/****************************************************************************
*
*  Create WPS objects for MO640
*
*  (C)      Marcel Mller 2002
*
****************************************************************************/

/* load funcs */
CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
CALL SysLoadFuncs

SAY "Create WPS objects for MO640 conversion utility."
SAY

/* get some information */
drv = guessMO()
SAY "Enter drive letter of MO device ["drv"]:"
drv = input(drv)

exe = SysSearchPath('PATH', "..\mo640.exe")
IF exe = '' THEN
  exe = STREAM("mo640.exe", 'c', 'query exists')
SAY "Enter path to mo640 executable ["exe"]:"
exe = input(exe)

SAY "Enter physical sector size [2048]:"
pss = input(2048)

/* create objects */
CALL createobj exe, "Convert MO disk"||"0d0a"x||"for use with OS/2", drv" /E"
CALL createobj exe, "Convert MO disk"||"0d0a"x||"for use with other OS", drv" /E /S"pss

EXIT


/* input with default
   ARG(1) - default
*/
input: PROCEDURE
  PULL tmp
  IF tmp = '' & ARG(1,'e') THEN tmp = ARG(1)
  RETURN tmp

/* guess drive letter of removable */
guessMO: PROCEDURE
  list = SysDriveMap("D", "LOCAL")
  drv = ''
  DO i = WORDS(list) TO 1 BY -1
    PARSE VALUE SysDriveInfo(WORD(list, i)) WITH drv free dummy
    IF drv \= '' & free \= 0 THEN LEAVE
    END
  RETURN drv

/* create WPS Program object
   ARG(1) - EXE name
   ARG(2) - object name
   ARG(3) - parameter
*/
createobj: PROCEDURE
  SAY 'creating 'ARG(2)' ...'
  /* create object */
  rc = SysCreateObject("WPProgram", ARG(2), "<WP_DESKTOP>", "EXENAME="ARG(1)";PARAMETERS="ARG(3)";", "U")
  IF rc = 0 THEN
    SAY "The programobject "ARG(2)" could not be created"
  RETURN
