/* exit */
/* Exit if no 2/REXX Support installed */

If RxFuncQuery('SysLoadFuncs') \= 0 Then
  If RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs') <>0 Then Do
    Say 'Unable to init REXX Utility function loader.'
    signal ENDE
end
call SysLoadFuncs

IniFilename="OS2-CIM.INI"
LogFile=directory()"\hmi.log"

arg cmdline  /* Copy command line arg to var cmdline */

if cmdline="QUOTES" then call quotes
if cmdline="" then do
  call help
  call patch
end
else do
  LogFile=cmdline
  call patch
end

signal ENDE

help: procedure expose IniFilename LogFile
  say
  say "XtraCIM v1-A '95 Joerg Klemenz [100141,2463] -- Freeware!"
  say
  say "This 2/Rexx program activates 3 secret features of OS/2 CIM"
  say "(Compu$erve Information Manager for OS/2)"
  say "1. Auto-Pilot (Offline Reader)"
  say "2. Download efficiency controll (watch bottom line of OS/2 CIM)"
  say "3. Debug-Mode (Traces all activity)"
  say
  say "For a detailed explanation of all points and how to save with ENS"
  say "see included IBM Works Textfile (XTRACIM.LWP)"
  say "Note that this program does not work with WinCIM! See PILOT.HLP for details."
  say
  say "This program is distributed in the hope that it will be useful,"
  say "but WITHOUT ANY WARRANTY!"
  say
  say "Comments: Please leave Message in OS/2 CIM Support Forum. IT'S FREE!"
  say "          EMail me for BUGS ONLY!"
  say "          NO OTHER EMAIL PLEASE! I AM NOT A CIS SUPPORT PERSON!"
  say
  say "Usage: Execute in the directory "IniFilename" resides"
  say "       (Usually C:\COMPUSERVE\OS2-CIM)"
  say 
  "@pause"
  say
  say "The Debug information is saved in the "IniFilename" directory too."
  say "The filename is HMI.LOG."
  say "If you want a different filename/location enter XtraCIM <path\filename>"
  say 'Usage example: "XtraCIM e:\compuserve\os2-cim\cim.logfile"'
  say
  say "The old "IniFilename" is saved as BACKUP.INI"
  say
  say "I would like to thank Brett Merkey for the information on the undocumented"
  say "features of WinCIM and OS/2 CIM. If you find more hidden features please"
  say "mail him too. The adress is 74344,1350."
  say "Please kindly overlook any spelling errors as I am not a native speaker."
  say
  say "Press Y to add extra features NOW!"
  yesno=SysGetKey("NoEcho")
  if \(yesno="Y" | yesno="y") then do
    say IniFilename" NOT updated!"
    signal ENDE
  end
return

/* --------------------------------------------- */
patch: procedure expose IniFilename LogFile
"@attrib " IniFilename "-rh >NUL" 
   /* Delete READ-ONLY and HIDDEN Atributes of INI File */

if stream(IniFilename,'c','query exists')="" then do 
  say
  say "ERROR: "IniFilename" does not exist in this directory!"
  say "Current directory is:" directory()
  "@pause"
  signal ENDE
end

say "Updating "IniFilename"..."

"@copy " IniFilename " BACKUP.INI >NUL"

erg=SysIni(IniFilename, "General Preferences", "Auto-Pilot", "ON"D2C(0))
erg=SysIni(IniFileName, "General Preferences", "Show-Efficiency", "ON"D2C(0))
erg=SysIni(IniFilename, "Debug", "Commport-Logging-File", LogFile D2C(0))

say
say "The new fetures are added to the SPECIAL menu."
say "Warning: Early Versions of OS/2 CIM just crash when Auto-Pilot is activated."
say "(booo!) However - thanks to OS/2 - no other Programms are affected."
say "Download the latest Version if this happens."
say "NOTE: The latest Version of XtraCIM is always available in the"
say "      OS/2 User Forum (GO OS2USER)"
say
say "p.s.: See if you can find the hidden feature of THIS program :)"
say
return

qoutes: procedure
say
say " -"
say " Quote of the day:"
z=random(1,12)
select
  when z=1  then say " He who laughs last uses OS/2."
  when z=2  then say " Windows. From the people that brought you EDLIN."
  when z=3  then say " Dave, put down those Windows disks. Dave... DAVE! -- HAL 9000."
  when z=4  then say " Bunny owners of the world, UNITE!"
  when z=5  then say " Hello, I am part number ۳"
  when z=6  then say " Bugs come in through open Windows."
  when z=7  then say " Four out of five people think the 5th person is an idiot."
  when z=8  then say " It's only a hobby... only a hobby.. only a -- J.Klemenz."
  when z=9  then say " MASOCHIST: Windows SDK programmer with a smile!"
  when z=10 then say " Speed Kills - Use Windows!"
  when z=11 then say " Very funny Scotty - now beam up my clothes!"
  when z=12 then say " Peace!"
end
say " -"
return

ENDE: