/* V_FOD.CMD - Voice/Fax Answer Script for FaxWorks/PMfax (REXX) */
/* 
                  Keller Group Inc.  May 22, 1997
   You may freely use or modify this script for use with licensed
        products which are developed by Keller Group Inc.
      For new scripts or to share your scripts with others,
                 see http://www.kellergroup.com
*/
/*******************************************************************
V_FOD.CMD - Fax-on-demand with extras (for Voice/fax Modems)

For use with any of the following Keller software configurations:
        Stand-alone (single-line or multiline)
        LAN (single-line or multiline server, Shared or Private Mode)

Supported features:
	Both one-call and two-call fax-on-demand (FOD)
	Interactive fax response (generate data and fax it on-the-fly)
	Both text file and fax image file support
	Voice-on-demand (VOD)
	Drag/drop creation of FOD/VOD document library
	Voice announcement 
	Voice messaging from caller
	Fax receiving from caller
	Can be customized to support call blocking, different
	   features on different lines of a multiline system or
	   different extensions in a DID system, internet faxing, etc.
	Full source code in REXX - modify as needed

DESCRIPTION:
-----------
This script plays a greeting message and asks the user to select 1
(fax-on-demand), 2 (voice message), 3 (send a fax), 4 (hear
announcement message), or 5 (replay the greeting message).

If the call is from a fax device and your fax hardware detects the
caller's fax (CNG) tones, the script automatically receives the fax.

If a caller does not enter any key (such as if calling from a phone
which doesn't support touch tones), the script automatically goes to
"please leave a voice message" mode.

This script does much more than just "fax-on-demand" since it also
supports "voice-on-demand" (playing user-selected voice message
files) and "text-on-demand" (converting user-selected text files to
fax and faxing them).  It also demonstrates how you can execute your
own programs to dynamically gather data (such as from your database)
and send it as a fax document.  So it's really a powerful "document
on demand" system that you can customize to meet your needs.

USAGE INSTRUCTIONS:
------------------
You must be using the program with supported voice/fax hardware to
use this script.  Consult the README.DOC file for tested voice/fax
hardware and recommended configuration settings for your hardware.
Before using this script, first test your system with our built-in
voice answering machine feature by enabling "Voice" and setting the
"Answer script" to * (an asterisk character) on the Voice page of the
Settings notebook.  If you are using supported voice/fax hardware
with the proper configuration settings, you can then use
"Fax/Receive/All calls" mode to answer calls, play the outgoing
message (OGM), and record a voice message (or receive a fax).

Then, to change to this advanced script, specify the full pathname of
this file in the "Answer script" field on the Voice page of the
settings notebook.

NOTE: The script expects to find the LIB_FOD.CMD file and its Wave
audio files in the fax program (EXE) directory.  The script also uses
Wave files from the c:\mmos2\sounds directory for special effects.

SCRIPT VARIABLES:
----------------
The following script variable is used by this script.  Script
variables are set on the Voice page of the Settings Notebook.

	FODDIR - pathname of directory which contains "on-demand"
	files, including the trailing \ character.  If not specified,
	the files are assumed to be in the fax data (fax.log)
	directory which allows you to select IDs from the program's
	log for testing the system.

VOICE PROMPT FILES:
------------------
The script expects to find the following Wave audio files in the fax
program (EXE) directory.  The script also uses Wave files from the
c:\mmos2\sounds directory for special effects.

To record or modify your own voice prompt files, use your OS/2
Multimedia microphone and record voice prompts using the "Fax/New
message" command then save them to a .WAV file with the "Fax/Save
file/Wave" command.  You can also use the OS/2 Digital Audio program
to record, save, edit and modify the Wave files (be sure to use
"Type" of Mono, 8-bit, 11.025 kHz).

	GREETFOD.WAV - Short: "Enter selection."
	Long: "Thank you for calling.  To order fax on demand
	documents press 1, to leave a voice message press 2, to send
	us a fax press 3, to hear our announcement press 4, or to
	repeat this message press 5." 

	ANNOUNC.WAV - Short: "No announcement."
	Long: "Our annoucement for this week is...."

	ENTR_MSG.WAV - Short: "Enter message, then press # key."
	Long: "Please leave your message at the beep.  Press # key to end."

	ENTR_DOC.WAV - Short: "Enter document number and # key, or
	press the # key if done."
	Long: "Please enter the document number followed by the # key,
	or press the # key if done.  To receive an index of available
	documents, enter document 1000."

	HOW_FAX.WAV - Short: "Enter 1 if calling from fax machine, 2
	if not."
	Long: "If you are calling from your fax machine and are ready
	to receive the fax press 1, to send the fax to a different
	number press 2." 

	ENTR_FAX.WAV - Short: "Enter fax number and # key."
	Long: "Please enter your fax number followed by the # key,
	including 1 and area code if this is not a local call." 

	NO_FILE.WAV - Short: "File not found."
	Long: "That document was not found, please try again."

	WAIT.WAV - Short: "Please wait."
	Long: "Please wait while we process your request."

	THANKYOU.WAV - Short: "Thank you."


FAX/VOICE/TEXT-ON-DEMAND DOCUMENTS:
----------------------------------
This script allows the user to enter document numbers to select one
or more documents.  Each document can be a fax, text or voice message
document.  When voice documents are selected, they are played to the
caller.  When fax and text documents are selected, they are gathered
as a list and then either faxed to the caller on this current call
("one-call" fax-on-demand - if caller called from a fax machine) or
faxed to a number which the caller enters ("two-call" fax-on-demand).

The program's standard document file name format is used for the
"on-demand" documents (FX000001.FAX for fax documents, FX000001.TXT
for text documents, FX000001.MSG for voice message documents).  Any
fax, voice or text item that can appear in the log can be used as an
"on-demand" document.  You can create the documents in many different
ways (faxing to the program, printing through the FxPrint printer
driver, using the program's editing tools, recording voice messages
using Fax/New message or the answering machine features, etc.).

If the FODDIR script variable is not set, then this script can use
the documents from the log and the "document number" is the "ID"
number in the program's log display ("Fax/Open log" command).

If the FODDIR script variable is set to a different directory, then
this script uses the documents which are found in that directory.
For actual use, you will usually want to do this so that you can
control the document numbers yourself.  For example, you may wish to
have an "index fax" as document 1000 (file FX001000.FAX) so that
callers can order a list of all available documents, then have
different categories of documents as document 1100, 1101, 1200,
1201, etc.  This is easy to do using your choice of techniques:

	1) DRAG/DROP - Create a folder, drag (to move) or Ctrl-drag
	(to copy) the documents from the log to your folder, and use
	direct editing (Alt-Click) to edit the file names to use your
	desired ID values.  Set the FODDIR script variable to the
	pathname of the folder's directory (including trailing \).

	2) COMMAND LINE - Create a directory, then copy the desired
	files from the log directory to your desired file names in
	your directory (or use the Fax/Save file command in the fax
	program).  Set the FODDIR script variable to the pathname of
	the directory's pathname (including trailing \ character).

The script uses ID 9999 as a special case to demonstrate how you can
dynamically call another program to generate text, convert the text
to a fax and send the fax to the caller.  For this demonstration, we
simply use the OS/2 DIR command, but you could change this to do
something more interesting (a database query, etc.).

TO MODIFY THE SCRIPT:
--------------------
The script is REXX and uses calls from the Keller REXX API which are
automatically loaded into the OS/2 REXX environment by the retail
versions of Keller's fax products (version 3.0 and later).  See the
Reference Manual for documentation of the FxRx and FxLn calls.  You
may modify the script as desired, and then use it as the "Answer
script" with Keller fax software products.

TO USE WITH MULTILINE VERSIONS:
------------------------------
This script can be used with multiline versions of Keller fax
software.  The LAN and Standalone Multiline product versions can
accept multiline upgrade options up to 96 lines per CPU, and the
Multiple Fax Server Facility supports multiple cooperating fax
servers for additional capacity.  Please contact the publisher of
your Keller fax software for pricing and details.

All lines are handled identically by this script, so calls can be
received on any of your "receive" lines.  If you prefer to have
different lines handled differently, you can modify the script to
test the LID variable.  For example, to have line 1 immediately jump
to the "please enter your message" prompt, you could add a line like
the following after the "call FxLnInit" line in the script: "if LID =
1 then signal voice" where "voice" is a label in the script.

When using a multiline version of Keller fax software, you can easily
adjust the send/receive settings on the Ports page in the Settings
notebook to determine how the lines are used.  For example, to direct
the two-call fax-on-demand outbound faxing to special outbound lines
so that your inbound lines will remain available for callers, you can
set the inbound lines to "Receive" and the outbound lines to "Send"
or "Send/Receive".  Alternatively, if you set your inbound lines to
"Send/Receive" and your outbound lines to "Send", the software will
first try to use the "Send" lines for outbound faxing but will use a
"Send/Receive" line if all "Send" lines are currently in use.

*******************************************************************/

call FxLnInit

if FODDIR = 'FODDIR'		/* if not set, get docs in log dir */
  then FODDIR = FxRxPath( 'LOG' )

VOXDIR = FxRxPath( 'EXE' )	/* get voice prompts from exe dir */
LIBDIR = FxRxPath( 'EXE' )	/* get REXX subroutines from exe dir */
FODPROCEDURE = LIBDIR||'lib_fod.cmd'  /* use this external procedure */

hello:
  LREC. = ""				/* be sure this is clean */
  call FxLnMsg 'Greeting'		/* show this in status window */

  call FxLnPlay VOXDIR||'GREETFOD.WAV'	/* play the greeting prompt */
    if result = 'NOTOK' then signal byebye
    if result = 'FAX' then signal fax
    if result = 'DATA' then signal data

  call FxLnMsg 'User selection'
  call FxLnDtmf 1, 15, 'digit'		   /* get user selection */
    if result = 'NOTOK' then signal byebye
    if result = 'FAX' then signal fax
    if result = 'DATA' then signal data
    if result <> 'DTMF' then signal voice  /* if no key entered... */
  select
    when digit = 1 then signal fod	   /* go to key selection  */
    when digit = 2 then signal voice
    when digit = 3 then signal fax
    when digit = 4 then signal announce
    when digit = 5 then signal hello
    otherwise signal voice
  end

voice:					/* take a message and hangup */
  call FxLnMsg "Record Msg"
  call FxLnPlay VOXDIR||'ENTR_MSG.WAV'
    if result = 'NOTOK' then signal byebye
    if result = 'FAX' then signal fax
    if result = 'DATA' then signal data
  call FxLnTone 1850
    if result = 'NOTOK' then signal byebye
  call FxLnDtmf    /* flush dtmf buffer */
  call FxLnRecord
    if result = 'NOTOK' then signal byebye
    if result = 'FAX' then signal fax
    if result = 'DATA' then signal data
    /* Caller can press key or hangup to end message */
  call FxLnTone 1850, 1850, 1850
  signal out

fax:					/* receive fax and hangup */
  call FxLnReceive
  signal out

data:					/* report data call, hangup*/
  call FxLnMsg 'Data call, oh well...'
  LREC.!Status = '*Data!'   /* log status of call */
  signal out

announce:				/* play annoucement, restart */
  call FxLnMsg "Announcement"
  call FxLnPlay VOXDIR||'ANNOUNC.WAV'
    if result = 'NOTOK' then signal byebye
  signal hello

fod:					/* "document-on-demand" ... */
  /* call the external FOD procedure in LIBDIR directory */
  FODPARAMS = 'FODDIR, VOXDIR'
  interpret 'call' "'"||FODPROCEDURE||"'" FODPARAMS
  /* jump to the label that matches the return value */
  signal value result

byebye:					/* called for error cases */
  LREC.!Status = ''			/* don't log anything */
  call FxLnPlay 'c:\mmos2\sounds\BOO.wav'
  signal out

out:					/* clean up and quit */
  call FxLnTerm
  exit
