#define INCL_DOS
#include "os2.h"
 
#include "stdio.h"
#include "stdlib.h"
#include "stddef.h"
#include "string.h"



#define	MAXROWS		  12			/* currently - 12						 */
#define	MAXCOLS		  12			/* currently - 12						 */
#define	TEXTSIZE		  33			/* size of text to return (may be changed) includes NULL */

#define PCB_SET_SESSION_PARMS    		 	9
#define PCB_QUERY_SESSIONS      		   	10
#define PCB_QUERY_BUTTON_INFORMATION 	 5011


typedef struct _Session {			/* Session Information Structure  */
	char	ShortName;					/* Short Name for Session         */
	char	LongName[8];				/* Long Name for Session          */
	char	Type;							/* Session Type                   */
	short Size;							/* Session Presentation Space Size*/
} Session, *pSession;


typedef struct _ButtonCount  {	/* Button Count Query Information Structure  */
	char	cShortName;					/* Short Name for Session		         		*/
	char	cTypeCode;					/* Type of Inquiry = 0x01 (counts)	   		*/ 
	short	sMaxRows;					/* Maximum rows to query for     				*/
	short sColumns[MAXROWS]; 		/* Returns number of columns per Row			*/
} ButtonCount, *pButtonCount;


typedef struct _ButtonText  {		/* Button Text Query Information Structure  	*/
	char	cShortName;					/* Short Name for Session		         		*/
	char	cTypeCode;					/* Type of Inquiry = 0x02 (text)		   		*/ 
	short	sWhatRow;					/* A specific row or 0 for current 				*/
	short	sWhatCol;					/* A specific column (button) 0 for all		*/
	short	sMaxCols;					/* Maximum cols to query for     				*/
	short	sMaxTextSize;				/* Maximum size of Text to eturn per entry	*/
	char	szText[MAXCOLS][TEXTSIZE];
} ButtonText, *pButtonText;



extern SHORT PASCAL16 hllapi(PUSHORT  _Seg16 pFunction,
       			              PVOID    _Seg16 pData,
               			     PUSHORT  _Seg16 pLength,
		                       PUSHORT  _Seg16 pReturnCode);



short HapiSetSessionParms(char *pszParmString, short Size);
short HapiQuerySessions(Session *pSessions, short Size);
short HapiQueryButtonInfo(PCHAR pData, SHORT sLength);


void SayHello();
void SayGoodbye();
void ShowError();
void ShowSessions();

short  WaitKey();


/************************************************************************
*                                                                        *
*        hllapi Variables                                                *
*                                                                        *
************************************************************************/
 
USHORT CLIMFunction;      /* API function                   */
USHORT CLIMLength;        /* API string length              */
USHORT CLIMReturnCode;    /* API return code                */

/************************************************************************
*                                                                        *
*        Global Variables                                                *
*                                                                        *
************************************************************************/

short asRowColumns[12];
short sNumRows;
short sMaxRows;
char	request;


Session		 	Sessions[14];    /* A Bunch of Sessions 		           */

ButtonCount		BtnCnt;			  /* defines button count structure 	  */
ButtonText		BtnTxt;			  /* defines button text structure 		  */

 
/************************************************************************\
*                                                                        *
*        Useful Variables                                                *
*                                                                        *
\************************************************************************/
 
short NumSessions;                      /* Count of Host Sessions         */
short OurSession;                       /* Index to Current Session       */
 
/************************************************************************\
*                                                                        *
*        Constants                                                       *
*                                                                        *
\************************************************************************/
 
char SessionParms[]=
     "AUTORESET CONLOG ESC=@ NOATTRB NOEAB SRCHFROM SRCHFRWD STREOT";



/************************************************************************\
*                                                                        *
*        Mainline Process                                                *
*                                                                        *
\************************************************************************/
 
int main(int argc, char* argv[])
{
short	i, x;
short sLength;
char  *pWk;
 
 
    SayHello();                       /* First we introduce ourselves   */

	 printf("Setting Session Parms\n");
 
    if (HapiSetSessionParms(&SessionParms[0], strlen(SessionParms))) {
        ShowError();
        exit(0);
    }
 
	 printf("Querying Sessions\n");

    HapiQuerySessions(&Sessions[0], sizeof(Sessions));
    if (CLIMReturnCode != 0 ) {           /* If none - bail out             */
        ShowError();
        exit(0);
    }
    if (CLIMLength == 0 ) {               /* If none - bail out             */
       printf("There are NO Started Sessions.\n");
		 exit(0);
	 }

    for (i = 0, NumSessions = 0; i < CLIMLength; i++) {
        if (Sessions[i].Type == 'H') {		/* Look for host sessions         */
            NumSessions++;            		/* Count it and shrink buffer     */
            if (i > 0)
					Sessions[NumSessions-1] = Sessions[i];
		  }
    }
    if ( NumSessions == 0 ) {          	/* If no Host Sessions - bail out */
        ShowError();
        exit(0);
    }

    ShowSessions();                   		/* Show the sessions to the user  */
 
    while(NumSessions > 1) {
        printf("Choose a session by pressing the appropriate number key.\n");
        i = WaitKey();
        if (!isdigit(i))
            continue;
        i &= 0x000f;
        if ((i < 1) || (i > NumSessions))
            continue;
        OurSession = i - 1;
        break;
    }
 
	 printf("You are using session '%c\n'",Sessions[OurSession].ShortName);

	 memset(&BtnCnt,0,sizeof(BtnCnt));

	 BtnCnt.cShortName = Sessions[OurSession].ShortName;
	 BtnCnt.cTypeCode  = 0x01;										// Query Counts
	 BtnCnt.sMaxRows	 = MAXROWS;

	 sLength 	 		 = (MAXROWS*2) + 4;	

	 printf("Will Query Session for Number of Rows and Columns\n\n");

	 HapiQueryButtonInfo((PCHAR)&BtnCnt,sLength) ;

    if (CLIMReturnCode != 0) {             /* If none - bail out             */
        ShowError();
        exit(0);
    }

	 for (i=0; i < BtnCnt.sMaxRows; i++)
		 printf("ROW: %d,  Number of Columns (buttons): %d\n",i+1,BtnCnt.sColumns[i]);
	 
	 printf("\nPress any key to continue\n\n");
    WaitKey();

	 printf("Will Query Column (button) TEXT\n\n");

	 for (x=0;x < BtnCnt.sMaxRows; x++)	{

		 memset(&BtnTxt,0,sizeof(BtnTxt));

		 BtnTxt.cShortName 	= Sessions[OurSession].ShortName;
		 BtnTxt.cTypeCode  	= 0x02;										// Query Text
		 BtnTxt.sWhatRow   	= x+1;										// specific Row
		 BtnTxt.sWhatCol   	= 0;											// All Columns
		 BtnTxt.sMaxCols	 	= MAXCOLS;
		 BtnTxt.sMaxTextSize = TEXTSIZE;

		 sLength 	 		   = (BtnTxt.sMaxCols*BtnTxt.sMaxTextSize) + 10;	

		 HapiQueryButtonInfo((PCHAR)&BtnTxt,sLength);

	    if (CLIMReturnCode != 0) {             /* If none - bail out             */
	        ShowError();
	        exit(0);
		 }
		 printf("ROW: %d ................................\n",x+1);
		 for (i=0; i < BtnTxt.sMaxCols; i++)	{
		 	 pWk = strchr(BtnTxt.szText[i],0x0a);
			 if (pWk)
			 	*pWk = ' ';
			 pWk = NULL;
			 printf("   COL: %d, Text: %s\n",i+1,BtnTxt.szText[i]);
		 } 
		 printf("\nPress any key for next row\n\n");
	    WaitKey();
	 }
    printf("TEST5011 ended successfully\n\n");
    exit(0);
}
/* =================================================================================
*		SayHello
================================================================================== */
void SayHello()
{
    printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
    printf("Talkthru EHLLAPI Query Button Sample Program\n");
    printf("(C) Software Corporation of America, Inc.   1994\n\n");
 
}
/* =================================================================================
*		SayGoodbye
================================================================================== */
void SayGoodbye()
{
    printf("Talkthru EHLLAPI Query Button Sample Program Ended\n");
}
/* =================================================================================
*		ShowError
================================================================================== */
void ShowError()
{
    printf("\n\nFunction %d, Return Code %d, Length %d.\n",
			                CLIMFunction,CLIMReturnCode,CLIMLength);
}
/* =================================================================================
*		ShowSessions
================================================================================== */
void ShowSessions()
{
short i;

    printf("Session   Short Name   Long Name \n");
    printf("-------   ----------   --------- \n");
    for (i=0;i<NumSessions;i++){
        printf("   %d           %c        %.8s\n",
               (i + 1),
               Sessions[i].ShortName,
               Sessions[i].LongName);
        }
    printf("\n\n");
    OurSession = 0;
}
 
/* =================================================================================
*		WaitKey
================================================================================== */
short WaitKey()
{
 return(getchar());
}

/************************************************************************
*                                                                        *
*  HapiSetSessionParms - Function to issue HLLAPI call #9                *
*                                                                        *
************************************************************************/
short HapiSetSessionParms(char *pszParmString, short Size)
{
    CLIMFunction   = PCB_SET_SESSION_PARMS;      /* Set Function Code   */
    CLIMLength     = Size;                       /* Set Length          */
    CLIMReturnCode = -1;                         /* Initialize Ret. Code*/
    hllapi(&CLIMFunction, pszParmString, &CLIMLength, &CLIMReturnCode);
    return(CLIMReturnCode);                      /* Return to Caller    */
}
/************************************************************************
*                                                                        *
*  HapiQuerySessions - Function to issue HLLAPI call #10                 *
*                                                                        *
************************************************************************/
short HapiQuerySessions(Session *pSessions, short Size)
{
    CLIMFunction   = PCB_QUERY_SESSIONS;         /* Set Function Code   */
    CLIMLength     = Size;                       /* Set Length          */
    CLIMReturnCode = -1;                         /* Initialize Ret. Code*/
    hllapi(&CLIMFunction, pSessions, &CLIMLength, &CLIMReturnCode);
    return(CLIMReturnCode);                      /* Return to Caller    */
}
/************************************************************************
*                                                                        *
*  HapiQueryButtonInfo - TalkThru Function to issue HLLAPI call #5011    *
*                                                                        *
************************************************************************/
short HapiQueryButtonInfo(PCHAR pData, short sLength)
{
    CLIMFunction   = PCB_QUERY_BUTTON_INFORMATION;    /* Set Function Code   */
    CLIMLength     = sLength;                     		/* Set Length          */
    CLIMReturnCode = -1;                         		/* Initialize Ret. Code*/
    hllapi(&CLIMFunction, pData, &CLIMLength, &CLIMReturnCode);
    return(CLIMReturnCode);                      		/* Return to Caller    */
}
 
