/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import com.borland.dx.dataset.Variant;
import com.borland.jb.util.SearchPath;
import com.borland.jbcl.util.ImageCache;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.GrayFilter;

public class ImageLoader
implements Serializable {
    static ImageCache urlImageCache = new ImageCache(32);
    static ImageCache blobImageCache = new ImageCache(16);
    static ImageCache disabledImageCache = new ImageCache(48);

    public static void setUrlImageCacheLimit(int n) {
        urlImageCache.setLimit(n);
    }

    public static int getUrlImageCacheLimit() {
        return urlImageCache.getLimit();
    }

    public static void setBlobImageCacheLimit(int n) {
        blobImageCache.setLimit(n);
    }

    public static int getBlobImageCacheLimit() {
        return blobImageCache.getLimit();
    }

    public static void setDisabledImageCacheLimit(int n) {
        disabledImageCache.setLimit(n);
    }

    public static int getDisabledImageCacheLimit() {
        return disabledImageCache.getLimit();
    }

    public static Image load(String string, Component component) {
        try {
            Image image = component != null ? component.getToolkit().getImage(string) : Toolkit.getDefaultToolkit().getImage(string);
            return image;
        }
        catch (SecurityException securityException) {
            Image image = null;
            return image;
        }
    }

    public static Image load(String string, Component component, boolean bl) {
        Image image = ImageLoader.load(string, component);
        if (image != null && bl) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    public static Image load(URL uRL, Component component) {
        Image image = urlImageCache.get(uRL.toString());
        if (image != null) {
            return image;
        }
        try {
            image = component != null ? component.getToolkit().getImage(uRL) : Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (image != null) {
            urlImageCache.put(uRL.toString(), image, component);
        }
        return image;
    }

    public static Image load(URL uRL, Component component, boolean bl) {
        Image image = ImageLoader.load(uRL, component);
        if (image != null && bl) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    public static Image loadFromPath(SearchPath searchPath, String string, Component component) {
        try {
            Toolkit toolkit = component == null ? Toolkit.getDefaultToolkit() : component.getToolkit();
            Image image = toolkit.getImage(searchPath.getPath(string));
            return image;
        }
        catch (SecurityException securityException) {
            Image image = null;
            return image;
        }
    }

    public static Image loadFromPath(SearchPath searchPath, String string, Component component, boolean bl) {
        Image image = ImageLoader.loadFromPath(searchPath, string, component);
        if (image != null && bl) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    public static Image loadFromResource(String string, Component component) {
        return ImageLoader.loadFromResource(string, component, component.getClass());
    }

    public static Image loadFromResource(String string, Class clazz) {
        return ImageLoader.loadFromResource(string, null, clazz);
    }

    public static Image loadFromResource(String string, Component component, Class clazz) {
        try {
            URL uRL = clazz.getResource(string);
            if (uRL == null) {
                Image image = null;
                return image;
            }
            Image image = urlImageCache.get(uRL.toString());
            if (image != null) {
                Image image2 = image;
                return image2;
            }
            Object object = uRL.getContent();
            if (object instanceof Image) {
                image = (Image)object;
            } else if (object instanceof ImageProducer) {
                image = component != null ? component.createImage((ImageProducer)object) : Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            } else {
                Image image3 = null;
                return image3;
            }
            if (component != null) {
                component.prepareImage(image, component);
            } else {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, component);
            }
            urlImageCache.put(uRL.toString(), image, component);
            Image image4 = image;
            return image4;
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(new StringBuffer("loadFromResource IOException name=").append(string).append(" component=").append(component).append(" cl=").append(clazz)));
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(new StringBuffer("loadFromResource Exception").append(exception).append(" name=").append(string).append(" component=").append(component).append(" cl=").append(clazz)));
        }
        return null;
    }

    public static Image loadFromBlob(Object object, Component component) throws IOException {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof Variant) {
            object2 = (Variant)object;
            if (((Variant)object2).isNull()) {
                return null;
            }
            object = ((Variant)object2).getInputStream();
        }
        if ((object2 = blobImageCache.get(object)) != null) {
            return object2;
        }
        if (object instanceof Image) {
            object2 = (Image)object;
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            inputStream.reset();
            byte[] byArray = ImageLoader.byteArrayFromStream(inputStream);
            Toolkit toolkit = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
            object2 = toolkit.createImage(byArray);
        }
        if (object2 != null) {
            blobImageCache.put(object, (Image)object2, component);
        }
        return object2;
    }

    public static Image loadFromBlob(Object object, Component component, boolean bl) throws IOException {
        Image image = ImageLoader.loadFromBlob(object, component);
        if (image != null && bl) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    private static byte[] byteArrayFromStream(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.available();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            return null;
        }
        return byArray;
    }

    public static boolean waitForImage(Component component, Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !mediaTracker.isErrorID(1);
    }

    public static Image getDisabledImage(Component component, Image image) {
        Image image2 = disabledImageCache.get(image);
        if (image2 != null) {
            return image2;
        }
        image2 = GrayFilter.createDisabledImage(image);
        disabledImageCache.put(image, image2, component);
        return image2;
    }
}

