/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.io;

import com.borland.jb.io.SimpleCharOutputStream;
import com.borland.jb.util.Hex;
import java.io.IOException;
import java.io.OutputStream;

public class AsciiOutputStream
extends SimpleCharOutputStream {
    private OutputStream out;
    private int backCount;
    private int bufferLength;
    private int count;
    private byte[] buffer;

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.out.flush();
            this.count = -1;
        }
    }

    private void writeByte(int n) throws IOException {
        if (++this.count < this.bufferLength) {
            this.buffer[this.count] = (byte)n;
        } else {
            this.flush();
            this.buffer[++this.count] = (byte)n;
        }
    }

    public void write(int n) throws IOException {
        if ((n & 0xFF00) != 0) {
            this.writeByte(92);
            if (this.backCount > 0) {
                this.writeByte(92);
                this.backCount = 0;
            }
            this.writeByte(117);
            this.writeByte(Hex.chars[n >> 12 & 0xF]);
            this.writeByte(Hex.chars[n >> 8 & 0xF]);
            this.writeByte(Hex.chars[n >> 4 & 0xF]);
            this.writeByte(Hex.chars[n & 0xF]);
        } else if (n == 92) {
            this.writeByte(n);
            if (++this.backCount > 1) {
                this.writeByte(n);
                this.writeByte(n);
                this.backCount = 0;
            }
        } else if (this.backCount > 0) {
            if (n == 117) {
                this.writeByte(92);
            }
            this.writeByte(n);
            this.backCount = 0;
        } else if (++this.count < this.bufferLength) {
            this.buffer[this.count] = (byte)n;
        } else {
            this.flush();
            this.writeByte(n);
        }
    }

    public AsciiOutputStream(OutputStream outputStream, int n) {
        this.out = outputStream;
        this.count = -1;
        this.bufferLength = n;
        this.buffer = new byte[n];
    }

    public AsciiOutputStream(OutputStream outputStream) {
        this(outputStream, 2048);
    }
}

