/* * *
 *
 *    Simple Tagline Adder      v1.32\S - 1996-01-23
      Standalone version (ask me for the FleetStreet version)

      (c) Copyright 1995, Peter Karlsson, 2:204/137.5 @ Fidonet       *
                                                                      *
                                                                  * * */

/* Versions: 1.0 (1995-06-15)
             1.1 (1995-06-28) Added "Q" option, uses #0 for brag
             1.2 (1995-07-17) Removed bug when searching for tagline
             1.3 (1995-10-29) Now the bug when searching should be gone :)
             1.31(1995-11-02) Well, it should now.......
             1.32(1996-01-23) I hate the searching bug                     */

version = '1.32'

/*TRACE ?I*/

ARG Textfile Taglinefile Indexfile

CALL RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
CALL RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'

IF Indexfile = '' THEN
DO
  SAY 'TAG [drive:][path]textfile [drive:][path]tagfile [drive:][path]index'
  SAY
  SAY '  [drive:][path]textfile   The textfile to which the tagline should be added'
  SAY '  [drive:][path]tagfile    The file containing the taglines'
  SAY '  [drive:][path]index      The file containing the tagline index'
  EXIT 1
END

IF STREAM(Taglinefile, 'C', 'QUERY EXISTS') = '' THEN
DO
  SAY 'The specified tagline file ' || Taglinefile || ' could not be found.'
  SAY
  SAY 'Please check the setup'
  EXIT 1
END

TagfSize = STREAM(Taglinefile, 'C', 'QUERY SIZE')

IF STREAM(Indexfile, 'C', 'QUERY EXISTS') = '' THEN
DO
  SAY 'The specified tagline index file ' || Indexfile || ' could not be found.'
  SupposedSize = -1
END
ELSE
DO
  IF STREAM(Indexfile, 'C', 'OPEN READ') \= 'READY:' THEN
  DO
    SAY 'ERROR: Could not open index file ' || Indexfile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  SupposedSize = LINEIN(Indexfile)        /* Read supposed size of tagfile */
END

If SupposedSize \= TagfSize THEN        /* Supposed size do not match actual */
DO
  SAY 'Tagline index is not accurate, building new index'
  CALL STREAM Indexfile, 'C', 'CLOSE'
  IF SupposedSize \= -1 THEN
    IF SysFileDelete(Indexfile) \= 0 THEN
    DO
      SAY 'ERROR: Could not delete the index file ' || Indexfile || '.'
      SAY
      SAY 'File may be locked by another process.'
      EXIT 2
    END
  IF STREAM(Taglinefile, 'C', 'OPEN READ') \= 'READY:' THEN
  DO
    SAY 'ERROR: Could not open tagline file ' || Taglinefile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  Lines = 1
  SAY 'Building index, please wait. This may take a while.'
  DO WHILE LINES(Taglinefile)
    Index.Lines = TagfSize - CHARS(Taglinefile) /* Index to line */
    Data = LINEIN(Taglinefile)
    IF LEFT(Data, 1) \= ';' & STRIP(Data) \= '' THEN Lines = Lines + 1
  END
  CALL STREAM Taglinefile, 'C', 'CLOSE'
  IF STREAM(Indexfile, 'C', 'OPEN WRITE') \= 'READY:' THEN
  DO
    SAY 'ERROR: Could not create new index file ' || Indexfile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  CALL LINEOUT Indexfile, TagfSize      /* Save current filesize */
  CALL LINEOUT Indexfile, Lines         /* Save number of lines */
  DO print = 1 TO Lines-1
    CALL LINEOUT Indexfile, Index.print  /* Save indexes */
  END
  CALL STREAM Indexfile, 'C', 'CLOSE'
END
ELSE
DO                                      /* Read the correct index */
  SAY 'Reading index, please wait. This may take a while.'
  Lines = LINEIN(Indexfile)
  DO read = 1 TO Lines-1
    Index.read = LINEIN(Indexfile)
  END read
  CALL STREAM Indexfile, 'C', 'CLOSE'
END
Index.Lines = TagfSize
SAY
SAY 'Tagline file has ' || Lines-1 || ' entries.'
IF STREAM(Taglinefile, 'C', 'OPEN READ') \= 'READY:' THEN
DO
  SAY 'ERROR: Could not open tagline file ' || Taglinefile || '.'
  SAY
  SAY 'File may be locked by another process.'
  EXIT 2
END
satisfied = 'N'
number = RANDOM(Lines-1)                /* Starting random tagline */
CALL SysCls                             /* Clear screen */
SAY 'Tagline selector. Press [Y] when you are satisfied, [N] if not. [-] will get'
SAY 'the previous tagline, [+] the next. [#] Lets you enter a number and [O] seeks'
SAY 'for a word after the current tagline. [Q] to not add a tagline.'
SAY
SAY '==============================================================================='
DO UNTIL (satisfied = 'Y' | satisfied = 'Q')
  IF number = 0 THEN
  DO
    Tagline = 'Brought to you by TAG.CMD v' || version || ' (c) 1995 Peter Karlsson'
    CALL STREAM Taglinefile, 'C', 'SEEK =' || (Index.1)+1       /* Position */
  END
  ELSE
  DO
    CALL STREAM Taglinefile, 'C', 'SEEK =' || (Index.number)+1  /* Position */
    Tagline = LINEIN(Taglinefile)       /* Read the tagline */
  END
  SAY number || ': ' || Tagline
  satisfied = ''
  DO UNTIL satisfied = 'Y' | satisfied = 'N' | satisfied = '-' | satisfied = '+' | satisfied = 'O' | satisfied = '#' | satisfied = 'Q'
    PULL satisfied
  END
  IF satisfied = 'N' THEN number = RANDOM(Lines-1)      /* New random select */
  IF satisfied = '+' THEN number = number + 1           /* Previous tagline */
  IF satisfied = '-' THEN number = number - 1           /* Next tagline */
  IF satisfied = '#' THEN
  DO
    SAY '[#] Jump to which tagline? ( 0-' || Lines-1 ')'
    PULL number                         /* Select tagline by number */
  END
  IF satisfied = 'O' THEN
  DO
    SAY '[O] Search for what word?'
    PULL word
    nextnumb = number+1
    CALL STREAM Taglinefile, 'C', 'SEEK =' || (Index.nextnumb)+1 /* Position */
    DO search = number+1 TO Lines-1     /* Search subsequent lines for tagline */
      Tagline = TRANSLATE(LINEIN(Taglinefile))
      IF POS(word, Tagline) \= 0 THEN LEAVE
    END search
    IF search = Lines THEN              /* The loop did run until end */
      SAY 'Could not find the word "' || word || '"!'
    ELSE
      number = search                   /* Select the found tagline */
  END
END
CALL STREAM Taglinefile, 'C', 'CLOSE'   /* Close it, we have read the tagline */
If satisfied = 'Q' THEN EXIT
DROP Index.                             /* We do not need the indexes anymore */
IF STREAM(Textfile, 'C', 'QUERY EXISTS') = '' THEN
DO                                      /* Create new text file */
  IF STREAM(Textfile, 'C', 'OPEN WRITE') \= 'READY:' THEN
  DO
    SAY 'ERROR: Could not create new text file ' || Textfile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  CALL LINEOUT Textfile, '... ' || Tagline
  CALL STREAM Textfile, 'C', 'CLOSE'
END
ELSE
DO
  IF STREAM(Textfile, 'C', 'OPEN READ') \= 'READY:' THEN
  DO
    SAY 'ERROR: Could not open text file ' || Textfile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  Lines = 0
  DO WHILE LINES(Textfile)
    Data.Lines = LINEIN(Textfile)
    Lines = Lines + 1
  END
  CALL STREAM Textfile, 'C', 'CLOSE'
  IF SysFileDelete(Textfile) \= 0 THEN
  DO
    SAY 'ERROR: Could not delete the old text file ' || Textfile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  IF STREAM(Textfile, 'C', 'OPEN WRITE') \= 'READY:' THEN
  DO
    SAY 'ERROR: Could not create new text file ' || Textfile || '.'
    SAY
    SAY 'File may be locked by another process.'
    EXIT 2
  END
  Wrotetagline = 0
  DO write = 0 TO Lines-1
    IF LEFT(Data.write, 4) = '--- ' THEN        /* Add before tearline */
    DO
      CALL LINEOUT Textfile, '... ' || Tagline
      Wrotetagline = 1
    END
    CALL LINEOUT Textfile, Data.write
  END write
  IF \ Wrotetagline THEN                /* No tearline, add last */
    CALL LINEOUT Textfile, '... ' || Tagline
  CALL STREAM Textfile, 'C', 'CLOSE'
END
