/*------------------------------------------------------------------------
  Unload all matching, unchanged files - skipping the current file.

  01 Jan 2013  SEM - now accepts a command line, supports simple
    wildcards (* and ?).
    To unload all .s files:                 unload *.s
    To unload all files in a "save" dir:    unload *\save\*
    To unload all files with "foo" in the name: unload *foo*

 ------------------------------------------------------------------------*/
proc main()
    string mask[_MAX_PATH_] = Lower(Trim(Query(MacroCmdLine)))
    string this_fn[_MAX_PATH_]
    integer i, id, changed

    if mask == ""
        mask = "*"
    endif
    PushPosition()
    NextFile(_DONT_LOAD_)
    for i = 1 to NumFiles() - 1
        id = GetBufferId()
        this_fn = Lower(CurrFilename())
        changed = FileChanged()
        NextFile(_DONTLOAD_)
        if not changed and MatchFilename(this_fn, mask)
            AbandonFile(id)
        endif
    endfor
    PopPosition()
end
