/**************************************************************************
  March 10, 2003 SEM: When maximizing, in the Console
        version, with certain video cards, sometimes the
        Window is positioned off-screen.  Fix that by
        positioning the Window at 0,0 via the Win32
        SetWindowPos API.

        Additionally, In the Console version, with certain
        video cards, and especially with the statusline
        drawn at the bottom of the window, when maximizing,
        sometimes the statusline does not get drawn on the
        correct row.  Fix that by causing TSE to redraw the
        screen.

        Thanks to Graham Down for reporting these problems.

 **************************************************************************/

dll "<user32.dll>"
    integer proc GetWindowRect(integer hwnd, integer rect)
    integer proc SetWindowPos(integer hwnd, integer hwndafter,
                        integer x, integer y, integer cx, integer cy,
                        integer flags)
    integer proc SendMessage(integer hwnd, integer msg, integer wparam, integer lparam) : "SendMessageA"
    integer proc IsMaximized(integer hwnd) : "IsZoomed"
    integer proc IsMinimized(integer hwnd) : "IsIconic"
end

#define SWP_NOSIZE      0x0001
#define WM_SYSCOMMAND   0x0112
#define SC_MINIMIZE     0xF020
#define SC_MAXIMIZE     0xF030
#define SC_RESTORE      0xF120

integer prev_rows, prev_cols
integer r_left, r_top, r_right, r_bottom
proc mToggleConsoleMaximizedWindow()
    integer max_rows, max_cols
    if r_right or r_bottom endif
    if not isGUI()
        GetMaxRowsCols(max_rows, max_cols)
        if Query(ScreenRows) == max_rows and Query(ScreenCols) == max_cols
            SetVideoRowsCols(prev_rows, prev_cols)
            SetWindowPos(GetWinHandle(), 0, r_left, r_top, 0, 0, SWP_NOSIZE)
        else
            GetWindowRect(GetWinHandle(), Addr(r_left))
            prev_rows = Query(ScreenRows)
            prev_cols = Query(ScreenCols)
            SetWindowPos(GetWinHandle(), 0, 0, 0, 0, 0, SWP_NOSIZE)
            SetVideoRowsCols(max_rows, max_cols)
            UpdateDisplay(_ALL_WINDOWS_REFRESH_)
            VirtualToRealScreen()
        endif
    endif
end

proc mToggleGUIMaximizedWindow()
    if isGUI()
        if IsMaximized(GetWinHandle()) or IsMinimized(GetWinHandle())
            SendMessage(GetWinHandle(), WM_SYSCOMMAND, SC_RESTORE, 0)
        else
            SendMessage(GetWinHandle(), WM_SYSCOMMAND, SC_MAXIMIZE, 0)
        endif
    endif
end

proc main()
    if isGUI()
        mToggleGUIMaximizedWindow()
    else
        mToggleConsoleMaximizedWindow()
    endif
end

