/*************************************************************************
  TabUtil     Converts tab characters to spaces, or spaces to tab characters

  Author:     SemWare

  Date:       Dec  5, 1992 - Initial version (Richard Blackburn)
              Apr 23, 1993 - Clean up
              Aug 24, 1994 - re-write for TSE 2.0 release
              Dec 12, 1997 - SEM: support column blocks in the entabbing
                                process.
              Dec 15, 1998 - SEM: EntabStr now built-in.


  Overview:

  This macro converts tab characters in the current file to spaces, or
  converts spaces to tab characters.  When invoked, a menu is
  presented allowing you to select Entab or Detab.

  To limit the scope of the conversion to a block, execute the macro
  from within a marked block.  NOTE that it will convert the entire
  lines that the blocks span.

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  When entabbing, if a tab character or a single or double quote is
  encountered, the rest of that line is not entabbed.

  Copyright 1992-1997 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/
//
//  Start of the EnTab part of the macro
//

/************************************************************************
  If the dll is compiled with Borland (4.5, 5), use "entab"
  If the dll is compiled with Microsoft C (VC 4), use "_entab@20"
  If the dll is compiled with Watcom C (10, 10.5), use "_entab"

  Currently compiled with Watcom c 10.5.
 ************************************************************************/

integer proc SetUp(string msg)
    integer target_line

    Message("-- ", msg, " tabs --")
    PushBlock()
    PushPosition()
    if isCursorInBlock()
        GotoBlockBegin()
        target_line = Query(BlockEndLine)
    else
        BegFile()
        target_line = NumLines()
    endif
    return (target_line)
end

proc CleanUp()
    PopPosition()
    PopBlock()
    Message("Finished")
end

public proc EnTab()
    integer target_line

    target_line = SetUp("Inserting")
    repeat
        EntabCurrLine(TRUE)
    until NOT Down() or CurrLine() > target_line
    CleanUp()
end

public proc DeTab()
    integer save_expand = Set(ExpandTabs, ON),
        target_line = SetUp("Removing")

    repeat
        ExpandTabsToSpaces()
    until NOT Down() or CurrLine() > target_line
    CleanUp()
    Set(ExpandTabs, save_expand)
end

/***********************************************************************
  Menu to call the two tab utilities.
***********************************************************************/
menu TabUtilMenu()
    title = 'Tab Utilities'

    '&DeTab',DeTab(),CloseAllBefore, 'Convert tabs to spaces'
    '&EnTab',EnTab(),CloseAllBefore, 'Convert spaces to tabs'
end

/***********************************************************************
  This is executed if you select the main public listing for this
  macro.  It simply calls the TabUtilMenu().
***********************************************************************/
proc Main()
    string cmdline[255] = Query(MacroCmdLine)

    case cmdline
        when '-detab'   DeTab()
        when '-entab'   EnTab()
        otherwise
            TabUtilMenu()
    endcase
end
