/*************************************************************************
  Synchscr    Implements synchronized scrolling windows

  Author:     SemWare

  Date:       August 1995

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

/**************************************************************************
  Synchronized Scrolling Routines
 **************************************************************************/
integer sync_scroll, sync_lastline, sync_lastrow, sync_lastcol,
    sync_lastxoffset, sync_lastwinid

proc SaveSyncState()
    sync_lastline = CurrLine()
    sync_lastrow = CurrRow()
    sync_lastcol = CurrCol()
    sync_lastxoffset = CurrXoffset()
    sync_lastwinid = WindowId()
end

/**************************************************************************
  CheckSyncScroll

  Checks the current window, and scrolls all other windows if current
  window has scrolled.
 **************************************************************************/
proc CheckSyncScroll()
    integer line_delta, col_delta, row_delta, xoffset_delta, y, x

    if NumWindows() > 1
        if sync_scroll and not isZoomed() and WindowId() == sync_lastwinid

            line_delta = CurrLine() - sync_lastline
            row_delta = CurrRow() - sync_lastrow
            col_delta = CurrCol() - sync_lastcol
            xoffset_delta = CurrXoffset() - sync_lastxoffset

            while NextWindow() and WindowId() <> sync_lastwinid
                if Query(Key) in <Ctrl PgDn>, <Ctrl PgUp>, <Ctrl Home>, <Ctrl End>
                    PressKey(Query(Key))
                else
                    y = CurrRow()
                    x = CurrXoffset()
                    GotoLine(CurrLine() + line_delta)
                    ScrollToRow(y + row_delta)
                    GotoColumn(CurrCol() + col_delta)
                    GotoXoffset(x + xoffset_delta)
                endif
            endwhile

            GotoWindow(sync_lastwinid)   /* make sure were in our orig window */
        endif
    endif
    SaveSyncState()
end

proc main()
    sync_scroll = not sync_scroll
    if sync_scroll
        Hook(_AFTER_COMMAND_, CheckSyncScroll)
        SaveSyncState()
        Message("Sync Scrolling turned on")
    else
        Unhook(CheckSyncScroll)
        Message("Sync Scrolling turned off")
    endif
end

