/*------------------------------------------------------------------------
Editor sanity check/unit tests.
v 23 Feb 2024 10:14 am
v 24 Feb 2024  6:45 am
v 24 Feb 2024  9:47 am
v 24 Feb 2024 12:48 pm
Numerous fixes.

Variables:
[x] CaptureId

Commands:
[x] AbandonEditor
[x] AbandonFile
[x] AbandonFile+
[ ] About
[ ] AddAutoLoadMacro
[ ] AddFFInfoToBuffer
[ ] AddFileToRing
[ ] AddHistoryStr
[x] AddLine
[x] AddLine+
[ ] Addr
[ ] AddrPageSize
[x] AddTrailingSlash
[ ] AdjPtr
[ ] Alarm
[ ] Ask
[ ] AskFilename
[ ] AskNumeric
[ ] AskPopWin
[ ] BackSpace
[x] BegFile
[x] BegLine
[ ] BegLineTog
[ ] BegWindow
[ ] BegWord
[ ] BinaryMode
[ ] BinaryMode+
[ ] BreakHookChain
[ ] BrowseDir
[ ] BrowseMode
[ ] BrowseMode+
[ ] BufferSizeK
[ ] BufferType
[ ] BufferType+
[ ] BufferVideo
[ ] BuildPickBuffer
[ ] BuildPickBufferEx
[ ] BuildSynhiExtList
[x] Capture
[ ] CfgRange
[ ] ChainCmd
[ ] ChangeCurrFilename
[ ] ChangeCurrFilename+
[ ] ChangedFilesExist
[ ] ChDir
[ ] CheckDefaultExt
[ ] ChooseFont
[ ] ChrSet
[ ] ClearBit
[ ] ClearBufferDaTmAttr
[ ] ClearEditWindows
[ ] ClearPhysicalScreen
[ ] ClearUndoRedoList
[ ] ClosePrint
[ ] CloseWindow
[ ] ClrEol
[ ] ClrScr
[ ] CmpiStr
[x] CompareLines
[ ] ComputeX1
[ ] ComputeY1
[ ] Copy
[ ] Copy+
[ ] CopyAppend
[ ] CopyAppendToWinClip
[ ] CopyAppendToWinClip+
[ ] CopyBlock
[ ] CopyBlock+
[ ] CopyFile
[x] CopyToClipboard,
[x] CopyToWinClip
[x] CopyToWinClip+
[x] CreateBuffer
[x] CreateTempBuffer
[ ] CReturn
[ ] CurrChar
[ ] CurrChar+
[ ] CurrCol
[ ] CurrDir
[ ] CurrExt
[ ] CurrFilename
[ ] CurrLine
[ ] CurrLineLen
[ ] CurrLineMultiLineDelimiterType
[-] CurrLinePtr - no longer supported
[ ] CurrMacroFilename
[ ] CurrPos
[ ] CurrRow
[x] CurrX
[ ] CurrXoffset
[ ] Cut
[ ] Cut+
[ ] CutAppend
[ ] CutAppendToWinClip
[ ] CutToWinClip
[-] DecodeDTA - no longer supported
[-] DecodePickBuffer - no longer supported
[ ] DelAllBookMarks
[ ] DelAnyChar
[ ] DelAnyCharOrBlock
[ ] DelAutoLoadMacro
[ ] Delay
[ ] DelBlock
[ ] DelBookMark
[ ] DelBufferVar
[ ] DelChar
[ ] DelCharOrBlock
[ ] DelGlobalVar
[ ] DelHistory
[ ] DelHistoryStr
[ ] DelLeftWord
[ ] DelLine
[ ] DelRightWord
[ ] DelStr
[ ] DelToEol
[ ] DelWindow
[ ] Disable
[ ] DisablePromptKeys
[ ] DisplayMode
[ ] DisplayMode+
[ ] DistanceToTab
[ ] Dos
[ ] Dos+
[x] DosIOResult
[ ] Down
[ ] DrawBox
[ ] DupLine
[ ] EditAutoLoadList
[ ] EditBuffer
[ ] EditDistance
[ ] EditFile
[x] EditFile+
[ ] EditorType
[ ] EditPopWin
[x] EditThisFile
[x] EditThisFile+
[ ] EffectiveWidth
[x] EmptyBuffer
[x] EmptyBuffer+
[x] EmptyWinClip
[ ] Enable
[ ] EnablePromptKeys
[ ] EndFile
[ ] EndLine
[ ] EndLineTog
[ ] EndProcess
[ ] EndWindow
[ ] EndWord
[ ] EntabCurrLine
[ ] EquiStr
[x] EraseDiskFile
[ ] Escape
[ ] ExecCmd
[ ] ExecHook
[ ] ExecLoadedMacro
[ ] ExecMacro
[x] ExecMacro+
[ ] ExecScrapMacro
[ ] ExistBufferVar
[ ] ExistGlobalVar
[ ] Exit
[x] ExpandPath
[ ] ExpandTabsToSpaces
[ ] ExpandTilde
[x] fClose
[x] fCreate
[ ] fDup
[ ] fDup2
[ ] FFAttribute
[ ] FFDate
[ ] FFDateStr
[ ] FFHighDateTime
[ ] FFLowDateTime
[x] FFName
[ ] FFSize
[ ] FFSizeHigh
[ ] FFSizeStr
[ ] FFTime
[ ] FFTimeStr
[ ] FileChanged
[ ] FileChanged+
[x] FileExists
[ ] FillBlock
[ ] FillBlock+
[ ] Find
[ ] Find+
[x] FindFileClose
[ ] FindFirst
[x] FindFirstFile
[ ] FindHistoryStr
[ ] FindInfoPtr
[ ] FindNext
[ ] FindNextFile
[x] FindThisFile
[ ] FinishEditWindows
[ ] FixAndFindPath
[ ] Flip
[ ] Flip+
[ ] FlushProfile
[x] fOpen
[ ] Format
[ ] fRead
[ ] fRead2
[ ] fReadFile
[ ] FreeWorkBuffer
[ ] fSeek
[ ] FullWindow
[x] fWrite
[ ] fWriteFile
[ ] GenerateIndex2
[ ] GetBit
[ ] GetBookMarkInfo
[ ] GetBufferDaTmAttr
[x] GetBufferId
[x] GetBufferId+
[ ] GetBufferInt
[ ] GetBufferStr
[ ] GetCharWidthHeight
[ ] GetClipBoardBlockType
[ ] GetClockTicks
[ ] GetColorTableValue
[ ] GetConnectionType
[ ] GetData
[ ] GetDate
[ ] GetDateStr
[ ] GetDir
[ ] GetDirSeparator
[ ] GetDrive
[x] GetEnvStr
[ ] GetFilename
[ ] GetFileSize
[ ] GetFileToken
[ ] GetFont
[ ] GetForcedCmd
[ ] GetFoundText
[ ] GetFreeHistory
[ ] GetGlobalInt
[ ] GetGlobalStr
[ ] GetHistoryStr
[x] GetHomePath
[ ] GetHookState
[ ] GetKey
[ ] GetKeyFlags
[ ] GetLineNumberLength
[ ] GetMarkedText
[ ] GetMaxRowsCols
[ ] GetNextConnection
[ ] GetNextProfileItem
[ ] GetNextProfileSectionName
[ ] GetOutputDriver
[ ] GetPositionInfo
[ ] GetProfileInt
[ ] GetProfileStr
[ ] GetRedoInfoBuffer
[ ] GetRemoteName
[x] GetShortPath
[ ] GetStr
[ ] GetStrAttr
[ ] GetStrAttrXY
[x] GetStrFromClipboard
[x] GetStrFromWinClip
[x] GetStrXY
[ ] GetSynFilename
[ ] GetSynLanguageType
[ ] GetSynMultiLnDlmt
[ ] GetSynQuote
[ ] GetSynSingleLnDlmt
[ ] GetSynToEOL
[ ] GetSystemInfo
[x] GetTempPath
[ ] GetText
[ ] GetTime
[ ] GetTime+
[ ] GetTimeStr
[ ] GetToken
[ ] GetUndoInfoBuffer
[ ] GetVideoInfo
[ ] GetVolumeInfo
[ ] GetWheelScrollLines
[ ] GetWindowHandleHack
[ ] GetWindowInfo
[ ] GetWindowTitle
[ ] GetWinHandle
[ ] GetWord
[ ] GetWorkBuffer
[ ] GlobalUnDelete
[ ] GotoBlockBegin
[ ] GotoBlockBeginCol
[ ] GotoBlockEnd
[ ] GotoBlockEndCol
[x] GotoBufferId
[ ] GotoColumn
[ ] GotoColumn+
[ ] GotoLine
[ ] GotoLine+
[ ] GotoMark
[x] GotoMark+
[ ] GotoMouseCursor
[ ] GotoNextNonWhite
[ ] GotoNextWhite
[ ] GotoPos
[ ] GotoRow
[ ] GotoWindow
[ ] GotoWindow+
[ ] GotoXoffset
[ ] GotoXY
[ ] HashStr
[ ] Help
[ ] Help+
[ ] HelperFunctionOffset
[ ] HexEdit
[ ] HexEdit+
[ ] HiByte
[ ] HideMouse
[ ] HiLiteFoundText
[ ] HiWord
[ ] Hook
[ ] HookDebugger
[ ] HookDisplay
[ ] HWindow
[ ] InByte
[ ] InitSynhiCurrFile
[ ] InsertData
[ ] InsertFile
[x] InsertFile+
[ ] InsertFileNow
[ ] InsertHelp
[ ] InsertKeyAssignments
[ ] InsertLine
[ ] InsertLine+
[ ] InsertText
[ ] InsertTopic
[ ] InsStr
[ ] Interp
[ ] Intr
[ ] InWord
[ ] is32BitApp
[ ] isAlpha
[ ] isAlpha+
[ ] isAlphaNum
[ ] isAlphaNum+
[ ] isAutoLoaded
[ ] isAutoLoaded2
[ ] isBlockDevice
[ ] isBlockInCurrFile
[ ] isBlockMarked
[ ] isBookMarkSet
[ ] isCharDevice
[ ] isCurrLineInBlock
[ ] isCursorInBlock
[ ] isDigit
[ ] isDigit+
[ ] isDirSeparator
[ ] isDiskFileChanged
[ ] isFullScreen
[ ] isGUI
[ ] isHexDigit
[ ] isHexDigit+
[ ] isKeyAssigned
[ ] isLower
[ ] isLower+
[ ] isMacroLoaded
[ ] isScrapMacro
[ ] isTrailingSlash
[ ] isTypeableKey
[ ] isUpper
[ ] isUpper+
[ ] isWhite
[ ] isWhite+
[ ] isWildPath
[x] isWinClipAvailable
[ ] isWord
[ ] isWord+
[ ] isZoomed
[ ] JoinLine
[ ] KBDMacroBegin
[ ] KeyCode
[ ] KeyName
[ ] KeyPressed
[ ] KillBlock
[ ] KillFile
[ ] KillLine
[x] KillLocation
[ ] KillPosition
[ ] KillToEol
[x] lCapture
[ ] lDos
[x] Left
[x] LeftStr
[x] lFind
[ ] LineDraw
[ ] LineTypeMenu
[ ] LinkSynFile
[ ] List
[ ] ListFooter
[ ] ListHeader
[ ] Literal
[ ] lLeftBtn
[ ] lList
[x] LoadBuffer
[x] LoadDir
[ ] LoadHistory
[ ] LoadKeyMacro
[ ] LoadKeyMacro+
[ ] LoadMacro
[ ] LoadMacro+
[ ] LoadProfileSection
[ ] LoadProfileSectionNames
[ ] LoadStartupMacros
[ ] LoadSynhiAssoc
[ ] LoadUserInterface
[ ] LoByte
[ ] LocalHelp
[ ] LoCase
[ ] LockCurrentFile
[ ] LockMacroId
[ ] LogDrive
[ ] LongestLineInBuffer
[ ] Lower
[ ] Lower+
[ ] LoWord
[ ] lProcess
[ ] lRead
[ ] lReadNumeric
[ ] lRepeatFind
[ ] lReplace
[ ] lRightBtn
[ ] lShowEntryScreen
[ ] LTrim
[ ] lVersion
[ ] MacroStackAvail
[ ] MakeEditWindow
[ ] MakeTempName
[ ] Mark
[ ] MarkAll
[ ] MarkAll+
[ ] MarkBlockBegin
[ ] MarkBlockEnd
[ ] MarkChar
[ ] MarkColumn
[ ] MarkColumn+
[ ] MarkFoundText
[ ] MarkLine
[ ] MarkLine+
[ ] MarkStream
[ ] MarkToEol
[ ] MarkWord
[ ] MatchFilename
[ ] MaxBufferId
[ ] MemUsedK
[ ] MenuKey
[ ] MenuOption
[ ] MenuStr
[ ] Message
[x] MkDir
[ ] MouseHotSpot
[ ] MouseKeyHeld
[ ] MouseMarking
[ ] MouseStatus
[ ] MouseWindowId
[ ] Move
[ ] MoveBlock
[ ] MoveBufBack
[ ] MoveBufForw
[ ] MoveFile
[ ] MovePopWin
[x] MsgBox
[ ] MsgBoxBuff
[ ] MsgBoxEx
[ ] NewFile
[ ] NextChar
[ ] NextDiskConnection
[ ] NextFile
[ ] NextWindow
[ ] NoOp
[ ] NoSound
[ ] NumFiles
[ ] NumFileTokens
[ ] NumHistoryItems
[x] NumHistoryNames
[x] NumLines
[x] NumTokens
[ ] NumWindows
[ ] Ofs
[ ] OneWindow
[ ] OutByte
[ ] OutWord
[ ] PageDown
[ ] PageUp
[ ] Paste
[ ] Paste+
[ ] PasteFromWinClip
[ ] PasteFromWinClip+
[ ] PasteReplace
[ ] PasteReplaceFromWinClip
[ ] PasteUnDelete
[ ] PBAttribute
[ ] PBDate
[ ] PBDateStr
[ ] PBName
[ ] PBSize
[ ] PBSizeHigh
[ ] PBSizeStr
[ ] PBTime
[ ] PBTimeStr
[ ] PeekByte
[ ] PeekLong
[ ] PeekWord
[ ] PickDir
[ ] PickDrive
[ ] PickFile
[ ] PlaceMark
[x] PlaceMark+
[ ] PokeByte
[ ] PokeLong
[ ] PokeWord
[ ] PopBlock
[x] PopLocation
[ ] PopPosition
[ ] PopUndoMark
[ ] PopWinClose
[ ] PopWinOpen
[ ] Pos
[ ] PosFirstNonWhite
[ ] PosLastNonWhite
[ ] PressKey
[ ] PrevChar
[ ] PrevFile
[ ] PrevHelp
[ ] PrevPosition
[ ] PrevUpdateDisplayFlags
[ ] PrevWindow
[ ] PrintBlock
[ ] PrintChar
[ ] PrintFile
[ ] Process
[ ] ProcessHotSpot
[ ] ProcessInWindow
[ ] Ptr
[ ] PurgeKeyMacro
[ ] PurgeMacro
[ ] PurgeMacro+
[ ] PurgeMacroAt
[ ] PurgeSynhi
[ ] PushBlock
[x] PushKey
[ ] PushKeyStr
[x] PushLocation
[ ] PushPosition
[ ] PushUndoMark
[ ] PutAttr
[ ] PutAttrXY
[ ] PutChar
[ ] PutCharH
[ ] PutCharHXY
[ ] PutCharV
[ ] PutCharXY
[ ] PutCtrStr
[ ] PutHelpLine
[ ] PutLine
[ ] PutLineXY
[ ] PutNCharAttr
[ ] PutOemChar
[ ] PutOemCharH
[ ] PutOemCharV
[ ] PutOemLine
[ ] PutOemStr
[ ] PutOemStrXY
[ ] PutStr
[ ] PutStrAttr
[ ] PutStrAttrXY
[ ] PutStrEOL
[ ] PutStrEOLXY
[x] PutStrXY
[ ] Query
[ ] QueryEditState
[ ] QueryInt
[ ] QueryStr
[ ] QuickHelp
[ ] QuitFile
[ ] QuotePath
[ ] Random
[ ] Read
[ ] ReadCompressedLine
[ ] ReadFile
[ ] ReadNumeric
[ ] RealToVirtualScreen
[ ] RecordKeyMacro
[ ] Redo
[ ] RedoCount
[ ] ReinitVideo
[ ] RemoveProfileItem
[ ] RemoveProfileSection
[ ] RemoveTrailingSlash
[ ] RemoveUnloadedFiles
[ ] RenameAndSaveFile
[x] RenameDiskFile
[ ] RenameProfileSection
[ ] RepeatCmd
[ ] RepeatCmd+
[ ] RepeatFind
[ ] RepeatFind+
[ ] Replace
[ ] Replace+
[ ] ReplaceFile
[ ] ReplaceFile+
[ ] ReplaceSynFile
[ ] ResizeFont
[ ] ResizeWindow
[ ] ResizeWindow+
[ ] RestoreCursorLine
[ ] RestoreCursorLineFlag
[ ] RestoreMsgLevel
[ ] RestoreVideoWindow
[ ] Right
[x] RightStr
[x] RmDir
[ ] RollDown
[ ] RollDown2
[ ] RollLeft
[ ] RollRight
[ ] RollUp
[ ] RollUp2
[ ] RootPath
[x] RPos
[ ] RTrim
[ ] SaveAllAndExit
[ ] SaveAllFiles
[ ] SaveAndQuitFile
[ ] SaveAs
[ ] SaveAs+
[ ] SaveBlock
[ ] SaveBlock+
[ ] SaveFile
[ ] SaveHistory
[ ] SaveKeyMacro
[ ] SaveKeyMacro+
[ ] SaveSettings
[ ] SaveVideoWindow
[ ] ScrollDown
[ ] ScrollLeft
[ ] ScrollRight
[ ] ScrollToBottom
[ ] ScrollToCenter
[ ] ScrollToRow
[ ] ScrollToTop
[ ] ScrollUp
[ ] SearchHelp
[x] SearchPath
[ ] Seg
[ ] SelfInsert
[ ] Set
[ ] SetBit
[ ] SetBufferInt
[ ] SetBufferStr
[ ] SetColorTableValue
[ ] SetCurrFilename
[ ] SetCursorOff
[ ] SetCursorOn
[ ] SetDosIOResult
[ ] SetDTA
[ ] SetFileAttr
[ ] SetFont
[ ] SetFont+
[ ] SetGlobalInt
[ ] SetGlobalStr
[ ] SetHookState
[ ] SetInt
[ ] SetLastFindUnknown
[ ] SetMenuBar
[ ] SetMsgLevel
[ ] SetOpenFilenameCustomFilter
[ ] SetOpenFilenameFilter
[ ] SetOutputDriver
[ ] SetPrinterFont
[ ] SetPrintMode
[ ] SetRandomSeed
[ ] SetRefreshWorld
[ ] SetStr
[ ] SetSystemInfo
[ ] SetUndoOff
[ ] SetUndoOn
[ ] SetupCompressedRead
[ ] SetVideoRowsCols
[ ] SetWindowHeight
[ ] SetWindowTitle
[ ] SetWindowWidth
[ ] Shell
[x] Shell+
[ ] ShiftText
[ ] ShowEntryScreen
[ ] ShowMouse
[ ] SignOn
[x] Sort
[ ] Sound
[ ] SplitLine
[ ] SplitPath
[ ] SqueezePath
[ ] StartedFromDOSPrompt
[ ] StartPgm
[ ] Str
[x] StrCount
[x] StrFind
[ ] StripFileToken
[ ] StripToken
[x] StrReplace
[ ] SubStr
[ ] Suspend
[x] SwapLines
[ ] SwapPosition
[ ] SwapPosition+
[ ] System
[ ] TabLeft
[ ] TabRight
[ ] TerminateEvent
[ ] Toggle
[ ] ToggleInsert
[ ] ToggleInt
[ ] TrackMouseCursor
[ ] TranslateToLiteralCh
[ ] Trim
[ ] TurnOnOkToEraseFlag
[ ] UnBufferVideo
[ ] UnDelete
[ ] Undo
[ ] UndoCount
[ ] UndoMode
[ ] UndoMode+
[ ] UnHook
[ ] UnHookDisplay
[ ] UnloadAllBuffers
[ ] UnloadBuffer
[ ] UnLockCurrentFile
[ ] UnlockMacroId
[ ] UnMarkBlock
[x] Up
[ ] UpCase
[ ] UpdateBufferDaTmAttr
[ ] UpdateBufferDaTmSize
[ ] UpdateDisplay
[ ] UpdateDisplayFlags
[ ] UpdateDisplayNoBlock
[ ] Upper
[x] Upper+
[ ] UserHiliteFoundText
[ ] Val
[ ] VerifyHelp
[ ] Version
[ ] VersionStr
[ ] VGotoXY
[ ] VGotoXYAbs
[ ] VHomeCursor
[ ] ViewFinds
[ ] VirtualToRealScreen
[ ] VWhereX
[ ] VWhereXAbs
[ ] VWhereY
[ ] VWhereYAbs
[ ] VWindow
[ ] WaitForKeyPressed
[ ] WaitForMouseEvent
[x] Warn
[ ] WheelDown
[ ] WheelUp
[ ] WhereX
[ ] WhereXAbs
[ ] WhereY
[ ] WhereYAbs
[x] WhichOS
[ ] Window
[ ] WindowFooter
[ ] WindowId
[ ] WordLeft
[ ] WordRight
[ ] WorkLine
[ ] WrapLine
[ ] WrapPara
[ ] Write
[ ] WriteFile
[ ] WriteLine
[ ] WriteProfileInt
[ ] WriteProfileStr
[ ] XlatHelp
[ ] YesNo
[ ] ZoomWindow

[ ] check that ldos and capture return the child's exit code.
    Could run the editor with a macro that does:
    AbandonEditor(42)
    And then check for 42.

[x] (funptr)Left,
[x] (funptr)CurrX,

[x] (ufunptr)FileExists,
[x] (ufunptr)FFisDir,
[x] (ufunptr)PBisDir,

[ ] (lfunptr)SubStr,
[x] (lfunptr)GetHomePath,

[ ] (ffunptr)isAlpha,
[x] (ffunptr)SwapLines,

[ ] EditFile(fn, _DONT_LOAD_) -- did not switch to fn if already
loaded

[ ] StartupVideoMode
 ------------------------------------------------------------------------*/

string test_line1[] = "test line1" + chr(10)
string test_text[] = "test line1"
string test_buf[]   = "***test buf***"
string hello[] = "hello world"
string space_dir[] = "space dir"

string state_fn[] = "tsestate.dat"

string temp_path[_MAX_PATH_]

constant
    DQUOTE = 34,
    DASH = 45,
    BACKSLASH = 92
string  code[]   = "dxoxxxabtnvfr"

string proc mChr(integer i)
    case i
        when 0..6, 14..31, 255      // ctrl chars
            return (Format('\d',i:3:'0'))
        when 7..13                  // bell, backspace, tab, lf, vtab, ff, cr
            return ('\'+code[i])
        when DQUOTE, DASH, BACKSLASH    // ", -, \
            return ('\'+Chr(i))
    endcase
    return (Chr(i))
end

string proc rWordSet(string s)
    string
            ws[255] = ''
    integer i = 0, n

    while i < 256
        if GetBit(s,i)
            ws = ws + mChr(i)
            n = i + 1
            while n < 256 and GetBit(s,n)
                n = n + 1
            endwhile
            n = n - 1
            if n - i > 1
                ws = ws + '-' + mChr(n)
                i = n
            endif
        endif
        i = i + 1
    endwhile
    // check for '-' at beginning and remove the '\' from before it
    if (SubStr(ws, 1, 2) == "\-")
        ws = SubStr(ws, 2, 255)
    endif
    return (ws)
end


//--------------------------------------------------------------------------------------------------
//contributed by Miguel Farah
string proc chopLeft(string s)
  integer len = Length(s)
  return (iif(len>=1, RightStr(s, len-1), ""))
end

string proc chopBoth(string s)
  integer len = Length(s)
    return (iif(len>=2, LeftStr(RightStr(s, len-1), len-2), ""))
end

proc expand_env_str(var string s)
  string first[37] = "A-Za-z#_'(),`\$\*\+\-\.\?\@\[\]\{\}\~" // All acceptable characters in an environment variable name (minus the digits).
  string rest[ 40] = "0-9"+first                             // Digits can't be the first character, but are acceptable from the second one onward.
  // See https://ss64.com/nt/syntax-variables.html

  string ss[255] = ""
  string  t[255]
  string  before[255]
  string  after[ 255]
  integer p1
  integer px

//s = ""
//s = "Look, mom! No variables!!!!"
//s = GetEnvStr("HOME")
//s = "asdj lasdjlasd jalsdfj alsdjfdfj  asdjsadfkdk%ONEDRIVE"
//s = "%ONEDRIVE/asdj lasdjlasd jalsdfj alsdjfdfj  asdjsadfkdk"
//s = "%ProgramFiles(x86)"
//  s = "%A[]%x%A[];x%A2%x%HOMEDRIVE%%HOMEPATH%%SESSIONNAME %Z` %JERK ;%A#$'(E)*+,-I.?@[]O_{}U~; %HOMEDRIVE%%ONEDRIVE%%ONEDRIVE% %NADA%%ONEDRIVE %IT'S %ANT_HOME %SESSIONNAME! :%A%:%'a'%:  %ANT_HOME%%OnEdRiVe"

//  Warn("START: '",s, "'.")

  while (ss<>s) and (StrFind("%", s) <>0) // If s is empty to begin with, there's not gonna be a '%' character inside, so this works.
    ss = s

    // First pass: %NAME%
    p1 = -1
    while p1<>0
      p1 = StrFind("%["+first+"]["+rest+"]*%", s, "x")
      if p1<>0
        t  = SubStr(s, p1+1, Length(s))
        px = StrFind("%", t, "i")
        if px <>0
          before = SubStr(s,p1,px+1)
          after  = GetEnvStr(chopBoth(before))
          s      = StrReplace(before, s, after)
        else
          p1 = 0
        endif
      endif
    endwhile
    //Warn("PASS #1: '", s, "'.")

    // Second pass: %NAME (NOT at the end of the string).
    p1 = -1
    while p1<>0
      p1 = StrFind("%["+first+"]["+rest+"]*[~%"+rest+"]", s, "x")
      if p1<>0
        t  = SubStr(s, p1+1, Length(s))
        px = StrFind("[~"+rest+"]", t, "x")
        if px <>0
          before = SubStr(s,p1,px+1)
          after  = GetEnvStr(chopBoth(before)) + RightStr(before, 1)
          s = StrReplace(before, s, after)
        else
          p1 = 0
        endif
      endif
    endwhile
    //Warn("PASS #2: '", s, "'.")

    // Final pass: %NAME (AT the end of the string).
    p1 = StrFind("%["+first+"]["+rest+"]*$", s, "x")
    if p1<>0
      before  = SubStr(s, p1, Length(s))
      after   = GetEnvStr(chopLeft(before))
      s = StrReplace(before, s, after)
    endif
  //Warn("PASS #3: '", s, "'.")

  // A variable expansion could have introduce another variable, so...
  endwhile

//  Warn("END  : '", s, "'.")
end
//--------------------------------------------------------------------------------------------------

string proc find_exe(string fn, string ext)
    string exe[4] = iif(WhichOs() == _LINUX_, "", ".exe")
    string path[_MAX_PATH_]

    path = LoadDir() + fn + iif(ext <> "", ext, exe)
    if FileExists(path)
        return (path)
    endif

    path = LoadDir() + "mac" + GetDirSeparator() + fn + iif(ext <> "", ext, exe)
    if FileExists(path)
        return (path)
    endif

    return ("")
end

//--------------------------------------------------------------------------------------------------
// Start of test_SearchPath() implementation ... By Carlo Hogeveen
//--------------------------------------------------------------------------------------------------

string  test_SearchPath_cur_dir     [MAXSTRINGLEN] = ''
integer test_SearchPath_debug                      = OFF
integer test_SearchPath_debug_id                   = 0
integer test_SearchPath_id                         = 0
string  test_SearchPath_path1       [MAXSTRINGLEN] = ''
string  test_SearchPath_path2       [MAXSTRINGLEN] = ''
string  test_SearchPath_path3       [MAXSTRINGLEN] = ''
integer test_SearchPath_scd                        = 0
string  test_SearchPath_subdir      [MAXSTRINGLEN] = ''
string  test_SearchPath_unique_name [MAXSTRINGLEN] = ''

integer proc test_SearchPath_make_files(string dir)
  string  fqn [MAXSTRINGLEN] = ''
  integer ok                 = TRUE

  // This proc always returns TRUE.
  // SaveAs() errors are acceptable here.

  fqn = AddTrailingSlash(dir) + test_SearchPath_unique_name

  if not FileExists(fqn)
    SaveAs(fqn, _DONT_PROMPT_|_OVERWRITE_)
  endif

  fqn = AddTrailingSlash(AddTrailingSlash(dir) + test_SearchPath_subdir) +
                         test_SearchPath_unique_name

  if not FileExists(fqn)
    SaveAs(fqn, _DONT_PROMPT_|_OVERWRITE_)
  endif

  return(ok)
end test_SearchPath_make_files

integer proc test_SearchPath_delete_dirs(string dir)
  string  subdir_fqn [MAXSTRINGLEN] = AddTrailingSlash(dir) + test_SearchPath_subdir
  integer ok                        = TRUE

  if FileExists(dir) & _DIRECTORY_
    if FileExists(subdir_fqn) & _DIRECTORY_
      RmDir(subdir_fqn)
    endif

    RmDir(dir)
  endif

  return(ok)
end test_SearchPath_delete_dirs

integer proc test_SearchPath_delete_files(string dir)
  string  file_fqn        [MAXSTRINGLEN] = ''
  integer ok                             = TRUE
  string  subdir_file_fqn [MAXSTRINGLEN] = ''

  file_fqn        = AddTrailingSlash(dir) +
                    test_SearchPath_unique_name

  subdir_file_fqn = AddTrailingSlash(AddTrailingSlash(dir)   +
                                     test_SearchPath_subdir) +
                    test_SearchPath_unique_name

  if FileExists(file_fqn)
    EraseDiskFile(file_fqn)
  endif

  if FileExists(subdir_file_fqn)
    EraseDiskFile(subdir_file_fqn)
  endif

  return(ok)
end test_SearchPath_delete_files

integer proc test_SearchPath_expect_file(string dir)
  string  file_fqn [MAXSTRINGLEN] = AddTrailingSlash(dir) + test_SearchPath_unique_name
  integer ok                      = TRUE

  if test_SearchPath_debug
    AddLine('Expected: "' + file_fqn + '"', test_SearchPath_debug_id)
  endif

  if FileExists(file_fqn)
    if lFind(file_fqn, '^gi$')
      EndFile()
    else
      AddLine(file_fqn)
    endif
  endif

  return(ok)
end test_SearchPath_expect_file

integer proc test_SearchPath_expect_subdir_file(string dir)
  integer ok                        = TRUE
  string  subdir_fqn [MAXSTRINGLEN] = ''

  subdir_fqn = AddTrailingSlash(dir) + test_SearchPath_subdir
  ok         = test_SearchPath_expect_file(subdir_fqn)

  return(ok)
end test_SearchPath_expect_subdir_file

string proc test_SearchPath_option(string fn, string path, string subdir)
  integer counter                     = 0
  string  dir          [MAXSTRINGLEN] = ''
  string  expected_fqn [MAXSTRINGLEN] = ''
  string  found_fqn    [MAXSTRINGLEN] = ''
  integer is_fqn                      = FALSE
  string  result       [MAXSTRINGLEN] = ''

  if test_SearchPath_debug
    PushLocation()
    GotoBufferId(test_SearchPath_debug_id)

    AddLine('')
    AddLine('SearchPath("' + fn     + '",')
    AddLine('           "' + path   + '",')
    AddLine('           "' + subdir + '")')
    AddLine('      with SearchCurrentDirectory ' +
                   iif(test_SearchPath_scd, 'ON', 'OFF') + '.')
    PopLocation()
  endif

  if NumTokens(path, ';') == 0
    return('Testing "OS PATH search" with empty "path" parameter is not implemented.')
  endif

  // Make sure all searchable files exist irrespective of parameters and option.
  test_SearchPath_make_files(test_SearchPath_cur_dir)
  test_SearchPath_make_files(test_SearchPath_path1  )
  test_SearchPath_make_files(test_SearchPath_path2  )
  test_SearchPath_make_files(test_SearchPath_path3  )
  test_SearchPath_make_files(LoadDir()              )

  // Generate a list of expected files to be found in the expected order,
  // based on the search parameters and our own test_SearchPath_scd option.
  EmptyBuffer()

  if (WhichOS() in _WINDOWS_, _WINDOWSNT_)
    if (   isAlpha(fn[1])
       and fn[2] == ':')
    or fn[1:2] == '\\'
      is_fqn = TRUE
    endif
  else
    if fn[1] == '/'
      is_fqn = TRUE
    endif
  endif

  if is_fqn
    //  Searching a file by its fully qualified name should have only itself as
    //  a result, irrespective of other parameters.
    if FileExists(fn)
      AddLine(fn)   // Just add the fully qualified name as the expected file.

      if test_SearchPath_debug
        AddLine('Expected: "' + fn + '"', test_SearchPath_debug_id)
      endif
    endif
  else
    if  subdir <> ''
    and test_SearchPath_scd
      test_SearchPath_expect_file(test_SearchPath_cur_dir)
    endif

    //  Windows' PATH setting uses ";" as directory separator.
    //  Linux'   PATH setting uses ":" as directory separator.
    //  The SearchPath() statement of both Windows TSE and Linux TSE
    //  expects a ";" separator in its path parameter.
    for counter = 1 to NumTokens(path, ';')
      dir = GetToken(path, ';', counter)
      test_SearchPath_expect_file(dir)

      if not (subdir in '.', '')
        test_SearchPath_expect_subdir_file(dir)
      endif
    endfor

    if subdir <> ''
      test_SearchPath_expect_file(LoadDir())
      if subdir <> '.'
        test_SearchPath_expect_subdir_file(LoadDir())
      endif
    endif
  endif

  //  Now repeatedly use SearchPath() to find and delete each expected file in
  //  order.
  BegFile()
  repeat
    expected_fqn = GetText(1, MAXSTRINGLEN)

    if subdir == ''
      found_fqn = SearchPath(fn, path)
    else
      found_fqn = SearchPath(fn, path, subdir)
    endif

    if test_SearchPath_debug
      AddLine('Found   : "' + found_fqn + '"', test_SearchPath_debug_id)
    endif

    if EquiStr(expected_fqn, found_fqn)
    or EquiStr(GetShortPath(expected_fqn), GetShortPath(found_fqn))
      KillLine()
      EraseDiskFile(found_fqn)
    else
      PushLocation()
      test_SearchPath_debug = TRUE
      GotoBufferId(test_SearchPath_debug_id)
      AddLine('')
      AddLine('SearchPath() error!')
      AddLine('')
      AddLine('SearchPath("' + fn     + '",')
      AddLine('           "' + path   + '",')
      AddLine('           "' + subdir + '")')
      AddLine('with SearchCurrentDirectory == ' + iif(test_SearchPath_scd, 'ON', 'OFF'))
      AddLine('returns')
      AddLine('   "' + found_fqn    + '"')
      AddLine('instead of')
      AddLine('   "' + expected_fqn + '".')
      AddLine('')
      UpdateDisplay(_ALL_WINDOWS_REFRESH_)
      result = 'SearchPath() error: See description in new "' +
               CurrFilename() + '" buffer.'
      PopLocation()
    endif
  until result       <> ''
     or expected_fqn == ''
  return(result)
end test_SearchPath_option

string proc test_SearchPath_test(string fn, string path, string subdir)
  string result [MAXSTRINGLEN] = ''

  result = test_SearchPath_option(fn, path, subdir)

  #if INTERNAL_VERSION >= 12387
    if result == ''
      Toggle(searchcurrentdirectory)     // For SearchPath()'s internal use.
      test_SearchPath_scd = not test_SearchPath_scd // For this macro's use.

      result = test_SearchPath_option(fn, path, subdir)

      Toggle(searchcurrentdirectory)     // For SearchPath()'s internal use.
      test_SearchPath_scd = not test_SearchPath_scd // For this macro's use.
    endif
  #endif

  return(result)
end test_SearchPath_test

string proc test_SearchPath()
  string  cur_dir         [MAXSTRINGLEN] = ''
  string  result          [MAXSTRINGLEN] = ''
  string  old_current_dir [MAXSTRINGLEN] = CurrDir()
  string  path1           [MAXSTRINGLEN] = ''
  string  path2           [MAXSTRINGLEN] = ''
  string  path3           [MAXSTRINGLEN] = ''
  string  subdir          [MAXSTRINGLEN] = 'Mac'
  string  time                      [11] = Str(GetTime())
  string  tmp_dir         [MAXSTRINGLEN] = AddTrailingSlash(GetTempPath())
  integer tries                          = 0
  string  unique_name     [MAXSTRINGLEN] = ''
  string  wrk_dir         [MAXSTRINGLEN] = ''

  // Start of setting up the tests ...

  PushLocation()
  test_SearchPath_debug_id = NewFile()
  ChangeCurrFilename(SplitPath(CurrMacroFilename(), _NAME_) +
                     ':Debug:' + time,
                     _DONT_PROMPT_|_DONT_EXPAND_|_OVERWRITE_)
  test_SearchPath_id       = CreateTempBuffer()
  ChangeCurrFilename(SplitPath(CurrMacroFilename(), _NAME_) +
                     ':Tmp:' + time,
                     _DONT_PROMPT_|_DONT_EXPAND_|_OVERWRITE_)

  //  test_SearchPath_id remains the current buffer until either all tests are
  //  done or an error is encountered.

  #if INTERNAL_VERSION < 12387
    test_SearchPath_scd = ON
  #else
    test_SearchPath_scd = Query(searchcurrentdirectory)
  #endif

  // Determine a unique name that does not exist in any fixed SearchPath
  // directory or the temporary directory.
  repeat
    tries = tries + 1
    if tries <= 10000
      unique_name = SplitPath(MakeTempName(LoadDir()), _NAME_|_EXT_)
    else
      result = 'Program error: No unique name.'
    endif
  until result <> ''
    or (    not FileExists(LoadDir()       + 'mac\' + unique_name)
        and not FileExists(old_current_dir          + unique_name)
        and not FileExists(old_current_dir + 'mac\' + unique_name)
        and not FileExists(tmp_dir                  + unique_name))

  // Create all possible non-fixed SearchPath directories.
  if      result == ''
  and not MkDir(tmp_dir + unique_name)
    result = 'Program error: MkDir ' + QuotePath(tmp_dir + unique_name)
  endif

  if result == ''
    // Create temporary helper directories
    wrk_dir = AddTrailingSlash(tmp_dir + unique_name)
    cur_dir = wrk_dir + 'CurrentDir'
    path1   = wrk_dir + 'Path1'
    path2   = wrk_dir + 'Path2'
    path3   = wrk_dir + 'Path3'
    MkDir(cur_dir)
    MkDir(path1)
    MkDir(path2)
    MkDir(path3)
    MkDir(AddTrailingSlash(cur_dir) + subdir)
    MkDir(AddTrailingSlash(path1)   + subdir)
    MkDir(AddTrailingSlash(path2)   + subdir)
    MkDir(AddTrailingSlash(path3)   + subdir)
  endif

  // Communicate static variables thru global variables to increase readability.
  test_SearchPath_cur_dir     = cur_dir
  test_SearchPath_path1       = path1
  test_SearchPath_path2       = path2
  test_SearchPath_path3       = path3
  test_SearchPath_subdir      = subdir
  test_SearchPath_unique_name = unique_name

  if      result == ''
  and     (WhichOS() in _WINDOWSNT_, _WINDOWS_)
  and not LogDrive(cur_dir[1])
    result = 'Program error: LogDrive("' + cur_dir[1] + '").'
  endif

  if      result == ''
  and not ChDir(cur_dir)
    result = 'Program error: LogDrive("' + cur_dir[1] + '").'
  endif

  // End of setting up the tests.

  // Here the actual tests start ...

  if result == ''
    result = test_SearchPath_test(AddTrailingSlash(path2) + unique_name,
                                  path1 + ';' + path2 + ';' + path3,
                                  '')
  endif

  if result == ''
    result = test_SearchPath_test(unique_name,
                                  path1 + ';' + path2 + ';' + path3,
                                  '')
  endif

  if result == ''
    result = test_SearchPath_test(unique_name,
                                  path1 + ';' + path2 + ';' + path3,
                                  subdir)
  endif

  if result == ''
    result = test_SearchPath_test(unique_name,
                                  path1 + ';' + path2 + ';' + path3,
                                  '.')
  endif

  //  The following (default commented) meta-tests intentionally produce
  //  an error, each in a different form.

  //  test_SearchPath cannot test with an empty path parameter.
  if result == ''
    // result = test_SearchPath_test(unique_name, '', subdir)
  endif

  //  test_SearchPath only works for subdir parameter "mac", "." and "".
  if result == ''
    // result = test_SearchPath_test(unique_name, path1 + ';' + path2, 'NotMac')
  endif

  // Here the actual tests end.

  // Leave the test's temporary current directory so it becomes deletable.
  if (WhichOS() in _WINDOWSNT_, _WINDOWS_)
    LogDrive(old_current_dir[1])
  endif
  ChDir(old_current_dir)

  // Delete all helper files.
  test_SearchPath_delete_files(cur_dir  )
  test_SearchPath_delete_files(path1    )
  test_SearchPath_delete_files(path2    )
  test_SearchPath_delete_files(path3    )
  test_SearchPath_delete_files(LoadDir())

  // Delete all helper directories.
  test_SearchPath_delete_dirs(cur_dir)
  test_SearchPath_delete_dirs(path1  )
  test_SearchPath_delete_dirs(path2  )
  test_SearchPath_delete_dirs(path3  )
  RmDir(wrk_dir)

  // Restore location and clean-up temp file.
  PopLocation()
  AbandonFile(test_SearchPath_id)

  if not test_SearchPath_debug
    AbandonFile(test_SearchPath_debug_id)
  endif

  if result <> ''
    result = 'test_SearchPath: ' + result
  endif

  return(result)
end test_SearchPath

//--------------------------------------------------------------------------------------------------
// End of test_SearchPath() implementation.
//--------------------------------------------------------------------------------------------------

string proc test_FileStuff2(string fn, integer n)
    integer h, b
    string tst[32] = "test_FileStuff " + str(n) + " "

    // setup - remove buffers in case they exist
    b = GetBufferId(fn)
    if b <> 0
        AbandonFile(b)
    endif

    b = GetBufferId(test_buf)
    if b <> 0
        AbandonFile(b)
    endif

    h = fCreate(fn)
    if h == -1
        return (tst + ": fCreate failed on " + fn)
    endif

    // Write 1 line to the test file
    fWrite(h, test_line1)

    fClose(h)

    h = fOpen(fn)
    if h == -1
        return (tst + ": fOpen did not open " + fn)
    endif

    fClose(h)

    if not FileExists(fn)
        return (tst + ": FileExists did not find " + fn)
    endif

    h = FindFirstFile(fn, -1)
    if h == -1
        return (tst + ": FindFirstFile did not find " + fn)
    endif

    FindFileClose(h)

    h = FindThisFile(fn)
    if h == -1
        return (tst + ": FindThisFile did not find " + fn)
    endif

    b = EditThisFile(fn)
    if b == 0
        return (tst + ": EditThisFile did not find " + fn)
    endif

    if NumLines() <> 1
        return (tst + ": EditThisFile unexpected number of lines " + str(NumLines()) + " " + fn)
    endif

    AbandonFile(b)

    b = GetBufferId(test_buf)
    if b == 0
        b = CreateBuffer(test_buf)
    else
        GotoBufferId(b)
    endif
    if b == 0
        return (tst + ": CreateBuffer failed on " + test_buf)
    endif

    if not LoadBuffer(fn)
        return (tst + ": LoadBuffer failed " + fn)
    endif

    if NumLines() <> 1
        return (tst + ": LoadBuffer unexpected number of lines " + str(NumLines()) + " " + fn)
    endif

    BegFile()

    if not InsertFile(fn)
        return (tst + ": InsertFile failed " + fn)
    endif

    if NumLines() <> 2
        return (tst + ": InsertFile unexpected number of lines " + str(NumLines()) + " " + fn)
    endif

    AbandonFile(b)

    if not EraseDiskFile(fn)
        return (tst + ": EraseDiskFile failed on " + fn)
    endif

    if FileExists(fn)
        return (tst + ": File still exists " + fn)
    endif

    return ("")
end

string proc test_FileStuff()
    string error[255], temp_dir[255], tilde_dir[255], fn[255], tmp[32]
    integer i, found

    error = ""
    temp_dir = AddTrailingSlash(MakeTempName(GetTempPath()))
    MkDir(temp_dir)

    //  Create a file, and perform various operations on it
    fn = MakeTempName(temp_dir)
    error = test_FileStuff2(fn, 1)
    if error <> ""
        goto finish
    endif

    //  Create a file with spaces in the name, test it
    SetRandomSeed()
    fn = fn + " "
    found = false
    for i = 1 to 100
        tmp = str(Random())
        if not FileExists(fn + tmp)
            fn = fn + tmp
            found = true
            break
        endif
    endfor
    if not found
        error = "Could not generate filename with spaces - base: " + fn
        goto finish
    endif

    error = test_FileStuff2(fn, 2)
    if error <> ""
        goto finish
    endif

    //  Test using a ~\ filename
    tilde_dir = AddTrailingSlash(MakeTempName("~" + GetDirSeparator()))
    MkDir(tilde_dir)

    //  Create a file, and perform various operations on it
    fn = MakeTempName(tilde_dir)
    error = test_FileStuff2(fn, 3)
    RmDir(tilde_dir)

finish:
    RmDir(temp_dir)
    return (error)
end

/*------------------------------------------------------------------------
  Capture doesn't work on win95/98
 ------------------------------------------------------------------------*/
string proc test_capture()
    string internal[32], internal_f[255], s[255]
    integer rc

    if WhichOS() == _WINDOWS_
        return ("")
    endif

    internal = "echo " + hello
    internal_f = hello

    PushLocation()

    if Query(CaptureId) == 0
        KillLocation()
        return ("CaptureId 01 is 0")
    endif

    Message("Testing Capture() internal command")

    EmptyBuffer(Query(CaptureId))

    // test internal command, no flags
    if not Capture(internal)
        KillLocation()
        return ("Capture 02: dir failed")
    endif

    if GetBufferId() <> Query(CaptureId)
        KillLocation()
        return (Format("CaptureId 03: GetBufferId() == ", GetBufferId(), " Query(CaptureId) == ", Query(CaptureId)))
    endif

    if not lFind(internal_f, "g")
        KillLocation()
        return ("Capture 04: dir failed")
    endif

    EmptyBuffer(Query(CaptureId))

    // test internal command, flags
    if not Capture(internal, _STDOUT_|_STDERR_)
        KillLocation()
        return ("Capture 05: dir failed 03")
    endif

    if GetBufferId() <> Query(CaptureId)
        KillLocation()
        return (Format("CaptureId 06: GetBufferId() == ", GetBufferId(), " Query(CaptureId) == ", Query(CaptureId)))
    endif

    if not lFind(internal_f, "g")
        KillLocation()
        return ("Capture 07: dir failed")
    endif

    // testing with dir with spaces in the name

    EmptyBuffer(Query(CaptureId))
    s = GetTempPath()
    s = MakeTempName(s)
    MkDir(s)
    s = s + GetDirSeparator() + space_dir
    MkDir(s)
    s = s + GetDirSeparator() + "cmd.bat"
    EditThisFile(s)
    AddLine("echo " + hello)
    SaveFile()
    PushLocation()
    if WhichOS() == _LINUX_
        Shell('source ' + QuotePath(s))
    else
        Shell(QuotePath(s))
    endif

    if not lFind(hello, "g")
        return ("Capture 08: spaces echo")
    endif
    PopLocation()

    // remove what we created
    KillFile()
    AbandonFile()
    // have: \temppath\tempname\space dir\
    s = SplitPath(s, _DRIVE_|_PATH_)
    if not RmDir(s)
        return ("Rmdir error: " + s)
    endif

    s = RemoveTrailingSlash(s)
    s = SplitPath(s, _DRIVE_|_PATH_)
    if not RmDir(s)
        return ("Rmdir error: " + s)
    endif

    Message("Testing Capture() external command")

    // test external command, no flags

    EmptyBuffer(Query(CaptureId))

    if not Capture("sc32 -?")
        KillLocation()
        return ("Capture 09: sc32")
    endif

    if GetBufferId() <> Query(CaptureId)
        KillLocation()
        return (Format("CaptureId 10: GetBufferId() == ", GetBufferId(), " Query(CaptureId) == ", Query(CaptureId)))
    endif

    if not lFind("SAL Compiler", "g")
        KillLocation()
        return ("Capture 11: sc32 failed")
    endif

    // test external command, flags
    EmptyBuffer(Query(CaptureId))

    if not Capture("sc32 -?", _STDOUT_|_STDERR_)
        KillLocation()
        return ("Capture 12: sc32 failed")
    endif

    if GetBufferId() <> Query(CaptureId)
        KillLocation()
        return (Format("CaptureId 13: GetBufferId() == ", GetBufferId(), " Query(CaptureId) == ", Query(CaptureId)))
    endif

    if not lFind("SAL Compiler", "g")
        KillLocation()
        return ("Capture 14: sc32 failed")
    endif

    // test errno

    Capture("sc32 should_not_be_found.s")
    rc = DosIOResult()
    if rc == 0
        KillLocation()
        return ("CaptureId 15 - sc32 should_not_be_found.s should set errno")
    endif

    Capture("sc32 -?")
    rc = DosIOResult()
    if rc == 0
        KillLocation()
        return ("CaptureId 16 - sc32 -? should set errno")
    endif

    Capture("not_a_real_command")
    rc = DosIOResult()
    if rc == 0
        KillLocation()
        return ("CaptureId 17 - should set errno")
    endif

    PopLocation()

    return ("")
end

/*------------------------------------------------------------------------
  For example, this File Open fails with the warning "Directory not found: folder\New" :

   -b "d:\New folder\New Text Document.txt"
 ------------------------------------------------------------------------*/

string proc test_EditThisFile2(string m_dir, string m_dir2, string a_path, string e_path, string msg, string msg2)
    if not EditThisFile(e_path)
        EraseDiskFile(a_path)
        RmDir(m_dir2)
        RmDir(m_dir)
        return (msg + e_path)
    endif

    if GetText(1, CurrLineLen()) <> test_text
        KillFile()
        AbandonFile()
        EraseDiskFile(a_path)
        RmDir(m_dir2)
        RmDir(m_dir)
        return (msg2 + e_path)
    endif

    AbandonFile()
    return ("")
end

string proc test_EditThisFileBug()
    string m_dir[_MAX_PATH_] = MakeTempname(temp_path)
    string m_dir2[_MAX_PATH_] = m_dir + GetDirSeparator() + "test dir"
    string m_fn[_MAX_PATH_] = "test file.txt"
    string m_path[_MAX_PATH_] = m_dir2 + GetDirSeparator() + m_fn
    string s[255]

    Message("Testing EditThisFile()")

    if not MkDir(m_dir)
        return ("MkDir failed on: " + m_dir)
    endif

    if not MkDir(m_dir2)
        return ("MkDir failed on: " + m_dir2)
    endif

    if not EditThisFile(m_path)
        RmDir(m_dir2)
        RmDir(m_dir)
        return ("EditThisFile (new) failed on: " + m_path)
    endif

    AddLine(test_text)
    SaveAndQuitFile()

    // some dir/some file
    s = test_EditThisFile2(m_dir, m_dir2, m_path, m_path,                                                   "EditThisFile (existing) failed on: ",        "EditThisFile (existing) could not find text on: ")
    if s <> ""
        return (s)
    endif

    // "some dir/some file"
    s = test_EditThisFile2(m_dir, m_dir2, m_path, QuotePath(m_path),                                       "EditThisFile (existing quoted) failed on: ", "EditThisFile (existing quoted) could not find text on: ")
    if s <> ""
        return (s)
    endif

    // test with switch: -b some dir/some file
    s = test_EditThisFile2(m_dir, m_dir2, m_path, "-b" + str(length(test_text)) + " " + m_path,            "EditThisFile (existing) failed on: ",        "EditThisFile (existing) could not find text on: ")
    if s <> ""
        return (s)
    endif

    // test with switch: -b "some dir/some file"
    s = test_EditThisFile2(m_dir, m_dir2, m_path, "-b" + str(length(test_text)) + " " + QuotePath(m_path), "EditThisFile (existing quoted) failed on: ", "EditThisFile (existing quoted) could not find text on: ")
    if s <> ""
        return (s)
    endif

    if not EraseDiskFile(m_path)
        return ("EraseDiskFile failed on: " + m_path)
    endif

    if not RmDir(m_dir2)
        return ("RmDir failed on: " + m_dir2)
    endif

    if not RmDir(m_dir)
        return ("RmDir failed on: " + m_dir)
    endif

    return ("")
end

string proc test_GetTempPath()
    string fn[_MAX_PATH_]
    integer id, ok

    Message("Testing GetTempPath()")
    fn = GetTempPath()
    if fn == ""
        return ("GetTempPath failed")
    endif

    if not FindThisFile(fn)
        return ("GetTempPath: could not find: " + fn)
    endif

    if not FFisDir()
        return ("GetTempPath: not a dir: " + fn)
    endif

    PushLocation()
    fn = MakeTempName(fn)
    id = NewFile()
    AddLine("Hello, World")
    ok = SaveAs(fn)
    PopLocation()
    AbandonFile(id)
    if ok
        ok = FileExists(fn)
    endif
    EraseDiskFile(fn)
    if not ok
        return ("GetTempPath: could not save file")
    endif

    return ("")
end

string proc test_GetShortPath()
    string s[_MAX_PATH_], dir[_MAX_PATH_], dir2[_MAX_PATH_], short_name[_MAX_PATH_], long_file_name[_MAX_PATH_]
    integer i, n

    Message("Testing GetShortPath")

    // test with just a filename, and other weird stuff
    s = SplitPath(MakeTempName(GetTempPath()), _NAME_|_EXT_)
    s = s + ";" + "."
    s = s + ";" + GetDirSeparator()
    s = s + ";" + "." + GetDirSeparator()

    n = NumTokens(s, ";")
    for i = 1 to n
        long_file_name = GetToken(s, ";", i)
        short_name = GetShortPath(long_file_name)
        if short_name <> long_file_name
            return ("GetShortPath failed - should be equal:" + chr(13) + long_file_name + chr(13) + short_name)
        endif
    endfor

    s = GetTempPath()
    dir = MakeTempName(s)
    MkDir(dir)
    dir2 = dir + GetDirSeparator() + "longish dir name"
    MkDir(dir2)
    long_file_name = dir2 + GetDirSeparator() + "long file name"
    short_name = GetShortPath(long_file_name)

    if not RmDir(dir2)
        return ("GetShortPath: RmDir(" + dir2 + ") failed")
    endif

    if not RmDir(dir)
        return ("GetShortPath: RmDir(" + dir + ") failed")
    endif

    if WhichOS() == _WINDOWSNT_
        if short_name == long_file_name
            return ("GetShortPath failed:" + chr(13) + long_file_name + chr(13) + short_name)
        endif
    elseif WhichOS() == _LINUX_
        // On Linux, GetShortPath should not change the path
        if QuotePath(short_name) <> QuotePath(long_file_name)
            return ("GetShortPath failed:" + chr(13) + long_file_name + chr(13) + short_name)
        endif
    endif

    return ("")
end

/*------------------------------------------------------------------------
  10,000,000 line files caused editor to crash becaues of line number
  display error
 ------------------------------------------------------------------------*/
string proc test_LineNumbers()
    string fn[_MAX_PATH_] = MakeTempName(GetTempPath())
    integer save_line_numbers = Set(ShowLineNumbers, On)
    integer i
    integer n = 10000000

    // Win95/98 can't load that many lines
    if WhichOS() == _WINDOWS_
        n = 1000000
    endif

    EditThisFile(fn)
    Message("Testing 10,000,000 line file with line numbers on")
    SetUndoOff()
    for i = 1 to n
        AddLine(Format("This is line ", i, " of ", n))
        if i mod 500000 == 0
            Message("Adding ", i, " of ", n, " mem used k: ", MemUsedK())
            KeyPressed()
        endif
        if MemUsedK() > 1024 * 1024
            Warn("Almost out of memory at ", n, " - mem used k: ", MemUsedK(), " - terminating test")
            break
        endif
    endfor
    SetUndoOn()
    UpdateDisplay()
    BegFile()
    UpdateDisplay()
    EndFile()
    UpdateDisplay()
    AbandonFile()
    Set(ShowLineNumbers, save_line_numbers)
    EraseDiskFile(fn)
    return ("")
end

string proc test_GetStrXY()
    string s[255] = ""

    Message("Testing GetStrXY()")
    PutStrXY(2, 2, hello)
    GetStrXY(2, 2, s, sizeof(hello))
    if s <> hello
        return ("GetStrXY: put: " + hello + " : got: " + s)
    endif

    return ("")
end

/*------------------------------------------------------------------------
  Test that the local/global option of state works.
  We'll need to
    save any current global/local state files
    SaveState
 ------------------------------------------------------------------------*/

integer proc test_state_helper(string path0, integer new_state, integer old_state)
    string spath[_MAX_PATH_], tpath[_MAX_PATH_] = ""
    integer error = false

    Set(SaveState, new_state)

    /* save existing state file */
    spath = path0 + state_fn
    if FileExists(spath)
        tpath = MakeTempName(path0, "junk")
        RenameDiskFile(spath, tpath)
    endif

    ExecMacro("state -s")
    if not FileExists(spath)
        error = true
    endif

    /* erase state file we just created */

    EraseDiskFile(spath)
    /* restore existing state file */
    if tpath <> ""
        RenameDiskFile(tpath, spath)
    endif

    Set(SaveState, old_state)
    return (error)
end

string proc test_state()
    integer error, save_state = Query(SaveState)

    Message("testing SaveState global")
    error = test_state_helper(LoadDir(), ON, save_state)

    if error
        return ("SaveState global did not create global state file")
    endif

    Message("testing SaveState local")

    error = test_state_helper(CurrDir(), _LOCAL_, save_state)

    if error
        return ("SaveState local did not create global state file")
    endif

    return ("")
end

string proc test_CompareLines()
    integer a, b

    Message("testing CompareLines()")

    a = CreateTempBuffer()
    b = CreateTempBuffer()

    // equal case
    AddLine(hello, a)
    AddLine(hello, b)

    if CompareLines(1, 1, 0, a, b) <> 0
        return ("CompareLines() 01 did not return 0")
    endif

    // not equal case
    AddLine(Upper(hello), a)
    AddLine(hello, b)

    if CompareLines(2, 2, 0, a, b) <> -1
        return ("CompareLines() 02 did not return -1")
    endif

    // equal, ignore case
    if CompareLines(2, 2, _IGNORE_CASE_, a, b) <> 0
        return ("CompareLines() 03 did not return 0")
    endif

    // multiple spaces, ignore case, should not match
    AddLine(Upper(hello) + "   " + hello, a)
    AddLine(hello + " " + hello, b)

    if CompareLines(3, 3, _IGNORE_CASE_, a, b) <> -1
        return ("CompareLines() 04 did not return -1")
    endif

    // multiple spaces, ignore case, filter spaces, should match
    if CompareLines(3, 3, _IGNORE_CASE_|_FILTER_SPACES_, a, b) <> 0
        return ("CompareLines() 05 did not return 0")
    endif

    // multiple spaces, ignore case, multiple spaces at eol, filter spaces, should match
    AddLine(Upper(hello) + "   " + hello + "   ", a)
    AddLine(hello + " " + hello + " ", b)

    if CompareLines(4, 4, _IGNORE_CASE_|_FILTER_SPACES_, a, b) <> 0
        return ("CompareLines() 06 did not return 0")
    endif

    // multiple spaces, ignore case, multiple spaces at eol, plus an 'x' on one at eol, filter spaces, should not match
    AddLine(Upper(hello) + "   " + hello + "   " + 'x', a)
    AddLine(hello + " " + hello + " ", b)

    if CompareLines(5, 5, _IGNORE_CASE_|_FILTER_SPACES_, a, b) <> 1
        return ("CompareLines() 07 did not return 1")
    endif

    // multiple spaces, ignore case, multiple spaces at eol, plus an 'x' on at eol, filter spaces, should match
    AddLine(Upper(hello) + "   " + hello + "   " + 'x', a)
    AddLine(hello + " " + hello + " " + 'x', b)

    if CompareLines(6, 6, _IGNORE_CASE_|_FILTER_SPACES_, a, b) <> 0
        return ("CompareLines() 08 did not return 0")
    endif

    // multiple spaces, ignore case, multiple spaces at eol, plus an 'x' on one at eol, filter spaces, should not match
    AddLine(Upper(hello) + "   " + hello + "   ", a)
    AddLine(hello + " " + hello + " " + 'x', b)

    if CompareLines(7, 7, _IGNORE_CASE_|_FILTER_SPACES_, a, b) <> -1
        return ("CompareLines() 07 did not return -1")
    endif

    AbandonFile(a)
    AbandonFile(b)
    return ("")
end

/*------------------------------------------------------------------------
  Expanding a blank path should be the same expanding *.*
  Expanding a non-existent but validly named file should not fail
 ------------------------------------------------------------------------*/
string proc test_expandpath()
    string s1[_MAX_PATH_], s2[_MAX_PATH_], temp[_MAX_PATH_], error[255]
    integer rc

    error = ""

    s1 = ExpandPath("*.*")
    s2 = ExpandPath(" ")
    if s1 <> s2
        return ("expandpath() failed on blank path")
    endif

    temp = GetTempPath()
    temp = MakeTempName(temp)
    MkDir(temp)

    s1 = ExpandPath(temp)
    if s1 == ""
        error = "expandpath() of dir '" + temp + "' failed"
        goto finish
    endif

    rc = DosIOResult()
    if rc <> 0
        error = "expandpath() of dir '" + temp + "' ok, but rc <> 0: " + str(rc)
        goto finish
    endif

    s2 = MakeTempName(temp)
    s1 = ExpandPath(s2)
    if s1 == ""
        error = "expandpath() of file '" + s2 + "' failed"
        goto finish
    endif

    rc = DosIOResult()
    if rc == 0
        error = "expandpath() of non-existing file '" + temp + "' ok, but rc == 0"
        goto finish
    endif

finish:
    RmDir(temp)

    return (error)
end

/*------------------------------------------------------------------------
  EditFile(" ") was creating a file with garbage characters in the name.

  Editfile with a blank should be the same as EditFile *.*
 ------------------------------------------------------------------------*/
string proc test_editfilebug()
    integer rc, rc2, rc3, load_wild

    load_wild = Set(LoadWildFromInside, off)
    rc = EditFile(" ", _DONT_PROMPT_)
    rc2 = EditFile("", _DONT_PROMPT_)
    rc3 = EditFile("*.*", _DONT_PROMPT_)
    Set(LoadWildFromInside, load_wild)

    if rc == rc2 and rc == rc3
        return ("")
    endif
    return ("editfile() failed on blank path")
end

/*------------------------------------------------------------------------
  Not really sure how to test this.
 ------------------------------------------------------------------------*/
string proc test_NumHistoryNames()
    integer n1
    n1 = NumHistoryNames()
    if n1 < 0
        return ("NumHistoryNames() should be >= 0")
    endif
    return ("")
end

/*------------------------------------------------------------------------
  Test that warn returns FALSE
 ------------------------------------------------------------------------*/
string proc test_warn()
    PushKey(<Enter>)
    if Warn("Should not see this")
        return ("Warn() should return 0, but returns non-zero")
    endif
    return ("")
end

/*------------------------------------------------------------------------
  Test that MsgBox(..., _OK_) returns 1 if enter pressed, 0 if escape
 ------------------------------------------------------------------------*/
string proc test_msgbox()
    PushKey(<Enter>)
    if MsgBox("Title", "Should not see this", _OK_) <> _OK_
        return ("MsgBox(...,_OK_), <Enter>, should return 1, but returns 0")
    endif

    PushKey(<SpaceBar>)
    if MsgBox("Title", "Should not see this", _OK_) <> _OK_
        return ("MsgBox(...,_OK_), <SpaceBar>, should return 1, but returns 0")
    endif

    PushKey(<Escape>)
    if MsgBox("Title", "Should not see this", _OK_) <> 0
        return ("MsgBox(...,_OK_), <Escape>, should return 0, but returns 1")
    endif

    return ("")
end

/*------------------------------------------------------------------------
  Test Sort(_DECIMAL_) vs. -0 and 0
  Given the data below, -0 and 0 should be the first two lines
 ------------------------------------------------------------------------*/
string proc test_sort_decimal_asc()
    PushLocation()
    NewFile()

    AddLine("1")
    AddLine("3")
    AddLine("6")
    AddLine("5")
    AddLine("2")
    AddLine("0")
    AddLine("-0")
    AddLine("5")
    AddLine("6")
    AddLine("8")
    AddLine("3")
    MarkAll()
    Sort(_DECIMAL_)
    UnmarkBlock()
    BegFile()
    if Trim(GetText(1, CurrLineLen())) <> "-0"
        KillLocation()
        return ("Sort(_DECIMAL_) failed -0 test - should be at first line")
    endif

    Down()
    if Trim(GetText(1, CurrLineLen())) <> "0"
        KillLocation()
        return ("Sort(_DECIMAL_) failed 0 test - should be at second line")
    endif
    AbandonFile()
    PopLocation()
    return ("")
end

/*------------------------------------------------------------------------
  Test Sort(_DECIMAL_|_DESCENDING_) vs. -0 and 0
  Given the data below, -0 and 0 should be the last two lines
 ------------------------------------------------------------------------*/
string proc test_sort_decimal_dsc()
    PushLocation()
    NewFile()

    AddLine("1")
    AddLine("3")
    AddLine("6")
    AddLine("5")
    AddLine("2")
    AddLine("0")
    AddLine("-0")
    AddLine("5")
    AddLine("6")
    AddLine("8")
    AddLine("3")
    MarkAll()
    Sort(_DECIMAL_|_DESCENDING_)
    UnmarkBlock()
    EndFile()
    if Trim(GetText(1, CurrLineLen())) <> "-0"
        KillLocation()
        return ("Sort(_DECIMAL_|_DESCENDING_) failed -0 test - should be at last line")
    endif

    Up()
    if Trim(GetText(1, CurrLineLen())) <> "0"
        KillLocation()
        return ("Sort(_DECIMAL_|_DESCENDING_) failed 0 test - should be at next to last line")
    endif
    AbandonFile()
    PopLocation()
    return ("")
end

/*------------------------------------------------------------------------
  Test that descending sorting is stable.
  Lines should be sorted in reverse order, but the line numbers should
  remain in 1..5 order. Mark the "linen" below as a column block. The
  number's to the right should not change order.

  line1       1
  line1       2
  line1       3
  line2       1
  line2       2
  line2       3

  Should end up:

  line2       1
  line2       2
  line2       3
  line1       1
  line1       2
  line1       3

 ------------------------------------------------------------------------*/
string proc test_sort_stable_descending(integer internal)
    constant n = 99, n2 = 99
    integer id, id2, i, j, z, cols, ok
    string s[255], line[20] = "line"
    string tmpfn[_MAX_PATH_] = MakeTempname(temp_path)
    string thesort[255]

    PushLocation()
    id = NewFile()

    for i = 1 to n
        for j = 1 to n2
            AddLine(Format(line, Format(i:Length(Str(n)):"0", "          ", j)))
        endfor
    endfor

    cols = Length(line) + Length(Str(n))
    if internal
        id2 = 0
        MarkColumn(1, 1, n * n2, cols)
        Sort(_DESCENDING_)
    else
        thesort = find_exe("tsort", ".com")
        if thesort == ""
            KillLocation()
            return ("tsort.com not found")
        endif

        SaveAs(tmpfn)
        ok = lDos(thesort, Format("-q -r -+1:", cols; tmpfn; tmpfn), _DONT_CLEAR_|_DONT_PROMPT_|_RETURN_CODE_|_START_HIDDEN_)
        if not ok
            KillLocation()
            return ("Did not run " + thesort)
        endif
        id2 = EditFile(tmpfn)
        EraseDiskFile(tmpfn)
    endif

    BegFile()

    for i = 1 to n
        for j = 1 to n2
            s = GetText(1, CurrLineLen())
            z = val(substr(s, 5))
            if z <> n - i + 1
                KillLocation()
                return (Format("sort-stable-descending: i out of order at ", i * n + j; "Expected:"; j; "but found:"; z))
            endif
            z = val(GetToken(s, " ", 2))
            if z <> j
                KillLocation()
                return (Format("sort-stable-descending: j out of order at ", i * n + j; "Expected:"; i; "but found:"; z))
            endif
            if not Down()
                if i <> n and j <> n2
                    KillLocation()
                    return ("Logic error in sort-stable-descending")
                endif
            endif
        endfor
    endfor
    PopLocation()
    AbandonFile(id)
    if id2 <> 0
        AbandonFile(id2)
    endif
    return ("")
end

/*------------------------------------------------------------------------
  Test that gotomark returns true if the mark is there, false if not
 ------------------------------------------------------------------------*/
string proc test_gotomark()
    integer reset, id, line, cpos, xoff, row
    string bookmark[1] = "z", error[255]

    PushLocation()
    error = ""
    reset = false
    if isBookMarkSet(bookmark)
        GetBookMarkInfo(bookmark, id, line, cpos, xoff, row)
        reset = true
    endif

    DelBookMark(bookmark)
    if GotoMark(bookmark)
        error = "GotoMark on non-existing mark failed - returned true instead of false"
        goto finish
    endif

    PlaceMark(bookmark)
    if not GotoMark(bookmark)
        error = "GotoMark on existing mark failed - returned false instead of true"
        goto finish
    endif

finish:
    if reset
        GotoBufferId(id)
        GotoLine(line)
        ScrollToRow(row)
        GotoPos(cpos)
        GotoXOffset(xoff)
        PlaceMark(bookmark)
    endif

    PopLocation()
    return (error)
end

proc common_sc_prolog(var string fn, var integer id)
    PushLocation()
    EmptyBuffer(Query(CaptureId))
    fn = GetTempPath()
    fn = MakeTempName(fn)
    id = NewFile()
end

proc common_sc_epilog(string fn0, integer id)
    string fn[_MAX_PATH_] = fn0
    PopLocation()
    EmptyBuffer(Query(CaptureId))
    AbandonFile(id)
    PurgeMacro(fn)
    EraseDiskFile(fn + ".s")
    EraseDiskFile(fn + ".mac")
end

/*------------------------------------------------------------------------
sc32 crashed on the following:

#define FOO = 123

proc main()
    MsgBox(FOO)
end

Should generate at least one error:

Compiling...
Error   2204  (1,13)     Unknown operand '='
Error   2302  (1,13)     type mismatch error

 ------------------------------------------------------------------------*/
string proc test_sc_define_bug()
    string fn[_MAX_PATH_] = ""
    integer id = 0

    common_sc_prolog(fn, id)
    AddLine("#define FOO = 123")
    AddLine("proc main()      ")
    AddLine("    MsgBox(FOO)  ")
    AddLine("end              ")
    SaveAs(fn + ".s")

    if not lCapture("sc32", QuotePath(fn + ".s"))
        KillLocation()
        return ("test sc define: lCapture failed to compile define1.s")
    endif

    // in the capture buffer
    BegFile()
    if not lFind("Compiling", "^")
        KillLocation()
        return ("test sc define: did not find 'Compiling' line")
    endif

    if not lFind("Error", "^")
        KillLocation()
        return ("test sc define: did not find first 'Error' line")
    endif

    if not lFind("Error", "^+")
        KillLocation()
        return ("test sc define: did not find second 'Error' line")
    endif

    // clean up

    common_sc_epilog(fn, id)
    return ("")
end

/*------------------------------------------------------------------------
sc32 crashed on the following:

string MACRO_NAME [MAXSTRINGLEN] = ''

menu config_menu()
  title = MACRO_NAME
  '&Enable world peace ...', Warn('World peace enabled!')
end config_menu

proc Main()
  MACRO_NAME = SplitPath(CurrMacroFilename(), _NAME_)
  config_menu()
end Main

Should generate at least one error:

Compiling....
Error   2212  (4,11)     constant string required
.

And DosIOResult() should == 2
 ------------------------------------------------------------------------*/
string proc test_sc_menu_bug()
    string fn[_MAX_PATH_] = ""
    integer id = 0, rc

    common_sc_prolog(fn, id)
    AddLIne("string MACRO_NAME [MAXSTRINGLEN] = ''                    ")
    AddLIne("menu config_menu()                                       ")
    AddLIne("  title = MACRO_NAME                                     ")
    AddLIne("  '&Enable world peace ...', Warn('World peace enabled!')")
    AddLIne("end config_menu                                          ")
    AddLIne("proc Main()                                              ")
    AddLIne("  MACRO_NAME = SplitPath(CurrMacroFilename(), _NAME_)    ")
    AddLIne("  config_menu()                                          ")
    AddLIne("end Main                                                 ")

    SaveAs(fn + ".s")

    if not lCapture("sc32", QuotePath(fn + ".s"))
        KillLocation()
        return ("test sc menu: lCapture failed to compile menu.s")
    endif

    rc = DosIOResult()

    // in the capture buffer
    BegFile()
    if not lFind("Compiling", "^")
        KillLocation()
        return ("test sc menu: did not find 'Compiling' line")
    endif

    if not lFind("Error", "^")
        KillLocation()
        return ("test sc menu: did not find first 'Error' line")
    endif

    if rc <> 2
        KillLocation()
        return ("test sc menu: Expecting rc of 2, but found: " + str(rc))
    endif

    // clean up
    common_sc_epilog(fn, id)
    return ("")
end

/*------------------------------------------------------------------------
sc32 generated bogus code with the following

string proc foo_bad()
  string  c_Command[128] = " Parameter"
  string s[255]
  s = "MacXYZ " + str(42) + c_Command
  return (s)
end

proc main()
    string s[255] = foo_bad()
    Set(MacroCmdLine, iif(s == "MacXYZ 42 Parameter", "true", "false"))
end

 ------------------------------------------------------------------------*/
string proc test_sc_str_bug()
    string fn[_MAX_PATH_] = "", macro_fn[_MAX_PATH_]
    integer id = 0
    string error[255]

    error = ""

    common_sc_prolog(fn, id)
    AddLine('string proc foo_bad()                                                  ')
    AddLine('  string  c_Command[128] = " Parameter"                                ')
    AddLine('  string s[255]                                                        ')
    AddLine('  s = "MacXYZ " + str(42) + c_Command                                  ')
    AddLine('  return (s)                                                           ')
    AddLine('end                                                                    ')
    AddLine('                                                                       ')
    AddLine('proc main()                                                            ')
    AddLine('    string s[255] = foo_bad()                                          ')
    AddLine('    Set(MacroCmdLine, iif(s == "MacXYZ 42 Parameter", "true", "false"))')
    AddLine('end                                                                    ')

    SaveAs(fn + ".s")

    if not lCapture("sc32", QuotePath(fn + ".s"))
        error = "test sc str: lCapture failed to compile define1.s"
        goto cleanup
    endif

    // in the capture buffer
    BegFile()
    if not lFind("Compiling", "^")
        error = "test sc str: did not find 'Compiling' line"
        goto cleanup
    endif

    macro_fn = SplitPath(fn, _DRIVE_|_NAME_)
    if not ExecMacro(macro_fn)
        error = "test sc str: error on execmacro " + macro_fn
        goto cleanup
    endif

    if Query(MacroCmdLine) <> "true"
        error = "test sc str: expected MacroCmdLine to be true, but got: " Query(MacroCmdLine)
    endif

cleanup:
    common_sc_epilog(fn, id)
    return (error)
end

string proc test_special_effects()
    integer special_effects = Query(SpecialEffects)
    integer msg_level = Set(MsgLevel, _NONE_)
    integer all_special = _USE_3D_BUTTONS_|_USE_3D_CHARS_|_DRAW_SHADOWS_|_CENTER_POPUPS_|_SHOW_OEM_CHARS_|_TOP_RT_POPUPS_
    integer cur_max

    Set(SpecialEffects, all_special)
    cur_max = Query(SpecialEffects)
    Set(SpecialEffects, special_effects)
    Set(MsgLevel, msg_level)

    if cur_max <> all_special
        return (Format("Could not set all SpecialEffects values current max:"; cur_max; "wanted:"; all_special))
    endif

    return ("")
end

/*------------------------------------------------------------------------
  Side effect: updates windows clipboard
  30 Aug 2023  Without the delay's, we consistently get open error on the
  windows clipboard
 ------------------------------------------------------------------------*/
string proc test_CopyToWinClip()
    integer id
    string clip_string[15] = "testing winclip", clip_string2[10] = "more stuff"
    string error[80] = ""

    if WhichOS()  == _LINUX_
        return (error)
    endif

    PushLocation()
    PushBlock()
    id = 0

    message("one!!!")
    delay(1)

    if not CopyToWinClip(clip_string)
        error = "test CopyToWinClip() 1 error"
        goto done
    endif
    message("two!!!")
    delay(2)

    if not isWinClipAvailable()
        error = "After CopyToWinClip(string), isWinClipAvailable() failed"
        goto done
    endif
    message("three!!!")
    delay(1)

    id = NewFile()
    if not PasteFromWinClip()
        error = "PasteFromWinClip failed 02"
        goto done
    endif
    if GetText(1, CurrLineLen()) <> clip_string
        error = "CopyToWinClip(string) failed - strings not equal:" + clip_string + ":" + GetText(1, CurrLineLen())
        goto done
    endif
    message("four!!!")
    delay(1)

    EmptyWinClip()
    delay(1)
    if isWinClipAvailable()
        error = "EmptyWinClip failed"
        goto done
    endif
    message("five!!!")
    delay(1)

    BegFile()
    EmptyBuffer()
    InsertText(clip_string2)
    MarkAll()
    if not CopyToWinClip()
        error = "test CopyToWinClip() 2 error"
        goto done
    endif
    delay(1)

    if not isWinClipAvailable()
        error = "After CopyToWinClip(), isWinClipAvailable() failed"
        goto done
    endif
    delay(1)

    EmptyBuffer()
    if not PasteFromWinClip()
        error = "PasteFromWinClip failed 03"
        goto done
    endif

    if GetText(1, CurrLineLen()) <> clip_string2
        error = "CopyToWinClip() failed - strings not equal"
        goto done
    endif

done:
    PopLocation()
    PopBlock()
    if id
        AbandonFile(id)
    endif

    return (error)
end

/*------------------------------------------------------------------------
Context:
After you use TSE's clipboard menu to empty the Windows
clipboard, the Windows clipboard paste options are grayed out.

If you mark a COLUMN block that only contains columns past the
end of a line, and copy it to the Windows clipboard, then TSE's
clipboard menu does not gray out pasting from the Windows
clipboard, but if you select it, then you get a message that the
Windows clipboard is empty.
Given the above context, this is a bug.
  30 Aug 2023  Without the delay's, we consistently get open error on the
  windows clipboard
 ------------------------------------------------------------------------*/
string proc test_CopyToWinClipBug()
    integer id = 0
    string error[80] = ""

    if WhichOS()  == _LINUX_
        return (error)
    endif

    PushLocation()
    PushBlock()
    if not EmptyWinClip()
        error = "CopyWinClipBug: cannot empty win clip"
        goto done
    endif
    Delay(1)
    id = NewFile()
    AddLine()
    AddLine()
    BegFile()
    if lFind(" ", "g")
        error = "CopyWinClipBug: blanks found!"
        goto done
    endif
    // mark columns 10-12  - should not be anything there
    MarkColumn(2, 10, NumLines(), 12)
    if not CopytoWinClip()
        error = "CopyWinClipBug: cannot copy to win clip"
        goto done
    endif
    Delay(2)
    if not isWinClipAvailable()
        error = "CopyWinClipBug: no data in Windows clipboard"
        goto done
    endif
    Delay(1)

    if not PasteFromWinClip()
        error = "CopyWinClipBug: Pasting failed"
        goto done
    endif

done:
    PopLocation()
    PopBlock()
    if id
        AbandonFile(id)
    endif

    return (error)
end

string proc test_StrCount()
    integer n

    // should be 4 a's
    n = StrCount("a", "a bbba bbabb a")
    if n <> 4
        return ("StrCount() failed - got " + str(n) + " but expected 4")
    endif
    return ("")
end

string proc test_StrFind()
    integer n

    n = StrFind("Bobbi", "Her name is Bobbi, not Bobbie")
    if n <> 13
        return ("StrFind() failed - expected 13, got " + str(n))
    endif

    return ("")
end

string proc test_regexnew1()
    integer n
    string saved_wordset[32]

    n = StrFind("\d", "abc5def", "x")
    if n <> 4
        return ("StrFind(\d) failed - expected 4, got " + str(n))
    endif

    n = StrFind("\D", "1234x56", "x")
    if n <> 5
        return ("StrFind(\D) failed - expected 5, got " + str(n))
    endif

    n = StrFind("\s", "12345 6", "x")
    if n <> 6
        return ("StrFind(\s) failed - expected 6, got " + str(n))
    endif

    n = StrFind("\S", "      1 ", "x")
    if n <> 7
        return ("StrFind(\S) failed - expected 7, got " + str(n))
    endif

    // \w and \W use the system wordset - set it here in order to get the correct result
    saved_wordset = set(WordSet, ChrSet("0-9A-Z_a-z"))

    n = StrFind("\w", "!@#$%^&a*()+", "x")
    if n <> 8
        Set(WordSet, saved_wordset)
        return ("StrFind(\w) failed - expected 8, got " + str(n))
    endif

    n = StrFind("\W", "abcdefgh!def", "x")
    if n <> 9
        Set(WordSet, saved_wordset)
        return ("StrFind(\W) failed - expected 9, got " + str(n))
    endif

    // restore system wordset
    Set(WordSet, saved_wordset)

    n = StrFind("\h", "xyzxyzxyzfxy", "x")
    if n <> 10
        return ("StrFind(\h) failed - expected 10, got " + str(n))
    endif

    n = StrFind("\H", "0123456789abcdefxabc", "x")
    if n <> 17
        return ("StrFind(\H) failed - expected 17, got " + str(n))
    endif

    n = StrFind("\p",
    chr(1) + chr(2) + chr(3) + chr(4) + chr(5) + chr(6) + chr(7) + chr(8) + "x" + chr(14) + chr(15), "x")
    if n <> 9
        return ("StrFind(\h) failed - expected 9, got " + str(n))
    endif

    n = StrFind("\P", "abcdefgh!defxyz123!@#$%^&1234", "x")
    if n <> 26
        return ("StrFind(\H) failed - expected 26, got " + str(n))
    endif

    return ("")
end

string proc test_up()
    integer id
    string error[80] = ""

    PushLocation()
    id = NewFile()

    if Up()
        error = "Up failed - was able to go up on line 1"
        goto done
    endif

    AddLine()
    if Up()
        error = "Up failed - was able to go up on line 1"
        goto done
    endif

    AddLine()
    if not Up()
        error = "Up failed - could not go up from line 2"
        goto done
    endif

done:
    PopLocation()
    AbandonFile(id)
    return (error)
end

string proc test_GetStrFromWinClip()
    string s[80] = "Test String to send to WinClip"

    if WhichOS() <> _LINUX_
        if not CopyToWinClip(s)
            return ("test GetStrFromWinClip(): CopyToWinClip(s) failed")
        endif

        if GetStrFromWinClip() <> s
            return ("GetStrFromWinClip() failed: did not match what was put")
        endif
    endif
    return ("")
end

string proc test_LeftStr()
    string s[80] = "this is a test string"

    if LeftStr(s, 4) <> "this"
        return ("LeftStr() 1 failed")
    endif

    if LeftStr(s, 0) <> ""
        return ("LeftStr() 2 failed")
    endif

    if LeftStr(s, length(s) + 100) <> s
        return ("LeftStr() 3 failed")
    endif

    if LeftStr(s, -10) <> ""
        return ("LeftStr() 4 failed")
    endif

    return ("")
end

string proc test_StrReplace()
    string s0[80]
    string s[80] = "this is a test string"
    string s2[80] = "this is a production string"

    // should match new string
    s0 = StrReplace("test", s, "production")
    if s0 <> s2
        return ("StrReplace 1 failed: " + s0)
    endif

    // should not change anything
    s0 = StrReplace("not found", s, "anything")
    if s0 <> s
        return ("StrReplace 1 failed: " + s0)
    endif

    return ("")
end

string proc test_rpos()
    integer n
    string s[80] = "this is a test this is a test"
                  //123456789012345678901234567890
                  //         10        20

    n = rPos("test", s)
    if n <> 26
        return ("rPos 1 failed: expected 26, got: " + str(n))
    endif

    n = rPos("this", s)
    if n <> 16
        return ("rPos 2 failed: expected 16, got: " + str(n))
    endif

    return("")
end

string proc test_SwapLines()
    integer id
    string s1[80] = "line1"
    string s2[80] = "line2"
    string error[80] = ""

    PushLocation()
    id = NewFile()

    AddLine(s1)
    AddLine(s2)
    SwapLines(1, 2)
    BegFile()
    if GetText(1, CurrLineLen()) <> s2
        error = "SwapLines() 1st line not swapped"
        goto done
    endif

    Down()
    if GetText(1, CurrLineLen()) <> s1
        error = "SwapLines() 2nd line not swapped"
        goto done
    endif

    // use a blank line as the first line
    EmptyBuffer()
    AddLine()
    AddLine(s2)

    SwapLines(1, 2)
    BegFile()
    if GetText(1, CurrLineLen()) <> s2
        error = "SwapLines() 2 1st line not swapped"
        goto done
    endif

    Down()
    if GetText(1, CurrLineLen()) <> ""
        error = "SwapLines() 2 2nd line not swapped"
        goto done
    endif

done:
    PopLocation()
    AbandonFile(id)
    return (error)
end

string proc test_NumTokensBug()
    if NumTokens(";;", ";") <> 3
        return ("NumTokens(';;') does not return 3")
    endif
    return ("")
end

/*------------------------------------------------------------------------
  Some times the filemanager crashed when sorting by date
 ------------------------------------------------------------------------*/
string proc test_filemanager_sort()
    string path_sep[1] = GetDirSeparator()

    BufferVideo()
    do 20 times
        PushKey(<Escape>)
        PushKey(<D>)
        PushKey(<O>)
        PushKey(<alt s>)
        ExecMacro(QuotePath(LoadDir() + "mac" + path_sep + "f.mac") + " " + QuotePath(LoadDir() + "ui" + path_sep))
    enddo
    UnBufferVideo()

    BufferVideo()
    do 20 times
        PushKey(<Escape>)
        PushKey(<D>)
        PushKey(<O>)
        PushKey(<alt s>)
        ExecMacro(QuotePath(LoadDir() + "mac" + path_sep + "f.mac") + " " + QuotePath(LoadDir() + "mac" + path_sep))
    enddo
    UnBufferVideo()
    return ("")
end

/*------------------------------------------------------------------------
  Some times the filemanager crashed when sorting the "~\" dir by DTN
 ------------------------------------------------------------------------*/
string proc test_filemanager_sort2()
    string path_sep[1] = GetDirSeparator(), pick_file_sort[32]
    integer pick_file_flags

    pick_file_flags = Set(PickFileFlags, _ADD_DIRS_|_DIRS_AT_TOP_|_ADD_SLASH_)
    pick_file_sort  = Set(PickFileSortOrder, "DTN")

    BufferVideo()
    do 20 times
        PushKey(<Escape>)
        ExecMacro(QuotePath(LoadDir() + "mac" + path_sep + "f.mac") + " ~" + path_sep)
    enddo
    UnBufferVideo()

    Set(PickFileFlags, pick_file_flags)
    Set(PickFileSortOrder, pick_file_sort)
    return ("")
end

string proc test_left()
    integer id, col
    string error[128]

    PushLocation()
    error = ""
    id = NewFile()

    BegLine()
    col = CurrCol()
    if Left()
        error = "Left at beginning of line did not fail"
        goto done
    endif
    if CurrCol() <> col
        error = "Left at beginning of line changed CurrCol()"
        goto done
    endif

    Right()
    col = CurrCol()
    Left()
    if CurrCol() == col
        error = "Left at column 2 did not change CurrCol()"
        goto done
    endif
    if CurrCol() <> 1
        error = "Left at column 2 did not change to column 1"
        goto done
    endif

done:
    PopLocation()
    AbandonFile(id)
    return (error)
end

string proc test_currx()
    integer id, col
    string error[128]

    PushLocation()
    error = ""
    id = NewFile()

    BegLine()
    col = CurrX()
    if CurrX() <> col
        error = "Left at beginning of line changed CurrX()"
        goto done
    endif

    Right()
    col = CurrX()
    Left()
    if CurrX() == col
        error = "Left at column 2 did not change CurrX()"
        goto done
    endif
    if CurrX() <> 1
        error = "Left at column 2 did not change CurrX to 1"
        goto done
    endif

done:
    PopLocation()
    AbandonFile(id)
    return (error)
end
/*------------------------------------------------------------------------

22 Feb 2024 Miguel B. Farah
HOME=%HOMEDRIVE%%HOMEPATH%
HOMEDRIVE=C:
HOMEPATH=\Users\migue

These are not expanded upon reading %HOME%, so the comparison becomes
"%HOMEDRIVE%%HOMEPATH%\" against "C:\Users\migue\" and (unduly) fails.

Note that not few applications recommend setting the HOME variable like
that, to avoid anomalies derived from possible different values between
HOME and HOMEDRIVE+HOMEPATH. The macro should be able to detect and
expand "inner" environment variables.

23 Feb 2024 Carlo Hogeveen
I do not have a "HOME" environment variable, so the test_gethomepath() test fails.
Replacing GetEnvStr("HOME") with GenEnvStr('HOMEDRIVE') +
GetEnvStr('HOMEPATH') would return the expected path on my
system.

 ------------------------------------------------------------------------*/
string proc test_gethomepath()
    string s[255], s2[255]

    s = GetEnvStr("HOME")
    if s == ""
        s = GetEnvStr("HOMEDRIVE") + GetEnvStr("HOMEPATH")
        if s == ""
            return ("")
        endif
    endif

    expand_env_str(s)
    s = AddTrailingSlash(s)

    s2 = GetHomePath()
    if s <> s2
        return ("GetHomePath() <> GetEnvStr('HOME') "+s+ "::" +s2)
    endif
    return ("")
end

/*------------------------------------------------------------------------
  23 Feb 2024 Carlo Hogeveen
  The test_ffisdir() test would try to remove the directory
  "\Windows" instead of the temporary directory it created.
  Luckily I did not run it, although it probably lacks permission
  to do so anyway.
  On Linux it would try to remove the directory "/bin".
  Fixed.
  ------------------------------------------------------------------------
  01 Sep 2024 Carlo Hogeveen
  Contrary to TSE's documentation ChDir() does change a drive.
  A user has a temp path that is not on their Windows drive.
  test_ffisdir() assumed that C:\Windows exists on the same drive
  as the temp path, and in Windows failed the "sys" test incorrectly.
  Fixed.
 ------------------------------------------------------------------------*/
string proc test_ffisdir()
    string temp[255], error[128], cur_dir[255], sys[255]

    error = ""
    cur_dir = CurrDir()

    temp = GetTempPath()
    temp = MakeTempName(temp)
    MkDir(temp)
    ChDir(temp)

    if not FindThisFile(temp)
        error = "test_ffisdir: FindThisFile() failed for: " + temp
        goto done
    endif

    if not FFisDir()
        error = "FFisDir failed for: " + temp
        goto done
    endif


    if WhichOS() == _LINUX_
        sys = GetDirSeparator() + "bin"
    else
        sys = GetEnvStr('windir')
        if sys == ''
            sys = GetEnvStr('SystemRoot')
        endif
    endif

    ChDir(sys)
    if not FindThisFile(sys)
        error = "test_ffisdir: FindThisFile() failed for: " + sys
        goto done
    endif

    if not FFisDir()
        error = "FFisDir failed on: " + sys
        goto done
    endif

done:
    ChDir(cur_dir)
    RmDir(temp)
    return (error)
end

/*------------------------------------------------------------------------
 23 Feb 2024  Carlo Hogeveen
 The test_pbisdir() test also tries to remove the directory "\Windows" or "/bin" instead of the temporary directory it created.
 How rude!
 Fixed.
 ------------------------------------------------------------------------
 01 Sep 2024 Carlo Hogeveen
 The same program error as in test_ffisdir() above.
 Contrary to TSE's documentation ChDir() does change a drive.
 A user has a temp path that is not on their Windows drive.
 test_pbisdir() assumed that C:\Windows exists on the same drive
 as the temp path, and in Windows failed the "sys" test incorrectly.
 Fixed.
 ------------------------------------------------------------------------*/
string proc test_pbisdir()
    string temp[255], error[128], cur_dir[255], sys[255]
    integer id

    PushLocation()
    id = NewFile()
    error = ""
    cur_dir = CurrDir()

    temp = GetTempPath()
    temp = MakeTempName(temp)
    MkDir(temp)
    ChDir(temp)

    if not BuildPickBufferEx(temp, -1)
        error = "test_pbisdir: BuildPickBufferEx() failed for: " + temp
        goto done
    endif

    BegFile()
    if not PBisDir()
        error = "PBisDir failed for: " + temp
        goto done
    endif

    if WhichOS() == _LINUX_
        sys = GetDirSeparator() + "bin"
    else
        sys = GetEnvStr('windir')
        if sys == ''
            sys = GetEnvStr('SystemRoot')
        endif
    endif

    ChDir(sys)

    EmptyBuffer(id)
    if not BuildPickBufferEx(sys, -1)
        error = "test_pbisdir: BuildPickBufferEx() failed for: " + sys
        goto done
    endif

    BegFile()
    if not PBisDir()
        error = "PBisDir failed on: " + sys
        goto done
    endif

done:
    PopLocation()
    ChDir(cur_dir)
    RmDir(temp)
    AbandonFile(id)
    return (error)
end

/*------------------------------------------------------------------------
  02 Mar 2024 GetHistoryStr wipes out the "mark" that find sets, e.g.:
    Find
    GetHistoryStr
    MarkFoundText

    Marks the wrong text.  Verify that it has been fixed.
 ------------------------------------------------------------------------*/
string proc test_gethistorystrbug()
    string error[255]
    integer col_beg, col_end, line

    PushLocation()
    PushBlock()
    Find("main", "gi")
    MarkFoundText()
    col_beg = Query(BlockBegCol)
    col_end = Query(BlockEndCol)
    line    = Query(BlockBegLine)
    GetHistoryStr(_FINDOPTIONS_HISTORY_, 1)
    MarkFoundText()
    if col_beg <> Query(BlockBegCol) or
       col_end <> Query(BlockEndCol) or
       line    <> Query(BlockBegLine)
        error = "gethistorystrbug: GetHistoryStr trashed MarkFoundText"
        goto finished
    endif

finished:
    PopLocation()
    PopBlock()
    return (error)
end

string proc test_copy_get_clipboard()
    CopyToClipboard(hello)
    if GetStrFromClipboard() <> hello
        return ("Either CopyToClipboard or GetStrFromClipboard failed")
    endif
    return ("")
end

/*------------------------------------------------------------------------
  Did not allow cols or rows > 255.

  if cols or rows > 255:
    columns * 65536 + rows
  else
    columns * 256 + rows

  if mode < 65536
    columns = mode / 256
    rows    = mode % 256
  else
    columns = mode / 65536
    rows    = mode % 65536
 ------------------------------------------------------------------------*/
string proc test_startup_video_mode()
    constant c_big_factor = 65536, c_small_factor = 256
    constant c_big_cols = 500, c_big_rows = 400, c_small_cols = 255, c_small_rows = 255
    constant big_screen =   c_big_cols * c_big_factor + c_big_rows
    constant small_screen = c_small_cols * c_small_factor + c_small_rows
    integer save_mode = Query(StartupVideoMode), mode

    Set(StartupVideoMode, big_screen)
    if Query(StartupVideoMode) <> big_screen
        Set(StartupVideoMode, save_mode)
        return ("Failed to set StartupVideoMode to: " + str(big_screen))
    endif

    mode = Query(StartupVideoMode)
    if mode / c_big_factor <> c_big_cols
        Set(StartupVideoMode, save_mode)
        return (Format("StartupVideoMode big cols: expected ", c_big_cols, " but got ", mode / c_big_factor))
    endif

    if mode mod c_big_factor <> c_big_rows
        Set(StartupVideoMode, save_mode)
        return (Format("StartupVideoMode big rows: expected ", c_big_rows, " but got ", mode mod c_big_factor))
    endif

    Set(StartupVideoMode, small_screen)
    if Query(StartupVideoMode) <> small_screen
        Set(StartupVideoMode, save_mode)
        return ("Failed to set StartupVideoMode to: " + str(small_screen))
    endif

    mode = Query(StartupVideoMode)
    if mode / c_small_factor <> c_small_cols
        Set(StartupVideoMode, save_mode)
        return (Format("StartupVideoMode small cols: expected ", c_small_cols, " but got ", mode / c_small_factor))
    endif

    if mode mod c_small_factor <> c_small_rows
        Set(StartupVideoMode, save_mode)
        return (Format("StartupVideoMode small rows: expected ", c_small_rows, " but got ", mode mod c_small_factor))
    endif

    Set(StartupVideoMode, save_mode)
    if Query(StartupVideoMode) <> save_mode
        Set(StartupVideoMode, save_mode)
        return ("Failed to restore StartupVideoMode to: " + str(save_mode))
    endif

    return ("")
end

string proc test_ConFlags()
    constant flags = 0xbeef
    integer save, got
    string error[255] = ""

    save = Set(ConFlags, flags)
    got = Query(ConFlags)
    if got <> flags
        error = format("Could not set ConFlags: expected: ", flags, " got: ", got)
    endif

    set(ConFlags, save)
    return (error)
end

string proc test_CenterFinds()
    integer save = Query(CenterFinds)
    string error[255] = ""

    Set(CenterFinds, off)
    if Query(CenterFinds) <> off
        error = "Could not set CenterFinds off"
        goto finished
    endif

    Set(CenterFinds, on)
    if Query(CenterFinds) <> on
        error = "Could not set CenterFinds on"
        goto finished
    endif

finished:
    Set(CenterFinds, save)
    return (error)
end

string proc test_ThousandsSeparator()
    constant flags = 0xbeef
    integer save, got
    string error[255] = ""

    save = Set(ThousandsSeparator, flags)
    got = Query(ThousandsSeparator)
    if got <> flags
        error = format("Could not set ThousandsSeparator: expected: ", flags, " got: ", got)
    endif

    set(ThousandsSeparator, save)
    return (error)
end

string proc test_wordset()
    string saved_wordset[32]

    saved_wordset = Query(WordSet)
    set(WordSet, ChrSet("#$0-9A-Z_a-z"))
    set(WordSet, saved_wordset)

    saved_wordset = set(WordSet, ChrSet("#$0-9A-Z_a-z"))
    set(WordSet, saved_wordset)

    warn("saved_wordset: ", rWordSet(saved_wordset))
    warn("Wordset after setting: ", rWordSet(query(wordset)))
    warn("Wordset after restoring: ", rWordSet(query(wordset)))
end

/*------------------------------------------------------------------------
23 Feb 2024
1.
I do not have a "HOME" environment variable, so the test_gethomepath() test fails.
Replacing GetEnvStr("HOME") with GenEnvStr('HOMEDRIVE') + GetEnvStr('HOMEPATH') would
return the expected path on my system.
[x]

2.
The test_ffisdir() test would try to remove the directory "\Windows" instead of the
temporary directory it created.

Luckily I did not run it, although it probably lacks permission to do so anyway.
On Linux it would try to remove the directory "/bin".
[x]

3.
The test_pbisdir() test also tries to remove the directory "\Windows" or "/bin" instead of
the temporary directory it created.

How rude!
[x]

4.
The test_editfilebug() test fails if the LoadWildFromInside setting is ON,
because then EditFile('*.*', _DONT_PROMPT_) succeeds
and EditFile("", _DONT_PROMPT_) and EditFile(" ", _DONT_PROMPT_) fail.
I tried three other editors, and none of them loads all files when opening "" or " ", so
in my view the test is wrong, not EditFile().

I suggest saving the setting, turning it off, doing the test, and restoring the setting.

5.
Minor error in test_FileStuff().
The other test procedures create their own test directory if necessary.
test_FileStuff() writes to the current directory and deleted foo.bar.
The test will fail if the current directory is not writable,
which might occur as a user's security precaution or just happen.
[x]

6.
Logic error:
test_GetTempPath() is executed after a lot of other tests have already used it.
It should be the first test.
I would like to see the procedure test if what GetTempPath() returns is a directory and is
writable.
[x]

7.
Minor error in test_gotomark().
By just adding a GotoMark("a") at the start of the procedure, the procedure would not
delete bookmark "a".
[?]

8.
Programming error in test_sc_define_bug().
The 3rd lFind() should use options "^+", otherwise it finds the same error line as the 2nd
lFind().
[x]

Additionally test_sc_define_bug(), test_sc_menu_bug() and test_sc_str_bug() do not clean
up their temporary .s files, and potentially not their .mac files either.
[x]

9.
Nitpicking:
In the test_filemanager_sort() procedure I would expect 4 QuotePath()s.
[x]

Carlo Hogeveen
 ------------------------------------------------------------------------*/

proc main()
    string s[255]

    // do these first
    s = test_GetTempPath()            if s <> "" Warn(s) return () endif KeyPressed()
    s = test_expandpath()             if s <> "" Warn(s) return () endif KeyPressed()
    s = test_FileStuff()              if s <> "" Warn(s) return () endif KeyPressed()
    s = test_SearchPath()             if s <> "" Warn(s) return () endif KeyPressed()

    s = test_gethistorystrbug()       if s <> "" Warn(s) return () endif KeyPressed()

    s = test_capture()                if s <> "" Warn(s) return () endif KeyPressed()
    s = test_CenterFinds()            if s <> "" Warn(s) return () endif KeyPressed()
    s = test_CompareLines()           if s <> "" Warn(s) return () endif KeyPressed()
    s = test_ConFlags()               if s <> "" Warn(s) return () endif KeyPressed()
    s = test_CopyToWinClip()          if s <> "" Warn(s) return () endif KeyPressed()
    s = test_CopyToWinClipBug()       if s <> "" Warn(s) return () endif KeyPressed()
    s = test_copy_get_clipboard()     if s <> "" Warn(s) return () endif KeyPressed()
    s = test_currx()                  if s <> "" Warn(s) return () endif KeyPressed()

    s = test_editfilebug()            if s <> "" Warn(s) return () endif KeyPressed()
    s = test_EditThisFileBug()        if s <> "" Warn(s) return () endif KeyPressed()

    s = test_ffisdir()                if s <> "" Warn(s) return () endif KeyPressed()

    s = test_gethomepath()            if s <> "" Warn(s) return () endif KeyPressed()
    s = test_GetShortPath()           if s <> "" Warn(s) return () endif KeyPressed()
    s = test_GetStrFromWinClip()      if s <> "" Warn(s) return () endif KeyPressed()
    s = test_GetStrXY()               if s <> "" Warn(s) return () endif KeyPressed()
    s = test_gotomark()               if s <> "" Warn(s) return () endif KeyPressed()

    s = test_left()                   if s <> "" Warn(s) return () endif KeyPressed()
    s = test_leftstr()                if s <> "" Warn(s) return () endif KeyPressed()

    s = test_msgbox()                 if s <> "" Warn(s) return () endif KeyPressed()

    s = test_NumHistoryNames()        if s <> "" Warn(s) return () endif KeyPressed()
    s = test_NumTokensBug()           if s <> "" Warn(s) return () endif KeyPressed()

    s = test_pbisdir()                if s <> "" Warn(s) return () endif KeyPressed()

    s = test_regexnew1()              if s <> "" Warn(s) return () endif KeyPressed()
    s = test_rpos()                   if s <> "" Warn(s) return () endif KeyPressed()

    s = test_sc_define_bug()          if s <> "" Warn(s) return () endif KeyPressed()
    s = test_sc_menu_bug()            if s <> "" Warn(s) return () endif KeyPressed()
    s = test_sc_str_bug()             if s <> "" Warn(s) return () endif KeyPressed()
    s = test_sort_decimal_asc()       if s <> "" Warn(s) return () endif KeyPressed()
    s = test_sort_decimal_dsc()       if s <> "" Warn(s) return () endif KeyPressed()
    s = test_sort_stable_descending(false) if s <> "" Warn(s) return () endif KeyPressed()
    s = test_sort_stable_descending(true) if s <> "" Warn(s) return () endif KeyPressed()
    s = test_special_effects()        if s <> "" Warn(s) return () endif KeyPressed()
    s = test_startup_video_mode()     if s <> "" Warn(s) return () endif KeyPressed()
    s = test_state()                  if s <> "" Warn(s) return () endif KeyPressed()
    s = test_StrCount()               if s <> "" Warn(s) return () endif KeyPressed()
    s = test_StrFind()                if s <> "" Warn(s) return () endif KeyPressed()
    s = test_StrReplace()             if s <> "" Warn(s) return () endif KeyPressed()
    s = test_SwapLines()              if s <> "" Warn(s) return () endif KeyPressed()

    s = test_ThousandsSeparator()     if s <> "" Warn(s) return () endif KeyPressed()

    s = test_up()                     if s <> "" Warn(s) return () endif KeyPressed()

    s = test_warn()                   if s <> "" Warn(s) return () endif KeyPressed()

    // takes a while, so do last
    s = test_filemanager_sort()       if s <> "" Warn(s) return () endif KeyPressed()
    s = test_filemanager_sort2()      if s <> "" Warn(s) return () endif KeyPressed()
    s = test_LineNumbers()      if s <> "" Warn(s) return () endif KeyPressed()

    MsgBox("All tests passed")
end

proc WhenLoaded()
    temp_path = GetTempPath()
end
