/*************************************************************************
  RePage      Places page-breaks in current file based on printer settings

  Author:     SemWare

  Date:       Jul 14, 1992 - Initial version (Kevin A. Carr)
              Jan 27, 1994 - Minor enhancements (Kevin A. Carr)

  Overview:

  This macro places formfeed characters (ASCII 12) throughout a file,
  based on the page size.  (The page size is determined by the value
  of the PrintLinesPerPage variable, which can be set from the Print
  Menu, by selecting "Lines Per Page" under "Set Options").  When you
  execute this macro, it pauses on each line where a formfeed should
  go, according to the page size, and places a cursor bar on that
  line.  You can then select that line on which to place the formfeed,
  or move the cursor bar to a previous line in the file to select a
  different line on which to place the formfeed. After you select the
  line for the formfeed, the macro resumes, relative to the location
  of the selected line.

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

string  msg[71] = "  = move, <Enter> = place break, <Escape> = done"
integer page_size, min_line, max_line, cursor_row, PosOfFF = 1

integer proc mDown()
    PosOfFF = 1
    if CurrRow() < cursor_row
        return (Down())
    endif
    if CurrRow() > cursor_row
        ScrollToRow(cursor_row)
    endif
    return (RollDown())
end

integer proc mUp()
    PosOfFF = 1
    if CurrRow() > cursor_row
        return (Up())
    endif
    return (iif(RollUp(), TRUE, Up()))
end

proc UpdateMsg()
    Message('L ',CurrLine(),' Lines ', CurrLine() - min_line, msg)
end UpdateMsg

integer proc CheckForFormfeed()
    integer rc = FALSE

    if lFind(Chr(12), "gc")
        PosOfFF = CurrPos()
        lReplace(Chr(12),"","gcn")
        rc = TRUE
    endif

    return (rc)
end CheckForFormfeed

proc GotoNextPageBreak()
    repeat
        if not mDown()
            max_line = CurrLine()
        endif
        UpdateDisplay(_REFRESH_THIS_ONLY_|_CLINE_REFRESH_)
        UpdateMsg()
    until CheckForFormfeed() or CurrLine() == max_line
end GotoNextPageBreak

proc EnterKey()
    GotoPos(PosOfFF)
    InsertText(Chr(12),_INSERT_)
    BegLine()
    if CurrLine() < NumLines()
        min_line = CurrLine()
    endif
    max_line = min_line + page_size
    GotoNextPageBreak()
end EnterKey

proc CursorDownKey()
    if CurrLine() < max_line
        mDown()
        CheckForFormfeed()
    endif
end CursorDownKey

proc CursorUpKey()
    if CurrLine() > min_line
        mUp()
    endif
end CursorUpKey

proc mDelLine()
    PosOfFF = 1
    DelLine()
    CheckForFormfeed()
    UpdateDisplay()
end

proc Main()
    integer cline_attr = Query(CursorAttr),
            text_attr = Query(TextAttr),
            eq_enhkbd = Set(EquateEnhancedKbd,TRUE),
            msg_level = Set(MsgLevel,_NONE_)

    page_size = Query(PrintLinesPerPage)
                - (Query(PrintTopMargin) + Query(PrintBotMargin))
                - iif(Query(PrintHeader) <> "",2,0)
                - iif(Query(Printfooter) <> "",2,0)

    if page_size < 1
        Alarm()
        Warn('Must have a "Page Size" set to RePaginate')
        goto done
    endif

    min_line = 1
    max_line = page_size + 1

    cursor_row = (Query(WindowRows) * 2) / 3

    // set cursor line to inverse of text line
    Set(CursorAttr, ((text_attr & 0x07) shl 4) | ((text_attr & 0x70) shr 4))

    PushBlock()
    UnmarkBlock()

    UpdateDisplay(_ALL_WINDOWS_REFRESH_)

    BegFile()

    GotoNextPageBreak()

    UpdateMsg()

    loop
        UpdateDisplay(_REFRESH_THIS_ONLY_|_CLINE_REFRESH_)
        UpdateMsg()
        label_to_skip_update:
        case GetKey()
            when <escape>               break
            when <enter>                EnterKey()
            when <escape>               EndProcess()
            when <cursordown>           CursorDownKey()
            when <cursorup>             CursorUpKey()
            when <ctrl d>               mDelLine()
            otherwise
                goto label_to_skip_update
        endcase
    endloop

    done:

    PopBlock()
    Set(CursorAttr,cline_attr)
    Set(EquateEnhancedKbd,eq_enhkbd)
    Set(MsgLevel,msg_level)
    UpdateDisplay(_ALL_WINDOWS_REFRESH_)
    Message("RePaginate Complete")
end

