/**************************************************************************
  quote cmt         - inserts a comment box
  quote quote       - always quote/comment line/block
  quote             - toggle quote/comment line/block

  June 10, 1997 GDB Lowercase extension for systems supporting mixed case filenames.
  Sep  10, 1997 SEM Add Java support
  Aug  16, 1998 SEM Add Euphoria support
  Sep  15, 1998 SEM Add Perl support
  Mar  20, 2001 SEM Add Tex, vbs, inf, and others, thanks to Bill Stewart
                and R.A.G. Seely
  Mar  30, 2002 SEM Additional Tex support, thanks to Sjoerd Rienstra
  October 2003 Greg Macdonald - Add C# support
  October 2003 Hans-Peter Groezinger - Add xBase support
  January 2004 Shane Brinkman-Davis - Add .hpp extension.
  February 2004 SEM - convert to using .syn file info
  December 2013 SEM - fix unquote to only delete if quote/cmt chars there
  February 2018 SEM - insert comment at first non white
  July     2018 SEM - revert Febuary change
 **************************************************************************/

string box_char[] = '-' // '*' also works

proc QuoteLine(string c1, string c2)
    BegLine()
    InsertText(c1, _INSERT_)
    if Length(c2)
        EndLine()
        InsertText(c2)
    endif
end

integer proc compare_del(string cmt)
    if GetText(CurrPos(), Length(cmt)) == cmt
        DelChar(Length(cmt))
        return (true)
    endif
    return (false)
end

proc UnQuoteLine(string c1, string c2)
    GotoPos(PosFirstNonWhite())
    if compare_del(c1)
        GotoPos(CurrLineLen() - Length(c2) + 1)
        compare_del(c2)
    endif
end

/**************************************************************************
  Default to '>'
 **************************************************************************/
proc comment(integer always_quote)
    integer block = isCursorInBlock()
    string s1[64]="", s2[64]=""

    GetSynToEol(s1)
    if s1 <> ""
        s2 = ""
        if isAlphaNum(s1[Length(s1)])
            s1 = s1 + ' '
        endif
    else
        GetSynMultiLnDlmt(s1, s2)
        if s1 <> "" and s2 <> ""
            if isAlphaNum(s1[Length(s1)]) or isAlphaNum(s2[Length(s2)])
                s1 = s1 + ' '
                s2 = ' ' + s2
            endif
        endif
    endif

    if s1 == ""
        s1 = ">"
        s2 = ""
    endif

    PushPosition()
    PushBlock()
    if block
        GotoBlockBegin()
    endif
    repeat
        if always_quote or GetText(PosFirstNonWhite(), Length(s1)) <> s1
            QuoteLine(s1, s2)
        else
            UnQuoteLine(s1, s2)
        endif
    until not block or not Down() or not isCursorInBlock()
    PopPosition()
    PopBlock()
    if not block
        Down()
    endif
end

/**************************************************************************
  Insert a comment box (like this one) at the current position
 **************************************************************************/
proc box_cmt()
    string s1[64]="", s2[64]="", c[1], c1[255]="", c2[255]="", c3[64]=""

    c = box_char
    c3 = ""
    GetSynMultiLnDlmt(s1, s2)
    if s1 <> "" and s2 <> ""
        if (Length(s1) > 1 and Length(s2) > 1) and
                (s1[Length(s1)] == s2[Length(s2)]) and
                (not isAlphaNum(s1[Length(s1)]))
            c = s1[Length(s1)]
        endif

        if isAlphaNum(s1[Length(s1)]) or isAlphaNum(s2[Length(s2)])
            s1 = s1 + ' '
            s2 = ' ' + s2
        endif

        c1 = Format(s1, c:72:c)
        c2 = Format(" ", c:72:c, s2)
    else
        GetSynToEol(s1)
        if s1 <> ""
            if Length(s1) > 1 and not isAlphaNum(s1[Length(s1)])
                c = s1[Length(s1)]
            endif

            if isAlphaNum(s1[Length(s1)])
                s1 = s1 + ' '
            endif

            c1 = Format(s1, c:72:c)
            c2 = c1
            c3 = s1
        endif
    endif

    if c1 <> ""
        BegLine()
        if PosFirstNonWhite() == 0
            InsertText(c1)
        else
            InsertLine(c1)
        endif
        AddLine(c3)
        AddLine(c2)
        Up()
        BegLine()
        EndLine()
        Right(2)
    endif
end

proc main()
    case Lower(Query(MacroCmdLine))
        when "quote"
            comment(TRUE)
        when "cmt"
            box_cmt()
        otherwise
            comment(FALSE)
    endcase
end

