/*************************************************************************
  QuickXit    Quick Exit - prompt for saving or abandoning all changed files

  Author:     SemWare

  Date:       1992 Initial version (taken from Brief.ui)
              May 14, 1998 - Use "do n times" in lieu of while loop.

  Overview:

  An alternative way of exiting the editor.  If no changed files just
  exit.  Otherwise, give the user the choice of either canceling the
  command, quitting the editor without saving the files, or save all
  changed files and then quit the editor.

  Keys:     (none)


  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

proc mAbandonEditor()
    ExecHook(_ON_EXIT_CALLED_)
    AbandonEditor()
end

menu ExitMenu()
    "&Save Changed Files Then Exit",         SaveAllAndExit()
    "&Quit Without Saving Changed Files",   mAbandonEditor()
    "&Prompt on Each Changed File",          Exit()
    "&Cancel"
end

proc main()
    integer start_file = GetBufferId(),
        n = NumFiles() + (BufferType() <> _NORMAL_),
        changed = 0

    do n times
        if FileChanged()
            changed = changed + 1
        endif
        NextFile(_DONT_LOAD_)
    enddo
    GotoBufferId(start_file)
    if changed == 0
       mAbandonEditor()
    else
        ExitMenu(Str(changed) + " File(s) Have Not Been Saved")
    endif
end

