/*************************************************************************
lineupdn    Move a line or block up or down.

            Overview:

            This macro allows one to move the current line up or down.
            Additionally, if the cursor is in a marked block, the block moves up
            or down.

            Keys:

                <f7>    moves a line or block up
                <f8>    moves a line or block down

            Usage notes:

            To activate this macro, simply select it from the Potpourri menu.
            Then use the appropriate keys.

            To have it always available, autoload it - Macro, Autoload List.

  Author: SemWare, 2020
 *************************************************************************/
// On entry, marking is off
proc fix_includes_eol(integer blocktype)
    if not blocktype in _NONINCLUSIVE_, _INCLUSIVE_
        return ()
    endif

    if Query(BlockBegLine) == Query(BlockEndLine)
        if Query(BlockEndCol) == MAXLINELEN
            if blocktype == _NONINCLUSIVE_
                GotoPos(Query(BlockBegCol))
                MarkBlockBegin()
                EndLine()
                MarkBlockEnd()
                return ()
            endif
        endif

        if Query(BlockEndCol) > CurrLineLen()
            GotoPos(Query(BlockBegCol))
            MarkBlockBegin()
            EndLine()
            MarkBlockEnd()
            return ()
        endif
    endif

//    warn(Query(BlockBegLine);
//         Query(BlockEndLine);
//         Query(BlockBegCol);
//         Query(BlockEndCol);
//         CurrLineLen();
//         MAXLINELEN)
end

proc move_up()
    integer marking, ilba

    if CurrLine() <= 1
        return ()
    endif

    if not isCursorInBlock()
        swaplines(CurrLine() - 1, CurrLine())
        Up()
        return ()
    endif

    marking = Set(Marking, off)
    ilba = Set(InsertLineBlocksAbove, On)
    PushLocation()

    if isCursorInBlock() <> _LINE_
        GotoColumn(Query(BlockBegCol))
    endif

    GotoLine(Query(BlockBegLine))

    Up()
    MoveBlock()

    PopLocation()
    Up()
    Set(InsertLineBlocksAbove, ilba)
    Set(Marking, marking)

end

proc move_down()
    integer marking, ilba

    if CurrLine() >= NumLines()
        return ()
    endif

    if not isCursorInBlock()
        swaplines(CurrLine(), CurrLine() + 1)
        Down()
        return ()
    endif

    marking = Set(Marking, off)
    ilba = Set(InsertLineBlocksAbove, Off)
    PushLocation()

    if isCursorInBlock() <> _LINE_
        fix_includes_eol(isBlockMarked())
        GotoColumn(Query(BlockBegCol))
    endif

    if isCursorInBlock() == _COLUMN_
        GotoLine(Query(BlockBegLine))
    else
        GotoLine(Query(BlockEndLine))
    endif

    Down()
    MoveBlock()

    PopLocation()
    Down()
    Set(InsertLineBlocksAbove, ilba)
    Set(Marking, marking)
end

<f7> move_up()
<f8> move_down()
