/*************************************************************************
  FindEOL     Macros to find and replace text that include the end of line

  Author:     SemWare

  Date:       May 27, 1994 - Initial version

  Overview:

  This macro file provides a group of macros that allow you to find
  and replace text that includes the end of line, if you specify the
  end of line (as "$") in the search string.  These macros are useful
  for locating a text string that begins on one line, and ends on
  another.  They are also useful for such tasks as:

     Deleting extra blank lines in a file

      For example, to change all occurrences of 2 blank lines to a
      single blank line, use this macro to search for "$$$" and
      replace with "$$".

     Removing trailing text from certain lines

      For example, to remove a trailing comma from any lines
      immediately followed by a blank line, use this macro to search
      for ",$$" and replace with "$$".

  When you execute this macro file, special find, replace, and repeat
  find/replace macros are assigned to keys.  A message is displayed to
  identify the key to which each macro is assigned.

  Keys:
     <AltShift F>  FindReplaceEol(TRUE)   // Find only
     <AltShift R>  FindReplaceEol(FALSE)  // Find and Replace
     <AltShift L>  RepeatFindReplaceEol() // RepeatFind

  Usage notes:

  There are a few limitations to this macro:

    1 - Does not support regular expressions.
    2 - Search string cannot be a single '$'.
    3 - When lines are joined by replacing the '$' with nothing,
        the resulting line must be less than the max line length.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

constant FIND_CMD = 0, REPLACE_CMD = 1

integer pp, find_history, replace_history, last_cmd
string afindstr[80], areplacestr[80]


proc mPushP()
    PushPosition()
    pp = pp + 1
end

proc mPopP(integer n)
    while pp > n
        PopPosition()
        pp = pp - 1
    endwhile
end

integer proc FixUp(string c, var string s, var string a)
    integer i, p, len = Length(s)

    p = 0
    i = 1
    while i <= len
        if s[i] == c[1]
            a = a + Chr(i - p)
            p = i
            //s[i] = Chr(13)
            s = SubStr(s, 1, i - 1) + Chr(13) + SubStr(s, i + 1, 255)
        endif
        i = i + 1
    endwhile
    if s[Length(s)] <> Chr(13)
        a = a + Chr(i - p - 1)
    endif
    return (Length(a))
end

integer proc FindReplaceEol2(integer find_only)
    string findstr[80], replacestr[80], finda[12], replacea[12],
        s[80], forced_opt[10]
    integer num_find_str, num_replace_str, starting_pos, n,
        last_findstr_eol, one_found, replacements, y, find_anchor, prompt,
        only

    Set(Break, on)
    PushBlock()
    y = CurrRow()
    if y < Query(WindowRows) / 2
        y = Query(WindowRows) / 2
    endif
    pp = 0
    replacements = 0
    one_found = FALSE   only = FALSE
    prompt = TRUE
    finda = ''  replacea = ''
    findstr = afindstr
    replacestr = areplacestr

    last_findstr_eol = findstr[Length(findstr)] == '$'
    find_anchor = findstr[1] == '$'
    if find_anchor
        findstr = SubStr(findstr, 2, Length(findstr) - 1)
        if replacestr[1] == '$'
            replacestr = SubStr(replacestr, 2, Length(replacestr) - 1)
        endif
    endif

    num_find_str = FixUp('$', findstr, finda)
    num_replace_str = FixUp('$', replacestr, replacea)

    mPushP()

    loop
        starting_pos = 1
        n = 1
        loop
            s = SubStr(findstr, starting_pos, Asc(finda[n]))
            starting_pos = starting_pos + Length(s)
            forced_opt = ''
            if s[Length(s)] == Chr(13)
                forced_opt = '$'
                s = SubStr(s, 1, Length(s) - 1)
            endif

            if find_anchor or n > 1
                forced_opt = forced_opt + '^'
            endif

            if Length(s) == 0
                forced_opt = 'x'
            endif

            if n > 1
                forced_opt = forced_opt + 'l'
                MarkLine()
                MarkLine()
            endif

            if iif(Length(s), lFind(s, "i" + forced_opt), lFind("^$", forced_opt))
                if n == num_find_str    // if last one, then Found!
                    mPopP(1)
                    break
                endif
                if n == 1               // If first substring
                    mPushP()            // save place
                endif

                if not Down()           // Otherwise, if at eof,
                    goto not_found      // exit
                endif
                BegLine()               // Reposition
                n = n + 1               // use next substring
            else
                if n == 1
                    goto not_found
                else
                    mPopP(1)
                    EndLine()
                    if not NextChar()
                        not_found:

                        mPopP(iif(find_only, 1, 0))
                        PopBlock()
                        if one_found
                            if not find_only
                                Message(replacements, " replacements made")
                            endif
                        else
                            Warn("Not found:", afindstr)
                        endif
                        return (one_found)
                    endif
                    n = 1
                    starting_pos = 1
                endif
            endif
        endloop

        one_found = TRUE
        UnmarkBlock()
        ScrollToRow(y)

        if prompt
            UpdateDisplay()
            VGotoXY(WhereX(), WhereY())
            PutAttr(Query(HiLiteAttr), Query(WindowCols) - CurrCol() - CurrXOffSet() + 1)
            if find_only
                goto not_found
            endif
            Message("Replace (Yes/No/Rest/Only/Quit)?")
            VGotoXY(WhereX(), WhereY())
            case GetKey()
                // when <y>, <shift y>
                when <n>, <shift n>
                    goto end_main_loop
                when <Escape>, <q>, <shift q>
                    goto not_found
                when <o>, <shift o>
                    only = TRUE
                when <r>, <shift r>
                    prompt = FALSE
            endcase
        endif

        //UpdateDisplay() //$$$
        //Warn("Found at ", CurrLine())

        // Concat the lines
        if find_anchor
            Up()
            EndLine()
            InsertText(Chr(13))
            JoinLine()
            Left()
        endif

        PushPosition()
        MarkChar()

        n = num_find_str - 1
        while n
            EndLine()
            InsertText(Chr(13))
            JoinLine()
            n = n - 1
        endwhile

        EndLine()
        if last_findstr_eol
            InsertText(Chr(13))
            JoinLine()
        endif

        MarkChar()

        PopPosition()

        //UpdateDisplay() //$$$
        //Warn("Replacing")

        lReplace(findstr, replacestr, "1i")
        GotoBlockEnd()

        //UpdateDisplay() //$$$
        //Warn("Replaced")

        PushPosition()
        UnmarkBlock()
        MarkLine()
        MarkLine()
        while lFind(Chr(13), "gl")
            DelChar()
            SplitLine()
        endwhile

        //UpdateDisplay() //$$$
        //Warn("Joined")

        PopPosition()
        replacements = replacements + 1

        end_main_loop:
        if only
            goto not_found
        endif
        if num_find_str <= num_replace_str and not NextChar()
            goto not_found
        endif
    endloop
    return (FALSE)
end

proc FindReplaceEol(integer find_only)
    if Ask("Find ('$' for eol):", afindstr, find_history) and Length(afindstr)
            and afindstr <> '$' and
            (find_only or
            (Ask("Replace ('$' for eol):", areplacestr, replace_history) and
            Length(areplacestr)))
        FindReplaceEol2(find_only)
    endif
end

proc RepeatFindReplaceEol()
    if Length(afindstr) == 0
        FindReplaceEol(TRUE)
    else
        NextChar()
        if not FindReplaceEol2(last_cmd <> REPLACE_CMD)
            PrevChar()
        endif
    endif
end

proc WhenLoaded()
    find_history = GetFreeHistory("FindEOL:Find")
    replace_history = GetFreeHistory("FindEOL:Replace")
    last_cmd = FIND_CMD
end

proc WhenPurged()
    DelHistory(find_history)
    DelHistory(replace_history)
end

<AltShift r>   FindReplaceEol(FALSE)
<AltShift f>   FindReplaceEol(TRUE)
<AltShift l>   RepeatFindReplaceEol()
