integer proc is_blank_line()
    return (PosFirstNonWhite() == 0)
end

/*************************************************************************
  Delete blank lines around the current line, including the
  current line, if it is blank.
 *************************************************************************/
public proc DelBlankLines()
    // delete blank lines before the current line
    PushPosition()
    while Up() and is_blank_line()
        KillLine()
    endwhile
    PopPosition()
    // delete blank lines after the current line
    PushPosition()
    while Down() and is_blank_line()
        KillLine()
    endwhile
    PopPosition()
    // delete the current line, if blank
    if is_blank_line()
        KillLine()
    endif
end

/*************************************************************************
  Delete white-space around the cursor position
 *************************************************************************/
public proc DelWhiteSpace()
    if CurrPos() <= CurrLineLen()
        // delete white-space before the cursor
        PushPosition()
        while Left() and isWhite()
            DelChar()
        endwhile
        PopPosition()
        // delete white-space after the cursor
        if CurrPos() < CurrLineLen()
            PushPosition()
            if Right()
                while CurrPos() <= CurrLineLen() and isWhite()
                    DelChar()
                endwhile
            endif
            PopPosition()
        endif
        // delete white-space at the cursor
        if isWhite()
            DelChar()
        endif
    endif
end


