/*************************************************************************
  Date        Inserts current date (format includes Month spelled out)

  Author:     Mel Hulse

  Date:       Apr 23, 1993 - Initial version

  Overview:

  This macro inserts the current date with the full name of the month
  and a 4-digit year.  The format is as follows:

                    January 27, 1994.

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

*************************************************************************/

proc Main()
    integer mon, day, year, dow
    string  month_name[9] = ''

    GetDate(mon, day, year, dow)    // get current date
    case mon
        when  1 month_name = 'January'
        when  2 month_name = 'February'
        when  3 month_name = 'March'
        when  4 month_name = 'April'
        when  5 month_name = 'May'
        when  6 month_name = 'June'
        when  7 month_name = 'July'
        when  8 month_name = 'August'
        when  9 month_name = 'September'
        when 10 month_name = 'October'
        when 11 month_name = 'November'
        when 12 month_name = 'December'
    endcase
    InsertText(Format(month_name,' ',day,', ',year))
end

