/************************************************************************
  Capture the output of DOS commands.

  If filelocking is on, then the edited file can not simply be erased with
  the EraseDiskFile() command, since the file will be locked.  In order to
  accomplish this, we use the KillFile() command, which will erase a locked
  file.  Since KillFile() also sets the changed flag, we turn off the change
  flag with FileChanged().

  June 2007 SEM:  Show the current directory in the prompt.
    Thanks to Fred Holmes for the suggestion.

  April 2007 SEM: Bug fix to capture buffer creation.  Reported
    by Jose Adriano Baltieri.  Thanks to Harald Mezger for
    suggested code improvements.

  April 2007 SEM
    Allow the command to be captured to be passed on the command line

  March 2004 SEM
    Changed to use a single output buffer, as suggested by Peter Devine.

  June 2003 SEM
    Insert the typed command at the beginning of the buffer

  May 24, 2000 SEM
    Use Windows temp path, instead of current location.

  Jan 9, 1998
    KSW: Need to quote the filename if it contains spaces.
 ***********************************************************************/

string proc TempPath()
    string dir[_MAXPATH_]

    dir = GetEnvStr("TEMP")
    if dir == ""
        dir = GetEnvStr("TMP")
        if dir == ""
            dir = CurrDir()
        endif
    endif
    return (MakeTempName(dir))
end

string capture_buffer[] = "*capture buffer*"

proc get_cmd(var string cmd)
    cmd = Query(MacroCmdLine)
end

proc main()
    string fn[_MAXPATH_], cmd[_MAXPATH_] = ""
    integer cap_buf, n

    get_cmd(cmd)
    if cmd <> "" or Ask("OS command capture: [" + CurrDir() + "]",
            cmd, GetFreeHistory("CAP:cmd"))

        cap_buf = GetBufferId(capture_buffer)
        if cap_buf
            n = NumWindows()
            do n times
                if CurrFilename() == capture_buffer
                    break
                endif
                NextWindow()
            enddo
            if CurrFilename() <> capture_buffer
                HWindow()
            endif
            GotoBufferId(cap_buf)
        else
            HWindow()
            if not CreateBuffer(capture_buffer)
                Warn("Could not create capture buffer")
                return ()
            endif
        endif

        fn = QuotePath(TempPath())
        Dos(Format(cmd, ">", fn), _DONT_PROMPT_|_TEE_OUTPUT_)

        EndFile()
        if PosFirstNonWhite() <> 0
            AddLine()
        endif
        AddLine(cmd)
        AddLine()
        PushBlock()
        InsertFile(fn)
        PopBlock()
        EndFile()
        FileChanged(FALSE)
        EraseDiskFile(fn)
        ExecHook(_ON_CHANGING_FILES_)
    endif
end

