/************************************************************************
  ASCII       Alternate ASCII chart

  Author:     SemWare

  Date:       June 1992   - Initial version (Steve Watkins)
              March 1993  - Get ready for prime time

  Overview:

  This ASCII chart provides additional information for characters 0
  thru 31.

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

Datadef ASCIIData
    "   0  00  "+chr(0)+"  ^@  NUL Null"
    "   1  01    ^A  SOH Start of Header"
    "   2  02    ^B  STX Start of Text"
    "   3  03    ^C  ETX End of Text"
    "   4  04    ^D  EOT End of Transmission"
    "   5  05    ^E  ENQ Enquiry"
    "   6  06    ^F  ACK Acknowledge"
    "   7  07    ^G  BEL Bell"
    "   8  08    ^H  BS  BackSpace"
    "   9  09  "+chr(9) +"  ^I  HT  Horizontal Tab"
    "  10  0A  "+chr(10)+"  ^J  LF  Line Feed"
    "  11  0B    ^K  VT  Vertical Tab"
    "  12  0C    ^L  FF  Form Feed"
    "  13  0D  "+chr(13)+"  ^M  CR  Carriage Return"
    "  14  0E    ^N  SO  Shift Out"
    "  15  0F    ^O  SI  Shift In"
    "  16  10    ^P  DLE Data Link Escape"
    "  17  11    ^Q  DC1 Device Control 1"
    "  18  12    ^R  DC2 Device Control 2"
    "  19  13    ^S  DC3 Device Control 3"
    "  20  14    ^T  DC4 Device Control 4"
    "  21  15    ^U  NAK Negative Acknowledge"
    "  22  16    ^V  SYN Synchronous Idle"
    "  23  17    ^W  ETB End Transmission Block"
    "  24  18    ^X  CAN Cancel"
    "  25  19    ^Y  EM  End of Medium"
    "  26  1A    ^Z  SUB Substitute"
    "  27  1B    ^[  ESC Escape"
    "  28  1C    ^\  FS  File Separator"
    "  29  1D    ^]  GS  Group Separator"
    "  30  1E    ^^  RS  Record Separator"
    "  31  1F    ^_  US  Unit Separator"
end

integer ASCII_id

proc CreateASCIIFile()
    integer i

    PushPosition()
    if CreateTempBuffer()
        ASCII_id = GetBufferId()
        PushBlock()
        InsertData(ASCIIData)
        GotoBlockEnd()
        PopBlock()
        EndLine()
        JoinLine()
        i = 32
        while AddLine(format(i:4, str(i, 16):4, chr(i):3)) and i < 255
            i = i + 1
        endwhile
    endif
    PopPosition()
end

proc AsciiChart()
    integer ok, c, d

    if ASCII_id == 0
        CreateASCIIFile()
    endif
    if (ASCII_id)
        c = CurrChar()
        PushPosition()
        GotoBufferId(ASCII_id)
        BegFile()
        if c >= 0
            GotoLine(c + 1)
        endif

        d = GetOutputDriver()
        //SetOutputDriver(_DRIVER_BMPFONT_)
        ok = list("Dec Hex Chr     Description               ", 44)
        SetOutputDriver(d)

        c = CurrLine() - 1
        PopPosition()
        if ok
            InsertText(chr(c))
        endif
    endif
end

proc WhenPurged()
    AbandonFile(ASCII_id)
end

proc Main()
    AsciiChart()
end

// <Ctrl A> ASCIIChart()
