/*************************************************************************
  Align       Aligns current line with previous line, or at cursor position

  Author:     SemWare

  Date:       Apr 23, 1993 - Initial version (Sammy Mitchell)

  Overview:

  Align() positions the FirstNonWhite character on the current line to
  the same position of the FirstNonWhite character on the previous
  line or the first preceding non-blank line.  The cursor will then be
  moved to the next line in the file.

  AlignAtCursor() positions the FirstNonWhite character on the current
  line to the cursor position.  The cursor will then be moved to the
  next line in the file.

  Keys:
            <Ctrl F5>       Align()
            <Ctrl F6>       AlignAtCursor()

  Usage notes:

  If the current line is blank, the cursor will still go to the next
  line of the file, but no alignment will occur.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

// TSE Jr-type align command
// Align the current line with the indentation of a previous line.
// Would be _much_ simpler if we didn't have to account for hard tabs!
// After aligning the current line, the cursor moves to the next line.
proc Align()
    string text[128]
    integer p = CurrPos()

    PushPosition()
    BegLine()
    if PosFirstNonWhite() and PrevChar() and lFind("[~ \t\x00\xff]","xb")
        text = GetText(1, PosFirstNonWhite() - 1)
        PopPosition()
        PushPosition()
        BegLine()
        DelChar(PosFirstNonWhite() - 1)
        InsertText(text, _INSERT_)
    endif
    PopPosition()
    GotoPos(p)
    Down()
end

// Shift text on the current line so as to be aligned with the cursor,
// for instance, move the cursor to the desired column, press the key
// this command is assigned to, and the text will be shifted such that
// it lines up with the cursor.
// After aligning the current line, the cursor moves to the next line.
proc AlignAtCursor()
    integer p = CurrPos()

    if PosFirstNonWhite()
        ShiftText(CurrPos() - PosFirstNonWhite())
    endif
    GotoPos(p)
    Down()
end

proc main()
    Align()
end

<Ctrl F5>       Align()
<Ctrl F6>       AlignAtCursor()
