Rem file: Stree.bas - QB64 Utility v2.0a PD 2025.

' default integer variables
DefInt A-Z
Rem $Dynamic
_Title "STREE"

' define boolean values
Const True = -1
Const TrueD = -1#
Const False = 0
Const FalseD = 0#
Const FalseS = 0!
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Magenta = 12
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' declare date\time variables
Dim Shared Creation.Time As Integer
Dim Shared Access.Time As Integer
Dim Shared Modified.Time As Integer
Dim Shared Search.From.Date As Single
Dim Shared Search.To.Date As Single
Dim Shared Search.From.Time As Single
Dim Shared Search.To.Time As Single

' declare work variables
Dim Shared Search.Archive As Integer
Dim Shared Search.Hidden As Integer
Dim Shared Search.Readonly As Integer
Dim Shared Search.System As Integer
Dim Shared Search.Compressed As Integer
Dim Shared Search.Encrypted As Integer

Dim Shared Recurse.Directories As Integer
Dim Shared Attribute As _Unsigned Long
Dim Shared Extended.List As Integer
Dim Shared Display.Errors As Integer
Dim Shared Continuous.Display As Integer
Dim Shared Directories.Counted As Single
Dim Shared Display.Lines As Integer
Dim Shared Display.Lowercase As Integer
Dim Shared Drive.Search As String * 1
Dim Shared Current.Drive As String * 1
Dim Shared Nested.Levels As Integer
Dim Shared Nested.Recurse As Integer
Dim Shared Short.Filenames As Integer
Dim Shared Short.Display As Integer
Dim Shared Wide.Display As Integer
Dim Shared Display.Length As Integer
Dim Shared Truncate.Slash As Integer
Dim Shared Strip.Drive As Integer
Dim Shared Length As Integer
Dim Shared Quit.Searching As Integer
Dim Shared More.Display As Integer
Dim Shared Append.Slash As Integer
Dim Shared Current.Directory As String
Dim Shared Wide.Display2 As Integer

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer

' declare library constants.
Const MAX_PATH = 260
Const INVALID_HANDLE_VALUE = -1

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

' declare external libraries.
Declare Dynamic Library "kernel32"
   Function FindFirstFileA~%& (ByVal lpFileName~%&, ByVal lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, ByVal nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, ByVal nFileSystemNameSize&)
   Function SetCurrentDirectoryA% (f$)
End Declare

Declare Library
   Function GetDriveType& (d$)
   Function GetModuleFileNameA (ByVal Module As Long, FileName As String, ByVal nSize As Long)
End Declare

' declare library variables.
Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String

' declare standard error trap
On Error GoTo Error.Routine

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
If Command$ = "/?" Then
   GoSub Boot.Usage
   End
End If

' command line input loop
Command.Line = LTrim$(RTrim$(Read.Command$))
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset counters
Directories.Counted = FalseS
Display.Lines = False
Continuous.Display = False
Quit.Searching = False

' get current drive/directory
Current.Drive = Left$(_CWD$, 1)
Current.Directory = _CWD$
If Right$(Current.Directory, 1) <> "\" Then
   Current.Directory = Current.Directory + "\"
End If

' check command line
If Command.Line = NUL Then
   ' display header
   Color White, Black
   GoSub Header
   Display.Header = True

   ' get command line input
   Print "Dir spec: ";
   Line Input Command.Line
   Do
      Color White, Black
      Print "Switches(?=list): ";
      Line Input Var$
      If Var$ = "?" Then
         GoSub Boot.Usage
      Else
         Command.Line = Command.Line + Var$
         Exit Do
      End If
   Loop
End If

' store command line
Command.Line = RTrim$(Command.Line)

' check command line switches
Append.Slash = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Extended.List = ParseLine("/E")
Short.Display = ParseLine("/F")

Search.Archive = ParseLine("/A")
Search.Hidden = ParseLine("/H")
Search.Readonly = ParseLine("/O")
Search.System = ParseLine("/S")
Search.Compressed = ParseLine("/J")
Search.Encrypted = ParseLine("/K")

Display.Lowercase = ParseLine("/Y")
Strip.Drive = ParseLine("/U")
Recurse.Directories = ParseLine("/R")
Short.Filenames = ParseLine("/V")
Wide.Display2 = ParseLine("/W1")
Wide.Display = ParseLine("/W")
Truncate.Slash = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' reset some display variables
If Wide.Display Then
   Extended.List = False
   Short.Display = True
   Short.Filenames = True
End If

' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = InStr(UCase$(Command.Line), "/D")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   D$ = Mid$(Command.Line, Imbedded + 2, 21)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
   If Len(D$) <> 21 Then
      GoTo Boot.Error
   End If
   If Mid$(D$, 11, 1) <> "-" Then
      GoTo Boot.Error
   End If
   S$ = Left$(D$, 10)
   D1! = Int(Val(Mid$(S$, 1, 2)))
   D2! = Int(Val(Mid$(S$, 4, 2)))
   D3! = Int(Val(Mid$(S$, 7, 4)))
   Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   S$ = Right$(D$, 10)
   D1! = Int(Val(Mid$(S$, 1, 2)))
   D2! = Int(Val(Mid$(S$, 4, 2)))
   D3! = Int(Val(Mid$(S$, 7, 4)))
   Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   If Search.From.Date < False Or Search.To.Date < False Then
      GoTo Boot.Error
   End If
End If
Imbedded = InStr(UCase$(Command.Line), "/T")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   T$ = Mid$(Command.Line, Imbedded + 2, 17)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
   If Len(T$) <> 17 Then
      GoTo Boot.Error
   End If
   If Mid$(T$, 9, 1) <> "-" Then
      GoTo Boot.Error
   End If
   S$ = Left$(T$, 8)
   T1! = Int(Val(Mid$(S$, 1, 2)))
   T2! = Int(Val(Mid$(S$, 4, 2)))
   T3! = Int(Val(Mid$(S$, 7, 2)))
   Search.From.Time = T1! * 2048 + T2! * 32 + T3!
   S$ = Right$(T$, 8)
   T1! = Int(Val(Mid$(S$, 1, 2)))
   T2! = Int(Val(Mid$(S$, 4, 2)))
   T3! = Int(Val(Mid$(S$, 7, 2)))
   Search.To.Time = T1! * 2048 + T2! * 32 + T3!
   If Search.From.Time < False Or Search.To.Time < False Then
      GoTo Boot.Error
   End If
End If

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
If Creation.Time = False Then
   If Access.Time = False Then
      If Modified.Time = False Then
         Modified.Time = True
      End If
   End If
End If

' get nested switch from command line
Nested.Levels = 256%
Imbedded = InStr(UCase$(Command.Line), "/N")
If Imbedded Then
   Var = LastSwitch(Imbedded)
   Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
   GoSub Get.Numeric
   Nested.Recurse = Var%
End If

' recheck command line
If InStr(Command.Line, "/") Then
   GoTo Boot.Error
End If

' check trailing command line
Command.Line = RTrim$(Command.Line)
If Switch.Exist Then
   If Len(Command.Line) > Last.Switch Then
      GoTo Boot.Error
   End If
End If

' remove blanks from command line
Command.Line = RTrim$(Command.Line)
Command.Line = LTrim$(Command.Line)
If Command.Line = "" Then
   Command.Line = "*.*"
End If

' store entire command
Command.Work = Command.Line

' display header
If Display.Header = False Then
   If Continuous.Display = False Then
      Color White, Black
      GoSub Header
   End If
End If

' filename processing loop
Do
   ' store entire command
   If Left$(Command.Line, 1) = Chr$(34) Then
      Imbedded = InStr(2, Command.Line, Chr$(34))
      If Imbedded Then
         Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = NUL
      End If
   Else
      Imbedded = InStr(Command.Line, " ")
      If Imbedded Then
         Command.Work = Left$(Command.Line, Imbedded - 1)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = NUL
      End If
   End If

   ' store search drive
   If Mid$(Command.Work, 2, 1) = ":" Then
      Drive.Search = Left$(Command.Work, 1)
   Else
      Drive.Search = Current.Drive
   End If
   Drive.Search = UCase$(Drive.Search)

   ' store current directory
   Directory.Search$ = Command.Work

   ' parse drive letter
   Temp.Directory$ = Directory.Search$
   If Mid$(Temp.Directory$, 2, 1) = ":" Then
      Temp.Drive$ = UCase$(Left$(Temp.Directory$, 1))
      Temp.Directory$ = Mid$(Temp.Directory$, 3)
   Else
      Temp.Drive$ = Drive.Search
   End If

   ' parse directory
   If Left$(Temp.Directory$, 2) <> "\\" Then
      If Left$(Temp.Directory$, 1) <> "\" Then
         If Temp.Drive$ <> Left$(Current.Directory, 1) Then
            Directory.Search$ = Drive.Search + ":\" + Temp.Directory$
         Else
            Directory.Search$ = Current.Directory + Temp.Directory$
         End If
      Else
         Directory.Search$ = Temp.Drive$ + ":" + Temp.Directory$
      End If
   End If

   ' display search header
   If Continuous.Display = False Then
      Color Yellow, Black
      Display.Lines = Display.Lines + 1
      Print "Searching: " + Directory.Search$
   End If

   ' call subroutine to search directories
   If Left$(Directory.Search$, 2) = "\\" Then
      Call Directories(Directory.Search$)
   Else
      V = Asc(UCase$(Left$(Temp.Drive$, 1))) - 64
      If MEDIAEXISTS(V) Then
         Call Directories(Directory.Search$)
      End If
   End If

   ' check search filename
   If Command.Line = NUL Then
      Exit Do
   End If

   ' check quit searching
   If Quit.Searching Then
      Exit Do
   End If
Loop
End.Stree:

' display counters
If Continuous.Display = False Then
   If Wide.Display Then
      If Display.Length Then
         Print
      End If
   End If
   Color Yellow, Black
   Print "Directories counted"; Directories.Counted
   Color White, Black
   Prompt$ = "Press (A)gain, (Q)uit:"
   Print Prompt$;
   Do
      _Limit 50
      Locate , , 1
      I$ = InKey$
      If UCase$(I$) = "Q" Then
         Color Plain, Black
         System
      End If
      If UCase$(I$) = "A" Then
         Command.Line = NUL
         Color Plain, Black
         Print
         GoTo Start.Loop
      End If
   Loop
End If
Color Plain, Black
End

' make header
Header:
If Header.Flag Then
   Return
End If
Header.Flag = True
If Continuous.Display = False Then
   Color White, Black
   Print "Stree v2.0a: Directory search utility;"
End If
Return

Get.Numeric:
Var% = False
Do
   Temp$ = Mid$(Command.Line, Imbedded, 1)
   If Temp$ >= "0" And Temp$ <= "9" Then
      Var% = Var% * 10 + Val(Temp$)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
   Else
      Exit Do
   End If
Loop
Return

' display program usage
Boot.Usage:
' make header
Color White, Black
Print "Stree v2.0a: Directory search utility;"
Color Yellow, Black
Print "Usage:"
Print "   Stree [d:\path\][/ahos][/bcdefnrtuvwxyz][/123]"
Print "Where:"
Print "   /b  append slash         /c  continuous display"
Print "   /e  extended display     /f  short filename display"
Print "   /r  recurse directories  /u  strip leading drive letter"
Print "   /v  use 8.3 filenames    /w  wide list display"
Print "   /w1 prepend slash        /x  truncate slash"
Print "   /y  lowercase display    /z  suppress errors"
Print "   /nxxx  recurse levels override"
Print "   display directory ranges:"
Print "      /1  creation, /2 accessed, /3 modified"
Print "      /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
Print "      /t  is range of file times in form hh:mm:ss-hh:mm:ss"
Print "   display directory attributes:"
Print "      /a  archive, /h  hidden, /o  read-only, /s  system"
Print "      /j  compressed,  /k  encrypted"
Color Plain, Black
Return
End

Boot.Error:
Color White, Black
Print "Command line error. Type Stree /? for help."
Color Plain, Black
End

' critical error trap
Error.Routine:
DataError = Err
If Display.Errors Then
   Resume Next
End If
If Wide.Display Then
   If Display.Length Then
      Display.Length = False
      Print
   End If
End If
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
Select Case Outpt$
   Case "r"
      Resume
   Case "q"
      Resume End.Stree
   Case "c"
      Resume Next
End Select
Color Plain, Black
End 0

' subroutine to access directories
Sub Directories (Directory.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset
   Dim Recurse.Temp As Integer

   ' reset wildcard flag
   Wild = 0

   ' make directory filename
   Temp.Dir$ = Directory.Search$
   Recurse.Temp = Recurse.Directories
   If Recurse.Directories Then
      If InStr(Temp.Dir$, "?") Or InStr(Temp.Dir$, "*") Then
         ' Recurse.Temp = False
      Else
         If Right$(Temp.Dir$, 1) <> "\" Then
            Temp.Dir$ = Temp.Dir$ + "\"
         End If
         Temp.Dir$ = Temp.Dir$ + "*.*"
      End If
   End If
   ASCIIZ = Temp.Dir$ + Chr$(0)

   ' find first long filename
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))

   ' check findirst error
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' filename/directory loop
      Do
         ' get file attributes
         Attribute = finddata.dwFileAttributes

         ' check directory attribute
         If (Attribute And &H10) = &H10 Then

            ' check to recurse directories
            If Recurse.Temp = 0 Then
               ' store directory name
               Directory$ = finddata.cFileName
               V = InStr(Directory$, Chr$(0))
               If V Then Directory$ = Left$(Directory$, V - 1)

               ' display directory
               GoSub Display.Directory
            End If

            ' check to recurse directories
            If Recurse.Temp Then

               ' store directory name
               Directory$ = finddata.cFileName
               V = InStr(Directory$, Chr$(0))
               If V Then Directory$ = Left$(Directory$, V - 1)

               ' check unicode
               Unicode = 0
               If InStr(Directory$, "?") Then
                  Unicode = -1
                  Directory$ = finddata.cAlternateFileName
                  V = InStr(Directory$, Chr$(0))
                  If V Then Directory$ = Left$(Directory$, V - 1)
               End If

               ' check directory name
               Valid.Flag = -1
               If Directory$ = "." Then
                  Valid.Flag = 0
               End If
               If Directory$ = ".." Then
                  Valid.Flag = 0
               End If
               If Directory$ = NUL Then
                  Valid.Flag = 0
               End If
               If Valid.Flag Then

                  ' display directory
                  GoSub Display.Directory

                  ' check recursion levels
                  Recursion% = True
                  If Nested.Recurse > False Then
                     Nested.Levels = Nested.Levels + 1
                     If Nested.Levels >= Nested.Recurse Then
                        Recursion% = False
                     End If
                  End If

                  ' recursively search subdirectories
                  If Recursion% Then
                     Call Directories(Next.Directory$)
                  End If
                  If Nested.Recurse > False Then
                     Nested.Levels = Nested.Levels - 1
                  End If
               End If
            End If
         End If

         ' check quit searching
         If Quit.Searching Then
            Exit Do
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
   Exit Sub

   Display.Directory:
   ' retract one directory if wildcard/global characters in trailing path
   If InStr(Directory.Search$, "?") Or InStr(Directory.Search$, "*") Then
      Wild = -1
      For V = Len(Directory.Search$) To 1 Step -1
         If Mid$(Directory.Search$, V, 1) = "\" Then
            Directory.Search$ = Left$(Directory.Search$, V)
            Exit For
         End If
      Next
   End If

   ' make next search directory
   If Right$(Directory.Search$, 1) <> "\" Then
      Next.Directory$ = Directory.Search$ + "\" + Directory$
   Else
      Next.Directory$ = Directory.Search$ + Directory$
   End If

   ' store directory name
   Temp.Directory$ = finddata.cFileName
   V = InStr(Temp.Directory$, Chr$(0))
   If V Then Temp.Directory$ = Left$(Temp.Directory$, V - 1)

   If Temp.Directory$ = NUL Then
      Return
   End If
   If Temp.Directory$ = "." Then
      Return
   End If
   If Temp.Directory$ = ".." Then
      Return
   End If

   ' construct directory for display
   If Recurse.Directories = 0 Then
      If Wild Then
         If Right$(Directory.Search$, 1) <> "\" Then
            Temp.Directory$ = Directory.Search$ + "\" + Directory$
         Else
            Temp.Directory$ = Directory.Search$ + Directory$
         End If
      Else
         Temp.Directory$ = Directory.Search$
      End If
   Else
      If Unicode Then
         Unicode.Directory$ = finddata.cFileName
         V = InStr(Unicode.Directory$, Chr$(0))
         If V Then Unicode.Directory$ = Left$(Unicode.Directory$, V - 1)
         If Right$(Directory.Search$, 1) <> "\" Then
            Temp.Directory$ = Directory.Search$ + "\" + Unicode.Directory$
         Else
            Temp.Directory$ = Directory.Search$ + Unicode.Directory$
         End If
      Else
         Temp.Directory$ = Next.Directory$
      End If
      Wild = -1
   End If

   ' get short filename
   If Short.Filenames Then
      Temp.Directory$ = finddata.cAlternateFileName
      V = InStr(Temp.Directory$, Chr$(0))
      If V Then Temp.Directory$ = Left$(Temp.Directory$, V - 1)
      If Temp.Directory$ = NUL Then
         Temp.Directory$ = finddata.cFileName
         V = InStr(Temp.Directory$, Chr$(0))
         If V Then Temp.Directory$ = Left$(Temp.Directory$, V - 1)
      End If
   End If

   ' check directory attribute
   Valid.Attribute = True

   ' check for read-only file
   If Search.Readonly Then
      If (Attribute And &H1) <> &H1 Then
         Valid.Attribute = False
      End If
   End If

   ' check for hidden file
   If Search.Hidden Then
      If (Attribute And &H2) <> &H2 Then
         Valid.Attribute = False
      End If
   End If

   ' check for system file
   If Search.System Then
      If (Attribute And &H4) <> &H4 Then
         Valid.Attribute = False
      End If
   End If

   ' check for archive file
   If Search.Archive Then
      If (Attribute And &H20) <> &H20 Then
         Valid.Attribute = False
      End If
   End If

   ' check for compressed file
   If Search.Compressed Then
      If (Attribute And &H800) <> &H800 Then
         Valid.Attribute = False
      End If
   End If

   ' check for encrypted file
   If Search.Encrypted Then
      If (Attribute And &H4000) <> &H4000 Then
         Valid.Attribute = False
      End If
   End If

   ' store file date and time
   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
   Else
      If Access.Time Then
         x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
         GoSub Convert.Date
         GoSub Convert.Time
      Else
         If Modified.Time Then
            x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
            GoSub Convert.Date
            GoSub Convert.Time
         End If
      End If
   End If

   ' check date\time range
   If Search.From.Date Or Search.To.Date Then
      If File.Work.Date < Search.From.Date Then
         Valid.Attribute = False
      End If
      If File.Work.Date > Search.To.Date Then
         Valid.Attribute = False
      End If
   End If
   If Search.From.Time Or Search.To.Time Then
      If File.Work.Time < Search.From.Time Then
         Valid.Attribute = False
      End If
      If File.Work.Time > Search.To.Time Then
         Valid.Attribute = False
      End If
   End If

   ' check for valid directory
   If Valid.Attribute Then

      ' store directory name
      Outpt$ = RTrim$(Temp.Directory$)
      If Short.Display Then
         If Right$(Outpt$, 1) = "\" Then
            Outpt$ = Left$(Outpt$, Len(Outpt$) - 1)
         End If
         For Imbedded = Len(Outpt$) To 1 Step -1
            If Mid$(Outpt$, Imbedded, 1) = "\" Then
               Outpt$ = Mid$(Outpt$, Imbedded + 1)
               Exit For
            End If
         Next
      End If
      If Truncate.Slash Then
         If Outpt$ <> "\" Then
            If Right$(Outpt$, 1) = "\" Then
               Outpt$ = Left$(Outpt$, Len(Outpt$) - 1)
            End If
         End If
      End If
      If Short.Filenames = False Or Short.Display Then
         If Mid$(Outpt$, 2, 1) <> ":" Then
            If Left$(Directory.Search$, 2) <> "\\" Then
               Outpt$ = Drive.Search + ":" + Outpt$
            End If
         End If
      End If
      If Left$(Directory.Search$, 2) = "\\" Then
         If Mid$(Outpt$, 2, 1) = ":" Then
            Outpt$ = Mid$(Outpt$, 3)
         End If
      End If
      If Strip.Drive Then
         If Mid$(Outpt$, 2, 1) = ":" Then
            Outpt$ = Mid$(Outpt$, 3)
         End If
      End If
      If Display.Lowercase Then
         Outpt$ = LCase$(Outpt$)
      End If

      ' set directory flag
      Flag = True

      ' display directory
      If Flag Then
         ' increment directories counted
         Directories.Counted = Directories.Counted + 1!

         ' check wide display output
         If Wide.Display Then
            Color Yellow, Black
            ' append/prepend slash
            If Strip.Drive Then
               If Wide.Display2 Then ' prepend
                  If Left$(Outpt$, 1) <> "\" Then
                     Outpt$ = "\" + Outpt$
                  End If
               End If
               If Append.Slash Then ' append
                  If Right$(Outpt$, 1) <> "\" Then
                     Outpt$ = Outpt$ + "\"
                  End If
               End If
            End If
            Outpt$ = Left$(Outpt$, 14)
            Print Outpt$;
            Print Space$(15 - Len(Outpt$));
            ' count directories in one line
            Display.Length = Display.Length + 1
            If Display.Length = 5 Then
               ' reset counters
               Print
               Display.Length = False
               Display.Lines = Display.Lines + 1
               GoSub Page.Prompt
               If Quit.Searching Then
                  Exit Sub
               End If
            End If
         Else
            ' check slash switch
            If Append.Slash Then
               If Right$(Outpt$, 1) <> "\" Then
                  Outpt$ = Outpt$ + "\"
               End If
            End If

            ' store length of directory name
            Length = Len(Outpt$)
            ' calculate length variable
            GoSub Calc.Length

            ' check for overflow past more prompt
            ' before directory displayed
            If Continuous.Display = False Then
               ' reset display line counter
               If Display.Lines > 22 Then
                  GoSub Page.Prompt
                  If Quit.Searching Then
                     Exit Sub
                  End If
                  ' recalculate length
                  GoSub Calc.Length
               End If
            End If

            ' display full directory pathname
            Color Yellow, Black
            Print Outpt$

            ' check for paginate
            ' after directory displayed
            If Continuous.Display = False Then
               GoSub Page.Prompt
               If Quit.Searching Then
                  Exit Sub
               End If
            End If

            ' check output type
            If Extended.List Then
               ' display extended directory attributes
               GoSub Display.List
               ' check for paginate
               ' after extended info displayed
               If Continuous.Display = False Then
                  GoSub Page.Prompt
                  If Quit.Searching Then
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If
   Return

   ' check for page length
   Page.Prompt:
   If Display.Lines >= 22 Then
      Display.Lines = False
      If Continuous.Display = False Then
         If More.Display = False Then
            Prompt$ = "More (y)es/(n)o/(c)ontinuous?"
            Call MorePrompt(Prompt$, "ync", Outpt2$)
            Select Case Outpt2$
               Case "c"
                  More.Display = True
               Case "n"
                  Quit.Searching = True
            End Select
         End If
      End If
   End If
   Return

   ' calculates line length,
   ' increments total lines displayed
   Calc.Length:
   If Length > 240 Then
      Display.Lines = Display.Lines + 4
   Else
      If Length > 160 Then
         Display.Lines = Display.Lines + 3
      Else
         If Length > 80 Then
            Display.Lines = Display.Lines + 2
         Else
            Display.Lines = Display.Lines + 1
         End If
      End If
   End If
   Return

   ' routine to display extended directory attributes
   Display.List:
   Length = False
   ' store file creation date\time
   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
      Outpt$ = File.Date$ + " " + File.Time$
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color Red, Black
      Print Outpt$;
   End If
   If Access.Time Then
      x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
      If Creation.Time Then
         Length = Length + 1
         GoSub Line.Check
         Color White, Black
         Print "\";
      End If
      Outpt$ = File.Date$ + " " + File.Time$
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color Red, Black
      Print Outpt$;
   End If
   If Modified.Time Then
      x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
      GoSub Convert.Date
      GoSub Convert.Time
      If Creation.Time Or Access.Time Then
         Length = Length + 1
         GoSub Line.Check
         Color White, Black
         Print "\";
      End If
      Outpt$ = File.Date$ + " " + File.Time$
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color Red, Black
      Print Outpt$;
   End If

   ' display file attributes
   If (Attribute And &H1) = &H1 Then
      Outpt$ = " Read-only"
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color White, Black
      Print Outpt$;
   End If
   If (Attribute And &H2) = &H2 Then
      Outpt$ = " Hidden"
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color White, Black
      Print Outpt$;
   End If
   If (Attribute And &H4) = &H4 Then
      Outpt$ = " System"
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color White, Black
      Print Outpt$;
   End If
   If (Attribute And &H20) = &H20 Then
      Outpt$ = " Archive"
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color White, Black
      Print Outpt$;
   End If
   If (Attribute And &H800) = &H800 Then
      Outpt$ = " Compressed"
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color White, Black
      Print Outpt$;
   End If
   If (Attribute And &H4000) = &H4000 Then
      Outpt$ = " Encrypted"
      Length = Length + Len(Outpt$)
      GoSub Line.Check
      Color White, Black
      Print Outpt$;
   End If
   If Length Then
      Print
   End If
   Display.Lines = Display.Lines + Temp.Lines
   Return

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
   File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return

   ' check for page length
   Line.Check:
   ' calculate lines past current line display counter
   If Length Then
      Temp.Lines = 1
      If Length > 80 Then
         Temp.Lines = 2
      End If
   End If
   ' check overflow past line 22
   If Display.Lines + Temp.Lines > 22 Then
      ' page break
      If Length Then
         If Continuous.Display = False Then
            Print
         End If
      End If
      ' reset counters
      Length = False
      Display.Lines = False
      If Continuous.Display = False Then
         If More.Display = False Then
            ' prompt for more
            Prompt$ = "More (y)es/(n)o/(c)ontinuous?"
            Call MorePrompt(Prompt$, "ync", Outpt2$)
            Select Case Outpt2$
               Case "c"
                  More.Display = True
               Case "n"
                  Quit.Searching = True
            End Select
         End If
      End If
   End If
   Return
End Sub

' prompt for more
Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
   Color White, Black
   Print Input.String$ + " ";
   Input.Char$ = NUL
   Do
      Do
         _Limit 50
         Locate , , 1
         Input.Char$ = InKey$
         If Len(Input.Char$) Then
            Exit Do
         End If
      Loop
      Input.Char$ = LCase$(Input.Char$)
      If InStr(Input.Mask$, Input.Char$) Then
         Print Input.Char$
         Output.String$ = Input.Char$
         Exit Do
      End If
   Loop
End Sub

' command line switch position function.
Function LastSwitch (Var)
   If Last.Switch = 0 Then
      Last.Switch = Var - 1
      Switch.Exist = -1
   Else
      If Var < Last.Switch Then
         Last.Switch = Var - 1
         Switch.Exist = -1
      End If
   End If
   LastSwitch = -1
End Function

' command line parser
Function ParseLine (X$)
   Imbedded = InStr(Command.Line, LCase$(X$))
   If Imbedded Then
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
      Last.Switch = Imbedded - 1
      ParseLine = True
      Switch.Exist = -1
   Else
      Imbedded = InStr(Command.Line, UCase$(X$))
      If Imbedded Then
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
         Last.Switch = Imbedded - 1
         ParseLine = True
         Switch.Exist = -1
      Else
         ParseLine = False
      End If
   End If
End Function

' test volume media inserted.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If

   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = NUL
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = False
   Else
      DRIVEEXISTS = True
   End If
End Function

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

