Rem filelist utility for QB64 v1.0a PD 08/29/2022.

' declare all default variables
DefDbl A-Z
Rem $DYNAMIC

' boolean constants
Const Dfalse = 0#
Const Dtrue = -1#
Const False = 0
Const True = -1
Const SFalse = 0!
Const STrue = -1!
Const Nul = ""

' color constants
Const Black = 0
Const Plain = 7
Const Gray = 8
Const Blue = 9
Const Green = 10
Const Cyan = 11
Const Red = 12
Const Magenta = 13
Const Yellow = 14
Const White = 15

Dim Shared ControlBreak As Integer

' declare library constants.
Const MAX_PATH = 260
Const INVALID_HANDLE_VALUE = -1
Const ERROR_FILE_NOT_FOUND = 2
Const ERROR_NO_MORE_FILES = &H12
Const FILE_FLAG_BACKUP_SEMANTICS = &H02000000 ' CreateFile directory flag
Const ByteDivisor = 1024
Const ByteDivisor2 = 1024

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

Declare Dynamic Library "kernel32"
   Function FindFirstFileA~%& (ByVal lpFileName~%&, Byval lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, Byval lpFindFileData~%&)
   Function FindFirstFileW~%& (ByVal lpFileName~%&, Byval lpFindFileData~%&)
   Function FindNextFileW& (ByVal hFindFile~%&, Byval lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)

   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, Byval nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, Byval nFileSystemNameSize&)
   Function GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
   Function GetDiskFreeSpaceExA& (filename$, free As _Unsigned _Integer64, total As _Unsigned _Integer64, free2 As _Unsigned _Integer64)
   Function SetVolumeLabelA% (d$, f$)

   Function GetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function SetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function SystemTimeToFileTime& (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME)
End Declare

' declare library variables.
Dim Shared finddata As WIN32_FIND_DATAA
Dim Shared hfind As _Offset
Dim Shared SysTime As SYSTEMTIME

t1 = _FreeTimer
On Timer(t1, 1) GoSub TimerTrap
Timer(t1) On
VarQ = _Exit

Print "File spec(*.*)";
Input V$: V$ = LTrim$(RTrim$(V$))
If InStr(V$, " ") Then
   Do
      v1 = InStr(V$, " ")
      If v1 Then
         v1$ = LTrim$(RTrim$(Left$(V$, v1 - 1)))
         V$ = LTrim$(RTrim$(Mid$(V$, v1 + 1)))
         Call ListFiles(v1$, -1)
      Else
         v1$ = LTrim$(RTrim$(V$))
         Call ListFiles(v1$, -1)
         Exit Do
      End If
   Loop
Else
   V$ = LTrim$(RTrim$(V$))
   Call ListFiles(V$, -1)
End If
Timer(t1) Off
End

' timer ctrl-break trap. (added 01/08/2022)
TimerTrap:
VarQ = _Exit

If VarQ Then
   Timer(t1) Off
End If

' Alt-F4/windows X
If VarQ = 1 Then
   'Call StopProgram
   System
End If

' control-break
If VarQ = 2 Then
   ControlBreak = -1
   End
End If

' both windows X and ctrl-break
If VarQ = 3 Then
   'Call StopProgram
   System
End If
Return

' display dirs/files
'   VarQ = 0 for directories only
Sub ListFiles (VarZ$, VarQ)
   Dim ASCIIZ4 As String * 260

   ErrorCount = 0
   ErrorType2 = -1

   ' reset search parameter
   If Len(VarZ$) Then
      Var4$ = VarZ$
   Else
      Var4$ = "*.*"
   End If

   ' display header
   Color White, Black
   Print "Searching: " + Var4$
   GoSub TitleHeader

   c = 0
   q = 0
   v = 1
   t = 0
   For l = 1 To 2 ' dirs/files
      If l = 2 Then
         If VarQ = 0 Then
            Exit For
         End If
      End If
      ASCIIZ4 = Var4$ + Chr$(0)
      hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
      If hfind <> INVALID_HANDLE_VALUE Then
         z = 0
         Do
            OK = 0
            Var# = finddata.dwFileAttributes
            If l = 1 Then
               If (Var# And &H10) = &H10 Then
                  OK = -1
               End If
            End If
            If l = 2 Then
               If (Var# And &H10) = &H0 Then
                  OK = -1
               End If
            End If

            X$ = finddata.cFileName
            VarX = InStr(X$, Chr$(0))
            If VarX Then
               X$ = Left$(X$, VarX - 1)
            End If
            X$ = RTrim$(X$)
            If X$ = "." Or X$ = ".." Then
               OK = 0
            End If
            If OK Then
               If t Then
                  t = 0
                  GoSub TitleHeader
               End If
               Attr$ = Space$(7)
               If l = 1 Then
                  Mid$(Attr$, 2, 1) = "D"
                  d1 = d1 + 1
               Else
                  f1 = f1 + 1
               End If
               q = -1

               ' print shortfilename
               z$ = finddata.cAlternateFileName
               vx = InStr(z$, Chr$(0))
               If vx Then
                  z$ = Left$(z$, vx - 1)
               End If
               If z$ = Nul Then
                  z$ = finddata.cFileName
                  vx = InStr(z$, Chr$(0))
                  If vx Then
                     z$ = Left$(z$, vx - 1)
                  End If
               End If
               If Len(z$) > 12 Then
                  z$ = Left$(z$, 12)
               End If
               Color Yellow, Black
               Print UCase$(z$);
               If Len(z$) <= 14 Then
                  Print Space$(14 - Len(z$));
               End If

               ' print date/time
               x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
               Var$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
               Var$ = Var$ + LTrim$(Str$(SysTime.wYear)) + "  "
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
               Var$ = Var$ + LTrim$(Str$(SysTime.wYear))
               Color Green, Black
               Print Var$;

               ' attributes of directory/filename
               Var# = finddata.dwFileAttributes
               If Var# < 0 Then
                  Var# = 0
               End If
               If (Var# And &H20) = &H20 Then
                  Mid$(Attr$, 1, 1) = "A" ' archive
               End If
               If (Var# And &H4) = &H4 Then
                  Mid$(Attr$, 3, 1) = "S" ' system
               End If
               If (Var# And &H2) = &H2 Then
                  Mid$(Attr$, 4, 1) = "H" ' hidden
               End If
               If (Var# And &H1) = &H1 Then
                  Mid$(Attr$, 5, 1) = "R" ' read-only
               End If
               If (Var# And &H800) = &H800 Then
                  Mid$(Attr$, 6, 1) = "C" ' compressed
               End If
               If (Var# And &H4000) = &H4000 Then
                  Mid$(Attr$, 7, 1) = "E" ' encrypted
               End If
               Color Red, Black
               Print " "; Attr$; " ";

               ' print filesize
               z$ = "<DIR>"
               If l = 2 Then
                  Var# = CDbl(finddata.nFileSizeHigh * &H100000000~&&)
                  Var# = Var# + CDbl(finddata.nFileSizeLow)
                  VarX~&& = VarX~&& + Var# ' add bytes
                  Call Suffix(Var#, z$) ' 1,024.0 KB
               End If
               z$ = Left$(z$, 10)
               z$ = Space$(10 - Len(z$)) + z$
               Color Cyan, Black
               Print z$; " ";

               ' print longfilename
               z$ = finddata.cFileName
               VarX = InStr(z$, Chr$(0))
               If VarX Then
                  z$ = Left$(z$, VarX - 1)
               End If
               z$ = RTrim$(z$)
               If Len(z$) Then
                  If Len(z$) > 21 Then
                     z$ = Left$(z$, 20) + "..."
                  End If
                  Color Yellow, Black
                  Print z$;
               End If
               Print

               ' prompt
               v = v + 1
               If v = 21 Then
                  v = 0
                  If c = 0 Then
                     Color White, Black
                     Print "-more(y/n/c/q)-";
                     X$ = Nul
                     Do
                        _Limit 50
                        X$ = InKey$
                        If ControlBreak Then
                           ControlBreak = False
                           Exit Do
                        End If
                        If Len(X$) Then
                           Select Case LCase$(X$)
                              Case "c" ' continuous
                                 c = -1
                                 Exit Do
                              Case "n", "q" ' no/quit
                                 v = 0
                                 Print
                                 Exit For
                              Case " ", Chr$(13), "y" ' yes/continue
                                 Exit Do
                           End Select
                        End If
                     Loop
                     Print
                     t = -1
                  End If
               End If
            End If
         Loop While FindNextFileA(hfind, _Offset(finddata))
         x = FindClose(hfind)
      End If
   Next
   If q = 0 Then
      Color Yellow, Black
      Print None
   End If

   ' print totals
   Color White, Black
   Print "------------                                 ----------"
   TotalLine$ = "Files " + FormatString$(CDbl(f1))
   TotalLine$ = TotalLine$ + " Dirs " + FormatString$(CDbl(d1))
   TotalLine$ = Left$(TotalLine$, 40)
   TotalLine$ = TotalLine$ + Space$(44 - Len(TotalLine$))

   VarX# = CDbl(VarX~&&)
   Call Suffix(VarX#, z$) ' 1,024.0 KB
   TotalLine$ = TotalLine$ + Space$(11 - Len(z$)) + z$
   Print TotalLine$
   Exit Sub


   TitleHeader:
   Color White, Black
   Print "Filename      Date        Time       Attr          Size Longfilename"
   Print "------------  ----------  --------   -----   ---------- ------------"
   Return
End Sub

' formats a double numeric string
Function FormatString$ (s#)
   x$ = Nul
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString$ = x$
End Function

' calculate byte suffix.
Function Suffix$ (Var)
   Dim Var3 As Double
   ' Var - input value
   ' SuffixType - 0 = bytes, 1 = kilo, 2 = mega, 3 = giga
   Rem B  (Byte) = 00x - 0FFx
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB
   Rem GB (Gigabyte) = 1024 MB

   ' 1.#INF and -1.#INF and -1.#IND and 1#QNAN
   If InStr(Str$(Var), "#") Then
      Suffix$ = LTrim$(Str$(Var))
      Exit Function
   End If

   ' check sign
   If Var < 0 Then
      Suffix$ = " -1B"
      Exit Function
   End If

   ' check bytes.
   Var3 = Var
   If SuffixType = 0 Then
      Suffix$ = FormatString$(Var3) + " B"
      Exit Function
   End If

   ' calculate byte suffix.
   TempA = False
   Do
      If Var3 >= ByteDivisor2 Then
         Var3 = Var3 / ByteDivisor2
         TempA = TempA + 1
         If TempA >= SuffixType Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   '   Var2$ = FormatString$(Var3)
   If TempA = 3 Then
      Var3 = Var3 + .1
   End If
   Var2$ = FormatString$(Var3)
   If InStr(Var2$, ".") Then
      Var2$ = Left$(Var2$, InStr(Var2$, ".") + 1)
   End If
   Var$ = "B"
   Select Case TempA
      Case 1
         Var$ = "KB"
      Case 2
         Var$ = "MB"
      Case 3
         Var$ = "GB"
   End Select
   ' append suffix.
   Suffix$ = Var2$ + " " + Var$
End Function

Sub Suffix (Var#, Var3$)

   Rem B  (Byte) = 00x - 0FFx (hexidecimal zero-based)
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB (1 MB B)
   Rem GB (Gigabyte) = 1024 MB
   Rem TB (Terabyte) = 1024 GB (1 MB MB)
   Rem PB (Petabyte) = 1024 TB
   Rem EB (Exabyte) = 1024 PB (1 MB TB)
   Rem ZB (Zettabyte) = 1024 EB
   Rem YB (Yottabyte) = 1024 ZB (1 MB EB)

   ' 1.#INF and -1.#INF and -1.#IND and 1#QNAN
   If InStr(Str$(Var#), "#") Then
      Var3$ = LTrim$(Str$(Var#))
      Exit Sub
   End If

   ' check double
   VarX2# = Var#
   s$ = Str$(VarX2#)
   If InStr(s$, "D") Then
      Var3$ = s$
      Exit Sub
   End If

   ' get sign
   If VarX2# < 0# Then
      Sign = -1
      VarX2# = Abs(VarX2#)
   End If

   ' calculate bytes
   TempA = False
   Do
      If VarX2# >= ByteDivisor Then
         VarX2# = VarX2# / ByteDivisor
         TempA = TempA + 1
         If TempA = 8 Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   Var3$ = FormatString$(VarX2#)
   If InStr(Var3$, ".") Then
      Var3$ = Left$(Var3$, InStr(Var3$, ".") + 1)
   Else
      Var3$ = Var3$ + ".0"
   End If

   ' calculate byte suffix
   Var$ = Nul
   If TempA > 0 Then
      Var$ = Mid$("KMGTPEZY", TempA, 1)
   End If
   Var3$ = Var3$ + " " + Var$ + "B"

   ' calculate byte sign
   If Sign Then
      Var3$ = "-" + Var3$
   End If
End Sub

