Rem Sample program to search with _Files$ function. v3.0a QB64 source PD 2024.
Rem  v2.0a:
Rem    Adds dirspec match and restart.
Rem    Adds shellsort for dirs and files.
Rem  v2.1a:
Rem    Adds statusline and ctrl-break trap.
Rem    Adds filename search to titlebar.
Rem  v2.2a:
Rem    Adds Case-Sensitive selection.
Rem  v3.0a:
Rem    Fixes print position output.
Rem    Fixes exit loop in prompt output file.

Rem $Dynamic
Option _Explicit
Const Version = "v3.0a"

' arrays to store filenames in search function.
Dim Shared Directories(1) As String
Dim Shared Filenames(1) As String

' lines in arrays.
Dim Shared MaxDirs As Long
Dim Shared MaxFiles As Long
Dim Shared Restart As Integer

' specify slash in Win/Linux/OSX
Dim Shared DirChar As String * 1
Dim Shared DirChar2 As String * 2
Dim Shared DirChar3 As String * 3

' settings for file output.
Dim Shared DisplayOutput As Integer
Dim Shared WriteOutput As Integer
Dim Shared WriteFile As String

' values for dot display.
Dim Shared VarD As Integer
Dim Shared VarE As Integer
Dim Shared VarF As Single
Const DotChar = "."
Const DotCount = 5

' temp file variables.
Dim Shared SubDirectory As String
Dim Directory As String
Dim Filename As String
Dim Shared Match As Integer
Dim Shared CaseSensitive

' counters and temp variables.
Dim X As String * 1, Z As Long
Dim C As Integer, D As Integer

' init screen.
Dim t1 As Single, Q As Integer
_ScreenMove _Middle
_Title "FILEDIR"

' declare subroutines.
Declare Sub TreeDirectory (Directory As String, Filename As String)
Declare Sub CheckFilename (Filename1$, Filename2$, Match%)
Declare Sub Dot.Display2 (VarD%, VarE%, VarF!, Var$)

' assign timer traps.
On Timer(1) GoSub TimerTrap
Timer On
t1 = _FreeTimer
On Timer(t1, 1) GoSub CtrlBreak
Timer(t1) On
Q = _Exit

' store directory slashs.
$If WINDOWS Then
   DirChar = "\": DirChar2 = ".\": DirChar3 = "..\"
$Else
      DirChar = "/": DirChar2 = "./": DirChar3 = "../"
$End If

' start input loop.
On Error GoTo ErrorRoutine
Start.Loop:
Restart = 0
MaxDirs = 0
MaxFiles = 0

' setup all search variables.
Color 15
Print "File Search "; Version$
Print "Enter dirspec(" + DirChar + "Path" + DirChar + ")";: Input Directory
Print "Enter dirmatch(*)";: Input SubDirectory
Print "Enter filematch(*.*)";: Input Filename
If SubDirectory = "" Then SubDirectory = "*"
If Directory = "" Then Directory = _CWD$
If _DirExists(Directory) = 0 Then Directory = _CWD$
If Right$(Directory, 1) <> DirChar Then Directory = Directory + DirChar
If Filename = "" Then Filename = "*.*"
Print "Searching: "; Directory; Filename
DisplayOutput = -1 ' default to display files.

' get display option.
Print "Display output(y/n)?";
X$ = ""
Do
   _Limit 50
   X$ = InKey$
   If LCase$(X$) = "n" Then Print "n": DisplayOutput = 0: Exit Do
   If LCase$(X$) = "y" Then Print "y": DisplayOutput = -1: Exit Do
Loop

' get display option.
$If WINDOWS Then
   Print "Case-Sensitive(y/n)?";
   X$ = ""
   Do
      _Limit 50
      X$ = InKey$
      If LCase$(X$) = "n" Then Print "n": CaseSensitive = 0: Exit Do
      If LCase$(X$) = "y" Then Print "y": CaseSensitive = -1: Exit Do
   Loop
$End If

' get output file.
Print "Write output to file(y/n)?";
X$ = ""
Do
   _Limit 50
   X$ = InKey$
   If LCase$(X$) = "n" Then Print "n": Exit Do
   If LCase$(X$) = "y" Then
      Print "y"
      Print "Enter filename";
      Input WriteFile$
      If Len(WriteFile$) Then
         If _FileExists(WriteFile$) Then
            Print "File exists. Overwrite(y/n)?";
            X$ = ""
            Do
               _Limit 50
               X$ = InKey$
               If LCase$(X$) = "y" Then Print "y": Exit Do
               If LCase$(X$) = "n" Then Print "n": GoTo NextLoop
            Loop
         End If
         WriteOutput = -1
         Close
         Open WriteFile$ For Output As #1
      End If
      Exit Do
   End If
Loop

NextLoop:
' start loading dirs and files.
Color 15
If DisplayOutput = 0 Then
   Print "Loading files";
End If
Color 14
VarD% = 0
VarE% = 0
VarF! = Timer
Call TreeDirectory(Directory, Filename)
_Title "FILEDIR"

' check output type.
If Pos(0) > 1 Then Print
Color 15
If DisplayOutput = -1 Then
   Print "Dirs:"; MaxDirs; " Files:"; MaxFiles
End If
If DisplayOutput = 0 Then
   Print "Files written to array."
End If

' check dir display.
Print "Display dir array(y/n)?";
C = 0
X$ = ""
Do
   X$ = InKey$
   If LCase$(X$) = "n" Then Print: Exit Do
   If LCase$(X$) = "y" Then
      Print
      ' sort dirs.
      Print "Sorting"; MaxDirs; "dirs";
      GoSub SortDirs
      Print
      C = 1
      D = 0
      For Z = 1 To MaxDirs
         Color 14
         Print Directories(Z)
         C = C + 1
         If C >= 24 Then
            C = 0
            If D = 0 Then
               Color 15
               Print "-more(y/n/c)-";
               X$ = ""
               Do
                  _Limit 50
                  X$ = InKey$
                  If X$ = "?" Then
                     Print
                     Print " n = no": Print " y = yes": Print " c = continuous"
                     Print "-more(y/n/c)-";
                  End If
                  If LCase$(X$) = "n" Then Print: GoTo NextDir
                  If LCase$(X$) = "y" Then Print: Exit Do
                  If LCase$(X$) = "c" Then D = -1: Print: Exit Do
               Loop
            End If
         End If
      Next
      Exit Do
   End If
Loop
NextDir:

' check file display.
Color 15
Print "Display file array(y/n)?";
C = 0
X$ = ""
Do
   X$ = InKey$
   If LCase$(X$) = "n" Then Print: Exit Do
   If LCase$(X$) = "y" Then
      Print
      ' sort files.
      Print "Sorting"; MaxFiles; "files";
      GoSub SortFiles
      Print
      C = 1
      D = 0
      For Z = 1 To MaxFiles
         Color 14
         Print Filenames(Z)
         C = C + 1
         If C >= 24 Then
            C = 0
            If D = 0 Then
               Color 15
               Print "-more(y/n/c)-";
               X$ = ""
               Do
                  _Limit 50
                  X$ = InKey$
                  If X$ = "?" Then
                     Print
                     Print " n = no": Print " y = yes": Print " c = continuous"
                     Print "-more(y/n/c)-";
                  End If
                  If LCase$(X$) = "n" Then Print: GoTo Nextfile
                  If LCase$(X$) = "y" Then Print: Exit Do
                  If LCase$(X$) = "c" Then D = -1: Print: Exit Do
               Loop
            End If
         End If
      Next
      Exit Do
   End If
Loop
Nextfile:

' check restart.
Color 15
Print "Start search again(y/n)?";
X$ = ""
Do
   _Limit 50
   X$ = InKey$
   If LCase$(X$) = "n" Then Print: Exit Do
   If LCase$(X$) = "y" Then Print: Restart = -1: GoTo Start.Loop
Loop

' exit program.
Color 7
Print "Now exiting File Search."
End

' shell sort.
SortFiles:
Dim Num As Long, Span As Long
Dim Start As Long, Element As Long
Dim Sort.Column1 As String
Dim Sort.Column2 As String
Num = MaxFiles
Span = Int(Num / 2)
Do While Span > 0
   For Start = Span To Num - 1
      For Element = (Start - Span + 1) To 1 Step -Span
         Sort.Column1$ = Filenames(Element)
         Sort.Column2$ = Filenames(Element + Span)
         If Sort.Column1$ <= Sort.Column2$ Then
            Exit For
         End If
         Swap Filenames(Element), Filenames(Element + Span)
      Next
   Next
   Span = Int(Span / 2)
Loop
Return

' shell sort.
SortDirs:
Dim Num2 As Long, Span2 As Long
Dim Start2 As Long, Element2 As Long
Dim Sort.Column1x As String
Dim Sort.Column2x As String
Num2 = MaxDirs
Span2 = Int(Num2 / 2)
Do While Span2 > 0
   For Start2 = Span2 To Num2 - 1
      For Element2 = (Start2 - Span2 + 1) To 1 Step -Span2
         Sort.Column1x$ = Directories(Element2)
         Sort.Column2x$ = Directories(Element2 + Span2)
         If Sort.Column1x$ <= Sort.Column2x$ Then
            Exit For
         End If
         Swap Directories(Element2), Directories(Element2 + Span2)
      Next
   Next
   Span2 = Int(Span2 / 2)
Loop
Return

ErrorRoutine:
If Err = 53 Then Resume Next ' sometimes file not found.
If Pos(0) > 1 Then Print
Print "Critical error "; Err; " line"; _ErrorLine
Color 15
Print "Enter(R)esume same/(N)resume next/(Q)uit:";
X$ = ""
Do
   _Limit 50
   X$ = InKey$
   If LCase$(X$) = "r" Then Resume
   If LCase$(X$) = "n" Then Resume Next
   If LCase$(X$) = "q" Then Exit Do
Loop
Color 7
End

TimerTrap:
Dim L As Integer, M As Integer
L = CsrLin: M = Pos(0)
Color 15
Locate 25, 1, 1
Print "FILEDIR "; Date$ + " " + Time$ + " " + Version$;
Locate L, M, 1
Return

' trap control-break.
CtrlBreak:
Dim Q1 As Integer, X2 As String
Dim L1 As Integer, M1 As Integer
L1 = CsrLin: M1 = Pos(0)
Q1 = _Exit
If Q1 Then
   Locate 1, 1, 1
   Color 12
   Print "Enter R to restart or Q to exit program:";
   X2$ = ""
   Do
      X2$ = InKey$
      If Len(X2$) Then
         If LCase$(X2$) = "q" Then
            Color 7: System
         Else
            If LCase$(X2$) = "r" Then
               Restart = -2
               Exit Do
            Else
               Exit Do
            End If
         End If
      End If
   Loop
End If
Color 15
Locate L1, M1, 1
Return

' recursively search directories.
Sub TreeDirectory (Directory As String, Filename As String)
   Dim Entry(0 To 0) As String, N As _Unsigned Long
   Dim Filename1 As String, Filename2 As String, Match As Integer
   Dim I As _Unsigned Long, E As String, Var As String
   ' recursively exit subroutine.
   If Restart = -2 Then
      Exit Sub
   End If
   ' restart arrays and values.
   If Restart Then
      I = 0: N = 0
      MaxFiles = 0
      MaxDirs = 0
      Restart = 0 ' restart restart!
   End If
   ' start search
   E = _Files$(Directory)
   Do
      If InKey$ = Chr$(27) Then Restart = -2: Exit Sub
      If E <> DirChar2 And E <> DirChar3 Then
         Match% = -1
         If Right$(E, 1) = DirChar Then
            GoSub CheckDir
         End If
         If Match% Then
            Entry(N) = E
            N = N + 1
            If N > UBound(Entry) Then
               ReDim _Preserve Entry(0 To N) As String
            End If
         End If
      End If
      ' continue search
      E = _Files$
      Call Dot.Display2(VarD%, VarE%, VarF!, E)
      If Restart = -2 Then
         Exit Sub
      End If
   Loop While Len(E) > 0
   ' store directories.
   If WriteOutput Then
      Print #1, Directory
   End If
   If DisplayOutput Then
      If Pos(0) > 1 Then
         Print
      End If
      Color 14
      Print "Dir: "; Directory
   End If
   MaxDirs = MaxDirs + 1
   ReDim _Preserve Directories(MaxDirs) As String
   Directories(MaxDirs) = Directory
   ' search filenames.
   While I < N
      If InKey$ = Chr$(27) Then Restart = -2: Exit While
      Var$ = Entry(I)
      Call Dot.Display2(VarD%, VarE%, VarF!, Var$)
      If Var$ <> DirChar2 And Var$ <> DirChar3 Then
         If Right$(Entry(I), 1) <> DirChar Then
            GoSub CheckFile
            If Match% Then
               If WriteOutput Then
                  Print #1, Directory + Entry(I)
               End If
               If DisplayOutput Then
                  If Pos(0) > 1 Then
                     Print
                  End If
                  Color 14
                  Print "File: "; Directory + Entry(I)
               End If
               MaxFiles = MaxFiles + 1
               ReDim _Preserve Filenames(MaxFiles) As String
               Filenames(MaxFiles) = Directory + Entry(I)
            End If
         End If
         ' recurse directories.
         If Entry(I) <> DirChar2 And Entry(I) <> DirChar3 And Right$(Entry(I), 1) = DirChar Then
            Call TreeDirectory(Directory + Entry(I), Filename)
         End If
      End If
      I = I + 1
      If Restart = -2 Then
         Exit Sub
      End If
   Wend
   Exit Sub
   ' pattern match filename (sometimes *.*)
   ' also case-sensitive for Linux/OSX
   CheckFile:
   ' store case-sensitive filenames.
   $If WINDOWS Then
      If CaseSensitive Then
         Filename1$ = Filename$
         Filename2$ = Entry(I)
      Else
         Filename1$ = UCase$(Filename$)
         Filename2$ = UCase$(Entry(I))
      End If
   $Else
         Filename1$ = Filename$
         Filename2$ = Entry(I)
   $End If
   ' compare files with pattern matching.
   Call CheckFilename(Filename1$, Filename2$, Match%)
   Return
   ' pattern match directory (not always *.*)
   ' also case-sensitive for Linux/OSX
   CheckDir:
   ' store case-sensitive filenames.
   $If WINDOWS Then
      If CaseSensitive Then
         Filename1$ = SubDirectory$
         Filename2$ = E
      Else
         Filename1$ = UCase$(SubDirectory$)
         Filename2$ = UCase$(E)
      End If
   $Else
         Filename1$ = SubDirectory$
         Filename2$ = E
   $End If
   ' compare dirs with pattern matching.
   If Right$(Filename2$, 1) = DirChar Then Filename2$ = Left$(Filename2$, Len(Filename2$) - 1)
   If Left$(Filename2$, 1) = DirChar Then Filename2$ = Mid$(Filename2$, 2)
   Call CheckFilename(Filename1$, Filename2$, Match%)
   Return
End Sub

' check filename1 matches in filename2 using ? and * and ^ characters.
Sub CheckFilename (Filename1$, Filename2$, Match%)
   Dim Length1 As Integer, Length2 As Integer
   Dim Not.Include As String * 1
   Filename2$ = LTrim$(RTrim$(Filename2$))
   Match% = -1 ' assume mask matches filename2.
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement.
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Match% = 0
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement.
         ' searches for next matching character.
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement.
         ' matches any next character.
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character.
            ' checks next character unmatched.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match% = 0
                  Exit Do
               End If
            Else
               ' matches next character.
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match% = 0
                  Exit Do
               End If
               ' check string lengths.
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Match% = 0
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
End Sub

' make row of dots.
Sub Dot.Display2 (VarA%, VarB%, VarF!, Var$)
   ' check display timer
   Dim VarG As Single, VarZ As Integer
   VarG! = Timer - VarF!
   If VarG! < 0! Then VarG! = VarG! + 86400!
   If VarG! >= 1! Then
      If Var$ = DirChar Or Var$ = DirChar2 Or Var$ = DirChar3 Then
         Rem eat char
      Else
         If Len(LTrim$(RTrim$(Var$))) Then ' check filename
            _Title "FILEDIR" + " - " + Var$
         End If
      End If
      VarF! = Timer
      If VarA% = 0 Then
         VarB% = VarB% + 1
         Print DotChar;
         If VarB% = DotCount Then
            VarA% = -1
            VarB% = 0
         End If
      Else
         VarB% = VarB% + 1
         For VarZ = 1 To Len(DotChar)
            GoSub Back.Space
            Print " ";
            GoSub Back.Space
         Next
         If VarB% = DotCount Then
            VarA% = 0
            VarB% = 0
         End If
      End If
   End If
   Exit Sub
   ' back one dot
   Back.Space:
   If Pos(0) > 1 Then
      Locate CsrLin, Pos(0) - 1, 0
      Print " ";
      Locate CsrLin, Pos(0) - 1, 1
   End If
   Return
End Sub

