Rem Sic64.bas v64.0a r8.9a - Symbolic Instruction Code Kit for QB64 PD 2025.

Rem The public domain experimental BASIC Windows programming interpreter.

' declare all default variables.
DefDbl A-Z
Rem $Dynamic
_ControlChr Off

' added soundfont 12/10/2024
$If VERSION < 4.0.0 Then
   $UNSTABLE: MIDI
   $MIDISOUNDFONT: DEFAULT
$End If

' set some shared variables.
Rem $Include:'const.inc'
Rem $Include:'color.inc'
Rem $Include:'library.inc'

' declare os values.
Dim Shared LINUX As Integer
Dim Shared MACOSX As Integer
Dim Shared WINDOWS As Integer
Dim Shared ANDROID As Integer

' detect and set OS.
$If WIN Then
   WINDOWS = True
$ElseIf LINUX Then
   LINUX = True
$ElseIf MAC Then
   MACOSX = True
$End If

' force user as admin.
If IsUserAnAdmin = 0 Then
   Call ShellExecute(0, "runas" + Chr$(0), Command$(0) + Chr$(0), Command$ + Chr$(0), 0, 5)
   System
End If

' start screen
Do
   _Limit 10
Loop Until _ScreenExists

' set title icon
Call SetTitleIcon

' set screen position
_ScreenMove _Middle

' music constants
Const Melody$ = "o3 L8 E D+ E D+ E o2 B o3 D C L2 o2 A"
Const Melody2$ = "t180g8g8g4g4g4a8g8g4g4g4a4g4e4g4d1"

' dot display counter
Const DotCount = 5
Const DotChar = "."
Const ProgressChar = "#"

' PI constants
'Const PI = 3.1415926
Const PI = Atn(1) * 4
Const PI2 = PI * 2 / 180

' maximum integer constants
Const MaxInt = 32766 ' zero-based
Const MaxSingle = 1048576
Const MaxLong = 2147483647

' constant declarations (can be changed up to maxint)
Const MaxArrays = 128
Const MaxChainRecurse = 16
Const MaxIncludeRecurse = 10
Const MaxFNlength = 1024
Const MaxFunctions = 26
Const MaxHistory = 10
Const MaxLines = MaxInt
Const MaxLoop = 255
Const MaxNestGosub = 128
Const MaxRecurse = 16
Const MaxViolations = 1024

' set keymapper arrays
Dim Shared KeyMap(3, 0 To 255) As Integer ' ascii
Dim Shared KeyMapExtended(3, 0 To 255) As Integer ' extended ascii

' declare all alarm arrays
Const MaxAlarms = 9 ' can be changed
Dim Shared AlarmFlags(1 To MaxAlarms) As Integer
Dim Shared AlarmStart(1 To MaxAlarms) As Single
Dim Shared AlarmTime(1 To MaxAlarms) As Single
Dim Shared AlarmType(1 To MaxAlarms) As Integer
Dim Shared AlarmBeep(1 To MaxAlarms) As Integer
Dim Shared AlarmColor(1 To MaxAlarms) As Integer
Dim Shared AlarmMusic(1 To MaxAlarms) As Integer
Const AlarmDelay = 1.2!

' constant declarations (cannot be changed)
Const MaxFiles = 255
Const MaxRecords = 1024
Const MaxCommands = 68
Const MaxStatements = 158

' constant declarations (should not be changed)
Const Cookie$ = "Thank you for all the cookies!"
Const ErrorTries = 16
Const None = "<none>"
Const Nul = ""
Const PrimeKey = 29
Const ProgramNameRelease = "SICK64"
Const PublishDate = "12/25/2025"
Const Release = "8.9a"
Const TabStop = 8
Const Version = "64.0a"
Const Untitled = "<untitled>"
Const YearRelease = "2025"

' sound settings
Const Freq = 900
Const Duration = 6

' interval settings
Const LimitValue = 50
Const DelayValue = 1.2
Const TrapValue = 1.2

' constant moreprompt declarations (could be changed)
Const MorePrompt0 = "More(y/n/c/q)?"
Const MorePrompt1 = "More(y/n/c)?"
Const MorePrompt2 = "More(y/n)?"
Const MorePrompt3 = "(y/n/q)?"
Const MorePrompt4 = "-more-"

' declare screen saver constants
Const wm_syscommand = &H112&
Const sc_screensave = &HF140&

' declare screen saver variables
Dim Shared ScreenSaverActive As Integer
Dim Shared ScreenSaverTimer As Single
Dim Shared ScreenSaverStart As Single
Dim Shared ScreenSaverResolution As Single
Dim Shared KeyPressed As Integer

' initialize screen saver
ScreenSaverActive = False
ScreenSaverTimer = SFalse
ScreenSaverStart = SFalse
ScreenSaverResolution = SFalse
KeyPressed = False

' declare startup error routine
On Error GoTo ErrorRoutine2

' declare interrupt registers
Type RegTypeX
   AX As Integer
   BX As Integer
   CX As Integer
   DX As Integer
   BP As Integer
   SI As Integer
   DI As Integer
   FL As Integer
   DS As Integer
   ES As Integer
End Type

' declare interrupt functions
DECLARE SUB InterruptX(N AS INTEGER,I AS RegTypeX,O AS RegTypeX)
DECLARE SUB Absolute(N As Integer)

' interrupt registers
Common Shared InregsX As RegTypeX, OutregsX As RegTypeX

' global variables
Dim Shared AllowAlpha As Integer
Dim Shared AllowExtra As Integer
Dim Shared ArraySize As Integer
Dim Shared Assign As Integer
Dim Shared AutoIndent As Integer
Dim Shared AutoIndentSpaces As Integer
Dim Shared AutoSave As Integer
Dim Shared AutoSaveAlert As Integer
Dim Shared AutoSaveCounter As Single
Dim Shared AutoSaveValue As Integer
Dim Shared BadInput As String
Dim Shared BootError As Integer
Dim Shared BootStore As Integer
Dim Shared CaseStrng As String
Dim Shared CaseValue As Double
Dim Shared CaseValue1 As Double
Dim Shared CaseValue2 As Double
Dim Shared CaseValueS1 As String
Dim Shared CaseValueS2 As String
Dim Shared CommandLine As String
Dim Shared CurrentDirectory As String
Dim Shared Current.Drive As String * 1
Dim Shared Compatible As Integer
Dim Shared Continue.Search As Integer
Dim Shared ControlBreak As Integer
Dim Shared CPUtraptype As Integer
Dim Shared DataLine As Integer
Dim Shared DataNumber As Integer
Dim Shared DataValue As Double
Dim Shared DebugActive As Integer
Dim Shared DEFSEGvalue As Double
Dim Shared DotDisplay As Integer
Dim Shared ErrorCount As Integer
Dim Shared ErrorLine As Integer
Dim Shared ErrorType As Integer
Dim Shared ErrorType2 As Integer
Dim Shared ErrorValue As Integer
Dim Shared ErrorValue2 As Integer
Dim Shared ExceptStep As Double
Dim Shared ExceptStepIs As Integer
Dim Shared FieldVariable As Integer
Dim Shared Filename As String
Dim Shared FileNum As Integer
Dim Shared FileNumber As Integer
Dim Shared Files.Counter As Integer
Dim Shared File.Size As Double
Dim Shared FinishFor As Double
Dim Shared HelpOff As Integer
Dim Shared LineBreakTime As Single
Dim Shared ListLines As Integer
Dim Shared MaskInput As Integer
Dim Shared Recurse As Integer
Dim Shared Recurse2 As Integer
Dim Shared InDEFSEG As Integer
Dim Shared InDEFSEG2 As Integer
Dim Shared IncludeRecurse As Integer
Dim Shared KeyboardTimer As Integer
Dim Shared LastCursor1 As Integer
Dim Shared LastCursor2 As Integer
Dim Shared LastCursor3 As Integer
Dim Shared LastColor1 As Integer
Dim Shared LastColor2 As Integer
Dim Shared LastScreen1 As Integer
Dim Shared LastScreen2 As Integer
Dim Shared LastScreen3 As Integer
Dim Shared LastScreen4 As Integer
Dim Shared LastWidth1 As Integer
Dim Shared LastWidth2 As Integer
Dim Shared LastLine As Integer
Dim Shared LastSearchCase As Integer
Dim Shared LastSearchLine As Integer
Dim Shared LastSearchKeyword As String
Dim Shared LastToken As Integer
Dim Shared Length As Integer
Dim Shared Length2 As Integer
Dim Shared LineFeed As Integer
Dim Shared Line.Counter As Integer
Dim Shared Line.Counter2 As Integer
Dim Shared MaxGosubs As Integer
Dim Shared MEMtraptype As Integer
Dim Shared MEMtraptype2 As Integer
Dim Shared Node As Integer
Dim Shared NestedGosub As Integer
Dim Shared NetPathError As Integer
Dim Shared Out2 As String
Dim Shared Out3 As String
Dim Shared Out4 As String
Dim Shared Program.Start As Single
Dim Shared PageLength As Integer
Dim Shared Printing As Integer
Dim Shared PrinterLF As Integer
Dim Shared PrepareFilename As String
Dim Shared ProgramLine As Integer
Dim Shared ProgramName As String
Dim Shared ProgramResume As Integer
Dim Shared ProgramRunning As Integer
Dim Shared QuitBoxIgnore As Integer
Dim Shared Quit.Searching As Integer
Dim Shared Quotes As Integer
Dim Shared RecordNumber As Long
Dim Shared RunLine As Integer
Dim Shared RunType As Integer
Dim Shared StartBoxIgnore As Integer
Dim Shared StartMenuIgnore As Integer
Dim Shared StepTo As Double
Dim Shared StoredProgramName As String
Dim Shared SaveOnExit As Integer
Dim Shared ScreenHeight As Integer
Dim Shared ScreenMode As Integer
Dim Shared ScreenWidth As Integer
Dim Shared StartDir As String
Dim Shared StatusForeground As Integer
Dim Shared StatusBackground As Integer
Dim Shared StatusType As Integer
Dim Shared StoreCurrentDirectory As String
Dim Shared Strng As String
Dim Shared SoundHandle As Long
Dim Shared SoundFile As String
Dim Shared SuffixType As Integer
Dim Shared StatusLine1 As Double
Dim Shared StatusLine2 As Double
Dim Shared StatusLineFileSize As Double
Dim Shared t1 As Integer
Dim Shared t2 As Integer
Dim Shared t3 As Single
Dim Shared t4 As Integer
Dim Shared t5 As Single
Dim Shared t6 As Integer
Dim Shared t7 As Single
Dim Shared t8 As Integer
Dim Shared t9 As Single
Dim Shared t12 As Integer
Dim Shared Timing As Integer
Dim Shared Token As Integer
Dim Shared TokenIndex As Integer
Dim Shared TokenList As String
Dim Shared UnlessBranch As Integer
Dim Shared UnlessValue As Double
Dim Shared ValueIs As Double
Dim Shared Visible As Integer
Dim Shared VarSeg1 As String
Dim Shared VarSeg2 As Double
Dim Shared WhiteSpace As String
Dim Shared WhatisError As Integer
Dim Shared WindowX As Long
Dim Shared WindowY As Long

' whereis file display date/time type
Dim Shared Creation.Time As Integer
Dim Shared Access.Time As Integer
Dim Shared Modified.Time As Integer

' scrnedit dotdisplay variables
Dim Shared Percent As Single
Dim Shared Percent.Flag As Integer
Dim Shared Current.Progress As Integer
Dim Shared Last.Percent As Single

' store screen size
LastWidth1 = 80
LastWidth2 = 25

' operating system variables
Dim Shared AvoidLINUX As Integer
Dim Shared ForceLINUX As Integer

' common interrupt registers
Dim Shared AX As Double
Dim Shared BX As Double
Dim Shared CX As Double
Dim Shared DX As Double
Dim Shared BP As Double
Dim Shared SI As Double
Dim Shared DI As Double
Dim Shared FL As Double
Dim Shared DS As Double
Dim Shared ES As Double

' declare keyboardline2$ function timer
KeyboardTimer = 0

' declare prompt strings
Dim Shared Prompt1 As String
Dim Shared Prompt2 As String
Dim Shared Prompt3 As String
Dim Shared Prompt4 As String
Dim Shared Prompt5 As String
Dim Shared MakeBeep As Integer
Dim Shared PromptStore As String
Dim Shared PromptLine As Integer

' program variables
Dim Shared Commands(1 To MaxCommands) As String
Dim Shared CommandsLoaded(1 To MaxCommands) As Integer
Dim Shared CommandsParams(1 To MaxCommands) As Integer
Dim Shared CommandsSorted(1 To MaxCommands) As String
Dim Shared Statements(1 To MaxStatements) As String
Dim Shared AuthorStatus(1 To 3) As String

' program code
Dim Shared GosubReturn(1 To 10) As Integer
Dim Shared Program(0 To MaxLines) As String
Dim Shared LineBreak(1 To MaxLines) As Integer

' variable break arrays
Dim Shared VariableBreak(1 To 1024) As Integer
Dim Shared VariableValue(1 To 1024) As Double
Dim Shared VariableBreak2(1 To 1024) As Integer
Dim Shared VariableValue2(1 To 1024) As String
Dim Shared VariableBreak3(0 To 1024, 0 To MaxArrays) As Integer
Dim Shared VariableValue3(0 To 1024, 0 To MaxArrays) As Double

' program data
Dim Shared Arrays(0 To 1024, 0 To MaxArrays) As Double
Dim Shared Definitions(0 To MaxFunctions) As String
Dim Shared Strngs(0 To 1024) As String
Dim Shared Variables(0 To 1024) As Double

' constants data
Dim Shared ConstStrings(0 To 1) As String
Dim Shared ConstValues(0 To 1) As String
Dim Shared ConstArray As Long
ConstStrings(1) = Nul
ConstValues(1) = Nul

' stored filelist data
Dim Shared MaxRecent As Integer
MaxRecent = 9 ' should not be changed.
Dim Shared Recent1(0 To MaxRecent) As String
Dim Shared Recent2(0 To MaxRecent) As String

' multi-dimensional command history arrays
Dim Shared HistoryCount2(0 To 6) As Integer
Dim Shared History2(0 To 6, 1 To MaxHistory) As String * 256
Dim Shared EndOfHistoryFlag(0 To 6) As Integer

' multi-dimensional command history variable
Dim Shared Temp0 As Integer

' file areas
Dim Shared FieldArray(1 To MaxFiles) As String
Dim Shared FileFields(1 To MaxFiles) As String
Dim Shared FileFieldNames(1 To MaxFiles) As String
Dim Shared FileTraps(1 To MaxFiles) As Integer
Dim Shared FileRecords(1 To MaxRecords) As Long
Dim Shared RecordCount As Integer
Dim Shared FileTrap0 As Integer

' graphics areas
Dim Shared GraphicsScreen(1 To 10) As Integer
Dim Shared VarSeg3(1 To 10) As Integer

' temp directory
Dim Shared DRX As String
Dim Shared DRX2 As String

' break constants
Const BreakColor = 12 ' red
Const BreakMessage = "*break*"
Const BreakColor2 = 12 ' red
Const BreakMessage2 = "*line break*"
Const BreakColor3 = 12 ' red
Const BreakMessage3 = "*variable break*"
Const AutoSaveAlertColor = 12 ' red
Const AutosaveAlertMessage = "*alert*"
Const MoreBreakColor = 12 ' red
Const MoreBreakMessage = "*break*"

Const FileBreakMessage = "*filebreak*"
Const RecordBreakMessage = "*recordbreak*"

' timer trap defaults
Const AutoSaveDefault = 5

Declare Function clock$

Declare Function DisplayWinError$ (x)

' declare library variables.
Dim Shared finddata As WIN32_FIND_DATAA
Dim Shared finddata2 As WIN32_FIND_DATAA
Dim Shared finddata3 As WIN32_FIND_DATAA
Dim Shared finddatatemp As WIN32_FIND_DATAA
Dim Shared hfind As _Offset
Dim Shared hfind2 As _Offset
Dim Shared hfind3 As _Offset
Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String

' set soundfile extensions
Const MaxSoundFileExtensions = 31
Dim Shared SoundFileExtensions(1 To MaxSoundFileExtensions) As String

' set soundfont extensions
Const MaxSoundFontExtensions = 8
Dim Shared SoundFontExtensions(1 To MaxSoundFontExtensions) As String

' sets some constants
$If VERSION < 4.0.0 Then
   Dim Shared Quote As String * 1
   Quote = Chr$(34)
   Dim Shared TabS As String * 1
   TabS = Chr$(9)
   Dim Shared CRLF As String * 2
   CRLF = Chr$(13) + Chr$(10)
   Dim Shared CR As String * 1
   CR = Chr$(13)
   Dim Shared LF As String * 1
   LF = Chr$(10)
$End If
$If VERSION >= 4.0.0 Then
   Const Quote = Chr$(34)
   Const TabS = Chr$(9)
   Const CRLF = Chr$(13) + Chr$(10)
   Const CR = Chr$(13)
   Const LF = Chr$(10)
$End If
Const SpaceC = " "
Const UnderScore = "_"
Const Remark$ = "REM"

' store default path.
x$ = _StartDir$
StartDir$ = x$
If Right$(StartDir$, 1) <> "\" Then
   StartDir$ = StartDir$ + "\"
End If

' initialize common variables
MaxGosubs = 10
PageLength = 23
ProgramName = None
SaveOnExit = True
TokenList = " -+*/\^()[]{}<>=|&!%~?:#@`;,'_" + Quote ' cannot be changed
WhiteSpace = SpaceC + TabS ' can be changed

ReDim Program(1 To MaxLines) As String
Rem Program(MaxLines) = Remark$

' initialize default screen variables
LastScreen1 = 0
LastScreen2 = 1
LastScreen3 = 0
LastScreen4 = 0

' initialize local screen variables
ScreenMode = 0
ScreenHeight = 25
ScreenWidth = 80

' reset multi-dimensional command history arrays
For VarQ1 = 0 To 6
   EndOfHistoryFlag(VarQ1) = 0
   HistoryCount2(VarQ1) = 0
   For VarQ2 = 1 To MaxHistory
      History2(VarQ1, VarQ2) = Nul
   Next
Next

' reseed randomizer
Randomize Timer

' reset default values
Prompt1 = ">"
Prompt2 = ":"
Prompt3 = "?"
Prompt4 = "#"
Prompt5 = "]"
CPUtraptype = True
MakeBeep = True
StatusForeground = 15
StatusBackground = 1
MEMtraptype = True
SuffixType = 3

' parse config file
CurrentDirectory = _CWD$
Call ReadConfig(VarQ)
Call ReadRecent(VarQ)

' get environment variables
Var$ = Environ$("SICPAGELENGTH")
If Len(Var$) Then
   Temp = Int(Val(Var$))
   Select Case Temp
      Case 25, 43, 50
         PageLength = Temp - 2
   End Select
End If
Var$ = Environ$("HELPOFF")
If Len(Var$) Then
   HelpOff = True
End If
Var$ = Environ$("AVOIDLINUX")
If Len(Var$) Then
   AvoidLINUX = True
End If
Var$ = Environ$("FORCELINUX")
If Len(Var$) Then
   ForceLINUX = True
End If
Var$ = Environ$("SICSAVEONEXIT")
If Len(Var$) Then
   SaveOnExit = False
End If
Var$ = Environ$("SICSTATUSLINE")
If Len(Var$) Then
   If UCase$(Var$) = "OFF" Then
      StatusType = -3
   End If
End If
Var$ = Environ$("SICPROMPT1")
If Len(Var$) Then
   Prompt1 = Var$
End If
Var$ = Environ$("SICPROMPT2")
If Len(Var$) Then
   Prompt2 = Var$
End If
Var$ = Environ$("SICPROMPT3")
If Len(Var$) Then
   Prompt3 = Var$
End If
Var$ = Environ$("SICPROMPT4")
If Len(Var$) Then
   Prompt4 = Var$
End If
Var$ = Environ$("SICPROMPT5")
If Len(Var$) Then
   Prompt5 = Var$
End If
Var$ = Environ$("SICIGNORE")
If Len(Var$) Then
   BootError = True
End If
Var$ = Environ$("SICMAKEBEEP")
If Len(Var$) Then
   If UCase$(Var$) = "OFF" Then
      MakeBeep = False
   End If
End If
Var$ = Environ$("SICCPUTRAP")
If Len(Var$) Then
   If UCase$(Var$) = "OFF" Then
      CPUtraptype = False
   End If
End If

Var$ = Environ$("QUITBOXIGNORE")
If Len(Var$) Then
   If UCase$(Var$) = "OFF" Then
      QuitBoxIgnore = False
   End If
   If UCase$(Var$) = "ON" Then
      QuitBoxIgnore = True
   End If
End If
Var$ = Environ$("STARTBOXIGNORE")
If Len(Var$) Then
   If UCase$(Var$) = "OFF" Then
      StartBoxIgnore = False
   End If
   If UCase$(Var$) = "ON" Then
      StartBoxIgnore = True
   End If
End If
Var$ = Environ$("STARTMENUIGNORE")
If Len(Var$) Then
   If UCase$(Var$) = "OFF" Then
      StartMenuIgnore = False
   End If
   If UCase$(Var$) = "ON" Then
      StartMenuIgnore = True
   End If
End If

Var$ = Environ$("STATUSFORE")
If Len(Var$) Then
   If Int(Val(Var$)) >= 1 And Int(Val(Var$)) <= 15 Then
      StatusForeground = Int(Val(Var$))
   End If
End If
Var$ = Environ$("STATUSBACK")
If Len(Var$) Then
   If Int(Val(Var$)) >= 0 And Int(Val(Var$)) <= 7 Then
      StatusBackground = Int(Val(Var$))
   End If
End If

' store dir
CurrentDirectory = _CWD$
If Left$(CurrentDirectory, 2) = "\\" Then
   Current.Drive = "C"
Else
   Current.Drive = Left$(_CWD$, 1)
End If

Rem all commands in groups of 10..

' sorted: alarms, asciichart, analyze, autoindent, autosave..

' declares all Sic64 commands
Data "ANALYZE","FILES","HELP","INDENT","KILL","LIST","LOAD","NEW","PRINT","QUIT"
Data "RENUMBER","RUN","SAVE","WHATIS","CONTINUE","DEBUG","SHELL","SEARCH","SET","TIME"
Data "DATE","CLOCK","DIRS","DRIVES","VERSION","AUTOINDENT","SYSTEM","DECRYPT","ENCRYPT","TIMING"
Data "AUTOSAVE","BEEP","CPU","ASCIICHART","HEXCHART","STATUSLINE","ALARMS","MEMORY","SAMPLES","TOGGLE"
Data "MENU","COUNT","EDIT","WRITE","BLANK","SCREENSAVER"
Rem Added 06/15/2023
Data "CD","CHDIR","MD","MKDIR","RD","RMDIR","CLS","CD.","CD..","CD..."
Rem Added 07/01/2023
Data "WIDTH"
Rem Added 10/10/2023
Data "PLAY"
Rem Added 03/20/2024
Data "FILEMENU","SEARCHFILE","TREE"
Rem Added 04/20/2024
Data "TYPE","PROMPT","MORE"
Rem Added 07/10/2025
Data "KEYMAP"
Rem Added 08/25/2025
Data "REBOOT","SHUTDOWN"
Rem Added 11/25/2025
Data "RECENT"

' check command uses currently loaded program
'  (set to 0 for no required program loaded)
Data -1,0,0,-1,0,-1,0,-1,-1,0
Data -1,-1,-1,0,-1,0,0,-1,0,0
Data 0,0,0,0,0,0,0,0,0,0
Data -1,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,0

' check command has no parameter to specify
'  (set to -1 for no required parameter)
Data -1,0,-1,0,0,0,0,-1,0,-1
Data 0,0,0,0,-1,-1,0,-1,0,-1
Data -1,-1,0,0,-1,0,-1,0,0,-1
Data 0,-1,-1,-1,-1,0,0,0,0,0
Data 0,0,0,0,0,0,0,0,0,0
Data 0,0,0,-1,-1,-1,0,0,0,0
Data 0,0,-1,0,0,-1,-1,0

' read in commands
For Temp = 1 To MaxCommands
   Read Commands$(Temp)
Next
For Temp = 1 To MaxCommands
   Read CommandsLoaded(Temp)
Next
For Temp = 1 To MaxCommands
   Read CommandsParams(Temp)
Next
' store and sort commands
For Temp = 1 To MaxCommands
   CommandsSorted(Temp) = Commands(Temp)
Next
For Temp1 = 1 To MaxCommands
   For Temp2 = Temp1 + 1 To MaxCommands
      If CommandsSorted(Temp1) > CommandsSorted(Temp2) Then
         Swap CommandsSorted(Temp1), CommandsSorted(Temp2)
      End If
   Next
Next

' declares all Sic64 statements on left side of equation,
' each statement listed contains its own subroutine.
' listed in rows of ten.
Data "'","ENDIF","END IF","STOP","REM","MID$","LEFT$","RIGHT$","PRINT #","DPRINT"
Data "LPRINT USING","SPRINT","UPRINT","INPUT;","FORIF","FOR","NEXTIF","NEXT","CONTINUE FORIF","CONTINUE FOR"
Data "EXIT FORIF","EXIT FOR","DO UNTIL","LOOP WHILE","EXIT DO","CONTINUE DO","GOTO","GOSUB","RETURN","DO WHILE"
Data "DO","OFF","IF","ELSEIF","CASEIF ELSE","CASEIF","SELECT CASE","END SELECTIF","BEEP","SOUND"
Data "COLOR","LOCATE","CLS","SCREEN","WIDTH","WRITE #","LINE INPUT;","LINE INPUT #","INPUT #","WEND"
Data "WHILE","CONTINUE WHILE","EXIT WHILE","ELSE","LOOP UNTIL","LOOPIF","END LOOPIF","EXIT LOOPIF","LOOP","RANDOMIZE"
Data "POKE","INT86","DEFSEG","ABSOLUTE","OUT","WAIT","SLEEP","PAUSE","SELECTIF CASE","END SELECT"
Data "CASE ELSE","CASE","CONTINUE LOOPIF","END","CLEAR","SYSTEM","SWAP","ERROR","ON ERROR GOTO","ON ERROR RESUME PREVIOUS"
Data "ON ERROR RESUME SAME","ON ERROR RESUME NEXT","ON ERROR STOP","RESUME PREVIOUS","RESUME SAME","RESUME NEXT","RESUME","ON","DATE$","TIME$"
Data "CHDRIVE","CD","CHDIR","MD","MKDIR","RD","RMDIR","KILL","DELETE","RENAME"
Data "NAME","SHELL","CHAIN","LET","CLOSE #","OPEN #","FIELD #","WRITE","PRINT USING","INPUT"
Data "LINE INPUT","LSET #","RSET #","PUT #","GET #","READ #","DATA","READ","RESTORE","CIRCLE STEP"
Data "LINE STEP","PSET STEP","PRESET STEP","PAINT STEP","DRAW","PLAY","GET STEP","PUT STEP","BSAVE","BLOAD"
Data "VIEW SCREEN","VIEW","WINDOW SCREEN","WINDOW","CIRCLE","LINE","CLOSE","DEF FN","ENVIRON","PAINT"
Data "PSET","PRESET","GET","PUT","DIM","COMMON","DECLARE","LOCK #","UNLOCK #","PRINT"
Data "LPRINT","TRIANGLE","POLYGON","SQUARE","DELAY","LIMIT","SLICE","CONST"

Rem  "This program is public domain software written by:"
Data "Author: Erik Jon Oredson"
Data "Email: eoredson@gmail.com"
Data "Url: www.applewoodbbs.linkpc.net/files"

' Extended sound file extensions
Data "WAV","AIFF","AIFC","FLAC","OGG","MP3","IT","XM","S3M","MOD"
Data "RAD","AHX","HVL","MUS","HMI","HMP","HMQ","KAR","LDS","MDS"
Data "MIDS","RCP","R36","G18","G36","RMI","MID","MIDI","XFM","XMI"
Data "QOA"

' Midi soundfont file extensions
Data "AD","OP2","OPL","SF2","SF3","SFO","TMB","WOPL"

' read in statements
For Temp = 1 To MaxStatements
   Read Statements$(Temp)
Next

' read in author info
For Temp = 1 To 3
   Read AuthorStatus(Temp)
Next

' read in sound file extensions
For Temp = 1 To MaxSoundFileExtensions
   Read SoundFileExtensions(Temp)
Next

' read sound font extensions
For Temp = 1 To MaxSoundFontExtensions
   Read SoundFontExtensions(Temp)
Next

' declares indent structure types
IndentData:
' 1=indent right
Data "SELECTIF CASE",1
Data "DO WHILE",1
Data "DO",1
Data "IF",1
Data "SELECT CASE",1
Data "DO UNTIL",1
Data "FORIF",1
Data "FOR",1
Data "WHILE",1
Data "LOOPIF",1
' -1=indent left
Data "ENDIF",-1
Data "END IF",-1
Data "NEXTIF",-1
Data "NEXT",-1
Data "LOOP UNTIL",-1
Data "LOOP WHILE",-1
Data "END SELECT",-1
Data "WEND",-1
Data "END LOOPIF",-1
Data "LOOP",-1
Data "END SELECTIF",-1
' -2=indent left, then right
Data "ELSE",-2
Data "CASE",-2
Data "EOF",0

AnalyzeData1:
Data "IF","ENDIF"
Data "DO","LOOP"
Data "FOR","NEXT"
Data "WHILE","WEND"
Data "FORIF","NEXTIF"
Data "LOOPIF","END LOOPIF"
Data "SELECT CASE","END SELECT"
Data "SELECTIF CASE","END SELECTIF"

AnalyzeData2:
Data "IF","ENDIF","ELSE","ELSEIF"
Data "SELECT CASE","END SELECT","CASE ELSE","CASE"
Data "SELECTIF CASE","END SELECTIF","CASEIF ELSE","CASEIF"

AnalyzeData3:
Data "DO","LOOP","EXIT DO","CONTINUE DO"
Data "FOR","NEXT","EXIT FOR","CONTINUE FOR"
Data "WHILE","WEND","EXIT WHILE","CONTINUE WHILE"
Data "FORIF","NEXTIF","EXIT FORIF","CONTINUE FORIF"
Data "LOOPIF","END LOOPIF","EXIT LOOPIF","CONTINUE LOOPIF"

' parse command line
Filename = Read.Command$
If Filename = "/?" Or Filename = "-?" Then
   GoTo BootUsage
End If
Filename = UCase$(Filename)
Var = InStr(Filename, "/H")
If Var Then
   HelpOff = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If

Var = InStr(Filename, "/I")
If Var Then
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
   Call InitConfig(VarQ)
End If

Var = InStr(Filename, "/L2")
If Var Then
   AvoidLINUX = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 3)
End If

Var = InStr(Filename, "/L1")
If Var Then
   ForceLINUX = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 3)
End If

Var = InStr(Filename, "/T1")
If Var Then
   Creation.Time = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 3)
End If
Var = InStr(Filename, "/T2")
If Var Then
   Access.Time = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 3)
End If
Var = InStr(Filename, "/T3")
If Var Then
   Modified.Time = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 3)
End If
If Creation.Time = 0 And Access.Time = 0 And Modified.Time = 0 Then
   Creation.Time = True
End If

Var = InStr(Filename, "/R")
If Var Then
   QuitBoxIgnore = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If

Var = InStr(Filename, "/W")
If Var Then
   StartBoxIgnore = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If

Var = InStr(Filename, "/U")
If Var Then
   StartMenuIgnore = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If

Var = InStr(Filename, "/X")
If Var Then
   Compatible = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If

Var = InStr(Filename, "/Y")
If Var Then
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)

   ' reset default values
   Prompt1 = ">"
   Prompt2 = ":"
   Prompt3 = "?"
   Prompt4 = "#"
   Prompt5 = "]"
   CPUtraptype = True
   MakeBeep = True
   StatusForeground = 15
   StatusBackground = 1
End If

Var = InStr(Filename, "/Z")
If Var Then
   BootError = True
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If
Var = InStr(Filename, "/Q")
If Var Then
   StatusType = -3
   Filename = Left$(Filename, Var - 1) + Mid$(Filename, Var + 2)
End If
Filename = RTrim$(Filename)
Filename = LTrim$(Filename)
If Left$(Filename, 1) = "/" Then
   TempX$ = Mid$(Filename, 2, 1)
   If TempX$ >= "1" And TempX$ <= "9" Then
      Node = Int(Val(TempX$))
      Filename = Mid$(Filename, 3)
   Else
      If TempX$ >= "A" And TempX$ <= "F" Then
         Node = Int(Val("&H" + TempX$))
         Filename = Mid$(Filename, 3)
      Else
         GoTo BootUsage
      End If
   End If
End If
Filename = RTrim$(Filename)
Filename = LTrim$(Filename)
If InStr(Filename, " ") = False Then
   If Len(Filename) Then
      If Left$(Filename, 1) = Quote Then
         Filename = Mid$(Filename, 2)
         If Right$(Filename, 1) = Quote Then
            Filename = Left$(Filename, Len(Filename) - 1)
         Else
            Boot$ = "Command line filename error."
            GoTo BootUsageError
         End If
      End If
      If Filename = Nul Then
         Boot$ = "Command line filename error."
         GoTo BootUsageError
      End If
      If UCase$(Right$(Filename, 4)) <> ".SIC" Then
         Boot$ = "Command line filename error."
         GoTo BootUsageError
      End If
      ProgramResume = True
   End If
End If

' declare main input loop error routine
On Error GoTo ErrorRoutine

' check system type
OS$ = _OS$
If InStr(OS$, "[LINUX]") Then
   LINUX = True
End If
If InStr(OS$, "[MACOSX]") Then
   MACOSX = True
End If
If InStr(OS$, "[WINDOWS]") Then
   WINDOWS = True
End If
If InStr(OS$, "[ANDROID]") Then
   ANDROID = True
End If
' check os
If ANDROID Then
   System
End If

' check temp directory.
FX$ = "C:\TEMP"
If Node Then
   FX$ = "C:\TEMP" + Hex$(Node)
End If
If _DirExists(FX$) = False Then
   If _FileExists(FX$) Then
      f$ = FX$ + Chr$(0)
      x = DeleteFileA%(f$)
      If x Then
         Print "Delete: "; f$
      End If
   End If
   f$ = FX$ + Chr$(0)
   x = CreateDirectoryA(f$, 0)
   If x Then
      Print "Createdir: "; f$
   End If
End If
DRX = FX$ + "\"

' make backup directory
FX$ = "C:\BACKUP.SIC"
If Node Then
   FX$ = "C:\BACKUP" + Hex$(Node) + ".SIC"
End If
If _DirExists(FX$) = False Then
   If _FileExists(FX$) Then
      f$ = FX$ + Chr$(0)
      x = DeleteFileA%(f$)
      If x Then
         Print "Delete: "; f$
      End If
   End If
   f$ = FX$ + Chr$(0)
   x = CreateDirectoryA(f$, 0)
   If x Then
      Print "Createdir: "; f$
   End If
End If
DRX2 = FX$ + "\"

' start control-break timer trap. (added 01/08/2022)
t1 = _FreeTimer
On Timer(t1, TrapValue) TimerTrap
Timer(t1) On
VarQ = _Exit

' delete all old temp files
Call DelTemp("*.SC2") ' backup
Call DelTemp3("*.SC3") ' root
'Call DelTemp4("*.SC1") ' root

' restore screen coordinates
_ScreenMove WindowX, WindowY

' ProgramResume variable:
'   -1 = command line program
'    0 = immediate interpreter

' run multiple programs from command line
If Len(Filename) Then
   ' check filename first
   Var$ = Filename
   Do
      If InStr(Var$, " ") Then
         FilenameX$ = Left$(Var$, InStr(Var$, " ") - 1)
         If Right$(FilenameX$, 1) = Quote Then
            FilenameX$ = Left$(FilenameX$, Len(FilenameX$) - 1)
         End If
         If Left$(FilenameX$, 1) = Quote Then
            FilenameX$ = Mid$(FilenameX$, 2)
         End If
         Var$ = Mid$(Var$, InStr(Var$, " ") + 1)
         Var$ = LTrim$(RTrim$(Var$))
         If UCase$(Right$(FilenameX$, 4)) <> ".SIC" Then
            Color Red
            Boot$ = FilenameX$ + " is not a .sic file."
            GoTo BootUsageError
         End If
         If _FileExists(FilenameX$) = False Then
            Color Red
            Boot$ = FilenameX$ + " not found."
            GoTo BootUsageError
         End If
      Else
         Var$ = LTrim$(RTrim$(Var$))
         FilenameX$ = Var$
         If Right$(FilenameX$, 1) = Quote Then
            FilenameX$ = Left$(FilenameX$, Len(FilenameX$) - 1)
         End If
         If Left$(FilenameX$, 1) = Quote Then
            FilenameX$ = Mid$(FilenameX$, 2)
         End If
         If UCase$(Right$(FilenameX$, 4)) <> ".SIC" Then
            Color Red
            Boot$ = FilenameX$ + " is not a .sic file."
            GoTo BootUsageError
         End If
         If _FileExists(FilenameX$) = False Then
            Color Red
            Boot$ = FilenameX$ + " not found."
            GoTo BootUsageError
         End If
         Exit Do
      End If
   Loop

   ' run multiple filenames
   Var$ = Filename
   Do
      If InStr(Var$, " ") Then
         Filename = Left$(Var$, InStr(Var$, " ") - 1)
         Var$ = Mid$(Var$, InStr(Var$, " ") + 1)
         Var$ = LTrim$(RTrim$(Var$))
         If Right$(Filename, 1) = Quote Then
            If Left$(Filename, 1) = Quote Then
               Filename = Left$(Filename, Len(Filename) - 1)
               Filename = Mid$(Filename, 2)
            End If
         End If
         Filename = LTrim$(Filename)
         Filename = RTrim$(Filename)
         If Right$(Filename, 1) = Quote Then
            Filename = Left$(Filename, Len(Filename) - 1)
         End If
         If Left$(Filename, 1) = Quote Then
            Filename = Mid$(Filename, 2)
         End If
         If Filename = Nul Then
            Boot$ = "Command line filename error."
            GoTo BootUsageError
         End If
         If _FileExists(Filename) = False Then
            Boot$ = "Command line filename error."
            GoTo BootUsageError
         End If

         ProgramResume = True
         Call NewProgram
         Call ReadProgram
         RunType = False
         Call RunProgram(False)
      Else
         Var$ = LTrim$(RTrim$(Var$))
         Filename = Var$
         If Right$(Filename, 1) = Quote Then
            If Left$(Filename, 1) = Quote Then
               Filename = Left$(Filename, Len(Filename) - 1)
               Filename = Mid$(Filename, 2)
            End If
         End If
         If Right$(Filename, 1) = Quote Then
            Filename = Left$(Filename, Len(Filename) - 1)
         End If
         If Left$(Filename, 1) = Quote Then
            Filename = Mid$(Filename, 2)
         End If
         If Filename = Nul Then
            Boot$ = "Command line filename error."
            GoTo BootUsageError
         End If
         If _FileExists(Filename) = False Then
            Boot$ = "Command line filename error."
            GoTo BootUsageError
         End If
         ProgramResume = True
         Call NewProgram
         Call ReadProgram
         RunType = False
         Call RunProgram(False)
         Exit Do
      End If
   Loop
   Call StopProgram
End If

' display logon banner
V = _Height
Locate V - 1, 1, 1

Color White, Black
Print "SIC64 v" + Version + " r" + Release + " for QB64 (node " + Hex$(Node) + "):"
Print "The Symbolic Instruction Code Interpreter."

If StartBoxIgnore = False Then
   BoxText$ = "Press Yes to continue" + Chr$(13) + Chr$(10) + "Or No to continue and disable box" + Chr$(13) + Chr$(10) + "Or Cancel to quit."
   Title$ = " SICK v" + Version + " r" + Release + " (node " + Hex$(Node) + ")"
   x& = _MessageBox(Title$, BoxText$, "yesnocancel", "info")
   If x& = 0 Then System ' cancel
   If x& = 1 Then Eat$ = Nul ' yes
   If x& = 2 Then StartBoxIgnore = True ' no
End If

' declare main input loop error routine
On Error GoTo ErrorRoutine

' start statusline timer trap. (added 03/20/2022)
Call StatusLine
t2 = _FreeTimer
t3! = 1!
On Timer(t2, t3!) StatusLine
Timer(t2) On

' start autosave timer trap (added 04/10/2022)
t4 = _FreeTimer
If AutoSaveValue = False Then AutoSaveValue = AutoSaveDefault
t5! = AutoSaveValue * 60!
If AutoSave Then
   On Timer(t4, t5!) BackupProgramTimer ' autosave
   Timer(t4) On
End If

' start cpu timer trap (added 04/22/2022)
t6 = _FreeTimer
t7! = 1!
On Timer(t6, t7!) CPUtrap ' title with cpu
Timer(t6) On

' start alarm timer trap (added 05/01/2022)
t8 = _FreeTimer
t9! = 1!
On Timer(t8, t9!) CheckAlarms ' alarms
Timer(t8) On

' set screensaver timer (added 02/10/2023)
t12 = _FreeTimer
On Timer(t12, 1!) SaverTrap
Timer(t12) On

' enter the Sic64 engine
ErrorResume:

' check which function started Sic
If ProgramResume Then
   Call EndProgram
   Call StopProgram
End If
If FileNumber Then
   Close #FileNumber
   FileNumber = False
End If

' declare main input loop error routine
On Error GoTo ErrorRoutine

' enter the Sic64 programming interface
'   start sick command editor
Call StartMenu
V = _Height
Locate V - 1, 1, 1

StartLoop:
Do
   ' get input
   ValidCommand = False
   Visible = 1
   Color Yellow, Black
   Locate , 1, 1
   PromptLine = CsrLin
   Temp0 = 1
   WhatisError = True
   Call DisplayPrompt(Prompt1$)
   Color White, Black
   Locate , , 1
   PromptStore = Prompt1$
   Out2 = RTrim$(KeyboardLine2$(Prompt1))
   Print
   If Out2 = Nul Then
      ValidCommand = True
   Else
      ' check drive letter
      If Mid$(Out2, 2, 1) = ":" Then
         Call SwitchDrive(Out2)
         GoTo StartLoop
      End If
      ' check netpath
      If Left$(Out2, 3) = "\\\" Then
         Print "Unknown netpath."
         GoTo StartLoop
      End If
      If Left$(Out2, 2) = "\\" Then
         Call SwitchNetpath(Out2)
         GoTo StartLoop
      End If
      ' check path
      If Left$(Out2, 1) = "\" Then
         Call Switchpath(Out2)
         GoTo StartLoop
      End If
      ' check preceding line number
      Call EnterProgramLine
      If Assign Then
         ValidCommand = True
      Else

         ' get environment variable
         Param2$ = Nul
         Var$ = Environ$("SICCMDLINE")
         If Len(Var$) Then
            Param2$ = Var$
         End If

         ' store parameter
         Param$ = Nul
         Param3$ = Nul
         Out3 = Out2
         Out2 = UCase$(Out2)
         Parameter = InStr(Out2, "\")
         If Parameter Then
            Param$ = Mid$(Out2, Parameter + 1)
            Param2$ = Mid$(Out3, Parameter + 1)
            Param3$ = Param2$
            Out2 = Left$(Out2, Parameter - 1)
         End If
         Parameter = InStr(Out2, " ")
         If Parameter Then
            Param$ = Mid$(Out2, Parameter + 1)
            Param2$ = Mid$(Out3, Parameter + 1)
            Param3$ = Param2$
            Out2 = Left$(Out2, Parameter - 1)
         End If

         ' compare to sorted command list 1-letter count
         ValidCommand = False
         If Len(Out2) = 3 Then
            If Mid$(Out2, 2, 1) = "#" Then
               V = Int(Val(Mid$(Out2, 3, 1)))
               If V >= 1 And V <= 9 Then
                  V$ = UCase$(Left$(Out2, 1))
                  Z = False
                  For x = 1 To MaxCommands
                     If V$ = Left$(CommandsSorted(x), 1) Then
                        Z = Z + 1
                        If Z = V Then
                           Out2 = CommandsSorted(x)
                           Exit For
                        End If
                     End If
                  Next
               End If
            End If
         End If

         ' compare to command list
         For CommandNumber = 1 To MaxCommands
            ' compare command in array
            '   equals: full command, 3-letter command, 1-letter command.
            If Out2 = Commands(CommandNumber) Or Out2 = Left$(Commands(CommandNumber), 3) Or Out2 = Left$(Commands(CommandNumber), 1) Then

               ' check command uses currently loaded program
               If CommandsLoaded(CommandNumber) Then
                  If ProgramName = None Then
                     Color White, Black
                     Print "No program loaded."
                     ValidCommand = True
                     Exit For
                  End If
               End If

               ' check command has no parameter to specify
               If CommandsParams(CommandNumber) Then
                  If Len(Param$) Then
                     Exit For
                  End If
               End If

               ' process command
               ValidCommand = True
               Select Case CommandNumber
                  Case 1 ' analyze
                     Call PrepareProgram
                     Call AnalyzeProgram(-1, VarX, Var1$)
                     Call NewProgram
                     Filename = PrepareFilename
                     Call ReadProgram
                  Case 2 ' files
                     Call ListFilesX(Param$, True)
                     ErrorType2 = 0
                  Case 3 ' help
                     Call ListHelp
                  Case 4 ' indent
                     Call IndentProgram(0, Int(Val(Param$)))
                  Case 5 ' kill
                     Call DeleteProgram(Param$)
                  Case 6 ' list
                     StartLine = 1
                     Call CountLines(LastLine)
                     StopLine = LastLine
                     If Len(Param$) Then
                        Comma = InStr(Param$, ",")
                        If Comma Then
                           StartLine = Int(Val(Left$(Param$, Comma - 1)))
                           StopLine = Int(Val(Mid$(Param$, Comma + 1)))
                        Else
                           StartLine = Int(Val(Param$))
                           StopLine = LastLine
                        End If
                     End If
                     Call ListProgram(StartLine, StopLine, False)
                  Case 7 ' load
                     Call LoadProgram(Param$)
                  Case 8 ' new
                     If SaveOnExit Then
                        Call SaveCurrent
                     End If
                     LastSearchLine = False
                     Call NewProgram
                     ProgramName = None
                     Color White, Black
                     Print "Program cleared."
                  Case 9 ' print
                     StartLine = 1
                     Call CountLines(LastLine)
                     StopLine = LastLine
                     If Len(Param$) Then
                        Comma = InStr(Param$, ",")
                        If Comma Then
                           StartLine = Int(Val(Left$(Param$, Comma - 1)))
                           StopLine = Int(Val(Mid$(Param$, Comma + 1)))
                        Else
                           StartLine = Int(Val(Param$))
                           StopLine = LastLine
                        End If
                     End If
                     Call ListProgram(StartLine, StopLine, True)
                  Case 10 ' quit
                     Call QuitProgram
                  Case 11 ' renumber
                     StartLine = False
                     IncrementValue = False
                     If Len(Param$) Then
                        Comma = InStr(Param$, ",")
                        If Comma Then
                           StartLine = Int(Val(Left$(Param$, Comma - 1)))
                           IncrementValue = Int(Val(Mid$(Param$, Comma + 1)))
                        End If
                     End If
                     Call RenumberProgram(StartLine, IncrementValue)
                  Case 12 ' run
                     CommandLine = Param2$
                     If Left$(UCase$(Param2$), 5) = "LINE=" Then
                        StartNumber = Int(Val(Mid$(Param2$, 6)))
                     Else
                        StartNumber = False
                     End If
                     Color White, Black
                     Print "Starting program: " + ProgramName
                     RunType = False
                     Call RunProgram(StartNumber)
                     Color White, Black
                     If Pos(0) > 1 Then
                        Print
                     End If
                     Print "Program run ended."
                  Case 13 ' save
                     Call SaveProgram(Param$)
                  Case 14 ' whatis
                     Call CountLines(LastLine)
                     If Len(Param$) Then
                        WhatisError = -3
                     Else
                        WhatisError = -1
                     End If
                     Call WhatisCommand(Param$, 0)
                  Case 15 ' continue
                     RunType = True
                     If RunLine > MaxLines Then
                        Color White, Black
                        Print "Can't continue."
                     Else
                        Call CountLines(V%)
                        If RunLine >= V% Then
                           Color White, Black
                           Print "Can't continue."
                        Else
                           Color White, Black
                           Print "Continuing program: " + ProgramName
                           Call RunProgram(0)
                        End If
                     End If
                  Case 16 ' debug
                     Call DebugCommand(0, -1)
                  Case 17 ' shell
                     Call ShellProgram2(Param$)
                  Case 18 ' search
                     Call SearchProgram
                  Case 19 ' set
                     ' check command parameter.
                     Var2$ = Nul
                     If InStr(Param$, " ") Then
                        Var2$ = Mid$(Param$, InStr(Param$, " ") + 1)
                        Param$ = Left$(Param$, InStr(Param$, " ") - 1)
                     End If
                     Param$ = Strim$(Param$): Var2$ = Strim$(Var2$)
                     Select Case Param$
                        Case "HELP"
                           If Len(Var2$) Then
                              Select Case Var2$
                                 Case "ALARMS"
                                    Print "Alarms <menu> or none for set."
                                 Case "KEYMAP"
                                    Print "Keymap <menu> or none for set."
                                 Case "TOGGLE"
                                    Print "Toggle <menu> or none for help."
                                 Case Else
                                    Print "Unknown SET parameter. Type SET HELP for help."
                              End Select
                           Else
                              Color White
                              Print "SET parameters:"
                              Color Yellow
                              Print " Alarms  -  starts alarm menu."
                              Print " Memmenu -  starts memory usage menu."
                              Print " Prompt  -  starts set prompt menu."
                              Print " Toggle  -  starts toggle menu."
                              Print " Init    -  initializes settings."
                              Print " Keymap  -  starts keymapper menu."
                              Print " <none>  -  defaults to set prompt."
                              Color White
                              Call KeyPrompt
                           End If
                        Case "KEYMAP"
                           Call Keymapper(Var2$)
                        Case "TOGGLE"
                           If Len(Var2$) Then
                              Call ToggleMenu(Var2$)
                           Else
                              Call ToggleMenu("HELP")
                           End If
                        Case "ALARMS"
                           If Len(Var2$) Then
                              Call AlarmMenu(Var2$)
                           Else
                              Call AlarmMenu("SET")
                           End If
                        Case "MEMMENU"
                           Call MEMmenu(Var2$)
                        Case "PROMPT"
                           If Len(Var2$) Then
                              Print "Unknown SET parameter. Type SET HELP for help."
                           Else
                              Call SetPrompts
                           End If
                        Case "INIT"
                           If Len(Var2$) Then
                              Print "Unknown SET parameter. Type SET HELP for help."
                           Else
                              Call InitConfig(VarQ)
                              Print "Config init ";
                              If VarQ Then
                                 Print "success."
                              Else
                                 Print "failed."
                              End If
                           End If
                        Case Else
                           If Param$ = Nul Then
                              Call SetPrompts
                           Else
                              Print "Unknown SET parameter. Type SET HELP for help."
                           End If
                     End Select
                  Case 20 ' time
                     Color White, Black
                     Print Time$
                     Prompt$ = "Enter time(hh:mm:ss): "
                     Var$ = KeyboardLine4$(Prompt$)
                     If Len(Var$) Then
                        Call TimeFunc(Var$)
                     End If
                  Case 21 ' date
                     Color White, Black
                     Print Date$
                     Prompt$ = "Enter date(mm-dd-yyyy): "
                     Var$ = KeyboardLine4$(Prompt$)
                     If Len(Var$) Then
                        Call DateFunc(Var$)
                     End If
                  Case 22 ' clock
                     Color White, Black
                     Print clock$
                  Case 23, 61 ' dirs/tree
                     If Param$ = Nul Then Param$ = "*"
                     Call ListFilesX(Param$, False)
                     ErrorType2 = 0
                  Case 24 ' drives
                     Call ListDrives(Param$, False)
                  Case 25 ' version
                     Color White, Black
                     Print "SIC64 v" + Version + " r" + Release + " for QB64 (node " + Hex$(Node) + ")"
                     Print "Published "; PublishDate
                     Print "System: "; _OS$
                  Case 26 ' autoindent
                     If Param$ = Nul Then
                        Call SetAutoIndent(-1)
                     Else
                        If Int(Val(Param$)) > 0 And Int(Val(Param$)) <= 9 Then
                           Call SetAutoIndent(Int(Val(Param$)))
                        Else
                           Call SetAutoIndent(0)
                        End If
                     End If
                  Case 27 ' system
                     Call HaltProgram
                     End
                  Case 28 ' decrypt
                     Call DecryptProgram(Param$)
                  Case 29 ' encrypt
                     Call EncryptProgram(Param$)
                  Case 30 ' timing
                     Timing = Not Timing
                     If Timing Then
                        Print "Timing on."
                     Else
                        Print "Timing off."
                     End If
                  Case 31 ' autosave
                     Call AutoSaveMenu(Param$)
                  Case 32
                     MakeBeep = Not MakeBeep
                     If MakeBeep Then
                        Print "Beep on."
                     Else
                        Print "Beep off."
                     End If
                  Case 33
                     CPUtraptype = Not CPUtraptype
                     If CPUtraptype Then
                        Print "CPU on."
                     Else
                        Print "CPU off."
                     End If
                  Case 34
                     GoSub SaveScreenX
                     Call AsciiChart
                     Cls
                     GoSub RestoreScreenX
                     Locate ScreenHeight - 1, 1, 1
                     Call StatusLine
                  Case 35
                     GoSub SaveScreenX
                     Call HexChart
                     Cls
                     GoSub RestoreScreenX
                     Locate ScreenHeight - 1, 1, 1
                     Call StatusLine
                  Case 36
                     Call SetStatusColor(Param$)
                  Case 37
                     If Param$ <> Nul Then
                        If UCase$(Param$) = "MENU" Then
                           Call AlarmMenuFunc
                        Else
                           Call AlarmMenu(Param$)
                        End If
                     Else
                        Call AlarmMenu("HELP")
                     End If
                  Case 38
                     Call MEMmenu(Param$)
                  Case 39
                     Call Samples
                  Case 40
                     Call ToggleMenu(Param$)
                  Case 41
                     Call Menu3
                  Case 42
                     Call CountMenu(Param$)
                  Case 43
                     Call EditMenu(Param$)
                  Case 44
                     Call WriteConfig(VarQ)
                     Call WriteRecent(VarQ)
                  Case 45
                     s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
                  Case 46
                     Call ScreenSaver(Param$)
                  Case 47, 48 ' CD/CHDIR
                     Call CDdirA(Param3$)
                  Case 49, 50 ' MD/MKDIR
                     Call MDdirA(Param3$)
                  Case 51, 52 ' RD/RMDIR
                     Call RDdirA(Param3$)
                  Case 53
                     Cls
                  Case 54 ' cd.
                     Print "Current dir "; _CWD$
                  Case 55 ' cd..
                     Call CDdirA("..")
                  Case 56 ' cd...
                     Call CDdirA("...")
                  Case 57
                     Call CDwidth(Param$)
                  Case 58
                     Call PlayFunc(Param3$)
                  Case 59, 60
                     GoSub SaveScreenX
                     Timer(t2) Off
                     Call SearchFiles(Param$)
                     Timer(t2) On
                     Cls
                     GoSub RestoreScreenX
                     Locate ScreenHeight - 1, 1, 1
                     Call StatusLine
                  Case 62, 64
                     Call TypeFile(Param$)
                  Case 63
                     Call SetPrompts
                  Case 65
                     Call Keymapper(Param$)
                  Case 66
                     Call RebootFunc
                  Case 67
                     Call ShutdownFunc
                  Case 68
                     Call RecentMenu(Param$)
               End Select
               Exit For
            End If
         Next
      End If
   End If
   If ValidCommand = False Then
      Color White, Black
      Print "Type 'Help' for information."
      If HelpOff = False Then
         Color Yellow, Black
         Print "If you are entering a line of code then precede it with a line number.."
      End If
   End If
Loop
End

' screen save
SaveScreenX:
ReDim TempArrayY3(1 To 2000) As Integer
ReDim TempArrayZ3(1 To 2000) As Integer
For Var1 = 1 To ScreenHeight - 1
   For Var2 = 1 To ScreenWidth
      TempZ1 = Screen(Var1, Var2) ' screen char
      TempZ2 = Screen(Var1, Var2, 1) ' char color
      TempArrayY3((Var1 - 1) * 80 + Var2) = TempZ1
      TempArrayZ3((Var1 - 1) * 80 + Var2) = TempZ2
   Next
Next
Return

' screen restore
RestoreScreenX:
For Var1 = 1 To ScreenHeight - 2
   For Var2 = 1 To ScreenWidth
      VarB = Int(TempArrayZ3((Var1 - 1) * 80 + Var2) / 16)
      VarF = TempArrayZ3((Var1 - 1) * 80 + Var2) Mod 16
      TempZ1 = TempArrayY3((Var1 - 1) * 80 + Var2)
      Locate Var1, Var2, 1
      Color VarF, VarB
      Print Chr$(TempZ1);
   Next
Next
Return

EquateTrap:
ErrorLine = ProgramLine
ErrorValue = Err
ErrorValue2 = Err
Select Case ErrorType
   Case -1 ' previous
      Do
         ProgramLine = ProgramLine - 1
         If Len(Strim$(Program$(ProgramLine))) Then
            ProgramLine = ProgramLine - 1
            ErrorLine = False
            Resume Next
         End If
         If ProgramLine <= False Then
            Exit Do
         End If
      Loop
      ErrorLine = 0
   Case -2 ' same
      ProgramLine = ProgramLine - 1
      ErrorLine = 0
      Resume Next
   Case -3 ' next
      Do
         ProgramLine = ProgramLine + 1
         If Len(Strim$(Program$(ProgramLine))) Then
            ProgramLine = ProgramLine - 1
            ErrorLine = 0
            Resume Next
         End If
         If ProgramLine >= LastLine Then
            ProgramLine = LastLine
            ErrorLine = 0
            Resume Next
         End If
      Loop
      ErrorLine = 0
   Case 0 ' stop
      Eat$ = Nul
   Case Is > 0 ' line number
      ProgramLine = ErrorType
      If Len(Strim$(Program$(ProgramLine))) Then
         ProgramLine = ProgramLine - 1
         Resume Next
      End If
End Select
PrinterLF = False
Printing = False
ProgramLine = MaxLines
If Pos(0) > 1 Then
   Print
End If
Call ResetScreen
Out2 = Nul
If WhatisError = True Then
   If Temp0 = 1 Then
      Prompt1 = ">"
   End If
   If Temp0 = 2 Then
      Prompt2 = ":"
   End If
   If Temp0 = 3 Then
      Prompt3 = "?"
   End If
   If Temp0 = 4 Then
      Prompt4 = "#"
   End If
   If Temp0 = 5 Then
      Prompt5 = "]"
   End If
End If
If BootError = False Then
   Call DisplayError
End If
' error in debug or whatis
If WhatisError = -2 Then
   Resume Next
End If
If WhatisError = -3 Then
   Resume ErrorResume
End If
Call KeyPrompt
If WhatisError Then
   WhatisError = 0
   BootError = BootStore
End If
ProgramLine = LastLine

' read original program
If ProgramRunning Then
   Call RestoreProgram
End If
ProgramRunning = 0
Resume ErrorResume

' display error and exit
'  added 07/10/2025.
BootUsageError:
Locate _Height - 1, 1, 1
Color White, Black
Print Boot$
Color Yellow, Black
Print "  Check command line or try /? for usage."
Color Plain, Black
Print "Returning to System:"
If t1 Then
   Timer(t1) Off
End If
End

' display boot usage and quit
BootUsage:
Color White, Black
Print "SIC64 v" + Version + " r" + Release + " Usage: for QB64 (node " + Hex$(Node) + "):"
Color Yellow, Black
Print "SIC64 [/n][/H][/I][/Q][/R][/U][/W][/X][/Y][/Z][/L<n>][/T<n>]"
Color Green, Black
Print "  Starts SIC"
Color Yellow, Black
Print "SIC64 [/n][/H][/I][/Q][/R][/U][/W][/X][/Y][/Z][/L<n>][/T<n>] <program name>"
Color Green, Black
Print "  Starts SIC64 and runs program."
Color White, Black
Print "Optional switches:"
Print " /n is node 1 to 9, A to F"
Print " /H disable help line"
Print " /I init config"
Print " /Q disable statusline"
Print " /R disable quitbox"
Print " /U ignore startmenu"
Print " /W ignore startbox"
Print " /X disable compatible"
Print " /Y reset prompts"
Print " /Z disable error display"
Print " /L<n> override linux"
Print "   where <n> is 1=force linux/2=avoid linux"
Print " /T<n> override whereis file date/time"
Print "   where <n> is 1=creation/2=access/3=modified"
Color Plain, Black
Print "Returning to System:"
Call StopProgram
End

' critical error trap for exit
ErrorRoutineX:
System

' error trap for nothing
NulErrorRoutine:
Resume Next

' standard error trap for all Sic64 functions.
ErrorRoutine:

' check share violation
If ErrorType2 Then
   If Err = 70 Then
      ErrorCount = ErrorCount + 1
      If ErrorCount < MaxViolations Then ' could use timer
         Resume
      End If
   End If
End If

' reset variables
ErrorCount = 0
PrinterLF = False
Printing = False
ErrorLine = ProgramLine
ErrorValue = Err
ErrorValue2 = Err
If Pos(0) > 1 Then
   Print
End If
Out2 = Nul
If WhatisError = True Then
   If Temp0 = 1 Then
      Prompt1 = ">"
   End If
   If Temp0 = 2 Then
      Prompt2 = ":"
   End If
   If Temp0 = 3 Then
      Prompt3 = "?"
   End If
   If Temp0 = 4 Then
      Prompt4 = "#"
   End If
   If Temp0 = 5 Then
      Prompt5 = "]"
   End If
End If
If BootError = False Then
   Call DisplayError
End If
Call KeyPrompt
If WhatisError Then
   WhatisError = 0
   BootError = BootStore
End If
InDEFSEG = False
ProgramLine = LastLine

' read original program
If ProgramRunning Then
   Call RestoreProgram
End If
ProgramRunning = 0
Resume ErrorResume

' standard startup error trap.
ErrorRoutine2:
If ProgramResume = False Then
   Print "SIC64 is terminating because of an error loading."
   Print "Returning to system with error:";
   Select Case Err
      Case 7
         Print " Out of memory."
         Print "Free more RAM and restart."
      Case 14
         Print " Out of string space."
         Print "Free more RAM and restart."
      Case Else
         Print Err
   End Select
End If
If ProgramResume Then
   Print "Error"; Err
End If
Color Plain, Black
End

Sub StartMenu
   Static Displayed As Integer
   If Displayed Then Exit Sub
   Displayed = True
   If StartMenuIgnore Then
      Exit Sub
   End If
   Cls
   Color White, BBlue
   Print "Welcome to the SICK interpreter v"; Version$; " r"; Release$; " (node "; Hex$(Node); ")";
   Print " Published "; PublishDate
   Color White, Black
   Filename = "menu5.doc"
   If _FileExists(Filename) Then
      Print "Command list:"
      Color Yellow, Black
      H = FreeFile
      Open Filename For Input As #H
      Do Until EOF(H)
         Line Input #H, V$
         Print V$
      Loop
      Close H
   End If
   Color White
   Print "Enter code or commands here:"
   Locate _Height - 1, 1, 1
End Sub

Function VerifyPlay (Inpt$)
   VerifyPlay = False
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      For V = 1 To MaxSoundFileExtensions
         If Var$ = SoundFileExtensions(V) Then
            VerifyPlay = True
            Exit Function
         End If
      Next
   End If
End Function

Function VerifyPlay2 (Inpt$)
   VerifyPlay2 = False
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      For V = 1 To MaxSoundFileExtensions
         If Var$ = SoundFileExtensions(V) Then
            VerifyPlay2 = True
            Exit Function
         End If
      Next
   End If
End Function

Function VerifyFile (Inpt$)
   VerifyFile = False
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "COM", "EXE"
            VerifyFile = True
      End Select
   End If
End Function

Function VerifyFile2 (Inpt$)
   VerifyFile2 = False
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "OBJ", "LIB", "DLL", "QLB"
            VerifyFile2 = True
      End Select
   End If
End Function

Function VerifyFile3 (Inpt$)
   VerifyFile3 = False
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "C", "H", "BI", "ASM", "INC", "BAS", "SIC"
            VerifyFile3 = True
      End Select
   End If
End Function

Function VerifyFile4 (Inpt$)
   VerifyFile4 = False
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "TXT", "DOC", "LST"
            VerifyFile4 = True
      End Select
   End If
End Function

Function VerifyFile5 (Inpt$)
   VerifyFile5 = False
   If ValidFileChar(Inpt$) Then
      Exit Function
   End If
   Var$ = UCase$(Inpt$)
   For X = Len(Var$) To 1 Step -1
      If Mid$(Var$, X, 1) = "." Then
         Var$ = Mid$(Var$, X + 1)
      End If
   Next
   If Len(Var$) Then
      Select Case Var$
         Case "ZIP", "RAR", "TAR", "GZ", "7Z"
            VerifyFile5 = True
      End Select
   End If
End Function

Sub PlayFunc (x1$)
   x1$ = RTrim$(LTrim$(x1$))
   If Len(x1$) Then
      z$ = x1$
      If Left$(z$, 1) = Quote And Right$(z$, 1) = Quote Then
         z$ = Left$(z$, Len(z$) - 1)
         z$ = Mid$(z$, 2)
      End If
      If LCase$(z$) = "help" Then
         Color Yellow
         Print "PLAY <parameter$>"
         Print "  Loads and plays the soundfile into a buffered stream."
         Print "  Where parameter is:"
         Print "    <filename>  -  plays specified file with extension of:"

         Print "     WAV, AIFF, AIFC, FLAC, OGG, MP3, IT, XM, S3M, MOD,"
         Print "     RAD, AHX, HVL, MUS, HMI, HMP, HMQ, KAR, LDS, MDS,"
         Print "     MIDS, RCP, R36, G18, G36, RMI, MID, MIDI, XFM, XMI, QOA"

         Print "    FONT  -  prompt filename to change music font of extension:"
         Print "     AD, OP2, OPL, SF2, SF3, SFO, TMB, WOPL."

         Print "    LENGTH - displays current sound handle and time."
         Print "    LIST  -  lists all audio files."
         Print "    LOAD  -  prompt filename to load and play."
         Print "    TYPES - displays list of sound extensions."
         Print "    STOP  -  stops current file being played."
         Print "    PAUSE -  pauses playmode."
         Print "    RESUME -  resume playmode."
         Print "    RESTART - resets current sound file and volume."
         Print "    MOVE <seconds>  -  moves position of file playing plus 10 seconds."
         Print "      <seconds> can also be +<n> or -<n> where n is seconds."
         Color White
         Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(z$) = "types" Then
         Call DisplayFontFilesX
         Exit Sub
      End If
      If LCase$(z$) = "list" Then
         $If VERSION >= 4.0.0 Then
            Found = False
            For V = 1 To MaxSoundFileExtensions
               Var$ = "*." + SoundFileExtensions(V)
               If _Files$(Var$) <> Nul Then ' new feature
                  Found = True
                  Call ListFiles(Var$, -1)
                  Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
               End If
            Next
            If Found = False Then
               Print "No files found."
               Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
            End If
            Exit Sub
         $End If
         ' old music
         Var$ = "*.MP3"
         Call ListFiles(Var$, -1)
         Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(z$) = "length" Then
         If SoundHandle <> 0 Then
            If Len(SoundFile) Then
               Print "Soundfile: "; SoundFile
            End If
            S& = _SndLen(SoundHandle)
            S$ = Str$(S&)
            If InStr(S$, ".") Then
               S$ = Left$(S$, InStr(S$, ".") + 2)
            End If
            Print "Handle"; SoundHandle; "is"; S$; " seconds.";
            S& = _SndGetPos(SoundHandle)
            S$ = Str$(S&)
            If InStr(S$, ".") Then
               S$ = Left$(S$, InStr(S$, ".") + 1)
            End If
            Print " Position is"; S$; " seconds."
            If _SndPaused(SoundHandle) = True Then
               Print "  File is paused."
            End If
            Exit Sub
         End If
      End If
      If LCase$(z$) = "restart" Then
         If SoundHandle <> 0 Then
            Print "File restarted."
            _SndPlay SoundHandle
            SoundVolume = 1!
            _SndVol SoundHandle, SoundVolume
            Exit Sub
         End If
      End If
      If LCase$(Left$(z$, 4)) = "move" Then
         If SoundHandle <> 0 Then
            z$ = LTrim$(Mid$(z$, 5))
            If Left$(z$, 1) = "+" Then
               z! = Val(Mid$(z$, 2))
               z2! = _SndGetPos(SoundHandle)
               z2! = z2! + z!
               _SndSetPos SoundHandle, z2!
               Exit Sub
            End If
            If Left$(z$, 1) = "-" Then
               z! = Val(Mid$(z$, 2))
               z2! = _SndGetPos(SoundHandle)
               z2! = z2! - z!
               If z2! < SFalse Then
                  z2! = SFalse
               End If
               If z2! >= SFalse Then
                  _SndSetPos SoundHandle, z2!
               End If
               Exit Sub
            End If
            If LTrim$(RTrim$(z$)) = Nul Then
               z! = 10!
            Else
               z! = Val(z$)
            End If
            z2! = _SndGetPos(SoundHandle)
            z2! = z2! + z!
            _SndSetPos SoundHandle, z2!
            Exit Sub
         End If
      End If
      If LCase$(z$) = "stop" Then
         If SoundHandle <> 0 Then
            _SndStop SoundHandle
            _SndClose SoundHandle
            SoundHandle = False
            Print "File closed."
         Else
            Print "File not loaded."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "pause" Then
         If SoundHandle <> 0 Then
            If _SndPaused(SoundHandle) = False Then
               _SndPause SoundHandle
               Print "File paused."
            End If
         Else
            Print "File not loaded."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "resume" Then
         If SoundHandle <> 0 Then
            If _SndPaused(SoundHandle) = True Then
               _SndPlay SoundHandle
               Print "File resume."
            End If
         Else
            Print "File not loaded."
         End If
         Exit Sub
      End If
      If LCase$(z$) = "load" Then
         ' load soundfile
         '   compatible with Linux
         VarX$ = Nul
         For Temp = 1 To MaxSoundFileExtensions
            VarX$ = VarX$ + "|*." + LCase$(RTrim$(SoundFileExtensions(Temp)))
         Next
         For Temp = 1 To MaxSoundFileExtensions
            VarX$ = VarX$ + "|*." + UCase$(RTrim$(SoundFileExtensions(Temp)))
         Next
         SoundFile = Nul
         Filter$ = "All files (*.*)" + VarX$
         Title$ = "SICK Open Sound File"
         Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
         If Len(Filename) Then
            ' play a music file.
            If VerifyPlay2(Filename) Then
               Color Yellow
               If SoundHandle <> 0 Then
                  _SndStop SoundHandle
                  _SndClose SoundHandle
               End If
               Print "Loading file: "; Filename
               SoundHandle = _SndOpen(Filename) ' get file handle
               If SoundHandle <> 0 Then
                  SoundFile = Filename
                  SoundVolume = 1!
                  _SndVol SoundHandle, SoundVolume
                  S& = _SndLen(SoundHandle)
                  S$ = Str$(S&)
                  If InStr(S$, ".") Then
                     S$ = Left$(S$, InStr(S$, ".") + 2)
                  End If
                  Print "Handle"; SoundHandle; "is"; S$; " seconds."
                  _SndPlay SoundHandle
                  Color White
                  Call MorePrompt("-more-", " " + Chr$(13), Outpt2$)
               End If
            Else
               Print "Filename "; Filename; " not found."
            End If
         End If
         Exit Sub
      End If
      If LCase$(z$) = "font" Then
         ' store font extensions
         '   compatible with Linux
         $If VERSION < 4.0.0 Then
            Print "Soundfont not supported."
            Exit  Sub
         $End If
         VarX$ = Nul
         For Temp = 1 To MaxSoundFontExtensions
            VarX$ = VarX$ + "|*." + LCase$(RTrim$(SoundFontExtensions(Temp)))
         Next
         For Temp = 1 To MaxSoundFontExtensions
            VarX$ = VarX$ + "|*." + UCase$(RTrim$(SoundFontExtensions(Temp)))
         Next
         Filter$ = "All files (*.*)" + VarX$
         Title$ = "SICK Open Font File"
         Filename = _OpenFileDialog$(Title$, StartDir$, Filter$)
         If Len(Filename) Then
            For Temp = 1 To MaxSoundFontExtensions
               Var$ = "." + LCase$(SoundFontExtensions(Temp))
               If LCase$(Right$(Filename, Len(Var$))) = Var$ Then
                  $If VERSION >= 4.0.0 Then
                     _MIDISoundBank Filename ' "sf2"
                     Print "Sound font: " + Quote + Filename + Quote + " loaded."
                  $End If
                  Exit Sub
               End If
            Next
         End If
         Print "Soundfont file not found."
         Exit Sub
      End If
      If LCase$(z$) = "melody" Then
         VarZ$ = Melody$
         Play VarZ$
         Exit Sub
      End If
      If LCase$(z$) = "melody2" Then
         VarZ$ = Melody2$
         Play VarZ$
         Exit Sub
      End If
      If _FileExists(z$) Then
         If VerifyPlay(z$) Then
            Print "Loading file: "; z$
            If SoundHandle <> 0 Then
               _SndStop SoundHandle
               _SndClose SoundHandle
            End If
            SoundHandle = _SndOpen(z$) ' get file handle
            If SoundHandle = False Then
               Print "Sound file not found."
            Else
               SoundFile = z$
               _SndPlay SoundHandle
            End If
         Else
            Print "Sound file not found."
         End If
      Else
         Print "Sound file not found."
      End If
   Else
      Print "Sound file not found."
   End If
End Sub

Sub DisplayFontFilesX
   Color Yellow
   Print "Soundfile extension list:"
   Color Plain
   VarX$ = Nul
   For V = 1 To MaxSoundFileExtensions - 20
      VarX$ = VarX$ + "." + SoundFileExtensions(V) + ","
   Next
   Print Left$(VarX$, Len(VarX$) - 1)
   VarX$ = Nul
   For V = 11 To MaxSoundFileExtensions - 10
      VarX$ = VarX$ + "." + SoundFileExtensions(V) + ","
   Next
   Print Left$(VarX$, Len(VarX$) - 1)
   VarX$ = Nul
   For V = 21 To MaxSoundFileExtensions
      VarX$ = VarX$ + "." + SoundFileExtensions(V) + ","
   Next
   Print Left$(VarX$, Len(VarX$) - 1)
   Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
   Color Yellow
   Print "Soundfont extension list:"
   Color Plain
   VarX$ = Nul
   For V = 1 To MaxSoundFontExtensions
      VarX$ = VarX$ + "." + SoundFontExtensions(V) + ","
   Next
   Print Left$(VarX$, Len(VarX$) - 1)
   Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
End Sub

' move to dir
Sub CDdirA (Var$) ' CD
   Dim ASCIIZ As String * 260
   If Left$(Var$, 1) = Quote And Right$(Var$, 1) = Quote Then
      Var$ = Left$(Var$, Len(Var$) - 1)
      Var$ = Mid$(Var$, 2)
   End If
   If Var$ = "." Or Var$ = Nul Then
      Print "Current dir "; _CWD$
      Exit Sub
   End If
   Print "Moving: "; Var$
   ' move to multiple retracting dots.
   If Var$ = String$(Len(Var$), ".") Then
      VarX = Len(Var$)
      If VarX >= 2 Then
         For VarZ = 1 To VarX - 1
            ASCIIZ = ".." + Chr$(0)
            x = SetCurrentDirectoryA(ASCIIZ)
         Next
         Exit Sub
      End If
   End If
   ' replace ...
   Do
      VarX = InStr(Var$, "...")
      If VarX Then
         Var$ = Left$(Var$, VarX - 1) + "..\.." + Mid$(Var$, VarX + 3)
      Else
         Exit Do
      End If
   Loop
   ' move to dir
   ASCIIZ = Var$ + Chr$(0)
   x = SetCurrentDirectoryA(ASCIIZ)
   If x = 0 Then
      Print "Error changing path."
      VarQ$ = DisplayWinError$(x)
      If Len(VarQ$) Then
         Print VarQ$
      End If
   End If
End Sub

' make dir
Sub MDdirA (Var$) ' MD
   If Left$(Var$, 1) = Quote And Right$(Var$, 1) = Quote Then
      Var$ = Left$(Var$, Len(Var$) - 1)
      Var$ = Mid$(Var$, 2)
   End If
   Print "Creating: "; Var$
   ' replace ...
   Do
      VarX = InStr(Var$, "...")
      If VarX Then
         Var$ = Left$(Var$, VarX - 1) + "..\.." + Mid$(Var$, VarX + 3)
      Else
         Exit Do
      End If
   Loop
   x = CreateDirectoryStructure(Var$)
   If x = 0 Then
      Print "Error making path."
      VarQ$ = DisplayWinError$(x)
      If Len(VarQ$) Then
         Print VarQ$
      End If
   End If
End Sub

' remove dir
Sub RDdirA (Var$) ' RD
   If Left$(Var$, 1) = Quote And Right$(Var$, 1) = Quote Then
      Var$ = Left$(Var$, Len(Var$) - 1)
      Var$ = Mid$(Var$, 2)
   End If
   If Var$ = Nul Or Var$ = "\" Then
      Print "Error removing path."
      Exit Sub
   End If
   If Var$ = String$(Len(Var$), ".") Then
      Print "Error removing path."
      Exit Sub
   End If
   ' check C: and C:\
   If Mid$(Var$, 2, 1) = ":" Then
      DeleteDrive = False
      If Len(Var$) = 2 Then DeleteDrive = True
      If Len(Var$) = 3 Then If Right$(Var$, 1) = "\" Then DeleteDrive = True
      If DeleteDrive Then
         If Left$(UCase$(Var$), 1) >= "A" And Left$(UCase$(Var$), 1) <= "Z" Then
            Eat$ = Nul
         Else
            Print "Invalid drive letter."
            Exit Sub
         End If
         ' check drive
         V = Asc(Left$(UCase$(Var$), 1)) - 64
         If DRIVEEXISTS(V) Then
            Print "Drive exists error accessing drive."
            Exit Sub
         End If
         If MEDIAEXISTS(V) = False Then
            Print "Media exists error accessing drive."
            Exit Sub
         End If
         If DriveType = "[CDROM]" Then
            Print "Error accessing ROM drive."
            Exit Sub
         End If
         ' prompt to remove drive root.
         Print "Delete drive " + Quote + Var$ + Quote + " and all subdirectories/filenames(y/n)? ";
         Do
            x$ = InKeyx$
            If LCase$(x$) = "n" Then Print "n": Exit Sub
            If LCase$(x$) = "y" Then
               Print "y"
               Print "Removing drive: "; Var$
               If Right$(Var$, 1) <> "\" Then Var$ = Var$ + "\"
               Call Silentdel_Directories(Var$)
               Exit Sub
            End If
         Loop
      End If
   End If
   ' replace ...
   VarX$ = Var$
   Do
      VarX = InStr(Var$, "...")
      If VarX Then
         Var$ = Left$(Var$, VarX - 1) + "..\.." + Mid$(Var$, VarX + 3)
      Else
         Exit Do
      End If
   Loop
   ' check  C:\path and \path
   If _DirExists(Var$) = False Then
      Print "Directory not found."
   Else
      Deletedir = False
      Print "Delete directory " + Quote + VarX$ + Quote + " and all filenames(y/n)? ";
      Do
         x$ = InKeyx$
         If LCase$(x$) = "y" Then Print: Deletedir = True: Exit Do
         If LCase$(x$) = "n" Then Print: Deletedir = False: Exit Do
      Loop
      If Deletedir Then
         Print "Removing: "; Var$
         If Right$(Var$, 1) <> "\" Then Var$ = Var$ + "\"
         Call Silentdel_Directories(Var$)
         If _DirExists(Var$) Then
            Print "Error removing path."
         End If
      End If
   End If
End Sub

' move to drive
Sub SwitchDrive (Var$)
   Dim ASCIIZ As String * 260
   Var1$ = UCase$(Left$(Var$, 1))
   Var2$ = Var$
   Var3$ = Mid$(Var$, 3)

   If Var1$ >= "A" And Var1$ <= "Z" Then
      ' check drive
      V = Asc(Var1$) - 64
      If DRIVEEXISTS(V) Then
         Print "Drive exists error accessing drive."
         Exit Sub
      End If
      If MEDIAEXISTS(V) = False Then
         Print "Media exists error accessing drive."
         Exit Sub
      End If

      ' make drive/path
      If Len(Var3$) Then
         ASCIIZ = Var2$ + Chr$(0)
         x = SetCurrentDirectoryA(ASCIIZ)
         If x = 0 Then
            Print "Error switching drive."
            VarQ$ = DisplayWinError$(x)
            If Len(VarQ$) Then
               Print VarQ$
            End If
         End If
         Exit Sub
      End If

      ' make directory name
      ASCIIZ = Var1$ + ":\" + Chr$(0)
      x = SetCurrentDirectoryA(ASCIIZ)
      If x = 0 Then
         Print "Error switching drive."
         VarQ$ = DisplayWinError$(x)
         If Len(VarQ$) Then
            Print VarQ$
         End If
      End If
      Exit Sub
   End If
   Print "Drive letter error accessing drive."
End Sub

' move to netpath
Sub SwitchNetpath (Var$)
   Dim ASCIIZ As String * 260
   ASCIIZ = Var$ + Chr$(0)
   x = SetCurrentDirectoryA(ASCIIZ)
   If x = 0 Then
      Print "Error switching netpath."
      VarQ$ = DisplayWinError$(x)
      If Len(VarQ$) Then
         Print VarQ$
      End If
   End If
End Sub

' move to netpath
Sub Switchpath (Var$)
   Dim ASCIIZ As String * 260
   ASCIIZ = Var$ + Chr$(0)
   x = SetCurrentDirectoryA(ASCIIZ)
   If x = 0 Then
      Print "Error switching path."
      VarQ$ = DisplayWinError$(x)
      If Len(VarQ$) Then
         Print VarQ$
      End If
   End If
End Sub

' screen saver timer trap.
Sub SaverTrap
   If ScreenSaverActive = False Then
      Exit Sub
   End If
   If KeyPressed Then
      KeyPressed = False
      ScreenSaverTimer = Timer ' reset current timer
      ScreenSaverStart = Timer ' reset starting timer
      Exit Sub
   End If
   If ScreenSaverResolution = SFalse Then
      Exit Sub
   End If
   If ScreenSaverTimer = SFalse Then
      Exit Sub
   End If

   ' start screen saver
   Elapsed! = Timer - ScreenSaverTimer
   If Elapsed! < SFalse Then Elapsed! = Elapsed! + 86400!
   If Elapsed! >= ScreenSaverResolution Then
      ScreenSaverTimer = SFalse ' disable timer until next keypress.
      ScreenSaverStart = Timer ' reset starting timer
      s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
   End If
End Sub

' timer ctrl-break trap. (added 01/08/2022)
Sub TimerTrap
   VarQ = _Exit

   ' Alt-F4/windows X
   If VarQ = 1 Then
      Call StopProgram
   End If

   ' control-break
   If VarQ = 2 Then
      ControlBreak = True
      Quit.Searching = True
      ' trap keypress
      Do
         X = _KeyHit
         If X = 0 Then
            Exit Do
         End If
      Loop
      ' trap ctrl-c
      Trap1:
      While InKeyx$ <> Nul
         Eat$ = InKeyx$
      Wend
      _Delay DelayValue
      If InKeyx$ = Chr$(3) Then GoTo Trap1
   End If

   ' both windows X and ctrl-break
   If VarQ = 3 Then
      Call StopProgram
   End If
End Sub

Sub ToggleMenu (Param$)
   If Len(Param$) Then
      Select Case UCase$(Param$)
         Case "MENU"
            Call ToggleMenuEdit
         Case "KEYTIMER"
            KeyboardTimer = Not KeyboardTimer
            If KeyboardTimer Then
               Print "Keyboardline timer off."
            Else
               Print "Keyboardline timer on."
            End If
            Call KeyPrompt
         Case "LIST"
            Color White
            Print "Toggle list."
            Color Yellow
            If AutoSaveAlert Then
               Print "Autosave alert on."
            Else
               Print "Autosave alert off."
            End If
            If HelpOff Then
               Print "Help line display off."
            Else
               Print "Help line display on."
            End If
            If LINUX Then
               Print "Linux on."
            Else
               Print "Linux off."
            End If
            If MACOSX Then
               Print "Macosx on."
            Else
               Print "Macosx off."
            End If
            If MakeBeep Then
               Print "Beep on."
            Else
               Print "Beep off."
            End If
            If CPUtraptype Then
               Print "CPU on."
            Else
               Print "CPU off."
            End If
            If MEMtraptype Then
               Print "Memory trap on."
            Else
               Print "Memory trap off."
            End If
            If AutoIndent Then
               Print "Autoindent on."
            Else
               Print "Autoindent off."
            End If
            Print "Screenedit: ";
            Select Case DotDisplay
               Case 0
                  Print "Dot display."
               Case -1
                  Print "Percent display."
               Case -2
                  Print "Progress display."
               Case Else
                  Print "Dot display."
                  DotDisplay = False
            End Select
            Print "Filename date/time: ";
            If Creation.Time Then
               Print "Creation"
            Else
               If Access.Time Then
                  Print "Access"
               Else
                  If Modified.Time Then
                     Print "Modified"
                  Else
                     Print "<none>"
                  End If
               End If
            End If
            If KeyboardTimer Then
               Print "Keyboardline timer off."
            Else
               Print "Keyboardline timer on."
            End If
            If StartMenuIgnore Then
               Print "StartMenuIgnore on."
            Else
               Print "StartMenuIgnore off."
            End If
            If StartBoxIgnore Then
               Print "StartBoxIgnore on."
            Else
               Print "StartBoxIgnore off."
            End If
            If QuitBoxIgnore Then
               Print "QuitBoxIgnore on."
            Else
               Print "QuitBoxIgnore off."
            End If
            Color White
            Call KeyPrompt
         Case "HELP"
            Color White
            Print "Toggle parameters:"
            Color Yellow
            Print "  ALERT - autosave alert."
            Print "  BEEP  - beep break override."
            Print "  CPU   - cpu titlebar display."
            Print "  DATETIME - filename date/time display."
            Print "  COMPATIBLE - linux/macos compatible mode."
            Print "  HELPOFF  - help line display setting."
            Print "  AVOIDLINUX - skip linux binary read/write mode."
            Print "  FORCELINUX - linux binary read/write mode."
            Print "  MENU   - start toggle menu."
            Print "  MEM    - mem titlebar display."
            Print "  INDENT - program autoindent."
            Print "  LIST   - list current settings."
            Print "  LINUX  - toggle Linux used."
            Print "  MACOSX - toggle Macosx used."
            Print "  STATUS - toggle screen edit load/store display."
            Print "  KEYTIMER - toggle keyboardline function timer."
            Print "  STARTMENUIGNORE - toggle startup menu display"
            Print "  STARTBOXIGNORE - toggle startup dialogbox"
            Print "  QUITBOXIGNORE - toggle quit dialogbox"
            Color White
            Call KeyPrompt
         Case "STATUS"
            Select Case DotDisplay
               Case 0
                  DotDisplay = -1
               Case -1
                  DotDisplay = -2
               Case -2
                  DotDisplay = 0
               Case Else
                  DotDisplay = 0
            End Select
            Print "Screenedit: ";
            Select Case DotDisplay
               Case 0
                  Print "Dot display."
               Case -1
                  Print "Percent display."
               Case -2
                  Print "Progress display."
               Case Else
                  Print "Dot display."
                  DotDisplay = False
            End Select
         Case "DATETIME"
            If Creation.Time Then
               Creation.Time = False
               Access.Time = True
               Modified.Time = False
            Else
               If Access.Time Then
                  Creation.Time = False
                  Access.Time = False
                  Modified.Time = True
               Else
                  If Modified.Time Then
                     Creation.Time = True
                     Access.Time = False
                     Modified.Time = False
                  Else
                     Creation.Time = True
                     Access.Time = False
                     Modified.Time = False
                  End If
               End If
            End If
            Print "Filename date/time: ";
            If Creation.Time Then
               Print "Creation"
            Else
               If Access.Time Then
                  Print "Access"
               Else
                  If Modified.Time Then
                     Print "Modified"
                  Else
                     Print "<none>"
                  End If
               End If
            End If
         Case "STARTMENUIGNORE"
            StartMenuIgnore = Not StartMenuIgnore
            If StartMenuIgnore Then
               Print "StartMenuIgnore on."
            Else
               Print "StartMenuIgnore off."
            End If
         Case "STARTBOXIGNORE"
            StartBoxIgnore = Not StartBoxIgnore
            If StartBoxIgnore Then
               Print "StartBoxIgnore on."
            Else
               Print "StartBoxIgnore off."
            End If
         Case "QUITBOXIGNORE"
            QuitBoxIgnore = Not QuitBoxIgnore
            If QuitBoxIgnore Then
               Print "QuitBoxIgnore on."
            Else
               Print "QuitBoxIgnore off."
            End If
         Case "ALERT"
            AutoSaveAlert = Not AutoSaveAlert
            If AutoSaveAlert Then
               Print "Autosave alert on."
            Else
               Print "Autosave alert off."
            End If
         Case "COMPATIBLE"
            Compatible = Not Compatible
            If Compatible Then
               Print "Linux compatible on."
            Else
               Print "Linux compatible off."
            End If
         Case "HELPOFF"
            HelpOff = Not HelpOff
            If HelpOff Then
               Print "Help line display off."
            Else
               Print "Help line display on."
            End If
         Case "AVOIDLINUX"
            AvoidLINUX = Not AvoidLINUX
            If AvoidLINUX Then
               Print "Linux skip read/write on."
            Else
               Print "Linux skip read/write off."
            End If
         Case "FORCELINUX"
            ForceLINUX = Not ForceLINUX
            If ForceLINUX Then
               Print "Linux read/write on."
            Else
               Print "Linux read/write off."
            End If
         Case "LINUX"
            LINUX = Not LINUX
            If LINUX Then
               Print "Linux on."
            Else
               Print "Linux off."
            End If
         Case "MOCOSX"
            MACOSX = Not MACOSX
            If MACOSX Then
               Print "Macosx on."
            Else
               Print "Macosx off."
            End If
         Case "BEEP"
            MakeBeep = Not MakeBeep
            If MakeBeep Then
               Print "Beep on."
            Else
               Print "Beep off."
            End If
         Case "CPU"
            CPUtraptype = Not CPUtraptype
            If CPUtraptype Then
               Print "CPU on."
            Else
               Print "CPU off."
            End If
         Case "MEM"
            MEMtraptype = Not MEMtraptype
            If MEMtraptype Then
               Print "Memory trap on."
            Else
               Print "Memory trap off."
            End If
         Case "INDENT"
            Call SetAutoIndent(-1)
         Case Else
            Print "Unknown toggle parameter. Type TOGGLE HELP."
      End Select
   Else
      Print "Unknown toggle parameter. Type TOGGLE HELP."
   End If
End Sub

Sub ToggleMenuEdit
   Do
      Color White
      Print "Toggle Menu Editor for ";
      Color Red
      Print StartDir
      Color Yellow
      Print "  (1)Keyboard timer: ";
      If KeyboardTimer Then
         Print "off."
      Else
         Print "on."
      End If
      Print "  (2)List settings"
      Print "  (3)List toggle options"
      Print "  (4)Display type: ";
      Select Case DotDisplay
         Case 0
            Print "Dot display."
         Case -1
            Print "Percent display."
         Case -2
            Print "Progress display."
         Case Else
            Print "Dot display."
            DotDisplay = False
      End Select
      Print "  (5)Filename date/time: ";
      If Creation.Time Then
         Print "Creation"
      Else
         If Access.Time Then
            Print "Access"
         Else
            If Modified.Time Then
               Print "Modified"
            Else
               Print "<none>"
            End If
         End If
      End If
      Print "  (6)Autosave alert: ";
      If AutoSaveAlert Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (7)Linux compatible: ";
      If Compatible Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (8)Help line: ";
      If HelpOff Then
         Print "off."
      Else
         Print "on."
      End If
      Print "  (9)Linux skip: ";
      If AvoidLINUX Then
         Print "on."
      Else
         Print "off."
      End If
      Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
      Color Yellow
      Print "  (A)Linux read/write: ";
      If ForceLINUX Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (B)Linux setting: ";
      If LINUX Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (C)Macos setting: ";
      If MACOSX Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (D)Beep: ";
      If MakeBeep Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (E)CPUtrap: ";
      If CPUtraptype Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (F)MEMtrap: ";
      If MEMtraptype Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (G)Autoindent."
      Print "  (H)Init config."
      Print "  (I)Reset settings."
      Print "  (J)Write config."
      Print "  (K)Help line list: ";
      If HelpOff Then
         Print "off."
      Else
         Print "on."
      End If
      Print "  (L)Start Menu Ignore: ";
      If StartMenuIgnore Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (M)Start Box Ignore: ";
      If StartBoxIgnore Then
         Print "on."
      Else
         Print "off."
      End If
      Print "  (N)Quit Box Ignore: ";
      If QuitBoxIgnore Then
         Print "on."
      Else
         Print "off."
      End If
      Color White
      Print "Enter option(Q to Quit): ";
      X$ = Nul
      Do
         X$ = InKeyx$
         If Len(X$) Then
            Exit Do
         End If
      Loop
      If Len(X$) Then
         Print
         Select Case UCase$(X$)
            Case "Q"
               Exit Do
            Case "1"
               KeyboardTimer = Not KeyboardTimer
            Case "2"
               If AutoSaveAlert Then
                  Print "Autosave alert on."
               Else
                  Print "Autosave alert off."
               End If
               If HelpOff Then
                  Print "Help line display off."
               Else
                  Print "Help line display on."
               End If
               If LINUX Then
                  Print "Linux on."
               Else
                  Print "Linux off."
               End If
               If MACOSX Then
                  Print "Macosx on."
               Else
                  Print "Macosx off."
               End If
               If MakeBeep Then
                  Print "Beep on."
               Else
                  Print "Beep off."
               End If
               If CPUtraptype Then
                  Print "CPU on."
               Else
                  Print "CPU off."
               End If
               If MEMtraptype Then
                  Print "Memory trap enabled."
               Else
                  Print "Memory trap disabled."
               End If
               If AutoIndent Then
                  Print "Autoindent on."
               Else
                  Print "Autoindent off."
               End If
               Print "Screenedit: ";
               Select Case DotDisplay
                  Case 0
                     Print "Dot display."
                  Case -1
                     Print "Percent display."
                  Case -2
                     Print "Progress display."
                  Case Else
                     Print "Dot display."
                     DotDisplay = False
               End Select
               Print "Filename date/time: ";
               If Creation.Time Then
                  Print "Creation"
               Else
                  If Access.Time Then
                     Print "Access"
                  Else
                     If Modified.Time Then
                        Print "Modified"
                     Else
                        Print "<none>"
                     End If
                  End If
               End If
               If KeyboardTimer Then
                  Print "Keyboardline timer off."
               Else
                  Print "Keyboardline timer on."
               End If
               If StartMenuIgnore Then
                  Print "StartMenuIgnore on."
               Else
                  Print "StartMenuIgnore off."
               End If
               If StartBoxIgnore Then
                  Print "StartBoxIgnore on."
               Else
                  Print "StartBoxIgnore off."
               End If
               If QuitBoxIgnore Then
                  Print "QuitBoxIgnore on."
               Else
                  Print "QuitBoxIgnore off."
               End If
               Call KeyPrompt
            Case "3"
               Print "Toggle parameters:"
               Print "  ALERT - autosave alert."
               Print "  BEEP  - beep break override."
               Print "  CPU   - cpu titlebar display."
               Print "  DATETIME - filename date/time display."
               Print "  COMPATIBLE - linux compatible mode."
               Print "  HELPOFF  - help line display setting."
               Print "  AVOIDLINUX - skip linux binary read/write mode."
               Print "  FORCELINUX - linux binary read/write mode."
               Print "  MEM    - mem titlebar display."
               Print "  MENU   - starts toggle menu editor."
               Print "  INDENT - program autoindent."
               Print "  LIST   - list current settings."
               Print "  LINUX  - toggle Linux used."
               Print "  MACOSX - toggle Macosx used."
               Print "  STATUS - toggle screen edit load/store display."
               Print "  KEYTIMER - toggle keyboardline function timer."
               Print "  STARTMENUIGNORE - toggle startup menu display."
               Print "  STARTBOXIGNORE - toggle startup dialogbox."
               Print "  QUITBOXIGNORE - toggle quit dialogbox."
               Call KeyPrompt
            Case "4"
               Select Case DotDisplay
                  Case 0
                     DotDisplay = -1
                  Case -1
                     DotDisplay = -2
                  Case -2
                     DotDisplay = 0
                  Case Else
                     DotDisplay = 0
               End Select
            Case "5"
               If Creation.Time Then
                  Creation.Time = False
                  Access.Time = True
                  Modified.Time = False
               Else
                  If Access.Time Then
                     Creation.Time = False
                     Access.Time = False
                     Modified.Time = True
                  Else
                     If Modified.Time Then
                        Creation.Time = True
                        Access.Time = False
                        Modified.Time = False
                     Else
                        Creation.Time = True
                        Access.Time = False
                        Modified.Time = False
                     End If
                  End If
               End If
            Case "6"
               AutoSaveAlert = Not AutoSaveAlert
            Case "7"
               Compatible = Not Compatible
            Case "8"
               HelpOff = Not HelpOff
            Case "9"
               AvoidLINUX = Not AvoidLINUX
            Case "A"
               ForceLINUX = Not ForceLINUX
            Case "B"
               LINUX = Not LINUX
            Case "C"
               MACOSX = Not MACOSX
            Case "D"
               MakeBeep = Not MakeBeep
            Case "E"
               CPUtraptype = Not CPUtraptype
            Case "F"
               MEMtraptype = Not MEMtraptype
            Case "G"
               Call SetAutoIndent(-1)
            Case "H"
               Call InitConfig(VarQ)
               If VarQ Then
                  Print "Init sucess."
               Else
                  Print "Init failed."
               End If
            Case "I"
               KeyboardTimer = False
               AutoSaveAlert = False
               HelpOff = False
               LINUX = False
               MACOSX = False
               MakeBeep = True
               AutoSaveAlert = False
               CPUtraptype = True
               MEMtraptype = False
               AutoIndent = False
               DotDisplay = False
               Creation.Time = False
               Access.Time = False
               Modified.Time = False
               StartMenuIgnore = False
               StartBoxIgnore = False
               QuitBoxIgnore = False
               Print "Settings reset."
               Call KeyPrompt
            Case "J"
               Call WriteConfig(VarQ)
               Select Case VarQ
                  Case 0
                     Print "Settings write error."
                  Case -1
                     Print "Settings stored."
                  Case -2
                     Print "Error writing to LAN."
                  Case -3
                     Print "Error writing to CD-ROM."
                  Case -4
                     Print "Error writing to media."
               End Select
               Call WriteRecent(VarQ)
               Select Case VarQ
                  Case 0
                     Print "Recent Settings write error."
                  Case -1
                     Print "Recent Settings stored."
                  Case -2
                     Print "Recent Error writing to LAN."
                  Case -3
                     Print "Recent Error writing to CD-ROM."
                  Case -4
                     Print "Recent Error writing to media."
               End Select
               Call KeyPrompt
            Case "K"
               HelpOff = Not HelpOff
            Case "L"
               StartMenuIgnore = Not StartMenuIgnore
            Case "M"
               StartBoxIgnore = Not StartBoxIgnore
            Case "N"
               QuitBoxIgnore = Not QuitBoxIgnore
            Case Else
               Print "Unknown toggle parameter."
         End Select
      End If
   Loop
End Sub

Sub MEMmenu (Param$)
   If Param$ = Nul Then
      Print "Memory status.."
      Call MemFunction
      Exit Sub
   End If
   If Param$ = "BLANK" Then
      s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
      Exit Sub
   End If
   If Param$ = "SCREENSAVER" Then
      s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
      Exit Sub
   End If
   If Param$ = "HELP" Then
      Print "MEM - display memory usage."
      Print "  MEM BLANK - call screen saver."
      Print "  MEM TRAP - toggle titlebar."
      Print "  MEM TYPE - cycle suffix."
      Print "  MEM TOGGLE - toggle total/free/used RAM."
      Print "    MEM TOGGLE FREE/USED/TOTAL."
      Print "    MEM TOGGLE 0/1/2."
      Print "  MEM SCREENSAVER - call screen saver."
      Exit Sub
   End If
   If Param$ = "TRAP" Then
      MEMtraptype = Not MEMtraptype
      If MEMtraptype Then
         Print "Memory trap enabled."
      Else
         Print "Memory trap disabled."
      End If
      Exit Sub
   End If
   If Param$ = "TYPE" Then
      Select Case SuffixType
         Case 0
            SuffixType = 1
            Print "Suffix now KB."
         Case 1
            SuffixType = 2
            Print "Suffix now MB."
         Case 2
            SuffixType = 3
            Print "Suffix now GB."
         Case 3
            SuffixType = 0
            Print "Suffix now B."
      End Select
      Exit Sub
   End If
   If Left$(Param$, 6) = "TOGGLE" Then
      If InStr(Param$, " ") Then
         Param$ = Mid$(Param$, InStr(Param$, " ") + 1)
         If Param$ = "FREE" Then
            MEMtraptype2 = 1
            Print "MEM trap now free memory."
            Exit Sub
         End If
         If Param$ = "USED" Then
            MEMtraptype2 = 2
            Print "MEM trap now used memory."
            Exit Sub
         End If
         If Param$ = "TOTAL" Then
            MEMtraptype2 = 0
            Print "MEM trap now total memory."
            Exit Sub
         End If
         If Param$ >= "0" And Param$ <= "2" Then
            VarX = Int(Val(Param$))
            If VarX >= 0 And VarX <= 2 Then
               MEMtraptype2 = VarX
               Print "MEM trap type reset."
            Else
               Print "Unknown mem trap type."
            End If
         End If
         Exit Sub
      End If
      If Param$ = "TOGGLE" Then
         Select Case MEMtraptype2
            Case 0
               MEMtraptype2 = 1
               Print "Memory trap now free display."
            Case 1
               MEMtraptype2 = 2
               Print "Memory trap now used display."
            Case 2
               MEMtraptype2 = 0
               Print "Memory trap now total display."
            Case Else
               MEMtraptype2 = 0
               Print "Memory trap now total display."
         End Select
      End If
      Exit Sub
   End If
   Print "Unknown MEM function. Try:"
   Print "  MEM BLANK - call screen saver."
   Print "  MEM TRAP - toggle titlebar."
   Print "  MEM TYPE - cycle suffix."
   Print "  MEM TOGGLE - toggle total/free/used RAM."
   Print "    MEM TOGGLE FREE/USED/TOTAL."
   Print "    MEM TOGGLE 0/1/2."
   Print "  MEM SCREENSAVER - call screen saver."
End Sub

Sub SetAutoIndent (Var)
   ' toggle autoindent
   If Var = True Then
      AutoIndent = Not AutoIndent
      If AutoIndent = False Then
         Print "Autoindent off."
      End If
   End If
   ' check autoindent parameter
   If Var > False Then
      AutoIndentSpaces = Var
      Print "Autoindent set to" + Str$(Var) + " spaces."
      Exit Sub
   End If
   ' check autoindent
   If AutoIndent Then
      Print "Enter spaces(1-9)? ";
      X$ = Nul
      Do
         X$ = InKeyx$
         If ControlBreak Then
            ControlBreak = False
            Exit Do
         End If
         If Len(X$) Then
            If X$ >= "1" And X$ <= "9" Then
               AutoIndentSpaces = Val(X$)
               Print X$
               Print "Autoindent on."
               Exit Do
            End If
         End If
      Loop
   End If
End Sub

Sub AutoSaveMenu (Param$)
   Color White, Black
   If UCase$(Param$) = "ALERT" Then
      AutoSaveAlert = Not AutoSaveAlert
      If AutoSaveAlert Then
         Print "Autosave alert on."
      Else
         Print "Autosave alert off."
      End If
      Exit Sub
   End If
   If UCase$(Param$) = "DELTEMP" Then
      Ext$ = "*.BKP"
      Call DelTemp2(Ext$)
      Exit Sub
   End If
   If UCase$(Param$) = "BACKUP" Then
      Call BackupProgram(-1)
      Exit Sub
   End If
   If UCase$(Param$) = "INFO" Then
      If AutoSave = False Then
         Print "Autosave is off."
      Else
         Print "Autosave is on."
         If AutoSaveAlert Then
            Print "Autosave alert is on."
         Else
            Print "Autosave alert is off."
         End If
         Print "Autosave timer is set to" + Str$(AutoSaveValue) + " minutes."
         Print "Autosave counter is:" + Str$(AutoSaveCounter) + " traps."
      End If
      Print "Backup directory is: " + DRX2
      Var# = CountBackupFiles#
      Print "Backup directory has"; Str$(Var#); " backup files."
      If Var# > Dfalse Then
         Print "Enter AUTOSAVE DELTEMP to remove backup files."
      End If
      Print "Current program is: ";
      If ProgramName = None Then
         Print None
      Else
         If ProgramName = Untitled Then
            Print Untitled
         Else
            VarQ$ = GetFileName$(ProgramName)
            Print VarQ$
         End If
      End If
      Exit Sub
   End If
   If UCase$(Param$) = "ON" Then
      AutoSave = True
      If AutoSaveValue <= False Then
         AutoSaveValue = AutoSaveDefault
         If AutoSaveValue = False Then AutoSaveValue = 5
         t5! = AutoSaveValue * 60!
      End If
      If t5! = SFalse Then t5! = 60!
      Print "Autosave on. Set to" + Str$(AutoSaveValue) + " minutes."
      On Timer(t4, t5!) BackupProgramTimer ' autosave
      Timer(t4) On
      Exit Sub
   End If
   If UCase$(Param$) = "OFF" Then
      AutoSave = False
      Print "Autosave off."
      Timer(t4) Off
      Exit Sub
   End If
   If UCase$(Param$) = "HELP" Then
      Color Yellow, Black
      Print "Multi purpose functions:"
      Print " AUTOSAVE --  starts autosave file backup."
      Print "    AUTOSAVE [<value>][ON][OFF][BACKUP][INFO][ALERT][DELTEMP]"
      Print "      <value> minutes of timer."
      Print "      ON - activate timer."
      Print "      OFF - deactivate timer."
      Print "      BACKUP - force a backup."
      Print "      INFO - displays autosave info."
      Print "      ALERT - toggle alert message."
      Print "      DELTEMP - remove old backup files."
      Call KeyPrompt
      Exit Sub
   End If
   If Len(Param$) Then
      If Int(Val(Param$)) >= 1 And Int(Val(Param$)) <= 1440 Then
         AutoSave = True
         AutoSaveValue = Int(Val(Param$))
         If AutoSaveValue = False Then AutoSaveValue = 5
         t5! = AutoSaveValue * 60!
         If t5! = SFalse Then t5! = 60!
         Print "Autosave on. Set to" + Str$(AutoSaveValue) + " minutes."
         On Timer(t4, t5!) BackupProgramTimer ' autosave
         Timer(t4) On
         Exit Sub
      End If
      Print "Unknown parameter. Type AUTOSAVE HELP for help."
      Exit Sub
   End If
   ' toggle autosave
   AutoSave = Not AutoSave
   If AutoSave Then
      If AutoSaveValue <= False Then
         AutoSaveValue = AutoSaveDefault
         If AutoSaveValue = False Then AutoSaveValue = 5
         t5! = AutoSaveValue * 60!
      End If
      If t5! = SFalse Then t5! = 60!
      Print "Autosave on. Set to" + Str$(AutoSaveValue) + " minutes."
      On Timer(t4, t5!) BackupProgramTimer ' autosave
      Timer(t4) On
   Else
      Print "Autosave off."
      Timer(t4) Off
   End If
End Sub

' gets last line in program
Sub CountLines (Temp1%)
   On Error GoTo NulErrorRoutine ' avoid nul loop
   Temp1% = False
   Var% = MaxLines
   If Var% < 0 Then Var% = 1%
   If Var% > 32766% Then Var% = 32766%
   For Temp2% = Var% To 1 Step -1
      Temp1$ = Program$(Temp2%)
      Temp1$ = Strim$(Temp1$)
      If Len(Temp1$) Then
         Exit For
      End If
   Next
   Temp1% = Temp2%
   On Error GoTo ErrorRoutine
End Sub

' displays error message
Sub DisplayError
   ' check error value range
   Select Case ErrorValue
      Case 1
         Var$ = "Internal Error #001: Next without For."
      Case 2
         Var$ = "Error #002: Line%1: Syntax error."
      Case 3
         Var$ = "Internal Error #003: Line%1: Return without Gosub."
      Case 4
         Var$ = "Internal Error #004: Line%1: Out of Data."
      Case 5
         Var$ = "Error #005: Line%1: Illegal function call."
      Case 6
         Var$ = "Error #006: Line%1: Overflow."
      Case 7
         Var$ = "Error #007: Line%1: Out of memory."
      Case 8
         Var$ = "Internal Error #008: Label not defined."
      Case 9
         Var$ = "Error #009: Line%1: Subscript out of range."
      Case 10
         Var$ = "Internal Error #010: Duplicate definition."
      Case 11
         Var$ = "Error #011: Line%1: Division by zero."
      Case 12
         Var$ = "Internal Error #012: Illegal in direct mode."
      Case 13
         Var$ = "Internal Error #013: Type mismatch."
      Case 14
         Var$ = "Error #014: Line%1: Out of string space."
      Case 15
         Var$ = "Error #015: Line%1: Invalid Pset statement."
      Case 16
         Var$ = "Error #016: Line%1: String formula too complex."
      Case 17
         Var$ = "Reserved Error #017: Cannot continue."
      Case 18
         Var$ = "Internal Error #018: Function not defined."
      Case 19
         Var$ = "Error #019: Line%1: No RESUME."
      Case 20
         Var$ = "Error #020: Line%1: RESUME without error."
      Case 21
         Var$ = "Error #021: Line%1: Syntax error specifying filename to open."
      Case 22
         Var$ = "Error #022: Line%1: Syntax error specifying filename to close."
      Case 23
         Var$ = "Error #023: Line%1: Syntax error specifying filename field."
      Case 24
         Var$ = "Error #024: Line%1: Device timeout."
      Case 25
         Var$ = "Error #025: Line%1: Device fault."
      Case 26
         Var$ = "Internal Error #026: For without Next."
      Case 27
         Var$ = "Error #027: Line%1: Out of paper."
      Case 28
         Var$ = "Error #028: Line%1: Invalid LINE statement."
      Case 29
         Var$ = "Internal Error #029: While without Wend."
      Case 30
         Var$ = "Internal Error #030: Wend without While."
      Case 31
         Var$ = "Error #031: Line%1: Syntax error writing to file."
      Case 32
         Var$ = "Error #032: Line%1: Syntax error printing to file."
      Case 33
         Var$ = "Internal Error #033: Duplicate label."
      Case 34
         Var$ = "Error #034: Line%1: Syntax error inputing from file."
      Case 35
         Var$ = "Internal Error #035: Subprogram not defined."
      Case 36
         Var$ = "Error #036: Line%1: Syntax error line inputing from file."
      Case 37
         Var$ = "Internal Error #037: Argument-count mismatch."
      Case 38
         Var$ = "Error #038: Line%1: Array not defined."
      Case 39
         Var$ = "Error #039: Line%1: Invalid CIRCLE statement."
      Case 40
         Var$ = "Error #040: Line%1: Variable required."
      Case 41
         Var$ = "Error #041: Line%1: Invalid Lset statement."
      Case 42
         Var$ = "Error #042: Line%1: Invalid Rset statement."
      Case 43
         Var$ = "Error #043: Line%1: Invalid Put statement."
      Case 44
         Var$ = "Error #044: Line%1: Invalid Get statement."
      Case 45
         Var$ = "Error #045: Line%1: Invalid Read statement."
      Case 46
         Var$ = "Error #046: Line%1: Invalid Draw statement."
      Case 47
         Var$ = "Error #047: Line%1: Invalid Play statement."
      Case 48
         Var$ = "Error #048: Line%1: Invalid Paint statement."
      Case 49
         Var$ = "Error #049: Line%1: Invalid Get/Put statement."
      Case 50
         Var$ = "Error #050: Line%1: Field overflow."
      Case 51
         Var$ = "Internal compiler error #051."
      Case 52
         Var$ = "Error #052: Line%1: Bad file name or number."
      Case 53
         Var$ = "Error #053: Line%1: File not found."
      Case 54
         Var$ = "Error #054: Line%1: Bad file mode."
      Case 55
         Var$ = "Error #055: Line%1: File already open."
      Case 56
         Var$ = "Error #056: Line%1: Field statement active."
      Case 57
         Var$ = "Error #057: Line%1: Device I/O error."
      Case 58
         Var$ = "Error #058: Line%1: File already exists."
      Case 59
         Var$ = "Error #059: Line%1: Bad record length."
      Case 60
         Var$ = "Error #060: Line%1: Invalid Bsave/Bload statement."
      Case 61
         Var$ = "Error #061: Line%1: Disk full."
      Case 62
         Var$ = "Error #062: Line%1: Input past end of file."
      Case 63
         Var$ = "Error #063: Line%1: Bad record number."
      Case 64
         Var$ = "Error #064: Line%1: Bad file name."
      Case 65
         Var$ = "Error #065: Line%1: Invalid Data statement."
      Case 66
         Var$ = "Error #066: Line%1: Out of data."
      Case 67
         Var$ = "Error #067: Line%1: Too many files."
      Case 68
         Var$ = "Error #068: Line%1: Device unavailable."
      Case 69
         Var$ = "Error #069: Line%1: Communication buffer overflow."
      Case 70
         Var$ = "Error #070: Line%1: File permission denied."
      Case 71
         Var$ = "Error #071: Line%1: Disk not ready."
      Case 72
         Var$ = "Error #072: Line%1: Disk-media error."
      Case 73
         Var$ = "Internal Error #073: Feature unavailable."
      Case 74
         Var$ = "Error #074: Line%1: Rename across disks."
      Case 75
         Var$ = "Error #075: Line%1: Path/File access error."
      Case 76
         Var$ = "Error #076: Line%1: Path not found."
      Case 77
         Var$ = "Error #077: Line%1: Invalid View statement."
      Case 78
         Var$ = "Error #078: Line%1: Invalid Window statement."
      Case 80
         Var$ = "Internal Error #080: Feature removed."
      Case 81
         Var$ = "Error #081: Line%1: Invalid name."
      Case 82
         Var$ = "Reserved Error #082: Table not found."
      Case 83
         Var$ = "Reserved Error #083: Index not found."
      Case 84
         Var$ = "Reserved Error #084: Invalid column."
      Case 85
         Var$ = "Reserved Error #085: No current record."
      Case 86
         Var$ = "Reserved Error #086: Duplicate value for unique index."
      Case 87
         Var$ = "Reserved Error #087: Invalid operation on null index."
      Case 88
         Var$ = "Reserved Error #088: Database needs repair."
      Case 89
         Var$ = "Reserved Error #089: Insufficient ISAM buffers."
      Case 91
         Var$ = "Error #091: Line%1: Unknown statement."
      Case 92
         Var$ = "Error #092: Line%1: Whatis: %2."
      Case 97
         Var$ = "Error #097: Line%1: Mismatched for/next."
      Case 98
         Var$ = "Error #098: Line%1: Mismatched do/loop."
      Case 99
         Var$ = "Error #099: Line%1: Missing line number."
      Case 100
         Var$ = "Error #100: Line%1: Unmatched gosub."
      Case 101
         Var$ = "Error #101: Error accessing file."
      Case 102
         Var$ = "Error #102: Line%1: Mismatched select/end select."
      Case 103
         Var$ = "Error #103: Line%1: Mismatched forif/nextif."
      Case 104
         Var$ = "Error #104: Line%1: Mismatched loopif/endloopif."
      Case 105
         Var$ = "Error #105: Line%1: Mismatched selectif/end selectif."
      Case 110
         Var$ = "Error #110: Line%1: Unknown swap statement."
      Case 111
         Var$ = "Error #111: Line%1: Record size overflow."
      Case 112
         Var$ = "Error #112: Line%1: Error chaining to program."
      Case 113
         Var$ = "Error #113: Line%1: Error naming file."
      Case 114
         Var$ = "Error #114: Line%1: Error killing file."
      Case 115
         Var$ = "Error #115: Line%1: Error changing directory."
      Case 116
         Var$ = "Error #116: Line%1: Error making directory."
      Case 117
         Var$ = "Error #117: Line%1: Error removing directory."
      Case 118
         Var$ = "Error #118: Line%1: Error setting date."
      Case 119
         Var$ = "Error #119: Line%1: Error setting time."
      Case 120
         Var$ = "Error #120: Line%1: Error changing drive."
      Case 121
         Var$ = "Error #121: Line%1: Error using OUT statement."
      Case 122
         Var$ = "Error #122: Line%1: Error using WAIT statement."
      Case 123
         Var$ = "Error #123: Line%1: Error using ABSOLUTE statement."
      Case 124
         Var$ = "Error #124: Line%1: Error using POKE statement."
      Case 125
         Var$ = "Error #125: Line%1: Error using DEFSEG statement."
      Case 126
         Var$ = "Error #126: Line%1: Error specifying file handle number."
      Case 127
         Var$ = "Error #127: Line%1: Error specifying hexidecimal number."
      Case 128
         Var$ = "Error #128: Line%1: Error specifying octal number."
      Case 129
         Var$ = "Error #129: Line%1: Error specifying binary number."
      Case 130
         Var$ = "Error #130: Line%1: Error specifying decimal value."
      Case 131
         Var$ = "Error #131: Line%1: Error specifying numeric value."
      Case 132
         Var$ = "Error #132: Line%1: Error specifying factorial value."
      Case 133
         Var$ = "Error #133: Line%1: Error specifying quoted value."
      Case 134
         Var$ = "Error #134: Line%1: Bad input variable: %3"
      Case 135
         Var$ = "Error #135: Line%1: Mismatched data."
      Case 136
         Var$ = "Error #136: Line%1: Too few input variables."
      Case 137
         Var$ = "Error #137: Line%1: Too many input variables."
      Case 138
         Var$ = "Error #138: Line%1: Missing left parenthesis."
      Case 139
         Var$ = "Error #139: Line%1: Missing right parenthesis."
      Case 140
         Var$ = "Error #140: Line%1: Specified double exponent."
      Case 141
         Var$ = "Error #141: Line%1: Missing exponent value."
      Case 142
         Var$ = "Error #142: Line%1: Bad exponent unary sign."
      Case 143
         Var$ = "Error #143: Line%1: Bad exponent decimal point."
      Case 144
         Var$ = "Error #144: Line%1: Bad DEF FN declaration."
      Case 145
         Var$ = "Error #145: Line%1: Unknown line number."
      Case 146
         Var$ = "Error #146: Line%1: Bad WIDTH statement."
      Case 147
         Var$ = "Error #147: Line%1: Bad SOUND statement."
      Case 148
         Var$ = "Error #148: Line%1: FN call error: %2."
      Case 149
         Var$ = "Error #149: Line%1: FZ call error: %2."
      Case 150
         Var$ = "Error #150: Line%1: Bad exponent unary sign."
      Case 151
         Var$ = "Error #151: Line%1: Bad exponent decimal point."
      Case 154
         Var$ = "Error #154: Line%1: Bad SHELL call."
      Case 155
         Var$ = "Error #155: Line%1: Restricted command."
      Case 156
         Var$ = "Error #156: Line%1: Maximum nested gosub."
      Case 157
         Var$ = "Error #157: Line%1: Square root of a negative value."
      Case 158
         Var$ = "Error #158: Line%1: Unknown INT86 function."
      Case 159
         Var$ = "Error #159: Line%1: Feature not available."
      Case 160
         Var$ = "Error #160: Line%1: Unknown metacommand."
      Case 161
         Var$ = "Error #161: Line%1: Illegal line printer function."
      Case 162
         Var$ = "Error #162: Line%1: Illegal MID$ function call."
      Case 163
         Var$ = "Error #163: Line%1: Illegal LEFT$ function call."
      Case 164
         Var$ = "Error #164: Line%1: Illegal RIGHT$ function call."
      Case 165
         Var$ = "Error #165: Line%1: Illegal ENVIRON$ function call."
      Case 166
         Var$ = "Error #166: Line%1: Drive not available."
      Case 167
         Var$ = "Error #167: Line%1: Illegal write function."
      Case 168
         Var$ = "Error #168: Line%1: Invalid TRIANGLE statement."
      Case 169
         Var$ = "Error #169: Line%1: Invalid POLYGON statement."
      Case 170
         Var$ = "Error #170: Line%1: Eerror specifying sound filename to open."
      Case 171
         Var$ = "Error #171: Line%1: Invalid SQUARE statement."
      Case 172
         Var$ = "Error #172: Line%1: Invalid SETTIMER statement."
      Case 173
         Var$ = "Error #173: Line%1: Recursive include statement."
      Case 174
         Var$ = "Error #174: Line%1: CHAIN call error: %2."
      Case 175
         Var$ = "Internal Error #175: OS feature unavailable."
      Case 176
         Var$ = "Error #176: Line%1: Illegal DEBUG error: %2."
      Case 177
         Var$ = "Error #177: Line%1: Illegal LOCK/UNLOCK error: %2."
      Case 178
         Var$ = "Error #178: Line%1: Illegal LLINES error: %2."
      Case 179
         Var$ = "Error #179: Line%1: Illegal Include error."
      Case 180
         Var$ = "Error #180: Line%1: Unknown constant declaration."
      Case 181
         Var$ = "Error #181: Line%1: Unknown SLICE declaration."
      Case 79, 90, 93 To 96, 106 To 109, 152, 153, 182 To 255
         Var$ = "User defined error #" + Mid$(Str$(ErrorValue), 2) + ": Line%1."
      Case Else ' unknown error
         Var$ = "Error #000: Error: Line%1."
   End Select

   ' parse out ': Line%1:'
   If WhatisError <= -2 Then ErrorLine = 0
   Parse = InStr(Var$, "%1")
   If Parse Then
      ' check error line number.
      If ErrorLine = False Then ' remove %1 string
         Var$ = Left$(Var$, Parse - 7) + Mid$(Var$, Parse + 2)
      Else ' replace %1 string
         Var$ = Left$(Var$, Parse - 1) + Str$(ErrorLine) + Mid$(Var$, Parse + 2)
      End If
   End If

   ' parse out ': %2.'
   Parse = InStr(Var$, "%2")
   If Parse Then
      ' check token string.
      If Strng = TabS Then
         Strng = "<tab>"
      End If
      If Len(Strng) = False Then ' remove %2 string
         Var$ = Left$(Var$, Parse - 1) + "<?>" + Mid$(Var$, Parse + 2)
      Else ' replace %2 string
         Var$ = Left$(Var$, Parse - 1) + Strng + Mid$(Var$, Parse + 2)
      End If
   End If

   ' parse out ': %3.'
   Parse = InStr(Var$, "%3")
   If Parse Then
      If Len(BadInput) = False Then ' remove %3 string
         Var$ = Left$(Var$, Parse - 1) + "<?>" + Mid$(Var$, Parse + 2)
      Else ' replace %3 string
         Var$ = Left$(Var$, Parse - 1) + Xtrim$(BadInput, -1) + Mid$(Var$, Parse + 2)
      End If
   End If

   ' store error and qb64 line number of where.
   Var$ = RTrim$(Var$) + " (IDE" + Str$(_ErrorLine) + ")"
   Color Red, Black
   Print RTrim$(Var$)
   Color White
End Sub

' parses and stores a program line number
Sub EnterProgramLine
   Assign = False
   Out2 = Strim$(Out2)
   If Left$(Out2, 1) = ";" Then ' comment is ignored
      Assign = True
      Exit Sub
   End If
   If Left$(Out2, 1) = "'" Then ' comment is ignored
      Assign = True
      Exit Sub
   End If
   If Left$(UCase$(Out2), 3) = Remark$ Then ' comment is ignored
      Assign = True
      Exit Sub
   End If
   For Blanks = 1 To Len(Out2)
      Imbedded = False
      For Parse = 1 To Len(WhiteSpace)
         If Mid$(Out2, Blanks, 1) = Mid$(WhiteSpace, Parse, 1) Then
            Imbedded = Blanks
            Exit For
         End If
      Next
      If Imbedded Then
         LineNumber = Int(Val(Left$(Out2, Imbedded - 1)))
         If LineNumber >= 1 And LineNumber <= MaxLines Then
            Out3 = Mid$(Out2, Imbedded)
            If Strim$(Out3) = Nul Then
               Exit For
            End If
            Assign = True
            Program$(LineNumber) = Out3
            If ProgramName = None Then
               ProgramName = Untitled
            End If
            If AutoIndent Then
               Call IndentProgram(-1, 3) ' autoindent
            End If
         Else
            Out3 = Strim$(Out2)
            If InStr("0123456789", Left$(Out3, 1)) Then
               Assign = True
               Print "Line number out of range."
            End If
         End If
         Exit Sub
      End If
   Next
   LineNumber = Int(Val(Out2))
   If LineNumber > False And LineNumber <= MaxLines Then
      Assign = True
      Program$(LineNumber) = Nul
      Call CountLines(LastLine)
      If LastLine = False Then
         ProgramName = None
      Else
         If ProgramName = None Then
            ProgramName = Untitled
         End If
      End If
      If AutoIndent Then
         Call IndentProgram(-1, 3) ' autoindent
      End If
   Else
      Out3 = Strim$(Out2)
      If InStr("0123456789", Left$(Out3, 1)) Then
         Assign = True
         Print "Line number out of range."
      End If
   End If
End Sub

' indents current program
Sub IndentProgram (Auto, NumberSpaces)
   Call AnalyzeProgram(0, VarX, Var$)
   If VarX Then
      If Auto Then
         Exit Sub
      End If
      Color White
      Print "Program analyze error line:" + Str$(ProgramLine) + ": " + Var$ + "."
      Exit Sub
   End If
   If Auto Then
      Increment = AutoIndentSpaces
   Else
      Increment = Int(NumberSpaces)
      If NumberSpaces = False Then
         Prompt$ = "Enter number of spaces to indent: "
         Var$ = KeyboardLine4$(Prompt$)
         Increment = Int(Val(Var$))
      End If
   End If
   If Increment <= 0 Then
      Exit Sub
   End If
   Indent = False
   Call CountLines(LastLine)
   MX = Len(Str$(LastLine))
   For ProgramLine = 1 To LastLine
      Number$ = Space$(MX - Len(Mid$(Str$(ProgramLine), 2)))
      Out2 = Program$(ProgramLine)
      Out2 = Strim$(Out2)
      If Len(Out2) Then
         Temp1$ = Strim$(Out2)
         Temp1$ = UCase$(Temp1$)
         Temp1$ = Ttrim$(Temp1$, False)
         NextIndent = False
         Restore IndentData
         Do
            Read Keyword$, KeyIndent
            If Keyword$ = "EOF" Then
               Exit Do
            End If
            If Left$(Temp1$, Len(Keyword$)) = Keyword$ Then
               NextIndent = KeyIndent
               Exit Do
            End If
         Loop
         Select Case NextIndent
            Case 1 ' right
               Out2 = Space$(Indent * Increment) + Strim$(Out2)
               Indent = Indent + 1
            Case -1 ' left
               Indent = Indent - 1
               If Indent < False Then
                  If Auto = False Then
                     Print "Indent error: Line:"; ProgramLine
                  End If
                  Exit Sub
               End If
               Out2 = Space$(Indent * Increment) + Strim$(Out2)
            Case -2 ' left/right
               Indent = Indent - 1
               If Indent < False Then
                  If Auto = False Then
                     Print "Indent error: Line:"; ProgramLine
                  End If
                  Exit Sub
               End If
               Out2 = Space$(Indent * Increment) + Strim$(Out2)
               Indent = Indent + 1
            Case Else
               Out2 = Space$(Indent * Increment) + Strim$(Out2)
         End Select
         Out2 = Number$ + Out2
         Program$(ProgramLine) = Out2
      End If
   Next
   If Auto Then
      Exit Sub
   End If
   If Indent <> False Then
      Print "Indent error: Line:"; ProgramLine
      Exit Sub
   End If
   Print "Program indented."
End Sub

' deletes a .sic file
Sub DeleteProgram (Var$)
   Do
      If Var$ = Nul Then
         ProgramFile$ = _OpenFileDialog$("SICK kill file", _CWD$)
      Else
         ProgramFile$ = Var$
      End If
      If Len(ProgramFile$) = False Then
         Color White
         Print "File not found."
         Exit Do
      End If
      Filename = ProgramFile$
      If _FileExists(Filename) = False Then
         Print "File " + Quote + Filename + Quote + " does not exist."
         If Len(Var$) Then
            Exit Do
         End If
      Else
         If Var$ = Nul Then
            Color White, Black
            Print "Kill " + Quote + Filename + Quote + "."
            Call MorePrompt("Are you sure(y/n)?", "yn", OutputChar$)
         Else
            OutputChar$ = "y"
         End If
         Color White, Black
         If OutputChar$ = "y" Then
            f$ = Filename + Chr$(0)
            x = DeleteFileA(f$)
            If x = 0 Then
               Print "Error killing program."
               VarQ$ = DisplayWinError$(x)
               If Len(VarQ$) Then
                  Print VarQ$
               End If
            Else
               Print "Program " + Quote + Filename + Quote + " killed."
            End If
         Else
            Print "Program " + Quote + Filename + Quote + " not killed."
         End If
         Exit Do
      End If
   Loop
End Sub

' encrypts a .sic file
Sub EncryptProgram (Var$)
   Dim ASCIIZ As String * 260
   Do
      If Var$ = Nul Then
         ProgramFile$ = _OpenFileDialog$("SICK encrypt file", _CWD$)
      Else
         ProgramFile$ = Var$
      End If
      If Len(ProgramFile$) = False Then
         Color White
         Print "File not found."
         Exit Do
      End If
      If Right$(ProgramFile$, 1) = Quote Then
         If Left$(ProgramFile$, 1) = Quote Then
            ProgramFile$ = Left$(ProgramFile$, Len(ProgramFile$) - 1)
            ProgramFile$ = Mid$(ProgramFile$, 2)
         End If
      End If
      If Len(ProgramFile$) = False Then
         Exit Do
      End If
      Filename = ProgramFile$
      If _FileExists(Filename) = False Then
         Print "File " + Quote + Filename + Quote + " does not exist."
         If Len(Var$) Then
            Exit Do
         End If
      Else
         If Var$ = Nul Then
            Color White, Black
            Print "Encrypt " + Quote + Filename + Quote + "."
            Call MorePrompt("Are you sure(y/n)?", "yn", OutputChar$)
         Else
            OutputChar$ = "y"
         End If
         Color White, Black
         If OutputChar$ = "y" Then
            ' encrypt filename
            ASCIIZ = Filename + Chr$(0)
            V = EncryptFileA(ASCIIZ)
            If V = 0 Then
               Print "Error 0x" + Hex$(GetLastError) + " encrypting filename."
               VarQ$ = DisplayWinError$(x)
               If Len(VarQ$) Then
                  Print VarQ$
               End If
            Else
               Print "Program " + Quote + Filename + Quote + " encrypted."
            End If
         Else
            Print "Program " + Quote + Filename + Quote + " not encrypted."
         End If
         Exit Do
      End If
   Loop
End Sub

' decrypts a .sic file
Sub DecryptProgram (Var$)
   Dim ASCIIZ As String * 260
   Do
      If Var$ = Nul Then
         ProgramFile$ = _OpenFileDialog$("SICK decrypt file", _CWD$)
      Else
         ProgramFile$ = Var$
      End If
      If Len(ProgramFile$) = False Then
         Color White
         Print "File not found."
         Exit Do
      End If
      If Right$(ProgramFile$, 1) = Quote Then
         If Left$(ProgramFile$, 1) = Quote Then
            ProgramFile$ = Left$(ProgramFile$, Len(ProgramFile$) - 1)
            ProgramFile$ = Mid$(ProgramFile$, 2)
         End If
      End If
      If Len(ProgramFile$) = False Then
         Exit Do
      End If
      Filename = ProgramFile$
      If _FileExists(Filename) = False Then
         Print "File " + Quote + Filename + Quote + " does not exist."
         If Len(Var$) Then
            Exit Do
         End If
      Else
         If Var$ = Nul Then
            Color White, Black
            Print "Decrypt " + Quote + Filename + Quote + "."
            Call MorePrompt("Are you sure(y/n)?", "yn", OutputChar$)
         Else
            OutputChar$ = "y"
         End If
         Color White, Black
         If OutputChar$ = "y" Then
            ' decrypt filename
            ASCIIZ = Filename + Chr$(0)
            V = DecryptFileA(ASCIIZ, 0) ' 0=reserved
            If V = 0 Then
               Print "Error 0x" + Hex$(GetLastError) + " decrypting filename."
               VarQ$ = DisplayWinError$(x)
               If Len(VarQ$) Then
                  Print VarQ$
               End If
            Else
               Print "Program " + Quote + Filename + Quote + " decrypted."
            End If
         Else
            Print "Program " + Quote + Filename + Quote + " not decrypted."
         End If
         Exit Do
      End If
   Loop
End Sub

' encrypts a .sic file
Sub EncryptFileSub (Var$)
   Dim ASCIIZ As String * 260
   If Var$ = Nul Then
      Exit Sub
   End If
   ProgramFile$ = Var$
   Filename = ProgramFile$
   If _FileExists(Filename) = False Then
      Var$ = Nul
      Exit Sub
   End If
   ' encrypt filename
   ASCIIZ = Filename + Chr$(0)
   V = EncryptFileA(ASCIIZ)
   If V = 0 Then
      Var$ = Nul
   End If
End Sub

' decrypts a .sic file
Sub DecryptFileSub (Var$)
   Dim ASCIIZ As String * 260
   If Var$ = Nul Then
      Exit Sub
   End If
   ProgramFile$ = Var$
   Filename = ProgramFile$
   If _FileExists(Filename) = False Then
      Var$ = Nul
      Exit Sub
   End If
   ' decrypt filename
   ASCIIZ = Filename + Chr$(0)
   V = DecryptFileA(ASCIIZ, 0) ' 0=reserved
   If V = 0 Then
      Var$ = Nul
   End If
End Sub

' gets encryption status of a .sic file
Sub EncryptionFileStatus (Var#)
   Dim ASCIIZ As String * 260
   Var# = Dfalse
   Var$ = Out3
   If Var$ = Nul Then
      Exit Sub
   End If
   ProgramFile$ = Var$
   Filename = ProgramFile$
   If _FileExists(Filename) = False Then
      Exit Sub
   End If
   ' get encryption status of filename
   ASCIIZ = Filename + Chr$(0)
   x = FileEncryptionStatusA(ASCIIZ, f&)
   If x = 0 Then
      Exit Sub
   End If
   Var# = f&
End Sub

' parses command parameter and calls file list.
Sub ListFilesX (Var4$, VarQ)
   Var5$ = Var4$
   If InStr(Var5$, " ") = False Then
      Call ListFiles(Var4$, VarQ)
   Else
      Do
         Z = InStr(Var5$, "  ")
         If Z Then
            Var5$ = Left$(Var5$, Z) + Mid$(Var5$, Z + 2)
         Else
            Exit Do
         End If
      Loop
      Do
         Z = InStr(Var5$, " ")
         If Z Then
            Var4$ = Left$(Var5$, Z - 1)
            Var5$ = Mid$(Var5$, Z + 1)
            Call ListFiles(Var4$, VarQ)
         Else
            Var4$ = Var5$
            Call ListFiles(Var4$, VarQ)
            Exit Do
         End If
      Loop
   End If
End Sub

' display dirs/files
'   VarQ = 0 for directories only
Sub ListFiles (VarZ$, VarQ)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Error 175
         Exit Sub
      End If
   End If

   ErrorCount = False
   ErrorType2 = True

   ' reset search parameter
   If Len(VarZ$) Then
      Var4$ = VarZ$
   Else
      Var4$ = "*.sic"
   End If

   ' check filename
   If Right$(Var4$, 1) = Quote Then
      If Left$(Var4$, 1) = Quote Then
         Var4$ = Left$(Var4$, Len(Var4$) - 1)
         Var4$ = Mid$(Var4$, 2)
         If Var4$ = Nul Then Exit Sub
      End If
   End If

   ' display header
   Color White, Black
   Print "Searching: " + Var4$
   If VarQ = True Then l = 2 Else l = 1
   GoSub TitleHeader

   c = 0
   q = 0
   v = 3
   t = 0
   For l = 1 To 2 ' dirs/files
      If l = 2 Then
         If VarQ = False Then
            Exit For
         End If
      End If
      ASCIIZ4 = Var4$ + Chr$(0)
      hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
      If hfind <> INVALID_HANDLE_VALUE Then
         z = 0
         Do
            If ControlBreak Then Exit Do
            OK = False
            Var# = finddata.dwFileAttributes
            If l = 1 Then
               If (Var# And &H10) = &H10 Then
                  OK = True
               End If
            End If
            If l = 2 Then
               If (Var# And &H10) = &H0 Then
                  OK = True
               End If
            End If

            X$ = finddata.cFileName
            VarX = InStr(X$, Chr$(0))
            If VarX Then
               X$ = Left$(X$, VarX - 1)
            End If
            X$ = RTrim$(X$)
            If X$ = "." Or X$ = ".." Then
               OK = False
            End If
            If OK Then
               If t Then
                  t = 0
                  GoSub TitleHeader
               End If
               Attr$ = Space$(7)
               If l = 1 Then
                  Mid$(Attr$, 2, 1) = "D"
                  d1 = d1 + 1
               Else
                  f1 = f1 + 1
               End If
               q = -1

               ' print shortfilename
               z$ = finddata.cAlternateFileName
               vx = InStr(z$, Chr$(0))
               If vx Then
                  z$ = Left$(z$, vx - 1)
               End If
               If z$ = Nul Then
                  z$ = finddata.cFileName
                  vx = InStr(z$, Chr$(0))
                  If vx Then
                     z$ = Left$(z$, vx - 1)
                  End If
               End If
               If Len(z$) > 12 Then
                  z$ = Left$(z$, 12)
               End If
               Color Yellow, Black
               Print UCase$(z$);
               If Len(z$) <= 14 Then
                  Print Space$(14 - Len(z$));
               End If

               ' print date/time
               x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)

               If Creation.Time Then
                  x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
               Else
                  If Access.Time Then
                     x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
                  Else
                     If Modified.Time Then
                        x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
                     End If
                  End If
               End If

               Var$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
               Var$ = Var$ + LTrim$(Str$(SysTime.wYear)) + "  "
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
               Var$ = Var$ + LTrim$(Str$(SysTime.wYear))
               Color Green, Black
               Print Var$;

               ' check linelength
               If ScreenWidth = 40 Then GoTo NextFile

               ' attributes of directory/filename
               Var# = finddata.dwFileAttributes
               If Var# < 0 Then
                  Var# = 0
               End If
               If (Var# And &H20) = &H20 Then
                  Mid$(Attr$, 1, 1) = "A" ' archive
               End If
               If (Var# And &H4) = &H4 Then
                  Mid$(Attr$, 3, 1) = "S" ' system
               End If
               If (Var# And &H2) = &H2 Then
                  Mid$(Attr$, 4, 1) = "H" ' hidden
               End If
               If (Var# And &H1) = &H1 Then
                  Mid$(Attr$, 5, 1) = "R" ' read-only
               End If
               If (Var# And &H800) = &H800 Then
                  Mid$(Attr$, 6, 1) = "C" ' compressed
               End If
               If (Var# And &H4000) = &H4000 Then
                  Mid$(Attr$, 7, 1) = "E" ' encrypted
               End If
               Color Red, Black
               Print " "; Attr$; " ";

               ' print filesize
               z$ = "<DIR>"
               If l = 2 Then
                  Var# = finddata.nFileSizeHigh * &H100000000~&&
                  Var# = Var# Or finddata.nFileSizeLow
                  VarX~&& = VarX~&& + Var# ' add bytes
                  Call Suffix(Var#, z$) ' 1,024.0 KB
               End If
               z$ = Left$(z$, 10)
               z$ = Space$(10 - Len(z$)) + z$
               Color Cyan, Black
               Print z$; " ";

               ' print longfilename
               z$ = finddata.cFileName
               VarX = InStr(z$, Chr$(0))
               If VarX Then
                  z$ = Left$(z$, VarX - 1)
               End If
               z$ = RTrim$(z$)
               If Len(z$) Then
                  If Len(z$) > 21 Then
                     z$ = Left$(z$, 20) + "..."
                  End If
                  Color Yellow, Black
                  Print z$;
               End If
               NextFile:
               Print
               ' prompt
               v = v + 1
               If v >= ScreenHeight - 2 Then
                  v = 2
                  If c = 0 Then
                     Color White, Black
                     Print MorePrompt0;
                     X$ = Nul
                     Do
                        X$ = InKeyx$
                        If ControlBreak Then
                           ControlBreak = False
                           Exit Do
                        End If
                        If Len(X$) Then
                           Select Case LCase$(X$)
                              Case "c" ' continuous
                                 c = -1
                                 Exit Do
                              Case "n", "q" ' no/quit
                                 v = 0
                                 Print
                                 Exit For
                              Case " ", CR, "y" ' yes/continue
                                 Exit Do
                           End Select
                        End If
                     Loop
                     Print
                     t = -1
                  End If
               End If
            End If
         Loop While FindNextFileA(hfind, _Offset(finddata))
         x = FindClose(hfind)
      End If
      If ControlBreak Then
         ControlBreak = 0
         Exit For
      End If
   Next
   If q = 0 Then
      Color Yellow, Black
      Print None
   End If

   ' print totals
   Color White, Black
   If ScreenWidth = 40 Then
      Print "------------"
      TotalLine$ = "Files " + FormatString$(CDbl(f1))
      TotalLine$ = TotalLine$ + " Dirs " + FormatString$(CDbl(d1))
      TotalLine$ = Left$(TotalLine$, 39)
      Print TotalLine$
   Else
      Print "------------                                 ----------"
      TotalLine$ = "Files " + FormatString$(CDbl(f1))
      TotalLine$ = TotalLine$ + " Dirs " + FormatString$(CDbl(d1))
      TotalLine$ = Left$(TotalLine$, 40)
      TotalLine$ = TotalLine$ + Space$(44 - Len(TotalLine$))

      VarX# = CDbl(VarX~&&)
      Call Suffix(VarX#, z$) ' 1,024.0 KB
      z$ = Left$(z$, 10)
      TotalLine$ = TotalLine$ + Space$(11 - Len(z$)) + z$
      Print TotalLine$
   End If
   Exit Sub

   TitleHeader:
   Color White, Black
   If ScreenWidth = 40 Then
      If l = 1 Then
         Print "Directory     Date        Time"
      Else
         Print "Filename      Date        Time"
      End If
      Print "------------  ----------  --------"
   Else
      If l = 1 Then
         Print "Directory     Date        Time       Attr          Size Longfilename"
      Else
         Print "Filename      Date        Time       Attr          Size Longfilename"
      End If
      Print "------------  ----------  --------   -----   ---------- ------------"
   End If
   Return
End Sub

' lists specified drives
Sub ListDrives (Var$, VarQ)
   ' Var$ = "x..." only list drives in string
   ' VarQ = 0 list all drives, VarQ = 1 to 26 list drives in array list
   '    always skips A: and B: unless array element 1 or 2 is equal to 1.

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Error 175
         Exit Sub
      End If
   End If

   l = 0
   GoSub DriveHeader
   For c = 1 To 26
      If Var$ <> Nul Then ' display specific drives
         x$ = UCase$(Var$)
         If InStr(x$, Chr$(c + 64)) Then
            x = InStr(x$, Chr$(c + 64))
            x = Asc(Mid$(x$, x, 1))
            If x >= 65 And x <= 90 Then
               x = x - 64
               If c = x Then
                  GoSub DisplayDrive
               End If
            End If
         End If
      Else
         If VarQ = False Then ' display all drives except A: or B:
            If c >= 3 Then
               GoSub DisplayDrive
            End If
         Else
            If c <= 2 Then ' check floppy override
               If Arrays(VarQ, c) = 1 Then
                  GoSub DisplayDrive
               End If
            Else
               If Arrays(VarQ, c) = 0 Then ' compare drive array list
                  GoSub DisplayDrive
               End If
            End If
         End If
      End If
      If h = 20 Then
         h = 0
         Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
         GoSub DriveHeader
      End If
   Next
   If q = 0 Then
      Print "<none>"
   Else
      Color White, Black
      Print "Total drives"; l
   End If
   Exit Sub

   DisplayDrive:
   c$ = Chr$(c + 64)
   Out3 = c$
   If DRIVEEXISTS(c) = False Then
      h = h + 1
      l = l + 1
      q = -1

      ' display drive letter
      Color White, Black
      Print c$; ":    ";

      ' display volume label
      Color Yellow, Black
      Out3 = c$
      Call Vlabel(Out3)
      If RTrim$(Out3) = Nul Then
         z$ = DriveType
      Else
         z$ = Left$(Out3, 12)
      End If
      z$ = z$ + Space$(13 - Len(z$))
      Print z$;

      ' display volume serial number
      Color Green, Black
      Out3 = c$
      Call Vserial(Out3)
      z$ = Left$(Out3, 12)
      z$ = z$ + Space$(13 - Len(z$))
      Print z$;

      ' check linelength
      If ScreenWidth = 40 Then Print: Return

      ' display volume file system type
      Color Red, Black
      Out3 = c$
      Call Vtype(Out3)
      z$ = Left$(Out3, 8)
      z$ = z$ + Space$(9 - Len(z$))
      Print z$;

      ' display volume total disk space
      Color Cyan, Black
      Out3 = c$
      Call TotalSpace(Out3)
      x# = Int(Val(Out3))
      If x# > Dfalse Then
         Call Suffix(x#, S$) ' 1,024.0 KB
         S$ = Left$(S$, 10)
         Print Space$(11 - Len(S$)) + S$;
      Else
         Print "      <n/a>";
      End If

      ' display volume free disk space
      Out3 = c$
      Call FreeSpace(Out3)
      y# = Int(Val(Out3))
      If y# > Dfalse Then
         Call Suffix(y#, S$) ' 1,024.0 KB
         S$ = Left$(S$, 10)
         Print Space$(11 - Len(S$)) + S$;
      Else
         Print "      <n/a>";
      End If

      ' display volume used disk space
      Out3 = c$
      Call UsedSpace(Out3)
      z# = Int(Val(Out3))
      If z# > Dfalse Then
         Call Suffix(z#, S$) ' 1,024.0 KB
         S$ = Left$(S$, 10)
         Print Space$(11 - Len(S$)) + S$
      Else
         Print "      <n/a>"
      End If
   End If
   Return

   DriveHeader:
   h = 2
   Color White, Black
   If ScreenWidth = 40 Then
      Print "Drive Label        Serial"
      Print "----------------------------"
   Else
      Print "Drive Label        Serial       Type           Total       Free       Used"
      Print "--------------------------------------------------------------------------"
   End If
   Return
End Sub

' formats a double numeric string
Function FormatString$ (s#)
   x$ = Nul
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString$ = x$
End Function

' ambiguate function
Function Ambiguate2$ (Var$)
   VarX$ = Var$
   If InStr(VarX$, ":") Then
      VarX$ = Mid$(VarX$, InStr(VarX$, ":") + 1)
   End If
   For VarX = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, VarX, 1) = "\" Then
         VarX$ = Mid$(VarX$, VarX + 1)
         Exit For
      End If
   Next
   Ambiguate2$ = VarX$
End Function

' ambiguate function
Function Ambiguate$ (Var$)
   Dim ASCIIZ4 As String * 260
   Dim ASCIIZ5 As String * 260

   If Len(Var$) = False Then
      Ambiguate$ = Nul
      Exit Function
   End If

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Ambiguate$ = Var$
         Exit Function
      End If
   End If

   ASCIIZ4 = Var$ + Chr$(0)
   ret = GetShortPathName(ASCIIZ4, ASCIIZ5, MAX_PATH + 1)
   If ret > 0 Then
      Var2$ = ASCIIZ5
   Else
      Var2$ = ASCIIZ4
   End If
   v = InStr(Var2$, Chr$(0))
   If v Then
      Var2$ = Left$(Var2$, v - 1)
   End If
   If Var2$ = "." Then
      Var2$ = Nul
   End If
   Ambiguate$ = Var2$
End Function

' emulate shortfilename DIR$()
Sub FileDir (Var3$)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Out3 = Nul
         Exit Sub
      End If
   End If

   ' init filelist
   If Len(Var3$) Then
      ' see if directory exists
      Var4$ = Var3$
      If _DirExists(Var3$) Then
         If Right$(Var3$, 1) = "\" Then
            Var4$ = Var4$ + "*.*"
         Else
            Var4$ = Var4$ + "\*.*"
         End If
      End If

      If hfind2 Then
         x = FindClose(hfind2)
         hfind2 = 0
      End If

      ASCIIZ4 = Var4$ + Chr$(0)
      hfind2 = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata2))
      If hfind2 = INVALID_HANDLE_VALUE Then
         hfind2 = 0
         Out3 = Nul
         Exit Sub
      End If
   End If

   ' get short filename
   If hfind2 Then
      Out3 = finddata2.cAlternateFileName
      VarX = InStr(Out3, Chr$(0))
      If VarX Then
         Out3 = Left$(Out3, VarX - 1)
      End If
      If Out3 = Nul Then
         Out3 = finddata2.cFileName
         VarX = InStr(Out3, Chr$(0))
         If VarX Then
            Out3 = Left$(Out3, VarX - 1)
         End If
      End If
      Out3 = RTrim$(Out3)
      Out3 = UCase$(Out3)
      If FindNextFileA(hfind2, _Offset(finddata2)) = 0 Then
         x = FindClose(hfind2)
         hfind2 = 0
      End If
   End If
End Sub

' delete old temp files
Sub DelTemp (Ext$)
   Dim ASCIIZ4 As String * 260
   Dim Attr As _Unsigned Long
   ' reset search parameter
   Var4$ = DRX + Ext$
   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' delete longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               ASCIIZ4 = DRX + z$ + Chr$(0)
               Attr = 0&
               z = SetFileAttributes&(ASCIIZ4, Attr)
               f$ = DRX + z$ + Chr$(0)
               x = DeleteFileA%(f$)
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
End Sub

' delete old temp files
Sub DelTemp2 (Ext$)
   Dim ASCIIZ4 As String * 260
   Dim Attr As _Unsigned Long

   ' reset search parameter
   Var4$ = DRX2 + Ext$

   ' display header
   Color White, Black
   Print "Deleting: " + Var4$

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' delete longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               ASCIIZ4 = DRX2 + z$ + Chr$(0)
               Attr = 0&
               z = SetFileAttributes&(ASCIIZ4, Attr)
               f$ = DRX2 + z$ + Chr$(0)
               x = DeleteFileA%(f$)
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
End Sub

Sub DelTemp3 (Ext$)
   Dim ASCIIZ4 As String * 260
   Dim Attr As _Unsigned Long
   ' reset search parameter
   Var4$ = _CWD$
   If Right$(Var4$, 1) <> "\" Then Var4$ = Var4$ + "\"
   Var4$ = Var4$ + Ext$
   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' delete longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               ASCIIZ4 = DRX + z$ + Chr$(0)
               Attr = 0&
               z = SetFileAttributes&(ASCIIZ4, Attr)
               f$ = DRX + z$ + Chr$(0)
               x = DeleteFileA%(f$)
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
End Sub

' count backup files
Function CountBackupFiles#
   Dim ASCIIZ4 As String * 260
   Found# = Dfalse

   ' reset search parameter
   Var4$ = DRX2 + "*.BKP"
   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountBackupFiles# = Found#
End Function

' count bytes
Function CountBytes# (Ext$)
   Dim ASCIIZ4 As String * 260
   Found# = Dfalse

   ' reset search parameter
   Var4$ = _CWD$
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = Nul Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  VarZ# = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow
                  Found# = Found# + VarZ#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountBytes# = Found#
End Function

' count files
Function CountFiles# (Ext$)
   Dim ASCIIZ4 As String * 260
   Found# = Dfalse

   ' reset search parameter
   Var4$ = _CWD$
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = Nul Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountFiles# = Found#
End Function

' count dirs
Function CountDirs# (Ext$)
   Dim ASCIIZ4 As String * 260
   Found# = Dfalse

   ' reset search parameter
   Var4$ = _CWD$
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = Nul Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata.dwFileAttributes
               If (Var# And &H10) = &H10 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If
   CountDirs# = Found#
End Function

' count drives
Function CountDriveLetters$
   v$ = Nul
   For c = 1 To 26
      If DRIVEEXISTS(c) = False Then
         v$ = v$ + Chr$(c + 64)
      End If
   Next
   CountDriveLetters = v$
End Function

' count drives
Function CountDrives%
   v = 0
   For c = 1 To 26
      If DRIVEEXISTS(c) = False Then
         v = v + 1
      End If
   Next
   CountDrives = v
End Function

' emulate longfilename DIRX$()
Sub FileDirX (Var3$)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Out3 = Nul
         Exit Sub
      End If
   End If

   ' init filelist
   If Len(Var3$) Then
      ' see if directory exists
      Var4$ = Var3$
      If _DirExists(Var3$) Then
         If Right$(Var3$, 1) = "\" Then
            Var4$ = Var4$ + "*.*"
         Else
            Var4$ = Var4$ + "\*.*"
         End If
      End If

      If hfind3 Then
         x = FindClose(hfind3)
         hfind3 = 0
      End If

      ASCIIZ4 = Var4$ + Chr$(0)
      hfind3 = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata3))
      If hfind3 = INVALID_HANDLE_VALUE Then
         hfind3 = 0
         Out3 = Nul
         Exit Sub
      End If
   End If

   ' get long filename
   If hfind3 Then
      Out3 = finddata3.cFileName
      VarX = InStr(Out3, Chr$(0))
      If VarX Then
         Out3 = Left$(Out3, VarX - 1)
      End If
      Out3 = RTrim$(Out3)
      If FindNextFileA(hfind3, _Offset(finddata3)) = 0 Then
         x = FindClose(hfind3)
         hfind3 = 0
      End If
   End If
End Sub

' test volume media inserted.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If

   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = Nul
   ' drives A: and B: default to floppy
   If DriveType = Nul Then
      If V = 1 Then
         DriveType = "[FLOPPY A]"
         DRIVEEXISTS = False
         Exit Function
      End If
      If V = 2 Then
         DriveType = "[FLOPPY B]"
         DRIVEEXISTS = False
         Exit Function
      End If
   End If
   Select Case VarX
      Case 0 ' invalid drive
         DriveType = "[UNKNOWN]"
      Case 1 ' invalid drive
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = False
   Else
      DRIVEEXISTS = True
   End If
End Function

' check netpath exists.
'  returns -1 if netpath not detected.
Function NETPATHEXISTS (Z$)
   VarX$ = Z$ + Chr$(0)
   VarX = GetDriveType(VarX$)
   If VarX > 1 Then
      NETPATHEXISTS = False
   Else
      NETPATHEXISTS = True
   End If
End Function

' get file date
Sub FileDate (Var$)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   If Var$ = Nul Then
      Error 53
      Exit Sub
   End If

   If InStr(Var$, "?") Or InStr(Var$, "*") Then
      Error 53
      Exit Sub
   End If

   ErrorCount = False
   ErrorType2 = True

   ' construct file date for display.
   ASCIIZ4 = Var$ + Chr$(0)
   Var$ = Nul
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)

      If Creation.Time Then
         x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      Else
         If Access.Time Then
            x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
         Else
            If Modified.Time Then
               x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
            End If
         End If
      End If

      Var$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
      Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
      Var$ = Var$ + LTrim$(Str$(SysTime.wYear))
      x = FindClose(hfind)
   End If
End Sub

' get file time
Sub FileTime (Var$)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   If Var$ = Nul Then
      Error 53
      Exit Sub
   End If

   If InStr(Var$, "?") Or InStr(Var$, "*") Then
      Error 53
      Exit Sub
   End If

   ErrorCount = False
   ErrorType2 = True

   ' construct file time for display.
   ASCIIZ4 = Var$ + Chr$(0)
   Var$ = Nul
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)

      If Creation.Time Then
         x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      Else
         If Access.Time Then
            x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
         Else
            If Modified.Time Then
               x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
            End If
         End If
      End If

      Var$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
      Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
      Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
      x = FindClose(hfind)
   End If
End Sub

' get file size
Sub FileSize (Var#)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var# = Dfalse
         Exit Sub
      End If
   End If

   If Out3 = Nul Then
      Error 53
      Exit Sub
   End If

   If InStr(Out3, "?") Or InStr(Out3, "*") Then
      Error 53
      Exit Sub
   End If

   ErrorCount = False
   ErrorType2 = True

   ' get file size.
   ASCIIZ4 = Out3 + Chr$(0)
   Var# = Dfalse
   hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Var# = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow
      x = FindClose(hfind)
   End If
End Sub

' get dir/file attribute
Sub FileAttr (Var#)
   Dim ASCIIZ4 As String * 260

   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var# = Dfalse
         Exit Sub
      End If
   End If

   If Out3 = Nul Then
      Error 53
      Exit Sub
   End If

   If InStr(Out3, "?") Or InStr(Out3, "*") Then
      Error 53
      Exit Sub
   End If

   ErrorCount = False
   ErrorType2 = True

   ASCIIZ4 = Out3 + Chr$(0)
   Var# = GetFileAttributes(ASCIIZ4)
   If Var# < 0 Then
      Var# = 0
   End If
End Sub

' get volume label
Sub Vlabel (Var$)
   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   ' get drive info.
   VarX$ = Var$ + ":\" + Chr$(0)
   Var$ = Nul
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      ' get volume label.
      Var$ = RTrim$(Vname$)
      v = InStr(Var$, Chr$(0))
      If v Then Var$ = Left$(Var$, v - 1)
   End If
End Sub

' get volume serial number
Sub Vserial (Var$)
   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   ' get drive info.
   VarX$ = Var$ + ":\" + Chr$(0)
   Var$ = Nul
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      ' serial number.
      Var$ = Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4)
   End If
End Sub

' get volume system type
Sub Vtype (Var$)
   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   ' get drive info.
   VarX$ = Var$ + ":\" + Chr$(0)
   Var$ = Nul
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      ' get volume system type.
      Var$ = RTrim$(Fname$)
      v = InStr(Var$, Chr$(0))
      If v Then Var$ = Left$(Var$, v - 1)
   End If
End Sub

' get drive freespace
Sub FreeSpace (Var$)
   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   ' check disk exists
   c = Asc(Left$(UCase$(Var$), 1)) - 64
   If DRIVEEXISTS(c) Then
      Var$ = Nul
      Exit Sub
   End If

   V = Asc(Left$(UCase$(Var$), 1)) - 64
   If MEDIAEXISTS(V) = False Then
      Var$ = Nul
      Exit Sub
   End If

   VarX$ = Var$ + ":\" + Chr$(0)
   Var$ = Nul

   r = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
   If r Then
      Var$ = LTrim$(Str$(free~&&))
   End If
   Exit Sub

   r = GetDiskFreeSpaceA(VarX$, sectors&, bytes&, free&, total&)
   If r Then
      ' sectors per cluster * bytes per sector * free clusters
      x1# = CDbl(sectors&) * CDbl(bytes&) * CDbl(free&)
      Var$ = LTrim$(Str$(x1#))
   End If
End Sub

' get drive totalspace
Sub TotalSpace (Var$)
   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   ' check disk exists
   c = Asc(Left$(UCase$(Var$), 1)) - 64
   If DRIVEEXISTS(c) Then
      Var$ = Nul
      Exit Sub
   End If

   V = Asc(Left$(UCase$(Var$), 1)) - 64
   If MEDIAEXISTS(V) = False Then
      Var$ = Nul
      Exit Sub
   End If

   VarX$ = Var$ + ":\" + Chr$(0)
   Var$ = Nul

   r = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
   If r Then
      Var$ = LTrim$(Str$(total~&&))
   End If
   Exit Sub

   r = GetDiskFreeSpaceA(VarX$, sectors&, bytes&, free&, total&)
   If r Then
      ' sectors per cluster * bytes per sector * total clusters
      x1# = CDbl(sectors&) * CDbl(bytes&) * CDbl(total&)
      Var$ = LTrim$(Str$(x1#))
   End If
End Sub

' get drive usedspace
Sub UsedSpace (Var$)
   If Compatible = False Then
      If LINUX Or MACOSX Then
         Var$ = Nul
         Exit Sub
      End If
   End If

   ' check disk exists
   c = Asc(Left$(UCase$(Var$), 1)) - 64
   If DRIVEEXISTS(c) Then
      Var$ = Nul
      Exit Sub
   End If

   V = Asc(Left$(UCase$(Var$), 1)) - 64
   If MEDIAEXISTS(V) = False Then
      Var$ = Nul
      Exit Sub
   End If

   VarX$ = Var$ + ":\" + Chr$(0)
   Var$ = Nul

   ' total space
   r = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
   If r Then
      x0# = total~&&
   Else
      r = GetDiskFreeSpaceA(VarX$, sectors&, bytes&, free&, total&)
      If r Then
         ' sectors per cluster * bytes per sector * total clusters
         x0# = CDbl(sectors&) * CDbl(bytes&) * CDbl(total&)
      End If
   End If

   ' free space
   r = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
   If r Then
      x1# = free~&&
   Else
      r = GetDiskFreeSpaceA(VarX$, sectors&, bytes&, free&, total&)
      If r Then
         ' sectors per cluster * bytes per sector * free clusters
         x1# = CDbl(sectors&) * CDbl(bytes&) * CDbl(free&)
      End If
   End If

   ' used space
   x2# = x0# - x1#
   Var$ = LTrim$(Str$(x2#))
End Sub

' display help menu
Sub ListHelp
   Do
      Color White, Black
      Print "Help utility SIC64 v" + Version + " r" + Release + " list: for QB64 (node "; Hex$(Node); ")"
      Color Yellow, Black
      Print "[1]command list"
      Print "[2]general documentation"
      Print "[3]formatting information"
      Print "[4]screen mode tables"
      Print "[5]error code values"
      Print "[6]syntax documentation"
      Print "[7]boolean syntax/charts"
      Print "[8]troolean syntax/charts"
      Print "[9]disclaimer notice"
      Print "[0]set prompt info"
      Print "[A]shareware information"
      Print "[B]version list"
      Print "[C]short command list"
      Call MorePrompt("Enter(1-C,Q to quit)?", "1234567890abcq", OutputChar$)
      Select Case OutputChar$
         Case "0"
            Filename = "prompt.doc"
            Call ListHelpFile(0)
         Case "1"
            Filename = "menu4.doc"
            Call ListHelpFile(-1)
         Case "2"
            Filename = "sic64.doc"
            Call ListHelpFile(0)
         Case "3"
            Filename = "sicform.doc"
            Call ListHelpFile(0)
         Case "4"
            Filename = "sicscrn.doc"
            Call ListHelpFile(0)
         Case "5"
            Filename = "error.doc"
            Call ListHelpFile(0)
         Case "6"
            Filename = "syntax1.doc"
            Call ListHelpFile(0)
         Case "7"
            Filename = "boolean.doc"
            Call ListHelpFile(0)
         Case "8"
            Filename = "troolean.doc"
            Call ListHelpFile(0)
         Case "9"
            Filename = "disclaim.doc"
            Call ListHelpFile(0)
         Case "a"
            Filename = "disclam2.doc"
            Call ListHelpFile(0)
         Case "b"
            Filename = "version.lst"
            Call ListHelpFile(0)
         Case "c"
            Filename = "menu5.doc"
            Call ListHelpFile(0)
         Case "q"
            Exit Do
      End Select
   Loop
End Sub

' displays a help file
' input: VarQ equals -1 to parse macros.
Sub ListHelpFile (VarQ)
   FileFound = _FileExists(Filename$)
   If FileFound = False Then
      Print "Helpfile " + Quote + Filename + Quote + " not found."
      Call MorePrompt(MorePrompt1, "ync", OutputChar$)
      Exit Sub
   End If
   X = FreeFileNumber
   Open Filename$ For Input As #FileNumber
   Continuous = False
   LineCount = False
   Do While Not EOF(FileNumber)
      Color Yellow, Black
      Line Input #FileNumber, InputLine$
      If Left$(LTrim$(InputLine$), 1) = ";" Then
         GoTo NextHelpLine
      End If
      If VarQ Then ' check macros
         GoSub ConvertColor
         If VarX Then
            GoTo NextHelpLine
         End If
         If LCase$(InputLine$) = "<cls>" Then
            Cls
            GoTo NextHelpLine
         End If
         If LCase$(InputLine$) = "<more>" Then
            If LineCount > 0 Then
               LineCount = 23
               GoSub DisplayMore
            End If
            GoTo NextHelpLine
         End If
         Do
            V = InStr(LCase$(InputLine$), "quote")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + Quote + Mid$(InputLine$, V + 5)
            Else
               Exit Do
            End If
         Loop
         Do
            V = InStr(LCase$(InputLine$), "date$")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + Date$ + Mid$(InputLine$, V + 5)
            Else
               Exit Do
            End If
         Loop
         Do
            V = InStr(LCase$(InputLine$), "time$")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + Time$ + Mid$(InputLine$, V + 5)
            Else
               Exit Do
            End If
         Loop
         Do
            V = InStr(LCase$(InputLine$), "<date>")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + Date$ + Mid$(InputLine$, V + 6)
            Else
               Exit Do
            End If
         Loop
         Do
            V = InStr(LCase$(InputLine$), "<time>")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + Time$ + Mid$(InputLine$, V + 6)
            Else
               Exit Do
            End If
         Loop
         Do
            V = InStr(LCase$(InputLine$), "<clock>")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + clock$ + Mid$(InputLine$, V + 7)
            Else
               Exit Do
            End If
         Loop
         Do
            V = InStr(LCase$(InputLine$), "<recent>")
            If V Then
               InputLine$ = Left$(InputLine$, V - 1) + LTrim$(Str$(MaxRecent)) + Mid$(InputLine$, V + 8)
            Else
               Exit Do
            End If
         Loop
      End If
      Print InputLine$
      If Continuous = False Then
         LineCount = LineCount + 1
         GoSub DisplayMore
      End If
      NextHelpLine:
   Loop
   Call KeyPrompt
   Close #FileNumber
   FileNumber = False
   Exit Sub

   DisplayMore:
   If LineCount >= PageLength Then
      LineCount = False
      Call MorePrompt(MorePrompt1, "ync" + CR, OutputChar$)
      Select Case LCase$(OutputChar$)
         Case "n"
            Call KeyPrompt
            Close #FileNumber
            FileNumber = False
            Exit Sub
         Case "c"
            Continuous = True
      End Select
   End If
   Return

   ConvertColor:
   VarX = 0
   VarX$ = LCase$(InputLine$)
   VarX$ = Xtrim$(VarX$, 0)
   Select Case VarX$
      Case "<color=gray>", "<color=8>"
         Color Gray
         VarX = True
      Case "<color=blue>", "<color=9>"
         Color Blue
         VarX = True
      Case "<color=green>", "<color=10>"
         Color Green
         VarX = True
      Case "<color=cyan>", "<color=11>"
         Color Cyan
         VarX = True
      Case "<color=red>", "<color=12>"
         Color Red
         VarX = True
      Case "<color=magenta>", "<color=13>"
         Color Magenta
         VarX = True
      Case "<color=yellow>", "<color=14>"
         Color Yellow
         VarX = True
      Case "<color=white>", "<color=15>"
         Color White
         VarX = True
   End Select
   Return
End Sub

' lists current .sic program
Sub ListProgram (StartLine, StopLine, PrintProg)
   Color White, Black

   If PrintProg Then
      LPrint "Program: "; ProgramName
   Else
      Print "Program: "; ProgramName
   End If

   Continuous = False
   LineCount = 1
   For ProgramLine = StartLine To StopLine
      Out2 = Program$(ProgramLine)
      If Len(Out2) Then
         Color Yellow, Black
         If PrintProg Then
            If InStr(WhiteSpace, Left$(Out2, 1)) Then
               LPrint Mid$(Str$(ProgramLine), 2) + Out2
            Else
               LPrint Mid$(Str$(ProgramLine), 2) + " " + Out2
            End If
         Else
            If InStr(WhiteSpace, Left$(Out2, 1)) Then
               V$ = ">" + Mid$(Str$(ProgramLine), 2) + Out2
            Else
               V$ = ">" + Mid$(Str$(ProgramLine), 2) + " " + Out2
            End If
            Print V$
            If Continuous = False Then
               Z = LastWidth1: If Z = 0 Then Z = 80
               LineCount = LineCount + Int((Len(V$) - 1) / Z) + 1
               If LineCount >= PageLength Then
                  LineCount = False
                  Call MorePrompt(MorePrompt1, "ync" + CR, OutputChar$)
                  Select Case OutputChar$
                     Case "n"
                        Exit For
                     Case "c"
                        Continuous = True
                  End Select
               End If
            End If
         End If
      End If
   Next
   Color White, Black
   Print "Program list ended."

   If PrintProg Then
      _ControlChr On
      LPrint Chr$(12);
      _ControlChr Off
   End If
End Sub

' searchs current .sic program
Sub SearchProgram
   Call CountLines(LastLine)
   Color White, Black
   If LastSearchLine > False Then
      Call MorePrompt("Continue search(y/n)?", "yn", OutputChar$)
      If OutputChar$ = "y" Then
         Var1 = LastSearchCase
         Var1$ = LastSearchKeyword
         StartLine = LastSearchLine + 1
         If StartLine > MaxLines Then
            Color White, Black
            Print "Program search ended."
            Exit Sub
         End If
         Print "Continuing search from line:" + Str$(StartLine)
         GoTo StartSearch
      End If
   End If
   ProgramLine = False
   Visible = 1
   Color White, Black
   Locate , 1, 1
   Print "Search string:"
   Locate , , 1
   Do
      Visible = 1
      Color Yellow, Black
      Locate , 1, 1
      Temp0 = 4
      PromptLine = CsrLin
      Call DisplayPrompt(Prompt4$)
      Color White, Black
      PromptStore = Prompt4$
      Locate , , 1
      Temp0 = 4
      Out2 = KeyboardLine2$(Prompt4)
      Print
      If Out2 <> Nul Then
         Exit Do
      End If
   Loop
   Var1$ = Out2
   Call MorePrompt("Case-sensitive(y/n)?", "yn", OutputChar$)
   If OutputChar$ = "y" Then
      Var1 = True
   Else
      Var1 = False
   End If
   StartLine = 1

   StartSearch:

   Print "Searching Program: " + Quote + ProgramName + Quote

   For ProgramLine = StartLine To LastLine
      Out2 = Program$(ProgramLine)
      If Len(Out2) Then
         Call InstrSUB1(Flag, Var1$, Out2, Var1)
         If Flag Then
            Color Yellow, Black
            If InStr(WhiteSpace, Left$(Out2, 1)) Then
               Print ">" + Mid$(Str$(ProgramLine), 2) + Out2
            Else
               Print ">" + Mid$(Str$(ProgramLine), 2) + " " + Out2
            End If
            Call MorePrompt(MorePrompt2, "yn" + CR, OutputChar$)
            If OutputChar$ = "n" Then
               Exit For
            End If
         End If
      End If
   Next
   LastSearchCase = Var1
   LastSearchLine = ProgramLine
   LastSearchKeyword = Var1$
   Color White, Black
   Print "Program search ended."
End Sub

' loads a .sic file
Sub LoadProgram (Var$)
   If SaveOnExit Then
      Call SaveCurrent
   End If
   If Var$ = Nul Then
      Filter$ = "All files (*.*)|*.sic|*.SIC"
      Title$ = "SICK Open File"
      ProgramFile$ = _OpenFileDialog$(Title$, StartDir$, Filter$)
      Temp1$ = ProgramFile$
   Else
      If Right$(Var$, 1) = Quote Then
         If Left$(Var$, 1) = Quote Then
            Var$ = Left$(Var$, Len(Var$) - 1)
            Var$ = Mid$(Var$, 2)
         End If
      End If
      If Var$ = Nul Then
         Color White
         Print "File not found."
         Exit Sub
      End If
      ProgramFile$ = Var$
      If InStr(Var$, ":") = 0 And InStr(Var$, "\") = 0 Then
         Temp1$ = StartDir$ + ProgramFile$
      Else
         Temp1$ = ProgramFile$
      End If
   End If
   If Right$(ProgramFile$, 1) = Quote Then
      If Left$(ProgramFile$, 1) = Quote Then
         ProgramFile$ = Left$(ProgramFile$, Len(ProgramFile$) - 1)
         ProgramFile$ = Mid$(ProgramFile$, 2)
      End If
   End If
   If ProgramFile$ = Nul Then
      Color White
      Print "File not found."
      Exit Sub
   End If
   If Right$(LCase$(ProgramFile$), 4) <> ".sic" Then
      Color White
      Print "File not found."
      Exit Sub
   End If
   Call Concatenate(ProgramFile$)
   ' store .sic program name into recent array.
   If Right$(Temp1$, 1) = Quote Then
      If Left$(Temp1$, 1) = Quote Then
         Temp1$ = Left$(Temp1$, Len(Temp1$) - 1)
         Temp1$ = Mid$(Temp1$, 2)
      End If
   End If
   StoredProgramName = Temp1$
   Call AddRecent

   Filename = ProgramFile$
   LastSearchLine = False
   Call NewProgram
   ProgramName = None
   PrepareFilename = Nul
   Call ReadProgram
   Call CountLines(LastLine)
   If LastLine = False Then
      Color White, Black
      Print "New program loaded."
   Else
      Color White, Black
      Print "Program loaded."
      If AutoIndent Then
         Call IndentProgram(-1, 3)
      End If
   End If
   ProgramName = Filename
   PrepareFilename = Filename
   ' adjust statusline timer to number of program lines.
   If LastLine = False Then
      t3! = 1!
      Timer(t2) Off
      On Timer(t2, t3!) StatusLine
      Timer(t2) On
   End If
   If LastLine > 0 Then
      Select Case LastLine
         Case Is > 250
            If t3! < 5! Then
               t3! = 5!
               Timer(t2) Off
               On Timer(t2, t3!) StatusLine
               Timer(t2) On
            End If
         Case Is > 150
            If t3! < 3! Then
               t3! = 3!
               Timer(t2) Off
               On Timer(t2, t3!) StatusLine
               Timer(t2) On
            End If
         Case Is > 100
            If t3! < 2! Then
               t3! = 2!
               Timer(t2) Off
               On Timer(t2, t3!) StatusLine
               Timer(t2) On
            End If
      End Select
   End If
End Sub

' add/remove/pack recent list.
Sub AddRecent
   If MaxRecent > 9 Then MaxRecent = 9
   If MaxRecent < 1 Then MaxRecent = 1
   ' backup recent list
   ReDim Recent2(0 To MaxRecent) As String
   Var2 = False
   For Var = 1 To MaxRecent
      Eat = 0
      If Len(StoredProgramName) Then
         If Recent1(Var) = StoredProgramName Then
            Eat = -1
         End If
      End If
      If Eat = 0 Then
         Var2 = Var2 + 1
         If Var2 <= MaxRecent Then
            Recent2(Var2) = Recent1(Var)
         End If
      End If
   Next
   ' restore original array
   ReDim Recent1(0 To MaxRecent) As String
   If Len(StoredProgramName) Then
      Var2 = 1
      Recent1(1) = StoredProgramName
   Else
      Var2 = 0
   End If
   For Var = 1 To MaxRecent
      Var$ = LTrim$(Recent2(Var))
      If Len(Var$) Then
         If _FileExists(Var$) Then ' check broken link
            Var2 = Var2 + 1
            If Var2 <= MaxRecent Then
               Recent1(Var2) = Recent2(Var)
            End If
         End If
      End If
   Next
End Sub

' recent filelist menu
Sub RecentMenu (VarX$)
   VarX$ = LTrim$(RTrim$(VarX$))
   If Len(VarX$) Then
      If LCase$(VarX$) = "help" Then
         Color White
         Print "RECENT <parameter$>"
         Print "  Starts recent menu:"
         Print "  Where optional parameter is:"
         Print "  Option 1-"; LTrim$(Str$(MaxRecent)); " loads recent file."
         Print "  LIST  - option lists files."
         Print "  REMOVE <n> - option removes file."
         Print "    where <n> is 1 to"; Str$(MaxRecent); "."
         Print "  RESET - clear recent array."
         Print "  STORE - store recent array."
         Print "  RESTORE - restore recent array."
         Print "  REFRESH - reload recent array."
         Print "  PACK    - pack and reload recent array."
         Print "  SORT    - sort recent array ascending."
         Print "  SORTX   - sort recent array descending."
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If Left$(LCase$(VarX$), 6) = "remove" Or Left$(LCase$(VarX$), 6) = "delete" Then
         VarZ$ = Mid$(VarX$, 7)
         VarZ$ = LTrim$(RTrim$(VarZ$))
         If Len(VarZ$) = 1 Then
            If Val(VarZ$) >= 1 And Val(VarZ$) <= MaxRecent Then
               VarZ = Int(Val(VarZ$))
               VarZ1$ = Recent1(VarZ)
               If Len(VarZ1$) Then
                  Recent1(VarZ) = Nul
                  Print "File in recentlist removed."
                  Call AddRecent
               Else
                  Print "Recentlist not found."
               End If
            Else
               Print "Recentlist not 1 to"; Str$(MaxRecent); "."
            End If
         Else
            Print "Recentlist not 1 to"; Str$(MaxRecent); "."
         End If
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "list" Then
         Call RecentList
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "refresh" Then
         Call AddRecent
         Call RecentList
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "pack" Then
         Call AddRecent
         Print "Recentlist packed."
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "sort" Then
         For Var1 = 1 To MaxRecent
            For Var2 = Var1 To MaxRecent
               If Recent1(Var1) > Recent1(Var2) Then
                  Swap Recent1(Var1), Recent1(Var2)
               End If
            Next
         Next
         Call AddRecent
         Print "Recentlist sorted."
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "sortx" Then
         For Var1 = 1 To MaxRecent
            For Var2 = Var1 To MaxRecent
               If Recent1(Var1) < Recent1(Var2) Then
                  Swap Recent1(Var1), Recent1(Var2)
               End If
            Next
         Next
         Call AddRecent
         Print "Recentlist sorted."
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "store" Then
         Call WriteRecent(VarQ)
         If VarQ = -1 Then
            Print "Recentlist stored."
         Else
            Print "Error Recentlist stored."
         End If
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "restore" Then
         Call ReadRecent(VarQ)
         If VarQ Then
            Print "Recentlist restored."
         Else
            Print "Error Recentlist restored."
         End If
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If LCase$(VarX$) = "reset" Then
         For VarX = 1 To MaxRecent
            Recent1(VarX) = Nul
         Next
         Print "Recentlist reset."
         Call AddRecent
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      If Val(VarX$) >= 1 And Val(VarX$) <= MaxRecent Then
         V = Int(Val(VarX$))
         V$ = LTrim$(Recent1(V))
         If Len(V$) Then
            Call LoadProgram(V$)
            Exit Sub
         End If
         Color Yellow
         Print "Recent file not found."
         Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
         Exit Sub
      End If
      Print "Recentlist command not found. Type RECENT HELP for help."
      Exit Sub
   End If
   Call RecentList
   Do
      Color White
      Print "Enter recent option(1-"; LTrim$(Str$(MaxRecent)); ",?=list,Q=quit)?";
      X$ = Nul
      Do
         _Limit LimitValue
         X$ = InKey$
         If X$ <> Nul Then
            If LCase$(X$) = "q" Then Print "q": Exit Sub
            If X$ = "?" Then Print "?": Call RecentList: Exit Do
            If Val(X$) >= 1 And Val(X$) <= MaxRecent Then
               Print X$
               V = Int(Val(X$))
               V$ = LTrim$(Recent1(V))
               If Len(V$) Then
                  Call LoadProgram(V$)
                  Exit Sub
               End If
               Color Yellow
               Print "Recent file not found."
               Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
               Exit Do
            End If
         End If
      Loop
   Loop
End Sub

' display files in recentlist.
Sub RecentList
   Color White
   Print "Recent filelist:"
   Color Yellow
   For Var = 1 To MaxRecent
      Print LTrim$(Str$(Var)); ")";
      Var$ = Recent1(Var)
      If LTrim$(Var$) = "" Then
         Print "<none>"
      Else
         If _FileExists(Var$) = 0 Then
            Print "<broken>"
         Else
            Print Var$
         End If
      End If
   Next
End Sub

' prompts for a keystroke
Sub KeyPrompt
   If BootError = False Then
      Color White, Black
      Locate , , 1
      Print "Press any key to continue:";
      Do
         Var$ = InKeyx$
         If ControlBreak Then
            ControlBreak = False
            Exit Do
         End If
         If Len(Var$) Then
            Exit Do
         End If
      Loop
      Print
   End If
End Sub

' prompts for multiple input characters
Sub MorePrompt (InputString$, InputMask$, OutputString$)
   Color White, Black
   If InputString$ = MorePrompt4 Then
      Print InputString$;
   Else
      Print InputString$; " ";
   End If
   InputChar$ = Nul
   Do
      Locate , , 1
      InputChar$ = LCase$(InKeyx$)
      If ControlBreak Then
         Print
         Color MoreBreakColor, Black
         Print MoreBreakMessage
         If MakeBeep Then
            Sound Freq, Duration
         End If
         Color White, Black
         If InputString$ = MorePrompt4 Then
            Print InputString$;
         Else
            Print InputString$; " ";
         End If
         ControlBreak = False
      End If
      If Len(InputChar$) Then
         If InputChar$ = "?" Then
            Call DisplayPromptHelp(InputString$)
            Color White, Black
            If InputString$ = MorePrompt4 Then
               Print InputString$;
            Else
               Print InputString$; " ";
            End If
         Else
            If InStr(InputMask$, InputChar$) Then
               If InputChar$ = CR Then
                  Print
               Else
                  Print InputChar$
               End If
               OutputString$ = InputChar$
               Exit Do
            End If
         End If
      End If
   Loop
End Sub

Sub MorePromptType (InputString$, InputMask$, OutputString$)
   Color White, Black
   If InputString$ = MorePrompt4 Then
      Print InputString$;
   Else
      Print InputString$; " ";
   End If
   InputChar$ = Nul
   Do
      Locate , , 1
      InputChar$ = LCase$(InKeyx$)
      If ControlBreak Then
         Print
         Color MoreBreakColor, Black
         Print MoreBreakMessage
         If MakeBeep Then
            Sound Freq, Duration
         End If
         Color White, Black
         Exit Do
      End If
      If Len(InputChar$) Then
         If InputChar$ = "?" Then
            Call DisplayPromptHelp(InputString$)
            Color White, Black
            If InputString$ = MorePrompt4 Then
               Print InputString$;
            Else
               Print InputString$; " ";
            End If
         Else
            If InStr(InputMask$, InputChar$) Then
               If InputChar$ = CR Then
                  Print
               Else
                  Print InputChar$
               End If
               OutputString$ = InputChar$
               Exit Do
            End If
         End If
      End If
   Loop
End Sub

' display prompt help
Sub DisplayPromptHelp (Var$)
   Print
   Select Case Var$
      Case MorePrompt0 ' "More(y/n/c/q)?"
         Color White
         Print " Y = Yes"
         Print " N = No"
         Print " C = Continuous"
         Print " Q = Quit"
         Color Yellow
      Case MorePrompt1 ' "More(y/n/c)?"
         Color White
         Print " Y = Yes"
         Print " N = No"
         Print " C = Continuous"
         Color Yellow
      Case MorePrompt2 ' "More(y/n)?"
         Color White
         Print " Y = Yes"
         Print " N = No"
         Color Yellow
      Case MorePrompt3 ' "(y/n/q)?"
         Color White
         Print " Y = Yes"
         Print " N = No"
         Print " Q = Quit"
         Color Yellow
      Case MorePrompt4 ' "-more-"
         Color White
         Print " <space> = continue"
         Print " <enter> = continue"
         Color Yellow
      Case Else
         Color White
         Print " Y = Yes"
         Print " N = No"
         Color Yellow
   End Select
End Sub

' remove current .sic program from memory
Sub NewProgram
   ' erase/redimension program code array
   Erase Program
   ReDim Program(1 To MaxLines) As String
End Sub

' end of .sic program routine
Sub EndProgram
   Call ResetScreen
   Color Plain, Black
   Locate , , , 8, 8
   If LineFeed Then
      If Pos(0) > 1 Then
         Print
      End If
   End If
   InDEFSEG = False
   ChDir CurrentDirectory
End Sub

' quit the Sic64 program
Sub QuitProgram
   If QuitBoxIgnore = False Then
      BoxText$ = "Press Yes to continue" + Chr$(13) + Chr$(10) + "Or No to continue and disable box" + Chr$(13) + Chr$(10) + "Or Cancel to quit."
      Title$ = " SICK v" + Version + " r" + Release + " (node " + Hex$(Node) + ")"
      x& = _MessageBox(Title$, BoxText$, "yesnocancel", "info")
   End If
   If x& = 0 Then ' cancel
      LineFeed = False
      If SaveOnExit Then
         Call SaveCurrent
      End If
      Call KeyPrompt
      Call EndProgram
      Print "Exiting to system.."
      Call StopProgram
   End If
   If x& = 1 Then Eat$ = Nul ' yes
   If x& = 2 Then QuitBoxIgnore = True ' no
End Sub

' stop Sic64 program/exit to dos
Sub StopProgram
   On Error GoTo ErrorRoutineX
   Close

   ' close timers
   Timer(t1) Off
   Timer(t2) Off
   Timer(t4) Off
   Timer(t6) Off
   Timer(t8) Off
   Color Plain, Black

   ' return to start dir
   ChDir CurrentDirectory
   Call WriteConfig(VarQ)
   Call WriteRecent(VarQ)
   Color Plain, Black
   If ScreenMode = False Then
      Call ClearStatusLine
   End If
   Color Plain, Black
   End
End Sub

' stop Sic64 program/exit to dos
Sub HaltProgram
   On Error GoTo ErrorRoutineX
   Close

   ' close timers
   Timer(t1) Off
   Timer(t2) Off
   Timer(t4) Off
   Timer(t6) Off
   Timer(t8) Off

   ' return to start dir
   ChDir CurrentDirectory
   Call WriteConfig(VarQ)
   Call WriteRecent(VarQ)
   Color Plain, Black
   System
End Sub

' restore after any graphics screen modes
Sub ResetScreen
   If LastScreen1 Or LastScreen2 Or LastScreen3 Or LastScreen4 Then
      Screen 0, 1, 0, 0
      Width 80, 25
   End If
   If LastWidth1 <> 80 Then
      If LastWidth2 <> 25 Then
         Width 80, 25
      End If
   End If
End Sub

' loads a program from disk
Sub ReadProgram
   Var = 0: Var2 = 0
   X = FreeFileNumber
   If _FileExists(Filename) Then
      Open Filename For Input As #FileNumber
      Do While Not EOF(FileNumber)
         Line Input #FileNumber, Out2
         Out2 = Strim$(Out2)
         If Len(Out2) Then
            If Left$(Out2, 1) = "'" Or Left$(Out2, 1) = ";" Then
               Eat$ = Nul
            Else
               For Blanks = 1 To Len(Out2)
                  Imbedded$ = Mid$(Out2, Blanks, 1)
                  If Imbedded$ >= "0" And Imbedded$ <= "9" Then
                     Eat$ = Nul
                  Else
                     LineNumber = Int(Val(Left$(Out2, Blanks)))
                     If LineNumber > False And LineNumber <= MaxLines Then
                        Program$(LineNumber) = Mid$(Out2, Blanks)
                        Var2 = True
                     Else
                        Var = Var + 1
                     End If
                     Exit For
                  End If
               Next
            End If
         End If
      Loop
   End If
   Close #FileNumber
   FileNumber = False
   If Var Then
      Print "Lines ignored:"; Var
   End If
   If Var2 = False Then
      Print "No program loaded."
   End If
End Sub

' renumbers current .sic program
Sub RenumberProgram (StartValue, IncrementValue)
   Dim ASCIIZ As String * 260
   Call AnalyzeProgram(0, VarX, Var$)
   If VarX Then
      Color White
      Print "Program analyze error line:" + Str$(ProgramLine) + ": " + Var$ + "."
      Exit Sub
   End If
   If StartValue = False Or IncrementValue = False Then
      Prompt$ = "Starting line number: "
      Var$ = KeyboardLine4$(Prompt$)
      StartLine = Int(Val(Var$))
      Prompt$ = "Increment value: "
      Var$ = KeyboardLine4$(Prompt$)
      Increment = Int(Val(Var$))
   Else
      StartLine = StartValue
      Increment = IncrementValue
   End If
   StartLine = Int(StartLine)
   If StartLine <= False Then
      Print "Bad start line value."
      Exit Sub
   End If
   If StartLine > MaxLines Then
      Print "Bad start line value."
      Exit Sub
   End If
   Increment = Int(Increment)
   If Increment <= False Then
      Print "Bad increment value."
      Exit Sub
   End If
   If Increment > Int(MaxLines / 2) Then
      Print "Bad increment value."
      Exit Sub
   End If
   Do
      TempFilename$ = TempName$
      Filename = TempFilename$ + ".sc1"
      If _FileExists(Filename) = False Then
         Exit Do
      End If
   Loop
   Call StoreProgram(0)
   Call CountLines(LastLine)
   ReDim RenumberList(1 To MaxLines) As Integer
   NewLineNumber = StartLine
   For LineNumber = 1 To LastLine
      ProgramLine$ = Program$(LineNumber)
      If Strim$(ProgramLine$) <> Nul Then
         If NewLineNumber > MaxLines Then
            Color White, Black
            Print "Renumber list exceeds"; Str$(MaxLines); " lines."
            Erase RenumberList
            Exit Sub
         End If
         RenumberList(NewLineNumber) = LineNumber
         NewLineNumber = NewLineNumber + Increment
      End If
   Next
   Print "Renumbering program.."
   For LineNumber = 1 To LastLine
      NewProgramLine$ = Program$(LineNumber)
      OldProgramLine$ = Program$(LineNumber)
      OldProgramLine$ = Strim$(OldProgramLine$)
      OldProgramLine$ = Ttrim$(OldProgramLine$, True)
      If OldProgramLine$ <> Nul Then
         LineRenumbered = True
         If UCase$(Left$(OldProgramLine$, 7)) = "RESTORE" Then
            V$ = RTrim$(Mid$(OldProgramLine$, 8))
            If Len(V$) Then
               If Int(Val(V$)) > 0 Then
                  LineRenumbered = False
                  Imbedded = InStr(UCase$(NewProgramLine$), "RESTORE") + 7
                  GoSub NextSpace
                  Number$ = Mid$(OldProgramLine$, 8)
                  Number$ = Strim$(Number$)
                  OldLineNumber = Int(Val(Number$))
                  If OldLineNumber > False And OldLineNumber <= MaxLines Then
                     For NewLineNumber = 1 To MaxLines
                        If RenumberList(NewLineNumber) = OldLineNumber Then
                           Program$(LineNumber) = NextProgramLine$ + LTrim$(Str$(NewLineNumber))
                           LineRenumbered = True
                           Exit For
                        End If
                     Next
                  End If
               End If
            End If
         End If
         If UCase$(Left$(OldProgramLine$, 4)) = "GOTO" Then
            LineRenumbered = False
            Imbedded = InStr(UCase$(NewProgramLine$), "GOTO") + 4
            GoSub NextSpace
            Number$ = Mid$(OldProgramLine$, 5)
            Number$ = Strim$(Number$)
            OldLineNumber = Int(Val(Number$))
            If OldLineNumber > False And OldLineNumber <= MaxLines Then
               For NewLineNumber = 1 To MaxLines
                  If RenumberList(NewLineNumber) = OldLineNumber Then
                     Program$(LineNumber) = NextProgramLine$ + LTrim$(Str$(NewLineNumber))
                     LineRenumbered = True
                     Exit For
                  End If
               Next
            End If
         End If
         If UCase$(Left$(OldProgramLine$, 13)) = "ON ERROR GOTO" Then
            LineRenumbered = False
            Imbedded = InStr(UCase$(NewProgramLine$), "GOTO") + 4
            GoSub NextSpace
            Number$ = Mid$(OldProgramLine$, 14)
            Number$ = Strim$(Number$)
            OldLineNumber = Int(Val(Number$))
            If OldLineNumber > False And OldLineNumber <= MaxLines Then
               For NewLineNumber = 1 To MaxLines
                  If RenumberList(NewLineNumber) = OldLineNumber Then
                     Program$(LineNumber) = NextProgramLine$ + LTrim$(Str$(NewLineNumber))
                     LineRenumbered = True
                     Exit For
                  End If
               Next
            End If
         End If
         If UCase$(Left$(OldProgramLine$, 6)) = "RESUME" Then
            If UCase$(Left$(OldProgramLine$, 15)) <> "RESUME PREVIOUS" Then
               If UCase$(Left$(OldProgramLine$, 11)) <> "RESUME SAME" Then
                  If UCase$(Left$(OldProgramLine$, 11)) <> "RESUME NEXT" Then
                     LineRenumbered = False
                     Imbedded = InStr(UCase$(NewProgramLine$), "RESUME") + 6
                     GoSub NextSpace
                     Number$ = Mid$(OldProgramLine$, 7)
                     Number$ = Strim$(Number$)
                     OldLineNumber = Int(Val(Number$))
                     If OldLineNumber > False And OldLineNumber <= MaxLines Then
                        For NewLineNumber = 1 To MaxLines
                           If RenumberList(NewLineNumber) = OldLineNumber Then
                              Program$(LineNumber) = NextProgramLine$ + LTrim$(Str$(NewLineNumber))
                              LineRenumbered = True
                              Exit For
                           End If
                        Next
                     End If
                  End If
               End If
            End If
         End If
         If UCase$(Left$(OldProgramLine$, 5)) = "GOSUB" Then
            LineRenumbered = False
            Imbedded = InStr(UCase$(NewProgramLine$), "GOSUB") + 5
            GoSub NextSpace
            Number$ = Mid$(OldProgramLine$, 6)
            Number$ = Strim$(Number$)
            OldLineNumber = Int(Val(Number$))
            If OldLineNumber > False And OldLineNumber <= MaxLines Then
               For NewLineNumber = 1 To MaxLines
                  If RenumberList(NewLineNumber) = OldLineNumber Then
                     Program$(LineNumber) = NextProgramLine$ + LTrim$(Str$(NewLineNumber))
                     LineRenumbered = True
                     Exit For
                  End If
               Next
            End If
         End If
         If UCase$(Left$(OldProgramLine$, 2)) = "ON" Then
            If UCase$(Left$(OldProgramLine$, 8)) <> "ON ERROR" Then
               LineRenumbered = False
               If InStr(UCase$(OldProgramLine$), "GOTO") Then
                  Imbedded = InStr(UCase$(NewProgramLine$), "GOTO") + 4
                  OldNumber1$ = LTrim$(Mid$(NewProgramLine$, Imbedded))
                  GoSub NextSpace
                  NewProgramLine1$ = NextProgramLine$
                  Imbedded2 = InStr(UCase$(OldProgramLine$), "GOTO")
                  OldNumber2$ = Mid$(OldProgramLine$, Imbedded2 + 4)
                  Do
                     Imbedded1 = InStr(OldNumber1$, ",")
                     If Imbedded1 Then
                        NewNumber1$ = Left$(OldNumber1$, Imbedded1 - 1)
                        OldNumber1$ = Mid$(OldNumber1$, Imbedded1 + 1)
                     Else
                        NewNumber1$ = OldNumber1$
                        OldNumber1$ = Nul
                     End If
                     If InStr(WhiteSpace, Mid$(NewNumber1$, 1, 1)) Then
                        Imbedded = 1
                        NewProgramLine$ = NewNumber1$
                        GoSub NextSpace
                        NewNumber1$ = NextProgramLine$
                     Else
                        NewNumber1$ = Nul
                     End If
                     Imbedded2 = InStr(OldNumber2$, ",")
                     If Imbedded2 Then
                        NewNumber2$ = Left$(OldNumber2$, Imbedded2 - 1)
                        OldNumber2$ = Mid$(OldNumber2$, Imbedded2 + 1)
                     Else
                        NewNumber2$ = OldNumber2$
                        OldNumber2$ = Nul
                     End If
                     LineRenumbered = False
                     OldLineNumber = Int(Val(NewNumber2$))
                     If OldLineNumber > False And OldLineNumber <= MaxLines Then
                        For NewLineNumber = 1 To MaxLines
                           If RenumberList(NewLineNumber) = OldLineNumber Then
                              NewProgramLine1$ = NewProgramLine1$ + NewNumber1$ + LTrim$(Str$(NewLineNumber)) + ","
                              LineRenumbered = True
                              Exit For
                           End If
                        Next
                     End If
                     If OldNumber2$ = Nul Then
                        Exit Do
                     End If
                     If LineRenumbered = False Then
                        Exit Do
                     End If
                  Loop
                  If Right$(NewProgramLine1$, 1) = "," Then
                     NewProgramLine1$ = Left$(NewProgramLine1$, Len(NewProgramLine1$) - 1)
                  End If
                  Program$(LineNumber) = NewProgramLine1$
               Else
                  If InStr(UCase$(OldProgramLine$), "GOSUB") Then
                     Imbedded = InStr(UCase$(NewProgramLine$), "GOSUB") + 5
                     OldNumber1$ = LTrim$(Mid$(NewProgramLine$, Imbedded))
                     GoSub NextSpace
                     NewProgramLine1$ = NextProgramLine$
                     Imbedded2 = InStr(UCase$(OldProgramLine$), "GOSUB")
                     OldNumber2$ = Mid$(OldProgramLine$, Imbedded2 + 5)
                     Do
                        Imbedded1 = InStr(OldNumber1$, ",")
                        If Imbedded1 Then
                           NewNumber1$ = Left$(OldNumber1$, Imbedded1 - 1)
                           OldNumber1$ = Mid$(OldNumber1$, Imbedded1 + 1)
                        Else
                           NewNumber1$ = OldNumber1$
                           OldNumber1$ = Nul
                        End If
                        If InStr(WhiteSpace, Mid$(NewNumber1$, 1, 1)) Then
                           Imbedded = 1
                           NewProgramLine$ = NewNumber1$
                           GoSub NextSpace
                           NewNumber1$ = NextProgramLine$
                        Else
                           NewNumber1$ = Nul
                        End If
                        Imbedded2 = InStr(OldNumber2$, ",")
                        If Imbedded2 Then
                           NewNumber2$ = Left$(OldNumber2$, Imbedded2 - 1)
                           OldNumber2$ = Mid$(OldNumber2$, Imbedded2 + 1)
                        Else
                           NewNumber2$ = OldNumber2$
                           OldNumber2$ = Nul
                        End If
                        LineRenumbered = False
                        OldLineNumber = Int(Val(NewNumber2$))
                        If OldLineNumber > False And OldLineNumber <= MaxLines Then
                           For NewLineNumber = 1 To MaxLines
                              If RenumberList(NewLineNumber) = OldLineNumber Then
                                 NewProgramLine1$ = NewProgramLine1$ + NewNumber1$ + LTrim$(Str$(NewLineNumber)) + ","
                                 LineRenumbered = True
                                 Exit For
                              End If
                           Next
                        End If
                        If OldNumber2$ = Nul Then
                           Exit Do
                        End If
                        If LineRenumbered = False Then
                           Exit Do
                        End If
                     Loop
                     If Right$(NewProgramLine1$, 1) = "," Then
                        NewProgramLine1$ = Left$(NewProgramLine1$, Len(NewProgramLine1$) - 1)
                     End If
                     Program$(LineNumber) = NewProgramLine1$
                  End If
               End If
            End If
         End If
         If LineRenumbered = False Then
            Color White, Black
            Print "Error renumbering program: line"; LineNumber
            Filename = TempFilename$ + ".sc1"
            Call ReadProgram
            Color White, Black
            Print "Program reloaded."

            If Right$(Filename, 4) = ".sc1" Then
               ASCIIZ = Filename + Chr$(0)
               AttrX& = 0&
               z = SetFileAttributes&(ASCIIZ, AttrX&)

               f$ = Filename + Chr$(0)
               x = DeleteFileA(f$)
               If x = 0 Then
                  Print "Error deleting: "; Quote; Filename; Quote
                  x$ = DisplayWinError$(x)
                  Print x$
               Else
                  Print "Filename "; Quote; Filename; Quote; " deleted."
               End If
            End If
            Erase RenumberList
            Exit Sub
         End If
      End If
   Next
   Print "Resequencing line numbers.."
   Filename = TempFilename$ + ".sc1"
   Call StoreProgram(0)
   x = FreeFileNumber
   Open Filename For Input As #FileNumber
   Call NewProgram
   While Not EOF(FileNumber)
      Line Input #FileNumber, NewProgramLine$
      For Blanks = 1 To Len(WhiteSpace)
         Imbedded = InStr(NewProgramLine$, Mid$(WhiteSpace, Blanks, 1))
         If Imbedded Then
            Exit For
         End If
      Next
      OldLineNumber = Int(Val(Left$(NewProgramLine$, Imbedded - 1)))
      For NewProgramLine = 1 To MaxLines
         If RenumberList(NewProgramLine) = OldLineNumber Then
            Program$(NewProgramLine) = Mid$(NewProgramLine$, Imbedded)
            Exit For
         End If
      Next
   Wend
   Close #FileNumber
   FileNumber = False
   Color White, Black
   Print "Program renumbered."

   If Right$(Filename, 4) = ".sc1" Then
      ASCIIZ = Filename + Chr$(0)
      AttrX& = 0&
      z = SetFileAttributes&(ASCIIZ, AttrX&)

      f$ = Filename + Chr$(0)
      x = DeleteFileA(f$)
      If x = 0 Then
         Print "Error deleting: "; Quote; Filename; Quote
         x$ = DisplayWinError$(x)
         Print x$
      Else
         Print "Filename "; Quote; Filename; Quote; " deleted."
      End If
   End If
   Erase RenumberList
   Exit Sub

   ' locates string with following white spaces
   NextSpace:
   NextProgramLine$ = NewProgramLine$
   Do
      If Imbedded >= Len(NextProgramLine$) Then
         Exit Do
      End If
      If InStr(WhiteSpace, Mid$(NextProgramLine$, Imbedded + 1, 1)) Then
         Imbedded = Imbedded + 1
      Else
         Exit Do
      End If
   Loop
   NextProgramLine$ = Left$(NextProgramLine$, Imbedded)
   Return
End Sub

' check maximum program runtime seconds.
Sub Check.Program (Var)
   Program.Time! = Timer - Program.Start!
   If Program.Time! < SFalse Then
      Program.Time! = Program.Time! + 86400!
   End If
   ' break in seconds
   If LineBreakTime > SFalse Then
      If Program.Time! >= LineBreakTime Then
         If Var Then
            If LineFeed Then
               Print
            End If
            Print "Debug - Program runtime exceeded limit of" + Str$(LineBreakTime) + " seconds."
            ControlBreak = -4
         Else
            ControlBreak = -1
         End If
      End If
   End If
End Sub

' starts current .sic program
Sub RunProgram (StartLine)
   BadInput = Nul
   Recurse2 = False
   IncludeRecurse = False
   ControlBreak = False
   WhatisError = False
   ' check to continue halted program.
   If RunType Then
      Color Plain, Black
      GoTo RunProg
   End If

   ErrorCount = False
   ErrorType2 = True

   ' close any files
   Close
   _ControlChr Off

   ' restore run variables
   DebugActive = True
   DataLine = 1
   DataNumber = False
   ErrorLine = False
   ErrorType = False
   ErrorValue = False
   NestedGosub = False
   MaxGosubs = 10
   ScreenMode = False
   ScreenHeight = 25
   ScreenWidth = 80
   Visible = 1
   Color Plain, Black

   ' clear runtime arrays
   ReDim GosubReturn(1 To 10) As Integer
   For Count1 = 1 To 1024
      Variables(Count1) = Dfalse
      Strngs$(Count1) = Nul
      V = UBound(Arrays, 2)
      For Count2 = 1 To V
         Arrays(Count1, Count2) = Dfalse
      Next
   Next
   V = UBound(Definitions, 1)
   For Count1 = 1 To V
      Definitions$(Count1) = Nul
   Next
   ReDim ConstStrings(0 To 1) As String
   ReDim ConstValues(0 To 1) As String
   ConstArray = 0&

   ' start program processing loop.
   RunProg:

   ' start program execution.
   Call PrepareProgram

   ' check program validity.
   Call AnalyzeProgram(0, VarX, Var$)
   If VarX Then
      Color White
      Print "Program analyze error line:" + Str$(ProgramLine) + ": " + Var$ + "."
      RunLine = MaxLines + 1
      Close
      GoSub ReadProg
      Exit Sub
   End If

   ' check starting line number
   Call CountLines(LastLine)

   ' check to continue halted program.
   If RunType Then
      ' restore last program line processed.
      ProgramLine = RunLine - 1 ' fixed 11/10/2020
   Else
      ' store first program line.
      ProgramLine = False
      If StartLine Then
         If StartLine > False And StartLine <= LastLine Then
            If Len(Strim$(Program$(StartLine))) Then
               ProgramLine = StartLine - 1
            Else
               GoTo RunError
            End If
         Else
            GoTo RunError
         End If
      End If
   End If

   ' reset segment flag
   If RunType Then
      InDEFSEG = InDEFSEG2
   Else
      InDEFSEG = False
      InDEFSEG2 = False
   End If

   ' reset colors
   If RunType Then
      Color LastColor1, LastColor2
   Else
      LastColor1 = Plain
      LastColor2 = Black
   End If

   ' reset screen width
   If RunType Then
      Width LastWidth1, LastWidth2
   Else
      LastWidth1 = 80
      LastWidth2 = 25
   End If

   ' reset screen mode
   If RunType Then
      Screen LastScreen1, LastScreen2, LastScreen3, LastScreen4
   Else
      LastScreen1 = 0
      LastScreen2 = 1
      LastScreen3 = 0
      LastScreen4 = 0
   End If

   ' reset cursor size
   If RunType Then
      Locate , , LastCursor1, LastCursor2, LastCursor3
   Else
      LastCursor1 = 1
      LastCursor2 = 8
      LastCursor3 = 8
   End If

   ' start program flow
   BreakFlag1 = False
   BreakFlag2 = False
   BreakFlag3 = False
   BreakFlag4 = False
   BreakFlag5 = False
   BreakFlag6 = False
   BreakFlag7 = False

   ' check for break variables
   For VarBreak = 1 To 1024
      If VariableBreak(VarBreak) Then
         ' store first break variable
         BreakFlag3 = VarBreak
         Exit For
      End If
   Next

   ' check for break variables
   For VarBreak = 1 To 1024
      If Len(VariableBreak2(VarBreak)) <> False Then
         ' store first break variable
         BreakFlag5 = VarBreak
         Exit For
      End If
   Next

   ' check for break variables
   For VarBreak = 1 To 1024
      For VarBreak2 = 1 To UBound(VariableBreak3, 2) ' MaxArrays
         If VariableBreak3(VarBreak, VarBreak2) Then
            ' store first break variable
            BreakFlag7 = VarBreak
            Exit For
         End If
      Next
      If BreakFlag7 Then
         Exit For
      End If
   Next

   ' start program loop
   ProgramRunning = True
   Program.Start! = Timer
   StartTime# = Timer
   Do
      ' check program runtime
      Call Check.Program(-1)

      ' check control-nreak
      If ControlBreak Then
         If Pos(0) > 1 Then
            Print
         End If
         Color BreakColor, Black
         Select Case ControlBreak
            Case -1 ' standard break message
               Print BreakMessage
            Case -2 ' file number break message
               Print FileBreakMessage + " (file" + Str$(FileNum) + ")"
            Case -3 ' record number break message
               Print RecordBreakMessage + " (file" + Str$(FileNum) + ") (record" + Str$(RecordNumber) + ")"
         End Select
         If MakeBeep Then
            Sound Freq, Duration
         End If
         Color White, Black
         Exit Do
      End If

      ' increment program flow
      ProgramLine = ProgramLine + 1
      If ProgramLine > LastLine Then
         ProgramLine = MaxLines + 1
      End If
      If ProgramLine > MaxLines Then
         Exit Do
      End If

      ' test line list/line break
      If DebugActive Then
         If Len(Program$(ProgramLine)) <> False Then
            ' display debug list line
            If ListLines Then
               If Pos(0) > 1 Then
                  Print
               End If
               Print "Debug line:" + Str$(ProgramLine) + "."
            End If
            ' test break lines
            If LineBreak(ProgramLine) Then
               BreakFlag1 = True
               Exit Do
            End If
         End If
      End If

      ' process the program line
      Out2 = Strim$(Program$(ProgramLine))
      If Len(Out2) Then

         ' clear recurse flag
         Recurse = 0

         ' enter the parser
         Call EnterEquate

         ' test break variables
         If DebugActive Then
            If BreakFlag3 Then
               GoSub TestBreak1
               If BreakFlag2 Then
                  Exit Do
               End If
            End If
            If BreakFlag5 Then
               GoSub TestBreak2
               If BreakFlag4 Then
                  Exit Do
               End If
            End If
            If BreakFlag7 Then
               GoSub TestBreak3
               If BreakFlag6 Then
                  Exit Do
               End If
            End If
         End If
      End If
   Loop

   ' store last program line processed.
   RunLine = ProgramLine
   ProgramRunning = 0

   ' store segment flag.
   InDEFSEG2 = InDEFSEG

   ' end program parsing
   Call EndProgram

   ' stop processing program
   ProgramLine = MaxLines

   ' display program runtime
   If Timing Then
      RunTime# = Timer - StartTime#
      If RunTime# < Dfalse Then RunTime# = RunTime# + 86400#
      Print "Time elapsed:"; RunTime#
   End If

   ' display any break messages
   If BreakFlag1 Then
      Color BreakColor2, Black
      Print BreakMessage2
      If MakeBeep Then
         Sound Freq, Duration
      End If
      Color Yellow, Black
      Print "Line:" + Str$(RunLine) + "."
   End If
   If BreakFlag2 Then
      Color BreakColor3, Black
      Print BreakMessage3
      If MakeBeep Then
         Sound Freq, Duration
      End If
      Color Yellow, Black
      Print "Line:" + Str$(RunLine) + "."
      Print "Variable: " + GetVariable2$(VarBreak)
      Print "Test: " + Symbol$ + Str$(VariableValue(VarBreak))
      Print "Value:" + Str$(Variables(VarBreak))
   End If
   If BreakFlag4 Then
      Color BreakColor3, Black
      Print BreakMessage3
      If MakeBeep Then
         Sound Freq, Duration
      End If
      Color Yellow, Black
      Print "Line:" + Str$(RunLine) + "."
      Print "Variable: " + GetVariable2$(VarBreak) + "$"
      If Len(VariableValue2$(VarBreak)) > 40 Then
         Print "Test: " + Symbol$ + " " + Quote + Left$(VariableValue2$(VarBreak), 40) + "..."
      Else
         Print "Test: " + Symbol$ + " " + Quote + VariableValue2$(VarBreak) + Quote
      End If
      If Len(Strngs$(VarBreak)) > 40 Then
         Print "Value: " + Quote + Left$(Strngs$(VarBreak), 40) + "..."
      Else
         Print "Value: " + Quote + Strngs$(VarBreak) + Quote
      End If
   End If
   If BreakFlag6 Then
      Color BreakColor3, Black
      Print BreakMessage3
      If MakeBeep Then
         Sound Freq, Duration
      End If
      Color Yellow, Black
      Print "Line:" + Str$(RunLine) + "."
      Print "Variable: " + GetVariable2$(VarBreak) + "(" + Mid$(Str$(VarBreak2), 2) + ")"
      Print "Test: " + Symbol$ + Str$(VariableValue3(VarBreak, VarBreak2))
      Print "Value:" + Str$(Arrays(VarBreak, VarBreak2))
   End If
   If BreakFlag1 Or BreakFlag2 Or BreakFlag4 Or BreakFlag6 Then
      GoSub ReadProg
      Exit Sub
   End If
   Close
   GoSub ReadProg
   Exit Sub

   ' exit with error
   RunError:
   Close
   GoSub ReadProg
   Error 145
   Exit Sub

   ' read original program
   ReadProg:
   Call RestoreProgram
   Return

   TestBreak1:
   ' start with first break to test variable
   For VarBreak = BreakFlag3 To 1024
      If VariableBreak(VarBreak) Then
         Select Case VariableBreak(VarBreak)
            Case -1
               If Variables(VarBreak) = VariableValue(VarBreak) Then
                  BreakFlag2 = True
                  Symbol$ = "="
                  Return
               End If
            Case 1
               If Variables(VarBreak) <> VariableValue(VarBreak) Then
                  BreakFlag2 = True
                  Symbol$ = "<>"
                  Return
               End If
            Case 2
               If Variables(VarBreak) > VariableValue(VarBreak) Then
                  BreakFlag2 = True
                  Symbol$ = ">"
                  Return
               End If
            Case 3
               If Variables(VarBreak) >= VariableValue(VarBreak) Then
                  BreakFlag2 = True
                  Symbol$ = ">="
                  Return
               End If
            Case 4
               If Variables(VarBreak) < VariableValue(VarBreak) Then
                  BreakFlag2 = True
                  Symbol$ = "<"
                  Return
               End If
            Case 5
               If Variables(VarBreak) <= VariableValue(VarBreak) Then
                  BreakFlag2 = True
                  Symbol$ = "<="
                  Return
               End If
         End Select
      End If
   Next
   Return

   TestBreak2:
   ' start with first break to test string variable
   For VarBreak = BreakFlag5 To 1024
      If VariableBreak2(VarBreak) Then
         Select Case VariableBreak2(VarBreak)
            Case -1
               If Strngs$(VarBreak) = VariableValue2$(VarBreak) Then
                  BreakFlag4 = True
                  Symbol$ = "="
                  Return
               End If
            Case 1
               If Strngs$(VarBreak) <> VariableValue2$(VarBreak) Then
                  BreakFlag4 = True
                  Symbol$ = "<>"
                  Return
               End If
            Case 2
               If Strngs$(VarBreak) > VariableValue2$(VarBreak) Then
                  BreakFlag4 = True
                  Symbol$ = ">"
                  Return
               End If
            Case 3
               If Strngs$(VarBreak) >= VariableValue2$(VarBreak) Then
                  BreakFlag4 = True
                  Symbol$ = ">="
                  Return
               End If
            Case 4
               If Strngs$(VarBreak) < VariableValue2$(VarBreak) Then
                  BreakFlag4 = True
                  Symbol$ = "<"
                  Return
               End If
            Case 5
               If Strngs$(VarBreak) <= VariableValue2$(VarBreak) Then
                  BreakFlag4 = True
                  Symbol$ = "<="
                  Return
               End If
         End Select
      End If
   Next
   Return

   TestBreak3:
   ' start with first break to test array variable
   For VarBreak = BreakFlag7 To 1024
      For VarBreak2 = 1 To UBound(Arrays, 2) ' MaxArrays
         If VariableBreak3(VarBreak, VarBreak2) Then
            Select Case VariableBreak3(VarBreak, VarBreak2)
               Case -1
                  If Arrays(VarBreak, VarBreak2) = VariableValue3(VarBreak, VarBreak2) Then
                     BreakFlag6 = True
                     Symbol$ = "="
                     Return
                  End If
               Case 1
                  If Arrays(VarBreak, VarBreak2) <> VariableValue3(VarBreak, VarBreak2) Then
                     BreakFlag6 = True
                     Symbol$ = "<>"
                     Return
                  End If
               Case 2
                  If Arrays(VarBreak, VarBreak2) > VariableValue3(VarBreak, VarBreak2) Then
                     BreakFlag6 = True
                     Symbol$ = ">"
                     Return
                  End If
               Case 3
                  If Arrays(VarBreak, VarBreak2) >= VariableValue3(VarBreak, VarBreak2) Then
                     BreakFlag6 = True
                     Symbol$ = ">="
                     Return
                  End If
               Case 4
                  If Arrays(VarBreak, VarBreak2) < VariableValue3(VarBreak, VarBreak2) Then
                     BreakFlag6 = True
                     Symbol$ = "<"
                     Return
                  End If
               Case 5
                  If Arrays(VarBreak, VarBreak2) <= VariableValue3(VarBreak, VarBreak2) Then
                     BreakFlag6 = True
                     Symbol$ = "<="
                     Return
                  End If
            End Select
         End If
      Next
   Next
   Return
End Sub

' reads original program after program halt or error
Sub RestoreProgram
   Call NewProgram
   Filename = PrepareFilename
   Call ReadProgram
End Sub

' prompts to store current .sic program
Sub SaveCurrent
   If ProgramName <> None Then
      Call MorePrompt("Save current program(y/n)?", "yn", OutputChar$)
      If OutputChar$ = "y" Then
         Call SaveProgram(Nul)
      End If
   End If
End Sub

' stores current .sic program
Sub SaveProgram (Var$)
   Do
      If Var$ <> Nul Then
         ProgramFile$ = Var$
      End If
      If Var$ = Nul Then
         Do
            Prompt$ = "Program name to save"
            If ProgramName <> Untitled Then
               Prompt$ = Prompt$ + "(" + ProgramName + ")"
            End If
            Prompt$ = Prompt$ + "? "
            ProgramFile$ = KeyboardLine3$(Prompt$)
            If ProgramFile$ <> Nul Then
               Exit Do
            End If
            If ProgramFile$ = Nul Then
               If ProgramName <> Untitled Then
                  ProgramFile$ = ProgramName
                  Exit Do
               End If
               Call MorePrompt("Abort save(y/n)?", "yn", OutputChar$)
               If OutputChar$ = "y" Then
                  Exit Sub
               End If
            End If
         Loop
      End If
      If Right$(ProgramFile$, 1) = Quote Then
         If Left$(ProgramFile$, 1) = Quote Then
            ProgramFile$ = Left$(ProgramFile$, Len(ProgramFile$) - 1)
            ProgramFile$ = Mid$(ProgramFile$, 2)
         End If
      End If
      Call Concatenate(ProgramFile$)
      Filename = ProgramFile$
      If Var$ = Nul Then
         Color Cyan, Black
         Print "Save program as " + Quote + Filename + Quote;
         Call MorePrompt(MorePrompt3, "ynq", OutputChar$)
      Else
         OutputChar$ = "y"
      End If
      Select Case OutputChar$
         Case "y"
            If Var$ = Nul Then
               OutputChar$ = "y"
               If _FileExists(Filename) Then
                  Color Red, Black
                  Print "Program already exists. ";
                  Call MorePrompt("Overwrite(y/n)?", "yn", OutputChar$)
               End If
            Else
               OutputChar$ = "y"
            End If
            If OutputChar$ = "y" Then
               ErrorValue = False
               Call StoreProgram(-1)
               If ErrorValue = False Then
                  ProgramName = ProgramFile$
                  Color White, Black
                  Print "Program " + Quote + Filename + Quote + " saved to disk."
               End If

               Var$ = ProgramFile$
               If InStr(Var$, ":") = 0 And InStr(Var$, "\") = 0 Then
                  Temp1$ = StartDir$ + ProgramFile$
               Else
                  Temp1$ = ProgramFile$
               End If
               StoredProgramName = Temp1$
               Call AddRecent
               Exit Do
            End If
         Case "q"
            Color White, Black
            Print "Program not saved to disk."
            Exit Do
      End Select
   Loop
End Sub

' sets statusline color
Sub SetStatusColor (Param$)
   If Param$ <> Nul Then
      If Param$ = "?" Then
         Print "Help - display colors."
         Print " StatusFore = value"
         Print " StatusBack = value"
         Exit Sub
      End If
      If UCase$(Param$) = "HELP" Then
         Color White
         Print "Statusline parameters:"
         Print " StatusFore = <n>"
         Print " StatusBack = <n>"
         Color Yellow
         Print "Press a key:";
         x$ = Inkey2$
         Print
         Color White
         Print "Color values in <n>:"
         Print "  foreground/background"
         Print "  0  Black"
         Print "  1  Blue"
         Print "  2  Green"
         Print "  3  Cyan"
         Print "  4  Red"
         Print "  5  Magenta"
         Print "  6  Brown"
         Print "  7  White"
         Print "  foreground intensity"
         Print "  8  Gray"
         Print "  9  Light blue"
         Print " 10  Light green"
         Print " 11  Light cyan"
         Print " 12  Light red"
         Print " 13  Light magenta"
         Print " 14  Yellow"
         Print " 15  High-intensity white"
         Color Yellow
         Print "Press a key:";
         x$ = Inkey2$
         Print
         Color White
         Exit Sub
      End If
      V = InStr(Param$, "=")
      If V Then
         X1$ = Left$(Param$, InStr(Param$, "=") - 1)
         X2$ = Mid$(Param$, InStr(Param$, "=") + 1)
         X1$ = LTrim$(RTrim$(X1$))
         X2$ = LTrim$(RTrim$(X2$))
         If UCase$(X1$) = "STATUSFORE" Or UCase$(X1$) = "STATUSFOREGROUND" Then
            If Int(Val(X2$)) >= 1 And Int(Val(X2$)) <= 15 Then
               StatusForeground = Int(Val(X2$))
            Else
               Print "Unknown color."
            End If
         Else
            If UCase$(X1$) = "STATUSBACK" Or UCase$(X1$) = "STATUSBACKGROUND" Then
               If Int(Val(X2$)) >= 0 And Int(Val(X2$)) <= 7 Then
                  StatusBackground = Int(Val(X2$))
               Else
                  Print "Unknown color."
               End If
            Else
               Print "Unknown command."
            End If
         End If
      Else
         Print "Missing parameter."
      End If
   Else
      Print "Missing parameter."
   End If
End Sub

' alarm menu function
Sub AlarmMenuFunc
   Do
      Color White
      Print "Menulist for alarms.."
      Color Yellow
      Print "(1)Set"
      Print "  sets seconds per alarm for" + Str$(MaxAlarms) + " alarms."
      Print "(2)Beep"
      Print "  toggles alarm beeps."
      Print "(3)Clear"
      Print "  clears all alarms."
      Print "(4)List"
      Print "  lists settings for all alarms set."
      Print "(5)Count"
      Print "  displays number of alarms set."
      Print "(6)Type"
      Print "  toggles alarm time display."
      Print "(7)Color"
      Print "  sets alarms colors."
      Print "(8)Music"
      Print "  toggles alarm music play."
      Print "(9)Help"
      Print "  lists alarm functions."
      Color White
      Print "Enter option(1-9,Q to quit";
      X$ = Nul
      Do
         _Limit LimitValue
         X$ = InKey$
         If X$ <> Nul Then
            If LCase$(X$) = "q" Then Print "q": Exit Sub
            If X$ >= "1" And X$ <= "9" Then Print X$: Exit Do
         End If
      Loop
      Select Case X$
         Case "1"
            Call AlarmMenu("SET")
         Case "2"
            Call AlarmMenu("BEEP")
         Case "3"
            Call AlarmMenu("CLEAR")
         Case "4"
            Call AlarmMenu("LIST")
         Case "5"
            Call AlarmMenu("COUNT")
         Case "6"
            Call AlarmMenu("TYPE")
         Case "7"
            Call AlarmMenu("COLOR")
         Case "8"
            Call AlarmMenu("MUSIC")
         Case "9"
            Call AlarmMenu("HELP")
      End Select
   Loop
End Sub

' alarm menu
Sub AlarmMenu (Var$)
   Select Case UCase$(Var$)
      Case "HELP"
         VarZ = True
         Color White
         Print "Helplist for alarms.."
         Color Yellow
         Print "MENU"
         Print "  starts the menu for alarm functions."
         Print "SET"
         Print "  sets seconds per alarm for" + Str$(MaxAlarms) + " alarms."
         Print "BEEP"
         Print "  toggles alarm beeps."
         Print "CLEAR"
         Print "  clears all alarms."
         Print "LIST"
         Print "  lists settings for all alarms set."
         Print "COUNT"
         Print "  displays number of alarms set."
         Print "TYPE"
         Print "  toggles alarm time display."
         Print "COLOR"
         Print "  sets alarms colors."
         Print "MUSIC"
         Print "  toggles alarm music play."
         Color White
         Call KeyPrompt
      Case "CLEAR"
         For VarZZ = 1 To MaxAlarms
            AlarmFlags(VarZZ) = False
            AlarmStart(VarZZ) = SFalse
            AlarmTime(VarZZ) = SFalse
            AlarmColor(VarZZ) = False
         Next
         Print "All alarms cleared."
      Case "COUNT"
         VarZ = True
         Temp5 = False
         For VarZZ = 1 To MaxAlarms
            If AlarmFlags(VarZZ) Then
               Temp5 = Temp5 + 1
            End If
         Next
         If Temp5 = False Then
            Print "No alarms are set."
         Else
            Print "There are" + Str$(Temp5) + " alarms set."
         End If
      Case "LIST"
         Temp5 = False: TempC = False
         VarZ = True
         VarZ1 = False
         For VarZZ = 1 To MaxAlarms
            If AlarmFlags(VarZZ) Then
               VarZ1 = True
               Var2$ = "Alarm" + Str$(VarZZ) + " set to" + Str$(AlarmTime(VarZZ)) + " seconds."
               Elapsed! = Timer - AlarmStart(VarZZ)
               If Elapsed! < SFalse Then Elapsed! = Elapsed! + 86400!
               Remaining! = AlarmTime(VarZZ) - Elapsed!
               Var3$ = LTrim$(Str$(Remaining!))
               If InStr(Var3$, ".") Then
                  Var3$ = Left$(Var3$, InStr(Var3$, ".") - 1)
               End If
               Var2$ = Var2$ + " (" + Var3$ + " seconds remaining)"
               If AlarmType(VarZZ) = False Then
                  Var2$ = Var2$ + " [time display on]"
               Else
                  Var2$ = Var2$ + " [time display off]"
               End If
               If AlarmBeep(VarZZ) >= False Then
                  If AlarmBeep(VarZZ) = False Then
                     Var2$ = Var2$ + " {beep on}"
                  Else
                     Var2$ = Var2$ + " {" + LTrim$(Str$(AlarmBeep(VarZZ))) + " beeps on}"
                  End If
               Else
                  Var2$ = Var2$ + " {beep off}"
               End If
               Print Var2$
               Temp5 = Temp5 + 1
            End If
         Next
         If Temp5 Then
            Call KeyPrompt
         Else
            Print "No alarms set."
         End If
      Case "BEEP"
         Prompt$ = "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? "
         Var$ = KeyboardLine4$(Prompt$)
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            If AlarmFlags(VarZZ) Then
               Prompt$ = "Enter number of beeps(on/off/<n>)? "
               Var$ = KeyboardLine4$(Prompt$)
               VarZZ2 = Int(Val(Var$))
               Select Case UCase$(Var$)
                  Case "ON"
                     AlarmBeep(VarZZ) = 0
                     Print "Alarm beep on."
                  Case "OFF"
                     AlarmBeep(VarZZ) = True
                     Print "Alarm beep off."
                  Case Else
                     If VarZZ2 >= 1 Then
                        AlarmBeep(VarZZ) = VarZZ2
                        If VarZZ2 = 1 Then
                           Print "Alarm set to" + Str$(VarZZ2) + " beep."
                        Else
                           Print "Alarm set to" + Str$(VarZZ2) + " beeps."
                        End If
                     Else
                        Print "Alarm not set."
                     End If
               End Select
            Else
               Print "Alarm not set."
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "MUSIC"
         Prompt$ = "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? "
         Var$ = KeyboardLine4$(Prompt$)
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            If AlarmFlags(VarZZ) Then
               AlarmMusic(VarZZ) = Not AlarmMusic(VarZZ)
               If AlarmMusic(VarZZ) = False Then
                  Print "Alarm music off."
               Else
                  Print "Alarm music on."
               End If
            Else
               Print "Alarm not set."
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "TYPE"
         Prompt$ = "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? "
         Var$ = KeyboardLine4$(Prompt$)
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            If AlarmFlags(VarZZ) Then
               AlarmType(VarZZ) = Not AlarmType(VarZZ)
               If AlarmType(VarZZ) = False Then
                  Print "Alarm time display on."
               Else
                  Print "Alarm time display off."
               End If
            Else
               Print "Alarm not set."
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "SET"
         Prompt$ = "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? "
         Var$ = KeyboardLine4$(Prompt$)
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            Prompt$ = "Enter alarm time(seconds)? "
            Var2$ = KeyboardLine4$(Prompt$)
            VarZZ2! = Int(Val(Var2$))
            If VarZZ2! = SFalse Then
               AlarmFlags(VarZZ) = False
               Print "Alarm" + Str$(VarZZ) + " cleared."
            Else
               If VarZZ2! > SFalse And VarZZ2! <= 86400! Then
                  AlarmFlags(VarZZ) = True
                  AlarmStart(VarZZ) = Timer
                  AlarmTime(VarZZ) = VarZZ2!
                  AlarmType(VarZZ) = False
                  AlarmBeep(VarZZ) = False
                  AlarmColor(VarZZ) = False
                  AlarmMusic(VarZZ) = False

                  Prompt$ = "Enter number of beeps(on/off/<n>)? "
                  Var$ = KeyboardLine4$(Prompt$)
                  VarZZ2 = Int(Val(Var$))
                  Select Case UCase$(Var$)
                     Case "ON"
                        AlarmBeep(VarZZ) = 0
                        Print "Alarm beep on."
                     Case "OFF"
                        AlarmBeep(VarZZ) = True
                        Print "Alarm beep off."
                     Case Else
                        If VarZZ2 >= 1 Then
                           AlarmBeep(VarZZ) = VarZZ2
                           If VarZZ2 = 1 Then
                              Print "Alarm set to" + Str$(VarZZ2) + " beep."
                           Else
                              Print "Alarm set to" + Str$(VarZZ2) + " beeps."
                           End If
                        Else
                           Print "Alarm not set."
                        End If
                  End Select
                  Print "Alarm" + Str$(VarZZ) + " set."
               Else
                  Print "Illegal alarm time."
               End If
            End If
         Else
            Print "Unknown alarm."
         End If
      Case "COLOR"
         StartColor:
         Prompt$ = "Enter alarm(1-" + LTrim$(Str$(MaxAlarms)) + ")? "
         Var$ = KeyboardLine4$(Prompt$)
         VarZZ = Int(Val(Var$))
         If VarZZ >= 1 And VarZZ <= MaxAlarms Then
            Prompt$ = "Enter alarm color(?=Help, 1-7)? "
            Var2$ = KeyboardLine4$(Prompt$)
            VarZZ2 = Int(Val(Var2$))
            If Var2$ = "?" Then
               Print "Foreground intensity:"
               Print "  1  Light blue"
               Print "  2  Light green"
               Print "  3  Light cyan"
               Print "  4  Light red"
               Print "  5  Light magenta"
               Print "  6  Yellow"
               Print "  7  White"
               Color Yellow
               Print "Press a key:";
               x$ = Inkey2$
               Print
               GoTo StartColor
            End If
            If VarZZ2 = False Then
               AlarmColor(VarZZ) = False
               Print "Alarm" + Str$(VarZZ) + " color cleared."
            Else
               If VarZZ2 >= 1 And VarZZ2 <= 7 Then
                  AlarmColor(VarZZ) = VarZZ2 + 8
                  Print "Alarm" + Str$(VarZZ) + " color set."
               Else
                  Print "Illegal alarm color."
               End If
            End If
         Else
            Print "Unknown alarm."
         End If
      Case Else
         Print "Unknown alarm function. Try ALARMS MENU instead."
   End Select
End Sub

' alarm timer trap
Sub CheckAlarms
   ' check alarms
   For VarZZ = 1 To MaxAlarms
      If AlarmTime(VarZZ) = SFalse Then
         AlarmFlags(VarZZ) = False
      End If
   Next
   For VarZZ = 1 To MaxAlarms
      VarZ5 = AlarmFlags(VarZZ)
      VarZ2! = AlarmStart(VarZZ)
      VarZ3! = AlarmTime(VarZZ)
      If VarZ5 Then
         If VarZ2! > SFalse And VarZ3! > SFalse Then
            ElapsedTime! = Timer - VarZ2!
            If ElapsedTime! < SFalse Then
               ElapsedTime! = ElapsedTime! + 86400!
            End If
            If ElapsedTime! >= VarZ3! Then
               TimeElapsed = True
            Else
               TimeElapsed = False
            End If
            If TimeElapsed Then
               VarZ = True
               AlarmFlags(VarZZ) = False
               If AlarmBeep(VarZZ) = False Then ' single beep
                  If MakeBeep Then
                     Sound Freq, Duration
                     _Delay AlarmDelay
                  End If
               End If
               If AlarmBeep(VarZZ) > False Then ' multiple beeps
                  If MakeBeep Then
                     For VarZZ2 = 1 To AlarmBeep(VarZZ)
                        Sound Freq, Duration
                        _Delay AlarmDelay
                     Next
                  End If
               End If
               If AlarmMusic(VarZZ) Then
                  VarZ$ = Melody$
                  Play VarZ$
               End If
               Print
               If AlarmColor(VarZZ) Then
                  Color AlarmColor(VarZZ)
               Else
                  Color White
               End If
               If AlarmType(VarZZ) = False Then
                  Print "Alarm" + Str$(VarZZ) + " notice! It is now " + Date$ + " " + Time$
               Else
                  Print "Alarm" + Str$(VarZZ) + " notice!"
               End If
               Color Yellow
               If Temp0 = False Then
                  Print PromptStore$;
               Else
                  Call DisplayPrompt(PromptStore$)
               End If
               Color White, Black
            End If
         End If
      End If
   Next
End Sub

' backs up out the current .sic program to directory
Sub BackupProgram (X2) ' autosave
   If PrepareFilename = Nul Then
      If X2 Then
         Print "Prepare: No file found."
      End If
      Exit Sub
   End If
   If ProgramName = None Then
      If X2 Then
         Print "Program name: No file found."
      End If
      Exit Sub
   End If
   If ProgramName = Untitled Then
      If X2 Then
         Print "Program title: No file found."
      End If
      Exit Sub
   End If

   If X2 Then
      Print "Copy from: "; PrepareFilename
   End If
   VarQ$ = DRX2 + GetFileName$(ProgramName) + ".backup." + Date$ + "." + LTrim$(Str$(Timer)) + ".bkp"
   If X2 Then
      Print "Copy to: "; VarQ$
   End If
   If _FileExists(PrepareFilename) = False Then
      Exit Sub
   End If
   f$ = PrepareFilename + Chr$(0)
   g$ = VarQ$ + Chr$(0)
   x = CopyFile(f$, g$, 0) ' 0=overwrite, -1=don't

   If X2 Then
      If x = 0 Then
         Print "Error 0x" + Hex$(GetLastError) + " copying filename."
         VarQ$ = DisplayWinError$(x)
         If Len(VarQ$) Then
            Print VarQ$
         End If
      Else
         Print "Filename copied."
      End If
   End If
End Sub

' backs up out the current .sic program to directory
Sub BackupProgramTimer ' autosave
   If ProgramName = None Then
      Exit Sub
   End If
   If ProgramName = Untitled Then
      Exit Sub
   End If
   If PrepareFilename = Nul Then
      Exit Sub
   End If
   If _FileExists(PrepareFilename) = False Then
      Exit Sub
   End If
   VarQ$ = DRX2 + GetFileName$(ProgramName) + ".backup." + Date$ + "." + LTrim$(Str$(Timer)) + ".bkp"

   ' use windows to copy file
   f$ = PrepareFilename + Chr$(0)
   g$ = VarQ$ + Chr$(0)
   x = CopyFile(f$, g$, 0) ' 0=overwrite, -1=don't

   ' check error return
   If x = 0 Then
      Exit Sub
   End If

   Rem increment counter and display alert
   AutoSaveCounter = AutoSaveCounter + 1!
   If AutoSaveAlert Then
      Print
      Color AutoSaveAlertColor
      Print AutosaveAlertMessage + " autosave at " + Time$
      If MakeBeep Then
         Sound Freq, Duration
      End If
      Color Yellow
      If Temp0 = 0 Then
         Print PromptStore$;
      Else
         Call DisplayPrompt(PromptStore$)
      End If
      Color White, Black
   End If
End Sub

' writes out the current .sic program to file
Sub StoreProgram (VarZ)
   Dim ASCIIZ As String * 260
   Dim Attr As _Unsigned Long

   ' change filename attribute
   ASCIIZ = Filename + Chr$(0)
   Attr = 0&
   z = SetFileAttributes&(ASCIIZ, Attr)

   ' open and store program
   Bytes# = Dfalse
   FileNumber = FreeFile
   Open Filename For Output As #FileNumber
   Call CountLines(LastLine)
   For LineNumber = 1 To LastLine
      ProgramLine$ = Program$(LineNumber)
      If Strim$(ProgramLine$) <> Nul Then
         If InStr(WhiteSpace, Left$(ProgramLine$, 1)) Then
            VarX$ = Mid$(Str$(LineNumber), 2) + ProgramLine$
            Print #FileNumber, VarX$
         Else
            VarX$ = Mid$(Str$(LineNumber), 2) + " " + ProgramLine$
            Print #FileNumber, VarX$
         End If
         Bytes# = Bytes# + Len(VarX$) + 2#
      End If
   Next
   Close #FileNumber
   If VarZ Then
      Print "Total " + FormatString$(Bytes#); " bytes written to "; Filename
   End If
End Sub

' parse metacommand
Sub DebugCommand2 (VarX)
   If VarX Then Exit Sub
   Out2 = Mid$(Out2, 9) ' $Llines:
   Out2 = LTrim$(RTrim$(UCase$(Out2)))
   Select Case Out2
      Case "ON"
         ListLines = True
         Exit Sub
      Case "OFF"
         ListLines = False
         Exit Sub
   End Select
   Error 178
End Sub

' immediate debugging prompt.
Sub DebugCommand (VarX, VarX20)
   Static RecurseX As Integer
   If VarX20 = False Then
      Out2 = Mid$(Out2, 8) ' $Debug:
      Out2 = LTrim$(RTrim$(UCase$(Out2)))
      Select Case Out2
         Case "ON"
            DebugActive = True
            Exit Sub
         Case "OFF"
            DebugActive = False
            Exit Sub
      End Select
      TempIn$ = Out2
      GoSub StartDebug1
      Exit Sub
   End If
   ControlBreak = False
   If VarX = False Then RecurseX = False
   If VarX = True Then
      RecurseX = RecurseX + 1
      Print "Debug recurse" + Str$(RecurseX) + " level."
   End If
   Color White, Black
   Print "Type 'Quit' to exit Debug mode."
   Print "Or type ? for brief command list."
   Do
      Visible = 1
      Color Yellow, Black
      Locate , 1, 1
      Temp0 = 3
      PromptLine = CsrLin
      Call DisplayPrompt(Prompt3$)
      Color White, Black
      PromptStore = Prompt3$
      Locate , , 1
      Temp0 = 3
      Out2 = KeyboardLine2$(Prompt3)
      Print

      ' parse debug commands
      Var$ = Out2
      Var4$ = Out2
      Out2 = UCase$(Out2)
      Select Case Out2
         Case "QUIT"
            Exit Do
         Case "EXIT"
            Exit Do
         Case "?"
            GoSub DisplayDebugHelp
         Case Else
            If Len(Out2) Then
               TempIn$ = Out2
               GoSub StartDebug1
            End If
      End Select
      If ControlBreak Then
         ControlBreak = False
         Exit Do
      End If
   Loop
   Color White, Black
   Print "Debug mode ended."
   Exit Sub

   DisplayDebugHelp:
   Color Yellow, Black
   Print "Brief list of Debug commands:"
   Print "Command               Shortcut"
   Print "-------------------   ---------"
   Color White, Black
   Print "LISTLINES             LL"
   Print "SETBREAK <l>          SB <l>"
   Print "CLEARBREAK <l>        CB <l>"
   Print "LISTBREAKS            LB"
   Print "CLEARALLBREAKS        CA"
   Print "SETVARIABLE <x>,<n>   SV <x>,<n>[,<sign>]"
   Print "CLEARVARIABLE <x>     CV <x>"
   Print "TOGGLEVARIABLE <x>    TV <x>"
   Print "LISTVARIABLES         LV"
   Print "CLEARALLVARIABLES     AV"
   Print "SETBREAKTIME <x>      ST <x>"
   Print "CLEARBREAKTIME        CT"
   Print "LISTBREAKTIME         LT"
   ' new 04/06/2022
   Print "SETFILE               SF <x>"
   Print "CLEARFILE             CF <x>"
   Print "LISTFILE              LF"
   Print "CLEARALLFILE          AF"
   ' new 03/05/2023
   Print "SETRECORD             SR <x>"
   Print "CLEARRECORD           CR <x>"
   Print "LISTRECORD            LR"
   Print "CLEARALLRECORD        AR"
   Return

   ' loop command line separated by colons.
   StartDebug1:
   Do
      Temp = InStr(TempIn$, ":")
      If Temp Then
         Out2 = Left$(TempIn$, Temp - 1)
         Out2 = LTrim$(RTrim$(Out2))
         TempIn$ = Mid$(TempIn$, Temp + 1)
         If Len(Out2) Then
            GoSub StartDebug2
         End If
      Else
         Out2 = TempIn$
         Out2 = LTrim$(RTrim$(Out2))
         If Len(Out2) Then
            GoSub StartDebug2
         End If
         Exit Do
      End If
   Loop
   Return

   StartDebug2:
   If Out2 = "DEBUG" Then ' DE
      Out2 = "DE"
   End If
   If Out2 = "WHATIS" Then ' WA
      Out2 = "WA"
   End If
   If Out2 = "LISTLINES" Then ' LL
      Out2 = "LL"
   End If
   If Left$(Out2, 13) = "SETBREAKTIME " Then ' ST
      Out2 = "ST" + Mid$(Out2, 14)
   End If
   If Left$(Out2, 9) = "SETBREAK " Then ' SB
      Out2 = "SB" + Mid$(Out2, 10)
   End If
   If Left$(Out2, 11) = "CLEARBREAK " Then ' CB
      Out2 = "CB" + Mid$(Out2, 12)
   End If
   If Out2 = "LISTBREAKS" Then ' LB
      Out2 = "LB"
   End If
   If Out2 = "CLEARALLBREAKS" Then ' CA
      Out2 = "CA"
   End If
   If Left$(Out2, 12) = "SETVARIABLE " Then ' SV
      Out2 = "SV" + Mid$(Out2, 13)
      Var4$ = "SV" + Mid$(Var4$, 13)
   End If
   If Left$(Out2, 14) = "CLEARVARIABLE " Then ' CV
      Out2 = "CV" + Mid$(Out2, 15)
   End If
   If Left$(Out2, 15) = "TOGGLEVARIABLE " Then ' TV
      Out2 = "TV" + Mid$(Out2, 16)
   End If
   If Out2 = "LISTVARIABLES" Then ' LV
      Out2 = "LV"
   End If
   If Out2 = "CLEARALLVARIABLES" Then ' AV
      Out2 = "AV"
   End If
   If Out2 = "LISTBREAKTIME" Then ' LT
      Out2 = "LT"
   End If
   If Out2 = "CLEARBREAKTIME" Then ' CT
      Out2 = "CT"
   End If
   If Out2 = "LISTFILE" Then ' LF
      Out2 = "LF"
   End If
   If Out2 = "LISTRECORD" Then ' LR
      Out2 = "LR"
   End If
   If Out2 = "CLEARALLFILE" Then ' AF
      Out2 = "AF"
   End If
   If Out2 = "CLEARALLRECORD" Then ' AR
      Out2 = "AR"
   End If
   If Left$(Out2, 10) = "CLEARFILE " Then ' CF
      Out2 = "CF" + Mid$(Out2, 11)
   End If
   If Left$(Out2, 12) = "CLEARRECORD " Then ' CR
      Out2 = "CR" + Mid$(Out2, 13)
   End If
   If Left$(Out2, 8) = "SETFILE " Then ' SF
      Out2 = "SF" + Mid$(Out2, 9)
   End If
   If Left$(Out2, 10) = "SETRECORD " Then ' SR
      Out2 = "SR" + Mid$(Out2, 11)
   End If

   ' parse shortcut parameters.
   Select Case Left$(Out2, 2)
      Case "DE", "WA", "LL", "LB", "CA", "LV", "AV", "LT", "CT", "LF", "LR", "AF", "AR"
         If Len(Out2) > 2 Then
            If VarX20 = False Then Error 176
            If VarX20 Then
               Color White, Black
               Print "Unknown command."
            End If
            Return
         End If
   End Select

   ' parse shortcuts.
   Select Case Left$(Out2, 2)
      Case "DE"
         If VarX20 Then
            If Len(Out2) = 2 Then
               Call DebugCommand(-1, -1)
            Else
               If VarX20 = False Then Error 176
               If VarX20 Then
                  Color White, Black
                  Print "Unknown command."
               End If
            End If
         End If
      Case "WA"
         If VarX20 Then
            If Len(Out2) = 2 Then
               Call WhatisCommand("", 0)
            Else
               If VarX20 = False Then Error 176
               If VarX20 Then
                  Color White, Black
                  Print "Unknown command."
               End If
            End If
         End If
      Case "LL"
         If Len(Out2) = 2 Then
            ListLines = Not ListLines
            If VarX20 Then
               If ListLines Then
                  Print "Debug: List lines on."
               Else
                  Print "Debug: List lines off."
               End If
            End If
         Else
            If VarX20 = False Then Error 176
            If VarX20 Then
               Color White, Black
               Print "Unknown command."
            End If
         End If
      Case "LF"
         GoSub ListBreakFile
      Case "LR"
         GoSub ListRecordFile
      Case "CF"
         GoSub ClearFile
      Case "CR"
         GoSub ClearRecord
      Case "AF"
         GoSub ClearAllFile
      Case "AR"
         GoSub ClearAllRecord
      Case "SF"
         GoSub SetFile
      Case "SR"
         GoSub SetRecord
      Case "LT"
         GoSub ListBreakTime
      Case "ST"
         GoSub SetBreakTime
      Case "CT"
         GoSub ClearBreakTime
      Case "SB"
         GoSub SetBreak
      Case "CB"
         GoSub ClearBreak
      Case "LB"
         If Len(Out2) = 2 Then
            GoSub DisplayBreaks
         Else
            If VarX20 = False Then Error 176
            If VarX20 Then
               Color White, Black
               Print "Unknown command."
            End If
         End If
      Case "CA"
         If Len(Out2) = 2 Then
            GoSub ClearAllBreaks
         Else
            If VarX20 = False Then Error 176
            If VarX20 Then
               Color White, Black
               Print "Unknown command."
            End If
         End If
      Case "SV"
         GoSub SetVariable
      Case "CV"
         GoSub ClearVariable
      Case "TV"
         GoSub ToggleVariable
      Case "LV"
         If Len(Out2) = 2 Then
            GoSub DisplayVariables
         Else
            If VarX20 = False Then Error 176
            If VarX20 Then
               Color White, Black
               Print "Unknown command."
            End If
         End If
      Case "AV"
         If Len(Out2) = 2 Then
            GoSub ClearAllVariables
         Else
            If VarX20 = False Then Error 176
            If VarX20 Then
               Color White, Black
               Print "Unknown command."
            End If
         End If
      Case Else
         If VarX20 = False Then Return
         ' parse whatis
         Out2 = Var$
         Color Plain, Black
         Out2 = Ttrim$(Out2, True)
         ' clear recurse flag
         Recurse2 = 0
         Recurse = 0
         ' start the parser
         ErrorLine = 0
         WhatisError = -2
         Temp0 = 0
         Call EnterEquate
         WhatisError = 0
         If LineFeed Then
            Print
         End If
   End Select
   Return

   ListBreakFile:
   If VarX20 = False Then Return
   Var4$ = Nul
   VarX = 0
   If FileTrap0 Then
      Var4$ = " 0,"
      VarX = True
   End If
   For Z = 1 To MaxFiles
      If FileTraps(Z) Then
         Var4$ = Var4$ + Str$(Z) + ","
         VarX = True
      End If
   Next
   If VarX Then
      Var4$ = Left$(Var4$, Len(Var4$) - 1) + "."
      Print "File number breaks:" + Var4$
   Else
      Print "No file breaks found."
   End If
   Return

   ListRecordFile:
   If VarX20 = False Then Return
   Var4$ = Nul
   VarX = 0
   For Z = 1 To RecordCount
      If FileRecords(Z) Then
         Var4$ = Var4$ + Str$(FileRecords(Z)) + ","
         VarX = True
      End If
   Next
   If VarX Then
      Var4$ = Left$(Var4$, Len(Var4$) - 1) + "."
      Print "File number records:" + Var4$
   Else
      Print "No file records found."
   End If
   Return

   ClearFile:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Z = Int(Val(Out2))
   If Z = False Then
      FileTrap0 = False
      If VarX20 Then
         Print "File trap" + Str$(0) + " cleared."
      End If
      Return
   End If
   If Z > False And Z <= MaxFiles Then
      FileTraps(Z) = False
      If VarX20 Then
         Print "File trap" + Str$(Z) + " cleared."
      End If
      Return
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Print "Unknown file."
   End If
   Return

   ClearRecord:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Z& = Int(Val(Out2))
   If Z& > 0& And Z& <= MaxLong Then
      For X = 1 To RecordCount
         If FileRecords(X) = Z& Then
            FileRecords(X) = False
            If VarX20 Then
               Print "File record" + Str$(X) + " cleared."
            End If
            Return
         End If
      Next
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Print "Unknown record."
   End If
   Return

   ClearAllFile:
   For VarZ = 1 To MaxFiles
      FileTraps(VarZ) = False
   Next
   FileTrap0 = False
   If VarX20 Then
      Print "All file traps cleared."
   End If
   Return

   ClearAllRecord:
   For VarZ = 1 To RecordCount
      FileRecords(VarZ) = 0&
   Next
   If VarX20 Then
      Print "All file records cleared."
   End If
   Return

   SetFile:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Z = Int(Val(Out2))
   If Z = False Then
      FileTrap0 = True
      If VarX20 Then
         Print "File trap" + Str$(0) + " set."
      End If
      Return
   End If
   If Z > False And Z <= MaxFiles Then
      FileTraps(Z) = True
      If VarX20 Then
         Print "File trap" + Str$(Z) + " set."
      End If
      Return
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Print "Unknown file."
   End If
   Return

   SetRecord:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Z& = Int(Val(Out2))
   If Z& > 0& And Z& <= MaxLong Then
      If RecordCount < MaxRecords Then
         RecordCount = RecordCount + 1
         FileRecords(RecordCount) = Z&
         If VarX20 Then
            Print "File record" + Str$(Z&) + " set."
         End If
         Return
      End If
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Print "Unknown record."
   End If
   Return

   DisplayVariables:
   If VarX20 = False Then Return
   Continuous = False
   LineCount = False
   Line.Flag = False
   For Var = 1 To 1024
      ' display break variables
      If VariableBreak(Var) Then
         ' check page length
         GoSub CheckTitle
         Color Yellow, Black
         ' multivar assign
         Var$ = GetVariable2$(Var)
         If Len(Var$) = 1 Then
            Print " "; GetVariable2$(Var); "        ";
         Else
            Print " "; GetVariable2$(Var); "       ";
         End If
         BreakSign = VariableBreak(Var)
         GoSub GetSign
         Print Symbol$; "   ";
         Print Str$(VariableValue(Var))
         Line.Flag = True
      End If

      ' check page length
      If LineCount = PageLength - 2 Then
         GoSub CheckPage
         Select Case OutputChar$
            Case "n"
               Return
            Case "c"
               Continuous = True
         End Select
      End If
   Next
   For Var = 1 To 1024
      ' display break variables
      If VariableBreak2(Var) Then
         ' check page length
         GoSub CheckTitle
         Color Yellow, Black
         ' multivar assign
         Var$ = GetVariable2$(Var)
         If Len(Var$) = 1 Then
            Print " "; GetVariable2$(Var); "$       ";
         Else
            Print " "; GetVariable2$(Var); "$      ";
         End If
         BreakSign = VariableBreak2(Var)
         GoSub GetSign
         Print Symbol$; "   ";
         If Len(VariableValue2$(Var)) > 40 Then
            Print Quote + Left$(VariableValue2$(Var), 40) + "..."
         Else
            Print Quote + VariableValue2$(Var) + Quote
         End If
         Line.Flag = True
      End If

      ' check page length
      If LineCount = PageLength - 2 Then
         GoSub CheckPage
         Select Case OutputChar$
            Case "n"
               Return
            Case "c"
               Continuous = True
         End Select
      End If
   Next
   For Var = 1 To 1024
      For Var2 = 1 To UBound(VariableBreak3, 2) ' MaxArrays
         ' display break variables
         If VariableBreak3(Var, Var2) Then
            ' check page length
            GoSub CheckTitle
            Color Yellow, Black
            ' multivar assign
            Var$ = GetVariable2$(Var)
            If Len(Var$) = 1 Then
               Print " "; GetVariable2$(Var); "("; Mid$(Str$(Var2), 2); ") ";
            Else
               Print " "; GetVariable2$(Var); "("; Mid$(Str$(Var2), 2); ")";
            End If
            If Var2 > 9999 Then
               ' nul
            Else
               If Var2 > 999 Then
                  Print " ";
               Else
                  If Var2 > 99 Then
                     Print "  ";
                  Else
                     If Var2 > 9 Then
                        Print "   ";
                     Else
                        Print "    ";
                     End If
                  End If
               End If
            End If
            BreakSign = VariableBreak3(Var, Var2)
            GoSub GetSign
            Print Symbol$; "   ";
            Print Str$(VariableValue3(Var, Var2))
            Line.Flag = True
         End If

         ' check page length
         If LineCount = PageLength - 2 Then
            GoSub CheckPage
            Select Case OutputChar$
               Case "n"
                  Return
               Case "c"
                  Continuous = True
            End Select
         End If
      Next
   Next
   If Line.Flag = False Then
      Color White, Black
      Print "No variable breaks set."
   End If
   Return

   DisplayBreaks:
   If VarX20 = False Then Return
   Continuous = False
   LineCount = False
   Line.Flag = False
   For Var = 1 To MaxLines
      ' display break variables
      If LineBreak(Var) Then
         ' check page length
         LineCount = LineCount + 1
         If Continuous = False Then
            If LineCount = 1 Then
               Color White, Black
               Print "Line Number"
               Print "-----------"
            End If
         End If
         Color Yellow, Black
         Print Str$(Var)
         Line.Flag = True
      End If

      ' check page length
      If LineCount = PageLength - 2 Then
         GoSub CheckPage
         Select Case OutputChar$
            Case "n"
               Return
            Case "c"
               Continuous = True
         End Select
      End If
   Next
   If Line.Flag = False Then
      Color White, Black
      Print "No line breaks set."
   End If
   Return

   CheckPage:
   LineCount = False
   If Continuous = False Then
      Call MorePrompt(MorePrompt1, "ync" + CR, OutputChar$)
   End If
   Return

   CheckTitle:
   LineCount = LineCount + 1
   If Continuous = False Then
      If LineCount = 1 Then
         Color White, Black
         Print "Variable  Sign Value"
         Print "--------------------"
      End If
   End If
   Return

   GetSign:
   Select Case BreakSign
      Case -1
         Symbol$ = "= "
      Case 1
         Symbol$ = "<>"
      Case 2
         Symbol$ = "> "
      Case 3
         Symbol$ = ">="
      Case 4
         Symbol$ = "< "
      Case 5
         Symbol$ = "<="
   End Select
   Return

   SetBreak:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   BreakLine = Int(Val(Out2))
   If BreakLine >= False And BreakLine <= MaxLines Then
      LineBreak(BreakLine) = True
      If VarX20 Then
         Color White, Black
         Print "Break line" + Str$(BreakLine) + " set."
      End If
      Return
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Color White, Black
      Print "Unknown line."
   End If
   Return

   ClearBreak:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   BreakLine = Int(Val(Out2))
   If BreakLine >= False And BreakLine <= MaxLines Then
      LineBreak(BreakLine) = False
      If VarX20 Then
         Color White, Black
         Print "Break line" + Str$(BreakLine) + " cleared."
      End If
      Return
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Color White, Black
      Print "Unknown line."
   End If
   Return

   ' SETVARIABLE X, 2048 [,<sign>]
   SetVariable:
   BreakSign = True
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Var$ = Out2
   Var$ = LTrim$(Var$)
   VarX = InStr(Var$, ",")
   If VarX Then
      VarX = InStr(VarX + 1, Var$, ",")
      If VarX Then
         VarX$ = Mid$(Var$, VarX + 1)
         VarX$ = LTrim$(RTrim$(VarX$))
         Var2$ = Left$(Var$, VarX - 1)
         Var4$ = Var2$
         GoSub ReturnSign
      End If
   End If
   Var4$ = Mid$(Var4$, 3)
   Var4$ = LTrim$(Var4$)
   Var2$ = Left$(Var$, 1)
   Var2$ = UCase$(Var2$)
   If Var2$ >= "A" And Var2$ <= "Z" Then
      BreakVar = Asc(Var2$) - 64
      Var$ = Mid$(Var$, 2)
      If Left$(Var$, 1) >= "0" And Left$(Var$, 1) <= "9" Then
         BreakVar$ = Var2$ + Left$(Var$, 1)
         ' multivar assign
         BreakVar = GetVariable(BreakVar$)
         Var$ = Mid$(Var$, 2)
         Var4$ = Mid$(Var4$, 3)
         Var4$ = LTrim$(Var4$)
      Else
         Var4$ = Mid$(Var4$, 2)
         Var4$ = LTrim$(Var4$)
      End If
      Var$ = LTrim$(Var$)
      If Left$(Var$, 1) = "(" Then
         Imbedded = InStr(Var$, ")")
         If Imbedded Then
            Var2$ = Left$(Var$, Imbedded - 1)
            Var2$ = Mid$(Var2$, 2)
            BreakVar2 = Int(Val(Var2$))
            V = UBound(VariableBreak3, 2)
            If BreakVar2 > V Then
               ReDim _Preserve VariableBreak3(1024, BreakVar2) As Integer
               ReDim _Preserve VariableValue3(1024, BreakVar2) As Double
            End If
            If BreakVar2 >= 1 And BreakVar2 <= UBound(VariableBreak3, 2) Then
               Var$ = Mid$(Var$, Imbedded + 1)
               Var$ = LTrim$(Var$)
               If Left$(Var$, 1) = "," Then
                  BreakVar3# = Val(Mid$(Var$, 2))
                  VariableBreak3(BreakVar, BreakVar2) = BreakSign
                  VariableValue3(BreakVar, BreakVar2) = BreakVar3#
                  If VarX20 Then
                     Color White, Black
                     Print "Break variable " + GetVariable2$(BreakVar) + "(" + Mid$(Str$(BreakVar2), 2) + ")" + " set to" + Str$(BreakVar3#) + "."
                  End If
                  Return
               End If
            End If
         End If
      Else
         If Left$(Var$, 1) = "$" Then
            Var$ = Mid$(Var$, 2)
            Var$ = LTrim$(Var$)
            Var4$ = Mid$(Var4$, 2)
            Var4$ = LTrim$(Var4$)
            If Left$(Var$, 1) = "," Then
               BreakVar2$ = Mid$(Var4$, 2)
               VariableBreak2(BreakVar) = BreakSign
               VariableValue2$(BreakVar) = BreakVar2$
               If VarX20 Then
                  Color White, Black
                  Print "Break variable " + GetVariable2$(BreakVar) + "$ set to " + Quote + BreakVar2$ + Quote + "."
               End If
               Return
            End If
         Else
            If Left$(Var$, 1) = "," Then
               BreakVar2# = Val(Mid$(Var$, 2))
               VariableBreak(BreakVar) = BreakSign
               VariableValue(BreakVar) = BreakVar2#
               If VarX20 Then
                  Color White, Black
                  Print "Break variable " + GetVariable2$(BreakVar) + " set to" + Str$(BreakVar2#) + "."
               End If
               Return
            End If
         End If
      End If
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Color White, Black
      Print "Unknown variable."
   End If
   Return

   ClearBreakTime:
   LineBreakTime = False
   If VarX20 Then
      Print "Break time cleared."
   End If
   Return

   ListBreakTime:
   If VarX20 = False Then Return
   If LineBreakTime > False Then
      Print "Break time set to" + Str$(LineBreakTime) + " seconds."
      Return
   End If
   Print "Break time not set."
   Return

   SetBreakTime:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   BreakLine = Int(Val(Out2))
   If BreakLine > False Then
      LineBreakTime = BreakLine
      If VarX20 Then
         Print "Break time set."
      End If
      Return
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Print "Unknown time."
   End If
   Return

   ClearVariable:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Var$ = Out2
   Var$ = UCase$(Var$)
   Var$ = RTrim$(Var$)
   Var$ = LTrim$(Var$)
   Var2$ = Left$(Var$, 1)
   If Var2$ >= "A" And Var2$ <= "Z" Then
      BreakVar = Asc(Var2$) - 64
      If Len(Var$) = 1 Then
         VariableBreak(BreakVar) = False
         VariableValue(BreakVar) = Dfalse
         If VarX20 Then
            Color White, Black
            Print "Break variable " + Chr$(BreakVar + 64) + " cleared."
         End If
         Return
      Else
         If Len(Var$) = 2 Then
            Var2$ = Mid$(Var$, 2)
            If Var2$ = "$" Then
               VariableBreak2(BreakVar) = False
               VariableValue2$(BreakVar) = Nul
               If VarX20 Then
                  Color White, Black
                  Print "Break variable " + Chr$(BreakVar + 64) + "$ cleared."
               End If
               Return
            Else
               If Var2$ >= "0" And Var2$ <= "9" Then
                  ' multivar assign
                  BreakVar = GetVariable(Var$)
                  VariableBreak(BreakVar) = False
                  VariableValue(BreakVar) = Dfalse
                  If VarX20 Then
                     Color White, Black
                     Print "Break variable " + Var$ + " cleared."
                  End If
                  Return
               End If
            End If
         Else
            If Len(Var$) >= 3 Then
               If Len(Var$) = 3 Then
                  If Mid$(Var$, 3, 1) = "$" Then
                     Var2$ = Left$(Var$, 2)
                     ' multivar assign
                     BreakVar = GetVariable(Var2$)
                     VariableBreak2(BreakVar) = False
                     VariableValue2$(BreakVar) = Nul
                     If VarX20 Then
                        Color White, Black
                        Print "Break variable " + Var$ + " cleared."
                     End If
                     Return
                  End If
               End If
               Var2$ = Var$
               Var$ = Mid$(Var$, 2)
               If Left$(Var$, 1) >= "0" And Left$(Var$, 1) <= "9" Then
                  Var2$ = Left$(Var2$, 2)
                  ' multivar assign
                  BreakVar = GetVariable(Var2$)
                  Var$ = Mid$(Var$, 2)
               End If
               If Left$(Var$, 1) = "(" Then
                  Imbedded = InStr(Var$, ")")
                  If Imbedded Then
                     Var$ = Left$(Var$, Imbedded - 1)
                     Var$ = Mid$(Var$, 2)
                     BreakVar2 = Val(Var$)
                     If BreakVar2 >= 1 And BreakVar2 <= UBound(VariableBreak3, 2) Then ' MaxArrays
                        VariableBreak3(BreakVar, BreakVar2) = False
                        VariableValue3(BreakVar, BreakVar2) = Dfalse
                        If VarX20 Then
                           Color White, Black
                           Print "Break variable " + GetVariable2$(BreakVar) + "(" + Mid$(Str$(BreakVar2), 2) + ") cleared."
                        End If
                        Return
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Color White, Black
      Print "Unknown variable."
   End If
   Return

   ToggleVariable:
   Out2 = LTrim$(Mid$(Out2, 3))
   If Left$(Out2, 1) = "," Then Out2 = Mid$(Out2, 2)
   Var$ = Out2
   Var$ = UCase$(Var$)
   Var$ = RTrim$(Var$)
   Var$ = LTrim$(Var$)
   Var2$ = Left$(Var$, 1)
   If Var2$ >= "A" And Var2$ <= "Z" Then
      BreakVar = Asc(Var2$) - 64
      If Len(Var$) = 1 Then
         If VariableBreak(BreakVar) Then
            NewBreak = VariableBreak(BreakVar)
            GoSub NextBreak
            VariableBreak(BreakVar) = NewBreak
            If VarX20 Then
               Color White, Black
               Print "Break variable " + Chr$(BreakVar + 64) + " toggled to "; Symbol$; "."
            End If
            Return
         End If
      Else
         If Len(Var$) = 2 Then
            Var2$ = Mid$(Var$, 2)
            If Var2$ = "$" Then
               If VariableBreak2(BreakVar) Then
                  NewBreak = VariableBreak2(BreakVar)
                  GoSub NextBreak
                  VariableBreak2(BreakVar) = NewBreak
                  If VarX20 Then
                     Color White, Black
                     Print "Break variable " + Chr$(BreakVar + 64) + "$ toggled to "; Symbol$; "."
                  End If
                  Return
               End If
            Else
               If Var2$ >= "0" And Var2$ <= "9" Then
                  ' multivar assign
                  BreakVar = GetVariable(Var$)
                  If VariableBreak(BreakVar) Then
                     NewBreak = VariableBreak(BreakVar)
                     GoSub NextBreak
                     VariableBreak(BreakVar) = NewBreak
                     If VarX20 Then
                        Color White, Black
                        Print "Break variable " + Var$ + " toggled to "; Symbol$; "."
                     End If
                     Return
                  End If
               End If
            End If
         Else
            If Len(Var$) >= 3 Then
               If Len(Var$) = 3 Then
                  If Mid$(Var$, 3, 1) = "$" Then
                     Var2$ = Left$(Var$, 2)
                     ' multivar assign
                     BreakVar = GetVariable(Var2$)
                     If VariableBreak(BreakVar) Then
                        NewBreak = VariableBreak(BreakVar)
                        GoSub NextBreak
                        VariableBreak(BreakVar) = NewBreak
                        If VarX20 Then
                           Color White, Black
                           Print "Break variable " + Var$ + " toggled to "; Symbol$; "."
                        End If
                        Return
                     End If
                  End If
               End If
               Var2$ = Var$
               Var$ = Mid$(Var$, 2)
               If Left$(Var$, 1) >= "0" And Left$(Var$, 1) <= "9" Then
                  Var2$ = Left$(Var2$, 2)
                  ' multivar assign
                  BreakVar = GetVariable(Var2$)
                  Var$ = Mid$(Var$, 2)
               End If
               Var$ = Mid$(Var$, 2)
               If Left$(Var$, 1) = "(" Then
                  Imbedded = InStr(Var$, ")")
                  If Imbedded Then
                     Var$ = Left$(Var$, Imbedded - 1)
                     Var$ = Mid$(Var$, 2)
                     BreakVar2 = Val(Var$)
                     If BreakVar2 >= 1 And BreakVar2 <= UBound(VariableBreak3, 2) Then ' MaxArrays
                        If VariableBreak3(BreakVar, BreakVar2) Then
                           NewBreak = VariableBreak3(BreakVar, BreakVar2)
                           GoSub NextBreak
                           VariableBreak3(BreakVar, BreakVar2) = NewBreak
                           If VarX20 Then
                              Color White, Black
                              Print "Break variable " + Chr$(BreakVar + 64) + "(" + Mid$(Str$(BreakVar2), 2) + ") toggled to "; Symbol$; "."
                           End If
                           Return
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   If VarX20 = False Then Error 176
   If VarX20 Then
      Color White, Black
      Print "Unknown variable."
   End If
   Return

   ReturnSign:
   Select Case VarX$
      Case "="
         BreakSign = -1
      Case "<>"
         BreakSign = 1
      Case ">"
         BreakSign = 2
      Case ">="
         BreakSign = 3
      Case "<"
         BreakSign = 4
      Case "<="
         BreakSign = 5
      Case Else
         BreakSign = -1
   End Select
   Return

   NextBreak:
   Select Case NewBreak
      Case -1 ' =
         NewBreak = 1
         Symbol$ = "<>"
      Case 1 ' <>
         NewBreak = 2
         Symbol$ = ">"
      Case 2 ' >
         NewBreak = 3
         Symbol$ = ">="
      Case 3 ' >=
         NewBreak = 4
         Symbol$ = "<"
      Case 4 ' <
         NewBreak = 5
         Symbol$ = "<="
      Case 5 ' <=
         NewBreak = True
         Symbol$ = "="
   End Select
   Return

   ClearAllBreaks:
   For BreakLine = 1 To MaxLines
      LineBreak(BreakLine) = False
   Next
   If VarX20 Then
      Color White, Black
      Print "All line breaks cleared."
   End If
   Return

   ClearAllVariables:
   For BreakVar = 1 To 1024
      VariableBreak(BreakVar) = False
      VariableValue(BreakVar) = Dfalse
      VariableBreak2(BreakVar) = False
      VariableValue2$(BreakVar) = Nul
      For BreakVar2 = 1 To UBound(VariableBreak3, 2) ' MaxArrays
         VariableBreak3(BreakVar, BreakVar2) = False
      Next
      For BreakVar2 = 1 To UBound(VariableValue3, 2) ' MaxArrays
         VariableValue3(BreakVar, BreakVar2) = Dfalse
      Next
   Next
   If VarX20 Then
      Color White, Black
      Print "All variable breaks cleared."
   End If
   Return
End Sub

' immediate parsing prompt.
Sub WhatisCommand (WhatValue$, VarX)
   Static RecurseX As Integer
   If VarX = False Then RecurseX = False
   If VarX = True Then
      RecurseX = RecurseX + 1
      Print "Whatis recurse" + Str$(RecurseX) + " level."
   End If
   ErrorType = False
   ErrorValue = False
   If Len(WhatValue$) Then
      ProgramLine = False
      Out2 = Ttrim$(WhatValue$, True)
      ' clear recurse flag
      Recurse2 = 0
      Recurse = 0
      ' start the parser
      Call EnterEquate
      If LineFeed Then
         Print
      End If
      Call EndProgram
      Color White, Black
      Print "Whatis mode ended."
      Exit Sub
   End If
   Color White, Black
   Print "Type 'Quit' to exit Whatis mode."
   StartWhatis:
   Do
      ' check control-nreak
      If ControlBreak Then
         Color BreakColor, Black
         If ControlBreak = -3 Then
            Print RecordBreakMessage + " (file" + Str$(FileNum) + ") (record" + Str$(RecordNumber) + ")"
         Else
            If ControlBreak = -2 Then
               Print FileBreakMessage + " (file" + Str$(FileNum) + ")"
            Else
               Print BreakMessage
            End If
         End If
         If MakeBeep Then
            Sound Freq, Duration
         End If
         Color White, Black
         ControlBreak = 0
         Exit Do
      End If
      ProgramLine = False
      Visible = 1
      Color Yellow, Black
      Locate , 1, 1
      Temp0 = 2
      PromptLine = CsrLin
      Call DisplayPrompt(Prompt2$)
      Color White, Black
      PromptStore = Prompt2$
      Locate , , 1
      Temp0 = 2
      Out2 = RTrim$(KeyboardLine2$(Prompt2))
      Print
      If UCase$(Out2) = "QUIT" Then
         Exit Do
      End If
      If UCase$(Out2) = "EXIT" Then
         Exit Do
      End If
      If UCase$(Out2) = "DEBUG" Then
         Call DebugCommand(0, -1)
         GoTo StartWhatis
      End If
      If UCase$(Out2) = "WHATIS" Then
         Call WhatisCommand("", -1)
         GoTo StartWhatis
      End If
      If Out2 <> Nul Then
         Color Plain, Black
         Out2 = Ttrim$(Out2, True)
         Call TrimComment

         ' clear recurse flag
         Recurse2 = 0
         Recurse = 0
         WhatisError = 0
         ' start the parser
         WhatisError = -2
         Call EnterEquate
         WhatisError = 0
         If LineFeed Then
            Print
         End If
      End If
   Loop
   Call EndProgram
   Color White, Black
   Print "Whatis mode ended."
End Sub

' prepares program for analyze/run command
Sub PrepareProgram
   ' write out current program
   Do
      TempFilename$ = TempName$
      Filename = DRX + TempFilename$ + ".sc2"
      If _FileExists(Filename) = False Then
         Exit Do
      End If
   Loop
   PrepareFilename = Filename
   Call StoreProgram(0)

   ' remove remark at end of line,
   '   search for end of matching double quotes
   '   which might contain an apostrophe.
   Call CountLines(LastLine)
   For ProgramLine = 1 To LastLine
      Out2 = Strim$(Program$(ProgramLine))
      If Len(Out2) Then
         StartChar = 1
         Do
            QuoteStart = False
            For Temp = StartChar To Len(Out2)
               If Mid$(Out2, Temp, 1) = Quote Then
                  QuoteStart = Temp
                  Exit For
               End If
            Next
            If QuoteStart = False Then
               Exit Do
            End If
            QuoteStop = False
            For Temp2 = QuoteStart + 1 To Len(Out2)
               If Mid$(Out2, Temp2, 1) = Quote Then
                  QuoteStop = Temp2
                  Exit For
               End If
            Next
            If QuoteStop = False Then
               Exit Do
            End If
            StartChar = QuoteStop + 1
         Loop
         For Temp = StartChar To Len(Out2)
            If Mid$(Out2, Temp, 1) = "'" Then
               Out2 = Left$(Out2, Temp - 1)
               Exit For
            End If
         Next
         Out2 = Strim$(Out2)
         If Len(Out2) Then
            Program$(ProgramLine) = Out2
         Else
            Program$(ProgramLine) = Remark$
         End If
      End If
   Next

   ' concatenate line continuation statements,
   ' remove continued lines.
   ProgramLine = False
   Call CountLines(LastLine)
   Do
      ProgramLine = ProgramLine + 1
      If ProgramLine > LastLine Then
         Exit Do
      End If
      If ProgramLine > MaxLines Then
         Exit Do
      End If
      FirstLine = ProgramLine
      Out2 = Strim$(Program$(ProgramLine))
      If Len(Out2) Then
         Do
            If Right$(Out2, 1) = UnderScore Then
               Out2 = Left$(Out2, Len(Out2) - 1)
               For NextLine = ProgramLine + 1 To LastLine
                  Out3 = Strim$(Program$(NextLine))
                  If Len(Out3) Then
                     Out2 = Out2 + Out3
                     ProgramLine = NextLine
                     Program$(NextLine) = Remark$
                     Exit For
                  End If
               Next
            Else
               Exit Do
            End If
            Out2 = Strim$(Out2)
         Loop
         Program$(FirstLine) = Out2
      End If
   Loop

   ' compress program array,
   ' replaces all white spaces with single space,
   ' replaces all double spaces with single space.
   ProgramLine = False
   Call CountLines(LastLine)
   For ProgramLine = 1 To LastLine
      Out2 = Strim$(Program$(ProgramLine))
      If Len(Out2) Then
         Program$(ProgramLine) = Ttrim$(Out2, True)
      Else
         Program$(ProgramLine) = Nul
      End If
   Next
End Sub

' replaces white spaces with spaces,
' var = true; skip spaces in quotes
Function Ttrim$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Quote Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Quote Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(WhiteSpace)
         If Mid$(VarX$, Temp, 1) = Mid$(WhiteSpace, Blanks, 1) Then
            Mid$(VarX$, Temp, 1) = " "
         End If
      Next
   Loop
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Quote Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Quote Then
                  Exit Do
               End If
            Loop
         End If
      End If
      If Mid$(VarX$, Temp, 2) = "  " Then
         VarX$ = Left$(VarX$, Temp) + Mid$(VarX$, Temp + 2)
         Temp = Temp - 1
      End If
   Loop
   Ttrim$ = VarX$
End Function

' strips leading/trailing white spaces from string
Function Strim$ (Var$)
   VarX$ = Var$
   Do
      Blanks = False
      For Count = 1 To Len(WhiteSpace)
         If Left$(VarX$, 1) = Mid$(WhiteSpace, Count, 1) Then
            VarX$ = Mid$(VarX$, 2)
            Blanks = True
         End If
      Next
      If Blanks = False Then
         Exit Do
      End If
   Loop
   Do
      Blanks = False
      For Count = 1 To Len(WhiteSpace)
         If Right$(VarX$, 1) = Mid$(WhiteSpace, Count, 1) Then
            VarX$ = Left$(VarX$, Len(VarX$) - 1)
            Blanks = True
         End If
      Next
      If Blanks = False Then
         Exit Do
      End If
   Loop
   Strim$ = VarX$
End Function

' replaces white spaces with nul,
' var = true; skip spaces in quotes
Function Xtrim$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Quote Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Quote Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(WhiteSpace)
         If Mid$(VarX$, Temp, 1) = Mid$(WhiteSpace, Blanks, 1) Then
            VarX$ = Left$(VarX$, Temp - 1) + Mid$(VarX$, Temp + 1)
            Temp = Temp - 1
            Exit For
         End If
      Next
   Loop
   Xtrim$ = VarX$
End Function

' returns a randomized temporary filename.
'    could be generated from date/time.
Function TempName$
   Var$ = Nul
   For Temp = 1 To 8
      Var$ = Var$ + Hex$(Int(Rnd * 16)) ' 0-9,A-F
   Next
   TempName$ = Var$
End Function

Function TempName2$
   Var$ = Nul
   For Temp = 1 To 8
      Var$ = Var$ + Hex$(Int(Rnd * 9)) ' 0-9
   Next
   TempName2$ = Var$
End Function

' returns -1 if shiftkey pressed.
Function GetShiftState
   ' get shift state.
   Def Seg = &H40
   ShiftFlag = Peek(&H17)
   Def Seg

   ' store shift state.
   LeftShift = ShiftFlag And 1 ' left shift.
   RightShift = ShiftFlag And 2 ' right shift.
   CtrlShift = ShiftFlag And 4 ' either ctrl.
   AltShift = ShiftFlag And 8 ' either alt.

   ' return shiftkey pressed.
   If LeftShift Or RightShift Or CtrlShift Or AltShift Then
      GetShiftState = True
   Else
      GetShiftState = False
   End If
End Function

' reset shiftkey state.
Function SetShiftState
   Def Seg = &H40
   Poke &H17, 0
   Def Seg
   SetShiftState = True
End Function

' custom inkey$ function with shiftkey.
Function Inkey2$
   Do
      _Limit LimitValue
      If Len(InKey$) Then
         Exit Do
      End If
      If GetShiftState Then
         x = SetShiftState
         Exit Do
      End If
   Loop
   Inkey2$ = Nul
End Function

' specialized keyboard scan function
'  uses keymap function call.
Function INKEYq$
   _Limit LimitValue
   X = _KeyHit
   If X Then
      If X < 0 Then
         Select Case X
            Case -12 ' keypad-5
               X$ = Chr$(0) + Chr$(76)
               INKEYq$ = KeymapChar$(X$)
               KeyPressed = True
            Case -108 ' ctrl-keypad-5
               X$ = Chr$(0) + Chr$(143)
               INKEYq$ = KeymapChar$(X$)
               KeyPressed = True
         End Select
      Else
         X$ = InKey$
         If Len(X$) Then
            INKEYq$ = KeymapChar$(X$)
            KeyPressed = True
         End If
      End If
   End If
End Function

' simple custom inkey
Function InKeyx$
   _Limit LimitValue
   X$ = InKey$
   If Len(X$) Then
      InKeyx$ = X$
      KeyPressed = True
   End If
End Function

' custom Inkey$ function.
Function INKEYz$
   X = _KeyHit
   If X < 0 Then
      Select Case X
         Case -12 ' keypad-5
            INKEYz$ = Chr$(0) + Chr$(76)
            KeyPressed = -1
            Exit Function
         Case -108 ' ctrl-keypad-5
            INKEYz$ = Chr$(0) + Chr$(143)
            KeyPressed = -1
            Exit Function
      End Select
   End If
   X$ = InKey$
   If Len(X$) Then
      INKEYz$ = X$
      KeyPressed = -1
   End If
End Function

' uses direct keyboard input to get an input line
'   and edit multi-dimensional command history arrays with line-wrapping,
'     where Temp0 (history array type) equals:
'       0=none
'       1=command prompt
'       2=whatis prompt
'       3=debug prompt
'       4=search prompt
'       5=setprompt prompt
'       6=filename history
'
'  when KeyboardTimer=0 then linelength is 80.
'   otherwise linelength is 256.
Function KeyboardLine2$ (Prompt$)
   ControlBreak = 0
   Color White
   Var$ = Nul
   TimeNow! = Timer
   StoreLength = 0
   Do
      ' calculate time elapsed
      ElapsedTime! = Timer - TimeNow!
      ' adjust for midnight
      If ElapsedTime! < SFalse Then
         ElapsedTime! = ElapsedTime! + 86400!
      End If
      ' compare time elapsed
      If ElapsedTime! > 1! Then
         TimeNow! = Timer
         If KeyboardTimer = False Then
            Color Yellow, Black
            Locate , 1, 1
            If Temp0 = 0 Then
               Print Prompt$;
               StoreLength = Len(Prompt$)
            Else
               Call DisplayPrompt(Prompt$)
               StoreLength = Length
            End If
            Color White, Black
            LengthX = ScreenWidth - StoreLength - 1
            Var$ = Left$(Var$, LengthX)
            Print Var$;
         End If
      End If
      If ControlBreak Then
         GoSub EraseLine
         Print
         Color BreakColor, Black
         Print BreakMessage
         If MakeBeep Then
            Sound Freq, Duration
         End If
         ControlBreak = 0
         Color Yellow, Black
         Locate , 1, 1
         If Temp0 = 0 Then
            Print Prompt$;
            StoreLength = Len(Prompt$)
         Else
            Call DisplayPrompt(Prompt$)
            StoreLength = Length
         End If
         Color White, Black
         Locate , , 1
      End If
      ' get character with keymapping
      Var2$ = INKEYq$
      If Len(Var2$) Then
         Select Case Len(Var2$)
            Case 1
               Select Case Var2$
                  Case Chr$(3) ' ctrl-c
                     Eat$ = Nul
                  Case TabS ' tab
                     If KeyboardTimer = False Then
                        If Len(Var$) + TabStop < ScreenWidth - StoreLength - 1 Then
                           For VarX = 1 To TabStop
                              Print " ";
                              Locate , , Visible
                              Var$ = Var$ + " "
                           Next
                        End If
                     Else
                        If Len(Var$) + TabStop < 256 Then
                           For VarX = 1 To TabStop
                              Print " ";
                              Locate , , Visible
                              Var$ = Var$ + " "
                           Next
                        End If
                     End If
                  Case Chr$(13) ' return
                     If Temp0 > 0 Then
                        GoSub EnterHistory
                     End If
                     Exit Do
                  Case Chr$(8) ' backspace
                     If Len(Var$) > 0 Then
                        Var$ = Left$(Var$, Len(Var$) - 1)
                        GoSub BackSpace
                     End If
                  Case Chr$(27) ' escape
                     GoSub EraseLine
                  Case Else ' store input
                     If KeyboardTimer = False Then
                        If Len(Var$) < ScreenWidth - StoreLength - 1 Then
                           Print Var2$;
                           Locate , , Visible
                           Var$ = Var$ + Var2$
                        End If
                     Else
                        If Len(Var$) < 256 Then
                           Print Var2$;
                           Locate , , Visible
                           Var$ = Var$ + Var2$
                        End If
                     End If
               End Select
            Case 2
               Select Case Asc(Right$(Var2$, 1))
                  Case 73 ' pageup
                     If t3! + 10! < 86400! Then
                        t3! = t3! + 10!
                        Timer(t2) Off
                        On Timer(t2, t3!) StatusLine
                        Timer(t2) On
                     Else
                        t3! = 86400!
                        Timer(t2) Off
                        On Timer(t2, t3!) StatusLine
                        Timer(t2) On
                     End If
                  Case 81 ' pagedown
                     If t3! - 10! > 1! Then
                        t3! = t3! - 10!
                        Timer(t2) Off
                        On Timer(t2, t3!) StatusLine
                        Timer(t2) On
                     Else
                        t3! = 1!
                        Timer(t2) Off
                        On Timer(t2, t3!) StatusLine
                        Timer(t2) On
                     End If
                  Case 72 ' up
                     If t3! < 86400! Then
                        t3! = t3! + 1!
                        Timer(t2) Off
                        On Timer(t2, t3!) StatusLine
                        Timer(t2) On
                     End If
                  Case 80 ' down
                     If t3! > 1! Then
                        t3! = t3! - 1!
                        Timer(t2) Off
                        On Timer(t2, t3!) StatusLine
                        Timer(t2) On
                     End If
                  Case 132 ' ctrl-pgup
                     If t7! + 10! < 86400! Then
                        t7! = t7! + 10!
                        Timer(t6) Off
                        On Timer(t6, t7!) CPUtrap
                        Timer(t6) On
                     Else
                        t7! = 86400!
                        Timer(t6) Off
                        On Timer(t6, t7!) CPUtrap
                        Timer(t6) On
                     End If
                  Case 118 ' ctrl-pgdown
                     If t7! - 10! > 1! Then
                        t7! = t7! - 10!
                        Timer(t6) Off
                        On Timer(t6, t7!) CPUtrap
                        Timer(t6) On
                     Else
                        t7! = 1!
                        Timer(t6) Off
                        On Timer(t6, t7!) CPUtrap
                        Timer(t6) On
                     End If
                  Case 141 ' ctrl-up
                     If t7! < 86400! Then
                        t7! = t7! + 1!
                        Timer(t6) Off
                        On Timer(t6, t7!) CPUtrap
                        Timer(t6) On
                     End If
                  Case 145 ' ctrl-down
                     If t7! > 1! Then
                        t7! = t7! - 1!
                        Timer(t6) Off
                        On Timer(t6, t7!) CPUtrap
                        Timer(t6) On
                     End If
                  Case 147 ' ctrl-del
                     CPUtraptype = Not CPUtraptype
                  Case 82 ' insert
                     Timer(t2) Off
                     Ascii$ = Nul
                     GoSub DisplayAsciiLine
                     Do
                        Var3$ = InKeyx$
                        If ControlBreak Then
                           Ascii$ = Nul
                           ControlBreak = False
                           Exit Do
                        End If
                        If Var3$ = Chr$(13) Then ' return
                           Exit Do
                        End If
                        If Var3$ = Chr$(27) Then ' escape
                           Var3$ = Nul
                           If Len(Ascii$) Then
                              Ascii$ = Nul
                              GoSub DisplayAsciiLine
                           End If
                        End If
                        If Var3$ = Chr$(8) Then ' backspace
                           Var3$ = Nul
                           If Len(Ascii$) Then
                              Ascii$ = Left$(Ascii$, Len(Ascii$) - 1)
                              GoSub DisplayAsciiLine
                           End If
                        End If
                        If LCase$(Var3$) = "x" Or LCase$(Var3$) = "o" Or LCase$(Var3$) = "b" Then
                           If Len(Ascii$) = False Then
                              Ascii$ = Ascii$ + LCase$(Var3$)
                              GoSub DisplayAsciiLine
                           End If
                        End If
                        If LCase$(Var3$) >= "a" And LCase$(Var3$) <= "f" Then
                           If Len(Ascii$) >= 1 And Len(Ascii$) < 3 Then
                              If Left$(Ascii$, 1) = "x" Then
                                 Ascii$ = Ascii$ + Var3$
                                 GoSub DisplayAsciiLine
                              End If
                           End If
                        End If
                        If Left$(Ascii$, 1) = "o" Then
                           If Var3$ >= "0" And Var3$ <= "7" Then
                              If Len(Ascii$) < 4 Then
                                 Ascii$ = Ascii$ + Var3$
                                 GoSub DisplayAsciiLine
                              End If
                           End If
                        Else
                           If Left$(Ascii$, 1) = "b" Then
                              If Var3$ = "0" Or Var3$ = "1" Then
                                 If Len(Ascii$) < 9 Then
                                    Ascii$ = Ascii$ + Var3$
                                    GoSub DisplayAsciiLine
                                 End If
                              End If
                           Else
                              If Var3$ >= "0" And Var3$ <= "9" Then
                                 If Len(Ascii$) < 3 Then
                                    Ascii$ = Ascii$ + Var3$
                                    GoSub DisplayAsciiLine
                                 End If
                              End If
                           End If
                        End If
                     Loop
                     Timer(t2) On

                     ' insert ascii character
                     If Left$(Ascii$, 1) = "x" Then ' hexidecimal
                        AsciiValue = Int(Val("&H" + Mid$(Ascii$, 2)))
                     Else
                        If Left$(Ascii$, 1) = "o" Then ' octal
                           AsciiValue = Int(Val("&O" + Mid$(Ascii$, 2)))
                        Else
                           If Left$(Ascii$, 1) = "b" Then ' binary
                              AsciiValue = Int(Val("&B" + Mid$(Ascii$, 2)))
                           Else
                              AsciiValue = Int(Val(Ascii$))
                           End If
                        End If
                     End If
                     If AsciiValue >= 0 And AsciiValue <= 255 Then
                        If AsciiValue = 10 Or AsciiValue = 13 Then
                           Eat$ = Nul
                        Else
                           If KeyboardTimer = False Then
                              If Len(Var$) < ScreenWidth - StoreLength - 1 Then
                                 Var$ = Var$ + Chr$(AsciiValue)
                              End If
                           Else
                              If Len(Var$) < 256 Then
                                 Var$ = Var$ + Chr$(AsciiValue)
                              End If
                           End If
                        End If
                     End If
                     Locate PromptLine, 1, 1
                     Color Yellow, Black
                     If Temp0 = 0 Then
                        Print PromptStore$;
                     Else
                        Call DisplayPrompt(PromptStore$)
                     End If
                     Color White, Black
                     If KeyboardTimer = False Then
                        LengthX = ScreenWidth - StoreLength - 1
                        Print Left$(Var$, LengthX);
                     Else
                        Print Var$;
                     End If
                  Case 83 ' delete
                     Select Case StatusType
                        Case 0
                           StatusType = -1
                        Case -1
                           StatusType = -2
                        Case -2
                           StatusType = -3
                        Case -3
                           StatusType = 0
                     End Select
                  Case 77 ' right
                     If Temp0 > 0 Then
                        GoSub GetCount
                        ' return blank line at end of history
                        If Var1 > 0 Then
                           If Var1 = HistoryCount2(Temp0) Then
                              EndOfHistoryFlag(Temp0) = True
                              GoSub EraseLine
                              Var$ = Nul
                              Var1 = False
                           End If
                        End If
                        ' move to next history
                        If Var1 > 0 Then
                           Select Case HistoryCount2(Temp0)
                              Case 0
                                 GoSub EraseLine
                                 HistoryCount2(Temp0) = Var1
                                 Var$ = RTrim$(History2(Temp0, Var1))
                                 If KeyboardTimer = False Then
                                    LengthX = ScreenWidth - StoreLength - 1
                                    Print Left$(Var$, LengthX);
                                 Else
                                    Print Var$;
                                 End If
                              Case 1 To MaxHistory - 1
                                 If HistoryCount2(Temp0) + 1 <= Var1 Then
                                    GoSub EraseLine
                                    HistoryCount2(Temp0) = HistoryCount2(Temp0) + 1
                                    Var$ = RTrim$(History2(Temp0, HistoryCount2(Temp0)))
                                    If KeyboardTimer = False Then
                                       LengthX = ScreenWidth - StoreLength - 1
                                       Print Left$(Var$, LengthX);
                                    Else
                                       Print Var$;
                                    End If
                                 Else
                                    If HistoryCount2(Temp0) = Var1 Then
                                       GoSub EraseLine
                                       Var$ = RTrim$(History2(Temp0, Var1))
                                       If KeyboardTimer = False Then
                                          LengthX = ScreenWidth - StoreLength - 1
                                          Print Left$(Var$, LengthX);
                                       Else
                                          Print Var$;
                                       End If
                                    End If
                                 End If
                              Case MaxHistory
                                 GoSub EraseLine
                                 Var$ = RTrim$(History2(Temp0, MaxHistory))
                                 If KeyboardTimer = False Then
                                    LengthX = ScreenWidth - StoreLength - 1
                                    Print Left$(Var$, LengthX);
                                 Else
                                    Print Var$;
                                 End If
                           End Select
                        End If
                     End If
                  Case 75 ' left
                     If Temp0 > 0 Then
                        GoSub GetCount
                        If Var1 > 0 Then
                           If EndOfHistoryFlag(Temp0) Then
                              EndOfHistoryFlag(Temp0) = 0
                              GoSub EraseLine
                              HistoryCount2(Temp0) = Var1
                              Var$ = RTrim$(History2(Temp0, Var1))
                              If KeyboardTimer = False Then
                                 LengthX = ScreenWidth - StoreLength - 1
                                 Print Left$(Var$, LengthX);
                              Else
                                 Print Var$;
                              End If
                              Var1 = 0
                           End If
                        End If
                        If Var1 > 0 Then
                           Select Case HistoryCount2(Temp0)
                              Case 0
                                 GoSub EraseLine
                                 HistoryCount2(Temp0) = Var1
                                 Var$ = RTrim$(History2(Temp0, Var1))
                                 If KeyboardTimer = False Then
                                    LengthX = ScreenWidth - StoreLength - 1
                                    Print Left$(Var$, LengthX);
                                 Else
                                    Print Var$;
                                 End If
                              Case 1
                                 GoSub EraseLine
                                 Var$ = RTrim$(History2(Temp0, 1))
                                 If KeyboardTimer = False Then
                                    LengthX = ScreenWidth - StoreLength - 1
                                    Print Left$(Var$, LengthX);
                                 Else
                                    Print Var$;
                                 End If
                              Case Else
                                 If HistoryCount2(Temp0) - 1 > 0 Then
                                    GoSub EraseLine
                                    HistoryCount2(Temp0) = HistoryCount2(Temp0) - 1
                                    Var$ = RTrim$(History2(Temp0, HistoryCount2(Temp0)))
                                    If KeyboardTimer = False Then
                                       LengthX = ScreenWidth - StoreLength - 1
                                       Print Left$(Var$, LengthX);
                                    Else
                                       Print Var$;
                                    End If
                                 End If
                           End Select
                        End If
                     End If
                  Case 71 ' home
                     If Temp0 > 0 Then
                        GoSub GetCount
                        If Var1 > 0 Then
                           GoSub EraseLine
                           HistoryCount2(Temp0) = 1
                           Var$ = RTrim$(History2(Temp0, 1))
                           If KeyboardTimer = False Then
                              LengthX = ScreenWidth - StoreLength - 1
                              Print Left$(Var$, LengthX);
                           Else
                              Print Var$;
                           End If
                        End If
                     End If
                  Case 79 ' end
                     If Temp0 > 0 Then
                        GoSub GetCount
                        If Var1 > 0 Then
                           GoSub EraseLine
                           HistoryCount2(Temp0) = Var1
                           Var$ = RTrim$(History2(Temp0, Var1))
                           If KeyboardTimer = False Then
                              LengthX = ScreenWidth - StoreLength - 1
                              Print Left$(Var$, LengthX);
                           Else
                              Print Var$;
                           End If
                        End If
                     End If
               End Select
         End Select
      End If
   Loop

   ' return input line
   KeyboardLine2$ = Var$
   Exit Function

   EnterHistory:
   If Temp0 = 0 Then
      Return
   End If
   If Len(Var$) Then
      GoSub GetCount
      ' init
      EndOfHistoryFlag(Temp0) = True
      If Var1 = False Then
         HistoryCount2(Temp0) = 1
         History2(Temp0, 1) = Var$
      Else
         ' add history
         If Var1 < MaxHistory Then
            HistoryCount2(Temp0) = Var1 + 1
            History2(Temp0, Var1 + 1) = Var$
         Else
            ' pack history
            For Var = 1 To MaxHistory - 1
               History2(Temp0, Var) = History2(Temp0, Var + 1)
            Next
            HistoryCount2(Temp0) = MaxHistory
            History2(Temp0, MaxHistory) = Var$
         End If
      End If
   End If
   Return

   DisplayAsciiLine:
   Color White, BBlue
   Locate 25, 1, 1
   If Left$(Ascii$, 1) = "x" Then
      Var2$ = "Enter 2-digit ascii code: " + Ascii$
   Else
      If Left$(Ascii$, 1) = "o" Then
         Var2$ = "Enter 3-digit ascii code: " + Ascii$
      Else
         If Left$(Ascii$, 1) = "b" Then
            Var2$ = "Enter 8-digit ascii code: " + Ascii$
         Else
            Var2$ = "Enter 3-digit ascii code: " + Ascii$
         End If
      End If
   End If
   VarC = Len(Var2$) + 1
   Var2$ = Var2$ + Space$(80 - Len(Var2$))
   Print Var2$;
   Locate 25, VarC, 1
   Return

   EraseLine:
   For VarX = 1 To Len(Var$)
      GoSub BackSpace
   Next
   Var$ = Nul
   Return

   BackSpace:
   If Pos(0) > 1 Then ' check cursor location
      Locate CsrLin, Pos(0) - 1, 0
      Print " ";
      Locate CsrLin, Pos(0) - 1, Visible
   Else ' line-wrap
      Locate CsrLin - 1, ScreenWidth, 0
      Print " ";
      Locate CsrLin - 1, ScreenWidth, Visible
   End If
   Return

   GetCount:
   Var1 = 0
   For Var2 = MaxHistory To 1 Step -1
      If RTrim$(History2(Temp0, Var2)) <> Nul Then
         Var1 = Var2
         Exit For
      End If
   Next
   Return
End Function

' special keyboard input function
Function KeyboardLine3$ (Prompt$)
   Visible = 1
   Color Yellow, Black
   Locate , 1, 1
   PromptLine = CsrLin
   Print Prompt$;
   PromptStore = Prompt$
   Locate , , 1
   Temp0 = 6 ' filename history
   KeyboardLine3$ = KeyboardLine2$(Prompt$)
   Print
End Function

' special keyboard input function
Function KeyboardLine4$ (Prompt$)
   Visible = 1
   Color Yellow, Black
   Locate , 1, 1
   PromptLine = CsrLin
   Print Prompt$;
   PromptStore = Prompt$
   Locate , , 1
   Temp0 = 0 ' turn off history
   KeyboardLine4$ = KeyboardLine2$(Prompt$)
   Print
End Function

' closes last file open,
' resets next free file number
Function FreeFileNumber
   If FileNumber Then
      Close #FileNumber
      FileNumber = False
   End If
   FileNumber = FreeFile
   FreeFileNumber = True
End Function

' screen saver
Sub ScreenSaver (V$)
   If V$ = Nul Then
      Print "Screensaver settings:"
      If ScreenSaverActive Then
         Print "  Saver is on."
         Print "  Set to" + Str$(ScreenSaverResolution) + " seconds. "
      Else
         Print "  Saver is off."
      End If
      Exit Sub
   End If
   If UCase$(V$) = "ON" Then
      ScreenSaverActive = True
      Print "Screensaver on."
      Exit Sub
   End If
   If UCase$(V$) = "OFF" Then
      ScreenSaverActive = 0
      Print "Screensaver off."
      Exit Sub
   End If
   If Val(V$) <= 0 Then
      ScreenSaverActive = 0
      Print "Screensaver off."
      Exit Sub
   End If
   If Right$(V$, 1) = "H" Then ' hours
      V$ = Left$(V$, Len(V$) - 1)
      V! = Val(V$) * 3600!
      If V! > SFalse And V! < 86400! Then
         ScreenSaverActive = True
         ScreenSaverTimer = Timer
         ScreenSaverStart = Timer
         ScreenSaverResolution = V!
         Print "Screensaver set to"; V!; " seconds."
      Else
         Print "Invalid screensaver value."
      End If
      Exit Sub
   End If
   If Right$(V$, 1) = "M" Then ' minutes
      V$ = Left$(V$, Len(V$) - 1)
      V! = Val(V$) * 60!
      If V! > SFalse And V! < 86400! Then
         ScreenSaverActive = True
         ScreenSaverTimer = Timer
         ScreenSaverStart = Timer
         ScreenSaverResolution = V!
         Print "Screensaver set to"; V!; " seconds."
      Else
         Print "Invalid screensaver value."
      End If
      Exit Sub
   End If
   If Right$(V$, 1) = "S" Then ' seconds
      V$ = Left$(V$, Len(V$) - 1)
   End If
   If Val(V$) > 0 And Val(V$) < 86400 Then
      ScreenSaverActive = True
      ScreenSaverTimer = Timer
      ScreenSaverStart = Timer
      ScreenSaverResolution = CSng(Val(V$))
      Print "Screensaver set to "; V$; " seconds."
   Else
      Print "Invalid screensaver value."
   End If
End Sub

' set prompts
Sub SetPrompts
   Do
      Color White, Black
      Print "Edit Prompt Menu:"
      Color Yellow, Black
      Print "(1)SIC prompt: " + Prompt1
      Print "(2)Whatis prompt: " + Prompt2
      Print "(3)Debug prompt: " + Prompt3
      Print "(4)Search prompt: " + Prompt4
      Print "(5)Setprompt prompt: " + Prompt5
      Print "(6)Reset all prompts."
      Do
         Color White, Black
         Locate , 1, 1
         Print "Enter Prompt(? for Help, Q To Quit)? ";
         Locate , , 1
         Out2 = InKeyx$
         If ControlBreak Then
            ControlBreak = False
            Exit Do
         End If
         If Len(Out2) Then
            Select Case Out2
               Case Chr$(3)
                  Color BreakColor, Black
                  Print
                  Print BreakMessage
                  If MakeBeep Then
                     Sound Freq, Duration
                  End If
               Case Chr$(13)
                  Print
                  Out2 = "Q"
                  Exit Do
               Case Else
                  Print Out2
                  Exit Do
            End Select
         End If
      Loop
      If UCase$(Out2) = "Q" Then
         Exit Do
      End If
      If Out2 = "?" Then
         Filename = "prompt.doc"
         Call ListHelpFile(0)
         Out2 = Nul
      End If
      Color White, Black
      Select Case Int(Val(Out2))
         Case 1
            Print "SIC Prompt:"
            Visible = 1
            Color Yellow, Black
            Locate , 1, 1
            Temp0 = 5
            PromptLine = CsrLin
            Call DisplayPrompt(Prompt5$)
            Color White, Black
            PromptStore = Prompt5$
            Locate , , 1
            Temp0 = 5
            Out2 = KeyboardLine2$(Prompt5)
            Print
            Prompt1 = Out2
         Case 2
            Print "Whatis Prompt:"
            Visible = 1
            Color Yellow, Black
            Locate , 1, 1
            Temp0 = 5
            PromptLine = CsrLin
            Call DisplayPrompt(Prompt5$)
            Color White, Black
            PromptStore = Prompt5$
            Locate , , 1
            Temp0 = 5
            Out2 = KeyboardLine2$(Prompt5)
            Print
            Prompt2 = Out2
         Case 3
            Print "Debug Prompt:"
            Visible = 1
            Color Yellow, Black
            Locate , 1, 1
            Temp0 = 5
            PromptLine = CsrLin
            Call DisplayPrompt(Prompt5$)
            Color White, Black
            PromptStore = Prompt5$
            Locate , , 1
            Temp0 = 5
            Out2 = KeyboardLine2$(Prompt5)
            Print
            Prompt3 = Out2
         Case 4
            Print "Search Prompt:"
            Visible = 1
            Color Yellow, Black
            Locate , 1, 1
            Temp0 = 5
            PromptLine = CsrLin
            Call DisplayPrompt(Prompt5$)
            Color White, Black
            PromptStore = Prompt5$
            Locate , , 1
            Temp0 = 5
            Out2 = KeyboardLine2$(Prompt5)
            Print
            Prompt4 = Out2
         Case 5
            Print "Setprompt Prompt:"
            Visible = 1
            Color Yellow, Black
            Locate , 1, 1
            Temp0 = 5
            PromptLine = CsrLin
            Call DisplayPrompt(Prompt5$)
            Color White, Black
            PromptStore = Prompt5$
            Locate , , 1
            Temp0 = 5
            Out2 = KeyboardLine2$(Prompt5)
            Print
            Prompt5 = Out2
         Case 6
            Prompt1 = ">"
            Prompt2 = ":"
            Prompt3 = "?"
            Prompt4 = "#"
            Prompt5 = "]"
            Print "All prompts reset."
      End Select
   Loop
End Sub

' beginning of the command/equation parser
Sub EnterEquate
   On Error GoTo EquateTrap
   AllowExtra = False
   Out2 = Strim$(Out2)
   If Out2 = Nul Then
      Exit Sub
   End If
   StoreInput$ = Out2
   Call Assignment
   If Assign Then
      Exit Sub
   End If
   Out2 = StoreInput$
   PName$ = UCase$(Out2)
   For PNumber = 1 To MaxStatements
      SName$ = Statements$(PNumber)
      If Left$(PName$, Len(SName$)) = SName$ Then
         If Len(PName$) > Len(SName$) Then
            If Right$(SName$, 1) <> "#" Then
               BadToken = False
               TokenForm$ = Mid$(PName$, Len(SName$) + 1, 1)
               Select Case TokenForm$
                  Case "(", "[", "{"
                     Token = 2
                  Case "="
                     If Right$(SName$, 1) = "$" Then
                        Token = 1
                     Else
                        BadToken = True
                     End If
                  Case TabS, SpaceC, Quote ' tab/space/quote
                     Token = False
                  Case Else
                     BadToken = True
               End Select
               If BadToken Then
                  Select Case PNumber
                     Case 1, 5, 117 ' rem/data
                        Eat$ = Nul
                     Case Else
                        Strng = "<unknown statement>"
                        Error 92
                  End Select
               End If
            End If
         End If
         Select Case PNumber
            Case 1 ' apostrophe
               ' (does not exist)
            Case 2, 3
               ' EndIf/End If
            Case 4 ' stop
               ProgramLine = MaxLines
            Case 5 ' REM
               Out2 = Mid$(Out2, 4)
               Out2 = Strim$(Out2)
               Out2 = UCase$(Out2)
               Out2 = Xtrim$(Out2, False) ' trim spaces
               ' REM $function
               If Left$(Out2, 7) = "$PAUSE:" Then
                  Out2 = "PAUSE" + Mid$(Out2, 8)
                  Call PauseSecond
                  Exit Sub
               End If
               If Left$(Out2, 7) = "$SLEEP:" Then
                  Out2 = "PAUSE" + Mid$(Out2, 8)
                  Call PauseSecond
                  Exit Sub
               End If
               If Left$(Out2, 7) = "$DELAY:" Then
                  Out2 = "PAUSE" + Mid$(Out2, 8)
                  Call PauseSecond
                  Exit Sub
               End If
               ' REM $metacommand
               If Left$(Out2, 7) = "$DEBUG:" Then
                  Call DebugCommand(0, 0)
                  Exit Sub
               End If
               If Left$(Out2, 8) = "$LLINES:" Then
                  Call DebugCommand2(0)
                  Exit Sub
               End If
               If Left$(Out2, 1) = "$" Then
                  If Left$(Out2, 9) = "$INCLUDE:" Then
                     If IncludeRecurse >= MaxIncludeRecurse Then
                        Error 173
                     End If
                     IncludeRecurse = IncludeRecurse + 1
                     Var$ = Mid$(Out2, 10)
                     Var$ = LTrim$(RTrim$(Var$))
                     StartLine = 0
                     If InStr(Var$, ",") And InStr(Var$, ";") Then
                        Error 179
                     End If
                     If InStr(Var$, ",") Then
                        VarQ = Int(Val(Mid$(Var$, InStr(Var$, ",") + 1)))
                        Var$ = Left$(Var$, InStr(Var$, ",") - 1)
                        If VarQ >= 1 And VarQ <= MaxLines Then
                           StartLine = VarQ - 1
                        Else
                           Error 179
                        End If
                     End If
                     If InStr(Var$, ";") Then
                        VarQ = Int(Val(Mid$(Var$, InStr(Var$, ";") + 1)))
                        Var$ = Left$(Var$, InStr(Var$, ";") - 1)
                        If VarQ >= 1 And VarQ <= MaxLines Then
                           StartLine = VarQ - 1
                        Else
                           Error 179
                        End If
                     End If
                     Var$ = Strim$(Var$)
                     ' double quote
                     If Left$(Var$, 1) = Quote And Right$(Var$, 1) = Quote Then
                        Var$ = Left$(Var$, Len(Var$) - 1)
                        Var$ = Mid$(Var$, 2)
                        Var$ = Ambiguate$(Var$)
                        Filename = Var$
                        If Len(Filename) Then
                           If ValidFileChar2$(Filename) = Nul Then
                              Error 53
                           End If
                           If InStr(Filename, "?") Or InStr(Filename, "*") Then
                              Error 53
                           End If
                           If _FileExists(Filename) Then
                              ProgramName = Filename
                              Program(ProgramLine) = Nul
                              Call ReadProgram
                              Call PrepareProgram
                              ProgramLine = StartLine ' restart at line
                              Call CountLines(LastLine)
                              Exit Sub
                           End If
                        End If
                     Else
                        ' single quote
                        If Left$(Var$, 1) = "'" And Right$(Var$, 1) = "'" Then
                           Var$ = Left$(Var$, Len(Var$) - 1)
                           Var$ = Mid$(Var$, 2)
                           Var$ = Ambiguate$(Var$)
                           Filename = Var$
                           If Len(Filename) Then
                              If ValidFileChar2$(Filename) = Nul Then
                                 Error 53
                              End If
                              If InStr(Filename, "?") Or InStr(Filename, "*") Then
                                 Error 53
                              End If
                              If _FileExists(Filename) Then
                                 ProgramName = Filename
                                 Program(ProgramLine) = Nul
                                 Call ReadProgram
                                 Call PrepareProgram
                                 ProgramLine = StartLine ' restart at line
                                 Call CountLines(LastLine)
                                 Exit Sub
                              End If
                           End If
                        End If
                     End If
                     Error 53
                     Exit Sub
                  End If
                  Select Case Out2
                     Case "$DYNAMIC"
                        Eat$ = Nul
                     Case "$STATIC"
                        Eat$ = Nul
                     Case Else
                        Error 160
                        Exit Sub
                  End Select
               End If
            Case 6 ' mid$
               Call AssignMidString
            Case 7 ' left$
               Call AssignLeftString
            Case 8 ' right$
               Call AssignRightString
            Case 9 ' print #
               ErrorValue = 0
               Call PrintExpressionFile
            Case 10 ' dprint
               ErrorValue = 0
               Call DprintExpression
            Case 11 ' lprint using
               ErrorValue = 0
               Call LprintUsing
            Case 12 ' sprint
               ErrorValue = 0
               Call SprintExpression
            Case 13 ' uprint
               ErrorValue = 0
               Call UprintExpression
            Case 14 ' input;
               Call InputExpression(1)
            Case 15 ' forif
               GoSub ForifLoop
            Case 16 ' for
               GoSub LoopExpression
            Case 17 ' nextif
               GoSub LoopifTerminate
            Case 18 ' next
               GoSub LoopTerminate
            Case 19 ' continue for
               GoSub ContinueForif
            Case 20 ' continue forif
               GoSub ContinueFor
            Case 21 ' exit forif
               GoSub ExitifFor
            Case 22 ' exit for
               GoSub ExitFor
            Case 23
               ' DoUntil
            Case 24 ' loop while
               GoSub EndDoWhile
            Case 25 ' exit do
               GoSub ExitDo
            Case 26 ' continue do
               GoSub ContinueDo
            Case 27 ' goto
               GoSub BranchTo
            Case 28 ' gosub
               GoSub GosubBranch
            Case 29 ' return
               GoSub ReturnBranch
            Case 30 ' do while
               GoSub DoWhile
            Case 31
               ' Do
            Case 32 ' off
               ProgramLine = MaxLines
            Case 33 ' if
               GoSub IfBranch
            Case 34 ' elseif
               GoSub ElseBranch
            Case 35 ' caseif else
               GoSub SelectifEnd
            Case 36 ' caseif
               GoSub SelectifEnd
            Case 37 ' select case
               GoSub SelectCase
            Case 38
               ' End Selectif
            Case 39 ' beep
               'Beep
               'Sound Freq, Duration
               Call BeepSecond
            Case 40 ' sound
               Call SoundSpeaker
            Case 41 ' color
               Call ChangeColor
            Case 42 ' locate
               Call LocateCursor
            Case 43 ' cls
               Call CLSScreen
            Case 44 ' screen
               Call ChangeScreen
            Case 45 ' width
               Call ChangeWidth
            Case 46 ' write #
               ErrorValue = 0
               Call WriteExpressionFile
            Case 47 ' line input;
               Call LineInputExpression(1)
            Case 48 ' line input #
               Call LineInputExpFile
            Case 49 ' input #
               Call InputExpressionFile
            Case 50 ' wend
               GoSub EndWhile
            Case 51 ' while
               GoSub DoWend
            Case 52 ' continue while
               GoSub ContinueWhile
            Case 53 ' exit while
               GoSub ExitWhile
            Case 54 ' else
               GoSub ElseBranch
            Case 55 ' loop until
               GoSub EndDoUntil
            Case 56 ' loopif
               GoSub LoopifStart
            Case 57 ' end loopif
               GoSub EndloopIf
            Case 58 ' exit loopif
               GoSub ExitloopIf
            Case 59 ' loop
               GoSub EndDo
            Case 60 ' randmoize
               Call SeedRandom
            Case 61 ' poke
               Call PokeValue
            Case 62 ' int86
               Call Int86Function
            Case 63 ' def seg
               Call DefsegFunction
            Case 64 ' absolute
               Call AbsoluteFunction
            Case 65 ' out
               Call OutputPort
            Case 66 ' wait
               Call WaitPort
            Case 67 ' sleep
               'Call SleepSecond
               Call PauseSecond
            Case 68 ' pause
               Call PauseSecond
            Case 69 ' selectif case
               GoSub SelectifCase
            Case 70
               ' End Select
            Case 71 ' case else
               GoSub SelectEnd
            Case 72 ' case
               GoSub SelectEnd
            Case 73 ' continue loopif
               GoSub ContinueLoopif
            Case 74 ' end
               ProgramLine = MaxLines
            Case 75 ' clear
               ProgramLine = MaxLines
            Case 76 ' system
               ProgramLine = MaxLines
               Call HaltProgram
            Case 77 ' swap
               Call SwapData
            Case 78 ' error
               Out2 = Mid$(Out2, 6)
               Out2 = Strim$(Out2)
               TokenIndex = 1
               Call GetToken
               Call Parse1(Temp3#)
               Error CInt(Temp3#)
            Case 79 ' on error goto
               Out2 = Mid$(Out2, 14)
               Out2 = Strim$(Out2)
               TokenIndex = 1
               Call GetToken
               Call Parse1(Temp3#)
               ErrorType = CInt(Temp3#)
            Case 80 ' on error resume previous
               ErrorType = -1
            Case 81 ' on error resume same
               ErrorType = -2
            Case 82 ' on error resume next
               ErrorType = -3
            Case 83 ' on error stop
               ErrorType = False
            Case 84 ' resume previous
               If ErrorLine > 0 Then
                  ProgramLine = ErrorLine - 1
                  Do
                     If Len(Strim$(Program$(ProgramLine))) Then
                        ProgramLine = ProgramLine - 1
                        Exit Do
                     End If
                     ProgramLine = ProgramLine - 1
                     If ProgramLine < 1 Then
                        ProgramLine = MaxLines
                        Exit Do
                     End If
                  Loop
                  ErrorLine = 0
               Else
                  Error 20
               End If
            Case 85 ' resume same
               If ErrorLine > 0 Then
                  ProgramLine = ErrorLine - 1
                  ErrorLine = 0
               Else
                  Error 20
               End If
            Case 86 ' resume next
               If ErrorLine > 0 Then
                  ProgramLine = ErrorLine + 1
                  Do
                     If Len(Strim$(Program$(ProgramLine))) Then
                        ProgramLine = ProgramLine - 1
                        Exit Do
                     End If
                     ProgramLine = ProgramLine + 1
                     If ProgramLine > LastLine Then
                        Exit Do
                     End If
                  Loop
                  ErrorLine = 0
               Else
                  Error 20
               End If
            Case 87 ' resume
               If ErrorLine > 0 Then
                  Out2 = Mid$(Out2, 7)
                  Out2 = Strim$(Out2)
                  If Out2 = Nul Then
                     ProgramLine = ErrorLine - 1
                  Else
                     Temp3# = Int(Val(Out2))
                     If Temp3# <= Dfalse Then
                        ProgramLine = ErrorLine - 1
                     Else
                        If Temp3# <= MaxLines Then
                           ProgramLine = CInt(Temp3#) - 1
                        Else
                           ProgramLine = MaxLines
                        End If
                     End If
                  End If
                  ErrorLine = 0
               Else
                  Error 20
               End If
            Case 88 ' on x goto/gosub
               GoSub MultiBranch
            Case 89 ' date$=
               Call SetDate
            Case 90 ' time$=
               Call SetTime
            Case 91 ' chdrive
               StoreCurrentDirectory = _CWD$
               Call CHdrive(1)
            Case 92 ' cd
               StoreCurrentDirectory = _CWD$
               Call CDDirectory(1)
            Case 93 ' chdir
               StoreCurrentDirectory = _CWD$
               Call CDDirectory(2)
            Case 94 ' md
               Call MDDirectory(1)
            Case 95 ' mkdir
               Call MDDirectory(2)
            Case 96 ' rd
               Call RDDirectory(1)
            Case 97 ' rmdir
               Call RDDirectory(2)
            Case 98 ' kill
               Call KillFile(1)
            Case 99 ' delete
               Call KillFile(2)
            Case 100 ' rename
               Call NameExpression(1)
            Case 101 ' name
               Call NameExpression(2)
            Case 102 ' shell
               Call ShellProgram
            Case 103 ' chain
               Call ChainProgram
            Case 104 ' let
               Call AssignKeyword
            Case 105 ' close #
               Call CloseFile(1)
            Case 106 ' open #
               Call OpenFile
            Case 107 ' field #
               Call OpenField
            Case 108 ' write
               ErrorValue = 0
               Call WriteExpression
            Case 109 ' print using
               Call PrintUsing
            Case 110 ' input
               Call InputExpression(2)
            Case 111 ' line input
               Call LineInputExpression(2)
            Case 112 ' lset #
               Call FieldSet(1)
            Case 113 ' rset #
               Call FieldSet(2)
            Case 114 ' put #
               Call PutRecord
            Case 115 ' get #
               Call GetRecord
            Case 116 ' read #
               Call ReadRecord
            Case 117
               ' Data
            Case 118 ' read
               Call ReadData
            Case 119 ' restore
               Call RestoreData
            Case 120 ' circle step
               Call DrawCircleStep
            Case 121 ' line step
               Call DrawLineStep
            Case 122 ' pset step
               Call DrawPixelStep
            Case 123 ' preset step
               Call DrawPixelXStep
            Case 124 ' paint step
               Call PaintAreaStep
            Case 125 ' draw
               Call DrawExpression
            Case 126 ' play
               Call PlayExpression
            Case 127 ' get step
               Call GetGraphicsStep
            Case 128 ' put step
               Call PutGraphicsStep
            Case 129 ' bsave
               Call BSaveImage
            Case 130 ' bload
               Call BLoadImage
            Case 131 ' view screen
               Call ViewScreen(1)
            Case 132 ' view
               Call ViewScreen(2)
            Case 133 ' window screen
               Call WindowScreen(1)
            Case 134 ' window
               Call WindowScreen(2)
            Case 135 ' circle
               Call DrawCircle
            Case 136 ' line
               Call DrawLine
            Case 137 ' close
               Call CloseFile(2)
            Case 138 ' DEF FN
               Call DefineFunction
            Case 139 ' ENVIRON
               Call SetEnviron
            Case 140 ' paint
               Call PaintArea
            Case 141 ' pset
               Call DrawPixel
            Case 142 ' preset
               Call DrawPixelX
            Case 143 ' get
               Call GetGraphics
            Case 144 ' put
               Call PutGraphics
            Case 145 ' DIM
               ' doesn't do anything yet
            Case 146 ' COMMON
               ' doesn't do anything yet
            Case 147 ' DECLARE
               ' doesn't do anything yet
            Case 148 ' lock
               Call LockFile
            Case 149 ' unlock
               Call UnlockFile
            Case 150 ' print
               ErrorValue = 0
               Call PrintExpression
            Case 151 ' lprint
               ErrorValue = 0
               Call LprintExpression
            Case 152 ' triangle
               Call DrawTriangle
            Case 153 ' polygon
               Call DrawPolygon
            Case 154 ' square
               Call DrawSquare
            Case 155 ' delay
               Call PauseSecond
            Case 156 ' limit
               Call LimitSecond
            Case 157 ' slice
               Call LimitSecond
            Case 158 ' const
               Call SetConst
         End Select
         Exit Sub
      End If
   Next
   Error 91
   EquateExit:
   Exit Sub

   ForifLoop:
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   If Strng = "," Or Strng = ";" Then
      If Temp4# Then
         Out2 = UCase$(Mid$(Out2, TokenIndex))
         Out2 = Strim$(Out2)
         Temp1$ = UCase$(Left$(Out2, 1))
         If Temp1$ >= "A" And Temp1$ <= "Z" Then
            Element = Asc(Temp1$) - 64
            Out2 = Mid$(Out2, 2)
            Out2 = Strim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Out2 = Mid$(Out2, 2)
               Out2 = Strim$(Out2)
               FinishFor = Dfalse
               StepTo = 1#
               ExceptStep = Dfalse
               ExceptStepIs = False
               Call Equate(StartFor#)
               Variables(Element) = StartFor#
               If ExceptStepIs Then
                  If StartFor# = ExceptStep Then
                     If StartFor# = FinishFor Then
                        GoTo LoopifIgnore
                     Else
                        GoSub LoopifIgnore
                        ProgramLine = ProgramLine - 1
                        Return
                     End If
                  End If
               End If
               If StepTo > Dfalse Then
                  If StartFor# > FinishFor Then
                     GoTo LoopifIgnore
                  End If
               End If
               If StepTo < Dfalse Then
                  If StartFor# < FinishFor Then
                     GoTo LoopifIgnore
                  End If
               End If
               Return
            End If
         End If
      Else
         GoTo LoopifIgnore
      End If
      Return
   End If
   Error 103
   Return

   LoopifIgnore:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedifIgnore
      If Imbedded Then
         GoTo LoopifIgnore
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 6)) = "NEXTIF" Then
         ProgramLine = Count1
         Return
      End If
   Next
   Error 103
   Return

   ImbeddedifIgnore:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "FORIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 6)) = "NEXTIF" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 103
   Return

   LoopifTerminate:
   ForLoop = ProgramLine
   NextifFor:
   For Count1 = ProgramLine - 1 To 1 Step -1
      GoSub ImbeddedifFor
      If Imbedded Then
         GoTo NextifFor
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "FORIF" Then
         Out2 = Mid$(Temp1$, 6)
         Out2 = Strim$(Out2)
         TokenIndex = 1
         Call GetToken
         Call Parse1(Temp4#)
         If Strng = "," Or Strng = ";" Then
            If Temp4# Then
               Out2 = UCase$(Mid$(Out2, TokenIndex))
               Out2 = Strim$(Out2)
               Temp1$ = UCase$(Left$(Out2, 1))
               If Temp1$ >= "A" And Temp1$ <= "Z" Then
                  Element = Asc(Temp1$) - 64
                  Out2 = Mid$(Out2, 2)
                  Out2 = Strim$(Out2)
                  If Left$(Out2, 1) = "=" Then
                     Out2 = Mid$(Out2, 2)
                     Out2 = Strim$(Out2)
                     FinishFor = Dfalse
                     StepTo = 1#
                     ExceptStep = Dfalse
                     ExceptStepIs = False
                     Call Equate(x#)
                     Variable# = Variables(Element)
                     Variable# = Variable# + StepTo
                     Variables(Element) = Variable#
                     If ExceptStepIs Then
                        If Variable# = ExceptStep Then
                           ProgramLine = ForLoop - 1
                           Return
                        End If
                     End If
                     If StepTo > Dfalse Then
                        If Variable# <= FinishFor Then
                           ProgramLine = Count1
                        Else
                           ProgramLine = ForLoop
                        End If
                        Return
                     Else
                        If StepTo < Dfalse Then
                           If Variable# >= FinishFor Then
                              ProgramLine = Count1
                           Else
                              ProgramLine = ForLoop
                           End If
                           Return
                        End If
                     End If
                  End If
               End If
            Else
               ProgramLine = Count1
            End If
            Return
         End If
         Error 103
         Return
      End If
   Next
   Error 103
   Return

   ImbeddedifFor:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 6)) <> "NEXTIF" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 > 1
      Count2 = Count2 - 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 6)) = "NEXTIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 5)) = "FORIF" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 103
   Return

   ContinueForif:
   Nested = 1
   Out2 = Mid$(Out2, 15)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "FORIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 6)) = "NEXTIF" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1 - 1
            Return
         End If
      End If
   Next
   Error 103
   Return

   ExitifFor:
   Nested = 1
   Out2 = Mid$(Out2, 11)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "FORIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 6)) = "NEXTIF" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1
            Return
         End If
      End If
   Next
   Error 103
   Return

   LoopExpression:
   Out2 = Mid$(Out2, 4)
   Out2 = Strim$(Out2)
   Temp1$ = UCase$(Left$(Out2, 1))
   If Temp1$ >= "A" And Temp1$ <= "Z" Then
      Element = Asc(Temp1$) - 64
      Out2 = Mid$(Out2, 2)
      Out2 = Strim$(Out2)
      If Left$(Out2, 1) = "=" Then
         Out2 = Mid$(Out2, 2)
         Out2 = Strim$(Out2)
         FinishFor = Dfalse
         StepTo = 1#
         ExceptStep = Dfalse
         ExceptStepIs = False
         Call Equate(StartFor#)
         Variables(Element) = StartFor#
         If ExceptStepIs Then
            If StartFor# = ExceptStep Then
               If StartFor# = FinishFor Then
                  GoTo LoopIgnore
               Else
                  GoSub LoopIgnore
                  ProgramLine = ProgramLine - 1
                  Return
               End If
            End If
         End If
         If StepTo > Dfalse Then
            If StartFor# > FinishFor Then
               GoTo LoopIgnore
            End If
         End If
         If StepTo < Dfalse Then
            If StartFor# < FinishFor Then
               GoTo LoopIgnore
            End If
         End If
         Return
      End If
   End If
   Error 97
   Return

   LoopIgnore:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedIgnore
      If Imbedded Then
         GoTo LoopIgnore
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 4)) = "NEXT" Then
         If UCase$(Left$(Temp1$, 6)) <> "NEXTIF" Then
            ProgramLine = Count1
            Return
         End If
      End If
   Next
   Error 97
   Return

   ImbeddedIgnore:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
      Return
   End If
   If UCase$(Left$(Temp1$, 3)) <> "FOR" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 3)) = "FOR" Then
         If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
            Nested = Nested + 1
         End If
      End If
      If UCase$(Left$(Temp1$, 4)) = "NEXT" Then
         If UCase$(Left$(Temp1$, 6)) <> "NEXTIF" Then
            Nested = Nested - 1
         End If
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 97
   Return

   LoopTerminate:
   ForLoop = ProgramLine
   NextFor:
   For Count1 = ProgramLine - 1 To 1 Step -1
      GoSub Imbedded.For
      If Imbedded Then
         GoTo NextFor
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 3)) = "FOR" Then
         If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
            Temp1$ = Mid$(Temp1$, 4)
            Temp1$ = Strim$(Temp1$)
            Temp2$ = UCase$(Left$(Temp1$, 1))
            If Temp2$ >= "A" And Temp2$ <= "Z" Then
               Element = Asc(Temp2$) - 64
               Out2 = Mid$(Temp1$, 2)
               Out2 = Strim$(Out2)
               If Left$(Out2, 1) = "=" Then
                  Out2 = Mid$(Out2, 2)
                  Out2 = Strim$(Out2)
                  FinishFor = Dfalse
                  StepTo = 1#
                  ExceptStep = Dfalse
                  ExceptStepIs = False
                  Call Equate(x#)
                  Variable# = Variables(Element)
                  Variable# = Variable# + StepTo
                  Variables(Element) = Variable#
                  If ExceptStepIs Then
                     If Variable# = ExceptStep Then
                        ProgramLine = ForLoop - 1
                        Return
                     End If
                  End If
                  If StepTo > Dfalse Then
                     If Variable# <= FinishFor Then
                        ProgramLine = Count1
                     Else
                        ProgramLine = ForLoop
                     End If
                     Return
                  Else
                     If StepTo < Dfalse Then
                        If Variable# >= FinishFor Then
                           ProgramLine = Count1
                        Else
                           ProgramLine = ForLoop
                        End If
                        Return
                     End If
                  End If
               End If
            End If
         End If
      End If
   Next
   Error 97
   Return

   Imbedded.For:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 6)) = "NEXTIF" Then
      Return
   End If
   If UCase$(Left$(Temp1$, 4)) <> "NEXT" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 > 1
      Count2 = Count2 - 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 4)) = "NEXT" Then
         If UCase$(Left$(Temp1$, 6)) <> "NEXTIF" Then
            Nested = Nested + 1
         End If
      End If
      If UCase$(Left$(Temp1$, 3)) = "FOR" Then
         If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
            Nested = Nested - 1
         End If
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 97
   Return

   ContinueFor:
   Nested = 1
   Out2 = Mid$(Out2, 13)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 3)) = "FOR" Then
         If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
            Nested = Nested + 1
         End If
      End If
      If UCase$(Left$(Temp1$, 4)) = "NEXT" Then
         If UCase$(Left$(Temp1$, 6)) <> "NEXTIF" Then
            Nested = Nested - 1
            If Nested = False Then
               ProgramLine = Count1 - 1
               Return
            End If
         End If
      End If
   Next
   Error 97
   Return

   ExitFor:
   Nested = 1
   Out2 = Mid$(Out2, 9)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 3)) = "FOR" Then
         If UCase$(Left$(Temp1$, 5)) <> "FORIF" Then
            Nested = Nested + 1
         End If
      End If
      If UCase$(Left$(Temp1$, 4)) = "NEXT" Then
         If UCase$(Left$(Temp1$, 6)) <> "NEXTIF" Then
            Nested = Nested - 1
            If Nested = False Then
               ProgramLine = Count1
               Return
            End If
         End If
      End If
   Next
   Error 97
   Return

   EndDoWhile:
   Out2 = Mid$(Out2, 11)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   If Temp3# = Dtrue Then
      GoTo EndDo
   End If
   Return

   EndDoUntil:
   Out2 = Mid$(Out2, 11)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   If Temp3# = Dfalse Then
      GoTo EndDo
   End If
   Return

   EndDo:
   LoopLine = ProgramLine

   NextDo:
   For Count1 = ProgramLine - 1 To 1 Step -1
      GoSub ImbeddedLoop
      If Imbedded Then
         GoTo NextDo
      End If
      Temp1$ = Strim$(Program$(Count1))
      If UCase$(Left$(Temp1$, 2)) = "DO" Then
         If UCase$(Left$(Temp1$, 8)) = "DO WHILE" Then
            Out2 = Mid$(Temp1$, 9)
            Out2 = Strim$(Out2)
            Call Equate(Temp3#)
            If Temp3# = Dfalse Then
               ProgramLine = LoopLine
            Else
               ProgramLine = Count1
            End If
            Return
         Else
            If UCase$(Left$(Temp1$, 8)) = "DO UNTIL" Then
               Out2 = Mid$(Temp1$, 9)
               Out2 = Strim$(Out2)
               Call Equate(Temp3#)
               If Temp3# <> Dfalse Then
                  ProgramLine = LoopLine
               Else
                  ProgramLine = Count1
               End If
               Return
            Else
               ProgramLine = Count1
               Return
            End If
         End If
      End If
   Next
   Error 98
   Return

   LoopifStart:
   UnlessBranch = False
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   If Out2 = Nul Then
      Error 104
   End If
   Call Equate(Temp3#)
   If Temp3# Then
      If UnlessBranch = False Then
         Return
      Else
         If UnlessValue = Dfalse Then
            Return
         End If
      End If
   End If
   Nested = 1
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 6)) = "LOOPIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 10)) = "END LOOPIF" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1
            Return
         End If
      End If
   Next
   Error 104
   Return

   EndloopIf:
   LoopLine = ProgramLine
   NextIfdo:
   For Count1 = ProgramLine - 1 To 1 Step -1
      GoSub ImbeddedLoopif
      If Imbedded Then
         GoTo NextIfdo
      End If
      Temp1$ = Strim$(Program$(Count1))
      If UCase$(Left$(Temp1$, 6)) = "LOOPIF" Then
         Out2 = Mid$(Temp1$, 7)
         Out2 = Strim$(Out2)
         Call Equate(Temp3#)
         If Temp3# = Dfalse Then
            ProgramLine = LoopLine
         Else
            ProgramLine = Count1
         End If
         Return
      End If
   Next
   Error 104
   Return

   ExitloopIf:
   Nested = 1
   Out2 = Mid$(Out2, 12)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 6)) = "LOOPIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 10)) = "END LOOPIF" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1
            Return
         End If
      End If
   Next
   Error 104
   Return

   ImbeddedLoopif:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 10)) <> "END LOOPIF" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 > 1
      Count2 = Count2 - 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 10)) = "END LOOPIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 6)) = "LOOPIF" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 104
   Return

   ContinueLoopif:
   Nested = 1
   Out2 = Mid$(Out2, 16)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 6)) = "LOOPIF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 10)) = "END LOOPIF" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1 - 1
            Return
         End If
      End If
   Next
   Error 104
   Return

   ImbeddedLoop:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 6)) = "LOOPIF" Then
      Return
   End If
   If UCase$(Left$(Temp1$, 4)) <> "LOOP" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 > 1
      Count2 = Count2 - 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 4)) = "LOOP" Then
         If UCase$(Left$(Temp1$, 6)) <> "LOOPIF" Then
            Nested = Nested + 1
         End If
      End If
      If UCase$(Left$(Temp1$, 2)) = "DO" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 98
   Return

   ContinueDo:
   Nested = 1
   Out2 = Mid$(Out2, 12)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 2)) = "DO" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 4)) = "LOOP" Then
         If UCase$(Left$(Temp1$, 6)) <> "LOOPIF" Then
            Nested = Nested - 1
            If Nested = False Then
               ProgramLine = Count1 - 1
               Return
            End If
         End If
      End If
   Next
   Error 98
   Return

   ExitDo:
   Nested = 1
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 2)) = "DO" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 4)) = "LOOP" Then
         If UCase$(Left$(Temp1$, 6)) <> "LOOPIF" Then
            Nested = Nested - 1
            If Nested = False Then
               ProgramLine = Count1
               Return
            End If
         End If
      End If
   Next
   Error 98
   Return

   BranchTo:
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   BranchLoop = CInt(Temp3#)
   If BranchLoop > False And BranchLoop <= LastLine Then
      Temp1$ = Strim$(Program$(BranchLoop))
      If Temp1$ <> Nul Then
         ProgramLine = BranchLoop - 1
         Return
      End If
   End If
   Error 99
   Return

   GosubBranch:
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   BranchLoop = CInt(Temp3#)
   If BranchLoop > False And BranchLoop <= LastLine Then
      Temp1$ = Strim$(Program$(BranchLoop))
      If Temp1$ <> Nul Then
         NestedGosub = NestedGosub + 1
         If NestedGosub = MaxGosubs Then
            MaxGosubs = MaxGosubs + 1
            ReDim _Preserve GosubReturn(1 To MaxGosubs) As Integer
         End If
         If NestedGosub >= MaxNestGosub Then
            Error 156
            Exit Sub
         End If
         GosubReturn(NestedGosub) = ProgramLine
         ProgramLine = BranchLoop - 1
         Return
      End If
   End If
   Error 99
   Return

   ReturnBranch:
   If NestedGosub > False Then
      ProgramLine = GosubReturn(NestedGosub)
      NestedGosub = NestedGosub - 1
      Return
   End If
   Error 100
   Return

   DoWhile:
   Out2 = Mid$(Out2, 9)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   If Temp3# = Dfalse Then
      DoBranch:
      For Count1 = ProgramLine + 1 To LastLine
         GoSub Imbedded.Do
         If Imbedded Then
            GoTo DoBranch
         End If
         Temp1$ = Program$(Count1)
         Temp1$ = Strim$(Temp1$)
         If UCase$(Left$(Temp1$, 4)) = "LOOP" Then
            If UCase$(Left$(Temp1$, 6)) <> "LOOPIF" Then
               ProgramLine = Count1
               Return
            End If
         End If
      Next
      Error 98
   End If
   Return

   Imbedded.Do:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 2)) <> "DO" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 2)) = "DO" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 4)) = "LOOP" Then
         If UCase$(Left$(Temp1$, 6)) <> "LOOPIF" Then
            Nested = Nested - 1
         End If
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 98
   Return

   MultiBranch:
   Out2 = Mid$(Out2, 3)
   Out2 = Strim$(Out2)
   BranchIndex = False
   BranchNumber = False
   BranchType = False
   NextBranch = InStr(UCase$(Out2), "GOTO")
   If NextBranch Then
      BranchType = 1
      OutX$ = Mid$(Out2, NextBranch + 4)
      Out2 = Left$(Out2, NextBranch - 1)
   Else
      NextBranch = InStr(UCase$(Out2), "GOSUB")
      If NextBranch Then
         BranchType = 2
         OutX$ = Mid$(Out2, NextBranch + 5)
         Out2 = Left$(Out2, NextBranch - 1)
      End If
   End If
   If BranchType = False Then
      Error 99
   End If
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   BranchIndex = CInt(Temp3#)
   If BranchIndex <= False Then
      Exit Sub
   End If
   If BranchType = 1 Then
      TokenIndex = 1
      Out2 = OutX$
      Call GetToken
      Call Parse1(Temp4#)
      For IndexCount = 1 To BranchIndex - 1
         If Strng <> "," Then
            Temp4# = Dfalse
            Exit For
         End If
         Call GetToken
         Call Parse1(Temp4#)
      Next
      BranchNumber = CInt(Temp4#)
      If BranchNumber = False Then
         Return
      End If
      If BranchNumber > False And BranchNumber <= LastLine Then
         Temp1$ = Strim$(Program$(BranchNumber))
         If Temp1$ <> Nul Then
            ProgramLine = BranchNumber - 1
            Return
         End If
      End If
   Else
      If BranchType = 2 Then
         TokenIndex = 1
         Out2 = OutX$
         Call GetToken
         Call Parse1(Temp4#)
         For IndexCount = 1 To BranchIndex - 1
            If Strng <> "," Then
               Temp4# = Dfalse
               Exit For
            End If
            Call GetToken
            Call Parse1(Temp4#)
         Next
         BranchNumber = CInt(Temp4#)
         If BranchNumber = False Then
            Return
         End If
         If BranchNumber > False And BranchNumber <= LastLine Then
            Temp1$ = Strim$(Program$(BranchNumber))
            If Temp1$ <> Nul Then
               NestedGosub = NestedGosub + 1
               If NestedGosub = MaxGosubs Then
                  MaxGosubs = MaxGosubs + 1
                  ReDim _Preserve GosubReturn(1 To MaxGosubs) As Integer
               End If
               If NestedGosub >= MaxNestGosub Then
                  Error 156
                  Exit Sub
               End If
               GosubReturn(NestedGosub) = ProgramLine
               ProgramLine = BranchNumber - 1
               Return
            End If
         End If
      End If
   End If
   Error 99
   Return

   IfBranch:
   UnlessBranch = False
   Out2 = Mid$(Out2, 3)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   If Temp3# Then
      If UnlessBranch = False Then
         Return
      Else
         If UnlessValue = Dfalse Then
            Return
         End If
      End If
   End If
   EndifBranch:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedEndif
      If Imbedded Then
         GoTo EndifBranch
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 6)) = "ELSEIF" Then
         ProgramLine = Count1
         Out2 = UCase$(Mid$(Temp1$, 5))
         GoTo IfBranch
         Return
      End If
      If UCase$(Left$(Temp1$, 4)) = "ELSE" Then
         ProgramLine = Count1
         Return
      End If
      If UCase$(Left$(Temp1$, 5)) = "ENDIF" Or UCase$(Left$(Temp1$, 6)) = "END IF" Then
         ProgramLine = Count1
         Return
      End If
   Next
   Error 99
   Return

   ElseBranch:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedEndif
      If Imbedded Then
         GoTo ElseBranch
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "ENDIF" Or UCase$(Left$(Temp1$, 6)) = "END IF" Then
         ProgramLine = Count1
         Return
      End If
   Next
   Error 99
   Return

   ImbeddedEndif:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 2)) <> "IF" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 2)) = "IF" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 5)) = "ENDIF" Or UCase$(Left$(Temp1$, 6)) = "END IF" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 99
   Return

   DoWend:
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   Call Equate(Temp3#)
   If Temp3# = Dfalse Then
      WhileBranch:
      For Count1 = ProgramLine + 1 To LastLine
         GoSub ImbeddedWend
         If Imbedded Then
            GoTo WhileBranch
         End If
         Temp1$ = Program$(Count1)
         Temp1$ = Strim$(Temp1$)
         If UCase$(Left$(Temp1$, 4)) = "WEND" Then
            ProgramLine = Count1
            Return
         End If
      Next
      Error 98
   End If
   Return

   ImbeddedWend:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 5)) <> "WHILE" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "WHILE" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 4)) = "WEND" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 98
   Return

   EndWhile:
   LoopLine = ProgramLine
   NextWhile:
   For Count1 = ProgramLine - 1 To 1 Step -1
      GoSub ImbeddedWhile
      If Imbedded Then
         GoTo NextWhile
      End If
      Temp1$ = Strim$(Program$(Count1))
      If UCase$(Left$(Temp1$, 5)) = "WHILE" Then
         Out2 = Mid$(Temp1$, 6)
         Out2 = Strim$(Out2)
         Call Equate(Temp3#)
         If Temp3# = Dfalse Then
            ProgramLine = LoopLine
         Else
            ProgramLine = Count1
         End If
         Return
      End If
   Next
   Error 98
   Return

   ImbeddedWhile:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 4)) <> "WEND" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 > 1
      Count2 = Count2 - 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 4)) = "WEND" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 5)) = "WHILE" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 98
   Return

   ContinueWhile:
   Nested = 1
   Out2 = Mid$(Out2, 15)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "WHILE" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 4)) = "WEND" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1 - 1
            Return
         End If
      End If
   Next
   Error 98
   Return

   ExitWhile:
   Nested = 1
   Out2 = Mid$(Out2, 11)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      LastToken = False
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If Temp3# > Dfalse And Temp3# <= MaxLoop Then
         Nested = CInt(Temp3#)
      End If
   End If
   For Count1 = ProgramLine + 1 To LastLine
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "WHILE" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 4)) = "WEND" Then
         Nested = Nested - 1
         If Nested = False Then
            ProgramLine = Count1
            Return
         End If
      End If
   Next
   Error 98
   Return

   SelectEnd:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedSelect
      If Imbedded Then
         GoTo SelectEnd
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 12)) <> "END SELECTIF" Then
         If UCase$(Left$(Temp1$, 10)) = "END SELECT" Then
            ProgramLine = Count1
            Return
         End If
      End If
   Next
   Error 102
   Return

   SelectifEnd:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedifSelect
      If Imbedded Then
         GoTo SelectifEnd
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 12)) = "END SELECTIF" Then
         ProgramLine = Count1
         Return
      End If
   Next
   Error 105
   Return

   SelectCase:
   LastToken = False
   Out2 = Mid$(Out2, 12)
   Call Equate(Temp3#)
   If LastToken Then
      CaseValue = Temp3#
   Else
      CaseStrng = Out3
   End If
   PreviousToken = LastToken
   NextSelectCase:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedSelect
      If Imbedded Then
         GoTo NextSelectCase
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 12)) <> "END SELECTIF" Then
         If UCase$(Left$(Temp1$, 10)) = "END SELECT" Then
            ProgramLine = Count1
            Return
         End If
      End If
      If UCase$(Left$(Temp1$, 9)) = "CASE ELSE" Then
         ProgramLine = Count1
         Return
      End If
      If UCase$(Left$(Temp1$, 6)) <> "CASEIF" Then
         If UCase$(Left$(Temp1$, 4)) = "CASE" Then
            Out2 = Mid$(Temp1$, 5)
            Out2 = Strim$(Out2)
            TokenIndex = 1
            Do
               If LastToken <> 1 Then
                  LastToken = False
                  Call GetToken
               End If
               Call Parse1(Temp4#)
               Select Case LastToken
                  Case -1
                     If CaseValue = Temp4# Then
                        ProgramLine = Count1
                        Return
                     End If
                  Case 0
                     If CaseStrng = Out3 Then
                        ProgramLine = Count1
                        Return
                     End If
                  Case 1
                     If ValueIs Then
                        ProgramLine = Count1
                        Return
                     End If
                  Case 2
                     If PreviousToken Then
                        If CaseValue >= CaseValue1 And CaseValue <= CaseValue2 Then
                           ProgramLine = Count1
                           Return
                        End If
                     Else
                        If CaseStrng >= CaseValueS1 And CaseStrng <= CaseValueS2 Then
                           ProgramLine = Count1
                           Return
                        End If
                     End If
               End Select
               If TokenIndex > Len(Out2) Then
                  Exit Do
               End If
            Loop
         End If
      End If
   Next
   Error 102
   Return

   SelectifCase:
   Out2 = Mid$(Out2, 14)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   If Strng = "," Or Strng = ";" Then
      If Temp4# Then
         Out2 = UCase$(Mid$(Out2, TokenIndex))
         Out2 = Strim$(Out2)
         LastToken = False
         Call Equate(Temp3#)
         If LastToken Then
            CaseValue = Temp3#
         Else
            CaseStrng = Out3
         End If
         PreviousToken = LastToken
         NextSelectifCase:
         For Count1 = ProgramLine + 1 To LastLine
            GoSub ImbeddedifSelect
            If Imbedded Then
               GoTo NextSelectifCase
            End If
            Temp1$ = Program$(Count1)
            Temp1$ = Strim$(Temp1$)
            If UCase$(Left$(Temp1$, 12)) = "END SELECTIF" Then
               ProgramLine = Count1
               Return
            End If
            If UCase$(Left$(Temp1$, 11)) = "CASEIF ELSE" Then
               ProgramLine = Count1
               Return
            End If
            If UCase$(Left$(Temp1$, 6)) = "CASEIF" Then
               Out2 = Mid$(Temp1$, 7)
               Out2 = Strim$(Out2)
               TokenIndex = 1
               Do
                  If LastToken <> 1 Then
                     LastToken = False
                     Call GetToken
                  End If
                  Call Parse1(Temp4#)
                  Select Case LastToken
                     Case -1
                        If CaseValue = Temp4# Then
                           ProgramLine = Count1
                           Return
                        End If
                     Case 0
                        If CaseStrng = Out3 Then
                           ProgramLine = Count1
                           Return
                        End If
                     Case 1
                        If ValueIs Then
                           ProgramLine = Count1
                           Return
                        End If
                     Case 2
                        If PreviousToken Then
                           If CaseValue >= CaseValue1 And CaseValue <= CaseValue2 Then
                              ProgramLine = Count1
                              Return
                           End If
                        Else
                           If CaseStrng >= CaseValueS1 And CaseStrng <= CaseValueS2 Then
                              ProgramLine = Count1
                              Return
                           End If
                        End If
                  End Select
                  If TokenIndex > Len(Out2) Then
                     Exit Do
                  End If
               Loop
            End If
         Next
      Else
         GoTo SelectifIgnore
      End If
      Return
   End If
   Error 105
   Return

   SelectifIgnore:
   For Count1 = ProgramLine + 1 To LastLine
      GoSub ImbeddedselectifIgnore
      If Imbedded Then
         GoTo SelectifIgnore
      End If
      Temp1$ = Program$(Count1)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 12)) = "END SELECTIF" Then
         ProgramLine = Count1
         Return
      End If
   Next
   Error 105
   Return

   ImbeddedselectifIgnore:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 13)) <> "SELECTIF CASE" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 5)) = "SELECTIF CASE" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 6)) = "END SELECTIF" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 105
   Return

   ImbeddedSelect:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 11)) <> "SELECT CASE" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 11)) = "SELECT CASE" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 12)) <> "END SELECTIF" Then
         If UCase$(Left$(Temp1$, 10)) = "END SELECT" Then
            Nested = Nested - 1
         End If
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 102
   Return

   ImbeddedifSelect:
   Imbedded = False
   Temp1$ = Program$(Count1)
   Temp1$ = Strim$(Temp1$)
   If UCase$(Left$(Temp1$, 13)) <> "SELECTIF CASE" Then
      Return
   End If
   Imbedded = True
   Nested = 1
   Count2 = Count1
   Do While Count2 < LastLine
      Count2 = Count2 + 1
      Temp1$ = Program$(Count2)
      Temp1$ = Strim$(Temp1$)
      If UCase$(Left$(Temp1$, 13)) = "SELECTIF CASE" Then
         Nested = Nested + 1
      End If
      If UCase$(Left$(Temp1$, 12)) = "END SELECTIF" Then
         Nested = Nested - 1
      End If
      If Nested = False Then
         ProgramLine = Count2
         Return
      End If
   Loop
   Error 105
   Return
End Sub

' Const(<exp1$>,<exp2$>)
Sub SetConst
   Out2 = Mid$(Out2, 6) ' const
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken3
   Call GetToken
   Call Parse1(Temp#)
   ConstString$ = Out3
   Call GetToken
   Call Parse1(Temp#)
   If LastToken Then
      ConstValue$ = Str$(Temp#)
   Else
      ConstValue$ = Out3
   End If
   Call GetToken4
   LastToken = True
   Call StoreConst(ConstString$, ConstValue$)
   Assign = True
End Sub

' V1$ = input const
' V2$ = output const value
' V3 = output valid
Sub GetConst (V1$, V2$, V3)
   V3 = 0
   For X = 1 To ConstArray
      If UCase$(V1$) = ConstStrings(X) Then
         V2$ = ConstValues(X) ' could be nul
         V3 = -1
         Exit For
      End If
   Next
End Sub

' V1$ = input const
' V2$ = input const value
Sub StoreConst (V1$, V2$)
   ' check constant
   If Xtrim$(V1$, 0) = Nul Then
      Error 180
   End If

   ' check duplicate
   For V = 1 To ConstArray
      If UCase$(V1$) = ConstStrings(V) Then
         ConstValues(V) = V2$
         Exit Sub
      End If
   Next

   ' assign constant
   ConstArray = ConstArray + 1&
   If ConstArray > UBound(ConstStrings, 1) Then
      ReDim _Preserve ConstStrings(ConstArray) As String
   End If
   If ConstArray > UBound(ConstValues, 1) Then
      ReDim _Preserve ConstValues(ConstArray) As String
   End If
   ConstStrings(ConstArray) = UCase$(V1$)
   ConstValues(ConstArray) = V2$
End Sub

Sub AssignKeyword
   Temp1$ = UCase$(Mid$(Out2, 4)) ' let
   Temp1$ = Strim$(Temp1$)
   Out2 = Mid$(Out2, 4) ' let
   Out2 = Strim$(Out2)
   ' parse let let
   Do
      If Left$(Temp1$, 3) = "LET" Then
         Temp1$ = Mid$(Temp1$, 4)
         Out2 = Mid$(Out2, 4)
         Temp1$ = Strim$(Temp1$)
         Out2 = Strim$(Out2)
      Else
         Exit Do
      End If
   Loop
   If Left$(Temp1$, 5) = "CONST" Then
      Call SetConst
      Exit Sub
   End If
   If Left$(Temp1$, 3) = "MID" Then
      Call AssignMidString
      Exit Sub
   End If
   If Left$(Temp1$, 4) = "LEFT" Then
      Call AssignLeftString
      Exit Sub
   End If
   If Left$(Temp1$, 5) = "RIGHT" Then
      Call AssignRightString
      Exit Sub
   End If
   Call Assignment
End Sub

Sub Assignment
   Assign = False
   Temp1$ = UCase$(Left$(Out2, 1))
   If Temp1$ = "?" Then ' ?=
      Temp1$ = LTrim$(Mid$(Out2, 2))
      Temp2$ = Left$(Temp1$, 1)
      If Temp2$ = "=" Then
         Temp1$ = LTrim$(Mid$(Temp1$, 2))
         Out2 = Temp1$
         Call Assignment
         Call Equate(Temp4#)
         Assign = True
         Exit Sub
      End If
   End If
   If Temp1$ >= "A" And Temp1$ <= "Z" Then
      Variable = Asc(Temp1$) - 64
      Temp1$ = Mid$(Out2, 2)
      Temp2$ = Left$(Temp1$, 1)
      If Temp2$ >= "0" And Temp2$ <= "9" Then
         Temp1$ = LTrim$(Mid$(Temp1$, 2))
         If Len(Temp1$) Then
            ' multivar assign
            Variable = GetVariable(Left$(Out2, 2))
         End If
      End If
      Temp1$ = LTrim$(Temp1$)
      Call Assignment1(Temp1$, Variable)
      If Assign Then
         Call AssignEnd
         Exit Sub
      End If
      If Left$(Temp1$, 1) = "$" Then
         Temp1$ = Mid$(Temp1$, 2)
         Temp1$ = Strim$(Temp1$)
         If Left$(Temp1$, 1) = "(" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "[" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "{" Then
            Strng = "<bad string token>"
            Error 92
         End If
         If Left$(Temp1$, 1) = "=" Then
            Out2 = Mid$(Temp1$, 2)
            Out2 = Strim$(Out2)
            TokenIndex = 1
            Call GetToken
            Call Parse1(Temp3#)
            If LastToken = False Then
               Strngs$(Variable) = Out3
               Assign = True
               Call AssignEnd
               Exit Sub
            End If
         End If
      End If
      If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
         TokenLeft$ = Left$(Temp1$, 1)
         Out2 = Mid$(Temp1$, 2)
         Out2 = Strim$(Out2)
         LastToken = False
         TokenIndex = 1
         Call GetToken
         Call Parse1(Temp3#)
         OK = 0
         If TokenLeft$ = "(" Then
            If Strng = ")" Then
               OK = True
            End If
         End If
         If TokenLeft$ = "[" Then
            If Strng = "]" Then
               OK = True
            End If
         End If
         If TokenLeft$ = "{" Then
            If Strng = "}" Then
               OK = True
            End If
         End If
         If OK = False Then
            Strng = "<illegal closing token>"
            Error 92
            Exit Sub
         End If
         If LastToken = True Then
            Element = CInt(Temp3#)
            Temp1$ = Mid$(Out2, TokenIndex)
            Temp1$ = Strim$(Temp1$)
            V = UBound(Arrays, 2)
            If Element > V Then
               ReDim _Preserve Arrays(1024, Element) As Double
            End If
            Call Assignment2(Temp1$, Variable, Element)
            If Assign Then
               Call AssignEnd
               Exit Sub
            End If
         End If
      End If
   End If
End Sub

Sub AssignEnd
   If Len(Strng) Then
      Call Parse1(X#)
      Strng = "<extra token>"
      Error 92
   End If
End Sub

Sub AssignMidString
   Out2 = Mid$(Out2, 4)
   If Len(Out2) Then
      Begin = 0: If Left$(Out2, 2) = "$(" Then Begin = True
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" And Begin Then
         X$ = UCase$(Mid$(Out2, 2, 1))
         If X$ >= "0" And X$ <= "9" Then
            V$ = V$ + X$
         End If
         ' multivar assign
         Variable = GetVariable(V$)
         Begin = Len(V$)
         If Mid$(Out2, Begin + 1, 1) = "$" Then
            Out2 = Mid$(Out2, Begin + 3)
            LastToken = False
            TokenIndex = 1
            Call GetToken
            Call Parse1(Temp3#)
            Start = CInt(Temp3#)
            If Strng = "," Or Strng = ";" Then
               Call GetToken
               Call Parse1(Temp3#)
               Length = CInt(Temp3#)
               Out2 = Mid$(Out2, TokenIndex)
               Out2 = Strim$(Out2)
               If Left$(Out2, 1) = "=" Then
                  Out2 = Mid$(Out2, 2)
                  Out2 = Strim$(Out2)
                  TokenIndex = 1
                  Call GetToken
                  Call Parse1(Temp3#)
                  If LastToken = False Then
                     If Length = Len(Out3) Then
                        If Start > Len(Strngs(Variable)) Then
                           Strngs(Variable) = Strngs(Variable) + Space$(Start - Len(Strngs(Variable)) - 1) + Out3
                        Else
                           Mid$(Strngs(Variable), Start, Length) = Out3
                        End If
                        Call AssignEnd
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Strng = "<illegal MID$ function call>"
   Error 162
End Sub

Sub AssignLeftString
   Out2 = Mid$(Out2, 5)
   If Len(Out2) Then
      Begin = 0: If Left$(Out2, 2) = "$(" Then Begin = True
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" Then
         X$ = UCase$(Mid$(Out2, 2, 1))
         If X$ >= "0" And X$ <= "9" And Begin Then
            V$ = V$ + X$
         End If
         ' multivar assign
         Variable = GetVariable(V$)
         Begin = Len(V$)
         If Mid$(Out2, Begin + 1, 1) = "$" Then
            Out2 = Mid$(Out2, Begin + 3)
            LastToken = False
            TokenIndex = 1
            Call GetToken
            Call Parse1(Temp3#)
            Start = CInt(Temp3#)
            Out2 = Mid$(Out2, TokenIndex)
            Out2 = Strim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Out2 = Mid$(Out2, 2)
               Out2 = Strim$(Out2)
               TokenIndex = 1
               Call GetToken
               Call Parse1(Temp3#)
               If LastToken = False Then
                  If Start = Len(Out3) Then
                     If Strngs(Variable) = Nul Then
                        Strngs(Variable) = Out3
                        Call AssignEnd
                        Exit Sub
                     End If
                     Mid$(Strngs(Variable), 1, Start) = Out3
                     Call AssignEnd
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If
   Strng = "<illegal LEFT$ function call>"
   Error 163
End Sub

Sub AssignRightString
   Out2 = Mid$(Out2, 6)
   If Len(Out2) Then
      Begin = 0: If Left$(Out2, 2) = "$(" Then Begin = True
      Out2 = LTrim$(Out2)
      Out2 = Mid$(Out2, 3)
      V$ = UCase$(Left$(Out2, 1))
      If V$ >= "A" And V$ <= "Z" And Begin Then
         X$ = UCase$(Mid$(Out2, 2, 1))
         If X$ >= "0" And X$ <= "9" Then
            V$ = V$ + X$
         End If
         ' multivar assign
         Variable = GetVariable(V$)
         Begin = Len(V$)
         If Mid$(Out2, Begin + 1, 1) = "$" Then
            Out2 = Mid$(Out2, Begin + 3)
            LastToken = False
            TokenIndex = 1
            Call GetToken
            Call Parse1(Temp3#)
            Start = CInt(Temp3#)
            Out2 = Mid$(Out2, TokenIndex)
            Out2 = Strim$(Out2)
            If Left$(Out2, 1) = "=" Then
               Out2 = Mid$(Out2, 2)
               Out2 = Strim$(Out2)
               TokenIndex = 1
               Call GetToken
               Call Parse1(Temp3#)
               Length = Len(Strngs$(Variable)) - Start + 1
               If LastToken = False Then
                  If Start = Len(Out3) Then
                     If Strngs(Variable) = Nul Then
                        Strngs(Variable) = Out3
                        Call AssignEnd
                        Exit Sub
                     End If
                     Mid$(Strngs(Variable), Length, Start) = Out3
                     Call AssignEnd
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If
   Strng = "<illegal RIGHT$ function call>"
   Error 164
End Sub

Rem CIRCLE STEP <x1>,<y1>,<radius>,[<color>],[<start>],[<end>],[<aspect>]
Sub DrawCircleStep
   AllowExtra = True
   Xcoor1 = False
   Xcoor1Set = False
   Ycoor1 = False
   Ycoor1Set = False
   Radius = False
   RadiusSet = False
   ColorCode = False
   ColorSet = False
   StartCircle = False
   StartSet = False
   EndCircle = False
   EndSet = False
   Aspect = False
   AspectSet = False
   Out2 = Mid$(Out2, 12)
   Out2 = Strim$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken = 3 Then
      Xcoor1Set = False
   Else
      Xcoor1Set = True
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken = 3 Then
         Ycoor1Set = False
      Else
         Ycoor1Set = True
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Radius = CInt(Temp3#)
         If LastToken = 3 Then
            RadiusSet = False
         Else
            RadiusSet = True
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            ColorCode = CInt(Temp3#)
            If LastToken = 3 Then
               ColorSet = False
            Else
               ColorSet = True
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               StartCircle = CInt(Temp3#)
               If LastToken = 3 Then
                  StartSet = False
               Else
                  StartSet = True
               End If
               If Strng = "," Or Strng = ";" Then
                  LastToken = False
                  Out3 = Nul
                  Call GetToken
                  Call Parse1(Temp3#)
                  EndCircle = CInt(Temp3#)
                  If LastToken = 3 Then
                     EndSet = False
                  Else
                     EndSet = True
                  End If
                  If Strng = "," Or Strng = ";" Then
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     Call Parse1(Temp3#)
                     Aspect = CInt(Temp3#)
                     If LastToken = 3 Then
                        AspectSet = False
                     Else
                        AspectSet = True
                     End If
                     If Strng <> Nul Then
                        Error 39
                     End If
                  End If
               End If
            End If
         End If
         If Xcoor1Set And Ycoor1Set And RadiusSet Then
            If StartSet And EndSet Then
               If ColorSet Then
                  If AspectSet Then
                     Circle Step(Xcoor1, Ycoor1), Radius, ColorCode, StartCircle, EndCircle, Aspect%
                  Else
                     Circle Step(Xcoor1, Ycoor1), Radius, ColorCode, StartCircle, EndCircle
                  End If
               Else
                  If AspectSet Then
                     Circle Step(Xcoor1, Ycoor1), Radius, , StartCircle, EndCircle, Aspect
                  Else
                     Circle Step(Xcoor1, Ycoor1), Radius, , StartCircle, EndCircle
                  End If
               End If
            Else
               If StartSet Or EndSet Then
                  Error 39
               Else
                  If ColorSet Then
                     If AspectSet Then
                        Circle Step(Xcoor1, Ycoor1), Radius, ColorCode, , , Aspect
                     Else
                        Circle Step(Xcoor1, Ycoor1), Radius, ColorCode
                     End If
                  Else
                     If AspectSet Then
                        Circle Step(Xcoor1, Ycoor1), Radius, , , , Aspect
                     Else
                        Circle Step(Xcoor1, Ycoor1), Radius
                     End If
                  End If
               End If
            End If
            Exit Sub
         End If
      End If
   End If
   Error 39
End Sub

Rem CIRCLE <x1>,<y1>,<radius>,[<color>],[<start>],[<end>],[<aspect>]
Sub DrawCircle
   AllowExtra = True
   Xcoor1 = False
   Xcoor1Set = False
   Ycoor1 = False
   Ycoor1Set = False
   Radius = False
   RadiusSet = False
   ColorCode = False
   ColorSet = False
   StartCircle = False
   StartSet = False
   EndCircle = False
   EndSet = False
   Aspect = False
   AspectSet = False
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken = 3 Then
      Xcoor1Set = False
   Else
      Xcoor1Set = True
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken = 3 Then
         Ycoor1Set = False
      Else
         Ycoor1Set = True
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Radius = CInt(Temp3#)
         If LastToken = 3 Then
            RadiusSet = False
         Else
            RadiusSet = True
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            ColorCode = CInt(Temp3#)
            If LastToken = 3 Then
               ColorSet = False
            Else
               ColorSet = True
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               StartCircle = CInt(Temp3#)
               If LastToken = 3 Then
                  StartSet = False
               Else
                  StartSet = True
               End If
               If Strng = "," Or Strng = ";" Then
                  LastToken = False
                  Out3 = Nul
                  Call GetToken
                  Call Parse1(Temp3#)
                  EndCircle = CInt(Temp3#)
                  If LastToken = 3 Then
                     EndSet = False
                  Else
                     EndSet = True
                  End If
                  If Strng = "," Or Strng = ";" Then
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     Call Parse1(Temp3#)
                     Aspect = CInt(Temp3#)
                     If LastToken = 3 Then
                        AspectSet = False
                     Else
                        AspectSet = True
                     End If
                     If Strng <> Nul Then
                        Error 39
                     End If
                  End If
               End If
            End If
         End If
         If Xcoor1Set And Ycoor1Set And RadiusSet Then
            If StartSet And EndSet Then
               If ColorSet Then
                  If AspectSet Then
                     Circle (Xcoor1, Ycoor1), Radius, ColorCode, StartCircle, EndCircle, Aspect%
                  Else
                     Circle (Xcoor1, Ycoor1), Radius, ColorCode, StartCircle, EndCircle
                  End If
               Else
                  If AspectSet Then
                     Circle (Xcoor1, Ycoor1), Radius, , StartCircle, EndCircle, Aspect
                  Else
                     Circle (Xcoor1, Ycoor1), Radius, , StartCircle, EndCircle
                  End If
               End If
            Else
               If StartSet Or EndSet Then
                  Error 39
               Else
                  If ColorSet Then
                     If AspectSet Then
                        Circle (Xcoor1, Ycoor1), Radius, ColorCode, , , Aspect
                     Else
                        Circle (Xcoor1, Ycoor1), Radius, ColorCode
                     End If
                  Else
                     If AspectSet Then
                        Circle (Xcoor1, Ycoor1), Radius, , , , Aspect
                     Else
                        Circle (Xcoor1, Ycoor1), Radius
                     End If
                  End If
               End If
            End If
            Exit Sub
         End If
      End If
   End If
   Error 39
End Sub

Rem LINE STEP <x1>,<y1>, [STEP] <x2>,<y2>,[<color>],[<box>],[<style>]
Sub DrawLineStep
   AllowExtra = True
   Xcoor1 = False
   Xcoor1Set = False
   Ycoor1 = False
   Ycoor1Set = False
   Xcoor2 = False
   Xcoor2Set = False
   Ycoor2 = False
   Ycoor2Set = False
   ColorCode = False
   ColorSet = False
   BoxSet = False
   FilledSet = False
   Style = False
   StyleSet = False
   StepSet = False
   Out2 = Mid$(Out2, 10)
   Out2 = Xtrim$(Out2, False)
   Out2 = UCase$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken = 3 Then
      Xcoor1Set = False
   Else
      Xcoor1Set = True
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken = 3 Then
         Ycoor1Set = False
      Else
         Ycoor1Set = True
      End If
      If Strng = "," Or Strng = ";" Then
         Temp1$ = Mid$(Out2, TokenIndex)
         If Left$(Temp1$, 4) = "STEP" Then
            StepSet = True
            TokenIndex = TokenIndex + 4
         End If
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If LastToken = 3 Then
            Xcoor2Set = False
         Else
            Xcoor2Set = True
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            If LastToken = 3 Then
               Ycoor2Set = False
            Else
               Ycoor2Set = True
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               ColorCode = CInt(Temp3#)
               If LastToken = 3 Then
                  ColorSet = False
               Else
                  ColorSet = True
               End If
               If Strng = "," Or Strng = ";" Then
                  If Mid$(Out2, TokenIndex, 1) = "," Then
                     Call GetToken
                     Call Parse1(Temp3#)
                  Else
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     Call Parse1(Temp3#)
                     If LastToken = 3 Then
                        Error 28
                     End If
                     Select Case Out3
                        Case "FB"
                           BoxSet = True
                           FilledSet = True
                        Case "B"
                           BoxSet = True
                        Case Else
                           Error 28
                     End Select
                  End If
                  If Strng = "," Or Strng = ";" Then
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     If TokenIndex < Len(Out2) Then
                        Call Parse1(Temp3#)
                        If LastToken = False Then
                           Error 28
                        End If
                        Style = CInt(Temp3#)
                        StyleSet = True
                        If Strng <> Nul Then
                           Error 28
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
      If Xcoor1Set = False Or Ycoor1Set = False Then
         Error 28
      End If
      If Xcoor2Set = False Or Ycoor2Set = False Then
         Error 28
      End If
      If StepSet = False Then
         If BoxSet And FilledSet Then
            If ColorSet And StyleSet Then
               Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BF , Style
            Else
               If ColorSet Then
                  Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BF
               Else
                  If StyleSet Then
                     Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF , Style
                  Else
                     Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF
                  End If
               End If
            End If
         Else
            If BoxSet Then
               If ColorSet And StyleSet Then
                  Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, B , Style
               Else
                  If ColorSet Then
                     Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, B
                  Else
                     If StyleSet Then
                        Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B , Style
                     Else
                        Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B
                     End If
                  End If
               End If
            Else
               If ColorSet And StyleSet Then
                  Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, , Style
               Else
                  If ColorSet Then
                     Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode
                  Else
                     If StyleSet Then
                        Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , , Style
                     Else
                        Line Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
                     End If
                  End If
               End If
            End If
         End If
      Else
         If BoxSet And FilledSet Then
            If ColorSet And StyleSet Then
               Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, BF , Style
            Else
               If ColorSet Then
                  Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, BF
               Else
                  If StyleSet Then
                     Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , BF , Style
                  Else
                     Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , BF
                  End If
               End If
            End If
         Else
            If BoxSet Then
               If ColorSet And StyleSet Then
                  Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, B , Style
               Else
                  If ColorSet Then
                     Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, B
                  Else
                     If StyleSet Then
                        Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , B , Style
                     Else
                        Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , B
                     End If
                  End If
               End If
            Else
               If ColorSet And StyleSet Then
                  Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, , Style
               Else
                  If ColorSet Then
                     Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode
                  Else
                     If StyleSet Then
                        Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , , Style
                     Else
                        Line Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2)
                     End If
                  End If
               End If
            End If
         End If
      End If
      Exit Sub
   End If
   Error 28
End Sub

Rem LINE <x1>,<y1>, [STEP] <x2>,<y2>,[<color>],[<box>],[<style>]
Sub DrawLine
   AllowExtra = True
   Xcoor1 = False
   Xcoor1Set = False
   Ycoor1 = False
   Ycoor1Set = False
   Xcoor2 = False
   Xcoor2Set = False
   Ycoor2 = False
   Ycoor2Set = False
   ColorCode = False
   ColorSet = False
   BoxSet = False
   FilledSet = False
   Style = False
   StyleSet = False
   StepSet = False
   Out2 = Mid$(Out2, 5)
   Out2 = Xtrim$(Out2, False)
   Out2 = UCase$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken = 3 Then
      Xcoor1Set = False
   Else
      Xcoor1Set = True
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken = 3 Then
         Ycoor1Set = False
      Else
         Ycoor1Set = True
      End If
      If Strng = "," Or Strng = ";" Then
         Temp1$ = Mid$(Out2, TokenIndex)
         If Left$(Temp1$, 4) = "STEP" Then
            StepSet = True
            TokenIndex = TokenIndex + 4
         End If
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If LastToken = 3 Then
            Xcoor2Set = False
         Else
            Xcoor2Set = True
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            If LastToken = 3 Then
               Ycoor2Set = False
            Else
               Ycoor2Set = True
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               ColorCode = CInt(Temp3#)
               If LastToken = 3 Then
                  ColorSet = False
               Else
                  ColorSet = True
               End If
               If Strng = "," Or Strng = ";" Then
                  If Mid$(Out2, TokenIndex, 1) = "," Then
                     Call GetToken
                     Call Parse1(Temp3#)
                  Else
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     Call Parse1(Temp3#)
                     If LastToken = 3 Then
                        Error 28
                     End If
                     Select Case Out3
                        Case "FB"
                           BoxSet = True
                           FilledSet = True
                        Case "B"
                           BoxSet = True
                        Case Else
                           Error 28
                     End Select
                  End If
                  If Strng = "," Or Strng = ";" Then
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     If TokenIndex < Len(Out2) Then
                        Call Parse1(Temp3#)
                        If LastToken = False Then
                           Error 28
                        End If
                        Style = CInt(Temp3#)
                        StyleSet = True
                        If Strng <> Nul Then
                           Error 28
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
      If Xcoor2Set = False Or Ycoor2Set = False Then
         Error 28
      End If
      If StepSet = False Then
         If Xcoor1Set And Ycoor1Set Then
            If BoxSet And FilledSet Then
               If ColorSet And StyleSet Then
                  Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BF , Style
               Else
                  If ColorSet Then
                     Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BF
                  Else
                     If StyleSet Then
                        Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF , Style
                     Else
                        Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF
                     End If
                  End If
               End If
            Else
               If BoxSet Then
                  If ColorSet And StyleSet Then
                     Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, B , Style
                  Else
                     If ColorSet Then
                        Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, B
                     Else
                        If StyleSet Then
                           Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B , Style
                        Else
                           Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B
                        End If
                     End If
                  End If
               Else
                  If ColorSet And StyleSet Then
                     Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, , Style
                  Else
                     If ColorSet Then
                        Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode
                     Else
                        If StyleSet Then
                           Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , , Style
                        Else
                           Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
                        End If
                     End If
                  End If
               End If
            End If
         Else
            If BoxSet And FilledSet Then
               If ColorSet And StyleSet Then
                  Line -(Xcoor2, Ycoor2), ColorCode, BF , Style
               Else
                  If ColorSet Then
                     Line -(Xcoor2, Ycoor2), ColorCode, BF
                  Else
                     If StyleSet Then
                        Line -(Xcoor2, Ycoor2), , BF , Style
                     Else
                        Line -(Xcoor2, Ycoor2), , BF
                     End If
                  End If
               End If
            Else
               If BoxSet Then
                  If ColorSet And StyleSet Then
                     Line -(Xcoor2, Ycoor2), ColorCode, B , Style
                  Else
                     If ColorSet Then
                        Line -(Xcoor2, Ycoor2), ColorCode, B
                     Else
                        If StyleSet Then
                           Line -(Xcoor2, Ycoor2), , B , Style
                        Else
                           Line -(Xcoor2, Ycoor2), , B
                        End If
                     End If
                  End If
               Else
                  If ColorSet And StyleSet Then
                     Line -(Xcoor2, Ycoor2), ColorCode, , Style
                  Else
                     If ColorSet Then
                        Line -(Xcoor2, Ycoor2), ColorCode
                     Else
                        If StyleSet Then
                           Line -(Xcoor2, Ycoor2), , , Style
                        Else
                           Line -(Xcoor2, Ycoor2)
                        End If
                     End If
                  End If
               End If
            End If
         End If
      Else
         If Xcoor1Set And Ycoor1Set Then
            If BoxSet And FilledSet Then
               If ColorSet And StyleSet Then
                  Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, BF , Style
               Else
                  If ColorSet Then
                     Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, BF
                  Else
                     If StyleSet Then
                        Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , BF , Style
                     Else
                        Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , BF
                     End If
                  End If
               End If
            Else
               If BoxSet Then
                  If ColorSet And StyleSet Then
                     Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, B , Style
                  Else
                     If ColorSet Then
                        Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, B
                     Else
                        If StyleSet Then
                           Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , B , Style
                        Else
                           Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , B
                        End If
                     End If
                  End If
               Else
                  If ColorSet And StyleSet Then
                     Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode, , Style
                  Else
                     If ColorSet Then
                        Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), ColorCode
                     Else
                        If StyleSet Then
                           Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), , , Style
                        Else
                           Line (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2)
                        End If
                     End If
                  End If
               End If
            End If
         Else
            If BoxSet And FilledSet Then
               If ColorSet And StyleSet Then
                  Line -Step(Xcoor2, Ycoor2), ColorCode, BF , Style
               Else
                  If ColorSet Then
                     Line -Step(Xcoor2, Ycoor2), ColorCode, BF
                  Else
                     If StyleSet Then
                        Line -Step(Xcoor2, Ycoor2), , BF , Style
                     Else
                        Line -Step(Xcoor2, Ycoor2), , BF
                     End If
                  End If
               End If
            Else
               If BoxSet Then
                  If ColorSet And StyleSet Then
                     Line -Step(Xcoor2, Ycoor2), ColorCode, B , Style
                  Else
                     If ColorSet Then
                        Line -Step(Xcoor2, Ycoor2), ColorCode, B
                     Else
                        If StyleSet Then
                           Line -Step(Xcoor2, Ycoor2), , B , Style
                        Else
                           Line -Step(Xcoor2, Ycoor2), , B
                        End If
                     End If
                  End If
               Else
                  If ColorSet And StyleSet Then
                     Line -Step(Xcoor2, Ycoor2), ColorCode, , Style
                  Else
                     If ColorSet Then
                        Line -Step(Xcoor2, Ycoor2), ColorCode
                     Else
                        If StyleSet Then
                           Line -Step(Xcoor2, Ycoor2), , , Style
                        Else
                           Line -Step(Xcoor2, Ycoor2)
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
      Exit Sub
   End If
   Error 28
End Sub

Rem TRIANGLE <x1>,<y1>,<x2>,<y2>,<x3>,<y3>,<color>
Sub DrawTriangle
   AllowExtra = True
   Xcoor1 = False
   Ycoor1 = False
   Xcoor2 = False
   Ycoor2 = False
   Xcoor3 = False
   Ycoor3 = False
   ColorCode = False
   Out2 = Mid$(Out2, 9)
   Out2 = Xtrim$(Out2, False)
   Out2 = UCase$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken = 3 Then
      Error 168
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken = 3 Then
         Error 168
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If LastToken = 3 Then
            Error 168
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            If LastToken = 3 Then
               Error 168
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               Xcoor3 = CInt(Temp3#)
               If LastToken = 3 Then
                  Error 168
               End If
               If Strng = "," Or Strng = ";" Then
                  LastToken = False
                  Out3 = Nul
                  Call GetToken
                  Call Parse1(Temp3#)
                  Ycoor3 = CInt(Temp3#)
                  If LastToken = 3 Then
                     Error 168
                  End If
                  If Strng = "," Or Strng = ";" Then
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     Call Parse1(Temp3#)
                     ColorCode = CInt(Temp3#)
                     If LastToken = 3 Then
                        Error 168
                     End If
                     If Strng <> Nul Then
                        Error 168
                     End If
                     ' make triangle
                     Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode
                     Line (Xcoor2, Ycoor2)-(Xcoor3, Ycoor3), ColorCode
                     Line (Xcoor3, Ycoor3)-(Xcoor1, Ycoor1), ColorCode
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If
   Error 168
End Sub

Rem SQUARE <x1>,<y1>,<x2>,<y2>,<x3>,<y3>,<x4>,<y4>,<color>
Sub DrawSquare
   AllowExtra = True
   Xcoor1 = False
   Ycoor1 = False
   Xcoor2 = False
   Ycoor2 = False
   Xcoor3 = False
   Ycoor3 = False
   Xcoor4 = False
   Ycoor4 = False
   ColorCode = False
   Out2 = Mid$(Out2, 7)
   Out2 = Xtrim$(Out2, False)
   Out2 = UCase$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken = 3 Then
      Error 171
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken = 3 Then
         Error 171
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If LastToken = 3 Then
            Error 171
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            If LastToken = 3 Then
               Error 171
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               Xcoor3 = CInt(Temp3#)
               If LastToken = 3 Then
                  Error 171
               End If
               If Strng = "," Or Strng = ";" Then
                  LastToken = False
                  Out3 = Nul
                  Call GetToken
                  Call Parse1(Temp3#)
                  Ycoor3 = CInt(Temp3#)
                  If LastToken = 3 Then
                     Error 171
                  End If
                  If Strng = "," Or Strng = ";" Then
                     LastToken = False
                     Out3 = Nul
                     Call GetToken
                     Call Parse1(Temp3#)
                     Xcoor4 = CInt(Temp3#)
                     If LastToken = 3 Then
                        Error 171
                     End If
                     If Strng = "," Or Strng = ";" Then
                        LastToken = False
                        Out3 = Nul
                        Call GetToken
                        Call Parse1(Temp3#)
                        Ycoor4 = CInt(Temp3#)
                        If LastToken = 3 Then
                           Error 171
                        End If
                        If Strng = "," Or Strng = ";" Then
                           LastToken = False
                           Out3 = Nul
                           Call GetToken
                           Call Parse1(Temp3#)
                           ColorCode = CInt(Temp3#)
                           If LastToken = 3 Then
                              Error 171
                           End If
                           If Strng <> Nul Then
                              Error 171
                           End If
                           ' make square
                           Line (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode
                           Line (Xcoor2, Ycoor2)-(Xcoor3, Ycoor3), ColorCode
                           Line (Xcoor3, Ycoor3)-(Xcoor4, Ycoor4), ColorCode
                           Line (Xcoor4, Ycoor4)-(Xcoor1, Ycoor1), ColorCode
                           Exit Sub
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Error 171
End Sub

Rem DrawPolygon <x1>,<y1>,<r>,<n>,<a>,<c>
Sub DrawPolygon
   AllowExtra = True
   Out2 = Mid$(Out2, 8)
   Out2 = Xtrim$(Out2, False)
   Out2 = UCase$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   xc = CInt(Temp3#)
   If LastToken = 3 Then
      Error 169
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      yc = CInt(Temp3#)
      If LastToken = 3 Then
         Error 169
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         r = CInt(Temp3#)
         If LastToken = 3 Then
            Error 169
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            n = CInt(Temp3#)
            If LastToken = 3 Then
               Error 169
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               a = CInt(Temp3#)
               If LastToken = 3 Then
                  Error 169
               End If
               If Strng = "," Or Strng = ";" Then
                  LastToken = False
                  Out3 = Nul
                  Call GetToken
                  Call Parse1(Temp3#)
                  c = CInt(Temp3#)
                  If LastToken = 3 Then
                     Error 169
                  End If
                  If Strng <> Nul Then
                     Error 169
                  End If
                  ' make polygon
                  If n >= 3 And n <= 30 Then
                     x1 = xc + r * Cos(PI2 * a)
                     y1 = yc + r * Sin(PI2 * a)
                     Line (x1, y1)-(x1, y1), c
                     For i = 0 To n
                        a = a + 180 / n
                        x1 = xc + r * Cos(PI2 * a)
                        y1 = yc + r * Sin(PI2 * a)
                        Line Step(0, 0)-(x1, y1), c
                     Next
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If
   Error 169
End Sub

Sub GetGraphics
   Select Case ScreenMode
      Case 1
         PlaneBits = 2
         Planes = 1
      Case 2, 11
         PlaneBits = 1
         Planes = 1
      Case 7, 8, 9, 12
         PlaneBits = 1
         Planes = 4
      Case 10
         PlaneBits = 1
         Planes = 2
      Case 13
         PlaneBits = 8
         Planes = 1
      Case Else
         Error 49
   End Select
   Xcoor1 = False
   Ycoor1 = False
   Xcoor2 = False
   Ycoor2 = False
   Out2 = Mid$(Out2, 4)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Temp1$ = UCase$(Mid$(Out2, TokenIndex))
         If Left$(Temp1$, 4) = "STEP" Then
            StepSet = True
            TokenIndex = TokenIndex + 4
         End If
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            ArraySize = 4 + Int(((Xcoor2 - Xcoor1 + 1) * (PlaneBits) + 7) / 8) * Planes * ((Ycoor2 - Ycoor1) + 1)
            Elements = Int((ArraySize + 1) / 2)
            ReDim GraphicsScreen(1 To Elements) As Integer
            If StepSet Then
               Get (Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), GraphicsScreen()
            Else
               Get (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), GraphicsScreen()
            End If
            Exit Sub
         End If
      End If
   End If
   Error 49
End Sub

Sub GetGraphicsStep
   Select Case ScreenMode
      Case 1
         PlaneBits = 2
         Planes = 1
      Case 2, 11
         PlaneBits = 1
         Planes = 1
      Case 7, 8, 9, 12
         PlaneBits = 1
         Planes = 4
      Case 10
         PlaneBits = 1
         Planes = 2
      Case 13
         PlaneBits = 8
         Planes = 1
      Case Else
         Error 49
   End Select
   Xcoor1 = False
   Ycoor1 = False
   Xcoor2 = False
   Ycoor2 = False
   Out2 = Mid$(Out2, 9)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Temp1$ = UCase$(Mid$(Out2, TokenIndex))
         If Left$(Temp1$, 4) = "STEP" Then
            StepSet = True
            TokenIndex = TokenIndex + 4
         End If
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            ArraySize = 4 + Int(((Xcoor2 - Xcoor1 + 1) * (PlaneBits) + 7) / 8) * Planes * ((Ycoor2 - Ycoor1) + 1)
            Elements = Int((ArraySize + 1) / 2)
            ReDim GraphicsScreen(1 To Elements) As Integer
            If StepSet Then
               Get Step(Xcoor1, Ycoor1)-Step(Xcoor2, Ycoor2), GraphicsScreen()
            Else
               Get Step(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), GraphicsScreen()
            End If
            Exit Sub
         End If
      End If
   End If
   Error 49
End Sub

Sub PutGraphics
   Xcoor1 = False
   Ycoor1 = False
   Out2 = Mid$(Out2, 4)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Temp1$ = Mid$(Out2, TokenIndex)
         Temp1$ = Strim$(Temp1$)
         Temp1$ = UCase$(Temp1$)
         If Left$(Temp1$, 4) = "PSET" Then
            Put (Xcoor1, Ycoor1), GraphicsScreen(), PSet
            Exit Sub
         Else
            If Left$(Temp1$, 6) = "PRESET" Then
               Put (Xcoor1, Ycoor1), GraphicsScreen(), PReset
               Exit Sub
            Else
               If Left$(Temp1$, 3) = "AND" Then
                  Put (Xcoor1, Ycoor1), GraphicsScreen(), And
                  Exit Sub
               Else
                  If Left$(Temp1$, 2) = "OR" Then
                     Put (Xcoor1, Ycoor1), GraphicsScreen(), Or
                     Exit Sub
                  Else
                     If Left$(Temp1$, 3) = "XOR" Then
                        Put (Xcoor1, Ycoor1), GraphicsScreen(), Xor
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      Else
         Put (Xcoor1, Ycoor1), GraphicsScreen()
         Exit Sub
      End If
   End If
   Error 49
End Sub

Sub PutGraphicsStep
   Xcoor1 = False
   Ycoor1 = False
   Out2 = Mid$(Out2, 9)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Temp1$ = Mid$(Out2, TokenIndex)
         Temp1$ = Strim$(Temp1$)
         Temp1$ = UCase$(Temp1$)
         If Left$(Temp1$, 4) = "PSET" Then
            Put Step(Xcoor1, Ycoor1), GraphicsScreen(), PSet
            Exit Sub
         Else
            If Left$(Temp1$, 6) = "PRESET" Then
               Put Step(Xcoor1, Ycoor1), GraphicsScreen(), PReset
               Exit Sub
            Else
               If Left$(Temp1$, 3) = "AND" Then
                  Put Step(Xcoor1, Ycoor1), GraphicsScreen(), And
                  Exit Sub
               Else
                  If Left$(Temp1$, 2) = "OR" Then
                     Put Step(Xcoor1, Ycoor1), GraphicsScreen(), Or
                     Exit Sub
                  Else
                     If Left$(Temp1$, 3) = "XOR" Then
                        Put Step(Xcoor1, Ycoor1), GraphicsScreen(), Xor
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      Else
         Put Step(Xcoor1, Ycoor1), GraphicsScreen()
         Exit Sub
      End If
   End If
   Error 49
End Sub

Sub WindowScreen (Var)
   If Var = 1 Then
      WindowType = True
      Out2 = Mid$(Out2, 14)
      Out2 = Strim$(Out2)
   Else
      WindowType = False
      Out2 = Mid$(Out2, 7)
      Out2 = Strim$(Out2)
   End If
   Xcoor1 = False
   Xcoor2 = False
   Ycoor1 = False
   Ycoor2 = False
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            If WindowType Then
               Window Screen(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
            Else
               Window (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
            End If
            Exit Sub
         End If
      End If
   End If
   Error 78
End Sub

Sub ViewScreen (Var)
   AllowExtra = True
   If Var = 1 Then
      ViewType = True
      Out2 = Mid$(Out2, 12)
      Out2 = Strim$(Out2)
   Else
      ViewType = False
      Out2 = Mid$(Out2, 5)
      Out2 = Strim$(Out2)
   End If
   Xcoor1 = False
   Xcoor2 = False
   Ycoor1 = False
   Ycoor2 = False
   ColorCode = False
   ColorSet = False
   BorderColor = False
   BorderSet = False
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         Xcoor2 = CInt(Temp3#)
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            Ycoor2 = CInt(Temp3#)
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               ColorCode = CInt(Temp3#)
               If LastToken Then
                  ColorSet = True
               End If
               If Strng = "," Or Strng = ";" Then
                  LastToken = False
                  Out3 = Nul
                  Call GetToken
                  Call Parse1(Temp3#)
                  BorderColor = CInt(Temp3#)
                  If LastToken Then
                     BorderSet = True
                  End If
               End If
            End If
            If ViewType Then
               If ColorSet And BorderSet Then
                  View Screen(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BorderColor
               Else
                  If ColorSet Then
                     View Screen(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BorderColor
                  Else
                     If BorderSet Then
                        View Screen(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BorderColor
                     Else
                        View Screen(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
                     End If
                  End If
               End If
            Else
               If ColorSet And BorderSet Then
                  View (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode, BorderColor
               Else
                  If ColorSet Then
                     View (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), ColorCode
                  Else
                     If BorderSet Then
                        View (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BorderColor
                     Else
                        View (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
                     End If
                  End If
               End If
            End If
            Exit Sub
         End If
      End If
   End If
   Error 77
End Sub

Sub PaintArea
   AllowExtra = True
   Xcoor1 = False
   Xcoor1Set = False
   Ycoor1 = False
   Ycoor1Set = False
   PaintType = False
   PaintStyle$ = Nul
   BorderColor = False
   BorderSet = False
   BackGroundStyle$ = Nul
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken Then
      Xcoor1Set = True
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken Then
         Ycoor1Set = True
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         If LastToken = False Then
            PaintType = True
            PaintStyle$ = Out3
         Else
            PaintType = CInt(Temp3#)
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            BorderColor = CInt(Temp3#)
            If LastToken Then
               BorderSet = True
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               BackGroundStyle$ = Out3
            End If
         End If
      End If
      If Xcoor1Set And Ycoor1Set Then
         If PaintType = True Then
            If BorderSet Then
               If Len(BackGroundStyle$) Then
                  Paint (Xcoor1, Ycoor1), PaintStyle$, BorderColor, BackGroundStyle$
               Else
                  Paint (Xcoor1, Ycoor1), PaintStyle$, BorderColor
               End If
            Else
               If Len(BackGroundStyle$) Then
                  Paint (Xcoor1, Ycoor1), PaintStyle$, , BackGroundStyle$
               Else
                  Paint (Xcoor1, Ycoor1), PaintStyle$
               End If
            End If
         Else
            If PaintType > False Then
               If BorderSet Then
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint (Xcoor1, Ycoor1), PaintType, BorderColor
                  End If
               Else
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint (Xcoor1, Ycoor1), PaintType
                  End If
               End If
            Else
               If BorderSet Then
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint (Xcoor1, Ycoor1), , BorderColor
                  End If
               Else
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint (Xcoor1, Ycoor1)
                  End If
               End If
            End If
         End If
         Exit Sub
      End If
   End If
   Error 48
End Sub

Sub PaintAreaStep
   AllowExtra = True
   Xcoor1 = False
   Xcoor1Set = False
   Ycoor1 = False
   Ycoor1Set = False
   PaintType = False
   PaintStyle$ = Nul
   BorderColor = False
   BorderSet = False
   BackGroundStyle$ = Nul
   Out2 = Mid$(Out2, 11)
   Out2 = Strim$(Out2)
   LastToken = False
   Out3 = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Xcoor1 = CInt(Temp3#)
   If LastToken Then
      Xcoor1Set = True
   End If
   If Strng = "," Or Strng = ";" Then
      LastToken = False
      Out3 = Nul
      Call GetToken
      Call Parse1(Temp3#)
      Ycoor1 = CInt(Temp3#)
      If LastToken Then
         Ycoor1Set = True
      End If
      If Strng = "," Or Strng = ";" Then
         LastToken = False
         Out3 = Nul
         Call GetToken
         Call Parse1(Temp3#)
         If LastToken = False Then
            PaintType = True
            PaintStyle$ = Out3
         Else
            PaintType = CInt(Temp3#)
         End If
         If Strng = "," Or Strng = ";" Then
            LastToken = False
            Out3 = Nul
            Call GetToken
            Call Parse1(Temp3#)
            BorderColor = CInt(Temp3#)
            If LastToken Then
               BorderSet = True
            End If
            If Strng = "," Or Strng = ";" Then
               LastToken = False
               Out3 = Nul
               Call GetToken
               Call Parse1(Temp3#)
               BackGroundStyle$ = Out3
            End If
         End If
      End If
      If Xcoor1Set And Ycoor1Set Then
         If PaintType = True Then
            If BorderSet Then
               If Len(BackGroundStyle$) Then
                  Paint Step(Xcoor1, Ycoor1), PaintStyle$, BorderColor, BackGroundStyle$
               Else
                  Paint Step(Xcoor1, Ycoor1), PaintStyle$, BorderColor
               End If
            Else
               If Len(BackGroundStyle$) Then
                  Paint Step(Xcoor1, Ycoor1), PaintStyle$, , BackGroundStyle$
               Else
                  Paint Step(Xcoor1, Ycoor1), PaintStyle$
               End If
            End If
         Else
            If PaintType > False Then
               If BorderSet Then
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint Step(Xcoor1, Ycoor1), PaintType, BorderColor
                  End If
               Else
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint Step(Xcoor1, Ycoor1), PaintType
                  End If
               End If
            Else
               If BorderSet Then
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint Step(Xcoor1, Ycoor1), , BorderColor
                  End If
               Else
                  If Len(BackGroundStyle$) Then
                     Error 48
                     Exit Sub
                  Else
                     Paint Step(Xcoor1, Ycoor1)
                  End If
               End If
            End If
         End If
         Exit Sub
      End If
   End If
   Error 48
End Sub

Sub PrintExpression
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
      Out2 = Out2 + Quote + Quote + ";"
   Else
      LineFeed = False
      Out2 = Out2 + ";" + Quote + Quote
   End If

   PrinterLF = 1
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Print Str$(Temp3#), " ";
               Case 0
                  Print Out3, " ";
               Case Else
                  Print "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Print Str$(Temp3#);
               Case 0
                  Print Out3;
               Case Else
                  Print "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If LineFeed = False Then
      Print
   End If
   PrinterLF = False
   Printing = False
End Sub

Sub PrintExpressionFile
   AllowExtra = True
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Out2 = Mid$(Out2, TokenIndex)
      Out2 = Strim$(Out2)
      LastToken = False
      Out3 = Nul
      Out4 = Nul
      Temp# = False
      TokenIndex = 1

      If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
         LineFeed = True
         Out2 = Out2 + Quote + Quote + ";"
      Else
         LineFeed = False
         Out2 = Out2 + ";" + Quote + Quote
      End If

      Do
         LastToken = False
         Call GetToken
         Call Parse1(Temp3#)
         If ErrorValue Then
            ErrorValue = 0
            Exit Sub
         End If
         Select Case Strng
            Case ","
               Select Case LastToken
                  Case -1
                     Print #FileNum%, Str$(Temp3#), " ";
                  Case 0
                     Print #FileNum%, Out3, " ";
                  Case Else
                     Print #FileNum%, "",
               End Select
            Case ";"
               Select Case LastToken
                  Case -1
                     Print #FileNum%, Str$(Temp3#);
                  Case 0
                     Print #FileNum%, Out3;
                  Case Else
                     Print #FileNum%, "";
               End Select
            Case Else
               If Len(Strng) Then
                  Strng = "<extra token>"
                  Error 92
               End If
               Exit Do
         End Select
         If TokenIndex > Len(Out2) Then
            Exit Do
         End If
      Loop
      If LineFeed = False Then
         Print #FileNum%, CRLF;
      End If
      Exit Sub
   End If
   Error 32
End Sub

Sub LprintExpression
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
      Out2 = Out2 + Quote + Quote + ";"
   Else
      LineFeed = False
      Out2 = Out2 + ";" + Quote + Quote
   End If

   PrinterLF = True
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  LPrint Str$(Temp3#),
               Case 0
                  LPrint Out3,
               Case Else
                  LPrint "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  LPrint Str$(Temp3#);
               Case 0
                  LPrint Out3;
               Case Else
                  LPrint "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If LineFeed = False Then
      LPrint
   End If
   PrinterLF = False
   Printing = False
End Sub

Sub SprintExpression
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
      Out2 = Out2 + Quote + Quote + ";"
   Else
      LineFeed = False
      Out2 = Out2 + ";" + Quote + Quote
   End If

   PrinterLF = 1
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Print Chr$(Temp3#), " ";
               Case 0
                  Print Out3, " ";
               Case Else
                  Print "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Print Chr$(Temp3#);
               Case 0
                  Print Out3;
               Case Else
                  Print "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If LineFeed = False Then
      Print
   End If
   PrinterLF = False
   Printing = False
End Sub

Sub XprintExpression (File, Outpt)
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1
   Out2 = Xtrim$(Out2, True)
   Outpt = True

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
   Else
      LineFeed = False
   End If

   PrinterLF = 1
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      If Strng <> "(" Then
         Strng = "<missing left token>"
         Outpt = 0
         Error 92
         Exit Sub
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Outpt = 0
         Exit Sub
      End If
      Number# = Temp3#
      If LastToken = False Then ' left parameter is string
         Strng = "<left token should be numeric>"
         Outpt = 0
         Error 92
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Strng = Mid$(Out2, TokenIndex, 1)
      TokenIndex = TokenIndex + 1
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Outpt = 0
                  Error 92
               Case 0
                  Print #File, Using Out3; Number#;
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Outpt = 0
                  Error 92
               Case 0
                  Print #File, Using Out3; Number#;
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Outpt = 0
               Error 92
            End If
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Outpt = 0
                  Error 92
               Case 0
                  Print #File, Using Out3; Number#;
            End Select
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      Out2 = Left$(Out2, Len(Out2) - 1)
   End If
   If Right$(Out2, 1) <> ")" Then
      Strng = "<missing right token>"
      Outpt = 0
      Error 92
      Exit Sub
   End If
   PrinterLF = False
   Printing = False
End Sub

' special print function requires:
'    Uprint (<x>,"x"), (<x>,"x"), ...
Sub UprintExpression
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1
   Out2 = Xtrim$(Out2, True)

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
   Else
      LineFeed = False
   End If

   PrinterLF = 1
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      If Strng <> "(" Then
         Strng = "<missing left token>"
         Error 92
         Exit Sub
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Number# = Temp3#
      If LastToken = False Then ' left parameter is string
         Strng = "<left token should be numeric>"
         Error 92
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Strng = Mid$(Out2, TokenIndex, 1)
      TokenIndex = TokenIndex + 1
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  Print Using Out3; Number#;
                  Print , " ";
               Case Else
                  Print "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  Print Using Out3; Number#;
               Case Else
                  Print "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  Print Using Out3; Number#;
               Case Else
                  Print "";
            End Select
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      Out2 = Left$(Out2, Len(Out2) - 1)
   End If
   If Right$(Out2, 1) <> ")" Then
      Strng = "<missing right token>"
      Error 92
      Exit Sub
   End If
   If LineFeed = False Then
      Print
   End If
   PrinterLF = False
   Printing = False
End Sub

'    Dprint (<x$>,"x"), (<x$>,"x"), ...
Sub DprintExpression
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1
   Out2 = Xtrim$(Out2, True)

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
   Else
      LineFeed = False
   End If

   PrinterLF = 1
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      If Strng <> "(" Then
         Strng = "<missing left token>"
         Error 92
         Exit Sub
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Number$ = Out3
      If LastToken = True Then ' left parameter is number
         Strng = "<left token should be string>"
         Error 92
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Strng = Mid$(Out2, TokenIndex, 1)
      TokenIndex = TokenIndex + 1
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  Print Using Out3; Number$;
                  Print , " ";
               Case Else
                  Print "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  Print Using Out3; Number$;
               Case Else
                  Print "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  Print Using Out3; Number$;
               Case Else
                  Print "";
            End Select
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      Out2 = Left$(Out2, Len(Out2) - 1)
   End If
   If Right$(Out2, 1) <> ")" Then
      Strng = "<missing right token>"
      Error 92
      Exit Sub
   End If
   If LineFeed = False Then
      Print
   End If
   PrinterLF = False
   Printing = False
End Sub

Sub LineInputExpression (Var)
   If Var = 1 Then
      AddCursor = False
      Temp1$ = Mid$(Out2, 12)
   Else
      AddCursor = True
      Temp1$ = Mid$(Out2, 11)
   End If
   Temp1$ = Strim$(Temp1$)
   TokenIndex = 1
   Out2 = Temp1$
   LastToken = True
   Quotes = False
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      If Quotes Then
         Print Out3;
         Temp1$ = Mid$(Out2, TokenIndex)
      End If
   End If
   Temp1$ = Strim$(Temp1$)
   Temp1$ = UCase$(Temp1$)
   Select Case Len(Temp1$)
      Case 1 ' A-Z
         If Temp1$ >= "A" And Temp1$ <= "Z" Then
            Variable = Asc(Temp1$) - 64
            Locate , , Visible
            Line Input ; Temp2$
            Variables(Variable) = Val(Temp2$)
         End If
      Case 2 ' A0-A9, A$-Z$
         Temp2$ = Temp1$
         If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
            Temp1$ = Left$(Temp1$, 1)
            If Temp1$ >= "A" And Temp1$ <= "Z" Then
               ' multivar assign
               Variable = GetVariable(Temp2$)
               Locate , , Visible
               Line Input ; Temp3$
               Variables(Variable) = Val(Temp3$)
            End If
         End If
         If Mid$(Temp1$, 2, 1) = "$" Then ' A$-Z$
            Temp1$ = Left$(Temp1$, 1)
            If Temp1$ >= "A" And Temp1$ <= "Z" Then
               Variable = Asc(Temp1$) - 64
               Locate , , Visible
               Line Input ; Temp2$
               Strngs$(Variable) = Temp2$
            End If
         End If
      Case 3 ' A(), A0$
         If Right$(Temp1$, 2) = "()" Then
            Temp1$ = Left$(Temp1$, 1)
            If Temp1$ >= "A" And Temp1$ <= "Z" Then
               Variable = Asc(Temp1$) - 64
               Locate , , Visible
               Line Input ; Temp2$
               For Temp = 1 To Len(Temp2$)
                  V = UBound(Arrays, 2)
                  If Temp > V Then
                     ReDim _Preserve Arrays(1024, Temp) As Double
                  End If
                  Arrays(Variable, Temp) = Asc(Mid$(Temp2$, Temp, 1))
               Next
            End If
         Else
            If Right$(Temp1$, 1) = "$" Then
               Temp1$ = Left$(Temp1$, 2)
               If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
                  If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                     ' multivar assign
                     Variable = GetVariable(Temp1$)
                     Locate , , Visible
                     Line Input ; Temp2$
                     Strngs$(Variable) = Temp2$
                  End If
               End If
            End If
         End If
      Case 4 ' A0(), A(9)
         If Right$(Temp1$, 2) = "()" Then
            Temp1$ = Left$(Temp1$, 2)
            If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
               If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                  ' multivar assign
                  Variable = GetVariable(Temp1$)
                  Locate , , Visible
                  Line Input ; Temp2$
                  For Temp = 1 To Len(Temp2$)
                     V = UBound(Arrays, 2)
                     If Temp > V Then
                        ReDim _Preserve Arrays(1024, Temp) As Double
                     End If
                     Arrays(Variable, Temp) = Asc(Mid$(Temp2$, Temp, 1))
                  Next
               End If
            End If
         Else
            If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
               If Mid$(Temp1$, 2, 1) = "(" And Mid$(Temp1$, 4, 1) = ")" Then
                  Variable = Asc(UCase$(Left$(Temp1$, 1))) - 64
                  Temp = Int(Val(Mid$(Temp1$, 3, 1)))
                  Locate , , Visible
                  Line Input ; Temp2$
                  Arrays(Variable, Temp) = Int(Val(Temp2$))
               End If
            End If
         End If
      Case Else ' A(10), A0(10)
         Out2 = Mid$(Temp1$, 2)
         Temp1$ = Left$(Temp1$, 1)
         If Temp1$ >= "A" And Temp1$ <= "Z" Then
            Variable = Asc(Temp1$) - 64
            Temp3$ = Left$(Out2, 1)
            If Temp3$ >= "0" And Temp3$ <= "9" Then
               Temp4$ = Temp1$ + Temp3$
               ' multivar assign
               Variable = GetVariable(Temp4$)
               Out2 = Mid$(Out2, 2)
            End If
            Call Equate(Temp3#)
            Element = CInt(Temp3#)
            V = UBound(Arrays, 2)
            If Element > V Then
               ReDim _Preserve Arrays(1024, Element) As Double
            End If
            If Element > False Then
               Locate , , Visible
               Line Input ; Temp2$
               Arrays(Variable, Element) = Val(Temp2$)
            Else
               Error 9
            End If
         End If
   End Select
   If AddCursor Then
      Print
   End If
End Sub

Sub LineInputExpFile
   Out2 = Mid$(Out2, 13)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Temp1$ = Mid$(Out2, TokenIndex)
      Temp1$ = Strim$(Temp1$)
      Temp1$ = UCase$(Temp1$)
      Select Case Len(Temp1$)
         Case 1
            If Temp1$ >= "A" And Temp1$ <= "Z" Then
               Variable = Asc(Temp1$) - 64
               Line Input #FileNum%, Temp2$
               If Right$(Temp2$, 1) = LF Then
                  Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
               End If
               If Right$(Temp2$, 1) = CR Then
                  Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
               End If
               Variables(Variable) = Val(Temp2$)
            End If
         Case 2
            Temp2$ = Temp1$
            If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
               Temp1$ = Left$(Temp1$, 1)
               If Temp1$ >= "A" And Temp1$ <= "Z" Then
                  ' multivar assign
                  Variable = GetVariable(Temp2$)
                  Locate , , Visible
                  Line Input #FileNum%, Temp3$
                  If Right$(Temp3$, 1) = LF Then
                     Temp3$ = Left$(Temp3$, Len(Temp3$) - 1)
                  End If
                  If Right$(Temp3$, 1) = CR Then
                     Temp3$ = Left$(Temp3$, Len(Temp3$) - 1)
                  End If
                  Variables(Variable) = Val(Temp3$)
               End If
            End If
            If Mid$(Temp1$, 2, 1) = "$" Then
               Temp1$ = Left$(Temp1$, 1)
               If Temp1$ >= "A" And Temp1$ <= "Z" Then
                  Variable = Asc(Temp1$) - 64
                  Line Input #FileNum%, Temp2$
                  If Right$(Temp2$, 1) = LF Then
                     Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
                  End If
                  If Right$(Temp2$, 1) = CR Then
                     Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
                  End If
                  Strngs$(Variable) = Temp2$
               End If
            End If
         Case 3 ' A(), a0$
            If Right$(Temp1$, 2) = "()" Then
               Temp1$ = Left$(Temp1$, 1)
               If Temp1$ >= "A" And Temp1$ <= "Z" Then
                  Variable = Asc(Temp1$) - 64
                  Line Input #FileNum%, Temp2$
                  If Right$(Temp2$, 1) = LF Then
                     Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
                  End If
                  If Right$(Temp2$, 1) = CR Then
                     Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
                  End If
                  For Temp = 1 To Len(Temp2$)
                     V = UBound(Arrays, 2)
                     If Temp > V Then
                        ReDim _Preserve Arrays(1024, Temp) As Double
                     End If
                     Arrays(Variable, Temp) = Asc(Mid$(Temp2$, Temp, 1))
                  Next
               End If
            Else
               If Right$(Temp1$, 1) = "$" Then
                  Temp1$ = Left$(Temp1$, 2)
                  If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
                     If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                        ' multivar assign
                        Variable = GetVariable(Temp1$)
                        Locate , , Visible
                        Line Input #FileNum%, Temp2$
                        Strngs$(Variable) = Temp2$
                     End If
                  End If
               End If
            End If
         Case 4 ' A0()
            If Right$(Temp1$, 2) = "()" Then
               Temp1$ = Left$(Temp1$, 2)
               If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
                  If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                     ' multivar assign
                     Variable = GetVariable(Temp1$)
                     Line Input #FileNum%, Temp2$
                     For Temp = 1 To Len(Temp2$)
                        V = UBound(Arrays, 2)
                        If Temp > V Then
                           ReDim _Preserve Arrays(1024, Temp) As Double
                        End If
                        Arrays(Variable, Temp) = Asc(Mid$(Temp2$, Temp, 1))
                     Next
                  End If
               End If
            Else
               If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
                  If Mid$(Temp1$, 2, 1) = "(" And Mid$(Temp1$, 4, 1) = ")" Then
                     Variable = Asc(UCase$(Left$(Temp1$, 1))) - 64
                     Temp = Int(Val(Mid$(Temp1$, 3, 1)))
                     Locate , , Visible
                     Line Input #FileNum%, Temp2$
                     Arrays(Variable, Temp) = Int(Val(Temp2$))
                  End If
               End If
            End If
         Case Else
            Out2 = Mid$(Temp1$, 2)
            Temp1$ = Left$(Temp1$, 1)
            If Temp1$ >= "A" And Temp1$ <= "Z" Then
               Variable = Asc(Temp1$) - 64
               Temp3$ = Left$(Out2, 1)
               If Temp3$ >= "0" And Temp3$ <= "9" Then
                  Temp4$ = Temp1$ + Temp3$
                  ' multivar assign
                  Variable = GetVariable(Temp4$)
                  Out2 = Mid$(Out2, 2)
               End If
               Call Equate(Temp3#)
               Element = CInt(Temp3#)
               V = UBound(Arrays, 2)
               If Element > V Then
                  ReDim _Preserve Arrays(1024, Element) As Double
               End If
               If Element > False Then
                  Line Input #FileNum%, Temp2$
                  If Right$(Temp2$, 1) = LF Then
                     Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
                  End If
                  If Right$(Temp2$, 1) = CR Then
                     Temp2$ = Left$(Temp2$, Len(Temp2$) - 1)
                  End If
                  Arrays(Variable, Element) = Val(Temp2$)
               Else
                  Error 9
               End If
            End If
      End Select
      Exit Sub
   End If
   Error 36
End Sub

' fixed: 08/25/2025
Sub InputExpression (Var)
   AllowExtra = 1
   If Var = 1 Then
      AddCursor = False
      Temp1$ = Mid$(Out2, 7)
   Else
      AddCursor = True
      Temp1$ = Mid$(Out2, 6)
   End If
   Temp1$ = Strim$(Temp1$)
   TokenIndex = 1
   Out2 = Temp1$
   LastToken = True
   Quotes = False
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      If Quotes Then
         If Strng = ";" Then
            Print Out3;
         Else
            If Strng = "," Or Strng = ";" Then
               Print Out3; "?";
            End If
         End If
         Out2 = Mid$(Temp1$, TokenIndex)
      Else
         Out2 = Temp1$
         Print "?";
      End If
   Else
      Out2 = Temp1$
      Print "?";
   End If
   Locate , , Visible
   Line Input ; User.Input$
   Stored.Input$ = User.Input$
   StoredTokenIndex = 1
   StoredOut2$ = Strim$(UCase$(Out2))
   BadInput = StoredOut2$
   Do
      TokenIndex = StoredTokenIndex
      Out2 = StoredOut2$
      If Mid$(Out2, TokenIndex + 1, 1) = " " Then
         Out2 = Left$(Out2, TokenIndex) + Mid$(Out2, TokenIndex + 2)
      End If
      LastToken = False
      Call GetToken
      StoredTokenIndex = TokenIndex
      StoredOut2$ = Out2
      Temp1$ = Strim$(Strng)
      If Left$(Temp1$, 1) >= "A" And Left$(Temp1$, 1) <= "Z" Then
         Variable = Asc(Left$(Temp1$, 1)) - 64
         Out2 = Stored.Input$
         LastToken = False
         TokenIndex = 1
         Temp3# = Dfalse
         Do
            Call GetToken
            LastTokenType = Token
            If Token = 1 Then
               If Strng = "," Or Strng = ";" Then
                  LastTokenType = PrevTokenType
                  Out3 = Left$(Out2, TokenIndex - 2)
                  Exit Do
               End If
            End If
            If TokenIndex > Len(Out2) Then
               Out3 = Out2
               Exit Do
            End If
            PrevTokenType = LastTokenType
         Loop
         Temp3# = Val(Out3)
         If Stored.Input$ = Nul Then
            Error 136
         End If
         Stored.Input$ = Mid$(Out2, TokenIndex)
         TokenIndex = StoredTokenIndex
         Out2 = StoredOut2$
         Select Case Len(Temp1$)
            Case 1 ' A-Z, A()-Z()
               Out2 = Strim$(Out2)
               If Mid$(Out2, TokenIndex, 1) = "(" Then
                  Call GetToken
                  Call Parse1(Temp4#)
                  StoredTokenIndex = TokenIndex
                  StoredOut2$ = Out2
                  Element = CInt(Temp4#)
                  V = UBound(Arrays, 2)
                  If Element > V Then
                     ReDim _Preserve Arrays(1024, Element) As Double
                  End If
                  If Element > False Then
                     Arrays(Variable, Element) = Temp3#
                     Out2 = Mid$(Out2, TokenIndex)
                     StoredOut2$ = Out2
                     TokenIndex = 1
                     StoredTokenIndex = TokenIndex
                  Else
                     Error 9
                  End If
               Else
                  Variables(Variable) = Temp3#
                  Out2 = Mid$(Out2, TokenIndex + 1)
                  StoredOut2$ = Out2
                  TokenIndex = 1
                  StoredTokenIndex = TokenIndex
               End If
            Case 2 ' a0-a9, a$-z$, a0()-a9()
               Out2 = Xtrim$(Out2, -1): Temp1$ = Xtrim$(Temp1$, -1) ' fix
               If Mid$(Out2, 3, 1) = "(" Then ' a0()-a9()
                  Temp2$ = Left$(Temp1$, 2)
                  If Mid$(Temp2$, 2, 1) >= "0" And Mid$(Temp2$, 2, 1) <= "9" Then
                     ' nul
                  Else
                     Error 134
                  End If
                  ' multivar assign
                  Variable = GetVariable(Temp2$)
                  Call GetToken
                  Call Parse1(Temp4#)
                  StoredTokenIndex = TokenIndex
                  StoredOut2$ = Out2
                  Element = CInt(Temp4#)
                  V = UBound(Arrays, 2)
                  If Element > V Then
                     ReDim _Preserve Arrays(1024, Element) As Double
                  End If
                  If Element > False Then
                     If LastTokenType = 2 Then
                        Arrays(Variable, Element) = Temp3#
                     Else
                        Error 134
                     End If
                  Else
                     Error 9
                  End If
                  Out2 = Mid$(Out2, TokenIndex)
                  StoredOut2$ = Out2
                  TokenIndex = 1
                  StoredTokenIndex = TokenIndex
               Else ' a0-a9
                  Temp2$ = Temp1$
                  If Mid$(Temp2$, 2, 1) >= "0" And Mid$(Temp2$, 2, 1) <= "9" Then
                     Temp3$ = Left$(Temp2$, 1)
                     If Temp3$ >= "A" And Temp3$ <= "Z" Then
                        ' multivar assign
                        Variable = GetVariable(Temp2$)
                        Variables(Variable) = Val(Out3)
                        Out2 = Mid$(Out2, TokenIndex + 1) ' fix
                        StoredOut2$ = Out2
                        TokenIndex = 1
                        StoredTokenIndex = TokenIndex
                     End If
                  Else ' a$-z$
                     If Mid$(Temp2$, 2, 1) = "$" Then
                        Strngs$(Variable) = Out3
                        Out2 = Mid$(Out2, TokenIndex + 1) ' fix
                        StoredOut2$ = Out2
                        TokenIndex = 1
                        StoredTokenIndex = TokenIndex
                     Else
                        Error 134
                     End If
                  End If
               End If
            Case 3 ' a0$ - a9$
               Temp2$ = Strim$(Temp1$)
               If Mid$(Temp1$, 1, 1) >= "A" And Mid$(Temp1$, 1, 1) <= "Z" Then
                  If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                     If Mid$(Temp1$, 3, 1) = "$" Then
                        Temp2$ = Left$(Temp2$, 2)
                        ' multivar assign
                        Variable = GetVariable(Temp2$)
                        Strngs$(Variable) = Out3
                        TokenIndex = TokenIndex + 1 ',x1$
                        StoredTokenIndex = StoredTokenIndex - 1
                        Out2 = Mid$(Out2, 3) ' x0$,x1$
                        StoredOut2$ = Out2
                     Else
                        Error 134
                     End If
                  Else
                     Error 134
                  End If
               End If
            Case Else '  should not happen
               Error 134
         End Select
      Else
         If Temp1$ <> "," Then
            Error 134
         End If
      End If
      If StoredTokenIndex > Len(StoredOut2$) Then
         Exit Do
      End If
   Loop
   ' check extra input
   If Stored.Input$ <> Nul Then
      Error 137
   End If
   ' add return
   If AddCursor Then
      Print
   End If
End Sub

Sub InputExpressionFile
   AllowExtra = 1
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Out2 = Mid$(Out2, TokenIndex)
      Out2 = Strim$(Out2)
      Do
         LastToken = False
         TokenIndex = 1
         Call GetToken
         If Strng = "," Or Strng = ";" Then
            Call GetToken
         End If
         Temp1$ = Strim$(Strng)
         Temp1$ = UCase$(Temp1$)
         If Left$(Temp1$, 1) >= "A" And Left$(Temp1$, 1) <= "Z" Then
            Variable = Asc(Left$(Temp1$, 1)) - 64
            Select Case Len(Temp1$)
               Case 1
                  If Mid$(Out2, TokenIndex, 1) = "(" Then
                     Call GetToken
                     Call Parse1(Temp4#)
                     Element = CInt(Temp4#)
                     Input #FileNum%, Temp3#
                     V = UBound(Arrays, 2)
                     If Element > V Then
                        ReDim _Preserve Arrays(1024, Element) As Double
                     End If
                     If Element > False Then
                        Arrays(Variable, Element) = Temp3#
                     Else
                        Error 9
                     End If
                  Else
                     Input #FileNum, Temp3#
                     Variables(Variable) = Temp3#
                  End If
               Case 2 ' a0-a9, a$-z$, a0()-a9()
                  If Mid$(Out2, 3, 1) = "(" Then ' a0()-a9()
                     Temp2$ = Left$(Temp1$, 2)
                     If Mid$(Temp2$, 2, 1) >= "0" And Mid$(Temp2$, 2, 1) <= "9" Then
                        ' nul
                     Else
                        Error 134
                     End If
                     ' multivar assign
                     Variable = GetVariable(Temp2$)
                     Call GetToken
                     Call Parse1(Temp4#)
                     StoredTokenIndex = TokenIndex
                     StoredOut2$ = Out2
                     Element = CInt(Temp4#)
                     Input #FileNum%, Temp3#
                     V = UBound(Arrays, 2)
                     If Element > V Then
                        ReDim _Preserve Arrays(1024, Element) As Double
                     End If
                     If Element > False Then
                        If LastTokenType = 2 Then
                           Arrays(Variable, Element) = Temp3#
                        Else
                           Error 134
                        End If
                     Else
                        Error 9
                     End If
                     Out2 = Mid$(Out2, TokenIndex)
                     StoredOut2$ = Out2
                     TokenIndex = 1
                     StoredTokenIndex = TokenIndex
                  Else ' a0-a9
                     Temp2$ = Temp1$
                     If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                        Temp1$ = Left$(Temp1$, 1)
                        If Temp1$ >= "A" And Temp1$ <= "Z" Then
                           ' multivar assign
                           Variable = GetVariable(Temp2$)
                           Input #FileNum%, Out3
                           If Left$(Out3, 1) = Quote Then
                              Out3 = Mid$(Out3, 2)
                           End If
                           If Right$(Out3, 1) = Quote Then
                              Out3 = Left$(Out3, Len(Out3) - 1)
                           End If
                           Variables(Variable) = Val(Out3)
                        End If
                     Else ' a$-z$
                        If Mid$(Temp1$, 2, 1) = "$" Then
                           Input #FileNum%, Out3
                           If Left$(Out3, 1) = Quote Then
                              Out3 = Mid$(Out3, 2)
                           End If
                           If Right$(Out3, 1) = Quote Then
                              Out3 = Left$(Out3, Len(Out3) - 1)
                           End If
                           Strngs$(Variable) = Out3
                        Else
                           Error 134
                        End If
                     End If
                  End If
               Case 3 ' a0$ - a9$
                  Temp2$ = Temp1$
                  If Mid$(Temp1$, 3, 1) = "$" Then
                     If Mid$(Temp1$, 2, 1) >= "0" And Mid$(Temp1$, 2, 1) <= "9" Then
                        Temp1$ = Left$(Temp1$, 1)
                        If Temp1$ >= "A" And Temp1$ <= "Z" Then
                           Temp2$ = Left$(Temp2$, 2)
                           ' multivar assign
                           Variable = GetVariable(Temp2$)
                           Input #FileNum%, Out3
                           If Left$(Out3, 1) = Quote Then
                              Out3 = Mid$(Out3, 2)
                           End If
                           If Right$(Out3, 1) = Quote Then
                              Out3 = Left$(Out3, Len(Out3) - 1)
                           End If
                           Strngs$(Variable) = Out3
                        End If
                     Else
                        Error 134
                     End If
                  End If
               Case Else
                  Error 134
            End Select
         Else
            If Temp1$ <> "," Then
               Error 134
            End If
         End If
         If TokenIndex > Len(Out2) Then
            Exit Do
         End If
         Out2 = Mid$(Out2, TokenIndex)
      Loop
      Exit Sub
   End If
   Error 34
End Sub

Sub WriteExpression
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   TokenIndex = 1

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
      Out2 = Left$(Out2, Len(Out2) - 1)
   Else
      LineFeed = False
   End If
   Out2 = Out2 + ","

   PrinterLF = -2
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   Do
      LastToken = False
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Select Case Strng
         Case ",", ";"
            Select Case LastToken
               Case -1
                  Var$ = Strim$(Str$(Temp3#))
                  For Var = 1 To Len(Var$)
                     Print Mid$(Var$, Var, 1);
                  Next
               Case 0
                  Var$ = Quote + Out3 + Quote
                  For Var = 1 To Len(Var$)
                     Print Mid$(Var$, Var, 1);
                  Next
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
      Print ",";
   Loop
   If LineFeed Then
      Print ",";
   End If
   If LineFeed = False Then
      Print
   End If
   PrinterLF = False
   Printing = False
End Sub

Sub WriteExpressionFile
   AllowExtra = True
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Out2 = Mid$(Out2, TokenIndex)
      Out2 = Strim$(Out2)
      LastToken = False
      Out3 = Nul
      Out4 = Nul
      TokenIndex = 1

      If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
         LineFeed = True
         Out2 = Left$(Out2, Len(Out2) - 1)
      Else
         LineFeed = False
      End If
      Out2 = Out2 + ","

      Do
         LastToken = False
         Call GetToken
         Call Parse1(Temp3#)
         If ErrorValue Then
            ErrorValue = 0
            Exit Sub
         End If
         Select Case Strng
            Case ",", ";"
               Select Case LastToken
                  Case -1
                     Var$ = Strim$(Str$(Temp3#))
                     For Var = 1 To Len(Var$)
                        Print #FileNum%, Mid$(Var$, Var, 1);
                     Next
                  Case 0
                     Var$ = Quote + Out3 + Quote
                     For Var = 1 To Len(Var$)
                        Print #FileNum%, Mid$(Var$, Var, 1);
                     Next
               End Select
            Case Else
               If Len(Strng) Then
                  Strng = "<extra token>"
                  Error 92
               End If
               Exit Do
         End Select
         If TokenIndex > Len(Out2) Then
            Exit Do
         End If
         Print #FileNum%, ",";
      Loop
      If LineFeed Then
         Print #FileNum%, ",";
      End If
      If LineFeed = False Then
         Print #FileNum%, CRLF;
      End If
      Exit Sub
   End If
   Error 31
End Sub

Sub ChangeColor
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   Foreground = CInt(Temp4#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      BackGround = CInt(Temp4#)
      Color Foreground, BackGround
      LastColor1 = Foreground
      LastColor2 = BackGround
      Exit Sub
   End If
   Color Foreground
   LastColor1 = Foreground
End Sub

Sub LockFile ' lock #
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   FileNum = CInt(Temp4#)
   If FileNum <= 0% Or FileNum > MaxFiles Then
      Error 177
      Exit Sub
   End If
   If FileTraps(FileNum) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      Filerec& = CInt(Temp4#)
      If Strng = "," Or Strng = ";" Or Strng = "TO" Then
         Call GetToken
         Call Parse1(Temp4#)
         Filerec2& = CInt(Temp4#)
         Lock FileNum, Filerec& To Filerec2&
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = Filerec& Then
                  RecordNumber = Filerec&
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = Filerec2& Then
                  RecordNumber = Filerec2&
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
      Else
         Lock FileNum, Filerec&
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = Filerec& Then
                  RecordNumber = Filerec&
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
      End If
      Exit Sub
   End If
   Lock FileNum
End Sub

Sub UnlockFile ' unlock #
   Out2 = Mid$(Out2, 9)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   FileNum = CInt(Temp4#)
   If FileNum <= 0% Or FileNum > MaxFiles Then
      Error 177
      Exit Sub
   End If
   If FileTraps(FileNum) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      Filerec& = CInt(Temp4#)
      If Strng = "," Or Strng = ";" Or Strng = "TO" Then
         Call GetToken
         Call Parse1(Temp4#)
         Filerec2& = CInt(Temp4#)
         Unlock FileNum, Filerec& To Filerec2&
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = Filerec& Then
                  RecordNumber = Filerec&
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = Filerec2& Then
                  RecordNumber = Filerec2&
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
      Else
         Unlock FileNum, Filerec&
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = Filerec& Then
                  RecordNumber = Filerec&
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
      End If
      Exit Sub
   End If
   Unlock FileNum
End Sub

' special print function requires:
'    Print Using (<x>,"x"), (<x>,"x"), ...
Sub PrintUsing
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1
   Out2 = Mid$(Out2, 12)
   Out2 = Strim$(Out2)
   Out2 = Xtrim$(Out2, True)

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
   Else
      LineFeed = False
   End If

   PrinterLF = 1
   Do
      LastToken = False
      Call GetToken
      If Strng <> "(" Then
         Strng = "<missing left token>"
         Error 92
         Exit Sub
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Number# = Temp3#
      Number$ = Out3
      LastToken2 = LastToken
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Strng = Mid$(Out2, TokenIndex, 1)
      TokenIndex = TokenIndex + 1
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  If LastToken2 = True Then
                     Print Using Out3; Number#;
                  Else
                     Print Using Out3; Number$;
                  End If
                  Print , " ";
               Case Else
                  Print "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  If LastToken2 = True Then
                     Print Using Out3; Number#;
                  Else
                     Print Using Out3; Number$;
                  End If
               Case Else
                  Print "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  If LastToken2 = True Then
                     Print Using Out3; Number#;
                  Else
                     Print Using Out3; Number$;
                  End If
               Case Else
                  Print "";
            End Select
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      Out2 = Left$(Out2, Len(Out2) - 1)
   End If
   If Right$(Out2, 1) <> ")" Then
      Strng = "<missing right token>"
      Error 92
      Exit Sub
   End If
   If LineFeed = False Then
      Print
   End If
   PrinterLF = False
   Printing = False
End Sub

' special lprint function requires:
'    Lprint Using (<x>,"x"), (<x>,"x"), ...
Sub LprintUsing
   AllowExtra = True
   Printing = True
   LastToken = False
   Out3 = Nul
   Out4 = Nul
   Temp# = False
   TokenIndex = 1
   Out2 = Mid$(Out2, 13)
   Out2 = Strim$(Out2)
   Out2 = Xtrim$(Out2, True)

   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      LineFeed = True
   Else
      LineFeed = False
   End If

   PrinterLF = True
   Do
      LastToken = False
      Call GetToken
      If Strng <> "(" Then
         Strng = "<missing left token>"
         Error 92
         Exit Sub
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Number# = Temp3#
      Number$ = Out3
      LastToken2 = LastToken
      Call GetToken
      Call Parse1(Temp3#)
      If ErrorValue Then
         ErrorValue = 0
         Exit Sub
      End If
      Strng = Mid$(Out2, TokenIndex, 1)
      TokenIndex = TokenIndex + 1
      Select Case Strng
         Case ","
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  If LastToken2 = True Then
                     LPrint Using Out3; Number#;
                  Else
                     LPrint Using Out3; Number$;
                  End If
                  LPrint , " ";
               Case Else
                  LPrint "",
            End Select
         Case ";"
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  If LastToken2 = True Then
                     LPrint Using Out3; Number#;
                  Else
                     LPrint Using Out3; Number$;
                  End If
               Case Else
                  LPrint "";
            End Select
         Case Else
            If Len(Strng) Then
               Strng = "<extra token>"
               Error 92
            End If
            Select Case LastToken
               Case -1
                  Strng = "<string error>"
                  Error 92
               Case 0
                  If LastToken2 = True Then
                     LPrint Using Out3; Number#;
                  Else
                     LPrint Using Out3; Number$;
                  End If
               Case Else
                  LPrint "";
            End Select
            Exit Do
      End Select
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
   If Right$(Out2, 1) = ";" Or Right$(Out2, 1) = "," Then
      Out2 = Left$(Out2, Len(Out2) - 1)
   End If
   If Right$(Out2, 1) <> ")" Then
      Strng = "<missing right token>"
      Error 92
      Exit Sub
   End If
   If LineFeed = False Then
      LPrint
   End If
   PrinterLF = False
   Printing = False
End Sub

Sub ChangeScreen
   ' ScreenMode:
   '  0  text mode
   '  1  low resolution
   '  2  high resolution
   '  7 - 13  high resolution ega/vga modes
   AllowExtra = True
   ScreenColor = False
   ColorSet = False
   ActivePage = False
   ActiveSet = False
   VisualPage = False
   VisualSet = False
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   VarX = CInt(Temp4#)
   Select Case VarX
      Case 0, 1, 2, 7 To 13
         ScreenMode = CInt(Temp4#)
      Case Else
         Error 5
         Exit Sub
   End Select
   Timer(t2) Off
   If ScreenMode = False Then
      Call ClearStatusLine
   End If
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      ScreenColor = CInt(Temp4#)
      If LastToken Then
         ColorSet = True
      End If
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp4#)
         ActivePage = CInt(Temp4#)
         If LastToken Then
            ActiveSet = True
         End If
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp4#)
            VisualPage = CInt(Temp4#)
            If LastToken Then
               VisualSet = True
            End If
         End If
      End If
   End If
   If ColorSet And ActiveSet And VisualSet Then
      Screen ScreenMode, ScreenColor, ActivePage, VisualPage
      LastScreen1 = ScreenMode
      LastScreen2 = ScreenColor
      LastScreen3 = ActivePage
      LastScreen4 = VisualPage
   Else
      If ColorSet And ActiveSet Then
         Screen ScreenMode, ScreenColor, ActivePage
         LastScreen1 = ScreenMode
         LastScreen2 = ScreenColor
         LastScreen3 = ActivePage
      Else
         If ColorSet And VisualSet Then
            Screen ScreenMode, ScreenColor, , VisualPage
            LastScreen1 = ScreenMode
            LastScreen2 = ScreenColor
            LastScreen4 = VisualPage
         Else
            If ActiveSet And VisualSet Then
               Screen ScreenMode, , ActivePage, VisualPage
               LastScreen1 = ScreenMode
               LastScreen3 = ActivePage
               LastScreen4 = VisualPage
            Else
               If ColorSet Then
                  Screen ScreenMode, ScreenColor
                  LastScreen1 = ScreenMode
                  LastScreen2 = ScreenColor
               Else
                  If ActiveSet Then
                     Screen ScreenMode, , ActivePage
                     LastScreen1 = ScreenMode
                     LastScreen3 = ActivePage
                  Else
                     If VisualSet Then
                        Screen ScreenMode, , , VisualPage
                        LastScreen1 = ScreenMode
                        LastScreen4 = VisualPage
                     Else
                        Screen ScreenMode
                        LastScreen1 = ScreenMode
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   If ScreenMode = False Then
      Timer(t2) On
   End If
End Sub

Sub CDwidth (Var$)
   If Var$ = Nul Then
      VarS$ = "Enter screen width(40,80)? "
      Var1$ = KeyboardLine4$(VarS$)
      VarS$ = "Enter screen height(25,30,43,50,60)? "
      Var2$ = KeyboardLine4$(VarS$)
   Else
      If InStr(Var$, ",") Then
         Var1$ = Left$(Var$, InStr(Var$, ",") - 1)
         Var2$ = Mid$(Var$, InStr(Var$, ",") + 1)
      End If
   End If

   VarX = Int(Val(Var1$))
   VarY = Int(Val(Var2$))

   If VarX = 40 Or VarX = 80 Then
      If VarY = 25 Or VarY = 30 Or VarY = 43 Or VarY = 50 Or VarY = 60 Then
         Width VarX, VarY
         ScreenWidth = VarX
         ScreenHeight = VarY
         LastWidth1 = ScreenWidth
         LastWidth2 = ScreenHeight
         PageLength = VarY - 2
         Exit Sub
      End If
   End If
   Print "Invalid Width function."
End Sub

Sub ChangeWidth
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   If Left$(Out2, 1) = "#" Then
      Out2 = Mid$(Out2, 2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      FileNumber = CInt(Temp4#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp4#)
         FileWidth = CInt(Temp4#)
         Width #FileNumber, FileWidth
         Exit Sub
      End If
   Else
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken Then
         ScreenWidth = CInt(Temp4#)
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp4#)
            ScreenHeight = CInt(Temp4#)
            Select Case ScreenWidth
               Case 40, 80
                  Select Case ScreenHeight
                     Case 25, 30, 43, 50, 60
                        Width ScreenWidth, ScreenHeight
                        LastWidth1 = ScreenWidth
                        LastWidth2 = ScreenHeight
                        PageLength = ScreenHeight - 2
                        Exit Sub
                  End Select
            End Select
         End If
      Else
         Device$ = Out3
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp4#)
            DeviceWidth = CInt(Temp4#)
            If UCase$(Device$) = "LPRINT" Then
               Width LPrint DeviceWidth
               Exit Sub
            Else
               ' device width not supported
               Error 73
               Exit Sub
            End If
         End If
      End If
   End If
   Error 146
End Sub

Sub SoundSpeaker
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   Tone = CInt(Temp4#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      Duration1 = CInt(Temp4#)
      Sound Tone, Duration1
      Exit Sub
   End If
   Error 147
End Sub

Sub LocateCursor
   AllowExtra = True
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   Xcoor = CsrLin
   Ycoor = Pos(0)
   If Len(Out2) Then
      TokenIndex = 1
      If Mid$(Out2, TokenIndex, 1) = "," Then
         Call GetToken
      Else
         Call GetToken
         Call Parse1(Temp4#)
         Xcoor = CInt(Temp4#)
      End If
      If Strng = "," Or Strng = ";" Then
         If Mid$(Out2, TokenIndex, 1) = "," Then
            Call GetToken
         Else
            Call GetToken
            Call Parse1(Temp4#)
            Ycoor = CInt(Temp4#)
         End If
         If Strng = "," Or Strng = ";" Then
            If Mid$(Out2, TokenIndex, 1) = "," Then
               Call GetToken
            Else
               Call GetToken
               Call Parse1(Temp4#)
               Visible = CInt(Temp4#)
            End If
            If Strng = "," Or Strng = ";" Then
               Call GetToken
               Call Parse1(Temp4#)
               StartScan = CInt(Temp4#)
               EndScan = StartScan
               If Strng = "," Or Strng = ";" Then
                  Call GetToken
                  Call Parse1(Temp4#)
                  EndScan = CInt(Temp4#)
               End If
               Locate Xcoor, Ycoor, Visible, StartScan, EndScan
               LastCursor1 = Visible
               LastCursor2 = StartScan
               LastCursor3 = EndScan
               Exit Sub
            End If
         End If
      End If
   End If
   Locate Xcoor, Ycoor, Visible
   LastCursor1 = Visible
End Sub

Sub CLSScreen
   Out2 = Mid$(Out2, 4)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      '   CLSType = INT(VAL(Out2))
      Select Case Out2
         Case "0"
            Cls 0
         Case "1"
            Cls 1
         Case "2"
            Cls 2
         Case Else
            Error 2
      End Select
      Exit Sub
   End If
   Cls
End Sub

Sub BSaveImage
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   Filename$ = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      Filename$ = DRX + Out3 + ".sc2"
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         Offset = CInt(Temp3#)
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp3#)
            Length = CInt(Temp3#)
            BSave Filename$, Offset, Length
            Exit Sub
         End If
      End If
   End If
   Error 60
End Sub

Sub BLoadImage
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   Filename$ = Nul
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      Filename$ = DRX + Out3 + ".sc2"
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         Offset = CInt(Temp3#)
         BLoad Filename$, Offset
      Else
         BLoad Filename$
      End If
      Exit Sub
   End If
   Error 60
End Sub

Sub DrawPixel
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   X% = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Y% = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         C% = CInt(Temp3#)
         PSet (X%, Y%), C%
         Exit Sub
      Else
         PSet (X%, Y%)
         Exit Sub
      End If
   End If
   Error 15
End Sub

Sub DrawPixelStep
   Out2 = Mid$(Out2, 10)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   X% = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Y% = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         C% = CInt(Temp3#)
         PSet Step(X%, Y%), C%
         Exit Sub
      Else
         PSet Step(X%, Y%)
         Exit Sub
      End If
   End If
   Error 15
End Sub

Sub DrawPixelX
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   X% = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Y% = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         C% = CInt(Temp3#)
         PReset (X%, Y%), C%
         Exit Sub
      Else
         PReset (X%, Y%)
         Exit Sub
      End If
   End If
   Error 15
End Sub

Sub DrawPixelXStep
   Out2 = Mid$(Out2, 12)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   X% = CInt(Temp3#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp3#)
      Y% = CInt(Temp3#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp3#)
         C% = CInt(Temp3#)
         PReset Step(X%, Y%), C%
         Exit Sub
      Else
         PReset Step(X%, Y%)
         Exit Sub
      End If
   End If
   Error 15
End Sub

Sub DrawExpression
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      Draw Out3
      Exit Sub
   End If
   Error 46
End Sub

Sub PlayExpression
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      Play Out3
      Exit Sub
   End If
   Error 47
End Sub

Sub RestoreData
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)

   ' search first data statement
   If Len(Out2) = False Then
      For LineNumber% = 1 To LastLine
         Out2 = Program$(LineNumber%)
         Out2 = Strim$(Out2)
         Out2 = UCase$(Out2)
         If Left$(Out2, 4) = "DATA" Then
            DataLine = LineNumber%
            DataNumber = False
            Exit For
         End If
      Next
      Exit Sub
   End If

   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#) ' allow equation in RESTORE statement!?
   If LastToken = True Then
      LineNumber% = CInt(Temp3#)
      If LineNumber% = True Then ' move back
         If DataLine > False Then
            For V = DataLine - 1 To 1 Step -1
               Out2 = Program$(V)
               Out2 = Strim$(Out2)
               Out2 = UCase$(Out2)
               If Left$(Out2, 4) = "DATA" Then
                  DataLine = V
                  DataNumber = False
                  Exit Sub
               End If
            Next
         End If
         Exit Sub
      End If
      If LineNumber% >= 1 And LineNumber% <= LastLine Then
         Out2 = Program$(LineNumber%)
         Out2 = Strim$(Out2)
         Out2 = UCase$(Out2)
         If Left$(Out2, 4) = "DATA" Then
            DataLine = LineNumber%
            DataNumber = False
            Exit Sub
         End If
      End If
   End If
   Error 65
End Sub

Sub ReadData
   AllowExtra = 1
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Do
      LastToken = False
      Call GetToken
      Temp1$ = Strim$(Strng)
      Temp1$ = UCase$(Temp1$)
      If Left$(Temp1$, 1) >= "A" And Left$(Temp1$, 1) <= "Z" Then
         Variable = Asc(Left$(Temp1$, 1)) - 64
         Select Case Len(Temp1$)
            Case 1
               If Mid$(Out2, TokenIndex, 1) = "(" Then
                  If Mid$(Out2, TokenIndex + 1, 1) = ")" Then
                     Call GetToken
                     Call GetToken
                     Call ReadDataElement(Var)
                     If Var Then
                        Error 66
                     End If
                     If LastToken = False Then
                        For Element = 1 To Len(Out3)
                           V = UBound(Arrays, 2)
                           If Element > V Then
                              ReDim _Preserve Arrays(1024, Element) As Double
                           End If
                           Arrays(Variable, Element) = Asc(Mid$(Out3, Element, 1))
                        Next
                     Else
                        Arrays(Variable, 1) = DataValue
                     End If
                  Else
                     Call GetToken
                     Call Parse1(Temp4#)
                     Element = CInt(Temp4#)
                     Call ReadDataElement(Var)
                     If Var Then
                        Error 66
                     End If
                     If LastToken Then
                        V = UBound(Arrays, 2)
                        If Element > V Then
                           ReDim _Preserve Arrays(1024, Element) As Double
                        End If
                        If Element > False Then
                           Arrays(Variable, Element) = DataValue
                        Else
                           Error 9
                        End If
                     Else
                        If Out3 = Nul Then
                           V = UBound(Arrays, 2)
                           If Element > V Then
                              ReDim _Preserve Arrays(1024, Element) As Double
                           End If
                           If Element > False Then
                              Arrays(Variable, Element) = Dfalse
                           Else
                              Error 9
                           End If
                        Else
                           DataNumber = DataNumber - 1
                           Error 135
                        End If
                     End If
                  End If
               Else
                  Call ReadDataElement(Var)
                  If Var Then
                     Error 66
                  End If
                  If LastToken Then
                     Variables(Variable) = DataValue
                  Else
                     If Out3 = Nul Then
                        Variables(Variable) = Dfalse
                     Else
                        DataNumber = DataNumber - 1
                        Error 135
                     End If
                  End If
               End If
            Case 2
               If Mid$(Temp1$, 2, 1) = "$" Then
                  Call ReadDataElement(Var)
                  If Var Then
                     Error 66
                  End If
                  If LastToken = False Then
                     Strngs$(Variable) = Out3
                  Else
                     Strngs(Variable) = LTrim$(Str$(DataValue))
                  End If
               Else
                  Error 134
               End If
            Case Else
               Error 134
         End Select
      Else
         If Temp1$ = "," Or Temp1$ = ";" Then
            Eat$ = Nul
         Else
            Error 134
         End If
      End If
      If TokenIndex > Len(Out2) Then
         Exit Do
      End If
   Loop
End Sub

Sub ReadRecord
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FieldRead = False
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Temp1$ = Mid$(Out2, TokenIndex)
      Temp1$ = Strim$(Temp1$)
      Temp1$ = UCase$(Temp1$)
      Temp2$ = Left$(Temp1$, 1)
      Temp1$ = Mid$(Temp1$, 2)
      If Temp1$ = "$" Then
         If Temp2$ >= "A" And Temp2$ <= "Z" Then
            Variable = Asc(Temp2$) - 64
            Out2 = FieldArray$(FileNum%)
            Out2 = Strim$(Out2)
            Out2 = UCase$(Out2)
            TokenIndex = 1
            Start% = 1
            Do
               Call GetToken
               Call Parse1(Temp3#)
               Length% = CInt(Temp3#)
               FieldVariable = False
               If Strng = "AS" Then
                  Out2 = Mid$(Out2, TokenIndex + 1)
                  Out2 = Strim$(Out2)
                  If Left$(Out2, 1) >= "A" And Left$(Out2, 1) <= "Z" Then
                     If Mid$(Out2, 2, 1) = "$" Then
                        FieldVariable = Asc(Left$(Out2, 1)) - 64
                        Out2 = Mid$(Out2, 4)
                     End If
                  End If
                  TokenIndex = 1
               End If
               If Strng = "," Or Strng = ";" Then
                  Out2 = Mid$(Out2, TokenIndex + 1)
                  TokenIndex = 1
               End If
               If FieldVariable = Variable Then
                  FieldRead = True
                  Temp$ = Mid$(FileFields$(FileNum%), Start%, Length%)
                  Strngs$(Variable) = Temp$
               End If
               If FieldVariable Then
                  Start% = Start% + Length%
               End If
               If TokenIndex > Len(Out2) Then
                  Exit Do
               End If
            Loop
         End If
      End If
   End If
   If FieldRead = False Then
      Error 45
   End If
End Sub

Sub GetRecord
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      RecordNumber& = CSng(Temp4#)
      If Strng = "," Or Strng = ";" Then
         Temp1$ = Mid$(Out2, TokenIndex)
         Temp1$ = Strim$(Temp1$)
         Temp1$ = UCase$(Temp1$)
         Temp2$ = Left$(Temp1$, 1)
         Temp1$ = Mid$(Temp1$, 2)
         If Left$(Temp1$, 1) = "$" Then
            If Temp2$ >= "A" And Temp2$ <= "Z" Then
               Variable = Asc(Temp2$) - 64
               If RecordNumber& = 0& Then
                  Get #FileNum%, , Strngs$(Variable)
               Else
                  Get #FileNum%, RecordNumber&, Strngs$(Variable)
                  For Z = 1 To RecordCount
                     If FileRecords(Z) > 0& Then
                        If FileRecords(Z) = RecordNumber& Then
                           ControlBreak = -3
                           Exit Sub
                        End If
                     End If
                  Next
               End If
               Exit Sub
            End If
         End If
      Else
         Get #FileNum%, RecordNumber&
         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = RecordNumber& Then
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
         Exit Sub
      End If
   Else
      Get #FileNum%
      Exit Sub
   End If
   Error 44
End Sub

Sub PutRecord
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      RecordNumber& = CSng(Temp4#)
      If RecordNumber& > LOF(FileNum%) + 1 Then
         Error 111
         Exit Sub
      End If
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp4#)
         If LastToken = False Then
            If RecordNumber& = 0& Then
               Put #FileNum%, , Out3
            Else
               Put #FileNum%, RecordNumber&, Out3
               For Z = 1 To RecordCount
                  If FileRecords(Z) > 0& Then
                     If FileRecords(Z) = RecordNumber& Then
                        ControlBreak = -3
                        Exit Sub
                     End If
                  End If
               Next
            End If
         Else
            If RecordNumber& = 0& Then
               Put #FileNum%, , Temp4#
            Else
               Put #FileNum%, RecordNumber&, Temp4#
               For Z = 1 To RecordCount
                  If FileRecords(Z) > 0& Then
                     If FileRecords(Z) = RecordNumber& Then
                        ControlBreak = -3
                        Exit Sub
                     End If
                  End If
               Next
            End If
         End If
         Exit Sub
      Else
         ' fixed: 09/15/2025
         Program.Length = Len(FileFields(FileNum%))
         Record.Length& = (RecordNumber& - 1) * Program.Length + 1

         ' close then reopen for binary
         Close FileNum%
         Open FileFieldNames(FileNum%) For Binary Shared As #FileNum% Len = 1

         'Put #FileNum%, RecordNumber&
         VarQ = 0
         For VarX = Record.Length& To Record.Length& + Program.Length - 1
            VarQ = VarQ + 1
            VarZ$ = Mid$(FileFields(FileNum%), VarQ, 1)
            Put #FileNum%, VarX, VarZ$
         Next

         ' close then reopen original field
         Close FileNum%
         Open FileFieldNames(FileNum%) For Random Shared As #FileNum% Len = Program.Length

         For Z = 1 To RecordCount
            If FileRecords(Z) > 0& Then
               If FileRecords(Z) = RecordNumber& Then
                  ControlBreak = -3
                  Exit Sub
               End If
            End If
         Next
         Exit Sub
      End If
   Else
      Put #FileNum%
      Exit Sub
   End If
   Error 43
End Sub

' rset/lset
Sub FieldSet (Var)
   If Var = 1 Then
      FieldType = 1
   Else
      FieldType = 2
   End If
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FieldSet2 = False
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Temp1$ = Mid$(Out2, TokenIndex)
      Temp1$ = Strim$(Temp1$)
      Temp1$ = UCase$(Temp1$)
      Temp2$ = Left$(Temp1$, 1)
      Temp1$ = Mid$(Temp1$, 2)
      If Left$(Temp1$, 1) = "$" Then
         Temp1$ = Mid$(Temp1$, 2)
         Temp1$ = Strim$(Temp1$)
         If Left$(Temp1$, 1) = "," Then
            If Temp2$ >= "A" And Temp2$ <= "Z" Then
               Variable = Asc(Temp2$) - 64
               Call GetToken
               Call Parse1(Temp4#)
               Call GetToken
               Call Parse1(Temp4#)
               If LastToken = False Then
                  FieldValue$ = Out3
                  Out2 = FieldArray$(FileNum%)
                  Out2 = Strim$(Out2)
                  Out2 = UCase$(Out2)
                  TokenIndex = 1
                  Start% = 1
                  Do
                     Call GetToken
                     Call Parse1(Temp3#)
                     Length% = CInt(Temp3#)
                     FieldVariable = False
                     If Strng = "AS" Then
                        Out2 = Mid$(Out2, TokenIndex + 1)
                        Out2 = Strim$(Out2)
                        If Left$(Out2, 1) >= "A" And Left$(Out2, 1) <= "Z" Then
                           If Mid$(Out2, 2, 1) = "$" Then
                              FieldVariable = Asc(Left$(Out2, 1)) - 64
                              Out2 = Mid$(Out2, 4)
                           End If
                        End If
                        TokenIndex = 1
                     End If
                     If Strng = "," Or Strng = ";" Then
                        Out2 = Mid$(Out2, TokenIndex + 1)
                        TokenIndex = 1
                     End If
                     If FieldVariable = Variable Then
                        FieldSet2 = True
                        Temp$ = String$(Length%, Chr$(0))
                        If FieldType = 1 Then
                           LSet Temp$ = FieldValue$
                        Else
                           RSet Temp$ = FieldValue$
                        End If
                        Mid$(FileFields$(FileNum%), Start%, Length%) = Temp$
                     End If
                     If FieldVariable Then
                        Start% = Start% + Length%
                     End If
                     If TokenIndex > Len(Out2) Then
                        Exit Do
                     End If
                  Loop
               End If
            End If
         End If
      End If
   End If
   If FieldSet2 = False Then
      If FieldType = 1 Then
         Error 41
      Else
         Error 42
      End If
   End If
End Sub

' Field #1, 128 As A$, 128 As B$, ...
' fixed: 09/20/2025
Sub OpenField
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Then
      VarX$ = Mid$(Out2, TokenIndex)
      If Int(Val(VarX$)) <= 0 Then Error 23
      Out2 = UCase$(Mid$(Out2, TokenIndex))
      StoredOut2$ = Strim$(Out2)
      Temp1$ = Xtrim$(Out2, 0)
      Temp3$ = Temp1$
      StartField:
      VarX = InStr(Temp1$, ",")
      If VarX Then
         Temp3$ = Left$(Temp1$, VarX - 1)
         Temp1$ = Mid$(Temp1$, VarX + 1)
      Else
         Temp3$ = Temp1$
         Temp1$ = Nul
      End If
      VarX = InStr(UCase$(Temp3$), "AS")
      If VarX Then
         Temp3$ = Mid$(Temp3$, VarX)
      End If
      If Len(Temp3$) = 4 Then ' AS X$
         If UCase$(Left$(Temp3$, 2)) = "AS" Then
            If Right$(Temp3$, 1) = "$" Then
               If UCase$(Mid$(Temp3$, 3, 1)) >= "A" And UCase$(Mid$(Temp3$, 3, 1)) <= "Z" Then
                  If Len(Temp1$) Then
                     VarX = InStr(UCase$(Temp1$), "AS")
                     If VarX Then
                        VarX$ = Left$(Temp1$, VarX - 1)
                        If Int(Val(VarX$)) <= 0 Then Error 23
                        Temp1$ = Mid$(Temp1$, VarX)
                     End If
                     GoTo StartField
                  End If
                  FieldArray$(FileNum%) = StoredOut2$
                  Exit Sub
               End If
            End If
         End If
      End If
   End If
   Error 23
End Sub

Sub OpenFile
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   FileNum% = CInt(Temp3#)
   If FileNum% <= 0 Or FileNum% > MaxFiles Then
      Error 126
      Exit Sub
   End If
   If FileTraps(FileNum%) Then
      ControlBreak = -2
      Exit Sub
   End If
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = False Then
         ProgramFile$ = Out3
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp4#)
            If LastToken = False Then
               ProgramType$ = Out3
               If Strng = "," Or Strng = ";" Then
                  Call GetToken
                  Call Parse1(Temp4#)
                  Program.Length = CInt(Temp4#)
               Else
                  Program.Length = 128
               End If
               Select Case UCase$(ProgramType$)
                  Case "I" ' input
                     Open ProgramFile$ For Input Shared As #FileNum% Len = Program.Length
                  Case "O", "W" ' output/write
                     Open ProgramFile$ For Output Shared As #FileNum% Len = Program.Length
                  Case "A" ' append
                     Open ProgramFile$ For Append Shared As #FileNum% Len = Program.Length
                  Case "R" ' random
                     Open ProgramFile$ For Random Shared As #FileNum% Len = Program.Length
                     FileFields$(FileNum%) = String$(Program.Length, Chr$(0))
                     Field #FileNum%, Program.Length As FileFields$(FileNum%)
                     FileFieldNames(FileNum%) = ProgramFile$
                  Case "B" ' binary
                     Open ProgramFile$ For Binary Shared As #FileNum% Len = Program.Length
                     FileFields$(FileNum%) = String$(Program.Length, Chr$(0))
                  Case Else
                     Error 21
               End Select
               Exit Sub
            End If
         End If
      End If
   End If
   Error 21
End Sub

Sub CloseFile (Var)
   If Var = 2 Then
      Out2 = Strim$(Out2)
      If UCase$(Out2) = "CLOSE" Then
         Close
         If FileTrap0 Then
            ControlBreak = -2
            Exit Sub
         End If
      Else
         Error 22
      End If
      Exit Sub
   End If
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      Start.Close:
      FileNum% = CInt(Temp3#)
      If FileNum% <= 0 Or FileNum% > MaxFiles Then
         Error 126
         Exit Sub
      End If
      Close #FileNum%
      If FileTraps(FileNum%) Then
         ControlBreak = -2
         Exit Sub
      End If
      If Strng = "TO" Then
         Call GetToken
         Call GetToken
         If Left$(Strng, 1) = "#" Then
            Strng = Mid$(Strng, 2)
         End If
         FileNum2% = Int(Val(Strng))
         For Var% = FileNum% To FileNum2%
            If Var% <= 0 Or Var% > MaxFiles Then
               Error 126
               Exit Sub
            End If
            Close #Var%
            If FileTraps(Var%) Then
               FileNum% = Var%
               ControlBreak = -2
               Exit Sub
            End If
         Next
         Call Parse1(Temp3#)
         GoTo Start.Close
      Else
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call GetToken
            If Left$(Strng, 1) = "#" Then
               Strng = Mid$(Strng, 2)
            End If
            Call Parse1(Temp3#)
            GoTo Start.Close
         End If
      End If
      Exit Sub
   End If
   Error 22
End Sub

Sub ChainProgram
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      ProgramFile$ = Out3
      StartLine = False
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp4#)
         StartLine = CInt(Temp4#) - 1
      End If
      If ProgramFile$ <> Nul Then
         Call Concatenate(ProgramFile$)
         Filename = ProgramFile$
         If _FileExists(Filename) Then
            Recurse2 = Recurse2 + 1
            If Recurse2 > MaxChainRecurse Then
               Strng = "<bad CHAIN recurse>"
               Error 174
            Else
               If _FileExists(PrepareFilename) Then
                  f$ = PrepareFilename + Chr$(0)
                  x = DeleteFileA(f$)
               End If
               Call NewProgram
               ProgramName = None
               Call ReadProgram
               ProgramName = ProgramFile$
               Call PrepareProgram
               NestedGosub = False
               MaxGosubs = 10
               Visible = 1
               ReDim GosubReturn(1 To 10) As Integer
               ProgramLine = StartLine
               Call CountLines(LastLine)
               Exit Sub
            End If
         End If
      End If
   End If
   Error 112
End Sub

Sub RebootFunc
   $If WIN Then
      V$ = "Attempt to reboot(y/n)? "
      Call MorePrompt(V$, "yn", Outpt$)
      If Outpt$ = "y" Then
         S$ = "%windir%\System32\shutdown.exe /r /t 0"
         x$ = "SHELL" + S$
         Call ShellProgram2(S$)
         Print "Reboot failed.."
      Else
         Print "Reboot halted.."
      End If
      Exit Sub
   $End If
   $If LINUX OR MAC Then
      V$ = "Attempt to reboot(y/n)? "
      Call MorePrompt(V$, "yn", Outpt$)
      If Outpt$ = "y" Then
         S$ = "/sbin/shutdown -r now"
         x$ = "SHELL" + S$
         Call ShellProgram2(S$)
         Print "Reboot failed.."
      Else
         Print "Reboot halted.."
      End If
      Exit Sub
   $End If
   Print "OS not supported.."
End Sub

Sub ShutdownFunc
   $If WIN Then
      V$ = "Attempt to shutdown(y/n)? "
      Call MorePrompt(V$, "yn", Outpt$)
      If Outpt$ = "y" Then
         S$ = "%windir%\System32\shutdown.exe /s /t 0"
         x$ = "SHELL" + S$
         Call ShellProgram2(S$)
         Print "Shutdown failed.."
      Else
         Print "Shutdown halted.."
      End If
      Exit Sub
   $End If
   $If LINUX OR MAC Then
      V$ = "Attempt to shutdown(y/n)? "
      Call MorePrompt(V$, "yn", Outpt$)
      If Outpt$ = "y" Then
         S$ = "/sbin/shutdown -h now"
         x$ = "SHELL" + S$
         Call ShellProgram2(S$)
         Print "Shutdown failed.."
      Else
         Print "Shutdown halted.."
      End If
      Exit Sub
   $End If
   Print "OS not supported.."
End Sub

Sub ShellProgram
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   DOSCommand$ = Nul
   If Len(Out2) Then
      If Left$(Out2, 1) = Quote And Right$(Out2, 1) = Quote Then
         ' nul
      Else
         Print "Enclose command in quotes."
         Exit Sub
      End If
      Call GetToken
      Call Parse1(Temp3#)
      If LastToken = False Then
         DOSCommand$ = Out3
      End If
   End If
   If DOSCommand$ = Nul Then
      Color Plain, Black
      Print "Type 'EXIT' to return."
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         Shell Comspec$
      Else
         Shell "CMD"
      End If
      Exit Sub
   End If
   FX$ = "SIC64" + Hex$(Node) + ".BAT"
   X = FreeFile
   Open FX$ For Output As #X
   Print #X, "@ECHO OFF"
   Print #X, DOSCommand$
   Print #X, "PAUSE"
   Print #X, "EXIT"
   Close #X
   Shell FX$
   f$ = FX$ + Chr$(0)
   X = DeleteFileA(f$)
End Sub

' SHELL Param$
Sub ShellProgram2 (Var$)
   If Len(Var$) Then
      FX$ = "SIC64" + Hex$(Node) + ".BAT"
      X = FreeFile
      Open FX$ For Output As #X
      Print #X, "@ECHO OFF"
      Print #X, Var$
      Print #X, "PAUSE"
      Print #X, "EXIT"
      Close #X
      Shell FX$
      f$ = FX$ + Chr$(0)
      X = DeleteFileA(f$)
      Color White, Black
      Print "Returned from DOS shell."
      Exit Sub
   End If
   Color Plain, Black
   Print "Type 'EXIT' to return."
   Comspec$ = Environ$("COMSPEC")
   If Len(Comspec$) Then
      Shell Comspec$
   Else
      Shell "CMD"
   End If
   Color White, Black
   Print "Returned from DOS shell."
End Sub

Sub NameExpression (Var)
   If Var = 1 Then
      Out2 = Mid$(Out2, 7)
   Else
      Out2 = Mid$(Out2, 5)
   End If
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      ProgramFile$ = Out3
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp4#)
         If LastToken = False Then
            f$ = ProgramFile$ + Chr$(0)
            g$ = Out3 + Chr$(0)
            x = MoveFile(f$, g$)
            If x = 0 Then Error 113
            Exit Sub
         End If
      End If
   End If
   Error 113
End Sub

Sub KillFile (Var)
   If Var = 1 Then
      Out2 = Mid$(Out2, 5)
   Else
      Out2 = Mid$(Out2, 7)
   End If
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      f$ = Out3 + Chr$(0)
      x = DeleteFileA(f$)
      If x = 0 Then
         Error 114
      End If
      Exit Sub
   End If
   Error 114
End Sub

Sub CHdrive (Var)
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Var = False
   Var$ = Nul
   If LastToken Then
      Var = CInt(Temp3#)
      If Var >= 1 And Var <= 26 Then
         Var$ = Chr$(Var + 64) + ":\"
         ChDir Var$
         Temp# = Dtrue
      Else
         Error 120
         Temp# = Dfalse
      End If
   Else
      Var$ = UCase$(Out3)
      If Var$ >= "A" And Var$ <= "Z" Then
         Var$ = Var$ + ":\"
         ChDir Var$
         Temp# = Dtrue
      Else
         Error 120
         Temp# = Dfalse
      End If
   End If
   LastToken = True
End Sub

Sub CDDirectory (Var)
   Dim ASCIIZ As String * 260
   If Var = 1 Then
      Out2 = Mid$(Out2, 3)
   Else
      Out2 = Mid$(Out2, 6)
   End If
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      ASCIIZ = Out3 + Chr$(0)
      x = SetCurrentDirectoryA(ASCIIZ)
      If x = 0 Then
         Error 115
      End If
      Exit Sub
   End If
   Error 115
End Sub

Sub MDDirectory (Var)
   Dim ASCIIZ As String * 260
   If Var = 1 Then
      Out2 = Mid$(Out2, 3)
   Else
      Out2 = Mid$(Out2, 6)
   End If
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      ASCIIZ = Out3 + Chr$(0)
      x = CreateDirectoryA(ASCIIZ, 0)
      If x = 0 Then
         Error 116
      End If
      Exit Sub
   End If
   Error 116
End Sub

Sub RDDirectory (Var)
   Dim ASCIIZ As String * 260
   If Var = 1 Then
      Out2 = Mid$(Out2, 3)
   Else
      Out2 = Mid$(Out2, 6)
   End If
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      ASCIIZ = Out3 + Chr$(0)
      x = RemoveDirectoryA%(ASCIIZ)
      If x = 0 Then
         Error 117
      End If
      Exit Sub
   End If
   Error 117
End Sub

Sub SetDate
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   If Out2 = Nul Then
      Print "Current date: "; Date$
      Exit Sub
   End If
   If Left$(Out2, 1) = "=" Then
      Out2 = Mid$(Out2, 2)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If LastToken = False Then
         Call DateFunc(Out3)
         Exit Sub
      End If
   End If
   Error 118
End Sub

Sub SetTime
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   If Out2 = Nul Then
      Print "Current time: "; Time$
      Exit Sub
   End If
   If Left$(Out2, 1) = "=" Then
      Out2 = Mid$(Out2, 2)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
      If LastToken = False Then
         Call TimeFunc(Out3)
         Exit Sub
      End If
   End If
   Error 119
End Sub

Sub SetEnviron
   Out2 = Mid$(Out2, 8)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   If LastToken = False Then
      Environ Out3
      Exit Sub
   End If
   Error 165
End Sub

Rem improved 04/10/2025
Rem  added MultiVar 07/25/2025
Rem  added constant arrays.

Rem can now swap A0,A9 to Z0,Z9
Rem   and A0(n),A9(n) to Z(n),Z9(n)
Rem   and A0$,A9$ to Z0$,Z9$
Rem   and also A0,A(n) and A0(n),A0
Sub SwapData
   Assign = 0
   Temp1$ = Mid$(Out2, 5) ' swap
   StoreSwap$ = Temp1$
   GoSub SwapConst
   Temp1$ = Strim$(Temp1$)
   Temp2$ = UCase$(Left$(Temp1$, 1))
   Temp3$ = Mid$(Temp1$, 2, 1)
   If Temp2$ >= "A" And Temp2$ <= "Z" Then
      If Temp3$ >= "0" And Temp3$ <= "9" Then
         V$ = Temp2$ + Temp3$
         ' multivar assign
         Variable1 = GetVariable(V$)
         Temp1$ = Mid$(Temp1$, 3)
      Else
         V$ = Temp2$
         ' multivar assign
         Variable1 = GetVariable(V$)
         Temp1$ = Mid$(Temp1$, 2)
      End If
      Temp1$ = Strim$(Temp1$)
      If Left$(Temp1$, 1) = "," Or Left$(Temp1$, 1) = ";" Then
         Temp1$ = Mid$(Temp1$, 2)
         Temp1$ = Strim$(Temp1$)
         Temp2$ = UCase$(Left$(Temp1$, 1))
         Temp3$ = Mid$(Temp1$, 2, 1)
         If Temp2$ >= "A" And Temp2$ <= "Z" Then
            If Temp3$ >= "0" And Temp3$ <= "9" Then
               V$ = Temp2$ + Temp3$
               ' multivar assign
               Variable2 = GetVariable(V$)
               Temp1$ = Mid$(Temp1$, 3)
            Else
               V$ = Temp2$
               ' multivar assign
               Variable2 = GetVariable(V$)
               Temp1$ = Mid$(Temp1$, 2)
            End If
            Temp1$ = Strim$(Temp1$)
            If Temp1$ = Nul Then
               Swap Variables(Variable1), Variables(Variable2)
               Assign = True
               Exit Sub
            Else
               If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
                  TokenLeft$ = Left$(Temp1$, 1)
                  Out2 = Mid$(Temp1$, 2)
                  Out2 = Strim$(Out2)
                  LastToken = False
                  TokenIndex = 1
                  Call GetToken
                  Call Parse1(Temp3#)
                  OK = 0
                  If TokenLeft$ = "(" Then
                     If Strng = ")" Then
                        OK = True
                     End If
                  End If
                  If TokenLeft$ = "[" Then
                     If Strng = "]" Then
                        OK = True
                     End If
                  End If
                  If TokenLeft$ = "{" Then
                     If Strng = "}" Then
                        OK = True
                     End If
                  End If
                  If OK = False Then
                     Error 110
                     Exit Sub
                  End If
                  Element = CInt(Temp3#)
                  V = UBound(Arrays, 2)
                  If Element > V Then
                     ReDim _Preserve Arrays(1024, Element) As Double
                  End If
                  If Element > False Then
                     Swap Variables(Variable1), Arrays(Variable2, Element)
                     Assign = True
                     Exit Sub
                  End If
               End If
            End If
         End If
      Else
         If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
            TokenLeft$ = Left$(Temp1$, 1)
            Out2 = Mid$(Temp1$, 2)
            Out2 = Strim$(Out2)
            LastToken = False
            TokenIndex = 1
            Call GetToken
            Call Parse1(Temp3#)
            OK = 0
            If TokenLeft$ = "(" Then
               If Strng = ")" Then
                  OK = True
               End If
            End If
            If TokenLeft$ = "[" Then
               If Strng = "]" Then
                  OK = True
               End If
            End If
            If TokenLeft$ = "{" Then
               If Strng = "}" Then
                  OK = True
               End If
            End If
            If OK = False Then
               Error 110
               Exit Sub
            End If
            Element1 = CInt(Temp3#)
            Temp1$ = Mid$(Out2, TokenIndex)
            Temp1$ = Strim$(Temp1$)
            If Left$(Temp1$, 1) = "," Or Left$(Temp1$, 1) = ";" Then
               Out2 = Mid$(Temp1$, 2)
               Out2 = UCase$(Out2)
               Temp1$ = Mid$(Temp1$, 2)
               Temp1$ = Strim$(Temp1$)
               Temp2$ = UCase$(Left$(Temp1$, 1))
               Temp3$ = Mid$(Temp1$, 2, 1)
               If Temp2$ >= "A" And Temp2$ <= "Z" Then
                  If Temp3$ >= "0" And Temp3$ <= "9" Then
                     V$ = Temp2$ + Temp3$
                     ' multivar assign
                     Variable2 = GetVariable(V$)
                     Temp1$ = Mid$(Temp1$, 3)
                  Else
                     V$ = Temp2$
                     ' multivar assign
                     Variable2 = GetVariable(V$)
                     Temp1$ = Mid$(Temp1$, 2)
                  End If
                  Temp1$ = Strim$(Temp1$)
                  If Temp1$ = Nul Then
                     V = UBound(Arrays, 2)
                     If Element1 > V Then
                        ReDim _Preserve Arrays(1024, Element1) As Double
                     End If
                     If Element1 > False Then
                        Swap Arrays(Variable1, Element1), Variables(Variable2)
                        Assign = True
                        Exit Sub
                     End If
                  Else
                     If Left$(Temp1$, 1) = "(" Or Left$(Temp1$, 1) = "[" Or Left$(Temp1$, 1) = "{" Then
                        TokenLeft$ = Left$(Temp1$, 1)
                        Out2 = Mid$(Temp1$, 2)
                        Out2 = Strim$(Out2)
                        LastToken = False
                        TokenIndex = 1
                        Call GetToken
                        Call Parse1(Temp3#)
                        OK = 0
                        If TokenLeft$ = "(" Then
                           If Strng = ")" Then
                              OK = True
                           End If
                        End If
                        If TokenLeft$ = "[" Then
                           If Strng = "]" Then
                              OK = True
                           End If
                        End If
                        If TokenLeft$ = "{" Then
                           If Strng = "}" Then
                              OK = True
                           End If
                        End If
                        If OK = False Then
                           Error 110
                           Exit Sub
                        End If
                        Element2 = CInt(Temp3#)
                        V = UBound(Arrays, 2)
                        If Element1 > V Then
                           ReDim _Preserve Arrays(1024, Element1) As Double
                        End If
                        V = UBound(Arrays, 2)
                        If Element2 > V Then
                           ReDim _Preserve Arrays(1024, Element2) As Double
                        End If
                        If Element1 > False Then
                           If Element2 > False Then
                              Swap Arrays(Variable1, Element1), Arrays(Variable2, Element2)
                              Assign = True
                              Exit Sub
                           End If
                        End If
                     End If
                  End If
               End If
            End If
         Else
            If Left$(Temp1$, 1) = "$" Then
               Temp1$ = Mid$(Temp1$, 2)
               Temp1$ = Strim$(Temp1$)
               If Left$(Temp1$, 1) = "," Or Left$(Temp1$, 1) = ";" Then
                  Temp1$ = Mid$(Temp1$, 2)
                  Temp1$ = Strim$(Temp1$)
                  Temp2$ = UCase$(Left$(Temp1$, 1))
                  Temp3$ = Mid$(Temp1$, 2, 1)
                  If Temp2$ >= "A" And Temp2$ <= "Z" Then
                     If Temp3$ >= "0" And Temp3$ <= "9" Then
                        V$ = Temp2$ + Temp3$
                        ' multivar assign
                        Variable2 = GetVariable(V$)
                        Temp1$ = Mid$(Temp1$, 3)
                     Else
                        V$ = Temp2$
                        ' multivar assign
                        Variable2 = GetVariable(V$)
                        Temp1$ = Mid$(Temp1$, 2)
                     End If
                     Temp1$ = Strim$(Temp1$)
                     If Temp1$ = "$" Then
                        Swap Strngs$(Variable1), Strngs$(Variable2)
                        Assign = True
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Error 110

   SwapConst:
   ' swap constant arrays.
   Var$ = StoreSwap$
   V = InStr(Var$, ",")
   If V Then
      Var1$ = Left$(Var$, V - 1)
      Var2$ = Mid$(Var$, V + 1)
      Var1$ = LTrim$(RTrim$(Var1$))
      Var2$ = LTrim$(RTrim$(Var2$))
      If Len(Var1$) > 0 And Len(Var2$) > 0 Then
         For V1 = 1 To ConstArray
            If UCase$(Var1$) = ConstStrings(V1) Then
               For V2 = 1 To ConstArray
                  If UCase$(Var2$) = ConstStrings(V2) Then
                     Swap ConstValues(V1), ConstValues(V2)
                     Exit Sub
                  End If
               Next
            End If
         Next
      End If
   End If
   Return
   Error 110
End Sub

Sub LimitSecond
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   If Len(Out2) = False Then
      Temp3# = 1#
   Else
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
   End If
   If Temp3# > Dfalse Then
      _Limit CSng(Temp3#)
   End If
End Sub

Sub BeepSecond
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   If Len(Out2) = False Then
      Temp3# = 1#
   Else
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
   End If
   For T# = 1 To Temp3#
      Sound Freq, Duration ' long beep
      _Delay DelayValue ' pause for multiple beeps
      'Beep
   Next
End Sub

Sub SleepSecond
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   If Len(Out2) = False Then
      Temp3# = 1#
   Else
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
   End If
   Sleep CInt(Temp3#)
   X$ = InKeyx$
End Sub

Sub PauseSecond
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   If Len(Out2) = False Then
      Temp3# = 1#
   Else
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp3#)
   End If
   PauseTime! = CSng(Temp3#)
   TimeNow! = Timer
   Do
      ' calculate time elapsed
      ElapsedTime! = Timer - TimeNow!
      ' adjust for midnight
      If ElapsedTime! < SFalse Then
         ElapsedTime! = ElapsedTime! + 86400!
      End If
      ' compare time elapsed
      If ElapsedTime! > PauseTime! Then
         Exit Do
      End If
      X$ = InKeyx$
   Loop
   X$ = InKeyx$
End Sub

Sub OutputPort
   Out2 = Mid$(Out2, 4)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   PortAddress = CInt(Temp4#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      PortByte = CInt(Temp4#)
      Out PortAddress, PortByte
      Exit Sub
   End If
   Error 121
End Sub

Sub WaitPort
   AllowExtra = True
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      PortAddress = CInt(Temp4#)
      If Strng = "," Or Strng = ";" Then
         Call GetToken
         Call Parse1(Temp4#)
         AndValue = CInt(Temp4#)
         XorValue = False
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp4#)
            XorValue = CInt(Temp4#)
         End If
         Wait PortAddress, AndValue, XorValue
         Exit Sub
      End If
   End If
   Error 122
End Sub

Sub AbsoluteFunction
   Out2 = Mid$(Out2, 9)
   Out2 = Strim$(Out2)
   If Len(Out2) Then
      TokenIndex = 1
      Call GetToken3
      Call GetToken
      Call Parse1(Temp4#)
      Call GetToken4
      Call Absolute(CInt(Temp4#))
      Exit Sub
   End If
   Error 123
End Sub

Sub PokeValue
   Out2 = Mid$(Out2, 5)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp4#)
   Poke.Address = CInt(Temp4#)
   If Strng = "," Or Strng = ";" Then
      Call GetToken
      Call Parse1(Temp4#)
      Poke.Byte = CInt(Temp4#)
      Poke Poke.Address, Poke.Byte
      Exit Sub
   End If
   Error 124
End Sub

Sub Int86Function
   Out2 = Mid$(Out2, 6)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken3
   Call GetToken
   Call Parse1(Temp4#)
   Call GetToken4
   Int86Value = CInt(Temp4#)
   If Int86Value = &H33 Then ' mouse
      InregsX.AX = Int(Val("&H" + Hex$(AX)))
      InregsX.BX = Int(Val("&H" + Hex$(BX)))
      InregsX.CX = Int(Val("&H" + Hex$(CX)))
      InregsX.DX = Int(Val("&H" + Hex$(DX)))
      InregsX.BP = Int(Val("&H" + Hex$(BP)))
      InregsX.SI = Int(Val("&H" + Hex$(SI)))
      InregsX.DI = Int(Val("&H" + Hex$(DI)))
      InregsX.FL = Int(Val("&H" + Hex$(FL)))
      InregsX.DS = Int(Val("&H" + Hex$(DS)))
      InregsX.ES = Int(Val("&H" + Hex$(ES)))
      Call INTERRUPTX(Int86Value, InregsX, OutregsX)
      If OutregsX.AX < False Then
         AX = CDbl(OutregsX.AX + 65536)
      Else
         AX = CDbl(OutregsX.AX)
      End If
      If OutregsX.BX < False Then
         BX = CDbl(OutregsX.BX + 65536)
      Else
         BX = CDbl(OutregsX.BX)
      End If
      If OutregsX.CX < False Then
         CX = CDbl(OutregsX.CX + 65536)
      Else
         CX = CDbl(OutregsX.CX)
      End If
      If OutregsX.DX < False Then
         DX = CDbl(OutregsX.DX + 65536)
      Else
         DX = CDbl(OutregsX.DX)
      End If
      If OutregsX.BP < False Then
         BP = CDbl(OutregsX.BP + 65536)
      Else
         BP = CDbl(OutregsX.BP)
      End If
      If OutregsX.SI < False Then
         SI = CDbl(OutregsX.SI + 65536)
      Else
         SI = CDbl(OutregsX.SI)
      End If
      If OutregsX.DI < False Then
         DI = CDbl(OutregsX.DI + 65536)
      Else
         DI = CDbl(OutregsX.DI)
      End If
      If OutregsX.FL < False Then
         FL = CDbl(OutregsX.FL + 65536)
      Else
         FL = CDbl(OutregsX.FL)
      End If
      If OutregsX.DS < False Then
         DS = CDbl(OutregsX.DS + 65536)
      Else
         DS = CDbl(OutregsX.DS)
      End If
      If OutregsX.ES < False Then
         ES = CDbl(OutregsX.ES + 65536)
      Else
         ES = CDbl(OutregsX.ES)
      End If
   Else
      Error 158
   End If
End Sub

Sub DefsegFunction
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   If Len(Out2) = False Then
      Def Seg ' restore segment
      InDEFSEG = False ' reset segment flag
      Exit Sub
   End If
   TokenIndex = 1
   Call GetToken3
   Call GetToken
   Call Parse1(Temp4#)
   Call GetToken4
   If Temp4# >= Dfalse And Temp4# <= 65535# Then
      Def Seg = Temp4# ' set segment
      InDEFSEG = True ' set segment flag
      DEFSEGvalue = Temp4# ' store segment value
      Exit Sub
   End If
   Error 125
End Sub

Sub SeedRandom
   Out2 = Mid$(Out2, 10)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken
   Call Parse1(Temp3#)
   Randomize CLng(Temp3#)
End Sub

' def fn(x)=value
Sub DefineFunction
   Out2 = Mid$(Out2, 7)
   Out2 = Strim$(Out2)
   TokenIndex = 1
   Call GetToken3
   Call GetToken
   Call Parse1(Temp4#)
   Call GetToken4
   Func& = CLng(Temp4#)
   If Func& > UBound(Definitions, 1) Then
      ReDim _Preserve Definitions(Func&) As String
   End If
   If Func& >= 1 And Func& <= UBound(Definitions, 1) Then
      Out2 = Mid$(Out2, TokenIndex)
      Out2 = LTrim$(Out2)
      If Left$(Out2, 1) = "=" Then
         Out2 = Mid$(Out2, 2)
         Definitions$(Func&) = Out2
         Exit Sub
      End If
   End If
   Error 144
End Sub

' accepts an operation and performs on two values, string or numeric
Sub Arith (TokenParsed$, Temp#, Temp2#)
   If LastToken Then
      Select Case TokenParsed$
         Case "_"
            Temp# = Temp2#
         Case "-"
            Temp# = Temp# - Temp2#
         Case "+"
            Temp# = Temp# + Temp2#
         Case "/"
            Temp# = Temp# / Temp2#
         Case "\"
            Temp# = Temp# \ Temp2#
         Case "*"
            Temp# = Temp# * Temp2#
         Case "^"
            Temp# = Temp# ^ Temp2#
         Case "<"
            Temp# = (Temp# < Temp2#)
         Case ">"
            Temp# = (Temp# > Temp2#)
         Case "<<"
            Temp# = Temp# * 2#
         Case ">>"
            Temp# = Temp# \ 2#
         Case "||"
            Temp# = Temp# * 10#
         Case "&&"
            Temp# = Temp# + 1#
         Case "##"
            Temp# = Temp# \ 10#
         Case "^^"
            Temp# = Temp# ^ 10#
         Case "++"
            Temp# = Temp# + 1#
         Case "--"
            Temp# = Temp# - 1#
         Case "+++"
            Temp# = Temp# + 1#
         Case "---"
            Temp# = Temp# - 1#
         Case "**"
            Temp# = Temp# ^ 2#
         Case "//"
            If Temp# < Dfalse Then
               Error 157
            Else
               Temp# = Sqr(Temp#)
            End If
         Case "="
            Temp# = (Temp# = Temp2#)
         Case "<="
            Temp# = (Temp# <= Temp2#)
         Case ">="
            Temp# = (Temp# >= Temp2#)
         Case "<>"
            Temp# = (Temp# <> Temp2#)
         Case "=="
            CaseValue1 = Temp#
            CaseValue2 = Temp2#
            LastToken = 2
         Case "|"
            Temp# = Temp# Or Temp2#
         Case "&"
            Temp# = Temp# And Temp2#
         Case "%"
            Temp# = Temp# Mod Temp2#
         Case "~"
            Temp# = Temp# Xor Temp2#
         Case "?"
            Temp# = Temp# Imp Temp2#
         Case ":"
            Temp# = Temp# Eqv Temp2#
         Case "#"
            Temp# = Not (Temp# Or Temp2#)
         Case "@"
            Temp# = Not (Temp# Imp Temp2#)
         Case "`"
            Temp# = Not (Temp# And Temp2#)
      End Select
      Exit Sub
   End If
   Select Case TokenParsed$
      Case "_"
         Out3 = XTRIM$(Out4, -1)
      Case "-"
         If Right$(Out3, Len(Out4)) = Out4 Then
            Out3 = Left$(Out3, Len(Out3) - Len(Out4))
         End If
      Case "+"
         Out3 = Out3 + Out4
      Case "/", "\"
         If Len(Out3) > False And Len(Out4) > False Then
            Imbedded = InStr(Out3, Out4)
            While Imbedded
               Out3 = Left$(Out3, Imbedded - 1) + Mid$(Out3, Imbedded + Len(Out4))
               Imbedded = InStr(Out3, Out4)
            Wend
         End If
      Case "<"
         LastToken = True
         Temp# = Out3 < Out4
      Case ">"
         LastToken = True
         Temp# = Out3 > Out4
      Case "="
         LastToken = True
         Temp# = Out3 = Out4
      Case "<="
         LastToken = True
         Temp# = Out3 <= Out4
      Case ">="
         LastToken = True
         Temp# = Out3 >= Out4
      Case "<>"
         LastToken = True
         Temp# = Out3 <> Out4
      Case "=="
         CaseValueS1 = Out3
         CaseValueS2 = Out4
         LastToken = 2
   End Select
End Sub

' accepts an operation and performs on one numeric variable
Sub Assignment1 (TempS$, TempS3%)
   If TempS$ = "<<" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) * 2#
      Exit Sub
   End If
   If TempS$ = ">>" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) / 2#
      Exit Sub
   End If
   If TempS$ = "||" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) * 10#
      Exit Sub
   End If
   If TempS$ = "&&" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) + 1#
      Exit Sub
   End If
   If TempS$ = "##" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) / 10#
      Exit Sub
   End If
   If TempS$ = "^^" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) ^ 10#
      Exit Sub
   End If
   If TempS$ = "--" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) - 1#
      Exit Sub
   End If
   If TempS$ = "++" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) + 1#
      Exit Sub
   End If
   If TempS$ = "---" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) - 1#
      Exit Sub
   End If
   If TempS$ = "+++" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) + 1#
      Exit Sub
   End If
   If TempS$ = "**" Then
      Assign = True
      Strng = Nul
      Variables(TempS3%) = Variables(TempS3%) ^ 2#
      Exit Sub
   End If
   If TempS$ = "//" Then
      Assign = True
      Strng = Nul
      If Variables(TempS3%) < Dfalse Then
         Error 157
      Else
         Variables(TempS3%) = Sqr(Variables(TempS3%))
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "-=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) - Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "+=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) + Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "/=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) / Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "\=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) \ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "*=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) * Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "^=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) ^ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "++=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) + Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "<<=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) * Temp4# * 2#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = ">>=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) / (Temp4# * 2#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "--=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) - Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "**=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) * Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "//=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) / Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "\\=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) \ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "!!=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         TempX# = Variables(TempS3%)
         TempX# = TempX# * Not Temp4#
         Variables(TempS3%) = TempX#

         ' C++ Compilation Error:
         'Variables(TempS3%) = Variables(TempS3%) Not Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "||=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) Or Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "&&=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) And Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "^^=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) ^ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "^+=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) ^ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "^-=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) ^ (-Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "%=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) Mod Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "|=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) Or Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "&=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) And Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "~=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) Xor Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "?=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) Imp Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = ":=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Variables(TempS3%) Eqv Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "#=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Not (Variables(TempS3%) Or Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "@=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Not (Variables(TempS3%) Imp Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "`=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Not (Variables(TempS3%) And Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 1) = "=" Then
      Out2 = Mid$(TempS$, 2)
      Out2 = Strim$(Out2)
      Call Equate(Temp4#)
      If LastToken = True Then
         Assign = True
         Variables(TempS3%) = Temp4#
      End If
      Exit Sub
   End If
End Sub

' accepts an operation and performs on one numeric array element
Sub Assignment2 (TempS$, TempS1%, TempS2%)
   If TempS$ = "<<" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * 2#
      Exit Sub
   End If
   If TempS$ = ">>" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / 2#
      Exit Sub
   End If
   If TempS$ = "||" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * 10#
      Exit Sub
   End If
   If TempS$ = "&&" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + 1#
      Exit Sub
   End If
   If TempS$ = "##" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / 10#
      Exit Sub
   End If
   If TempS$ = "^^" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ 10#
      Exit Sub
   End If
   If TempS$ = "--" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - 1#
      Exit Sub
   End If
   If TempS$ = "++" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + 1#
      Exit Sub
   End If
   If TempS$ = "---" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - 1#
      Exit Sub
   End If
   If TempS$ = "+++" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + 1#
      Exit Sub
   End If
   If TempS$ = "**" Then
      Assign = True
      Strng = Nul
      Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ 2#
      Exit Sub
   End If
   If TempS$ = "//" Then
      Assign = True
      Strng = Nul
      If Arrays(TempS1%, Temp2%) < Dfalse Then
         Error 157
      Else
         Arrays(TempS1%, TempS2%) = Sqr(Arrays(TempS1%, TempS2%))
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "-=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "+=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "/=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "\=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) \ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "*=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "^=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "++=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "<<=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * Temp4# * 2#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = ">>=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / (Temp4# * 2#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "--=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "**=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "//=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "\\=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) \ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "!!=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         TempX# = Arrays(TempS1%, TempS2%)
         TempX# = TempX# * Not Temp4#
         Arrays(TempS1%, TempS2%) = TempX#

         ' C++ Compilation Error:
         'Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Not Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "^^=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "||=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Or Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "&&=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) And Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "^+=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 3) = "^-=" Then
      Out2 = Mid$(TempS$, 4)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ (-Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "%=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Mod Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "|=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Or Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "&=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) And Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "~=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Xor Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "?=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Imp Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = ":=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) Eqv Temp4#
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "#=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Not (Arrays(TempS1%, TempS2%) Or Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "@=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Not (Arrays(TempS1%, TempS2%) Imp Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 2) = "`=" Then
      Out2 = Mid$(TempS$, 3)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Not (Arrays(TempS1%, TempS2%) And Temp4#)
      End If
      Exit Sub
   End If
   If Left$(TempS$, 1) = "=" Then
      Out2 = Mid$(TempS$, 2)
      Out2 = Strim$(Out2)
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp4#)
      If LastToken = True Then
         Assign = True
         Arrays(TempS1%, TempS2%) = Temp4#
      End If
   End If
End Sub

' gets a value and assigns to one register variable
Sub Assignment3 (TempS1$, TempS2$)
   Select Case TempS2$
      Case "AX"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            AX = Temp4#
         End If
         Exit Sub
      Case "BX"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            BX = Temp4#
         End If
         Exit Sub
      Case "CX"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            CX = Temp4#
         End If
         Exit Sub
      Case "DX"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            DX = Temp4#
         End If
         Exit Sub
      Case "BP"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            BP = Temp4#
         End If
         Exit Sub
      Case "SI"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            SI = Temp4#
         End If
         Exit Sub
      Case "DI"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            DI = Temp4#
         End If
         Exit Sub
      Case "FL"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            FL = Temp4#
         End If
         Exit Sub
      Case "DS"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            DS = Temp4#
         End If
         Exit Sub
      Case "ES"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            ES = Temp4#
         End If
         Exit Sub
   End Select
End Sub

' gets a value and assigns to one error variable
Sub Assignment4 (TempS1$, TempS2$)
   Select Case TempS2$
      Case "ERR"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            ErrorValue = CInt(Temp4#)
            ErrorValue2 = CInt(Temp4#)
         End If
         Exit Sub
      Case "ERL"
         Out2 = TempS1$
         Call Equate(Temp4#)
         If LastToken = True Then
            Assign = True
            ErrorLine = CInt(Temp4#)
         End If
         Exit Sub
   End Select
End Sub

' return variable of mixed-length string.
Function GetVariable (V$)
   X$ = V$
   If Len(X$) = 1 Then
      X$ = UCase$(X$)
      If X$ >= "A" And X$ <= "Z" Then
         GetVariable = Asc(X$) - 64 ' 1-26
      End If
      Exit Function
   End If
   ' A0-A9, B0-B9, ...
   If Len(X$) = 2 Then
      Y$ = UCase$(Left$(X$, 1))
      Z$ = UCase$(Right$(X$, 1))
      If Y$ >= "A" And Y$ <= "Z" Then
         If Z$ >= "0" And Z$ <= "9" Then
            Y = Asc(Y$) - 64
            Z = Int(Val(Z$)) + 1
            ' a0=26*1+0, a9=26*1+9
            ' b0=26*2+0, b9=26*2+9, ...
            GetVariable = Y * 26 + Z
         End If
      End If
   End If
End Function

' return mixed-length string of variable.
Function GetVariable2$ (V)
   If V >= 1 And V <= 26 Then ' A-Z
      GetVariable2$ = Chr$(V + 64)
      Exit Function
   End If
   X = Int(V / 26) ' A-Z
   Y = V - X * 26 ' 0-9
   X$ = Chr$(X + 64)
   X$ = X$ + LTrim$(Str$(Y - 1))
   GetVariable2$ = X$
End Function

' entry to expression parser,
' each following parser is higher precedence,
' this routine called by higher precedence routines recursively.

Rem precedence of operators (from highest to lowest):
Rem   !, +, - Not, Unary plus, Unary Minus
Rem   ^       Power
Rem   *, /    Multiplication, Division
Rem   \       Integer division
Rem   %       Modulo
Rem   +, -    Addition, Subtraction
Rem   =, <, >, <>, >=, <= Relational
Rem   |, &, ~, ?, :, #, @, ` Logical (or, and, xor, imp, eqv, nor, non, xan)

Rem  Returns LastToken equal to:
Rem    0  =  string
Rem   -1  =  numeric
Rem    1  =  token IS/ISNT
Rem    2  =  token is ==
Rem    3  =  token , or ;

Sub Equate (Temp#)
   LastToken = False
   Out3 = Nul ' reset string storage
   Out4 = Nul ' reset string concatenate storage
   Temp# = Dfalse ' reset result
   TokenIndex = 1 ' reset pointer to expression token
   Call GetToken ' read next token
   Call Parse1(Temp#) ' entry to parse the expression
   ' parse leftover tokens
   While Len(Strng)
      Call Parse1(X#)
      ' toss away any unwanted tokens
      If LastToken = 3 Then
         If AllowExtra = False Then
            Strng = "<extra token>"
            Error 92
         End If
      End If
   Wend
End Sub

' verifies next token is opening parenthesis.
Sub GetToken3
   Strng = Nul
   Token = False
   If Mid$(Out2, TokenIndex, 1) = " " Then
      TokenIndex = TokenIndex + 1
   End If
   If TokenIndex > Len(Out2) Then
      Error 138
   End If
   ' locate parenthesis symbol
   TokenElement$ = Mid$(Out2, TokenIndex, 1)
   If TokenElement$ = "(" Then
      Token = 1 ' store token type
      Strng = TokenElement$ ' store token
      TokenIndex = TokenIndex + 1 ' increment pointer
      Exit Sub
   End If
   Error 138
End Sub

' verifies last token is closing parenthesis.
Sub GetToken4
   ' locate parenthesis symbol
   If Strng = ")" Then
      Exit Sub
   End If
   Error 139
End Sub

' returns next token in string form,
' increments pointer to next token,
' determines token type.
Sub GetToken
   Strng = Nul
   Token = False
   If Mid$(Out2, TokenIndex, 1) = " " Then
      TokenIndex = TokenIndex + 1
   End If
   Call GetToken2(TokenExists)
   If TokenExists Then
      Exit Sub
   End If
   If TokenIndex > Len(Out2) Then
      Strng = Nul
      Token = False
      TokenIndex = TokenIndex + 1
      Exit Sub
   End If
   ' locate expression symbol
   TokenElement$ = Mid$(Out2, TokenIndex, 1)
   If InStr(TokenList, TokenElement$) Then
      Token = 1 ' store token type
      Strng = TokenElement$ ' store token
      TokenIndex = TokenIndex + 1 ' increment pointer
      Exit Sub
   End If
   ' locate expression is number
   TokenElement$ = Mid$(Out2, TokenIndex, 1)
   If TokenElement$ >= "0" And TokenElement$ <= "9" Then
      ' increment token until token is other than number
      Do
         If Len(TokenElement$) = False Then
            Exit Do
         End If
         If InStr(TokenList, TokenElement$) Then
            Exit Do
         End If
         Strng = Strng + TokenElement$
         TokenIndex = TokenIndex + 1
         TokenElement$ = Mid$(Out2, TokenIndex, 1)
      Loop
      Token = 2 ' store token type
      Exit Sub
   End If
   ' locate expression is number beginning with decimal
   TokenElement$ = Mid$(Out2, TokenIndex, 1)
   If TokenElement$ = "." Then
      ' increment token until token is other than number
      Do
         If Len(TokenElement$) = False Then
            Exit Do
         End If
         If InStr(TokenList, TokenElement$) Then
            Exit Do
         End If
         Strng = Strng + TokenElement$
         TokenIndex = TokenIndex + 1
         TokenElement$ = Mid$(Out2, TokenIndex, 1)
      Loop
      Token = 2 ' store token type
      Exit Sub
   End If
   ' locate expression is alphabetic
   TokenElement$ = UCase$(Mid$(Out2, TokenIndex, 1))
   If TokenElement$ >= "A" And TokenElement$ <= "Z" Then
      ' increment token until token is other than alphabetic
      Do
         If Len(TokenElement$) = False Then
            Exit Do
         End If
         If InStr(TokenList, TokenElement$) Then
            Exit Do
         End If
         Strng = Strng + TokenElement$
         TokenIndex = TokenIndex + 1
         TokenElement$ = UCase$(Mid$(Out2, TokenIndex, 1))
      Loop
      Token = 3 ' store token type
      Exit Sub
   End If
   ' store unknown token
   Token = False
   Strng = TokenElement$
   TokenIndex = TokenIndex + 1
End Sub

' returns next two-character token in string form,
' increments pointer to next token,
' determines token type.
Sub GetToken2 (TokenExists)
   TokenExists = False
   StoredToken$ = Out2
   If Mid$(StoredToken$, TokenIndex + 1, 1) = " " Then
      StoredToken$ = Left$(StoredToken$, TokenIndex) + Mid$(StoredToken$, TokenIndex + 2)
   End If
   ' locate expression symbols
   NextToken$ = Mid$(StoredToken$, TokenIndex, 2)
   Select Case NextToken$
      Case "<<"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "<<" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case ">>"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = ">>" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "||"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "||" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "&&"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "&&" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "##"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "##" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "^^"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "^^" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "--"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "--" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "++"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "++" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "---"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "---" ' store token
         TokenIndex = TokenIndex + 3 ' increment pointer
         TokenExists = True
      Case "+++"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "+++" ' store token
         TokenIndex = TokenIndex + 3 ' increment pointer
         TokenExists = True
      Case "**"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "**" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "//"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "//" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case ">=", "=>"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = ">=" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "<=", "=<"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "<=" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "<>", "><"
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "<>" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
      Case "=="
         GoSub RemoveSpaces
         Token = 1 ' store token type
         Strng = "==" ' store token
         TokenIndex = TokenIndex + 2 ' increment pointer
         TokenExists = True
   End Select
   Exit Sub

   ' locate and remove spaces
   RemoveSpaces:
   If Mid$(Out2, TokenIndex + 1, 1) = " " Then
      Out2 = Left$(Out2, TokenIndex) + Mid$(Out2, TokenIndex + 2)
   End If
   Return
End Sub

' parses out single variable tokens
Sub ParseAlphabetic1 (Temp#)
   Select Case UCase$(Strng) ' test variable symbol
      Case "A" To "Z"
         Element = Asc(UCase$(Strng)) - 64
         ElementType$ = Mid$(Out2, TokenIndex, 1)
         Select Case ElementType$
            Case "("
               Call GetToken
               Call GetToken
               Call Parse1(Temp#)
               If Strng = ")" Then
                  Subscript = CInt(Temp#)
                  V = UBound(Arrays, 2)
                  If Subscript > V Then
                     ReDim _Preserve Arrays(1024, Subscript) As Double
                  End If
                  Temp# = Arrays(Element, Subscript)
                  LastToken = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case "["
               Call GetToken
               Call GetToken
               Call Parse1(Temp#)
               If Strng = "]" Then
                  Subscript = CInt(Temp#)
                  V = UBound(Arrays, 2)
                  If Subscript > V Then
                     ReDim _Preserve Arrays(1024, Subscript) As Double
                  End If
                  Temp# = Arrays(Element, Subscript)
                  LastToken = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case "{"
               Call GetToken
               Call GetToken
               Call Parse1(Temp#)
               If Strng = "}" Then
                  Subscript = CInt(Temp#)
                  V = UBound(Arrays, 2)
                  If Subscript > V Then
                     ReDim _Preserve Arrays(1024, Subscript) As Double
                  End If
                  Temp# = Arrays(Element, Subscript)
                  LastToken = True
               Else
                  Strng = "<missing closing token>"
                  Error 92
               End If
            Case Else
               Call GetConst(Strng, V2$, V3)
               If V3 Then
                  Temp# = Val(V2$)
               Else
                  Temp# = Variables(Element)
               End If
               LastToken = True
         End Select
      Case Else
         If AllowAlpha Then
            Out3 = Strng
         Else
            Strng = "(" + Strng + ")"
            Error 92
         End If
   End Select
End Sub

' parses out two-letter variable tokens
Sub ParseAlphabetic2 (Temp#)
   Select Case UCase$(Strng)
      ' user defined functions
      Case "FN"
         Call ParseFN(Temp#)
      Case "FZ"
         Call ParseFZ(Temp#)
         ' interrupt functions
      Case "AX"
         Temp# = AX
         LastToken = True
      Case "BX"
         Temp# = BX
         LastToken = True
      Case "CX"
         Temp# = CX
         LastToken = True
      Case "DX"
         Temp# = DX
         LastToken = True
      Case "BP"
         Temp# = BP
         LastToken = True
      Case "SI"
         Temp# = SI
         LastToken = True
      Case "DI"
         Temp# = DI
         LastToken = True
      Case "FL"
         Temp# = FL
         LastToken = True
      Case "DS"
         Temp# = DS
         LastToken = True
      Case "ES"
         Temp# = ES
         LastToken = True

         ' functions w/o parameters
      Case "PI" ' calculate PI
         'Temp# = Atn(1#) * 4#
         Temp# = PI
         LastToken = True
      Case "EX" ' calculate E
         Temp# = Exp(1#)
         LastToken = True

         ' special case functions
      Case "IS"
         Call GetToken
         Strng2$ = Strng
         Call GetToken
         Call Parse1(Temp4#)
         Out4 = Out3
         Temp3# = CaseValue
         Out3 = CaseStrng
         Strng = Strng2$
         Call Arith(Strng, Temp3#, Temp4#)
         ValueIs = Temp3#
         LastToken = 1
      Case "OR"
         Call GetToken
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# Or Temp#
         LastToken = True

         ' special case constants
      Case "CR"
         Out3 = CR
         LastToken = False
      Case "LF"
         Out3 = LF
         LastToken = False
      Case Else
         If Mid$(Strng, 2, 1) = "$" Then
            Select Case Mid$(Out2, TokenIndex, 1)
               Case "(", "[", "{"
                  Strng = "<bad string token>"
                  Error 92
            End Select
            Select Case UCase$(Left$(Strng, 1))
               Case "A" To "Z"
                  Call GetConst(Strng, V2$, V3)
                  If V3 Then
                     Out3 = V2$
                  Else
                     Element = Asc(UCase$(Left$(Strng, 1))) - 64
                     Out3 = Strngs$(Element)
                  End If
                  LastToken = False
            End Select
         Else
            If Mid$(Strng, 2, 1) >= "0" And Mid$(Strng, 2, 1) <= "9" Then
               Element.Type$ = Mid$(Out2, TokenIndex, 1)
               If Element.Type$ = "(" Then
                  ' multivar assign
                  V = GetVariable(Left$(Strng, 2))
                  Call GetToken3
                  Call GetToken
                  Call Parse1(Temp#)
                  Call GetToken4
                  LastToken = True
                  Element = Temp#
                  Z = UBound(Arrays, 2)
                  If Element > Z Then
                     ReDim _Preserve Arrays(1024, Element) As Double
                  End If
                  Temp# = Arrays(V, Element)
               Else
                  ' multivar assign
                  Call GetConst(Strng, V2$, V3)
                  If V3 Then
                     Temp# = Val(V2$)
                  Else
                     V = GetVariable(Strng)
                     Temp# = Variables(V)
                  End If
                  LastToken = True
               End If
            Else
               If AllowAlpha Then
                  Out3 = Strng
               Else
                  Strng = "[" + Strng + "]"
                  Error 92
               End If
            End If
         End If
   End Select
End Sub

' parses FN(<x>)
Sub ParseFN (Temp#)
   Var$ = Left$(Out2, TokenIndex - 3)
   Call GetToken3
   Call GetToken
   Call Parse1(Temp4#)
   Call GetToken4
   Func& = CLng(Temp4#)
   If Func& >= 1 And Func& <= UBound(Definitions, 1) Then
      Var2$ = Mid$(Out2, TokenIndex)
      Out2 = Definitions$(Func&)
      Out2 = Strim$(Out2)
      ' test for nul token
      If Out2 = Nul Then
         Strng = "<bad FN token>"
         Error 148
         Exit Sub
      End If
      ' count recursing calls
      Recurse = Recurse + 1
      If Recurse > MaxRecurse Then
         Strng = "<bad FN recurse>"
         Error 148
         Exit Sub
      End If
      ' recursively call functions
      TokenIndex = 1
      Call GetToken
      Call Parse1(Temp#)
      ' test huge recursed FN
      If Len(Var$) + Len(Var2$) >= MaxFNlength Then
         Var$ = Nul
         Var2$ = Nul
         Strng = "<bad FN string>"
         Error 148
         Exit Sub
      End If
      ' re-concatenate equation
      Out2 = Var$ + Var2$
      TokenIndex = Len(Var$) + 1
      Exit Sub
   End If
   Strng = "<bad FN range>"
   Error 148
End Sub

' parses FZ(<x>)
Sub ParseFZ (Temp#)
   Call GetToken3
   Call GetToken
   Call Parse1(Temp4#)
   Call GetToken4
   Func& = CLng(Temp4#)
   If Func& >= 1 And Func& <= UBound(Definitions, 1) Then
      Out3 = Definitions$(Func&)
      Out3 = Strim$(Out3)
      If Out3 = Nul Then
         Strng = "<bad FN token>"
         Error 149
         Exit Sub
      End If
      LastToken = False
      Temp# = Dfalse
      Exit Sub
   End If
   Strng = "<bad FN range>"
   Error 149
End Sub

' parses out three-letter and greater variable tokens
Sub ParseAlphabetic3 (Temp#)

   ' check multivar
   If Len(Strng) = 3 Then
      x$ = Mid$(Strng, 1, 1)
      y$ = Mid$(Strng, 2, 1)
      z$ = Mid$(Strng, 3, 1)
      If LCase$(x$) >= "a" And LCase$(x$) <= "z" Then
         If y$ >= "0" And y$ <= "9" Then
            If z$ = "$" Then
               z$ = Left$(Strng, 2)
               ' multivar assign
               Call GetConst(Strng, V2$, V3)
               If V3 Then
                  Out3 = V2$
               Else
                  z = GetVariable(z$)
                  Out3 = Strngs(z)
               End If
               LastToken = False
               Exit Sub
            End If
         End If
      End If
   End If

   Select Case UCase$(Strng)
      ' default variables
      Case "COMMAND$"
         Out3 = Read.Command$
         LastToken = False
      Case "COMMANDNAME$"
         Out3 = Command$(0)
         LastToken = False
      Case "COMSPEC$"
         Out3 = Environ$("COMSPEC")
         LastToken = False
      Case "PI2" ' calculate PI radians
         Temp# = PI2
         LastToken = True
      Case "BEEP"
         Sound Freq, Duration
         Out3 = "Beep"
         LastToken = False
      Case "BADINPUT$"
         Out3 = BadInput
         LastToken = False
      Case "MELODY$"
         Out3 = Melody$
         LastToken = False
      Case "MELODY2$"
         Out3 = Melody2$
         LastToken = False
      Case "AUTHOR$"
         Out3 = AuthorStatus(1)
         LastToken = False
      Case "EMAIL$"
         Out3 = AuthorStatus(2)
         LastToken = False
      Case "URL$"
         Out3 = AuthorStatus(3)
         LastToken = False
      Case "NODE$"
         Out3 = Hex$(Node)
         LastToken = False
      Case "VERSION$"
         Out3 = "v" + Version$
         LastToken = False
      Case "RELEASE$"
         Out3 = "r" + Release$
         LastToken = False
      Case "YEARRELEASE$"
         Out3 = YearRelease$
         LastToken = False
      Case "PROGRAM$"
         Out3 = ProgramNameRelease$
         LastToken = False
      Case "PROGRAMNAME$"
         Out3 = ProgramName
         LastToken = False
      Case "PROGRAMFILE$"
         Out3 = StoredProgramName
         LastToken = False
      Case "PUBLISH$"
         Out3 = PublishDate
         LastToken = False
      Case "COOKIE$"
         Out3 = Cookie$
         LastToken = False

         ' special purpose functions
      Case "ISNT"
         Call GetToken
         Strng2$ = Strng
         Call GetToken
         Call Parse1(Temp4#)
         Out4 = Out3
         Temp3# = CaseValue
         Out3 = CaseStrng
         Strng = Strng2$
         Call Arith(Strng, Temp3#, Temp4#)
         ValueIs = Not Temp3#
         LastToken = 1
      Case "SCREEN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Xcoor# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Ycoor# = Temp#
         Temp# = Screen(Xcoor#, Ycoor#)
         Call GetToken4
         LastToken = True
      Case "SCREENX"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Xcoor# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Ycoor# = Temp#
         Temp# = Screen(Xcoor#, Ycoor#, 1)
         Call GetToken4
         LastToken = True
      Case "POINT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Xcoor# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Ycoor# = Temp#
         Temp# = Point(Xcoor#, Ycoor#)
         Call GetToken4
         LastToken = True
      Case "INFINITY"
         Temp# = 1D308 ' maximum large value
         LastToken = True

         ' color constants

         ' low intensity/background
      Case "BLACK"
         Temp# = 0
         LastToken = True
      Case "BBLUE"
         Temp# = 1
         LastToken = True
      Case "BGREEN"
         Temp# = 2
         LastToken = True
      Case "BCYAN"
         Temp# = 3
         LastToken = True
      Case "BRED"
         Temp# = 4
         LastToken = True
      Case "BMAGENTA"
         Temp# = 5
         LastToken = True
      Case "BYELLOW"
         Temp# = 6
         LastToken = True
      Case "PLAIN"
         Temp# = 7
         LastToken = True

         ' high intensity foreground
      Case "GRAY"
         Temp# = 8
         LastToken = True
      Case "BLUE"
         Temp# = 9
         LastToken = True
      Case "GREEN"
         Temp# = 10
         LastToken = True
      Case "CYAN"
         Temp# = 11
         LastToken = True
      Case "RED"
         Temp# = 12
         LastToken = True
      Case "MAGENTA"
         Temp# = 13
      Case "YELLOW"
         Temp# = 14
         LastToken = True
      Case "WHITE"
         Temp# = 15
         LastToken = True

         ' functions w/o parameters
      Case "CHRON"
         _ControlChr On
         Temp# = Dfalse
         LastToken = True
      Case "CHROFF"
         _ControlChr Off
         Temp# = Dfalse
         LastToken = True
      Case "CRLF"
         Out3 = CRLF
         LastToken = False
      Case "NUL", "NULL"
         Out3 = Nul
         LastToken = False
      Case "FALSE"
         Temp# = Dfalse
         LastToken = True
      Case "TRUE"
         Temp# = Dtrue
         LastToken = True
      Case "QUOTE$"
         Out3 = Quote
         LastToken = False
      Case "DOUBLEQUOTE$"
         Out3 = Quote + Quote
         LastToken = False
      Case "SINGLEQUOTE$"
         Out3 = "'"
         LastToken = False

         ' some file variables
      Case "MAXFILES"
         Temp# = CDbl(MaxFiles)
         LastToken = True
      Case "FREEFILE"
         FileNum% = FreeFile
         If FileNum% >= 1 And FileNum% <= MaxFiles Then
            Temp# = CDbl(FileNum%)
         Else
            Temp# = Dfalse
         End If
         LastToken = True
      Case "FILEFIELD"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         FileNum% = CInt(Temp#)
         If FileNum% >= 1 And FileNum% <= MaxFiles Then
            Out3 = FieldArray$(FileNum%)
         Else
            Out3 = Nul
         End If
         Call GetToken4
         LastToken = False
      Case "FIELDNAME"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         FileNum% = CInt(Temp#)
         If FileNum% >= 1 And FileNum% <= MaxFiles Then
            Out3 = FileFieldNames(FileNum%)
         Else
            Out3 = Nul
         End If
         Call GetToken4
         LastToken = False

         ' windows screen save
      Case "SCREENSAVE"
         s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
         Temp# = -1#
         LastToken = True
      Case "SCREENSAVE$"
         s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
         Out3 = "Screensave"
         LastToken = False

         ' remaining functions/variables
      Case "RND"
         Temp# = Rnd
         LastToken = True
      Case "POS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Pos(0)
         Call GetToken4
         Out3 = Nul
         LastToken = True
      Case "CSRLIN"
         Temp# = CsrLin
         LastToken = True
      Case "ERR"
         Temp# = CDbl(ErrorValue2)
         LastToken = True
      Case "ERL"
         Temp# = CDbl(ErrorLine)
         LastToken = True
      Case "ARRAYSIZE"
         Temp# = CDbl(ArraySize)
         LastToken = True

         ' boolean functions
      Case "AND"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# And Temp#
         Call GetToken4
         LastToken = True
      Case "MOD"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# Mod Temp#
         Call GetToken4
         LastToken = True
      Case "NOR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Not (Number# Or Temp#)
         Call GetToken4
         LastToken = True
      Case "NON"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Not (Number# Imp Temp#)
         Call GetToken4
         LastToken = True
      Case "XAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Not (Number# And Temp#)
         Call GetToken4
         LastToken = True
      Case "XOR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# Xor Temp#
         Call GetToken4
         LastToken = True
      Case "IMP"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# Imp Temp#
         Call GetToken4
         LastToken = True
      Case "EQV"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# Eqv Temp#
         Call GetToken4
         LastToken = True
      Case "NOT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Not Temp#
         Call GetToken4
         LastToken = True

         ' third-order boolean
      Case "TAND"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number1# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Number2# = Temp#
         Call GetToken4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# And Number2#
                     LastToken = True
                     Exit Sub
               End Select
         End Select
         Error 2
      Case "TOR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number1# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Number2# = Temp#
         Call GetToken4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# Or Number2#
                     LastToken = True
                     Exit Sub
               End Select
         End Select
         Error 2
      Case "TXOR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number1# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Number2# = Temp#
         Call GetToken4
         Select Case Number1#
            Case -1, 0, 1
               Select Case Number2#
                  Case -1, 0, 1
                     Temp# = Number1# Xor Number2#
                     LastToken = True
                     Exit Sub
               End Select
         End Select
         Error 2

         ' data constants
      Case "DATALINE"
         Temp# = DataLine
         LastToken = True
      Case "DATANUMBER"
         Temp# = DataNumber
         LastToken = True
         ' date/time functions
      Case "CLOCK"
         Temp# = Timer
         LastToken = True
      Case "NOW"
         Temp# = Timer
         LastToken = True
      Case "DATE$"
         Out3 = Date$
         LastToken = False
      Case "TIME$"
         Out3 = Time$
         LastToken = False
      Case "TIMER"
         Temp# = Timer
         LastToken = True

         ' input functions
      Case "INKEY$"
         ' read keyboard directly
         Locate , , Visible
         Out3 = InKeyx$
         LastToken = False
      Case "INPUT$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If Temp# <= Dfalse Or Temp# > MaxInt Then
            Error 2 ' syntax error
         End If
         Chars% = CInt(Temp#)
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp#)
            FileNum% = CInt(Temp#)
            If FileNum% <= 0 Or FileNum% > MaxFiles Then
               Error 126
               Exit Sub
            End If
            If FileTraps(FileNum%) Then
               ControlBreak = -2
               Exit Sub
            End If
            Out3 = Input$(Chars%, FileNum%)
         Else
            ' read keyboard directly
            Locate , , Visible
            Out3 = Nul
            Do
               I$ = InKeyx$
               If ControlBreak Then
                  ControlBreak = False
                  Exit Do
               End If
               If Len(I$) Then
                  If I$ = Chr$(3) Then
                     Eat$ = Nul
                  Else
                     Out3 = Out3 + I$ ' get character
                  End If
               End If
               If Len(Out3) >= Chars% Then ' check length
                  Exit Do
               End If
            Loop
         End If
         Call GetToken4
         LastToken = False
      Case "MELODY$"
         Out3 = Melody$
         LastToken = False
      Case "MELODY2$"
         Out3 = Melody2$
         LastToken = False
         ' special line printer functions
      Case "LPOS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         VarX = CInt(Temp#)
         If VarX >= 0 And VarX <= 3 Then
            Temp# = LPos(VarX)
         Else
            Error 161
         End If
         Call GetToken4
         Out3 = Nul
         LastToken = True
      Case "SETCPUTIMER"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         VarX! = CSng(Temp#)
         If VarX! >= 1! And VarX! <= 86400! Then
            t7! = VarX!
            Timer(t6) Off
            On Timer(t6, t7!) CPUtrap ' title with cpu
            Timer(t6) On
         Else
            Error 172
         End If
         Call GetToken4
         Out3 = Nul
         LastToken = True
      Case "SETBREAKTIMER"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         VarX! = CSng(Temp#)
         If VarX! >= 1! And VarX! <= 86400! Then
            t! = VarX!
            Timer(t1) Off
            On Timer(t1, t!) TimerTrap
            Timer(t1) On
         Else
            Error 172
         End If
         Call GetToken4
         Out3 = Nul
         LastToken = True
      Case "SETSTATUSTIMER"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         VarX! = CSng(Temp#)
         If VarX! >= 1! And VarX! <= 86400! Then
            t3! = VarX!
            Timer(t2) Off
            On Timer(t2, t3!) StatusLine
            Timer(t2) On
         Else
            Error 172
         End If
         Call GetToken4
         Out3 = Nul
         LastToken = True
      Case "LPRINT"
         Out3 = "LPRINT"
         LastToken = False
         ' beep override constants
      Case "BEEPOFF"
         MakeBeep = 0
         Out3 = "Beepoff"
         LastToken = False
      Case "BEEPON"
         MakeBeep = True
         Out3 = "Beepon"
         LastToken = False
         ' special debug constants
      Case "TEMPDIR$"
         Out3 = DRX$
         LastToken = False
      Case "NODE"
         Temp# = Node
         LastToken = True
      Case "DEBUG"
         Temp# = DebugActive
         LastToken = True
      Case "STDINENABLED"
         Temp# = ProgramResume
         LastToken = True
      Case "LLINES"
         Temp# = ListLines
         LastToken = True
      Case "LBOUND"
         Temp# = 1
         LastToken = True
      Case "UBOUND"
         Temp# = UBound(Arrays, 2)
         LastToken = True

         ' special input loop time slice releaser
      Case "SLICE" ' numeric
         Temp2$ = Mid$(Out2, 6)
         Temp2$ = Xtrim$(Temp2$, 0)
         Temp3# = LimitValue
         If Len(Temp2$) = False Then
            Temp3# = LimitValue
         Else
            ' optional parameter
            If Left$(Temp2$, 1) = "(" Then
               Call GetToken3
               Call GetToken
               Call Parse1(Temp3#)
               Call GetToken4
            Else
               Error 181
            End If
         End If
         If Temp3# > Dfalse Then
            _Limit CSng(Temp3#)
         End If
         Temp# = -1#
         LastToken = True
      Case "SLICE$" ' string
         Temp2$ = Mid$(Out2, 7)
         Temp2$ = Xtrim$(Temp2$, 0)
         Temp3# = LimitValue
         If Len(Temp2$) = False Then
            Temp3# = LimitValue
         Else
            ' optional parameter
            If Left$(Temp2$, 1) = "(" Then
               Call GetToken3
               Call GetToken
               Call Parse1(Temp3#)
               Call GetToken4
            Else
               Error 181
            End If
         End If
         If Temp3# > Dfalse Then
            _Limit CSng(Temp3#)
         End If
         Out3 = Nul
         LastToken = False

         ' conversion/calculation functions
      Case "BIN$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = _Bin$(Temp#)
         Call GetToken4
         LastToken = False
      Case "CHR$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Chr$(Temp#)
         Call GetToken4
         LastToken = False
      Case "HEX$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Hex$(Temp#)
         Call GetToken4
         LastToken = False
      Case "OCT$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Oct$(Temp#)
         Call GetToken4
         LastToken = False
      Case "STR$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Str$(Temp#)
         Call GetToken4
         LastToken = False
      Case "LCASE$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LCase$(Out3)
         Call GetToken4
         LastToken = False
      Case "UCASE$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = UCase$(Out3)
         Call GetToken4
         LastToken = False
      Case "LTRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Call GetToken4
         LastToken = False
      Case "RTRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = RTrim$(Out3)
         Call GetToken4
         LastToken = False
      Case "TRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Out3 = RTrim$(Out3)
         Call GetToken4
         LastToken = False
      Case "STRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Strim$(Out3)
         Call GetToken4
         LastToken = False
      Case "TTRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Out3 = RTrim$(Out3)
         Out3 = Ttrim$(Out3, True)
         Call GetToken4
         LastToken = False
      Case "UTRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Out3 = RTrim$(Out3)
         Out3 = Ttrim$(Out3, False)
         Call GetToken4
         LastToken = False
      Case "XTRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Out3 = RTrim$(Out3)
         Out3 = Xtrim$(Out3, True)
         Call GetToken4
         LastToken = False
      Case "ZTRIM$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = LTrim$(Out3)
         Out3 = RTrim$(Out3)
         Out3 = Xtrim$(Out3, False)
         Call GetToken4
         LastToken = False
      Case "STRIP$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         For Var1 = 1 To Len(WhiteSpace)
            V$ = Mid$(WhiteSpace, Var1, 1)
            While InStr(Out3, V$)
               Var2 = InStr(Out3, V$)
               Out3 = Left$(Out3, Var2 - 1) + Mid$(Out3, Var2 + 1)
            Wend
         Next
         Call GetToken4
         LastToken = False
      Case "SPACE$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Space$(CInt(Temp#))
         Call GetToken4
         LastToken = False
      Case "FORMATS$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = FormatString$(Temp#)
         Call GetToken4
         LastToken = False
      Case "FORMAT$"
         ' force print using to file.
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken = False Then ' string
            If LCase$(Out3) = "now" Then
               LastToken = True
               Temp# = Timer
            End If
         End If
         If LastToken = True Then ' numeric
            StoredValue = Temp#
            Call GetToken
            Call Parse1(Temp#)
            Call GetToken4
            If LastToken = False Then ' string
               StoredString$ = Out3
               LastToken = False
               ' get temp file.
               Do
                  TempFilename$ = TempName$ + ".sc3"
                  If _FileExists(TempFilename$) = False Then
                     Exit Do
                  End If
               Loop
               ' write print using to file.
               X = FreeFile
               Open TempFilename$ For Output As #X
               Out2 = "XPRINT(" + LTrim$(Str$(StoredValue)) + "," + Quote + StoredString$ + Quote + ")"
               Call XprintExpression(X, z)
               ' read print using from file.
               Out3 = Nul
               If z Then
                  Close #X
                  If _FileExists(TempFilename$) Then
                     Open TempFilename$ For Input As #X
                     If EOF(X) = 0 Then
                        Line Input #X, Out3
                     End If
                     Close #X
                  End If
               End If
               f$ = TempFilename$ + Chr$(0)
               r = DeleteFileA(f$)
            Else
               Strng = "<format$ string error>"
               Error 92
            End If
         Else
            Strng = "<format$ value error>"
            Error 92
         End If
      Case "MID$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         StoredString$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         Temp4# = Temp#
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp#)
            Length# = Temp#
            Out3 = Mid$(StoredString$, Temp4#, Length#)
         Else
            Out3 = Mid$(StoredString$, Temp4#)
         End If
         Call GetToken4
         LastToken = False
      Case "REMID$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         StoredString$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         Temp4# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Length# = Temp#
         Out3 = Left$(StoredString$, Temp4# - 1) + Mid$(StoredString$, Temp4# + Length#)
         Call GetToken4
         LastToken = False
      Case "DEMID$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         String1$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         If Len(String1$) > False And Len(Out3) > False Then
            Imbedded = InStr(String1$, Out3)
            While Imbedded
               String1$ = Left$(String1$, Imbedded - 1) + Mid$(String1$, Imbedded + Len(Out3))
               Imbedded = InStr(String1$, Out3)
            Wend
         End If
         Out3 = String1$
         Call GetToken4
         LastToken = False
      Case "REPLACE$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         String1$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         String2$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         String3$ = Out3
         If String1$ = Nul Or String2$ = Nul Or String2$ = String3$ Then
            Out3 = String1$
            Exit Sub
         End If
         Temp1 = 1
         Do
            If String1$ = Nul Then
               Exit Do
            End If
            Var1 = InStr(Temp1, String1$, String2$)
            If Var1 = False Then
               Exit Do
            End If
            String1$ = Left$(String1$, Var1 - 1) + String3$ + Mid$(String1$, Var1 + Len(String2$))
            Temp1 = Temp1 + Len(String3$)
         Loop
         Out3 = String1$
         Call GetToken4
         LastToken = False
      Case "LEFT$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         StoredString$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Left$(StoredString$, Temp#)
         Call GetToken4
         LastToken = False
      Case "CONST"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         ConstString$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            ConstValue$ = Str$(Temp#)
         Else
            ConstValue$ = Out3
         End If
         Call GetToken4
         LastToken = True
         Call StoreConst(ConstString$, ConstValue$)
      Case "CONST$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         ConstString$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            ConstValue$ = Str$(Temp#)
         Else
            ConstValue$ = Out3
         End If
         Call GetToken4
         LastToken = False
         Call StoreConst(ConstString$, ConstValue$)
      Case "RIGHT$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         StoredString$ = Out3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Right$(StoredString$, Temp#)
         Call GetToken4
         LastToken = False
      Case "STRING$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Out3 = String$(Number#, Temp#)
         Else
            Out3 = String$(Number#, Out3)
         End If
         Call GetToken4
         LastToken = False
      Case "ENCRYPT$"
         PrimeKey2 = PrimeKey
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         V$ = Out3
         Token2 = LastToken
         If Strng = "," Or Strng = ";" Then
            Call GetToken
            Call Parse1(Temp2#)
            PrimeKey2 = Temp2#
         End If
         Out3 = V$
         If Token2 Then
            Out3 = Chr$(Temp# Xor PrimeKey2)
         Else
            For V = 1 To Len(Out3)
               Mid$(Out3, V, 1) = Chr$(Asc(Mid$(Out3, V, 1)) Xor PrimeKey2)
            Next
         End If
         Call GetToken4
         LastToken = False
      Case "STOPWAV" ' stops .wav file
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            VarX = CInt(Temp#)
            _SndStop VarX
         End If
         Call GetToken4
         LastToken = True
      Case "WAV" ' plays .wav file
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            VarX = CInt(Temp#)
            If VarX >= 1 And VarX <= 12 Then
               Out3 = Nul
               Select Case VarX
                  Case 1
                     Out3 = "Laser.wav"
                  Case 2
                     Out3 = "Ringin.wav"
                  Case 3
                     Out3 = "Carrier.wav"
                  Case 4
                     Out3 = "Boing.wav"
                  Case 5
                     Out3 = "Bang.wav"
                  Case 6
                     Out3 = "Connect.wav"
                  Case 7
                     Out3 = "Complete.wav"
                  Case 8
                     Out3 = "Gunshot.wav"
                  Case 9
                     Out3 = "Ricochet.wav"
                  Case 10
                     Out3 = "Whoosh.wav"
                  Case 11
                     Out3 = "Glass.wav"
                  Case 12
                     Out3 = "Cashreg.wav"
                  Case Else
                     Error 92
                     Exit Sub
               End Select
            End If
         End If
         Temp# = Dtrue
         z$ = Out3
         If LCase$(Left$(z$, 4)) = "move" Then
            If SoundHandle <> 0 Then
               z$ = LTrim$(Mid$(z$, 5))
               If Left$(z$, 1) = "+" Then
                  z! = Val(Mid$(z$, 2))
                  z2! = _SndGetPos(SoundHandle)
                  z2! = z2! + z!
                  _SndSetPos SoundHandle, z2!
                  Call GetToken4
                  LastToken = True
                  Exit Sub
               End If
               If Left$(z$, 1) = "-" Then
                  z! = Val(Mid$(z$, 2))
                  z2! = _SndGetPos(SoundHandle)
                  z2! = z2! - z!
                  If z2! > SFalse Then
                     _SndSetPos SoundHandle, z2!
                  End If
                  Exit Sub
               End If
               If LTrim$(RTrim$(z$)) = Nul Then
                  z! = 10!
               Else
                  z! = Val(z$)
               End If
               z2! = _SndGetPos(SoundHandle)
               z2! = z2! + z!
               _SndSetPos SoundHandle, z2!
               Call GetToken4
               LastToken = True
               Exit Sub
            End If
         End If
         If LCase$(Out3) = "stop" Then
            If SoundHandle <> 0 Then
               _SndStop SoundHandle
               _SndClose SoundHandle
               SoundHandle = 0
               Temp# = Dfalse
            Else
               Temp# = Dfalse
               Error 170
            End If
         Else
            If LCase$(Out3) = "pause" Then
               If SoundHandle <> 0 Then
                  Temp# = Dfalse
                  If _SndPaused(SoundHandle) = False Then
                     _SndPause SoundHandle
                  Else
                     Temp# = Dfalse
                     Error 170
                  End If
               End If
            Else
               If LCase$(Out3) = "resume" Then
                  If SoundHandle <> 0 Then
                     Temp# = Dfalse
                     If _SndPaused(SoundHandle) = True Then
                        _SndPlay SoundHandle
                     End If
                  Else
                     Temp# = Dfalse
                     Error 170
                  End If
               Else
                  If _FileExists(Out3) Then
                     If VerifyPlay(Out3) Then
                        SoundHandle = _SndOpen(Out3) ' get file handle
                        If SoundHandle = False Then
                           Temp# = Dfalse
                           Error 170
                        Else
                           Temp# = SoundHandle
                           _SndPlay SoundHandle
                        End If
                     Else
                        Temp# = Dfalse
                        Error 170
                     End If
                  Else
                     Temp# = Dfalse
                     Error 53
                  End If
               End If
            End If
         End If
         Call GetToken4
         LastToken = True

         ' plays music file
         '   supports file types:
         '     WAV, AIFF, AIFC, FLAC, OGG, MP3, IT, XM, S3M, MOD,
         '     RAD, AHX, HVL, MUS, HMI, HMP, HMQ, KAR, LDS, MDS,
         '     MIDS, RCP, R36, G18, G36, RMI, MID, MIDI, XFM, XMI, QOA
      Case "WAV$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Out3 = Nul
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 9 Then
               Select Case Var
                  Case 1
                     Out3 = "addctdto.mid"
                  Case 2
                     Out3 = "africa.mid"
                  Case 3
                     Out3 = "burning.mid"
                  Case 4
                     Out3 = "hotel.mid"
                  Case 5
                     Out3 = "imagine5.mid"
                  Case 6
                     Out3 = "panama.mid"
                  Case 7
                     Out3 = "stayin.mid"
                  Case 8
                     Out3 = "strshptr.mid"
                  Case 9
                     Out3 = "wtj.mid"
               End Select
            End If
         End If
         Temp# = Dtrue
         z$ = Out3
         If LCase$(Left$(z$, 4)) = "move" Then
            If SoundHandle <> 0 Then
               z$ = LTrim$(Mid$(z$, 5))
               If Left$(z$, 1) = "+" Then
                  z! = Val(Mid$(z$, 2))
                  z2! = _SndGetPos(SoundHandle)
                  z2! = z2! + z!
                  _SndSetPos SoundHandle, z2!
                  Call GetToken4
                  LastToken = True
                  Exit Sub
               End If
               If Left$(z$, 1) = "-" Then
                  z! = Val(Mid$(z$, 2))
                  z2! = _SndGetPos(SoundHandle)
                  z2! = z2! - z!
                  If z2! > SFalse Then
                     _SndSetPos SoundHandle, z2!
                  End If
                  Exit Sub
               End If
               If LTrim$(RTrim$(z$)) = Nul Then
                  z! = 10!
               Else
                  z! = Val(z$)
               End If
               z2! = _SndGetPos(SoundHandle)
               z2! = z2! + z!
               _SndSetPos SoundHandle, z2!
               Call GetToken4
               LastToken = True
               Exit Sub
            End If
         End If
         If LCase$(Out3) = "stop" Then
            If SoundHandle <> 0 Then
               _SndStop SoundHandle
               _SndClose SoundHandle
               SoundHandle = False
               Temp# = Dfalse
            Else
               Temp# = Dfalse
               Error 170
            End If
         Else
            If LCase$(Out3) = "pause" Then
               If SoundHandle <> 0 Then
                  Temp# = Dfalse
                  If _SndPaused(SoundHandle) = False Then
                     _SndPause SoundHandle
                  Else
                     Temp# = Dfalse
                     Error 170
                  End If
               End If
            Else
               If LCase$(Out3) = "resume" Then
                  If SoundHandle <> 0 Then
                     Temp# = Dfalse
                     If _SndPaused(SoundHandle) = True Then
                        _SndPlay SoundHandle
                     End If
                  Else
                     Temp# = Dfalse
                     Error 170
                  End If
               Else
                  If _FileExists(Out3) Then
                     If VerifyPlay(Out3) Then
                        SoundHandle = _SndOpen(Out3) ' get file handle
                        If SoundHandle = False Then
                           Temp# = Dfalse
                           Error 170
                        Else
                           Temp# = SoundHandle
                           _SndPlay SoundHandle
                        End If
                     Else
                        Temp# = Dfalse
                        Error 170
                     End If
                  Else
                     Temp# = Dfalse
                     Error 53
                  End If
               End If
            End If
         End If
         Call GetToken4
         LastToken = True

         ' gets/sets music file functions.
         '   supports file types:
         '     WAV, AIFF, AIFC, FLAC, OGG, MP3, IT, XM, S3M, MOD,
         '     RAD, AHX, HVL, MUS, HMI, HMP, HMQ, KAR, LDS, MDS,
         '     MIDS, RCP, R36, G18, G36, RMI, MID, MIDI, XFM, XMI, QOA
      Case "WAVPAUSE"
         Temp# = Dfalse
         If SoundHandle <> 0 Then
            If _SndPaused(SoundHandle) = False Then
               _SndPause SoundHandle
            End If
         End If
         LastToken = True
      Case "WAVRESUME"
         Temp# = Dfalse
         If SoundHandle <> 0 Then
            If _SndPaused(SoundHandle) = True Then
               _SndPlay SoundHandle
            End If
         End If
         LastToken = True
      Case "WAVSTOP"
         Temp# = Dfalse
         If SoundHandle <> 0 Then
            _SndStop SoundHandle
            _SndClose SoundHandle
            SoundHandle = 0
         End If
         LastToken = True
      Case "WAVLEN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Dfalse
         If _FileExists(Out3) Then
            If VerifyPlay(Out3) Then
               h = _SndOpen(Out3) ' get file handle
               If h = 0 Then
                  Temp# = Dfalse
                  Error 170
               End If
               If h > 0 Then
                  Temp# = _SndLen(h)
                  T$ = Str$(Temp#)
                  If InStr(T$, ".") Then
                     T$ = Left$(T$, InStr(T$, ".") + 2)
                     Temp# = Val(T$)
                  End If
                  _SndClose h
               End If
            Else
               Temp# = Dfalse
               Error 170
            End If
         Else
            Error 53
         End If
         Call GetToken4
         LastToken = True

         ' constant functions
      Case "ERROR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Error CInt(Temp#)
         Call GetToken4
         LastToken = True
      Case "OS$"
         Out3 = _OS$
         LastToken = False
      Case "MACHINE$"
         ' check net path.
         Out3 = Nul
         Var$ = Environ$("COMPUTERNAME")
         If Len(Var$) Then
            Out3 = Var$
         End If
         LastToken = False
      Case "PRIMEKEY"
         Temp# = PrimeKey
         LastToken = True
      Case "TICKS"
         Temp# = 18.20648
         LastToken = True
      Case "MAXINT"
         Temp# = CDbl(MaxInt)
         LastToken = True
      Case "MAXLONG"
         Temp# = CDbl(MaxLong)
         LastToken = True
      Case "MAXSINGLE"
         Temp# = CDbl(MaxSingle)
         LastToken = True
      Case "LONG"
         Temp# = MaxLong
         LastToken = True
         ' numeric/string constant functions
      Case "LASTLINE"
         Temp# = LastLine
         LastToken = True
      Case "LINENUMBER"
         Temp# = ProgramLine
         LastToken = True
      Case "PROGRAMLINE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var2 = CInt(Temp#)
         If Var2 > False And Var2 <= MaxLines Then
            If Len(Program(Var2)) <> False Then
               Out3 = Program(Var2)
            End If
         End If
         Call GetToken4
         LastToken = False
      Case "CLEARHISTORY"
         ' reset multi-dimensional command history arrays
         For VarQ1 = 1 To 5
            HistoryCount2(VarQ1) = 0
            For VarQ2 = 1 To MaxHistory
               History2(VarQ1, VarQ2) = Nul
            Next
         Next
         Temp# = MaxHistory
         LastToken = True
      Case "HISTORYCOUNT"
         Call GetToken
         Call GetToken
         Call Parse1(Temp#)
         Var1 = CInt(Temp#)
         If Var1 >= 1 And Var1 <= 5 Then
            Temp# = HistoryCount2(Var1)
         End If
         Call GetToken4
         LastToken = True
      Case "HISTORY"
         Call GetToken
         Call GetToken
         Call Parse1(Temp#)
         Var1 = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         Var2 = CInt(Temp#)
         If Var1 >= 1 And Var1 <= 5 Then
            If Var2 > False And Var2 <= MaxHistory Then
               If Len(RTrim$(History2(Var1, Var2))) <> False Then
                  Out3 = RTrim$(History2(Var1, Var2))
               End If
            End If
         End If
         Call GetToken4
         LastToken = False
      Case "MAXARRAYS"
         Temp# = MaxArrays
         LastToken = True
      Case "MAXFUNCTIONS"
         Temp# = MaxFunctions
         LastToken = True
      Case "MAXHISTORY"
         Temp# = MaxHistory
         LastToken = True
      Case "MAXLINES"
         Temp# = MaxLines
         LastToken = True
      Case "MAXFNLENGTH"
         Temp# = MaxFNlength
         LastToken = True
      Case "MAXNESTGOSUB"
         Temp# = MaxNestGosub
         LastToken = True
      Case "MAXRECURSE"
         Temp# = MaxRecurse
         LastToken = True
         ' other functions
      Case "PMAP"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number% = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         MapType% = CInt(Temp#)
         Temp# = PMap(Number%, MapType%)
         Call GetToken4
         LastToken = True
      Case "VARSEG"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            VarSeg2 = Temp#
            Temp# = VarSeg(VarSeg2)
            If Temp# < Dfalse Then
               Temp# = Temp# + 65536#
            End If
         Else
            Length = Len(Out3)
            ReDim VarSeg3(1 To Length) As Integer
            For Count = 1 To Length
               VarSeg3(Count) = Asc(Mid$(Out3, Count, 1))
            Next
            Temp# = VarSeg(VarSeg3(1))
            If Temp# < Dfalse Then
               Temp# = Temp# + 65536#
            End If
         End If
         Call GetToken4
         LastToken = True
      Case "VARPTR$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            VarSeg2 = Temp#
            Out3 = VarPtr$(VarSeg2)
         Else
            VarSeg1 = Out3
            Out3 = VarPtr$(VarSeg1)
         End If
         Call GetToken4
         LastToken = False
      Case "VARPTR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            VarSeg2 = Temp#
            Temp# = VarPtr(VarSeg2)
            If Temp# < Dfalse Then
               Temp# = Temp# + 65536#
            End If
         Else
            Length = Len(Out3)
            ReDim VarSeg3(1 To Length) As Integer
            For Count = 1 To Length
               VarSeg3(Count) = Asc(Mid$(Out3, Count, 1))
            Next
            Temp# = VarPtr(VarSeg3(1))
            If Temp# < Dfalse Then
               Temp# = Temp# + 65536#
            End If
         End If
         Call GetToken4
         LastToken = True
      Case "BUFFER"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         CaseValue = Temp#
         Select Case CaseValue
            Case 1
               Temp# = VarSeg2
               LastToken = True
            Case 2
               Out3 = Nul
               Length = UBound(VarSeg3)
               For Count = 1 To Length
                  Out3 = Out3 + Chr$(VarSeg3(Count))
               Next
               LastToken = False
            Case 3
               Elements = Int((ArraySize + 1) / 2)
               For Count = 1 To Elements
                  GraphicsScreen(Count) = VarSeg3(Count)
               Next
               LastToken = True
         End Select
         Call GetToken4
      Case "GRPHSEG"
         Elements = Int((ArraySize + 1) / 2)
         ReDim VarSeg3(1 To Elements) As Integer
         For Count = 1 To Elements
            VarSeg3(Count) = GraphicsScreen(Count)
         Next
         Temp# = VarSeg(VarSeg3(1))
         LastToken = True
      Case "GRPHPTR"
         Elements = Int((ArraySize + 1) / 2)
         ReDim VarSeg3(1 To Elements) As Integer
         For Count = 1 To Elements
            VarSeg3(Count) = GraphicsScreen(Count)
         Next
         Temp# = VarPtr(VarSeg3(1))
         LastToken = True
      Case "PLAY"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Play(Temp#)
         Call GetToken4
         LastToken = True
         ' more numeric functions
      Case "ABS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Abs(Temp#)
         Call GetToken4
         LastToken = True
      Case "ASC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Asc(Out3)
         Call GetToken4
         LastToken = True
      Case "EXP"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Exp(Temp#)
         Call GetToken4
         LastToken = True
      Case "FBN" ' calculate xth fibonachi value
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         FiboA# = 1
         FiboB# = 1
         If Temp# >= 1 Then
            For FiboNumber# = 1 To Temp# - 1
               FiboTemp# = FiboB#
               FiboB# = FiboA# + FiboB#
               FiboA# = FiboTemp#
            Next
         End If
         Temp# = FiboB#
         Call GetToken4
         LastToken = True
      Case "FCT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Factorial# = 1
         FactorialCount# = Int(Temp#)
         If FactorialCount# >= 1 Then
            For FactorialCount# = 1 To Temp#
               Factorial# = Factorial# * FactorialCount#
            Next
         End If
         Temp# = Factorial#
         Call GetToken4
         LastToken = True
      Case "FIX"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Fix(Temp#)
         Call GetToken4
         LastToken = True
      Case "INP"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Inp(CInt(Temp#))
         Call GetToken4
         LastToken = True
      Case "INSTR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Temp4# = Temp#
            Call GetToken
            Call Parse1(Temp#)
            StoredString$ = Out3
            Call GetToken
            Call Parse1(Temp#)
            Temp# = InStr(Temp4#, StoredString$, Out3)
         Else
            StoredString$ = Out3
            Call GetToken
            Call Parse1(Temp#)
            Temp# = InStr(StoredString$, Out3)
         End If
         Call GetToken4
         LastToken = True
      Case "INT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Int(Temp#)
         Call GetToken4
         LastToken = True
      Case "CINT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = CInt(Temp#)
         Call GetToken4
         LastToken = True
      Case "CSNG", "CLNG", "CDBL"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call GetToken4
         LastToken = True
      Case "LEN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = CDbl(Len(Out3))
         Call GetToken4
         LastToken = True
      Case "LOG"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log(Temp#)
         Call GetToken4
         LastToken = True
      Case "GCM"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number1# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Number2# = Temp#
         ' find last factor which divides into both numbers
         Factor1# = 1
         Number3# = Number1#
         For Factor2# = 2 To Number1#
            Do
               If Number3# / Factor2# = Number3# \ Factor2# Then
                  If Number2# / Factor2# = Number2# \ Factor2# Then
                     If Factor2# > Factor1# Then
                        Factor1# = Factor2#
                     End If
                  End If
                  Number3# = Number3# / Factor2#
               Else
                  Exit Do
               End If
            Loop
         Next
         Temp# = Factor1#
         Call GetToken4
         LastToken = True
      Case "LCD"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number1# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Number2# = Temp#
         ' find first factor which divides into both numbers
         Factor1# = 0
         For Factor2# = 2 To Number1#
            If Number1# / Factor2# = Number1# \ Factor2# Then
               If Number2# / Factor2# = Number2# \ Factor2# Then
                  Factor1# = Factor2#
                  Exit For
               End If
            End If
         Next
         If Factor1# = Dfalse Then
            Factor1# = 1#
         End If
         If Factor1# = Number2# Then
            Factor1# = 1#
         End If
         Temp# = Factor1#
         Call GetToken4
         LastToken = True
      Case "ISNUM"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = IsNumeric(Out3)
         Call GetToken4
         LastToken = True
      Case "ISEVEN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (Temp# Mod 2#) = Dfalse
         Call GetToken4
         LastToken = True
      Case "ISODD"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (Temp# Mod 2#) = 1#
         Call GetToken4
         LastToken = True
      Case "ISPRM" ' calculate x is prime
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         ControlBreak = 0
         Prime# = Int(Temp#)
         PrimeFlag = True
         If Prime# <= 1# Then
            PrimeFlag = 0
         End If
         If Prime# > 2# Then
            For LoopCount# = 2# To Int(Sqr(Prime#))
               Call Check.Program(0)
               If ControlBreak Then
                  Exit For
               End If
               If Prime# / LoopCount# = Int(Prime# / LoopCount#) Then
                  PrimeFlag = False
                  Exit For
               End If
            Next
         End If
         If PrimeFlag = False Then
            Temp# = Dfalse
         Else
            Temp# = Dtrue
         End If
         Call GetToken4
         LastToken = True
      Case "PRF" ' calculate nth perfect number
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Perfect# = Int(Temp#)
         Select Case Perfect# ' x = 1,2,4,6,12,16,18,30
            Case 1#
               X# = 1#
            Case 2#
               X# = 2#
            Case 3#
               X# = 4#
            Case 4#
               X# = 6#
            Case 5#
               X# = 12#
            Case 6#
               X# = 16#
            Case 7#
               X# = 18#
            Case Else
               Error 131
         End Select
         ' equation for perfect number
         Temp# = 2 ^ X# * (2 ^ (X# + 1) - 1)
         Call GetToken4
         LastToken = True
      Case "PRM" ' calculate xth prime
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         ControlBreak = 0
         PrimeNumber# = Int(Temp#)
         If PrimeNumber# <= Dfalse Then
            Prime# = 0
         End If
         If PrimeNumber# = 1# Then
            Prime# = 2
         End If
         If PrimeNumber# > 1# Then
            PrimeCounter# = False
            PrimeNumber# = PrimeNumber# + 1#
            $Checking:Off
            Do
               Prime# = Prime# + 1
               PrimeFlag = False
               For Factor# = 2 To Int(Sqr(Prime#))
                  Call Check.Program(0)
                  If ControlBreak Then
                     Exit Do
                  End If
                  If Prime# / Factor# = Int(Prime# / Factor#) Then
                     PrimeFlag = True
                     Exit For
                  End If
               Next
               If PrimeFlag = False Then
                  PrimeCounter# = PrimeCounter# + 1
               End If
               If PrimeCounter# = PrimeNumber# Then
                  Exit Do
               End If
            Loop
            $Checking:On
         End If
         Temp# = Prime#
         Call GetToken4
         LastToken = True
      Case "SGN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Sgn(Temp#)
         Call GetToken4
         LastToken = True
      Case "SQR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If Temp# < Dfalse Then
            Error 157
         Else
            Temp# = Sqr(Temp#)
         End If
         Call GetToken4
         LastToken = True
      Case "CBR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Temp# ^ (1# / 3#)
         Call GetToken4
         LastToken = True
      Case "NTH"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# ^ (1# / Temp#)
         Call GetToken4
         LastToken = True
      Case "PWR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Number# ^ Temp#
         Call GetToken4
         LastToken = True
      Case "VAL"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Val(Out3)
         Call GetToken4
         LastToken = True
      Case "PEEK"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Peek(Temp#)
         Call GetToken4
         LastToken = True
      Case "MKI$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = MKI$(Temp#)
         Call GetToken4
         LastToken = False
      Case "MKS$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = MKS$(Temp#)
         Call GetToken4
         LastToken = False
      Case "MKD$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = MKD$(Temp#)
         Call GetToken4
         LastToken = False
      Case "CVI"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = CVI(Out3)
         Call GetToken4
         LastToken = True
      Case "CVS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = CVS(Out3)
         Call GetToken4
         LastToken = True
      Case "CVD"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = CVD(Out3)
         Call GetToken4
         LastToken = True
      Case "EOF"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp3#)
         Temp# = EOF(CInt(Temp3#))
         Call GetToken4
         LastToken = True
      Case "LOC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp3#)
         Temp# = Loc(CInt(Temp3#))
         Call GetToken4
         LastToken = True
      Case "LOF"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp3#)
         Temp# = LOF(CInt(Temp3#))
         Call GetToken4
         LastToken = True
      Case "EOD" ' end-of-data
         AllowExtra = 1
         Call GetToken3
         Call GetToken
         Call Parse1(Temp3#)
         Call GetToken4

         ' search for data statement
         X = False
         For V = 1 To LastLine
            V$ = Program(V)
            V$ = Strim$(V$)
            V$ = UCase$(V$)
            If Left$(V$, 4) = "DATA" Then
               X = True
               Exit For
            End If
         Next
         If X = False Then
            Temp# = Dtrue
            Out3 = "-1"
            LastToken = True
            AllowExtra = 0
            Exit Sub
         End If

         V1 = DataLine
         V2 = DataNumber
         StoredOut2$ = Out2
         StoredTokenIndex = TokenIndex
         Call ReadDataElement(Var)
         DataLine = V1
         DataNumber = V2
         Out2 = StoredOut2$
         TokenIndex = StoredTokenIndex

         Temp# = CDbl(Var)
         Out3 = Str$(Var)
         LastToken = True
         AllowExtra = 0
      Case "TOD" ' type-of-data
         AllowExtra = 1
         Call GetToken3
         Call GetToken
         Call Parse1(Temp3#)
         Call GetToken4

         ' search for data statement
         X = False
         For V = 1 To LastLine
            V$ = Program(V)
            V$ = Strim$(V$)
            V$ = UCase$(V$)
            If Left$(V$, 4) = "DATA" Then
               X = True
               Exit For
            End If
         Next
         If X = False Then
            Temp# = False
            Out3 = "0"
            LastToken = True
            AllowExtra = 0
            Exit Sub
         End If

         V1 = DataLine
         V2 = DataNumber
         StoredOut2$ = Out2
         StoredTokenIndex = TokenIndex
         Call ReadDataElement(Var)
         DataLine = V1
         DataNumber = V2
         Out2 = StoredOut2$
         TokenIndex = StoredTokenIndex

         ' store datatype of next data element
         If Var = False Then
            If LastToken Then
               Temp# = 1# ' numeric
            Else
               Temp# = 2# ' string
            End If
         Else
            Temp# = Dfalse ' no more data
         End If
         LastToken = True
         Out3 = Str$(Temp#)
         AllowExtra = 0
      Case "ISDATA" ' is-type-of-data
         AllowExtra = 1
         Call GetToken3
         Call GetToken
         Call Parse1(Temp3#)
         Call GetToken4
         SearchType = Temp3#

         ' search for data statement
         X = False
         For V = 1 To LastLine
            V$ = Program(V)
            V$ = Strim$(V$)
            V$ = UCase$(V$)
            If Left$(V$, 4) = "DATA" Then
               X = True
               Exit For
            End If
         Next
         If X = False Then
            If SearchType = False Then
               Temp# = Dtrue
               Out3 = "-1"
            Else
               Temp# = False
               Out3 = "0"
            End If
            LastToken = True
            AllowExtra = False
            Exit Sub
         End If

         V1 = DataLine
         V2 = DataNumber
         StoredOut2$ = Out2
         StoredTokenIndex = TokenIndex
         Call ReadDataElement(Var)
         DataLine = V1
         DataNumber = V2
         Out2 = StoredOut2$
         TokenIndex = StoredTokenIndex

         ' store datatype of next data element
         Temp# = Dfalse
         Select Case SearchType
            Case 0 ' more data
               If Var Then
                  Temp# = Dtrue
               End If
            Case 1 ' numeric
               If Var = False Then
                  If LastToken Then
                     Temp# = Dtrue
                  End If
               End If
            Case 2 ' string
               If Var = False Then
                  If LastToken = False Then
                     Temp# = Dtrue
                  End If
               End If
         End Select

         LastToken = True
         Out3 = Str$(Temp#)
         AllowExtra = 0
         ' disk functions
      Case "CAPITALIZE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call Capitalize(Out3)
         Call GetToken4
         LastToken = False
      Case "SUFFIX"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call Suffix(Temp#, Out3)
         Call GetToken4
         LastToken = False
      Case "FILEEXISTS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = _FileExists(Out3)
         Call GetToken4
         LastToken = True
      Case "DIREXISTS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = _DirExists(Out3)
         Call GetToken4
         LastToken = True
      Case "DRIVEEXISTS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var$ = Nul
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Var$ = Chr$(Var + 64)
            End If
         Else
            Var = Asc(UCase$(Out3))
            If Var >= 65 And Var <= 90 Then
               Var$ = Chr$(Var)
               Var = Var - 64
            End If
         End If
         Temp# = Dfalse
         If Len(Var$) Then
            Out3 = Var$
            If DRIVEEXISTS(Var) = False Then
               Temp# = Dtrue
            End If
         End If
         Call GetToken4
         LastToken = True
      Case "DRIVETYPE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var$ = Nul
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Var$ = Chr$(Var + 64)
            End If
         Else
            Var = Asc(UCase$(Out3))
            If Var >= 65 And Var <= 90 Then
               Var$ = Chr$(Var)
               Var = Var - 64
            End If
         End If
         Out3 = Nul
         If Len(Var$) Then
            If DRIVEEXISTS(Var) = False Then
               Out3 = DriveType
            End If
         End If
         Call GetToken4
         LastToken = False
      Case "AMBIG2$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Ambiguate2$(Out3)
         Call GetToken4
         LastToken = False
      Case "AMBIG$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = Ambiguate$(Out3)
         Call GetToken4
         LastToken = False
      Case "CURDIR$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Out3 = _CWD$
         Call GetToken4
         LastToken = False
      Case "ENVIRON$"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            Out3 = Environ$(Var)
         Else
            Out3 = Environ$(Out3)
         End If
         Call GetToken4
         LastToken = False
      Case "DIR$", "FILEDIR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         VarX$ = Out3
         Call FileDir(VarX$)
         Call GetToken4
         LastToken = False
      Case "DIRX$", "FILEDIRX"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         VarX$ = Out3
         Call FileDirX(VarX$)
         Call GetToken4
         LastToken = False
      Case "FILES"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call ListFilesX(Out3, True)
         ErrorType2 = 0
         Call GetToken4
         LastToken = False
      Case "DIRS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call ListFilesX(Out3, False)
         ErrorType2 = 0
         Call GetToken4
         LastToken = False
      Case "DRIVES"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var = 0
         Var$ = Nul
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 0 And Var <= 26 Then
               Call ListDrives("", Var)
               Temp# = Dtrue
            Else
               Temp# = Dfalse
            End If
         Else
            Var$ = UCase$(Out3)
            Call ListDrives(Var$, 0)
            Temp# = Dtrue
         End If
         Call GetToken4
         LastToken = True
      Case "FILEDATE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call FileDate(Out3)
         Call GetToken4
         LastToken = False
      Case "FILETIME"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call FileTime(Out3)
         Call GetToken4
         LastToken = False
      Case "FILESIZE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call FileSize(Temp#)
         Call GetToken4
         LastToken = True
      Case "FILEATTR"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call FileAttr(Temp#)
         Call GetToken4
         LastToken = True
      Case "FILESTATUS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call EncryptionFileStatus(Temp#)
         Call GetToken4
         LastToken = True
      Case "FILEBITS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call FileAttr(Temp#)
         Call GetToken4
         Out3 = Space$(7)
         If (Temp# And &H20) = &H20 Then
            Mid$(Out3, 1, 1) = "A" ' archive
         End If
         If (Temp# And &H10) = &H10 Then
            Mid$(Out3, 2, 1) = "D" ' directory
         End If
         If (Temp# And &H4) = &H4 Then
            Mid$(Out3, 3, 1) = "S" ' system
         End If
         If (Temp# And &H2) = &H2 Then
            Mid$(Out3, 4, 1) = "H" ' hidden
         End If
         If (Temp# And &H1) = &H1 Then
            Mid$(Out3, 5, 1) = "R" ' read-only
         End If
         If (Temp# And &H800) = &H800 Then
            Mid$(Out3, 6, 1) = "C" ' compressed
         End If
         If (Temp# And &H4000) = &H4000 Then
            Mid$(Out3, 7, 1) = "E" ' encrypted
         End If
         LastToken = False
      Case "VLABEL"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Out3) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         LastToken = False
         If Len(Var$) Then
            Temp# = Dfalse
            If DRIVEEXISTS(Var) = False Then
               Call Vlabel(Out3)
            Else
               Error 166
            End If
         Else
            Error 166
         End If
         Call GetToken4
      Case "VSERIAL"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Var$) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         LastToken = False
         If Len(Var$) Then
            Temp# = Dfalse
            If DRIVEEXISTS(Var) = False Then
               Call Vserial(Out3)
            Else
               Error 166
            End If
         Else
            Error 166
         End If
         Call GetToken4
      Case "VTYPE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
               Var$ = Out3
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
               Var = Asc(Out3) - 64
            Else
               Out3 = Nul
               Var$ = Nul
            End If
         End If
         LastToken = False
         If Len(Var$) Then
            Temp# = Dfalse
            If DRIVEEXISTS(Var) = False Then
               Call Vtype(Out3)
            Else
               Error 166
            End If
         Else
            Error 166
         End If
         Call GetToken4
      Case "DRV"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
            Else
               Out3 = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
            Else
               Out3 = Nul
            End If
         End If
         If Len(Out3) Then
            Call FreeSpace(Out3)
            Temp# = Int(Val(Out3))
         End If
         LastToken = True
         Call GetToken4
      Case "TDRV"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
            Else
               Out3 = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
            Else
               Out3 = Nul
            End If
         End If
         If Len(Out3) Then
            Call TotalSpace(Out3)
            Temp# = Int(Val(Out3))
         End If
         LastToken = True
         Call GetToken4
      Case "UDRV"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         If LastToken Then
            Var = CInt(Temp#)
            If Var >= 1 And Var <= 26 Then
               Out3 = Chr$(Var + 64)
            Else
               Out3 = Nul
            End If
         Else
            Var$ = UCase$(Out3)
            If Var$ >= "A" And Var$ <= "Z" Then
               Out3 = Var$
            Else
               Out3 = Nul
            End If
         End If
         If Len(Out3) Then
            Call UsedSpace(Out3)
            Temp# = Int(Val(Out3))
         End If
         LastToken = True
         Call GetToken4
      Case "TEMPFILENAME"
         Out3 = TempName$
         LastToken = False
      Case "DECRYPTFILE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call DecryptFileSub(Out3)
         Call GetToken4
         LastToken = False
      Case "ENCRYPTFILE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call EncryptFileSub(Out3)
         Call GetToken4
         LastToken = False

         ' bubble sort variable array ascending
      Case "SORT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call GetToken4
         Var = CInt(Temp#)
         If Var >= 1 And Var <= 1024 Then
            For Var1 = 1 To UBound(Arrays, 2) ' MaxArrays
               For Var2 = Var1 + 1 To UBound(Arrays, 2) ' MaxArrays
                  If Arrays(Var, Var1) > Arrays(Var, Var2) Then
                     Swap Arrays(Var, Var1), Arrays(Var, Var2)
                  End If
               Next
            Next
            LastToken = True
            Exit Sub
         End If
         Error 2
         ' bubble sort variable array descending
      Case "ZSORT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call GetToken4
         Var = CInt(Temp#)
         If Var >= 1 And Var <= 1024 Then
            For Var1 = 1 To UBound(Arrays, 2) ' MaxArrays
               For Var2 = Var1 + 1 To UBound(Arrays, 2) ' MaxArrays
                  If Arrays(Var, Var1) < Arrays(Var, Var2) Then
                     Swap Arrays(Var, Var1), Arrays(Var, Var2)
                  End If
               Next
            Next
            LastToken = True
            Exit Sub
         End If
         Error 2
         ' bubble sort variables
      Case "ZSORT2"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call GetToken4
         Var = CInt(Temp#)
         If Var = False Then
            ' ascending
            For Var1 = 1 To 1024
               For Var2 = Var1 + 1 To 1024
                  If Variables(Var1) > Variables(Var2) Then
                     Swap Variables(Var1), Variables(Var2)
                  End If
               Next
            Next
         Else
            ' descending
            For Var1 = 1 To 1024
               For Var2 = Var1 + 1 To 1024
                  If Variables(Var1) < Variables(Var2) Then
                     Swap Variables(Var1), Variables(Var2)
                  End If
               Next
            Next
         End If
         Temp# = Dtrue
         LastToken = True
         Exit Sub
         ' fill array with random values
      Case "RNDARRAY"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         VarX# = Temp#
         Call GetToken4
         If Var >= 1 And Var <= 1024 Then
            For Var2 = 1 To UBound(Arrays, 2) ' MaxArrays
               Arrays(Var, Var2) = Int(Rnd * VarX# + 1)
            Next
            Temp# = Var
            LastToken = True
            Exit Sub
         End If
         Error 2
         ' fill variables with random values
      Case "RNDARRAY2"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Call GetToken4
         For Var1 = 1 To 1024
            Variables(Var1) = Int(Rnd * Temp# + 1)
         Next
         Temp# = Dtrue
         LastToken = True
         Exit Sub
         ' get array value
      Case "ARRAY"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var1 = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         Var2 = CInt(Temp#)
         Call GetToken4
         If Var1 >= 1 And Var1 <= 1024 Then
            If Var2 >= 1 And Var2 <= UBound(Arrays, 2) Then ' MaxArrays
               Temp# = Arrays(Var1, Var2)
               LastToken = True
               Exit Sub
            End If
         End If
         Error 2
         ' set array value
      Case "SETARRAY"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var1 = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         Var2 = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         VarX# = Temp#
         Call GetToken4
         If Var1 >= 1 And Var1 <= 1024 Then
            If Var2 >= 1 And Var2 <= UBound(Arrays, 2) Then ' MaxArrays
               Arrays(Var1, Var2) = VarX#
               Temp# = Var1
               LastToken = True
               Exit Sub
            End If
         End If
         Error 2
         ' get variable value
      Case "VARIABLE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var1 = CInt(Temp#)
         Call GetToken4
         If Var1 >= 1 And Var1 <= 1024 Then
            Temp# = Variables(Var1)
            LastToken = True
            Exit Sub
         End If
         Error 2
         ' set variable value
      Case "SETVARIABLE"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Var1 = CInt(Temp#)
         Call GetToken
         Call Parse1(Temp#)
         VarX# = Temp#
         Call GetToken4
         If Var1 >= 1 And Var1 <= 1024 Then
            Variables(Var1) = VarX#
            Temp# = Var1
            LastToken = True
            Exit Sub
         End If
         Error 2

         Rem Basic trigonometric functions..

      Case "COS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Cos(Temp#)
         Call GetToken4
         LastToken = True
      Case "SIN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Sin(Temp#)
         Call GetToken4
         LastToken = True
      Case "TAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Tan(Temp#)
         Call GetToken4
         LastToken = True

         Rem Advanced trigonometric functions..

      Case "ATN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Atn(Temp#)
         Call GetToken4
         LastToken = True
      Case "COT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Cos(Temp#) / Sin(Temp#)
         Call GetToken4
         LastToken = True
      Case "CSC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = 1# / Sin(Temp#)
         Call GetToken4
         LastToken = True
      Case "SEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = 1# / Cos(Temp#)
         Call GetToken4
         LastToken = True

         Rem Note: PI equals ATN(1)*4 because TAN(PI/4)=1
         Rem    and ATN(TAN(1))=1 is the only solution which derives PI.

         Rem Remaining nonintrinsic trigonometric functions..

         'Inverse Cosine
      Case "ARCCOS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Atn(-Temp# / Sqr(-Temp# * Temp# + 1#)) + 2# * Atn(1#)
         Call GetToken4
         LastToken = True
         'Inverse Cosecant
      Case "ARCCOSEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(Temp# * Temp# - 1#)) + (Sgn(Temp#) - 1#) * (2# * Atn(1#))
         Call GetToken4
         LastToken = True
         'Inverse Cotangent
      Case "ARCCOTAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Atn(Temp#) + 2# * Atn(1#)
         Call GetToken4
         LastToken = True
         'Inverse Secant
      Case "ARCSEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(Temp# * Temp# - 1#)) + Sgn((Temp#) - 1#) * (2# * Atn(1#))
         Call GetToken4
         LastToken = True
         'Inverse Sine
      Case "ARCSIN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Atn(Temp# / Sqr(-Temp# * Temp# + 1#))
         Call GetToken4
         LastToken = True
         'Inverse Hyperbolic Cosine
      Case "HARCCOS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log(Temp# + Sqr(Temp# * Temp# - 1#))
         Call GetToken4
         LastToken = True
         'Inverse Hyperbolic Cosecant
      Case "HARCCOSEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log((Sgn(Temp#) * Sqr(Temp# * Temp# + 1#) + 1#) / Temp#)
         Call GetToken4
         LastToken = True
         'Inverse Hyperbolic Cotangent
      Case "HARCCOTAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log((Temp# + 1#) / (Temp# - 1#)) / 2#
         Call GetToken4
         LastToken = True
         'Inverse Hyperbolic Secant
      Case "HARCSEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log((Sqr(-Temp# * Temp# + 1#) + 1#) / Temp#)
         Call GetToken4
         LastToken = True
         'Inverse Hyperbolic Sine
      Case "HARCSIN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log(Temp# + Sqr(Temp# * Temp# + 1#))
         Call GetToken4
         LastToken = True
         'Inverse Hyperbolic Tangent
      Case "HARCTAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Log((1# + Temp#) / (1# - Temp#)) / 2#
         Call GetToken4
         LastToken = True
         'Hyperbolic Cosine
      Case "HCOS"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) + Exp(-Temp#)) / 2#
         Call GetToken4
         LastToken = True
         'Hyperbolic Cosecant
      Case "HCOSEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = 2# / (Exp(Temp#) - Exp(-Temp#))
         Call GetToken4
         LastToken = True
         'Hyperbolic Cotangent
      Case "HCOTAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) + Exp(-Temp#)) / (Exp(Temp#) - Exp(-Temp#))
         Call GetToken4
         LastToken = True
         'Hyperbolic Secant
      Case "HSEC"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = 2# / (Exp(Temp#) + Exp(-Temp#))
         Call GetToken4
         LastToken = True
         'Hyperbolic Sine
      Case "HSIN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) - Exp(-Temp#)) / 2#
         Call GetToken4
         LastToken = True
         'Hyperbolic Tangent
      Case "HTAN"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (Exp(Temp#) - Exp(-Temp#)) / (Exp(Temp#) + Exp(-Temp#))
         Call GetToken4
         LastToken = True
         'Convert Degrees to Radians
      Case "DEGTORAD"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = ((Atn(1#) * 4#) / 180#) * Temp#
         Call GetToken4
         LastToken = True
         'Convert Radians to Degrees
      Case "RADTODEG"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Temp# = (180# / (Atn(1#) * 4#)) * Temp#
         Call GetToken4
         LastToken = True
         ' Hypotenuse
      Case "HYPOT"
         Call GetToken3
         Call GetToken
         Call Parse1(Temp#)
         Number# = Temp#
         Call GetToken
         Call Parse1(Temp#)
         Temp# = Sqr(Number# * Number# + Temp# * Temp#)
         Call GetToken4
         LastToken = True
      Case Else
         Call GetConst(Strng, V2$, V3)
         If V3 Then
            If Right$(Strng, 1) = "$" Then
               Out3 = V2$
               LastToken = False
            Else
               Temp# = Val(V2$)
               LastToken = True
            End If
            Exit Sub
         End If
         If AllowAlpha Then
            Out3 = Strng
         Else
            Strng = "{" + Strng + "}"
            Error 92
         End If
   End Select
End Sub

' process a number
Sub ParseNumeric (Temp#)
   Select Case Right$(UCase$(Strng), 1) ' compare character after number
      Case "Q" ' perfect number suffix
         For Digit = 1 To Len(Strng) - 1
            OutX$ = UCase$(Mid$(Strng, Digit, 1))
            Select Case OutX$
               Case "0" To "9"
                  ' nul
               Case Else
                  Error 131
            End Select
         Next
         Temp# = CDbl(Val(Left$(Strng, Len(Strng) - 1)))
         Perfect# = Int(Temp#)
         Select Case Perfect# ' x = 1,2,4,6,12,16,18,30
            Case 1#
               X# = 1#
            Case 2#
               X# = 2#
            Case 3#
               X# = 4#
            Case 4#
               X# = 6#
            Case 5#
               X# = 12#
            Case 6#
               X# = 16#
            Case 7#
               X# = 18#
            Case Else
               Error 131
         End Select
         ' equation for perfect number
         Temp# = 2 ^ X# * (2 ^ (X# + 1) - 1)
      Case "P" ' prime number suffix
         For Digit = 1 To Len(Strng) - 1
            OutX$ = UCase$(Mid$(Strng, Digit, 1))
            Select Case OutX$
               Case "0" To "9"
                  ' nul
               Case Else
                  Error 131
            End Select
         Next
         Temp# = CDbl(Val(Left$(Strng, Len(Strng) - 1)))
         ControlBreak = 0
         PrimeNumber# = Int(Temp#)
         If PrimeNumber# <= Dfalse Then
            Prime# = 0
         End If
         If PrimeNumber# = 1# Then
            Prime# = 2
         End If
         If PrimeNumber# > 1# Then
            PrimeCounter# = False
            PrimeNumber# = PrimeNumber# + 1#
            $Checking:Off
            Do
               Prime# = Prime# + 1
               PrimeFlag = False
               For Factor# = 2 To Int(Sqr(Prime#))
                  Call Check.Program(0)
                  If ControlBreak Then
                     Exit Do
                  End If
                  If Prime# / Factor# = Int(Prime# / Factor#) Then
                     PrimeFlag = True
                     Exit For
                  End If
               Next
               If PrimeFlag = False Then
                  PrimeCounter# = PrimeCounter# + 1
               End If
               If PrimeCounter# = PrimeNumber# Then
                  Exit Do
               End If
            Loop
            $Checking:On
         End If
         Temp# = Prime#
      Case "F" ' factorial
         Temp2 = False
         Temp3 = Len(Strng)
         Do
            If UCase$(Mid$(Strng, Temp3, 1)) <> "F" Then
               Exit Do
            End If
            Temp2 = Temp2 + 1
            Temp3 = Temp3 - 1
         Loop
         For Decimal.Digit = 1 To Temp3
            OutX$ = UCase$(Mid$(Strng, Decimal.Digit, 1))
            Select Case OutX$
               Case "0" To "9"
                  ' nul
               Case Else
                  Error 132
            End Select
         Next
         Temp4# = Val(Left$(Strng, Temp3))
         For Number = 1 To Temp2
            Temp# = 1#
            For Factorial# = 2# To Temp4#
               Temp# = Temp# * Factorial#
            Next
            Temp4# = Temp#
         Next
      Case "H" ' hexidecimal suffix
         Temp# = False
         HexPower = False
         For HexDigit = Len(Strng) - 1 To 1 Step -1
            OutX$ = UCase$(Mid$(Strng, HexDigit, 1))
            Select Case OutX$
               Case "0" To "9", "A" To "F"
                  HexValue = Val("&H" + OutX$)
                  Temp# = Temp# + HexValue * 16 ^ HexPower
                  HexPower = HexPower + 1
               Case Else
                  Error 127
            End Select
         Next
      Case "O" ' octal suffix
         Temp# = False
         OctalPower = False
         For OctalDigit = Len(Strng) - 1 To 1 Step -1
            OutX$ = Mid$(Strng, OctalDigit, 1)
            If OutX$ >= "0" And OutX$ <= "7" Then
               OctalValue = Val(OutX$)
               Temp# = Temp# + OctalValue * 8 ^ OctalPower
               OctalPower = OctalPower + 1
            Else
               Error 128
            End If
         Next
      Case "B" ' binary suffix
         Temp# = False
         BinaryPower = False
         For BinaryDigit = Len(Strng) - 1 To 1 Step -1
            OutX$ = Mid$(Strng, BinaryDigit, 1)
            Select Case OutX$
               Case "0"
                  ' nul
               Case "1"
                  Temp# = Temp# + 2 ^ BinaryPower
               Case Else
                  Error 129
            End Select
            BinaryPower = BinaryPower + 1
         Next
      Case "0" To "9", "D", "E" ' decimal/exponent suffix
         Decimal = False
         Exponent = False
         Number$ = Strng
         StartToken:
         For DecimalDigit = 1 To Len(Number$)
            OutX$ = UCase$(Mid$(Number$, DecimalDigit, 1))
            Select Case OutX$
               Case "0" To "9", "-", "+"
                  ' nul
               Case "D", "E"
                  If Exponent Then
                     Error 140
                  End If
                  Exponent = True
                  Exponent$ = UCase$(Right$(Number$, 1))
                  If Exponent$ = "D" Or Exponent$ = "E" Then
                     If Mid$(Out2, TokenIndex, 1) = " " Then
                        TokenIndex = TokenIndex + 1
                     End If
                     ' concatenate pre-parsed tokens into exponent
                     Unary$ = Mid$(Out2, TokenIndex, 1)
                     If Unary$ = "+" Or Unary$ = "-" Then
                        Var$ = Left$(Out2, TokenIndex - 1)
                        Call GetToken
                        VarX$ = Var$ + Strng
                        If InStr(VarX$, "--") Then
                           Error 142
                           Exit Sub
                        End If
                        If InStr(VarX$, "++") Then
                           Error 142
                           Exit Sub
                        End If
                        Out2 = Var$ + Strng + Mid$(Out2, TokenIndex)
                        Call GetToken
                        If Strng = Nul Then
                           Error 141
                           Exit Sub
                        End If
                        Number$ = Number$ + Unary$ + Strng
                        If Strng = "-" Or Strng = "+" Then
                           Error 142
                           Exit Sub
                        End If
                        If InStr(Strng, ".") Then
                           Error 143
                           Exit Sub
                        End If
                        ' remove pre-parsed leading unary signs
                        Do
                           If Left$(Number$, 1) = "-" Then
                              Number$ = Mid$(Number$, 2)
                           Else
                              If Left$(Number$, 1) = "+" Then
                                 Number$ = Mid$(Number$, 2)
                              Else
                                 Exit Do
                              End If
                           End If
                        Loop
                        Decimal = False
                        Exponent = False
                        GoTo StartToken
                     Else
                        Error 142
                        Exit Sub
                     End If
                  End If
               Case "."
                  If Exponent Then
                     Error 143
                     Exit Sub
                  End If
                  If Decimal Then
                     Error 143
                     Exit Sub
                  End If
                  Decimal = True
               Case Else
                  Error 130
                  Exit Sub
            End Select
         Next
         Temp# = CDbl(Val(Number$))
      Case Else
         Error 131
   End Select
   Call GetToken
   LastToken = True
End Sub

' parse string in quotes
Sub ParseQuoted
   Out3 = Nul
   Do Until Mid$(Out2, TokenIndex, 1) = Quote
      Out3 = Out3 + Mid$(Out2, TokenIndex, 1)
      TokenIndex = TokenIndex + 1
      If TokenIndex > Len(Out2) Then
         Error 133
         Exit Do
      End If
   Loop
   Call GetToken
   Call GetToken
   LastToken = False
End Sub

' logical parser
Sub Parse1 (Temp#)
   Call Parse2(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "|", "&", "~", "?", ":", "#", "@", "`"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3
      Call GetToken ' read next token
      Call Parse2(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = TokenStored$ ' restore previous string
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' relational parser
Sub Parse2 (Temp#)
   Call Parse3(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "<", ">", "=", ">=", "<=", "<>", "=="
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3 ' store current string
      Call GetToken ' read next token
      Call Parse3(Temp2#) ' get next operator
      Out4 = Out3 ' reset current string
      Out3 = TokenStored$ ' restore previous string
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' addition/subtraction parser
Sub Parse3 (Temp#)
   Call Parse4(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "+", "-"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3
      Call GetToken ' read next token
      Call Parse4(Temp2#) ' get next operator
      Out4 = Out3
      Out3 = TokenStored$
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' modulo parser
Sub Parse4 (Temp#)
   Call Parse5(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "%"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3
      Call GetToken ' read next token
      Call Parse5(Temp2#) ' get next operator
      Out4 = Out3
      Out3 = TokenStored$
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' integer division parser
Sub Parse5 (Temp#)
   Call Parse6(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "\"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3
      Call GetToken ' read next token
      Call Parse6(Temp2#) ' get next operator
      Out4 = Out3
      Out3 = TokenStored$
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' multiplication/division parser
Sub Parse6 (Temp#)
   Call Parse7(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "*", "/"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3
      Call GetToken ' read next token
      Call Parse7(Temp2#) ' get next operator
      Out4 = Out3
      Out3 = TokenStored$
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' power parser
Sub Parse7 (Temp#)
   Call Parse7a(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "^"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3
      Call GetToken ' read next token
      Call Parse7a(Temp2#) ' get next operator
      Out4 = Out3
      Out3 = TokenStored$
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' dual-unary parser
Sub Parse7a (Temp#)
   Call Parse8(Temp#) ' get next operator precedence
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "<<", ">>", "--", "++", "**", "//", "||", "##", "^^", "&&"
            ' Nul
         Case Else
            Exit Do
      End Select
      TokenStored$ = Out3 ' store current token
      Call GetToken ' read next token
      Out4 = Out3 ' reset current string
      Out3 = TokenStored$ ' restore previous string
      Call Arith(TokenParsed$, Temp#, Temp2#) ' calculate expression
      TokenParsed$ = Strng ' store next token
   Loop
End Sub

' not/unary plus/unary negative parser
Sub Parse8 (Temp#)
   TokenNegate$ = Nul ' reset token storage
   TokenParsed$ = Strng ' store token
   ' process token
   Do
      Select Case TokenParsed$
         Case "_", "!", "-", "+", "--", "++", "+++", "---"
            ' Nul
         Case Else
            Exit Do
      End Select
      Call GetToken ' read next token
      TokenNegate$ = TokenNegate$ + TokenParsed$
      TokenParsed$ = Strng ' store token
   Loop
   Call Parse9(Temp#) ' get next operator

   ' process the combined operators in reverse
   For TokenType = Len(TokenNegate$) To 1 Step -1
      Select Case Mid$(TokenNegate$, TokenType, 1) ' get previous token
         Case "_"
            Temp# = Abs(Temp#) ' perform absolute
         Case "+"
            ' nul calculation for unary plus
         Case "-"
            Temp# = -Temp# ' perform negate
         Case "!" ' not
            Temp# = Not Temp# ' perform not calculation
      End Select
   Next
End Sub

' string/numeric expression parser,
' routine returns calculated expression string/value,
' calls Parse1 recursively for values inside parenthesis/functions.
Sub Parse9 (Temp#)
   Select Case Token ' determine token type
      Case 0 ' no terminating token
         If LastToken = 3 Then
            If AllowExtra = False Then
               Strng = "<extra token>"
               Error 92
            End If
         Else
            If Strng = Nul Then
               Strng = "<missing token>"
            Else
               Strng = "<" + Strng + ">"
            End If
            Error 92
         End If
         LastToken = False
      Case 1 ' token is symbol
         TokenParsed$ = Strng
         Select Case TokenParsed$
            Case ",", ";" ' separaters
               Token = False
               LastToken = 3
            Case Quote ' parse string in quotes
               Call ParseQuoted
               Quotes = True
            Case "(" ' calculate opening parenthesis
               Call GetToken ' read next token value inside parenthesis
               If Strng = ")" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> ")" Then
                  Do ' calculate value
                     Call Parse1(Temp#) ' recursively call parse entry
                  Loop Until Strng = ")" Or Token = False ' check closing parenthesis
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call GetToken ' read next token after parenthesis
            Case "["
               Call GetToken
               If Strng = "]" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> "]" Then
                  Do
                     Call Parse1(Temp#) ' recursively call parse entry
                  Loop Until Strng = "]" Or Token = False ' check closing parenthesis
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call GetToken ' read next token after parenthesis
            Case "{"
               Call GetToken
               If Strng = "}" Then
                  Strng = "<empty closing token>"
                  Error 92
               End If
               If Strng <> "}" Then
                  Do
                     Call Parse1(Temp#) ' recursively call parse entry
                  Loop Until Strng = "}" Or Token = False ' check closing parenthesis
               End If
               If Token = False Then
                  Strng = "<missing closing token>"
                  Error 92
               End If
               Call GetToken ' read next token after parenthesis
            Case ")", "]", "}" ' check token is unmatched parenthesis
               If AllowExtra <= False Then
                  Strng = "<extra closing token>"
                  Error 92
               End If
         End Select
      Case 2 ' token is numeric value
         Call ParseNumeric(Temp#)
      Case 3 ' token type is alphabetic
         Select Case Len(Strng) ' check token length
            Case 1
               ' parse the token
               Call ParseAlphabetic1(Temp#)
            Case 2
               Select Case UCase$(Strng)
                  ' special tokens
                  Case "AS"
                     Call GetToken
                     Exit Sub
                  Case "TO"
                     Call GetToken
                     Call Parse1(Temp4#)
                     FinishFor = Temp4#
                     Exit Sub
               End Select
               ' parse the token
               Call ParseAlphabetic2(Temp#)
            Case Else
               Select Case UCase$(Strng)
                  ' printing tokens
                  Case "SPC"
                     If Printing = False Then
                        Error 92
                     End If
                     If PrinterLF = -2 Then ' write function
                        Error 92
                     End If
                     Call GetToken3
                     Call GetToken
                     Call Parse1(Temp#)
                     Select Case PrinterLF
                        Case -1
                           If Temp# < Dfalse Then
                              Error 161
                           Else
                              LPrint Space$(Temp#);
                           End If
                        Case 1
                           If Temp# < Dfalse Then
                              Error 167
                           Else
                              Print Spc(Temp#);
                           End If
                     End Select
                     Call GetToken
                     If PrinterLF Then
                        Call GetToken
                        Call Parse1(Temp#)
                     End If
                     Exit Sub
                  Case "TAB"
                     If Printing = False Then
                        Error 92
                     End If
                     If PrinterLF = -2 Then ' write function
                        Error 92
                     End If
                     Call GetToken3
                     Call GetToken
                     Call Parse1(Temp#)
                     Select Case PrinterLF
                        Case -1
                           If Temp# < Dfalse Then
                              Error 161
                           Else
                              LPrint Tab(Temp#);
                           End If
                        Case 1
                           If Temp# < Dfalse Then
                              Error 167
                           Else
                              Print Tab(Temp#);
                           End If
                     End Select
                     Call GetToken
                     If PrinterLF Then
                        Call GetToken
                        Call Parse1(Temp#)
                     End If
                     Exit Sub

                     ' special tokens
                  Case "THEN"
                     Call GetToken
                     Exit Sub
                  Case "STEP"
                     Call GetToken
                     Call Parse1(Temp4#)
                     StepTo = Temp4#
                     Exit Sub
                  Case "EXCEPT"
                     Call GetToken
                     Call Parse1(Temp4#)
                     ExceptStep = Temp4#
                     ExceptStepIs = True
                     Exit Sub
                  Case "UNLESS"
                     Call GetToken
                     Call Parse1(Temp4#)
                     UnlessBranch = True
                     UnlessValue = Temp4#
                     Exit Sub
               End Select
               ' parse the token
               Call ParseAlphabetic3(Temp#)
         End Select
         ' parse the last token
         ' after any alphabetic token
         ' except the special tokens above.
         Call GetToken
   End Select
End Sub

' parses data statements.
Sub ReadDataElement (MoreData)
   MoreData = False
   VarX = DataLine
   StoredOut2$ = Out2
   StoredTokenIndex = TokenIndex
   Do
      Out2 = Program$(VarX)
      Out2 = Strim$(Out2)
      Out2 = UCase$(Out2)
      If Left$(Out2, 4) <> "DATA" Then
         Var = DataLine
         Var2 = False
         Do
            If Var >= LastLine Then
               Exit Do
            End If
            Var = Var + 1
            Strng2$ = Program$(Var)
            Strng2$ = Strim$(Strng2$)
            Strng2$ = UCase$(Strng2$)
            If Left$(Strng2$, 4) = "DATA" Then
               DataLine = Var
               Var2 = True
               Exit Do
            End If
         Loop
         If Var2 = False Then
            MoreData = True
            Exit Sub
         End If
         DataNumber = False
      End If
      Out2 = Program$(DataLine)
      Out2 = Strim$(Out2)
      Out2 = Mid$(Out2, 5)
      Out2 = Xtrim$(Out2, True)
      Call TrimComment

      ' append trailing data seperator
      Out2 = Out2 + ","

      DataCount = False
      TokenIndex = 1
      Do
         LastToken = False
         Call GetToken
         Select Case Strng
            Case ",", ";"
               DataValue = Dfalse
               Out3 = Nul
            Case Else
               ' allow equations in DATA elements!?
               Call Parse1(DataValue)

               ' next token should be data terminator
               Select Case Strng
                  Case Quote
                     Error 133
                     Exit Sub
                  Case ",", ";"
                     Eat$ = Nul
                  Case Else
                     Error 66
                     Exit Sub
               End Select
         End Select
         If DataCount = DataNumber Then
            DataNumber = DataNumber + 1
            Out2 = StoredOut2$
            TokenIndex = StoredTokenIndex
            Exit Sub
         End If
         If TokenIndex > Len(Out2) Then
            Exit Do
         End If
         DataCount = DataCount + 1
      Loop
      VarX = VarX + 1
      DataNumber = False
   Loop
End Sub

' parses filename and returns drive\path\filename.sic
Sub Concatenate (ProgramFile$)
   ProgramFile$ = Strim$(ProgramFile$)
   ProgramFile$ = LCase$(ProgramFile$)
   ProgramDrive$ = Nul
   ProgramPath$ = Nul
   If Mid$(ProgramFile$, 2, 1) = ":" Then
      ProgramDrive$ = Left$(ProgramFile$, 2)
      ProgramFile$ = Mid$(ProgramFile$, 3)
   End If
   For Var = Len(ProgramFile$) To 1 Step -1
      If Mid$(ProgramFile$, Var, 1) = "\" Then
         ProgramPath$ = Left$(ProgramFile$, Var)
         ProgramFile$ = Mid$(ProgramFile$, Var + 1)
         Exit For
      End If
   Next
   If Right$(ProgramFile$, 4) = ".sic" Then
      ProgramFile$ = Left$(ProgramFile$, Len(ProgramFile$) - 4)
   End If
   ProgramFile$ = ProgramDrive$ + ProgramPath$ + ProgramFile$ + ".sic"
End Sub

' parses filename and returns filename.sic
Function GetFileName$ (Var$)
   VarQ$ = Var$
   If Mid$(VarQ$, 2, 1) = ":" Then
      VarQ$ = Mid$(VarQ$, 3)
   End If
   For Var = Len(VarQ$) To 1 Step -1
      If Mid$(VarQ$, Var, 1) = "\" Then
         VarQ$ = Mid$(VarQ$, Var + 1)
         Exit For
      End If
   Next
   GetFileName$ = VarQ$
End Function

' check validity of program
'  Var1 = -1 to display process
'  Var2 = returns -1 if syntax error
'  Var1$ = the syntax error in string format
Sub AnalyzeProgram (Var1, Var2, Var1$)
   Var2 = 0
   Call CountLines(LastLine)
   If Var1 = True Then
      Color Yellow, Black
      Print "Analyzing Program: "; ProgramName
      Color White, Black
      Print "Pass 1: counting matching structures."
   End If

   For ProgramLine = 1 To LastLine
      Out2$ = Program(ProgramLine)
      Out2$ = Strim$(Out2$)
      If Len(Out2$) Then
         Temp1$ = Strim$(Out2$)
         Temp1$ = UCase$(Temp1$)
      End If
      If Left$(Temp1$, 4) = "THEN" Then
         Var2 = True
         Var1$ = "Incorrect structure"
         If Var1 = True Then
            Print "Analyze error, pass 1: Incorrect structure : Line:" + Str$(ProgramLine)
         End If
         Exit Sub
      End If
      If Left$(Temp1$, 4) = "STEP" Then
         Var2 = True
         Var1$ = "Incorrect structure"
         If Var1 = True Then
            Print "Analyze error, pass 1: Incorrect structure : Line:" + Str$(ProgramLine)
         End If
         Exit Sub
      End If
      If Left$(Temp1$, 6) = "UNLESS" Then
         Var2 = True
         Var1$ = "Incorrect structure"
         If Var1 = True Then
            Print "Analyze error, pass 1: Incorrect structure : Line:" + Str$(ProgramLine)
         End If
         Exit Sub
      End If
      If Left$(Temp1$, 6) = "EXCEPT" Then
         Var2 = True
         Var1$ = "Incorrect structure"
         If Var1 = True Then
            Print "Analyze error, pass 1: Incorrect structure : Line:" + Str$(ProgramLine)
         End If
         Exit Sub
      End If
   Next

   Restore AnalyzeData1
   For DataCount = 1 To 8
      Read StartStructure$, StopStructure$
      NestedCount = False
      For ProgramLine = 1 To LastLine
         Out2$ = Program(ProgramLine)
         Out2$ = Strim$(Out2$)
         If Len(Out2$) Then
            Temp1$ = Strim$(Out2$)
            Temp1$ = UCase$(Temp1$)
            CountData1 = False
            If Left$(Temp1$, Len(StartStructure$)) = StartStructure$ Then
               CountData1 = True
            End If
            If StartStructure$ = "FOR" Then
               If Left$(Temp1$, 5) = "FORIF" Then
                  CountData1 = False
               End If
            End If
            If CountData1 Then
               NestedCount = NestedCount + 1
            End If
            If StartStructure$ = "IF" Then
               If Left$(Temp1$, 6) = "END IF" Then
                  NestedCount = NestedCount - 1
                  If NestedCount < False Then
                     Var2 = True
                     Var1$ = "Incomplete " + StartStructure$
                     If Var1 = True Then
                        Print "Analyze error, pass 1: Incomplete " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                     End If
                     Exit Sub
                  End If
               End If
            End If
            If StopStructure$ = "LOOP" Then
               If Left$(Temp1$, 6) <> "LOOPIF" Then
                  Temp1$ = Left$(Temp1$, 4)
               End If
            End If
            If StopStructure$ = "NEXT" Then
               If Left$(Temp1$, 6) <> "NEXTIF" Then
                  Temp1$ = Left$(Temp1$, 4)
               End If
            End If
            If StopStructure$ = "END SELECT" Then
               If Left$(Temp1$, 12) <> "END SELECTIF" Then
                  Temp1$ = Left$(Temp1$, 10)
               End If
            End If
            If Temp1$ = StopStructure$ Then
               NestedCount = NestedCount - 1
               If NestedCount < False Then
                  Var2 = True
                  Var1$ = "Incomplete " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 1: Incomplete " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   If Var1 = True Then
      Print "Pass 2: counting matching imbedded structures."
   End If
   Restore AnalyzeData2
   For DataCount = 1 To 3
      Read StartStructure$, StopStructure$, Imbedded1$, Imbedded2$
      NestedCount = False
      For ProgramLine = 1 To LastLine
         Out2$ = Program(ProgramLine)
         Out2$ = Strim$(Out2$)
         If Len(Out2$) Then
            Temp1$ = Strim$(Out2$)
            Temp1$ = UCase$(Temp1$)
            If Left$(Temp1$, Len(StartStructure$)) = StartStructure$ Then
               NestedCount = NestedCount + 1
            End If
            If Left$(Temp1$, Len(Imbedded1$)) = Imbedded1$ Then
               NestedCount = NestedCount - 1
               If NestedCount < False Then
                  Var2 = True
                  Var1$ = "Incomplete " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 2: Incomplete " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
               NestedCount = NestedCount + 1
            Else
               Temp2$ = Temp1$
               If Imbedded2$ <> "ELSEIF" Then
                  If Left$(Temp1$, Len(Imbedded2$)) = Imbedded2$ Then
                     Imbedded3 = InStr(Temp1$, " ")
                     If Imbedded3 = False Then
                        Var2 = True
                        Var1$ = "Bad " + Imbedded2$
                        If Var1 = True Then
                           Print "Analyze error, pass 2: Bad " + Imbedded2$ + ": Line:" + Str$(ProgramLine)
                        End If
                        Exit Sub
                     End If
                     Temp2$ = Left$(Temp1$, Imbedded3 - 1)
                  End If
               End If
               If Temp2$ = Imbedded2$ Then
                  NestedCount = NestedCount - 1
                  If NestedCount < False Then
                     Var2 = True
                     Var1$ = "Incomplete " + StartStructure$
                     If Var1 = True Then
                        Print "Analyze error, pass 2: Incomplete " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                     End If
                     Exit Sub
                  End If
                  NestedCount = NestedCount + 1
               End If
            End If
            If StartStructure$ = "IF" Then
               If Left$(Temp1$, 6) = "END IF" Then
                  NestedCount = NestedCount - 1
                  If NestedCount < False Then
                     Var2 = True
                     Var1$ = "Incomplete " + StartStructure$
                     If Var1 = True Then
                        Print "Analyze error, pass 2: Incomplete " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                     End If
                     Exit Sub
                  End If
               End If
            End If
            If Temp1$ = StopStructure$ Then
               NestedCount = NestedCount - 1
               If NestedCount < False Then
                  Var2 = True
                  Var1$ = "Incomplete " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 2: Incomplete " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   If Var1 = True Then
      Print "Pass 3: multipass structure match."
   End If
   Restore AnalyzeData1
   For DataCount = 1 To 8
      Read StartStructure$, StopStructure$
      For ProgramLine = 1 To LastLine
         Out2$ = Program(ProgramLine)
         Out2$ = Strim$(Out2$)
         If Len(Out2$) Then
            Temp1$ = Strim$(Out2$)
            Temp1$ = UCase$(Temp1$)
            CountData1 = False
            If Left$(Temp1$, Len(StartStructure$)) = StartStructure$ Then
               CountData1 = True
            End If
            If StartStructure$ = "FOR" Then
               If Left$(Temp1$, 5) = "FORIF" Then
                  CountData1 = False
               End If
            End If
            If CountData1 Then
               NestedCount = 1
               For NestedLines = ProgramLine + 1 To LastLine
                  Temp2$ = Program(NestedLines)
                  Temp2$ = Strim$(Temp2$)
                  If Len(Temp2$) Then
                     Temp2$ = Strim$(Temp2$)
                     Temp2$ = UCase$(Temp2$)
                     CountData2 = False
                     If Left$(Temp2$, Len(StartStructure$)) = StartStructure$ Then
                        CountData2 = True
                     End If
                     If StartStructure$ = "FOR" Then
                        If Left$(Temp2$, 5) = "FORIF" Then
                           CountData2 = False
                        End If
                     End If
                     If CountData2 Then
                        NestedCount = NestedCount + 1
                     End If
                     If StopStructure$ = "LOOP" Then
                        If Left$(Temp2$, 6) <> "LOOPIF" Then
                           Temp2$ = Left$(Temp2$, 4)
                        End If
                     End If
                     If StopStructure$ = "NEXT" Then
                        If Left$(Temp2$, 6) <> "NEXTIF" Then
                           Temp2$ = Left$(Temp2$, 4)
                        End If
                     End If
                     If StopStructure$ = "END SELECT" Then
                        If Left$(Temp1$, 12) <> "END SELECTIF" Then
                           Temp1$ = Left$(Temp1$, 10)
                        End If
                     End If
                     If Temp2$ = StopStructure$ Then
                        NestedCount = NestedCount - 1
                        If NestedCount = False Then
                           Exit For
                        End If
                     End If
                     If StartStructure$ = "IF" Then
                        If Left$(Temp2$, 6) = "END IF" Then
                           NestedCount = NestedCount - 1
                           If NestedCount = False Then
                              Exit For
                           End If
                        End If
                     End If
                  End If
               Next
               If NestedCount <> False Then
                  Var2 = True
                  Var1$ = "Mismatched " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 3: Mismatched " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   If Var1 = True Then
      Print "Pass 4: multipass imbedded struture match."
   End If
   Restore AnalyzeData2
   For DataCount = 1 To 3
      Read StartStructure$, StopStructure$, Imbedded1$, Imbedded2$
      For ProgramLine = 1 To LastLine
         Out2$ = Program(ProgramLine)
         Out2$ = Strim$(Out2$)
         If Len(Out2$) Then
            Temp1$ = Strim$(Out2$)
            Temp1$ = UCase$(Temp1$)
            If Left$(Temp1$, Len(StartStructure$)) = StartStructure$ Then
               TotalNested1 = 1
               TotalNested2 = False
               NestedCount1 = 1
               NestedCount2 = False
               For NestedLines = ProgramLine + 1 To LastLine
                  Temp2$ = Program(NestedLines)
                  Temp2$ = Strim$(Temp2$)
                  If Len(Temp2$) Then
                     Temp2$ = Strim$(Temp2$)
                     Temp2$ = UCase$(Temp2$)
                     If Left$(Temp2$, Len(StartStructure$)) = StartStructure$ Then
                        TotalNested1 = TotalNested1 + 1
                        NestedCount1 = NestedCount1 + 1
                     End If
                     If Temp2$ = StopStructure$ Then
                        TotalNested2 = TotalNested2 - 1
                        NestedCount1 = NestedCount1 - 1
                        If NestedCount1 = False Then
                           Exit For
                        End If
                     End If
                     If StartStructure$ = "IF" Then
                        If Left$(Temp2$, 6) = "END IF" Then
                           NestedCount1 = NestedCount1 - 1
                           If NestedCount1 = False Then
                              Exit For
                           End If
                        End If
                     End If
                     If Left$(Temp2$, Len(Imbedded1$)) = Imbedded1$ Then
                        NestedCount2 = NestedCount2 + 1
                        If NestedCount2 > NestedCount1 Then
                           Var2 = True
                           Var1$ = "Mismatched " + StartStructure$
                           If Var1 = True Then
                              Print "Analyze error, pass 4: Mismatched " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                           End If
                           Exit Sub
                        End If
                        NestedCount2 = NestedCount2 - 1
                     Else
                        Temp3$ = Temp2$
                        If Imbedded2$ <> "ELSEIF" Then
                           If Left$(Temp2$, Len(Imbedded2$)) = Imbedded2$ Then
                              Imbedded3 = InStr(Temp2$, " ")
                              If Imbedded3 = False Then
                                 Var2 = True
                                 Var1$ = "Bad " + Imbedded2$
                                 If Var1 = True Then
                                    Print "Analyze error, pass 4: Bad " + Imbedded2$ + ": Line:" + Str$(ProgramLine)
                                 End If
                                 Exit Sub
                              End If
                              Temp3$ = Left$(Temp2$, Imbedded3 - 1)
                           End If
                        End If
                        If Temp3$ = Imbedded2$ Then
                           NestedCount2 = NestedCount2 + 1
                           If NestedCount2 > NestedCount1 Then
                              Var2 = True
                              Var1$ = "Mismatched " + StartStructure$
                              If Var1 = True Then
                                 Print "Analyze error, pass 4: Mismatched " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                              End If
                              Exit Sub
                           End If
                           NestedCount2 = NestedCount2 - 1
                        End If
                     End If
                  End If
               Next
               If TotalNested2 > TotalNested1 Then
                  Var2 = True
                  Var1$ = "Mismatched " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 4: Mismatched " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   If Var1 = True Then
      Print "Pass 5: single pass imbedded control structure match."
   End If
   Restore AnalyzeData3
   For DataCount = 1 To 5
      Read StartStructure$, StopStructure$, Imbedded1$, Imbedded2$
      NestedCount = False
      For ProgramLine = 1 To LastLine
         Out2$ = Program(ProgramLine)
         Out2$ = Strim$(Out2$)
         If Len(Out2$) Then
            Temp1$ = Strim$(Out2$)
            Temp1$ = UCase$(Temp1$)
            CountData1 = False
            If Left$(Temp1$, Len(StartStructure$)) = StartStructure$ Then
               CountData1 = True
            End If
            If StartStructure$ = "FOR" Then
               If Left$(Temp1$, 5) = "FORIF" Then
                  CountData1 = False
               End If
            End If
            If CountData1 Then
               NestedCount = NestedCount + 1
            End If
            CountData2 = False
            If Left$(Temp1$, Len(StopStructure$)) = StopStructure$ Then
               CountData2 = True
            End If
            If StopStructure$ = "LOOP" Then
               If Left$(Temp1$, 6) = "LOOPIF" Then
                  CountData2 = False
               End If
            End If
            If StopStructure$ = "NEXT" Then
               If Left$(Temp1$, 6) = "NEXTIF" Then
                  CountData2 = False
               End If
            End If
            If CountData2 Then
               NestedCount = NestedCount - 1
            End If
            If Left$(Temp1$, Len(Imbedded1$)) = Imbedded1$ Then
               If NestedCount <= False Then
                  Var2 = True
                  Var1$ = "Badly nested " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 5: Badly nested " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
            End If
            If Left$(Temp1$, Len(Imbedded2$)) = Imbedded2$ Then
               If NestedCount <= False Then
                  Var2 = True
                  Var1$ = "Badly nested " + StartStructure$
                  If Var1 = True Then
                     Print "Analyze error, pass 5: Badly nested " + StartStructure$ + ": Line:" + Str$(ProgramLine)
                  End If
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   If Var1 = True Then
      Color Yellow, Black
      Print "Analysis completed. Program syntax correct."
   End If
End Sub

' routine compares occurrence of filename1$ in filename2$
'  with pattern matching.
Sub CheckFilename (Filename1$, Filename2$, Match)
   Match = True ' assume mask matches filename2.
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement.
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Match = 0
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement.
         ' searches for next matching character.
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement.
         ' matches any next character.
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character.
            ' checks next character unmatched.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match = 0
                  Exit Do
               End If
            Else
               ' matches next character.
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match = 0
                  Exit Do
               End If
               ' check string lengths.
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Match = 0
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
End Sub

' function to match case-sensitive substring with ?, * characters in substring
'  Return Var = -1 if match
'  VarQ = -1 force case-sensitive
'  See if Var1$ exists in Var2$
Sub InstrSUB1 (Var, Var1$, Var2$, VarQ)

   ' store case-sensitive string match variables
   If VarQ Then
      S2$ = Var1$
      S3$ = Var2$
   Else
      S2$ = LCase$(Var1$)
      S3$ = LCase$(Var2$)
   End If

   ' check default instr
   If InStr(S2$, "*") = 0 Then
      If InStr(S2$, "?") = 0 Then
         Var = InStr(S3$, S2$)
         Exit Sub
      End If
   End If

   Var = True ' assume match

   ' see if S2$ matches in S3$ with substrings
   For S3 = 1 To Len(S3$)
      S1$ = Mid$(S3$, S3)
      P1 = 1 ' pointer to S1$
      P2 = 1 ' pointer to S2$
      Do
         ' check match
         If P2 > Len(S2$) Then
            Exit Sub
         End If

         ' check character in S2$ at P2
         V$ = Mid$(S2$, P2, 1)
         Select Case V$
            Case "*" ' global character
               ' scan to next char
               If P2 > Len(S2$) Then
                  Exit Do
               End If
               S4$ = Mid$(S2$, P2 + 1, 1)
               Select Case S4$
                  Case "*", "?"
                     P2 = P2 + 1
                  Case Else
                     Do
                        If Mid$(S1$, P1, 1) = S4$ Then
                           Exit Do
                        End If
                        If P1 >= Len(S1$) Then
                           Exit Do
                        End If
                        P1 = P1 + 1
                     Loop
                     P2 = P2 + 1
               End Select
            Case "?" ' wildcard character
               P1 = P1 + 1
               P2 = P2 + 1
            Case Else ' ascii character
               If Mid$(S1$, P1, 1) <> V$ Then ' no match
                  Exit Do
               End If
               P1 = P1 + 1
               P2 = P2 + 1
         End Select
      Loop
   Next
   Var = 0 ' no match
End Sub

Sub Capitalize (Var3$)
   Var3$ = RTrim$(LTrim$(Var3$))
   If Var3$ = Nul Then
      Exit Sub
   End If
   Mid$(Var3$, 1, 1) = UCase$(Mid$(Var3$, 1, 1))
   Var = InStr(Var3$, " ")
   If Var < Len(Var3$) Then
      Do While Var
         Mid$(Var3$, Var + 1, 1) = UCase$(Mid$(Var3$, Var + 1, 1))
         Var = InStr(Var + 1, Var3$, " ")
      Loop
   End If
End Sub

' calculate byte suffix
Sub Suffix (Var#, Var3$)

   Rem B  (Byte) = 00x - 0FFx (hexidecimal zero-based)
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB (1 MB B)
   Rem GB (Gigabyte) = 1024 MB
   Rem TB (Terabyte) = 1024 GB (1 MB MB)
   Rem PB (Petabyte) = 1024 TB
   Rem EB (Exabyte) = 1024 PB (1 MB TB)
   Rem ZB (Zettabyte) = 1024 EB
   Rem YB (Yottabyte) = 1024 ZB (1 MB EB)

   ' 1.#INF and -1.#INF and -1.#IND and 1#QNAN
   If InStr(Str$(Var#), "#") Then
      Var3$ = LTrim$(Str$(Var#))
      Exit Sub
   End If

   ' check double
   VarX# = Var#
   s$ = Str$(VarX#)
   If InStr(s$, "D") Then
      Var3$ = s$
      Exit Sub
   End If

   ' get sign
   If VarX# < Dfalse Then
      Sign = True
      VarX# = Abs(VarX#)
   End If

   ' calculate bytes
   TempA = False
   Do
      If VarX# >= ByteDivisor Then
         VarX# = VarX# / ByteDivisor
         TempA = TempA + 1
         If TempA = 8 Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   Var3$ = FormatString$(VarX#)
   If InStr(Var3$, ".") Then
      Var3$ = Left$(Var3$, InStr(Var3$, ".") + 1)
   Else
      Var3$ = Var3$ + ".0"
   End If

   ' calculate byte suffix
   Var$ = Nul
   If TempA > 0 Then
      Var$ = Mid$("KMGTPEZY", TempA, 1)
   End If
   Var3$ = Var3$ + " " + Var$ + "B"

   ' calculate byte sign
   If Sign Then
      Var3$ = "-" + Var3$
   End If
End Sub

' trim trailing comment/underscore
Sub TrimComment
   If Len(Out2) Then
      StartChar = 1
      Do
         QuoteStart = False
         For Temp = StartChar To Len(Out2)
            If Mid$(Out2, Temp, 1) = Quote Then
               QuoteStart = Temp
               Exit For
            End If
         Next
         If QuoteStart = False Then
            Exit Do
         End If
         QuoteStop = False
         For Temp2 = QuoteStart + 1 To Len(Out2)
            If Mid$(Out2, Temp2, 1) = Quote Then
               QuoteStop = Temp2
               Exit For
            End If
         Next
         If QuoteStop = False Then
            Exit Do
         End If
         StartChar = QuoteStop + 1
      Loop
      For Temp = StartChar To Len(Out2)
         If Mid$(Out2, Temp, 1) = "'" Then
            Out2 = Left$(Out2, Temp - 1)
            Exit For
         End If
      Next
      Out2 = Strim$(Out2)
   End If

   ' trim continuation character
   Do
      V$ = Right$(Out2, 1)
      If V$ = TabS Or V$ = SpaceC Or V$ = UnderScore Then
         Out2 = Left$(Out2, Len(Out2) - 1)
      Else
         Exit Do
      End If
   Loop
End Sub

Sub TotalBytes (X#)
   X# = Dfalse
   Call CountLines(V%)
   If V% > 0% Then
      For VarX% = 1% To V%
         X# = X# + CDbl(Len(Program$(VarX%)))
      Next
   End If
End Sub

Sub StatusLine
   Var2$ = Nul
   If SoundHandle <> 0 Then
      S& = _SndGetPos(SoundHandle)
      S$ = Str$(S&)
      If InStr(S$, ".") Then
         S$ = Left$(S$, InStr(S$, ".") + 2)
      End If
      S& = _SndLen(SoundHandle)
      S2$ = Str$(S&)
      If InStr(S2$, ".") Then
         S2$ = Left$(S2$, InStr(S2$, ".") + 2)
      End If
      Var2$ = "(sound" + S$ + " of" + S2$ + ")"
   End If
   X = CsrLin
   Y = Pos(0)
   Select Case StatusType
      Case 0
         Var$ = "SICK v" + Version + " r" + Release + " time: " + Time$ + " (node " + Hex$(Node) + ")"
         If ScreenWidth = 80 Then
            Var$ = Var$ + " Program - " + ProgramName
            Call TotalBytes(V#)
            Var$ = Var$ + " (" + LTrim$(Str$(V#)) + " bytes)"
         End If
         Color StatusForeground, StatusBackground
         Locate ScreenHeight, 1, 1
         If LastWidth1 > 0 Then
            Print Space$(LastWidth1);
         End If
         If Len(Var2$) Then
            If Len(Var$) + Len(Var2$) < LastWidth1 Then
               Var$ = Var$ + " " + Var2$
            End If
         End If
         Locate ScreenHeight, 1, 1
         If LastWidth1 > 0 Then
            Var$ = Left$(Var$, LastWidth1 - 1)
            Print Var$;
         End If
      Case -1
         Var$ = "SICK v" + Version + " r" + Release + " time: " + Time$ + " (node " + Hex$(Node) + ")"
         If ScreenWidth = 80 Then
            Var$ = Var$ + " Program - " + ProgramName
            Locate ScreenHeight, 1, 1
         End If
         Color StatusForeground, StatusBackground
         If LastWidth1 > 0 Then
            Print Space$(LastWidth1);
         End If
         If Len(Var2$) Then
            If Len(Var$) + Len(Var2$) < LastWidth1 Then
               Var$ = Var$ + " " + Var2$
            End If
         End If
         Locate ScreenHeight, 1, 1
         If LastWidth1 > 0 Then
            Var$ = Left$(Var$, LastWidth1 - 1)
            Print Var$;
         End If
      Case -2
         Var$ = "SICK v" + Version + " r" + Release + " time: " + Time$ + " (node " + Hex$(Node) + ")"
         Locate LastWidth2, 1, 1
         Color StatusForeground, StatusBackground
         If LastWidth1 > 0 Then
            Print Space$(LastWidth1);
         End If
         Locate ScreenHeight, 1, 1
         If LastWidth1 > 0 Then
            Var$ = Left$(Var$, LastWidth1 - 1)
            Print Var$;
         End If
      Case -3
         Locate ScreenHeight, 1, 1
         Color Plain, Black
         If LastWidth1 > 0 Then
            Print Space$(LastWidth1);
         End If
         Locate LastWidth2, 1, 1
   End Select
   Color White, Black
   Locate X, Y, 1
End Sub

Sub ClearStatusLine
   X = CsrLin
   Y = Pos(0)
   Color Plain, Black
   Locate LastWidth2, 1, 1
   If LastWidth1 > 0 Then
      Print Space$(LastWidth1);
   End If
   Locate LastWidth2, 1, 1
   Color White, Black
   Locate X, Y, 1
End Sub

Sub MemFunction
   Print "Memory used:"; Str$(MemInUsePercent); "%"
   Print "Total Physical Memory: ";
   Print Suffix$(TotalPhysicalMem)
   Print "Free Physical Memory: ";
   Print Suffix$(FreePhysicalMem)

   Print "Used Physical Memory: ";
   Print Suffix$(TotalPhysicalMem - FreePhysicalMem)

   Print "Total Paging File: ";
   Print Suffix$(TotalPagingFile)
   Print "Free Paging File: ";
   Print Suffix$(FreePagingFile)
   Print "Total Virtual Memory: ";
   Print Suffix$(TotalVirtualMem)
   Print "Free Virtual Memory:";
   Print Suffix$(FreeVirtualMem)
End Sub

' calculate byte suffix.
Function Suffix$ (Var)
   Dim Var3 As Double
   ' Var - input value
   ' SuffixType - 0 = bytes, 1 = kilo, 2 = mega, 3 = giga
   Rem B  (Byte) = 00x - 0FFx
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB
   Rem GB (Gigabyte) = 1024 MB

   ' 1.#INF and -1.#INF and -1.#IND and 1#QNAN
   If InStr(Str$(Var), "#") Then
      Suffix$ = LTrim$(Str$(Var))
      Exit Function
   End If

   ' check sign
   If Var < False Then
      Suffix$ = " -1B"
      Exit Function
   End If

   ' check bytes.
   Var3 = Var
   If SuffixType = False Then
      Suffix$ = FormatString$(Var3) + " B"
      Exit Function
   End If

   ' calculate byte suffix.
   TempA = False
   Do
      If Var3 >= ByteDivisor2 Then
         Var3 = Var3 / ByteDivisor2
         TempA = TempA + 1
         If TempA >= SuffixType Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   '   Var2$ = FormatString$(Var3)
   If TempA = 3 Then
      Var3 = Var3 + .1
   End If
   Var2$ = FormatString$(Var3)
   If InStr(Var2$, ".") Then
      Var2$ = Left$(Var2$, InStr(Var2$, ".") + 1)
   End If
   Var$ = "B"
   Select Case TempA
      Case 1
         Var$ = "KB"
      Case 2
         Var$ = "MB"
      Case 3
         Var$ = "GB"
   End Select
   ' append suffix.
   Suffix$ = Var2$ + " " + Var$
End Function

Sub CPUtrap
   If CPUtraptype = False Then
      X$ = ProgramNameRelease + " - " + ProgramName
      If MEMtraptype Then
         Select Case MEMtraptype2
            Case 0
               X$ = X$ + " - Total MEM - " + Suffix$(TotalPhysicalMem)
            Case 1
               X$ = X$ + " - Free MEM - " + Suffix$(FreePhysicalMem)
            Case 2
               X$ = X$ + " - Used MEM - " + Suffix$(TotalPhysicalMem - FreePhysicalMem)
            Case Else
               X$ = X$ + " - Free MEM - " + Suffix$(FreePhysicalMem)
         End Select
      End If
      _Title X$
      Exit Sub
   End If
   S$ = Str$(Int(GetCPULoad * 10000) / 100) ' 100.00
   If InStr(S$, ".") Then
      Q$ = Mid$(S$, InStr(S$, ".") + 1)
      S$ = Left$(S$, InStr(S$, ".") - 1)
      Q$ = Left$(Q$, 3)
      S$ = S$ + "." + Q$
   Else
      S$ = S$ + ".0"
   End If
   D$ = "CPU " + S$ + "%" ' 100.00
   If MEMtraptype Then
      Select Case MEMtraptype2
         Case 0
            D$ = D$ + " - Total MEM - " + Suffix$(TotalPhysicalMem)
         Case 1
            D$ = D$ + " - Free MEM - " + Suffix$(FreePhysicalMem)
         Case 2
            D$ = D$ + " - Used MEM - " + Suffix$(TotalPhysicalMem - FreePhysicalMem)
         Case Else
            D$ = D$ + " - Free MEM - " + Suffix$(FreePhysicalMem)
      End Select
   End If
   _Title ProgramNameRelease + " - " + ProgramName + " - " + D$
End Sub

Sub WriteConfig (Var)
   Var = 0
   f$ = CurrentDirectory
   If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
   f$ = f$ + "sick" + Hex$(Node) + ".cfg"
   If Left$(f$, 2) = "\\" Then Var = -2: Exit Sub
   V = Asc(UCase$(Left$(f$, 1))) - 64
   Y = DRIVEEXISTS(V)
   If DriveType = "[CDROM]" Then Var = -3: Exit Sub
   If MEDIAEXISTS(V) = False Then Var = -4: Exit Sub
   Var = True
   ' open file for output
   X = FreeFile
   Open f$ For Output As #X

   ' write values to file
   Print #X, _ScreenX
   Print #X, _ScreenY
   Print #X, ";SICK Config File " + Date$ + " " + Time$ + " (node " + Hex$(Node) + ")"

   ' write environment settings
   Print #X, "SICPAGELENGTH=" + LTrim$(Str$(PageLength))
   Print #X, "SICSAVEONEXIT=" + LTrim$(Str$(SaveOnExit))
   Print #X, "SICSTATUSLINE=" + LTrim$(Str$(StatusType))
   Print #X, "SICPROMPT1=" + Prompt1
   Print #X, "SICPROMPT2=" + Prompt2
   Print #X, "SICPROMPT3=" + Prompt3
   Print #X, "SICPROMPT4=" + Prompt4
   Print #X, "SICPROMPT5=" + Prompt5
   Print #X, "SICIGNORE=" + LTrim$(Str$(BootError))
   Print #X, "SICMAKEBEEP=" + LTrim$(Str$(MakeBeep))
   Print #X, "SICCPUTRAP=" + LTrim$(Str$(CPUtraptype))
   Print #X, "STATUSFORE=" + LTrim$(Str$(StatusForeground))
   Print #X, "STATUSBACK=" + LTrim$(Str$(StatusBackground))
   Print #X, "MEMTRAP=" + LTrim$(Str$(MEMtraptype))
   Print #X, "MEMTRAP2=" + LTrim$(Str$(MEMtraptype2))
   Print #X, "SUFFIXTYPE=" + LTrim$(Str$(SuffixType))
   Print #X, "AUTOINDENT=" + LTrim$(Str$(AutoIndent))
   Print #X, "AUTOINDENTSPACES=" + LTrim$(Str$(AutoIndentSpaces))
   Print #X, "AUTOSAVE=" + LTrim$(Str$(AutoSave))
   Print #X, "AUTOSAVEVALUE=" + LTrim$(Str$(AutoSaveValue))
   Print #X, "AUTOSAVEALERT=" + LTrim$(Str$(AutoSaveAlert))
   Print #X, "HELPOFF=" + LTrim$(Str$(HelpOff))
   Print #X, "AVOIDLINUX=" + LTrim$(Str$(AvoidLINUX))
   Print #X, "FORCELINUX=" + LTrim$(Str$(ForceLINUX))
   Print #X, "DOTDISPLAY=" + LTrim$(Str$(DotDisplay))
   Print #X, "COMPATIBLE=" + LTrim$(Str$(Compatible))
   Print #X, "DATETIME1=" + LTrim$(Str$(Creation.Time))
   Print #X, "DATETIME2=" + LTrim$(Str$(Access.Time))
   Print #X, "DATETIME3=" + LTrim$(Str$(Modified.Time))
   Print #X, "KEYBOARDTIMER=" + LTrim$(Str$(KeyboardTimer))
   Print #X, "STARTMENUIGNORE=" + LTrim$(Str$(StartMenuIgnore))
   Print #X, "STARTBOXIGNORE=" + LTrim$(Str$(StartBoxIgnore))
   Print #X, "QUITBOXIGNORE=" + LTrim$(Str$(QuitBoxIgnore))
   Close #X
End Sub

Sub WriteRecent (Var)
   Var = 0
   f$ = CurrentDirectory
   If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
   f$ = f$ + "sickrecent" + Hex$(Node) + ".cfg"
   If Left$(f$, 2) = "\\" Then Var = -2: Exit Sub
   V = Asc(UCase$(Left$(f$, 1))) - 64
   Y = DRIVEEXISTS(V)
   If DriveType = "[CDROM]" Then Var = -3: Exit Sub
   If MEDIAEXISTS(V) = False Then Var = -4: Exit Sub
   Var = True
   ' open file for output
   X = FreeFile
   Open f$ For Output As #X

   ' write values to file
   Print #X, ";SICK Recent File " + Date$ + " " + Time$ + " (node " + Hex$(Node) + ")"

   ' write recent settings
   For VarX = 1 To MaxRecent
      VarX$ = LTrim$(Str$(VarX)) + "=" + LTrim$(Recent1(VarX))
      Print #X, VarX$
   Next
   Close #X
End Sub

Sub InitConfig (Var)
   Var = 0
   f$ = CurrentDirectory
   If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
   f$ = f$ + "sick" + Hex$(Node) + ".cfg"
   If Left$(f$, 2) = "\\" Then Exit Sub
   V = Asc(UCase$(Left$(f$, 1))) - 64
   Y = DRIVEEXISTS(V)
   If DriveType = "[CDROM]" Then Exit Sub
   If MEDIAEXISTS(V) = False Then Exit Sub
   Var = True
   ' open file for output
   X = FreeFile
   Open f$ For Output As #X

   ' write values to file
   Print #X, _ScreenX
   Print #X, _ScreenY
   Print #X, ";SICK Config File " + Date$ + " " + Time$ + " (node " + Hex$(Node) + ")"

   ' write environment settings
   PageLength = _Height: Print #X, "SICPAGELENGTH=" + LTrim$(Str$(PageLength))
   SaveOnExit = True: Print #X, "SICSAVEONEXIT=" + LTrim$(Str$(SaveOnExit))
   StatusType = 0: Print #X, "SICSTATUSLINE=" + LTrim$(Str$(StatusType))
   Prompt1 = ">": Print #X, "SICPROMPT1=" + Prompt1
   Prompt2 = ":": Print #X, "SICPROMPT2=" + Prompt2
   Prompt3 = "?": Print #X, "SICPROMPT3=" + Prompt3
   Prompt4 = "#": Print #X, "SICPROMPT4=" + Prompt4
   Prompt5 = "]": Print #X, "SICPROMPT5=" + Prompt5
   BootError = 0: Print #X, "SICIGNORE=" + LTrim$(Str$(BootError))
   MakeBeep = 0: Print #X, "SICMAKEBEEP=" + LTrim$(Str$(MakeBeep))
   CPUtraptype = 0: Print #X, "SICCPUTRAP=" + LTrim$(Str$(CPUtraptype))
   StatusForeground = 15: Print #X, "STATUSFORE=" + LTrim$(Str$(StatusForeground))
   StatusBackground = 1: Print #X, "STATUSBACK=" + LTrim$(Str$(StatusBackground))
   MEMtraptype = 0: Print #X, "MEMTRAP=" + LTrim$(Str$(MEMtraptype))
   MEMtraptype2 = 0: Print #X, "MEMTRAP2=" + LTrim$(Str$(MEMtraptype2))
   SuffixType = 3: Print #X, "SUFFIXTYPE=" + LTrim$(Str$(SuffixType))
   AutoIndent = 0: Print #X, "AUTOINDENT=" + LTrim$(Str$(AutoIndent))
   AutoIndentSpaces = 3: Print #X, "AUTOINDENTSPACES=" + LTrim$(Str$(AutoIndentSpaces))
   AutoSave = 0: Print #X, "AUTOSAVE=" + LTrim$(Str$(AutoSave))
   AutoSaveValue = 0: Print #X, "AUTOSAVEVALUE=" + LTrim$(Str$(AutoSaveValue))
   AutoSaveAlert = 0: Print #X, "AUTOSAVEALERT=" + LTrim$(Str$(AutoSaveAlert))
   HelpOff = 0: Print #X, "HELPOFF=" + LTrim$(Str$(HelpOff))
   AvoidLINUX = 0: Print #X, "AVOIDLINUX=" + LTrim$(Str$(AvoidLINUX))
   ForceLINUX = 0: Print #X, "FORCELINUX=" + LTrim$(Str$(ForceLINUX))
   DotDisplay = 1: Print #X, "DOTDISPLAY=" + LTrim$(Str$(DotDisplay))
   Compatible = 0: Print #X, "COMPATIBLE=" + LTrim$(Str$(Compatible))
   Creation.Time = 0: Print #X, "DATETIME1=" + LTrim$(Str$(Creation.Time))
   Access.Time = 0: Print #X, "DATETIME2=" + LTrim$(Str$(Access.Time))
   Modified.Time = 0: Print #X, "DATETIME3=" + LTrim$(Str$(Modified.Time))
   KeyboardTimer = 0: Print #X, "KEYBOARDTIMER=" + LTrim$(Str$(KeyboardTimer))
   StartMenuIgnore = 0: Print #X, "STARTMENUIGNORE=" + LTrim$(Str$(StartMenuIgnore))
   StartBoxIgnore = 0: Print #X, "STARTBOXIGNORE=" + LTrim$(Str$(StartBoxIgnore))
   QuitBoxIgnore = 0: Print #X, "QUITBOXIGNORE=" + LTrim$(Str$(QuitBoxIgnore))
   Close #X
End Sub

Sub ReadConfig (Var)
   Var = 0
   WindowX = _ScreenX: WindowY = _ScreenY
   f$ = CurrentDirectory
   If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
   f$ = f$ + "sick" + Hex$(Node) + ".cfg"
   If _FileExists(f$) = False Then Exit Sub
   Var = True
   X = FreeFile
   Open f$ For Input As #X
   If EOF(X) = 0 Then
      Input #X, WindowX
   End If
   If EOF(X) = 0 Then
      Input #X, WindowY
   End If
   Do Until EOF(X)
      Line Input #X, V$
      If Left$(V$, 1) <> ";" Then
         If InStr(V$, "=") Then
            V1$ = Left$(V$, InStr(V$, "=") - 1)
            V2$ = Mid$(V$, InStr(V$, "=") + 1)
            Select Case UCase$(V1$)
               Case "SICPAGELENGTH"
                  PageLength = Int(Val(V2$))
               Case "SICSAVEONEXIT"
                  SaveOnExit = Int(Val(V2$))
               Case "SICSTATUSLINE"
                  StatusType = Int(Val(V2$))
               Case "SICPROMPT1"
                  Prompt1 = V2$
               Case "SICPROMPT2"
                  Prompt2 = V2$
               Case "SICPROMPT3"
                  Prompt3 = V2$
               Case "SICPROMPT4"
                  Prompt4 = V2$
               Case "SICPROMPT5"
                  Prompt5 = V2$
               Case "SICIGNORE"
                  BootError = Int(Val(V2$))
               Case "SICMAKEBEEP"
                  MakeBeep = Int(Val(V2$))
               Case "SICCPUTRAP"
                  CPUtraptype = Int(Val(V2$))
               Case "STATUSFORE"
                  StatusForeground = Int(Val(V2$))
               Case "STATUSBACK"
                  StatusBackground = Int(Val(V2$))
               Case "MEMTRAP"
                  MEMtraptype = Int(Val(V2$))
               Case "MEMTRAP2"
                  MEMtraptype2 = Int(Val(V2$))
               Case "SUFFIXTYPE"
                  SuffixType = Int(Val(V2$))
               Case "AUTOINDENT"
                  AutoIndent = Int(Val(V2$))
               Case "AUTOINDENTSPACES"
                  AutoIndentSpaces = Int(Val(V2$))
               Case "AUTOSAVE"
                  AutoSave = Int(Val(V2$))
               Case "AUTOSAVEVALUE"
                  AutoSaveValue = Int(Val(V2$))
               Case "AUTOSAVEALERT"
                  AutoSaveAlert = Int(Val(V2$))
               Case "HELPOFF"
                  HelpOff = Int(Val(V2$))
               Case "AVOIDLINUX"
                  AvoidLINUX = Int(Val(V2$))
               Case "FORCELINUX"
                  ForceLINUX = Int(Val(V2$))
               Case "DOTDISPLAY"
                  DotDisplay = Int(Val(V2$))
               Case "COMPATIBLE"
                  Compatible = Int(Val(V2$))
               Case "DATETIME1"
                  Creation.Time = Int(Val(V2$))
               Case "DATETIME2"
                  Access.Time = Int(Val(V2$))
               Case "DATETIME3"
                  Modified.Time = Int(Val(V2$))
               Case "KEYBOARDTIMER"
                  KeyboardTimer = Int(Val(V2$))
               Case "STARTMENUIGNORE"
                  StartMenuIgnore = Int(Val(V2$))
               Case "STARTBOXIGNORE"
                  StartBoxIgnore = Int(Val(V2$))
               Case "QUITBOXIGNORE"
                  QuitBoxIgnore = Int(Val(V2$))
            End Select
         End If
      End If
   Loop
   Close #X
End Sub

' restore recent list array
Sub ReadRecent (Var)
   Var = 0
   f$ = CurrentDirectory
   If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
   f$ = f$ + "sickrecent" + Hex$(Node) + ".cfg"
   If _FileExists(f$) = False Then Exit Sub
   Var = True
   X = FreeFile
   Open f$ For Input As #X
   Do Until EOF(X)
      Line Input #X, V$
      If Left$(V$, 1) <> ";" Then
         If InStr(V$, "=") Then
            V1$ = Left$(V$, InStr(V$, "=") - 1)
            V2$ = Mid$(V$, InStr(V$, "=") + 1)
            V = Int(Val(V1$))
            If V >= 1 And V <= MaxRecent Then
               Recent1(V) = V2$
            End If
         End If
      End If
   Loop
   Close #X
End Sub

' display prompt text with macros
Sub DisplayPrompt (Prompt$)
   Dim StoreX As Integer, StoreY As Integer
   Length = 0
   Var$ = Prompt$
   Do
      If Left$(Var$, 1) = "$" Then
         Param$ = Left$(Var$, 2)
         Param$ = Mid$(Param$, 2)
         Var$ = Mid$(Var$, 3)
         If UCase$(Param$) = "F" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  If Param$ <> Nul Then ' x;y
                     T = InStr(Param$, ";")
                     If T = 0 Then
                        T = InStr(Param$, ",")
                     End If
                     If T Then
                        Z = LastWidth2
                        X1 = Val(Left$(Param$, T - 1))
                        Y1 = Val(Mid$(Param$, T + 1))
                        If X1 >= 1 And X1 <= Z Then
                           If Y1 >= 1 And Y1 <= LastWidth1 Then
                              Locate X1, Y1, 1
                           End If
                        End If
                     End If
                  End If
                  Var$ = Mid$(Var$, V + 1)
               End If
            End If
         End If
         If UCase$(Param$) = "W" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  Var$ = Mid$(Var$, V + 1)
                  If Param$ <> Nul Then
                     ' parse whatis
                     Out2 = Param$
                     Out2 = Ttrim$(Out2, True)
                     Out2 = "PRINT " + Out2 + ";"
                     If Temp0 > 0 Then
                        ' clear recurse flag
                        Recurse2 = 0
                        Recurse = 0
                        ' store error variable
                        BootStore = BootError
                        BootError = True
                        ' start the parser
                        WhatisError = True
                        Call EnterEquate
                        WhatisError = False
                        ' restore error variable
                        BootError = BootStore
                     End If
                  End If
               End If
            End If
         End If
         If UCase$(Param$) = "C" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  If Param$ <> Nul Then
                     T = Int(Val(Param$))
                     If T >= 0 And T <= 15 Then
                        Color T
                     End If
                  End If
                  Var$ = Mid$(Var$, V + 1)
               End If
            End If
         End If
         If UCase$(Param$) = "A" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  Var$ = Mid$(Var$, V + 1)
                  If Param$ <> Nul Then
                     If Asc(Param$) >= 0 And Asc(Param$) <= 255 Then
                        Whatis.Length = Whatis.Length + 1
                        Print Chr$(Val(Param$));
                     End If
                  End If
               End If
            End If
         End If
         If UCase$(Param$) = "E" Then
            If Left$(Var$, 1) = "[" Then
               V = InStr(2, Var$, "]")
               If V Then
                  Param$ = Left$(Var$, V - 1)
                  Param$ = Mid$(Param$, 2)
                  If Param$ <> Nul Then
                     T = Int(Val(Param$))
                     If T >= 0 And T <= 7 Then
                        Color , T
                     End If
                  End If
                  Var$ = Mid$(Var$, V + 1)
               End If
            End If
         End If
         If UCase$(Param$) = "J" Then
            Length = 0
            Cls
         End If
         If UCase$(Param$) = "P" Then
            Length = Length + Len(_CWD$)
            Print _CWD$;
         End If
         If UCase$(Param$) = "K" Then
            Length = Length + Len(_OS$)
            Print _OS$;
         End If
         If UCase$(Param$) = "N" Then
            Length = Length + 1
            Print Left$(_CWD$, 1);
         End If
         If UCase$(Param$) = "D" Then
            Length = Length + 10
            Print Date$;
         End If
         If UCase$(Param$) = "T" Then
            Length = Length + 8
            Print Time$;
         End If
         If UCase$(Param$) = "V" Then
            X$ = "v" + Version$
            Length = Length + Len(X$)
            Print X$;
         End If
         If UCase$(Param$) = "R" Then
            X$ = "r" + Release$
            Length = Length + Len(X$)
            Print X$;
         End If
         If UCase$(Param$) = "Q" Then
            GoSub DisplayVolume
         End If
         If UCase$(Param$) = "Z" Then
            GoSub DisplaySerial
         End If
         If UCase$(Param$) = "S" Then
            StoreX = CsrLin
            StoreY = Pos(0)
         End If
         If UCase$(Param$) = "U" Then
            If StoreX > 0 And StoreY > 0 Then
               Locate StoreX, StoreY, 1
            End If
         End If
         If UCase$(Param$) = "_" Then
            Length = 0
            Print
         End If
         If UCase$(Param$) = "$" Then
            Length = Length + 1
            Print "$";
         End If
         If UCase$(Param$) = "G" Then
            Length = Length + 1
            Print ">";
         End If
         If UCase$(Param$) = "L" Then
            Length = Length + 1
            Print "<";
         End If
         If UCase$(Param$) = "H" Then ' backspace
            If Pos(0) > 1 Then ' check cursor location
               Locate CsrLin, Pos(0) - 1, 0
               Print " ";
               Locate CsrLin, Pos(0) - 1, 1
               Length = Length - 1
            End If
         End If
      Else
         If Length < ScreenWidth Then
            Length = Length + 1
            Print Left$(Var$, 1);
            Locate , , 1
         End If
         Var$ = Mid$(Var$, 2)
      End If
      If Var$ = Nul Then Exit Do
   Loop
   Exit Sub

   ' display drive volume for prompt
   DisplayVolume:
   f$ = UCase$(Left$(_CWD$, 1))
   If f$ >= "A" And f$ <= "Z" Then
      f = Asc(f$) - 64
      V = DRIVEEXISTS(f)
      If V = False Then
         Call Vlabel(f$)
         If RTrim$(f$) = Nul Then
            Var3$ = DriveType
         Else
            Var3$ = RTrim$(f$)
         End If
         Length = Length + Len(Var3$)
         Print Var3$;
      End If
   End If
   Return

   ' display drive volume for prompt
   DisplaySerial:
   f$ = UCase$(Left$(_CWD$, 1))
   If f$ >= "A" And f$ <= "Z" Then
      f = Asc(f$) - 64
      V = DRIVEEXISTS(f)
      If V = False Then
         Call Vserial(f$)
         If RTrim$(f$) = Nul Then
            Var3$ = "0000-0000"
         Else
            Var3$ = RTrim$(f$)
         End If
         Length = Length + Len(Var3$)
         Print Var3$;
      End If
   End If
   Return
End Sub

' Displays ASCII character chart. v1.1a. PD 2006.
'  v1.1a modify unprintable char output for QB64.
Sub AsciiChart
   Color Plain, Black
   Cls
   Color White, Black
   Print "ASCII Chart for characters 1 to 127:"
   For Char = 1 To 127
      DisplayChar$ = Chr$(Char)
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("00" + Var$, 3) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If (Char Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   x$ = Inkey2$
   Color Plain, Black
   Print
   Cls
   Color White, Black
   Print "ASCII Chart for characters 128 to 255:"
   For Char = 128 To 255
      DisplayChar$ = Chr$(Char)
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("00" + Var$, 3) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If ((Char - 7) Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   x$ = Inkey2$
   Print
   Exit Sub
End Sub

' Displays HEX character chart. v1.1a. PD 2006.
'  v1.1a modify unprintable char output for QB64.
Sub HexChart
   Color Plain, Black
   Cls
   Color White, Black
   Print "HEX Chart for characters 1 to 127:"
   For Char = 1 To 127
      DisplayChar$ = Chr$(Char)
      Var$ = Hex$(Char)
      Var1$ = Right$("0" + Var$, 2) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If (Char Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   x$ = Inkey2$
   Color Plain, Black
   Print
   Cls
   Color White, Black
   Print "HEX Chart for characters 128 to 255:"
   For Char = 128 To 255
      DisplayChar$ = Chr$(Char)
      Var$ = Hex$(Char)
      Var1$ = Right$("0" + Var$, 2) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$; " ";
      ' check full screen line
      If ((Char - 7) Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   x$ = Inkey2$
   Print
   Exit Sub
End Sub

Sub Samples
   Color White, Black
   Print "An example to display prime numbers:"
   Print ""
   Color Yellow, Black
   Print "10 P=2"
   Print "20 P=P+1"
   Print "30 FOR L=2 TO INT(SQR(P))"
   Print "40    IF P/L=P\L THEN"
   Print "50       GOTO 20"
   Print "60    ENDIF"
   Print "70 NEXT L"
   Print "80 PRINT P"
   Print "90 GOTO 20"
   Print ""
   If ProgramName = None Then
      Call MorePrompt("Import program(y/n)?", "yn", OutputChar$)
      If OutputChar$ = "y" Then
         ProgramName = Untitled
         Program(10) = "P=2"
         Program(20) = "P=P+1"
         Program(30) = "FOR L=2 TO INT(SQR(P))"
         Program(40) = "   IF P/L=P\L THEN"
         Program(50) = "      GOTO 20"
         Program(60) = "   ENDIF"
         Program(70) = "NEXT L"
         Program(80) = "PRINT P"
         Program(90) = "GOTO 20"
         Print "Program loaded."
         Exit Sub
      End If
   Else
      Call KeyPrompt
   End If
   Color White, Black
   Print "An example of a bubble sort:"
   Print ""
   Color Yellow, Black
   Print "10 FOR L=1 TO 10"
   Print "20    X(L)=INT(RND*10+1)"
   Print "30 NEXT"
   Print "40 FOR L=1 TO 10"
   Print "50    FOR M=L+1 TO 10"
   Print "60       IF X(L)>X(M) THEN"
   Print "70          SWAP X(L),X(M)"
   Print "80       END IF"
   Print "90    NEXT"
   Print "100 NEXT"
   Print "110 FOR L=1 TO 10"
   Print "120    PRINT X(L);"
   Print "130 NEXT"
   Print ""
   If ProgramName = None Then
      Call MorePrompt("Import program(y/n)?", "yn", OutputChar$)
      If OutputChar$ = "y" Then
         ProgramName = Untitled
         Program(10) = "FOR L=1 TO 10"
         Program(20) = "   X(L)=INT(RND*10+1)"
         Program(30) = "NEXT"
         Program(40) = "FOR L=1 TO 10"
         Program(50) = "   FOR M=L+1 TO 10"
         Program(60) = "      IF X(L)>X(M) THEN"
         Program(70) = "         SWAP X(L),X(M)"
         Program(80) = "      END IF"
         Program(90) = "   NEXT"
         Program(100) = "NEXT"
         Program(110) = "FOR L=1 TO 10"
         Program(120) = "   PRINT X(L);"
         Program(130) = "NEXT"
         Print "Program loaded."
         Exit Sub
      End If
   Else
      Call KeyPrompt
   End If
   Color White, Black
   Print "An example of a shell sort:"
   Print ""
   Color Yellow, Black
   Print "10 N=10"
   Print "20 FOR L=1 TO N"
   Print "30    X(L)=INT(RND*N+1)"
   Print "40 NEXT"
   Print "50 S=INT(N/2)"
   Print "60 DO WHILE S>0"
   Print "70    FOR I=S TO N-1"
   Print "80       FOR J=(I-S+1) TO 1 STEP -S"
   Print "90          IF X(J)<X(J+S) THEN"
   Print "100            EXIT FOR"
   Print "110         END IF"
   Print "120         SWAP X(J),X(J+S)"
   Print "130      NEXT"
   Print "140   NEXT"
   Print "150   S=INT(S/2)"
   Print "160 LOOP"
   Print "170 FOR L=1 TO N"
   Print "180    PRINT X(L);"
   Print "190 NEXT"
   Print ""
   If ProgramName = None Then
      Call MorePrompt("Import program(y/n)?", "yn", OutputChar$)
      If OutputChar$ = "y" Then
         ProgramName = Untitled
         Program(10) = "N=10"
         Program(20) = "FOR L=1 TO N"
         Program(30) = "   X(L)=INT(RND*N+1)"
         Program(40) = "NEXT"
         Program(50) = "S=INT(N/2)"
         Program(60) = "DO WHILE S>0"
         Program(70) = "   FOR I=S TO N-1"
         Program(80) = "      FOR J=(I-S+1) TO 1 STEP -S"
         Program(90) = "         IF X(J)<X(J+S) THEN"
         Program(100) = "           EXIT FOR"
         Program(110) = "         END IF"
         Program(120) = "         SWAP X(J),X(J+S)"
         Program(130) = "      NEXT"
         Program(140) = "   NEXT"
         Program(150) = "   S=INT(S/2)"
         Program(160) = "LOOP"
         Program(170) = "FOR L=1 TO N"
         Program(180) = "   PRINT X(L);"
         Program(190) = "NEXT"
         Print "Program loaded."
         Exit Sub
      End If
   Else
      Call KeyPrompt
   End If
   Color White, Black
   Print "Sample to draw all polygons:"
   Print ""
   Color Yellow, Black
   Print "10  SCREEN 12"
   Print "20  FOR n = 3 TO 30"
   Print "30     CLS"
   Print "40     a = n * 5 + 1"
   Print "50     POLYGON 320, 240, 100, n, a, 15"
   Print "60     PAINT 320, 240, 15, 15"
   Print "70     WHILE INKEY$ = NUL"
   Print "80     WEND"
   Print "90  NEXT"
   If ProgramName = None Then
      Call MorePrompt("Import program(y/n)?", "yn", OutputChar$)
      If OutputChar$ = "y" Then
         ProgramName = Untitled
         Program(10) = "SCREEN 12"
         Program(20) = "FOR n = 3 TO 30"
         Program(30) = "   CLS"
         Program(40) = "   a = n * 5 + 1"
         Program(50) = "   POLYGON 320, 240, 100, n, a, 15"
         Program(60) = "   PAINT 320, 240, 15, 15"
         Program(70) = "   WHILE INKEY$ = NUL"
         Program(80) = "   WEND"
         Program(90) = "NEXT"
         Print "Program loaded."
         Exit Sub
      End If
   Else
      Call KeyPrompt
   End If
End Sub

Function FileCompare (Path1$, Path2$, Filename1$, Filename2$)
   FileComp1$ = Path1$
   If Right$(FileComp1$, 1) <> "\" Then
      FileComp1$ = FileComp1$ + "\"
   End If
   FileComp1$ = FileComp1$ + Filename1$

   FileComp2$ = Path2$
   If Right$(FileComp2$, 1) <> "\" Then
      FileComp2$ = FileComp2$ + "\"
   End If
   FileComp2$ = FileComp2$ + Filename2$

   If _FileExists(FileComp1$) = False Then
      FileCompare = 0
      Exit Function
   End If

   If _FileExists(FileComp2$) = False Then
      FileCompare = 0
      Exit Function
   End If
   ' check file buffers
   X = FreeFile
   Open FileComp1$ For Random Shared As #X Len = 1024
   Field #X, 1024 As X$
   Y = FreeFile
   Open FileComp2$ For Random Shared As #Y Len = 1024
   Field #Y, 1024 As Y$
   Do
      If EOF(X) Then Exit Do
      Get #X: Get #Y
      If X$ <> Y$ Then
         Close #X, #Y
         FileCompare = 0
         Exit Function
      End If
   Loop
   Close #X, #Y
   FileCompare = True
End Function

' compare 2 directories.
Sub VerifyFiles (Var1$, Var2$, VarX)
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata4 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset

   Dim Verify1(1) As String
   Dim Verify2(1) As String
   Dim VerifyCount1 As Single
   Dim VerifyCount2 As Single
   VerifyCount1 = SFalse
   VerifyCount2 = SFalse

   Dim SizeArray1(1) As Double
   Dim SizeArray2(1) As Double

   ' make search path
   Var3$ = Var1$
   If Right$(Var3$, 1) <> "\" Then
      Var3$ = Var3$ + "\"
   End If
   TempPath1$ = Var3$
   Var3$ = Var3$ + "*.*"

   Var4$ = Var2$
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   TempPath2$ = Var4$
   Var4$ = Var4$ + "*.*"

   If VarX Then
      Color White, Black
      Print "Wait.."
   End If

   ' store first path files
   ASCIIZ = Var3$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      Do
         Attribute = finddata4.dwFileAttributes
         ' check for directory
         If (Attribute And &H10) <> &H10 Then
            ' store directory name
            Directory$ = finddata4.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then
               VerifyCount1 = VerifyCount1 + 1!
               ReDim _Preserve Verify1(VerifyCount1) As String
               Verify1(VerifyCount1) = Directory$

               ReDim _Preserve SizeArray1(VerifyCount1) As Double
               SizeArray1(VerifyCount1) = finddata4.nFileSizeHigh * &H100000000~&& Or finddata4.nFileSizeLow

            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata4))
      x = FindClose(Wfile.Handle)
   End If

   ' store second path files
   ASCIIZ = Var4$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      Do
         Attribute = finddata4.dwFileAttributes
         ' check for directory
         If (Attribute And &H10) <> &H10 Then
            ' store directory name
            Directory$ = finddata4.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then
               VerifyCount2 = VerifyCount2 + 1!
               ReDim _Preserve Verify2(VerifyCount2) As String
               Verify2(VerifyCount2) = Directory$

               ReDim _Preserve SizeArray2(VerifyCount2) As Double
               SizeArray2(VerifyCount2) = finddata4.nFileSizeHigh * &H100000000~&& Or finddata4.nFileSizeLow

            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata4))
      x = FindClose(Wfile.Handle)
   End If

   ' check files found
   If VerifyCount1 = SFalse Or VerifyCount2 = SFalse Then
      Color White
      Print "No matching files found."
      Exit Sub
   End If

   If VarX = False Then
      Color White, Black
      Print "Filename1", "Filename2", "   Filesize"
      Print "---------", "---------", "   --------"
   End If

   ' compare both arrays
   LineCount = 3
   LineBreak = PageLength
   Found = False
   Color White
   Print "Comparing "; Var3$; " to "; Var4$
   MatchingBytes# = Dfalse
   For Var1! = 1! To VerifyCount1
      For Var2! = 1! To VerifyCount2
         If Verify1(Var1!) = Verify2(Var2!) Then
            If SizeArray1(Var1!) = SizeArray2(Var2!) Then
               If FileCompare(Var1$, Var2$, Verify1(Var1!), Verify2(Var2!)) Then
                  If Found = False Then
                     If VarX = False Then
                        Color White
                        Print "Filename1", "Filename2", "Filesize"
                        Print "---------", "---------", "--------"
                     End If
                  End If
                  Found = Found + 1
                  MatchingBytes# = MatchingBytes# + SizeArray1(Var1!)
                  Color Yellow
                  ' force to 8.3
                  File1$ = Ambiguate$(TempPath1$ + Verify1(Var1!))
                  If File1$ = Nul Then File1$ = Verify1(Var1!)
                  File2$ = Ambiguate$(TempPath2$ + Verify2(Var2!))
                  If File2$ = Nul Then File2$ = Verify2(Var2!)
                  ' strip path
                  File1$ = Ambiguate2$(File1$)
                  File1$ = Left$(File1$, 12)
                  File2$ = Ambiguate2$(File2$)
                  File2$ = Left$(File2$, 12)
                  ' display matching files
                  If VarX = False Then
                     Print UCase$(File1$), UCase$(File2$), FormatString$(SizeArray1(Var1!))
                     LineCount = LineCount + 1
                     If LineCount >= LineBreak Then
                        LineCount = False
                        Color White
                        Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
                        If Outpt$ = "n" Then
                           Exit Sub
                        End If
                     End If
                  End If
               End If
            End If
         End If
      Next
   Next
   If Found = False Then
      Color White
      Print "No matching files found."
   Else
      Color Yellow
      Print "Matching files:"; Found; "bytes: "; FormatString$(MatchingBytes#)
   End If
   If LineCount Then
      Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
   End If
End Sub

' compare 2 filenames.
Sub VerifyFiles2 (Var1$, Var2$, VarX)
   Dim Byte1 As String * 1
   Dim Byte2 As String * 1
   X = FreeFile
   Open Var1$ For Binary Shared As #X Len = 1
   Y = FreeFile
   Open Var2$ For Binary Shared As #Y Len = 1
   If LOF(X) <> LOF(Y) Then
      Print "Files not same size."
      Close X, Y
      Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
      Exit Sub
   End If

   LineCount = 3
   LineBreak = PageLength

   Z# = Dfalse
   Close X, Y
   X = FreeFile
   Open Var1$ For Random Shared As #X Len = 1024
   Field #X, 1024 As x$
   Y = FreeFile
   Open Var2$ For Random Shared As #Y Len = 1024
   Field #Y, 1024 As y$
   T# = 1#
   VX = False
   ' read both files in 1K blocks.
   Do
      If EOF(X) Then Exit Do
      Get #X: Get #Y
      If x$ <> y$ Then
         If VarX Then
            If VX = False Then
               Color White
               Print "Comparing "; Var1$; " to "; Var2$
               Print "Offset         Byte Hex    ASCII"
               Print "-------------  ---- -----  -------"
            End If
            VX = True
            GoSub DisplayX
         Else
            Print "Files do not match."
            Close #X, #Y
            Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
            Exit Sub
         End If
      End If
      T# = T# + 1024#
   Loop
   Close #X, #Y
   If VX = False Then
      Print "Files match."
      Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
   Else
      If LineCount Then
         Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
      End If
   End If
   Exit Sub
   ' display bytes compared in block.
   DisplayX:
   For Q = 1 To 1024
      Byte1 = Mid$(x$, Q, 1)
      Byte2 = Mid$(y$, Q, 1)
      Z# = T# + Q - 1 ' store block plus byte.
      If Byte1 <> Byte2 Then
         V1$ = LTrim$(Str$(Z#)): V1$ = V1$ + Space$(15 - Len(V1$))
         Color Yellow: Print V1$;
         V1$ = Byte1
         Color Red: Print V1$;
         Color White: Print "\";
         V1$ = Byte2 + "  "
         Color Red: Print V1$;
         V2$ = Right$("00" + Hex$(Asc(Byte1)), 2) + "\" + Right$("00" + Hex$(Asc(Byte2)), 2)
         V3$ = Right$("000" + LTrim$(Str$(Asc(Byte1))), 3) + "\" + Right$("000" + LTrim$(Str$(Asc(Byte2))), 3)
         VX$ = V2$ + "  " + V3$
         Color Green: Print VX$
         LineCount = LineCount + 1
         If LineCount >= LineBreak Then
            LineCount = 0
            Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
            If Outpt$ = "n" Then
               Exit For
            End If
         End If
      End If
   Next
   Return
End Sub

' Custom line input function.
' Input:
'    XC = X-coordinate
'    YC = Y-coordinate
'    LC = Edit area length
Function LineInput$ (XC, YC, LC)
   ' init constants
   Const MaskChar = "#"

   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   Insert = True
   GoSub DisplayFileLine

   ' main input loop.
   Do
      ' get keypress.
      I$ = InKeyx$

      ' check key.
      If Len(I$) = 1 Then

         ' enter key.
         If I$ = Chr$(13) Then
            LineInput$ = X$
            Exit Do
         End If

         ' escape key.
         If I$ = Chr$(27) Then
            LineInput$ = Nul
            Exit Do
         End If

         ' backspace.
         If I$ = Chr$(8) Then
            If Len(X$) Then
               If Xposition2 > 0 Then
                  If Insert Then ' destructive backspace
                     X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                  End If
                  Xposition2 = Xposition2 - 1
                  If Xposition2 - LC <= Xposition1 Then
                     Xposition1 = Xposition1 - 1
                     If Xposition1 < 1 Then
                        Xposition1 = 1
                     End If
                  End If
                  GoSub DisplayFileLine
               End If
            End If
         Else
            ' append/insert character into edit area.
            OK = True
            If Asc(I$) >= 0 And Asc(I$) <= 31 Then
               OK = 0 ' disallow control charcters
            End If
            If OK Then
               If Insert Then
                  X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                  Xposition2 = Xposition2 + 1
                  If Xposition2 > LC Then
                     Xposition1 = Xposition1 + 1
                  End If
               Else
                  If Xposition2 + 1 > Len(X$) Then
                     X$ = X$ + I$ ' append
                     Xposition2 = Xposition2 + 1
                     If Xposition2 > LC Then
                        Xposition1 = Xposition1 + 1
                     End If
                  Else ' insert
                     Mid$(X$, Xposition2 + 1, 1) = I$
                     Xposition2 = Xposition2 + 1
                  End If
               End If
               GoSub DisplayFileLine
            End If
         End If
      End If

      ' check extended key
      If Len(I$) = 2 Then
         Select Case Asc(Right$(I$, 1))
            Case 82 ' Insert
               Insert = Not Insert
               If Insert Then
                  Locate , , 1, 8, 8 ' line cursor
               Else
                  Locate , , 1, 0, 8 ' block cursor
               End If
            Case 83 ' Delete
               If Len(X$) > 0 Then
                  X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                  GoSub DisplayFileLine
               End If
            Case 71, 73, 119 ' Home/PageUp/Ctrl-Home
               If Xposition2 > 0 Then
                  Xposition1 = 1
                  Xposition2 = 0
                  GoSub DisplayFileLine
               End If
            Case 79, 81, 117 ' End/PageDown/Ctrl-End
               If Xposition2 < Len(X$) Then
                  Xposition2 = Len(X$)
                  Xposition1 = Xposition2 - LC + 1
                  If Xposition1 < 1 Then
                     Xposition1 = 1
                  End If
                  GoSub DisplayFileLine
               End If
            Case 75, 115, 155 ' Left/Ctrl-Left/Alt-Left
               If Len(X$) Then
                  If Xposition2 > 0 Then
                     Xposition2 = Xposition2 - 1
                     If Xposition2 - LC <= Xposition1 Then
                        Xposition1 = Xposition1 - 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                        GoSub DisplayFileLine
                     End If
                  End If
               End If
            Case 77, 116, 157 ' Right/Ctrl-Right/Alt-Right
               If Len(X$) Then
                  If Xposition2 < Len(X$) Then
                     Xposition2 = Xposition2 + 1
                     If Xposition2 > Xposition1 + LC - 1 Then
                        Xposition1 = Xposition1 + 1
                     End If
                     GoSub DisplayFileLine
                  End If
               End If
         End Select
      End If
   Loop
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' display current entry area.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);

   ' display edit line and position cursor.
   Locate XC, YC, 1
   If Len(X$) Then
      Color White
      If MaskInput Then
         LV = Len(Mid$(X$, Xposition1, LC))
         Print String$(LV, MaskChar$);
      Else
         Print Mid$(X$, Xposition1, LC);
      End If
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   Color Plain, Black
   Return
End Function

' display windows error message
Function DisplayWinError$ (x)
   Dim ErrorBuffer As String * 260
   x = True
   ' define error message value
   v& = GetLastError
   ' call windows error message routine
   x& = FormatMessageA&(&H1200, "", v&, 0, ErrorBuffer$, 260, "")
   If x& Then
      DisplayWinError$ = Left$(ErrorBuffer$, x& - 2)
   Else
      DisplayWinError$ = "Unknown error 0x" + Hex$(v&) + "."
   End If
End Function

' edit menu
Sub EditMenu (f$)
   Color White
   If f$ = Nul Then
      f$ = _SaveFileDialog$("SICK open file", _CWD$)
   End If
   If f$ <> Nul Then
      Timer(t2) Off
      t10 = _FreeTimer
      On Timer(t10, 1) Edit.Status.Line
      Timer(t10) On
      Call Scrnedit(f$)
      Timer(t10) Off
      Timer(t2) On
   Else
      Color White
      Print "File not found."
      Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
   End If
End Sub

' count menu
Sub CountMenu (param$)
   If Len(param$) Then
      Select Case param$
         Case "MENU"
            Do
               Color Yellow
               Print "Count menu:"
               Color White
               Print "  (A)ll list"
               Print "  (B)ytes"
               Print "  (F)iles"
               Print "  (D)irs"
               Print "  (L)ist drives"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = InKeyx$
                  If Len(x$) Then
                     Print x$
                     Exit Do
                  End If
               Loop
               Select Case UCase$(x$)
                  Case "A"
                     Color White
                     Q# = CountBytes#("*.*")
                     X# = CountFiles("*.*")
                     Y# = CountDirs("*.*")
                     Z = CountDrives
                     Z1$ = CountDriveLetters
                     Print _CWD$
                     Print "Drives:"; Z; "("; Z1$; ")"
                     Print "Dirs: "; FormatString$(Y#)
                     Print "Files: "; FormatString$(X#)
                     Print "Bytes: "; FormatString$(Q#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "B"
                     prompt$ = "Enter file spec(*.*)? "
                     f$ = KeyboardLine3$(prompt$)
                     Q# = CountBytes#(f$)
                     Print "Bytes: "; FormatString$(Q#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "F"
                     prompt$ = "Enter file spec(*.*)? "
                     f$ = KeyboardLine3$(prompt$)
                     X# = CountFiles(f$)
                     Print "Files: "; FormatString$(X#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "D"
                     prompt$ = "Enter dir spec(*.*)? "
                     f$ = KeyboardLine3$(prompt$)
                     Y# = CountDirs(f$)
                     Print "Dirs: "; FormatString$(Y#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "L"
                     Z = CountDrives
                     Z1$ = CountDriveLetters
                     Print "Drives:"; Z; "("; Z1$; ")"
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "Q"
                     Exit Do
               End Select
            Loop
            Exit Sub
         Case "HELP"
            Color White
            Print "COUNT options:"
            Print "   COUNT FILES"
            Print "     Prompts for filespec and counts files."
            Print "   COUNT DIRS"
            Print "     Prompts for filespec and counts dirs."
            Print "   COUNT BYTES"
            Print "     Prompts for filespec and counts bytes."
            Print "   COUNT DRIVES"
            Print "     Counts and displays drive letters."
            Print "   COUNT MENU"
            Print "     Starts count menu selection."
            Color Yellow
            Exit Sub
         Case "FILES"
            prompt$ = "Enter file spec(*.*)? "
            f$ = KeyboardLine3$(prompt$)
            X# = CountFiles(f$)
            Print "Files: "; FormatString$(X#)
            Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
            Exit Sub
         Case "DIRS"
            prompt$ = "Enter dir spec(*.*)? "
            f$ = KeyboardLine3$(prompt$)
            Y# = CountDirs(f$)
            Print "Dirs: "; FormatString$(Y#)
            Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
            Exit Sub
         Case "DRIVES"
            Z = CountDrives
            Z1$ = CountDriveLetters
            Print "Drives:"; Z; "("; Z1$; ")"
            Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
            Exit Sub
         Case "BYTES"
            prompt$ = "Enter file spec(*.*)? "
            f$ = KeyboardLine3$(prompt$)
            Q# = CountBytes#(f$)
            Print "Bytes: "; FormatString$(Q#)
            Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
            Exit Sub
         Case Else
            Print "Unknown parameter. Type COUNT HELP for help."
            Exit Sub
      End Select
   End If

   ' default to display all.
   Color White
   Q# = CountBytes#("*.*")
   X# = CountFiles("*.*")
   Y# = CountDirs("*.*")
   Z = CountDrives
   Z1$ = CountDriveLetters
   Print _CWD$
   Print "Drives:"; Z; "("; Z1$; ")"
   Print "Dirs: "; FormatString$(Y#)
   Print "Files: "; FormatString$(X#)
   Print "Bytes: "; FormatString$(Q#)
   Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
End Sub

' simple file edit menu
Sub Menu3
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata4 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset
   Dim hfind4 As _Offset
   Temp0 = 0
   cx$ = _CWD$ ' store current drive/directory
   Do
      Color Yellow
      Print "Main Options for ";
      Color Red
      Print _CWD$
      Color White
      Print "  (C)ount specs"
      Print "  (D)irectory"
      Print "  (F)iles"
      Print "  (V)olume"
      Print "  (S)ystem"
      Print "  (Q)uit"
      Color Yellow
      PromptStore$ = "Enter option(?=help):"
      Print "Enter option(?=help):";
      Color White
      Do
         Locate , , 1
         x$ = InKeyx$
         If x$ = Chr$(13) Then
            x$ = "q"
            Print "q"
            Exit Do
         Else
            If Len(x$) Then
               Print x$
               Exit Do
            End If
         End If
      Loop
      If UCase$(x$) = "Q" Then
         Color Plain
         ' restore current drive/directory
         f$ = cx$ + Chr$(0)
         x = SetCurrentDirectoryA(f$)
         Exit Sub
      End If
      Select Case UCase$(x$)
         Case "?"
            Filename = "menu3.doc"
            Call ListHelpFile(-1)
         Case "C"
            Color White
            Q# = CountBytes#("*.*")
            x# = CountFiles("*.*")
            Y# = CountDirs("*.*")
            Z = CountDrives
            Z1$ = CountDriveLetters
            Print _CWD$
            Print "Drives:"; Z; "("; Z1$; ")"
            Print "Dirs: "; FormatString$(Y#)
            Print "Files: "; FormatString$(x#)
            Print "Bytes: "; FormatString$(Q#)
            Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
         Case "S"
            Do
               If ScreenWidth = 40 Then
                  Color Yellow
                  Print "System Options: "
               Else
                  Color Yellow
                  Print "System Options for: ";
                  Color Red
                  If Left$(_CWD$, 2) = "\\" Then
                     Print _CWD$
                  Else
                     Print Left$(_CWD$, 3)
                  End If
               End If
               Color White
               Print "  (C)pu load"
               Print "  (S)ystem RAM"
               Print "  (P)aging RAM"
               Print "  (V)irtual RAM"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = InKeyx$
                  If Len(x$) Then
                     Print x$
                     Exit Do
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Select Case UCase$(x$)
                  Case "C"
                     Color Yellow
                     S$ = Str$(Int(GetCPULoad * 10000) / 100) ' 100.00
                     If InStr(S$, ".") Then
                        Q$ = Mid$(S$, InStr(S$, ".") + 1)
                        S$ = Left$(S$, InStr(S$, ".") - 1)
                        Q$ = Left$(Q$, 3)
                        S$ = S$ + "." + Q$
                     Else
                        S$ = S$ + ".0"
                     End If
                     Print "CPU " + S$ + "%" ' 100.00
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "S"
                     Color Yellow
                     Print "Total Physical Memory: "; FormatString$(CDbl(TotalPhysicalMem))
                     Print "Free Physical Memory: "; FormatString$(CDbl(FreePhysicalMem))
                     Used# = CDbl(TotalPhysicalMem) - CDbl(FreePhysicalMem)
                     Print "Used Physical Memory: "; FormatString$(Used#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "P"
                     Color Yellow
                     Print "Total Paging File: "; FormatString$(CDbl(TotalPagingFile))
                     Print "Free Paging File: "; FormatString$(CDbl(FreePagingFile))
                     Used# = CDbl(TotalPagingFile) - CDbl(FreePagingFile)
                     Print "Used Paging File: "; FormatString$(Used#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                  Case "V"
                     Color Yellow
                     Print "Total Virtual Memory: "; FormatString$(CDbl(TotalVirtualMem))
                     Print "Free Virtual Memory: "; FormatString$(CDbl(FreeVirtualMem))
                     Used# = CDbl(TotalVirtualMem) - CDbl(FreeVirtualMem)
                     Print "Used Virtual Memory: "; FormatString$(Used#)
                     Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
               End Select
            Loop
         Case "D"
            Do
               If ScreenWidth = 40 Then
                  Color Yellow
                  Print "Directory Options: "
               Else
                  Color Yellow
                  Print "Directory Options for: ";
                  Color Red
                  Print _CWD$;
                  Color Green
                  x# = CountDirs("*.*")
                  Print " ["; LTrim$(Str$(x#)); " dirs]"
               End If
               Color White
               Print "  (A)ttribute override"
               Print "  (C)reate directory"
               Print "  (L)ist directories"
               Print "  (R)emove directory"
               Print "  (S)et current directory"
               Print "  (V)erify duplicates"
               Print "  (X)search directories"
               Print "  (Y)count duplicates"
               Print "  (Z)extended display"
               Print "  (Q)uit"
               Color Yellow
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = InKeyx$
                  If Len(x$) Then
                     Print x$
                     Exit Do
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Select Case UCase$(x$)
                  Case "A"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> Nul Then
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Attribute = finddata.dwFileAttributes
                           x = FindClose(Wfile.Handle)
                           ' check for directory
                           If (Attribute And &H10) = &H10 Then
                              Do
                                 Color Yellow
                                 Print "Attributes:"
                                 Color White
                                 Print "  (1)Read-Only ";
                                 If (Attribute And &H1) = &H1 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (2)Hidden ";
                                 If (Attribute And &H2) = &H2 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (3)System ";
                                 If (Attribute And &H4) = &H4 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (4)Archive ";
                                 If (Attribute And &H20) = &H20 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (Q)uit"
                                 Color Yellow
                                 Print "Enter option?";
                                 Color White
                                 Do
                                    Locate , , 1
                                    x$ = InKeyx$
                                    If Len(x$) Then
                                       Print
                                       Exit Do
                                    End If
                                 Loop
                                 If UCase$(x$) = "Q" Then Exit Do
                                 Select Case x$
                                    Case "1"
                                       Attribute = Attribute Xor &H1
                                    Case "2"
                                       Attribute = Attribute Xor &H2
                                    Case "3"
                                       Attribute = Attribute Xor &H4
                                    Case "4"
                                       Attribute = Attribute Xor &H20
                                 End Select
                              Loop
                              ' change filename attribute
                              x = SetFileAttributes&(ASCIIZ, Attribute)
                           Else
                              Color White
                              Print "Specified filename."
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        Else
                           Color White
                           Print "Path not found."
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                     End If
                  Case "C"
                     'f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     Color Yellow
                     Print "Enter directory?";
                     Color White
                     f$ = LineInput$(CsrLin, Pos(0), 20): Print
                     If f$ <> Nul Then
                        x = CreateDirectoryStructure(f$)
                        Color Yellow
                        If x = 0 Then
                           If NetPathError Then
                              Print "Netpath error."
                           Else
                              Print "Error 0x" + Hex$(GetLastError) + " creating directory."
                              VarQ$ = DisplayWinError$(x)
                              If Len(VarQ$) Then
                                 Print VarQ$
                              End If
                           End If
                        Else
                           Print "Directory created."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "L"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> Nul Then
                        LineCount = 0
                        LineBreak = PageLength
                        Quit = 0
                        ' start directory search
                        ASCIIZ = f$ + "\*.*" + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Do
                              Attribute = finddata4.dwFileAttributes
                              ' check for directory
                              If (Attribute And &H10) = &H10 Then
                                 ' store directory name
                                 Directory$ = finddata4.cFileName
                                 Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
                                 ' check directory name
                                 If Directory$ <> "." And Directory$ <> ".." Then
                                    ' get numbers of dirs in dir.
                                    Var2# = CountDirs#(Directory$ + "\*.*")
                                    ' attributes of directory/filename
                                    Attr$ = Nul
                                    Var# = finddata4.dwFileAttributes
                                    If Var# < 0 Then
                                       Var# = 0
                                    End If
                                    If (Var# And &H20) = &H20 Then
                                       Attr$ = Attr$ + "A" ' archive
                                    End If
                                    If (Var# And &H4) = &H4 Then
                                       Attr$ = Attr$ + "S" ' system
                                    End If
                                    If (Var# And &H2) = &H2 Then
                                       Attr$ = Attr$ + "H" ' hidden
                                    End If
                                    If (Var# And &H1) = &H1 Then
                                       Attr$ = Attr$ + "R" ' read-only
                                    End If
                                    If (Var# And &H800) = &H800 Then
                                       Attr$ = Attr$ + "C" ' compressed
                                    End If
                                    If (Var# And &H4000) = &H4000 Then
                                       Attr$ = Attr$ + "E" ' encrypted
                                    End If
                                    Color Yellow
                                    Print Directory$;
                                    Print " ("; FormatString$(Var2#); " dirs) ";
                                    If Attr$ <> Nul Then
                                       Print " ["; Attr$; "]";
                                    End If
                                    Print
                                    LineCount = LineCount + 1
                                    If LineCount >= LineBreak Then
                                       LineCount = 0
                                       Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
                                       If Outpt$ = "n" Then
                                          Exit Do
                                       End If
                                    End If
                                 End If
                              End If
                           Loop While FindNextFileA(Wfile.Handle, _Offset(finddata4))
                           x = FindClose(Wfile.Handle)
                           If LineCount Then
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        Else
                           Color White
                           Print "Error 0x" + Hex$(GetLastError) + " searching directory."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        End If
                     End If
                  Case "R"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> Nul Then
                        Color Yellow
                        If _DirExists(f$) = False Then
                           Print "Directory not found."
                        Else
                           Print "Delete directory " + Quote + f$ + Quote + " and all filenames(y/n)? ";
                           Do
                              x$ = InKeyx$
                              If LCase$(x$) = "y" Then Print: DeleteDir = True: Exit Do
                              If LCase$(x$) = "n" Then Print: DeleteDir = False: Exit Do
                           Loop
                           If DeleteDir Then
                              If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
                              Call Silentdel_Directories(f$)
                              If _DirExists(f$) = False Then
                                 Print "Directory deleted."
                              Else
                                 Print "Error deleting directory."
                              End If
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        End If
                     End If
                  Case "S"
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ <> Nul Then
                        f$ = f$ + Chr$(0)
                        x = SetCurrentDirectoryA(f$)
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " changing directory."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        Else
                           Print "Directory changed."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "V"
                     Color White
                     f$ = _SelectFolderDialog$("Enter first directory", _CWD$)
                     If f$ <> Nul Then
                        Color White
                        g$ = _SelectFolderDialog$("Enter second directory", _CWD$)
                        If g$ <> Nul Then
                           If _DirExists(f$) And _DirExists(g$) Then
                              Call VerifyFiles(f$, g$, 0)
                           Else
                              Color White
                              Print "Path not found."
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        End If
                     End If
                  Case "X"
                     Color White
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ = Nul Then f$ = "*.*"
                     Call ListFilesX(f$, False)
                     Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
                  Case "Y"
                     Color White
                     f$ = _SelectFolderDialog$("Enter first directory", _CWD$)
                     If f$ <> Nul Then
                        Color White
                        g$ = _SelectFolderDialog$("Enter second directory", _CWD$)
                        If g$ <> Nul Then
                           If _DirExists(f$) And _DirExists(g$) Then
                              Color Plain
                              Call VerifyFiles(f$, g$, -1)
                           Else
                              Color White
                              Print "Path not found."
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        End If
                     End If
                  Case "Z"
                     Color White
                     f$ = _SelectFolderDialog$("Enter directory", _CWD$)
                     If f$ = Nul Then f$ = _CWD$
                     If Right$(f$, 1) <> "\" Then f$ = f$ + "\"
                     Quit.Searching = 0: Continue.Search = 0: Line.Counter = 0: Line.Counter2 = 0
                     Call Recurse_Directories(f$)
                     If Line.Counter Then
                        Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
                     End If
               End Select
            Loop
         Case "F"
            Do
               If ScreenWidth = 40 Then
                  Color Yellow
                  Print "File Options: "
               Else
                  Color Yellow
                  Print "File Options: ";
                  Color Red
                  Var# = CountFiles("*.*")
                  Print "("; LTrim$(Str$(Var#)); " files)"
               End If
               Color White
               Print "  (A)ppend file"
               Print "  (B)yte compare"
               Print "  (C)opy file"
               Print "  (D)elete file"
               Print "  (E)ncrypt file"
               Print "  (F)ile editor"
               Print "  (G)et filesize"
               Print "  (L)ist files"
               Print "  (M)ake file"
               Print "  (R)ename file"
               Print "  (S)et attributes"
               Print "  (T)est file"
               Print "  (U)nencrypt file"
               Print "  (V)erify files"
               Print "  (X)search files"
               Print "  (Z)extended display"
               Print "  (Q)uit"
               Color Yellow
               PromptStore$ = "Enter option?"
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = InKeyx$
                  If Len(x$) Then
                     Print x$
                     Exit Do
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Select Case UCase$(x$)
                  Case "A"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        hfind4 = CreateFileA(f$, 2)
                        Color Yellow
                        Print "File opened for append."
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "B"
                     f$ = _OpenFileDialog$("SICK open first file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                     If f$ <> Nul Then
                        g$ = _OpenFileDialog$("SICK open second file", _CWD$)
                        If g$ = Nul Then
                           Color White
                           Print "File not found."
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                        If g$ <> Nul Then
                           If _FileExists(f$) And _FileExists(g$) Then
                              Call VerifyFiles2(f$, g$, -1)
                           Else
                              Color White
                              Print "File not found."
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        End If
                     End If
                  Case "C"
                     f$ = _OpenFileDialog$("SICK source file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                     If f$ <> Nul Then
                        g$ = _SaveFileDialog$("SICK destination file", _CWD$)
                        If g$ = Nul Then
                           Color White
                           Print "File not found."
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                        If g$ <> Nul Then
                           If _FileExists(g$) Then
                              Color White, Black
                              Print "Overwrite " + Quote + g$ + Quote + "."
                              Call MorePrompt("Are you sure(y/n)?", "yn", OutputChar$)
                              Color White, Black
                              If OutputChar$ = "y" Then
                                 f$ = f$ + Chr$(0)
                                 g$ = g$ + Chr$(0)
                                 x = CopyFile(f$, g$, 0) ' 0=overwrite, -1=don't
                                 Color Yellow
                                 If x = 0 Then
                                    Print "Error 0x" + Hex$(GetLastError) + " copying filename."
                                    VarQ$ = DisplayWinError$(x)
                                    If Len(VarQ$) Then
                                       Print VarQ$
                                    End If
                                 Else
                                    Print "Filename copied."
                                 End If
                                 Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                              Else
                                 Print "File not copied."
                              End If
                           Else
                              f$ = f$ + Chr$(0)
                              g$ = g$ + Chr$(0)
                              x = CopyFile(f$, g$, 0) ' 0=overwrite, -1=don't
                              Color Yellow
                              If x = 0 Then
                                 Print "Error 0x" + Hex$(GetLastError) + " copying filename."
                                 VarQ$ = DisplayWinError$(x)
                                 If Len(VarQ$) Then
                                    Print VarQ$
                                 End If
                              Else
                                 Print "Filename copied."
                              End If
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        End If
                     End If
                  Case "D"
                     f$ = _OpenFileDialog$("SICK kill file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        f$ = f$ + Chr$(0)
                        x = DeleteFileA(f$)
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " deleting file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        Else
                           Print "File deleted."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "E"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        f$ = f$ + Chr$(0)
                        x = EncryptFile(f$)
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " encrypting file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        Else
                           Print "File encrypted."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "F"
                     Color White
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ <> Nul Then
                        Timer(t2) Off
                        t10 = _FreeTimer
                        On Timer(t10, 1) Edit.Status.Line
                        Timer(t10) On
                        Call Scrnedit(f$)
                        Timer(t10) Off
                        Timer(t2) On
                     Else
                        Color White
                        Print "File not found."
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "G"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           File.Size# = finddata4.nFileSizeHigh * &H100000000~&& Or finddata4.nFileSizeLow
                           Print FormatString$(File.Size#); " bytes."
                           x = FindClose(Wfile.Handle)
                        Else
                           Color White
                           Print "Error 0x" + Hex$(GetLastError) + " listing file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "L"
                     prompt$ = "Enter file spec? "
                     f$ = KeyboardLine3$(prompt$)
                     If f$ <> Nul Then
                        LineCount = 0
                        LineBreak = PageLength
                        Quit = 0
                        ' start filename search
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Do
                              Attribute = finddata4.dwFileAttributes
                              ' check for directory
                              If (Attribute And &H10) <> &H10 Then
                                 Var# = finddata4.nFileSizeHigh * &H100000000~&&
                                 Var# = Var# Or finddata4.nFileSizeLow
                                 Call Suffix(Var#, z$) ' 1,024.0 KB
                                 ' store directory name
                                 Directory$ = finddata4.cFileName
                                 Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)
                                 ' check directory name
                                 If Directory$ <> "." And Directory$ <> ".." Then
                                    ' attributes of directory/filename
                                    Attr$ = Nul
                                    Var# = finddata4.dwFileAttributes
                                    If Var# < 0 Then
                                       Var# = 0
                                    End If
                                    If (Var# And &H20) = &H20 Then
                                       Attr$ = Attr$ + "A" ' archive
                                    End If
                                    If (Var# And &H4) = &H4 Then
                                       Attr$ = Attr$ + "S" ' system
                                    End If
                                    If (Var# And &H2) = &H2 Then
                                       Attr$ = Attr$ + "H" ' hidden
                                    End If
                                    If (Var# And &H1) = &H1 Then
                                       Attr$ = Attr$ + "R" ' read-only
                                    End If
                                    If (Var# And &H800) = &H800 Then
                                       Attr$ = Attr$ + "C" ' compressed
                                    End If
                                    If (Var# And &H4000) = &H4000 Then
                                       Attr$ = Attr$ + "E" ' encrypted
                                    End If
                                    If Attr$ = Nul Then Attr$ = "<n/a>"
                                    Color Yellow
                                    Print Directory$; " ("; z$; ") ["; Attr$; "]"
                                    LineCount = LineCount + 1
                                    If LineCount >= LineBreak Then
                                       LineCount = 0
                                       Call MorePrompt(MorePrompt2, "yn " + CR, Outpt$)
                                       If Outpt$ = "n" Then
                                          Exit Do
                                       End If
                                    End If
                                 End If
                              End If
                           Loop While FindNextFileA(Wfile.Handle, _Offset(finddata4))
                           x = FindClose(Wfile.Handle)
                           If LineCount Then
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        Else
                           Color White
                           Print "Error 0x" + Hex$(GetLastError) + " listing file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        End If
                     End If
                  Case "M"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        If _FileExists(f$) Then
                           Color White, Black
                           Print "Overwrite " + Quote + f$ + Quote + "."
                           Call MorePrompt("Are you sure(y/n)?", "yn", OutputChar$)
                           Color White, Black
                           If OutputChar$ = "y" Then
                              hfind4 = CreateFileA(f$, 1)
                              Print "File created."
                           Else
                              Print "File not created."
                           End If
                        Else
                           hfind4 = CreateFileA(f$, 1)
                           Color Yellow
                           If hfind4 Then
                              Print "File created."
                           Else
                              Print "Error creating file."
                           End If
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "R"
                     f$ = _OpenFileDialog$("SICK source file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        g$ = _SaveFileDialog$("SICK destination file", _CWD$)
                        If g$ = Nul Then
                           Color White
                           Print "File not found."
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                        If g$ <> Nul Then
                           f$ = f$ + Chr$(0)
                           g$ = g$ + Chr$(0)
                           x = MoveFile(f$, g$)
                           Color Yellow
                           If x = 0 Then
                              Print "Error 0x" + Hex$(GetLastError) + " renaming filename."
                              VarQ$ = DisplayWinError$(x)
                              If Len(VarQ$) Then
                                 Print VarQ$
                              End If
                           Else
                              Print "Filename renamed."
                           End If
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                     End If
                  Case "S"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        ASCIIZ = f$ + Chr$(0)
                        Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
                        If Wfile.Handle <> INVALID_HANDLE_VALUE Then
                           Attribute = finddata4.dwFileAttributes
                           x = FindClose(Wfile.Handle)
                           ' check for directory
                           If (Attribute And &H10) <> &H10 Then
                              Do
                                 Color Yellow
                                 Print "Attributes:"
                                 Color White
                                 Print "  (1)Read-Only ";
                                 If (Attribute And &H1) = &H1 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (2)Hidden ";
                                 If (Attribute And &H2) = &H2 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (3)System ";
                                 If (Attribute And &H4) = &H4 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (4)Archive ";
                                 If (Attribute And &H20) = &H20 Then
                                    Print "<set>"
                                 Else
                                    Print "<off>"
                                 End If
                                 Print "  (Q)uit"
                                 Color Yellow
                                 Print "Enter option?";
                                 Color White
                                 Do
                                    Locate , , 1
                                    x$ = InKeyx$
                                    If Len(x$) Then
                                       Print x$
                                       Exit Do
                                    End If
                                 Loop
                                 If UCase$(x$) = "Q" Then Exit Do
                                 Select Case x$
                                    Case "1"
                                       Attribute = Attribute Xor &H1
                                    Case "2"
                                       Attribute = Attribute Xor &H2
                                    Case "3"
                                       Attribute = Attribute Xor &H4
                                    Case "4"
                                       Attribute = Attribute Xor &H20
                                 End Select
                              Loop
                              ' change filename attribute
                              x = SetFileAttributes&(ASCIIZ, Attribute)
                           Else
                              Color White
                              Print "Specified directory."
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        Else
                           Color White
                           Print "Error 0x" + Hex$(GetLastError) + " modifying file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                     End If
                  Case "T"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        f$ = f$ + Chr$(0)
                        x = FileEncryptionStatusA(f$, f&)

                        'FileEncryptionStatus return variable:

                        '0 = can be encrypted
                        '1 = file is encrypted
                        '2 = file is a system file (cannot be encrypted)
                        '3 = file is root (cannot be encryped)
                        '4 = file is system directory (cannot be encrypted)
                        '5 = encryption status unknown. file may be encrypted
                        '6 = file system does not support file encryption
                        '7 = reserved
                        '8 = file is read-only

                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " accessing file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        End If
                        If x Then
                           Select Case f&
                              Case 0
                                 Print "File can be encrypted."
                              Case 1
                                 Print "File is encrypted."
                              Case 2
                                 Print "File is system."
                              Case 3
                                 Print "File is root."
                              Case 4
                                 Print "File is system directory."
                              Case 5
                                 Print "Encryption status unknown."
                              Case 6
                                 Print "File system does not support encryption."
                              Case 7 ' reserved
                              Case 8
                                 Print "File is read-only."
                           End Select
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "U"
                     f$ = _OpenFileDialog$("SICK open file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                     End If
                     If f$ <> Nul Then
                        f$ = f$ + Chr$(0)
                        x = DecryptFile(f$, 0) ' 0=reserved
                        Color Yellow
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " decrypting file."
                           VarQ$ = DisplayWinError$(x)
                           If Len(VarQ$) Then
                              Print VarQ$
                           End If
                        Else
                           Print "File decrypted."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "V"
                     f$ = _OpenFileDialog$("SICK open first file", _CWD$)
                     If f$ = Nul Then
                        Color White
                        Print "File not found."
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                     If f$ <> Nul Then
                        g$ = _OpenFileDialog$("SICK open second file", _CWD$)
                        If g$ = Nul Then
                           Color White
                           Print "File not found."
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                        If g$ <> Nul Then
                           If _FileExists(f$) And _FileExists(g$) Then
                              Call VerifyFiles2(f$, g$, 0)
                           Else
                              Color White
                              Print "File not found."
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        End If
                     End If
                  Case "X"
                     Color White
                     prompt$ = "Enter file spec(*.*)? "
                     f$ = KeyboardLine3$(prompt$)
                     If f$ = Nul Then f$ = "*.*"
                     Call ListFilesX(f$, True)
                     Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
                  Case "Z"
                     Color White
                     prompt$ = "Enter dir spec? "
                     f$ = KeyboardLine3$(prompt$)
                     If f$ = Nul Then f$ = _CWD$
                     If Right$(f$, 1) <> "\" Then f$ = f$ + "\"

                     prompt$ = "Enter file spec? "
                     g$ = KeyboardLine3$(prompt$)
                     If g$ = Nul Then g$ = "*.*"

                     Quit.Searching = 0: Continue.Search = 0: Line.Counter = 0: Line.Counter2 = 0: Files.Counter = 0
                     Call Whereis_Directories(f$, g$)
                     If Line.Counter Then
                        Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
                     End If
               End Select
            Loop
         Case "V"
            If Left$(_CWD$, 2) = "\\" Then
               z$ = _CWD$
            Else
               c$ = UCase$(Left$(_CWD$, 1))
               z$ = _CWD$
               V = Asc(c$) - 64
               If DRIVEEXISTS(V) = False Then
                  Call Vlabel(c$)
                  If RTrim$(c$) = Nul Then
                     z$ = DriveType
                  Else
                     z$ = Left$(c$, 12)
                  End If
                  z$ = Left$(_CWD$, 2) + z$
                  x = CountDrives
                  z$ = z$ + " [" + LTrim$(Str$(x)) + " drives]"
               End If
            End If
            Do
               Color Yellow
               If ScreenWidth = 40 Then
                  Color Red
                  Print "Volume Options:"
               Else
                  Color Red
                  Print "Volume Options for: ";
                  Color Green
                  Print z$
               End If
               Color White
               Print "  (C)hange volume"
               Print "  (D)isplay serial"
               Print "  (G)et system type"
               Print "  (L)ist volume"
               Print "  (R)ead disk space"
               Print "  (S)et drive"
               Print "  (V)iew drives"
               Print "  (X)Search volume"
               Print "  (Y)Randomize volumes"
               Print "  (Z)Destroy drive"
               Print "  (Q)uit"
               Color Yellow
               PromptStore$ = "Enter option?"
               Print "Enter option?";
               Color White
               Do
                  Locate , , 1
                  x$ = InKeyx$
                  If Len(x$) Then
                     Print x$
                     Exit Do
                  End If
               Loop
               If UCase$(x$) = "Q" Then Exit Do
               Color Yellow
               Select Case UCase$(x$)
                  Case "C"
                     prompt$ = "Enter drive letter? "
                     f$ = KeyboardLine3$(prompt$)
                     If f$ <> Nul Then
                        f$ = UCase$(f$)
                        z$ = f$
                        If f$ >= "A" And f$ <= "Z" Then
                           V = GetDriveExists(f$)
                           If V Then
                              ' get drive info.
                              VarX$ = f$ + ":\" + Chr$(0)
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 OK = True
                                 prompt$ = "Enter drive volume? "
                                 g$ = KeyboardLine3$(prompt$)
                                 If g$ = Nul Then
                                    v$ = "Are you sure you want to remove the volume label(y/n)? "
                                    Call MorePrompt(v$, "yn", Outpt$)
                                    If Outpt$ = "n" Then
                                       OK = 0
                                    End If
                                 End If
                                 If OK Then
                                    ' change volume label
                                    f$ = f$ + ":\" + Chr$(0)
                                    g$ = g$ + Chr$(0)
                                    x = SetVolumeLabelA%(f$, g$)
                                    ' check volume flag
                                    If x = 0 Then
                                       Print "Error 0x" + Hex$(GetLastError) + " naming volume."
                                       VarQ$ = DisplayWinError$(x)
                                       If Len(VarQ$) Then
                                          Print VarQ$
                                       End If
                                    Else
                                       Print "Volume "; z$; ": changed."
                                    End If
                                 Else
                                    Print "Volume "; z$; ": unchanged."
                                 End If
                              Else
                                 Print "Media "; z$; ": not inserted."
                              End If
                           Else
                              Print "Drive "; z$; ": not found."
                           End If
                        Else
                           Print "Invalid "; z$; ": drive letter."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "D"
                     prompt$ = "Enter drive letters? "
                     z$ = KeyboardLine3$(prompt$)
                     If z$ <> Nul Then
                        For VX = 1 To Len(z$)
                           f$ = UCase$(Mid$(z$, VX, 1))
                           If f$ >= "A" And f$ <= "Z" Then
                              V = GetDriveExists(f$)
                              If V Then
                                 ' get drive info.
                                 Out3$ = Nul
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    ' get serial number.
                                    Out3$ = Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4)
                                    Print f$; ":"; Out3$
                                 Else
                                    Print "Media "; f$; ": not inserted."
                                 End If
                              Else
                                 Print "Drive "; f$; ": not found."
                              End If
                           Else
                              Print "Invalid "; f$; ": drive letter."
                           End If
                        Next
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "G"
                     prompt$ = "Enter drive letters? "
                     z$ = KeyboardLine3$(prompt$)
                     If z$ <> Nul Then
                        For VX = 1 To Len(z$)
                           f$ = UCase$(Mid$(z$, VX, 1))
                           If f$ >= "A" And f$ <= "Z" Then
                              V = GetDriveExists(f$)
                              If V Then
                                 ' get drive info.
                                 Out3$ = Nul
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    ' get system type.
                                    Out3$ = RTrim$(Fname$)
                                    Print f$; ":"; Out3$
                                 Else
                                    Print "Media "; f$; ": not inserted."
                                 End If
                              Else
                                 Print "Drive "; f$; ": not found."
                              End If
                           Else
                              Print "Invalid "; f$; ": drive letter."
                           End If
                        Next
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "L"
                     prompt$ = "Enter drive letters? "
                     z$ = KeyboardLine3$(prompt$)
                     If z$ <> Nul Then
                        For VX = 1 To Len(z$)
                           f$ = UCase$(Mid$(z$, VX, 1))
                           If f$ >= "A" And f$ <= "Z" Then
                              V = GetDriveExists(f$)
                              If V Then
                                 Print f$; ":";
                                 ' get drive info.                                    VarX$ = f$ + ":\" + CHR$(0)
                                 Out3$ = Nul
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    ' get volume label.
                                    Out3$ = RTrim$(Vname$)
                                    V = InStr(Out3$, Chr$(0))
                                    If V Then Out3$ = Left$(Out3$, V - 1)
                                 End If
                                 If RTrim$(Out3$) = Nul Then
                                    Print DriveType
                                 Else
                                    Print Out3$; " "; DriveType
                                 End If
                              Else
                                 Print "Drive "; f$; ": not found."
                                 Exit For
                              End If
                           Else
                              Print "Invalid "; f$; ": drive letter."
                              Exit For
                           End If
                        Next
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "R"
                     prompt$ = "Enter drive letters? "
                     z$ = KeyboardLine3$(prompt$)
                     If z$ <> Nul Then
                        VarQ = 0
                        For VX = 1 To Len(z$)
                           f$ = UCase$(Mid$(z$, VX, 1))
                           If f$ >= "A" And f$ <= "Z" Then
                              V = GetDriveExists(f$)
                              If V Then
                                 ' get drive info.
                                 Out3$ = Nul
                                 Vname$ = Space$(MAX_PATH)
                                 Fname$ = Space$(MAX_PATH)
                                 VarX$ = f$ + ":\" + Chr$(0)
                                 r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                                 If r Then
                                    ' get drive space.
                                    r = GetDiskFreeSpaceExA(VarX$, free~&&, total~&&, free2~&&)
                                    If r Then
                                       Color Yellow
                                       Print "Drive "; f$; ":"
                                       Color White
                                       Print "Total: "; FormatString$(CDbl(total~&&))
                                       Print "Free: "; FormatString$(CDbl(free~&&))
                                       Used~&& = total~&& - free~&&
                                       Print "Used: "; FormatString$(CDbl(Used~&&))
                                       VarQ = True
                                       Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                                    Else
                                       Print "Disk ;"; f$; ": space unavailable."
                                       VarQ = True
                                       Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                                    End If
                                 Else
                                    Print "Media "; f$; ": not inserted."
                                    VarQ = True
                                    Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                                 End If
                              Else
                                 Print "Drive "; f$; ": not found."
                                 VarQ = True
                                 Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                              End If
                           Else
                              Print "Invalid "; f$; ": drive letter."
                              VarQ = True
                              Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                           End If
                        Next
                        If VarQ = False Then
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                     End If
                  Case "S"
                     prompt$ = "Enter drive letter? "
                     f$ = KeyboardLine3$(prompt$)
                     If f$ <> Nul Then
                        f$ = UCase$(f$)
                        z$ = f$
                        If f$ >= "A" And f$ <= "Z" Then
                           V = GetDriveExists(f$)
                           If V Then
                              f$ = f$ + ":\" + Chr$(0)
                              x = SetCurrentDirectoryA(f$)
                              Color Yellow
                              If x = 0 Then
                                 Print "Error 0x" + Hex$(GetLastError) + " changing drive."
                                 VarQ$ = DisplayWinError$(x)
                                 If Len(VarQ$) Then
                                    Print VarQ$
                                 End If
                              Else
                                 Print "Drive "; z$; ": changed."
                              End If
                           Else
                              Print "Drive "; z$; ": not found."
                           End If
                        Else
                           Print "Drive "; z$; ": not found."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "V"
                     Q = 0
                     prompt$ = "Enter drive list(<enter>=all)? "
                     f$ = KeyboardLine3$(prompt$)
                     If f$ = Nul Then
                        prompt$ = "Enter drive array(0-26)? "
                        g$ = KeyboardLine3$(prompt$)
                        V = Int(Val(g$))
                        If V >= 0 And V <= 26 Then
                           Q = V
                        End If
                     End If
                     Call ListDrives(f$, Q) ' list all specified drives
                     Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
                  Case "X"
                     prompt$ = "Enter drive volume(? and * allowed)? "
                     g$ = KeyboardLine3$(prompt$)
                     g$ = UCase$(g$)
                     If g$ <> Nul Then
                        Found = 0
                        For f = 1 To 26
                           f$ = UCase$(Chr$(f + 64))
                           V = GetDriveExists(f$)
                           If V Then
                              ' get drive info.
                              Out3$ = Nul
                              VarX$ = f$ + ":\" + Chr$(0)
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' get volume label.
                                 Out3$ = RTrim$(Vname$)
                                 V = InStr(Out3$, Chr$(0))
                                 If V Then
                                    Out3$ = Left$(Out3$, V - 1)
                                    Call InstrSUB1(Flag, g$, Out3$, 0)
                                    If Flag Then
                                       Print f$; ":";
                                       Print Out3$
                                       Found = True
                                    End If
                                 End If
                              End If
                           End If
                        Next
                        If Found = False Then
                           Print "No drive volumes found."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "Y"
                     ' only if run as admin
                     v$ = "Are you sure you want to rename all volume labels(y/n)? "
                     Call MorePrompt(v$, "yn", Outpt$)
                     If Outpt$ = "y" Then
                        v$ = "Rename (D)os/(A)scii? "
                        Call MorePrompt(v$, "da", Outpt$)
                        d = 0
                        If Outpt$ = "a" Then d = -1
                        f = 0
                        For Z = 1 To 26
                           f$ = UCase$(Chr$(Z + 64))
                           V = GetDriveExists(f$)
                           If V Then
                              ' get drive info.
                              VarX$ = f$ + ":\" + Chr$(0)
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' change volume label
                                 f$ = f$ + ":\" + Chr$(0)
                                 If d = 0 Then
                                    g$ = GetLabel$ + Chr$(0)
                                 Else
                                    g$ = GetASCIIZLabel$ + Chr$(0)
                                 End If
                                 x = SetVolumeLabelA%(f$, g$)
                                 If x Then
                                    f = f + 1
                                 End If
                              End If
                           End If
                        Next
                        If f Then
                           Print "Volume labels renamed:"; f
                        Else
                           Print "No volume labels renamed."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
                  Case "Z"
                     prompt$ = "Enter drive letter? "
                     z$ = KeyboardLine3$(prompt$)
                     If z$ <> Nul Then
                        f$ = UCase$(z$)
                        If f$ >= "A" And f$ <= "Z" Then
                           V = GetDriveExists(f$)
                           If V Then
                              ' get drive info.
                              Out3$ = Nul
                              Vname$ = Space$(MAX_PATH)
                              Fname$ = Space$(MAX_PATH)
                              VarX$ = f$ + ":\" + Chr$(0)
                              r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
                              If r Then
                                 ' prompt to remove drive root.
                                 Print "Delete drive " + Quote + f$ + Quote + " and all subdirectories/filenames(y/n)? ";
                                 Do
                                    x$ = InKeyx$
                                    If LCase$(x$) = "n" Then Print "n": Exit Do
                                    If LCase$(x$) = "y" Then
                                       Print "y"
                                       f$ = f$ + ":\"
                                       Print "Removing drive: "; f$
                                       Call Silentdel_Directories(f$)
                                       Exit Do
                                    End If
                                 Loop
                              Else
                                 Print "Media "; f$; ": not inserted."
                              End If
                           Else
                              Print "Drive "; f$; ": not found."
                           End If
                        Else
                           Print "Invalid "; f$; ": drive letter."
                        End If
                        Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                     End If
               End Select
            Loop
      End Select
   Loop
End Sub

' routine to create directory structure
Function CreateDirectoryStructure (NewDirectory$)
   ' construct path
   NewDirectory$ = RTrim$(NewDirectory$)
   Next.Dest.Net$ = Nul
   NetPathError = False
   If Left$(NewDirectory$, 2) = "\\" Then ' \\serve\share\
      V = InStr(3, NewDirectory$, "\")
      If V Then
         V = InStr(V + 1, NewDirectory$, "\")
         If V Then
            Next.Dest.Net$ = Left$(NewDirectory$, V - 1)
            NewDirectory$ = Mid$(NewDirectory$, V + 1)
         End If
      End If
      If Next.Dest.Net$ = Nul Then
         NetPathError = True
         CreateDirectory = False
         Exit Function
         NewDirectory$ = "\"
         Drive.Create$ = Current.Drive
      End If
   Else
      If Mid$(NewDirectory$, 2, 1) = ":" Then ' c:\tempx
         Drive.Create$ = Left$(NewDirectory$, 1)
         NewDirectory$ = Mid$(NewDirectory$, 3)
      Else
         If Left$(NewDirectory$, 1) = "\" Then ' \tempx
            Drive.Create$ = Left$(_CWD$, 1)
         Else
            If Left$(_CWD$, 2) = "\\" Then ' \\tempx
               Next.Dest.Net$ = _CWD$
            Else
               Drive.Create$ = Left$(_CWD$, 1) ' c:tempx
            End If
         End If
      End If
   End If
   If Right$(NewDirectory$, 1) <> "\" Then
      NewDirectory$ = NewDirectory$ + "\"
   End If

   ' create path
   x = 0
   Next.Dir = InStr(NewDirectory$, "\")
   Do
      If Next.Dir = False Then
         Exit Do
      End If

      ' parse path left to right
      SubDir$ = Left$(NewDirectory$, Next.Dir - 1) ' \tempx\t1\t2\t3\
      Next.Dir = InStr(Next.Dir + 1, NewDirectory$, "\")

      ' make directory name
      If Len(SubDir$) Then
         ' create directory
         If Len(Next.Dest.Net$) Then
            f$ = Next.Dest.Net$ + "\" + SubDir$
         Else
            f$ = Drive.Create$ + ":" + SubDir$
         End If

         ' check directory
         If _DirExists(f$) = False Then
            f$ = f$ + Chr$(0)
            x = CreateDirectoryA(f$, 0)

            ' check error
            If x = 0 Then
               If GetLastError& = &HB7 Then ' ignore already exists
                  ' nul
               Else
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
   CreateDirectoryStructure = x
End Function

' return -1 if drive exists
Function GetDriveExists (V$)
   VarX$ = V$ + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = Nul
   ' drives A: and B: default to floppy
   If V$ = "A" Then
      DriveType = "[FLOPPY A]"
      GetDriveExists = True
      Exit Function
   End If
   If V$ = "B" Then
      DriveType = "[FLOPPY B]"
      GetDriveExists = True
      Exit Function
   End If
   Select Case VarX
      Case 0 ' invalid drive
         DriveType = "[UNKNOWN]"
      Case 1 ' invalid drive
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      GetDriveExists = True
   Else
      GetDriveExists = False
   End If
End Function

' main fullscreen editor
Sub Scrnedit (OutX$)
   Const Nul = Nul
   Dim ASCIIZ As String * 260
   Dim Byte As String * 1
   Dim FileVar As String * MaxInt
   Dim VarX As String * 1
   Dim VarY As String * MaxInt
   Dim LineX As String
   Dim Max.Row As Integer
   Dim Temp.ArrayS(1) As String
   Dim Max.Lines As Long
   Dim Max.File As Long
   Max.Row = LastWidth2

   StatusLine1 = Dfalse
   StatusLine2 = Dfalse
   StatusLineFileSize# = Dfalse
   Call Edit.Status.Line

   Filename$ = OutX$
   If Left$(Filename$, 1) = Quote Then
      Filename$ = Mid$(Filename$, 2)
      If Right$(Filename$, 1) = Quote Then
         Filename$ = Left$(Filename$, Len(Filename) - 1)
      End If
   End If
   File5 = FreeFile
   Close #File5
   ControlBreak = 0
   If _FileExists(Filename$) Then
      Max.Lines = 0
      Var& = 0&
      LineX = Nul
      VarD = False
      VarE = False
      VarF! = Timer
      LINUXLoad = False
      If AvoidLINUX = False Then
         If Compatible = False And ForceLINUX Then
            LINUXLoad = True
         Else
            Print "Edit file in Linux binary mode(y/n/q)? ";
            Do
               X$ = InKeyx$
               If LCase$(X$) = "y" Then Print: LINUXLoad = True: Exit Do
               If LCase$(X$) = "n" Then Print: LINUXLoad = False: Exit Do
               If LCase$(X$) = "q" Then Print: LINUXLoad = False: Exit Sub
            Loop
         End If
      End If
      If LINUXLoad = False Then
         Open Filename$ For Input As #File5 ' read file in text
         StatusLine1 = Dfalse
         StatusLine2 = LOF(File5)
         Do While EOF(File5) = 0
            Call Dot.Display(VarD, VarE, VarF!)
            Line Input #File5, LineX
            StatusLine1 = StatusLine1 + Len(LineX)
            If Max.Lines >= MaxLong Then
               Print "Out of memory."; MaxLong; "lines."
               Print "Edit partial file anyway(y/n)?";
               Do
                  X$ = InKeyx$
                  If LCase$(X$) = "y" Then Print "y": GoTo ContinueLoop
                  If LCase$(X$) = "n" Then Print "n": Exit Do
               Loop
               Close #File5
               Erase Temp.ArrayS
               Exit Sub
            End If
            Max.Lines = Max.Lines + 1
            ReDim _Preserve Temp.ArrayS(Max.Lines) As String
            Temp.ArrayS(Max.Lines) = LineX
         Loop
         ContinueLoop:
      Else
         Open Filename$ For Binary As #File5 Len = MaxInt ' read file in binary
         StatusLine1 = Dfalse
         StatusLine2 = LOF(File5)
         Buffer$ = Nul
         Do Until EOF(File5)
            Call Dot.Display(VarD, VarE, VarF!)
            Get #File5, , VarY
            If InKeyx$ = Chr$(27) Then
               Close #File5
               Erase Temp.ArrayS
               Exit Sub
            End If
            For VarZ = 1 To Len(VarY)
               If Mid$(VarY, VarZ, 1) = CR Then
                  ' ignore cr
               Else
                  If Mid$(VarY, VarZ, 1) = LF Then ' check lf
                     If Max.Lines >= MaxLong Then
                        Print "Out of memory."; MaxLong; "lines."
                        Print "Edit partial file anyway(y/n)?";
                        Do
                           X$ = InKeyx$
                           If LCase$(X$) = "y" Then Print "y": GoTo ContinueLoop2
                           If LCase$(X$) = "n" Then Print "n": Exit Do
                        Loop
                        Close #File5
                        Erase Temp.ArrayS
                        Exit Sub
                     End If
                     Max.Lines = Max.Lines + 1
                     ReDim _Preserve Temp.ArrayS(Max.Lines) As String
                     Temp.ArrayS(Max.Lines) = Buffer$
                     StatusLine1 = StatusLine1 + Len(Buffer$)
                     Buffer$ = Nul
                  Else
                     Buffer$ = Buffer$ + Mid$(VarY, VarZ, 1)
                  End If
               End If
            Next
         Loop
         ' avoid binary overrun at eof
         VX = InStr(Buffer$, Chr$(0))
         If VX Then
            Buffer$ = Left$(Buffer$, VX - 1)
            If Len(Buffer$) Then
               If Max.Lines >= MaxLong Then
                  Print "Out of memory."; MaxLong; "lines."
                  Print "Edit partial file anyway(y/n)?";
                  Do
                     X$ = InKeyx$
                     If LCase$(X$) = "y" Then Print "y": GoTo ContinueLoop2
                     If LCase$(X$) = "n" Then Print "n": Exit Do
                  Loop
                  Close #File5
                  Erase Temp.ArrayS
                  Exit Sub
               End If
               If Max.Lines < MaxLong Then
                  Max.Lines = Max.Lines + 1
                  ReDim _Preserve Temp.ArrayS(Max.Lines) As String
                  Temp.ArrayS(Max.Lines) = Buffer$
               End If
            End If
         End If
         ContinueLoop2:
      End If
      Max.File = Max.Lines
      Close #File5
   End If
   Print
   StatusLine1 = Dfalse
   StatusLine2 = Dfalse
   If Max.Lines = False Then
      Max.File = 1
      Max.Lines = 1
      Line.Number = 1
      ReDim Temp.ArrayS(Max.Lines) As String
   End If
   Xcoor = 1
   Ycoor = 1
   Column = 1
   Row = 1
   Line.Number = 1
   Line.Length = 78
   GoSub Display.Screen
   Do
      V = Column + Ycoor - 1
      Var# = CDbl(Line.Number)
      If Var# = Dfalse Then
         Var$ = " 0"
      Else
         Call Amount(Var#, Var$)
      End If
      If V = False Then
         Var2$ = " 0"
      Else
         Call Amount(CDbl(V), Var2$)
      End If
      Strng$ = "Row" + Var$ + " Column" + Var2$

      If V > 0 And V <= Len(Temp.ArrayS(Line.Number)) Then
         V2 = Asc(Mid$(Temp.ArrayS(Line.Number), V, 1))
         Strng$ = Strng$ + " Ascii" + Str$(V2)

         Select Case V2
            Case 0
               Strng$ = Strng$ + " (nul)"
            Case 1
               Strng$ = Strng$ + " (soh)"
            Case 2
               Strng$ = Strng$ + " (stx)"
            Case 3
               Strng$ = Strng$ + " (etx)"
            Case 4
               Strng$ = Strng$ + " (eot)"
            Case 5
               Strng$ = Strng$ + " (enq)"
            Case 6
               Strng$ = Strng$ + " (ack)"
            Case 7
               Strng$ = Strng$ + " (bel)"
            Case 8
               Strng$ = Strng$ + " (bs)"
            Case 9
               Strng$ = Strng$ + " (tab)"
            Case 10
               Strng$ = Strng$ + " (lf)"
            Case 11
               Strng$ = Strng$ + " (vt)"
            Case 12
               Strng$ = Strng$ + " (np)"
            Case 13
               Strng$ = Strng$ + " (cr)"
            Case 14
               Strng$ = Strng$ + " (so)"
            Case 15
               Strng$ = Strng$ + " (si)"
            Case 16
               Strng$ = Strng$ + " (dle)"
            Case 17
               Strng$ = Strng$ + " (dc1)"
            Case 18
               Strng$ = Strng$ + " (dc2)"
            Case 19
               Strng$ = Strng$ + " (dc3)"
            Case 20
               Strng$ = Strng$ + " (dc4)"
            Case 21
               Strng$ = Strng$ + " (nak)"
            Case 22
               Strng$ = Strng$ + " (syn)"
            Case 23
               Strng$ = Strng$ + " (etb)"
            Case 24
               Strng$ = Strng$ + " (can)"
            Case 25
               Strng$ = Strng$ + " (em)"
            Case 26
               Strng$ = Strng$ + " (eof)"
            Case 27
               Strng$ = Strng$ + " (esc)"
            Case 28
               Strng$ = Strng$ + " (fs)"
            Case 29
               Strng$ = Strng$ + " (gs)"
            Case 30
               Strng$ = Strng$ + " (rs)"
            Case 31
               Strng$ = Strng$ + " (us)"
            Case 32
               Strng$ = Strng$ + " (spc)"
            Case 255
               Strng$ = Strng$ + " (?)"
            Case Else
               Strng$ = Strng$ + " (" + Chr$(V2) + ")"
         End Select
      End If
      Strng$ = Left$(Strng, ScreenWidth)
      Strng$ = Strng$ + Space$(ScreenWidth - Len(Strng$))
      Color Yellow, BBlue
      Locate Max.Row - 1, 1
      Print Left$(Strng$, ScreenWidth - 1);
      Locate Xcoor, Ycoor
      Color White, Black
      TempX$ = Nul
      Do While TempX$ = Nul
         TempX$ = InKeyx$
      Loop
      Select Case Len(TempX$)
         Case 1
            Select Case TempX$
               Case Chr$(18) ' ctrl-r = searchreplace
                  GoSub Replace.String
               Case Chr$(6) ' search string (ctrl-f)
                  If Max.Lines > 0 Then
                     GoSub Search.String
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color White, Black
                  GoSub Display.Screen
               Case Chr$(10) ' jump to byte (ctrl-j)
                  If Max.Lines > 0 Then
                     GoSub Jump.Byte
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color White, Black
                  GoSub Display.Screen
               Case Chr$(7) ' goto to line (ctrl-g)
                  If Max.Lines > 0 Then
                     GoSub Jump.Line
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color White, Black
                  GoSub Display.Screen
               Case Chr$(12) ' ctrl-l insert file
                  Store.Line.Number = Line.Number
                  Color White, BBlue
                  Locate Max.Row - 1, 1
                  Strng$ = Space$(ScreenWidth)
                  Print Strng$;
                  Color Yellow, BBlue
                  Locate Max.Row - 1, 1
                  prompt$ = "Enter filename? "
                  VarA$ = KeyboardLine4$(prompt$)
                  If Len(VarA$) Then
                     If _FileExists(VarA$) Then
                        Xcount1! = SFalse
                        Zcount1# = Dfalse
                        f = FreeFile
                        Open VarA$ For Input As #f
                        Do Until EOF(f)
                           Line Input #f, VarB$
                           ' insert always extends array
                           If Max.Lines + 1 > Max.File Then
                              Max.File = Max.File + 1
                              ReDim _Preserve Temp.ArrayS(Max.File) As String
                           End If
                           ' insert line to file array
                           Max.Lines = Max.Lines + 1
                           For Temp1 = Max.Lines - 1 To Line.Number Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           Temp.ArrayS(Line.Number) = VarB$
                           Line.Number = Line.Number + 1
                           Xcount1! = Xcount1! + 1!
                           Zcount1# = Zcount1# + CDbl(Len(VarB$))
                        Loop
                        Close #f

                        ' display lines/bytes inserted.
                        Xcount1$ = Str$(Xcount1!)
                        Zcount1$ = Str$(Zcount1#)
                        VarX$ = "Lines inserted:" + Xcount1$ + " Bytes inserted:" + Zcount1$ + " Press <esc>"

                        ' restore screen
                        Line.Number = Store.Line.Number
                        Ycoor = 1
                        Column = 1
                        GoSub Display.Screen
                     End If
                  End If
               Case Chr$(11) ' ctrl-k append file
                  Color White, BBlue
                  Locate Max.Row - 1, 1
                  Strng$ = Space$(ScreenWidth)
                  Print Strng$;
                  Color Yellow, BBlue
                  Locate Max.Row - 1, 1
                  prompt$ = "Enter filename? "
                  VarA$ = KeyboardLine4$(prompt$)
                  If Len(LTrim$(RTrim$(VarA$))) Then
                     If _FileExists(VarA$) Then
                        Xcount1! = SFalse
                        Zcount1# = Dfalse
                        f = FreeFile
                        Open VarA$ For Input As #f
                        Do Until EOF(f)
                           Line Input #f, VarB$
                           ' append always extends array
                           If Max.Lines + 1 > Max.File Then
                              Max.File = Max.File + 1
                              ReDim _Preserve Temp.ArrayS(Max.File) As String
                           End If
                           ' append line to eof
                           Max.Lines = Max.Lines + 1
                           Temp.ArrayS(Max.Lines) = VarB$
                           Xcount1! = Xcount1! + 1!
                           Zcount1# = Zcount1# + CDbl(Len(VarB$))
                        Loop
                        Close #f

                        ' display lines/bytes appended.
                        Xcount1$ = Str$(Xcount1!)
                        Zcount1$ = Str$(Zcount1#)
                        VarX$ = "Lines appended:" + Xcount1$ + " Bytes appended:" + Zcount1$ + " Press <esc>"

                        ' control-end
                        Line.Number = Max.Lines
                        If Max.Lines < 22 Then
                           Xcoor = Max.Lines
                        Else
                           Xcoor = 22
                        End If
                        Ycoor = 1
                        Column = 1
                        GoSub Display.Screen
                     End If
                  End If
               Case Chr$(13) ' insert line
                  ' always increases array
                  If Max.File < MaxLong Then
                     Max.File = Max.File + 1
                     ReDim _Preserve Temp.ArrayS(Max.File) As String
                     ' above
                     If Column + Ycoor - 1 = 1 Then
                        For Temp1 = Max.Lines To Line.Number Step -1
                           Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                        Next
                        Temp.ArrayS(Line.Number) = Nul
                        Line.Number = Line.Number + 1
                        Max.Lines = Max.Lines + 1
                        If Xcoor < Max.Row - 2 Then
                           Xcoor = Xcoor + 1
                        End If
                     Else
                        ' below
                        If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                           Line.Number = Line.Number + 1 ' below
                           For Temp1 = Max.Lines To Line.Number Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           Temp.ArrayS(Line.Number) = Nul
                           If Xcoor < Max.Row - 2 Then
                              Xcoor = Xcoor + 1
                           End If
                           Max.Lines = Max.Lines + 1
                        Else
                           ' split line
                           For Temp1 = Max.Lines To Line.Number + 1 Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           T$ = Temp.ArrayS(Line.Number)
                           U$ = Mid$(T$, Column + Ycoor - 1)
                           T$ = Left$(T$, Column + Ycoor - 2)
                           Temp.ArrayS(Line.Number) = T$
                           Line.Number = Line.Number + 1 ' below
                           Temp.ArrayS(Line.Number) = U$
                           If Xcoor < Max.Row - 2 Then
                              Xcoor = Xcoor + 1
                           End If
                           Max.Lines = Max.Lines + 1
                        End If
                     End If
                  End If
                  Column = 1
                  Ycoor = 1
                  GoSub Display.Screen
               Case Chr$(8) ' backspace
                  Q = Column + Ycoor - 1
                  If Line.Number <= 1 And Q <= 1 Then ' no backspace at 1,1
                     Eat$ = Nul
                  Else
                     ' remove current line
                     If Temp.ArrayS(Line.Number) = Nul Then
                        ' pack array
                        For Temp1 = Line.Number To Max.Lines - 1
                           Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                        Next
                        If Xcoor > 1 Then
                           Xcoor = Xcoor - 1
                        End If
                        Line.Number = Line.Number - 1
                        Max.Lines = Max.Lines - 1
                        ' position at eol
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= ScreenWidth Then
                           Column = End.Line - ScreenWidth - 2
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     Else
                        ' concatenate previous line
                        If Column + Ycoor - 1 <= 1 Then
                           If Line.Number > 1 Then
                              If Line.Number <= Max.Lines Then
                                 Var = 0
                                 If Temp.ArrayS(Line.Number - 1) = Nul Then
                                    If Ycoor = 1 Then
                                       Var = True
                                    End If
                                 End If

                                 ' position at eol
                                 If Var = False Then
                                    End.Line = Len(Temp.ArrayS(Line.Number - 1))
                                 End If

                                 Temp.ArrayS(Line.Number - 1) = Temp.ArrayS(Line.Number - 1) + Temp.ArrayS(Line.Number)
                                 For Temp1 = Line.Number To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 If Xcoor > 1 Then
                                    Xcoor = Xcoor - 1
                                 End If
                                 Line.Number = Line.Number - 1
                                 Max.Lines = Max.Lines - 1
                                 Column = 1
                                 Ycoor = 1

                                 ' position at eol
                                 If Var = False Then
                                    If End.Line >= ScreenWidth Then
                                       Column = End.Line - ScreenWidth - 2
                                       Ycoor = End.Line - Column + 2
                                    Else
                                       Ycoor = End.Line - Column + 2
                                    End If
                                 End If

                                 GoSub Display.Screen
                              End If
                           End If
                        Else
                           ' backspace 1 character
                           If Column + Ycoor - 2 > False Then
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = Left$(T$, Column + Ycoor - 3) + Mid$(T$, Column + Ycoor - 1)
                              Temp.ArrayS(Line.Number) = T$
                              StatusLineFileSize = StatusLineFileSize - 1
                              ' move cursor 1 left
                              If Ycoor > 1 Then
                                 Ycoor = Ycoor - 1
                                 GoSub Display.Screen
                              Else
                                 If Column > 1 Then
                                    Column = Column - 1
                                    GoSub Display.Screen
                                 End If
                              End If
                           End If
                        End If
                     End If
                  End If
               Case TabS ' tab
                  If Column + Ycoor + (TabStop - 1) <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor + TabStop < ScreenWidth Then
                        Ycoor = Ycoor + TabStop
                     Else
                        Column = Column + TabStop
                        GoSub Display.Screen
                     End If
                  Else ' end
                     End.Line = Len(Temp.ArrayS(Line.Number))
                     If End.Line >= ScreenWidth Then
                        Column = End.Line - ScreenWidth - 2
                        Ycoor = End.Line - Column + 2
                        GoSub Display.Screen
                     Else
                        Ycoor = End.Line - Column + 2
                     End If
                  End If
               Case Chr$(27) ' escape, exit editor
                  Exit Do
               Case Else ' insert character
                  If Line.Number > 0 Then
                     T$ = Temp.ArrayS(Line.Number)
                     T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                     Temp.ArrayS(Line.Number) = T$
                     StatusLineFileSize = StatusLineFileSize + 1
                     If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                        If Ycoor < ScreenWidth Then
                           Ycoor = Ycoor + 1
                           GoSub Display.Screen
                        Else
                           Column = Column + 1
                           GoSub Display.Screen
                        End If
                     End If
                  End If
            End Select
         Case 2
            Temp = Asc(Mid$(TempX$, 2, 1))
            Select Case Temp
               Case 96 ' Ctrl-F3 - repeat replace
                  If Search$ = Nul Then
                     GoSub Replace.String
                  Else
                     GoSub Replace.String2
                  End If
               Case 61 ' F3 - continue search
                  If Max.Lines > 0 Then
                     If LastSearchLine& = 0& Then ' init search
                        GoSub Search.String
                     Else
                        GoSub Search.String2
                     End If
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color White, Black
                  GoSub Display.Screen
               Case 15 ' shift-tab
                  If Column + Ycoor - TabStop > 0 Then
                     If Column + Ycoor - TabStop - 1 > 1 Then
                        Ycoor = Ycoor - TabStop - 1
                     Else
                        If Column > TabStop Then
                           Column = Column - TabStop - 1
                           GoSub Display.Screen
                        End If
                     End If
                  Else ' home
                     If Column > 1 Then
                        Column = 1
                        Ycoor = 1
                        GoSub Display.Screen
                     Else
                        Column = 1
                        Ycoor = 1
                     End If
                  End If
               Case 83, 147 ' delete/control-delete
                  Q = Column + Ycoor - 1
                  ' no delete at 1,1
                  If (Line.Number <= 1 And Q < 1) Or Max.Lines < 1 Then
                     Eat$ = Nul
                  Else
                     ' remove line
                     If Temp.ArrayS(Line.Number) = Nul Then
                        If Line.Number = 1 And Max.Lines = 1 Then ' 1,1
                           Eat$ = Nul
                        Else
                           ' pack array
                           For Temp1 = Line.Number To Max.Lines - 1
                              Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                           Next
                           If Line.Number = Max.Lines Then
                              Line.Number = Line.Number - 1
                              If Xcoor > 1 Then
                                 Xcoor = Xcoor - 1
                              End If
                           End If
                           Max.Lines = Max.Lines - 1
                           Column = 1
                           Ycoor = 1
                           GoSub Display.Screen
                        End If
                     Else
                        ' delete line
                        If Len(Temp.ArrayS(Line.Number)) < 1 Then
                           Temp.ArrayS(Line.Number) = Nul
                           GoSub Display.Screen
                        Else
                           ' concatenate line
                           If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                              If Line.Number + 1 <= Max.Lines Then
                                 T$ = Temp.ArrayS(Line.Number)
                                 T$ = T$ + Temp.ArrayS(Line.Number + 1)
                                 Temp.ArrayS(Line.Number) = T$

                                 ' pack array
                                 For Temp1 = Line.Number + 1 To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 Max.Lines = Max.Lines - 1
                                 GoSub Display.Screen
                              End If
                           Else
                              ' delete character
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = Left$(T$, Column + Ycoor - 2) + Mid$(T$, Column + Ycoor)
                              Temp.ArrayS(Line.Number) = T$
                              StatusLineFileSize = StatusLineFileSize - 1
                              GoSub Display.Screen
                           End If
                        End If
                     End If
                  End If
               Case 71 ' home
                  If Column > 1 Then
                     Column = 1
                     Ycoor = 1
                     GoSub Display.Screen
                  Else
                     Column = 1
                     Ycoor = 1
                  End If
               Case 79 ' end
                  End.Line = Len(Temp.ArrayS(Line.Number))
                  If End.Line >= ScreenWidth Then
                     Column = End.Line - ScreenWidth - 2
                     Ycoor = End.Line - Column + 2
                     GoSub Display.Screen
                  Else
                     Ycoor = End.Line - Column + 2
                  End If
               Case 75, 155 ' left/alt-left
                  If Ycoor > 1 Then
                     Ycoor = Ycoor - 1
                  Else
                     If Column > 1 Then
                        Column = Column - 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 77, 157 ' right/alt-right
                  If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor < ScreenWidth Then
                        Ycoor = Ycoor + 1
                     Else
                        Column = Column + 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 72, 141, 152 ' up/ctrl-up/alt-up
                  Var = 0
                  If Line.Number > 1 Then
                     Line.Number = Line.Number - 1
                     If Xcoor = 1 Then
                        Var = True
                     Else
                        Xcoor = Xcoor - 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = True
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 80, 145, 160 ' down/ctrl-dn/alt-dn
                  Var = 0
                  If Line.Number < Max.Lines Then
                     Line.Number = Line.Number + 1
                     If Xcoor >= Max.Row - 2 Then
                        Var = True
                     Else
                        Xcoor = Xcoor + 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = True
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 73, 132 ' pageup/ctrl-pageup
                  If Line.Number > 1 Then
                     If Line.Number - 22 > 1 Then
                        Line.Number = Line.Number - 22
                     Else
                        Line.Number = 1
                     End If
                     Xcoor = 1
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = True
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 81, 118 ' pagedown/ctrl-pagedn
                  If Line.Number < Max.Lines Then
                     If Line.Number + 22 < Max.Lines Then
                        Line.Number = Line.Number + 22
                        Xcoor = 1
                     Else
                        Line.Number = Max.Lines
                        If Max.Lines < Max.Row - 3 Then
                           Xcoor = Max.Lines
                        Else
                           Xcoor = Max.Row - 3
                        End If
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = True
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 116 ' control-right
                  If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then ' eol
                     If Line.Number + 1 <= Max.Lines Then
                        Line.Number = Line.Number + 1
                        If Xcoor = Max.Row - 3 Then
                           Var = True
                        Else
                           Xcoor = Xcoor + 1
                        End If
                        Ycoor = 1
                        Column = 1
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     For Temp2 = Column + Ycoor - 1 To Len(Temp.ArrayS(Line.Number))
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              Exit For
                           End If
                        End If
                     Next
                     'shift right
                     For Var3 = 1 To P
                        If Ycoor < ScreenWidth Then
                           Ycoor = Ycoor + 1
                        Else
                           Column = Column + 1
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 115 ' control-left
                  If Column + Ycoor - 1 <= 1 Then
                     If Line.Number > 1 Then
                        Line.Number = Line.Number - 1
                        If Xcoor = 1 Then
                           Var = True
                        Else
                           Xcoor = Xcoor - 1
                        End If
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= ScreenWidth Then
                           Column = End.Line - ScreenWidth - 2
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     V = 0
                     For Temp2 = Column + Ycoor - 3 To 1 Step -1
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              V = True
                              Exit For
                           End If
                        End If
                     Next
                     If V = 0 Then
                        P = P + 1
                     End If
                     ' shift left
                     For Var3 = 1 To P
                        If Ycoor > 1 Then
                           Ycoor = Ycoor - 1
                        Else
                           If Column > 1 Then
                              Column = Column - 1
                           End If
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 119 ' control-home
                  If Max.Lines > 0 Then
                     Line.Number = 1
                     Xcoor = 1
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 117 ' control-end
                  If Max.Lines > 0 Then
                     Line.Number = Max.Lines
                     If Max.Lines < Max.Row - 3 Then
                        Xcoor = Max.Lines
                     Else
                        Xcoor = Max.Row - 3
                     End If
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 82 ' insert
                  If Line.Number > 0 Then
                     Var = False
                     Ascii$ = Nul
                     GoSub Display.Ascii.Line
                     Do
                        Var$ = Nul
                        Do
                           Var$ = InKeyx$
                           If Len(Var$) Then
                              Exit Do
                           End If
                        Loop
                        If Len(Var$) = 1 Then
                           If Var$ = Chr$(8) Then
                              If Len(Ascii$) > 0 Then
                                 Ascii$ = Left$(Ascii$, Len(Ascii$) - 1)
                                 GoSub Display.Ascii.Line
                                 Var = Var - 1
                                 Locate Max.Row - 1, 27
                                 Print Ascii$ + " ";
                                 Locate Max.Row - 1, 27
                                 Print Ascii$;
                              End If
                           End If
                           If Var$ = Chr$(13) Then
                              Exit Do
                           End If
                           If LCase$(Var$) = "x" Or LCase$(Var$) = "o" Or LCase$(Var$) = "b" Then
                              If Var = False Then
                                 Ascii$ = Ascii$ + LCase$(Var$)
                                 GoSub Display.Ascii.Line
                                 Var = Var + 1
                                 Locate Max.Row - 1, 26 + Var
                                 Strng$ = LCase$(Var$)
                                 Print Strng$;
                              End If
                           End If
                           If LCase$(Var$) >= "a" And LCase$(Var$) <= "f" Then
                              If Var >= 1 And Var < 3 Then
                                 If Left$(Ascii$, 1) = "x" Then
                                    Var = Var + 1
                                    Locate Max.Row - 1, 26 + Var
                                    Strng$ = Var$
                                    Print Strng$;
                                    Ascii$ = Ascii$ + Var$
                                 End If
                              End If
                           End If
                           If Left$(Ascii$, 1) = "o" Then
                              If Var$ >= "0" And Var$ <= "7" Then
                                 If Var < 4 Then
                                    Var = Var + 1
                                    Locate Max.Row - 1, 26 + Var
                                    Strng$ = Var$
                                    Print Strng$;
                                    Ascii$ = Ascii$ + Var$
                                 End If
                              End If
                           Else
                              If Left$(Ascii$, 1) = "b" Then
                                 If Var$ = "0" Or Var$ = "1" Then
                                    If Var < 9 Then
                                       Var = Var + 1
                                       Locate Max.Row - 1, 26 + Var
                                       Strng$ = Var$
                                       Print Strng$;
                                       Ascii$ = Ascii$ + Var$
                                    End If
                                 End If
                              Else
                                 If Var$ >= "0" And Var$ <= "9" Then
                                    If Var < 3 Then
                                       Var = Var + 1
                                       Locate Max.Row - 1, 26 + Var
                                       Print Var$;
                                       Ascii$ = Ascii$ + Var$
                                    End If
                                 End If
                              End If
                           End If
                        End If
                     Loop
                     Color White, Black

                     ' insert ascii character
                     If Left$(Ascii$, 1) = "x" Then
                        Ascii.Value = Int(Val("&H" + Mid$(Ascii$, 2)))
                     Else
                        If Left$(Ascii$, 1) = "o" Then
                           Ascii.Value = Int(Val("&O" + Mid$(Ascii$, 2)))
                        Else
                           If Left$(Ascii$, 1) = "b" Then ' binary
                              Ascii.Value = Int(Val("&B" + Mid$(Ascii$, 2)))
                           Else
                              Ascii.Value = Int(Val(Ascii$))
                           End If
                        End If
                     End If
                     If Ascii.Value >= 0 And Ascii.Value <= 255 Then
                        TempX$ = Chr$(Ascii.Value)
                        T$ = Temp.ArrayS(Line.Number)
                        T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                        Temp.ArrayS(Line.Number) = T$
                        StatusLineFileSize = StatusLineFileSize + 1
                        If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                           If Ycoor < ScreenWidth Then
                              Ycoor = Ycoor + 1
                              GoSub Display.Screen
                           Else
                              Column = Column + 1
                              GoSub Display.Screen
                           End If
                        End If
                     End If
                  End If
            End Select
      End Select
   Loop
   Color White, Black
   Cls
   Call Edit.Status.Line
   Locate Max.Row - 1, 1
   Q = 0
   Print "Write "; Filename$; " to disk(y/n)? ";
   Do
      Char$ = InKeyx$
      Char$ = UCase$(Char$)
      If Char$ = "Y" Then
         Q = True
         Print "y"
         Exit Do
      End If
      If Char$ = "N" Then
         Print "n"
         Exit Do
      End If
   Loop
   If Q Then
      Close #File5
      ' change filename attribute
      ASCIIZ = Filename$ + Chr$(0)
      AttrX& = GetFileAttributes(ASCIIZ)
      StoreAttr& = AttrX&
      AttrX& = AttrX& And Not &H1 ' remove read-only bit
      x = SetFileAttributes&(ASCIIZ, AttrX&)
      ' delete output file
      If _FileExists(Filename$) Then
         f$ = Filename$ + Chr$(0)
         x = DeleteFileA%(f$)
      End If
      LinuxSave = False
      If AvoidLINUX = False Then
         If Compatible = False And ForceLINUX Then
            LinuxSave = True
         Else
            Print "Save file in Linux binary mode(y/n)? ";
            Do
               X$ = InKeyx$
               If LCase$(X$) = "y" Then Print: LinuxSave = True: Exit Do
               If LCase$(X$) = "n" Then Print: LinuxSave = False: Exit Do
            Loop
         End If
      End If
      TotalBytes2# = Dfalse
      For Count& = 1& To Max.Lines
         TotalBytes2# = TotalBytes2# + Len(RTrim$(Temp.ArrayS(Count&)))
      Next
      VarD = False
      VarE = False
      VarF! = Timer
      StatusLine1 = Dfalse
      StatusLine2 = TotalBytes2#
      If LinuxSave Then
         Open Filename$ For Binary As #File5 Len = MaxInt
         Var& = 0&
         Buffer$ = Nul
         Position = False
         For Var2 = 1 To Max.Lines
            Call Dot.Display(VarD, VarE, VarF!)
            For Var3 = 1 To Len(Temp.ArrayS(Var2))
               If Position >= MaxInt Then
                  FileVar = Buffer$
                  Var& = Var& + MaxInt
                  Put #File5, , FileVar
                  Buffer$ = Nul
                  Position = False
               End If
               Position = Position + 1
               Buffer$ = Buffer$ + Mid$(Temp.ArrayS(Var2), Var3, 1)
            Next
            Buffer$ = Buffer$ + LF
            Position = Position + 1
            Var& = Var& + 1&
            StatusLine1 = CDbl(Var&)
         Next
         If Len(Buffer$) Then
            Close File5
            Open Filename$ For Binary As #File5 Len = 1
            For Var2 = 1 To Len(Buffer$)
               Byte = Mid$(Buffer$, Var2, 1)
               Var& = Var& + 1&
               VarZ& = LOF(File5) + 1
               Put #File5, VarZ&, Byte
            Next
         End If
      Else
         Var& = 0&
         Open Filename$ For Output As #File5
         For Count& = 1& To Max.Lines
            Call Dot.Display(VarD, VarE, VarF!)
            Var& = Var& + Len(RTrim$(Temp.ArrayS(Count&)))
            StatusLine1 = CDbl(Var&)
            Print #File5, Temp.ArrayS(Count&)
         Next
      End If
      Close #File5
      If Pos(0) > 1 Then
         Print
      End If
      If LinuxSave Then
         Print " "; FormatString$(CDbl(Var&)) + " binary bytes stored to disk."
      Else
         Print " "; FormatString$(CDbl(Var&)) + " bytes stored to disk."
      End If
      ' restore filename attribute
      x = SetFileAttributes&(ASCIIZ, StoreAttr&)
      Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
   End If
   ' prompt to load into array
   Erase Temp.ArrayS
   If LCase$(Right$(Filename$, 4)) = ".sic" Then
      Print "Load file into program array(y/n)? ";
      Do
         X$ = InKeyx$
         If LCase$(X$) = "y" Then
            Print "y"
            Call LoadProgram(Filename$)
            Exit Do
         End If
         If LCase$(X$) = "n" Then
            Print "n"
            Exit Do
         End If
      Loop
   End If
   Exit Sub

   Display.Ascii.Line:
   Color White, BBlue
   Locate Max.Row - 1, 1, 1
   Color White, BBlue
   Strng$ = Space$(41)
   Print Strng$;
   Locate Max.Row - 1, 1, 1
   If Left$(Ascii$, 1) = "x" Then
      Var2$ = "Enter 2-digit ascii code: "
   Else
      If Left$(Ascii$, 1) = "o" Then
         Var2$ = "Enter 3-digit ascii code: "
      Else
         If Left$(Ascii$, 1) = "b" Then
            Var2$ = "Enter 8-digit ascii code: "
         Else
            Var2$ = "Enter 3-digit ascii code: "
         End If
      End If
   End If
   VarC = Len(Var2$) + Len(Ascii$)
   Var2$ = Var2$ + Space$(41 - Len(Var2$))
   Print Var2$;
   Locate Max.Row - 1, VarC, 1
   Return

   Display.Line:
   Color White, BBlue
   Locate Max.Row - 1, 1
   Strng$ = Space$(ScreenWidth)
   Print Strng$;
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   Print VarX$;
   Do
      X$ = InKeyx$
      If X$ = Chr$(27) Then Exit Do
   Loop
   Return

   Jump.Line:
   Color White, BBlue
   Locate Max.Row - 1, 1
   Strng$ = Space$(ScreenWidth)
   Print Strng$;
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   prompt$ = "Enter line number(1-" + LTrim$(Str$(Max.Lines)) + ")? "
   X$ = KeyboardLine4$(prompt$)

   VarX2 = True
   If Len(X$) = False Then
      VarX2 = False
   Else
      If Len(X$) > 7 Then
         VarX2 = False
      Else
         VarX2 = IsNumeric(X$)
      End If
   End If
   Count& = 0&
   If VarX2 Then
      If Val(X$) > 0 And Val(X$) <= Max.Lines Then
         Count& = Val(X$)
      Else
         VarX2 = False
      End If
   End If
   Return

   Jump.Byte:
   ' count bytes in edit array
   x# = Dfalse
   For X& = 1 To Max.Lines
      x# = x# + Len(Temp.ArrayS(X&))
   Next

   Color White, BBlue
   Locate Max.Row - 1, 1
   Strng$ = Space$(ScreenWidth)
   Print Strng$;
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   prompt$ = "Enter byte number(1-" + LTrim$(Str$(x#)) + ")? "
   X$ = KeyboardLine4$(prompt$)

   VarX2 = True
   If Len(X$) = False Then
      VarX2 = False
   Else
      If Len(X$) > 15 Then
         VarX2 = False
      Else
         VarX2 = IsNumeric(X$)
      End If
   End If
   T# = Dfalse
   If VarX2 Then
      Count# = Val(X$)
      If Count# > 0 And Count# <= x# Then
         For Count& = 1 To Max.Lines
            If T# + Len(Temp.ArrayS(Count&)) >= Count# Then
               Exit For
            End If
            T# = T# + Len(Temp.ArrayS(Count&))
         Next
      Else
         VarX2 = 0
      End If
   End If
   Return

   Replace.String:
   If Max.Lines > 0 Then
      Color White, BBlue
      Locate Max.Row - 1, 1
      Strng$ = Space$(ScreenWidth)
      Print Strng$;
      Color Yellow, BBlue
      Locate Max.Row - 1, 1
      Line Input ; "Enter search string? "; Search$

      Color White, BBlue
      Locate Max.Row - 1, 1
      Strng$ = Space$(ScreenWidth)
      Print Strng$;
      Color Yellow, BBlue
      Locate Max.Row - 1, 1
      Line Input ; "Enter replace string? "; Replace$

      Replace.String2:

      Color White, BBlue
      Locate Max.Row - 1, 1
      Strng$ = Space$(ScreenWidth)
      Print Strng$;
      Color Yellow, BBlue
      Locate Max.Row - 1, 1
      Print "Enter (R)eplace, Replace(A)ll, (C)ancel? ";
      Do
         X$ = InKeyx$
         x = 0
         If UCase$(X$) = "R" Then x = 1: Exit Do
         If UCase$(X$) = "A" Then x = 2: Exit Do
         If UCase$(X$) = "C" Then x = 0: Exit Do
      Loop
      If x Then
         Color White, BBlue
         Locate Max.Row - 1, 1
         Strng$ = Space$(ScreenWidth)
         Print Strng$;
         Color Yellow, BBlue
         Locate Max.Row - 1, 1
         Print "Case-sensitive(y/n)? ";
         Do
            Y$ = InKeyx$
            If UCase$(Y$) = "Y" Then SensitiveSelect = True: Exit Do
            If UCase$(Y$) = "N" Then SensitiveSelect = False: Exit Do
         Loop
      End If

      If x = 1 Then ' replace
         ' store current screen
         Store1 = Xcoor
         Store2 = Ycoor
         Store3 = Column
         Store& = Line.Number
         ' start replace
         Count& = 0&
         If Len(Search$) Then
            For X& = Store& To Max.Lines
               S1 = 1
               Text$ = Temp.ArrayS(X&)
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     ' jump to line
                     Ycoor = 1
                     Column = 1
                     Line.Number = X&
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     ' display screen
                     Color White, Black
                     GoSub Display.Screen

                     ' display text to replace fixed 09/08/2022
                     If P1 + Len(Search$) < ScreenWidth Then
                        If Len(Search$) < ScreenWidth Then
                           Locate Xcoor, P1
                           Color Scolor, Scolor2
                           Var1$ = Mid$(Text$, P1, Len(Search$))
                           Print Var1$;
                           Color White, Black
                        End If
                     Else
                        If Len(Search$) < ScreenWidth Then
                           ' move right until search fits
                           Do
                              If Column + Ycoor + 1 < P1 + Len(Search$) Then
                                 If Ycoor < ScreenWidth Then
                                    Ycoor = Ycoor + 1
                                 Else
                                    Column = Column + 1
                                 End If
                              Else
                                 Exit Do
                              End If
                           Loop
                           ' decrease until display search fits in line
                           Do Until Ycoor + Len(Search$) < ScreenWidth
                              Ycoor = Ycoor - 1
                           Loop
                           ' check display search at end of line
                           If Ycoor + Len(Search$) <= ScreenWidth Then
                              GoSub Display.Screen
                              Locate Xcoor, Ycoor, 1
                              Color Scolor, Scolor2
                              Var1$ = Mid$(Text$, P1, Len(Search$))
                              Print Var1$;
                              Color White, Black
                           End If
                        End If
                     End If

                     ' z=-1 replace, z=1 skip, z=0 cancel
                     Color White, BBlue
                     Locate Max.Row - 1, 1
                     Strng$ = Space$(ScreenWidth)
                     Print Strng$;
                     Color Yellow, BBlue
                     Locate Max.Row - 1, 1
                     Print "Enter (R)eplace, (S)kip, (C)ancel? ";
                     Do
                        X$ = InKeyx$
                        z = 0
                        If UCase$(X$) = "R" Then z = -1: Exit Do
                        If UCase$(X$) = "S" Then z = 1: Exit Do
                        If UCase$(X$) = "C" Then z = 0: Exit Do
                     Loop
                     If z = 0 Then ' cancel
                        Exit For
                     End If
                     If z = -1 Then ' replace
                        Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                        Temp.ArrayS(X&) = Text$
                        Count& = Count& + 1&
                        StatusLineFileSize = StatusLineFileSize - Len(Search$) + Len(Replace$)
                     End If
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
            Next
         End If
         ' restore current screen
         Color White, Black
         GoSub Display.Screen

         Xcoor = Store1
         Ycoor = Store2
         Column = Store3
         Line.Number = Store&

         Color White, BBlue
         Locate Max.Row - 1, 1
         Strng$ = Space$(ScreenWidth)
         Print Strng$;
         Color Yellow, BBlue
         Locate Max.Row - 1, 1
         ' display replacements
         If Count& = 0& Then
            Print "Text not found. Press any key.";
         Else
            Print "Replaced" + Str$(Count&) + " strings. Press any key.";
         End If
         X$ = Inkey2$
         Color White, Black
         GoSub Display.Screen
      End If
      If x = 2 Then ' replaceall
         Count& = 0&
         If Len(Search$) Then
            For X& = 1& To Max.Lines
               Text$ = Temp.ArrayS(X&)
               Flag = 0
               S1 = 1
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     Flag = True
                     Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                     Count& = Count& + 1&
                     StatusLineFileSize = StatusLineFileSize - Len(Search$) + Len(Replace$)
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
               If Flag Then
                  Temp.ArrayS(X&) = Text$
               End If
            Next
         End If
         Color White, Black
         GoSub Display.Screen
         Color White, BBlue
         Locate Max.Row - 1, 1
         Strng$ = Space$(ScreenWidth)
         Print Strng$;
         Color Yellow, BBlue
         Locate Max.Row - 1, 1
         ' display replacements
         If Count& = 0& Then
            Print "Text not found. Press any key.";
         Else
            Print "Replaced" + Str$(Count&) + " strings. Press any key.";
         End If
         X$ = Inkey2$
         Color White, Black
         GoSub Display.Screen
      End If
   End If
   Return

   ' init search
   Search.String:

   Color White, BBlue
   Locate Max.Row - 1, 1
   Strng$ = Space$(ScreenWidth)
   Print Strng$;
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   Line Input ; "Enter search string? "; X$

   Color White, BBlue
   Locate Max.Row - 1, 1
   Strng$ = Space$(ScreenWidth)
   Print Strng$;
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   Line Input ; "Case-sensitive(y/n)? "; Y$
   If UCase$(Y$) = "Y" Then CaseSensitive = True
   If UCase$(Y$) = "N" Then CaseSensitive = False

   Color White, BBlue
   Locate Max.Row - 1, 1
   Strng$ = Space$(ScreenWidth)
   Print Strng$;
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   Line Input ; "Use wildcards(y/n)? "; Z$
   If UCase$(Z$) = "Y" Then WildCards = True
   If UCase$(Z$) = "N" Then WildCards = False

   LastSearchLine& = 0&
   LastSearchString$ = X$
   VarX2 = False
   If Len(X$) = False Then
      Return
   End If
   For Count& = 1 To Max.Lines
      If WildCards Then
         VarX1$ = Temp.ArrayS(Count&)
         VarX2$ = X$
         Call InstrSUB1(VarX2, VarX2$, VarX1$, CaseSensitive)
         If VarX2 Then
            LastSearchLine& = Count&
            Exit For
         End If
      Else
         If CaseSensitive Then
            If InStr(Temp.ArrayS(Count&), X$) Then
               LastSearchLine& = Count&
               VarX2 = True
               Exit For
            End If
         Else
            VarX1$ = UCase$(Temp.ArrayS(Count&))
            VarX2$ = UCase$(X$)
            If InStr(VarX1$, VarX2$) Then
               LastSearchLine& = Count&
               VarX2 = True
               Exit For
            End If
         End If
      End If
   Next
   Return

   ' continue search
   Search.String2:
   X$ = LastSearchString$
   VarX2 = 0
   If Len(X$) Then
      For Count& = LastSearchLine& + 1& To Max.Lines
         If WildCards Then
            VarX1$ = Temp.ArrayS(Count&)
            VarX2$ = X$
            Call InstrSUB1(VarX2, VarX2$, VarX1$, CaseSensitive)
            If VarX2 Then
               LastSearchLine& = Count&
               Exit For
            End If
         Else
            If CaseSensitive Then
               If InStr(Temp.ArrayS(Count&), X$) Then
                  LastSearchLine& = Count&
                  VarX2 = True
                  Exit For
               End If
            Else
               VarX1$ = UCase$(Temp.ArrayS(Count&))
               VarX2$ = UCase$(X$)
               If InStr(VarX1$, VarX2$) Then
                  LastSearchLine& = Count&
                  VarX2 = True
                  Exit For
               End If
            End If
         End If
      Next
   End If
   Return

   ' redisplay editor screen
   Display.Screen:
   Color White, Black
   Cls
   Locate 1, 1
   Count2 = 0
   Do
      Count2 = Count2 + 1
      If Count2 = Max.Row - 1 Then
         Exit Do
      End If
      If Count2 + Line.Number - Xcoor > Max.Lines Then
         Exit Do
      End If
      Locate Count2, 1
      Strng$ = Mid$(Temp.ArrayS(Count2 + Line.Number - Xcoor), Column)
      If Len(Strng$) > ScreenWidth Then
         Strng$ = Left$(Strng$, ScreenWidth)
      End If
      Print Strng$;
   Loop
   If Count2 < Max.Row - 1 Then
      Locate Count2, 1
      Color Red, Black
      Print "<end of file>";
   End If
   S = ScreenWidth
   Color Yellow, BBlue
   Locate Max.Row - 1, 1
   Print Space$(S - 2);
   Color Black, BBlue
   Locate Max.Row - 1, S - 1, 0
   Print " ";
   Locate Max.Row - 1, S, 0
   Print " ";
   Color White, Black
   Call Edit.Status.Line
   Return
End Sub

Sub Make.Format (Var#, Var$)
   Var2# = Var#
   If Var2# <= 0 Then
      Var$ = "0.00 B"
      Exit Sub
   End If
   TempA = False
   Do
      If Var2# < 1024# Then
         Exit Do
      End If
      Var2# = Var2# / 1024#
      TempA = TempA + 1
      If TempA = 8 Then
         Exit Do
      End If
   Loop
   Strng$ = Nul
   If TempA >= 1 And TempA <= 8 Then
      Strng$ = Mid$("KMGTPEZY", TempA, 1)
   End If
   Var$ = FormatString$(Var2#) + " " + Strng$ + "B"
End Sub

Sub Amount (Var#, Var$)
   If Var# = Dfalse Then
      Var$ = " 0"
   Else
      If InStr(Str$(Var#), "D") Then
         Var$ = Str$(Var#)
      Else
         Var$ = " " + FormatString$(Var#)
      End If
   End If
End Sub

' display editor status line
Sub Edit.Status.Line
   TempX$ = "SICK Editor > Time: " + Date$ + " " + Time$ + " "
   If StatusLine1 = Dfalse And StatusLine2 = Dfalse Then
      If StatusLineFileSize > Dfalse Then
         TempX$ = TempX$ + "Size: " + FormatString$(StatusLineFileSize) + " bytes."
      End If
   Else
      TempX$ = TempX$ + FormatString$(StatusLine1) + " of " + FormatString$(StatusLine2)
   End If
   S = ScreenWidth
   TempX$ = Left$(TempX$, S - 1)
   TempX$ = TempX$ + Space$(S - 1 - Len(TempX$))
   Call Display.Status.Line(-1, TempX$)
End Sub

' display status line
Sub Display.Status.Line (Var, Var$)
   X = CsrLin
   Y = Pos(0)
   Max.Row = ScreenHeight
   If Var Then
      Color Yellow, BBlue
   Else
      Color White, Black
   End If
   Locate Max.Row, 1, 0
   Var2$ = Left$(Var$, ScreenWidth)
   Print Var2$;
   Locate Max.Row, ScreenWidth
   If Var Then
      Color Black, BBlue
   Else
      Color Plain, Black
   End If
   Print " ";
   Locate Max.Row - 1, 1, 1
   Color White, Black
   Locate X, Y, 1
End Sub

Sub Dot.Display (VarA, VarB, VarC!)
   ' check display timer
   VarG! = Timer - VarC!
   If VarG! < SFalse Then VarG! = VarG! + 86400!
   If VarG! >= 1! Then
      VarC! = Timer
      ' check to display percent copied
      If DotDisplay = True Then
         If StatusLine2 > 0 Then
            Percent = (StatusLine1 / StatusLine2) * 100!
            Percent = Int(Percent)
            If Percent = False Then
               If Percent.Flag = False Then
                  Print "000%";
               End If
               Percent.Flag = True
            Else
               If Percent <> Last.Percent Then
                  Last.Percent = Percent
                  If Percent.Flag Then
                     For Var = 1 To 4
                        Call BackSpace
                        Print " ";
                        Call BackSpace
                     Next
                  End If
                  Print Right$(Str$(Percent + 1000%), 3) + "%";
                  Percent.Flag = True
               End If
            End If
         End If
         Exit Sub
      End If

      ' check to display progress bar
      If DotDisplay = -2 Then
         If StatusLine2 > 0 Then
            If Len(ProgressChar) = 1 Then
               Percent = (StatusLine1 / StatusLine2) * 100#
               Percent = Int(Percent / 10)
               Do While Percent > Current.Progress
                  If Current.Progress >= 10 Then
                     Exit Do
                  End If
                  Print ProgressChar;
                  Current.Progress = Current.Progress + 1
               Loop
            End If
         End If
         Exit Sub
      End If

      ' default to display dots.
      If DotChar = Nul Then
         Exit Sub
      End If
      If VarA = False Then
         VarB = VarB + 1
         Print DotChar;
         If VarB = DotCount Then
            VarA = True
            VarB = False
         End If
      Else
         VarB = VarB + 1
         For VarX = 1 To Len(DotChar)
            Call BackSpace
            Print " ";
            Call BackSpace
         Next
         If VarB = DotCount Then
            VarA = False
            VarB = False
         End If
      End If
   End If
End Sub

Sub BackSpace
   If Pos(0) > 1 Then
      Locate CsrLin, Pos(0) - 1, 0
      Print " ";
      Locate CsrLin, Pos(0) - 1, 1
   End If
End Sub

Function IsNumeric (x$)
   For V = 1 To Len(x$)
      If Mid$(x$, V, 1) >= "0" And Mid$(x$, V, 1) <= "9" Then
         Eat$ = Nul
      Else
         IsNumeric = 0
         Exit Function
      End If
   Next
   IsNumeric = True
End Function

' subroutine to access subdirectories
Sub Silentdel_Directories (Directory.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata4 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset

   ' make directory filename
   ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata4))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' delete filenames
      Call Silentdel_DeleteFiles(Directory.Search$)

      ' recurse subdirectories
      Do
         ' check directory attribute
         Attribute = finddata4.dwFileAttributes

         ' check directory
         If (Attribute And &H10) = &H10 Then

            ' store directory name
            Directory$ = finddata4.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

            ' store short filename
            If InStr(Directory$, "?") Then
               Directory$ = finddata4.cAlternateFileName
               V = InStr(Directory$, Chr$(0))
               If V Then Directory$ = Left$(Directory$, V - 1)
            End If

            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then

               ' make next search directory
               Next.Directory$ = Directory.Search$ + Directory$ + "\"

               ' recursively search subdirectories
               Call Silentdel_Directories(Next.Directory$)
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata4))
      x = FindClose(Wfile.Handle)
   End If

   ' delete directory
   Call Silentdel_DeleteDirectory(Directory.Search$)
End Sub

' subroutine to delete an empty directory
Sub Silentdel_DeleteDirectory (Directory$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260

   ' store directory filename
   ASCIIZ = Directory$ + Chr$(0)

   ' change directory attribute
   AttrX& = GetFileAttributes(ASCIIZ)
   AttrX& = AttrX& And Not &H1 ' remove read-only bit
   x = SetFileAttributes&(ASCIIZ, AttrX&)

   ' delete directory
   x = RemoveDirectoryA(ASCIIZ)
End Sub

' subroutine to delete files in a directory
Sub Silentdel_DeleteFiles (Directory$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260
   Dim ASCIIZ2 As String * 260
   Dim finddata5 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset

   ' make filename
   ASCIIZ = Directory$ + "*.*" + Chr$(0)

   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata5))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' filename loop
      Do
         ' store filename
         Filename$ = finddata5.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then
            ' store filename
            ASCIIZ2 = Directory$ + Filename$ + Chr$(0)

            ' change filename attribute
            AttrX& = GetFileAttributes(ASCIIZ2)
            AttrX& = AttrX& And Not &H1 ' remove read-only bit
            x = SetFileAttributes&(ASCIIZ2, AttrX&)

            ' delete long filename
            x = DeleteFileA(ASCIIZ2)

            ' check error and delete 8.3 filename
            If x = 0 Then
               Short.Filename$ = finddata5.cAlternateFileName
               V = InStr(Short.Filename$, Chr$(0))
               If V Then Short.Filename$ = Left$(Short.Filename$, V - 1)
               ASCIIZ2 = Directory$ + Short.Filename$ + Chr$(0)

               ' change filename attribute
               AttrX& = GetFileAttributes(ASCIIZ2)
               AttrX& = AttrX& And Not &H1
               x = SetFileAttributes&(ASCIIZ2, AttrX&)

               ' delete short filename
               x = DeleteFileA(ASCIIZ2)
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata5))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to access subdirectories
Sub Recurse_Directories (Directory.Search$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata6 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset
   If Quit.Searching Then GoTo QuitRecurse

   ' make directory filename
   ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata6))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' display length
      Var$ = "(" + LTrim$(Str$(Line.Counter2 + 1)) + ")" + Directory.Search$
      Length3 = Len(Var$)
      Z = LastWidth1: If Z = 0 Then Z = 80
      Line.Counter = Line.Counter + Int(Length3 / Z) + 1
      Z = PageLength - 1
      If Line.Counter >= Z Then
         Line.Counter = False
         Line.Counter2 = False
         If Continue.Search = False And Quit.Searching = False Then
            Color White, Black
            Call MorePrompt(MorePrompt0, "yncq " + CR, Outpt$)
            Select Case LCase$(Outpt$)
               Case "c" ' continuous
                  Continue.Search = True
               Case "n", "q" ' no/quit
                  Quit.Searching = True
                  GoTo QuitRecurse
            End Select
         End If
      End If

      ' print directory
      Color Yellow, Black
      Line.Counter2 = Line.Counter2 + 1
      Var$ = "(" + LTrim$(Str$(Line.Counter2)) + ")" + Directory.Search$
      Print Var$

      ' check exit
      If ControlBreak Then
         ControlBreak = 0
         Quit.Searching = True
      End If
      If Quit.Searching Then GoTo QuitRecurse

      ' recurse subdirectories
      Do
         If Quit.Searching Then GoTo QuitRecurse

         ' check directory attribute
         Attribute = finddata6.dwFileAttributes

         ' check directory
         If (Attribute And &H10) = &H10 Then

            ' store directory name
            Directory$ = finddata6.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

            ' store short filename
            If InStr(Directory$, "?") Then
               Directory$ = finddata6.cAlternateFileName
               v = InStr(Directory$, Chr$(0))
               If v Then Directory$ = Left$(Directory$, v - 1)
            End If

            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then

               ' make next search directory
               Next.Directory$ = Directory.Search$ + Directory$ + "\"

               ' recursively search subdirectories
               Call Recurse_Directories(Next.Directory$)
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata6))
      x = FindClose(Wfile.Handle)
   End If
   Exit Sub
   QuitRecurse:
   If Wfile.Handle > 0 Then
      x = FindClose(Wfile.Handle)
   End If
   Exit Sub
End Sub

' subroutine to access directories
Sub Whereis_Directories (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata7 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset
   Recurse.Directories = True

   ' check to quit
   If Quit.Searching Then
      Exit Sub
   End If

   ' store directory asciiz
   ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata7))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search directory names
      Call Whereis_Filenames(Directory.Search$, Filename.Search$)

      ' check to recurse directories
      If Recurse.Directories Then

         ' recurse directories
         Do
            ' check to quit
            If Quit.Searching Then
               Exit Do
            End If

            ' check directory attribute
            Attribute = finddata7.dwFileAttributes

            ' check for directory
            If (Attribute And &H10) = &H10 Then

               ' store directory name
               Directory$ = finddata7.cFileName
               Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

               ' check directory name
               If Directory$ <> "." And Directory$ <> ".." Then

                  ' check unicode
                  If InStr(Directory$, "?") Then
                     Directory$ = finddata7.cAlternateFileName
                     V = InStr(Directory$, Chr$(0))
                     If V Then Directory$ = Left$(Directory$, V - 1)
                  End If

                  ' make next search directory
                  Next.Directory$ = Directory.Search$ + Directory$ + "\"

                  ' recursively search subdirectories
                  Call Whereis_Directories(Next.Directory$, Filename.Search$)
               End If
            End If
         Loop While FindNextFileA(Wfile.Handle, _Offset(finddata7))
      End If
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to access filenames in directory
Sub Whereis_Filenames (Directory.Search$, Filename.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata8 As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Offset

   ' check to quit
   If Quit.Searching Then
      Exit Sub
   End If

   ' make filename
   Var1$ = Directory.Search$
   Var2$ = Filename.Search$

   Var1$ = RTrim$(Var1$)
   Var2$ = RTrim$(Var2$)

   ASCIIZ = Var1$ + Var2$ + Chr$(0)
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata8))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search filenames
      Do
         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If

         ' store file data
         finddatatemp = finddata8

         ' check directory attribute
         Attribute = finddata8.dwFileAttributes

         ' store filename
         Filename$ = finddata8.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check unicode
         If InStr(Filename$, "?") And CurrentCommand < CommandCount Then
            Filename$ = finddata8.cAlternateFileName
            V = InStr(Filename$, Chr$(0))
            If V Then Filename$ = Left$(Filename$, V - 1)
         End If

         ' store short filename
         Short.Directory$ = finddata8.cAlternateFileName
         V = InStr(Short.Directory$, Chr$(0))
         If V Then Short.Directory$ = Left$(Short.Directory$, V - 1)
         If Short.Directory$ = Nul Then
            Short.Directory$ = finddata8.cFileName
            V = InStr(Short.Directory$, Chr$(0))
            If V Then Short.Directory$ = Left$(Short.Directory$, V - 1)
         End If

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then

            ' check for directory
            If (Attribute And &H10) = &H10 Then
               ' increment directories actually searched
               Dirs.Counted = Dirs.Counted + 1#
            End If

            ' store file size
            File.Size = finddata8.nFileSizeHigh * &H100000000~&& Or finddata8.nFileSizeLow

            ' display filename info
            Call Whereis_DisplayFiles(Directory.Search$, Filename$)
         End If

         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata8))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to display a filename
Sub Whereis_DisplayFiles (Search.Directory$, Search.Filename$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long

   ' get file attributes
   Attribute = finddatatemp.dwFileAttributes

   ' make filename
   File.List$ = Search.Directory$ + Search.Filename$

   ' store file date and time
   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)

   If Creation.Time Then
      x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   Else
      If Access.Time Then
         x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
      Else
         If Modified.Time Then
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
         End If
      End If
   End If
   GoSub Convert.Date
   GoSub Convert.Time

   ' check for directory bit
   If (Attribute And &H10) <> &H10 Then
      ' increment files counted
      Files.Counted = Files.Counted + 1#
      Total.Bytes = Total.Bytes + File.Size
   End If

   ' display directory/filename
   Outpt$ = LCase$(File.List$)

   ' check for directory bit
   If (Attribute And &H10) = &H10 Then
      Dirs.Displayed = Dirs.Displayed + 1#
   End If

   ' display filename
   If Len(Outpt$) Then
      Color Yellow, Black
      Print Outpt$;
      Length2 = Len(Outpt$)
      Color Red, Black
      Outpt$ = " [" + File.Date$ + " " + File.Time$ + "]"
      Length2 = Length2 + Len(Outpt$)
      Print Outpt$;
      If ScreenWidth = 40 Then Print: GoTo NextDir
      ' check for directory bit
      Color Green, Black
      If (Attribute And &H10) = &H10 Then
         Size$ = " <dir>"
      Else
         Size$ = " (" + FormatString$(File.Size) + ")"
      End If
      Print Size$;
      Length2 = Length2 + Len(Size$)

      ' attributes of directory/filename
      Attr$ = Nul
      If (Attribute And &H20) = &H20 Then
         Attr$ = Attr$ + "A" ' archive
      End If
      If (Attribute And &H4) = &H4 Then
         Attr$ = Attr$ + "S" ' system
      End If
      If (Attribute And &H2) = &H2 Then
         Attr$ = Attr$ + "H" ' hidden
      End If
      If (Attribute And &H1) = &H1 Then
         Attr$ = Attr$ + "R" ' read-only
      End If
      If (Attribute And &H800) = &H800 Then
         Attr$ = Attr$ + "C" ' compressed
      End If
      If (Attribute And &H4000) = &H4000 Then
         Attr$ = Attr$ + "E" ' encrypted
      End If
      If Len(Attr$) Then
         Attr$ = " {" + Attr$ + "}"
         Color Cyan, Black
         Print Attr$;
         Length2 = Length2 + Len(Attr$)
      End If
      Print
      NextDir:
      Z = LastWidth1: If Z = 0 Then Z = 80
      Files.Counter = Files.Counter + Int(Length2 / Z) + 1
   End If
   ' check paginate
   Call PagePrompt(Files.Counter, FlagX)
   If FlagX Then
      Files.Counter = 0
   End If

   ' reset line length
   Length2 = False
   Exit Sub

   Convert.Date:
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))
   Return

   Convert.Time:
   File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   Return
End Sub

' check to paginate
Sub PagePrompt (Var, Flag)
   Flag = False
   Z = PageLength - 2
   If Var >= Z Then
      Flag = True
      If Continue.Search = False Then
         Call MorePrompt(MorePrompt0, "yncq " + CR, Outpt$)
         Select Case Outpt$
            Case "c"
               Continue.Search = True
            Case "n", "q"
               Quit.Searching = True
         End Select
      End If
   End If
End Sub

' Def FNclock$=Format$(Now,"ddd dd mmm yyyy\, hh:mma/p")
Function clock$
   ' mm-dd-yyyy hh:mm:ss
   M = Val(Left$(Date$, 2))
   D = Val(Mid$(Date$, 4, 2))
   Y = Val(Right$(Date$, 4))

   If M < 3 Then M = M + 12: Y = Y - 1
   W = ((13 * M + 3) \ 5 + D + Y + Y \ 4 - Y \ 100 + Y \ 400 + 1) Mod 7
   var$ = Mid$("SunMonTueWedThuFriSat", W * 3 + 1, 3)
   var$ = var$ + " " + Mid$(Date$, 4, 2) ' dd

   T = (Val(Mid$(Date$, 1, 2)) - 1) * 3 + 1 ' mmm
   var$ = var$ + " " + Mid$("JanFebMarAprMayJunJulAugSepOctNovDec", T, 3)

   var$ = var$ + " " + Mid$(Date$, 7, 4) ' yyyy

   T = Val(Left$(Time$, 2))
   If T > 11 Then T = T - 12
   If T = 0 Then T = 12
   var$ = var$ + ", " + Right$("00" + LTrim$(Str$(T)), 2) ' hh
   var$ = var$ + ":" + Mid$(Time$, 4, 2) ' mm

   T = Val(Left$(Time$, 2))
   If T < 12 Then
      var$ = var$ + "a"
   Else
      var$ = var$ + "p"
   End If
   clock$ = var$
End Function

' function creates a bitmap of the icon and returns the icon count
Function Icon2BMP% (filein As String, fileout As String, index As Integer)
   Dim byte As _Unsigned _Byte, word As Integer, dword As Long
   Dim wide As Long, high As Long, BM As Integer, bpp As Integer
   rf = FreeFile
   If LCase$(Right$(filein, 4)) <> ".ico" Then 'check file extension is ICO only
      Exit Function
   End If
   Open filein For Binary Access Read As rf
   Get rf, , word
   Get rf, , word: icon = word
   Get rf, , word: count = word
   If icon <> 1 Or count = 0 Then Close rf: Exit Function
   If index > 0 And index <= count Then entry = 16 * (index - 1) Else entry = 16 * (count - 1)
   Seek rf, 1 + 6 + entry 'start of indexed Entry header
   Get rf, , byte: wide = byte ' use this unsigned for images over 127
   Get rf, , byte: high = byte ' use this unsigned because it isn't doubled
   Get rf, , word 'number of 4 BPP colors(256 & 32 = 0) & reserved bytes
   Get rf, , dword '2 hot spots both normally 0 in icons, used for cursors
   Get rf, , dword: size = dword 'this could be used, doesn't seem to matter
   Get rf, , dword: offset = dword 'find where the specific index BMP header is
   Seek rf, 1 + offset + 14 'only read the BPP in BMP header
   Get rf, , word: bpp = word
   If bpp = 0 Then Close rf: Exit Function
   If bpp <= 24 Then pixelbytes = bpp / 8 Else pixelbytes = 3
   If bpp > 1 And bpp <= 8 Then palettebytes = 4 * (2 ^ bpp) Else palettebytes = 0
   datasize& = (wide * high * pixelbytes) + palettebytes 'no padder should be necessary
   filesize2& = datasize& + 14 + 40 '                      data and palette + header
   bmpoffset& = palettebytes + 54 '                       data offset from start of bitmap
   readbytes& = datasize& + 28 ' (40 - 12) bytes left to read in BMP header and XOR mask only
   BM = CVI("BM") 'this will create "BM" in file like MKI$ would
   wf = FreeFile
   Open fileout For Binary As wf
   Put wf, , BM
   Put wf, , filesize2&
   dword = 0
   Put wf, , dword
   Put wf, , bmpoffset& 'byte location of end of palette or BMP header
   dword = 40
   Put wf, , dword '              start of 40 byte BMP header
   Put wf, , wide
   Put wf, , high
   Seek rf, 1 + offset + 12 '     after 12 bytes start copy of BMP header starting at planes
   dat$ = String$(readbytes&, 0) 'create string to hold remaining bytes needed w/o AND mask data
   Get rf, , dat$ '               copy lower header, palette(if used) and XOR mask
   Put wf, , dat$ '               put all of the string data in the bitmap all at once
   Close rf, wf
   Icon2BMP = count '             return the number of icons available in the icon file
End Function

' set title icon
Sub DisplayIcon (Var$)
   Bitmap$ = "tempfile.bmp"
   indx% = 6
   Icon$ = Var$
   If Right$(LCase$(Icon$), 4) = ".ico" Then
      If _FileExists(Icon$) Then
         ' new icon convert (01/20/2024)
         If Icon2BMP(Icon$, Bitmap$, indx%) Then
            img& = _LoadImage(Bitmap$)
            If img& < True Then
               _Icon img&
               _FreeImage img&
               f$ = Bitmap$ + Chr$(0)
               x = DeleteFileA%(f$)
            End If
         End If
      End If
   Else
      Icon& = _LoadImage(Icon$, 32)
      If Icon& < True Then
         _Icon Icon&
         _FreeImage Icon&
      End If
   End If
End Sub

Sub SetTitleIcon
   i& = _LoadImage("SIC64.BMP", 32)
   If i& < True Then
      _Icon i&
      _FreeImage i&
   Else
      ' old icon code
      If _FileExists("sic64.ico") Then
         Call DisplayIcon("sic64.ico")
      End If
   End If

   ' set title
   _Title "SICK64"
End Sub

' var = 0 test file, 1 = create file, 2 = append file
Function CreateFileA& (Filename$, Var)
   If Var = 0 Then
      If _FileExists(Filename$) Then
         CreateFileA = True
      Else
         CreateFileA = False
      End If
   End If
   If Var = 1 Then
      If _FileExists(Filename$) Then
         CreateFileA = False
      Else
         x = FreeFile
         Open Filename$ For Output As #x
         CreateFileA = True
         Close x
      End If
   End If
   If Var = 2 Then
      If _FileExists(Filename$) Then
         CreateFileA = False
      Else
         x = FreeFile
         Open Filename$ For Append As #x
         CreateFileA = True
         Close x
      End If
   End If
End Function

Rem In DateFunc and TimeFunc the error
Rem   a required privilege is not held by the client.
Rem is solved by running qb64pe as admin.
Rem (although Sick will attempt to force user to admin).

Sub DateFunc (Var$)
   z$ = Var$
   z$ = LTrim$(RTrim$(z$))
   If Len(z$) Then
      z = ValidDate(z$)
      If z Then
         ' mm-dd-yyyy or mm/dd/yyyy
         x = GetLocalTime(SysTime)
         SysTime.wMonth = Int(Val(Left$(z$, 2)))
         SysTime.wDay = Int(Val(Mid$(z$, 4, 2)))
         SysTime.wYear = Int(Val(Right$(z$, 4)))
         x = SetLocalTime(SysTime)
         If x = 0 Then
            Print "Error Date reset: " + z$
            Print DisplayWinError$(x)
         Else
            Print "Date reset to: " + z$
         End If
      Else
         Print "Invalid date."
      End If
   End If
End Sub

Sub TimeFunc (Var$)
   z$ = Var$
   z$ = LTrim$(RTrim$(z$))
   If Len(z$) Then
      z = ValidTime(z$)
      If z Then
         ' hh:mm:ss
         x = GetLocalTime(SysTime)
         SysTime.wHour = Int(Val(Left$(z$, 2)))
         SysTime.wMinute = Int(Val(Mid$(z$, 4, 2)))
         SysTime.wSecond = Int(Val(Right$(z$, 2)))
         x = SetLocalTime(SysTime)
         If x = 0 Then
            Print "Error Time reset: " + z$
            Print DisplayWinError$(x)
         Else
            Print "Time reset to: " + z$
         End If
      Else
         Print "Invalid time."
      End If
   End If
End Sub

Function ValidDate (Var$)
   ' mm-dd-yyyy or mm/dd/yyyy
   Var$ = RTrim$(Var$)
   If Len(Var$) <> 10 Then
      ValidDate = False
      Exit Function
   End If
   V1$ = Mid$(Var$, 3, 1)
   V2$ = Mid$(Var$, 6, 1)
   If V1$ = "-" And V1$ = "-" Then
      Eat$ = Nul
   Else
      If V1$ = "/" And V2$ = "/" Then
         Eat$ = Nul
      Else
         ValidDate = False
         Exit Function
      End If
   End If
   For Var = 1 To 10
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8, 9, 10
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = Nul
            Else
               ValidDate = False
               Exit Function
            End If
      End Select
   Next
   M = Int(Val(Mid$(Var$, 1, 2)))
   D = Int(Val(Mid$(Var$, 4, 2)))
   Y = Int(Val(Mid$(Var$, 7, 4)))
   If M >= 1 And M <= 12 Then
      If D >= 1 And D <= 31 Then
         If Y >= 1980 And Y <= 2079 Then
            L = 0
            If Y / 4 = Y \ 4 Then
               L = True
            End If
            If Y / 100 = Y \ 100 Then
               L = False
            End If
            If Y / 400 = Y \ 400 Then
               L = True
            End If
            Select Case M
               Case 1, 3, 5, 7, 8, 10, 12
                  If D <= 31 Then
                     ValidDate = ValidDate2(Var$)
                     Exit Function
                  End If
               Case 4, 6, 9, 11
                  If D <= 30 Then
                     ValidDate = ValidDate2(Var$)
                     Exit Function
                  End If
               Case 2
                  If L Then
                     If D <= 29 Then
                        ValidDate = ValidDate2(Var$)
                        Exit Function
                     End If
                  End If
                  If D <= 28 Then
                     ValidDate = ValidDate2(Var$)
                     Exit Function
                  End If
            End Select
         End If
      End If
   End If
   ValidDate = 0
End Function

Function ValidTime (Var$)
   ' hh:mm:ss
   Var$ = RTrim$(Var$)
   If Len(Var$) <> 8 Then
      ValidTime = False
      Exit Function
   End If
   For Var = 1 To 8
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = Nul
            Else
               ValidTime = False
               Exit Function
            End If
         Case Else
            If V$ <> ":" Then
               ValidTime = False
               Exit Function
            End If
      End Select
   Next
   H = Int(Val(Mid$(Var$, 1, 2)))
   M = Int(Val(Mid$(Var$, 4, 2)))
   S = Int(Val(Mid$(Var$, 7, 2)))
   If H >= 0 And H <= 23 Then
      If M >= 0 And M <= 59 Then
         If S >= 0 And S <= 59 Then
            ValidTime = ValidTime2(Var$)
            Exit Function
         End If
      End If
   End If
   ValidTime = 0
End Function

' create a randomized 8.3 dos filename.
Function GetLabel$
   X$ = Nul
   For L = 1 To 11
      X = Int(Rnd * 16 + 1)
      X$ = X$ + Hex$(X)
   Next
   GetLabel$ = X$
End Function

' create a randomized ASCIIZ windows filename.
Function GetASCIIZLabel$
   X$ = Nul
   For L = 1 To 32
      X = Int(Rnd * 16 + 1)
      X$ = X$ + Hex$(X)
   Next
   GetASCIIZLabel$ = X$
End Function

' create a randomized extended ASCIIZ windows filename.
Function GetASCIIZLabelA$
   X$ = Nul
   For L = 1 To MAX_PATH
      X = Int(Rnd * 16 + 1)
      X$ = X$ + Hex$(X)
   Next
   GetASCIIZLabelA$ = X$
End Function

' count bytes
Function CountBytes2# (Var4$, Ext$)
   Dim ASCIIZ4 As String * 260
   Dim finddata9 As WIN32_FIND_DATAA
   Dim hfind5 As _Offset
   Found# = Dfalse

   ' reset search parameter
   If Var4$ = Nul Then
      Var4$ = _CWD$
   End If
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = Nul Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind5 = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata9))
   If hfind5 <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata9.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata9.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  VarZ# = finddata9.nFileSizeHigh * &H100000000~&& Or finddata9.nFileSizeLow
                  Found# = Found# + VarZ#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind5, _Offset(finddata9))
      x = FindClose(hfind5)
   End If
   CountBytes2# = Found#
End Function

' count files
Function CountFiles2# (Var4$, Ext$)
   Dim ASCIIZ4 As String * 260
   Dim finddata9 As WIN32_FIND_DATAA
   Dim hfind5 As _Offset
   Found# = Dfalse

   ' reset search parameter
   If Var4$ = Nul Then
      Var4$ = _CWD$
   End If
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = Nul Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind5 = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata9))
   If hfind5 <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata9.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata9.dwFileAttributes
               If (Var# And &H10) = &H0 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind5, _Offset(finddata9))
      x = FindClose(hfind5)
   End If
   CountFiles2# = Found#
End Function

' count dirs
Function CountDirs2# (Var4$, Ext$)
   Dim ASCIIZ4 As String * 260
   Dim finddata9 As WIN32_FIND_DATAA
   Dim hfind5 As _Offset
   Found# = Dfalse

   ' reset search parameter
   If Var4$ = Nul Then
      Var4$ = _CWD$
   End If
   If Right$(Var4$, 1) <> "\" Then
      Var4$ = Var4$ + "\"
   End If
   If Ext$ = Nul Then
      Var4$ = Var4$ + "*.*"
   Else
      Var4$ = Var4$ + Ext$
   End If

   ASCIIZ4 = Var4$ + Chr$(0)
   hfind5 = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata9))
   If hfind5 <> INVALID_HANDLE_VALUE Then
      Do
         ' check longfilename
         z$ = finddata9.cFileName
         vx = InStr(z$, Chr$(0))
         If vx Then
            z$ = Left$(z$, vx - 1)
         End If
         If z$ = Nul Then
            Eat$ = Nul
         Else
            If z$ = "." Or z$ = ".." Then
               Eat$ = Nul
            Else
               Var# = finddata9.dwFileAttributes
               If (Var# And &H10) = &H10 Then
                  Found# = Found# + 1#
               End If
            End If
         End If
      Loop While FindNextFileA(hfind5, _Offset(finddata9))
      x = FindClose(hfind5)
   End If
   CountDirs2# = Found#
End Function

' display status line
Sub DisplayStatusLine2 (Var, Var$)
   Var1 = ScreenHeight
   Var2 = ScreenWidth
   If Var Then
      Color Yellow, BBlue
   Else
      Color White, Black
   End If
   Locate Var1, 1, 0
   Var$ = Left$(Var$, Var2)
   Print Var$;
   Locate Var1, Var2
   If Var Then
      Color Black, BBlue
   Else
      Color Plain, Black
   End If
   Print " ";
   Locate Var1 - 1, 1, 1
   Color White, Black
End Sub

Sub SearchFiles (VarX$)
   ' declare subroutine variables
   Dim Max.Row As Integer
   Const Nul = ""
   Const RefreshTimer = 10
   Const TabStop = 8
   Dim Width1 As Integer
   Dim Width2 As Integer
   Dim Width3 As Integer
   Dim Max.Files As Long
   Dim Max.Lines As Long
   Dim Max.File As Long
   Dim Filenames(1) As String
   Dim FileType(1) As Integer
   Dim Current.Directory As String
   Dim Current.File As Long
   Dim Current.Line As Long
   Dim SortOrder As Integer
   Dim SortOrder2 As Integer

   ' setup screen
   Max.Row = ScreenHeight
   Width1 = ScreenWidth
   Width2 = Width1 - 1
   Width3 = Width1 - 2
   Cls
   Width Width1, Max.Row

   ' initialize drive variables
   Dim DriveList(26) As String

   ' setup default file variables.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' setup default values.
   SortOrder = True
   SortOrder2 = True
   Line.Length = 5
   If Width1 = 40 Then
      Line.Length = 2
   End If

   ' store current default drive/directory.
   Current.Directory = _CWD$
   If Right$(Current.Directory, 1) <> "\" Then
      Current.Directory = Current.Directory + "\"
   End If

   ' read in all drives.
   VarZ1 = True
   Top.Loop:
   Cls
   If VarZ1 = -1 Then
      Color Red, BBlue
      Print "Loading drives."
      Color White, Black
   End If
   If VarZ1 = -2 Then
      Color Red, BBlue
      Print "Drive " + VarQ1$ + "removed."
      Color White, Black
   End If
   If VarZ1 = -3 Then
      Color Red, BBlue
      Print "Drive " + VarQ2$ + "added."
      Color White, Black
   End If
   If VarZ1 = -4 Then
      Color Red, BBlue
      Print "Drive " + VarQ3$ + "removed/added."
      Color White, Black
   End If
   If VarZ1 < True Then
      VarX$ = "*.*"
      VarY$ = "*"
   End If

   ' load drive list array.
   Max.Drives = 0
   For i = 1 To 26
      DriveList(i) = Nul
      f$ = Chr$(i + 64)
      VarZ$ = f$ + ":\" + Chr$(0)
      Vname$ = Space$(MAX_PATH)
      Fname$ = Space$(MAX_PATH)
      r = GetVolumeInformationA(VarZ$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
      If r Then
         ' get volume label.
         Vname$ = Left$(Vname$, InStr(Vname$, Chr$(0)) - 1)
         VarQ$ = f$ + ":\" + LTrim$(RTrim$(Vname$))
         ' get serial number.
         VarQ$ = VarQ$ + " [" + Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4) + "]"
         ' add drive info to list.
         Max.Drives = Max.Drives + 1
         DriveList(i) = VarQ$
         If VarZ1 = True Then
            Color Yellow
            Print "Drive "; VarQ$
         End If
      End If
   Next
   If VarZ1 = True Then
      Color White
      Print "Total"; Max.Drives; "drives."
   End If

   ' check current drive
   Drive$ = Left$(Current.Directory, 3)
   DriveX = Asc(Mid$(Drive$, 1, 1)) - 64
   If DriveList(DriveX) = Nul Then
      Current.Directory = "C:\"
      ' check endless loop
      If DriveList(3) = Nul Then
         Print "Root of C:\ not found."
         Exit Sub
      End If
      Print "Moved to "; Current.Directory
   End If

   ' prepare search specs
   If Len(VarX$) Then
      If Len(VarY$) Then
         SpecD$ = VarY$
      Else
         SpecD$ = "*"
      End If
      SpecF$ = VarX$
      VarX$ = Nul
      GoTo Start.Sub2
   End If

   Start.Sub:
   Color White, Black
   VarZ$ = "Enter dirspec(*)?"
   SpecD$ = KeyboardLine4$(VarZ$)
   If SpecD$ = Nul Then SpecD$ = "*"
   If InStr(SpecD$, "\") Then
      ' store current default drive/directory.
      Current.Directory$ = SpecD$
      If Right$(Current.Directory$, 1) <> "\" Then
         Current.Directory$ = Current.Directory$ + "\"
      End If
      If Left$(Current.Directory$, 1) = "\" Then
         Current.Directory$ = Left$(_CWD$, 2) + Current.Directory$
      End If
      If Left$(Current.Directory$, 1) = ":" Then
         Current.Directory$ = Left$(_CWD$, 1) + Current.Directory$
      End If
      If _DirExists(Current.Directory$) = False Then
         Current.Directory$ = _CWD$
         If Right$(Current.Directory$, 1) <> "\" Then
            Current.Directory$ = Current.Directory$ + "\"
         End If
      End If
      SpecD$ = "*"
   End If
   If ValidFileChar2$(SpecD$) = Nul Then
      Print "Illegal directory character."
      GoTo Start.Sub
   End If

   Color White, Black
   VarZ$ = "Enter filespec(*.*)?"
   SpecF$ = KeyboardLine4$(VarZ$)
   If SpecF$ = Nul Then SpecF$ = "*.*"

   Start.Sub2:
   If InStr(SpecF$, "\") Then
      Print "Illegal filename character."
      GoTo Start.Sub
   End If
   If InStr(SpecF$, ":") Then
      Print "Illegal filename character."
      GoTo Start.Sub
   End If
   If ValidFileChar2$(SpecF$) = Nul Then
      Print "Illegal filename character."
      GoTo Start.Sub
   End If

   Start.Loop:
   Cls
   ReDim Filenames(26) As String
   ReDim FileType(26) As Integer
   Color Red, BBlue
   Print "Loading files."
   Color White, Black
   Max.Files = Max.Drives
   Max.Lines = 0&
   Max.File = 0&

   For VarZ = 0 To 1
      ' make filename
      If VarZ = 0 Then
         SpecDir$ = Current.Directory + SpecD$
      Else
         SpecDir$ = Current.Directory + SpecF$
      End If
      ASCIIZ = SpecDir$ + Chr$(0)
      Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
      If Wfile.Handle <> INVALID_HANDLE_VALUE Then
         ' filename loop
         Do
            ' check filename
            Attribute = finddata.dwFileAttributes
            Found = 0
            If (Attribute And &H10) = &H10 Then ' dir
               If VarZ = 0 Then
                  Found = True
               End If
            End If
            If (Attribute And &H10) = &H0 Then ' file
               If VarZ = 1 Then
                  Found = True
               End If
            End If
            If Found Then
               ' store filename
               Filename$ = finddata.cFileName
               Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

               ' check filename
               If Filename$ <> "." And Filename$ <> ".." Then
                  ' store long filename
                  If Max.Files >= MaxLong Then
                     Exit Do
                  End If
                  Max.Files = Max.Files + 1
                  ReDim _Preserve Filenames(Max.Files) As String
                  Filenames(Max.Files) = Filename$
                  ReDim _Preserve FileType(Max.Files) As Integer
                  FileType(Max.Files) = False ' file
                  If VarZ = False Then ' dir
                     FileType(Max.Files) = True
                  End If
               End If
            End If
         Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
         x = FindClose(Wfile.Handle)
      End If
   Next

   ' reload drives
   j = 0
   For i = 1 To 26
      If Len(DriveList(i)) Then
         j = j + 1
         Filenames(j) = Left$(DriveList(i), 3)
         FileType(j) = -2
      End If
   Next

   ' shell sort dirs and files
   Print "Sorting files."
   For VarZ = 0 To 1
      Num = Max.Files
      Span = Int(Num / 2)
      Do While Span > False
         For Start = Span To Num - 1
            For Element = (Start - Span + 1) To 1 Step -Span
               Sort.Column1$ = UCase$(RTrim$(Filenames(Element)))
               Sort.Column2$ = UCase$(RTrim$(Filenames(Element + Span)))
               If VarZ = False Then ' dir
                  If FileType(Element) = True And FileType(Element + Span) = True Then
                     If SortOrder2 = False Then ' descending
                        If Sort.Column2$ <= Sort.Column1$ Then
                           Exit For
                        End If
                     Else ' ascending
                        If Sort.Column1$ <= Sort.Column2$ Then
                           Exit For
                        End If
                     End If
                     Swap Filenames(Element), Filenames(Element + Span)
                  End If
               Else ' file
                  If FileType(Element) = False And FileType(Element + Span) = False Then
                     If SortOrder = False Then ' descending
                        If Sort.Column2$ <= Sort.Column1$ Then
                           Exit For
                        End If
                     Else ' ascending
                        If Sort.Column1$ <= Sort.Column2$ Then
                           Exit For
                        End If
                     End If
                     Swap Filenames(Element), Filenames(Element + Span)
                  End If
               End If
            Next
         Next
         Span = Int(Span / 2)
      Loop
   Next

   ' begin search menu loop
   Current.File = 1
   Current.Line = 1
   GoSub Display.Screen2
   Inpt2$ = Nul
   Drive.Counter = Timer
   Do
      If ControlBreak Then
         If SoundHandle <> 0 Then
            _SndStop SoundHandle
            _SndClose SoundHandle
            SoundHandle = 0
         End If
         Exit Do ' escape
      End If
      ' check current drive exists/added/removed.
      Counter.Elapsed = Timer - Drive.Counter
      If Counter.Elapsed < 0 Then Counter.Elapsed = Counter.Elapsed + 86400
      If Counter.Elapsed >= RefreshTimer Then
         Drive.Counter = Timer

         ' store current drive.
         Drive$ = Left$(Current.Directory, 3) + Chr$(0)
         Vname$ = Space$(MAX_PATH)
         Fname$ = Space$(MAX_PATH)

         ' check current drive.
         r = GetVolumeInformationA(Drive$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
         If r = 0 Then
            ' restart drive loop
            VarZ1 = 0
            GoTo Top.Loop
         End If

         ' check drive removed.
         Found1 = 0
         VarQ1$ = Nul
         For i = 1 To 26
            If DriveList(i) <> Nul Then
               f$ = Chr$(i + 64)
               VarZ$ = f$ + ":\" + Chr$(0)
               Vname$ = Space$(MAX_PATH)
               Fname$ = Space$(MAX_PATH)
               ' check drive
               r = GetVolumeInformationA(VarZ$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
               If r = 0 Then
                  VarQ1$ = VarQ1$ + Left$(VarZ$, 3) + " "
                  Found1 = True
               End If
            End If
         Next

         ' check drive added.
         Found2 = 0
         VarQ2$ = Nul
         For i = 1 To 26
            If DriveList(i) = Nul Then
               f$ = Chr$(i + 64)
               VarZ$ = f$ + ":\" + Chr$(0)
               Vname$ = Space$(MAX_PATH)
               Fname$ = Space$(MAX_PATH)
               ' check drive
               r = GetVolumeInformationA(VarZ$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
               If r Then
                  VarQ2$ = VarQ2$ + Left$(VarZ$, 3) + " "
                  Found2 = True
               End If
            End If
         Next

         ' check drive added/removed and restart drive loop.
         If Found1 Or Found2 Then
            If Found1 Then ' removed
               VarZ1 = -2
            End If
            If Found2 Then ' added
               VarZ1 = -3
            End If
            If Found1 And Found2 Then ' removed/added
               VarQ3$ = VarQ1$ + VarQ2$
               VarZ1 = -4
            End If
            GoTo Top.Loop
         End If
      End If

      Continue.Loop:
      Inpt2$ = InKeyx$
      If Inpt2$ = Chr$(3) Then ' ctrl-c
         _Delay DelayValue
         If ControlBreak Then Inpt2$ = Nul
      End If

      LengthIn = Len(Inpt2$)
      If LengthIn Then
         Select Case LengthIn
            Case 1
               VarQ = 0
               If Inpt2$ >= "a" And Inpt2$ <= "z" Then VarQ = True
               If Inpt2$ >= "A" And Inpt2$ <= "Z" Then VarQ = True
               If Inpt2$ >= "0" And Inpt2$ <= "9" Then VarQ = True
               If Inpt2$ = "@" Or Inpt2$ = "-" Or Inpt2$ = "+" Then VarQ = True
               ' scan filename
               StartSearch:
               If VarQ Then
                  ' store current position
                  Temp.Current.Item = Current.Item
                  Temp.Current.File = Current.File
                  Temp.Current.Line = Current.Line
                  ' scan current to right
                  If Temp.Current.File < Line.Length Then
                     For VarZ = Temp.Current.File To Line.Length - 1
                        If VarZ + 1 <= Max.Files Then
                           Temp.Current.File = VarZ + 1
                           Match = False
                           VarQ$ = Filenames(Temp.Current.File)
                           If VarQ = -2 Then
                              Call CheckFilename(Search.Filename$, VarQ$, Match)
                           End If
                           If VarQ = True Then
                              If Left$(VarQ$, 1) = Inpt2$ Then
                                 Match = True
                              End If
                           End If
                           If Match Then
                              Current.File = Temp.Current.File
                              GoSub Display.Screen2
                              VarQ = 0
                              Exit For
                           End If
                        End If
                     Next
                  End If
                  ' scan to next line
                  If VarQ Then
                     Temp.Current.File = Temp.Current.File + 1
                     Do While Temp.Current.File <= Max.Files
                        For VarZ = Temp.Current.File To Temp.Current.File + Line.Length
                           If VarZ <= Max.Files Then
                              Match = False
                              If VarQ = -2 Then
                                 VarQ$ = Filenames(VarZ)
                                 Call CheckFilename(Search.Filename$, VarQ$, Match)
                              End If
                              If VarQ = True Then
                                 If Left$(Filenames(VarZ), 1) = Inpt2$ Then
                                    Match = True
                                 End If
                              End If
                              If Match Then
                                 Current.File = VarZ
                                 Current.Line = Temp.Current.Line
                                 If Current.Line > Line.Length Then
                                    VarZ = Current.Line - Line.Length * 5
                                    If VarZ > 0 And VarZ <= Max.Files Then
                                       Current.Line = VarZ
                                    Else
                                       Current.Line = 1
                                    End If
                                 Else
                                    Current.Line = 1
                                 End If
                                 GoSub Display.Screen2
                                 VarQ = 0
                                 Exit Do
                              End If
                           End If
                        Next
                        Temp.Current.File = Temp.Current.File + Line.Length
                        Temp.Current.Line = Temp.Current.Line + Line.Length
                     Loop
                  End If
                  ' scan 1,1 to current
                  If VarQ Then
                     Temp.Current.File = 1
                     Temp.Current.Line = 1
                     Do While Temp.Current.File <= Current.File
                        For VarZ = Temp.Current.File To Temp.Current.File + Line.Length
                           If VarZ <= Max.Files Then
                              Match = False
                              If VarQ = -2 Then
                                 VarQ$ = Filenames(VarZ)
                                 Call CheckFilename(Search.Filename$, VarQ$, Match)
                              End If
                              If VarQ = True Then
                                 If Left$(Filenames(VarZ), 1) = Inpt2$ Then
                                    Match = True
                                 End If
                              End If
                              If Match Then
                                 Current.File = VarZ
                                 Current.Line = Temp.Current.Line
                                 GoSub Display.Screen2
                                 VarQ = 0
                                 Exit Do
                              End If
                           End If
                        Next
                        Temp.Current.File = Temp.Current.File + Line.Length
                        Temp.Current.Line = Temp.Current.Line + Line.Length
                     Loop
                  End If
               End If
               If Inpt2$ = Chr$(27) Then
                  If SoundHandle <> 0 Then
                     _SndStop SoundHandle
                     _SndClose SoundHandle
                     SoundHandle = 0
                  End If
                  Exit Do ' escape
               End If
               If Inpt2$ = TabS Then ' tab to right
                  If Current.Item < Line.Length Then
                     If Current.File + 1 <= Max.Files Then
                        Current.File = Current.File + 1
                        GoSub Display.Screen2
                     End If
                  End If
               End If
               If Inpt2$ = Chr$(16) Then ' ctrl-p pause/resume soundfile
                  If SoundHandle <> 0 Then
                     If _SndPaused(SoundHandle) = False Then
                        _SndPause SoundHandle
                     Else
                        _SndPlay SoundHandle
                     End If
                  End If
               End If
               If Inpt2$ = Chr$(17) Then ' ctrl-q set soundfile plus 10 seconds
                  If SoundHandle <> 0 Then
                     z2! = _SndGetPos(SoundHandle)
                     z2! = z2! + 10!
                     _SndSetPos SoundHandle, z2!
                  End If
               End If
               If Inpt2$ = Chr$(18) Then ' ctrl-r set soundfile minus 10 seconds
                  If SoundHandle <> 0 Then
                     z2! = _SndGetPos(SoundHandle)
                     z2! = z2! - 10!
                     If z2! < SFalse Then
                        z2! = SFalse
                     End If
                     If z2! >= SFalse Then
                        _SndSetPos SoundHandle, z2!
                     End If
                  End If
               End If
               If Inpt2$ = Chr$(4) Then ' ctrl-d change drive
                  Cls
                  Print "Enter drive(A-Z)";
                  Input Var$
                  Var$ = UCase$(Var$)
                  If Len(Var$) = 1 Then
                     If Var$ >= "A" And Var$ <= "Z" Then
                        Var$ = Var$ + ":\"
                        For Var = 1 To Max.Drives
                           If Filenames(Var) = Var$ Then
                              Current.Directory = Var$
                              GoTo Start.Loop
                           End If
                        Next
                     End If
                  End If
                  Print "Drive not found. Press key:";
                  x$ = Inkey2$
                  GoSub Display.Screen2
               End If
               If Inpt2$ = Chr$(6) Then ' ctrl-f refresh
                  VarZ1 = True
                  GoTo Top.Loop
               End If
               If Inpt2$ = Chr$(5) Then ' ctrl-e make dir
                  Cls
                  Print "Target dir";
                  Input Var$
                  If Var$ = Nul Then GoTo Start.Loop
                  If ValidFileChar(Var$) Then
                     Print "Illegal directory character. Press key:"
                     x$ = Inkey2$
                     GoTo Start.Loop
                  End If
                  Target$ = Current.Directory + Var$
                  If _FileExists(Target$) Then
                     Print "File already exists. Press key:";
                     x$ = Inkey2$: Print
                     GoSub Display.Screen2
                  Else
                     If _DirExists(Target$) Then
                        Print "Directory already exists. Press key:";
                        x$ = Inkey2$: Print
                        GoSub Display.Screen2
                     Else
                        f$ = Target$ + Chr$(0)
                        x = CreateDirectoryA(f$, 0)
                        If x = 0 Then
                           Print "Error 0x" + Hex$(GetLastError) + " creating directory."
                           Print DisplayWinError$(x); " Press key:";
                           x$ = Inkey2$: Print
                           GoSub Display.Screen2
                        Else
                           GoTo Start.Loop
                        End If
                     End If
                  End If
               End If
               If Inpt2$ = Chr$(7) Then ' ctrl-g renamefile
                  If Current.File Then
                     If FileType(Current.File) = -2 Then ' rename drive
                        Cls
                        Print "Cannot rename drive. Press key:"
                        x$ = Inkey2$
                        GoTo Start.Loop
                     End If
                     If FileType(Current.File) = False Then ' rename file
                        If Filenames(Current.File) > Nul Then
                           Cls
                           Print "Target file";
                           Input Var$
                           If Var$ = Nul Then GoTo Start.Loop
                           If ValidFileChar(Var$) Then
                              Print "Illegal filename character. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           Source$ = Current.Directory + Filenames(Current.File)
                           Target$ = Current.Directory + Var$
                           If _DirExists(Target$) Then
                              Print "Target directory already exists. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           If _FileExists(Target$) Then
                              Print "Target filename exists. Overwrite(y/n)";
                              x$ = Nul
                              Do
                                 x$ = InKeyx$
                                 If LCase$(x$) = "y" Then
                                    x$ = Target$ + Chr$(0)
                                    r = DeleteFileA(x$)
                                    Exit Do
                                 End If
                                 If LCase$(x$) = "n" Then GoTo Start.Loop
                              Loop
                           End If
                           f$ = Source$ + Chr$(0)
                           g$ = Target$ + Chr$(0)
                           x = MoveFile(f$, g$)
                           If x = 0 Then
                              Print "Error 0x" + Hex$(GetLastError) + " renaming filename."
                              Print DisplayWinError$(x); " Press key:";
                              x$ = Inkey2$
                           Else
                              Print "Filename renamed. Press key:"
                              x$ = Inkey2$
                           End If
                           GoTo Start.Loop
                        End If
                     End If
                     If FileType(Current.File) = True Then ' rename dir
                        If Filenames(Current.File) > Nul Then
                           Cls
                           Print "Target dir";
                           Input Var$
                           If Var$ = Nul Then GoTo Start.Loop
                           If InStr(Var$, "*") Then
                              Print "Illegal directory character. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           If InStr(Var$, "?") Then
                              Print "Illegal directory character. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           If ValidFileChar2$(Var$) = Nul Then
                              Print "Illegal directory character. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           Source$ = Current.Directory + Filenames(Current.File)
                           Target$ = Current.Directory + Var$
                           If _DirExists(Target$) Then
                              Print "Target directory already exists. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           If _FileExists(Target$) Then
                              Print "Target filename already exists. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           f$ = Source$ + Chr$(0)
                           g$ = Target$ + Chr$(0)
                           x = MoveFile(f$, g$)
                           If x = 0 Then
                              Print "Error 0x" + Hex$(GetLastError) + " renaming directory."
                              Print DisplayWinError$(x); " Press key:";
                              x$ = Inkey2$
                           Else
                              Print "Directory renamed. Press key:"
                              x$ = Inkey2$
                           End If
                           GoTo Start.Loop
                        End If
                     End If
                  End If
               End If
               If Inpt2$ = Chr$(3) Then ' ctrl-c copyfile
                  If Current.File Then
                     If FileType(Current.File) = False Then ' copy file
                        If Filenames(Current.File) > Nul Then
                           Cls
                           Print "Target file";
                           Input Var$
                           If Var$ = Nul Then GoTo Start.Loop
                           If ValidFileChar(Var$) Then
                              GoTo Start.Loop
                           End If
                           Source$ = Current.Directory + Filenames(Current.File)
                           Target$ = Current.Directory + Var$
                           If _DirExists(Target$) Then
                              Print "Target directory already exists. Press key:"
                              x$ = Inkey2$
                              GoTo Start.Loop
                           End If
                           If _FileExists(Target$) Then
                              Print "Target filename exists. Overwrite(y/n)";
                              x$ = Nul
                              Do
                                 x$ = InKeyx$
                                 If LCase$(x$) = "y" Then Exit Do
                                 If LCase$(x$) = "n" Then GoTo Start.Loop
                              Loop
                           End If
                           f$ = Source$ + Chr$(0)
                           g$ = Target$ + Chr$(0)
                           x = CopyFile(f$, g$, 0) ' 0=overwrite, -1=don't
                           Color Yellow
                           If x = 0 Then
                              Print "Error 0x" + Hex$(GetLastError) + " copying filename."
                              Print DisplayWinError$(x)
                           Else
                              Print "Filename copied."
                           End If
                           Call MorePrompt(MorePrompt4, " " + CR, Outpt$)
                        End If
                        GoTo Start.Loop
                     End If
                  End If
               End If
               If Inpt2$ = Chr$(8) Then ' backspace
                  Current.Directory = Left$(Current.Directory, Len(Current.Directory) - 1)
                  For Var = Len(Current.Directory) To 1 Step -1
                     If Mid$(Current.Directory, Var, 1) = "\" Then
                        Current.Directory = Left$(Current.Directory, Var - 1)
                        Exit For
                     End If
                  Next
                  If Right$(Current.Directory, 1) <> "\" Then
                     Current.Directory = Current.Directory + "\"
                  End If
                  Cls
                  GoTo Start.Loop
               End If
               If Inpt2$ = Chr$(13) Then ' enter
                  If Current.File Then
                     If FileType(Current.File) = -2 Then ' move to drive
                        Current.Directory = Filenames(Current.File)
                        Cls
                        GoTo Start.Loop
                     Else
                        If FileType(Current.File) = True Then ' move to directory
                           Current.Directory = Current.Directory + Filenames(Current.File) + "\"
                           Cls
                           GoTo Start.Loop
                        Else
                           If Filenames(Current.File) > Nul Then
                              Cls
                              Strng$ = Filenames(Current.File)
                              Var$ = Strng$

                              ' play a music file.
                              If VerifyPlay(Strng$) Then
                                 Color Yellow
                                 Var2$ = Current.Directory + Filenames(Current.File)
                                 If SoundHandle <> 0 Then
                                    _SndStop SoundHandle
                                    _SndClose SoundHandle
                                 End If
                                 Print "Loading file: "; Var$
                                 SoundHandle = _SndOpen(Var2$) ' get file handle
                                 If SoundHandle <> 0 Then
                                    S& = _SndLen(SoundHandle)
                                    S$ = Str$(S&)
                                    If InStr(S$, ".") Then
                                       S$ = Left$(S$, InStr(S$, ".") + 2)
                                    End If
                                    Print "Handle"; SoundHandle; "is"; S$; " seconds."
                                    _SndPlay SoundHandle
                                 Else
                                    GoTo Next.Loop2
                                 End If
                                 Color White
                                 Call MorePrompt(MorePrompt4, " " + CR, Output.Char$)
                                 GoTo Start.Loop
                              End If
                              Next.Loop2:
                              ' edit a file.
                              Print "Edit " + Quote + Strng$ + Quote + "(y/n)?";
                              x$ = Nul
                              Do
                                 x$ = InKeyx$
                                 If LCase$(x$) = "n" Then
                                    Print
                                    GoSub Display.Screen2
                                    Exit Do
                                 End If
                                 If LCase$(x$) = "y" Then
                                    Print
                                    Strng$ = Current.Directory + Filenames(Current.File)
                                    Timer(t6) Off
                                    Call Scrnedit2(Strng$, -1)
                                    Timer(t6) On
                                    GoTo Start.Loop
                                 End If
                              Loop
                           End If
                        End If
                     End If
                  End If
               End If
            Case 2
               Inpt2 = Asc(Right$(Inpt2$, 1))
               Select Case Inpt2
                  Case 59 ' F1 - edit about file
                     VarZ2$ = StartDir$ + "scrnedit.txt"
                     If _FileExists(VarZ2$) Then
                        Timer(t6) Off
                        Call Scrnedit2(VarZ2$, 0)
                        Timer(t6) On
                        Color White, Black
                        GoSub Display.Screen2
                     Else
                        VarZ2$ = CurrentDirectory
                        If Right$(VarZ2$, 1) <> "\" Then VarZ2$ = VarZ2$ + "\"
                        VarZ2$ = VarZ2$ + "scrnedit.txt"
                        If _FileExists(VarZ2$) Then
                           Timer(t6) Off
                           Call Scrnedit2(VarZ2$, 0)
                           Timer(t6) On
                           Color White, Black
                           GoSub Display.Screen2
                        End If
                     End If
                  Case 60 ' F2 - restart input loop
                     VarZ1 = True
                     GoTo Top.Loop
                  Case 61 ' F3 - search filename
                     Cls
                     Print "Edit filespec(?, *, ^ allowed)";
                     Input Search.Filename$
                     If Search.Filename$ = Nul Then GoTo Start.Loop
                     Color White, Black
                     GoSub Display.Screen2
                     VarQ = -2
                     GoTo StartSearch
                  Case 96 ' Ctrl-F3 - repeat search
                     If Len(Search.Filename$) Then
                        VarQ = -2
                        GoTo StartSearch
                     End If
                  Case 62 ' F4 - toggle file sort order
                     SortOrder = Not SortOrder
                     Cls
                     GoTo Start.Loop
                  Case 63 ' F5 - toggle dir sort order
                     SortOrder2 = Not SortOrder2
                     Cls
                     GoTo Start.Loop
                  Case 64 ' F6 - recurse searchfiles
                     Call SearchFiles("")
                     Cls
                     GoTo Start.Loop
                  Case 73 ' pageup
                     For VarQ = 1 To Max.Row - 1
                        If Current.File - Line.Length < Current.Line Then
                           If Current.Line - Line.Length >= 1 Then
                              Current.File = Current.File - Line.Length
                              Current.Line = Current.Line - Line.Length
                           End If
                        Else
                           If Current.File - Line.Length >= 1 Then
                              Current.File = Current.File - Line.Length
                           Else
                              Current.File = 1
                              Current.Line = 1
                              Exit For
                           End If
                        End If
                     Next
                     GoSub Display.Screen2
                  Case 81 ' pagedown
                     For VarQ = 1 To Max.Row - 1
                        Max.Items = (Max.Row - 1) * Line.Length
                        If Current.File + Line.Length <= Max.Items Then
                           If Current.File + Line.Length <= Max.Files Then
                              Current.File = Current.File + Line.Length
                           End If
                        Else
                           If Current.File + Line.Length <= Max.Files Then
                              Current.File = Current.File + Line.Length
                              Current.Line = Current.Line + Line.Length
                           Else
                              Current.File = Current.File + Line.Length
                              If Current.File > Max.Files Then
                                 Current.File = Max.Files
                                 Exit For
                              End If
                           End If
                        End If
                     Next
                     GoSub Display.Screen2
                  Case 119 ' ctrl-home
                     Current.File = 1
                     Current.Line = 1
                     GoSub Display.Screen2
                  Case 117 ' ctrl-end
                     If Max.Files <= (Max.Row - 1) * Line.Length Then
                        ' perform page-down if max row less than one page length
                        For VarQ = 1 To Max.Row - 1
                           Max.Items = (Max.Row - 1) * Line.Length
                           If Current.File + Line.Length <= Max.Items Then
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                              End If
                           Else
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                                 Current.Line = Current.Line + Line.Length
                              Else
                                 Current.File = Current.File + Line.Length
                                 If Current.File > Max.Files Then
                                    Current.File = Max.Files
                                    Exit For
                                 End If
                              End If
                           End If
                        Next
                        GoSub Display.Screen2
                     Else
                        ' jump to end of max rows page length
                        Max.Items = (Max.Row - 1) * Line.Length
                        Do Until Current.File >= Max.Files
                           If Current.File + Line.Length <= Max.Items Then
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                              End If
                           Else
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                                 Current.Line = Current.Line + Line.Length
                              Else
                                 Current.File = Current.File + Line.Length
                                 If Current.File >= Max.Files Then
                                    Current.File = Max.Files
                                    Exit Do
                                 End If
                              End If
                           End If
                        Loop
                     End If
                     ' move to last item in last page
                     If Max.Files > 0 Then
                        Current.File = Max.Files
                        GoSub Display.Screen2
                     End If
                  Case 83 ' delete
                     If Current.File Then
                        If Filenames(Current.File) > Nul Then
                           If FileType(Current.File) = -2 Then ' delete drive
                              Cls
                              Print "Delete drive(y/n)?";
                              Do
                                 x$ = InKeyx$
                                 If LCase$(x$) = "n" Then Exit Do
                                 If LCase$(x$) = "y" Then
                                    File$ = Filenames(Current.File)
                                    If File$ > Nul Then
                                       If Right$(File$, 1) <> "\" Then File$ = File$ + "\"
                                       Call Silentdel_Directories(File$)
                                    End If
                                    Cls
                                    GoTo Start.Loop
                                 End If
                              Loop
                              GoSub Display.Screen2
                           Else
                              If FileType(Current.File) = True Then ' delete dir
                                 Cls
                                 Print "Delete dir(y/n)?";
                                 Do
                                    x$ = InKeyx$
                                    If LCase$(x$) = "n" Then Exit Do
                                    If LCase$(x$) = "y" Then
                                       File$ = Current.Directory + Filenames(Current.File)
                                       If File$ > Nul Then
                                          If Right$(File$, 1) <> "\" Then File$ = File$ + "\"
                                          Call Silentdel_Directories(File$)
                                       End If
                                       Cls
                                       GoTo Start.Loop
                                    End If
                                 Loop
                                 GoSub Display.Screen2
                              Else
                                 If FileType(Current.File) = False Then ' delete file
                                    Cls
                                    Print "Delete file(y/n)?";
                                    Do
                                       x$ = InKeyx$
                                       If LCase$(x$) = "n" Then Exit Do
                                       If LCase$(x$) = "y" Then
                                          File$ = Current.Directory + Filenames(Current.File)
                                          If File$ > Nul Then
                                             x$ = File$ + Chr$(0)
                                             r = DeleteFileA(x$)
                                          End If
                                          Cls
                                          GoTo Start.Loop
                                       End If
                                    Loop
                                    GoSub Display.Screen2
                                 End If
                              End If
                           End If
                        End If
                     End If
                  Case 71 ' home
                     Do
                        If Current.Item > 1 Then
                           Current.File = Current.File - 1
                           GoSub Display.Screen2
                        Else
                           Exit Do
                        End If
                     Loop
                  Case 79 ' end
                     Do
                        If Current.Item < Line.Length Then
                           If Current.File + 1 <= Max.Files Then
                              Current.File = Current.File + 1
                              GoSub Display.Screen2
                           Else
                              Exit Do
                           End If
                        Else
                           Exit Do
                        End If
                     Loop
                  Case 82 ' insert
                     Cls
                     Timer(t6) Off
                     g$ = _SaveFileDialog$("SICK open file", _CWD$)
                     If Len(g$) Then
                        Call Scrnedit2(g$, -1)
                     End If
                     Timer(t6) On
                     GoTo Start.Loop
                  Case 72, 141 ' up/ctrl-up
                     If Current.File > 1 Then
                        VarX = 0
                        For VarQ = 0 To Line.Length - 1
                           If Current.File - VarQ = Current.Line Then
                              If Current.Line - Line.Length >= 1 Then
                                 Current.File = Current.File - Line.Length
                                 Current.Line = Current.Line - Line.Length
                              End If
                              If Current.File < 1 Then
                                 Current.File = 1
                              End If
                              If Current.Line < 1 Then
                                 Current.Line = 1
                              End If
                              VarX = True
                              Color White, Black
                              GoSub Display.Screen2
                              Exit For
                           End If
                        Next
                        If VarX = False Then
                           If Current.File - Line.Length >= 1 Then
                              Current.File = Current.File - Line.Length
                              If Current.File < Current.Line Then
                                 Current.Line = Current.Line - Line.Length
                                 If Current.Line < 1 Then
                                    Current.Line = 1
                                 End If
                              End If
                              Color White, Black
                              GoSub Display.Screen2
                           Else
                              Current.File = 1
                              Current.Line = 1
                              Color White, Black
                              GoSub Display.Screen2
                           End If
                        End If
                     End If
                  Case 80, 145 ' down/ctrl-down
                     Max.Items = (Max.Row - 1) * Line.Length ' length of a page
                     Max.Items2 = Current.Line + Max.Items - Line.Length ' length of last line on a page
                     If Max.Items2 > Max.Files Then
                        Max.Items2 = Max.Files
                     End If
                     If Max.Items2 < 1 Then
                        Max.Items2 = 1
                     End If
                     If Current.File + Line.Length <= Max.Items Then
                        If Current.File + Line.Length <= Max.Files Then
                           Current.File = Current.File + Line.Length
                           GoSub Display.Screen2
                        End If
                     Else
                        If Current.File + Line.Length <= Max.Files Then
                           Current.File = Current.File + Line.Length
                           If Current.File > Max.Items2 Then
                              If Current.Line + Line.Length <= Max.Files Then
                                 Current.Line = Current.Line + Line.Length
                              End If
                           End If
                           GoSub Display.Screen2
                        Else
                           Current.File = Current.File + Line.Length
                           If Current.File > Max.Files Then
                              Current.File = Max.Files
                              GoSub Display.Screen2
                           End If
                        End If
                     End If
                  Case 15, 75, 115 ' shift-tab/left/ctrl-left
                     If Current.Item > 1 Then
                        Current.File = Current.File - 1
                        GoSub Display.Screen2
                     End If
                  Case 77, 116 ' right/ctrl-right
                     If Current.Item < Line.Length Then
                        If Current.File + 1 <= Max.Files Then
                           Current.File = Current.File + 1
                           GoSub Display.Screen2
                        End If
                     End If
               End Select
         End Select
      End If
   Loop
   Exit Sub

   ' redraw file menu screen.
   Display.Screen2:
   Cls
   CursorX = 1
   CursorY = 1
   Line1z = 0
   Line2z = 0
   Found = 0
   For VarZ = Current.Line To Max.Files
      Line2z = Line2z + 1
      If Line2z > Line.Length Then
         Line2z = 1
         Line1z = Line1z + 1
         If Line1z >= Max.Row - 1 Then
            Exit For
         End If
         Print
      End If
      StrngZ$ = Filenames(VarZ)
      Var$ = StrngZ$
      ' display drive
      If FileType(VarZ) = -2 Then
         If Len(StrngZ$) > 12 Then
            StrngZ$ = Left$(StrngZ$, 11) + "*"
         End If
         StrngZ$ = StrngZ$ + Space$(15 - Len(StrngZ$))
      End If
      ' display directory
      If FileType(VarZ) = True Then
         Found = True
         If Len(StrngZ$) > 12 Then
            StrngZ$ = Left$(StrngZ$, 11) + "*"
         End If
         StrngZ$ = "[" + StrngZ$ + "]"
         StrngZ$ = StrngZ$ + Space$(15 - Len(StrngZ$))
      End If
      ' display filename
      If FileType(VarZ) = False Then
         Found = True
         If Len(StrngZ$) > 12 Then
            StrngZ$ = Left$(StrngZ$, 11) + "*"
         End If
         StrngZ$ = StrngZ$ + Space$(15 - Len(StrngZ$))
      End If
      ' hilight current file
      If VarZ = Current.File Then
         Current.Item = Line2z
         Color White, BBlue
         ' detect file exstension.
         If FileType(VarZ) = False Then
            If VerifyPlay(Var$) Then ' music file.
               Color Green, BBlue
            End If
            If VerifyFile(Var$) Then ' system file.
               Color Red, BBlue
            End If
            If VerifyFile2(Var$) Then ' library file.
               Color Yellow, BBlue
            End If
            If VerifyFile3(Var$) Then ' source file.
               Color Green, Black
            End If
            If VerifyFile4(Var$) Then ' document file.
               Color Red, Black
            End If
            If VerifyFile5(Var$) Then ' compressed file.
               Color Yellow, Black
            End If
         End If
         Print StrngZ$;
         StoreX = CsrLin: StoreY = Pos(0)
         If FileType(VarZ) = -2 Then ' drive
            Drive = Asc(Left$(Var$, 1)) - 64
            VarQ$ = DriveList(Drive)
            VarZ$ = Left$(VarQ$, 1) + ":\" + Chr$(0)
            r = GetDiskFreeSpaceExA(VarZ$, free~&&, total~&&, free2~&&)
            If r Then
               VarQ# = CDbl(total~&&)
               Var$ = FormatString$(VarQ#) + " bytes"
               VarQ$ = VarQ$ + " (" + Var$ + ")"
            End If
            TempX$ = "Editor > drive: " + VarQ$
         Else
            If FileType(VarZ) = True Then ' dir
               TempX$ = "Editor > dir: " + Current.Directory + Var$

               f$ = Current.Directory + Var$
               ext$ = "*.*"
               x# = CountFiles2#(f$, ext$)

               f$ = Current.Directory + Var$
               ext$ = "*.*"
               z# = CountDirs2#(f$, ext$)

               z$ = " (" + LTrim$(FormatString$(z#)) + " dirs "
               z$ = z$ + LTrim$(FormatString$(x#)) + " files)"
               If Len(TempX$ + z$) < Width2 Then
                  TempX$ = TempX$ + z$
               End If
            Else ' file
               TempX$ = "Editor > file: " + Current.Directory + Var$
               DirN$ = Current.Directory
               FileN$ = Current.Directory + Var$
               If _FileExists(FileN$) Then
                  x# = CountBytes2#(DirN$, Var$)
                  z$ = " (" + LTrim$(FormatString$(x#)) + " bytes)"
                  If Len(TempX$ + z$) < Width2 Then
                     TempX$ = TempX$ + z$
                  End If
                  If VerifyPlay(Var$) Then ' music file.
                     z$ = " (sound file)"
                     If Len(TempX$ + z$) < Width2 Then
                        TempX$ = TempX$ + z$
                     End If
                  End If
                  If VerifyFile(Var$) Then ' system file.
                     z$ = " (system file)"
                     If Len(TempX$ + z$) < Width2 Then
                        TempX$ = TempX$ + z$
                     End If
                  End If
                  If VerifyFile2(Var$) Then ' library file.
                     z$ = " (library file)"
                     If Len(TempX$ + z$) < Width2 Then
                        TempX$ = TempX$ + z$
                     End If
                  End If
                  If VerifyFile3(Var$) Then ' source file.
                     z$ = " (source file)"
                     If Len(TempX$ + z$) < Width2 Then
                        TempX$ = TempX$ + z$
                     End If
                  End If
                  If VerifyFile4(Var$) Then ' document file.
                     z$ = " (document file)"
                     If Len(TempX$ + z$) < Width2 Then
                        TempX$ = TempX$ + z$
                     End If
                  End If
                  If VerifyFile5(Var$) Then ' document file.
                     z$ = " (compressed file)"
                     If Len(TempX$ + z$) < Width2 Then
                        TempX$ = TempX$ + z$
                     End If
                  End If
               End If
            End If
         End If
         TempX$ = Left$(TempX$, Width2)
         TempX$ = TempX$ + Space$(Width2 - Len(TempX$))
         Call DisplayStatusLine2(-1, TempX$)
         Locate StoreX, StoreY, 1
         CursorX = CsrLin
         CursorY = Pos(0) - 15
         If CursorY < 1 Then CursorY = 1
      Else
         Color White, Black
         Print StrngZ$;
      End If
   Next
   If Found = False Then
      Print
      If Line.Length = 40 Then
         Print "File not found. Press F2";
      Else
         Print "File not found. Press F2 to reload file spec.";
      End If
   End If
   Locate CursorX, CursorY, 1
   Return
End Sub

' main fullscreen editor
Sub Scrnedit2 (OutX$, InptX)
   Const Nul = ""
   Const TabStop = 8
   Dim Byte As String * 1
   Dim FileVar As String * MaxInt
   Dim Max.Row As Integer
   Dim Width1 As Integer
   Dim Width2 As Integer
   Dim Width3 As Integer
   Dim VarY As String * MaxInt
   Dim LineX As String
   Dim Temp.ArrayS(1) As String
   Dim Max.Lines As Long
   Dim Max.File As Long
   Inserting = True

   ' setup screen.
   Max.Row = ScreenHeight
   Width1 = ScreenWidth
   Width2 = Width1 - 1
   Width3 = Width1 - 2
   Cls
   Width Width1, Max.Row

   ' parse and open filename.
   Filename$ = OutX$
   If Left$(Filename$, 1) = Quote Then
      Filename$ = Mid$(Filename$, 2)
      If Right$(Filename$, 1) = Quote Then
         Filename$ = Left$(Filename$, Len(Filename) - 1)
      End If
   End If
   File5 = FreeFile
   Close #File5
   If Filename$ = Nul Then
      Exit Sub
   End If
   If InStr(Filename$, "?") Then
      Exit Sub
   End If
   If InStr(Filename$, "*") Then
      Exit Sub
   End If
   If _FileExists(Filename$) Then
      Max.Lines = 0
      Var& = 0&
      LineX = Nul
      VarD = 0
      VarE = 0
      VarF! = Timer
      LINUXLoad = False
      If AvoidLINUX = False Then
         If InptX Then
            Print "Edit file in Linux read mode(y/n/q)? ";
            Do
               X$ = InKeyx$
               If LCase$(X$) = "y" Then Print: LINUXLoad = True: Exit Do
               If LCase$(X$) = "n" Then Print: LINUXLoad = False: Exit Do
               If LCase$(X$) = "q" Then Print: LINUXLoad = False: Exit Sub
            Loop
         End If
      End If
      If LINUXLoad = False Then
         Open Filename$ For Input As #File5 ' read file in text
         StatusLine1 = Dfalse
         StatusLine2 = LOF(File5)
         Do While EOF(File5) = 0
            Call Dot.Display(VarD, VarE, VarF!)
            Line Input #File5, LineX
            If Max.Lines >= MaxLong Then
               Print "Out of memory."; MaxLong; "lines."
               Print "Edit partial file anyway(y/n)?";
               Do
                  X$ = InKeyx$
                  If LCase$(X$) = "y" Then Print "y": GoTo ContinueLoop3
                  If LCase$(X$) = "n" Then Print "n": Exit Do
               Loop
               Close #File5
               Erase Temp.ArrayS
               Exit Sub
            End If
            Max.Lines = Max.Lines + 1
            ReDim _Preserve Temp.ArrayS(Max.Lines) As String
            Temp.ArrayS(Max.Lines) = LineX
            StatusLine1 = StatusLine1 + Len(LineX)
         Loop
         ContinueLoop3:
      Else
         Open Filename$ For Binary As #File5 Len = MaxInt ' read file in binary
         StatusLine1 = Dfalse
         StatusLine2 = LOF(File5)
         Buffer$ = Nul
         Do Until EOF(File5)
            Call Dot.Display(VarD, VarE, VarF!)
            Get #File5, , VarY
            If InKeyx$ = Chr$(27) Then
               Close #File5
               Erase Temp.ArrayS
               Exit Sub
            End If
            For VarZ = 1 To Len(VarY)
               If Mid$(VarY, VarZ, 1) = CR Then
                  ' ignore cr
               Else
                  If Mid$(VarY, VarZ, 1) = LF Then ' check lf
                     If Max.Lines >= MaxLong Then
                        Print "Out of memory."; MaxLong; "lines."
                        Print "Edit partial file anyway(y/n)?";
                        Do
           