Rem Analyze.bas v64.0a r8.6a - Symbolic Instruction Code Kit; analyze module.

' get standard include declarations
Rem $Include: 'SIC16.INC'

' declare global error routine
On Error GoTo Error.Routine

Color White, Black
Print "Analyze v" + Version + " r" + Release + ":"

' adjust array size
Max.Lines = 4096
100
Print "Array size is:"; Max.Lines
Print "Increase array size(y/n)?";
Do
   X$ = InKey$
   If UCase$(X$) = "N" Then Print: Exit Do
   If UCase$(X$) = "Y" Then
      Print
      Print "Enter value(4096-32766)";
      Input X
      If X >= 4096 And X <= 32766 Then Max.Lines = X
      Exit Do
   End If
Loop

' program code
ReDim Program(1 To Max.Lines) As String

' initialize variables
White.Space = Chr$(32) + Chr$(9)

' run program from command line
Filename = Command$
StartLoop:
If Len(Filename) = False Then
   Print "Enter .sic filename";
   Input Filename
End If
If InStr(Filename, "?") Or InStr(Filename, "*") Then
   Shell "dir *.sic /p"
   Filename = ""
   GoTo StartLoop
End If
If Filename = Nul Then
   GoTo Boot.Usage
End If
Call New.Program
Call Read.Program
Call Prepare.Program
Call Analyze.Program
Error.Resume:
Color Plain, Black
While InKey$ <> Nul
Wend
Print "Exiting to system.."
End

Boot.Usage:
Color White, Black
Print "Analyze v" + Version + " r" + Release + "; Usage:"
Color Yellow, Black
Print "Analyze <program name>"
Print "   Analyzes program specified on command line."
Color Plain, Black
End

' standard error trap for all Sic functions.
Error.Routine:
If Pos(0) > 1 Then
   Print
End If
Color White, Black
Print "Analyze utility error";
Select Case Err
   Case 9 ' subscript out of range
      Print
      Print "Array size error."
      Max.Lines = 4096
      Resume 100
   Case 52, 53
      Print ": File not found."
   Case 70
      Print ": File is read-only."
   Case Else
      Print Err
End Select
Resume Error.Resume

' all remaining data statements declare
' analyze functions types and pairs
AnalyzeData1:
Data "IF","ENDIF"
Data "DO","LOOP"
Data "FOR","NEXT"
Data "WHILE","WEND"
Data "FORIF","NEXTIF"
Data "LOOPIF","END LOOPIF"
Data "SELECT CASE","END SELECT"
Data "SELECTIF CASE","END SELECTIF"

AnalyzeData2:
Data "IF","ENDIF","ELSE","ELSEIF"
Data "SELECT CASE","END SELECT","CASE ELSE","CASE"
Data "SELECTIF CASE","END SELECTIF","CASEIF ELSE","CASEIF"

AnalyzeData3:
Data "DO","LOOP","EXIT DO","CONTINUE DO"
Data "FOR","NEXT","EXIT FOR","CONTINUE FOR"
Data "WHILE","WEND","EXIT WHILE","CONTINUE WHILE"
Data "FORIF","NEXTIF","EXIT FORIF","CONTINUE FORIF"
Data "LOOPIF","END LOOPIF","EXIT LOOPIF","CONTINUE LOOPIF"

Rem $Dynamic
' check validity of program
Sub Analyze.Program
   Color Yellow, Black
   Call Count.Lines(Last.Line)
   Print "Pass 1: Counting matching structures."
   Restore AnalyzeData1
   For Data.Count = 1 To 8
      Read Start.Structure$, Stop.Structure$
      Nested.Count = False
      For Program.Line = 1 To Last.Line
         Out2 = Program(Program.Line)
         Out2 = STRIM$(Out2)
         If Len(Out2) Then
            Temp1$ = STRIM$(Out2)
            Temp1$ = UCase$(Temp1$)
            Count.Data1 = False
            If Left$(Temp1$, Len(Start.Structure$)) = Start.Structure$ Then
               Count.Data1 = True
            End If
            If Start.Structure$ = "FOR" Then
               If Left$(Temp1$, 5) = "FORIF" Then
                  Count.Data1 = False
               End If
            End If
            If Count.Data1 Then
               Nested.Count = Nested.Count + 1
            End If
            If Start.Structure$ = "IF" Then
               If Left$(Temp1$, 6) = "END IF" Then
                  Nested.Count = Nested.Count - 1
                  If Nested.Count < False Then
                     Print "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
                     Exit Sub
                  End If
               End If
            End If
            If Stop.Structure$ = "LOOP" Then
               If Left$(Temp1$, 6) <> "LOOPIF" Then
                  Temp1$ = Left$(Temp1$, 4)
               End If
            End If
            If Stop.Structure$ = "NEXT" Then
               If Left$(Temp1$, 6) <> "NEXTIF" Then
                  Temp1$ = Left$(Temp1$, 4)
               End If
            End If
            If Stop.Structure$ = "END SELECT" Then
               If Left$(Temp1$, 12) <> "END SELECTIF" Then
                  Temp1$ = Left$(Temp1$, 10)
               End If
            End If
            If Temp1$ = Stop.Structure$ Then
               Nested.Count = Nested.Count - 1
               If Nested.Count < False Then
                  Print "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   Print "Pass 2: Counting matching imbedded structures."
   Restore AnalyzeData2
   For Data.Count = 1 To 3
      Read Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
      Nested.Count = False
      For Program.Line = 1 To Last.Line
         Out2 = Program(Program.Line)
         Out2 = STRIM$(Out2)
         If Len(Out2) Then
            Temp1$ = STRIM$(Out2)
            Temp1$ = UCase$(Temp1$)
            If Left$(Temp1$, Len(Start.Structure$)) = Start.Structure$ Then
               Nested.Count = Nested.Count + 1
            End If
            If Left$(Temp1$, Len(Imbedded1$)) = Imbedded1$ Then
               Nested.Count = Nested.Count - 1
               If Nested.Count < False Then
                  Print "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
               Nested.Count = Nested.Count + 1
            Else
               Temp2$ = Temp1$
               If Imbedded2$ <> "ELSEIF" Then
                  If Left$(Temp1$, Len(Imbedded2$)) = Imbedded2$ Then
                     Imbedded3 = InStr(Temp1$, " ")
                     If Imbedded3 = False Then
                        Print "Analyze error, pass 2: Bad "; Imbedded2$; ": Line:"; Program.Line
                        Exit Sub
                     End If
                     Temp2$ = Left$(Temp1$, Imbedded3 - 1)
                  End If
               End If
               If Temp2$ = Imbedded2$ Then
                  Nested.Count = Nested.Count - 1
                  If Nested.Count < False Then
                     Print "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
                     Exit Sub
                  End If
                  Nested.Count = Nested.Count + 1
               End If
            End If
            If Start.Structure$ = "IF" Then
               If Left$(Temp1$, 6) = "END IF" Then
                  Nested.Count = Nested.Count - 1
                  If Nested.Count < False Then
                     Print "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
                     Exit Sub
                  End If
               End If
            End If
            If Temp1$ = Stop.Structure$ Then
               Nested.Count = Nested.Count - 1
               If Nested.Count < False Then
                  Print "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   Print "Pass 3: Multipass structure match."
   Restore AnalyzeData1
   For Data.Count = 1 To 8
      Read Start.Structure$, Stop.Structure$
      For Program.Line = 1 To Last.Line
         Out2 = Program(Program.Line)
         Out2 = STRIM$(Out2)
         If Len(Out2) Then
            Temp1$ = STRIM$(Out2)
            Temp1$ = UCase$(Temp1$)
            Count.Data1 = False
            If Left$(Temp1$, Len(Start.Structure$)) = Start.Structure$ Then
               Count.Data1 = True
            End If
            If Start.Structure$ = "FOR" Then
               If Left$(Temp1$, 5) = "FORIF" Then
                  Count.Data1 = False
               End If
            End If
            If Count.Data1 Then
               Nested.Count = 1
               For Nested.Lines = Program.Line + 1 To Last.Line
                  Temp2$ = Program(Nested.Lines)
                  Temp2$ = STRIM$(Temp2$)
                  If Len(Temp2$) Then
                     Temp2$ = STRIM$(Temp2$)
                     Temp2$ = UCase$(Temp2$)
                     Count.Data2 = False
                     If Left$(Temp2$, Len(Start.Structure$)) = Start.Structure$ Then
                        Count.Data2 = True
                     End If
                     If Start.Structure$ = "FOR" Then
                        If Left$(Temp2$, 5) = "FORIF" Then
                           Count.Data2 = False
                        End If
                     End If
                     If Count.Data2 Then
                        Nested.Count = Nested.Count + 1
                     End If
                     If Stop.Structure$ = "LOOP" Then
                        If Left$(Temp2$, 6) <> "LOOPIF" Then
                           Temp2$ = Left$(Temp2$, 4)
                        End If
                     End If
                     If Stop.Structure$ = "NEXT" Then
                        If Left$(Temp2$, 6) <> "NEXTIF" Then
                           Temp2$ = Left$(Temp2$, 4)
                        End If
                     End If
                     If Stop.Structure$ = "END SELECT" Then
                        If Left$(Temp1$, 12) <> "END SELECTIF" Then
                           Temp1$ = Left$(Temp1$, 10)
                        End If
                     End If
                     If Temp2$ = Stop.Structure$ Then
                        Nested.Count = Nested.Count - 1
                        If Nested.Count = False Then
                           Exit For
                        End If
                     End If
                     If Start.Structure$ = "IF" Then
                        If Left$(Temp2$, 6) = "END IF" Then
                           Nested.Count = Nested.Count - 1
                           If Nested.Count = False Then
                              Exit For
                           End If
                        End If
                     End If
                  End If
               Next
               If Nested.Count <> False Then
                  Print "Analyze error, pass 3: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   Print "Pass 4: Multipass imbedded struture match."
   Restore AnalyzeData2
   For Data.Count = 1 To 3
      Read Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
      For Program.Line = 1 To Last.Line
         Out2 = Program(Program.Line)
         Out2 = STRIM$(Out2)
         If Len(Out2) Then
            Temp1$ = STRIM$(Out2)
            Temp1$ = UCase$(Temp1$)
            If Left$(Temp1$, Len(Start.Structure$)) = Start.Structure$ Then
               Total.Nested1 = 1
               Total.Nested2 = 0
               Nested.Count1 = 1
               Nested.Count2 = 0
               For Nested.Lines = Program.Line + 1 To Last.Line
                  Temp2$ = Program(Nested.Lines)
                  Temp2$ = STRIM$(Temp2$)
                  If Len(Temp2$) Then
                     Temp2$ = STRIM$(Temp2$)
                     Temp2$ = UCase$(Temp2$)
                     If Left$(Temp2$, Len(Start.Structure$)) = Start.Structure$ Then
                        Total.Nested1 = Total.Nested1 + 1
                        Nested.Count1 = Nested.Count1 + 1
                     End If
                     If Temp2$ = Stop.Structure$ Then
                        Total.Nested2 = Total.Nested2 - 1
                        Nested.Count1 = Nested.Count1 - 1
                        If Nested.Count1 = 0 Then
                           Exit For
                        End If
                     End If
                     If Start.Structure$ = "IF" Then
                        If Left$(Temp2$, 6) = "END IF" Then
                           Nested.Count1 = Nested.Count1 - 1
                           If Nested.Count1 = 0 Then
                              Exit For
                           End If
                        End If
                     End If
                     If Left$(Temp2$, Len(Imbedded1$)) = Imbedded1$ Then
                        Nested.Count2 = Nested.Count2 + 1
                        If Nested.Count2 > Nested.Count1 Then
                           Print "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                           Exit Sub
                        End If
                        Nested.Count2 = Nested.Count2 - 1
                     Else
                        Temp3$ = Temp2$
                        If Imbedded2$ <> "ELSEIF" Then
                           If Left$(Temp2$, Len(Imbedded2$)) = Imbedded2$ Then
                              Imbedded3 = InStr(Temp2$, " ")
                              If Imbedded3 = False Then
                                 Print "Analyze error, pass 4: Bad "; Imbedded2$; ": Line:"; Program.Line
                                 Exit Sub
                              End If
                              Temp3$ = Left$(Temp2$, Imbedded3 - 1)
                           End If
                        End If
                        If Temp3$ = Imbedded2$ Then
                           Nested.Count2 = Nested.Count2 + 1
                           If Nested.Count2 > Nested.Count1 Then
                              Print "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                              Exit Sub
                           End If
                           Nested.Count2 = Nested.Count2 - 1
                        End If
                     End If
                  End If
               Next
               If Total.Nested2 > Total.Nested1 Then
                  Print "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   Print "Pass 5: Single pass imbedded control structure match."
   Restore AnalyzeData3
   For Data.Count = 1 To 5
      Read Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
      Nested.Count = False
      For Program.Line = 1 To Last.Line
         Out2 = Program(Program.Line)
         Out2 = STRIM$(Out2)
         If Len(Out2) Then
            Temp1$ = STRIM$(Out2)
            Temp1$ = UCase$(Temp1$)
            Count.Data1 = False
            If Left$(Temp1$, Len(Start.Structure$)) = Start.Structure$ Then
               Count.Data1 = True
            End If
            If Start.Structure$ = "FOR" Then
               If Left$(Temp1$, 5) = "FORIF" Then
                  Count.Data1 = False
               End If
            End If
            If Count.Data1 Then
               Nested.Count = Nested.Count + 1
            End If
            Count.Data2 = False
            If Left$(Temp1$, Len(Stop.Structure$)) = Stop.Structure$ Then
               Count.Data2 = True
            End If
            If Stop.Structure$ = "LOOP" Then
               If Left$(Temp1$, 6) = "LOOPIF" Then
                  Count.Data2 = False
               End If
            End If
            If Stop.Structure$ = "NEXT" Then
               If Left$(Temp1$, 6) = "NEXTIF" Then
                  Count.Data2 = False
               End If
            End If
            If Count.Data2 Then
               Nested.Count = Nested.Count - 1
            End If
            If Left$(Temp1$, Len(Imbedded1$)) = Imbedded1$ Then
               If Nested.Count <= False Then
                  Print "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
            End If
            If Left$(Temp1$, Len(Imbedded2$)) = Imbedded2$ Then
               If Nested.Count <= False Then
                  Print "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
                  Exit Sub
               End If
            End If
         End If
      Next
   Next
   Color White, Black
   Print "Analysis completed. Program syntax correct."
End Sub

' gets last line in program
Sub Count.Lines (Temp1%)
   Temp1% = False
   For Temp2% = Max.Lines To 1 Step -1
      Temp1$ = Program(Temp2%)
      Temp1$ = STRIM$(Temp1$)
      If Len(Temp1$) Then
         Exit For
      End If
   Next
   Temp1% = Temp2%
End Sub

' remove current .sic program from memory
Sub New.Program
   ' erase/redimension program code array
   Erase Program
   ReDim Program(1 To Max.Lines) As String
End Sub

' prepares program for analyze/run command
Sub Prepare.Program
   ' concatenate line continuation statements, remove continued lines.
   Program.Line = False
   Call Count.Lines(Last.Line)
   Count.Start1:
   Program.Line = Program.Line + 1
   If Program.Line > Last.Line Then
      GoTo Count.End1
   End If
   If Program.Line > Max.Lines Then
      GoTo Count.End1
   End If
   First.Line = Program.Line
   Out2 = STRIM$(Program(Program.Line))
   If Len(Out2) Then
      Do
         If Right$(Out2, 1) = "_" Then
            While Right$(Out2, 1) = "_"
               Out2 = Left$(Out2, Len(Out2) - 1)
            Wend
            For Next.Line = Program.Line + 1 To Last.Line
               Out3 = STRIM$(Program(Next.Line))
               If Len(Out3) Then
                  Out2 = Out2 + Out3
                  Program.Line = Next.Line
                  Program(Next.Line) = Nul
                  Exit For
               End If
            Next
         Else
            Exit Do
         End If
         Out2 = STRIM$(Out2)
      Loop
      Program(First.Line) = Out2
   End If
   GoTo Count.Start1
   Count.End1:

   ' compress program array,
   ' replaces all white spaces with single space,
   ' replaces all double spaces with single space.
   Program.Line = False
   Call Count.Lines(Last.Line)
   For Program.Line = 1 To Last.Line
      Out2 = STRIM$(Program(Program.Line))
      If Len(Out2) Then
         Program(Program.Line) = TTRIM$(Out2, True)
      Else
         Program(Program.Line) = Nul
      End If
   Next

   ' remove remark at end of line,
   ' search for end of matching double quotes
   ' which might contain an apostrophe.
   For Program.Line = 1 To Last.Line
      Out2 = STRIM$(Program(Program.Line))
      If Len(Out2) Then
         Start.Char = 1
         Next.Quotes:
         Quote.Start = False
         For Temp = Start.Char To Len(Out2)
            If Mid$(Out2, Temp, 1) = Chr$(34) Then
               Quote.Start = Temp
               Exit For
            End If
         Next
         If Quote.Start Then
            Quote.Stop = False
            For Temp2 = Quote.Start + 1 To Len(Out2)
               If Mid$(Out2, Temp2, 1) = Chr$(34) Then
                  Quote.Stop = Temp2
                  Exit For
               End If
            Next
            If Quote.Stop Then
               Start.Char = Quote.Stop + 1
               GoTo Next.Quotes
            End If
         End If
         For Temp = Start.Char To Len(Out2)
            If Mid$(Out2, Temp, 1) = "'" Then
               Out2 = Left$(Out2, Temp - 1)
               Exit For
            End If
         Next
         Out2 = STRIM$(Out2)
         If Len(Out2) Then
            Program(Program.Line) = Out2
         Else
            Program(Program.Line) = "REM"
         End If
      End If
   Next
End Sub

' loads a program from disk
Sub Read.Program
   Close
   Open Filename For Input As #1
   Do While Not EOF(1)
      Line Input #1, Out2
      Out2 = STRIM$(Out2)
      For Blanks = 1 To Len(White.Space)
         Imbedded = InStr(Out2, Mid$(White.Space, Blanks, 1))
         If Imbedded Then
            Line.Number = Int(Val(Left$(Out2, Imbedded - 1)) + .5)
            If Line.Number > False And Line.Number <= Max.Lines Then
               Program(Line.Number) = Mid$(Out2, Imbedded)
               Exit For
            End If
         End If
      Next
   Loop
   Close
End Sub

' strips leading/trailing white spaces from string
Function STRIM$ (Var$)
   XVar$ = Var$
   Do
      Blanks = 0
      For Count = 1 To Len(White.Space)
         If Left$(XVar$, 1) = Mid$(White.Space, Count, 1) Then
            XVar$ = Mid$(XVar$, 2)
            Blanks = -1
         End If
      Next
      If Blanks = 0 Then
         Exit Do
      End If
   Loop
   Do
      Blanks = 0
      For Count = 1 To Len(White.Space)
         If Right$(XVar$, 1) = Mid$(White.Space, Count, 1) Then
            XVar$ = Left$(XVar$, Len(XVar$) - 1)
            Blanks = -1
         End If
      Next
      If Blanks = 0 Then
         Exit Do
      End If
   Loop
   STRIM$ = XVar$
End Function

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
Function TTRIM$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(VarX$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            Mid$(VarX$, Temp, 1) = " "
         End If
      Next
   Loop
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      If Mid$(VarX$, Temp, 2) = "  " Then
         VarX$ = Left$(VarX$, Temp) + Mid$(VarX$, Temp + 2)
         Temp = Temp - 1
      End If
   Loop
   TTRIM$ = VarX$
End Function

