Rem Indent.bas v64.0a r8.6a - Symbolic Instruction Code Kit; indent module.

' get standard include declarations
Rem $Include: 'SIC16.INC'

' declare global error routine
On Error GoTo Error.Routine

Color White, Black
Print "Indent v" + Version + " r" + Release + ":"

' adjust array size
Max.Lines = 4096
100
Print "Array size is:"; Max.Lines
Print "Increase array size(y/n)?";
Do
   X$ = InKey$
   If UCase$(X$) = "N" Then Print: Exit Do
   If UCase$(X$) = "Y" Then
      Print
      Print "Enter value(4096-32766)";
      Input X
      If X >= 4096 And X <= 32766 Then Max.Lines = X
      Exit Do
   End If
Loop

' program code
ReDim Program(1 To Max.Lines) As String

' initialize variables
White.Space = Chr$(32) + Chr$(9)

' run program from command line
Filename = Command$
StartLoop:
If Len(Filename) = False Then
   Print "Enter .sic filename";
   Input Filename
End If
If InStr(Filename, "?") Or InStr(Filename, "*") Then
   Shell "dir *.sic /p"
   Filename = ""
   GoTo StartLoop
End If
If Filename = Nul Then
   GoTo Boot.Usage
End If
Call New.Program
Call Read.Program
Call Indent.Program
Error.Resume:
Color Plain, Black
While InKey$ <> Nul
Wend
Print "Exiting to system.."
End

Boot.Usage:
Color White, Black
Print "Indent v" + Version + " r" + Release + "; Usage:"
Color Yellow, Black
Print "Indent <program name>"
Print "   Indents program specified on command line."
Color Plain, Black
End

' standard error trap for all Sic functions.
Error.Routine:
If Pos(0) > 1 Then
   Print
End If
Color White, Black
Print "Indent utility error";
Select Case Err
   Case 9 ' subscript out of range
      Print
      Print "Array size error."
      Max.Lines = 4096
      Resume 100
   Case 52, 53
      Print ": File not found."
   Case 70
      Print ": File is read-only."
   Case Else
      Print Err
End Select
Resume Error.Resume

' declares indent structure types
IndentDATA:
' 1=indent right
Data "SELECTIF CASE",1
Data "DO WHILE",1
Data "DO",1
Data "IF",1
Data "SELECT CASE",1
Data "DO UNTIL",1
Data "FORIF",1
Data "FOR",1
Data "WHILE",1
Data "LOOPIF",1
' -1=indent left
Data "ENDIF",-1
Data "END IF",-1
Data "NEXTIF",-1
Data "NEXT",-1
Data "LOOP UNTIL",-1
Data "LOOP WHILE",-1
Data "END SELECT",-1
Data "WEND",-1
Data "END LOOPIF",-1
Data "LOOP",-1
Data "END SELECTIF",-1
' -2=indent left, then right
Data "ELSE",-2
Data "CASE",-2
Data "EOF",0

Rem $Dynamic
' gets last line in program
Sub Count.Lines (Temp1%)
   Temp1% = False
   For Temp2% = Max.Lines To 1 Step -1
      Temp1$ = Program(Temp2%)
      Temp1$ = STRIM$(Temp1$)
      If Len(Temp1$) Then
         Exit For
      End If
   Next
   Temp1% = Temp2%
End Sub

' indents current program
Sub Indent.Program
   Color Yellow, Black
   Print "Enter number of spaces to indent";
   Input Increment
   Increment = Int(Increment)
   If Increment <= 0 Then
      Exit Sub
   End If
   Indent = False
   Call Count.Lines(Last.Line)
   MX = Len(Str$(Last.Line))
   For Program.Line = 1 To Last.Line
      Number$ = Space$(MX - Len(Mid$(Str$(Program.Line), 2)))
      Out2 = Program(Program.Line)
      Out2 = STRIM$(Out2)
      If Len(Out2) Then
         Temp1$ = STRIM$(Out2)
         Temp1$ = UCase$(Temp1$)
         Temp1$ = TTRIM$(Temp1$, False)
         Next.Indent = False
         Restore IndentDATA
         Do
            Read Keyword$, KeyIndent
            If Keyword$ = "EOF" Then
               Exit Do
            End If
            If Left$(Temp1$, Len(Keyword$)) = Keyword$ Then
               Next.Indent = KeyIndent
               Exit Do
            End If
         Loop
         Select Case Next.Indent
            Case 1 ' right
               Out2 = Space$(Indent * Increment) + STRIM$(Out2)
               Indent = Indent + 1
            Case -1 ' left
               Indent = Indent - 1
               If Indent < False Then
                  Print "Indent error: Line:"; Program.Line
                  Exit Sub
               End If
               Out2 = Space$(Indent * Increment) + STRIM$(Out2)
            Case -2 ' left/right
               Indent = Indent - 1
               If Indent < False Then
                  Print "Indent error: Line:"; Program.Line
                  Exit Sub
               End If
               Out2 = Space$(Indent * Increment) + STRIM$(Out2)
               Indent = Indent + 1
            Case Else
               Out2 = Space$(Indent * Increment) + STRIM$(Out2)
         End Select
         Out2 = Number$ + Out2
         Program(Program.Line) = Out2
      End If
   Next
   If Indent <> False Then
      Print "Indent error: Line:"; Program.Line
   Else
      Call Store.Program
      Print "Program indented."
   End If
End Sub

' remove current .sic program from memory
Sub New.Program
   ' erase/redimension program code array
   Erase Program
   ReDim Program(1 To Max.Lines) As String
End Sub

' loads a program from disk
Sub Read.Program
   Close
   Open Filename For Input As #1
   Do While Not EOF(1)
      Line Input #1, Out2
      Out2 = STRIM$(Out2)
      For Blanks = 1 To Len(White.Space)
         Imbedded = InStr(Out2, Mid$(White.Space, Blanks, 1))
         If Imbedded Then
            Line.Number = Int(Val(Left$(Out2, Imbedded - 1)) + .5)
            If Line.Number > False And Line.Number <= Max.Lines Then
               Program(Line.Number) = Mid$(Out2, Imbedded)
               Exit For
            End If
         End If
      Next
   Loop
   Close
End Sub

' writes out the current .sic program to file
Sub Store.Program
   Close
   Open Filename For Output As #1
   Call Count.Lines(Last.Line)
   For Line.Number = 1 To Last.Line
      ProgramLine$ = Program(Line.Number)
      If STRIM$(ProgramLine$) <> Nul Then
         If InStr(White.Space, Left$(ProgramLine$, 1)) Then
            Print #1, Mid$(Str$(Line.Number), 2) + ProgramLine$
         Else
            Print #1, Mid$(Str$(Line.Number), 2) + " " + ProgramLine$
         End If
      End If
   Next
   Close
End Sub

' strips leading/trailing white spaces from string
Function STRIM$ (Var$)
   XVar$ = Var$
   Do
      Blanks = 0
      For Count = 1 To Len(White.Space)
         If Left$(XVar$, 1) = Mid$(White.Space, Count, 1) Then
            XVar$ = Mid$(XVar$, 2)
            Blanks = -1
         End If
      Next
      If Blanks = 0 Then
         Exit Do
      End If
   Loop
   Do
      Blanks = 0
      For Count = 1 To Len(White.Space)
         If Right$(XVar$, 1) = Mid$(White.Space, Count, 1) Then
            XVar$ = Left$(XVar$, Len(XVar$) - 1)
            Blanks = -1
         End If
      Next
      If Blanks = 0 Then
         Exit Do
      End If
   Loop
   STRIM$ = XVar$
End Function

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
Function TTRIM$ (Var$, Var)
   VarX$ = Var$
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      For Blanks = 1 To Len(White.Space)
         If Mid$(VarX$, Temp, 1) = Mid$(White.Space, Blanks, 1) Then
            Mid$(VarX$, Temp, 1) = " "
         End If
      Next
   Loop
   Temp = False
   Do
      Temp = Temp + 1
      If Temp > Len(VarX$) Then
         Exit Do
      End If
      If Var Then
         If Mid$(VarX$, Temp, 1) = Chr$(34) Then
            Do
               Temp = Temp + 1
               If Temp > Len(VarX$) Then
                  Exit Do
               End If
               If Mid$(VarX$, Temp, 1) = Chr$(34) Then
                  Exit Do
               End If
            Loop
         End If
      End If
      If Mid$(VarX$, Temp, 2) = "  " Then
         VarX$ = Left$(VarX$, Temp) + Mid$(VarX$, Temp + 2)
         Temp = Temp - 1
      End If
   Loop
   TTRIM$ = VarX$
End Function

