Rem Memory Usage Monitor v1.0a QB64 PD 2025.

_Define A-Z As _UNSIGNED _INTEGER64

Declare Library "mem"
   Function MemInUsePercent~&&
   Function TotalPhysicalMem~&&
   Function FreePhysicalMem~&&
   Function TotalPagingFile~&&
   Function FreePagingFile~&&
   Function TotalVirtualMem~&&
   Function FreeVirtualMem~&&
   Function FreeExtendedMem~&&
   Function GetCPULoad#
End Declare

' byte suffix type
Dim Shared SuffixType As Integer

' setup screen
_ScreenMove _Middle
_Title "Memory Usage"

' start display loop
Do
   _Delay 1
   I$ = InKey$
   If Len(I$) Then
      If I$ = Chr$(27) Then Color 7: End
      If I$ = " " Then ' rotate suffix
         SuffixType = SuffixType + 1
         If SuffixType = 4 Then SuffixType = 0
      End If
   End If
   Cls
   Color 14, 0
   Print "Press <space> to cycle suffix, <escape> to quit."
   Print
   Color 15, 0

   ' GetCPULoad = 0 is idle, 1 is fully used.
   '  Multiply by 100 for a percentage
   Print "CPU used:";
   ' truncate 2 decimal places.
   V$ = Str$(Int(GetCPULoad * 10000) / 100)
   If InStr(V$, ".") Then
      V$ = Left$(V$, InStr(V$, ".") + 2)
   End If
   V$ = V$ + "%"
   Print V$
   _Title "Memory Usage - CPU " + V$

   Print "Memory used:"; Str$(MemInUsePercent); "%"
   Print

   Print "Total Physical Memory: "
   Print "  "; Suffix$(TotalPhysicalMem)
   Print

   Print "Free Physical Memory: "
   Print "  "; Suffix$(FreePhysicalMem)
   Print

   Print "Total Paging File: "
   Print "  "; Suffix$(TotalPagingFile)
   Print

   Print "Free Paging File: "
   Print "  "; Suffix$(FreePagingFile)
   Print

   Print "Total Virtual Memory: "
   Print "  "; Suffix$(TotalVirtualMem)
   Print

   Print "Free Virtual Memory:"
   Print "  "; Suffix$(FreeVirtualMem)
   Print

   ' locate and display statusline
   X = CsrLin
   Y = Pos(0)
   V$ = "Memusage " + Date$ + " " + Time$
   Locate 25, 1, 1
   Color 14
   Print V$;
   Locate X, Y
   Color 15
Loop
Color 7
End

' calculate byte suffix.
Function Suffix$ (Var)
   Dim Var3 As Double
   ' Var - input value
   ' SuffixType - 0 = bytes, 1 = kilo, 2 = mega, 3 = giga
   Rem B  (Byte) = 00x - 0FFx
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB
   Rem GB (Gigabyte) = 1024 MB

   ' check exponent.
   Var3 = Var
   s$ = Str$(Var3)
   If InStr(s$, "D") Then
      Suffix$ = s$
      Exit Function
   End If

   ' check bytes.
   If SuffixType = 0 Then
      Suffix$ = FormatString$(Var)
      Exit Function
   End If

   ' calculate byte suffix.
   TempA = False
   Do
      If Var3 >= 1024 Then
         Var3 = Var3 / 1024
         TempA = TempA + 1
         If TempA = SuffixType Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   Var2$ = FormatString$(Var3)

   ' make byte suffix.
   Var$ = ""
   If TempA > 0 Then
      Select Case TempA
         Case 1
            Var$ = "KB"
         Case 2
            Var$ = "MB"
         Case 3
            Var$ = "GB"
      End Select
   End If

   ' get single precision decimal place.
   If Int(Var3) <> Var3 Then
      x$ = Str$(Var3)
      x = InStr(x$, ".")
      x$ = Mid$(x$, x)
      Select Case SuffixType
         Case 1 ' KB
            x$ = Left$(x$, 2)
         Case 2 ' MB
            x$ = Left$(x$, 3)
         Case 3 ' GB
            x$ = Left$(x$, 4)
      End Select
      Var2$ = Var2$ + x$
   Else
      Var2$ = Var2$ + ".0 "
   End If

   ' append suffix.
   Suffix$ = Var2$ + " " + Var$
End Function

' formats a numeric string.
Function FormatString$ (s)
   x$ = ""
   s$ = Str$(s)
   s$ = LTrim$(s$)
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   FormatString$ = x$
End Function

