' Dialog flag constants (use + or OR to use more than 1 flag value)
Const OFN_ALLOWMULTISELECT = &H200& '  Allows the user to select more than one file, not recommended!
Const OFN_CREATEPROMPT = &H2000& '     Prompts if a file not found should be created(GetOpenFileName only).
Const OFN_EXTENSIONDIFFERENT = &H400& 'Allows user to specify file extension other than default extension.
Const OFN_FILEMUSTEXIST = &H1000& '    Chechs File name exists(GetOpenFileName only).
Const OFN_HIDEREADONLY = &H4& '        Hides read-only checkbox(GetOpenFileName only)
Const OFN_NOCHANGEDIR = &H8& '         Restores the current directory to original value if user changed
Const OFN_NODEREFERENCELINKS = &H100000& 'Returns path and file name of selected shortcut(.LNK) file instead of file referenced.
Const OFN_NONETWORKBUTTON = &H20000& ' Hides and disables the Network button.
Const OFN_NOREADONLYRETURN = &H8000& ' Prevents selection of read-only files, or files in read-only subdirectory.
Const OFN_NOVALIDATE = &H100& '        Allows invalid file name characters.
Const OFN_OVERWRITEPROMPT = &H2& '     Prompts if file already exists(GetSaveFileName only)
Const OFN_PATHMUSTEXIST = &H800& '     Checks Path name exists (set with OFN_FILEMUSTEXIST).
Const OFN_READONLY = &H1& '            Checks read-only checkbox. Returns if checkbox is checked
Const OFN_SHAREAWARE = &H4000& '       Ignores sharing violations in networking
Const OFN_SHOWHELP = &H10& '           Shows the help button (useless!)
'--------------------------------------------------------------------------------------------

DefInt A-Z

Type FILEDIALOGTYPE
   $If 32BIT Then
      lStructSize As Long '        For the DLL call
      hwndOwner As Long '          Dialog will hide behind window when not set correctly
      hInstance As Long '          Handle to a module that contains a dialog box template.
      lpstrFilter As _Offset '     Pointer of the string of file filters
      lpstrCustFilter As _Offset
      nMaxCustFilter As Long
      nFilterIndex As Long '       One based starting filter index to use when dialog is called
      lpstrFile As _Offset '       String full of 0's for the selected file name
      nMaxFile As Long '           Maximum length of the string stuffed with 0's minus 1
      lpstrFileTitle As _Offset '  Same as lpstrFile
      nMaxFileTitle As Long '      Same as nMaxFile
      lpstrInitialDir As _Offset ' Starting directory
      lpstrTitle As _Offset '      Dialog title
      flags As Long '              Dialog flags
      nFileOffset As Integer '     Zero-based offset from path beginning to file name string pointed to by lpstrFile
      nFileExtension As Integer '  Zero-based offset from path beginning to file extension string pointed to by lpstrFile.
      lpstrDefExt As _Offset '     Default/selected file extension
      lCustData As Long
      lpfnHook As Long
      lpTemplateName As _Offset
   $Else
      lStructSize AS _OFFSET '           For the DLL call
      hwndOwner AS _OFFSET '          Dialog will hide behind window when not set correctly
      hInstance AS _OFFSET '          Handle to a module that contains a dialog box template.
      lpstrFilter AS _OFFSET '        Pointer of the string of file filters
      lpstrCustFilter AS LONG
      nMaxCustFilter AS LONG
      nFilterIndex AS _INTEGER64 '    One based starting filter index to use when dialog is called
      lpstrFile AS _OFFSET '          String full of 0's for the selected file name
      nMaxFile AS _OFFSET '        Maximum length of the string stuffed with 0's minus 1
      lpstrFileTitle AS _OFFSET '     Same as lpstrFile
      nMaxFileTitle AS _OFFSET '      Same as nMaxFile
      lpstrInitialDir AS _OFFSET '    Starting directory
      lpstrTitle AS _OFFSET '         Dialog title
      flags AS _INTEGER64 '           Dialog flags
      nFileOffset AS _INTEGER64 '     Zero-based offset from path beginning to file name string pointed to by lpstrFile
      nFileExtension AS _INTEGER64 '  Zero-based offset from path beginning to file extension string pointed to by lpstrFile.
      lpstrDefExt AS _OFFSET '        Default/selected file extension
      lCustData AS _INTEGER64
      lpfnHook AS _INTEGER64
      lpTemplateName AS _OFFSET
   $End If
End Type

Declare Dynamic Library "comdlg32" ' Library declarations using _OFFSET types
   Function GetOpenFileNameA&& (DIALOGPARAMS As FILEDIALOGTYPE) ' The Open file dialog
   Function GetSaveFileNameA&& (DIALOGPARAMS As FILEDIALOGTYPE) ' The Save file dialog
End Declare

Declare Library
   Function FindWindow~&& (ByVal ClassName As _Offset, WindowName$) ' To get hWnd handle
End Declare

Dim hWnd As _Integer64
$If 64BIT Then
   hWnd = _WINDOWHANDLE 'FindWindow(0, "Open and Save Dialog" + CHR$(0)) 'get window handle using _TITLE string
$Else
   hWnd&& = FindWindow(0, "FOCdemo" + Chr$(0)) 'get window handle using _TITLE string
$End If

' Do the Open File dialog call!
Filter$ = "All files (*.*)|*.*"
Flags& = OFN_FILEMUSTEXIST + OFN_NOCHANGEDIR + OFN_READONLY ' add flag constants here
OFile$ = GetOpenFileName$("Common Dialogs", ".\", Filter$, 1, Flags&, hWnd&&)

If OFile$ = "" Then ' Display Open dialog results
   Print "You didn't pick any file..."
Else
   Print "You picked this file: "
   Print OFile$
End If
End

Function GetOpenFileName$ (Title$, InitialDir$, Filter$, FilterIndex&, Flags&, hWnd As _Integer64)
   '  Title$      - The dialog title.
   '  InitialDir$ - If this left blank, it will use the directory where the last opened file is
   '  located. Specify ".\" if you want to always use the current directory.
   '  Filter$     - File filters separated by pipes (|) in the same format as using VB6 common dialogs.
   '  FilterIndex - The initial file filter to use. Will be altered by user during the call.
   '  Flags&      - Dialog flags. Will be altered by the user during the call.
   '  hWnd&       - Your program's window handle that should be aquired by the FindWindow function.
   '
   ' Returns: Blank when cancel is clicked otherwise, the file name selected by the user.
   ' FilterIndex and Flags& will be changed depending on the user's selections.

   Dim OpenCall As FILEDIALOGTYPE ' Needed for dialog call

   fFilter$ = Filter$
   For R = 1 To Len(fFilter$) ' Replace the pipes with character zero
      If Mid$(fFilter$, R, 1) = "|" Then Mid$(fFilter$, R, 1) = Chr$(0)
   Next R
   fFilter$ = fFilter$ + Chr$(0)

   lpstrFile$ = String$(2048, 0) ' For the returned file name
   lpstrDefExt$ = String$(10, 0) ' Extension will not be added when this is not specified
   OpenCall.lStructSize = Len(OpenCall)
   OpenCall.hwndOwner = hWnd&&
   OpenCall.lpstrFilter = _Offset(fFilter$)
   OpenCall.nFilterIndex = FilterIndex&
   OpenCall.lpstrFile = _Offset(lpstrFile$)
   OpenCall.nMaxFile = Len(lpstrFile$) - 1
   OpenCall.lpstrFileTitle = OpenCall.lpstrFile
   OpenCall.nMaxFileTitle = OpenCall.nMaxFile
   OpenCall.lpstrInitialDir = _Offset(InitialDir$)
   OpenCall.lpstrTitle = _Offset(Title$)
   OpenCall.lpstrDefExt = _Offset(lpstrDefExt$)
   OpenCall.flags = Flags&

   Result = GetOpenFileNameA&&(OpenCall) '            Do Open File dialog call!

   If Result Then ' Trim the remaining zeros
      GetOpenFileName$ = Left$(lpstrFile$, InStr(lpstrFile$, Chr$(0)) - 1)
      Flags& = OpenCall.flags
      FilterIndex = OpenCall.nFilterIndex
   End If

End Function

Function GetSaveFileName$ (Title$, InitialDir$, Filter$, FilterIndex, Flags&, hWnd&&)
   '  Title$      - The dialog title.
   '  InitialDir$ - If this left blank, it will use the directory where the last opened file is
   '     located. Specify ".\" if you want to always use the current directory.
   '  Filter$     - File filters separated by pipes (|) in the same format as VB6 common dialogs.
   '  FilterIndex - The initial file filter to use. Will be altered by user during the call.
   '  Flags&      - Dialog flags. Will be altered by the user during the call.
   '  hWnd&       - Your program's window handle that should be aquired by the FindWindow function.

   ' Returns: Blank when cancel is clicked otherwise, the file name entered by the user.
   ' FilterIndex and Flags& will be changed depending on the user's selections.

   Dim SaveCall As FILEDIALOGTYPE ' Needed for dialog call

   fFilter$ = Filter$
   For R = 1 To Len(fFilter$) ' Replace the pipes with zeros
      If Mid$(fFilter$, R, 1) = "|" Then Mid$(fFilter$, R, 1) = Chr$(0)
   Next R
   fFilter$ = fFilter$ + Chr$(0)

   lpstrFile$ = String$(2048, 0) ' For the returned file name
   lpstrDefExt$ = String$(10, 0) ' Extension will not be added when this is not specified
   SaveCall.lStructSize = Len(SaveCall)
   SaveCall.hwndOwner = hWnd&&
   SaveCall.lpstrFilter = _Offset(fFilter$)
   SaveCall.nFilterIndex = FilterIndex
   SaveCall.lpstrFile = _Offset(lpstrFile$)
   SaveCall.nMaxFile = Len(lpstrFile$) - 1
   SaveCall.lpstrFileTitle = SaveCall.lpstrFile
   SaveCall.nMaxFileTitle = SaveCall.nMaxFile
   SaveCall.lpstrInitialDir = _Offset(InitialDir$)
   SaveCall.lpstrTitle = _Offset(Title$)
   SaveCall.lpstrDefExt = _Offset(lpstrDefExt$)
   SaveCall.flags = Flags&

   Result& = GetSaveFileNameA&&(SaveCall) ' Do dialog call!

   If Result& Then ' Trim the remaining zeros
      GetSaveFileName$ = Left$(lpstrFile$, InStr(lpstrFile$, Chr$(0)) - 1)
      Flags& = SaveCall.flags
      FilterIndex = SaveCall.nFilterIndex
   End If
End Function


