REM: Include file for Hex Editor v8.6a PD 2024.

' initialize all default variables as integer.
DEFINT A-Z

' load all arrays during runtime.
REM $DYNAMIC

' get include files.
REM $INCLUDE: 'bpb.bi'
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'fcb.bi'
REM $INCLUDE: 'wdta.bi'

' declare multiple file structure.
TYPE FileType
 AsciiValue AS INTEGER
 ASCIIZ AS STRING * 260
 Buffer AS STRING * 1
 CopyPositionEnd AS DOUBLE
 CopyPositionPivot AS DOUBLE
 CopyPositionStart AS DOUBLE
 CurrentMarker AS SINGLE
 CurrentUndo AS SINGLE
 CurrentWindow2 AS INTEGER
 Filename AS STRING * 12
 FileAttribute AS INTEGER
 FileByte AS STRING * 1
 FileDisplay AS INTEGER
 FileLength AS DOUBLE
 FileLocked AS INTEGER
 FilePage AS DOUBLE
 FilePosition AS DOUBLE
 Handle AS INTEGER
 MarkerCount AS SINGLE
 Netpath AS STRING * 260
 PageColumn AS DOUBLE
 PageRow AS DOUBLE
 ScreenRow AS INTEGER
 ShortFilename AS STRING * 260
 StoreSearchString AS STRING * 260
END TYPE

' declare dos filename/directory structure.
TYPE DosFileType
 Name AS STRING * 12' 8.3
END TYPE

' declare windows filename/directory structure.
TYPE WinFileType
 Name AS STRING * 260' asciiz
END TYPE

' declare marker filename structure.
TYPE MarkerFileType
 Markers1(15) AS DOUBLE
END TYPE

' declare byte undo filename structure.
TYPE UndoFileType
 UndoByte1(15) AS INTEGER
 UndoPosition1(15) AS DOUBLE
END TYPE

' declare multi array process filenames.
COMMON SHARED MultiFilename1() AS STRING, MultiFilenames() AS STRING

' declare undo structure.
COMMON SHARED UndoFile AS UndoFileType

' declare undo variables.
COMMON SHARED CurrentUndo AS SINGLE, UndoToggle AS INTEGER

' declare marker structure.
COMMON SHARED MarkerFile AS MarkerFileType

' declare marker variables.
COMMON SHARED CurrentMarker AS SINGLE, NewMarker AS SINGLE
COMMON SHARED MarkerCount AS SINGLE, MarkerPosition AS SINGLE

' declare menu area storage arrays.
COMMON SHARED Area1() AS INTEGER, Area2() AS INTEGER

' declare ascii character variables.
COMMON SHARED Hline AS INTEGER, Vline AS INTEGER
COMMON SHARED ULcorner AS INTEGER, URcorner AS INTEGER
COMMON SHARED LLcorner AS INTEGER, LRcorner AS INTEGER

' declare temporary file position variables.
COMMON SHARED FileDisplay AS INTEGER, FileDisplay2 AS INTEGER
COMMON SHARED FileDisplayX AS INTEGER, ScreenRowX AS INTEGER
COMMON SHARED Low AS DOUBLE, High AS DOUBLE, HeapSortOff AS INTEGER
COMMON SHARED TempPosition AS DOUBLE, TempPosition1 AS DOUBLE
COMMON SHARED TempPosition2 AS DOUBLE, TempPosition3 AS DOUBLE
COMMON SHARED TempFiles() AS STRING, SortMax AS SINGLE, SortMax2 AS SINGLE

' declare common program variables.
COMMON SHARED AsciiValue AS INTEGER, AsciiValue2 AS INTEGER
COMMON SHARED ASCIIValue3 AS DOUBLE, HexValue AS DOUBLE
COMMON SHARED CurrentWindow AS INTEGER, CurrentWindow2 AS INTEGER
COMMON SHARED PageColumn AS DOUBLE, PageRow AS DOUBLE
COMMON SHARED ScreenDrawn AS INTEGER, ScreenRow AS INTEGER
COMMON SHARED StatusMessage AS STRING, SupportedCall AS INTEGER

' declare common validity check variables.
COMMON SHARED AllowWildCard AS INTEGER
COMMON SHARED ValidFunction AS INTEGER, ValidASCIIValue AS INTEGER
COMMON SHARED ValidString AS INTEGER, ValidHexValue AS INTEGER
COMMON SHARED ValidByteString AS INTEGER, NumBytes AS INTEGER

' declare filename/file position variables.
Const BlockByteLength = 1024 ' can be changed
COMMON SHARED BlockByte AS STRING * BlockByteLength, Column AS DOUBLE
COMMON SHARED Column2 AS DOUBLE, DumpFile AS STRING, ExcludeFile AS STRING
COMMON SHARED FileDumped AS INTEGER, Filename AS STRING
COMMON SHARED FileByte AS STRING * 1, FileBytePosition AS DOUBLE
COMMON SHARED FileLength AS DOUBLE, FilePage AS DOUBLE
COMMON SHARED FilePosition AS DOUBLE, FilePosition2 AS DOUBLE
COMMON SHARED FirstByte AS DOUBLE, FilePage2 AS DOUBLE
COMMON SHARED LastByte AS DOUBLE, LastPage AS DOUBLE
COMMON SHARED NewByte AS DOUBLE, NextByte AS DOUBLE
COMMON SHARED NextLine AS DOUBLE, NextPage AS DOUBLE
COMMON SHARED NewPosition AS DOUBLE, NewPosition2 AS DOUBLE
COMMON SHARED PageColumn2 AS DOUBLE, PageRow2 AS DOUBLE
COMMON SHARED SeekPosition AS DOUBLE, SeekPosition2 AS DOUBLE
COMMON SHARED ShortFilename AS STRING, StorePosition AS DOUBLE

' declare file search position variables.
COMMON SHARED SearchBytePosition AS DOUBLE, StoreNumBytes AS INTEGER
COMMON SHARED StoreSearchPosition AS DOUBLE, StoreSearchString AS STRING
COMMON SHARED StoreSearchMulti AS INTEGER

' declare all long filename common variables.
COMMON SHARED ASCIIZ AS STRING * 260, ASCIIZ2 AS STRING * 260
COMMON SHARED Buffer AS STRING * 1, BPBfile AS BPBtype
COMMON SHARED ConfigFile AS STRING, BASIC.DTA.OFF AS INTEGER
COMMON SHARED BASIC.DTA.SEG AS INTEGER, Directory.ASCIIZ AS STRING
COMMON SHARED DTAfile AS DTAtype, ErrorTrap AS INTEGER
COMMON SHARED FileAttribute AS INTEGER, FileLocked AS INTEGER
COMMON SHARED FileDateTime AS STRING, FileSwitch AS INTEGER
COMMON SHARED FileSize AS DOUBLE, FileSizeType AS INTEGER
COMMON SHARED Handle AS INTEGER, QuietSwitch AS INTEGER
COMMON SHARED Quote AS STRING, Windows.Detected AS INTEGER
COMMON SHARED Wfile.Handle AS INTEGER, WDTAfile AS WDTAtype
COMMON SHARED Write.Error AS INTEGER, Load.Windows AS INTEGER
COMMON SHARED Load.DOS AS INTEGER

' declare all common mouse variables.
COMMON SHARED Mouse.Present AS INTEGER, Mouse.Button1 AS INTEGER
COMMON SHARED Mouse.Button2 AS INTEGER, Mouse.Button3 AS INTEGER
COMMON SHARED Mouse.Row AS INTEGER, Mouse.Column AS INTEGER
COMMON SHARED Old.Mouse.Row AS INTEGER, Old.Mouse.Column AS INTEGER
COMMON SHARED Mouse.X AS INTEGER, Mouse.Y AS INTEGER, Show.Mouse AS INTEGER

' common default left click mouse variables.
COMMON SHARED Mouse.ButtonX AS INTEGER
COMMON SHARED Mouse.RowX AS INTEGER, Mouse.ColumnX AS INTEGER
COMMON SHARED MouseTime AS SINGLE, Time1 AS SINGLE

' common left click and drag mouse variables.
COMMON SHARED Mouse.Button1.Row AS INTEGER, Mouse.Button1.Column AS INTEGER
COMMON SHARED Mouse.Button1.X AS INTEGER, Mouse.Button1.Y AS INTEGER
COMMON SHARED Mouse.Drag AS INTEGER, Reset1 AS INTEGER

' declare filename variables for file menu box.
COMMON SHARED Ambiguate AS INTEGER, AmbiguateSwitch AS INTEGER
COMMON SHARED Attribute AS INTEGER, ASCIIZ3 AS STRING * 260
COMMON SHARED Current.Drive AS INTEGER, Drive.Box.Line AS INTEGER
COMMON SHARED Default.Drive AS INTEGER, Last.Drive AS INTEGER
COMMON SHARED Num.Dirs AS SINGLE, Num.Files AS SINGLE
COMMON SHARED RAMdisk AS STRING * 1

' declare Alt-n keys array.
COMMON SHARED Keys() AS INTEGER

' declare filename sort variables for file menu box.
COMMON SHARED FileSort AS INTEGER, DirSort AS INTEGER, Millisecond AS INTEGER

' declare requirement filename attribute bit variables for file menu box.
COMMON SHARED RequireReadOnly AS INTEGER, RequireHidden AS INTEGER
COMMON SHARED RequireSystem AS INTEGER, RequireArchive AS INTEGER

' declare requirement directory attribute bit variables for file menu box.
COMMON SHARED RequireDirReadOnly AS INTEGER, RequireDirHidden AS INTEGER
COMMON SHARED RequireDirSystem AS INTEGER, RequireDirArchive AS INTEGER

' declare sort structure for file menu box.
COMMON SHARED DosFileStruc AS DosFileType, WinFileStruc AS WinFileType

' declare menu screen location offsets for file menu box.
COMMON SHARED Xcoor AS INTEGER, Ycoor AS INTEGER

' declare menu variables for DropDownMenu.
COMMON SHARED CurrentMenu AS INTEGER, CurrentMenuSelection AS INTEGER

' declare variables for copy/paste.
COMMON SHARED CopyByte AS STRING * 1, CopyStart AS DOUBLE
COMMON SHARED CopyPositionEnd AS DOUBLE, CopyPositionPivot AS DOUBLE
COMMON SHARED CopyPositionStart AS DOUBLE

' declare structure for multiple files.
COMMON SHARED File() AS FileType

' declare multiple file variables.
COMMON SHARED CurrentFile AS INTEGER, NumberFiles AS INTEGER

' declare temp file share variables.
COMMON SHARED Process.Number AS INTEGER

' declare interrupt structures.
COMMON SHARED InregsX AS RegtypeX, OutregsX AS RegtypeX
COMMON SHARED InregsX2 AS RegtypeX

' declare interrupt trap services variable.
COMMON SHARED TrapInit AS INTEGER

' declare color variables.
COMMON SHARED Black AS INTEGER, Blue AS INTEGER, Cyan AS INTEGER
COMMON SHARED Green AS INTEGER, Magenta AS INTEGER, Plain AS INTEGER
COMMON SHARED Red AS INTEGER, White AS INTEGER, Yellow AS INTEGER
COMMON SHARED Background AS INTEGER, BackGround2 AS INTEGER

' declare color storage variables.
COMMON SHARED Background.Color AS INTEGER, Foreground.Color AS INTEGER
COMMON SHARED Video.Page AS INTEGER

' declare network path variables.
COMMON SHARED CurrentNetPath AS STRING * 260, DefaultNetPath AS STRING * 260

' additional display purposes.
COMMON SHARED Debug AS INTEGER, Debug2 AS INTEGER, Debug3 AS INTEGER

' declare default printer port variable.
COMMON SHARED PrinterPort AS INTEGER

' declare constants.
CONST Nul = ""
CONST False = 0
CONST SFalse = 0!
CONST DFalse = 0#
CONST True = -1
CONST Author$ = "Erik Jon Oredson"
CONST Email = "eoredson@gmail.com"
CONST Version = "v8.6a"
CONST Release = "r1.0a"
CONST Program = "Hex Editor"
CONST Publish = "07/20/2024"
CONST Status = "Public Domain"
CONST Urls = "www.filegate.net"

' declare mouse function constants.
CONST CheckMouse = 0
CONST ShowMouse = 1
CONST HideMouse = 2
CONST MovePosition = 4
CONST Position = 3
CONST Button = 5

' declare maximum files/processes.
CONST MaxFiles = 15 ' should not be changed
CONST MaxProcesses = 9 ' should not be changed

' declare functions.
DECLARE FUNCTION Conanicalize$ (V$)
DECLARE FUNCTION ReleaseTime ()
DECLARE FUNCTION TestFile (V$)

' declare record structure functions.
DECLARE FUNCTION Directories$ (V!)
DECLARE FUNCTION Filenames$ (V!)

' declare marker record structure function.
DECLARE FUNCTION Markers# (V!)

' declare undo record structure functions.
DECLARE FUNCTION UndoByte% (V!)
DECLARE FUNCTION UndoPosition# (V!)

' declare specialized DIR$ functions.
DECLARE FUNCTION DIRx$ (F$)
DECLARE FUNCTION DIRz$ (F$)

' declare specialized LINE INPUT function.
DECLARE FUNCTION LineInput$ (X%, y%, l%)

' declare calculation functions.
DECLARE FUNCTION CalculateColumn ()
DECLARE FUNCTION CalculateColumn2 ()
DECLARE FUNCTION CalculatePosition3# ()
DECLARE FUNCTION DumpLineRange$ ()

' declare DTA subroutine.
DECLARE SUB GetInfo (S%, S$)

' declare calculation subroutines.
DECLARE SUB CalculatePosition1 ()
DECLARE SUB CalculatePosition2 ()
DECLARE SUB FormatPosition1 ()

' declare subroutines.
DECLARE SUB CheckExcluded (V1$, V2$, M%)
DECLARE SUB Clipboard2 (V%)
DECLARE SUB Colorf (V%)
DECLARE SUB Colorf2 (V1%, V2%)
DECLARE SUB Deconcatenate (N$, V$, V%)
DECLARE SUB DisplayChart (V%)
DECLARE SUB DisplayBootUsage ()
DECLARE SUB DisplayScreen ()
DECLARE SUB DisplayScreen2 ()
DECLARE SUB DumpSub (S%)
DECLARE SUB DropDownMenu ()
DECLARE SUB ExcludeList (Y1%, Y2$)
DECLARE SUB HelpScreen ()
DECLARE SUB InitPasteFiles (V%)
DECLARE SUB InitVars ()
DECLARE SUB InstrSUB (V%, V1$, V2$)
DECLARE SUB Locatef (V1%, V2%, V3%)
DECLARE SUB Marker (V%)
DECLARE SUB Menu (V1$, V2$, V3$, V4$, V5$)
DECLARE SUB MoveMenu ()
DECLARE SUB MultiFileFunction (V%)
DECLARE SUB OpenPasteFiles (V%)
DECLARE SUB OpenUndoFile (V%)
DECLARE SUB OverridePrompt ()
DECLARE SUB Printf (V$)
DECLARE SUB PrintSub (S%)
DECLARE SUB ReadConfigFile (V$)
DECLARE SUB SearchFile (V1%, V2%)
DECLARE SUB SortFiles (S%)
DECLARE SUB ViewFiles (V%)

' declare more subroutines.
DECLARE SUB AsciiToHex1 (S$)
DECLARE SUB AsciiToHex2 (S$)
DECLARE SUB CheckASCIIValue (S$)
DECLARE SUB CheckString (S$)
DECLARE SUB CheckHexValue (S$)
DECLARE SUB CheckAsciiBytes (S$)
DECLARE SUB CheckHexBytes (S$)
DECLARE SUB Error.Inkey (E$)
DECLARE SUB FormatPosition2 (V%)
DECLARE SUB GetDrive (V%, V$)
DECLARE SUB GetDriveInfo (D$)
DECLARE SUB GetFileLength (V%)
DECLARE SUB GetShortFilename (S$)
DECLARE SUB Prompt.Inkey ()
DECLARE SUB ResetTrap ()
DECLARE SUB SetTrap ()

' declare mouse subroutines.
DECLARE SUB HMouse () ' hide mouse
DECLARE SUB SMouse () ' show mouse
DECLARE SUB MouseButton1Drag (V%)
DECLARE SUB MouseDriver ()
DECLARE SUB MouseDriver1 ()
DECLARE SUB MouseDriver2 ()
DECLARE SUB MouseFunction (V1%, V2%)
DECLARE SUB MouseFunction2 (V1%, V2%)

' declare replacement stub subroutines.
DECLARE SUB BytePrint ()
DECLARE SUB ClearStatus ()
DECLARE SUB DisplayX ()
DECLARE SUB DisplayPosition ()
DECLARE SUB DisplayFilename ()
DECLARE SUB DisplayFileTitle ()
DECLARE SUB DisplayPageByte ()
DECLARE SUB ClearPageByte ()
DECLARE SUB ClearHilightByte ()
DECLARE SUB Delete.Process ()
DECLARE SUB DisplayHilightByte ()
DECLARE SUB DisplayHexPage ()
DECLARE SUB DisplayStatus1 ()
DECLARE SUB DisplayStatus2 ()
DECLARE SUB DisplayStatusLine ()
DECLARE SUB GetDrives ()
DECLARE SUB LockedFile ()
DECLARE SUB LocateCursor ()
DECLARE SUB LocateCursor2 ()
DECLARE SUB LocateHilightCursor ()
DECLARE SUB LseekFile ()
DECLARE SUB PressKey ()
DECLARE SUB PromptKey ()
DECLARE SUB PromptEscKey ()
DECLARE SUB ReadFile ()
DECLARE SUB RedrawRightWindow ()
DECLARE SUB RedrawWindow1 ()
DECLARE SUB RedrawWindow2 ()
DECLARE SUB ResetHilightBytes ()
DECLARE SUB ResetBytes ()
DECLARE SUB RestoreHilightBytes ()
DECLARE SUB ResetByte ()
DECLARE SUB Writefile ()

' declare directory/filename loaders.
DECLARE SUB LoadDirSpec (V$, N$, C$, D$)
DECLARE SUB LoadFileSpec (V$, F$)

' declare file menu box functions.
DECLARE FUNCTION MakeFilename$ (N$, C$, D$, X$)
DECLARE FUNCTION MakeFilename2$ (N$, C$, D$)
DECLARE FUNCTION MakeFilename3$ (N$, C$, D$)
DECLARE FUNCTION MakeFilename4$ (N$, C$, D$)

' declare pack subroutines.
DECLARE SUB Pack.Files1 ()
DECLARE SUB Pack.Arrays1 ()
DECLARE SUB Pack.Arrays2 ()

' declare formatting function.
DECLARE FUNCTION FormatX$ (V#, V%)

DECLARE SUB ReadCommandLine (Var$)
DECLARE SUB StoreServerName ()
DECLARE SUB InitializePaste (Var2%)
DECLARE SUB ClearMouse ()
DECLARE SUB DisplayTab (Var%)
DECLARE SUB DisplayCriticalError (Var%)
DECLARE SUB DisplayScreen3X ()
DECLARE SUB HexCalc ()


'-end-

