Rem Small full screen editor for QB64 v4.6a 06/15/2025 PD.
Rem Initial port to QB64 v1.0a
Rem New v2.0a:
Rem    Adds insert cursor for overstrike in Backspace, Tab, and InsertChar.
Rem    Adds support for 40 column editing and display.
Rem New v3.0a:
Rem    Adds ListFiles and SearchFiles.
Rem New v3.1a:
Rem    Fixes some scrolling in SearchFiles.
Rem New v3.2a:
Rem    Adds Ctrl-C copyfile in SearchFiles.
Rem    Adds Ctrl-D changedrive in SearchFiles.
Rem    Adds OldSkool directory delete in SearchFiles.
Rem New v3.3a:
Rem    Adds F1 help key to ScrnEdit.
Rem    Adds F1 help key to SearchFiles.
Rem New v3.4a:
Rem    Adds _hide to shell in SearchFiles.
Rem    Adds drives to file list in SearchFiles.
Rem    Adds shell to vol to SearchFiles.
Rem New v3.5a:
Rem    Moves F2 display in SearchFiles.
Rem    Adds F4 toggle sort order in SearchFiles.
Rem    Display Drive: and Dir: and File: in Display.Screen in SearchFiles.
Rem New v3.6a:
Rem    Adds DriveList to improve display in Display.Screen in SearchFiles.
Rem    Adds custom FileExists and DirExists functions.
Rem    Adds Ctrl-E MKdir and Ctrl-F refresh to SearchFiles.
Rem New v3.7a:
Rem    Adds buffer to Ctrl-C CopyFile in SearchFiles to improve copying speed.
Rem    Adds F8 to recursively load file in ScrnEdit.
Rem New v3.8a:
Rem    Fixes buffer overrun in CopyFile in SearchFiles.
Rem    Fixes pagedown in Ctrl-End in SearchFiles.
Rem    Fixes error with long filename.
Rem New v4.0a:
Rem    Adds Ctrl-G RenameFile in SearchFiles.
Rem    Adds Ambig$ function to ValidFileChar2$
Rem    Adds file exists ValidFileChar3$ function to ScrnEdit.
Rem New v4.1a:
Rem    Adds Tab and Shift-Tab to SearchFiles.
Rem    Adds Control-Right and Control-Left to SearchFiles.
Rem    Adds Control-Up and Control-Down to SearchFiles.
Rem    Checks Ctrl-D ChangeDrive is in drivelist.
Rem New v4.2a:
Rem    Adds F4 AppendFile and F5 InsertFile to ScrnEdit.
Rem    Fixes array error in InsertFile.
Rem    Adds '-/+', 'a-z', 'A-Z', '0-9' to scan filename in SearchFiles.
Rem    Adds F3 to search filename in SearchFile. And Ctrl-F3 to repeat search.
Rem New v4.3a:
Rem    Adds counters and continuous display to ListFiles.
Rem    Adds FormatString$ output display to ListFiles.
Rem New v4.4a:
Rem    Adds prompt for DirSpec in SearchFiles.
Rem    Adds F4 to sort files and F5 to sort dirs in SearchFiles.
Rem    Adds F6 to recursively call SearchFiles.
Rem New v4.5a:
Rem    Adds custom Command$ function.
Rem New v4.6a:
Rem    Fixes exit sub in SearchFiles.
Rem    Fixes read command$ in startloop.

Rem $Dynamic
_ControlChr Off

' set screen mode and location
Screen 0
Do: _Limit 10: Loop Until _ScreenExists
_Title "SCRNEDIT"
_ScreenMove _Middle

DECLARE SUB RDOldSkool (V$)

DECLARE SUB ListFiles()
DECLARE SUB SearchFiles()

DECLARE SUB Amount (Var#, Var$)
DECLARE SUB Back.Space ()
DECLARE SUB Display.Status.Line (Var!, Var$)
DECLARE SUB Dot.Display (VarA!, VarB!, VarC!)
DECLARE SUB Edit.Status.Line ()
DECLARE SUB InstrSUB1 (Var!, Var1$, Var2$, VarQ!)
DECLARE SUB Scrnedit (OutX$, Inpt)

DECLARE FUNCTION FormatString$ (s#)
DECLARE FUNCTION IsNumeric! (X$)
Declare Function PercentDisplay$ (B&, F&)
Declare Function ValidFileChar (V$)
Declare Function ValidFileChar2$ (V$)
Declare Function CheckDrive$ (i)

' declare filename buffer
Const xbuflen = 32767 ' can be changed
Dim Shared xbuffer As String * xbuflen

Dim Shared DriveList(26) As String

Dim Shared Start.Directory As String

' screen override variables
Dim Shared Max.Row As Integer
Dim Shared Width1 As Integer
Dim Shared Width2 As Integer
Dim Shared Width3 As Integer
Max.Row = 25
Width1 = 80
Width2 = 79
Width3 = 78
Screen 0

' store default start directory
Start.Directory = _CWD$
If Right$(Start.Directory, 1) <> "\" Then
   Start.Directory = Start.Directory + "\"
End If

On Error GoTo Error.Routine

x$ = RTrim$(Read.Command$)
If Len(x$) Then
   GoTo StartMain
End If
Color 14
Print "Welcome to the screen editor v4.6a"
Color 15
Print "Override screen size(y/n)? ";
InputC$ = ""
Do
   _Limit 50
   Locate , , 1
   InputC$ = InKey$
   If LCase$(InputC$) = "n" Then
      Print "n"
      Exit Do
   End If
   If LCase$(InputC$) = "y" Then
      Print "y"
      Do
         Print "Enter width(40,80)";
         Input VarX
         If VarX = 40 Or VarX = 80 Then
            Width1 = VarX
            Width2 = VarX - 1
            Width3 = VarX - 2
            Exit Do
         End If
      Loop
      Do
         Print "Enter height(25,43,50)";
         Input VarX
         If VarX = 25 Or VarX = 43 Or VarX = 50 Then
            Max.Row = VarX
            Exit Do
         End If
      Loop
      Exit Do
   End If
Loop
Width Width1, Max.Row
101
StartLoop:
Color 14
Print "Enter the screen editor v4.6a"
Color 15
Print "Enter filename(?=list,*=search)";
Input x$
x$ = RTrim$(LTrim$(x$))
If x$ = "?" Then
   Timer Off
   Call ListFiles
   Cls
   GoTo StartLoop
End If
If x$ = "*" Then
   Timer Off
   Call SearchFiles
   Cls
   GoTo StartLoop
End If
If x$ = "" Then
   Locate , , 1, 7, 7
   Color 7, 0
   End
End If

StartMain:
If Len(x$) Then
   ' trim spaces
   Do
      V = InStr(x$, "  ")
      If V Then
         x$ = Left$(x$, V) + Mid$(x$, V + 2)
      Else
         Exit Do
      End If
   Loop

   ' loop filename by spaces
   Z$ = x$
   Do
      V = InStr(Z$, " ")
      If V Then
         x$ = Left$(Z$, V - 1)
         Z$ = Mid$(Z$, V + 1)
         If Len(x$) Then
            x$ = ValidFileChar2$(x$)
            If Len(x$) Then
               Call Scrnedit(x$, -1)
            End If
         End If
      Else
         x$ = Z$
         If Len(x$) Then
            x$ = ValidFileChar2$(x$)
            If Len(x$) Then
               Call Scrnedit(x$, -1)
            End If
         End If
         If Len(RTrim$(Read.Command$)) Then
            Exit Do
         Else
            GoTo StartLoop
         End If
      End If
   Loop
End If
Locate , , 1, 7, 7
Color 7, 0
End

Timer1:
x = CsrLin: Y = Pos(0)
TempX$ = "Editor > time: " + Date$ + " " + Time$
TempX$ = Left$(TempX$, Width2)
TempX$ = TempX$ + Space$(Width2 - Len(TempX$))
Call Display.Status.Line(-1, TempX$)
Locate x, Y, 1
Return

Error.Routine:
Color 7, 0
Cls
Color 12, 0
Print "Error:"; Err; " IDE line:"; _ErrorLine
Color 15
Print "Enter (R)etry,(S)tart,(Q)uit";
x$ = ""
Do
   _Limit 50
   x$ = InKey$
   If LCase$(x$) = "r" Then Print: Resume
   If LCase$(x$) = "s" Then Print: Resume 101
   If LCase$(x$) = "q" Then Print: Color 7: End
Loop
End

Sub ListFiles
   Dim TempFile As String
   Dim DirCount As Double
   Dim FileCount As Double
   Dim ByteCount As Double
   TempFile = MakeTempFile$
   Start.Sub2:
   Print "Enter filespec(*.*)";
   Input Spec$
   If Spec$ = "" Then Spec$ = "*.*"
   If Len(Spec$) Then
      If ValidFileChar(Spec$) Then
         GoTo Start.Sub2
      End If
      Print "Searching "; Spec$
      X = 1
      For Z = 1 To 2
         Close #1
         If Z = 1 Then ' directories
            Shell _Hide "DIR " + Spec$ + " /b/ad > " + TempFile
         End If
         If Z = 2 Then ' filenames
            Shell _Hide "DIR " + Spec$ + " /b/a-d > " + TempFile
         End If
         Open TempFile For Input As #1
         Found = 0
         Do While Not EOF(1)
            Line Input #1, X$
            If Z = 1 Then
               DirCount = DirCount + 1#
               Found = -1
               Color 15
               If Len(X$ + " (DIR)") <= Width2 Then
                  Print X$ + " (DIR)"
               Else
                  Print Left$(X$, Width2)
               End If
            End If
            If Z = 2 Then
               FileCount = FileCount + 1#
               Found = -1
               Close #2
               Open X$ For Binary As #2
               X# = LOF(2)
               ByteCount = ByteCount + X#
               Close #2
               Color 15
               If Len(X$ + " (" + FormatString$(X#) + ")") <= Width2 Then
                  Print X$ + " (" + FormatString$(X#) + ")"
               Else
                  Print Left$(X$, Width2)
               End If
            End If
            X = X + 1
            If X >= Max.Row - 2 Then
               X = 0
               If c = 0 Then
                  Color 14
                  Print "-more(y/n/c)-";
                  Do
                     _Limit 50
                     z$ = InKey$
                     If LCase$(z$) = "c" Then c = -1: Print "c": Exit Do
                     If LCase$(z$) = "n" Then Print "n": Exit For
                     If LCase$(z$) = "y" Then Print "y": Exit Do
                     If LCase$(z$) = " " Then Print: Exit Do
                     If LCase$(z$) = Chr$(13) Then Print: Exit Do
                  Loop
               End If
            End If
         Loop
         Close #1
         If c = 0 Then
            If X And Found Then
               Color 14
               Print "-more-";
               While InKey$ = ""
                  _Limit 50
               Wend
               Print
            End If
         End If
      Next
   End If
   ' remove temp file
   Close #1
   If _FileExists(TempFile) Then
      Kill TempFile
   End If
   ' display totals
   Color 15
   Print "Dirs: "; FormatString$(DirCount); " ";
   Print "Files: "; FormatString$(FileCount); " ";
   Print "Bytes: "; FormatString$(ByteCount)
   Color 14
   Print "-more-";
   While InKey$ = ""
      _Limit 50
   Wend
   Print
End Sub

Sub SearchFiles
   Dim TempFile As String
   TempFile = MakeTempFile$
   Const MaxInt = 32766 ' zero-based
   Const MaxLong = 2147483647
   Const Nul = ""
   Const TabStop = 8
   Dim LineX As String
   Dim Max.Dirs As Long
   Dim Max.Files As Long
   Dim Max.Lines As Long
   Dim Max.File As Long
   Inserting = -1
   Dim Filenames(1) As String
   Dim FileType(1) As Integer
   Dim Current.Directory As String
   Dim Current.File As Long
   Dim Current.Line As Long
   Dim SortOrder As Integer
   Dim SortOrder2 As Integer
   SortOrder = -1
   SortOrder2 = -1
   Line.Length = 5
   If Width1 = 40 Then
      Line.Length = 2
   End If

   Current.Directory = _CWD$
   If Right$(Current.Directory, 1) <> "\" Then
      Current.Directory = Current.Directory + "\"
   End If

   ' read in all drives.
   Cls
   Color 12, 1
   Print "Loading drives.";
   Color 15, 0
   Max.Drives = 0
   t$ = MakeTempFile$
   For i = 1 To 26
      i$ = Chr$(i + 64) + ":"
      j$ = "cd " + i$
      Shell _Hide j$ + " > " + t$
      Close #1
      Open t$ For Input As #1
      If EOF(1) = 0 Then
         Line Input #1, s$
         s$ = LCase$(s$)
         If s$ = "path not found" Then
            ' eat
         Else
            VarQ$ = CheckDrive$(i)
            If Len(VarQ$) Then
               Max.Drives = Max.Drives + 1
               DriveList(i) = VarQ$
            End If
         End If
      End If
   Next
   Close #1
   Kill t$
   Print " List"; Max.Drives; "drives."

   Start.Sub:
   Print "Enter dirspec(*)";
   Input SpecD$
   If SpecD$ = "" Then SpecD$ = "*"
   If InStr(SpecD$, "\") Then
      GoTo Start.Sub
   End If
   If InStr(SpecD$, ":") Then
      GoTo Start.Sub
   End If
   If ValidFileChar(SpecD$) Then
      GoTo Start.Sub
   End If

   Print "Enter filespec(*.*)";
   Input SpecF$
   If SpecF$ = "" Then SpecF$ = "*.*"
   If InStr(SpecF$, "\") Then
      GoTo Start.Sub
   End If
   If InStr(SpecF$, ":") Then
      GoTo Start.Sub
   End If
   If ValidFileChar(SpecF$) Then
      GoTo Start.Sub
   End If

   Start.Loop:
   Cls
   ReDim Filenames(26) As String
   ReDim FileType(26) As Integer
   Color 12, 1
   Print "Loading files."
   Color 15, 0
   Max.Dirs = 0&
   Max.Files = Max.Drives
   Max.Lines = 0&
   Max.File = 0&
   SpecDir$ = Current.Directory + SpecD$

   ' read directories
   Close #1
   Shell _Hide "DIR " + SpecDir$ + " /b/ad > " + TempFile
   Open TempFile For Input As #1

   Do While Not EOF(1)
      Line Input #1, LineX
      If Max.Files >= MaxLong Then
         Exit Do
      End If
      Max.Dirs = Max.Dirs + 1
      Max.Files = Max.Files + 1
      ReDim _Preserve Filenames(Max.Files) As String
      Filenames(Max.Files) = LineX
      ReDim _Preserve FileType(Max.Files) As Integer
      FileType(Max.Files) = -1
   Loop

   ' read filenames
   SpecDir$ = Current.Directory + SpecF$
   Close #1
   Shell _Hide "DIR " + SpecDir$ + " /b/a-d > " + TempFile
   Open TempFile For Input As #1

   Do While Not EOF(1)
      Line Input #1, LineX
      If Max.Files >= MaxLong Then
         Exit Do
      End If
      Max.Files = Max.Files + 1
      ReDim _Preserve Filenames(Max.Files) As String
      Filenames(Max.Files) = LineX
      ReDim _Preserve FileType(Max.Files) As Integer
      FileType(Max.Files) = 0
   Loop

   ' remove temp file
   Close #1
   If _FileExists(TempFile) Then
      Kill TempFile
   End If

   ' reload drives
   j = 0
   For i = 1 To 26
      If Len(DriveList(i)) Then
         j = j + 1
         Filenames(j) = Left$(DriveList(i), 3)
         FileType(j) = -2
      End If
   Next

   ' sort directories
   For Var1 = 1 To Max.Files
      For Var2 = Var1 To Max.Files
         If FileType(Var1) = -1 Then
            If FileType(Var2) = -1 Then
               If SortOrder2 Then
                  If Filenames(Var1) > Filenames(Var2) Then
                     Swap Filenames(Var1), Filenames(Var2)
                  End If
               Else
                  If Filenames(Var1) < Filenames(Var2) Then
                     Swap Filenames(Var1), Filenames(Var2)
                  End If
               End If
            End If
         End If
      Next
   Next

   ' sort filenames
   For Var1 = 1 To Max.Files
      For Var2 = Var1 To Max.Files
         If FileType(Var1) = 0 Then
            If FileType(Var2) = 0 Then
               If SortOrder Then
                  If Filenames(Var1) > Filenames(Var2) Then
                     Swap Filenames(Var1), Filenames(Var2)
                  End If
               Else
                  If Filenames(Var1) < Filenames(Var2) Then
                     Swap Filenames(Var1), Filenames(Var2)
                  End If
               End If
            End If
         End If
      Next
   Next

   ' begin search menu loop
   Timer Off
   Current.File = 1
   Current.Line = 1
   GoSub Display.Screen2
   Inpt$ = ""
   Do
      _Limit 50
      Inpt$ = InKey$
      If Len(Inpt$) Then
         Select Case Len(Inpt$)
            Case 1
               VarQ = 0
               If Inpt$ >= "a" And Inpt$ <= "z" Then VarQ = -1
               If Inpt$ >= "A" And Inpt$ <= "Z" Then VarQ = -1
               If Inpt$ >= "0" And Inpt$ <= "9" Then VarQ = -1
               If Inpt$ = "-" Or Inpt$ = "+" Then VarQ = -1
               ' scan filename
               StartSearch:
               If VarQ Then
                  ' store current position
                  Temp.Current.Item = Current.Item
                  Temp.Current.File = Current.File
                  Temp.Current.Line = Current.Line
                  ' scan current to right
                  If Temp.Current.File < Line.Length Then
                     For VarZ = Temp.Current.File To Line.Length - 1
                        If VarZ + 1 <= Max.Files Then
                           Temp.Current.File = VarZ + 1
                           Match = 0
                           VarQ$ = Filenames(Temp.Current.File)
                           If VarQ = -2 Then
                              Call CheckFilename(Search.Filename$, VarQ$, Match)
                           End If
                           If VarQ = -1 Then
                              If Left$(VarQ$, 1) = Inpt$ Then
                                 Match = -1
                              End If
                           End If
                           If Match Then
                              Current.File = Temp.Current.File
                              GoSub Display.Screen2
                              VarQ = 0
                              Exit For
                           End If
                        End If
                     Next
                  End If
                  ' scan to next line
                  If VarQ Then
                     Temp.Current.File = Temp.Current.File + 1
                     Do While Temp.Current.File <= Max.Files
                        For VarZ = Temp.Current.File To Temp.Current.File + Line.Length
                           If VarZ <= Max.Files Then
                              Match = 0
                              If VarQ = -2 Then
                                 VarQ$ = Filenames(VarZ)
                                 Call CheckFilename(Search.Filename$, VarQ$, Match)
                              End If
                              If VarQ = -1 Then
                                 If Left$(Filenames(VarZ), 1) = Inpt$ Then
                                    Match = -1
                                 End If
                              End If
                              If Match Then
                                 Current.File = VarZ
                                 Current.Line = Temp.Current.Line
                                 If Current.Line > Line.Length Then
                                    VarZ = Current.Line - Line.Length * 5
                                    If VarZ > 0 And VarZ <= Max.Files Then
                                       Current.Line = VarZ
                                    Else
                                       Current.Line = 1
                                    End If
                                 Else
                                    Current.Line = 1
                                 End If
                                 GoSub Display.Screen2
                                 VarQ = 0
                                 Exit Do
                              End If
                           End If
                        Next
                        Temp.Current.File = Temp.Current.File + Line.Length
                        Temp.Current.Line = Temp.Current.Line + Line.Length
                     Loop
                  End If
                  ' scan 1,1 to current
                  If VarQ Then
                     Temp.Current.File = 1
                     Temp.Current.Line = 1
                     Do While Temp.Current.File <= Current.File
                        For VarZ = Temp.Current.File To Temp.Current.File + Line.Length
                           If VarZ <= Max.Files Then
                              Match = 0
                              If VarQ = -2 Then
                                 VarQ$ = Filenames(VarZ)
                                 Call CheckFilename(Search.Filename$, VarQ$, Match)
                              End If
                              If VarQ = -1 Then
                                 If Left$(Filenames(VarZ), 1) = Inpt$ Then
                                    Match = -1
                                 End If
                              End If
                              If Match Then
                                 Current.File = VarZ
                                 Current.Line = Temp.Current.Line
                                 GoSub Display.Screen2
                                 VarQ = 0
                                 Exit Do
                              End If
                           End If
                        Next
                        Temp.Current.File = Temp.Current.File + Line.Length
                        Temp.Current.Line = Temp.Current.Line + Line.Length
                     Loop
                  End If
               End If

               If Inpt$ = Chr$(27) Then Exit Do ' escape
               If Inpt$ = Chr$(9) Then ' tab to right
                  If Current.Item < Line.Length Then
                     If Current.File + 1 <= Max.Files Then
                        Current.File = Current.File + 1
                        GoSub Display.Screen2
                     End If
                  End If
               End If
               If Inpt$ = Chr$(4) Then ' ctrl-d change drive
                  Cls
                  Print "Enter drive(A-Z)";
                  Input Var$
                  Var$ = UCase$(Var$)
                  If Len(Var$) = 1 Then
                     If Var$ >= "A" And Var$ <= "Z" Then
                        Var$ = Var$ + ":\"
                        For Var = 1 To Max.Drives
                           If Filenames(Var) = Var$ Then
                              Current.Directory = Var$
                              GoTo Start.Loop
                           End If
                        Next
                     End If
                  End If
                  Print "Drive not found. Press key:";
                  While InKey$ = "": _Limit 50: Wend
                  GoSub Display.Screen2
               End If
               If Inpt$ = Chr$(6) Then ' ctrl-f refresh
                  GoTo Start.Loop
               End If
               If Inpt$ = Chr$(5) Then ' ctrl-e make dir
                  Cls
                  Print "Target dir";
                  Input Var$
                  If Var$ = "" Then GoTo Start.Loop
                  If ValidFileChar(Var$) Then
                     GoTo Start.Loop
                  End If
                  Target$ = Current.Directory + Var$
                  If _FileExists(Target$) Then
                     Print "File exists.";
                  Else
                     If _DirExists(Target$) Then
                        Print "Dir exists.";
                     Else
                        MkDir Target$
                        GoTo Start.Loop
                     End If
                  End If
                  Print " Press key:";
                  While InKey$ = "": _Limit 50: Wend: Print
                  GoSub Display.Screen2
               End If
               If Inpt$ = Chr$(7) Then ' ctrl-g renamefile
                  If Current.File Then
                     If FileType(Current.File) = 0 Then ' copy file
                        If Filenames(Current.File) > "" Then
                           Cls
                           Print "Target file";
                           Input Var$
                           If Var$ = "" Then GoTo Start.Loop
                           If ValidFileChar(Var$) Then
                              GoTo Start.Loop
                           End If
                           Source$ = Current.Directory + Filenames(Current.File)
                           Target$ = Current.Directory + Var$
                           If _FileExists(Target$) Then
                              Print "Target exists. Overwrite(y/n)";
                              X$ = ""
                              Do
                                 _Limit 50
                                 X$ = InKey$
                                 If LCase$(X$) = "y" Then Kill Target$: Exit Do
                                 If LCase$(X$) = "n" Then GoTo Start.Loop
                              Loop
                           End If
                           Name Source$ As Target$
                           GoTo Start.Loop
                        End If
                     End If
                  End If
               End If
               If Inpt$ = Chr$(3) Then ' ctrl-c copyfile
                  If Current.File Then
                     If FileType(Current.File) = 0 Then ' copy file
                        If Filenames(Current.File) > "" Then
                           Cls
                           Print "Target file";
                           Input Var$
                           If Var$ = "" Then GoTo Start.Loop
                           If ValidFileChar(Var$) Then
                              GoTo Start.Loop
                           End If
                           Source$ = Current.Directory + Filenames(Current.File)
                           Target$ = Current.Directory + Var$
                           If _FileExists(Target$) Then
                              Print "Target exists. Overwrite(y/n)";
                              X$ = ""
                              Do
                                 _Limit 50
                                 X$ = InKey$
                                 If LCase$(X$) = "y" Then Exit Do
                                 If LCase$(X$) = "n" Then GoTo Start.Loop
                              Loop
                           End If
                           ' copy file
                           VarD = 0
                           VarE = 0
                           VarF! = Timer
                           ' open/delete files
                           X = FreeFile
                           Open Source$ For Binary As #X
                           Y = FreeFile
                           Open Target$ For Output As #Y
                           Close Y
                           Y = FreeFile
                           Open Target$ For Binary As #Y
                           ' copy file in binary form
                           File.Size& = LOF(X)
                           StartTimer = Timer
                           Var& = 0&
                           Do Until EOF(X)
                              _Limit 50
                              If InKey$ = Chr$(27) Then
                                 Print "Copy abort! Press key:"
                                 While InKey$ = "": _Limit 50: Wend
                                 Exit Do
                              End If
                              Call Dot.Display(VarD, VarE, VarF!)
                              Elapsed = Timer - StartTimer
                              If Elapsed < 0 Then Elapsed = Elapsed + 86400
                              If Elapsed >= 1 Then
                                 StartTimer = Timer
                                 P$ = PercentDisplay$(Var&, File.Size&)
                                 If Len(P$) Then
                                    _Title "Screen edit copying file " + Filenames(Current.File) + " - " + P$
                                 End If
                              End If
                              Var& = Var& + xbuflen
                              Var2& = Var&
                              If Var& > LOF(X) Then Var& = LOF(X)
                              Get X, , xbuffer
                              If EOF(X) Then
                                 ' trim trailing nuls
                                 X$ = xbuffer
                                 Do
                                    If Var2& <= LOF(X) Then
                                       Exit Do
                                    End If
                                    If Right$(X$, 1) = Chr$(0) Then
                                       X$ = Left$(X$, Len(X$) - 1)
                                       Var2& = Var2& - 1&
                                    Else
                                       Exit Do
                                    End If
                                 Loop
                                 Put Y, , X$
                              Else
                                 Put Y, , xbuffer
                              End If
                           Loop
                           Close X, Y
                           _Title "SCRNEDIT"
                           GoTo Start.Loop
                        End If
                     End If
                  End If
               End If
               If Inpt$ = Chr$(8) Then ' backspace
                  Current.Directory = Left$(Current.Directory, Len(Current.Directory) - 1)
                  For Var = Len(Current.Directory) To 1 Step -1
                     If Mid$(Current.Directory, Var, 1) = "\" Then
                        Current.Directory = Left$(Current.Directory, Var - 1)
                        Exit For
                     End If
                  Next
                  If Right$(Current.Directory, 1) <> "\" Then
                     Current.Directory = Current.Directory + "\"
                  End If
                  Cls
                  GoTo Start.Loop
               End If
               If Inpt$ = Chr$(13) Then ' enter
                  If Current.File Then
                     If FileType(Current.File) = -2 Then ' move to drive
                        Current.Directory = Filenames(Current.File)
                        Cls
                        GoTo Start.Loop
                     Else
                        If FileType(Current.File) = -1 Then ' move to directory
                           Current.Directory = Current.Directory + Filenames(Current.File) + "\"
                           Cls
                           GoTo Start.Loop
                        Else
                           If Filenames(Current.File) > "" Then
                              Cls
                              Strng$ = Filenames(Current.File)
                              Print "Edit " + Chr$(34) + Strng$ + Chr$(34) + "(y/n)?";
                              X$ = ""
                              Do
                                 _Limit 50
                                 X$ = InKey$
                                 If LCase$(X$) = "n" Then
                                    Print
                                    GoSub Display.Screen2
                                    Exit Do
                                 End If
                                 If LCase$(X$) = "y" Then
                                    Print
                                    Strng$ = Current.Directory + Filenames(Current.File)
                                    Call Scrnedit(Strng$, -1)
                                    Timer Off
                                    GoSub Display.Screen2
                                    Exit Do
                                 End If
                              Loop
                           End If
                        End If
                     End If
                  End If
               End If
            Case 2
               Inpt2 = Asc(Right$(Inpt$, 1))
               Select Case Inpt2
                  Case 59 ' F1 - edit about file
                     VarZ2$ = Start.Directory$ + "scrnedit.txt"
                     If _FileExists(VarZ2$) Then
                        Call Scrnedit(VarZ2$, 0)
                        Timer Off
                     End If
                     Color 15, 0
                     GoSub Display.Screen2
                  Case 60 ' F2 - restart input loop
                     Cls
                     GoTo Start.Sub
                  Case 61 ' F3 - search filename
                     Cls
                     Print "Edit filespec(?, *, ^ allowed)";
                     Input Search.Filename$
                     If Search.Filename$ = "" Then GoTo Start.Loop
                     Color 15, 0
                     GoSub Display.Screen2
                     VarQ = -2
                     GoTo StartSearch
                  Case 96 ' Ctrl-F3 - repeat search
                     If Len(Search.Filename$) Then
                        VarQ = -2
                        GoTo StartSearch
                     End If
                  Case 62 ' F4 - toggle file sort order
                     SortOrder = Not SortOrder
                     Cls
                     GoTo Start.Loop
                  Case 63 ' F5 - toggle dir sort order
                     SortOrder2 = Not SortOrder2
                     Cls
                     GoTo Start.Loop
                  Case 64 ' F6 - recurse searchfiles
                     Call SearchFiles
                     Cls
                     GoTo Start.Loop
                  Case 73 ' pageup
                     For VarQ = 1 To Max.Row - 1
                        If Current.File - Line.Length < Current.Line Then
                           If Current.Line - Line.Length >= 1 Then
                              Current.File = Current.File - Line.Length
                              Current.Line = Current.Line - Line.Length
                           End If
                        Else
                           If Current.File - Line.Length >= 1 Then
                              Current.File = Current.File - Line.Length
                           Else
                              Current.File = 1
                              Current.Line = 1
                              Exit For
                           End If
                        End If
                     Next
                     GoSub Display.Screen2
                  Case 81 ' pagedown
                     For VarQ = 1 To Max.Row - 1
                        Max.Items = (Max.Row - 1) * Line.Length
                        If Current.File + Line.Length <= Max.Items Then
                           If Current.File + Line.Length <= Max.Files Then
                              Current.File = Current.File + Line.Length
                           End If
                        Else
                           If Current.File + Line.Length <= Max.Files Then
                              Current.File = Current.File + Line.Length
                              Current.Line = Current.Line + Line.Length
                           Else
                              Current.File = Current.File + Line.Length
                              If Current.File > Max.Files Then
                                 Current.File = Max.Files
                                 Exit For
                              End If
                           End If
                        End If
                     Next
                     GoSub Display.Screen2
                  Case 119 ' ctrl-home
                     Current.File = 1
                     Current.Line = 1
                     GoSub Display.Screen2
                  Case 117 ' ctrl-end
                     If Max.Files <= (Max.Row - 1) * Line.Length Then
                        ' perform page-down if max row less than one page length
                        For VarQ = 1 To Max.Row - 1
                           Max.Items = (Max.Row - 1) * Line.Length
                           If Current.File + Line.Length <= Max.Items Then
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                              End If
                           Else
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                                 Current.Line = Current.Line + Line.Length
                              Else
                                 Current.File = Current.File + Line.Length
                                 If Current.File > Max.Files Then
                                    Current.File = Max.Files
                                    Exit For
                                 End If
                              End If
                           End If
                        Next
                        GoSub Display.Screen2
                     Else
                        ' jump to end of max rows page length
                        Max.Items = (Max.Row - 1) * Line.Length
                        Do Until Current.File >= Max.Files
                           If Current.File + Line.Length <= Max.Items Then
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                              End If
                           Else
                              If Current.File + Line.Length <= Max.Files Then
                                 Current.File = Current.File + Line.Length
                                 Current.Line = Current.Line + Line.Length
                              Else
                                 Current.File = Current.File + Line.Length
                                 If Current.File >= Max.Files Then
                                    Current.File = Max.Files
                                    Exit Do
                                 End If
                              End If
                           End If
                           'GoSub Display.Screen2
                        Loop
                     End If
                     ' move to last item in last page
                     If Max.Files > 0 Then
                        Current.File = Max.Files
                        GoSub Display.Screen2
                     End If
                  Case 83 ' delete
                     If Current.File Then
                        If Filenames(Current.File) > "" Then
                           If FileType(Current.File) = -2 Then ' delete drive
                              Cls
                              Print "Delete drive(y/n)?";
                              Do
                                 _Limit 50
                                 X$ = InKey$
                                 If LCase$(X$) = "n" Then Exit Do
                                 If LCase$(X$) = "y" Then
                                    File$ = Filenames(Current.File)
                                    If File$ > "" Then
                                       Call RDOldSkool(File$)
                                    End If
                                    Cls
                                    GoTo Start.Loop
                                 End If
                              Loop
                              GoSub Display.Screen2
                           Else
                              If FileType(Current.File) = -1 Then ' delete dir
                                 Cls
                                 Print "Delete dir(y/n)?";
                                 Do
                                    _Limit 50
                                    X$ = InKey$
                                    If LCase$(X$) = "n" Then Exit Do
                                    If LCase$(X$) = "y" Then
                                       File$ = Current.Directory + Filenames(Current.File)
                                       If File$ > "" Then
                                          Call RDOldSkool(File$)
                                       End If
                                       Cls
                                       GoTo Start.Loop
                                    End If
                                 Loop
                                 GoSub Display.Screen2
                              Else
                                 If FileType(Current.File) = 0 Then ' delete file
                                    Cls
                                    Print "Delete file(y/n)?";
                                    Do
                                       _Limit 50
                                       X$ = InKey$
                                       If LCase$(X$) = "n" Then Exit Do
                                       If LCase$(X$) = "y" Then
                                          File$ = Current.Directory + Filenames(Current.File)
                                          If File$ > "" Then
                                             Kill File$
                                          End If
                                          Cls
                                          GoTo Start.Loop
                                       End If
                                    Loop
                                    GoSub Display.Screen2
                                 End If
                              End If
                           End If
                        End If
                     End If
                  Case 71 ' home
                     Do
                        If Current.Item > 1 Then
                           Current.File = Current.File - 1
                           GoSub Display.Screen2
                        Else
                           Exit Do
                        End If
                     Loop
                  Case 79 ' end
                     Do
                        If Current.Item < Line.Length Then
                           If Current.File + 1 <= Max.Files Then
                              Current.File = Current.File + 1
                              GoSub Display.Screen2
                           Else
                              Exit Do
                           End If
                        Else
                           Exit Do
                        End If
                     Loop
                  Case 82 ' insert
                     Cls
                     Print "Edit file";
                     Input Var$
                     If Var$ = "" Then GoTo Start.Loop
                     If InStr(Var$, "*") Then
                        GoTo Start.Loop
                     End If
                     If InStr(Var$, "?") Then
                        GoTo Start.Loop
                     End If
                     If ValidFileChar(Var$) Then
                        GoTo Start.Loop
                     End If
                     Target$ = Current.Directory + Var$
                     Call Scrnedit(Target$, -1)
                     Timer Off
                     GoTo Start.Loop
                  Case 72, 141 ' up/ctrl-up
                     If Current.File > 1 Then
                        VarX = 0
                        For VarQ = 0 To Line.Length - 1
                           If Current.File - VarQ = Current.Line Then
                              If Current.Line - Line.Length >= 1 Then
                                 Current.File = Current.File - Line.Length
                                 Current.Line = Current.Line - Line.Length
                              End If
                              If Current.File < 1 Then
                                 Current.File = 1
                              End If
                              If Current.Line < 1 Then
                                 Current.Line = 1
                              End If
                              VarX = -1
                              GoSub Display.Screen2
                              Exit For
                           End If
                        Next
                        If VarX = 0 Then
                           If Current.File - Line.Length >= 1 Then
                              Current.File = Current.File - Line.Length
                              If Current.File < Current.Line Then
                                 Current.Line = Current.Line - Line.Length
                                 If Current.Line < 1 Then
                                    Current.Line = 1
                                 End If
                              End If
                              GoSub Display.Screen2
                           Else
                              Current.File = 1
                              Current.Line = 1
                              GoSub Display.Screen2
                           End If
                        End If
                     End If
                  Case 80, 145 ' down/ctrl-down
                     Max.Items = (Max.Row - 1) * Line.Length ' length of a page
                     Max.Items2 = Current.Line + Max.Items - Line.Length ' length of last line on a page
                     If Max.Items2 > Max.Files Then
                        Max.Items2 = Max.Files
                     End If
                     If Max.Items2 < 1 Then
                        Max.Items2 = 1
                     End If
                     If Current.File + Line.Length <= Max.Items Then
                        If Current.File + Line.Length <= Max.Files Then
                           Current.File = Current.File + Line.Length
                           GoSub Display.Screen2
                        End If
                     Else
                        If Current.File + Line.Length <= Max.Files Then
                           Current.File = Current.File + Line.Length
                           If Current.File > Max.Items2 Then
                              If Current.Line + Line.Length <= Max.Files Then
                                 Current.Line = Current.Line + Line.Length
                              End If
                           End If
                           GoSub Display.Screen2
                        Else
                           Current.File = Current.File + Line.Length
                           If Current.File > Max.Files Then
                              Current.File = Max.Files
                              GoSub Display.Screen2
                           End If
                        End If
                     End If
                  Case 15, 75, 115 ' shift-tab/left/ctrl-left
                     If Current.Item > 1 Then
                        Current.File = Current.File - 1
                        GoSub Display.Screen2
                     End If
                  Case 77, 116 ' right/ctrl-right
                     If Current.Item < Line.Length Then
                        If Current.File + 1 <= Max.Files Then
                           Current.File = Current.File + 1
                           GoSub Display.Screen2
                        End If
                     End If
               End Select
         End Select
      End If
   Loop
   Exit Sub

   Display.Screen2:
   Cls
   CursorX = CsrLin
   CursorY = Pos(0)
   Line1 = 0
   Line2 = 0
   Found = 0
   For Var = Current.Line To Max.Files
      Line2 = Line2 + 1
      If Line2 > Line.Length Then
         Line2 = 1
         Line1 = Line1 + 1
         If Line1 >= Max.Row - 1 Then
            Exit For
         End If
         Print
      End If
      Strng$ = Filenames(Var)
      Var$ = Strng$
      ' display drive
      If FileType(Var) = -2 Then
         If Len(Strng$) > 12 Then
            Strng$ = Left$(Strng$, 11) + "*"
         End If
         Strng$ = Strng$ + Space$(15 - Len(Strng$))
      End If
      ' display directory
      If FileType(Var) = -1 Then
         Found = -1
         If Len(Strng$) > 12 Then
            Strng$ = Left$(Strng$, 11) + "*"
         End If
         Strng$ = "[" + Strng$ + "]"
         Strng$ = Strng$ + Space$(15 - Len(Strng$))
      End If
      ' display filename
      If FileType(Var) = 0 Then
         Found = -1
         If Len(Strng$) > 12 Then
            Strng$ = Left$(Strng$, 11) + "*"
         End If
         Strng$ = Strng$ + Space$(15 - Len(Strng$))
      End If
      ' hilight current file
      If Var = Current.File Then
         Current.Item = Line2
         Color 15, 1
         Print Strng$;

         X = CsrLin: Y = Pos(0)
         If FileType(Var) = -2 Then ' drive
            Drive = Asc(Left$(Var$, 1)) - 64
            VarQ$ = DriveList(Drive)
            TempX$ = "Editor > drive: " + VarQ$
         Else
            If FileType(Var) = -1 Then ' dir
               TempX$ = "Editor > dir: " + Current.Directory + Var$
            Else
               TempX$ = "Editor > file: " + Current.Directory + Var$
               If _FileExists(Current.Directory + Var$) Then
                  Z = FreeFile
                  Open Current.Directory + Var$ For Binary As Z
                  X& = LOF(Z)
                  Close Z
                  Z$ = " (" + LTrim$(FormatString$(X&)) + " bytes)"
                  If Len(TempX$ + Z$) < Width2 Then
                     TempX$ = TempX$ + Z$
                  End If
               End If
            End If
         End If
         TempX$ = Left$(TempX$, Width2)
         TempX$ = TempX$ + Space$(Width2 - Len(TempX$))
         Call Display.Status.Line(-1, TempX$)
         Locate X, Y, 1

         CursorX = CsrLin
         CursorY = Pos(0) - 15
         If CursorY < 1 Then CursorY = 1
      Else
         Color 15, 0
         Print Strng$;
      End If
   Next
   If Found = 0 Then
      Print
      If Line.Length = 40 Then
         Print "File not found. Press F2";
      Else
         Print "File not found. Press F2 to reload file spec.";
      End If
   End If
   Locate CursorX, CursorY, 1
   Return
End Sub

Sub Amount (Var#, Var$)
   If Var# = 0# Then
      Var$ = " 0"
   Else
      If InStr(Str$(Var#), "D") Then
         Var$ = Str$(Var#)
      Else
         Var$ = " " + FormatString$(Var#)
      End If
   End If
End Sub

Sub Back.Space
   If Pos(0) > 1 Then
      Locate CsrLin, Pos(0) - 1, 0
      Print " ";
      Locate CsrLin, Pos(0) - 1, 1
   End If
End Sub

' display status line
Sub Display.Status.Line (Var, Var$)
   If Var Then
      Color 14, 1
   Else
      Color 15, 0
   End If
   Locate Max.Row, 1, 0
   Print Var$;
   Locate Max.Row, Width1
   If Var Then
      Color 0, 1
   Else
      Color 7, 0
   End If
   Print " ";
   Locate Max.Row - 1, 1, 1
   Color 15, 0
End Sub

Function PercentDisplay$ (Sum.Bytes2&, File.Size&)
   Static Percent.Flag As Integer
   Static Last.Percent As Integer
   ' check to display percent copied
   PercentDisplay = ""
   If File.Size& > 0& Then
      P$ = ""
      Percent = (Sum.Bytes2& / File.Size&) * 100!
      Percent = Int(Percent)
      If Percent = 0 Then
         If Percent.Flag = 0 Then
            P$ = "000%"
            PercentDisplay$ = P$
            Percent.Flag = -1
         End If
      Else
         If Percent <> Last.Percent Then
            Last.Percent = Percent
            P$ = Right$(Str$(Percent + 1000%), 3) + "%"
            PercentDisplay = P$
            Percent.Flag = -1
         End If
      End If
   End If
End Function

Sub Dot.Display (VarA, VarB, VarC!)
   VarG! = Timer - VarC!
   If VarG! < 0! Then VarG! = VarG! + 86400!
   If VarG! >= 1! Then
      VarC! = Timer
      If VarA = 0 Then
         VarB = VarB + 1
         Print ".";
         If VarB = 5 Then
            VarA = -1
            VarB = 0
         End If
      Else
         VarB = VarB + 1
         Call Back.Space
         Print " ";
         Call Back.Space
         If VarB = 5 Then
            VarA = 0
            VarB = 0
         End If
      End If
   End If
End Sub

' display editor status line
Sub Edit.Status.Line
   TempX$ = "Editor > time: " + Date$ + " " + Time$
   TempX$ = Left$(TempX$, Width2)
   TempX$ = TempX$ + Space$(Width2 - Len(TempX$))
   Call Display.Status.Line(-1, TempX$)
End Sub

' formats a double numeric string
Function FormatString$ (s#)
   X$ = ""
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      X$ = Mid$(s$, l - 2, 3) + "," + X$
   Next
   If l > 0 Then
      X$ = Mid$(s$, 1, l) + "," + X$
   End If
   If Len(s$) < 3 Then
      X$ = s$
   End If
   If Right$(X$, 1) = "," Then
      X$ = Left$(X$, Len(X$) - 1)
   End If
   X$ = e$ + X$ + q$ ' construct string
   FormatString$ = X$
End Function

' function to match case-sensitive substring with ?, * characters in substring
'  Return Var = -1 if match
'  VarQ = -1 force case-sensitive
'  See if Var1$ exists in Var2$
Sub InstrSUB1 (Var, Var1$, Var2$, VarQ)

   ' store case-sensitive string match variables
   If VarQ Then
      S2$ = Var1$
      S3$ = Var2$
   Else
      S2$ = LCase$(Var1$)
      S3$ = LCase$(Var2$)
   End If

   ' check default instr
   If InStr(S2$, "*") = 0 Then
      If InStr(S2$, "?") = 0 Then
         Var = InStr(S3$, S2$)
         Exit Sub
      End If
   End If

   Var = -1 ' assume match

   ' see if S2$ matches in S3$ with substrings
   For S3 = 1 To Len(S3$)
      S1$ = Mid$(S3$, S3)
      P1 = 1 ' pointer to S1$
      P2 = 1 ' pointer to S2$
      Do
         ' check match
         If P2 > Len(S2$) Then
            Exit Sub
         End If

         ' check character in S2$ at P2
         V$ = Mid$(S2$, P2, 1)
         Select Case V$
            Case "*" ' global character
               ' scan to next char
               If P2 > Len(S2$) Then
                  Exit Do
               End If
               S4$ = Mid$(S2$, P2 + 1, 1)
               Select Case S4$
                  Case "*", "?"
                     P2 = P2 + 1
                  Case Else
                     Do
                        If Mid$(S1$, P1, 1) = S4$ Then
                           Exit Do
                        End If
                        If P1 >= Len(S1$) Then
                           Exit Do
                        End If
                        P1 = P1 + 1
                     Loop
                     P2 = P2 + 1
               End Select
            Case "?" ' wildcard character
               P1 = P1 + 1
               P2 = P2 + 1
            Case Else ' ascii character
               If Mid$(S1$, P1, 1) <> V$ Then ' no match
                  Exit Do
               End If
               P1 = P1 + 1
               P2 = P2 + 1
         End Select
      Loop
   Next
   Var = 0 ' no match
End Sub

Function IsNumeric (X$)
   For V = 1 To Len(X$)
      If Mid$(X$, V, 1) >= "0" And Mid$(X$, V, 1) <= "9" Then
         Eat$ = ""
      Else
         IsNumeric = 0
         Exit Function
      End If
   Next
   IsNumeric = -1
End Function

Sub Make.Format (Var#, Var$)
   Var2# = Var#
   If Var2# <= 0 Then
      Var$ = "0.00 B"
      Exit Sub
   End If
   TempA = 0
   Do
      If Var2# < 1024# Then
         Exit Do
      End If
      Var2# = Var2# / 1024#
      TempA = TempA + 1
      If TempA = 8 Then
         Exit Do
      End If
   Loop
   Strng$ = ""
   If TempA >= 1 And TempA <= 8 Then
      Strng$ = Mid$("KMGTPEZY", TempA, 1)
   End If
   Var$ = FormatString$(Var2#) + " " + Strng$ + "B"
End Sub

' main fullscreen editor
Sub Scrnedit (OutX$, Inpt)
   Const MaxInt = 32766 ' zero-based
   Const MaxLong = 2147483647
   Const Nul = ""
   Const TabStop = 8
   Dim VarX As String * 1
   Dim VarY As String * 1
   Dim LineX As String
   Dim Temp.ArrayS(1) As String
   Dim Max.Lines As Long
   Dim Max.File As Long
   Inserting = -1
   On Timer(1) GoSub Timer1
   Timer On
   Call Edit.Status.Line
   Cls
   Filename$ = OutX$
   If Left$(Filename$, 1) = Chr$(34) Then
      Filename$ = Mid$(Filename$, 2)
      If Right$(Filename$, 1) = Chr$(34) Then
         Filename$ = Left$(Filename$, Len(Filename) - 1)
      End If
   End If
   File5 = FreeFile
   Close #File5
   If Filename$ = "" Then
      Exit Sub
   End If
   If InStr(Filename$, "?") Then
      Exit Sub
   End If
   If InStr(Filename$, "*") Then
      Exit Sub
   End If
   If _FileExists(Filename$) Then
      Open Filename$ For Binary As #File5 ' read file in binary
      Max.Lines = 0
      Var& = 0&
      LineX = Nul
      VarD = 0
      VarE = 0
      VarF! = Timer
      LINUXLoad = 0
      If Inpt Then
         Print "Edit file in Linux read mode(y/n)? ";
         Do
            _Limit 50
            X$ = InKey$
            If LCase$(X$) = "y" Then Print: LINUXLoad = -1: Exit Do
            If LCase$(X$) = "n" Then Print: LINUXLoad = 0: Exit Do
         Loop
      End If
      File.Size& = LOF(File5)
      StartTimer = Timer
      Do
         Call Dot.Display(VarD, VarE, VarF!)
         Var& = Var& + 1&
         Elapsed = Timer - StartTimer
         If Elapsed < 0 Then Elapsed = Elapsed + 86400
         If Elapsed >= 1 Then
            StartTimer = Timer
            P$ = PercentDisplay$(Var&, File.Size&)
            If Len(P$) Then
               _Title "Screen edit loading file " + Filename$ + " - " + P$
            End If
         End If
         If Var& > LOF(File5) Then
            If Len(LineX) Then
               If Max.Lines >= MaxLong Then
                  Print "Out of memory."
                  Close #File5
                  Erase Temp.ArrayS
                  Exit Sub
               End If
               Max.Lines = Max.Lines + 1
               ReDim _Preserve Temp.ArrayS(Max.Lines) As String
               Temp.ArrayS(Max.Lines) = LineX
            End If
            Exit Do
         End If
         Get #File5, Var&, VarX
         If InKey$ = Chr$(27) Then
            Print "Program load halted."
            Close #File5
            Erase Temp.ArrayS
            Exit Sub
         End If
         LineFeed = 0
         If LINUXLoad Then
            If VarX = Chr$(10) Then
               LineFeed = -1
            End If
         End If
         If VarX = Chr$(13) Then
            If Var& + 1& <= LOF(File5) Then
               Get #File5, Var& + 1&, VarY
               If VarY = Chr$(10) Then
                  Var& = Var& + 1&
                  LineFeed = -1
               End If
            End If
         End If
         If LineFeed Then
            If Max.Lines >= MaxLong Then
               Print "Out of memory."
               Close #File5
               Erase Temp.ArrayS
               Exit Sub
            End If
            Max.Lines = Max.Lines + 1
            ReDim _Preserve Temp.ArrayS(Max.Lines) As String
            Temp.ArrayS(Max.Lines) = LineX
            LineX = Nul
         Else
            LineX = LineX + VarX
         End If
      Loop
      Close #File5
      Max.File = Max.Lines
   End If
   Print
   _Title "Screen edit file " + Filename$
   If Max.Lines = 0 Then
      Max.File = 1
      Max.Lines = 1
      Line.Number = 1
      ReDim Temp.ArrayS(Max.Lines) As String
   End If
   Xcoor = 1
   Ycoor = 1
   Column = 1
   Row = 1
   Line.Number = 1
   Line.Length = 78
   GoSub Display.Screen
   Do
      If Inserting = -1 Then
         Locate Xcoor, Ycoor, 1, 3, 7
      Else
         Locate Xcoor, Ycoor, 1, 7, 7
      End If
      V = Column + Ycoor - 1
      Var# = CDbl(Line.Number)
      If Var# = 0# Then
         Var$ = " 0"
      Else
         Call Amount(Var#, Var$)
      End If
      If V = 0 Then
         Var2$ = " 0"
      Else
         Call Amount(CDbl(V), Var2$)
      End If
      Strng$ = "Row" + Var$ + " Column" + Var2$
      Strng2$ = ""
      If V > 0 And V <= Len(Temp.ArrayS(Line.Number)) Then
         V2 = Asc(Mid$(Temp.ArrayS(Line.Number), V, 1))
         Strng2$ = Strng2$ + " Ascii" + Str$(V2)
         Select Case V2
            Case 0
               Strng2$ = Strng2$ + " (nul)"
            Case 1
               Strng2$ = Strng2$ + " (soh)"
            Case 2
               Strng2$ = Strng2$ + " (stx)"
            Case 3
               Strng2$ = Strng2$ + " (etx)"
            Case 4
               Strng2$ = Strng2$ + " (eot)"
            Case 5
               Strng2$ = Strng2$ + " (enq)"
            Case 6
               Strng2$ = Strng2$ + " (ack)"
            Case 7
               Strng2$ = Strng2$ + " (bel)"
            Case 8
               Strng2$ = Strng2$ + " (bs)"
            Case 9
               Strng2$ = Strng2$ + " (tab)"
            Case 10
               Strng2$ = Strng2$ + " (lf)"
            Case 11
               Strng2$ = Strng2$ + " (vt)"
            Case 12
               Strng2$ = Strng2$ + " (np)"
            Case 13
               Strng2$ = Strng2$ + " (cr)"
            Case 14
               Strng2$ = Strng2$ + " (so)"
            Case 15
               Strng2$ = Strng2$ + " (si)"
            Case 16
               Strng2$ = Strng2$ + " (dle)"
            Case 17
               Strng2$ = Strng2$ + " (dc1)"
            Case 18
               Strng2$ = Strng2$ + " (dc2)"
            Case 19
               Strng2$ = Strng2$ + " (dc3)"
            Case 20
               Strng2$ = Strng2$ + " (dc4)"
            Case 21
               Strng2$ = Strng2$ + " (nak)"
            Case 22
               Strng2$ = Strng2$ + " (syn)"
            Case 23
               Strng2$ = Strng2$ + " (etb)"
            Case 24
               Strng2$ = Strng2$ + " (can)"
            Case 25
               Strng2$ = Strng2$ + " (em)"
            Case 26
               Strng2$ = Strng2$ + " (eof)"
            Case 27
               Strng2$ = Strng2$ + " (esc)"
            Case 28
               Strng2$ = Strng2$ + " (fs)"
            Case 29
               Strng2$ = Strng2$ + " (gs)"
            Case 30
               Strng2$ = Strng2$ + " (rs)"
            Case 31
               Strng2$ = Strng2$ + " (us)"
            Case 32
               Strng2$ = Strng2$ + " (spc)"
            Case 255
               Strng2$ = Strng2$ + " (?)"
            Case Else
               Strng2$ = Strng2$ + " (" + Chr$(V2) + ")"
         End Select
         If Len(Strng$ + Strng2$) <= 40 Then
            Strng$ = Strng$ + Strng2$
         End If
      End If
      If Inserting Then
         If Len(Strng$ + " Insert On") <= 40 Then
            Strng$ = Strng$ + " Insert On"
         End If
      Else
         If Len(Strng$ + " Insert Off") <= 40 Then
            Strng$ = Strng$ + " Insert Off"
         End If
      End If
      Strng$ = Left$(Strng$, 40)
      Strng$ = Strng$ + Space$(40 - Len(Strng$))
      Color 14, 1
      Locate Max.Row - 1, 1
      Print Strng$;
      Locate Xcoor, Ycoor
      Color 15, 0
      TempX$ = ""
      Do While TempX$ = ""
         _Limit 50
         TempX$ = InKey$
      Loop
      Select Case Len(TempX$)
         Case 1
            Select Case TempX$
               Case Chr$(18) ' ctrl-r = searchreplace
                  GoSub Replace.String
               Case Chr$(11) ' ctrl-k = insert ascii value
                  GoSub Insert.Char
               Case Chr$(6) ' search string (ctrl-f)
                  If Max.Lines > 0 Then
                     GoSub Search.String
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case Chr$(10) ' jump to byte (ctrl-j)
                  If Max.Lines > 0 Then
                     GoSub Jump.Byte
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case Chr$(7) ' goto to line (ctrl-g)
                  If Max.Lines > 0 Then
                     GoSub Jump.Line
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case Chr$(13) ' insert line
                  ' always increases array
                  If Max.File < MaxLong Then
                     Max.File = Max.File + 1
                     ReDim _Preserve Temp.ArrayS(Max.File) As String
                     ' above
                     If Column + Ycoor - 1 = 1 Then
                        For Temp1 = Max.Lines To Line.Number Step -1
                           Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                        Next
                        Temp.ArrayS(Line.Number) = Nul
                        Line.Number = Line.Number + 1
                        Max.Lines = Max.Lines + 1
                        If Xcoor < Max.Row - 2 Then
                           Xcoor = Xcoor + 1
                        End If
                     Else
                        ' below
                        If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                           Line.Number = Line.Number + 1 ' below
                           For Temp1 = Max.Lines To Line.Number Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           Temp.ArrayS(Line.Number) = Nul
                           If Xcoor < Max.Row - 2 Then
                              Xcoor = Xcoor + 1
                           End If
                           Max.Lines = Max.Lines + 1
                        Else
                           ' split line
                           For Temp1 = Max.Lines To Line.Number + 1 Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           T$ = Temp.ArrayS(Line.Number)
                           U$ = Mid$(T$, Column + Ycoor - 1)
                           T$ = Left$(T$, Column + Ycoor - 2)
                           Temp.ArrayS(Line.Number) = T$
                           Line.Number = Line.Number + 1 ' below
                           Temp.ArrayS(Line.Number) = U$
                           If Xcoor < Max.Row - 2 Then
                              Xcoor = Xcoor + 1
                           End If
                           Max.Lines = Max.Lines + 1
                        End If
                     End If
                  End If
                  Column = 1
                  Ycoor = 1
                  GoSub Display.Screen
               Case Chr$(8) ' backspace
                  q = Column + Ycoor - 1
                  If Line.Number <= 1 And q <= 1 Then ' no backspace at 1,1
                     Eat$ = Nul
                  Else
                     ' remove current line
                     If Temp.ArrayS(Line.Number) = Nul Then
                        ' pack array
                        For Temp1 = Line.Number To Max.Lines - 1
                           Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                        Next
                        If Xcoor > 1 Then
                           Xcoor = Xcoor - 1
                        End If
                        Line.Number = Line.Number - 1
                        Max.Lines = Max.Lines - 1
                        ' position at eol
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= Width1 Then
                           Column = End.Line - Width3
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     Else
                        ' concatenate previous line
                        If Column + Ycoor - 1 <= 1 Then
                           If Line.Number > 1 Then
                              If Line.Number <= Max.Lines Then
                                 Var = 0
                                 If Temp.ArrayS(Line.Number - 1) = Nul Then
                                    If Ycoor = 1 Then
                                       Var = -1
                                    End If
                                 End If

                                 ' position at eol
                                 If Var = 0 Then
                                    End.Line = Len(Temp.ArrayS(Line.Number - 1))
                                 End If

                                 Temp.ArrayS(Line.Number - 1) = Temp.ArrayS(Line.Number - 1) + Temp.ArrayS(Line.Number)
                                 For Temp1 = Line.Number To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 If Xcoor > 1 Then
                                    Xcoor = Xcoor - 1
                                 End If
                                 Line.Number = Line.Number - 1
                                 Max.Lines = Max.Lines - 1
                                 Column = 1
                                 Ycoor = 1

                                 ' position at eol
                                 If Var = 0 Then
                                    If End.Line >= Width1 Then
                                       Column = End.Line - Width3
                                       Ycoor = End.Line - Column + 2
                                    Else
                                       Ycoor = End.Line - Column + 2
                                    End If
                                 End If

                                 GoSub Display.Screen
                              End If
                           End If
                        Else
                           ' backspace 1 character
                           If Column + Ycoor - 2 > 0 Then
                              If Inserting Then
                                 T$ = Temp.ArrayS(Line.Number)
                                 T$ = Left$(T$, Column + Ycoor - 3) + Mid$(T$, Column + Ycoor - 1)
                                 Temp.ArrayS(Line.Number) = T$
                              End If
                              ' move cursor 1 left
                              If Ycoor > 1 Then
                                 Ycoor = Ycoor - 1
                                 GoSub Display.Screen
                              Else
                                 If Column > 1 Then
                                    Column = Column - 1
                                    GoSub Display.Screen
                                 End If
                              End If
                           End If
                        End If
                     End If
                  End If
               Case Chr$(9) ' tab
                  If Line.Number > 0 Then
                     If Inserting Then
                        TempX$ = Space$(TabStop)
                        T$ = Temp.ArrayS(Line.Number)
                        T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                        Temp.ArrayS(Line.Number) = T$
                        GoSub Display.Screen
                     End If
                  End If
                  If Column + Ycoor + (TabStop - 1) <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor + TabStop < Width1 Then
                        Ycoor = Ycoor + TabStop
                     Else
                        Column = Column + TabStop
                        GoSub Display.Screen
                     End If
                  Else ' end
                     End.Line = Len(Temp.ArrayS(Line.Number))
                     If End.Line >= Width1 Then
                        Column = End.Line - Width3
                        Ycoor = End.Line - Column + 2
                        GoSub Display.Screen
                     Else
                        Ycoor = End.Line - Column + 2
                     End If
                  End If
               Case Chr$(27) ' escape, exit editor
                  Exit Do
               Case Else ' insert character
                  If Line.Number > 0 Then
                     If Inserting Then
                        T$ = Temp.ArrayS(Line.Number)
                        T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                        Temp.ArrayS(Line.Number) = T$
                     Else
                        T$ = Temp.ArrayS(Line.Number)
                        If T$ = "" Then
                           T$ = TempX$
                        Else
                           If Column + Ycoor - 1 > Len(T$) Then
                              T$ = T$ + TempX$
                           Else
                              Mid$(T$, Column + Ycoor - 1, 1) = TempX$
                           End If
                        End If
                        Temp.ArrayS(Line.Number) = T$
                     End If
                     If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                        If Ycoor < Width1 Then
                           Ycoor = Ycoor + 1
                           GoSub Display.Screen
                        Else
                           Column = Column + 1
                           GoSub Display.Screen
                        End If
                     End If
                  End If
            End Select
         Case 2
            Temp = Asc(Mid$(TempX$, 2, 1))
            Select Case Temp
               Case 62 ' F4 - appendfile
                  GoSub AppendFile
                  Color 15, 0
                  GoSub Display.Screen
               Case 63 ' F5 - insertfile
                  GoSub InsertFile
                  Color 15, 0
                  GoSub Display.Screen
               Case 66 ' F8 - edit filename
                  Cls
                  Print "Edit file";
                  Input Var$
                  If Var$ = "" Then
                     Eat$ = Nul
                  Else
                     If InStr(Var$, "*") Then
                        Eat$ = Nul
                     Else
                        If InStr(Var$, "?") Then
                           Eat$ = Nul
                        Else
                           If ValidFileChar(Var$) Then
                              Eat$ = Nul
                           Else
                              Target$ = Var$
                              Call Scrnedit(Target$, -1)
                              'Timer Off
                           End If
                        End If
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case 59 ' F1 - edit about file
                  If Inpt Then
                     VarZ$ = Start.Directory + "scrnedit.txt"
                     If _FileExists(VarZ$) Then
                        Call Scrnedit(VarZ$, 0)
                        'Timer Off
                     End If
                     Color 15, 0
                     GoSub Display.Screen
                  End If
               Case 96 ' Ctrl-F3 - repeat replace
                  If Search$ = Nul Then
                     GoSub Replace.String
                  Else
                     GoSub Replace.String2
                  End If
               Case 61 ' F3 - continue search
                  If Max.Lines > 0 Then
                     If LastSearchLine& = 0& Then ' init search
                        GoSub Search.String
                     Else
                        GoSub Search.String2
                     End If
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case 15 ' shift-tab
                  If Column + Ycoor - TabStop > 0 Then
                     If Column + Ycoor - (TabStop - 1) > 1 Then
                        Ycoor = Ycoor - (TabStop - 1)
                     Else
                        If Column > TabStop Then
                           Column = Column - (TabStop - 1)
                           GoSub Display.Screen
                        End If
                     End If
                  Else ' home
                     If Column > 1 Then
                        Column = 1
                        Ycoor = 1
                        GoSub Display.Screen
                     Else
                        Column = 1
                        Ycoor = 1
                     End If
                  End If
               Case 83, 147 ' delete/control-delete
                  q = Column + Ycoor - 1
                  ' no delete at 1,1
                  If (Line.Number <= 1 And q < 1) Or Max.Lines < 1 Then
                     Eat$ = Nul
                  Else
                     ' remove line
                     If Temp.ArrayS(Line.Number) = Nul Then
                        If Line.Number = 1 And Max.Lines = 1 Then ' 1,1
                           Eat$ = Nul
                        Else
                           ' pack array
                           For Temp1 = Line.Number To Max.Lines - 1
                              Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                           Next
                           If Line.Number = Max.Lines Then
                              Line.Number = Line.Number - 1
                              If Xcoor > 1 Then
                                 Xcoor = Xcoor - 1
                              End If
                           End If
                           Max.Lines = Max.Lines - 1
                           Column = 1
                           Ycoor = 1
                           GoSub Display.Screen
                        End If
                     Else
                        ' delete line
                        If Len(Temp.ArrayS(Line.Number)) < 1 Then
                           Temp.ArrayS(Line.Number) = Nul
                           GoSub Display.Screen
                        Else
                           ' concatenate line
                           If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                              If Line.Number + 1 <= Max.Lines Then
                                 T$ = Temp.ArrayS(Line.Number)
                                 T$ = T$ + Temp.ArrayS(Line.Number + 1)
                                 Temp.ArrayS(Line.Number) = T$

                                 ' pack array
                                 For Temp1 = Line.Number + 1 To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 Max.Lines = Max.Lines - 1

                                 GoSub Display.Screen
                              End If
                           Else
                              ' delete character
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = Left$(T$, Column + Ycoor - 2) + Mid$(T$, Column + Ycoor)
                              Temp.ArrayS(Line.Number) = T$
                              GoSub Display.Screen
                           End If
                        End If
                     End If
                  End If
               Case 71 ' home
                  If Column > 1 Then
                     Column = 1
                     Ycoor = 1
                     GoSub Display.Screen
                  Else
                     Column = 1
                     Ycoor = 1
                  End If
               Case 79 ' end
                  End.Line = Len(Temp.ArrayS(Line.Number))
                  If End.Line >= Width1 Then
                     Column = End.Line - Width3
                     Ycoor = End.Line - Column + 2
                     GoSub Display.Screen
                  Else
                     Ycoor = End.Line - Column + 2
                  End If
               Case 75, 155 ' left/alt-left
                  If Ycoor > 1 Then
                     Ycoor = Ycoor - 1
                  Else
                     If Column > 1 Then
                        Column = Column - 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 77, 157 ' right/alt-right
                  If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor < Width1 Then
                        Ycoor = Ycoor + 1
                     Else
                        Column = Column + 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 72, 141, 152 ' up/ctrl-up/alt-up
                  Var = 0
                  If Line.Number > 1 Then
                     Line.Number = Line.Number - 1
                     If Xcoor = 1 Then
                        Var = -1
                     Else
                        Xcoor = Xcoor - 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 80, 145, 160 ' down/ctrl-dn/alt-dn
                  Var = 0
                  If Line.Number < Max.Lines Then
                     Line.Number = Line.Number + 1
                     If Xcoor >= Max.Row - 2 Then
                        Var = -1
                     Else
                        Xcoor = Xcoor + 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 73, 132 ' pageup/ctrl-pageup
                  If Line.Number > 1 Then
                     If Line.Number - 22 > 1 Then
                        Line.Number = Line.Number - 22
                     Else
                        Line.Number = 1
                     End If
                     Xcoor = 1
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 81, 118 ' pagedown/ctrl-pagedn
                  If Line.Number < Max.Lines Then
                     If Line.Number + 22 < Max.Lines Then
                        Line.Number = Line.Number + 22
                        Xcoor = 1
                     Else
                        Line.Number = Max.Lines
                        If Max.Lines < Max.Row - 3 Then
                           Xcoor = Max.Lines
                        Else
                           Xcoor = Max.Row - 3
                        End If
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 116 ' control-right
                  If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then ' eol
                     If Line.Number + 1 <= Max.Lines Then
                        Line.Number = Line.Number + 1
                        If Xcoor = Max.Row - 3 Then
                           Var = -1
                        Else
                           Xcoor = Xcoor + 1
                        End If
                        Ycoor = 1
                        Column = 1
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     For Temp2 = Column + Ycoor - 1 To Len(Temp.ArrayS(Line.Number))
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              Exit For
                           End If
                        End If
                     Next
                     'shift right
                     For Var3 = 1 To P
                        If Ycoor < Width1 Then
                           Ycoor = Ycoor + 1
                        Else
                           Column = Column + 1
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 115 ' control-left
                  If Column + Ycoor - 1 <= 1 Then
                     If Line.Number > 1 Then
                        Line.Number = Line.Number - 1
                        If Xcoor = 1 Then
                           Var = -1
                        Else
                           Xcoor = Xcoor - 1
                        End If
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= Width1 Then
                           Column = End.Line - Width3
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     V = 0
                     For Temp2 = Column + Ycoor - 3 To 1 Step -1
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              V = -1
                              Exit For
                           End If
                        End If
                     Next
                     If V = 0 Then
                        P = P + 1
                     End If
                     ' shift left
                     For Var3 = 1 To P
                        If Ycoor > 1 Then
                           Ycoor = Ycoor - 1
                        Else
                           If Column > 1 Then
                              Column = Column - 1
                           End If
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 119 ' control-home
                  If Max.Lines > 0 Then
                     Line.Number = 1
                     Xcoor = 1
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 117 ' control-end
                  If Max.Lines > 0 Then
                     Line.Number = Max.Lines
                     If Max.Lines < Max.Row - 3 Then
                        Xcoor = Max.Lines
                     Else
                        Xcoor = Max.Row - 3
                     End If
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 82 ' insert
                  Inserting = Not Inserting
            End Select
      End Select
   Loop
   Color 15, 0
   Cls
   Call Edit.Status.Line
   Locate , , 1, 7, 7
   Locate Max.Row - 1, 1
   If Inpt = 0 Then
      Erase Temp.ArrayS
      _Title "SCRNEDIT"
      Exit Sub
   End If
   q = 0
   Print "Write "; Filename$; " to disk(y/n)? ";
   Do
      _Limit 50
      Char$ = InKey$
      Char$ = UCase$(Char$)
      If Char$ = "Y" Then
         q = -1
         Print "y"
         Exit Do
      End If
      If Char$ = "N" Then
         Print "n"
         Exit Do
      End If
   Loop
   If q Then
      Close #File5
      If _FileExists(Filename$) Then
         Kill Filename$
      End If
      Print "Save file in Linux write mode(y/n)? ";
      Do
         _Limit 50
         X$ = InKey$
         If LCase$(X$) = "y" Then Print: LINUXSave = -1: Exit Do
         If LCase$(X$) = "n" Then Print: LINUXSave = 0: Exit Do
      Loop
      If LINUXSave Then
         Open Filename$ For Binary As #File5
         Var& = 0&
         For Count& = 1& To Max.Lines
            For Count2 = 1 To Len(Temp.ArrayS(Count&))
               VarX = Mid$(Temp.ArrayS(Count&), Count2, 1)
               Var& = Var& + 1&
               Put File5, Var&, VarX
            Next
            Var& = Var& + 1&
            VarX = Chr$(10)
            Put File5, Var&, VarX
         Next
      Else
         Var& = 0&
         Open Filename$ For Output As #File5
         For Count& = 1& To Max.Lines
            Var& = Var& + Len(Temp.ArrayS(Count&)) + 2&
            Print #File5, Temp.ArrayS(Count&)
         Next
      End If
      Close #File5
      If LINUXSave Then
         Print "Total " + FormatString$(Var&) + " binary bytes stored to disk."
      Else
         Print "Total " + FormatString$(Var&) + " bytes stored to disk."
      End If
      Print "-more-";
      While InKey$ = ""
         _Limit 50
      Wend
   End If
   Erase Temp.ArrayS
   _Title "SCRNEDIT"
   Exit Sub

   Insert.Char:
   If Line.Number > 0 Then
      Var = 0
      Ascii$ = Nul
      GoSub Display.Ascii.Line
      Do
         Var$ = Nul
         Do
            _Limit 50
            Var$ = InKey$
            If Len(Var$) Then
               Exit Do
            End If
         Loop
         If Len(Var$) = 1 Then
            If Var$ = Chr$(8) Then
               If Len(Ascii$) > 0 Then
                  Ascii$ = Left$(Ascii$, Len(Ascii$) - 1)
                  GoSub Display.Ascii.Line
                  Var = Var - 1
                  Locate Max.Row - 1, 27
                  Print Ascii$ + " ";
                  Locate Max.Row - 1, 27
                  Print Ascii$;
               End If
            End If
            If Var$ = Chr$(13) Then
               Exit Do
            End If
            If LCase$(Var$) = "x" Or LCase$(Var$) = "o" Or LCase$(Var$) = "b" Then
               If Var = 0 Then
                  Ascii$ = Ascii$ + LCase$(Var$)
                  GoSub Display.Ascii.Line
                  Var = Var + 1
                  Locate Max.Row - 1, 26 + Var
                  Strng$ = LCase$(Var$)
                  Print Strng$;
               End If
            End If
            If LCase$(Var$) >= "a" And LCase$(Var$) <= "f" Then
               If Var >= 1 And Var < 3 Then
                  If Left$(Ascii$, 1) = "x" Then
                     Var = Var + 1
                     Locate Max.Row - 1, 26 + Var
                     Strng$ = Var$
                     Print Strng$;
                     Ascii$ = Ascii$ + Var$
                  End If
               End If
            End If
            If Left$(Ascii$, 1) = "o" Then
               If Var$ >= "0" And Var$ <= "7" Then
                  If Var < 4 Then
                     Var = Var + 1
                     Locate Max.Row - 1, 26 + Var
                     Strng$ = Var$
                     Print Strng$;
                     Ascii$ = Ascii$ + Var$
                  End If
               End If
            Else
               If Left$(Ascii$, 1) = "b" Then
                  If Var$ = "0" Or Var$ = "1" Then
                     If Var < 9 Then
                        Var = Var + 1
                        Locate Max.Row - 1, 26 + Var
                        Strng$ = Var$
                        Print Strng$;
                        Ascii$ = Ascii$ + Var$
                     End If
                  End If
               Else
                  If Var$ >= "0" And Var$ <= "9" Then
                     If Var < 3 Then
                        Var = Var + 1
                        Locate Max.Row - 1, 26 + Var
                        Print Var$;
                        Ascii$ = Ascii$ + Var$
                     End If
                  End If
               End If
            End If
         End If
      Loop
      Color 15, 0

      ' insert ascii character
      If Left$(Ascii$, 1) = "x" Then
         Ascii.Value = Int(Val("&H" + Mid$(Ascii$, 2)))
      Else
         If Left$(Ascii$, 1) = "o" Then
            Ascii.Value = Int(Val("&O" + Mid$(Ascii$, 2)))
         Else
            If Left$(Ascii$, 1) = "b" Then ' binary
               Ascii$ = Mid$(Ascii$, 2)
               GoSub Binary.String
            Else
               Ascii.Value = Int(Val(Ascii$))
            End If
         End If
      End If
      If Ascii.Value >= 0 And Ascii.Value <= 255 Then
         TempX$ = Chr$(Ascii.Value)
         If Inserting Then
            T$ = Temp.ArrayS(Line.Number)
            T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
            Temp.ArrayS(Line.Number) = T$
         Else
            T$ = Temp.ArrayS(Line.Number)
            If T$ = "" Then
               T$ = TempX$
            Else
               If Column + Ycoor - 1 > Len(T$) Then
                  T$ = T$ + TempX$
               Else
                  Mid$(T$, Column + Ycoor - 1, 1) = TempX$
               End If
            End If
            Temp.ArrayS(Line.Number) = T$
         End If
         If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
            If Ycoor < Width1 Then
               Ycoor = Ycoor + 1
               GoSub Display.Screen
            Else
               Column = Column + 1
               GoSub Display.Screen
            End If
         End If
      End If
   End If
   Return

   Display.Ascii.Line:
   Color 15, 1
   Locate Max.Row - 1, 1, 1
   Color 15, 1
   Strng$ = Space$(40)
   Print Strng$;
   Locate Max.Row - 1, 1, 1
   If Left$(Ascii$, 1) = "x" Then
      Var2$ = "Enter 2-digit ascii code: "
   Else
      If Left$(Ascii$, 1) = "o" Then
         Var2$ = "Enter 3-digit ascii code: "
      Else
         If Left$(Ascii$, 1) = "b" Then
            Var2$ = "Enter 8-digit ascii code: "
         Else
            Var2$ = "Enter 3-digit ascii code: "
         End If
      End If
   End If
   VarC = Len(Var2$) + Len(Ascii$)
   Var2$ = Left$(Var2$, 40)
   Var2$ = Var2$ + Space$(40 - Len(Var2$))
   Print Var2$;
   Locate Max.Row - 1, VarC, 1
   Return

   Binary.String:
   Ascii.Value = 0
   Binary.Power = 0
   For Binary.Digit = Len(Ascii$) To 1 Step -1
      OutX2$ = Mid$(Ascii$, Binary.Digit, 1)
      Select Case OutX2$
         Case "0"
            ' nul
         Case "1"
            Ascii.Value = Ascii.Value + 2 ^ Binary.Power
      End Select
      Binary.Power = Binary.Power + 1
   Next
   Return

   InsertFile:
   Cls
   Store.Line.Number = Line.Number
   Print "Insert Filename";
   Input VarA$
   VarA$ = LTrim$(RTrim$(VarA$))
   If Left$(VarA$, 1) = Chr$(34) And Right$(VarA$, 1) = Chr$(34) Then
      VarA$ = Left$(VarA$, Len(VarA$) - 1)
      VarA$ = Mid$(VarA$, 2)
   End If
   If Len(VarA$) Then
      If _FileExists(VarA$) Then
         Xcount1! = 0!
         Zcount1# = 0#
         f = FreeFile
         Open VarA$ For Input As #f
         Do Until EOF(f)
            Line Input #f, VarB$
            ' insert always extends array
            If Max.Lines + 1 > Max.File Then
               Max.File = Max.File + 1
               ReDim _Preserve Temp.ArrayS(Max.File) As String
            End If
            ' insert line to file array
            Max.Lines = Max.Lines + 1
            For Temp1 = Max.Lines - 1 To Line.Number Step -1
               Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
            Next
            Temp.ArrayS(Line.Number) = VarB$
            Line.Number = Line.Number + 1
            Xcount1! = Xcount1! + 1!
            Zcount1# = Zcount1# + CDbl(Len(VarB$))
         Loop
         Close #f
         ' restore screen
         Line.Number = Store.Line.Number
         Ycoor = 1
         Column = 1
         'GoSub Display.Screen
         Xcount1$ = Str$(Xcount1!)
         Zcount1$ = Str$(Zcount1#)
         If Width1 = 40 Then
            Print "Lines inserted.";
         Else
            Print "Lines inserted:" + Xcount1$ + " Bytes inserted:" + Zcount1$;
         End If
      Else
         Print "File not found.";
      End If
      Print " Press key:";
      While InKey$ = "": _Limit 50: Wend
   End If
   Return

   AppendFile:
   Cls
   Print "Append Filename";
   Input VarA$
   VarA$ = LTrim$(RTrim$(VarA$))
   If Left$(VarA$, 1) = Chr$(34) And Right$(VarA$, 1) = Chr$(34) Then
      VarA$ = Left$(VarA$, Len(VarA$) - 1)
      VarA$ = Mid$(VarA$, 2)
   End If
   If Len(VarA$) Then
      If _FileExists(VarA$) Then
         Xcount1! = 0!
         Zcount1# = 0#
         f = FreeFile
         Open VarA$ For Input As #f
         Do Until EOF(f)
            Line Input #f, VarB$
            ' append always extends array
            If Max.Lines + 1 > Max.File Then
               Max.File = Max.File + 1
               ReDim _Preserve Temp.ArrayS(Max.File) As String
            End If
            ' append line to eof
            Max.Lines = Max.Lines + 1
            Temp.ArrayS(Max.Lines) = VarB$
            Xcount1! = Xcount1! + 1!
            Zcount1# = Zcount1# + CDbl(Len(VarB$))
         Loop
         Close #f
         ' control-end
         If Max.Lines > 0 Then
            Line.Number = Max.Lines
            If Max.Lines < Max.Row - 2 Then
               Xcoor = Max.Lines
            Else
               Xcoor = Max.Row - 2
            End If
            Ycoor = 1
            Column = 1
         End If
         'GoSub Display.Screen
         Xcount1$ = Str$(Xcount1!)
         Zcount1$ = Str$(Zcount1#)
         If Width1 = 40 Then
            Print "Lines appended.";
         Else
            Print "Lines appended:" + Xcount1$ + " Bytes appended:" + Zcount1$;
         End If
      Else
         Print "File not found.";
      End If
      Print " Press key:";
      While InKey$ = "": _Limit 50: Wend
   End If
   Return

   Jump.Line:
   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(Width1)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1

   Print "Enter line number(1-" + LTrim$(Str$(Max.Lines)) + ")? ";
   Line Input ; X$
   X$ = RTrim$(LTrim$(X$))
   VarX2 = -1
   If Len(X$) = 0 Then
      VarX2 = 0
   Else
      If Len(X$) > 7 Then
         VarX2 = 0
      Else
         VarX2 = IsNumeric(X$)
      End If
   End If
   Count& = 0&
   If VarX2 Then
      If Val(X$) > 0 And Val(X$) <= Max.Lines Then
         Count& = Val(X$)
      Else
         VarX2 = 0
      End If
   End If
   Return

   Jump.Byte:
   ' count bytes in edit array
   X# = 0#
   For X& = 1 To Max.Lines
      X# = X# + Len(Temp.ArrayS(X&))
   Next

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(Width1)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1

   Print "Enter byte number(1-" + LTrim$(Str$(X#)) + ")? ";
   Line Input ; X$
   X$ = RTrim$(LTrim$(X$))
   VarX2 = -1
   If Len(X$) = 0 Then
      VarX2 = 0
   Else
      If Len(X$) > 15 Then
         VarX2 = 0
      Else
         VarX2 = IsNumeric(X$)
      End If
   End If
   T# = 0#
   If VarX2 Then
      Count# = Val(X$)
      If Count# > 0 And Count# <= X# Then
         For Count& = 1 To Max.Lines
            If T# + Len(Temp.ArrayS(Count&)) >= Count# Then
               Exit For
            End If
            T# = T# + Len(Temp.ArrayS(Count&))
         Next
      Else
         VarX2 = 0
      End If
   End If
   Return

   Replace.String:
   If Max.Lines > 0 Then
      Color 15, 1
      Locate Max.Row - 1, 1
      Strng$ = Space$(Width1)
      Print Strng$;
      Color 14, 1
      Locate Max.Row - 1, 1
      Line Input ; "Enter search string? "; Search$

      Color 15, 1
      Locate Max.Row - 1, 1
      Strng$ = Space$(Width1)
      Print Strng$;
      Color 14, 1
      Locate Max.Row - 1, 1
      Line Input ; "Enter replace string? "; Replace$

      Replace.String2:

      Color 15, 1
      Locate Max.Row - 1, 1
      Strng$ = Space$(Width1)
      Print Strng$;
      Color 14, 1
      Locate Max.Row - 1, 1
      Print "Enter (R)eplace,Replace(A)ll,(C)ancel? ";
      Do
         _Limit 50
         X$ = InKey$
         X = 0
         If UCase$(X$) = "R" Then X = 1: Exit Do
         If UCase$(X$) = "A" Then X = 2: Exit Do
         If UCase$(X$) = "C" Then X = 0: Exit Do
      Loop
      If X Then
         Color 15, 1
         Locate Max.Row - 1, 1
         Strng$ = Space$(Width1)
         Print Strng$;
         Color 14, 1
         Locate Max.Row - 1, 1
         Print "Case-sensitive(y/n)? ";
         Do
            _Limit 50
            Y$ = InKey$
            If UCase$(Y$) = "Y" Then SensitiveSelect = -1: Exit Do
            If UCase$(Y$) = "N" Then SensitiveSelect = 0: Exit Do
         Loop
      End If

      If X = 1 Then ' replace
         ' store current screen
         Store1 = Xcoor
         Store2 = Ycoor
         Store3 = Column
         Store& = Line.Number
         ' start replace
         Count& = 0&
         If Len(Search$) Then
            For X& = Store& To Max.Lines
               S1 = 1
               Text$ = Temp.ArrayS(X&)
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     ' jump to line
                     Ycoor = 1
                     Column = 1
                     Line.Number = X&
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     ' display screen
                     Color 15, 0
                     GoSub Display.Screen
                     ' move right until search fits
                     If P1 + Len(Search$) < Width1 Then
                        If Len(Search$) < Width1 Then
                           Locate Xcoor, P1
                           Color 12, 1
                           Var1$ = Mid$(Text$, P1, Len(Search$))
                           Print Var1$;
                           Color 15, 0
                        End If
                     Else
                        If Len(Search$) < Width1 Then
                           Do
                              If Column + Ycoor + 1 < P1 + Len(Search$) Then
                                 If Ycoor < Width1 Then
                                    Ycoor = Ycoor + 1
                                 Else
                                    Column = Column + 1
                                 End If
                              Else
                                 Exit Do
                              End If
                           Loop
                           ' decrease until display search fits in line
                           Do Until Ycoor + Len(Search$) < Width1
                              Ycoor = Ycoor - 1
                           Loop
                           ' check display search at end of line
                           If Ycoor + Len(Search$) <= Width1 Then
                              GoSub Display.Screen
                              Locate Xcoor, Ycoor, 1
                              Color 12, 1
                              Var1$ = Mid$(Text$, P1, Len(Search$))
                              Print Var1$;
                              Color 15, 0
                           End If
                        End If
                     End If
                     ' z=-1 replace, z=1 skip
                     Color 15, 1
                     Locate Max.Row - 1, 1
                     Strng$ = Space$(Width1)
                     Print Strng$;
                     Color 14, 1
                     Locate Max.Row - 1, 1
                     Print "Enter (R)eplace,(S)kip,(C)ancel? ";
                     Do
                        _Limit 50
                        X$ = InKey$
                        Z = 0
                        If UCase$(X$) = "R" Then Z = -1: Exit Do
                        If UCase$(X$) = "S" Then Z = 1: Exit Do
                        If UCase$(X$) = "C" Then Z = 0: Exit Do
                     Loop
                     If Z = 0 Then ' cancel
                        Exit For
                     End If
                     If Z = -1 Then ' replace
                        Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                        Temp.ArrayS(X&) = Text$
                        Count& = Count& + 1&
                     End If
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
            Next
         End If
         ' restore current screen
         Color 15, 0
         GoSub Display.Screen

         Xcoor = Store1
         Ycoor = Store2
         Column = Store3
         Line.Number = Store&

         Color 15, 1
         Locate Max.Row - 1, 1
         Strng$ = Space$(Width1)
         Print Strng$;
         Color 14, 1
         Locate Max.Row - 1, 1
         ' display replacements
         If Count& = 0& Then
            Print "Text not found. Press any key.";
         Else
            Print "Replaced" + Str$(Count&) + " strings. Press any key.";
         End If
         While InKey$ = ""
            _Limit 50
         Wend
         Color 15, 0
         GoSub Display.Screen
      End If
      If X = 2 Then ' replaceall
         Count& = 0&
         If Len(Search$) Then
            For X& = 1& To Max.Lines
               Text$ = Temp.ArrayS(X&)
               Flag = 0
               S1 = 1
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     Flag = -1
                     Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                     Count& = Count& + 1&
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
               If Flag Then
                  Temp.ArrayS(X&) = Text$
               End If
            Next
         End If
         Color 15, 0
         GoSub Display.Screen
         Color 15, 1
         Locate Max.Row - 1, 1
         Strng$ = Space$(Width1)
         Print Strng$;
         Color 14, 1
         Locate Max.Row - 1, 1
         ' display replacements
         If Count& = 0& Then
            Print "Text not found. Press any key.";
         Else
            Print "Replaced" + Str$(Count&) + " strings. Press any key.";
         End If
         While InKey$ = ""
            _Limit 50
         Wend
         Color 15, 0
         GoSub Display.Screen
      End If
   End If
   Return

   ' init search
   Search.String:

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(Width1)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   Line Input ; "Enter search string? "; X$

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(Width1)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   Line Input ; "Case-sensitive(y/n)? "; Y$
   If UCase$(Y$) = "Y" Then CaseSensitive = -1
   If UCase$(Y$) = "N" Then CaseSensitive = 0

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(Width1)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   Line Input ; "Use wildcards(y/n)? "; Z$
   If UCase$(Z$) = "Y" Then WildCards = -1
   If UCase$(Z$) = "N" Then WildCards = 0

   LastSearchLine& = 0&
   LastSearchString$ = X$
   VarX2 = 0
   If Len(X$) = 0 Then
      Return
   End If
   For Count& = 1 To Max.Lines
      If WildCards Then
         VarX1$ = Temp.ArrayS(Count&)
         VarX2$ = X$
         Call InstrSUB1(VarX2, VarX2$, VarX1$, CaseSensitive)
         If VarX2 Then
            LastSearchLine& = Count&
            Exit For
         End If
      Else
         If CaseSensitive Then
            If InStr(Temp.ArrayS(Count&), X$) Then
               LastSearchLine& = Count&
               VarX2 = -1
               Exit For
            End If
         Else
            VarX1$ = UCase$(Temp.ArrayS(Count&))
            VarX2$ = UCase$(X$)
            If InStr(VarX1$, VarX2$) Then
               LastSearchLine& = Count&
               VarX2 = -1
               Exit For
            End If
         End If
      End If
   Next
   Return

   ' continue search
   Search.String2:
   X$ = LastSearchString$
   VarX2 = 0
   If Len(X$) Then
      For Count& = LastSearchLine& + 1& To Max.Lines
         If WildCards Then
            VarX1$ = Temp.ArrayS(Count&)
            VarX2$ = X$
            Call InstrSUB1(VarX2, VarX2$, VarX1$, CaseSensitive)
            If VarX2 Then
               LastSearchLine& = Count&
               Exit For
            End If
         Else
            If CaseSensitive Then
               If InStr(Temp.ArrayS(Count&), X$) Then
                  LastSearchLine& = Count&
                  VarX2 = -1
                  Exit For
               End If
            Else
               VarX1$ = UCase$(Temp.ArrayS(Count&))
               VarX2$ = UCase$(X$)
               If InStr(VarX1$, VarX2$) Then
                  LastSearchLine& = Count&
                  VarX2 = -1
                  Exit For
               End If
            End If
         End If
      Next
   End If
   Return

   ' redisplay editor screen
   Display.Screen:
   Color 15, 0
   Cls
   Locate 1, 1
   Count2 = 0
   Do
      Count2 = Count2 + 1
      If Count2 = Max.Row - 1 Then
         Exit Do
      End If
      If Count2 + Line.Number - Xcoor > Max.Lines Then
         Exit Do
      End If
      Locate Count2, 1
      Strng$ = Mid$(Temp.ArrayS(Count2 + Line.Number - Xcoor), Column)
      If Len(Strng$) > Width1 Then
         Strng$ = Left$(Strng$, Width1)
      End If
      Print Strng$;
   Loop
   If Count2 < Max.Row - 1 Then
      Locate Count2, 1
      Color 12, 0
      Print "<end of file>";
   End If
   Color 14, 1
   Locate Max.Row - 1, 1
   Print Space$(Width3);
   Color 0, 1
   Locate Max.Row - 1, Width2, 0
   Print " ";
   Locate Max.Row - 1, Width1, 0
   Print " ";
   Color 15, 0
   Call Edit.Status.Line
   Return
End Sub

Function ValidFileChar (Var$)
   V$ = ":\/<>|"
   If Var$ = "" Then
      ValidFileChar = -1
      Exit Function
   End If
   For V = 1 To Len(Var$)
      Z = Asc(Mid$(Var$, V, 1))
      If Z >= 1 And Z <= 31 Then
         ValidFileChar = -1
         Exit Function
      End If
   Next
   For V = 1 To Len(Var$)
      If InStr(V$, Mid$(Var$, V, 1)) Then
         ValidFileChar = -1
         Exit Function
      End If
   Next
   ValidFileChar = 0
End Function

Function ValidFileChar2$ (Var$)
   V$ = "/<>|"
   If Var$ = "" Then
      ValidFileChar2$ = ""
      Exit Function
   End If
   For V = 1 To Len(Var$)
      Z = Asc(Mid$(Var$, V, 1))
      If Z >= 1 And Z <= 31 Then
         ValidFileChar2$ = ""
         Exit Function
      End If
   Next
   For V = 1 To Len(Var$)
      If InStr(V$, Mid$(Var$, V, 1)) Then
         ValidFileChar2$ = ""
         Exit Function
      End If
   Next
   ValidFileChar2$ = Var$
End Function

Sub RDOldSkool (Var$)
   Const MaxArray = 1000
   Dim TempFile As String
   TempFile = MakeTempFile$

   Var$ = UCase$(Var$) 'old skool file names could only be ALL CAPS
   If Right$(Var$, 1) <> "\" Then Var$ = Var$ + "\"
   Shell _Hide "cd > " + TempFile
   Open TempFile For Input As #1
   Input #1, OldDir$ 'get the old directory name
   Close #1
   ChDir Var$ 'change to the specified directory
   Shell _Hide "cd > " + TempFile
   Open TempFile For Input As #1
   Input #1, VerifyDir$ 'get the changed directory name
   Close #1

   VerifyDir$ = UCase$(VerifyDir$)
   If Right$(VerifyDir$, 1) <> "\" Then VerifyDir$ = VerifyDir$ + "\" 'make certain it matchs old skool formatting before verifying

   If UCase$(VerifyDir$) <> Var$ Then 'verify that we're in the proper directory now
      Exit Sub
   End If
   Shell _Hide "dir /b /ad > " + TempFile

   Open TempFile For Input As #1 'can't use BINARY as we're going old skool!
   If LOF(1) Then 'If there's any data in that file and it's not just blank
      ReDim DirList(MaxArray) As String 'If you have more than 1,000 directories on an old skool folder, you fail!
      Do
         i = i + 1
         Line Input #1, DirList(i)
         If i = MaxArray Then Exit Do
      Loop Until EOF(1)
      ReDim _Preserve DirList(i) As String 'free up unused memory in that array of dir lists
   End If
   Close #1
   For j = 1 To i
      If DirList(j) <> "." And DirList(j) <> ".." Then
         SubDir$ = Var$ + DirList(j) + "\"
         Call RDOldSkool(SubDir$)
      End If
   Next
   Open TempFile For Output As #1: Close #1 'make certain there's a TEMP.TXT in the file list to clean up automatically
   Shell _Hide "dir /b *.* > " + TempFile
   Open TempFile For Input As #1
   If LOF(1) Then
      Do
         Line Input #1, File$
         If File$ <> TempFile Then 'can't kill our open file!
            Kill File$
         End If
      Loop Until EOF(1)
   End If
   Close #1
   Kill TempFile 'now kill that file!
   ChDir OldDir$
   For i = 65 To 90
      TestDir$ = Chr$(i) + ":\"
      If OldDir$ = TestDir$ Then Exit Sub
   Next
   RmDir Var$
End Sub

Function CheckDrive$ (i)
   t$ = MakeTempFile$
   i$ = Chr$(i + 64) + ":"
   j$ = "cd " + i$
   Shell _Hide j$ + " > " + t$
   Close
   Open t$ For Input As #1
   If EOF(1) = 0 Then
      Line Input #1, s$
      s$ = LCase$(s$)
      If s$ = "path not found" Then
         ' eat
      Else
         Shell _Hide "vol " + i$ + " > " + t$
         Close
         Open t$ For Input As #1
         z = 0
         Do Until EOF(1)
            Line Input #1, s$
            If Len(s$) Then
               z = -1
               Exit Do
            End If
         Loop
         If z Then
            Close
            Open t$ For Input As #1
            x = 0
            Do Until EOF(1)
               Line Input #1, s$
               If LCase$(s$) = "invalid drive specification" Then
                  Exit Do
               Else
                  drives = -1
                  If InStr(s$, " is ") Then
                     x = x + 1
                     ' volume in drive C is Label
                     If x = 1 Then
                        labels$ = Mid$(s$, InStr(s$, " is ") + 4)
                     End If
                     ' volume serial number is xxxx-xxxx
                     If x = 2 Then
                        serial$ = Mid$(s$, InStr(s$, " is ") + 4)
                     End If
                  End If
               End If
            Loop
         End If
      End If
   End If
   q$ = ""
   If drives Then
      q$ = Chr$(i + 64) + ":\" + labels$
      If Len(serial$) Then
         z$ = " [" + serial$ + "]"
         If Len(q$ + z$) <= Width2 Then
            q$ = q$ + z$
         End If
      End If
   End If
   CheckDrive = q$
End Function

Function MakeTempFile$ ()
   V$ = ""
   For V = 1 To 8
      V$ = V$ + Chr$(Int(Rnd * 10 + 1) + 64)
   Next
   V$ = V$ + ".DAT"
   MakeTempFile$ = V$
End Function

' routine compares occurrence of filename1$ in filename2$
'  with pattern matching.
Sub CheckFilename (Filename1$, Filename2$, Match)
   Match = -1 ' assume mask matches filename2.
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement.
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Match = 0
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement.
         ' searches for next matching character.
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement.
         ' matches any next character.
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character.
            ' checks next character unmatched.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match = 0
                  Exit Do
               End If
            Else
               ' matches next character.
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match = 0
                  Exit Do
               End If
               ' check string lengths.
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Match = 0
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
End Sub

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

