REM File: Dndinit for Dndbbs Version v5.0a Release r2.0 Tweak t6.0a

Declare Function Form$(X#)

Declare Sub Get.Config(X$)
Declare Sub Passwrd(V%)
Declare Sub Crypto(V$)

DEFINT A-Z
REM $DYNAMIC

' record length=64 for far heap redim.
TYPE DungeonType
 ShortDesc AS STRING * 48
 Direct(1 TO 4) AS SINGLE
END TYPE

TYPE MessType
 Index AS SINGLE
 User AS SINGLE
 Charges AS INTEGER
 Plus AS INTEGER
 Room AS SINGLE
 Prev AS SINGLE
 Next AS SINGLE
 Temp(1 To 4) AS SINGLE
 Desc(1 To 4) AS SINGLE
 Time1 As Single
 Time2 As Single
END TYPE

TYPE RoomType
 Action AS SINGLE
 Custom1 AS STRING * 12
 Custom2 AS STRING * 12
 Direct(1 TO 14) AS SINGLE
 LongDesc(1 TO 19) AS SINGLE
 MonsterClass AS SINGLE
 ShortDesc AS STRING * 80
 First AS SINGLE
 Last AS SINGLE
 First2 AS SINGLE
 Last2 AS SINGLE
END TYPE

TYPE RoomDescType
 Descrip AS STRING * 80
END TYPE

TYPE ObjectType
 ObjectName AS STRING * 30
 ShortName AS STRING * 30
 RoomLink AS SINGLE
 RoomLink2 AS SINGLE
 Invisible AS INTEGER
 JailTrap AS INTEGER
 DoorLock AS INTEGER
 Destination AS INTEGER
 Permanent AS INTEGER
 Hidden AS INTEGER
 Closed AS INTEGER
 Keyed AS SINGLE
 Relocks AS INTEGER
 LongDesc AS STRING * 80
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 LightRoom AS INTEGER
 LightTime AS INTEGER
 ShortDesc AS STRING * 80
 Trap AS INTEGER
 Teleport AS SINGLE
 SwitchType AS INTEGER
 SwitchRoom AS SINGLE
 SwitchLight AS INTEGER
 SwitchLockRoom AS INTEGER
 Prefix1 AS STRING * 8
 PortalPassword AS STRING * 8
 ObjDesc(1 To 19) As Single
 Buffer5 AS INTEGER
 Buffer6 AS INTEGER
 InitRoom AS SINGLE
 InitRoom2 AS SINGLE
END TYPE

TYPE TreasureType
 TreasureName AS STRING * 30
 ShortName AS STRING * 30
 Weight AS INTEGER
 Gold AS Double
 Spell AS SINGLE
 Plus AS INTEGER
 Coin AS INTEGER
 Locked AS INTEGER
 KeyNumber AS Single
 Scroll AS INTEGER
 Charges AS INTEGER
 Potion AS INTEGER
 Loadable AS INTEGER
 Ammunition AS INTEGER
 AmmoLoads AS SINGLE
 Invisible AS INTEGER
 Permanent AS INTEGER
 Proficiency AS INTEGER
 WeaponNumber AS INTEGER
 RingType AS INTEGER
 RingSpell AS SINGLE
 Edible AS INTEGER
 Rustable AS INTEGER
 RustPercent AS INTEGER
 Stealable AS INTEGER
 StealPercent AS INTEGER
 Launchable AS INTEGER
 LaunchLoads AS SINGLE
 LaunchAmmo AS INTEGER
 Movable AS INTEGER
 Vehicle AS INTEGER
 VehicleType AS INTEGER
 LightType AS INTEGER
 LightCharges AS INTEGER
 FuelType AS INTEGER
 FuelCharges AS INTEGER
 Container AS INTEGER
 ContainerMax AS INTEGER
 ContainerPrefix AS STRING * 15
 ContainerDisappears AS SINGLE
 ContainerSize AS INTEGER
 ContainerMaterial As Integer
 ContainerSelfImplodes As Integer
 PotionType AS SINGLE
 NewPotion AS SINGLE
 MixPotion AS INTEGER
 TwoHanded AS INTEGER
 RequireStr AS INTEGER
 RequireDex AS INTEGER
 RequireInt AS INTEGER
 RestrictItem(1 TO 3) AS SINGLE
 TrapType AS INTEGER
 TrapHits AS INTEGER
 TrapItem AS SINGLE
 MasterKey AS INTEGER
 Liquid AS INTEGER
 LiquidType AS INTEGER
 LiquidFlags AS INTEGER
 Prefix1 AS STRING * 8
 StaysInRoom AS INTEGER
 Occupants As Integer
 BindType As Integer
 TimesCursed As Integer
 TimesBlessed As Integer
 Persistent AS INTEGER
 MaxPersistCharges AS INTEGER
 PersistTime AS SINGLE
 DischargePersist AS SINGLE
 ProperName As String*20
END TYPE

COMMON SHARED DungeonRoom AS RoomType, _
 MessWorkRecord AS MessType, _
 ObjectRecord AS ObjectType, _
 RoomDescRecord AS RoomDescType, _
 TreasureRecord AS TreasureType

COMMON SHARED Dungeon() AS INTEGER, _
 Maze1() AS INTEGER, _
 Maze2() AS INTEGER, _
 Rooms() AS DungeonType

COMMON SHARED Apartment.Door1 AS SINGLE, _
 Apartment.Door2 AS SINGLE, _
 Apartment.Square AS SINGLE, _
 Apartment.Square1 AS SINGLE, _
 Apartment.Square2 AS SINGLE, _
 Elevator.Door AS SINGLE, _
 Max.Treasure AS SINGLE, _
 Mountain.Top AS SINGLE, _
 Next.Descrip AS SINGLE, _
 Next.Object AS SINGLE, _
 Next.Square AS SINGLE, _
 Room.Number AS SINGLE, _
 Treasure.Charges AS INTEGER, _
 Treasure.Number AS SINGLE

COMMON SHARED North.Room AS SINGLE, _
 East.Room AS SINGLE, _
 South.Room AS SINGLE, _
 West.Room AS SINGLE, _
 Tower.Room AS SINGLE

COMMON SHARED FileName AS STRING, _
 Filename1 AS STRING, _
 Filename2 AS STRING, _
 Filename3 AS STRING, _
 Filename4 AS STRING, _
 Filename5 AS STRING

COMMON SHARED MessWorkRecLen AS INTEGER
COMMON SHARED Strng3 AS STRING

Common Shared NodeX As String

 Const False=0
 Const True=-1
 Const Untrue=1

 Const SFalse=0!
 Const STrue=-1!

 Const DFalse=0#
 Const DTrue=-1#

 Const Nul=""

 Const MaxConfigArray1=40
 Const MaxConfigArray2=150
 Const MaxConfigArray3=100

 Const MaxLevels=10 ' should not be changed

 Function Form$(Var#)
   Form$=Format$(Var#,"#,##0;;"+Chr$(34)+"zero"+Chr$(34))
 End Function

 MessWorkRecLen = LEN(MessWorkRecord)

 ON ERROR GOTO Error.Routine

 IF COMMAND$ = Nul OR COMMAND$ = "/?" THEN
    GOTO Boot.Usage
 END IF

 Temp$ = COMMAND$

 ' check to over-ride specific node number
 TempA$=Nul
 Var1=Instr(Ucase$(Temp$),"/N:")
 If Var1 Then
    VarQ$=Mid$(Temp$,Var1+3,1)
    Select Case Ucase$(VarQ$)
    Case "0" To "9"
       TempA$=VarQ$
       VarQ2$=Mid$(Command.Line$,Var1+4,1)
       If VarQ2$>="0" And VarQ2$<="9" Then
          TempA$=TempA$+VarQ2$ ' 10-99
          Temp$=Left$(Temp$,Var1-1)+Mid$(Temp$,Var1+5)
       Else
          Temp$=Left$(Temp$,Var1-1)+Mid$(Temp$,Var1+4)
       Endif
    Case "A" To "Z" ' 64-90
       TempA$=VarQ$
       Temp$=Left$(Temp$,Var1-1)+Mid$(Temp$,Var1+4)
    End Select
 Endif
 NodeX=Nul
 If Len(TempA$) Then
    TempA$=Ucase$(TempA$)
    Select Case Len(TempA$)
    Case 1
       Select Case TempA$
       Case "0" To "9"
          NodeX=TempA$
          TempA$=Nul
       Case "A" To "Z"
          NodeX=TempA$
          TempA$=Nul
       End Select
    Case 2
       VarX=Int(Val(TempA$)+.5)
       If VarX>=10 And VarX<=99 Then
          NodeX=Mid$(Str$(VarX),2)
          TempA$=Nul
       Endif
    End Select
 Endif
 If TempA$<>Nul Then
    Goto Boot.Usage
 Endif

 Imbedded = INSTR(Temp$, " ")
 DO WHILE Imbedded
    Temp$ = LEFT$(Temp$, Imbedded - 1) + MID$(Temp$, Imbedded + 1)
    Imbedded = INSTR(Temp$, " ")
 LOOP

 Init.Rooms = False
 Imbedded = INSTR(Temp$, "/I")
 IF Imbedded THEN
    Init.Rooms = True
    Temp$ = LEFT$(Temp$, Imbedded - 1) + MID$(Temp$, Imbedded + 2)
 END IF

 Quiet.Mode = False
 Imbedded = INSTR(Temp$, "/Q")
 IF Imbedded THEN
    Quiet.Mode = True
    Temp$ = LEFT$(Temp$, Imbedded - 1) + MID$(Temp$, Imbedded + 2)
 END IF

 IF Quiet.Mode = False THEN
    COLOR 15, 0
    PRINT "DndInit program v5.0a"
 END IF
 Dungeon.Levels = INT(VAL(Temp$)+.5)
 IF Dungeon.Levels < False OR Dungeon.Levels > MaxLevels THEN
    GOTO Boot.Usage
 END IF

 CALL Get.Config(X$)
 CALL Passwrd(Var)
 IF Var = False THEN
    PRINT "Illegal password!"
    COLOR 7, 0
    END
 END IF
 IF Quiet.Mode = False THEN
    COLOR 14, 0
    Select Case Dungeon.Levels
    Case 0
       PRINT "Dndinit will now initialize data files in "+X$
    Case 1
       PRINT "Dndinit will now create 1 level in new data files in "+X$
    Case Else
       PRINT "Dndinit will now create "+Form$(Cdbl(Dungeon.Levels))+" levels in new data files in "+X$
    End Select
    PRINT "Continue(y/n)? ";
    DO
       Input.Char$ = Nul
       DO WHILE Input.Char$ = Nul
	  Input.Char$ = INKEY$
       LOOP
       SELECT CASE LCASE$(Input.Char$)
       CASE "n"
	  PRINT "n"
          Color 15, 0
	  PRINT "Quitting.."
	  COLOR 7, 0
	  END
       CASE "y"
	  PRINT "y"
	  EXIT DO
       END SELECT
    LOOP
 END IF
 COLOR 14, 0
 IF Init.Rooms = False THEN
    Var$ = "DNDINIT1.EXE"
    If Dir$(Var$)=Nul Then
       Color 12,0
       Print "File: "+Var$+" not found."
    Else
       Var$ = Var$ + "/I"
       IF Quiet.Mode THEN
          Var$ = Var$ + "/Q"
       END IF
       SHELL Var$
    Endif
 END IF
 CLOSE #1, #2, #3, #4, #5
 FileName$ = UCASE$(Filename1)
 IF DIR$(FileName$) <> Nul THEN
    KILL FileName$
 END IF
 FileName$ = UCASE$(Filename2)
 IF DIR$(FileName$) <> Nul THEN
    KILL FileName$
 END IF
 FileName$ = UCASE$(Filename4)
 IF DIR$(FileName$) <> Nul THEN
    KILL FileName$
 END IF
 FileName$ = UCASE$(Filename5)
 IF DIR$(FileName$) <> Nul THEN
    KILL FileName$
 END IF
 Var$ = "MAKESYS.EXE"
 If Dir$(Var$)=Nul Then
    Color 12,0
    Print "File: "+Var$+" not found."
 Else
    IF Quiet.Mode THEN
       Var$ = Var$ + "/Q"
    END IF
    SHELL Var$
 Endif
 CLOSE #1, #2, #3, #4, #5
 OPEN Filename1 FOR RANDOM AS #1 LEN = LEN(DungeonRoom)
 OPEN Filename2 FOR RANDOM AS #2 LEN = LEN(ObjectRecord)
 OPEN Filename3 FOR RANDOM AS #3 LEN = LEN(TreasureRecord)
 OPEN Filename4 FOR RANDOM AS #4 LEN = LEN(MessWorkRecord)
 OPEN Filename5 FOR RANDOM AS #5 LEN = LEN(RoomDescRecord)
 RANDOMIZE TIMER
 COLOR 14, 0
 IF Dungeon.Levels = False THEN
    DungeonRoom.Action = SFalse
    DungeonRoom.Custom1 = Nul
    DungeonRoom.Custom2 = Nul
    DungeonRoom.MonsterClass = False
    DungeonRoom.ShortDesc = "Dungeon room."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Index = 1 TO 14
       DungeonRoom.Direct(Index) = False
    NEXT
    DungeonRoom.First = SFalse
    DungeonRoom.Last = SFalse
    DungeonRoom.First2 = SFalse
    DungeonRoom.Last2 = SFalse
    PUT 1, 1, DungeonRoom
    PRINT "Null data files initialized."
    COLOR 7, 0
    END
 END IF
 RESTORE
 IF Quiet.Mode = False THEN
    PRINT "Creating Town Center";
    Var = CSRLIN
 END IF
 FOR Town.Center = 1 TO 16
    IF Quiet.Mode = False THEN
       LOCATE Var, 21, 1
       PRINT " "; MID$(STR$(Town.Center), 2); "..";
    END IF
    READ Town.Name$
    DungeonRoom.ShortDesc = Town.Name$ + " center."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    Next.Square = CSNG((Town.Center - 1) * 8 + 17)
    DungeonRoom.Direct(1) = Next.Square + 1!
    DungeonRoom.Direct(2) = Next.Square + 4!
    DungeonRoom.Direct(3) = Next.Square + 6!
    DungeonRoom.Direct(4) = Next.Square + 3!
    PUT 1, Town.Center, DungeonRoom
 NEXT
 RESTORE
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Creating Town Square";
    Var = CSRLIN
 END IF
 FOR Town.Area = 1 TO 16
    IF Quiet.Mode = False THEN
       LOCATE Var, 21, 1
       PRINT " "; MID$(STR$(Town.Area), 2); "..";
    END IF
    READ Town.Name$
    DungeonRoom.ShortDesc = Town.Name$ + " town."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Town.Squares = 1 TO 8
       Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
       SELECT CASE Town.Squares
       CASE 1
	  DungeonRoom.Direct(1) = False
	  DungeonRoom.Direct(2) = Next.Square + 1!
	  DungeonRoom.Direct(3) = Next.Square + 3!
	  DungeonRoom.Direct(4) = False
       CASE 2
	  DungeonRoom.Direct(1) = False
	  DungeonRoom.Direct(2) = Next.Square + 1!
	  DungeonRoom.Direct(3) = Town.Area
	  DungeonRoom.Direct(4) = Next.Square - 1!
       CASE 3
	  DungeonRoom.Direct(1) = False
	  DungeonRoom.Direct(2) = False
	  DungeonRoom.Direct(3) = Next.Square + 2!
	  DungeonRoom.Direct(4) = Next.Square - 1!
       CASE 4
	  DungeonRoom.Direct(1) = Next.Square - 3!
	  DungeonRoom.Direct(2) = Town.Area
	  DungeonRoom.Direct(3) = Next.Square + 2!
	  DungeonRoom.Direct(4) = False
       CASE 5
	  DungeonRoom.Direct(1) = Next.Square - 2!
	  DungeonRoom.Direct(2) = False
	  DungeonRoom.Direct(3) = Next.Square + 3!
	  DungeonRoom.Direct(4) = Town.Area
       CASE 6
	  DungeonRoom.Direct(1) = Next.Square - 2!
	  DungeonRoom.Direct(2) = Next.Square + 1!
	  DungeonRoom.Direct(3) = False
	  DungeonRoom.Direct(4) = False
       CASE 7
	  DungeonRoom.Direct(1) = Town.Area
	  DungeonRoom.Direct(2) = Next.Square + 1!
	  DungeonRoom.Direct(3) = False
	  DungeonRoom.Direct(4) = Next.Square - 1!
       CASE 8
	  DungeonRoom.Direct(1) = Next.Square - 3!
	  DungeonRoom.Direct(2) = False
	  DungeonRoom.Direct(3) = False
	  DungeonRoom.Direct(4) = Next.Square - 1!
       END SELECT
       PUT 1, Next.Square, DungeonRoom
    NEXT
 NEXT

 REM town map
 REM   1  2  3  4
 REM 13           9
 REM 14 (dungeon) 10
 REM 15           11
 REM 16           12
 REM   5  6  7  8

 REM mountain paths north from 4 and south from 5.

 RESTORE
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Creating Town Roads";
    Var = CSRLIN
 END IF
 FOR Town.Roads = 1 TO 16
    IF Quiet.Mode = False THEN
       LOCATE Var, 20, 1
       PRINT " "; MID$(STR$(Town.Roads), 2); "..";
    END IF
    READ Town.Name$
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    SELECT CASE Town.Roads
    CASE 1
       GET 1, 23, DungeonRoom
       DungeonRoom.Direct(3) = Next.Square
       PUT 1, 23, DungeonRoom
       DungeonRoom.Direct(1) = 23!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 270!
       DungeonRoom.Direct(4) = SFalse
    CASE 2
       GET 1, 31, DungeonRoom
       DungeonRoom.Direct(3) = Next.Square
       PUT 1, 31, DungeonRoom
       DungeonRoom.Direct(1) = 31!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 290!
       DungeonRoom.Direct(4) = SFalse
    CASE 3
       GET 1, 39, DungeonRoom
       DungeonRoom.Direct(3) = Next.Square
       PUT 1, 39, DungeonRoom
       DungeonRoom.Direct(1) = 39!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 310!
       DungeonRoom.Direct(4) = SFalse
    CASE 4
       GET 1, 47, DungeonRoom
       DungeonRoom.Direct(3) = Next.Square
       PUT 1, 47, DungeonRoom
       DungeonRoom.Direct(1) = 47!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 330!
       DungeonRoom.Direct(4) = SFalse
    CASE 5
       GET 1, 50, DungeonRoom
       DungeonRoom.Direct(1) = Next.Square
       PUT 1, 50, DungeonRoom
       DungeonRoom.Direct(1) = 2513!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 50!
       DungeonRoom.Direct(4) = SFalse
    CASE 6
       GET 1, 58, DungeonRoom
       DungeonRoom.Direct(1) = Next.Square
       PUT 1, 58, DungeonRoom
       DungeonRoom.Direct(1) = 2533!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 58!
       DungeonRoom.Direct(4) = SFalse
    CASE 7
       GET 1, 66, DungeonRoom
       DungeonRoom.Direct(1) = Next.Square
       PUT 1, 66, DungeonRoom
       DungeonRoom.Direct(1) = 2553!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 66!
       DungeonRoom.Direct(4) = SFalse
    CASE 8
       GET 1, 74, DungeonRoom
       DungeonRoom.Direct(1) = Next.Square
       PUT 1, 74, DungeonRoom
       DungeonRoom.Direct(1) = 2573!
       DungeonRoom.Direct(2) = SFalse
       DungeonRoom.Direct(3) = 74!
       DungeonRoom.Direct(4) = SFalse
    CASE 9
       GET 1, 84, DungeonRoom
       DungeonRoom.Direct(4) = Next.Square
       PUT 1, 84, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 84!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 765!
    CASE 10
       GET 1, 92, DungeonRoom
       DungeonRoom.Direct(4) = Next.Square
       PUT 1, 92, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 92!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 1169!
    CASE 11
       GET 1, 100, DungeonRoom
       DungeonRoom.Direct(4) = Next.Square
       PUT 1, 100, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 100!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 1573!
    CASE 12
       GET 1, 108, DungeonRoom
       DungeonRoom.Direct(4) = Next.Square
       PUT 1, 108, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 108!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 1977!
    CASE 13
       GET 1, 117, DungeonRoom
       DungeonRoom.Direct(2) = Next.Square
       PUT 1, 117, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 665!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 117!
    CASE 14
       GET 1, 125, DungeonRoom
       DungeonRoom.Direct(2) = Next.Square
       PUT 1, 125, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 1069!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 125!
    CASE 15
       GET 1, 133, DungeonRoom
       DungeonRoom.Direct(2) = Next.Square
       PUT 1, 133, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 1473!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 133!
    CASE 16
       GET 1, 141, DungeonRoom
       DungeonRoom.Direct(2) = Next.Square
       PUT 1, 141, DungeonRoom
       DungeonRoom.Direct(1) = SFalse
       DungeonRoom.Direct(2) = 1877!
       DungeonRoom.Direct(3) = SFalse
       DungeonRoom.Direct(4) = 141!
    END SELECT
    DungeonRoom.ShortDesc = Town.Name$ + " road."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    PUT 1, Next.Square, DungeonRoom
 NEXT
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Creating Dungeon Tower";
    Var = CSRLIN
 END IF
 Room.Number = 160!
 FOR Level = 1 TO 10
    IF Quiet.Mode = False THEN
       LOCATE Var, 23, 1
       PRINT " "; MID$(STR$(Level), 2); "..";
    END IF
    FOR Tower.Number = 1 TO 10
       FOR Index = 1 TO 19
	  DungeonRoom.LongDesc(Index) = SFalse
       NEXT
       DungeonRoom.Action = SFalse
       DungeonRoom.ShortDesc = "Dungeon tower."
       FOR Index = 1 TO 14
	  DungeonRoom.Direct(Index) = False
       NEXT
       Room.Number = Room.Number + 1!
       IF Tower.Number = 1 THEN
	  SELECT CASE Level
	  CASE 1
	     Tower.Room = 261!
	  CASE 2
	     Tower.Room = 294!
	  CASE 3
	     Tower.Room = 327!
	  CASE 4
	     Tower.Room = 361!
	  CASE 5
	     Tower.Room = 1372!
	  CASE 6
	     Tower.Room = 1472!
	  CASE 7
	     Tower.Room = 2483!
	  CASE 8
	     Tower.Room = 2516!
	  CASE 9
	     Tower.Room = 2549!
	  CASE 10
	     Tower.Room = 2583!
	  END SELECT
	  DungeonRoom.Direct(12) = Tower.Room
       END IF
       IF Tower.Number > 1 THEN
	  DungeonRoom.Direct(10) = Room.Number - 1!
       END IF
       IF Tower.Number < 10 THEN
	  DungeonRoom.Direct(9) = Room.Number + 1!
       END IF
       DungeonRoom.MonsterClass = False
       PUT 1, Room.Number, DungeonRoom
    NEXT
 NEXT
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Creating Dungeon Level     ";
    Var = CSRLIN
 END IF
 FOR Level = 1 TO Dungeon.Levels
    IF Quiet.Mode = False THEN
       LOCATE Var, 23, 1
       PRINT " "; MID$(STR$(Level), 2); "..";
    END IF
    REDIM Dungeon(1 TO 25, 1 TO 101) AS INTEGER
    REDIM Maze1(1 TO 50, 1 TO 11) AS INTEGER
    REDIM Maze2(1 TO 50, 1 TO 11) AS INTEGER
    REDIM Rooms(1 TO 25, 1 TO 101) AS DungeonType
    Q = False
    Z = 1
    X = INT(RND * 50 + 1)
    C = 1
    Maze2(X, 1) = C
    C = C + 1
    R = X
    S = 1
    GOTO 2540
2440 IF R <> 50 THEN 2520
    IF S <> 11 THEN 2490
    R = 1
    S = 1
    GOTO 2530
2490 R = 1
    S = S + 1
    GOTO 2530
2520 R = R + 1
2530 IF Maze2(R, S) = False THEN 2440
2540 IF R - 1 = False THEN 2830
    IF Maze2(R - 1, S) THEN 2830
    IF S - 1 = False THEN 2680
    IF Maze2(R, S - 1) THEN 2680
    IF R = 50 THEN 2610
    IF Maze2(R + 1, S) THEN 2610
    X = INT(RND * 3 + 1): ON X GOTO 3140, 3210, 3280
2610 IF S <> 11 THEN 2650
    IF Z = 1 THEN 2670
    Q = 1
    GOTO 2660
2650 IF Maze2(R, S + 1) THEN 2670
2660 X = INT(RND * 3 + 1): ON X GOTO 3140, 3210, 3370
2670 X = INT(RND * 2 + 1): ON X GOTO 3140, 3210
2680 IF R = 50 THEN 2770
    IF Maze2(R + 1, S) THEN 2770
    IF S <> 11 THEN 2740
    IF Z = 1 THEN 2760
    Q = 1
    GOTO 2750
2740 IF Maze2(R, S + 1) THEN 2760
2750 X = INT(RND * 3 + 1): ON X GOTO 3140, 3280, 3370
2760 X = INT(RND * 2 + 1): ON X GOTO 3140, 3280
2770 IF S <> 11 THEN 2810
    IF Z = 1 THEN 3140
    Q = 1
    GOTO 2820
2810 IF Maze2(R, S + 1) THEN 3140
2820 X = INT(RND * 2 + 1): ON X GOTO 3140, 3370
2830 IF S - 1 = False THEN 3000
    IF Maze2(R, S - 1) THEN 3000
    IF R = 50 THEN 2940
    IF Maze2(R + 1, S) THEN 2940
    IF S <> 11 THEN 2910
    IF Z = 1 THEN 2930
    Q = 1
    GOTO 2920
2910 IF Maze2(R, S + 1) THEN 2930
2920 X = INT(RND * 3 + 1): ON X GOTO 3210, 3280, 3370
2930 X = INT(RND * 2 + 1): ON X GOTO 3210, 3280
2940 IF S <> 11 THEN 2980
    IF Z = 1 THEN 3210
    Q = 1
    GOTO 2990
2980 IF Maze2(R, S + 1) THEN 3210
2990 X = INT(RND * 2 + 1): ON X GOTO 3210, 3370
3000 IF R = 50 THEN 3080
    IF Maze2(R + 1, S) THEN 3080
    IF S <> 11 THEN 3060
    IF Z = 1 THEN 3280
    Q = 1
    GOTO 3220
3060 IF Maze2(R, S + 1) THEN 3280
    X = INT(RND * 2 + 1): ON X GOTO 3280, 3370
3080 IF S <> 11 THEN 3120
    IF Z = 1 THEN 2440
    Q = 1
    GOTO 3370
3120 IF Maze2(R, S + 1) THEN 2440
    GOTO 3370
3140 Maze2(R - 1, S) = C
    C = C + 1
    Maze1(R - 1, S) = 2
    R = R - 1
    IF C > 550 THEN 3570
    Q = False
    GOTO 2540
3210 Maze2(R, S - 1) = C
3220 C = C + 1
    Maze1(R, S - 1) = 1
    S = S - 1
    IF C > 550 THEN 3570
    Q = False
    GOTO 2540
3280 Maze2(R + 1, S) = C
    C = C + 1
    IF Maze1(R, S) = False THEN 3330
    Maze1(R, S) = 3
    GOTO 3340
3330 Maze1(R, S) = 2
3340 R = R + 1
    IF C > 550 THEN 3570
    GOTO 2830
3370 IF Q = 1 THEN 3470
    Maze2(R, S + 1) = C
    C = C + 1
    IF Maze1(R, S) = False THEN 3430
    Maze1(R, S) = 3
    GOTO 3440
3430 Maze1(R, S) = 1
3440 S = S + 1
    IF C > 550 THEN 3570
    GOTO 2540
3470 Z = 1
    IF Maze1(R, S) = False THEN 3520
    Maze1(R, S) = 3
    Q = False
    GOTO 2440
3520 Maze1(R, S) = 1
    Q = False
    R = 1
    S = 1
    GOTO 2530
3570
    FOR Row = 1 TO 50
       FOR Column = 1 TO 11
	  SELECT CASE Maze1(Row, Column)
	  CASE 0
	     Dungeon(Column * 2, Row * 2 + 1) = True
	     Dungeon(Column * 2 + 1, Row * 2 - 1) = True
	     Dungeon(Column * 2 + 1, Row * 2) = True
	  CASE 1
	     Dungeon(Column * 2, Row * 2 + 1) = True
	     Dungeon(Column * 2 + 1, Row * 2 - 1) = True
	  CASE 2
	     Dungeon(Column * 2 + 1, Row * 2 - 1) = True
	     Dungeon(Column * 2 + 1, Row * 2) = True
	  CASE 3
	     Dungeon(Column * 2 + 1, Row * 2 - 1) = True
	  END SELECT
       NEXT
    NEXT
    FOR Row = 1 TO 23
       FOR Column = 1 TO 101
	  FOR Index = 1 TO 4
	     Rooms(Row, Column).Direct(Index) = False
	  NEXT
       NEXT
    NEXT
    Row = 1: Column = 1
    Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
    Rooms(Row, Column).Direct(2) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
    Rooms(Row, Column).Direct(3) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 361
    Row = 1: Column = 101
    Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
    Rooms(Row, Column).Direct(4) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
    Rooms(Row, Column).Direct(3) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 361
    Row = 23: Column = 1
    Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
    Rooms(Row, Column).Direct(2) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
    Rooms(Row, Column).Direct(1) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 159
    Row = 23: Column = 101
    Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
    Rooms(Row, Column).Direct(4) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
    Rooms(Row, Column).Direct(1) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 159
    FOR Column = 2 TO 100
       Row = 1
       Dungeon(Row, Column) = True
       Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
       Rooms(Row, Column).Direct(2) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
       Rooms(Row, Column).Direct(4) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
       Row = 23
       Dungeon(Row, Column) = True
       Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
       Rooms(Row, Column).Direct(2) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
       Rooms(Row, Column).Direct(4) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
    NEXT
    FOR Row = 2 TO 22
       Column = 1
       Dungeon(Row, Column) = True
       Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
       Rooms(Row, Column).Direct(1) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 159
       Rooms(Row, Column).Direct(3) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 361
       Column = 101
       Dungeon(Row, Column) = True
       Rooms(Row, Column).ShortDesc = "Dungeon wall perimeter."
       Rooms(Row, Column).Direct(1) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 159
       Rooms(Row, Column).Direct(3) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 361
    NEXT
    FOR Index = True TO 0 STEP 1
       FOR Row = 2 TO 22
	  FOR Column = 2 TO 100
	     Rooms(Row, Column).ShortDesc = "Dungeon room."
	     IF Dungeon(Row, Column) = Index THEN
		IF Dungeon(Row - 1, Column) = Index THEN
		   Rooms(Row, Column).Direct(1) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 159
		   Rooms(Row - 1, Column).Direct(3) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		END IF
		IF Dungeon(Row, Column + 1) = Index THEN
		   Rooms(Row, Column).Direct(2) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
		   Rooms(Row, Column + 1).Direct(4) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		END IF
		IF Dungeon(Row + 1, Column) = Index THEN
		   Rooms(Row, Column).Direct(3) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 361
		   Rooms(Row + 1, Column).Direct(1) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		END IF
		IF Dungeon(Row, Column - 1) = Index THEN
		   Rooms(Row, Column).Direct(4) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
		   Rooms(Row, Column - 1).Direct(2) = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		END IF
	     END IF
	  NEXT
       NEXT
    NEXT
    ' write room data file
    Max.Treasure = CSNG(LOF(3) / LEN(TreasureRecord))
    FOR Row = 1 TO 23
       FOR Column = 1 TO 101
	  FOR Array.Index = 1 TO 19
	     DungeonRoom.LongDesc(Array.Index) = SFalse
	  NEXT
	  DungeonRoom.Action = SFalse
	  DungeonRoom.ShortDesc = Rooms(Row, Column).ShortDesc
	  Next.Descrip = CSNG(LOF(5) / LEN(RoomDescRecord)) + 1!
	  RoomDescRecord.Descrip = Rooms(Row, Column).ShortDesc
	  PUT 5, Next.Descrip, RoomDescRecord
	  DungeonRoom.LongDesc(1) = Next.Descrip
	  Next.Descrip = CSNG(LOF(5) / LEN(RoomDescRecord)) + 1!
	  RoomDescRecord.Descrip = "Level" + STR$(Level) + ", room" + STR$(Row) + "," + STR$(Column) + "."
	  PUT 5, Next.Descrip, RoomDescRecord
	  DungeonRoom.LongDesc(2) = Next.Descrip
	  FOR Array.Index = 1 TO 12
	     DungeonRoom.Direct(Array.Index) = False
	  NEXT
	  FOR Array.Index = 1 TO 4
	     DungeonRoom.Direct(Array.Index) = Rooms(Row, Column).Direct(Array.Index)
	  NEXT
	  DungeonRoom.MonsterClass = False
	  IF RND > .5 THEN
             If Level>10 Then
                DungeonRoom.MonsterClass = 10
             Else
                DungeonRoom.MonsterClass = Level
             Endif
	  END IF
	  Room.Number = Room.Number + 1!
	  DungeonRoom.First = SFalse
	  DungeonRoom.Last = SFalse
	  DungeonRoom.First2 = SFalse
	  DungeonRoom.Last2 = SFalse
	  Treasure.Item = False
	  DO
	     IF RND > .5 THEN
		EXIT DO
	     END IF
	     IF Treasure.Item >= 20 THEN
		EXIT DO
	     END IF
	     Treasure.Number = CSNG(INT(RND * 20 + 1) + (Level - 1) * 20)
	     IF Treasure.Number > SFalse AND Treasure.Number <= Max.Treasure THEN
		Treasure.Item = Treasure.Item + 1
		GET 3, Treasure.Number, TreasureRecord
		Treasure.Charges = TreasureRecord.Charges
		GOSUB Write.Room.Inventory2
	     END IF
	  LOOP
	  PUT 1, Room.Number, DungeonRoom
       NEXT
    NEXT
 NEXT
 ' make eight stairs up/down on each level
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Making stairs 0";
    Var = CSRLIN
 END IF
 ' make eight stairs on each level
 IF Dungeon.Levels > 1 THEN
    FOR Level = 1 TO Dungeon.Levels - 1
       FOR Index = 1 TO 8
	  Row = INT(RND * 21 + 2)
	  Column = INT(RND * 99 + 2)
	  Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
	  ObjectRecord.ObjectName = "some stairs going up"
	  ObjectRecord.ShortName = "STAIRS"
	  ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
	  ObjectRecord.Permanent = True
	  ObjectRecord.LongDesc = "The stairs go up to level" + STR$(Level) + "."
	  ObjectRecord.ShortDesc = "You enter the stairs."
	  ObjectRecord.Prefix1 = Strng3 + "F9"
	  ObjectRecord.PortalPassword = Nul
          For VarQ=1 To 19
             ObjectRecord.ObjDesc(VarQ)=0!
          Next
	  PUT 2, Next.Object, ObjectRecord
	  Room.Number = CSNG(Level * 2323 + (Row - 1) * 101 + Column + 260)
	  GOSUB Write.Room.Inventory
	  IF Quiet.Mode = False THEN
	     LOCATE Var, 14, 1
	     PRINT Next.Object;
	  END IF
	  Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
	  ObjectRecord.ObjectName = "some stairs going down"
	  ObjectRecord.ShortName = "STAIRS"
	  ObjectRecord.RoomLink = Level * 2323 + (Row - 1) * 101 + Column + 260
	  ObjectRecord.Permanent = True
	  ObjectRecord.LongDesc = "The stairs go down to level" + STR$(Level + 1) + "."
	  ObjectRecord.ShortDesc = "You enter the stairs."
	  ObjectRecord.Prefix1 = Strng3 + "F9"
	  ObjectRecord.PortalPassword = Nul
          For VarQ=1 To 19
             ObjectRecord.ObjDesc(VarQ)=0!
          Next
	  PUT 2, Next.Object, ObjectRecord
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GOSUB Write.Room.Inventory
	  IF Quiet.Mode = False THEN
	     LOCATE Var, 14, 1
	     PRINT Next.Object;
	  END IF
       NEXT
    NEXT
 END IF
 ' make eight pits on each level
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Making pits 0";
    Var = CSRLIN
 END IF
 Number.Pits = False
 IF Dungeon.Levels > 1 THEN
    FOR Level = 1 TO Dungeon.Levels - 1
       FOR Index = 1 TO 8
	  Row = INT(RND * 21 + 2)
	  Column = INT(RND * 99 + 2)
	  Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
	  ObjectRecord.ObjectName = "a pit going down"
	  ObjectRecord.ShortName = "PIT"
	  ObjectRecord.RoomLink = Level * 2323 + (Row - 1) * 101 + Column + 260
	  ObjectRecord.Invisible = False
	  ObjectRecord.Permanent = True
	  ObjectRecord.LongDesc = "The pit goes down to level" + STR$(Level + 1) + "."
	  ObjectRecord.ShortDesc = "You fall down the pit."
	  ObjectRecord.Prefix1 = Strng3 + "FA"
	  ObjectRecord.PortalPassword = Nul
          For VarQ=1 To 19
             ObjectRecord.ObjDesc(VarQ)=0!
          Next
	  PUT 2, Next.Object, ObjectRecord
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GOSUB Write.Room.Inventory
	  Number.Pits = Number.Pits + 1
	  IF Quiet.Mode = False THEN
	     LOCATE Var, 12, 1
	     PRINT Number.Pits;
	  END IF
       NEXT
    NEXT
 END IF
 ' make eight ladders on each level
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Making ladders 0";
    Var = CSRLIN
 END IF
 Number.Ladders = False
 IF Dungeon.Levels > 1 THEN
    FOR Level = 2 TO Dungeon.Levels
       FOR Index = 1 TO 8
	  Row = INT(RND * 21 + 2)
	  Column = INT(RND * 99 + 2)
	  Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
	  ObjectRecord.ObjectName = "a ladder going up"
	  ObjectRecord.ShortName = "LADDER"
	  ObjectRecord.RoomLink = (Level - 2) * 2323 + (Row - 1) * 101 + Column + 260
	  ObjectRecord.Invisible = False
	  ObjectRecord.Permanent = True
	  ObjectRecord.LongDesc = "The ladder goes up to level" + STR$(Level - 1) + "."
	  ObjectRecord.ShortDesc = "You climb up the ladder."
	  ObjectRecord.Prefix1 = Strng3 + "FB"
	  ObjectRecord.PortalPassword = Nul
          For VarQ=1 To 19
             ObjectRecord.ObjDesc(VarQ)=0!
          Next
	  PUT 2, Next.Object, ObjectRecord
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GOSUB Write.Room.Inventory
	  Number.Ladders = Number.Ladders + 1
	  IF Quiet.Mode = False THEN
	     LOCATE Var, 15, 1
	     PRINT Number.Ladders;
	  END IF
       NEXT
    NEXT
 END IF
 ' add doors in hallways on each level
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Making doors ";
    Var = CSRLIN
 END IF
 Number.Doors = False
 FOR Level = 1 TO Dungeon.Levels
    FOR Row = 2 TO 22
       FOR Column = 2 TO 100
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(4) = False THEN ' wall west
	     IF DungeonRoom.Direct(1) = False THEN ' wall north
		IF DungeonRoom.Direct(2) = False THEN ' wall east
		   ' make door north
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going north"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to north room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 2) * 101 + Column + 260
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		   GOSUB Write.Room.Inventory
		   ' make door south
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going south"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to south room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 2) * 101 + Column + 260)
		   GOSUB Write.Room.Inventory
		END IF
	     END IF
	  END IF
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(1) = False THEN ' wall north
	     IF DungeonRoom.Direct(2) = False THEN ' wall east
		IF DungeonRoom.Direct(3) = False THEN ' wall south
		   ' make door east
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going east"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to east room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		   GOSUB Write.Room.Inventory
		   ' make door west
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going west"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to west room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 261)
		   GOSUB Write.Room.Inventory
		END IF
	     END IF
	  END IF
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(2) = False THEN ' wall east
	     IF DungeonRoom.Direct(3) = False THEN ' wall south
		IF DungeonRoom.Direct(4) = False THEN ' wall west
		   ' make door south
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going south"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to south room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + Row * 101 + Column + 260
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		   GOSUB Write.Room.Inventory
		   ' make door north
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going north"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to west room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + Row * 101 + Column + 260)
		   GOSUB Write.Room.Inventory
		END IF
	     END IF
	  END IF
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(3) = False THEN ' wall south
	     IF DungeonRoom.Direct(4) = False THEN ' wall west
		IF DungeonRoom.Direct(1) = False THEN ' wall north
		   ' make door west
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going west"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to south room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		   GOSUB Write.Room.Inventory
		   ' make door east
		   Number.Doors = Number.Doors + 1
		   IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
		      IF Quiet.Mode = False THEN
                         LOCATE Var, 14, 1
                         PRINT Form$(Cdbl(Number.Doors));
		      END IF
		   END IF
		   ' store door
		   Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		   ObjectRecord.ObjectName = "a door going east"
		   ObjectRecord.ShortName = "DOOR"
		   ' link door to west room
		   ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		   ObjectRecord.Permanent = True
		   ObjectRecord.LongDesc = "You see a metal dungeon door."
		   ObjectRecord.ShortDesc = "You enter the door."
		   ObjectRecord.Prefix1 = Strng3 + "FC"
		   ObjectRecord.PortalPassword = Nul
                   For VarQ=1 To 19
                       ObjectRecord.ObjDesc(VarQ)=0!
                   Next
		   PUT 2, Next.Object, ObjectRecord
		   ' store door number
		   Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 259)
		   GOSUB Write.Room.Inventory
		END IF
	     END IF
	  END IF
       NEXT
    NEXT
 NEXT
 IF Quiet.Mode = False THEN
    LOCATE Var, 14, 1
    PRINT Form$(Cdbl(Number.Doors));
 END IF
 ' add invisible doors in hallways on each level
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Making invisible doors ";
    Var = CSRLIN
 END IF
 Number.Doors = False
 FOR Level = 1 TO Dungeon.Levels
    FOR Row = 2 TO 22
       FOR Column = 2 TO 100
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(4) = False THEN ' wall west
	     IF DungeonRoom.Direct(1) = False THEN ' wall north
		IF DungeonRoom.Direct(2) = False THEN ' wall east
		   ' make door east
		   IF RND > .5 THEN
		      ' display door number
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going east"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                          ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door west
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going west"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                          ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 261)
		      GOSUB Write.Room.Inventory
		   END IF
		   ' make door west
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going west"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                          ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door east
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going east"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                          ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 259)
		      GOSUB Write.Room.Inventory
		   END IF
		END IF
	     END IF
	  END IF
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(1) = False THEN ' wall north
	     IF DungeonRoom.Direct(2) = False THEN ' wall east
		IF DungeonRoom.Direct(3) = False THEN ' wall south
		   ' make door south
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going south"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + Row * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                          ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door north
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going north"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + Row * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		   END IF
		   ' make door north
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going north"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 2) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door south
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going south"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 2) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		   END IF
		END IF
	     END IF
	  END IF
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(2) = False THEN ' wall east
	     IF DungeonRoom.Direct(3) = False THEN ' wall south
		IF DungeonRoom.Direct(4) = False THEN ' wall west
		   ' make door east
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going east"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 261
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door west
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going west"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 261)
		      GOSUB Write.Room.Inventory
		   END IF
		   ' make door west
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going west"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 259
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door east
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going east"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 259)
		      GOSUB Write.Room.Inventory
		   END IF
		END IF
	     END IF
	  END IF
	  Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
	  GET 1, Room.Number, DungeonRoom
	  IF DungeonRoom.Direct(3) = False THEN ' wall south
	     IF DungeonRoom.Direct(4) = False THEN ' wall west
		IF DungeonRoom.Direct(1) = False THEN ' wall north
		   ' make door north
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going north"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 2) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door south
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going south"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 2) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		   END IF
		   ' make door south
		   IF RND > .5 THEN
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going south"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to east room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + Row * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + (Row - 1) * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		      ' make door north
		      Number.Doors = Number.Doors + 1
		      IF Number.Doors / 10 = INT(Number.Doors / 10) THEN
			 IF Quiet.Mode = False THEN
                            LOCATE Var, 24, 1
                            PRINT Form$(Cdbl(Number.Doors));
			 END IF
		      END IF
		      ' store door
		      Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
		      ObjectRecord.ObjectName = "a door going north"
		      ObjectRecord.ShortName = "DOOR"
		      ' link door to south room
		      ObjectRecord.RoomLink = (Level - 1) * 2323 + (Row - 1) * 101 + Column + 260
		      ObjectRecord.Invisible = True
		      ObjectRecord.Permanent = True
		      ObjectRecord.LongDesc = "You see a wooden dungeon door."
		      ObjectRecord.ShortDesc = "You enter the door."
		      ObjectRecord.Prefix1 = Strng3 + "FC"
		      ObjectRecord.PortalPassword = Nul
                      For VarQ=1 To 19
                         ObjectRecord.ObjDesc(VarQ)=0!
                      Next
		      PUT 2, Next.Object, ObjectRecord
		      ' store door number
		      Room.Number = CSNG((Level - 1) * 2323 + Row * 101 + Column + 260)
		      GOSUB Write.Room.Inventory
		   END IF
		END IF
	     END IF
	  END IF
       NEXT
    NEXT
 NEXT
 IF Quiet.Mode = False THEN
    LOCATE Var, 24, 1
    PRINT Form$(Cdbl(Number.Doors));
 END IF
 ' add tower entrances
 IF Quiet.Mode = False THEN
    PRINT
    PRINT "Adding tower entrances."
 END IF
 FOR Tower.Number = 1 TO 10
    SELECT CASE Tower.Number
    CASE 1
       Tower.Room = 261!
    CASE 2
       Tower.Room = 294!
    CASE 3
       Tower.Room = 327!
    CASE 4
       Tower.Room = 361!
    CASE 5
       Tower.Room = 1372!
    CASE 6
       Tower.Room = 1472!
    CASE 7
       Tower.Room = 2483!
    CASE 8
       Tower.Room = 2516!
    CASE 9
       Tower.Room = 2549!
    CASE 10
       Tower.Room = 2583!
    END SELECT
    GET 1, Tower.Room, DungeonRoom
    DungeonRoom.Direct(11) = CSNG((Tower.Number - 1) * 10 + 161)
    PUT 1, Tower.Room, DungeonRoom
 NEXT
 ' add town road entrances
 IF Quiet.Mode = False THEN
    PRINT "Adding road entrances."
 END IF
 FOR Town.Roads = 1 TO 16
    SELECT CASE Town.Roads
    CASE 1
       GET 1, 270, DungeonRoom
       DungeonRoom.Direct(1) = 145!
       PUT 1, 270, DungeonRoom
    CASE 2
       GET 1, 290, DungeonRoom
       DungeonRoom.Direct(1) = 146!
       PUT 1, 290, DungeonRoom
    CASE 3
       GET 1, 310, DungeonRoom
       DungeonRoom.Direct(1) = 147!
       PUT 1, 310, DungeonRoom
    CASE 4
       GET 1, 330, DungeonRoom
       DungeonRoom.Direct(1) = 148!
       PUT 1, 330, DungeonRoom
    CASE 5
       GET 1, 2513, DungeonRoom
       DungeonRoom.Direct(3) = 149!
       PUT 1, 2513, DungeonRoom
    CASE 6
       GET 1, 2533, DungeonRoom
       DungeonRoom.Direct(3) = 150!
       PUT 1, 2533, DungeonRoom
    CASE 7
       GET 1, 2553, DungeonRoom
       DungeonRoom.Direct(3) = 151!
       PUT 1, 2553, DungeonRoom
    CASE 8
       GET 1, 2573, DungeonRoom
       DungeonRoom.Direct(3) = 152!
       PUT 1, 2573, DungeonRoom
    CASE 9
       GET 1, 765, DungeonRoom
       DungeonRoom.Direct(2) = 153!
       PUT 1, 765, DungeonRoom
    CASE 10
       GET 1, 1169, DungeonRoom
       DungeonRoom.Direct(2) = 154!
       PUT 1, 1169, DungeonRoom
    CASE 11
       GET 1, 1573, DungeonRoom
       DungeonRoom.Direct(2) = 155!
       PUT 1, 1573, DungeonRoom
    CASE 12
       GET 1, 1977, DungeonRoom
       DungeonRoom.Direct(2) = 156!
       PUT 1, 1977, DungeonRoom
    CASE 13
       GET 1, 665, DungeonRoom
       DungeonRoom.Direct(4) = 157!
       PUT 1, 665, DungeonRoom
    CASE 14
       GET 1, 1069, DungeonRoom
       DungeonRoom.Direct(4) = 158!
       PUT 1, 1069, DungeonRoom
    CASE 15
       GET 1, 1473, DungeonRoom
       DungeonRoom.Direct(4) = 159!
       PUT 1, 1473, DungeonRoom
    CASE 16
       GET 1, 1877, DungeonRoom
       DungeonRoom.Direct(4) = 160!
       PUT 1, 1877, DungeonRoom
    END SELECT
 NEXT
 ' connect towns
 IF Quiet.Mode = False THEN
    PRINT "Connecting towns."
 END IF
 FOR Town.Roads = 1 TO 16
    SELECT CASE Town.Roads
    CASE 1, 2, 3, 5, 6, 7
       GET 1, Town.Roads, DungeonRoom
       East.Room = DungeonRoom.Direct(2)
       GET 1, Town.Roads + 1, DungeonRoom
       West.Room = DungeonRoom.Direct(4)
       FOR Next.Road = 1 TO 7
	  Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
	  DungeonRoom.ShortDesc = "Town road."
	  FOR Index = 1 TO 19
	     DungeonRoom.LongDesc(Index) = SFalse
	  NEXT
	  FOR Directions = 1 TO 12
	     DungeonRoom.Direct(Directions) = SFalse
	  NEXT
	  SELECT CASE Next.Road
	  CASE 1
	     DungeonRoom.Direct(4) = East.Room
	     DungeonRoom.Direct(2) = Next.Square + 1!
	     PUT 1, Next.Square, DungeonRoom
	     GET 1, East.Room, DungeonRoom
	     DungeonRoom.Direct(2) = Next.Square
	     PUT 1, East.Room, DungeonRoom
	  CASE 7
	     DungeonRoom.Direct(2) = West.Room
	     DungeonRoom.Direct(4) = Next.Square - 1!
	     PUT 1, Next.Square, DungeonRoom
	     GET 1, West.Room, DungeonRoom
	     DungeonRoom.Direct(4) = Next.Square
	     PUT 1, West.Room, DungeonRoom
	  CASE 2 TO 6
	     DungeonRoom.Direct(2) = Next.Square + 1!
	     DungeonRoom.Direct(4) = Next.Square - 1!
	     PUT 1, Next.Square, DungeonRoom
	  END SELECT
       NEXT
    CASE 9, 10, 11, 13, 14, 15
       GET 1, Town.Roads, DungeonRoom
       South.Room = DungeonRoom.Direct(3)
       GET 1, Town.Roads + 1, DungeonRoom
       North.Room = DungeonRoom.Direct(1)
       Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
       DungeonRoom.ShortDesc = "Town road."
       FOR Index = 1 TO 19
	  DungeonRoom.LongDesc(Index) = SFalse
       NEXT
       FOR Directions = 1 TO 12
	  DungeonRoom.Direct(Directions) = SFalse
       NEXT
       DungeonRoom.Direct(1) = South.Room
       DungeonRoom.Direct(3) = North.Room
       PUT 1, Next.Square, DungeonRoom
       GET 1, South.Room, DungeonRoom
       DungeonRoom.Direct(3) = Next.Square
       PUT 1, South.Room, DungeonRoom
       GET 1, North.Room, DungeonRoom
       DungeonRoom.Direct(1) = Next.Square
       PUT 1, North.Room, DungeonRoom
    END SELECT
 NEXT
 ' connect corner towns
 GET 1, 1, DungeonRoom
 West.Room = DungeonRoom.Direct(4)
 GET 1, 13, DungeonRoom
 North.Room = DungeonRoom.Direct(1)
 FOR Next.Road = 1 TO 10
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Town road."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Next.Road
    CASE 1
       DungeonRoom.Direct(5) = West.Room
       DungeonRoom.Direct(7) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
       GET 1, West.Room, DungeonRoom
       DungeonRoom.Direct(7) = Next.Square
       PUT 1, West.Room, DungeonRoom
    CASE 2 TO 9
       DungeonRoom.Direct(5) = Next.Square - 1!
       DungeonRoom.Direct(7) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 10
       DungeonRoom.Direct(5) = Next.Square - 1!
       DungeonRoom.Direct(7) = North.Room
       PUT 1, Next.Square, DungeonRoom
       GET 1, North.Room, DungeonRoom
       DungeonRoom.Direct(5) = Next.Square
       PUT 1, North.Room, DungeonRoom
    END SELECT
 NEXT
 GET 1, 4, DungeonRoom
 East.Room = DungeonRoom.Direct(2)
 GET 1, 9, DungeonRoom
 North.Room = DungeonRoom.Direct(1)
 FOR Next.Road = 1 TO 10
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Town road."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Next.Road
    CASE 1
       DungeonRoom.Direct(8) = East.Room
       DungeonRoom.Direct(6) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
       GET 1, East.Room, DungeonRoom
       DungeonRoom.Direct(6) = Next.Square
       PUT 1, East.Room, DungeonRoom
    CASE 2 TO 9
       DungeonRoom.Direct(8) = Next.Square - 1!
       DungeonRoom.Direct(6) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 10
       DungeonRoom.Direct(8) = Next.Square - 1!
       DungeonRoom.Direct(6) = North.Room
       PUT 1, Next.Square, DungeonRoom
       GET 1, North.Room, DungeonRoom
       DungeonRoom.Direct(8) = Next.Square
       PUT 1, North.Room, DungeonRoom
    END SELECT
 NEXT
 GET 1, 5, DungeonRoom
 West.Room = DungeonRoom.Direct(4)
 GET 1, 16, DungeonRoom
 South.Room = DungeonRoom.Direct(3)
 FOR Next.Road = 1 TO 10
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Town road."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Next.Road
    CASE 1
       DungeonRoom.Direct(8) = South.Room
       DungeonRoom.Direct(6) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
       GET 1, South.Room, DungeonRoom
       DungeonRoom.Direct(6) = Next.Square
       PUT 1, South.Room, DungeonRoom
    CASE 2 TO 9
       DungeonRoom.Direct(8) = Next.Square - 1!
       DungeonRoom.Direct(6) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 10
       DungeonRoom.Direct(8) = Next.Square - 1!
       DungeonRoom.Direct(6) = West.Room
       PUT 1, Next.Square, DungeonRoom
       GET 1, West.Room, DungeonRoom
       DungeonRoom.Direct(8) = Next.Square
       PUT 1, West.Room, DungeonRoom
    END SELECT
 NEXT
 GET 1, 8, DungeonRoom
 East.Room = DungeonRoom.Direct(2)
 GET 1, 12, DungeonRoom
 South.Room = DungeonRoom.Direct(3)
 FOR Next.Road = 1 TO 10
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Town road."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Next.Road
    CASE 1
       DungeonRoom.Direct(5) = South.Room
       DungeonRoom.Direct(7) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
       GET 1, South.Room, DungeonRoom
       DungeonRoom.Direct(7) = Next.Square
       PUT 1, South.Room, DungeonRoom
    CASE 2 TO 9
       DungeonRoom.Direct(5) = Next.Square - 1!
       DungeonRoom.Direct(7) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 10
       DungeonRoom.Direct(5) = Next.Square - 1!
       DungeonRoom.Direct(7) = East.Room
       PUT 1, Next.Square, DungeonRoom
       GET 1, East.Room, DungeonRoom
       DungeonRoom.Direct(5) = Next.Square
       PUT 1, East.Room, DungeonRoom
    END SELECT
 NEXT
 IF Quiet.Mode = False THEN
    PRINT "Adding mountain paths."
 END IF
 GET 1, 4, DungeonRoom
 North.Room = DungeonRoom.Direct(1)
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 GET 1, North.Room, DungeonRoom
 DungeonRoom.Direct(9) = Next.Square
 PUT 1, North.Room, DungeonRoom
 FOR Mountain.Road = 1 TO 10
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(10) = North.Room
       DungeonRoom.Direct(9) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 8
       DungeonRoom.Direct(10) = Next.Square - 1!
       DungeonRoom.Direct(9) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 9
       DungeonRoom.Direct(10) = Next.Square - 1!
       DungeonRoom.Direct(1) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 10
       DungeonRoom.ShortDesc = "Mountain top."
       DungeonRoom.Direct(3) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
       Mountain.Top = Next.Square
    END SELECT
 NEXT
 GET 1, Mountain.Top, DungeonRoom
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 DungeonRoom.Direct(8) = Next.Square
 PUT 1, Mountain.Top, DungeonRoom
 FOR Mountain.Road = 1 TO 5
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(6) = Mountain.Top
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 4
       DungeonRoom.Direct(9) = Next.Square - 1!
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 5
       DungeonRoom.ShortDesc = "Dead end."
       DungeonRoom.Direct(9) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
    END SELECT
 NEXT
 GET 1, Mountain.Top, DungeonRoom
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 DungeonRoom.Direct(5) = Next.Square
 PUT 1, Mountain.Top, DungeonRoom
 FOR Mountain.Road = 1 TO 5
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(7) = Mountain.Top
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 4
       DungeonRoom.Direct(9) = Next.Square - 1!
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 5
       DungeonRoom.ShortDesc = "Dead end."
       DungeonRoom.Direct(9) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
    END SELECT
 NEXT
 GET 1, Mountain.Top, DungeonRoom
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 DungeonRoom.Direct(1) = Next.Square
 PUT 1, Mountain.Top, DungeonRoom
 FOR Mountain.Road = 1 TO 5
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(3) = Mountain.Top
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 4
       DungeonRoom.Direct(9) = Next.Square - 1!
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 5
       DungeonRoom.ShortDesc = "Dead end."
       DungeonRoom.Direct(9) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
       Apartment.Square1 = Next.Square
    END SELECT
 NEXT
 GET 1, 5, DungeonRoom
 South.Room = DungeonRoom.Direct(3)
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 GET 1, South.Room, DungeonRoom
 DungeonRoom.Direct(9) = Next.Square
 PUT 1, South.Room, DungeonRoom
 FOR Mountain.Road = 1 TO 10
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(10) = South.Room
       DungeonRoom.Direct(9) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 8
       DungeonRoom.Direct(10) = Next.Square - 1!
       DungeonRoom.Direct(9) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 9
       DungeonRoom.Direct(10) = Next.Square - 1!
       DungeonRoom.Direct(3) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 10
       DungeonRoom.ShortDesc = "Mountain top."
       DungeonRoom.Direct(1) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
       Mountain.Top = Next.Square
    END SELECT
 NEXT
 GET 1, Mountain.Top, DungeonRoom
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 DungeonRoom.Direct(6) = Next.Square
 PUT 1, Mountain.Top, DungeonRoom
 FOR Mountain.Road = 1 TO 5
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(8) = Mountain.Top
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 4
       DungeonRoom.Direct(9) = Next.Square - 1!
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 5
       DungeonRoom.ShortDesc = "Dead end."
       DungeonRoom.Direct(9) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
    END SELECT
 NEXT
 GET 1, Mountain.Top, DungeonRoom
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 DungeonRoom.Direct(5) = Next.Square
 PUT 1, Mountain.Top, DungeonRoom
 FOR Mountain.Road = 1 TO 5
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(7) = Mountain.Top
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 4
       DungeonRoom.Direct(9) = Next.Square - 1!
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 5
       DungeonRoom.ShortDesc = "Dead end."
       DungeonRoom.Direct(9) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
    END SELECT
 NEXT
 GET 1, Mountain.Top, DungeonRoom
 Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
 DungeonRoom.Direct(3) = Next.Square
 PUT 1, Mountain.Top, DungeonRoom
 FOR Mountain.Road = 1 TO 5
    Next.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
    DungeonRoom.ShortDesc = "Mountain path."
    FOR Index = 1 TO 19
       DungeonRoom.LongDesc(Index) = SFalse
    NEXT
    FOR Directions = 1 TO 12
       DungeonRoom.Direct(Directions) = SFalse
    NEXT
    SELECT CASE Mountain.Road
    CASE 1
       DungeonRoom.Direct(1) = Mountain.Top
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 2 TO 4
       DungeonRoom.Direct(9) = Next.Square - 1!
       DungeonRoom.Direct(10) = Next.Square + 1!
       PUT 1, Next.Square, DungeonRoom
    CASE 5
       DungeonRoom.ShortDesc = "Dead end."
       DungeonRoom.Direct(9) = Next.Square - 1!
       PUT 1, Next.Square, DungeonRoom
       Apartment.Square2 = Next.Square
    END SELECT
 NEXT

 REM floorplan #1         floorplan #2
 REM 1,  2,  3,  4,  5    1,  2,  3,  4,  5
 REM x   x   e   x   x    x - x   e   x - x
 REM |   |   |   |   |        |   |   |
 REM x - x - d - x - x    x - x - d - x - x
 REM 6,  7,  8,  9,  10   6,  7,  8,  9,  10

 REM (x=room, d=door, e=elevator)

 IF Quiet.Mode = False THEN
    PRINT "Adding apartments."
 END IF
 FOR Apartments = 1 TO 2
    FOR Level = 1 TO Dungeon.Levels
       Apartment.Square = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
       FOR Apartment.Room = 1 TO 10
	  FOR Index = 1 TO 19
	     DungeonRoom.LongDesc(Index) = SFalse
	  NEXT
	  FOR Directions = 1 TO 12
	     DungeonRoom.Direct(Directions) = SFalse
	  NEXT
	  SELECT CASE Apartment.Room
	  CASE 1
	     DungeonRoom.ShortDesc = "Bedroom."
	     IF (Level MOD 2) = False THEN
		DungeonRoom.Direct(2) = Apartment.Square + 1!
	     ELSE
		DungeonRoom.Direct(3) = Apartment.Square + 5!
	     END IF
	  CASE 2
	     DungeonRoom.ShortDesc = "Kitchen."
	     DungeonRoom.Direct(3) = Apartment.Square + 6!
	     IF (Level MOD 2) = False THEN
		DungeonRoom.Direct(4) = Apartment.Square
	     END IF
	  CASE 3
	     IF Dungeon.Levels > 1 THEN
		DungeonRoom.ShortDesc = "Elevator."
	     ELSE
		DungeonRoom.ShortDesc = "Storage room."
	     END IF
	     DungeonRoom.Direct(12) = Apartment.Square + 7!
	     Next.Descrip = CSNG(LOF(5) / LEN(RoomDescRecord)) + 1!
	     IF Dungeon.Levels > 1 THEN
		RoomDescRecord.Descrip = "Elevator, apartment level" + STR$(Level) + "."
	     ELSE
		RoomDescRecord.Descrip = "Storage room."
	     END IF
	     PUT 5, Next.Descrip, RoomDescRecord
	     DungeonRoom.LongDesc(1) = Next.Descrip
	  CASE 4
	     DungeonRoom.ShortDesc = "Kitchen."
	     DungeonRoom.Direct(3) = Apartment.Square + 8!
	     IF (Level MOD 2) = False THEN
		DungeonRoom.Direct(2) = Apartment.Square + 4!
	     END IF
	  CASE 5
	     DungeonRoom.ShortDesc = "Bedroom."
	     IF (Level MOD 2) = False THEN
		DungeonRoom.Direct(4) = Apartment.Square + 3!
	     ELSE
		DungeonRoom.Direct(3) = Apartment.Square + 9!
	     END IF
	  CASE 6
	     DungeonRoom.ShortDesc = "Washroom."
	     DungeonRoom.Direct(2) = Apartment.Square + 6!
	     IF (Level MOD 2) <> False THEN
		DungeonRoom.Direct(1) = Apartment.Square
	     END IF
	  CASE 7
	     DungeonRoom.ShortDesc = "Den."
	     DungeonRoom.Direct(1) = Apartment.Square + 1!
	     DungeonRoom.Direct(2) = Apartment.Square + 7!
	     DungeonRoom.Direct(4) = Apartment.Square + 5!
	  CASE 8
	     DungeonRoom.ShortDesc = "Lobby."
	     DungeonRoom.Direct(2) = Apartment.Square + 8!
	     DungeonRoom.Direct(4) = Apartment.Square + 6!
	     Next.Descrip = CSNG(LOF(5) / LEN(RoomDescRecord)) + 1!
	     RoomDescRecord.Descrip = "Lobby, apartment level" + STR$(Level) + "."
	     PUT 5, Next.Descrip, RoomDescRecord
	     DungeonRoom.LongDesc(1) = Next.Descrip
	  CASE 9
	     DungeonRoom.ShortDesc = "Den."
	     DungeonRoom.Direct(1) = Apartment.Square + 3!
	     DungeonRoom.Direct(2) = Apartment.Square + 9!
	     DungeonRoom.Direct(4) = Apartment.Square + 7!
	  CASE 10
	     DungeonRoom.ShortDesc = "Washroom."
	     DungeonRoom.Direct(4) = Apartment.Square + 8!
	     IF (Level MOD 2) <> False THEN
		DungeonRoom.Direct(1) = Apartment.Square + 4!
	     END IF
	  END SELECT
	  Room.Number = CSNG(LOF(1) / LEN(DungeonRoom)) + 1!
	  PUT 1, Room.Number, DungeonRoom
	  IF Level = 1 THEN
	     IF Apartment.Room = 8 THEN
		IF Apartments = 1 THEN
		   Apartment.Door1 = Room.Number
		ELSE
		   Apartment.Door2 = Room.Number
		END IF
	     END IF
	  END IF
       NEXT
    NEXT
 NEXT
 ' add apartment doors
 Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
 ObjectRecord.Invisible = False
 ObjectRecord.ObjectName = "an apartment door"
 ObjectRecord.ShortName = "DOOR"
 ObjectRecord.RoomLink = Apartment.Door1
 ObjectRecord.Permanent = True
 ObjectRecord.LongDesc = "The apartment looks vacated."
 ObjectRecord.ShortDesc = "You enter the apartment."
 ObjectRecord.Prefix1 = Strng3 + "FD"
 ObjectRecord.PortalPassword = Nul
 For VarQ=1 To 19
    ObjectRecord.ObjDesc(VarQ)=0!
 Next
 PUT 2, Next.Object, ObjectRecord
 Room.Number = Apartment.Square1
 GOSUB Write.Room.Inventory
 Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
 ObjectRecord.Invisible = False
 ObjectRecord.ObjectName = "an apartment door"
 ObjectRecord.ShortName = "DOOR"
 ObjectRecord.RoomLink = Apartment.Door2
 ObjectRecord.Permanent = True
 ObjectRecord.LongDesc = "The apartment looks vacated."
 ObjectRecord.ShortDesc = "You enter the apartment."
 ObjectRecord.Prefix1 = Strng3 + "FD"
 ObjectRecord.PortalPassword = Nul
 For VarQ=1 To 19
    ObjectRecord.ObjDesc(VarQ)=0!
 Next
 PUT 2, Next.Object, ObjectRecord
 Room.Number = Apartment.Square2
 GOSUB Write.Room.Inventory
 GET 1, Apartment.Door1, DungeonRoom
 DungeonRoom.Direct(12) = Apartment.Square1
 PUT 1, Apartment.Door1, DungeonRoom
 GET 1, Apartment.Door2, DungeonRoom
 DungeonRoom.Direct(12) = Apartment.Square2
 PUT 1, Apartment.Door2, DungeonRoom

 ' add elevator doors
 IF Dungeon.Levels > 1 THEN
    Elevator.Door = Apartment.Door1
    FOR Level = 1 TO Dungeon.Levels
       GOSUB Make.Elevator
       Elevator.Door = Elevator.Door + 10!
    NEXT
    Elevator.Door = Apartment.Door2
    FOR Level = 1 TO Dungeon.Levels
       GOSUB Make.Elevator
       Elevator.Door = Elevator.Door + 10!
    NEXT
 ELSE
    Elevator.Door = Apartment.Door1
    FOR Level = 1 TO Dungeon.Levels
       GOSUB Make.Storage.Room
       Elevator.Door = Elevator.Door + 10!
    NEXT
 END IF

 ' add apartment elevators
 IF Dungeon.Levels > 1 THEN
    Elevator.Door = Apartment.Door1 - 5!
    GOSUB ElevatorUp
    FOR Level = 2 TO Dungeon.Levels - 1
       Elevator.Door = Elevator.Door + 10!
       GOSUB ElevatorUp
       GOSUB ElevatorDown
    NEXT
    Elevator.Door = Elevator.Door + 10!
    GOSUB ElevatorDown
    Elevator.Door = Apartment.Door2 - 5!
    GOSUB ElevatorUp
    FOR Level = 2 TO Dungeon.Levels - 1
       Elevator.Door = Elevator.Door + 10!
       GOSUB ElevatorUp
       GOSUB ElevatorDown
    NEXT
    Elevator.Door = Elevator.Door + 10!
    GOSUB ElevatorDown
 END IF

 ' end data file construction.
 COLOR 15, 0
 PRINT "Data files written to disk."
 Var! = LOF(1) / LEN(DungeonRoom)
 PRINT "Dungeon rooms created: ";Form$(Cdbl(Var!))
 COLOR 7, 0
 END

' store an object
Write.Room.Inventory:
 GET 1, Room.Number, DungeonRoom
 New.Item! = -(Next.Object)
 GOSUB Add.Item
 PUT 1, Room.Number, DungeonRoom
 RETURN

' store some treasure
Write.Room.Inventory2:
 New.Item! = Treasure.Number!
 GOSUB Add.Item
 RETURN

' writes data into a doubly linked list
Add.Item:
 Last.Item! = CSNG(LOF(4) / MessWorkRecLen) + 1!
 IF DungeonRoom.First = SFalse THEN
    DungeonRoom.First = Last.Item!
    DungeonRoom.Last = Last.Item!
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    MessWorkRecord.Room = Room.Number
    MessWorkRecord.Index = New.Item!
    MessWorkRecord.Charges = False
    IF New.Item! > SFalse THEN
       MessWorkRecord.Charges = TreasureRecord.Charges
    END IF
    MessWorkRecord.Plus = False
    PUT 4, Last.Item!, MessWorkRecord
 ELSE
    IF New.Item! > SFalse THEN
       GET 4, Last.Item! - 1!, MessWorkRecord
       MessWorkRecord.Next = Last.Item!
       PUT 4, Last.Item! - 1!, MessWorkRecord
    ELSE
       IF DungeonRoom.Last <> SFalse THEN
	  GET 4, DungeonRoom.Last, MessWorkRecord
	  MessWorkRecord.Next = Last.Item!
	  PUT 4, DungeonRoom.Last, MessWorkRecord
       END IF
    END IF
    MessWorkRecord.Prev = DungeonRoom.Last
    MessWorkRecord.Next = SFalse
    MessWorkRecord.Room = Room.Number
    MessWorkRecord.Index = New.Item!
    MessWorkRecord.Charges = False
    IF New.Item! > SFalse THEN
       MessWorkRecord.Charges = TreasureRecord.Charges
    END IF
    MessWorkRecord.Plus = False
    PUT 4, Last.Item!, MessWorkRecord
    DungeonRoom.Last = Last.Item!
 END IF
 RETURN

ElevatorUp:
 ' one elevator going up
 Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
 ObjectRecord.SwitchType = 1
 ObjectRecord.SwitchRoom = Elevator.Door + 10!
 ObjectRecord.Invisible = False
 ObjectRecord.ObjectName = "an elevator button"
 ObjectRecord.ShortName = "BUTTON"
 ObjectRecord.RoomLink = SFalse
 ObjectRecord.Permanent = True
 ObjectRecord.LongDesc = "Press the button."
 ObjectRecord.ShortDesc = "The elevator goes up one level."
 ObjectRecord.Prefix1 = Strng3 + "F1"
 ObjectRecord.PortalPassword = Nul
 For VarQ=1 To 19
    ObjectRecord.ObjDesc(VarQ)=0!
 Next
 PUT 2, Next.Object, ObjectRecord
 Room.Number = Elevator.Door
 GOSUB Write.Room.Inventory
 RETURN

ElevatorDown:
 ' one elevator going down
 Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
 ObjectRecord.SwitchType = 1
 ObjectRecord.SwitchRoom = Elevator.Door - 10!
 ObjectRecord.Invisible = False
 ObjectRecord.ObjectName = "an elevator button"
 ObjectRecord.ShortName = "BUTTON"
 ObjectRecord.RoomLink = SFalse
 ObjectRecord.Permanent = True
 ObjectRecord.LongDesc = "Press the button."
 ObjectRecord.ShortDesc = "The elevator goes down one level."
 ObjectRecord.Prefix1 = Strng3 + "F1"
 ObjectRecord.PortalPassword = Nul
 For VarQ=1 To 19
    ObjectRecord.ObjDesc(VarQ)=0!
 Next
 PUT 2, Next.Object, ObjectRecord
 Room.Number = Elevator.Door
 GOSUB Write.Room.Inventory
 RETURN

Make.Elevator:
 Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
 ObjectRecord.Invisible = False
 ObjectRecord.ObjectName = "an elevator door"
 ObjectRecord.ShortName = "DOOR"
 ObjectRecord.RoomLink = Elevator.Door - 5!
 ObjectRecord.Permanent = True
 ObjectRecord.LongDesc = "The elevator appears working."
 ObjectRecord.ShortDesc = "You enter the elevator."
 ObjectRecord.Prefix1 = Strng3 + "FE"
 ObjectRecord.PortalPassword = Nul
 For VarQ=1 To 19
    ObjectRecord.ObjDesc(VarQ)=0!
 Next
 PUT 2, Next.Object, ObjectRecord
 Room.Number = Elevator.Door
 GOSUB Write.Room.Inventory
 RETURN

Make.Storage.Room:
 Next.Object = CSNG(LOF(2) / LEN(ObjectRecord)) + 1!
 ObjectRecord.Invisible = False
 ObjectRecord.ObjectName = "a door"
 ObjectRecord.ShortName = "DOOR"
 ObjectRecord.RoomLink = Elevator.Door - 5!
 ObjectRecord.Permanent = True
 ObjectRecord.LongDesc = "The storage room is open."
 ObjectRecord.ShortDesc = "You enter the storage room."
 ObjectRecord.Prefix1 = Strng3 + "F2"
 ObjectRecord.PortalPassword = Nul
 For VarQ=1 To 19
    ObjectRecord.ObjDesc(VarQ)=0!
 Next
 PUT 2, Next.Object, ObjectRecord
 Room.Number = Elevator.Door
 GOSUB Write.Room.Inventory
 RETURN

Error.Routine:
 PRINT
 SELECT CASE ERR
 CASE 7
    PRINT "Out of memory."
 CASE 9
    PRINT "Subscript out of range."
 CASE 53
    PRINT "File not found."
 CASE 55
    PRINT "File already open."
 CASE 57
    PRINT "Device I/O error."
 CASE 61
    PRINT "Disk full."
 CASE 62
    PRINT "Input past eof."
 CASE 63
    PRINT "Bad record number."
 CASE 67
    PRINT "Not enough file handles."
 CASE 68
    PRINT "Device unavailable."
 CASE 70
    PRINT "Permission denied."
 CASE 71
    PRINT "Disk not ready."
 CASE 76
    PRINT "Pathname not found."
 CASE ELSE
    PRINT "Untrapped error" + STR$(ERR) + "."
 END SELECT
 COLOR 7, 0
 END

Boot.Usage:
 COLOR 14, 0
 PRINT "DndInit v5.0a Dndbbs data file initialize program."
 COLOR 15, 0
 PRINT "Usage:"
 COLOR 14, 0
 PRINT "   DndInit <levels> [/i][/q][/n:<##>]"
 COLOR 15, 0
 PRINT "Where:"
 COLOR 14, 0
 PRINT "   <levels> is 1 to"+Str$(MaxLevels)+"."
 PRINT "     or 0 to init blank rooms,"
 PRINT "   and/or /i to init only rooms file."
 PRINT "   Use /q to disable output."
 PRINT "   Use /n: to override node to 0-9/A-Z/10-99."
 COLOR 7, 0
 END

 ' room #1 - #10 training areas
 DATA "Fighter training"
 DATA "Magic User training"
 DATA "Thief training"
 DATA "Cleric training"
 DATA "Paladin training"
 DATA "Ranger training"
 DATA "Druid training"
 DATA "Lady training"
 DATA "Assistant DM training"
 DATA "Dungeon Master training"
 ' room #11, cleric
 DATA "Sanctuary"
 ' room #12, jailer
 DATA "Jail Room"
 ' room #13, fence
 DATA "Pawn Shoppe"
 ' room #14, blacksmith
 DATA "Weapons Shoppe"
 ' room #15, broker
 DATA "Bank Shop"
 ' room #16, alchemist
 DATA "Wizard Master Shoppe"

SUB Get.Config(Var1$)
 ON LOCAL ERROR GOTO Config.Error
 DND.Path$ = ENVIRON$("DNDBBS")
 IF DND.Path$ <> Nul THEN
    IF RIGHT$(DND.Path$, 1) <> "\" THEN
       DND.Path$ = DND.Path$ + "\"
    END IF
 END IF
 FileName = DND.Path$ + "DND" + NodeX + ".CFG"
 CLOSE #1
 OPEN FileName FOR INPUT SHARED AS #1
 LINE INPUT #1, Var$
 FOR Temp1 = 1 TO MaxConfigArray1
    INPUT #1, Var!
 NEXT
 FOR Temp1 = 1 TO MaxConfigArray2
    INPUT #1, Var%
 NEXT
 FOR Temp1 = 1 TO MaxConfigArray3
    LINE INPUT #1, Var$
    Var$ = RTRIM$(Var$)
    SELECT CASE Temp1
    CASE 11
       Var1$ = Var$
       Out2$ = ENVIRON$("DNDDAT")
       IF Out2$ <> Nul THEN
	  IF RIGHT$(Out2$, 1) <> "\" THEN
	     Out2$ = Out2$ + "\"
	  END IF
	  Var1$ = Out2$
       END IF
    CASE 15
       Var2$ = Var$
    CASE 16
       Filename1 = Var1$ + Var$ + Var2$
    CASE 17
       Filename2 = Var1$ + Var$ + Var2$
    CASE 19
       Filename3 = Var1$ + Var$ + Var2$
    CASE 85
       Strng3 = Var$
    CASE 89
       Filename4 = Var1$ + Var$ + Var2$
    CASE 93
       Filename5 = Var1$ + Var$ + Var2$
    END SELECT
 NEXT
 EXIT SUB
Config.Error:
 Color 14, 0
 PRINT "File: "+LCASE$(FileName) + " not found. Run dndcnfg."
 COLOR 7, 0
 END
END SUB

Sub Passwrd(Var)
 On Local Error Goto ErrResume149a
 Dim File.Byte As String*1
 Var=True
 Close #5
 DND.Path$=Environ$("DNDBBS")
 If DND.Path$<>Nul Then
    If Right$(DND.Path$,1)<>"\" Then
       DND.Path$=DND.Path$+"\"
    Endif
 Endif
 FileName$=DND.Path$+"DNDINIT.EXE"
 Open FileName$ For Binary As #5
 File.Length!=LOF(5)
 Get #5,File.Length!,File.Byte
 Byte.Value=Asc(File.Byte)
 Password$ = Nul
 If Byte.Value=255 Then
    For File.Position!=File.Length!-20 To File.Length!-1
       Get #5,File.Position!,File.Byte
       Password$=Password$+File.Byte
    Next
    Call Crypto(Password$)
    Password$=Rtrim$(Password$)
    If Password$=Nul Then
       Exit Sub
    Endif
    Color 15,0
    Print "Enter password: ";
    Locate ,,1
    Var1$=Nul
    Do
       Input.Char$=Nul
       While Input.Char$=Nul
          Input.Char$ = Inkey$
       Wend
       If Input.Char$=Chr$(13) Then
          Exit Do
       Endif
       Var1$=Var1$+Input.Char$
    Loop
    Print
    If Password$<>Var1$ Then
       Var=False
    Endif
 Endif
ErrExit149a:
 Exit Sub
ErrResume149a:
 Resume ErrExit149a
End Sub

Sub Crypto(Var$)
 On Local Error Goto Error.Trap63
 For VarX=1 To Len(Var$)
    VarZ=Asc(Mid$(Var$,VarX,1)) Xor Len(Var$)
    Mid$(Var$,VarX,1)=Chr$(VarZ)
 Next
Error.Resume63:
 Exit Sub
Error.Trap63:
 Resume Error.Resume63
End Sub
