REM Program Dndcnvt2 for Dndbbs Version v5.0a Release r2.0 Tweak t6.0a

REM Converts old Dndbbs data versions.

DEFINT A-Z
REM $DYNAMIC

TYPE BankType
 UserIndex AS SINGLE
 DatePost AS STRING * 10
 TimePost AS STRING * 8
 Balance AS DOUBLE
 Balance2 AS DOUBLE
 Deleted As INTEGER
 PostAmount AS DOUBLE
 PostType AS STRING * 1
 PostSubType AS STRING * 1
 PostSubType2 As Integer
 From As String*30
 To As String*30
END TYPE

TYPE NewMessageBaseType
 BaseDeleted AS INTEGER
 BaseFileName AS STRING * 8
 BaseMessName AS STRING * 78
 BaseType AS INTEGER
END TYPE

TYPE OldMessageBaseType1
 BaseFileName AS STRING * 8
 BaseMessName AS STRING * 78
 BaseType AS INTEGER
 EmptyBuffer AS INTEGER
END TYPE

TYPE OldLastreadType1
 LastMessage AS INTEGER
 EmptyBuffer AS INTEGER
END TYPE

TYPE NewLastreadType
 LastMessage AS SINGLE
END TYPE

TYPE OldMessageType1
 Message AS STRING * 81
END TYPE

TYPE OldTableType1
 MessageTime AS STRING * 21
 MessageFrom AS STRING * 30
 MessageTo AS STRING * 30
 MessageSubject AS STRING * 20
 MessageLength AS INTEGER
 MessageKilled AS STRING * 1
 MessageStart AS INTEGER
END TYPE

TYPE NewMessageType
 Message AS STRING * 80
END TYPE

TYPE NewTableType
 ClassType AS INTEGER
 Clock AS STRING * 21
 Date AS STRING * 10
 Flags AS INTEGER
 from AS STRING * 30
 Killed AS INTEGER
 Length AS INTEGER
 Private AS INTEGER
 Received AS INTEGER
 Reply AS INTEGER
 Start AS SINGLE
 Subject AS STRING * 20
 Thread AS SINGLE
 Time AS STRING * 8
 Timer AS SINGLE
 TimesRead AS DOUBLE
 To AS STRING * 30
END TYPE

TYPE WeaponType
 Index AS SINGLE
 Charges AS INTEGER
 Plus AS INTEGER
END TYPE

TYPE NewUserType
 CodeName AS STRING * 30
 PassWord AS STRING * 20
 PassWord2 As String*20
 Question As String*80
 Answer As String*20
 PassWord3 As String*20
 ClassName AS STRING * 20
 ClassType AS INTEGER
 Stats(1 TO 7) AS INTEGER
 Weapon(1 TO 10) AS WeaponType
 Weapons(1 TO 4) AS INTEGER
 Room AS SINGLE
 Level AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumCalls AS INTEGER
 Fatigue AS INTEGER
 FatigueMax AS INTEGER
 Vitality AS INTEGER
 VitalityMax AS INTEGER
 Magic AS INTEGER
 MagicMax AS INTEGER
 Poison AS INTEGER
 Borrow AS DOUBLE
 Invisible AS INTEGER
 Race AS INTEGER
 Proficiency AS INTEGER
 Bank AS DOUBLE
 PlayersKilled AS DOUBLE
 MonstersKilled AS DOUBLE
 Permanentkilled AS DOUBLE
 Brief AS INTEGER
 DateOn AS STRING * 10
 SysNews As String * 10
 Beauty AS INTEGER
 Glamour AS INTEGER
 Psionic AS INTEGER
 PsionicMax AS INTEGER
 Align1 AS INTEGER
 Align2 AS INTEGER
 Flags AS INTEGER
 Flags2 AS INTEGER
 MaxCalls AS INTEGER
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 SortInv AS INTEGER
 TimeUsed AS SINGLE
 TimeLimit AS SINGLE
 Hidden AS INTEGER
 Encumbrance AS INTEGER
 TimesLogon As Double
 TimesDied As Double
 Prefix1 As String*8
 Prefix2 As String*8
 First AS SINGLE
 Last AS SINGLE
 First2 AS SINGLE
 Last2 AS SINGLE
 NodeList As String*127
 NodeList2 As Single
 EditList As Single
 StatusVar As Integer
 Prefix3 As String*8
 ShortcutKey1(1 To 8) As String*8
 ShortcutKey2(1 To 8) As String*32
 FunctionKeys(1 To 10) As String*20
 StatusLineString As String*80
 ActionLineString As String*80
 ObjectsCreated(1 To 10) As Double
 WishsLeft As Integer
 Block1 As Integer
 Block2 As Integer
 Buffer22 As Single
 Buffer23 As Single
 Buffer24 As Double
 Buffer25 As Double
END TYPE

TYPE NewContainerType
 ContainerName AS STRING * 30
 ContainerShort AS STRING * 30
 NamePrefix AS STRING * 15
 ContainerMax AS INTEGER
 Closed AS INTEGER
 Locked AS INTEGER
 KeyNumber AS Single
 UserNumber AS SINGLE
 RoomNumber AS SINGLE
 DeletedContainer AS INTEGER
 InvisibleContainer AS INTEGER
 Weight AS INTEGER
 WithinContainer AS SINGLE
 Disappears AS SINGLE
 ContainerIndex AS SINGLE
 Size AS INTEGER
 Material As Integer
 Permanent AS INTEGER
 SelfImplodes AS INTEGER
 RestrictItem(1 TO 3) AS SINGLE
 TrapType AS INTEGER
 TrapHits AS INTEGER
 TrapItem AS SINGLE
 Prefix1 As String*8
 Damaged As Integer
 SwapFlag As Integer
 Scanned As Integer
 First2 AS SINGLE ' within list
 Last2 AS SINGLE ' within list
 First AS SINGLE ' link to inventory
 Last AS SINGLE ' link to inventory
 Prev AS SINGLE ' doubly linked list
 Next AS SINGLE ' doubly linked list
END TYPE

TYPE NewActionType
 Attribute1 AS INTEGER
 Attribute2 AS INTEGER
 AttackMonster(1 TO 3) AS SINGLE
 EncounterRate AS INTEGER
 Fumble AS INTEGER
 HealthRate AS INTEGER
 HitPoints AS INTEGER
 Inventory AS INTEGER
 InvPercent AS INTEGER
 InvNumber AS INTEGER
 Level AS INTEGER
 MonsterTalk(1 TO 3) AS SINGLE
 MonsterTrigger(1 TO 3) AS SINGLE
 Restrictions AS INTEGER
 RustRate AS INTEGER
 SpellTrigger AS SINGLE
 StealRate AS INTEGER
 Teleport(1 TO 5) AS SINGLE
 TelePercent AS INTEGER
 Hidden AS INTEGER
 ItemForSale As Single
 WishPercent As Integer
 PoisonPercent As Integer
END TYPE

TYPE BufferType
 Buffer AS STRING * 80
END TYPE

TYPE MessType
 Index AS SINGLE
 User AS SINGLE
 Charges AS INTEGER
 Plus AS INTEGER
 Room AS SINGLE
 Prev AS SINGLE
 Next AS SINGLE
 Temp(1 To 4) AS SINGLE
 Desc(1 To 4) AS SINGLE
 Time1 As Single
 Time2 As Single
END TYPE

TYPE NewRoomType
 Action AS SINGLE
 Custom1 As String*12
 Custom2 As String*12
 Direct(1 TO 14) AS SINGLE
 LongDesc(1 TO 19) AS SINGLE
 MonClass AS SINGLE
 ShortDesc AS STRING * 80
 First AS SINGLE
 Last AS SINGLE
 First2 AS SINGLE
 Last2 AS SINGLE
END TYPE

TYPE NewObjectType
 ObjectName AS STRING * 30
 ShortName AS STRING * 30
 RoomLink1 AS SINGLE
 RoomLink2 AS SINGLE
 Invisible AS INTEGER
 JailTrap AS INTEGER
 DoorLock AS INTEGER
 Destination AS INTEGER
 Permanent AS INTEGER
 Hidden AS INTEGER
 Closed AS INTEGER
 KeyNumber AS Single
 Relocks AS INTEGER
 LongDesc AS STRING * 80
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 LightRoom AS INTEGER
 LightTime AS INTEGER
 ShortDesc AS STRING * 80
 Trap AS INTEGER
 Teleport AS SINGLE
 SwitchType AS INTEGER
 SwitchRoom AS SINGLE
 SwitchLight AS INTEGER
 SwitchLockRoom AS INTEGER
 Prefix1 AS STRING*8
 PortalPassword As String*8
 ObjDesc(1 To 19) As Single
 Buffer5 AS INTEGER
 Buffer6 AS INTEGER
 InitRoom AS SINGLE
 InitRoom2 AS SINGLE
END TYPE

TYPE NewTreasureType
 TreasureName AS STRING * 30
 ShortName AS STRING * 30
 Weight AS INTEGER
 Gold AS Double
 Spell AS SINGLE
 Plus AS INTEGER
 Coin AS INTEGER
 Locked AS INTEGER
 KeyNumber AS Single
 Scroll AS INTEGER
 Charges AS INTEGER
 Potion AS INTEGER
 Loadable AS INTEGER
 Ammunition AS INTEGER
 AmmoLoads AS SINGLE
 Invisible AS INTEGER
 Permanent AS INTEGER
 Proficiency AS INTEGER
 WeaponNumber AS INTEGER
 RingType AS INTEGER
 RingSpell AS SINGLE
 Edible AS INTEGER
 Rustable AS INTEGER
 RustPercent AS INTEGER
 Stealable AS INTEGER
 StealPercent AS INTEGER
 Launchable AS INTEGER
 LaunchLoads AS SINGLE
 LaunchAmmo AS INTEGER
 Movable AS INTEGER
 Vehicle AS INTEGER
 VehicleType AS INTEGER
 LightType AS INTEGER
 LightCharges AS INTEGER
 FuelType AS INTEGER
 FuelCharges AS INTEGER
 Container AS INTEGER
 ContainerMax AS INTEGER
 ContainerPrefix AS STRING * 15
 ContainerDisappears AS SINGLE
 ContainerSize AS INTEGER
 ContainerMaterial As Integer
 ContainerSelfImplodes As Integer
 PotionType AS SINGLE
 NewPotion AS SINGLE
 MixPotion AS INTEGER
 TwoHanded AS INTEGER
 RequireStr AS INTEGER
 RequireDex AS INTEGER
 RequireInt AS INTEGER
 RestrictItem(1 TO 3) AS SINGLE
 TrapType AS INTEGER
 TrapHits AS INTEGER
 TrapItem AS SINGLE
 MasterKey AS INTEGER
 Liquid As Integer
 LiquidType As Integer
 LiquidFlags As Integer
 Prefix1 As String*8
 StaysInRoom As Integer
 Occupants As Integer
 BindType As Integer
 TimesCursed As Integer
 TimesBlessed As Integer
 Persistent AS INTEGER
 MaxPersistCharges AS INTEGER
 PersistTime AS SINGLE
 DischargePersist AS SINGLE
 ProperName As String*20
END TYPE

TYPE NewSpellType
 SpellName AS STRING * 30
 Chant AS STRING * 80
 Level AS INTEGER
 SpellType AS INTEGER
 Teleport AS SINGLE
 Psionic AS INTEGER
 PsionicMode AS INTEGER
 ClassType AS INTEGER
 Desc AS STRING * 80
 Ingred(1 TO 5) AS SINGLE
 SpellFlag AS INTEGER
 SpellEquate AS STRING * 40
 Equation AS INTEGER
 Prefix1 As String*8
 Buffer9 AS INTEGER
 Buffer10 AS INTEGER
 Buffer11 AS SINGLE
 Buffer12 AS SINGLE
END TYPE

TYPE NewMonsterType
 MonsterName AS STRING * 30
 PluralName AS STRING * 30
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumberAppearing AS INTEGER
 Level AS INTEGER
 Hits AS INTEGER
 Poison AS INTEGER
 LevelDrain AS INTEGER
 Spell AS SINGLE
 Block AS INTEGER
 Prevent AS INTEGER
 Follow AS INTEGER
 Magic AS INTEGER
 Jail AS INTEGER
 TeleportPercent AS INTEGER
 FollowPercent AS INTEGER
 BlockPercent AS INTEGER
 PreventPercent AS INTEGER
 SpellPercent AS INTEGER
 PoisonPercent AS INTEGER
 DrainPercent AS INTEGER
 Rate AS INTEGER
 RatePercent AS INTEGER
 Permanent AS INTEGER
 Talk(1 TO 5) AS INTEGER
 Psionic AS INTEGER
 PsionicSpell AS SINGLE
 Equation AS INTEGER
 MonsterEquate AS STRING * 40
 MonsterSurprise As String*40
 MonsterSavingThrow As String*40
 Prefix1 As String*8
 First AS SINGLE
 Last AS SINGLE
 Weapon As Single
 Shield As Single
 Armor As Single
 PerMonster As Integer
 TalkGold As Double
 TalkGoldTimes As Integer
 TalkGoldPercent As Integer
 TalkItem As Single
 TalkItemTimes As Integer
 TalkItemPercent As Integer
 TalkMoveDirection As Integer
 Invisible AS INTEGER
 RemainsInRoom AS INTEGER
 Buffer15 AS SINGLE
 Buffer16 AS SINGLE
END TYPE

TYPE NewMonClassType
 Monsters(1 TO 10) AS SINGLE
END TYPE

TYPE OldRoomType1 ' dnd27a
 LongDesc(1 TO 4) AS STRING * 79
 ShortDesc AS STRING * 78
 Level AS INTEGER
 Direct(1 TO 11) AS INTEGER
 Restrictions AS INTEGER
 MonsterClass AS INTEGER
 SpellTrigger AS INTEGER
 MonsterTrigger AS INTEGER
 HealthRate AS INTEGER
 EncounterRate AS INTEGER
 HitPoints AS INTEGER
 Inventory AS INTEGER
 MonsterTalk AS INTEGER
 Fumble AS INTEGER
 Teleport AS INTEGER
 Object(1 TO 20) AS INTEGER
 ObjCharges(1 TO 20) AS INTEGER
 RustRate AS INTEGER
 StealRate AS INTEGER
 Flags AS STRING * 20
END TYPE

TYPE OldRoomType2 ' dnd29c1
 LongDesc(1 TO 4) AS STRING * 79
 ShortDesc AS STRING * 78
 Level AS INTEGER
 Direct(1 TO 11) AS INTEGER
 Restrictions AS INTEGER
 MonsterClass AS INTEGER
 SpellTrigger AS INTEGER
 MonsterTrigger AS INTEGER
 HealthRate AS INTEGER
 EncounterRate AS INTEGER
 HitPoints AS INTEGER
 Inventory AS INTEGER
 MonsterTalk AS INTEGER
 Fumble AS INTEGER
 Teleport AS INTEGER
 Object(1 TO 10) AS INTEGER
 Treasure(1 TO 10) AS INTEGER
 ObjCharges(1 TO 10) AS INTEGER
 TreCharges(1 TO 10) AS INTEGER
 RustRate AS INTEGER
 StealRate AS INTEGER
 Flags(1 TO 10) AS INTEGER
END TYPE

TYPE OldUserType1 ' dnd27a
 Inv(1 TO 20) AS INTEGER
 Charges(1 TO 20) AS INTEGER
 CodeName AS STRING * 30
 PassWord AS STRING * 20
 ClassName AS STRING * 20
 ClassType AS INTEGER
 Stats(1 TO 7) AS INTEGER
 Weapons(1 TO 4) AS INTEGER
 Room AS INTEGER
 Level AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumCalls AS INTEGER
 Fatigue AS INTEGER
 FatigueMax AS INTEGER
 Vitality AS INTEGER
 VitalityMax AS INTEGER
 Magic AS INTEGER
 MagicMax AS INTEGER
 Poison AS INTEGER
 Borrow AS INTEGER
 Invisible AS INTEGER
 Race AS INTEGER
 Proficiency AS INTEGER
 Bank AS DOUBLE
 PlayersKilled AS INTEGER
 MonstersKilled AS SINGLE
 Brief AS INTEGER
 DateOn AS STRING * 10
 EmptyBuffer AS INTEGER
 Psionic AS INTEGER
 PsionicMax AS INTEGER
 Align1 AS INTEGER
 Align2 AS INTEGER
 Flags AS INTEGER
END TYPE

TYPE OldUserType2 ' dnd29a1
 Inv(1 TO 15) AS INTEGER
 Object(1 TO 5) AS INTEGER
 Charges(1 TO 15) AS INTEGER
 ObjCharges(1 TO 5) AS INTEGER
 CodeName AS STRING * 30
 PassWord AS STRING * 20
 ClassName AS STRING * 20
 ClassType AS INTEGER
 Stats(1 TO 7) AS INTEGER
 Weapons(1 TO 4) AS INTEGER
 Room AS INTEGER
 Level AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumCalls AS INTEGER
 Fatigue AS INTEGER
 FatigueMax AS INTEGER
 Vitality AS INTEGER
 VitalityMax AS INTEGER
 Magic AS INTEGER
 MagicMax AS INTEGER
 Poison AS INTEGER
 Borrow AS INTEGER
 Invisible AS INTEGER
 Race AS INTEGER
 Proficiency AS INTEGER
 Bank AS DOUBLE
 PlayersKilled AS INTEGER
 MonstersKilled AS SINGLE
 Brief AS INTEGER
 DateOn AS STRING * 10
 EmptyBuffer AS INTEGER
 Psionic AS INTEGER
 PsionicMax AS INTEGER
 Align1 AS INTEGER
 Align2 AS INTEGER
 Flags AS INTEGER
 MaxCalls AS INTEGER
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
END TYPE

TYPE OldSpellType
 SpellName AS STRING * 30
 Chant AS STRING * 80
 Level AS INTEGER
 SpellType AS INTEGER
 Teleport AS INTEGER
 Psionic AS INTEGER
 PsionicMode AS INTEGER
 ClassType AS INTEGER
 Desc AS STRING * 80
 Ingred(1 TO 5) AS INTEGER
 SpellFlag AS INTEGER
 SpellEquate AS STRING * 40
 Equation AS INTEGER
END TYPE

TYPE OldMonClassType
 Monsters(1 TO 10) AS INTEGER
END TYPE

TYPE OldReceptacleType ' dnd27a
 Charges AS INTEGER
 Inv AS INTEGER
 Invis AS INTEGER
 TName AS STRING * 30
END TYPE

TYPE OldContainerType ' dnd29c1
 Inv AS INTEGER
 Charges AS INTEGER
 Invis AS INTEGER
 TName AS STRING * 30
END TYPE

TYPE OldObjectType
 ObjectName AS STRING * 30
 ShortName AS STRING * 30
 RoomLink AS INTEGER
 Invisible AS INTEGER
 JailTrap AS INTEGER
 DoorLock AS INTEGER
 EmptyField AS INTEGER
 Permanent AS INTEGER
 Hidden AS INTEGER
 Closed AS INTEGER
 Keyed AS INTEGER
 Relocks AS INTEGER
 Vehicle AS INTEGER
 VehicleHits AS INTEGER
 LongDesc AS STRING * 128
 ShortDesc AS STRING * 40
 Trap AS INTEGER
 Teleport AS INTEGER
END TYPE

TYPE OldMonsterType
 MonsterName AS STRING * 30
 PluralName AS STRING * 30
 Treasure(1 TO 5) AS INTEGER
 Experience AS INTEGER
 NumberAppearing AS INTEGER
 Level AS INTEGER
 Hits AS INTEGER
 Poison AS INTEGER
 LevelDrain AS INTEGER
 Spell AS INTEGER
 Block AS INTEGER
 Prevent AS INTEGER
 Follow AS INTEGER
 Magic AS INTEGER
 Jail AS INTEGER
 Teleport AS INTEGER
 FollowPercent AS INTEGER
 BlockPercent AS INTEGER
 PreventPercent AS INTEGER
 SpellPercent AS INTEGER
 PoisonPercent AS INTEGER
 DrainPercent AS INTEGER
 Rate AS INTEGER
 RatePercent AS INTEGER
 Permanent AS INTEGER
 Talk(1 TO 5) AS INTEGER
 Psionic AS INTEGER
 PsionicSpell AS INTEGER
END TYPE

TYPE OldMonsterType2
 MonsterName AS STRING * 30
 PluralName AS STRING * 30
 Treasure(1 TO 5) AS INTEGER
 Experience AS INTEGER
 NumberAppearing AS INTEGER
 Level AS INTEGER
 Hits AS INTEGER
 Poison AS INTEGER
 LevelDrain AS INTEGER
 Spell AS INTEGER
 Block AS INTEGER
 Prevent AS INTEGER
 Follow AS INTEGER
 Magic AS INTEGER
 Jail AS INTEGER
 Teleport AS INTEGER
 FollowPercent AS INTEGER
 BlockPercent AS INTEGER
 PreventPercent AS INTEGER
 SpellPercent AS INTEGER
 PoisonPercent AS INTEGER
 DrainPercent AS INTEGER
 Rate AS INTEGER
 RatePercent AS INTEGER
 Permanent AS INTEGER
 Talk(1 TO 5) AS INTEGER
 Psionic AS INTEGER
 PsionicSpell AS INTEGER
 Equation AS INTEGER
 MonsterEquate AS STRING * 40
END TYPE

TYPE OldMonsterTalkType
 TalkMessage AS STRING * 80
END TYPE

TYPE OldTreasureType
 TreasureName AS STRING * 30
 ShortName AS STRING * 30
 Weight AS INTEGER
 Gold AS INTEGER
 Spell AS INTEGER
 Plus AS INTEGER
 Coin AS INTEGER
 Keyed AS INTEGER
 Scroll AS INTEGER
 Charges AS INTEGER
 Container AS INTEGER
 ContainerFileName AS STRING * 8
 ContainerMax AS INTEGER
 Type AS INTEGER
 Potion AS INTEGER
 Locked AS INTEGER
 Closed AS INTEGER
 Loadable AS INTEGER
 Ammunition AS INTEGER
 AmmoLoads AS INTEGER
 Invisible AS INTEGER
 Proficiency AS INTEGER
 RingType AS INTEGER
 RingSpell AS INTEGER
 Edible AS INTEGER
 Rustable AS INTEGER
 RustPercent AS INTEGER
 Stealable AS INTEGER
 StealPercent AS INTEGER
 Launchable AS INTEGER
 LaunchLoads AS INTEGER
 LaunchAmmo AS INTEGER
 Movable AS INTEGER
END TYPE

TYPE OldRoomType3 ' dnd29c4
 LongDesc(1 TO 4) AS STRING * 78
 Attribute1 AS INTEGER
 Attribute2 AS INTEGER
 ShortDesc AS STRING * 78
 Level AS INTEGER
 Direct(1 TO 11) AS INTEGER
 Restrictions AS INTEGER
 MonsterClass AS INTEGER
 SpellTrigger AS INTEGER
 MonsterTrigger AS INTEGER
 HealthRate AS INTEGER
 EncounterRate AS INTEGER
 HitPoints AS INTEGER
 Inventory AS INTEGER
 MonsterTalk AS INTEGER
 Fumble AS INTEGER
 Teleport AS INTEGER
 Object(1 TO 10) AS INTEGER
 Treasure(1 TO 10) AS INTEGER
 ObjCharges(1 TO 10) AS INTEGER
 TreCharges(1 TO 10) AS INTEGER
 RustRate AS INTEGER
 StealRate AS INTEGER
 Flags(1 TO 10) AS INTEGER
END TYPE

TYPE OldUserType3 ' dnd29c4
 Inv(1 TO 15) AS INTEGER
 Object(1 TO 5) AS INTEGER
 Charges(1 TO 15) AS INTEGER
 ObjCharges(1 TO 5) AS INTEGER
 CodeName AS STRING * 30
 PassWord AS STRING * 20
 ClassName AS STRING * 20
 ClassType AS INTEGER
 Stats(1 TO 7) AS INTEGER
 Weapons(1 TO 4) AS INTEGER
 Room AS INTEGER
 Level AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumCalls AS INTEGER
 Fatigue AS INTEGER
 FatigueMax AS INTEGER
 Vitality AS INTEGER
 VitalityMax AS INTEGER
 Magic AS INTEGER
 MagicMax AS INTEGER
 Poison AS INTEGER
 Borrow AS INTEGER
 Invisible AS INTEGER
 Race AS INTEGER
 Proficiency AS INTEGER
 Bank AS DOUBLE
 PlayersKilled AS INTEGER
 MonstersKilled AS SINGLE
 Brief AS INTEGER
 DateOn AS STRING * 10
 Beauty AS INTEGER
 Glamour AS INTEGER
 Psionic AS INTEGER
 PsionicMax AS INTEGER
 Align1 AS INTEGER
 Align2 AS INTEGER
 Flags AS INTEGER
 MaxCalls AS INTEGER
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 Arm1 AS INTEGER
 Arm2 AS INTEGER
 Leg1 AS INTEGER
 Leg2 AS INTEGER
 Torso AS INTEGER
 Head AS INTEGER
END TYPE

TYPE OldSpellType3
 SpellName AS STRING * 30
 Chant AS STRING * 80
 Level AS INTEGER
 SpellType AS INTEGER
 Teleport AS INTEGER
 Psionic AS INTEGER
 PsionicMode AS INTEGER
 ClassType AS INTEGER
 Desc AS STRING * 80
 Ingred(1 TO 5) AS INTEGER
 SpellFlag AS INTEGER
 SpellEquate AS STRING * 40
 Equation AS INTEGER
END TYPE

TYPE OldObjectType3
 ObjectName AS STRING * 30
 ShortName AS STRING * 30
 RoomLink AS INTEGER
 Invisible AS INTEGER
 JailTrap AS INTEGER
 DoorLock AS INTEGER
 Destination AS INTEGER
 Permanent AS INTEGER
 Hidden AS INTEGER
 Closed AS INTEGER
 Keyed AS INTEGER
 Relocks AS INTEGER
 LongDesc AS STRING * 80
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 LightRoom AS INTEGER
 LightTime AS INTEGER
 ShortDesc AS STRING * 40
 Trap AS INTEGER
 Teleport AS INTEGER
END TYPE

TYPE OldMonsterType3
 MonsterName AS STRING * 30
 PluralName AS STRING * 30
 Treasure(1 TO 5) AS INTEGER
 Experience AS INTEGER
 NumberAppearing AS INTEGER
 Level AS INTEGER
 Hits AS INTEGER
 Poison AS INTEGER
 LevelDrain AS INTEGER
 Spell AS INTEGER
 Block AS INTEGER
 Prevent AS INTEGER
 Follow AS INTEGER
 Magic AS INTEGER
 Jail AS INTEGER
 Teleport AS INTEGER
 FollowPercent AS INTEGER
 BlockPercent AS INTEGER
 PreventPercent AS INTEGER
 SpellPercent AS INTEGER
 PoisonPercent AS INTEGER
 DrainPercent AS INTEGER
 Rate AS INTEGER
 RatePercent AS INTEGER
 Permanent AS INTEGER
 Talk(1 TO 5) AS INTEGER
 Psionic AS INTEGER
 PsionicSpell AS INTEGER
 Equation AS INTEGER
 MonsterEquate AS STRING * 40
END TYPE

TYPE OldTreasureType3
 TreasureName AS STRING * 30
 ShortName AS STRING * 30
 Weight AS INTEGER
 Gold AS INTEGER
 Spell AS INTEGER
 Plus AS INTEGER
 Coin AS INTEGER
 Keyed AS INTEGER
 Scroll AS INTEGER
 Charges AS INTEGER
 Container AS INTEGER
 ContainerFileName AS STRING * 8
 ContainerMax AS INTEGER
 Type AS INTEGER
 Potion AS INTEGER
 Locked AS INTEGER
 Closed AS INTEGER
 Loadable AS INTEGER
 Ammunition AS INTEGER
 AmmoLoads AS INTEGER
 Invisible AS INTEGER
 Proficiency AS INTEGER
 RingType AS INTEGER
 RingSpell AS INTEGER
 Edible AS INTEGER
 Rustable AS INTEGER
 RustPercent AS INTEGER
 Stealable AS INTEGER
 StealPercent AS INTEGER
 Launchable AS INTEGER
 LaunchLoads AS INTEGER
 LaunchAmmo AS INTEGER
 Movable AS INTEGER
 Vehicle AS INTEGER
 VehicleHits AS INTEGER
 VehicleType AS INTEGER
 LightType AS INTEGER
 LightCharges AS INTEGER
 FuelType AS INTEGER
 FuelCharges AS INTEGER
END TYPE

Common Shared BankRecord As BankType
Common Shared BankRecLen As Integer

COMMON SHARED OldReceptacleRecord AS OldReceptacleType
COMMON SHARED OldReceptacleRecLen AS INTEGER

COMMON SHARED OldContainerRecord AS OldContainerType
COMMON SHARED OldContainerRecLen AS INTEGER

COMMON SHARED NewContainerRecord AS NewContainerType
COMMON SHARED NewContainerRecLen AS INTEGER

COMMON SHARED OldUserRecord1 AS OldUserType1
COMMON SHARED OldUserRecord2 AS OldUserType2
COMMON SHARED OldUserRecord3 AS OldUserType3
COMMON SHARED NewUserRecord AS NewUserType

COMMON SHARED OldUserRecLen1 AS INTEGER
COMMON SHARED OldUserRecLen2 AS INTEGER
COMMON SHARED OldUserRecLen3 AS INTEGER
COMMON SHARED NewUserRecLen AS INTEGER

COMMON SHARED BufferRecord AS BufferType
COMMON SHARED BufferRecLen AS INTEGER

COMMON SHARED MessWorkRecord AS MessType
COMMON SHARED MessWorkRecLen AS INTEGER

COMMON SHARED OldRoomRecord1 AS OldRoomType1
COMMON SHARED OldRoomRecord2 AS OldRoomType2
COMMON SHARED OldRoomRecord3 AS OldRoomType3
COMMON SHARED NewRoomRecord AS NewRoomType

COMMON SHARED OldRoomRecLen1 AS INTEGER
COMMON SHARED OldRoomRecLen2 AS INTEGER
COMMON SHARED OldRoomRecLen3 AS INTEGER
COMMON SHARED NewRoomRecLen AS INTEGER

COMMON SHARED OldObjectRecord AS OldObjectType
COMMON SHARED OldObjectRecord3 AS OldObjectType3
COMMON SHARED NewObjectRecord AS NewObjectType

COMMON SHARED OldObjectRecLen AS INTEGER
COMMON SHARED OldObjectRecLen3 AS INTEGER
COMMON SHARED NewObjectRecLen AS INTEGER

COMMON SHARED OldTreasureRecord AS OldTreasureType
COMMON SHARED OldTreasureRecord3 AS OldTreasureType3
COMMON SHARED NewTreasureRecord AS NewTreasureType

COMMON SHARED OldTreasureRecLen AS INTEGER
COMMON SHARED OldTreasureRecLen3 AS INTEGER
COMMON SHARED NewTreasureRecLen AS INTEGER

COMMON SHARED OldSpellRecord AS OldSpellType
COMMON SHARED OldSpellRecord3 AS OldSpellType3
COMMON SHARED NewSpellRecord AS NewSpellType

COMMON SHARED OldSpellRecLen AS INTEGER
COMMON SHARED OldSpellRecLen3 AS INTEGER
COMMON SHARED NewSpellRecLen AS INTEGER

COMMON SHARED OldMonsterRecord AS OldMonsterType
COMMON SHARED OldMonsterRecord2 AS OldMonsterType2
COMMON SHARED OldMonsterRecord3 AS OldMonsterType3
COMMON SHARED NewMonsterRecord AS NewMonsterType

COMMON SHARED OldMonsterRecLen AS INTEGER
COMMON SHARED OldMonsterRecLen2 AS INTEGER
COMMON SHARED OldMonsterRecLen3 AS INTEGER
COMMON SHARED NewMonsterRecLen AS INTEGER

COMMON SHARED OldMonClassRecord AS OldMonClassType
COMMON SHARED NewMonClassRecord AS NewMonClassType

COMMON SHARED OldMonClassRecLen AS INTEGER
COMMON SHARED NewMonClassRecLen AS INTEGER

COMMON SHARED OldMessageRecord1 AS OldMessageType1
COMMON SHARED NewMessageRecord AS NewMessageType

COMMON SHARED OldMessageRecLen1 AS INTEGER
COMMON SHARED NewMessageRecLen AS INTEGER

COMMON SHARED OldTableRecord1 AS OldTableType1
COMMON SHARED NewTableRecord AS NewTableType

COMMON SHARED OldTableRecLen1 AS INTEGER
COMMON SHARED NewTableRecLen AS INTEGER

COMMON SHARED OldLastreadRecord1 AS OldLastreadType1
COMMON SHARED NewLastreadRecord AS NewLastreadType

COMMON SHARED OldMessageBaseRecord1 AS OldMessageBaseType1
COMMON SHARED NewMessageBaseRecord AS NewMessageBaseType

COMMON SHARED Filename1 AS STRING
COMMON SHARED Filename2 AS STRING
COMMON SHARED Filename3 AS STRING
COMMON SHARED Filename4 AS STRING
COMMON SHARED Filename5 AS STRING
COMMON SHARED Filename6 AS STRING
COMMON SHARED Filename7 AS STRING
COMMON SHARED FileName8 AS STRING
COMMON SHARED FileName9 AS STRING

Common Shared TotalBank As Double

Common Shared Strng3 As String

CONST PrimeKey = 29

Rem $Include: 'const.inc'

Function DateS$
 DateS$=Format$(Now,"mm-dd-yyyy")
End Function

BankRecLen = Len(BankRecord)

BufferRecLen = LEN(BufferRecord)

OldReceptacleRecLen = LEN(OldReceptacleRecord)
OldContainerRecLen = LEN(OldContainerRecord)
NewContainerRecLen = LEN(NewContainerRecord)

MessWorkRecLen = LEN(MessWorkRecord)

OldUserRecLen1 = LEN(OldUserRecord1)
OldUserRecLen2 = LEN(OldUserRecord2)
OldUserRecLen3 = LEN(OldUserRecord3)
NewUserRecLen = LEN(NewUserRecord)

OldRoomRecLen1 = LEN(OldRoomRecord1)
OldRoomRecLen2 = LEN(OldRoomRecord2)
OldRoomRecLen3 = LEN(OldRoomRecord3)
NewRoomRecLen = LEN(NewRoomRecord)

OldObjectRecLen = LEN(OldObjectRecord)
OldObjectRecLen3 = LEN(OldObjectRecord3)
NewObjectRecLen = LEN(NewObjectRecord)

OldTreasureRecLen = LEN(OldTreasureRecord)
OldTreasureRecLen3 = LEN(OldTreasureRecord3)
NewTreasureRecLen = LEN(NewTreasureRecord)

OldSpellRecLen = LEN(OldSpellRecord)
OldSpellRecLen3 = LEN(OldSpellRecord3)
NewSpellRecLen = LEN(NewSpellRecord)

OldMonsterRecLen = LEN(OldMonsterRecord)
OldMonsterRecLen2 = LEN(OldMonsterRecord2)
OldMonsterRecLen3 = LEN(OldMonsterRecord3)
NewMonsterRecLen = LEN(NewMonsterRecord)

OldMonClassRecLen = LEN(OldMonClassRecord)
NewMonClassRecLen = LEN(NewMonClassRecord)

OldMessageRecLen1 = LEN(OldMessageRecord1)
NewMessageRecLen = LEN(NewMessageRecord)

OldTableRecLen1 = LEN(OldTableRecord1)
NewTableRecLen = LEN(NewTableRecord)

OldLastreadRecLen1 = LEN(OldLastreadRecord1)
NewLastreadRecLen = LEN(NewLastreadRecord)

OldMessageBaseRecLen1 = LEN(OldMessageBaseRecord1)
NewMessageBaseRecLen = LEN(NewMessageBaseRecord)

OldActionRecLen=LEN(OldActionRecord)
NewActionRecLen=LEN(NewActionRecord)

ON ERROR GOTO Error.Routine
CALL Passwrd2(Var)
IF Var = False THEN
   PRINT "Illegal password!"
   COLOR 7, 0
   END
END IF
Command.Line$ = COMMAND$
If Command.Line$ <> "" Then
   I = Instr(Command.Line$, "/D:")
   If I Then
      Temp$ = Left$(Command.Line$, I - 1)
      Command.Line$ = Mid$(Command.Line$, I + 3)
      Gosub Get.Numeric
      Command.Line$ = Temp$ + Command.Line$
      Temp = Int(Val(TempA$)+.5)
      If Temp >= 1 And Temp <= 16 Then
         Node2$ = Mid$(Str$(Temp), 2)
      Endif
   Endif
   I = INSTR(Command.Line$, "/S:")
   If I Then
      Node1$ = Mid$(Command.Line$, I + 3, 1)
   Endif
END IF
COLOR 15, 0
PRINT "Dndcnvt utility for Dndbbs;"
COLOR 14, 0
PRINT "This utility converts old Dndbbs files";
IF Node1$ <> Nul THEN
   PRINT "(node "; Node1$; ")";
END IF
PRINT " to Version v5.0a";
IF Node2$ <> Nul THEN
   PRINT "(node "; Node2$; ")";
END IF
Print

PRINT "Select (1)v2.7a, (2)v2.9c-1, (3)v2.9c-4, (4)v2.9d-1, (5)Quit: ";
LOCATE , , 1
DO
   Var$ = INKEY$
   IF LEN(Var$) THEN
      Var$ = LCASE$(Var$)
      SELECT CASE Var$
      CASE "1", "2", "3", "4"
         OldVersion = INT(VAL(Var$)+.5)
         PRINT Var$
         EXIT DO
      CASE "5"
         PRINT "5"
         COLOR 7, 0
         PRINT "Exiting to system:"
         END
      END SELECT
   END IF
LOOP

' get pathnames
PRINT "Enter path for old Dndbbs version";
INPUT Var1$
PRINT "Enter path to Dndbbs Version v5.0a";
INPUT Var2$
Var3$ = CURDIR$

' check pathnames
IF RIGHT$(Var1$, 1) = "\" THEN
   Var1$ = LEFT$(Var1$, LEN(Var1$) - 1)
END IF
IF RIGHT$(Var2$, 1) = "\" THEN
   Var2$ = LEFT$(Var2$, LEN(Var2$) - 1)
END IF

' verify pathnames
CHDIR Var1$
CHDIR Var2$
CHDIR Var3$

PRINT "Dndcnvt will now create new data files. Continue(y/n)? ";
LOCATE , , 1
DO
   Var$ = INKEY$
   IF LEN(Var$) THEN
      Var$ = LCASE$(Var$)
      SELECT CASE Var$
      CASE "y"
         PRINT "y"
         EXIT DO
      CASE "n"
         PRINT "n"
         COLOR 7, 0
         PRINT "Exiting to system:"
         END
      END SELECT
   END IF
LOOP

GOSUB Read.Config
GOSUB Read.Config2
Var2$ = DataPath1$

SELECT CASE OldVersion
CASE 1, 2
   GOSUB Convert1
CASE 3, 4
   GOSUB Convert3
END SELECT

' convert mail
GOSUB Convert8

' delete remaining data files
Var2$ = DataPath1$
Filename2=Var2$ + "\" + TeamFileName2$
IF DIR$(Filename2)<>Nul THEN
   KILL Filename2
END IF
Filename2=Var2$ + "\" + TeamInvFileName2$
IF DIR$(Filename2)<>Nul THEN
   KILL Filename2
END IF
Filename2=Var2$ + "\" + BankFilename2$
IF DIR$(Filename2)<>Nul THEN
   KILL Filename2
END IF

' write bank balance
Close #1
Open FileName2 For Random Shared As #1 Len=BankRecLen
BankRecord.UserIndex = True
BankRecord.DatePost = DateS$
BankRecord.TimePost = Format$(Now,"hh:mm:ss")
BankRecord.Balance = TotalBank
BankRecord.PostAmount = DFalse
BankRecord.PostType = "A"
BankRecord.PostSubType = "A"
BankRecord.PostSubType2 = False
BankRecord.From = Nul
BankRecord.To = Nul
Put 1, 1, BankRecord
Close #1

' calculate monster armament
Var2$ = DataPath1$
Filename1 = Var2$ + "\" + TreasureFilename2$
Filename2 = Var2$ + "\" + MonstersFilename2$
Call MonsterArms

' end conversion process
Color 15, 0
Print "Conversion successful."
COLOR 7, 0
PRINT "Exiting to system:"
END

Convert1:
' convert objects
CLOSE
Filename1 = Var1$ + "\" + ObjectFilename$
Filename2 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldObjectRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewObjectRecLen
IF LOF(1) / OldObjectRecLen > False THEN
Temp! = LOF(1) / OldObjectRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad object file record length."
   Temp! = SFalse
   GOTO EndLoop2
END IF
FOR Temp! = 1! TO LOF(1) / OldObjectRecLen
   GET 1, Temp!, OldObjectRecord
   NewObjectRecord.ObjectName = OldObjectRecord.ObjectName
   NewObjectRecord.ShortName = OldObjectRecord.ShortName
   NewObjectRecord.RoomLink1 = OldObjectRecord.RoomLink
   NewObjectRecord.RoomLink2 = SFalse
   NewObjectRecord.Invisible = OldObjectRecord.Invisible
   NewObjectRecord.JailTrap = OldObjectRecord.JailTrap
   NewObjectRecord.DoorLock = OldObjectRecord.DoorLock
   'NewObjectRecord.Destination = OldObjectRecord.Destination
   NewObjectRecord.Permanent = OldObjectRecord.Permanent
   NewObjectRecord.Hidden = OldObjectRecord.Hidden
   NewObjectRecord.Closed = OldObjectRecord.Closed
   NewObjectRecord.KeyNumber = Csng(OldObjectRecord.Keyed)
   NewObjectRecord.Relocks = OldObjectRecord.Relocks
   NewObjectRecord.LongDesc = OldObjectRecord.LongDesc
   'NewObjectRecord.FromHour = OldObjectRecord.FromHour
   'NewObjectRecord.FromMin = OldObjectRecord.FromMin
   'NewObjectRecord.ToHour = OldObjectRecord.ToHour
   'NewObjectRecord.ToMin = OldObjectRecord.ToMin
   'NewObjectRecord.LightRoom = OldObjectRecord.LightRoom
   'NewObjectRecord.LightTime = OldObjectRecord.LightTime
   Var$ = Rtrim$(OldObjectRecord.ShortDesc)
   If Var$ = String$(40, 0) Then
      Var$ = Nul
   Endif
   NewObjectRecord.ShortDesc = Var$
   NewObjectRecord.Trap = OldObjectRecord.Trap
   NewObjectRecord.Teleport = OldObjectRecord.Teleport
   NewObjectRecord.SwitchType = False
   NewObjectRecord.SwitchRoom = SFalse
   NewObjectRecord.SwitchLight = False
   NewObjectRecord.SwitchLockRoom = False
   NewObjectRecord.Prefix1 = Nul
   NewObjectRecord.PortalPassword = Nul
   For VarQ=1 To 19
      NewObjectRecord.ObjDesc(VarQ)=0!
   Next
   If NewObjectRecord.DoorLock Then
      NewObjectRecord.Prefix1 = Strng3 + "FE"
      If NewObjectRecord.KeyNumber Then
         NewObjectRecord.Prefix1 = Strng3 + "FD"
      Endif
   Else
      If NewObjectRecord.RoomLink1 Then
         NewObjectRecord.Prefix1 = Strng3 + "FE"
         If NewObjectRecord.KeyNumber Then
            NewObjectRecord.Prefix1 = Strng3 + "FD"
         Endif
      Else
         If NewObjectRecord.LightRoom Then
            NewObjectRecord.Prefix1 = Strng3 + "FC"
         Else
            If NewObjectRecord.SwitchType Then
               NewObjectRecord.Prefix1 = Strng3 + "FB"
            Else
               If NewObjectRecord.JailTrap Then
                  NewObjectRecord.Prefix1 = Strng3 + "FA"
               Else
                  NewObjectRecord.Prefix1 = Strng3 + "F9"
               Endif
            Endif
         Endif
      Endif
   Endif
   PUT 2, Temp!, NewObjectRecord
NEXT
PRINT "Objects:"; Temp! - 1!
END IF
EndLoop2:
' convert treasure
CLOSE
Filename1 = Var1$ + "\" + TreasureFilename$
Filename2 = Var2$ + "\" + TreasureFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldTreasureRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewTreasureRecLen
IF LOF(1) / OldTreasureRecLen > False THEN
Temp! = LOF(1) / OldTreasureRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad treasure file record length."
   Temp! = SFalse
   GOTO EndLoop3
END IF
FOR Temp! = 1! TO LOF(1) / OldTreasureRecLen
   GET 1, Temp!, OldTreasureRecord
   NewTreasureRecord.TreasureName = OldTreasureRecord.TreasureName
   NewTreasureRecord.ShortName = OldTreasureRecord.ShortName
   NewTreasureRecord.Weight = OldTreasureRecord.Weight
   NewTreasureRecord.Gold = OldTreasureRecord.Gold
   NewTreasureRecord.Spell = OldTreasureRecord.Spell
   NewTreasureRecord.Plus = ABS(OldTreasureRecord.Plus)
   NewTreasureRecord.Coin = OldTreasureRecord.Coin
   NewTreasureRecord.Locked = OldTreasureRecord.Locked
   NewTreasureRecord.KeyNumber = Csng(OldTreasureRecord.Keyed)
   NewTreasureRecord.Scroll = OldTreasureRecord.Scroll
   NewTreasureRecord.Charges = OldTreasureRecord.Charges
   NewTreasureRecord.Potion = OldTreasureRecord.Potion
   NewTreasureRecord.Loadable = OldTreasureRecord.Loadable
   NewTreasureRecord.Ammunition = OldTreasureRecord.Ammunition
   NewTreasureRecord.AmmoLoads = OldTreasureRecord.AmmoLoads
   NewTreasureRecord.Invisible = OldTreasureRecord.Invisible
   NewTreasureRecord.Permanent = False
   NewTreasureRecord.StaysInRoom = False
   NewTreasureRecord.Proficiency = OldTreasureRecord.Proficiency
   NewTreasureRecord.WeaponNumber = OldTreasureRecord.Type
   IF OldTreasureRecord.RingType THEN
      NewTreasureRecord.WeaponNumber = 4
   ELSE
      IF OldTreasureRecord.Loadable = False THEN
         IF OldTreasureRecord.Launchable = False THEN
            SELECT CASE OldTreasureRecord.Type
            CASE False
               IF OldTreasureRecord.Plus > False THEN ' weapon
                  NewTreasureRecord.WeaponNumber = 7
               END IF
            CASE IS < False ' shield
               NewTreasureRecord.WeaponNumber = 5
            CASE IS > False ' armor
               NewTreasureRecord.WeaponNumber = 1
            END SELECT
         END IF
      END IF
   END IF
   NewTreasureRecord.RingType = OldTreasureRecord.RingType
   NewTreasureRecord.RingSpell = OldTreasureRecord.RingSpell
   NewTreasureRecord.Edible = OldTreasureRecord.Edible
   NewTreasureRecord.Rustable = OldTreasureRecord.Rustable
   NewTreasureRecord.RustPercent = OldTreasureRecord.RustPercent
   NewTreasureRecord.Stealable = OldTreasureRecord.Stealable
   NewTreasureRecord.StealPercent = OldTreasureRecord.StealPercent
   NewTreasureRecord.Launchable = OldTreasureRecord.Launchable
   NewTreasureRecord.LaunchLoads = OldTreasureRecord.LaunchLoads
   NewTreasureRecord.LaunchAmmo = OldTreasureRecord.LaunchAmmo
   NewTreasureRecord.Movable = OldTreasureRecord.Movable
   NewTreasureRecord.Vehicle = False
   NewTreasureRecord.VehicleType = False
   NewTreasureRecord.LightType = False
   NewTreasureRecord.LightCharges = False
   NewTreasureRecord.FuelType = False
   NewTreasureRecord.FuelCharges = False
   NewTreasureRecord.Container = False
   NewTreasureRecord.ContainerMax = False
   NewTreasureRecord.ContainerPrefix = Nul
   NewTreasureRecord.ContainerDisappears = False
   NewTreasureRecord.ContainerSize = False
   NewTreasureRecord.ContainerMaterial = False
   IF OldTreasureRecord.Container THEN
      NewTreasureRecord.Container = True
      NewTreasureRecord.ContainerMax = 10
      NewTreasureRecord.ContainerPrefix = "in it"
      NewTreasureRecord.ContainerDisappears = False
      NewTreasureRecord.ContainerSize = False
      NewTreasureRecord.ContainerMaterial = False
   END IF
   NewTreasureRecord.PotionType = False
   NewTreasureRecord.NewPotion = False
   NewTreasureRecord.MixPotion = False
   NewTreasureRecord.TwoHanded = False
   NewTreasureRecord.RequireStr = False
   NewTreasureRecord.RequireDex = False
   NewTreasureRecord.RequireInt = False
   For Var=1 To 3
      NewTreasureRecord.RestrictItem(Var)=SFalse
   Next
   NewTreasureRecord.TrapType=False
   NewTreasureRecord.TrapHits=False
   NewTreasureRecord.TrapItem=SFalse
   NewTreasureRecord.MasterKey=False
   NewTreasureRecord.Liquid=False
   NewTreasureRecord.LiquidType=False
   NewTreasureRecord.LiquidFlags=False
   NewTreasureRecord.Prefix1=Nul
   NewTreasureRecord.StaysInRoom=0
   NewTreasureRecord.Occupants=0
   NewTreasureRecord.BindType=0
   NewTreasureRecord.TimesCursed=0
   NewTreasureRecord.TimesBlessed=0
   NewTreasureRecord.Persistent=0
   NewTreasureRecord.MaxPersistCharges=0
   NewTreasureRecord.PersistTime=0!
   NewTreasureRecord.DischargePersist=0!
   NewTreasureRecord.ProperName=""
   Select Case NewTreasureRecord.WeaponNumber
   Case 0 ' treasure
      If NewTreasureRecord.Container Then
         NewTreasureRecord.Prefix1 = Strng3 + "FE"
      Else
         If NewTreasureRecord.Spell Then
            NewTreasureRecord.Prefix1 = Strng3 + "F5"
         Else
            If NewTreasureRecord.Coin Then
               NewTreasureRecord.Prefix1 = Strng3 + "F5"
            Else
               If NewTreasureRecord.Vehicle Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Loadable Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Ammunition Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.AmmoLoads Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Launchable Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.LaunchLoads Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.LaunchAmmo Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
            Endif
         Endif
      Endif
   Case 1 ' armor
      NewTreasureRecord.Prefix1 = Strng3 + "F9"
   Case 2 ' boots
      NewTreasureRecord.Prefix1 = Strng3 + "F1"
   Case 3 ' helmet
      NewTreasureRecord.Prefix1 = Strng3 + "F2"
   Case 4 ' ring(left)
      NewTreasureRecord.Prefix1 = Strng3 + "F3"
   Case 5 ' shield
      NewTreasureRecord.Prefix1 = Strng3 + "FA"
   Case 6 ' bracers
      NewTreasureRecord.Prefix1 = Strng3 + "F4"
   Case 7 ' weapon
      NewTreasureRecord.Prefix1 = Strng3 + "FB"
   Case 8 ' cloak
      NewTreasureRecord.Prefix1 = Strng3 + "FC"
   Case 9 ' ring(right)
      NewTreasureRecord.Prefix1 = Strng3 + "F3"
   Case 10 ' amulet
      NewTreasureRecord.Prefix1 = Strng3 + "FD"
   Case Else
      NewTreasureRecord.Prefix1 = Strng3 + "FF"
   End Select
   PUT 2, Temp!, NewTreasureRecord
NEXT
PRINT "Treasure:"; Temp! - 1!
END IF
EndLoop3:
' convert spells
CLOSE
Filename1 = Var1$ + "\" + SpellsFilename$
Filename2 = Var2$ + "\" + SpellsFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldSpellRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewSpellRecLen
IF LOF(1) / OldSpellRecLen > False THEN
Temp! = LOF(1) / OldSpellRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad spell file record length."
   Temp! = SFalse
   GOTO EndLoop4
END IF
FOR Temp! = 1! TO LOF(1) / OldSpellRecLen
   GET 1, Temp!, OldSpellRecord
   NewSpellRecord.SpellName = OldSpellRecord.SpellName
   NewSpellRecord.Chant = OldSpellRecord.Chant
   NewSpellRecord.Level = OldSpellRecord.Level
   NewSpellRecord.SpellType = OldSpellRecord.SpellType
   NewSpellRecord.Teleport = OldSpellRecord.Teleport
   NewSpellRecord.Psionic = OldSpellRecord.Psionic
   NewSpellRecord.PsionicMode = OldSpellRecord.PsionicMode
   NewSpellRecord.ClassType = OldSpellRecord.ClassType
   NewSpellRecord.Desc = OldSpellRecord.Desc
   FOR Temp2 = 1 TO 5
      NewSpellRecord.Ingred(Temp2) = OldSpellRecord.Ingred(Temp2)
   NEXT
   NewSpellRecord.SpellFlag = OldSpellRecord.SpellFlag
   NewSpellRecord.SpellEquate = Nul
   NewSpellRecord.Equation = False
   NewSpellRecord.Prefix1 = ""
   Select Case NewSpellRecord.SpellType
   Case 1
      NewSpellRecord.Prefix1="{F9"
   Case 2
      NewSpellRecord.Prefix1="{FA"
   Case 3
      NewSpellRecord.Prefix1="{FF"
   Case 4
      NewSpellRecord.Prefix1="{FF"
   Case 5
      NewSpellRecord.Prefix1="{F5"
   Case 6
      NewSpellRecord.Prefix1="{FB"
   Case 7
      NewSpellRecord.Prefix1="{FC"
   Case 8
      NewSpellRecord.Prefix1="{FF"
   Case 9
      NewSpellRecord.Prefix1="{FD"
   Case 10
      NewSpellRecord.Prefix1="{FE"
   Case 11
      NewSpellRecord.Prefix1="{F6"
   Case 12
      NewSpellRecord.Prefix1="{FD"
   Case 13
      NewSpellRecord.Prefix1="{FE"
   Case 14
      NewSpellRecord.Prefix1="{F5"
   Case 15
      NewSpellRecord.Prefix1="{FA"
   Case 16
      NewSpellRecord.Prefix1="{F1"
   Case 17
      NewSpellRecord.Prefix1="{F1"
   Case 18
      NewSpellRecord.Prefix1="{F1"
   Case 19
      NewSpellRecord.Prefix1="{FA"
   Case 20
      NewSpellRecord.Prefix1="{F2"
   Case 21
      NewSpellRecord.Prefix1="{F2"
   Case 22
      NewSpellRecord.Prefix1="{F2"
   Case 23
      NewSpellRecord.Prefix1="{F3"
   Case 24
      NewSpellRecord.Prefix1="{F4"
   Case 25
      NewSpellRecord.Prefix1="{F4"
   Case 26
      NewSpellRecord.Prefix1="{F4"
   Case 27
      NewSpellRecord.Prefix1="{FA"
   Case 28
      NewSpellRecord.Prefix1="{FE"
   Case Else
      NewSpellRecord.Prefix1="{FF"
   End Select
   PUT 2, Temp!, NewSpellRecord
NEXT
PRINT "Spells:"; Temp! - 1!
END IF
EndLoop4:
' convert monsters
CLOSE
Filename1 = Var1$ + "\" + MonstersFilename$
Filename2 = Var2$ + "\" + MonstersFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
IF OldVersion = 1 THEN
   GOSUB Convert4
ELSE
   GOSUB Convert5
END IF
' convert monster talk strings
CLOSE
Filename1 = Var1$ + "\" + MontalkFilename$
Filename2 = Var2$ + "\" + MontalkFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = BufferRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = BufferRecLen
IF LOF(1) / BufferRecLen > False THEN
FOR Temp1 = 1 TO LOF(1) / BufferRecLen
   GET 1, Temp1, BufferRecord
   PUT 2, Temp1, BufferRecord
NEXT
END IF
' convert nonplayers
IF OldVersion = 1 THEN
   GOSUB Convert6
ELSE
   GOSUB Convert7
END IF
' convert monster classes
CLOSE
Filename1 = Var1$ + "\" + MonclassFilename$
Filename2 = Var2$ + "\" + MonclassFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonClassRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonClassRecLen
IF LOF(1) / OldMonClassRecLen > False THEN
Temp! = LOF(1) / OldMonClassRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monclass file record length."
   Temp! = SFalse
   GOTO EndLoop7
END IF
FOR Temp! = 1! TO LOF(1) / OldMonClassRecLen
   GET 1, Temp!, OldMonClassRecord
   FOR Temp2 = 1 TO 10
      NewMonClassRecord.Monsters(Temp2) = OldMonClassRecord.Monsters(Temp2)
   NEXT
   PUT 2, Temp!, NewMonClassRecord
NEXT
PRINT "Monclass:"; Temp! - 1!
END IF
EndLoop7:
' convert rooms/users
SELECT CASE OldVersion
CASE 1
   GOSUB Convert2A
CASE 2
   GOSUB Convert2B
END SELECT
RETURN

Add.List.Item:
 VarZ! = LOF(3) / MessWorkRecLen + 1!
 MessWorkRecord.Room = Temp!
 MessWorkRecord.User = SFalse
 MessWorkRecord.Index = VarX!
 MessWorkRecord.Charges = VarY
 MessWorkRecord.Plus = VarY2
 IF NewRoomRecord.First = SFalse THEN
    NewRoomRecord.First = VarZ!
    NewRoomRecord.Last = VarZ!
    PUT 2, Temp!, NewRoomRecord
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    PUT 3, VarZ!, MessWorkRecord
    RETURN
 END IF
 MessWorkRecord.Prev = NewRoomRecord.Last
 MessWorkRecord.Next = SFalse
 PUT 3, VarZ!, MessWorkRecord
 GET 3, NewRoomRecord.Last, MessWorkRecord
 MessWorkRecord.Next = VarZ!
 PUT 3, NewRoomRecord.Last, MessWorkRecord
 GET 3, VarZ!, MessWorkRecord
 NewRoomRecord.Last = VarZ!
 PUT 2, Temp!, NewRoomRecord
 RETURN

Add.List.Item2:
 VarZ! = LOF(3) / MessWorkRecLen + 1!
 MessWorkRecord.Room = SFalse
 MessWorkRecord.User = Temp!
 MessWorkRecord.Index = VarX!
 MessWorkRecord.Charges = VarY
 MessWorkRecord.Plus = False
 IF NewUserRecord.First = SFalse THEN
    NewUserRecord.First = VarZ!
    NewUserRecord.Last = VarZ!
    PUT 2, Temp!, NewUserRecord
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    PUT 3, VarZ!, MessWorkRecord
    RETURN
 END IF
 MessWorkRecord.Prev = NewUserRecord.Last
 MessWorkRecord.Next = SFalse
 PUT 3, VarZ!, MessWorkRecord
 GET 3, NewUserRecord.Last, MessWorkRecord
 MessWorkRecord.Next = VarZ!
 PUT 3, NewUserRecord.Last, MessWorkRecord
 GET 3, VarZ!, MessWorkRecord
 NewUserRecord.Last = VarZ!
 PUT 2, Temp!, NewUserRecord
 RETURN

Add.List.Item3:
 VarZ! = LOF(6) / MessWorkRecLen + 1!
 MessWorkRecord.Room = SFalse
 MessWorkRecord.User = Var1
 MessWorkRecord.Index = Temp3!
 MessWorkRecord.Charges = Var6
 MessWorkRecord.Plus = Var5
 IF NewContainerRecord.First = SFalse THEN
    NewContainerRecord.First = VarZ!
    NewContainerRecord.Last = VarZ!
    PUT 5, Temp3!, NewContainerRecord
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    PUT 6, VarZ!, MessWorkRecord
    RETURN
 END IF
 MessWorkRecord.Prev = NewContainerRecord.Last
 MessWorkRecord.Next = SFalse
 PUT 6, VarZ!, MessWorkRecord
 GET 6, NewContainerRecord.Last, MessWorkRecord
 MessWorkRecord.Next = VarZ!
 PUT 6, NewContainerRecord.Last, MessWorkRecord
 GET 6, VarZ!, MessWorkRecord
 NewContainerRecord.Last = VarZ!
 PUT 5, Temp3!, NewContainerRecord
 RETURN

Convert2A:
' convert rooms dnd27a
CLOSE
Filename1 = Var1$ + "\" + RoomFilename$
Filename2 = Var2$ + "\" + RoomFilename2$
Filename3 = Var2$ + "\" + RoomInvFilename2$
Filename4 = Var2$ + "\" + RoomDescFilename2$
Filename5 = Var2$ + "\" + ContainerFilename2$
Filename6 = Var2$ + "\" + CtnInvFilename2$
Filename7 = Var1$ + "\" + TreasureFilename$
Filename8 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
IF DIR$(Filename4) <> Nul THEN
   KILL Filename4
END IF
IF DIR$(Filename5) <> Nul THEN
   KILL Filename5
END IF
IF DIR$(Filename6) <> Nul THEN
   KILL Filename6
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldRoomRecLen1
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewRoomRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = BufferRecLen
OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewContainerRecLen
OPEN Filename6 FOR RANDOM SHARED AS #6 LEN = MessWorkRecLen
OPEN Filename7 FOR RANDOM SHARED AS #7 LEN = OldTreasureRecLen
OPEN Filename8 FOR RANDOM SHARED AS #8 LEN = NewObjectRecLen
TempX! = SFalse
TempX2! = SFalse
TempX3! = SFalse
TempX4! = SFalse
IF LOF(1) / OldRoomRecLen1 > False THEN
Temp! = LOF(1) / OldRoomRecLen1
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad room file record length."
   Temp! = SFalse
   GOTO EndLoop8A
END IF
FOR Temp! = 1! TO LOF(1) / OldRoomRecLen1
   GET 1, Temp!, OldRoomRecord1
   NewRoomRecord.Action = SFalse
   NewRoomRecord.Custom1 = Nul
   NewRoomRecord.Custom2 = Nul
   FOR Temp2 = 1 TO 14
      NewRoomRecord.Direct(Temp2) = False
   NEXT
   NewRoomRecord.Direct(1) = OldRoomRecord1.Direct(1) ' north
   NewRoomRecord.Direct(2) = OldRoomRecord1.Direct(2) ' east
   NewRoomRecord.Direct(3) = OldRoomRecord1.Direct(3) ' south
   NewRoomRecord.Direct(4) = OldRoomRecord1.Direct(4) ' west
   NewRoomRecord.Direct(5) = OldRoomRecord1.Direct(8) ' northeast
   NewRoomRecord.Direct(6) = OldRoomRecord1.Direct(9) ' southeast
   NewRoomRecord.Direct(7) = OldRoomRecord1.Direct(10) ' southwest
   NewRoomRecord.Direct(8) = OldRoomRecord1.Direct(11) ' northwest
   NewRoomRecord.Direct(9) = OldRoomRecord1.Direct(6) ' up
   NewRoomRecord.Direct(10) = OldRoomRecord1.Direct(7) ' down
   NewRoomRecord.Direct(12) = OldRoomRecord1.Direct(5) ' out
   FOR Temp2 = 1 TO 19
      NewRoomRecord.LongDesc(Temp2) = SFalse
   NEXT
   FOR Temp2 = 1 TO 4
      Var$ = OldRoomRecord1.LongDesc(Temp2)
      Var$ = LTRIM$(Var$)
      Var$ = RTRIM$(Var$)
      IF LEN(Var$) THEN
         IF Var$ <> String$(Len(Var$), 0) THEN
            Temp3! = LOF(4) / BufferRecLen + 1
            BufferRecord.Buffer = Var$
            PUT 4, Temp3!, BufferRecord
            NewRoomRecord.LongDesc(Temp2) = Temp3!
         END IF
      END IF
   NEXT
   NewRoomRecord.MonClass = OldRoomRecord1.MonsterClass
   NewRoomRecord.ShortDesc = OldRoomRecord1.ShortDesc
   NewRoomRecord.First = SFalse
   NewRoomRecord.Last = SFalse
   NewRoomRecord.First2 = SFalse
   NewRoomRecord.Last2 = SFalse
   PUT 2, Temp!, NewRoomRecord
   ' convert room inventory
   FOR Var2 = 1 TO 20
      Var3 = OldRoomRecord1.Object(Var2)
      IF Var3 > False THEN ' object
         VarY = ABS(OldRoomRecord1.ObjCharges(Var2))
         IF ASC(MID$(OldRoomRecord1.Flags, Var2, 1)) = 1 THEN ' invisible
            VarY2 = 1
         ELSE
            VarY2 = False
         END IF
         VarX! = -CSNG(Var3) ' reverse
         GOSUB Add.List.Item
         ' store object room number
         VarX! = CSNG(Var3)
         GET 8, Var3, NewObjectRecord
         If NewObjectRecord.InitRoom = 0! Then
            NewObjectRecord.InitRoom = Temp!
         Else
            If NewObjectRecord.InitRoom2 = 0! Then
               NewObjectRecord.InitRoom2 = Temp!
            Endif
         Endif
         PUT 8, VarX!, NewObjectRecord
         TempX3! = TempX3! + 1!
      END IF
   NEXT
   ' convert room inventory
   FOR Var2 = 1 TO 20
      Var3 = OldRoomRecord1.Object(Var2)
      IF Var3 < False THEN ' treasure
         Var3 = ABS(Var3) ' reverse
         GET 7, Var3, OldTreasureRecord
         IF OldTreasureRecord.Container THEN
            ' convert container
            TempX! = TempX! + 1!
            NewContainerRecord.ContainerName = OldTreasureRecord.TreasureName
            NewContainerRecord.ContainerShort = OldTreasureRecord.ShortName
            NewContainerRecord.NamePrefix = "in it"
            NewContainerRecord.ContainerMax = 10
            NewContainerRecord.Closed = OldTreasureRecord.Closed
            NewContainerRecord.Locked = OldTreasureRecord.Locked
            NewContainerRecord.KeyNumber = Csng(OldTreasureRecord.Keyed)
            NewContainerRecord.UserNumber = SFalse
            NewContainerRecord.RoomNumber = Temp!
            NewContainerRecord.DeletedContainer = False
            NewContainerRecord.InvisibleContainer = False
            NewContainerRecord.Weight = 1
            NewContainerRecord.WithinContainer = SFalse
            NewContainerRecord.Disappears = SFalse
            NewContainerRecord.ContainerIndex = SFalse
            NewContainerRecord.Size = False
            NewContainerRecord.Material = False
            NewContainerRecord.Permanent = False
            NewContainerRecord.SelfImplodes = False
            NewContainerRecord.Prefix1 = Strng3 + "FE"
            NewContainerRecord.SwapFlag = False
            NewContainerRecord.Damaged = False
            NewContainerRecord.First2 = SFalse
            NewContainerRecord.Last2 = SFalse
            NewContainerRecord.First = SFalse
            NewContainerRecord.Last = SFalse
            Temp3! = LOF(5) / NewContainerRecLen + 1!
            ' add container to rooms.dat list
            IF NewRoomRecord.First2 = SFalse THEN
               NewRoomRecord.First2 = Temp3!
               NewRoomRecord.Last2 = Temp3!
               PUT 2, Temp!, NewRoomRecord
               NewContainerRecord.Prev = SFalse
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
            ELSE
               NewContainerRecord.Prev = NewRoomRecord.Last2
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
               GET 5, NewRoomRecord.Last2, NewContainerRecord
               NewContainerRecord.Next = Temp3!
               PUT 5, NewRoomRecord.Last2, NewContainerRecord
               GET 5, Temp3!, NewContainerRecord
               NewRoomRecord.Last2 = Temp3!
               PUT 2, Temp!, NewRoomRecord
            END IF
            ' convert all container inventory
            CLOSE 9
            FileName9 = Var1$ + "\" + RTRIM$(OldTreasureRecord.ContainerFileName) + ".CTN"
            OPEN FileName9 FOR RANDOM SHARED AS #9 LEN = LEN(OldReceptacleRecord)
            FOR Var4 = 1 TO LOF(9) / OldReceptacleRecLen
               GET 9, Var4, OldReceptacleRecord
               Var1 = OldReceptacleRecord.Inv
               IF Var1 > False THEN
                  Var1 = -ABS(Var1)
               ELSE
                  IF Var1 < False THEN
                     Var1 = ABS(Var1)
                  END IF
               END IF
               Var6 = OldReceptacleRecord.Charges
               Var5 = False
               IF OldReceptacleRecord.Invis THEN
                  Var5 = True
               END IF
               IF Var1 THEN
                  TempX4! = TempX4! + 1!
                  GOSUB Add.List.Item3
               END IF
            NEXT
         ELSE
            ' convert treasure
            VarY = ABS(OldRoomRecord1.ObjCharges(Var2))
            IF ASC(MID$(OldRoomRecord1.Flags, Var2, 1)) = 1 THEN ' invisible
               VarY2 = 1
            ELSE
               VarY2 = False
            END IF
            VarX! = ABS(Var3)
            GOSUB Add.List.Item
            TempX2! = TempX2! + 1!
         END IF
      END IF
   NEXT
NEXT
PRINT "Rooms:"; Temp! - 1!
PRINT "Room objects:"; TempX3!
PRINT "Room treasure:"; TempX2!
PRINT "Room containers:"; TempX!
PRINT "Container inventory:"; TempX4!
END IF
EndLoop8A:
' convert users dnd27a
CLOSE
Filename1 = Var1$ + "\" + UsersFilename$
Filename2 = Var2$ + "\" + UsersFilename2$
Filename3 = Var2$ + "\" + UserInvFilename2$
Filename4 = Nul
Filename5 = Var2$ + "\" + ContainerFilename2$
Filename6 = Var2$ + "\" + CtnInvFilename2$
Filename7 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldUserRecLen1
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewUserRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewContainerRecLen
OPEN Filename6 FOR RANDOM SHARED AS #6 LEN = MessWorkRecLen
OPEN Filename7 FOR RANDOM SHARED AS #7 LEN = OldTreasureRecLen
TempX! = SFalse
TempX2! = SFalse
TempX3! = SFalse
TempX4! = SFalse
IF LOF(1) / OldUserRecLen1 > False THEN
Temp! = LOF(1) / OldUserRecLen1
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad user file record length."
   Temp! = SFalse
   GOTO EndLoop9A
END IF
FOR Temp! = 1! TO LOF(1) / OldUserRecLen1
   GET 1, Temp!, OldUserRecord1
   Var$=OldUserRecord1.CodeName
   Var$=Rtrim$(Var$)
   Do
      Var=Instr(Var$," ")
      If Var=0 Then
         Exit Do
      Endif
      Mid$(Var$,Var,1)="_"
   Loop
   NewUserRecord.CodeName = Var$
   Var4$ = OldUserRecord1.PassWord
   Var4$ = LTRIM$(Var4$)
   Var4$ = RTRIM$(Var4$)
   Var4$ = UCASE$(Var4$)
   Var$ = Var4$
   CALL Cryptograph(Var$)
   NewUserRecord.PassWord = Var$
   NewUserRecord.ClassName = OldUserRecord1.ClassName
   NewUserRecord.DateOn = DateS$
   NewUserRecord.ClassType = OldUserRecord1.ClassType
   NewUserRecord.PassWord2 = Nul
   NewUserRecord.Question = Nul
   NewUserRecord.Answer = Nul
   Var$ = Var4$
   CALL Crypto(Var$)
   NewUserRecord.PassWord3 = Var$
   FOR Temp2 = 1 TO 7
      NewUserRecord.Stats(Temp2) = OldUserRecord1.Stats(Temp2)
   NEXT
   FOR Temp2 = 1 TO 10
      NewUserRecord.Weapon(Temp2).Index = SFalse
      NewUserRecord.Weapon(Temp2).Charges = False
      NewUserRecord.Weapon(Temp2).Plus = False
   NEXT
   FOR Temp2 = 1 TO 4
      NewUserRecord.Weapons(Temp2) = OldUserRecord1.Weapons(Temp2)
   NEXT
   NewUserRecord.Room = OldUserRecord1.Room
   NewUserRecord.Level = OldUserRecord1.Level
   NewUserRecord.Experience = OldUserRecord1.Experience
   NewUserRecord.Gold = OldUserRecord1.Gold
   NewUserRecord.NumCalls = OldUserRecord1.NumCalls
   NewUserRecord.Fatigue = OldUserRecord1.Fatigue
   NewUserRecord.FatigueMax = OldUserRecord1.FatigueMax
   NewUserRecord.Vitality = OldUserRecord1.Vitality
   NewUserRecord.VitalityMax = OldUserRecord1.VitalityMax
   NewUserRecord.Magic = OldUserRecord1.Magic
   NewUserRecord.MagicMax = OldUserRecord1.MagicMax
   NewUserRecord.Poison = OldUserRecord1.Poison
   NewUserRecord.Borrow = OldUserRecord1.Borrow
   NewUserRecord.Invisible = OldUserRecord1.Invisible
   NewUserRecord.Race = OldUserRecord1.Race
   NewUserRecord.Proficiency = OldUserRecord1.Proficiency
   NewUserRecord.Bank = OldUserRecord1.Bank
   TotalBank = TotalBank + OldUserRecord.Bank
   NewUserRecord.PlayersKilled = False
   NewUserRecord.MonstersKilled = OldUserRecord1.MonstersKilled
   NewUserRecord.Brief = OldUserRecord1.Brief
   NewUserRecord.Beauty = 10
   NewUserRecord.Glamour = 10
   NewUserRecord.Psionic = OldUserRecord1.Psionic
   NewUserRecord.PsionicMax = OldUserRecord1.PsionicMax
   NewUserRecord.Align1 = OldUserRecord1.Align1
   NewUserRecord.Align2 = OldUserRecord1.Align2
   NewUserRecord.Flags = OldUserRecord1.Flags
   NewUserRecord.Flags2 = False
   NewUserRecord.MaxCalls = 3
   NewUserRecord.FromHour = False
   NewUserRecord.FromMin = False
   NewUserRecord.ToHour = False
   NewUserRecord.ToMin = False
   NewUserRecord.SortInv = False
   NewUserRecord.TimeUsed = SFalse
   NewUserRecord.TimeLimit = SFalse
   NewUserRecord.Hidden = False
   NewUserRecord.Encumbrance = 10
   NewUserRecord.TimesLogon = 0#
   NewUserRecord.TimesDied = 0#
   NewUserRecord.Prefix1 = ""
   NewUserRecord.Prefix2 = ""
   NewUserRecord.Prefix3 = ""
   For Temp2=1 to 8
      NewUserRecord.ShortcutKey1(Temp2)=""
      NewUserRecord.ShortcutKey2(Temp2)=""
   Next
   For Temp2=1 To 10
      NewUserRecord.FunctionKeys(Temp2)=""
   Next
   NewUserRecord.ActionLineString = ""
   NewUserRecord.StatusLineString = ""
   NewUserRecord.StatusVar = 0
   NewUserRecord.First = SFalse
   NewUserRecord.Last = SFalse
   NewUserRecord.First2 = SFalse
   NewUserRecord.Last2 = SFalse
   NewUserRecord.NodeList=String$(127,"1")
   NewUserRecord.NodeList2=0!
   NewUserRecord.EditList=0!
   PUT 2, Temp!, NewUserRecord
   ' convert user inventory
   FOR Var2 = 1 TO 20
      Var3 = OldUserRecord1.Inv(Var2)
      IF Var3 > False THEN ' object
         VarY = ABS(OldUserRecord1.Charges(Var2))
         VarY2 = False
         VarX! = -ABS(Var3) ' reverse
         GOSUB Add.List.Item2
         TempX3! = TempX3! + 1!
      END IF
   NEXT
   ' convert user inventory
   FOR Var2 = 1 TO 20
      Var3 = OldUserRecord1.Inv(Var2)
      IF Var3 < False THEN ' treasure
         Var3 = ABS(Var3) ' reverse
         GET 7, Var3, OldTreasureRecord
         IF OldTreasureRecord.Container THEN
            ' convert container
            TempX! = TempX! + 1!
            NewContainerRecord.ContainerName = OldTreasureRecord.TreasureName
            NewContainerRecord.ContainerShort = OldTreasureRecord.ShortName
            NewContainerRecord.NamePrefix = "in it"
            NewContainerRecord.ContainerMax = 10
            NewContainerRecord.Closed = OldTreasureRecord.Closed
            NewContainerRecord.Locked = OldTreasureRecord.Locked
            NewContainerRecord.KeyNumber = Csng(OldTreasureRecord.Keyed)
            NewContainerRecord.UserNumber = SFalse
            NewContainerRecord.RoomNumber = Temp!
            NewContainerRecord.DeletedContainer = False
            NewContainerRecord.InvisibleContainer = False
            NewContainerRecord.Weight = 1
            NewContainerRecord.WithinContainer = SFalse
            NewContainerRecord.Disappears = SFalse
            NewContainerRecord.ContainerIndex = SFalse
            NewContainerRecord.Size = False
            NewContainerRecord.Material = False
            NewContainerRecord.Permanent = False
            NewContainerRecord.SelfImplodes = False
            NewContainerRecord.Prefix1 = Strng3 + "FE"
            NewContainerRecord.SwapFlag = False
            NewContainerRecord.Damaged = False
            NewContainerRecord.First2 = SFalse
            NewContainerRecord.Last2 = SFalse
            NewContainerRecord.First = SFalse
            NewContainerRecord.Last = SFalse
            Temp3! = LOF(5) / NewContainerRecLen + 1!
            ' add container to users.dat list
            IF NewUserRecord.First2 = SFalse THEN
               NewUserRecord.First2 = Temp3!
               NewUserRecord.Last2 = Temp3!
               PUT 2, Temp!, NewUserRecord
               NewContainerRecord.Prev = SFalse
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
            ELSE
               NewContainerRecord.Prev = NewRoomRecord.Last2
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
               GET 5, NewUserRecord.Last2, NewContainerRecord
               NewContainerRecord.Next = Temp3!
               PUT 5, NewUserRecord.Last2, NewContainerRecord
               GET 5, Temp3!, NewContainerRecord
               NewUserRecord.Last2 = Temp3!
               PUT 2, Temp!, NewUserRecord
            END IF
            ' convert all container inventory
            CLOSE 8
            FileName8 = Var1$ + "\" + RTRIM$(OldTreasureRecord.ContainerFileName) + ".CTN"
            OPEN FileName8 FOR RANDOM SHARED AS #8 LEN = LEN(OldReceptacleRecord)
            FOR Var4 = 1 TO LOF(8) / OldReceptacleRecLen
               GET 8, Var4, OldReceptacleRecord
               Var1 = OldReceptacleRecord.Inv
               IF Var1 > False THEN
                  Var1 = -ABS(Var1)
               ELSE
                  IF Var1 < False THEN
                     Var1 = ABS(Var1)
                  END IF
               END IF
               Var6 = OldReceptacleRecord.Charges
               Var5 = False
               IF OldReceptacleRecord.Invis THEN
                  Var5 = True
               END IF
               IF Var1 THEN
                  TempX4! = TempX4! + 1!
                  GOSUB Add.List.Item3
               END IF
            NEXT
         ELSE
            ' convert treasure
            VarY = ABS(OldUserRecord1.Charges(Var2))
            VarY2 = False
            VarX! = ABS(Var3)
            GOSUB Add.List.Item2
            TempX2! = TempX2! + 1!
         END IF
      END IF
   NEXT
NEXT
PRINT "Users:"; Temp! - 1!
PRINT "User objects:"; TempX3!
PRINT "User treasure:"; TempX2!
PRINT "User containers:"; TempX!
PRINT "Container inventory:"; TempX4!
END IF
EndLoop9A:
TempX! = SFalse
 RETURN

Convert2B:
' convert rooms dnd29c1
CLOSE
Filename1 = Var1$ + "\" + RoomFilename$
Filename2 = Var2$ + "\" + RoomFilename2$
Filename3 = Var2$ + "\" + RoomInvFilename2$
Filename4 = Var2$ + "\" + RoomDescFilename2$
Filename5 = Var2$ + "\" + ContainerFilename2$
Filename6 = Var2$ + "\" + CtnInvFilename2$
Filename7 = Var1$ + "\" + TreasureFilename$
Filename8 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
IF DIR$(Filename4) <> Nul THEN
   KILL Filename4
END IF
IF DIR$(Filename5) <> Nul THEN
   KILL Filename5
END IF
IF DIR$(Filename6) <> Nul THEN
   KILL Filename6
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldRoomRecLen2
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewRoomRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = BufferRecLen
OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewContainerRecLen
OPEN Filename6 FOR RANDOM SHARED AS #6 LEN = MessWorkRecLen
OPEN Filename7 FOR RANDOM SHARED AS #7 LEN = OldTreasureRecLen
OPEN Filename8 FOR RANDOM SHARED AS #8 LEN = NewObjectRecLen
TempX! = SFalse
TempX2! = SFalse
TempX3! = SFalse
TempX4! = SFalse
IF LOF(1) / OldRoomRecLen2 > False THEN
Temp! = LOF(1) / OldRoomRecLen2
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad room file record length."
   Temp! = SFalse
   GOTO EndLoop8B
END IF
FOR Temp! = 1! TO LOF(1) / OldRoomRecLen2
   GET 1, Temp!, OldRoomRecord2
   NewRoomRecord.Action = SFalse
   NewRoomRecord.Custom1 = Nul
   NewRoomRecord.Custom2 = Nul
   FOR Temp2 = 1 TO 14
      NewRoomRecord.Direct(Temp2) = False
   NEXT
   NewRoomRecord.Direct(1) = OldRoomRecord2.Direct(1) ' north
   NewRoomRecord.Direct(2) = OldRoomRecord2.Direct(2) ' east
   NewRoomRecord.Direct(3) = OldRoomRecord2.Direct(3) ' south
   NewRoomRecord.Direct(4) = OldRoomRecord2.Direct(4) ' west
   NewRoomRecord.Direct(5) = OldRoomRecord2.Direct(8) ' northeast
   NewRoomRecord.Direct(6) = OldRoomRecord2.Direct(9) ' southeast
   NewRoomRecord.Direct(7) = OldRoomRecord2.Direct(10) ' southwest
   NewRoomRecord.Direct(8) = OldRoomRecord2.Direct(11) ' northwest
   NewRoomRecord.Direct(9) = OldRoomRecord2.Direct(6) ' up
   NewRoomRecord.Direct(10) = OldRoomRecord2.Direct(7) ' down
   NewRoomRecord.Direct(12) = OldRoomRecord2.Direct(5) ' out
   FOR Temp2 = 1 TO 19
      NewRoomRecord.LongDesc(Temp2) = SFalse
   NEXT
   FOR Temp2 = 1 TO 4
      Var$ = OldRoomRecord2.LongDesc(Temp2)
      Var$ = LTRIM$(Var$)
      Var$ = RTRIM$(Var$)
      IF LEN(Var$) THEN
         IF Var$ <> String$(Len(Var$), 0) THEN
            Temp3! = LOF(4) / BufferRecLen + 1
            BufferRecord.Buffer = Var$
            PUT 4, Temp3!, BufferRecord
            NewRoomRecord.LongDesc(Temp2) = Temp3!
         END IF
      END IF
   NEXT
   NewRoomRecord.MonClass = OldRoomRecord2.MonsterClass
   NewRoomRecord.ShortDesc = OldRoomRecord2.ShortDesc
   NewRoomRecord.First = SFalse
   NewRoomRecord.Last = SFalse
   NewRoomRecord.First2 = SFalse
   NewRoomRecord.Last2 = SFalse
   PUT 2, Temp!, NewRoomRecord
   ' convert room objects
   FOR Var2 = 1 TO 10
      Var1 = OldRoomRecord2.Object(Var2)
      VarY = ABS(OldRoomRecord2.ObjCharges(Var2))
      VarY2 = OldRoomRecord2.Flags(Var2)
      IF Var1 THEN
         VarX! = -ABS(Var1)
         GOSUB Add.List.Item
         TempX3! = TempX3! + 1!
         ' store object room number
         VarX! = ABS(Var1)
         GET 8, VarX!, NewObjectRecord
         If NewObjectRecord.InitRoom = 0! Then
            NewObjectRecord.InitRoom = Temp!
         Else
            If NewObjectRecord.InitRoom2 = 0! Then
               NewObjectRecord.InitRoom2 = Temp!
            Endif
         Endif
         PUT 8, VarX!, NewObjectRecord
      END IF
   NEXT
   ' convert room treasure
   FOR Var2 = 1 TO 10
      Var3 = OldRoomRecord2.Treasure(Var2)
      IF Var3 > False THEN
         GET 7, Var3, OldTreasureRecord
         IF OldTreasureRecord.Container THEN
            ' convert container
            TempX! = TempX! + 1!
            NewContainerRecord.ContainerName = OldTreasureRecord.TreasureName
            NewContainerRecord.ContainerShort = OldTreasureRecord.ShortName
            NewContainerRecord.NamePrefix = "in it"
            NewContainerRecord.ContainerMax = 10
            NewContainerRecord.Closed = OldTreasureRecord.Closed
            NewContainerRecord.Locked = OldTreasureRecord.Locked
            NewContainerRecord.KeyNumber = Csng(OldTreasureRecord.Keyed)
            NewContainerRecord.UserNumber = SFalse
            NewContainerRecord.RoomNumber = Temp!
            NewContainerRecord.DeletedContainer = False
            NewContainerRecord.InvisibleContainer = False
            NewContainerRecord.Weight = 1
            NewContainerRecord.WithinContainer = SFalse
            NewContainerRecord.Disappears = SFalse
            NewContainerRecord.ContainerIndex = SFalse
            NewContainerRecord.Size = False
            NewContainerRecord.Material = False
            NewContainerRecord.Permanent = False
            NewContainerRecord.SelfImplodes = False
            NewContainerRecord.Prefix1 = Strng3 + "FE"
            NewContainerRecord.SwapFlag = False
            NewContainerRecord.Damaged = False
            NewContainerRecord.First2 = SFalse
            NewContainerRecord.Last2 = SFalse
            NewContainerRecord.First = SFalse
            NewContainerRecord.Last = SFalse
            Temp3! = LOF(5) / NewContainerRecLen + 1!
            ' add container to rooms.dat list
            IF NewRoomRecord.First2 = SFalse THEN
               NewRoomRecord.First2 = Temp3!
               NewRoomRecord.Last2 = Temp3!
               PUT 2, Temp!, NewRoomRecord
               NewContainerRecord.Prev = SFalse
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
            ELSE
               NewContainerRecord.Prev = NewRoomRecord.Last2
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
               GET 5, NewRoomRecord.Last2, NewContainerRecord
               NewContainerRecord.Next = Temp3!
               PUT 5, NewRoomRecord.Last2, NewContainerRecord
               GET 5, Temp3!, NewContainerRecord
               NewRoomRecord.Last2 = Temp3!
               PUT 2, Temp!, NewRoomRecord
            END IF
            ' convert all container inventory
            CLOSE 9
            FileName9 = Var5$ + "\" + RTRIM$(OldTreasureRecord.ContainerFileName) + CtnExt2$
            OPEN FileName9 FOR RANDOM SHARED AS #9 LEN = LEN(OldContainerRecord)
            FOR Var4 = 1 TO LOF(9) / OldContainerRecLen
               GET 9, Var4, OldContainerRecord
               Var1 = OldContainerRecord.Inv
               Var6 = OldContainerRecord.Charges
               Var5 = False
               IF OldContainerRecord.Invis THEN
                  Var5 = True
               END IF
               IF Var1 THEN
                  TempX4! = TempX4! + 1!
                  GOSUB Add.List.Item3
               END IF
            NEXT
         ELSE
            ' convert treasure
            Var1 = OldRoomRecord2.Treasure(Var2)
            VarY = ABS(OldRoomRecord2.TreCharges(Var2))
            VarY2 = OldRoomRecord2.Flags(Var2)
            VarX! = ABS(Var1)
            GOSUB Add.List.Item
            TempX2! = TempX2! + 1!
         END IF
      END IF
   NEXT
NEXT
PRINT "Rooms:"; Temp! - 1!
PRINT "Room objects:"; TempX3!
PRINT "Room treasure:"; TempX2!
PRINT "Room containers:"; TempX!
PRINT "Container inventory"; TempX4!
END IF
EndLoop8B:
' convert users dnd29c1
CLOSE
Filename1 = Var1$ + "\" + UsersFilename$
Filename2 = Var2$ + "\" + UsersFilename2$
Filename3 = Var2$ + "\" + UserInvFilename2$
Filename4 = Nul
Filename5 = Var2$ + "\" + ContainerFilename2$
Filename6 = Var2$ + "\" + CtnInvFilename2$
Filename7 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldUserRecLen2
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewUserRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen

OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewContainerRecLen
OPEN Filename6 FOR RANDOM SHARED AS #6 LEN = MessWorkRecLen
OPEN Filename7 FOR RANDOM SHARED AS #7 LEN = OldTreasureRecLen
TempX! = SFalse
TempX2! = SFalse
TempX3! = SFalse
TempX4! = SFalse
IF LOF(1) / OldUserRecLen2 > False THEN
Temp! = LOF(1) / OldUserRecLen2
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad user file record length."
   Temp! = SFalse
   GOTO EndLoop9B
END IF
FOR Temp! = 1! TO LOF(1) / OldUserRecLen2
   GET 1, Temp!, OldUserRecord2
   Var$ = OldUserRecord2.CodeName
   CALL Decrypt(Var$)
   Var$=Rtrim$(Var$)
   Do
      Var=Instr(Var$," ")
      If Var=0 Then
         Exit Do
      Endif
      Mid$(Var$,Var,1)="_"
   Loop
   NewUserRecord.CodeName = Var$
   Var4$ = OldUserRecord2.PassWord
   CALL Decrypt(Var4$)
   Var4$ = LTRIM$(Var4$)
   Var4$ = RTRIM$(Var4$)
   Var4$ = UCASE$(Var4$)
   Var$ = Var4$
   CALL Cryptograph(Var$)
   NewUserRecord.PassWord = Var$
   Var$ = OldUserRecord2.ClassName
   CALL Decrypt(Var$)
   NewUserRecord.ClassName = Var$
   NewUserRecord.DateOn = DateS$
   NewUserRecord.ClassType = OldUserRecord2.ClassType
   NewUserRecord.PassWord2 = Nul
   NewUserRecord.Question = Nul
   NewUserRecord.Answer = Nul
   Var$ = Var4$
   CALL Crypto(Var$)
   NewUserRecord.PassWord3 = Var$
   FOR Temp2 = 1 TO 7
      NewUserRecord.Stats(Temp2) = OldUserRecord2.Stats(Temp2)
   NEXT
   FOR Temp2 = 1 TO 10
      NewUserRecord.Weapon(Temp2).Index = SFalse
      NewUserRecord.Weapon(Temp2).Charges = False
      NewUserRecord.Weapon(Temp2).Plus = False
   NEXT
   FOR Temp2 = 1 TO 4
      NewUserRecord.Weapons(Temp2) = OldUserRecord2.Weapons(Temp2)
   NEXT
   NewUserRecord.Room = OldUserRecord2.Room
   NewUserRecord.Level = OldUserRecord2.Level
   NewUserRecord.Experience = OldUserRecord2.Experience
   NewUserRecord.Gold = OldUserRecord2.Gold
   NewUserRecord.NumCalls = OldUserRecord2.NumCalls
   NewUserRecord.Fatigue = OldUserRecord2.Fatigue
   NewUserRecord.FatigueMax = OldUserRecord2.FatigueMax
   NewUserRecord.Vitality = OldUserRecord2.Vitality
   NewUserRecord.VitalityMax = OldUserRecord2.VitalityMax
   NewUserRecord.Magic = OldUserRecord2.Magic
   NewUserRecord.MagicMax = OldUserRecord2.MagicMax
   NewUserRecord.Poison = OldUserRecord2.Poison
   NewUserRecord.Borrow = OldUserRecord2.Borrow
   NewUserRecord.Invisible = OldUserRecord2.Invisible
   NewUserRecord.Race = OldUserRecord2.Race
   NewUserRecord.Proficiency = OldUserRecord2.Proficiency
   NewUserRecord.Bank = OldUserRecord2.Bank
   TotalBank = TotalBank + OldUserRecord.Bank
   NewUserRecord.PlayersKilled = False
   NewUserRecord.MonstersKilled = OldUserRecord2.MonstersKilled
   NewUserRecord.Brief = OldUserRecord2.Brief
   'NewUserRecord.Beauty = OldUserRecord2.Beauty
   'NewUserRecord.Glamour = OldUserRecord2.Glamour
   NewUserRecord.Psionic = OldUserRecord2.Psionic
   NewUserRecord.PsionicMax = OldUserRecord2.PsionicMax
   NewUserRecord.Align1 = OldUserRecord2.Align1
   NewUserRecord.Align2 = OldUserRecord2.Align2
   NewUserRecord.Flags = OldUserRecord2.Flags
   NewUserRecord.Flags2 = False
   NewUserRecord.MaxCalls = OldUserRecord2.MaxCalls
   NewUserRecord.FromHour = OldUserRecord2.FromHour
   NewUserRecord.FromMin = OldUserRecord2.FromMin
   NewUserRecord.ToHour = OldUserRecord2.ToHour
   NewUserRecord.ToMin = OldUserRecord2.ToMin
   NewUserRecord.SortInv = False
   NewUserRecord.TimeUsed = SFalse
   NewUserRecord.TimeLimit = SFalse
   NewUserRecord.Hidden = False
   NewUserRecord.Encumbrance = 10
   NewUserRecord.TimesLogon = 0#
   NewUserRecord.TimesDied = 0#
   NewUserRecord.Prefix1 = ""
   NewUserRecord.Prefix2 = ""
   NewUserRecord.Prefix3 = ""
   For Temp2=1 to 8
      NewUserRecord.ShortcutKey1(Temp2)=""
      NewUserRecord.ShortcutKey2(Temp2)=""
   Next
   For Temp2=1 To 10
      NewUserRecord.FunctionKeys(Temp2)=""
   Next
   NewUserRecord.ActionLineString = ""
   NewUserRecord.StatusLineString = ""
   NewUserRecord.StatusVar = 0
   NewUserRecord.First = SFalse
   NewUserRecord.Last = SFalse
   NewUserRecord.First2 = SFalse
   NewUserRecord.Last2 = SFalse
   NewUserRecord.NodeList=String$(127,"1")
   NewUserRecord.NodeList2=0!
   NewUserRecord.EditList=0!
   PUT 2, Temp!, NewUserRecord
   ' convert user inventory
   FOR Var2 = 1 TO 5
      Var3 = OldUserRecord2.Object(Var2)
      IF Var3 THEN ' object
         VarY = ABS(OldUserRecord2.ObjCharges(Var2))
         VarY2 = False
         VarX! = -ABS(Var3) ' reverse
         GOSUB Add.List.Item2
         TempX3! = TempX3! + 1!
      END IF
   NEXT
   ' convert user inventory
   FOR Var2 = 1 TO 15
      Var3 = OldUserRecord2.Inv(Var2)
      IF Var3 THEN ' treasure
         Var3 = ABS(Var3) ' reverse
         GET 7, Var3, OldTreasureRecord
         IF OldTreasureRecord.Container THEN
            ' convert container
            TempX! = TempX! + 1!
            NewContainerRecord.ContainerName = OldTreasureRecord.TreasureName
            NewContainerRecord.ContainerShort = OldTreasureRecord.ShortName
            NewContainerRecord.NamePrefix = "in it"
            NewContainerRecord.ContainerMax = 10
            NewContainerRecord.Closed = OldTreasureRecord.Closed
            NewContainerRecord.Locked = OldTreasureRecord.Locked
            NewContainerRecord.KeyNumber = Csng(OldTreasureRecord.Keyed)
            NewContainerRecord.UserNumber = SFalse
            NewContainerRecord.RoomNumber = Temp!
            NewContainerRecord.DeletedContainer = False
            NewContainerRecord.InvisibleContainer = False
            NewContainerRecord.Weight = 1
            NewContainerRecord.WithinContainer = SFalse
            NewContainerRecord.Disappears = SFalse
            NewContainerRecord.ContainerIndex = SFalse
            NewContainerRecord.Size = False
            NewContainerRecord.Material = False
            NewContainerRecord.Permanent = False
            NewContainerRecord.SelfImplodes = False
            NewContainerRecord.Prefix1 = Strng3 + "FE"
            NewContainerRecord.SwapFlag = False
            NewContainerRecord.Damaged = False
            NewContainerRecord.First2 = SFalse
            NewContainerRecord.Last2 = SFalse
            NewContainerRecord.First = SFalse
            NewContainerRecord.Last = SFalse
            Temp3! = LOF(5) / NewContainerRecLen + 1!
            ' add container to users.dat list
            IF NewUserRecord.First2 = SFalse THEN
               NewUserRecord.First2 = Temp3!
               NewUserRecord.Last2 = Temp3!
               PUT 2, Temp!, NewUserRecord
               NewContainerRecord.Prev = SFalse
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
            ELSE
               NewContainerRecord.Prev = NewRoomRecord.Last2
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
               GET 5, NewUserRecord.Last2, NewContainerRecord
               NewContainerRecord.Next = Temp3!
               PUT 5, NewUserRecord.Last2, NewContainerRecord
               GET 5, Temp3!, NewContainerRecord
               NewUserRecord.Last2 = Temp3!
               PUT 2, Temp!, NewUserRecord
            END IF
            ' convert all container inventory
            CLOSE 8
            FileName8 = Var5$ + "\" + RTRIM$(OldTreasureRecord.ContainerFileName) + CtnExt2$
            OPEN FileName8 FOR RANDOM SHARED AS #8 LEN = LEN(OldContainerRecord)
            FOR Var4 = 1 TO LOF(8) / OldContainerRecLen
               GET 8, Var4, OldContainerRecord
               Var1 = OldContainerRecord.Inv
               Var6 = OldContainerRecord.Charges
               Var5 = False
               IF OldContainerRecord.Invis THEN
                  Var5 = True
               END IF
               IF Var1 THEN
                  TempX4! = TempX4! + 1!
                  GOSUB Add.List.Item3
               END IF
            NEXT
         ELSE
            ' convert treasure
            VarY = ABS(OldUserRecord2.Charges(Var2))
            VarY2 = False
            VarX! = ABS(Var3)
            GOSUB Add.List.Item2
            TempX2! = TempX2! + 1!
         END IF
      END IF
   NEXT
NEXT
PRINT "Users:"; Temp! - 1!
PRINT "User objects:"; TempX3!
PRINT "User treasure:"; TempX2!
PRINT "User containers:"; TempX!
PRINT "Container inventory:"; TempX4!
END IF
EndLoop9B:
TempX! = SFalse
 RETURN

Convert3:
' convert objects
CLOSE
Filename1 = Var1$ + "\" + ObjectFilename$
Filename2 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldObjectRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewObjectRecLen
IF LOF(1) / OldObjectRecLen3 > False THEN
Temp! = LOF(1) / OldObjectRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad object file record length."
   Temp! = SFalse
   GOTO EndLoop2A
END IF
FOR Temp! = 1! TO LOF(1) / OldObjectRecLen3
   GET 1, Temp!, OldObjectRecord3
   NewObjectRecord.ObjectName = OldObjectRecord3.ObjectName
   NewObjectRecord.ShortName = OldObjectRecord3.ShortName
   NewObjectRecord.RoomLink1 = OldObjectRecord3.RoomLink
   NewObjectRecord.RoomLink2 = SFalse
   NewObjectRecord.Invisible = OldObjectRecord3.Invisible
   NewObjectRecord.JailTrap = OldObjectRecord3.JailTrap
   NewObjectRecord.DoorLock = OldObjectRecord3.DoorLock
   NewObjectRecord.Destination = OldObjectRecord3.Destination
   NewObjectRecord.Permanent = OldObjectRecord3.Permanent
   NewObjectRecord.Hidden = OldObjectRecord3.Hidden
   NewObjectRecord.Closed = OldObjectRecord3.Closed
   NewObjectRecord.KeyNumber = Csng(OldObjectRecord3.Keyed)
   NewObjectRecord.Relocks = OldObjectRecord3.Relocks
   NewObjectRecord.LongDesc = OldObjectRecord3.LongDesc
   NewObjectRecord.FromHour = OldObjectRecord3.FromHour
   NewObjectRecord.FromMin = OldObjectRecord3.FromMin
   NewObjectRecord.ToHour = OldObjectRecord3.ToHour
   NewObjectRecord.ToMin = OldObjectRecord3.ToMin
   NewObjectRecord.LightRoom = OldObjectRecord3.LightRoom
   NewObjectRecord.LightTime = OldObjectRecord3.LightTime
   Var$ = Rtrim$(OldObjectRecord3.ShortDesc)
   If Var$ = String$(40, 0) Then
      Var$ = Nul
   Endif
   NewObjectRecord.ShortDesc = Var$
   NewObjectRecord.Trap = OldObjectRecord3.Trap
   NewObjectRecord.Teleport = OldObjectRecord3.Teleport
   NewObjectRecord.SwitchType = False
   NewObjectRecord.SwitchRoom = SFalse
   NewObjectRecord.SwitchLight = False
   NewObjectRecord.SwitchLockRoom = False
   NewObjectRecord.Prefix1 = Nul
   NewObjectRecord.PortalPassword = Nul
   For VarQ=1 To 19
      NewObjectRecord.ObjDesc(VarQ)=0!
   Next
   If NewObjectRecord.DoorLock Then
      NewObjectRecord.Prefix1 = Strng3 + "FE"
      If NewObjectRecord.KeyNumber Then
         NewObjectRecord.Prefix1 = Strng3 + "FD"
      Endif
   Else
      If NewObjectRecord.RoomLink1 Then
         NewObjectRecord.Prefix1 = Strng3 + "FE"
         If NewObjectRecord.KeyNumber Then
            NewObjectRecord.Prefix1 = Strng3 + "FD"
         Endif
      Else
         If NewObjectRecord.LightRoom Then
            NewObjectRecord.Prefix1 = Strng3 + "FC"
         Else
            If NewObjectRecord.SwitchType Then
               NewObjectRecord.Prefix1 = Strng3 + "FB"
            Else
               If NewObjectRecord.JailTrap Then
                  NewObjectRecord.Prefix1 = Strng3 + "FA"
               Else
                  NewObjectRecord.Prefix1 = Strng3 + "F9"
               Endif
            Endif
         Endif
      Endif
   Endif
   PUT 2, Temp!, NewObjectRecord
NEXT
PRINT "Objects:"; Temp! - 1!
END IF
EndLoop2A:
' convert treasure
CLOSE
Filename1 = Var1$ + "\" + TreasureFilename$
Filename2 = Var2$ + "\" + TreasureFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldTreasureRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewTreasureRecLen
IF LOF(1) / OldTreasureRecLen3 > False THEN
Temp! = LOF(1) / OldTreasureRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad treasure file record length."
   Temp! = SFalse
   GOTO EndLoop3A
END IF
FOR Temp! = 1! TO LOF(1) / OldTreasureRecLen3
   GET 1, Temp!, OldTreasureRecord3
   NewTreasureRecord.TreasureName = OldTreasureRecord3.TreasureName
   NewTreasureRecord.ShortName = OldTreasureRecord3.ShortName
   NewTreasureRecord.Weight = OldTreasureRecord3.Weight
   NewTreasureRecord.Gold = OldTreasureRecord3.Gold
   NewTreasureRecord.Spell = OldTreasureRecord3.Spell
   NewTreasureRecord.Plus = ABS(OldTreasureRecord3.Plus)
   NewTreasureRecord.Coin = OldTreasureRecord3.Coin
   NewTreasureRecord.Locked = OldTreasureRecord3.Locked
   NewTreasureRecord.KeyNumber = Csng(OldTreasureRecord3.Keyed)
   NewTreasureRecord.Scroll = OldTreasureRecord3.Scroll
   NewTreasureRecord.Charges = OldTreasureRecord3.Charges
   NewTreasureRecord.Potion = OldTreasureRecord3.Potion
   NewTreasureRecord.Loadable = OldTreasureRecord3.Loadable
   NewTreasureRecord.Ammunition = OldTreasureRecord3.Ammunition
   NewTreasureRecord.AmmoLoads = OldTreasureRecord3.AmmoLoads
   NewTreasureRecord.Invisible = OldTreasureRecord3.Invisible
   NewTreasureRecord.Permanent = False
   NewTreasureRecord.StaysInRoom = False
   NewTreasureRecord.Proficiency = OldTreasureRecord3.Proficiency
   NewTreasureRecord.WeaponNumber = False
   IF OldTreasureRecord3.RingType THEN
      NewTreasureRecord.WeaponNumber = 4
   ELSE
      IF OldTreasureRecord3.Loadable = False THEN
         IF OldTreasureRecord3.Launchable = False THEN
            SELECT CASE OldTreasureRecord3.Type
            CASE False
               IF OldTreasureRecord3.Plus > False THEN ' weapon
                  NewTreasureRecord.WeaponNumber = 7
               END IF
            CASE IS < False ' shield
               NewTreasureRecord.WeaponNumber = 5
            CASE IS > False ' armor
               NewTreasureRecord.WeaponNumber = 1
            END SELECT
         END IF
      END IF
   END IF
   NewTreasureRecord.RingType = OldTreasureRecord3.RingType
   NewTreasureRecord.RingSpell = OldTreasureRecord3.RingSpell
   NewTreasureRecord.Edible = OldTreasureRecord3.Edible
   NewTreasureRecord.Rustable = OldTreasureRecord3.Rustable
   NewTreasureRecord.RustPercent = OldTreasureRecord3.RustPercent
   NewTreasureRecord.Stealable = OldTreasureRecord3.Stealable
   NewTreasureRecord.StealPercent = OldTreasureRecord3.StealPercent
   NewTreasureRecord.Launchable = OldTreasureRecord3.Launchable
   NewTreasureRecord.LaunchLoads = OldTreasureRecord3.LaunchLoads
   NewTreasureRecord.LaunchAmmo = OldTreasureRecord3.LaunchAmmo
   NewTreasureRecord.Movable = OldTreasureRecord3.Movable
   NewTreasureRecord.Vehicle = False
   NewTreasureRecord.VehicleType = False
   IF OldTreasureRecord3.Vehicle THEN
      NewTreasureRecord.WeaponNumber = False
      NewTreasureRecord.Vehicle = True
      SELECT CASE OldTreasureRecord3.VehicleType
      CASE 0, 1, 2, 3
         NewTreasureRecord.VehicleType = OldTreasureRecord3.VehicleType
      CASE ELSE
         NewTreasureRecord.VehicleType = 3
      END SELECT
      NewTreasureRecord.Proficiency = False
      NewTreasureRecord.Permanent = True
   END IF
   IF OldTreasureRecord3.VehicleHits > False THEN
      NewTreasureRecord.Charges = OldTreasureRecord3.VehicleHits
   END IF
   NewTreasureRecord.LightType = OldTreasureRecord3.LightType
   NewTreasureRecord.LightCharges = OldTreasureRecord3.LightCharges
   NewTreasureRecord.FuelType = OldTreasureRecord3.FuelType
   NewTreasureRecord.FuelCharges = OldTreasureRecord3.FuelCharges
   NewTreasureRecord.Container = False
   NewTreasureRecord.ContainerMax = False
   NewTreasureRecord.ContainerPrefix = Nul
   NewTreasureRecord.ContainerDisappears = False
   NewTreasureRecord.ContainerSize = False
   NewTreasureRecord.ContainerMaterial = False
   IF OldTreasureRecord3.Container THEN
      NewTreasureRecord.Container = True
      NewTreasureRecord.ContainerMax = 10
      NewTreasureRecord.ContainerPrefix = "in it"
      NewTreasureRecord.ContainerDisappears = False
      NewTreasureRecord.ContainerSelfImplodes=False
      NewTreasureRecord.ContainerSize = False
      NewTreasureRecord.ContainerMaterial = False
   END IF
   NewTreasureRecord.PotionType = False
   NewTreasureRecord.NewPotion = False
   NewTreasureRecord.MixPotion = False
   NewTreasureRecord.TwoHanded = False
   NewTreasureRecord.RequireStr = False
   NewTreasureRecord.RequireDex = False
   NewTreasureRecord.RequireInt = False
   For Var=1 To 3
      NewTreasureRecord.RestrictItem(Var)=SFalse
   Next
   NewTreasureRecord.TrapType=False
   NewTreasureRecord.TrapHits=False
   NewTreasureRecord.TrapItem=SFalse
   NewTreasureRecord.MasterKey=False
   NewTreasureRecord.Liquid=False
   NewTreasureRecord.LiquidType=False
   NewTreasureRecord.LiquidFlags=False
   NewTreasureRecord.Prefix1=Nul
   NewTreasureRecord.StaysInRoom=0
   NewTreasureRecord.Occupants=0
   NewTreasureRecord.BindType=0
   NewTreasureRecord.TimesCursed=0
   NewTreasureRecord.TimesBlessed=0
   NewTreasureRecord.Persistent=0
   NewTreasureRecord.MaxPersistCharges=0
   NewTreasureRecord.PersistTime=0!
   NewTreasureRecord.DischargePersist=0!
   NewTreasureRecord.ProperName=""
   Select Case NewTreasureRecord.WeaponNumber
   Case 0 ' treasure
      If NewTreasureRecord.Container Then
         NewTreasureRecord.Prefix1 = Strng3 + "FE"
      Else
         If NewTreasureRecord.Spell Then
            NewTreasureRecord.Prefix1 = Strng3 + "F5"
         Else
            If NewTreasureRecord.Coin Then
               NewTreasureRecord.Prefix1 = Strng3 + "F5"
            Else
               If NewTreasureRecord.Vehicle Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Loadable Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Ammunition Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.AmmoLoads Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Launchable Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.LaunchLoads Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.LaunchAmmo Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
            Endif
         Endif
      Endif
   Case 1 ' armor
      NewTreasureRecord.Prefix1 = Strng3 + "F9"
   Case 2 ' boots
      NewTreasureRecord.Prefix1 = Strng3 + "F1"
   Case 3 ' helmet
      NewTreasureRecord.Prefix1 = Strng3 + "F2"
   Case 4 ' ring(left)
      NewTreasureRecord.Prefix1 = Strng3 + "F3"
   Case 5 ' shield
      NewTreasureRecord.Prefix1 = Strng3 + "FA"
   Case 6 ' bracers
      NewTreasureRecord.Prefix1 = Strng3 + "F4"
   Case 7 ' weapon
      NewTreasureRecord.Prefix1 = Strng3 + "FB"
   Case 8 ' cloak
      NewTreasureRecord.Prefix1 = Strng3 + "FC"
   Case 9 ' ring(right)
      NewTreasureRecord.Prefix1 = Strng3 + "F3"
   Case 10 ' amulet
      NewTreasureRecord.Prefix1 = Strng3 + "FD"
   Case Else
      NewTreasureRecord.Prefix1 = Strng3 + "FF"
   End Select
   PUT 2, Temp!, NewTreasureRecord
NEXT
PRINT "Treasure:"; Temp! - 1!
END IF
EndLoop3A:
' convert spells
CLOSE
Filename1 = Var1$ + "\" + SpellsFilename$
Filename2 = Var2$ + "\" + SpellsFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldSpellRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewSpellRecLen
IF LOF(1) / OldSpellRecLen3 > False THEN
Temp! = LOF(1) / OldSpellRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad spell file record length."
   Temp! = SFalse
   GOTO EndLoop4A
END IF
FOR Temp! = 1! TO LOF(1) / OldSpellRecLen3
   GET 1, Temp!, OldSpellRecord3
   NewSpellRecord.SpellName = OldSpellRecord3.SpellName
   NewSpellRecord.Chant = OldSpellRecord3.Chant
   NewSpellRecord.Level = OldSpellRecord3.Level
   NewSpellRecord.SpellType = OldSpellRecord3.SpellType
   NewSpellRecord.Teleport = OldSpellRecord3.Teleport
   NewSpellRecord.Psionic = OldSpellRecord3.Psionic
   NewSpellRecord.PsionicMode = OldSpellRecord3.PsionicMode
   NewSpellRecord.ClassType = OldSpellRecord3.ClassType
   NewSpellRecord.Desc = OldSpellRecord3.Desc
   FOR Temp2 = 1 TO 5
      NewSpellRecord.Ingred(Temp2) = OldSpellRecord3.Ingred(Temp2)
   NEXT
   NewSpellRecord.SpellFlag = OldSpellRecord3.SpellFlag
   NewSpellRecord.SpellEquate = Nul
   NewSpellRecord.Equation = False
   NewSpellRecord.Prefix1 = ""
   Select Case NewSpellRecord.SpellType
   Case 1
      NewSpellRecord.Prefix1="{F9"
   Case 2
      NewSpellRecord.Prefix1="{FA"
   Case 3
      NewSpellRecord.Prefix1="{FF"
   Case 4
      NewSpellRecord.Prefix1="{FF"
   Case 5
      NewSpellRecord.Prefix1="{F5"
   Case 6
      NewSpellRecord.Prefix1="{FB"
   Case 7
      NewSpellRecord.Prefix1="{FC"
   Case 8
      NewSpellRecord.Prefix1="{FF"
   Case 9
      NewSpellRecord.Prefix1="{FD"
   Case 10
      NewSpellRecord.Prefix1="{FE"
   Case 11
      NewSpellRecord.Prefix1="{F6"
   Case 12
      NewSpellRecord.Prefix1="{FD"
   Case 13
      NewSpellRecord.Prefix1="{FE"
   Case 14
      NewSpellRecord.Prefix1="{F5"
   Case 15
      NewSpellRecord.Prefix1="{FA"
   Case 16
      NewSpellRecord.Prefix1="{F1"
   Case 17
      NewSpellRecord.Prefix1="{F1"
   Case 18
      NewSpellRecord.Prefix1="{F1"
   Case 19
      NewSpellRecord.Prefix1="{FA"
   Case 20
      NewSpellRecord.Prefix1="{F2"
   Case 21
      NewSpellRecord.Prefix1="{F2"
   Case 22
      NewSpellRecord.Prefix1="{F2"
   Case 23
      NewSpellRecord.Prefix1="{F3"
   Case 24
      NewSpellRecord.Prefix1="{F4"
   Case 25
      NewSpellRecord.Prefix1="{F4"
   Case 26
      NewSpellRecord.Prefix1="{F4"
   Case 27
      NewSpellRecord.Prefix1="{FA"
   Case 28
      NewSpellRecord.Prefix1="{FE"
   Case Else
      NewSpellRecord.Prefix1="{FF"
   End Select
   PUT 2, Temp!, NewSpellRecord
NEXT
PRINT "Spells:"; Temp! - 1!
END IF
EndLoop4A:
' convert monsters
CLOSE
Filename1 = Var1$ + "\" + MonstersFilename$
Filename2 = Var2$ + "\" + MonstersFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen3
IF LOF(1) / OldMonsterRecLen3 > False THEN
Temp! = LOF(1) / OldMonsterRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monster file record length."
   Temp! = SFalse
   GOTO EndLoop5A
END IF
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen3
   GET 1, Temp!, OldMonsterRecord3
   NewMonsterRecord.MonsterName = OldMonsterRecord3.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord3.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord3.Experience
   NewMonsterRecord.Gold = SFalse
   NewMonsterRecord.NumberAppearing = OldMonsterRecord3.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord3.Level
   NewMonsterRecord.Hits = OldMonsterRecord3.Hits
   NewMonsterRecord.Poison = OldMonsterRecord3.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord3.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord3.Spell
   NewMonsterRecord.Block = OldMonsterRecord3.Block
   NewMonsterRecord.Prevent = OldMonsterRecord3.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord3.Follow
   NewMonsterRecord.Magic = OldMonsterRecord3.Magic
   NewMonsterRecord.Jail = OldMonsterRecord3.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord3.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord3.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord3.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord3.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord3.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord3.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord3.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord3.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord3.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord3.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord3.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord3.PsionicSpell
   NewMonsterRecord.Equation = False
   NewMonsterRecord.MonsterEquate = Nul
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.Prefix1 = Nul
   If NewMonsterRecord.Level>=10 Then
      NewMonsterRecord.Prefix1 = Strng3 + "FE"
   Else
      If NewMonsterRecord.Spell Then
         NewMonsterRecord.Prefix1 = Strng3 + "FD"
      Else
         NewMonsterRecord.Prefix1 = Strng3 + "FC"
      Endif
   Endif
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert monster inventory
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen3
   GET 1, Temp!, OldMonsterRecord3
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord3.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord3
         Var2 = OldTreasureRecord3.Charges
         MessWorkRecord.Index = Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Monsters:"; Temp! - 1!
END IF
EndLoop5A:
' convert monster talk strings
CLOSE
Filename1 = Var1$ + "\" + MontalkFilename$
Filename2 = Var2$ + "\" + MontalkFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = BufferRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = BufferRecLen
IF LOF(1) / BufferRecLen > False THEN
FOR Temp1 = 1 TO LOF(1) / BufferRecLen
   GET 1, Temp1, BufferRecord
   PUT 2, Temp1, BufferRecord
NEXT
END IF
' convert nonplayers
CLOSE
Filename1 = Var1$ + "\" + NonplyrsFilename$
Filename2 = Var2$ + "\" + NonplyrsFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen3
IF LOF(1) / OldMonsterRecLen3 > False THEN
Temp! = LOF(1) / OldMonsterRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad nonplayer file record length."
   Temp! = SFalse
   GOTO EndLoop6A
END IF
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen3
   GET 1, Temp!, OldMonsterRecord3
   NewMonsterRecord.MonsterName = OldMonsterRecord3.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord3.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord3.Experience
   NewMonsterRecord.Gold = SFalse
   NewMonsterRecord.NumberAppearing = OldMonsterRecord3.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord3.Level
   NewMonsterRecord.Hits = OldMonsterRecord3.Hits
   NewMonsterRecord.Poison = OldMonsterRecord3.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord3.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord3.Spell
   NewMonsterRecord.Block = OldMonsterRecord3.Block
   NewMonsterRecord.Prevent = OldMonsterRecord3.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord3.Follow
   NewMonsterRecord.Magic = OldMonsterRecord3.Magic
   NewMonsterRecord.Jail = OldMonsterRecord3.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord3.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord3.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord3.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord3.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord3.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord3.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord3.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord3.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord3.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord3.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord3.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord3.PsionicSpell
   NewMonsterRecord.Equation = False
   NewMonsterRecord.MonsterEquate = Nul
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.Prefix1 = Nul
   If NewMonsterRecord.Level>=10 Then
      NewMonsterRecord.Prefix1 = Strng3 + "FB"
   Else
      If NewMonsterRecord.Spell Then
         NewMonsterRecord.Prefix1 = Strng3 + "FA"
      Else
         NewMonsterRecord.Prefix1 = Strng3 + "F9"
      Endif
   Endif
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert nonplayer inventory
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen3
   GET 1, Temp!, OldMonsterRecord3
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord3.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord3
         Var2 = OldTreasureRecord3.Charges
         MessWorkRecord.Index = -Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Nonplayers:"; Temp! - 1!
END IF
EndLoop6A:
' convert monster classes
CLOSE
Filename1 = Var1$ + "\" + MonclassFilename$
Filename2 = Var2$ + "\" + MonclassFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonClassRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonClassRecLen
IF LOF(1) / OldMonClassRecLen > False THEN
Temp! = LOF(1) / OldMonClassRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monclass file record length."
   Temp! = SFalse
   GOTO EndLoop7A
END IF
FOR Temp! = 1! TO LOF(1) / OldMonClassRecLen
   GET 1, Temp!, OldMonClassRecord
   FOR Temp2 = 1 TO 10
      NewMonClassRecord.Monsters(Temp2) = OldMonClassRecord.Monsters(Temp2)
   NEXT
   PUT 2, Temp!, NewMonClassRecord
NEXT
PRINT "Monclass:"; Temp! - 1!
END IF
EndLoop7A:
' convert rooms dnd29c4
CLOSE
Filename1 = Var1$ + "\" + RoomFilename$
Filename2 = Var2$ + "\" + RoomFilename2$
Filename3 = Var2$ + "\" + RoomInvFilename2$
Filename4 = Var2$ + "\" + RoomDescFilename2$
Filename5 = Var2$ + "\" + ContainerFilename2$
Filename6 = Var2$ + "\" + CtnInvFilename2$
Filename7 = Var1$ + "\" + TreasureFilename$
Filename8 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
IF DIR$(Filename4) <> Nul THEN
   KILL Filename4
END IF
IF DIR$(Filename5) <> Nul THEN
   KILL Filename5
END IF
IF DIR$(Filename6) <> Nul THEN
   KILL Filename6
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldRoomRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewRoomRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = BufferRecLen
OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewContainerRecLen
OPEN Filename6 FOR RANDOM SHARED AS #6 LEN = MessWorkRecLen
OPEN Filename7 FOR RANDOM SHARED AS #7 LEN = OldTreasureRecLen3
OPEN Filename8 FOR RANDOM SHARED AS #8 LEN = NewObjectRecLen
TempX! = SFalse
TempX2! = SFalse
TempX3! = SFalse
TempX4! = SFalse
IF LOF(1) / OldRoomRecLen3 > False THEN
Temp! = LOF(1) / OldRoomRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad room file record length."
   Temp! = SFalse
   GOTO EndLoop8C
END IF
FOR Temp! = 1! TO LOF(1) / OldRoomRecLen3
   GET 1, Temp!, OldRoomRecord3
   NewRoomRecord.Action = SFalse
   NewRoomRecord.Custom1 = Nul
   NewRoomRecord.Custom2 = Nul
   FOR Temp2 = 1 TO 14
      NewRoomRecord.Direct(Temp2) = False
   NEXT
   NewRoomRecord.Direct(1) = OldRoomRecord3.Direct(1) ' north
   NewRoomRecord.Direct(2) = OldRoomRecord3.Direct(2) ' east
   NewRoomRecord.Direct(3) = OldRoomRecord3.Direct(3) ' south
   NewRoomRecord.Direct(4) = OldRoomRecord3.Direct(4) ' west
   NewRoomRecord.Direct(5) = OldRoomRecord3.Direct(8) ' northeast
   NewRoomRecord.Direct(6) = OldRoomRecord3.Direct(9) ' southeast
   NewRoomRecord.Direct(7) = OldRoomRecord3.Direct(10) ' southwest
   NewRoomRecord.Direct(8) = OldRoomRecord3.Direct(11) ' northwest
   NewRoomRecord.Direct(9) = OldRoomRecord3.Direct(6) ' up
   NewRoomRecord.Direct(10) = OldRoomRecord3.Direct(7) ' down
   NewRoomRecord.Direct(12) = OldRoomRecord3.Direct(5) ' out
   FOR Temp2 = 1 TO 19
      NewRoomRecord.LongDesc(Temp2) = SFalse
   NEXT
   FOR Temp2 = 1 TO 4
      Var$ = OldRoomRecord3.LongDesc(Temp2)
      Var$ = LTRIM$(Var$)
      Var$ = RTRIM$(Var$)
      IF LEN(Var$) THEN
         IF Var$ <> String$(Len(Var$), 0) THEN
            Temp3! = LOF(4) / BufferRecLen + 1
            BufferRecord.Buffer = Var$
            PUT 4, Temp3!, BufferRecord
            NewRoomRecord.LongDesc(Temp2) = Temp3!
         END IF
      END IF
   NEXT
   NewRoomRecord.MonClass = OldRoomRecord3.MonsterClass
   NewRoomRecord.ShortDesc = OldRoomRecord3.ShortDesc
   NewRoomRecord.First = SFalse
   NewRoomRecord.Last = SFalse
   NewRoomRecord.First2 = SFalse
   NewRoomRecord.Last2 = SFalse
   PUT 2, Temp!, NewRoomRecord
   ' convert room objects
   FOR Var2 = 1 TO 10
      Var1 = OldRoomRecord3.Object(Var2)
      VarY = ABS(OldRoomRecord3.ObjCharges(Var2))
      VarY2 = OldRoomRecord3.Flags(Var2)
      IF Var1 THEN
         VarX! = -ABS(Var1)
         GOSUB Add.List.Item
         TempX3! = TempX3! + 1!
         ' store object room number
         VarX! = ABS(Var1)
         GET 8, VarX!, NewObjectRecord
         If NewObjectRecord.InitRoom = 0! Then
            NewObjectRecord.InitRoom = Temp!
         Else
            If NewObjectRecord.InitRoom2 = 0! Then
               NewObjectRecord.InitRoom2 = Temp!
            Endif
         Endif
         PUT 8, VarX!, NewObjectRecord
      END IF
   NEXT
   ' convert room treasure
   FOR Var2 = 1 TO 10
      Var3 = OldRoomRecord2.Treasure(Var2)
      IF Var3 > False THEN
         GET 7, Var3, OldTreasureRecord3
         IF OldTreasureRecord3.Container THEN
            ' convert container
            TempX! = TempX! + 1!
            NewContainerRecord.ContainerName = OldTreasureRecord3.TreasureName
            NewContainerRecord.ContainerShort = OldTreasureRecord3.ShortName
            NewContainerRecord.NamePrefix = "in it"
            NewContainerRecord.ContainerMax = 10
            NewContainerRecord.Closed = OldTreasureRecord3.Closed
            NewContainerRecord.Locked = OldTreasureRecord3.Locked
            NewContainerRecord.KeyNumber = Csng(OldTreasureRecord3.Keyed)
            NewContainerRecord.UserNumber = SFalse
            NewContainerRecord.RoomNumber = Temp!
            NewContainerRecord.DeletedContainer = False
            NewContainerRecord.InvisibleContainer = False
            NewContainerRecord.Weight = 1
            NewContainerRecord.WithinContainer = SFalse
            NewContainerRecord.Disappears = SFalse
            NewContainerRecord.ContainerIndex = SFalse
            NewContainerRecord.Size = False
            NewContainerRecord.Material = False
            NewContainerRecord.Permanent = False
            NewContainerRecord.SelfImplodes = False
            NewContainerRecord.Prefix1 = Strng3 + "FE"
            NewContainerRecord.SwapFlag = False
            NewContainerRecord.Damaged = False
            NewContainerRecord.First2 = SFalse
            NewContainerRecord.Last2 = SFalse
            NewContainerRecord.First = SFalse
            NewContainerRecord.Last = SFalse
            Temp3! = LOF(5) / NewContainerRecLen + 1!
            ' add container to rooms.dat list
            IF NewRoomRecord.First2 = SFalse THEN
               NewRoomRecord.First2 = Temp3!
               NewRoomRecord.Last2 = Temp3!
               PUT 2, Temp!, NewRoomRecord
               NewContainerRecord.Prev = SFalse
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
            ELSE
               NewContainerRecord.Prev = NewRoomRecord.Last2
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
               GET 5, NewRoomRecord.Last2, NewContainerRecord
               NewContainerRecord.Next = Temp3!
               PUT 5, NewRoomRecord.Last2, NewContainerRecord
               GET 5, Temp3!, NewContainerRecord
               NewRoomRecord.Last2 = Temp3!
               PUT 2, Temp!, NewRoomRecord
            END IF
            ' convert all container inventory
            CLOSE 9
            FileName9 = Var5$ + "\" + RTRIM$(OldTreasureRecord3.ContainerFileName) + CtnExt2$
            OPEN FileName9 FOR RANDOM SHARED AS #9 LEN = LEN(OldContainerRecord)
            FOR Var4 = 1 TO LOF(9) / OldContainerRecLen
               GET 9, Var4, OldContainerRecord
               Var1 = OldContainerRecord.Inv
               Var6 = OldContainerRecord.Charges
               Var5 = False
               IF OldContainerRecord.Invis THEN
                  Var5 = True
               END IF
               IF Var1 THEN
                  TempX4! = TempX4! + 1!
                  GOSUB Add.List.Item3
               END IF
            NEXT
         ELSE
            ' convert treasure
            Var1 = OldRoomRecord3.Treasure(Var2)
            VarY = ABS(OldRoomRecord3.TreCharges(Var2))
            VarY2 = OldRoomRecord3.Flags(Var2)
            VarX! = ABS(Var1)
            GOSUB Add.List.Item
            TempX2! = TempX2! + 1!
         END IF
      END IF
   NEXT
NEXT
PRINT "Rooms:"; Temp! - 1!
PRINT "Room objects:"; TempX3!
PRINT "Room treasure:"; TempX2!
PRINT "Room containers:"; TempX!
PRINT "Container inventory"; TempX4!
END IF
EndLoop8C:
' convert users dnd29c4
CLOSE
Filename1 = Var1$ + "\" + UsersFilename$
Filename2 = Var2$ + "\" + UsersFilename2$
Filename3 = Var2$ + "\" + UserInvFilename2$
Filename4 = Nul
Filename5 = Var2$ + "\" + ContainerFilename2$
Filename6 = Var2$ + "\" + CtnInvFilename2$
Filename7 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldUserRecLen3
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewUserRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen

OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewContainerRecLen
OPEN Filename6 FOR RANDOM SHARED AS #6 LEN = MessWorkRecLen
OPEN Filename7 FOR RANDOM SHARED AS #7 LEN = OldTreasureRecLen3
TempX! = SFalse
TempX2! = SFalse
TempX3! = SFalse
TempX4! = SFalse
IF LOF(1) / OldUserRecLen3 > False THEN
Temp! = LOF(1) / OldUserRecLen3
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad user file record length."
   Temp! = SFalse
   GOTO EndLoop9C
END IF
FOR Temp! = 1! TO LOF(1) / OldUserRecLen3
   GET 1, Temp!, OldUserRecord3
   Var$ = OldUserRecord3.CodeName
   CALL Decrypt(Var$)
   Var$=Rtrim$(Var$)
   Do
      Var=Instr(Var$," ")
      If Var=0 Then
         Exit Do
      Endif
      Mid$(Var$,Var,1)="_"
   Loop
   NewUserRecord.CodeName = Var$
   Var4$ = OldUserRecord3.PassWord
   CALL Decrypt(Var4$)
   Var4$ = LTRIM$(Var4$)
   Var4$ = RTRIM$(Var4$)
   Var4$ = UCASE$(Var4$)
   Var$ = Var4$
   CALL Cryptograph(Var$)
   NewUserRecord.PassWord = Var$
   Var$ = OldUserRecord3.ClassName
   CALL Decrypt(Var$)
   NewUserRecord.ClassName = Var$
   NewUserRecord.DateOn = DateS$
   NewUserRecord.ClassType = OldUserRecord3.ClassType
   NewUserRecord.PassWord2 = Nul
   NewUserRecord.Question = Nul
   NewUserRecord.Answer = Nul
   Var$ = Var4$
   CALL Crypto(Var$)
   NewUserRecord.PassWord3 = Var$
   FOR Temp2 = 1 TO 7
      NewUserRecord.Stats(Temp2) = OldUserRecord3.Stats(Temp2)
   NEXT
   FOR Temp2 = 1 TO 10
      NewUserRecord.Weapon(Temp2).Index = SFalse
      NewUserRecord.Weapon(Temp2).Charges = False
      NewUserRecord.Weapon(Temp2).Plus = False
   NEXT
   FOR Temp2 = 1 TO 4
      NewUserRecord.Weapons(Temp2) = OldUserRecord3.Weapons(Temp2)
   NEXT
   NewUserRecord.Room = OldUserRecord3.Room
   NewUserRecord.Level = OldUserRecord3.Level
   NewUserRecord.Experience = OldUserRecord3.Experience
   NewUserRecord.Gold = OldUserRecord3.Gold
   NewUserRecord.NumCalls = OldUserRecord3.NumCalls
   NewUserRecord.Fatigue = OldUserRecord3.Fatigue
   NewUserRecord.FatigueMax = OldUserRecord3.FatigueMax
   NewUserRecord.Vitality = OldUserRecord3.Vitality
   NewUserRecord.VitalityMax = OldUserRecord3.VitalityMax
   NewUserRecord.Magic = OldUserRecord3.Magic
   NewUserRecord.MagicMax = OldUserRecord3.MagicMax
   NewUserRecord.Poison = OldUserRecord3.Poison
   NewUserRecord.Borrow = OldUserRecord3.Borrow
   NewUserRecord.Invisible = OldUserRecord3.Invisible
   NewUserRecord.Race = OldUserRecord3.Race
   NewUserRecord.Proficiency = OldUserRecord3.Proficiency
   NewUserRecord.Bank = OldUserRecord3.Bank
   TotalBank = TotalBank + OldUserRecord.Bank
   NewUserRecord.PlayersKilled = False
   NewUserRecord.MonstersKilled = OldUserRecord3.MonstersKilled
   NewUserRecord.Brief = OldUserRecord3.Brief
   NewUserRecord.Beauty = OldUserRecord3.Beauty
   NewUserRecord.Glamour = OldUserRecord3.Glamour
   NewUserRecord.Psionic = OldUserRecord3.Psionic
   NewUserRecord.PsionicMax = OldUserRecord3.PsionicMax
   NewUserRecord.Align1 = OldUserRecord3.Align1
   NewUserRecord.Align2 = OldUserRecord3.Align2
   NewUserRecord.Flags = OldUserRecord3.Flags
   NewUserRecord.Flags2 = False
   NewUserRecord.MaxCalls = OldUserRecord3.MaxCalls
   NewUserRecord.FromHour = OldUserRecord3.FromHour
   NewUserRecord.FromMin = OldUserRecord3.FromMin
   NewUserRecord.ToHour = OldUserRecord3.ToHour
   NewUserRecord.ToMin = OldUserRecord3.ToMin
   NewUserRecord.SortInv = False
   NewUserRecord.TimeUsed = SFalse
   NewUserRecord.TimeLimit = SFalse
   NewUserRecord.Hidden = False
   NewUserRecord.Encumbrance = 10
   NewUserRecord.TimesLogon = 0#
   NewUserRecord.TimesDied = 0#
   NewUserRecord.Prefix1 = ""
   NewUserRecord.Prefix2 = ""
   NewUserRecord.Prefix3 = ""
   For Temp2=1 to 8
      NewUserRecord.ShortcutKey1(Temp2)=""
      NewUserRecord.ShortcutKey2(Temp2)=""
   Next
   For Temp2=1 To 10
      NewUserRecord.FunctionKeys(Temp2)=""
   Next
   NewUserRecord.ActionLineString = ""
   NewUserRecord.StatusLineString = ""
   NewUserRecord.StatusVar = 0
   NewUserRecord.First = SFalse
   NewUserRecord.Last = SFalse
   NewUserRecord.First2 = SFalse
   NewUserRecord.Last2 = SFalse
   NewUserRecord.NodeList=String$(127,"1")
   NewUserRecord.NodeList2=0!
   NewUserRecord.EditList=0!
   PUT 2, Temp!, NewUserRecord
   ' convert user inventory
   FOR Var2 = 1 TO 5
      Var3 = OldUserRecord3.Object(Var2)
      IF Var3 THEN ' object
         VarY = ABS(OldUserRecord3.ObjCharges(Var2))
         VarY2 = False
         VarX! = -ABS(Var3) ' reverse
         GOSUB Add.List.Item2
         TempX3! = TempX3! + 1!
      END IF
   NEXT
   ' convert user inventory
   FOR Var2 = 1 TO 15
      Var3 = OldUserRecord3.Inv(Var2)
      IF Var3 THEN ' treasure
         Var3 = ABS(Var3) ' reverse
         GET 7, Var3, OldTreasureRecord3
         IF OldTreasureRecord3.Container THEN
            ' convert container
            TempX! = TempX! + 1!
            NewContainerRecord.ContainerName = OldTreasureRecord3.TreasureName
            NewContainerRecord.ContainerShort = OldTreasureRecord3.ShortName
            NewContainerRecord.NamePrefix = "in it"
            NewContainerRecord.ContainerMax = 10
            NewContainerRecord.Closed = OldTreasureRecord3.Closed
            NewContainerRecord.Locked = OldTreasureRecord3.Locked
            NewContainerRecord.KeyNumber = Csng(OldTreasureRecord3.Keyed)
            NewContainerRecord.UserNumber = SFalse
            NewContainerRecord.RoomNumber = Temp!
            NewContainerRecord.DeletedContainer = False
            NewContainerRecord.InvisibleContainer = False
            NewContainerRecord.Weight = 1
            NewContainerRecord.WithinContainer = SFalse
            NewContainerRecord.Disappears = SFalse
            NewContainerRecord.ContainerIndex = SFalse
            NewContainerRecord.Size = False
            NewContainerRecord.Material = False
            NewContainerRecord.Permanent = False
            NewContainerRecord.SelfImplodes = False
            NewContainerRecord.Prefix1 = Strng3 + "FE"
            NewContainerRecord.SwapFlag = False
            NewContainerRecord.Damaged = False
            NewContainerRecord.First2 = SFalse
            NewContainerRecord.Last2 = SFalse
            NewContainerRecord.First = SFalse
            NewContainerRecord.Last = SFalse
            Temp3! = LOF(5) / NewContainerRecLen + 1!
            ' add container to users.dat list
            IF NewUserRecord.First2 = SFalse THEN
               NewUserRecord.First2 = Temp3!
               NewUserRecord.Last2 = Temp3!
               PUT 2, Temp!, NewUserRecord
               NewContainerRecord.Prev = SFalse
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
            ELSE
               NewContainerRecord.Prev = NewRoomRecord.Last2
               NewContainerRecord.Next = SFalse
               PUT 5, Temp3!, NewContainerRecord
               GET 5, NewUserRecord.Last2, NewContainerRecord
               NewContainerRecord.Next = Temp3!
               PUT 5, NewUserRecord.Last2, NewContainerRecord
               GET 5, Temp3!, NewContainerRecord
               NewUserRecord.Last2 = Temp3!
               PUT 2, Temp!, NewUserRecord
            END IF
            ' convert all container inventory
            CLOSE 8
            FileName8 = Var5$ + "\" + RTRIM$(OldTreasureRecord3.ContainerFileName) + CtnExt2$
            OPEN FileName8 FOR RANDOM SHARED AS #8 LEN = LEN(OldContainerRecord)
            FOR Var4 = 1 TO LOF(8) / OldContainerRecLen
               GET 8, Var4, OldContainerRecord
               Var1 = OldContainerRecord.Inv
               Var6 = OldContainerRecord.Charges
               Var5 = False
               IF OldContainerRecord.Invis THEN
                  Var5 = True
               END IF
               IF Var1 THEN
                  TempX4! = TempX4! + 1!
                  GOSUB Add.List.Item3
               END IF
            NEXT
         ELSE
            ' convert treasure
            VarY = ABS(OldUserRecord3.Charges(Var2))
            VarY2 = False
            VarX! = ABS(Var3)
            GOSUB Add.List.Item2
            TempX2! = TempX2! + 1!
         END IF
      END IF
   NEXT
NEXT
PRINT "Users:"; Temp! - 1!
PRINT "User objects:"; TempX3!
PRINT "User treasure:"; TempX2!
PRINT "User containers:"; TempX!
PRINT "Container inventory:"; TempX4!
END IF
EndLoop9C:
TempX! = SFalse
 RETURN

Convert4:
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen
IF LOF(1) / OldMonsterRecLen > False THEN
Temp! = LOF(1) / OldMonsterRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monster file record length."
   Temp! = SFalse
   GOTO EndLoop5
END IF
Temp2! = 0!
FOR Temp! = 5! TO LOF(1) / OldMonsterRecLen
   GET 1, Temp!, OldMonsterRecord
   Temp2! = Temp2! + 1!
   NewMonsterRecord.MonsterName = OldMonsterRecord.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord.Experience
   'NewMonsterRecord.Gold = OldMonsterRecord.Gold
   NewMonsterRecord.NumberAppearing = OldMonsterRecord.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord.Level
   NewMonsterRecord.Hits = OldMonsterRecord.Hits
   NewMonsterRecord.Poison = OldMonsterRecord.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord.Spell
   NewMonsterRecord.Block = OldMonsterRecord.Block
   NewMonsterRecord.Prevent = OldMonsterRecord.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord.Follow
   NewMonsterRecord.Magic = OldMonsterRecord.Magic
   NewMonsterRecord.Jail = OldMonsterRecord.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord.PsionicSpell
   NewMonsterRecord.Equation = False
   NewMonsterRecord.MonsterEquate = Nul
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp2!, NewMonsterRecord
NEXT
TempX! = Temp2!
' convert monster inventory
Temp2! = 0!
FOR Temp! = 5! TO LOF(1) / OldMonsterRecLen
   GET 1, Temp!, OldMonsterRecord
   Temp2! = Temp2! + 1!
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord
         Var2 = OldTreasureRecord.Charges
         MessWorkRecord.Index = Temp2!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp2!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp2!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp2!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Monsters:"; TempX!
END IF
EndLoop5:
RETURN

Convert5:
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen2
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen
IF LOF(1) / OldMonsterRecLen2 > False THEN
Temp! = LOF(1) / OldMonsterRecLen2
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monster file record length."
   Temp! = SFalse
   GOTO EndLoopA
END IF
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen2
   GET 1, Temp!, OldMonsterRecord2
   NewMonsterRecord.MonsterName = OldMonsterRecord2.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord2.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord2.Experience
   'NewMonsterRecord.Gold = OldMonsterRecord2.Gold
   NewMonsterRecord.NumberAppearing = OldMonsterRecord2.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord2.Level
   NewMonsterRecord.Hits = OldMonsterRecord2.Hits
   NewMonsterRecord.Poison = OldMonsterRecord2.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord2.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord2.Spell
   NewMonsterRecord.Block = OldMonsterRecord2.Block
   NewMonsterRecord.Prevent = OldMonsterRecord2.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord2.Follow
   NewMonsterRecord.Magic = OldMonsterRecord2.Magic
   NewMonsterRecord.Jail = OldMonsterRecord2.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord2.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord2.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord2.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord2.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord2.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord2.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord2.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord2.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord2.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord2.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord2.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord2.PsionicSpell
   NewMonsterRecord.Equation = OldMonsterRecord2.Equation
   NewMonsterRecord.MonsterEquate = OldMonsterRecord2.MonsterEquate
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert monster inventory
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen2
   GET 1, Temp!, OldMonsterRecord2
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord2.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord
         Var2 = OldTreasureRecord.Charges
         MessWorkRecord.Index = Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Monsters:"; Temp! - 1!
END IF
EndLoopA:
RETURN

' dnd27a Nonplyrs.dat is first 4 monsters.dat
Convert6:
CLOSE
Filename1 = Var1$ + "\" + MonstersFilename$
Filename2 = Var2$ + "\" + NonplyrsFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen
IF LOF(1) / OldMonsterRecLen > False THEN
Temp! = LOF(1) / OldMonsterRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad nonplayer file record length."
   Temp! = SFalse
   GOTO EndLoop6
END IF
FOR Temp! = 1! TO 4!
   GET 1, Temp!, OldMonsterRecord
   NewMonsterRecord.MonsterName = OldMonsterRecord.MonsterName
   Select Case Temp!
   Case 1!
      NewMonsterRecord.PluralName = "2,219"
   Case 2!
      NewMonsterRecord.PluralName = "19,145"
   Case 3!
      NewMonsterRecord.PluralName = "147"
   Case 4!
      NewMonsterRecord.PluralName = "619"
   End Select
   NewMonsterRecord.Experience = OldMonsterRecord.Experience
   'NewMonsterRecord.Gold = OldMonsterRecord.Gold
   NewMonsterRecord.NumberAppearing = OldMonsterRecord.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord.Level
   NewMonsterRecord.Hits = OldMonsterRecord.Hits
   NewMonsterRecord.Poison = OldMonsterRecord.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord.Spell
   NewMonsterRecord.Block = OldMonsterRecord.Block
   NewMonsterRecord.Prevent = OldMonsterRecord.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord.Follow
   NewMonsterRecord.Magic = OldMonsterRecord.Magic
   NewMonsterRecord.Jail = OldMonsterRecord.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord.PsionicSpell
   NewMonsterRecord.Equation = False
   NewMonsterRecord.MonsterEquate = Nul
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert nonplayer inventory
FOR Temp! = 1! TO 4!
   GET 1, Temp!, OldMonsterRecord
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord
         Var2 = OldTreasureRecord.Charges
         MessWorkRecord.Index = -Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Nonplayers:"; Temp! - 1!
END IF
EndLoop6:
RETURN

Convert7:
CLOSE
Filename1 = Var1$ + "\" + NonplyrsFilename$
Filename2 = Var2$ + "\" + NonplyrsFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\" + TreasureFilename$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen2
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen
IF LOF(1) / OldMonsterRecLen2 > False THEN
Temp! = LOF(1) / OldMonsterRecLen2
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad nonplayer file record length."
   Temp! = SFalse
   GOTO EndLoopB
END IF
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen2
   GET 1, Temp!, OldMonsterRecord2
   NewMonsterRecord.MonsterName = OldMonsterRecord2.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord2.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord2.Experience
   'NewMonsterRecord.Gold = OldMonsterRecord2.Gold
   NewMonsterRecord.NumberAppearing = OldMonsterRecord2.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord2.Level
   NewMonsterRecord.Hits = OldMonsterRecord2.Hits
   NewMonsterRecord.Poison = OldMonsterRecord2.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord2.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord2.Spell
   NewMonsterRecord.Block = OldMonsterRecord2.Block
   NewMonsterRecord.Prevent = OldMonsterRecord2.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord2.Follow
   NewMonsterRecord.Magic = OldMonsterRecord2.Magic
   NewMonsterRecord.Jail = OldMonsterRecord2.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord2.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord2.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord2.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord2.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord2.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord2.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord2.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord2.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord2.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord2.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord2.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord2.PsionicSpell
   NewMonsterRecord.Equation = OldMonsterRecord2.Equation
   NewMonsterRecord.MonsterEquate = OldMonsterRecord2.MonsterEquate
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert nonplayer inventory
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen2
   GET 1, Temp!, OldMonsterRecord2
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord2.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord
         Var2 = OldTreasureRecord.Charges
         MessWorkRecord.Index = -Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Nonplayers:"; Temp! - 1!
END IF
EndLoopB:
RETURN

' convert mail
Convert8:
Var2$ = DataPath2$
SELECT CASE OldVersion
CASE 1 ' dnd27a
   PRINT "Processing mail.."
   CLOSE
   Filename1 = Var1$ + "\PUBMESS.DAT"
   Filename2 = Var2$ + "\" + PublicFilename2$ + ".DAT"
   Filename3 = Var2$ + "\" + PublicFilename2$ + ".NEW"
   IF DIR$(Filename3) <> Nul THEN
      KILL Filename3
   END IF
   GOSUB CopyMailData
   CLOSE
   Filename1 = Var1$ + "\PRIMESS.DAT"
   Filename2 = Var2$ + "\" + PrivateFilename2$ + ".DAT"
   Filename3 = Var2$ + "\" + PrivateFilename2$ + ".NEW"
   IF DIR$(Filename3) <> Nul THEN
      KILL Filename3
   END IF
   GOSUB CopyMailData
   Filename1 = Var1$ + "\PUBTABLE.DAT"
   Filename2 = Var2$ + "\" + PublicFilename2$ + ".TBL"
   GOSUB CopyMailTable
   Filename1 = Var1$ + "\PRITABLE.DAT"
   Filename2 = Var2$ + "\" + PrivateFilename2$ + ".TBL"
   GOSUB CopyMailTable
CASE ELSE ' dnd29c1/29c4/29d1
   PRINT "Processing mail.."
   IF OldVersion = 3 THEN
      Var1$ = Var6$
   END IF
   Filename1 = Var1$ + "\" + PublicFilename$ + ".DAT"
   Filename2 = Var2$ + "\" + PublicFilename2$ + ".DAT"
   GOSUB CopyMailData
   Filename1 = Var1$ + "\" + PrivateFilename$ + ".DAT"
   Filename2 = Var2$ + "\" + PrivateFilename2$ + ".DAT"
   GOSUB CopyMailData
   Filename1 = Var1$ + "\" + PublicFilename$ + ".TBL"
   Filename2 = Var2$ + "\" + PublicFilename2$ + ".TBL"
   GOSUB CopyMailTable
   Filename1 = Var1$ + "\" + PrivateFilename$ + ".TBL"
   Filename2 = Var2$ + "\" + PrivateFilename2$ + ".TBL"
   GOSUB CopyMailTable
   Filename1 = Var1$ + "\" + PublicFilename$ + ".NEW"
   Filename2 = Var2$ + "\" + PublicFilename2$ + ".NEW"
   GOSUB CopyMailNew
   Filename1 = Var1$ + "\" + PrivateFilename$ + ".NEW"
   Filename2 = Var2$ + "\" + PrivateFilename2$ + ".NEW"
   GOSUB CopyMailNew
   ' process message base datafile.
   Filename1 = Var1$ + "\" + MessbaseFilename$
   Filename2 = Var2$ + "\" + MessbaseFilename2$
   CLOSE
   IF DIR$(Filename2) <> Nul THEN
      KILL Filename2
   END IF
   OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMessageBaseRecLen1
   OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMessageBaseRecLen
   IF LOF(1) / OldMessageBaseRecLen1 > False THEN
      Temp! = LOF(1) / OldMessageBaseRecLen1
      IF INT(Temp!) <> Temp! THEN
         Temp! = SFalse
         RETURN
      END IF
      FOR Temp! = 1! TO LOF(1) / OldMessageBaseRecLen1
         GET 1, Temp!, OldMessageBaseRecord1
         NewMessageBaseRecord.BaseDeleted = False
         NewMessageBaseRecord.BaseFileName = OldMessageBaseRecord1.BaseFileName
         NewMessageBaseRecord.BaseMessName = OldMessageBaseRecord1.BaseMessName
         NewMessageBaseRecord.BaseType = OldMessageBaseRecord1.BaseType
         PUT 2, Temp!, NewMessageBaseRecord
      NEXT
   END IF
   ' process mail datafiles in messagebase file.
   CLOSE
   Filename3 = Var2$ + "\" + MessbaseFilename2$
   OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = NewMessageBaseRecLen
   IF LOF(3) / NewMessageBaseRecLen > False THEN
      FOR TempX! = 1! TO LOF(3) / NewMessageBaseRecLen
         GET 3, TempX!, NewMessageBaseRecord
         Filename1 = Var1$ + "\" + RTRIM$(NewMessageBaseRecord.BaseFileName) + ".DAT"
         Filename2 = Var2$ + "\" + RTRIM$(NewMessageBaseRecord.BaseFileName) + ".DAT"
         GOSUB CopyMailData
         Filename1 = Var1$ + "\" + RTRIM$(NewMessageBaseRecord.BaseFileName) + ".TBL"
         Filename2 = Var2$ + "\" + RTRIM$(NewMessageBaseRecord.BaseFileName) + ".TBL"
         GOSUB CopyMailTable
         Filename1 = Var1$ + "\" + RTRIM$(NewMessageBaseRecord.BaseFileName) + ".NEW"
         Filename2 = Var2$ + "\" + RTRIM$(NewMessageBaseRecord.BaseFileName) + ".NEW"
         GOSUB CopyMailNew
      NEXT
   END IF
END SELECT
RETURN

' process mail message datafile.
CopyMailData:
 CLOSE 1, 2
 IF DIR$(Filename2) <> Nul THEN
    KILL Filename2
 END IF
 OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMessageRecLen1
 OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMessageRecLen
 IF LOF(1) / OldMessageRecLen1 > False THEN
    Temp! = LOF(1) / OldMessageRecLen1
    IF INT(Temp!) <> Temp! THEN
       Temp! = SFalse
       RETURN
    END IF
    FOR Temp! = 1! TO LOF(1) / OldMessageRecLen1
       GET 1, Temp!, OldMessageRecord1
       Var$ = OldMessageRecord1.Message
       Var$ = RTRIM$(Var$)
       IF RIGHT$(Var$, 1) = CHR$(1) THEN
          Var$ = LEFT$(Var$, LEN(Var$) - 1)
       END IF
       CALL Valid(Var$, 80)
       CALL Crypto(Var$)
       NewMessageRecord.Message = Var$
       PUT 2, Temp!, NewMessageRecord
    NEXT
 END IF
 RETURN

' copy mail table datafile.
CopyMailTable:
 CLOSE 1, 2
 IF DIR$(Filename2) <> Nul THEN
    KILL Filename2
 END IF
 OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldTableRecLen1
 OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewTableRecLen
 IF LOF(1) / OldTableRecLen1 > False THEN
    Temp! = LOF(1) / OldTableRecLen1
    IF INT(Temp!) <> Temp! THEN
       Temp! = SFalse
       RETURN
    END IF
    FOR Temp! = 1! TO LOF(1) / OldTableRecLen1
       GET 1, Temp!, OldTableRecord1
       NewTableRecord.ClassType = 1
       NewTableRecord.Clock = OldTableRecord1.MessageTime
       NewTableRecord.Date = "01-01-1980"
       NewTableRecord.Flags = False
       NewTableRecord.from = OldTableRecord1.MessageFrom
       IF OldTableRecord1.MessageKilled = "T" THEN
          NewTableRecord.Killed = True
       ELSE
          NewTableRecord.Killed = False
       END IF
       NewTableRecord.Length = OldTableRecord1.MessageLength
       NewTableRecord.Private = False
       NewTableRecord.Received = False
       NewTableRecord.Reply = False
       NewTableRecord.Start = OldTableRecord1.MessageStart
       NewTableRecord.Subject = OldTableRecord1.MessageSubject
       NewTableRecord.Thread = SFalse
       NewTableRecord.Time = "12:00:00"
       NewTableRecord.Timer = SFalse
       NewTableRecord.TimesRead = False
       NewTableRecord.To = OldTableRecord1.MessageTo
       PUT 2, Temp!, NewTableRecord
    NEXT
 END IF
 RETURN

' copy mail new datafile.
CopyMailNew:
 CLOSE 1, 2
 IF DIR$(Filename2) <> Nul THEN
    KILL Filename2
 END IF
 OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldLastreadRecLen1
 OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewLastreadRecLen
 IF LOF(1) / OldLastreadRecLen1 > False THEN
    Temp! = LOF(1) / OldLastreadRecLen1
    IF INT(Temp!) <> Temp! THEN
       Temp! = SFalse
       RETURN
    END IF
    FOR Temp! = 1! TO LOF(1) / OldLastreadRecLen1
       GET 1, Temp!, OldLastreadRecord1
       NewLastreadRecord.LastMessage = OldLastreadRecord1.LastMessage
       PUT 2, Temp!, NewLastreadRecord
    NEXT
 END IF
 RETURN

' reads filenames and datapaths from source .cfg file
Read.Config:
 IF Node1$ = Nul THEN
    ConfigFilename$ = Var1$ + "\DNDBBS.CFG"
 ELSE
    ConfigFilename$ = Var1$ + "\DNDBBS" + Node1$ + ".CFG"
 END IF
 IF DIR$(ConfigFilename$) = Nul THEN
    Color 15, 0
    PRINT "Unable to open: "; ConfigFilename$
    If OldVersion = 4 Then
       Print "Specify node on command line with /s:n"
    Endif
    Color 14, 0
    PRINT "Exiting to system.."
    COLOR 7, 0
    END
 END IF
 CLOSE
 SELECT CASE OldVersion
 CASE 1
 ' dnd27a .cfg file
 Var5$ = Var1$
 OPEN ConfigFilename$ FOR INPUT AS #1
 FOR Temp = 1 TO 40
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 10
    LINE INPUT #1, Var$
 NEXT
 FOR Temp = 1 TO 30
    INPUT #1, Var!
 NEXT
 FOR Temp = 1 TO 66
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 77
    LINE INPUT #1, Var$
    SELECT CASE Temp
    CASE 11 ' datapath
       Var1$ = Var$
       IF RIGHT$(Var1$, 1) = "\" THEN
          Var1$ = LEFT$(Var1$, LEN(Var1$) - 1)
       END IF
    CASE 12 ' monclass
       MonclassFilename$ = Var$
    CASE 13 ' montalk
       MontalkFilename$ = Var$
    CASE 15 ' .dat
       DataExt1$ = Var$
    CASE 16 ' rooms
       RoomFilename$ = Var$
    CASE 17 ' objects
       ObjectFilename$ = Var$
    CASE 18 ' monsters
       MonstersFilename$ = Var$
    CASE 19 ' treasure
       TreasureFilename$ = Var$
    CASE 20 ' spells
       SpellsFilename$ = Var$
    CASE 21 ' users
       UsersFilename$ = Var$
    CASE 22 ' nonplyrs?
       NonplyrsFilename$ = "NONPLYRS"
    CASE 57 ' .ctn?
       CtnExt2$ = ".CTN"
    CASE 58 ' public?
    CASE 59 ' messbase?
    CASE 60 ' private?
    END SELECT
 NEXT
 MonclassFilename$ = MonclassFilename$ + DataExt1$
 MontalkFilename$ = MontalkFilename$ + DataExt1$
 RoomFilename$ = RoomFilename$ + DataExt1$
 ObjectFilename$ = ObjectFilename$ + DataExt1$
 MonstersFilename$ = MonstersFilename$ + DataExt1$
 TreasureFilename$ = TreasureFilename$ + DataExt1$
 SpellsFilename$ = SpellsFilename$ + DataExt1$
 UsersFilename$ = UsersFilename$ + DataExt1$
 NonplyrsFilename$ = NonplyrsFilename$ + DataExt1$
 CASE 2
 ' dnd29c1 .cfg file
 Var5$ = Var1$
 OPEN ConfigFilename$ FOR INPUT AS #1
 FOR Temp = 1 TO 40
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 10
    LINE INPUT #1, Var$
 NEXT
 FOR Temp = 1 TO 30
    INPUT #1, Var!
 NEXT
 FOR Temp = 1 TO 83
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 77
    LINE INPUT #1, Var$
    SELECT CASE Temp
    CASE 11 ' datapath
       Var1$ = Var$
       IF RIGHT$(Var1$, 1) = "\" THEN
          Var1$ = LEFT$(Var1$, LEN(Var1$) - 1)
       END IF
    CASE 12 ' monclass
       MonclassFilename$ = Var$
    CASE 13 ' montalk
       MontalkFilename$ = Var$
    CASE 15 ' .dat
       DataExt1$ = Var$
    CASE 16 ' rooms
       RoomFilename$ = Var$
    CASE 17 ' objects
       ObjectFilename$ = Var$
    CASE 18 ' monsters
       MonstersFilename$ = Var$
    CASE 19 ' treasure
       TreasureFilename$ = Var$
    CASE 20 ' spells
       SpellsFilename$ = Var$
    CASE 21 ' users
       UsersFilename$ = Var$
    CASE 22 ' nonplyrs
       NonplyrsFilename$ = Var$
    CASE 57 ' .ctn
       CtnExt2$ = Var$
    CASE 58 ' public
       PublicFilename$ = Var$
    CASE 59 ' messbase
       MessbaseFilename$ = Var$
    CASE 60 ' private
       PrivateFilename$ = Var$
    END SELECT
 NEXT
 MonclassFilename$ = MonclassFilename$ + DataExt1$
 MontalkFilename$ = MontalkFilename$ + DataExt1$
 RoomFilename$ = RoomFilename$ + DataExt1$
 ObjectFilename$ = ObjectFilename$ + DataExt1$
 MonstersFilename$ = MonstersFilename$ + DataExt1$
 TreasureFilename$ = TreasureFilename$ + DataExt1$
 SpellsFilename$ = SpellsFilename$ + DataExt1$
 UsersFilename$ = UsersFilename$ + DataExt1$
 NonplyrsFilename$ = NonplyrsFilename$ + DataExt1$
 MessbaseFilename$ = MessbaseFilename$ + DataExt1$
 CASE 3
 ' dnd29c4 .cfg file
 OPEN ConfigFilename$ FOR INPUT AS #1
 FOR Temp = 1 TO 40
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 10
    LINE INPUT #1, Var$
 NEXT
 FOR Temp = 1 TO 30
    INPUT #1, Var!
 NEXT
 FOR Temp = 1 TO 85
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 77
    LINE INPUT #1, Var$
    SELECT CASE Temp
    CASE 11 ' datapath
       Var1$ = Var$
       IF RIGHT$(Var1$, 1) = "\" THEN
          Var1$ = LEFT$(Var1$, LEN(Var1$) - 1)
       END IF
    CASE 12 ' monclass
       MonclassFilename$ = Var$
    CASE 13 ' montalk
       MontalkFilename$ = Var$
    CASE 15 ' .dat
       DataExt1$ = Var$
    CASE 16 ' rooms
       RoomFilename$ = Var$
    CASE 17 ' objects
       ObjectFilename$ = Var$
    CASE 18 ' monsters
       MonstersFilename$ = Var$
    CASE 19 ' treasure
       TreasureFilename$ = Var$
    CASE 20 ' spells
       SpellsFilename$ = Var$
    CASE 21 ' users
       UsersFilename$ = Var$
    CASE 22 ' nonplyrs
       NonplyrsFilename$ = Var$
    CASE 51 ' receptacle datapath
       Var5$ = Var$
       IF RIGHT$(Var5$, 1) = "\" THEN
          Var5$ = LEFT$(Var5$, LEN(Var5$) - 1)
       END IF
    CASE 54 ' message datapath
       Var6$ = Var$
       IF RIGHT$(Var6$, 1) = "\" THEN
          Var6$ = LEFT$(Var6$, LEN(Var6$) - 1)
       END IF
    CASE 57 ' .ctn
       CtnExt2$ = Var$
    CASE 58 ' public
       PublicFilename$ = Var$
    CASE 59 ' messbase
       MessbaseFilename$ = Var$
    CASE 60 ' private
       PrivateFilename$ = Var$
    END SELECT
 NEXT
 MonclassFilename$ = MonclassFilename$ + DataExt1$
 MontalkFilename$ = MontalkFilename$ + DataExt1$
 RoomFilename$ = RoomFilename$ + DataExt1$
 ObjectFilename$ = ObjectFilename$ + DataExt1$
 MonstersFilename$ = MonstersFilename$ + DataExt1$
 TreasureFilename$ = TreasureFilename$ + DataExt1$
 SpellsFilename$ = SpellsFilename$ + DataExt1$
 UsersFilename$ = UsersFilename$ + DataExt1$
 NonplyrsFilename$ = NonplyrsFilename$ + DataExt1$
 MessbaseFilename$ = MessbaseFilename$ + DataExt1$
 CASE 4
 ' dnd29d1 .cfg file
 Var5$ = Var1$
 OPEN ConfigFilename$ FOR INPUT AS #1
 FOR Temp = 1 TO 40
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 10
    LINE INPUT #1, Var$
 NEXT
 FOR Temp = 1 TO 30
    INPUT #1, Var!
 NEXT
 FOR Temp = 1 TO 85
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 77
    LINE INPUT #1, Var$
    SELECT CASE Temp
    CASE 11 ' datapath
       Var1$ = Var$
       IF RIGHT$(Var1$, 1) = "\" THEN
          Var1$ = LEFT$(Var1$, LEN(Var1$) - 1)
       END IF
    CASE 12 ' monclass
       MonclassFilename$ = Var$
    CASE 13 ' montalk
       MontalkFilename$ = Var$
    CASE 15 ' .dat
       DataExt1$ = Var$
    CASE 16 ' rooms
       RoomFilename$ = Var$
    CASE 17 ' objects
       ObjectFilename$ = Var$
    CASE 18 ' monsters
       MonstersFilename$ = Var$
    CASE 19 ' treasure
       TreasureFilename$ = Var$
    CASE 20 ' spells
       SpellsFilename$ = Var$
    CASE 21 ' users
       UsersFilename$ = Var$
    CASE 22 ' nonplyrs
       NonplyrsFilename$ = Var$
    CASE 57 ' .ctn
       CtnExt2$ = Var$
    CASE 58 ' public
       PublicFilename$ = Var$
    CASE 59 ' messbase
       MessbaseFilename$ = Var$
    CASE 60 ' private
       PrivateFilename$ = Var$
    END SELECT
 NEXT
 MonclassFilename$ = MonclassFilename$ + DataExt1$
 MontalkFilename$ = MontalkFilename$ + DataExt1$
 RoomFilename$ = RoomFilename$ + DataExt1$
 ObjectFilename$ = ObjectFilename$ + DataExt1$
 MonstersFilename$ = MonstersFilename$ + DataExt1$
 TreasureFilename$ = TreasureFilename$ + DataExt1$
 SpellsFilename$ = SpellsFilename$ + DataExt1$
 UsersFilename$ = UsersFilename$ + DataExt1$
 NonplyrsFilename$ = NonplyrsFilename$ + DataExt1$
 MessbaseFilename$ = MessbaseFilename$ + DataExt1$
 END SELECT
 RETURN

' reads filenames and datapaths from .cfg file for dest. files
Read.Config2:
 If Node2$ = Nul Then
    ConfigFilename$ = Var2$ + "\DND.CFG"
 Else
    ConfigFilename$ = Var2$ + "\DND" + Node2$ + ".CFG"
 Endif
 IF DIR$(ConfigFilename$) = Nul THEN
    Color 15, 0
    PRINT "Unable to open: "; ConfigFilename$
    Color 14, 0
    PRINT "Exiting to system.."
    COLOR 7, 0
    END
 END IF

 ' dnd49c1 .cfg file
 Strng3=Nul
 CLOSE
 OPEN ConfigFilename$ FOR INPUT AS #1
 INPUT #1, Var$
 FOR Temp = 1 TO 30
    INPUT #1, Var!
 NEXT
 FOR Temp = 1 TO 160
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 100
    LINE INPUT #1, Var$
    Var$=Ltrim$(Rtrim$(Var$))
    SELECT CASE Temp
    CASE 11 ' datapath1
       DataPath1$ = Var$
       IF RIGHT$(DataPath1$, 1) = "\" THEN
          DataPath1$ = LEFT$(DataPath1$, LEN(DataPath1$) - 1)
       END IF
    CASE 12 ' monclass
       MonclassFilename2$ = Var$
    CASE 13 ' montalk
       MontalkFilename2$ = Var$
    CASE 15 ' .dat
       DataExt2$ = Var$
    CASE 16 ' rooms
       RoomFilename2$ = Var$
    CASE 17 ' objects
       ObjectFilename2$ = Var$
    CASE 18 ' monsters
       MonstersFilename2$ = Var$
    CASE 19 ' treasure
       TreasureFilename2$ = Var$
    CASE 20 ' spells
       SpellsFilename2$ = Var$
    CASE 21 ' users
       UsersFilename2$ = Var$
    CASE 22 ' nonplyrs
       NonplyrsFilename2$ = Var$
    CASE 54 ' mess datapath
       DataPath2$ = Var$
       IF RIGHT$(DataPath2$, 1) = "\" THEN
          DataPath2$ = LEFT$(DataPath2$, LEN(DataPath2$) - 1)
       END IF
    CASE 57 ' teamuser
       TeamFileName2$ = Var$
    CASE 58 ' public
       PublicFilename2$ = Var$
    CASE 59 ' messbase
       MessbaseFilename2$ = Var$
    CASE 60 ' private
       PrivateFilename2$ = Var$
    CASE 71 ' actions
       ActionFilename2$ = Var$
    CASE 80 ' containr
       ContainerFilename2$ = Var$
    CASE 85 ' ansi prefix
       Strng3 = Var$
       If Strng3=Nul Then Strng3="{"
    CASE 86 ' userinv
       UserInvFilename2$ = Var$
    CASE 87 ' ctninv
       CtnInvFilename2$ = Var$
    CASE 88 ' teaminv
       TeamInvFileName2$ = Var$
    CASE 89 ' roominv
       RoomInvFilename2$ = Var$
    CASE 90 ' moninv
       MonInvFilename2$ = Var$
    CASE 93 ' roomdesc
       RoomDescFilename2$ = Var$
    CASE 96 ' bank
       BankFileName2$ = Var$
    END SELECT
 NEXT
 ActionFilename2$ = ActionFilename2$ + DataExt2$
 BankFileName2$ = BankFileName2$ + DataExt2$
 MonclassFilename2$ = MonclassFilename2$ + DataExt2$
 MontalkFilename2$ = MontalkFilename2$ + DataExt2$
 RoomFilename2$ = RoomFilename2$ + DataExt2$
 ObjectFilename2$ = ObjectFilename2$ + DataExt2$
 MonstersFilename2$ = MonstersFilename2$ + DataExt2$
 TreasureFilename2$ = TreasureFilename2$ + DataExt2$
 SpellsFilename2$ = SpellsFilename2$ + DataExt2$
 UsersFilename2$ = UsersFilename2$ + DataExt2$
 NonplyrsFilename2$ = NonplyrsFilename2$ + DataExt2$
 MessbaseFilename2$ = MessbaseFilename2$ + DataExt2$
 ContainerFilename2$ = ContainerFilename2$ + DataExt2$
 UserInvFilename2$ = UserInvFilename2$ + DataExt2$
 CtnInvFilename2$ = CtnInvFilename2$ + DataExt2$
 RoomInvFilename2$ = RoomInvFilename2$ + DataExt2$
 MonInvFilename2$ = MonInvFilename2$ + DataExt2$
 RoomDescFilename2$ = RoomDescFilename2$ + DataExt2$
 TeamFilename2$ = TeamFileName2$ + DataExt2$
 TeamInvFilename2$ = TeamInvFileName2$ + DataExt2$
 RETURN

Get.Numeric:
 TempA$=Nul
 Do
    TempX$=Left$(Command.Line$,1)
    If TempX$>="0" And TempX$<="9" Then
       TempA$=TempA$+TempX$
       Command.Line$=Mid$(Command.Line$,2)
    Else
       Exit Do
    Endif
 Loop
 Return

Error.Resume:
 CHDIR Var3$
 COLOR 7, 0
 PRINT "Exiting to system:"
 END

Error.Routine:
 COLOR 15, 0
 SELECT CASE ERR
 CASE 53
    PRINT "File not found."
 CASE 55
    PRINT "File already open."
 CASE 57
    PRINT "Device I/O error."
 CASE 59
    PRINT "Bad record length."
 CASE 61
    PRINT "Disk full."
 CASE 62
    PRINT "Input past eof."
 CASE 63
    PRINT "Bad record number."
 CASE 67
    PRINT "Not enough file handles."
 CASE 68
    PRINT "Device unavailable."
 CASE 70
    PRINT "Permission denied."
 CASE 71
    PRINT "Disk not ready."
 CASE 76
    PRINT "Pathname not found."
 CASE ELSE
    PRINT "Untrapped error" + STR$(ERR) + "."
 END SELECT
 RESUME Error.Resume

Sub MonsterArms
 On Local Error Goto ArmsErr
 DIM TempArray1(10, 10) AS Single
 CLOSE
 OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = NewTreasureRecLen
 OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
 ' process weapons
 For X = 1 To 10
    For Y = 1 To 10
       TempArray1(X, Y) = 0!
    Next
 Next
 ' store treasure weapons of plus 1-10 in array
 For Z! = 1! To Lof(1)/NewTreasureRecLen
    Get 1, Z!, NewTreasureRecord
    V = NewTreasureRecord.Plus
    If V>0 And V<=10 Then
       IF NewTreasureRecord.WeaponNumber = 7 THEN
          IF NewTreasureRecord.Spell = 0 THEN
             IF NewTreasureRecord.Loadable = 0 THEN
                For L = 1 To 10
                   If TempArray1(V, L) = 0! Then
                      TempArray1(V, L) = Z!
                      Exit For
                   Endif
                Next
             Endif
          Endif
       Endif
    Endif
 Next
 ' check array for blank rows
 For X = 1 To 10
    Z = 0
    For Y = 1 To 10
       If TempArray1(X, Y) > 0! Then
          Z = -1
          Exit For
       Endif
    Next
    If Z = 0 Then ' blank row
       If X = 10 Then
          For Y = 1 To 10
             TempArray1(X, Y) = TempArray1(X - 1, Y)
          Next
       Else
          If X < 10 Then
             For X2 = X + 1 To 10
                Z = 0
                For Y = 1 To 10
                   TempArray1(X, Y) = TempArray1(X2, Y)
                   If TempArray1(X2, Y) > 0! Then
                      Z = -1
                   Endif
                Next
                If Z Then
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
 Next
 ' add monster weapons
 For Z! = 1! To Lof(2)/NewMonsterRecLen
    Get 2, Z!, NewMonsterRecord
    V = NewMonsterRecord.Level
    If V > 0 Then
       If V > 10 Then
          V = 10
       Endif
       ' check blank row
       Z = 0
       For Y = 1 To 10
          If TempArray1(V, Y) > 0! Then
             Z = -1
             Exit For
          Endif
       Next
       If Z Then
          ' get random weapon
          NewMonsterRecord.Weapon = 0!
          DO
             Y = INT(RND * 10 + 1)
             IF TempArray1(V, Y) > 0! THEN
                NewMonsterRecord.Weapon = TempArray1(V, Y)
                Put 2, Z!, NewMonsterRecord
                EXIT DO
             END IF
          LOOP
       Endif
    Endif
 Next          
 ' process shields
 For X = 1 To 10
    For Y = 1 To 10
       TempArray1(X, Y) = 0!
    Next
 Next
 ' store treasure shields of plus 1-10 in array
 For Z! = 1! To Lof(1)/NewTreasureRecLen
    Get 1, Z!, NewTreasureRecord
    V = NewTreasureRecord.Plus
    If V>0 And V<=10 Then
       IF NewTreasureRecord.WeaponNumber = 5 THEN
          IF NewTreasureRecord.Spell = 0 THEN
             IF NewTreasureRecord.Loadable = 0 THEN
                For L = 1 To 10
                   If TempArray1(V, L) = 0! Then
                      TempArray1(V, L) = Z!
                      Exit For
                   Endif
                Next
             Endif
          Endif
       Endif
    Endif
 Next
 ' check array for blank rows
 For X = 1 To 10
    Z = 0
    For Y = 1 To 10
       If TempArray1(X, Y) > 0! Then
          Z = -1
          Exit For
       Endif
    Next
    If Z = 0 Then ' blank row
       If X = 10 Then
          For Y = 1 To 10
             TempArray1(X, Y) = TempArray1(X - 1, Y)
          Next
       Else
          If X < 10 Then
             For X2 = X + 1 To 10
                Z = 0
                For Y = 1 To 10
                   TempArray1(X, Y) = TempArray1(X2, Y)
                   If TempArray1(X2, Y) > 0! Then
                      Z = -1
                   Endif
                Next
                If Z Then
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
 Next
 ' add monster weapons
 For Z! = 1! To Lof(2)/NewMonsterRecLen
    Get 2, Z!, NewMonsterRecord
    V = NewMonsterRecord.Level
    If V > 0 Then
       If V > 10 Then
          V = 10
       Endif
       ' check blank row
       Z = 0
       For Y = 1 To 10
          If TempArray1(V, Y) > 0! Then
             Z = -1
             Exit For
          Endif
       Next
       If Z Then
          ' get random weapon
          NewMonsterRecord.Shield = 0!
          DO
             Y = INT(RND * 10 + 1)
             IF TempArray1(V, Y) > 0! THEN
                NewMonsterRecord.Shield = TempArray1(V, Y)
                Put 2, Z!, NewMonsterRecord
                EXIT DO
             END IF
          LOOP
       Endif
    Endif
 Next          
 ' process armor
 For X = 1 To 10
    For Y = 1 To 10
       TempArray1(X, Y) = 0!
    Next
 Next
 ' store treasure armor of plus 1-10 in array
 For Z! = 1! To Lof(1)/NewTreasureRecLen
    Get 1, Z!, NewTreasureRecord
    V = NewTreasureRecord.Plus
    If V>0 And V<=10 Then
       IF NewTreasureRecord.WeaponNumber = 1 THEN
          IF NewTreasureRecord.Spell = 0 THEN
             IF NewTreasureRecord.Loadable = 0 THEN
                For L = 1 To 10
                   If TempArray1(V, L) = 0! Then
                      TempArray1(V, L) = Z!
                      Exit For
                   Endif
                Next
             Endif
          Endif
       Endif
    Endif
 Next
 ' check array for blank rows
 For X = 1 To 10
    Z = 0
    For Y = 1 To 10
       If TempArray1(X, Y) > 0! Then
          Z = -1
          Exit For
       Endif
    Next
    If Z = 0 Then ' blank row
       If X = 10 Then
          For Y = 1 To 10
             TempArray1(X, Y) = TempArray1(X - 1, Y)
          Next
       Else
          If X < 10 Then
             For X2 = X + 1 To 10
                Z = 0
                For Y = 1 To 10
                   TempArray1(X, Y) = TempArray1(X2, Y)
                   If TempArray1(X2, Y) > 0! Then
                      Z = -1
                   Endif
                Next
                If Z Then
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
 Next
 ' add monster weapons
 For Z! = 1! To Lof(2)/NewMonsterRecLen
    Get 2, Z!, NewMonsterRecord
    V = NewMonsterRecord.Level
    If V > 0 Then
       If V > 10 Then
          V = 10
       Endif
       ' check blank row
       Z = 0
       For Y = 1 To 10
          If TempArray1(V, Y) > 0! Then
             Z = -1
             Exit For
          Endif
       Next
       If Z Then
          ' get random weapon
          NewMonsterRecord.Armor = 0!
          DO
             Y = INT(RND * 10 + 1)
             IF TempArray1(V, Y) > 0! THEN
                NewMonsterRecord.Armor = TempArray1(V, Y)
                Put 2, Z!, NewMonsterRecord
                EXIT DO
             END IF
          LOOP
       Endif
    Endif
 Next          
ArmsResume:
 Exit Sub
ArmsErr:
 Print "MonsterArms() Error";Err
 Resume ArmsResume
End Sub
