 Rem File: Cmd201.bas
 Rem Sub: HexCalc
 Rem $Include: 'dndbbs.inc'
 On Error Goto Main.Error
 Call HexCalc
Main.Resume:
 If Chained=0 Then
    End
 Endif
 Locate 1, 1, 1
 Chained=-2
 Shell.Type2=-1
 Chain DND.Path+"DNDBBS.EXE"
 End
Main.Error:
 Resume Main.Resume

' Note: In HexCalc the following keys are active:
'   Ctrl-A - move up, Ctrl-B - move down
'   Ctrl-C - move left, Ctrl-D - move right
'   Ctrl-E, Ctrl-F - cycle foreground
'   Ctrl-J, Ctrl-K - cycle background
'   Ctrl-X - cycle border, Ctrl-Y reset border

Sub HexCalc
 On Local Error Goto Error.Trap1xz

X$ = Command$
If Instr(X$, "/B:1") Then
   Border.Off=-1
   Border2.Off=-1
Endif
If Instr(X$, "/B:2") Then
   Border.Char=-1
   Border2.Char=-1
Endif

' get coordinates/insert/colors
Gosub Get.Config1

' reset new room number
Next.Room=SFalse

' read environment variables
VarX$=Ucase$(Environ$("BLIND"))
If VarX$="ON" Or VarX$="-1" Or VarX$="TRUE" Then
   Border.Off=-1
   Border2.Off=-1
Endif
VarX$=Ucase$(Environ$("BLINDCHAR"))
If VarX$="ON" Or VarX$="-1" Or VarX$="TRUE" Then
   Border.Char=-1
   Border2.Char=-1
Endif

' reset box
Gosub Reset.Box

DO ' calculator loop
   DO ' keystroke loop
      Var$ = INKEY$ ' get keystroke
      IF LEN(Var$) THEN ' check keystroke
         EXIT DO
      END IF
   LOOP
   SELECT CASE LEN(Var$)
   CASE 1 ' single ascii key
      SELECT CASE ASC(Var$)
      Case 24 ' ctrl-x
         Border.Off=0
         Border.Char=not Border.Char
         Gosub Reset.Box
      Case 25 ' ctrl-y
         Border.Off=not Border.Off
         Border.Char=0
         Gosub Reset.Box
      CASE 1 ' control-a (up)
         If Xcoor>1 Then
            Xcoor=Xcoor-1
            Gosub Reset.Box
         Endif
      CASE 2 ' control-b (down)
         If Xcoor<Max.Row-2 Then
            Xcoor=Xcoor+1
            Gosub Reset.Box
         Endif
      CASE 3 ' control-c (left)
         If Ycoor>1 Then
            Ycoor=Ycoor-1
            Gosub Reset.Box
         Endif
      CASE 4 ' control-d (right)
         If Ycoor<50 Then
            Ycoor=Ycoor+1
            Gosub Reset.Box
         Endif
      CASE 5 ' control-e
         If Foreground1=15 Then
            Foreground1=0
         Else
            Foreground1=Foreground1+1
         Endif
         Gosub Reset.Box
      CASE 6 ' control-f
         If Foreground2=15 Then
            Foreground2=0
         Else
            Foreground2=Foreground2+1
         Endif
         Gosub Reset.Box
      CASE 10 ' control-j
         If Background1=7 Then
            Background1=0
         Else
            Background1=Background1+1
         Endif
         Gosub Reset.Box
      CASE 11 ' control-k
         If Background2=7 Then
            Background2=0
         Else
            Background2=Background2+1
         Endif
         Gosub Reset.Box
      CASE 8 ' backspace
         IF Ycoor1 - Column3 > 0 THEN
            IF Ins THEN
               Box$ = LEFT$(Box$, Ycoor1 - Column3 - 1) + MID$(Box$, Ycoor1 - Column3 + 1)
               Ycoor1 = Ycoor1 - 1
               LOCATE Xcoor1, Ycoor1, 1
               Var$ = MID$(Box$, Ycoor1 - Column3 + 1) + " "
               COLOR Foreground2, Background1
               PRINT Var$;
               LOCATE Xcoor1, Ycoor1, 1
               GOSUB PrintBoxes
            ELSE ' move left
               Ycoor1 = Ycoor1 - 1
               LOCATE Xcoor1, Ycoor1, 1
            END IF
         END IF
      CASE 9 ' tab
         IF CalcBox = 1 THEN
            CalcBox = 2
            GOSUB SelectBox2
            GOSUB PrintBoxes
         END IF
      CASE 27 ' escape
         EXIT DO
      Case 63 ' ?
         Gosub Help.Box
         Gosub Reset.Box
      CASE ELSE ' keystroke
         VarX = 0 ' valid char flag
         TempX$ = UCASE$(Var$)
         SELECT CASE TempX$ ' validate char
         CASE "0" TO "9"
            VarX = -1
         CASE "A" TO "F"
            IF CalcBox = 1 THEN
               VarX = -1
            END IF
         END SELECT
         IF VarX THEN
            IF Ycoor1 - Column3 + 1 <= LineLength THEN
               ' insert digit
               IF Ins THEN
                  Box$ = LEFT$(Box$, Ycoor1 - Column3) + TempX$ + MID$(Box$, Ycoor1 - Column3 + 1)
                  Box$ = LEFT$(Box$, LineLength)
                  LOCATE Xcoor1, Ycoor1, 1
                  Var$ = MID$(Box$, Ycoor1 - Column3 + 1)
                  COLOR Foreground2, Background1
                  PRINT Var$;
                  Ycoor1 = Ycoor1 + 1
                  LOCATE Xcoor1, Ycoor1, 1
                  GOSUB PrintBoxes
               ELSE ' overstrike char
                  IF Ycoor1 - Column3 + 1 > LEN(Box$) THEN
                     Box$ = Box$ + TempX$ ' append box
                  ELSE
                     MID$(Box$, Ycoor1 - Column3 + 1, 1) = TempX$ ' replace
                  END IF
                  LOCATE Xcoor1, Ycoor1, 1
                  COLOR Foreground2, Background1
                  PRINT TempX$;
                  Ycoor1 = Ycoor1 + 1
                  LOCATE Xcoor1, Ycoor1, 1
                  GOSUB PrintBoxes
               END IF
            END IF
         END IF
      END SELECT
   CASE 2 ' extended key
      SELECT CASE ASC(RIGHT$(Var$, 1))
      CASE 15 ' shift-tab
         IF CalcBox = 2 THEN
            CalcBox = 1
            GOSUB SelectBox1
            GOSUB PrintBoxes
         END IF
      CASE 76, 143 ' center
         Xcoor = 4
         Ycoor = 6
         Gosub Reset.Box
      CASE 71, 73, 115, 119 ' home/control-left/control-home
         Ycoor1 = Column3
      CASE 79, 81, 116, 117 ' end/control-right/control-end
         Ycoor1 = LEN(Box$) + Column3
      CASE 77, 72, 157, 141, 132, 152 ' right/up
         IF Ycoor1 - Column3 + 1 <= LEN(Box$) THEN
            Ycoor1 = Ycoor1 + 1
         END IF
      CASE 75, 80, 155, 145, 118, 160 ' left/down
         IF Ycoor1 - Column3 > 0 THEN
            Ycoor1 = Ycoor1 - 1
         END IF
      CASE 82 ' insert
         Select Case Ins
         Case 0
            Ins=-1
         Case -1
            Ins=-2
         Case -2
            Ins=0
         End Select
         'Ins = NOT Ins
         Gosub Display.Insert
      CASE 83, 147 ' delete/control-delete
         IF Ycoor1 - Column3 + 1 <= LEN(Box$) THEN
            Box$ = LEFT$(Box$, Ycoor1 - Column3) + MID$(Box$, Ycoor1 - Column3 + 2)
            LOCATE Xcoor1, Ycoor1, 1
            Var$ = MID$(Box$, Ycoor1 - Column3 + 1) + " "
            COLOR Foreground2, Background1
            PRINT Var$;
            LOCATE Xcoor1, Ycoor1, 1
            GOSUB PrintBoxes
         END IF
      END SELECT
      LOCATE Xcoor1, Ycoor1, 1
   END SELECT
LOOP
COLOR 7, 0
If Chained=0 Then
   Gosub Restore.Screen
   'Locate Max.Row, 1, 1
   If TempX=0 Then TempX=1
   Locate TempX, 1, 1
   Color 15
   Print
   Print "Now exiting HexCalc utility."
   Color 7
   End
Endif
EXIT SUB

' display edit box
Reset.Box:
Color ,Background2
Cls

Box$ = "0" ' current box
Box1$ = "0" ' left box string
Box2$ = "0" ' right box string

GOSUB Make.Box ' create edit box.

CalcBox = 1 ' reset to left box.

GOSUB SelectBox2 ' display box 2.
GOSUB SelectBox1 ' display box 1.
Return

' create edit box.
Make.Box:
 ' Y-coordinate of editing boxes.
 Box1 = Ycoor + 3
 Box2 = Ycoor + 15

 ' display editing box.
 COLOR Foreground1, Background2
 LOCATE Xcoor, Ycoor, 1
 If Border.Off=0 Then
    If Border.Char=0 Then
       Var$ = " " + CHR$(201) + STRING$(1, 205) + "<esc>=Quit,?=Help" + STRING$(9, 205) + CHR$(187) + " "
    Else
       Var$ = " +-<esc>=Quit,?=Help" + STRING$(9, "-") + "+ "
    Endif
 Endif
 If Border.Off Then
    Var$ = "   <esc>=Quit,?=Help" + STRING$(11, 32) 
 Endif
 PRINT Var$;
 LOCATE Xcoor + 1, Ycoor, 1
 Var1$ = Box1$ + Space$(8 - Len(Box1$))
 Var2$ = Box2$ + Space$(10 - Len(Box2$))
 If Border.Off=0 Then
    If Border.Char=0 Then
       Var$ = " " + CHR$(186) + " " + Var1$ + "Hex" + " " + Var2$ + "Dec " + CHR$(186) + " "
    Else
       Var$ = " | " + Var1$ + "Hex" + " " + Var2$ + "Dec | " 
    Endif
 Endif
 If Border.Off Then
    Var$ = "   " + Var1$ + "Hex " + Var2$ + "Dec   " 
 Endif
 PRINT Var$;
 LOCATE Xcoor + 2, Ycoor, 1
 If Border.Off=0 Then
    If Border.Char=0 Then
       Var$ = " " + CHR$(200) + STRING$(1, 205) + "<tab>/<shift-tab>=switch" + STRING$(2, 205) + CHR$(188) + " "
    Else
       Var$ = " +-<tab>/<shift-tab>=switch" + STRING$(2, "-") + "+ "
    Endif
 Endif
 If Border.Off Then
    Var$ = "   <tab>/<shift-tab>=switch" + STRING$(4, 32) 
 Endif
 PRINT Var$;

' display insert state
Display.Insert:
 COLOR Foreground1, Background2
 LOCATE Xcoor, Ycoor + 24, 1
 IF Ins THEN
    PRINT "<ins>";
 ELSE
    If Border.Off=0 Then
       If Border.Char=0 Then
          PRINT STRING$(5, 205);
       Else
          PRINT STRING$(5, "-");
       Endif
    Endif
    If Border.Off Then
       PRINT STRING$(5, 32);
    Endif
 END IF
 IF Ins = -2 THEN
    Locate Xcoor, Ycoor, 1, 1, 7
 ELSE
    IF Ins = -1 THEN
       Locate Xcoor, Ycoor, 1, 3, 7
    ELSE
       Locate Xcoor, Ycoor, 1, 7, 7
    END IF
 END IF
 COLOR Foreground2, Background1
 Return

' create help box.
Help.Box:
 DO
    Color ,HBackground2
    CLS
    ' make help box
    COLOR HForeground1, HBackground1
    LOCATE Xcoor2+1, Ycoor2, 1
    If Border2.Off=False Then
       If Border2.Char=0 Then
          PRINT CHR$(201) + STRING$(44, 205) + CHR$(187);
       Else
          PRINT "+" + STRING$(44, "-") + "+";
       Endif
    Else
       Print String$(46," ");
    Endif
    If Border2.Off=False Then
       If Border2.Char=0 Then
          VarX$=CHR$(186)
       Else
          VarX$="|"
       Endif
    Else
       VarX$=" "
    Endif
    LOCATE Xcoor2+2, Ycoor2, 1
    Print VarX$;
    Locate Xcoor2+2, Ycoor2+45, 1
    Print VarX$;
    LOCATE Xcoor2+3, Ycoor2, 1
    PRINT VarX$;
    Locate Xcoor2+3, Ycoor2+45, 1
    Print VarX$;
    LOCATE Xcoor2+4, Ycoor2, 1
    PRINT VarX$;
    Locate Xcoor2+4, Ycoor2+45, 1
    Print VarX$;
    LOCATE Xcoor2+5, Ycoor2, 1
    PRINT VarX$;
    Locate Xcoor2+5, Ycoor2+45, 1
    Print VarX$;

    LOCATE Xcoor2+6, Ycoor2, 1
    PRINT VarX$;
    Locate Xcoor2+6, Ycoor2+45, 1
    Print VarX$;

    LOCATE Xcoor2+7, Ycoor2, 1
    If Border2.Off=False Then
       If Border2.Char=0 Then
          PRINT CHR$(200) + STRING$(44, 205) + CHR$(188);
       Else
          PRINT "+" + STRING$(44, "-") + "+";
       Endif
    Else
       Print String$(46," ");
    Endif

    ' make help box contents
    COLOR HForeground2, HBackground1
    Locate Xcoor2,Ycoor2+12,1
    Print " Additional Keys ";
    Locate Xcoor2+2, Ycoor2+1, 1
    Print "Ctrl-A = Move Up, Ctrl-B = Move Down        ";
    Locate Xcoor2+3, Ycoor2+1, 1
    Print "Ctrl-C = Move Left, Ctrl-D = Move Right     ";
    Locate Xcoor2+4, Ycoor2+1, 1
    Print "Ctrl-E, Ctrl-F = Cycle Foreground           ";
    Locate Xcoor2+5, Ycoor2+1, 1
    Print "Ctrl-J, Ctrl-K = Cycle Background           ";

    Locate Xcoor2+6, Ycoor2+1, 1
    Print "Ctrl-X = Cycle Border, Ctrl-Y = Reset Border";

    LOCATE Xcoor2+7, Ycoor2+11, 0
    PRINT "Press <esc> to Exit:";
    ' help box loop
    Do
       X$=Inkey$
       If Len(X$)=2 Then ' extended key
          Select Case Asc(Right$(X$,1))
          Case 71 ' home
             If Xcoor2>1 Then
                Xcoor2=1
                Exit Do
             Endif
          Case 79 ' end
             If Xcoor2<Max.Row-7 Then
                Xcoor2=Max.Row-7
                Exit Do
             Endif
          CASE 76, 143 ' center
             Xcoor2 = 4
             Ycoor2 = 6
             Exit Do
          CASE 75, 155 ' left/alt-left
             If Ycoor2>1 Then
                Ycoor2=Ycoor2-1
                Exit Do
             Endif
          CASE 77, 157 ' right/alt-right
             If Ycoor2<34 Then
                Ycoor2=Ycoor2+1
                Exit Do
             Endif
          CASE 72, 141, 152 ' up/ctrl-up/alt-up
             If Xcoor2>1 Then
                Xcoor2=Xcoor2-1
                Exit Do
             Endif
          CASE 80, 145, 160 ' down/ctrl-dn/alt-dn
             If Xcoor2<Max.Row-7 Then
                Xcoor2=Xcoor2+1
                Exit Do
             Endif
          Case 73, 57, 132 ' PageUp/Shift-PageUp/Ctrl-PageUp
             If Xcoor2>6 Then
                Xcoor2=Xcoor2-5
                Exit Do
             Else
                Xcoor2=1
                Exit Do
             Endif
          Case 81, 51, 118 ' PageDown/Shift-PageDown/Ctrl-PageDown
             If Xcoor2+5<Max.Row-7 Then
                Xcoor2=Xcoor2+5
                Exit Do
             Else
                Xcoor2=Max.Row-7
                Exit Do
             Endif
          End Select
       Endif
       If Len(X$)=1 Then
          Select Case Asc(X$)
          Case 24 ' ctrl-x
             Border2.Off=0
             Border2.Char=not Border2.Char
             Exit Do
          Case 25 ' ctrl-y
             Border2.Off=not Border2.Off
             Border2.Char=0
             Exit Do
          CASE 1 ' control-a (up)
             If Xcoor2>1 Then
                Xcoor2=Xcoor2-1
                Exit Do
             Endif
          CASE 2 ' control-b (down)
             If Xcoor2<Max.Row-7 Then
                Xcoor2=Xcoor2+1
                Exit Do
             Endif
          CASE 3 ' control-c (left)
             If Ycoor2>1 Then
                Ycoor2=Ycoor2-1
                Exit Do
             Endif
          CASE 4 ' control-d (right)
             If Ycoor2<34 Then
                Ycoor2=Ycoor2+1
                Exit Do
             Endif
          CASE 5 ' control-e
             If HForeground1=15 Then
                HForeground1=0
             Else
                HForeground1=HForeground1+1
             Endif
             Exit Do
          CASE 6 ' control-f
             If HForeground2=15 Then
                HForeground2=0
             Else
                HForeground2=HForeground2+1
             Endif
             Exit Do
          CASE 10 ' control-j
             If HBackground1=7 Then
                HBackground1=0
             Else
                HBackground1=HBackground1+1
             Endif
             Exit Do
          CASE 11 ' control-k
             If HBackground2=7 Then
                HBackground2=0
             Else
                HBackground2=HBackground2+1
             Endif
             Exit Do
          Case 27 ' escape
             Return
          End Select
       Endif
    Loop
 Loop
 Return

' move to box 1 (left box).
SelectBox1:
 Box2$ = Box$ ' store right box.
 Box$ = Box1$ ' reset to left box.
 ' reset editing parameters.
 Xcoor1 = Xcoor + 1
 Ycoor1 = Ycoor + 3
 Column3 = Ycoor1
 LineLength = 8

 ' display left box.
 COLOR Foreground2, Background1
 LOCATE Xcoor1, Ycoor1, 1
 PRINT SPACE$(8);
 LOCATE Xcoor1, Ycoor1, 1
 PRINT Box$;
 Ycoor1 = Ycoor1 + LEN(Box$)
 LOCATE Xcoor1, Ycoor1, 1
 RETURN

' move to box 2 (right box).
SelectBox2:
 Box1$ = Box$ ' store left box.
 Box$ = Box2$ ' reset to right box.
 ' reset editing parameters.
 Xcoor1 = Xcoor + 1
 Ycoor1 = Ycoor + 15
 Column3 = Ycoor1
 LineLength = 10

 ' display right box.
 COLOR Foreground2, Background1
 LOCATE Xcoor1, Ycoor1, 1
 PRINT SPACE$(10);
 LOCATE Xcoor1, Ycoor1, 1
 PRINT Box$;
 Ycoor1 = Ycoor1 + LEN(Box$)
 LOCATE Xcoor1, Ycoor1, 1
 RETURN

' calculates value of current box,
'  displays result in calculated form in opposite box.
PrintBoxes:
 IF CalcBox = 1 THEN ' is in hex box.
    ' strip leading zeroes for signed bit conversion.
    TempBox$ = Box$
    DO
       IF LEFT$(TempBox$, 1) = "0" THEN
          TempBox$ = MID$(TempBox$, 2)
       ELSE
          EXIT DO
       END IF
    LOOP
    Value# = VAL("&H" + TempBox$) ' retreive decimal value.
    IF Value# < 0# THEN ' check twos-complement from signed value.
       IF LEN(TempBox$) = 8 THEN ' 8000 0000 to FFFF FFFF
          Value# = Value# + 4294967296#
       ELSE
          IF LEN(TempBox$) = 4 THEN ' 8000 to FFFF
             Value# = Value# + 65536#
          END IF
       END IF
    END IF
    ' display decimal value.
    Box2$ = MID$(STR$(Value#), 2)
    COLOR Foreground2, Background1
    LOCATE Xcoor1, Box2, 1
    PRINT SPACE$(10);
    LOCATE Xcoor1, Box2, 1
    PRINT Box2$;
 END IF
 IF CalcBox = 2 THEN ' is in decimal box.
    Value# = VAL(Box$) ' retreive hex value.
    IF Value# >= 4294967296# THEN ' check overflow.
       COLOR Foreground2, Background1
       LOCATE Xcoor1, Box1, 1
       COLOR 12
       Var$ = "overflow"
       PRINT Var$;
       Box1$ = "0"
    ELSE
       IF Value# > 2147483647# THEN ' force to twos-complement.
          Value# = Value# - 4294967296# ' 8000 0000 to FFFF FFFF
       END IF
       ' display hex value.
       Box1$ = HEX$(Value#)
       COLOR Foreground2, Background1
       LOCATE Xcoor1, Box1, 1
       PRINT SPACE$(8);
       LOCATE Xcoor1, Box1, 1
       PRINT Box1$;
    END IF
 END IF
 LOCATE Xcoor1, Ycoor1, 1
 RETURN

Get.Config1:
 ' upper-left coordinate of editing box on screen.
 Xcoor = 4
 Ycoor = 6

 ' upper-left coordinate of help box on screen.
 Xcoor2 = 4
 Ycoor2 = 6

 ' reset insert mode.
 Ins = -1

 ' reset colors of editing box
 Background1=0 ' black
 Background2=1 ' blue
 Foreground1=14 ' yellow
 Foreground2=15 ' white

 ' reset colors of help box
 HBackground1=0 ' black
 HBackground2=1 ' blue
 HForeground1=14 ' yellow
 HForeground2=15 ' white

 ' check startup type
 If Chained = 0 Then
    Call Read.Rows(Max.Row)
    Gosub Save.Screen
    VarQ=0
    Filename$="cmd201.cfg"
    If Dir$(Filename$)<>"" Then
       Open Filename$ for input as #1
       Do while not eof(1)
          Line Input #1,X$
          X$ = Rtrim$(Ltrim$(X$))
          If Left$(X$,1) <> ";" Then
             Var = Instr(X$, "'")
             If Var = 1 Then
                X$ = Nul
             Else
                If Var Then
                   X$ = Left$(X$, Var - 1)
                Endif
             Endif
             X$ = Ltrim$(Rtrim$(X$))
             If Len(X$) > 0 Then
                Var=Instr(X$,"=")
                If Var Then
                   Var2$=Ltrim$(Rtrim$(Left$(X$,Var-1)))
                   Var3$=Ltrim$(Rtrim$(Mid$(X$,Var+1)))
                   VarZ=Int(Val(Var3$)+.5)
                   Gosub Parse.Options
                Endif
             Endif
          Endif
       Loop
    Endif
    Return
 Endif

 ' get config settings
 VarX=0
 Do
    VarX=VarX+1
    If VarX>Options.Lines Then
       Exit Do
    Endif
    Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
    If Ucase$(Var$)="[CMD201]" Then
       Do
          VarX=VarX+1
          If VarX>Options.Lines Then
             Return
          Endif
          Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
          If Ucase$(Var$)="[END]" Then
             Return
          Endif
          Var=Instr(Var$,"=")
          If Var Then
             Var2$=Ltrim$(Rtrim$(Left$(Var$,Var-1)))
             Var3$=Ltrim$(Rtrim$(Mid$(Var$,Var+1)))
             VarZ=Int(Val(Var3$)+.5)
             Gosub Parse.Options
          Endif
       Loop
    Endif
 Loop
 Return

Parse.Options:
 Select Case Lcase$(Var2$)
 Case "xcoor"
    If VarZ>=1 And VarZ<=Max.Row-2 Then
       Xcoor=VarZ
    Endif
 Case "ycoor"
    If VarZ>=1 And VarZ<=50 Then
       Ycoor=VarZ
    Endif
 Case "xcoor2"
    If VarZ>=1 And VarZ<=Max.Row-7 Then
       Xcoor2=VarZ
    Endif
 Case "ycoor2"
    If VarZ>=1 And VarZ<=34 Then
       Ycoor2=VarZ
    Endif
 Case "insert"
    Select Case Lcase$(Var3$)
    Case "0", "false", "off"
       Ins = 0
    End Select
 Case "blind"
    Select Case Lcase$(Var3$)
    Case "on", "-1", "true" 
       Border.Off=-1
       Border2.Off=-1
    End Select
 Case "blindchar"
    Select Case Lcase$(Var3$)
    Case "on", "-1", "true" 
       Border.Char=-1
       Border2.Char=-1
    End Select
 Case "background1"
    If VarZ>=0 And VarZ<=7 Then
       Background1=VarZ
    Endif
 Case "background2"
    If VarZ>=0 And VarZ<=7 Then
       Background2=VarZ
    Endif
 Case "foreground1"
    If VarZ>=0 And VarZ<=15 Then
       Foreground1=VarZ
    Endif
 Case "foreground2"
    If VarZ>=0 And VarZ<=15 Then
       Foreground2=VarZ
    Endif
 Case "hbackground1"
    If VarZ>=0 And VarZ<=7 Then
       HBackground1=VarZ
    Endif
 Case "hbackground2"
    If VarZ>=0 And VarZ<=7 Then
       HBackground2=VarZ
    Endif
 Case "hforeground1"
    If VarZ>=0 And VarZ<=15 Then
       HForeground1=VarZ
    Endif
 Case "hforeground2"
    If VarZ>=0 And VarZ<=15 Then
       HForeground2=VarZ
    Endif
 End Select
 Return

' screen save
Save.Screen:
 S = Max.Row * 80
 REDIM Temp.Array1(1 TO S) AS INTEGER
 REDIM Temp.Array2(1 TO S) AS INTEGER
 FOR Var1 = 1 TO Max.Row
    FOR Var2 = 1 TO 80
       TempZ1 = SCREEN(Var1, Var2) ' screen char
       TempZ2 = SCREEN(Var1, Var2, 1) ' char color
       VarX = (Var1 - 1) * 80 + Var2
       Temp.Array1(VarX) = TempZ1
       Temp.Array2(VarX) = TempZ2
    NEXT
 NEXT
 RETURN

' screen restore
Restore.Screen:
 Cls
 For VarX=Max.Row To 1 Step -1
    For VarY=1 To 80
       VarX2=(VarX-1)*80+VarY
       If Temp.Array1(VarX2)<>32 Then
          Goto Next.Line
       Endif
    Next
 Next
Next.Line:
 TempX=VarX
 If TempX=0 Then Return
 FOR Var1 = 1 TO VarX ' Max.Row
    FOR Var2 = 1 TO 80
       VarX = (Var1 - 1) * 80 + Var2
       VarB = INT(Temp.Array2(VarX) / 16)
       VarF = Temp.Array2(VarX) MOD 16
       TempZ1 = Temp.Array1(VarX)
       LOCATE Var1, Var2, 0
       COLOR VarF, VarB
       PRINT CHR$(TempZ1);
    NEXT
 NEXT
 RETURN
Error.Resume1xz:
 Exit Sub
Error.Trap1xz:
 Resume Error.Resume1xz
End Sub

' detects max rows 50/43/25
Sub Read.Rows(Var)
 On Local Error Goto Error.Trap62x
 Temp1=50
 Locate 50,1,0
 Var=50
 Exit Sub
Next.Trap1:
 Temp1=43
 Locate 43,1,0
 Var=43
 Exit Sub
Next.Trap2:
 Temp1=25
 Locate 25,1,0
 Var=25
 Exit Sub
Next.Trap3:
 Var=12
Error.Resume62x:
 Exit Sub
Error.Trap62x:
 If Temp1=50 Then
    Resume Next.Trap1
 Endif
 If Temp1=43 Then
    Resume Next.Trap2
 Endif
 If Temp1=25 Then
    Resume Next.Trap3
 Endif
 Resume Error.Resume62x
End Sub
