 Rem File: Cmd083a.bas
 Rem Sub: Display.Information2
 Rem $Include: 'dndbbs.inc'
 On Error Goto Main.Error
 If Chained<>-2 Then
    Color 15,0
    Print "DNDBBS Command 083a -- Display.Information2."
    Color 7,0
    End
 Endif
 Call Display.Information2
Main.Resume:
 Chain DND.Path+"DNDBBS.EXE"
 End
Main.Error:
 Resume Main.Resume

' function to match case-sensitive substring with ?, * characters in substring
SUB InstrSUB1(Var,Var1$,Var2$)

' see if Var2$ matches in Var1$
On Local Error Goto ErrorTrap24x5

' store case-sensitive string match variables
S2$ = Lcase$(Var2$)
S3$ = Lcase$(Var1$)

' check default instr
IF INSTR(S2$, "*") = 0 THEN
   IF INSTR(S2$, "?") = 0 THEN
      Var = INSTR(S3$, S2$)
      EXIT SUB
   END IF
END IF

Var = -1 ' assume match

' see if S2$ matches in S3$ with substrings
FOR S3 = 1 TO LEN(S3$)
   S1$ = MID$(S3$, S3)
   P1 = 1 ' pointer to S1$
   P2 = 1 ' pointer to S2$
   DO
      ' check match
      IF P2 > LEN(S2$) THEN
         EXIT SUB
      END IF

      ' check character in S2$ at P2
      V$ = MID$(S2$, P2, 1)
      SELECT CASE V$
      CASE "*" ' global character
         ' scan to next char
         IF P2 > LEN(S2$) THEN
            EXIT DO
         END IF
         S4$ = MID$(S2$, P2 + 1, 1)
         SELECT CASE S4$
         CASE "*", "?"
            P2 = P2 + 1
         CASE ELSE
            DO
               IF MID$(S1$, P1, 1) = S4$ THEN
                  EXIT DO
               END IF
               IF P1 >= LEN(S1$) THEN
                  EXIT DO
               END IF
               P1 = P1 + 1
            LOOP
            P2 = P2 + 1
         END SELECT
      CASE "?" ' wildcard character
         P1 = P1 + 1
         P2 = P2 + 1
      CASE ELSE ' ascii character
         IF MID$(S1$, P1, 1) <> V$ THEN ' no match
            EXIT DO
         END IF
         P1 = P1 + 1
         P2 = P2 + 1
      END SELECT
   LOOP
NEXT
Var = 0 ' no match
EXIT SUB
ErrorResume24x5:
 Exit Sub
ErrorTrap24x5:
 Resume ErrorResume24x5
End Sub

Sub Display.Information2
 On Local Error Goto ErrorTrp33
 Gosub Get.Config3

 Rem *** special look/iden functions:

 ' check for second parameter
 If Instr(Parsed.Command2," ") Then
    Parsed.Command1=Mid$(Parsed.Command2,Instr(Parsed.Command2," ")+1)
    Goto Display.Item
 Endif

 ' no second parameter
 Select Case Lcase$(Parsed.Command1)
 Case "debug"
    If Debug.Mode Then
       Graphics.Off=False
       Strng="Debug info:"
       Call IO.O
       Graphics.Off=True
       Strng="Inline.filename1="+Inline.Filename1
       Call IO.O
       Strng="Inline.filename2="+Inline.Filename2
       Call IO.O
       Strng="Video page="+Right$("0000"+Hex$(Video.Page),4)+"H"
       Call IO.O
       Call VideoInt(15,0)
       Var=OutregsX.AX And &HFF
       Strng="Video mode="+Right$("0000"+Hex$(Var),4)+"H"
       Call IO.O
       Call More.Prompt
       Exit Sub
    Endif
 Case "blaster"
    If OptionZ1=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Call GetBlaster (BasePort%, Channel%, SpeakerVolume, DSPVersion!, IRQ%, CardType)
    If BasePort% > 0% Then
       Graphics.Off=False
       Strng="Blaster info:"
       Call IO.O
       Graphics.Off=True
       Select Case CardType
       Case 1
          Strng="Sound Blaster 1.5"
       Case 2
          Strng="Sound Blaster Pro I"
       Case 3
          Strng="Sound Blaster 2.0"
       Case 4
          Strng="Sound Blaster Pro II"
       Case 5
          Strng="Sound Blaster Pro II/FM"
       Case 6
          Strng="Sound Blaster 16/AWE 32/32/64"
       Case Else
          Strng="Sound Blaster 2.0"
       End Select
       Strng="Card type: "+Strng
       Call IO.O

       Strng="DSP version:"+Str$(DSPVersion!)
       Call IO.O
       Strng="Baseport: 0x"+Hex$(BasePort%)
       Call IO.O
       Strng="Channel:"+Str$(Channel%)
       Call IO.O
       Strng="IRQ:"+Str$(IRQ%)
       Call IO.O
       Strng="Volume:"+Str$(SpeakerVolume)
       Call IO.O
       Call More.Prompt
    Else
       Strng="Blaster not found."
       Call IO.O
    Endif
    Exit Sub
 Case "environ", "environment"
    If Option0=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    VarZ=0
    Do While Lost.Carrier=False
       Strng="Environment selection(L=list,S=search,Q=quit)? "
       No.Input.Out="Q"
       Line.Length=1
       Call IO.I
       Out2=Ucase$(Out2)
       Select Case Out2
       Case "Q"
          Exit Sub
       Case "L"
          VarZ=1
          Exit Do
       Case "S"
          Strng="Search variable(? and * allowed)? "
          Call IO.I
          If Len(Out2) Then
             VarZ=2
             VarZ$=Ucase$(Out2)
             Exit Do
          Endif
       End Select
    Loop
    If VarZ=0 Then Exit Sub
    Graphics.Off=False
    If VarZ=1 Then
       Strng="List of environment variables:"
    Else
       Strng="Search of environment variables:"
    Endif
    Call IO.O
    TempC=1
    TempD=False
    VarQ=0
    Store.LineLength=User.LineLength
    Do
       VarQ=VarQ+1
       VarQ$ = ENVIRON$(VarQ)
       IF VarQ$ = "" THEN EXIT DO
       Strng=VarQ$
       If VarZ=2 Then
          Var1$=Strng
          Call InstrSUB1(VarZ2,Var1$,VarZ$)
          If VarZ2=0 Then
             Strng=Nul
          Endif
       Endif
       If Len(Strng) Then
          If Len(Strng)>Store.LineLength Then
             User.LineLength=Len(Strng)+1
          Else
             User.LineLength=Store.LineLength
          Endif
          LengthX=Int(Len(Strng) \ 80)
          Graphics.Off=True
          Call IO.O
          TempD=True
          If Continuous=False Then
             TempC=TempC+LengthX+1
             If TempC>=User.Pagelength-2 Then
                TempC=False
                Call More.Prompt
                If No Or Quit Then
                   Exit Sub
                Endif
             Endif
          Endif
       Endif
    Loop
    User.LineLength=Store.LineLength
    If TempD=False Then
       Strng="No variables lines found."
       Call IO.O
    Endif
    If TempC Then
       Call More.Prompt
    Endif
    Exit Sub
 Case "guestlines", "phonenumbers", "phonelines"
    If Option1=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Graphics.Off=False
    Strng="List of phone lines:"
    Call IO.O
    TempC=False
    TempD=False
    For VarQ=1 To 127
       Strng=Rtrim$(GuestLines(VarQ))
       If Len(Strng) Then
          Strng=Ltrim$(Str$(VarQ))+". "+Strng
          Graphics.Off=True
          Call IO.O
          TempD=True
          If Continuous=False Then
             TempC=TempC+1
             If TempC>=User.Pagelength-2 Then
                TempC=False
                Call More.Prompt
                If No Or Quit Then
                   Exit Sub
                Endif
             Endif
          Endif
       Endif
    Next
    If TempD=False Then
       Strng="No phone lines found."
       Call IO.O
    Endif
    If TempC Then
       Call More.Prompt
    Endif
    Exit Sub
 Case "specialusers", "specialnames"
    If OptionZ=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    If Local.Mode Or Debug.Mode Or Sysop Then
       VarZ=0
       Do While Lost.Carrier=False
          Strng="Special selection(L=list,S=search,Q=quit)? "
          No.Input.Out="Q"
          Line.Length=1
          Call IO.I
          Out2=Ucase$(Out2)
          Select Case Out2
          Case "Q"
             Exit Sub
          Case "L"
             VarZ=1
             Exit Do
          Case "S"
             Strng="Search variable(? and * allowed)? "
             Call IO.I
             If Len(Out2) Then
                VarZ=2
                VarZ$=Ucase$(Out2)
                Exit Do
             Endif
          End Select
       Loop
       If VarZ=0 Then Exit Sub
       Graphics.Off=False
       If VarZ=1 Then
          Strng="List of special users:"
       Else
          Strng="Search of special users:"
       Endif
       Call IO.O
       TempC=False
       TempD=False
       For VarZ3=1 To Special.Names
          VarX$=Lcase$(Rtrim$(SpecialUserName(VarZ3)))
          If Len(VarX$) Then
             If VarZ=2 Then
                VarZ2$=Ucase$(VarX$)
                Call InstrSUB1(VarZ2,VarZ2$,VarZ$)
                If VarZ2=0 Then
                   VarX$=Nul
                Endif
             Endif
          Endif
          If Len(VarX$) Then
             Var1$=Rtrim$(SpecialUserTime(VarZ3))
             Mid$(VarX$,1,1)=Ucase$(Mid$(VarX$,1,1))
             Strng=VarX$+" time restriction is "+Var1$
             Graphics.Off=True
             Call IO.O
             TempD=True
             If Continuous=False Then
                TempC=TempC+1
                If TempC>=User.Pagelength-2 Then
                   TempC=False
                   Call More.Prompt
                   If No Or Quit Then
                      Exit Sub
                   Endif
                Endif
             Endif
          Endif
       Next
       If TempD=False Then
          Strng="No special users found."
          Call IO.O
       Endif
       If TempC Then
          Call More.Prompt
       Endif
    Else
       Strng="You can't examine that!"
       Call IO.O
    Endif
    Exit Sub
 Case "deletedusers", "deletednames"
    If OptionZ=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    If Local.Mode Or Debug.Mode Or Sysop Then
       VarZ=0
       Do While Lost.Carrier=False
          Strng="Deleted selection(L=list,S=search,Q=quit)? "
          No.Input.Out="Q"
          Line.Length=1
          Call IO.I
          Out2=Ucase$(Out2)
          Select Case Out2
          Case "Q"
             Exit Sub
          Case "L"
             VarZ=1
             Exit Do
          Case "S"
             Strng="Search variable(? and * allowed)? "
             Call IO.I
             If Len(Out2) Then
                VarZ=2
                VarZ$=Ucase$(Out2)
                Strng="Search by date(y/n)? "
                No.Input.Out="N"
                Line.Length=1
                Call IO.I
                If Yes Then
                   Strng="Enter date(mm-dd-yyyy? "
                   Call IO.I
                   If Len(Out2) Then
                      VarZ1$=Out2
                   Endif
                Endif
                Exit Do
             Endif
          End Select
       Loop
       If VarZ=0 Then Exit Sub
       Graphics.Off=False
       If VarZ=1 Then
          Strng="List of deleted users:"
       Else
          Strng="Search of deleted users:"
       Endif
       Call IO.O
       TempC=False
       TempD=False

       Close #TempFile1
       FileName=DND.Path+"delete.log"
       If Dir$(FileName)<>Nul Then
          Open FileName For Input Shared As #TempFile1

          Do
             If Eof(TempFile1) Then
                Exit Do
             Endif
             VarZ2=-1
             Line Input #TempFile1,VarX$ ' username
             If VarZ=2 Then
                VarX$=Ucase$(VarX$)
                Call InstrSUB1(VarZ2,VarX$,VarZ$)
             Endif
             If Eof(TempFile1) Then
                Exit Do
             Endif
             Line Input #TempFile1,Var1$ ' date deleted
             If Eof(TempFile1) Then
                Exit Do
             Endif
             Line Input #TempFile1,Var2$ ' reason for deletion
             ' check date search
             If Len(VarZ1$) Then
                If Instr(Var1$,VarZ1$)=0 Then
                   VarZ2=0
                Endif
             Endif
             If VarZ2 Then
                VarX$=Lcase$(VarX$)
                Mid$(VarX$,1,1)=Ucase$(Mid$(VarX$,1,1))
                Strng=VarX$+" date deleted is "+Var1$
                Graphics.Off=True
                Call IO.O

                Carriage.Return=True
                Strng="Reason: "
                Call IO.O

                Graphics.Off=True
                Strng=Var2$
                Call Convert.String
                Call Convert.ANSI(True,VarQ,VarR)
                Graphics.Off=False
                Graphics.On=True
                Call IO.O
                Graphics.On=False

                TempD=True
                If Continuous=False Then
                   TempC=TempC+2
                   If TempC>=User.Pagelength-2 Then
                      TempC=False
                      Call More.Prompt
                      If No Or Quit Then
                         Exit Sub
                      Endif
                   Endif
                Endif
             Endif
          Loop
       Endif
       If TempD=False Then
          Strng="No deleted users found."
          Call IO.O
       Endif
       If TempC Then
          Call More.Prompt
       Endif
    Else
       Strng="You can't examine that!"
       Call IO.O
    Endif
    Exit Sub
 Case "create", "created"
    If Option2=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Temp1!=User.Index
    Call Read.Record(UserFile2,Temp1!)
    Out3=UserRecord2.CodeName
    Out3=Lcase$(Rtrim$(Out3))
    If Sysop Then
       Strng="Objects of specific user(y/n)? "
       Call IO.I
       If Yes Then
          Strng="Username? "
          Call IO.I
          If Len(Out2) Then
             Out2=Lcase$(Rtrim$(Out2))
             For Var!=1! To Lof(UserFile2)/UserRecLen
                Call Read.Record(UserFile2,Var!)
                Out3=UserRecord2.CodeName
                Out3=Lcase$(Rtrim$(Out3))
                If Out3=Out2 Then
                   Temp1!=Var!
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
    Call Read.Record(UserFile2,Temp1!)
    Graphics.Off=False
    Strng="Objects created/edited by: "+Out3+"."
    Call IO.O
    Graphics.Off=True
    For Var1=1 To 10
       Select Case Var1
       Case 1
          Strng="Actions"
       Case 2
          Strng="Monclass"
       Case 3
          Strng="Monster"
       Case 4
          Strng="Nonplayer"
       Case 5
          Strng="Object"
       Case 6
          Strng="Player"
       Case 7
          Strng="Room"
       Case 8
          Strng="Spell"
       Case 9
          Strng="Treasure"
       Case 10
          Strng="User"
       End Select
       Strng=Strng+":"+Str$(UserRecord2.ObjectsCreated(Var1))
       Call IO.O
    Next
    Call More.Prompt
    Exit Sub
 Case "wishes"
    If Option3=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Strng="Wishes left: "
    Select Case UserRecord.WishsLeft
    Case -1
       Strng=Strng+"Unlimited"
    Case 0
       Strng=Strng+"None"
    Case 1 To 10
       Strng=Strng+Rtrim$(Numeral(UserRecord.WishsLeft))
    Case Else
       Strng=Strng+Form$(Cdbl(UserRecord.WishsLeft))
    End Select
    Strng=Strng+"."
    Call IO.O
    Exit Sub
 Case "classnames"
    If Option4=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Graphics.Off=False
    Strng="Classnames:"
    Call IO.O
    Graphics.Off=True
    Strng="Classname        High Classname"
    Call IO.O
    Strng=String$(31,"-")
    Call IO.O
    For Temp1=1 To MaxClassNames
       Strng=Lcase$(Rtrim$(Class.Name(Temp1)))
       Call Capitalize(Strng)
       Strng=Strng+Space$(16-Len(Strng))+" "
       Out2=Lcase$(Rtrim$(High.Class.Name(Temp1)))
       Call Capitalize(Out2)
       Strng=Strng+Out2
       Call IO.O
    Next
    Call More.Prompt
    Exit Sub
 Case "pagetimes"
    If Option5=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Strng=Rtrim$(GuestRecord.PageTimes)
    If Strng=Nul Then
       Strng="<none>"
    Endif
    Strng="Sysop page times: "+Strng
    Call IO.O
    Gosub Get.Config2
    If Len(Strng) Then
       Strng=Left$(Strng,Len(Strng)-2)+"."
       Var$=Strng
       Strng="Additional sysop page times:"
       Call IO.O
       Strng=" "+Var$
       Call IO.O
    Endif
    Exit Sub
 Case "roomnumber"
    If Option6=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Strng="You are in room #"+Mid$(Str$(Room),2)+"."
    Call Safe.Room
    If TempA Then
       Strng=Strng+" <safe haven>"
    Endif
    Call IO.O
    Exit Sub
 Case "maxroomnumber"
    If Option7=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Strng="Max room:"+Str$(Lof(RoomFile)/RoomRecLen)+"."
    Call IO.O
    Exit Sub
 Case "monclass", "monsterclass", "classnumber"
    If Option8=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Call Safe.Room
    Strng="This room monclass:"
    If TempA Then
       Strng=Strng+" <safe haven>."
    Else
       Strng=Strng+Str$(RoomRecord.MonClass)+"."
    Endif
    Call IO.O
    Exit Sub
 Case "roomaction", "actionnumber"
    If Option9=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Strng="This room action:"+Str$(RoomRecord.Action)+"."
    Call IO.O
    Exit Sub
 Case "toggle"
    Room.Toggle=Not Room.Toggle
    If Room.Toggle Then
       Strng="Sorted inventory toggled on."
    Else
       Strng="Sorted inventory toggled off."
    Endif
    Call IO.O
    Exit Sub
 Case "dndbbs.doc", "dndcnfg.doc", "dndedit.doc", "sysop.doc", "edit.doc", "sic.doc", "tumbler.doc", "tumbler.dat", "coins.doc", "outfile.doc"
    If Option10=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    ' check against excludefilelist
    If Len(Option10$) Then
       VarZ$=Lcase$(Option10$)
       Do While Lost.Carrier=False
          VarP=Instr(VarZ$,";")
          If VarP Then
             VarZ2$=Left$(VarZ$,VarP-1)
             VarZ$=Mid$(VarZ$,VarP+1)
             Gosub Check.Filename
          Else
             VarZ2$=VarZ$
             Gosub Check.Filename
             Exit Do
          Endif
       Loop
    Endif
    FileName=DND.Path+Lcase$(Parsed.Command1)
    Strng="[xoff]"
    Call Convert.String
    Call Out.File(FileName,"-2")
    Strng="[xon]"
    Call Convert.String
    Call IO.O
    Exit Sub
 ' ANSI.Keys
 Case "ansikeys"
    If Option11=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Strng="ANSI keys:"
    Call IO.O
    For Var=1 To 26
       Strng=Chr$(Var+64)+": "
       If Rtrim$(ANSI.Keys(Var))=Nul Then
          Strng=Strng+"<none>"
       Else
          Strng=Strng+Rtrim$(ANSI.Keys(Var))
       Endif
       Call IO.O
       If Var=13 Then
          Call More.Prompt
       Endif
    Next
    Call More.Prompt
    Exit Sub
 ' modem
 Case "modem"
    If Option12=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    If Local.Mode Then
       Strng="There's no modem here.."
       Call IO.O
    Endif
    If Local.Mode=False Then
       Strng="It's a modem.."
       Call IO.O
       Graphics.Off=False
       Strng="Modem comm info:"
       Call IO.O
       Graphics.Off=True
       Strng="Comm:"+Str$(Port+1)+" (port:"+Str$(Port)+")"
       Call IO.O
       Strng=" Base: 0x"+Hex$(Base.Address)
       Call IO.O
       Strng="Computer to modem:"+Str$(Modem.Baud)
       Call IO.O
       If BBS.Mode=False Then
          Strng="Modem to modem: "+Modem.Return
          Call IO.O
       Endif
       If BBS.Mode = -1 Then
          Strng=" Modem: (door)"
          Call IO.O
       Endif
       If BBS.Mode = -2 Then
          Strng=" Modem: (telnet)"
          Call IO.O
       Endif
       Strng="Fossil: "
       If Fossil.Active Then
          Strng=Strng+"Yes"
          If Fossil.Active=1 Then
             Strng=Strng+": X00"
          Endif
       Else
          Strng=Strng+"No"
       Endif
       Call IO.O
       Call More.Prompt
    Endif
    Exit Sub
 ' options
 Case "options"
    If Option13=0 Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
    Do While Lost.Carrier=False
       Strng="Enter (C)ount, (L)ist, (S)earch, (Q)uit? "
       No.Input.Out="Q"
       Call IO.I
       If Quit Then
          Exit Sub
       Endif
       Out2=Ucase$(Out2)
       If Out2="C" Or Out2="L" Or Out2="S" Then
          Exit Do
       Endif
    Loop
    Select Case Out2
    Case "C"
       Var2=0
       Var2!=0!
       Strng="Lines and bytes of options:"
       Call IO.O
       For Var=1 To Options.Lines
          If Ucase$(Ltrim$(Rtrim$(Options.Array(Var))))="[END]" Then Var2=Var2+1
          Var2!=Var2!+Len(Ltrim$(Rtrim$(Options.Array(Var))))+2!
       Next
       Strng="Blocks:"+Str$(Var2)+"."
       Call IO.O
       Strng="Lines:"+Str$(Options.Lines)+"."
       Call IO.O
       Strng="Bytes: "+Form$(Cdbl(Var2!))+"."
       Call IO.O
       Call More.Prompt
    Case "S"
       Strng="Enter command block string? "
       Call IO.I
       If Len(Out2) Then
          If Left$(Out2,1)="[" And Right$(Out2,1)="]" Then
             Var1$=Out2
          Else
             Var1$="["+Out2+"]"
          Endif
          Var1$=Ucase$(Var1$)
          VarX=False
          VarZ=False
          Do While Lost.Carrier=False
             VarX=VarX+1
             If VarX>Options.Lines Then
                Exit Do
             Endif
             Var$=Ucase$(Ltrim$(Rtrim$(Options.Array(VarX))))
             If Var$=Var1$ Then
                Var2=1
                Strng=Var$
                Call IO.O
                VarZ=True
                Continuous=False
                Do While Lost.Carrier=False
                   VarX=VarX+1
                   If VarX>Options.Lines Then
                      Exit Do
                   Endif
                   Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
                   If Ucase$(Var$)="[END]" Then
                      If Var2=1 Then
                         Strng="<no items found>"
                         Call IO.O
                      Endif
                      Strng=Var$
                      Call IO.O
                      Exit Do
                   Endif
                   If Len(Var$)>=80 Then
                      Var2=Var2+1
                   Endif
                   Strng=Var$
                   Call IO.O
                   Var2=Var2+1
                   If Var2>=User.Pagelength-2 Then
                      Var2=False
                      If Continuous=False Then
                         Call More.Prompt
                         If No Or Quit Then
                            Exit Do
                         Endif
                      Endif
                   Endif
                Loop
             Endif
          Loop
       Endif
       If VarZ=False Then
          Strng="Command block "+Var1$+" not found."
          Call IO.O
       Endif
       Call More.Prompt
    Case "L"
       Var2=1
       Var2!=0!
       For Var=1 To Options.Lines
          Var2!=Var2!+Len(Ltrim$(Rtrim$(Options.Array(Var))))+2!
       Next
       Strng="Lines:"+Str$(Options.Lines)+" Bytes: "+Form$(Cdbl(Var2!))+"."
       Call IO.O
       Continuous=False
       For Var=1 To Options.Lines
          Var$=Ltrim$(Rtrim$(Options.Array(Var)))
          If Len(Var$)>=80 Then
             Var2=Var2+1
          Endif
          Strng=Var$
          Call IO.O
          If Ucase$(Var$)="[END]" Then
             Var2=False
             If Continuous=False Then
                Call More.Prompt
                If No Or Quit Then
                   Exit For
                Endif
             Endif
          Else
             Var2=Var2+1
             If Var2>=User.Pagelength-2 Then
                Var2=False
                If Continuous=False Then
                   Call More.Prompt
                   If No Or Quit Then
                      Exit For
                   Endif
                Endif
             Endif
          Endif
       Next
    End Select
    Exit Sub
 End Select

 Rem *** standard look/iden function:

Display.Item:

 ' object
 If Temp7!<SFalse Then
    Graphics.Off=True
    Strng=Prefix1+Rtrim$(ObjectRecord.Prefix1)+Out3
    Call Convert.ANSI(True,VarQ,VarR)
    Carriage.Return=True
    Graphics.On=True
    Call IO.O
    Graphics.On=False
    Strng=Nul
    If ObjectRecord.DoorLock>1 Then
       Strng=Strng+" [locked]"
    Else
       If ObjectRecord.DoorLock=1 Then
          If ObjectRecord.Closed Then
             Strng=Strng+" [closed]"
          Endif
       Endif
    Endif
    If ObjectRecord.Invisible Then
       Strng=Strng+" [inv]"
    Else
       If MessWorkRecord6.Plus=Hidden.Object Then
          Strng=Strng+" [inv]"
       Endif
    Endif
    If Sysop And Debug.Mode Then
       Strng2=Rtrim$(ObjectRecord.PortalPassword)
       If Len(Strng2) Then
          Call Crypto(Strng2)
          Strng=Strng+" {"+Lcase$(Strng2)+"}"
       Endif
    Endif
    Strng=Strng+"."
    Call IO.O
    If Last.Command.Number=Identify.Command Then
       If ObjectRecord.KeyNumber Then
          Strng="It requires key number "
          Strng=Strng+Right$(Str$(ObjectRecord.KeyNumber+1000000!),6)+"."
	  Call IO.O
       Endif
       If ObjectRecord.LightRoom Then
          Strng="It is a light."
          Call IO.O
       Endif
       If ObjectRecord.SwitchType Then
          Strng="It is a switch."
          Call IO.O
       Endif
       If ObjectRecord.Trap Then
          Strng="It has a "

          Select Case ObjectRecord.Trap
          Case 1
             Strng=Strng+"poison needles "
          Case 2
             Strng=Strng+"falling door "
          Case 3
             Strng=Strng+"deadly spears "
          Case 4
             Strng=Strng+"blade barrier "
          Case 5
             Strng=Strng+"crushing ceiling "
          End Select

          Strng=Strng+"trap."
          Call IO.O
       Endif
    Endif
    Strng=ObjectRecord.LongDesc
    Strng=Rtrim$(Strng)
    If Strng<>Nul Then
       Call Convert.ANSI(True,VarQ,VarR)
       Graphics.On=True
       Call IO.O
       Graphics.On=False
    Endif
    Graphics.Off=False
    ' check for multiline description
    VarS2=False
    For VarS1=1 To 19
       If ObjectRecord.ObjDesc(VarS1)>0! Then
          VarS2=True
          Exit For
       Endif
    Next
    ' display multiline description
    If VarS2 Then
       FileName=Data.Path1+"objdesc.dat"
       Close #TempFile1
       Open FileName For Random Shared As #TempFile1 Len=80
       For TempY=1 To 19
          TempQ!=ObjectRecord.ObjDesc(TempY)
          If TempQ!>SFalse And TempQ!<=Lof(TempFile1)/80! Then
             Call Read.Record(ObjDescFile,TempQ!)
             Strng=BufferRecord.Buffer
             Strng=Rtrim$(Strng)
             Call Convert.String
             Call Convert.ANSI(True,VarQ,VarR)
             Graphics.On=True
             Call IO.O
             Graphics.On=False
          Endif
       Next
       Close #TempFile1
       Call More.Prompt
    Endif
    Graphics.Off=False
    Exit Sub
 Endif
 ' treasure
 If Temp7!>SFalse Then
    Graphics.Off=True
    If TreasureRecord.Scroll Then
       Graphics.Off=True
       Var$=Lcase$(Rtrim$(TreasureRecord.TreasureName))
       Var2$=Rtrim$(TreasureRecord.Prefix1)
       Strng="It's "+Var2$+Var$
       Call Convert.ANSI(True,VarQ,VarR)
       Carriage.Return=-1
       Graphics.On=True
       Call IO.O
       Graphics.On=False
       Graphics.Off=True
       Strng="!"
       Call IO.O
       Graphics.Off=False
       ' check if scroll was written on.
       Gosub Display.Scroll
       ' check scroll has spell.
       If TreasureRecord.Spell Then
          Temp2!=TreasureRecord.Spell
          If Temp2!>SFalse And Temp2!<=Lof(SpellFile)/SpellRecLen Then
             Graphics.Off=True
             Call Read.Record(SpellFile,Temp2!)
             Out2=SpellRecord.SpellName
             Out2=Rtrim$(Out2)
             Out2=Lcase$(Out2)
             Strng="It's spell is: "+Quote$+Out2+Quote$
             Call Convert.ANSI(True,VarQ,VarR)
             Graphics.On=True
             Call IO.O
             Graphics.On=False
	     Out2=SpellRecord.Chant
	     Out2=Rtrim$(Out2)
	     Out2=Lcase$(Out2)
             Strng="It reads: "+Quote$+Out2+Quote$
	     Call IO.O
             VarQ=True
          Endif
       Endif
       ' remove written messages.
       Close #LogFile
       FileName=DND.Path+"writing.log"
       Open FileName For Random Shared As #LogFile Len=LogRecLen
       For Var=1 To 4
          Temp1!=MessWorkRecord6.Desc(Var)
          If Temp1!>0! And Temp1!<=Lof(LogFile)/LogRecLen Then
             LogRecord.User=0!
             LogRecord.Message=Nul
             LogRecord.Clock=Nul
             Call Write.Record(LogFile,Temp1!)
          Endif
       Next
       ' always remove scrolls.
       If OptionZ2 Then
          Graphics.Off=False
          Strng="It disintegrated!"
          Call IO.O
          ' remove inventory.
          Select Case Temp4
          Case True ' in room inventory.
             Call Delete.List.Node(Temp5!)
             Call Clear.List.Node
             Call Write.Record(RoomInvFile,Temp5!)
          Case False ' in user inventory.
             For Var=1 To 4
                MessWorkRecord6.Desc(Var)=0!
             Next
             Call Write.Record(MessWorkFile6,Temp5!)
             Call Discard(Temp5!,True)
          End Select
       Endif
       Exit Sub
    Endif
    Strng=Prefix1+Rtrim$(TreasureRecord.Prefix1)+Out3
    Call Convert.ANSI(True,VarQ,VarR)
    Carriage.Return=True
    Graphics.On=True
    Call IO.O
    Graphics.On=False
    Strng=Nul
    If TreasureRecord.MasterKey Then
       Strng=Strng+" (#master)"
    Else
       If TreasureRecord.KeyNumber Then
          Strng=Strng+" (#"+Right$(Str$(TreasureRecord.KeyNumber+1000000!),6)+")"
       Endif
    Endif
    Temp1=TreasureRecord.Plus
    If Temp1 Then
       Call Treasure.Plus
       If Out2<>Nul Then
          Strng=Strng+" "+Out2
       Endif
    Endif
    If TreasureRecord.Vehicle Then
       If Temp1>False Then
          Strng=Strng+" (+"+Mid$(Str$(Temp1),2)+")"
       Endif
    Endif
    If TreasureRecord.Spell Then
       Call Read.Record(SpellFile,TreasureRecord.Spell)
       Strng=Strng+" (+"+Mid$(Str$(SpellRecord.Level),2)+")"
    Endif
    If TreasureRecord.LightType Then
       If Temp6>False Then
          Strng=Strng+" [unlit]"
       Endif
       If Temp6<False Then
          Strng=Strng+" [lit]"
       Endif
    Endif
    If TreasureRecord.Invisible Then
       Strng=Strng+" [inv]"
    Else
       If Temp4=True Then ' in room inventory.
          If MessWorkRecord6.Plus=Hidden.Object Then
             Strng=Strng+" [inv]"
          Endif
       Endif
    Endif
    Strng=Strng+"."
    Call IO.O
    If Temp6<False Then
       If TreasureRecord.LightType=False Then
          VarQ=Abs(Temp6)
          Select Case VarQ
          Case 1
             Strng="It has one charge."
          Case 2 To 10
             Strng="It has "+Rtrim$(Numeral(VarQ))+" charges."
          Case Else
             Strng="It has "+Form$(Cdbl(VarQ))+" charges."
          End Select
          Call IO.O
       Endif
    Endif
    If TreasureRecord.Vehicle Then
       Var2!=MessWorkRecord6.User
       If Var2!>SFalse And Var2!<=Lof(UserFile)/UserRecLen Then
          Call Read.Record(UserFile2,Var2!)
          Carriage.Return=True
          Strng="It's being used by "
          Call IO.O
          Strng=UserRecord2.CodeName
          Strng=Rtrim$(Strng)
          Strng=Lcase$(Strng)
          Strng=Left$(Strng,30)
          Mid$(Strng,1,1)=UCase$(Mid$(Strng,1,1))
          Strng=Rtrim$(UserRecord2.Prefix1)+Strng
          Call Convert.ANSI(True,VarQ,VarR)
          Carriage.Return=True
          Graphics.On=True
          Call IO.O
          Graphics.On=False
          Strng="."
          Call IO.O
          If TreasureRecord.Occupants>False Then
             Carriage.Return=True
             Strng="Passengers: "
             Call IO.O
             Var=False
             For Var2=1 To 4
                Var2!=MessWorkRecord6.Temp(Var2)
                If Var2!>SFalse And Var2!<=Lof(UserFile)/UserRecLen Then
                   Call Read.Record(UserFile2,Var2!)
                   Carriage.Return=True
                   Strng=UserRecord2.CodeName
                   Strng=Rtrim$(Strng)
                   Strng=Lcase$(Strng)
                   Mid$(Strng,1,1)=UCase$(Mid$(Strng,1,1))
                   Call IO.O
                   If Var Then
                      Strng=", "+Strng
                   Endif
                   Var=True
                Endif
             Next
             If Var Then
                Strng="."
             Else
                Strng="<none>"
             Endif
             Call IO.O
          Endif
       Endif
    Endif
    Strng="Treasure type: "
    VarQ=TreasureRecord.WeaponNumber
    If VarQ>=1 And VarQ<=10 Then
       Strng=Strng+Rtrim$(InventoryNames(VarQ))
       Select Case VarQ
       Case 2, 6
          Strng=Strng+"s"
       Case 4
          Strng=Strng+" (left hand)"
       Case 9
          Strng=Strng+" (right hand)"
       Case 7
          If TreasureRecord.TwoHanded Then
             Strng=Strng+" (two-handed)"
          Endif
       End Select
       Call IO.O
       If Rtrim$(TreasureRecord.ProperName)<>"" Then
          Strng="It's proper name is: "
          Var$=Lcase$(Rtrim$(TreasureRecord.ProperName))
          Mid$(Var$,1,1)=Ucase$(Mid$(Var$,1,1))
          Strng=Strng+Var$
          Call IO.O
       Endif
    Endif
    If TreasureRecord.Proficiency Then
       Strng=Weapon.Type.Name(TreasureRecord.Proficiency)
       Strng=Rtrim$(Strng)
       Strng="This is a "+Strng+" weapon."
       Call IO.O
    Endif
    VarQ=TreasureRecord.TimesCursed
    Select Case VarQ
    Case 1
       Strng="It's been cursed once.."
       Call IO.O
    Case Is>1
       Strng="It's been cursed "+Form$(Cdbl(VarQ))+" times.."
       Call IO.O
    End Select
    VarQ=TreasureRecord.TimesBlessed
    Select Case VarQ
    Case 1
       Strng="It's been blessed once.."
       Call IO.O
    Case Is>1
       Strng="It's been blessed "+Form$(Cdbl(VarQ))+" times.."
       Call IO.O
    End Select
    If Last.Command.Number=Identify.Command Then
       Var#=TreasureRecord.Gold
       Select Case Var#
       Case 0#
          Strng="It's worth zero gold pieces."
       Case 1#
          Strng="It's worth one gold piece."
       Case 2# To 10#
          Strng="It's worth "+Rtrim$(Numeral(Cint(Var#)))+" gold pieces."
       Case Else
          Call Amount(Var#,VarQ2$)
          Strng="It's worth"+VarQ2$+" gold pieces."
       End Select
       Call IO.O
       Var=TreasureRecord.Weight
       Select Case Var
       Case 0
          Strng="It weighs zero gold pieces."
       Case 1
          Strng="It weighs one gold piece."
       Case 2 To 10
          Strng="It weighs "+Rtrim$(Numeral(Var))+" gold pieces."
       Case Else
          Strng="It weighs "+Form$(Cdbl(Var))+" gold pieces."
       End Select
       Call IO.O
       VarX=TreasureRecord.RingType
       If VarX>=1 And VarX<=9 Then
          Strng=Nul
          Select Case VarX
          Case 1
             Strng="protection from poison"
          Case 2
             Strng="protection from level drain"
          Case 3
             Var1!=TreasureRecord.RingSpell
             If Var1!=STrue Then
                Strng="protection from any spell"
             Else
                If Var1!>SFalse And Var1!<=Lof(SpellFile)/SpellRecLen Then
                   Call Read.Record(SpellFile,Var1!)
                   If SpellRecord.SpellType=Invisibly Then
                      Strng="invisibility"
                   Else
                      Strng=Rtrim$(SpellRecord.Prefix1)
                      Strng="protection from "+Strng+Rtrim$(Lcase$(SpellRecord.SpellName))+" spell"
                   Endif
                Endif
             Endif
          Case 4
             Strng="protection from traps"
          Case 5
             Strng="protection from rust"
          Case 6
             Strng="protection from theft"
          Case 7
             Strng="protection from damage"
          Case 8
             Strng="protection from fumble"
          Case 9
             Strng="protection from teleporting"
          End Select
          If Len(Strng) Then
             Strng="It's ring spell is "+Strng
             Call Convert.ANSI(True,VarQ,VarR)
             Carriage.Return=True
             Graphics.On=True
             Call IO.O
             Graphics.On=False
             Strng="."
             Graphics.Off=True
             Call IO.O
          Endif
          If TreasureRecord.BindType Then
             Strng="It binds with a spell."
             Call IO.O
          Endif
       Endif
       If TreasureRecord.Spell Then
          Call Read.Record(SpellFile,TreasureRecord.Spell)
          Strng=Rtrim$(SpellRecord.Prefix1)
          Strng="It's magical spell is "+Strng+Rtrim$(SpellRecord.SpellName)+"."
          Call Convert.ANSI(True,VarQ,VarR)
          Graphics.On=True
          Call IO.O
          Graphics.On=False
          Graphics.Off=True
          If SpellRecord.SpellType=Teleporting Then
             If SpellRecord.Teleport<SFalse Then
                Strng="It prompts for room number."
                Call IO.O
             Endif
             If SpellRecord.Teleport>SFalse Then
                Strng="It teleports to room"+Str$(SpellRecord.Teleport)+"."
                Call IO.O
             Endif
          Endif
       Endif
       If TreasureRecord.Ammunition Or TreasureRecord.LaunchAmmo Then
	  Strng="It's ammunition."
	  Call IO.O
       Else
          If TreasureRecord.Potion Then
             If TreasureRecord.Liquid Then
                Strng="It's liquid."
             Else
                Strng="It's a potion."
             Endif
             Call IO.O
             Select Case Temp6
             Case IS<=False
                Strng="It has no charges."
             Case 1
                Strng="It has one charge."
             Case 2 To 10
                Strng="It has "+Rtrim$(Numeral(Temp6))+" charges."
             Case Else
                Strng="It has "+Form$(Cdbl(Temp6))+" charges."
             End Select
             Call IO.O
          Else
             If TreasureRecord.Edible Then
                If (TreasureRecord.Edible And 1)=1 Then
                   Strng="It's edible."
                   Call IO.O
                Endif
                If (TreasureRecord.Edible And 2)=2 Then
                   Strng="It's slippery."
                   Call IO.O
                Endif
                If (TreasureRecord.Edible And 4)=4 Then
                   Strng="It's smokable."
                   Call IO.O
                Endif
                If (TreasureRecord.Edible And 8)=8 Then
                   Strng="It's burnable."
                   Call IO.O
                Endif
                Select Case Abs(Temp6)
                Case 0
                   Strng="It has no charges."
                Case 1
                   Strng="It has one charge."
                Case 2 To 10
                   Strng="It has "+Rtrim$(Numeral(Abs(Temp6)))+" charges."
                Case Else
                   Strng="It has "+Form$(Cdbl(Abs(Temp6)))+" charges."
                End Select
                Call IO.O
             Else
                If TreasureRecord.Vehicle Then
                   Strng="It's a vehicle."
                   Call IO.O
                   Select Case Temp6
                   Case -1
                      Strng="It cannot be hit."
                   Case 0
                      Strng="It has no charges."
                   Case 1
                      Strng="It has one charge."
                   Case 2 To 10
                      Strng="It has "+Rtrim$(Numeral(Temp6))+" charges."
                   Case Else
                      Strng="It has "+Form$(Cdbl(Temp6))+" charges."
                   End Select
                   Call IO.O
                Else
                   If TreasureRecord.LightType Then
                      If Temp6<=False Then
                         Select Case Abs(Temp6)
                         Case 0
                            Strng="It's not fueled."
                         Case 1
                            Strng="It's fueled with one charge."
                         Case 2 To 10
                            Strng="It's fueled with "+Rtrim$(Numeral(Abs(Temp6)))+" charges."
                         Case Else
                            Strng="It's fueled with "+Form$(Cdbl(Abs(Temp6)))+" charges."
                         End Select
                         Call IO.O
                      Endif
                   Else
                      If TreasureRecord.Loadable Or TreasureRecord.Launchable Then
                         Select Case Temp6
                         Case IS<=0
                            Strng="It's not loaded."
                         Case 1
                            Strng="It's loaded with one charge."
                         Case 2 To 10
                            Strng="It's loaded with "+Rtrim$(Numeral(Temp6))+" charges."
                         Case Else
                            Strng="It's loaded with "+Form$(Cdbl(Temp6))+" charges."
                         End Select
                         Call IO.O
                      Else
                         If TreasureRecord.RingType Or TreasureRecord.Spell Or TreasureRecord.Plus Then
                            Select Case Temp6
                            Case IS<=0
                               Strng="It has no charges."
                            Case 1
                               Strng="It has one charge."
                            Case 2 To 10
                               Strng="It has "+Rtrim$(Numeral(Temp6))+" charges."
                            Case Else
                               Strng="It has "+Form$(Cdbl(Temp6))+" charges."
                            End Select
                            Call IO.O
                         Endif
                      Endif
                   Endif
                Endif
             Endif
          Endif
       Endif
       If TreasureRecord.Persistent Then
          Strng="It's persistent("+Mid$(Str$(TreasureRecord.PersistTime),2)+" sec.)"
          Call IO.O
          Strng="Persistent charges:"+Str$(TreasureRecord.MaxPersistCharges)
          Call IO.O
          If TreasureRecord.DischargePersist>0 Then
             Strng="Persist discharges:"+Str$(TreasureRecord.DischargePersist)+" sec."
             Call IO.O
          Endif
       Endif
    Endif
    Graphics.Off=False
    Exit Sub
 Endif
 Strng="You can't examine that!"
 Call IO.O
 Exit Sub

' check if item was written on.
Display.Scroll:
 VarQ=False
 Close #LogFile
 FileName=DND.Path+"writing.log"
 Open FileName For Random Shared As #LogFile Len=LogRecLen
 For Var=1 To 4
    Temp1!=MessWorkRecord6.Desc(Var)
    If Temp1!>0! And Temp1!<=Lof(LogFile)/LogRecLen Then
       Call Read.Record(LogFile,Temp1!)
       Var$=Rtrim$(LogRecord.Message)
       If Len(Var$) Then
          Strng="It was written on at "
          Var2!=LogRecord.User
          If Var2!>0! And Var2!<=Lof(UserFile2)/UserRecLen Then
             Call Read.Record(UserFile2,Var2!)
             Strng2=UserRecord2.CodeName
             Call Valid.Name(Strng2)
             If TempA Then
                Strng=Lcase$(Rtrim$(Strng2))+" wrote on it at "
                Mid$(Strng,1,1)=Ucase$(Mid$(Strng,1,1))
             Endif
          Endif
          Strng=Strng+Logrecord.Clock+".."
          Graphics.Off=True
          Call IO.O
          Strng=Var$
          Call Convert.String
          Call Convert.ANSI(True,VarQ,VarR)
          Graphics.Off=False
          Graphics.On=True
          Call IO.O
          Graphics.On=False
          VarQ=True
       Endif
    Endif
 Next
 Return

Get.Config3:
 VarX=0
 Gosub Reset.Options
 Do
    VarX=VarX+1
    If VarX>Options.Lines Then
       Goto Next.Read
       Exit Do
    Endif
    Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
    If Ucase$(Var$)="[CMD083]" Then
       Do
          VarX=VarX+1
          If VarX>Options.Lines Then
             Goto Next.Read
             Return
          Endif
          Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
          If Ucase$(Var$)="[END]" Then
             Goto Next.Read
             Return
          Endif
          Var=Instr(Var$,"=")
          If Var Then
             Var2$=Lcase$(Ltrim$(Rtrim$(Left$(Var$,Var-1))))
             Var3Z$=Lcase$(Ltrim$(Rtrim$(Mid$(Var$,Var+1))))
             Gosub Parse.Options
          Endif
       Loop
    Endif
 Loop
 Return
Next.Read:
 Close #TempFile1
 Filename$=DND.Path+"CMD083.CFG"
 If Dir$(Filename$)="" Then
    Return
 Endif
 Open Filename$ For Input As #TempFile1
 Do
    If Eof(TempFile1) Then
       Exit Do
    Endif
    Line Input #TempFile1, Var$
    Var$=Ltrim$(Rtrim$(Var$))
    If Left$(Var$,1)<>";" Then
       VarX$=UserRecord.CodeName
       VarX$=Rtrim$(VarX$)
       VarX$=Ucase$(VarX$)
       If Ucase$(Var$)="["+VarX$+"]" Then
          VarZ=0
          Gosub Reset.Options
          Do
             If Eof(TempFile1) Then
                Exit Do
             Endif
             Line Input #TempFile1, Var$
             If Ucase$(Var$)="[END]" Then
                Return
             Endif
             Var=Instr(Var$,"=")
             If Var Then
                Var2$=Ltrim$(Rtrim$(Left$(Var$,Var-1)))
                Var3$=Ltrim$(Rtrim$(Mid$(Var$,Var+1)))
                Gosub Parse.Options
             Endif
          Loop
       Endif
   Endif
 Loop
 Return

Reset.Options:
 Option0=-1
 Option1=-1 : Option2=-1 : Option3=-1 : Option4=-1
 Option5=-1 : Option6=-1 : Option7=-1 : Option8=-1
 Option9=-1 : Option10=-1 : Option11=-1 : Option12=-1 : Option13=-1
 OptionZ=-1 : OptionZ1=-1 : OptionZ2 = -1 : Option10$=""
 Return

Parse.Options:
 Select Case Var2$
 Case "scroll.always.deletes"
    Select Case Var3Z$
    Case "0", "false", "off"
       OptionZ2=0
    End Select
 Case "allow.user.look0"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option0=0
    End Select
 Case "allow.user.look1"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option1=0
    End Select
 Case "allow.user.look2"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option2=0
    End Select
 Case "allow.user.look3"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option3=0
    End Select
 Case "allow.user.look4"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option4=0
    End Select
 Case "allow.user.look5"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option5=0
    End Select
 Case "allow.user.look6"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option6=0
    End Select
 Case "allow.user.look7"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option7=0
    End Select
 Case "allow.user.look8"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option8=0
    End Select
 Case "allow.user.look9"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option9=0
    End Select
 Case "allow.user.look10"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option10=0
    End Select
 Case "allow.user.look11"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option11=0
    End Select
 Case "allow.user.look12"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option12=0
    End Select
 Case "allow.user.look13"
    Select Case Var3Z$
    Case "0", "false", "off"
       Option13=0
    End Select
 Case "allow.user.look14"
    Select Case Var3Z$
    Case "0", "false", "off"
       OptionZ1=0
    End Select
 Case "allow.sysop.look"
    Select Case Var3Z$
    Case "0", "false", "off"
       OptionZ=0
    End Select
 Case "excludefilelist"
    Option10$=Var3Z$
 End Select
 Return

Check.Filename:
 If Left$(VarZ2$,1)=Chr$(34) And Right$(VarZ2$,1)=Chr$(34) Then
    VarZ2$=Left$(VarZ2$,Len(VarZ2$)-1):VarZ2$=Mid$(VarZ2$,2)
 Endif
 If Len(VarZ2$) Then
    If Left$(Lcase$(Parsed.Command1),Len(VarZ2$))=VarZ2$ Then
       Strng="You can't examine that!"
       Call IO.O
       Exit Sub
    Endif
 Endif
 Return

Get.Config2:
 VarX=0
 Strng=Nul
 Do
    VarX=VarX+1
    If VarX>Options.Lines Then
       Goto Next.Read2
       Exit Do
    Endif
    Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
    If Ucase$(Var$)="[CMD004]" Then
       Do
          VarX=VarX+1
          If VarX>Options.Lines Then
             Goto Next.Read2
             Return
          Endif
          Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
          If Ucase$(Var$)="[END]" Then
             Goto Next.Read2
             Return
          Endif
          Var=Instr(Var$,"=")
          If Var Then
             Var4$=Ltrim$(Rtrim$(Left$(Var$,Var-1)))
             Var5$=Ltrim$(Rtrim$(Mid$(Var$,Var+1)))
             If Left$(Lcase$(Var4$),15)="sysop.page.time" Then
                VarQ=Int(Val(Mid$(Var4$,16))+.5)
                If VarQ>=1 And VarQ<=9 Then
                   Strng=Strng+Var5$+", "
                Endif
             Endif
          Endif
       Loop
    Endif
 Loop
 Return
Next.Read2:
 Close #TempFile1
 Filename$=DND.Path+"CMD004.CFG"
 If Dir$(Filename$)="" Then
    Return
 Endif
 Open Filename$ For Input As #TempFile1
 Do
    If Eof(TempFile1) Then
       Exit Do
    Endif
    Line Input #TempFile1, Var$
    Var$=Ltrim$(Rtrim$(Var$))
    If Left$(Var$,1)<>";" Then
       VarX$=UserRecord.CodeName
       VarX$=Rtrim$(VarX$)
       VarX$=Ucase$(VarX$)
       If Ucase$(Var$)="["+VarX$+"]" Then
          VarZ=0
          Strng=Nul
          Do
             If Eof(TempFile1) Then
                Exit Do
             Endif
             Line Input #TempFile1, Var$
             If Ucase$(Var$)="[END]" Then
                Return
             Endif
             Var=Instr(Var$,"=")
             If Var Then
                Var4$=Ltrim$(Rtrim$(Left$(Var$,Var-1)))
                Var5$=Ltrim$(Rtrim$(Mid$(Var$,Var+1)))
                If Left$(Lcase$(Var4$),15)="sysop.page.time" Then
                   VarQ=Int(Val(Mid$(Var4$,16))+.5)
                   If VarQ>=1 And VarQ<=9 Then
                      Strng=Strng+Var5$+", "
                   Endif
                Endif
             Endif
          Loop
       Endif
    Endif
 Loop
 Return
ErrorRsm33:
 Exit Sub
ErrorTrp33:
 Resume ErrorRsm33
End Sub

' parse the BLASTER environment string and return settings.
SUB GetBlaster (BasePort%, Channel%, SpeakerVolume, DSPVersion!, IRQ%, CardType)

 REM SET BLASTER=A220 I5 D1 H5 P330 T3 V9
 BasePort% = &H220
 Channel% = &H1
 IRQ% = 7
 SpeakerVolume = 13
 Var$ = Environ$("BLASTER")
 If Var$ = "" Then
    BasePort% = 0%
    Exit Sub
 Endif
 If Var$ = "A0" Then
    BasePort% = 0%
    Exit Sub
 Endif
 IF Var$ <> "" THEN ' default values
    Var% = INSTR(Var$, "A") ' base IO port
    If Var% Then ' A220
       BasePort% = VAL("&H" + MID$(Var$, Var% + 1, 3))
    Endif
    Var% = INSTR(Var$, "D") ' 8-bit DMA channel
    If Var% Then ' D1
       Channel% = VAL(MID$(Var$, Var% + 1, 1))
    Endif
    Var% = INSTR(Var$, "I") ' IRQ
    If Var% Then ' I7
       IRQ% = VAL(MID$(Var$, Var% + 1, 1))
    Endif
    Var% = INSTR(Var$, "T") ' cardtype
    If Var% Then ' T3
       CardType = VAL(MID$(Var$, Var% + 1, 1))
    Endif
    SpeakerVolume=13
    Var% = INSTR(Var$, "V") ' speaker volume
    If Var% Then ' V1
       SpeakerVolume = VAL(MID$(Var$, Var% + 1))
    Endif
 END IF

REM Gets the DSP version.
 ' Writes version request byte to the DSP
 Call WriteDSP (BasePort%, &HE1%)

 ' Reads version bytes from the DSP
 Call ReadDSP(BasePort%, Temp%)
 Call ReadDSP(BasePort%, Temp2%)

 DSPVersion! = VAL(STR$(Temp%) + "." + STR$(Temp2%))

 Var$ = Environ$("BLASTERVOLUME")
 IF Len(Var$) THEN ' default volume
    SpeakerVolume=Int(Val(Var$)+.5)
 Endif
END SUB

SUB WriteDSP (BasePort%, b%)
' Writes a byte to the DSP
 DO
    VarX=VarX+1
    If VarX>1024 Then
       Exit Do
    Endif
 LOOP WHILE INP(BasePort% + 12) AND &H80
 OUT BasePort% + 12, b%
END SUB

SUB ReadDSP (BasePort%, b%)
' Reads a byte from the DSP
 DO
    VarX=VarX+1
    If VarX>1024 Then
       Exit Do
    Endif
 LOOP WHILE INP(BasePort% + 14) AND &H80
 b% = INP(BasePort% + 10)
END SUB
