 Rem File: Cmd008.bas
 Rem Sub: Bank
 Rem $Include: 'dndbbs.inc'

 On Error Goto Main.Error
 If Chained=0 Then ' local mode
    Call Get.Node
    Call Open.Arrays
    Call Get.Config
    Call Increase.Files
    Call Make.FileNames
    Call Reset.Cursor
    Call Detect.Share
    Call Open.Files
    Call Read.Options
    Call Valid.Node
    Call Save.Screen2(0)
    Color 14,0
    Print "DNDBBS CMD008 - Bank"
    Var$=Nul
    If Command$<>Nul Then
       Var$=Command$
    Endif
    Call Alt.Login(Var,Var$)
    If Var=False Then
       If Lost.Carrier=False Then
          Color 14,0
          Print "Codename not found."
       Endif
       Call More.Prompt
       Goto Main.Resume
    Endif
    Call Search.Mess.File(User.Index,Var1)
    If Var1 Then
       Color 14,0
       Print "Codename is in use."
       Call More.Prompt
       Goto Main.Resume
    Endif
    Call Get.User.Stats(Var)
    Timeon=Timeit!
    Time.Left=3600!
    Date.On = Format$(Now,"mm-dd-yyyy")
    Time.On = Format$(Now,"hh:mm:ss")
 Else
    TempA$=Config3$(94)
    TempB$=Config3$(95)
 Endif
 Call Bank
Main.Resume:
 If Chained=-2 Then
    Chain DND.Path+"DNDBBS.EXE"
 Endif
 Call Clear.Status.Line
 Call ScreenANSI(1,37,7)
 Color 7, 0
 Cls
 Call Save.Screen2(-1)
' Locate Max.Row,1,1
 If TempX=0 Then TempX=1
 Locate TempX,1,1
 Color 15,0
 Print
 Print "Now exiting Bank.."
 Color 7,0
 Call Decrease.Files
 End
Main.Error:
 Resume Main.Resume

REM PostType key:
REM   A = User account
REM       UserIndex=True: bank balance.
REM   B = User loan
REM   C = Bank deposit
REM   D = Bank withdraw
REM   I = Interest posted
REM   T = Bank transfer: no gold moved through bank.

REM PostSubType key:
REM   A = Account balance
REM   B = Borrowed
REM   D = Deposit
REM       PostSubType2=1: user investment.
REM   I = Interest posted
REM       PostSubType2=1: bank interest.
REM       PostSubType2=2: user account interest.
REM       PostSubType2=3: user loan interest.
REM   P = Payment
REM       PostSubType2=1: loan payment during login.
REM       PostSubType2=2: loan payment from bank account.
REM       PostSubType2=3: loan payment from gold.
REM       PostSubType2=4: loan payment interest from bank.
REM       PostSubType2=5: loan payment interest from gold.
REM   T = Transfer
REM       PostSubType2=False: gold transfered.
REM       PostSubType2=1: gold charge for transfer.
REM   W = Withdraw

REM Maximum balance = 1.79769313486231D+308
REM   Bank overflows Borrow, Deposit, Invest, Transfer and Withdraw at 1D308

Sub Bank
 On Local Error Goto Error.Trap53
 Gosub Get.Config
 If GuestLogin Then
    If GuestRecord.GuestAllowBank=False Then
       Strng="Guests cannot use the bank.."
       Call IO.O
       Exit Sub
    Endif
 Endif
 If Local.Mode=False Then
    TempA=True
    If Config2(50)=False Then
       Call In.Room(15)
    Endif
    If TempA=False Then
       Strng="Find the Bank Shoppe!"
       Call IO.O
       If Sysop Or Local.Mode Then
          Strng="Bank shoppe: "+Rtrim$(Room.Array(15))
          Call IO.O
       Endif
       Exit Sub
    Endif
 Endif
Bank.Error:
 Close #TempFile1
 FileName=Data.Path1+Bank.FileName+File.Extension1
 Open FileName For Random As #TempFile1 Len=BankRecLen
 Do While Lost.Carrier=False
    Call Bank.Status.Line
    Graphics.Off=False
    Strng="The broker asks: What can I do for you(?=Help): "
    No.Input.Out="Q"
    Call IO.I
    Select Case Ucase$(Out2)
    Case "?"
       Gosub Bank.Help
    Case "I"
       If UserRecord.Gold<=DFalse Then
          Strng="You have no gold to invest!"
          Call IO.O
       Else
          Call Extend.Amount2(MaxGold#,VarQ$)
          Strng="Maximum gold: "+Ltrim$(VarQ$)
          Call IO.O
          Call Extend.Amount2(UserRecord.Gold,VarQ$)
          Strng="How much(1-"+Ltrim$(VarQ$)+",<all>)?"
          Call IO.I
          If Lcase$(Out2)="all" Then
             Temp3#=UserRecord.Gold
          Else
             Temp3#=Int(Val(Out2)+.5)
          Endif
          If Temp3#>MaxGold# Then
             Strng="You can't invest that much!"
             Call IO.O
          Else
          If Temp3#<=DFalse Or Temp3#>UserRecord.Gold Then
             Strng="You don't have that much gold!"
             Call IO.O
          Else
             Dnow$=DateS$
             Tnow$=Format$(Now,"hh:mm:ss")
             UserRecord.Gold=UserRecord.Gold-Temp3#
             Call Write.Record(UserFile,User.Index)
             BankRecord.UserIndex = User.Index
             BankRecord.DatePost = Dnow$
             BankRecord.TimePost = Tnow$
             BankRecord.Balance = UserRecord.Bank
             BankRecord.Deleted = False
             BankRecord.PostAmount = Temp3#
             BankRecord.PostType = "A"
             BankRecord.PostSubType = "D"
             BankRecord.PostSubType2 = 1
             BankRecord.From=Nul
             BankRecord.To=Nul
             z! = LOF(TempFile1) / BankRecLen + 1!
             Call Write.Record(BankFile,z!)
             BankRecord.UserIndex = True
             BankRecord.DatePost = Dnow$
             BankRecord.TimePost = Tnow$
             BankRecord.Deleted = False
             BankRecord.PostAmount = Temp3#
             BankRecord.PostType = "C"
             BankRecord.PostSubType = "D"
             BankRecord.PostSubType2 = 1
             BankRecord.From = UserRecord.Codename
             BankRecord.To=Nul
             z! = LOF(TempFile1) / BankRecLen + 1!
             Call Write.Record(BankFile,z!)
             Call Extend.Amount2(Temp3#,Var$)
             Strng="Invest:"+Var$
             Call Bank.Log(Strng)
             Strng="You hand him the gold."
             Call IO.O
          Endif
          Endif
       Endif
    Case "D"
       If UserRecord.Gold<=DFalse Then
          Strng="You have no gold to deposit!"
          Call IO.O
       Else
          Call Extend.Amount2(MaxGold#,VarQ$)
          Strng="Maximum gold: "+Ltrim$(VarQ$)
          Call IO.O
          Call Extend.Amount2(UserRecord.Gold,VarQ$)
          Strng="How much(1-"+Ltrim$(VarQ$)+",<all>)?"
          Call IO.I
          If Lcase$(Out2)="all" Then
             Temp3#=UserRecord.Gold
          Else
             Temp3#=Int(Val(Out2)+.5)
          Endif
          If Temp3#>MaxGold# Then
             Strng="You can't deposit that much!"
             Call IO.O
          Else
          If Temp3#<=DFalse Or Temp3#>UserRecord.Gold Then
             Strng="You don't have that much gold!"
             Call IO.O
          Else
             Dnow$=DateS$
             Tnow$=Format$(Now,"hh:mm:ss")
             UserRecord.Bank=UserRecord.Bank+Temp3#
             UserRecord.Gold=UserRecord.Gold-Temp3#
             Call Write.Record(UserFile,User.Index)
             BankRecord.UserIndex = User.Index
             BankRecord.DatePost = Dnow$
             BankRecord.TimePost = Tnow$
             BankRecord.Balance = UserRecord.Bank
             BankRecord.Deleted = False
             BankRecord.PostAmount = Temp3#
             BankRecord.PostType = "A"
             BankRecord.PostSubType = "D"
             BankRecord.PostSubType2 = False
             BankRecord.From=Nul
             BankRecord.To=Nul
             z! = LOF(TempFile1) / BankRecLen + 1!
             Call Write.Record(BankFile,z!)
             BankRecord.UserIndex = True
             BankRecord.DatePost = Dnow$
             BankRecord.TimePost = Tnow$
             BankRecord.Deleted = False
             BankRecord.PostAmount = Temp3#
             BankRecord.PostType = "C"
             BankRecord.PostSubType = "D"
             BankRecord.PostSubType2 = False
             BankRecord.From = UserRecord.Codename
             BankRecord.To=Nul
             z! = LOF(TempFile1) / BankRecLen + 1!
             Call Write.Record(BankFile,z!)
             Call Extend.Amount2(Temp3#,Var$)
             Strng="Deposit:"+Var$
             Call Bank.Log(Strng)
             Strng="You hand him the gold."
             Call IO.O
          Endif
          Endif
       Endif
    Case "T"
       If UserRecord.Bank<=DFalse Then
          Strng="You have nothing in your account to transfer!"
          Call IO.O
       Else
          Call Extend.Amount2(MaxGold#,VarQ$)
          Strng="Maximum gold: "+Ltrim$(VarQ$)
          Call IO.O
          Call Extend.Amount2(UserRecord.Bank,VarQ$)
          Strng="How much(1-"+Ltrim$(VarQ$)+",<all>)?"
          Call IO.I
          If Lcase$(Out2)="all" Then
             Temp3#=UserRecord.Bank
             Temp4#=0#
          Else
             Temp3#=Int(Val(Out2)+.5)
             Temp4#=Cdbl(BankFee)
             If Temp4#<0# Then
                Temp4#=0#
             Endif
          Endif
          If Temp3#<=0# Or Temp3#>MaxGold# Then
             Strng="You can't transfer that much!"
             Call IO.O
          Else
          If Instr(Str$(Temp4#),"D") Then
             Temp4#=0#
          Endif
          If Instr(Str$(Temp3#),"D") Then
             Temp4#=0#
          Endif
          If Temp4#>0# Then
             Strng="Pay"+Str$(Temp4#)+" gold for the transfer(y/n)? "
             Call IO.I
          Else
             Yes=True
          Endif
          If Yes Then
             If Temp3#<=DFalse Or Temp3#+Temp4#>UserRecord.Bank Then
                Strng="You don't have that much gold in the bank!"
                Call IO.O
             Else
                Strng="Transfer to what person?"
                Call IO.I
                Out2=Rtrim$(Out2)
                Out2=Ucase$(Out2)
                Temp1=False
                For Temp.User.Index=1! To Lof(UserFile2)/UserRecLen
                   Call Read.Record(UserFile2,Temp.User.Index)
                   Strng=UserRecord2.CodeName
                   Strng=Rtrim$(Strng)
                   Strng=Ucase$(Strng)
                   If Strng=Out2 Then
                      If User.Index<>Temp.User.Index Then
                         Var2$=Strng
                         Var2$=Lcase$(Var2$)
                         If Len(Var2$) Then
                            Mid$(Var2$,1,1)=Ucase$(Mid$(Var2$,1,1))
                         Endif
                         Temp1=True
                         Exit For
                      Endif
                   Endif
                Next
                If Temp1=False Then
                   Strng="There's nobody in my ledgers with that name!"
                   Call IO.O
                Else
                   Dnow$=DateS$
                   Tnow$=Format$(Now,"hh:mm:ss")
                   ' record gold deposited to user.
                   UserRecord2.Bank=UserRecord2.Bank+Temp3#
                   Call Write.Record(UserFile2,Temp.User.Index)
                   BankRecord.UserIndex = Temp.User.Index
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Balance = UserRecord2.Bank
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp3#
                   BankRecord.PostType = "A"
                   BankRecord.PostSubType = "T"
                   BankRecord.PostSubType2 = False
                   BankRecord.From = UserRecord.Codename
                   BankRecord.To = UserRecord2.Codename
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   ' record gold withdrawn from user.
                   UserRecord.Bank=UserRecord.Bank-Temp3#
                   BankRecord.UserIndex = User.Index
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Balance = UserRecord.Bank
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp3#
                   BankRecord.PostType = "A"
                   BankRecord.PostSubType = "T"
                   BankRecord.PostSubType2 = False
                   BankRecord.From = UserRecord.Codename
                   BankRecord.To = UserRecord2.Codename
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   ' record gold charged from user.
                   If Temp4#>0# Then
                      UserRecord.Bank=UserRecord.Bank-Temp4#
                      BankRecord.UserIndex = User.Index
                      BankRecord.DatePost = Dnow$
                      BankRecord.TimePost = Tnow$
                      BankRecord.Balance = UserRecord.Bank
                      BankRecord.Deleted = False
                      BankRecord.PostAmount = 3#
                      BankRecord.PostType = "A"
                      BankRecord.PostSubType = "T"
                      BankRecord.PostSubType2 = 1
                      BankRecord.From = UserRecord.Codename
                      BankRecord.To = UserRecord2.Codename
                      z! = LOF(TempFile1) / BankRecLen + 1!
                      Call Write.Record(BankFile,z!)
                   Endif
                   ' record bank transfer amount.
                   BankRecord.UserIndex = True
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp3#
                   BankRecord.PostType = "T"
                   BankRecord.PostSubType = "T"
                   BankRecord.PostSubType2 = False
                   BankRecord.From = UserRecord.Codename
                   BankRecord.To = UserRecord2.Codename
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   ' record bank gold charged for transfer.
                   If Temp4#>0# Then
                      BankRecord.UserIndex = True
                      BankRecord.DatePost = Dnow$
                      BankRecord.TimePost = Tnow$
                      BankRecord.Deleted = False
                      BankRecord.PostAmount = Temp4#
                      BankRecord.PostType = "C"
                      BankRecord.PostSubType = "T"
                      BankRecord.PostSubType2 = 1
                      BankRecord.From = UserRecord.Codename
                      BankRecord.To = UserRecord2.Codename
                      z! = LOF(TempFile1) / BankRecLen + 1!
                      Call Write.Record(BankFile,z!)
                   Endif
                   Call Extend.Amount2(Temp3#,Var$)
                   Strng="Transfer to: "+Var2$+";"+Var$
                   Call Bank.Log(Strng)
                   If Temp4#>0# Then
                      Strng="Transfer to: "+Var2$+": Charge;"+Str$(Temp4#)
                      Call Bank.Log(Strng)
                   Endif
                   Call Read.Record(UserFile,User.Index)
                   Var2$=UserRecord.CodeName
                   Var2$=Rtrim$(Var2$)
                   Var2$=Lcase$(Var2$)
                   If Len(Var2$) Then
                      Mid$(Var2$,1,1)=Ucase$(Mid$(Var2$,1,1))
                   Endif
                   Call Extend.Amount2(Temp3#,VarQ$)
                   Var$=Var2$+" transferred"+VarQ$+" gold to your account"

                   Close #LogFile
                   Open Log.FileName For Random Shared As #LogFile Len=LogRecLen
                   Temp1!=Lof(LogFile)/LogRecLen+1!
                   LogRecord.Message=Var$
                   LogRecord.Clock=Fclock2$
                   LogRecord.User=Temp.User.Index
                   Call Write.Record(LogFile,Temp1!)
                   Close #LogFile

                   Strng="The broker works with his ledgers for a while."
                   Call IO.O
                   Call Extend.Amount2(Temp3#,VarQ$)
                   VarQ$=Ltrim$(VarQ$)
                   Strng="And says '"+VarQ$+" transferred to the account.'"
                   Call IO.O
                Endif
             Endif
          Endif
          Endif
       Endif
    Case "W"
       If UserRecord.Bank<=DFalse Then
          Strng="You have nothing to withdraw!"
          Call IO.O
       Else
          If UserRecord.Borrow>DFalse Then
             Strng="You must pay back your loan first!"
             Call IO.O
          Else
             Call Extend.Amount2(MaxGold#,VarQ$)
             Strng="Maximum gold: "+Ltrim$(VarQ$)
             Call IO.O
             Call Extend.Amount2(UserRecord.Bank,VarQ$)
             Strng="How much(1-"+Ltrim$(VarQ$)+",<all>)?"
             Call IO.I
             If Lcase$(Out2)="all" Then
                Temp3#=UserRecord.Bank
             Else
                Temp3#=Int(Val(Out2)+.5)
             Endif
             If Temp3#<=DFalse Or Temp3#>UserRecord.Bank Then
                Strng="You don't have that much gold!"
                Call IO.O
             Else
                If Temp3#>MaxGold# Then
                   Strng="You can't withdraw that much!"
                   Call IO.O
                Else
                Dnow$=DateS$
                Tnow$=Format$(Now,"hh:mm:ss")
                UserRecord.Bank=UserRecord.Bank-Temp3#
                UserRecord.Gold=UserRecord.Gold+Temp3#
                Call Write.Record(UserFile,User.Index)
                BankRecord.UserIndex = User.Index
                BankRecord.DatePost = Dnow$
                BankRecord.TimePost = Tnow$
                BankRecord.Balance = UserRecord.Bank
                BankRecord.Deleted = False
                BankRecord.PostAmount = Temp3#
                BankRecord.PostType = "A"
                BankRecord.PostSubType = "W"
                BankRecord.PostSubType2 = False
                BankRecord.From=Nul
                BankRecord.To=Nul
                z! = LOF(TempFile1) / BankRecLen + 1!
                Call Write.Record(BankFile,z!)
                BankRecord.UserIndex = True
                BankRecord.DatePost = Dnow$
                BankRecord.TimePost = Tnow$
                BankRecord.Deleted = False
                BankRecord.PostAmount = Temp3#
                BankRecord.PostType = "D"
                BankRecord.PostSubType = "W"
                BankRecord.PostSubType2 = False
                BankRecord.From = UserRecord.Codename
                BankRecord.To=Nul
                z! = LOF(TempFile1) / BankRecLen + 1!
                Call Write.Record(BankFile,z!)
                Call Extend.Amount2(Temp3#,Var$)
                Strng="Withdraw:"+Var$
                Call Bank.Log(Strng)
                Strng="The broker hands you the gold."
                Call IO.O
                Endif
             Endif
          Endif
       Endif
    Case "B"
       Gosub Bank.Balance
       If TempX#<DFalse Then
          Strng="You can't! The bank is broke!"
          Call IO.O
       Else
          If UserRecord.Level<10 Then
             Amount2#=Int(Val(TempA$)+.5)
          Else
             Amount2#=Int(Val(TempB$)+.5)
          Endif
          If Amount2#<=DFalse Then
             Amount2#=1000#
          Endif
          If Amount2#>MaxGold# Then
             Amount2#=MaxGold#
          Endif
          If UserRecord.Borrow>=Amount2# Then
             Strng="The broker says: You can't borrow any more!"
             Call IO.O
          Else
             Call Extend.Amount2(MaxGold#,VarQ$)
             Strng="Maximum gold: "+Ltrim$(VarQ$)
             Call IO.O
             TempX#=Amount2#-UserRecord.Borrow
             Call Extend.Amount2(TempX#,VarQ$)
             Strng="How much will you borrow(1-"+Ltrim$(VarQ$)+",<all>)?"
             Call IO.I
             If Lcase$(Out2)="all" Then
                Temp2#=TempX#
             Else
                Temp2#=Int(Val(Out2)+.5)
             Endif
             If Temp2#<=DFalse Or Temp2#>TempX# Then
                Strng="The broker says: You can't borrow that much!"
                Call IO.O
             Else
                If Temp2#>MaxGold# Then
                   Strng="You can't borrow that much!"
                   Call IO.O
                Else
                   Dnow$=DateS$
                   Tnow$=Format$(Now,"hh:mm:ss")
                   UserRecord.Gold=UserRecord.Gold+Temp2#
                   UserRecord.Borrow=UserRecord.Borrow+Temp2#
                   BankRecord.UserIndex = User.Index
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Balance = UserRecord.Borrow
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp2#
                   BankRecord.PostType = "B"
                   BankRecord.PostSubType = "B"
                   BankRecord.PostSubType2 = False
                   BankRecord.From=Nul
                   BankRecord.To=Nul
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   BankRecord.UserIndex = True
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.PostAmount = Temp2#
                   BankRecord.Deleted = False
                   BankRecord.PostType = "D"
                   BankRecord.PostSubType = "B"
                   BankRecord.PostSubType2 = False
                   BankRecord.From = UserRecord.Codename
                   BankRecord.To=Nul
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   Call Extend.Amount2(Temp3#,Var$)
                   Strng="Borrow:"+Var$
                   Call Bank.Log(Strng)
                   Strng="The broker hands you the gold."
                   Call IO.O
                Endif
             Endif
          Endif
       Endif
    Case "P"
       GOSUB Loan.Interest
       Graphics.Off=True
       If UserRecord.Borrow<=DFalse And p2#<=DFalse Then
          Strng="You don't have any debt with the bank!"
          Call IO.O
       Else
          If UserRecord.Bank>DFalse Then
             Call Extend.Amount2(p2#,Var$)
             Strng2=Format$(TNow#,"ddd dd mmm yy\, hh:mma/p")
             Strng="Loan account interest accrued for "+Strng2+" is"+Var$+" gold."
             Call IO.O
             Var1=False
             Strng="The broker asks: Pay back with your current bank account(y/n)? "
             No.Input.Out="Y"
             Call IO.I
             If Yes Then
                p3#=DFalse
                If UserRecord.Borrow-UserRecord.Bank<=DFalse Then
                   UserRecord.Bank=UserRecord.Bank-UserRecord.Borrow
                   Temp3#=UserRecord.Borrow
                   UserRecord.Borrow=DFalse
                   Strng="The broker says: Your loan balance is paid off!"
                   Call IO.O
                   If p2#<=DFalse Then
                      Var1=1
                   Endif
                   If p2#>DFalse Then
                      If UserRecord.Bank-p2#>DFalse Then
                         UserRecord.Bank=UserRecord.Bank-p2#
                         Strng="He adds: Your loan interest is also paid!"
                         Call IO.O
                         Var1=1
                         p3#=p2#
                      Else
                         Strng="He says: You have not paid the loan interest!"
                         Call IO.O
                         Var1=2
                      Endif
                   Endif
                Else
                   UserRecord.Borrow=UserRecord.Borrow-UserRecord.Bank
                   Temp3#=UserRecord.Bank
                   UserRecord.Bank=DFalse
                   Strng="The broker says: Your balance paid part of the loan!"
                   Call IO.O
                   Var1=2
                Endif
                ' clear loan transactions.
                If Var1=1 Then
                   FOR z! = 1! TO LOF(TempFile1) / BankRecLen
                      Call Read.Record(BankFile,z!)
                      IF BankRecord.UserIndex = User.Index THEN
                         IF BankRecord.PostType = "B" THEN
                            IF BankRecord.Deleted = False THEN
                               BankRecord.Balance2 = BankRecord.Balance
                               BankRecord.Balance = False
                               BankRecord.Deleted = True
                               Call Write.Record(BankFile,z!)
                            END IF
                         END IF
                      END IF
                   NEXT
                Endif
                ' post current loan transaction.
                If Var1>=1 Then
                   ' record user balance.
                   BankRecord.UserIndex = User.Index
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Balance = UserRecord.Bank
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp3#
                   BankRecord.PostType = "A"
                   BankRecord.PostSubType = "P"
                   BankRecord.PostSubType2 = 2
                   BankRecord.From=Nul
                   BankRecord.To=Nul
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   ' record loan balance.
                   BankRecord.UserIndex = User.Index
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Balance = UserRecord.Borrow
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp3#
                   BankRecord.PostType = "B"
                   BankRecord.PostSubType = "P"
                   BankRecord.PostSubType2 = 2
                   BankRecord.From=Nul
                   BankRecord.To=Nul
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   ' record bank balance.
                   BankRecord.UserIndex = True
                   BankRecord.DatePost = Dnow$
                   BankRecord.TimePost = Tnow$
                   BankRecord.Deleted = False
                   BankRecord.PostAmount = Temp3#
                   BankRecord.PostType = "C"
                   BankRecord.PostSubType = "P"
                   BankRecord.PostSubType2 = 2
                   BankRecord.From = UserRecord.Codename
                   BankRecord.To=Nul
                   z! = LOF(TempFile1) / BankRecLen + 1!
                   Call Write.Record(BankFile,z!)
                   ' record bank loan interest.
                   If p3#>DFalse Then
                      BankRecord.UserIndex = True
                      BankRecord.DatePost = Dnow$
                      BankRecord.TimePost = Tnow$
                      BankRecord.Deleted = False
                      BankRecord.PostAmount = p3#
                      BankRecord.PostType = "C"
                      BankRecord.PostSubType = "P"
                      BankRecord.PostSubType2 = 4
                      BankRecord.From = UserRecord.Codename
                      BankRecord.To=Nul
                      z! = LOF(TempFile1) / BankRecLen + 1!
                      Call Write.Record(BankFile,z!)
                   Endif
                   Call Extend.Amount2(Temp3#,Var$)
                   Strng="Payment from bank account:"+Var$
                   Call Bank.Log(Strng)
                   If p3#>DFalse Then
                      Call Extend.Amount2(p3#,Var$)
                      Strng="Interest Payment from bank account:"+Var$
                      Call Bank.Log(Strng)
                   Endif
                Endif
             Endif
          Endif
          GOSUB Loan.Interest
          If UserRecord.Borrow>DFalse Or p2#>DFalse Then
             If UserRecord.Gold>DFalse Then
                Var1=False
                Strng="The broker asks: Pay back with your current gold(y/n)? "
                No.Input.Out="Y"
                Call IO.I
                If Yes Then
                   p3#=DFalse
                   If UserRecord.Borrow-UserRecord.Gold<=DFalse Then
                      UserRecord.Gold=UserRecord.Gold-UserRecord.Borrow
                      Temp3#=UserRecord.Borrow
                      UserRecord.Borrow=DFalse
                      Strng="The broker says: Your loan balance is paid off!"
                      Call IO.O
                      If p2#<=DFalse Then
                         Var1=1
                      Endif
                      If p2#>DFalse Then
                         If UserRecord.Gold-p2#>DFalse Then
                            UserRecord.Gold=UserRecord.Gold-p2#
                            Strng="He adds: Your loan interest is also paid!"
                            Call IO.O
                            Var1=1
                            p3#=p2#
                         Else
                            Strng="He says: You have not paid the loan interest!"
                            Call IO.O
                            Var1=2
                         Endif
                      Endif
                   Else
                      UserRecord.Borrow=UserRecord.Borrow-UserRecord.Gold
                      Temp3#=UserRecord.Gold
                      UserRecord.Gold=DFalse
                      Strng="The broker says: Your balance paid part of the loan!"
                      Call IO.O
                      Var1=2
                   Endif
                   ' clear loan transactions.
                   If Var1=1 Then
                      FOR z! = 1! TO LOF(TempFile1) / BankRecLen
                         Call Read.Record(BankFile,z!)
                         IF BankRecord.UserIndex = User.Index THEN
                            IF BankRecord.PostType = "B" THEN
                               IF BankRecord.Deleted = False THEN
                                  BankRecord.Balance2 = BankRecord.Balance
                                  BankRecord.Balance = False
                                  BankRecord.Deleted = True
                                  Call Write.Record(BankFile,z!)
                               END IF
                            END IF
                         END IF
                      NEXT
                   Endif
                   ' post current loan transaction.
                   If Var1>=1 Then
                      ' record loan balance.
                      BankRecord.UserIndex = User.Index
                      BankRecord.DatePost = Dnow$
                      BankRecord.TimePost = Tnow$
                      BankRecord.Balance = UserRecord.Borrow
                      BankRecord.Deleted = False
                      BankRecord.PostAmount = Temp3#
                      BankRecord.PostType = "B"
                      BankRecord.PostSubType = "P"
                      BankRecord.PostSubType2 = 3
                      BankRecord.From=Nul
                      BankRecord.To=Nul
                      z! = LOF(TempFile1) / BankRecLen + 1!
                      Call Write.Record(BankFile,z!)
                      ' record bank balance.
                      BankRecord.UserIndex = True
                      BankRecord.DatePost = Dnow$
                      BankRecord.TimePost = Tnow$
                      BankRecord.Deleted = False
                      BankRecord.PostAmount = Temp3#
                      BankRecord.PostType = "C"
                      BankRecord.PostSubType = "P"
                      BankRecord.PostSubType2 = 3
                      BankRecord.From = UserRecord.Codename
                      BankRecord.To=Nul
                      z! = LOF(TempFile1) / BankRecLen + 1!
                      Call Write.Record(BankFile,z!)
                      ' record bank loan interest.
                      If p3#>DFalse Then
                         BankRecord.UserIndex = True
                         BankRecord.DatePost = Dnow$
                         BankRecord.TimePost = Tnow$
                         BankRecord.Deleted = False
                         BankRecord.PostAmount = p3#
                         BankRecord.PostType = "C"
                         BankRecord.PostSubType = "P"
                         BankRecord.PostSubType2 = 5
                         BankRecord.From = UserRecord.Codename
                         BankRecord.To=Nul
                         z! = LOF(TempFile1) / BankRecLen + 1!
                         Call Write.Record(BankFile,z!)
                      Endif
                      Call Extend.Amount2(Temp3#,Var$)
                      Strng="Payment from gold:"+Var$
                      Call Bank.Log(Strng)
                      If p3#>DFalse Then
                         Call Extend.Amount2(p3#,Var$)
                         Strng="Interest Payment from gold:"+Var$
                         Call Bank.Log(Strng)
                      Endif
                   Endif
                Endif
             Endif
          Endif
       Endif
    Case "A"
       Strng="He fumbles with his ledgers and says:"
       Call IO.O
       Graphics.Off=True
       Strng2=Fclock$
       Strng="Bank information for "+Strng2+"."
       Call IO.O
       Call Extend.Amount2(UserRecord.Gold,VarQ$)
       Call Extend.Amount2(UserRecord.Bank,VarQ2$)
       Strng="You have"+VarQ$+" gold and"+VarQ2$+" in the bank."
       Call IO.O
       If UserRecord.Borrow>DFalse Then
          Call Extend.Amount2(UserRecord.Borrow,VarQ$)
          Strng="You have borrowed"+VarQ$+" gold from the bank."
          Call IO.O
          GOSUB Loan.Interest
          If p2#>DFalse Then
             Call Extend.Amount2(p2#,Var$)
             Strng="Loan account interest accrued is"+Var$+" gold."
             Call IO.O
          Endif
       Endif
       Strng="The current account interest rate is"+Str$(InterestRate2*100)+"%"
       Call IO.O
       Strng="The current lending interest rate is"+Str$(InterestRate1*100)+"%"
       Call IO.O
       Gosub Bank.Balance
       If TempX#<DFalse Then
          TempX#=Abs(TempX#)
          Call Extend.Amount2(TempX#,VarQ2$)
          Strng="The bank is"+VarQ2$+" in debt."
       Else
          Call Extend.Amount2(TempX#,VarQ2$)
          Strng="The bank has"+VarQ2$+" gold."
       Endif
       Call IO.O
       If UserRecord.Level<10 Then
          Amount2#=Int(Val(TempA$)+.5)
       Else
          Amount2#=Int(Val(TempB$)+.5)
       Endif
       If Amount2#<=DFalse Then
          Amount2#=1000#
       Endif
       If Amount2#>MaxGold# Then
          Amount2#=MaxGold#
       Endif
       Call Extend.Amount2(Amount2#,VarQ$)
       Strng="The maximum lending account is"+VarQ$+" gold."
       Call IO.O
       If UserRecord.Borrow>=Amount2# Then
          Amount2#=DFalse
       Else
          Amount2#=Amount2#-UserRecord.Borrow
       Endif
       Call Extend.Amount2(Amount2#,VarQ$)
       Strng="The maximum amount you may borrow is"+VarQ$+" gold."
       Call IO.O

       Call Extend.Amount2(MaxGold#,VarQ$)
       Strng="The maximum gold transfered through the bank: "+Ltrim$(VarQ$)
       Call IO.O
    Case "R"
       If UserRecord.Level=0 Then
          Strng="You can't! Your level is too low!"
          Call IO.O
       Else
          If UserRecord.Stats(2)<Option2 Then
             Strng="You can't! Your intelligence is too low!"
             Call IO.O
          Else
             Strng="Are you sure you want to rob the bank(y/n)? "
             No.Input.Out="N"
             Call IO.I
             If Yes Then
                If Len(Optionz1$) Then
                   Out2=Optionz1$
                   Call Equate(Temp#)
                Else
                   Temp#=Rnd>.99
                Endif
                If Temp# Then
                   Strng="Success! You rob the Bank!"
                   Call IO.O
                   VarQQ=0
                   If Optionz10!>0! Then
                      If UserRecord.Level<32767 Then
                         VarQQ=-1
                         VarZZ!=Csng(UserRecord.Level)
                         If VarZZ!+Optionz10!>32767! Then
                            UserRecord.Level=32767
                         Else
                            UserRecord.Level=UserRecord.Level+Optionz10!
                         Endif
                         Strng="Your level is now "+Form$(Cdbl(UserRecord.Level))+"."
                         Call IO.O
                      Endif
                   Endif
                   If Optionz10#>0# Then
                      VarQQ=-1
                      UserRecord.Gold=UserRecord.Gold+Optionz10#
                      Call Extend.Amount2(UserRecord.Gold,VarQ$)
                      Strng="You now have"+VarQ$+" Gold!"
                      Call IO.O
                   Endif
                   If VarQQ=0 Then
                      Strng="Nothing happens!"
                      Call IO.O
                   Endif
                Else
                   If Rnd>.5 Then
                      Strng="You got caught! The Broker shoots you in the head!"
                   Else
                      Strng="You got caught! The Broker blows your brains out with a shotgun!"
                   Endif
                   Call IO.O
                   If Len(Option1$) Then
                      Out2=Option1$
                      Call Equate(Temp#)
                   Else
                      Temp#=Rnd<.75
                   Endif
                   If Temp# Then
                      UserRecord.Level=UserRecord.Level-Option1
                      If UserRecord.Level<0 Then UserRecord.Level=0
                      If UserRecord.Level=0 Then
                         Strng="You lose all your levels!"
                      Else
                         If Option1=1 Then
                            Strng="You lose 1 level!"
                         Else
                            Strng="You lose"+Str$(Option1)+" levels!"
                         Endif
                      Endif
                      If UserRecord.Level=1 Then
                         Strng=Strng+" You now have 1 level!"
                      Else
                         Strng=Strng+" You now have "+Form$(Cdbl(UserRecord.Level))+" levels!"
                      Endif
                      Call IO.O
                   Endif
                   If Option3>0 Then
                      Out2=Option3$
                      Call Equate(Temp#)
                      Var1=Cint(Temp#)
                      If Var1>=1 And Var1<=7 Then
                         If UserRecord.Stats(Var1)>0 Then
                            UserRecord.Stats(Var1)=UserRecord.Stats(Var1)-Option3
                            If UserRecord.Stats(Var1)<0 Then UserRecord.Stats(Var1)=0
                            Strng="You lost"+Str$(Option3)+" "+Lcase$(Rtrim$(Stat(Var1)))+" point"
                            If Option3=1 Then Strng=Strng+"!" Else Strng=Strng+"s!"
                            Call IO.O
                         Endif
                      Endif
                   Endif
                Endif
                Call Write.Record(UserFile,User.Index)
             Else
                Strng="Nothing happens!"
                Call IO.O
             Endif
          Endif
       Endif
    Case "V"
       Do While Lost.Carrier=False
          If Sysop Then
             Do While Lost.Carrier=False
                Graphics.Off=False
                Strng="Select view type:"
                Call IO.O
                Graphics.Off=True
                Strng="(1)Personal bank logs"
                Call IO.O
                Strng="(2)Personal bank transactions"
                Call IO.O
                Graphics.Off=False
                Strng="Sysop only:"
                Call IO.O
                Graphics.Off=True
                Strng="(3)Bank logs"
                Call IO.O
                Strng="(4)Archived bank logs"
                Call IO.O
                Strng="(5)Bank transactions"
                Call IO.O
                Graphics.Off=False
                Strng="Enter view type(1-5, Q to Quit)? "
                No.Input.Out="q"
                Call IO.I
                Var=False
                If Lcase$(Out2)="q" Then
                   Var=True
                   Exit Do
                Endif
                Choice=Int(Val(Out2)+.5)
                If Choice>=1 And Choice<=5 Then
                   Exit Do
                Endif
                Choice=False
             Loop
          Else
             Do While Lost.Carrier=False
                Graphics.Off=False
                Strng="Select view type:"
                Call IO.O
                Graphics.Off=True
                Strng="(1)Personal bank logs"
                Call IO.O
                Strng="(2)Personal bank transactions"
                Call IO.O
                Graphics.Off=False
                Strng="Enter view type(1,2, Q to Quit)? "
                No.Input.Out="q"
                Call IO.I
                Var=False
                If Lcase$(Out2)="q" Then
                   Var=True
                   Exit Do
                Endif
                Choice=Int(Val(Out2)+.5)
                If Choice>=1 And Choice<=2 Then
                   Exit Do
                Endif
                Choice=False
             Loop
          Endif
          If Var Then
             Exit Do
          Endif
          Select Case Choice
          Case 1
             Call Bank.Log.Display(1)
          Case 2
             Call Bank.Session.Display(User.Index)
          Case 3
             If Sysop Then
                Call Bank.Log.Display(2)
             Endif
          Case 4
             If Sysop Then
                Call Bank.Log.Display(3)
             Endif
          Case 5
             If Sysop Then
                Call Bank.Session.Display(-1!)
             Endif
          End Select
       Loop
    Case "Q"
       Call Write.Record(UserFile,User.Index)
       Exit Do
    Case "H"
       Stored.Parsed.Command1="BANK"
       Call Read.Help
    Case Else
       Strng="Type ? for Help."
       Call IO.O
    End Select
 Loop
 Exit Sub

Bank.Help:
 Graphics.Off=True
 Strng="[A]ccount"
 Call IO.O
 Strng="[B]orrow"
 Call IO.O
 Strng="[D]eposit"
 Call IO.O
 Strng="[I]nvest"
 Call IO.O
 Strng="[P]ayment"
 Call IO.O
 Strng="[R]ob the Bank"
 Call IO.O
 Strng="[T]ransfer"
 Call IO.O
 Strng="[V]iew"
 Call IO.O
 Strng="[W]ithdraw"
 Call IO.O
 Strng="[H]elp"
 Call IO.O
 Strng="[Q]uit"
 Call IO.O
 Graphics.Off=False
 Return

' calculates bank balance.
Bank.Balance:
 TempX#=SFalse
 f=False
 For Temp!=1! To Lof(TempFile1)/BankRecLen
    Call Read.Record(BankFile,Temp!)
    If BankRecord.UserIndex=True Then
       If f=False then
          TempX#=BankRecord.Balance
          f=True
       Endif
       TempY#=BankRecord.PostAmount
       Select Case BankRecord.PostType
       Case "C"
          MaxDbl#=CDBL(1D+308)
          If TempX#+TempY#<=MaxDbl# Then
             TempX#=TempX#+TempY#
          Endif
       Case "D"
          MaxDbl#=CDBL(1D+308)
          MaxDbl#=-MaxDbl#
          If TempX#-TempY#>=MaxDbl# Then
             TempX#=TempX#-TempY#
          Endif
       End Select
    Endif
 Next
 Return

' calculate loan interest for current date/time.
Loan.Interest:
 p2# = DFalse
 Tnow$=Format$(Now,"hh:mm:ss")
 Dnow$=DATES$
 Tnow#=Now
 ' search for first bank record
 f = False
 FOR z! = 1! TO LOF(TempFile1) / BankRecLen
    Call Read.Record(BankFile,z!)
    IF BankRecord.UserIndex = User.Index THEN
       IF BankRecord.PostType = "B" THEN
          f = True
          EXIT FOR
       END IF
    END IF
 NEXT
 IF f THEN
    ' first balance record
    d1$ = BankRecord.DatePost
    t1$ = BankRecord.TimePost
    a1# = BankRecord.Balance
    ' search for second bank record
    f = False
    FOR z! = z! + 1! TO LOF(TempFile1) / BankRecLen
       Call Read.Record(BankFile,z!)
       IF BankRecord.UserIndex = User.Index THEN
          IF BankRecord.PostType = "B" THEN
             f = True
             EXIT FOR
          END IF
       END IF
    NEXT
    IF f THEN
       DO
          ' next transaction record
          d2$ = BankRecord.DatePost
          t2$ = BankRecord.TimePost
          a2# = BankRecord.Balance
          GOSUB Process1
          d1$ = d2$: t1$ = t2$ ' store previous date/time
          a1# = a2# ' flat rate (no accrued interest).
          ' search for next transaction record
          f = False
          FOR z! = z! + 1! TO LOF(TempFile1) / BankRecLen
             Call Read.Record(BankFile,z!)
             IF BankRecord.UserIndex = User.Index THEN
                IF BankRecord.PostType = "B" THEN
                   f = True
                   EXIT FOR
                END IF
             END IF
          NEXT
          IF f = False THEN
             EXIT DO
          END IF
       LOOP
    END IF
    d2$ = Dnow$
    t2$ = Tnow$
    GOSUB Process1
 END IF
 RETURN

' subroutine processes yearly interest on a balance for a date/time range.
Process1:
 d1# = cdbl(DateValue(d1$))
 If Val(Left$(t1$,2))>23 Then
    V = Val(Mid$(t1$,1,2))
    V = V MOD 24
    V$ = Right$("00"+Mid$(Str$(V),2), 2)
    Mid$(t1$,1,2)=V$
 Endif
 If Mid$(t1$,3,1)<>":" Or Mid$(t1$,6,1)<>":" Then t1$="00:00:00"
 t1# = cdbl(TimeValue(t1$))
 d2# = cdbl(DateValue(d2$))
 If Val(Left$(t2$,2))>23 Then
    V = Val(Mid$(t2$,1,2))
    V = V MOD 24
    V$ = Right$("00"+Mid$(Str$(V),2), 2)
    Mid$(t2$,1,2)=V$
 Endif
 If Mid$(t2$,3,1)<>":" Or Mid$(t2$,6,1)<>":" Then t2$="00:00:00"
 t2# = cdbl(TimeValue(t2$))
 d3# = d2# - d1#
 H1% = Hour(t1#)
 M1% = Minute(t1#)
 S1% = Second(t1#)
 t1! = CSNG(H1%) * 3600! + CSNG(M1%) * 60! + CSNG(S1%)
 H2% = Hour(t2#)
 M2% = Minute(t2#)
 S2% = Second(t2#)
 t2! = CSNG(H2%) * 3600! + CSNG(M2%) * 60! + CSNG(S2%)
 ' calculate seconds elapsed from previous login.
 IF d3# = 0# THEN
    t3# = cdbl(t2!) - cdbl(t1!)
 ELSE
    IF d3# >= 1# THEN
       t3# = cdbl(86400!) - cdbl(t1!) + cdbl(t2!)
       t3# = t3# + cdbl(86400!) * (d3# - 1#)
    END IF
 END IF
 ' calculate days in year range.
 L#=365#
 L1=Val(Right$(d1$,4))
 L2=Val(Right$(d2$,4))
 FOR Var=L1 TO L2
    ' calculate leap years.
    f=False
    IF (Var MOD 4)=False THEN
       f=True
       IF (Var MOD 100)=False THEN
          f=False
          IF (Var MOD 400)=False THEN
             f=True
          END IF
       END IF
    END IF
    IF f THEN
       ' check leap year date range.
       d4$="01-01-"+Mid$(Str$(Var),2)
       d5$="12-31-"+Mid$(Str$(Var),2)
       d4#=DateValue(d4$)
       d5#=DateValue(d5$)
       If d1#<=d4# And d2#>=d5# Then
          L#=L#+1# ' add one day.
       Endif
    Endif
 NEXT
 ' calculate interest based on seconds in time interval.
 T#=86400#*L#
 R#=Cdbl(InterestRate3/100!)
 p1#=a1#*t3#/T#*R# ' 365 days @ rate / second.
 p1#=INT(p1#) ' round to one gold.
 ' add to accrued interest.
 IF p1#>0# THEN
    p2#=p2#+p1# ' flatrate (not compounded).
 END IF
 RETURN

Get.Config:
 VarX=0
 Gosub Reset.Options
 Do
    VarX=VarX+1
    If VarX>Options.Lines Then
       Goto Next.Read
       Exit Do
    Endif
    Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
    If Ucase$(Var$)="[CMD008]" Then
       Do
          VarX=VarX+1
          If VarX>Options.Lines Then
             Goto Next.Read
             Return
          Endif
          Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
          If Ucase$(Var$)="[END]" Then
             Goto Next.Read
             Return
          Endif
          Var=Instr(Var$,"=")
          If Var Then
             Var2$=Lcase$(Ltrim$(Rtrim$(Left$(Var$,Var-1))))
             Var3$=Lcase$(Ltrim$(Rtrim$(Mid$(Var$,Var+1))))
             Gosub Parse.Options
          Endif
       Loop
    Endif
 Loop
Next.Read:
 Close #TempFile1
 Filename$=DND.Path+"CMD008.CFG"
 If Dir$(Filename$)="" Then
    Return
 Endif
 Open Filename$ For Input As #TempFile1
 Do
    If Eof(TempFile1) Then
       Exit Do
    Endif
    Line Input #TempFile1, Var$
    Var$=Ltrim$(Rtrim$(Var$))
    If Left$(Var$,1)<>";" Then
       VarX$=UserRecord.CodeName
       VarX$=Rtrim$(VarX$)
       VarX$=Ucase$(VarX$)
       If Ucase$(Var$)="["+VarX$+"]" Then
          VarZ=0
          Gosub Reset.Options
          Do
             If Eof(TempFile1) Then
                Exit Do
             Endif
             Line Input #TempFile1, Var$
             If Ucase$(Var$)="[END]" Then
                Return
             Endif
             Var=Instr(Var$,"=")
             If Var Then
                Var2$=Ltrim$(Rtrim$(Left$(Var$,Var-1)))
                Var3$=Ltrim$(Rtrim$(Mid$(Var$,Var+1)))
                Gosub Parse.Options
             Endif
          Loop
       Endif
   Endif
 Loop
 Return
Reset.Options:
 MaxGold#=Cdbl(1d+300)
 Option1=1
 Option2=10
 Option3=0
 Option3$="1"
 Option1$="RND<.75"
 Optionz1$="RND>.99"
 Optionz10!=1!
 Optionz10#=10#
 Return
Parse.Options:
 Select Case Var2$
 Case "rob.success.equation"
    If Left$(Var3$,1)=Chr$(34) Then
       If Right$(Var3$,1)=Chr$(34) Then
          Optionz1$=Mid$(Var3$,2)
          Optionz1$=Left$(Optionz1$,Len(Optionz1$)-1)
       Endif
    Endif
 Case "rob.lose.equation"
    If Left$(Var3$,1)=Chr$(34) Then
       If Right$(Var3$,1)=Chr$(34) Then
          Option1$=Mid$(Var3$,2)
          Option1$=Left$(Option1$,Len(Option1$)-1)
       Endif
    Endif
 Case "rob.lose.level"
    Var=Int(Val(Var3$)+.5)
    If Var>=1 And Var<=10 Then
       Option1=Var
    Endif
 Case "rob.success.level"
    Var!=Int(Val(Var3$)+.5)
    If Var!>=0! And Var!<=10! Then
       Optionz10!=Var!
    Endif
 Case "rob.success.gold"
    Var#=Int(Val(Var3$)+.5)
    If Var#>=0# Then
       Optionz10#=Var#
    Endif
 Case "required.intelligence"
    Var=Int(Val(Var3$)+.5)
    If Var>=1 And Var<=250 Then
       Option2=Var
    Endif
 Case "stats.point.loss.equation"
    If Left$(Var3$,1)=Chr$(34) Then
       If Right$(Var3$,1)=Chr$(34) Then
          Option3$=Mid$(Var3$,2)
          Option3$=Left$(Option3$,Len(Option3$)-1)
       Endif
    Endif
 Case "stats.point.loss"
    Var=Int(Val(Var3$)+.5)
    If Var>=1 And Var<=10 Then
       Option3=Var
    Endif
 Case "max.gold"
    MaxDbl#=CDBL(1D+308)
    Var#=Int(Val(Var3$)+.5)
    If Var#>=1# And Var#<=MaxDbl# Then
       MaxGold#=Var#
    Endif
 End Select
 Return
Error.Resume53:
 Exit Sub
Error.Trap53:
 If Err=6 Then
    Strng="Overflow"
    Call IO.O
    Resume Bank.Error
 Endif
 If Err=5 Then
    Strng="Syntax error"
    Call IO.O
    Resume Bank.Error
 Endif
 Resume Error.Resume53
End Sub

Sub Bank.Log(Var$)
 On Local Error Goto Error.Trap54x
 Z$=DateS$+", "+Format$(Now,"hh:mm:ss")
 Var2$=UserRecord.CodeName
 Var2$=Rtrim$(Var2$)
 Var2$=Lcase$(Var2$)
 Mid$(Var2$,1,1)=Ucase$(Mid$(Var2$,1,1))
 Close #TempFile2
 FileName2$=Data.Path1+Bank.FileName+Log.Extension
 Open FileName2$ For Append Shared As #TempFile2
 Var3$=Var2$+": "+Z$+"; "+Ltrim$(Var$)+" gold."
 Print #TempFile2,Var3$
 Var3$="Bank: "+Var2$+"; "+Z$+"; "+Ltrim$(Var$)+" gold."
 Print #TempFile2,Var3$
 Close #TempFile2
Error.Resume54x:
 Exit Sub
Error.Trap54x:
 Resume Error.Resume54x
 If Err=6 Then
    Strng="Overflow"
    Call IO.O
 Endif
End Sub

Sub Bank.Log.Display(Var)
 On Local Error Goto Error.Trap54x1
 Do While Lost.Carrier=False
    Graphics.Off=True
    No.Input.Out="4"
    Strng="(1)List all, (2)Search, (3)Archive, (4)Quit? "
    Call IO.I
    Var2=Int(Val(Out2)+.5)
    Var$=Nul
    Select Case Var2
    Case 4
       Exit Sub
    Case 1, 3
       Continuous=False
       Gosub Display.Loop
    Case 2
       Graphics.Off=False
       Strng="Enter search term: "
       Call IO.I
       If Len(Out2) Then
          Var$=Lcase$(Out2)
          Continuous=False
          Gosub Display.Loop
       Endif
    End Select
 Loop
 Exit Sub

Display.Loop:
 Graphics.Off=False
 Select Case Var2
 Case 1
    Strng="Personal log transaction list:"
 Case 2
    Strng="Bank log transaction list:"
 Case 3
    Strng="Archived bank log transaction list:"
 End Select
 Call IO.O
 Temp5=2
 Select Case Var2
 Case 1
    Var2$=UserRecord.CodeName
    Var2$=Rtrim$(Var2$)
    Var2$=Lcase$(Var2$)
    Mid$(Var2$,1,1)=Ucase$(Mid$(Var2$,1,1))
    Var2$=Var2$+": "
 Case 2, 3
    Var2$="Bank: "
 End Select
 Var3=False
 Var4=False
 If Var2=3 Then
    Var4=True
    FileName2$=Data.Path1+Bank.Log.FileName+Log.Extension
    Gosub Bank.Display1
    Return
 Endif
 Do While Lost.Carrier=False
    If Var3=False Then
       FileName2$=Data.Path1+Bank.FileName+Log.Extension
       Gosub Bank.Display1
       If Quit Then
          Exit Do
       Endif
       Var3=True
    Else
       FileName2$=Data.Path1+Bank.FileName+Mid$(Str$(Var4),2)+Log.Extension
       Gosub Bank.Display1
       If Quit Then
          Exit Do
       Endif
       Var4=Var4+1
       If Var4>9 Then
          Exit Do
       Endif
    Endif
    Temp5=1
 Loop
 Return

' display current & back logs.
Bank.Display1:
 Graphics.Off=False
 Allow.Break=True
 Break=False
 If Var3=False Then
    If Var4=True Then
       Strng="Searching archived bank log:"
    Else
       Strng="Searching current bank log:"
    Endif
 Else
    Strng="Searching bank log number:"+Str$(Var4)+".."
 Endif
 Call IO.O
 Temp6=False
 If Dir$(FileName2$)<>Nul Then
    Close #TempFile2
    Open FileName2$ For Input Shared As #TempFile2
    Do While Lost.Carrier=False
       If Eof(TempFile2) Then
          Exit Do
       Endif
       Line Input #TempFile2,Strng
       Strng=Lcase$(Strng)
       Var2$=Lcase$(Var2$)
       If Left$(Strng,Len(Var2$))=Var2$ Then
          F=True
          If Len(Var$) Then
             If Instr(Lcase$(Strng),Var$)=False Then
                F=False
             Endif
          Endif
          If F Then
             If Len(Strng) Then
                Mid$(Strng,1,1)=Ucase$(Mid$(Strng,1,1))
             Endif
             Graphics.Off=True
             Call IO.O
             Temp6=True
             Temp5=Temp5+1
             If Break Then
                Exit Do
             Endif
             If Temp5>=User.Pagelength-2 Then
                Temp5=False
                If Continuous=False Then
                   Call More.Prompt
                   If No Or Quit Then
                      Exit Do
                   Endif
                Endif
             Endif
          Endif
       Endif
    Loop
 Endif
 Allow.Break=False
 Break=False
 If Temp6=False Then
    Strng="No listing in log."
    Call IO.O
    If Continuous=False Then
       Call More.Prompt
    Endif
 Else
    If Temp5 Then
       If Continuous=False Then
          Call More.Prompt
       Endif
    Endif
 Endif
 Graphics.Off=False
 Close #TempFile2
 Return
Error.Resume54x1:
 Exit Sub
Error.Trap54x1:
 Resume Error.Resume54x1
 If Err=6 Then
    Strng="Overflow"
    Call IO.O
 Endif
End Sub

Sub Bank.Session.Display(Var!)
 On Local Error Goto Error.Trap54x2
 Graphics.Off=False
 Strng="He fumbles with his ledgers and says:"
 Call IO.O
 Graphics.Off=True
 Strng2=Fclock$
 If Var!=STrue Then
    Strng="Bank transactions for "+Strng2+"."
 Else
    Strng="Personal bank transactions for "+Strng2+"."
 Endif
 Call IO.O
 Continuous.Display=False
 Allow.Break=True
 Break=False
 Temp5=2
 FOR z! = 1! TO LOF(TempFile1) / BankRecLen
    If Lost.Carrier Then
       Exit For
    Endif
    Call Read.Record(BankFile,z!)
    Z$=BankRecord.DatePost+", "+BankRecord.TimePost+":"
    IF BankRecord.UserIndex = Var! THEN
       V$ = Nul
       If Var!=STrue Then
          V$ = BankRecord.From
          V$ = Rtrim$(V$)
          V$ = Lcase$(V$)
          If Len(V$) Then
             Mid$(V$, 1, 1) = Ucase$(Mid$(V$, 1, 1))
             V$ = V$ + ";"
          Endif
       Endif
       Graphics.Off=True
       Select Case BankRecord.PostSubType
       Case "A"
          Select Case BankRecord.PostType
          Case "A"
             If BankRecord.Deleted = False Then
                Var#=BankRecord.Balance
                Call Extend.Amount2(Var#,Var$)
                Strng=V$+"Account balance: "+Z$+Var$+" gold."
             Else
                Var#=BankRecord.Balance2
                Call Extend.Amount2(Var#,Var$)
                Strng=V$+"Account balance: "+Z$+Var$+" gold."
             Endif
             Graphics.Off=True
             Call IO.O
             Temp5=Temp5+1
          Case "B"
             If BankRecord.Deleted = False Then
                Var#=BankRecord.Balance
                Call Extend.Amount2(Var#,Var$)
                Strng=V$+"Loan balance: "+Z$+Var$+" gold."
             Else
                Var#=BankRecord.Balance2
                Call Extend.Amount2(Var#,Var$)
                Strng=V$+"Loan balance: "+Z$+Var$+" gold."
             Endif
             Graphics.Off=True
             Call IO.O
             Temp5=Temp5+1
          End Select
       Case "B"
          Var#=BankRecord.PostAmount
          Call Extend.Amount2(Var#,Var$)
          Strng=V$+"Borrow: "+Z$+Var$+" gold."
          Call IO.O
          Temp5=Temp5+1
       Case "D"
          Var#=BankRecord.PostAmount
          Call Extend.Amount2(Var#,Var$)
          Select Case BankRecord.PostSubType2
          Case 0
             Strng=V$+"Deposit: "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          Case 1
             Strng=V$+"Invest: "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          End Select
       Case "I"
          Var#=BankRecord.PostAmount
          Call Extend.Amount2(Var#,Var$)
          Select Case BankRecord.PostSubType2
          Case 1
             Graphics.Off=True
             Strng=V$+"Bank Interest: "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          Case 2
             Select Case BankRecord.PostType
             Case "D"
                Graphics.Off=True
                Strng=V$+"Bank Interest Paid: "+Z$+Var$+" gold."
                Call IO.O
                Temp5=Temp5+1
             Case "I"
                Graphics.Off=True
                Strng=V$+"Bank Interest Earned: "+Z$+Var$+" gold."
                Call IO.O
                Temp5=Temp5+1
             End Select
          Case 3
             Graphics.Off=True
             Strng=V$+"Loan Interest: "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          End Select
       Case "P"
          Var#=BankRecord.PostAmount
          Call Extend.Amount2(Var#,Var$)
          Select Case BankRecord.PostSubType2
          Case 1
             Strng=V$+"Loan Payment(login): "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          Case 2
             If BankRecord.PostType = "B" Or BankRecord.PostType = "C" Then
                Strng=V$+"Loan Payment from bank account: "+Z$+Var$+" gold."
                Call IO.O
                Temp5=Temp5+1
             Endif
          Case 3
             If BankRecord.PostType = "B" Or BankRecord.PostType = "C" Then
                Strng=V$+"Loan Payment from gold: "+Z$+Var$+" gold."
                Call IO.O
                Temp5=Temp5+1
             Endif
          Case 4
             Strng=V$+"Loan Payment Interest from bank account: "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          Case 5
             Strng=V$+"Loan Payment Interest from gold: "+Z$+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          End Select
       Case "T"
          Var#=BankRecord.PostAmount
          Call Extend.Amount2(Var#,Var$)
          Var1$=BankRecord.From
          Var1$=Rtrim$(Var1$)
          Var1$=Lcase$(Var1$)
          Mid$(Var1$,1,1)=Ucase$(Mid$(Var1$,1,1))
          Var2$=BankRecord.To
          Var2$=Rtrim$(Var2$)
          Var2$=Lcase$(Var2$)
          Mid$(Var2$,1,1)=Ucase$(Mid$(Var2$,1,1))
          Select Case BankRecord.PostSubType2
          Case 0
             Strng="Transfer: "+Z$+" From: "+Var1$+"; To: "+Var2$+":"+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          Case 1
             Strng="Transfer: "+Z$+" From: "+Var1$+"; To: "+Var2$+": Charge:"+Var$+" gold."
             Call IO.O
             Temp5=Temp5+1
          End Select
       Case "W"
          Var#=BankRecord.PostAmount
          Call Extend.Amount2(Var#,Var$)
          Strng=V$+"Withdraw: "+Z$+Var$+" gold."
          Call IO.O
          Temp5=Temp5+1
       END Select
    END IF
    If Temp5>=User.Pagelength-2 Then
       Temp5=False
       If Continuous=False Then
          Call More.Prompt
          If No Or Quit Then
             Exit For
          Endif
       Endif
    Endif
 NEXT
 Allow.Break=False
 Break=False
 If Temp5 Then
    Call More.Prompt
 Endif
Error.Resume54x2:
 Exit Sub
Error.Trap54x2:
 Resume Error.Resume54x2
 If Err=6 Then
    Strng="Overflow"
    Call IO.O
 Endif
End Sub

Sub Bank.Status.Line
 On Local Error Goto Error.Trap54
 Temp$=UserRecord.CodeName
 Temp$=Rtrim$(Temp$)
 Temp$=Lcase$(Temp$)
 Mid$(Temp$,1,1)=Ucase$(Mid$(Temp$,1,1))
 Temp$=Temp$+" > "
 Call Extend.Amount2(UserRecord.Gold,Var$)
 Temp$=Temp$+"Gold:"+Var$+" "
 Call Extend.Amount2(UserRecord.Bank,Var$)
 Temp$=Temp$+"Bank:"+Var$+" "

 Call Extend.Amount2(UserRecord.Borrow,Var$)
 Var2$="Loan:"+Var$+" "
 If Len(Temp$)+Len(Var2$)<=79 Then
    Temp$=Temp$+Var2$
 Endif

 Var2$="> Interest Rate:"+Str$(InterestRate2)+"%"
 If Len(Temp$)+Len(Var2$)<=79 Then
    Temp$=Temp$+Var2$
 Endif

 Temp$=Left$(Temp$,79)
 Temp$=Temp$+Space$(79-Len(Temp$))
 Call Display.Status.Line(True)
Error.Resume54:
 Exit Sub
Error.Trap54:
 Resume Error.Resume54
 If Err=6 Then
    Strng="Overflow"
    Call IO.O
 Endif
End Sub

Sub Clear.Status.Line
 On Local Error Goto Error.Trap58a
 Temp$=Space$(79)
 Call Display.Status.Line(False)
Error.Resume58a:
 Exit Sub
Error.Trap58a:
 Resume Error.Resume58a
End Sub

Sub Alt.Login(Var,Var$)
 On Local Error Goto ErrorTrp25
 If Instr(Var$,"/N:") Then
    Var$=Left$(Var$,Instr(Var$,"/N:")-1)
 Endif
 Out2=Nul
 Var=False
 If Len(Var$) Then
    Var2=Instr(Var$,Chr$(34))
    If Var2 Then
       Var$=Mid$(Var$,Var2+1)
       Var2=Instr(Var$,Chr$(34))
       If Var2 Then
          Out2=Left$(Var$,Var2-1)
          If Out2=Nul Then
             Exit Sub
          Endif
       Else
          Exit Sub
       Endif
    Else
       Exit Sub
    Endif
 Endif
Start.Login:
 If Out2=Nul Then
    Graphics.Off=False
    Strng="Enter codename(?=list,*=search): "
    Call IO.I
 Endif
 Strng=Lcase$(Rtrim$(Out2))
 Out2=Nul
 If Len(Strng)=0 Then
    Exit Sub
 Endif
 If Strng="?" Then
    Temp1=False
    For Temp1!=1! To Lof(UserFile)/UserRecLen
       Call Read.Record(UserFile,Temp1!)
       Out3=UserRecord.CodeName
       Out3=Lcase$(Rtrim$(Out3))
       If Out3<>"<deleted>" Then
          Strng=Out3
          Mid$(Strng,1,1)=Ucase$(Mid$(Strng,1,1))
          Strng=Rtrim$(UserRecord.Prefix1)+Strng
          Call Convert.ANSI(True,VarQ,VarR)
          Carriage.Return=True
          Graphics.On=True
          Call IO.O
          Graphics.On=False
          Strng=Strng+" (level "+Form$(Cdbl(UserRecord.Level))+")"
          If UserRecord.ClassType=AsstDM Then
             Strng=Strng+" [AsstDM]"
          Endif
          If UserRecord.ClassType=DM Then
             Strng=Strng+" [DM]"
          Endif
          If UserRecord.Flags And Special.Char4 Then
             Strng=Strng+" [Sysop]"
          Endif
          Call Search.Mess.File(Temp1!,Var1)
          If Var1 Then
             Strng=Strng+" {online}"
          Endif
          Call IO.O
          Temp1=Temp1+1
          If Temp1>=User.Pagelength-2 Then
             Temp1=False
             Call More.Prompt
             If No Or Quit Then
                Exit For
             Endif
          Endif
       Endif
    Next
    If Temp1 Then
       Call More.Prompt
    Endif
    Out2=Nul
    Goto Start.Login
 Endif
 If Strng="*" Then
    Strng="Enter codename search(?,* allowed): "
    Call IO.I
    Var2$=Lcase$(Out2)
    Temp1=False
    Var2=False
    For Temp1!=1! To Lof(UserFile)/UserRecLen
       Call Read.Record(UserFile,Temp1!)
       Out3=UserRecord.CodeName
       Out3=Lcase$(Rtrim$(Out3))
       If Out3<>"<deleted>" Then
          Out2=Var2$
          Call InstrSUB2(VarX)
          If VarX Then
             Var2=True
             Strng=Out3
             Mid$(Strng,1,1)=Ucase$(Mid$(Strng,1,1))
             Strng=Rtrim$(UserRecord.Prefix1)+Strng
             Call Convert.ANSI(True,VarQ,VarR)
             Carriage.Return=True
             Graphics.On=True
             Call IO.O
             Graphics.On=False
             Strng=Strng+" (level "+Form$(Cdbl(UserRecord.Level))+")"
             If UserRecord.ClassType=AsstDM Then
                Strng=Strng+" [AsstDM]"
             Endif
             If UserRecord.ClassType=DM Then
                Strng=Strng+" [DM]"
             Endif
             If UserRecord.Flags And Special.Char4 Then
                Strng=Strng+" [Sysop]"
             Endif
             Call Search.Mess.File(Temp1!,Var1)
             If Var1 Then
                Strng=Strng+" {online}"
             Endif
             Call IO.O
             Temp1=Temp1+1
             If Temp1>=User.Pagelength-2 Then
                Temp1=False
                Call More.Prompt
                If No Or Quit Then
                   Exit For
                Endif
             Endif
          Endif
       Endif
    Next
    If Var2=False Then
       Strng="Codename not found."
       Call IO.O
    Endif
    If Temp1 Then
       Call More.Prompt
    Endif
    Out2=Nul
    Goto Start.Login
 Endif
 For User.Index=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,User.Index)
    Out3=UserRecord.CodeName
    Out3=Lcase$(Rtrim$(Out3))
    If Strng=Out3 Then
       Var=True ' valid name
       Exit Sub
    Endif
 Next
 User.Index=SFalse
 Exit Sub
ErrorRsm25:
 Exit Sub
ErrorTrp25:
 Security.Guard=False
 Resume ErrorRsm25
End Sub

Sub Get.Node
 On Local Error Goto Node.Error
 Var$=Command$
 Var$=Ltrim$(Rtrim$(Var$))
 If Instr(Var$,"/N:") Then
    Var$=Mid$(Var$,Instr(Var$,"/N:")+3)
    Select Case Len(Var$)
    Case 0
       Node=0
       NodeX=Nul
       Exit Sub
    Case 1 ' 0-9,A-Z
       Select Case Var$
       Case "0" To "9"
          Node=Val(Var$)+1
          NodeX=Var$
       Case "A" To "Z"
          Node=Asc(Var$)-54
          NodeX=Var$
       Case Else
          Goto Node.Error
       End Select
    Case 2 ' 10-99
       VarX=Int(Val(Var$)+.5)
       If VarX>=10 And VarX<=99 Then
          Node=VarX+27 ' 37-126
          NodeX=Mid$(Str$(VarX),2) ' 10-99
       Else
          Goto Node.Error
       Endif
    Case Else
       Goto Node.Error
    End Select
 Endif
 Exit Sub
Node.Error:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3="Error reading node. Node must be <nul>,0-9,A-Z,10-99."
 Call Terminate.Program
End Sub

Sub Valid.Node
 On Local Error Goto ErrorTrap11
 If Node>=False And Node<=MaxNodes Then
    VarX2=Node+1
    Call Read.Message.Record(MessWorkFile1,VarX2)
    If MessWorkRecord1.ActiveNode Then
       If Rtrim$(NodeX)=Nul Then
          Strng="Node -, already active."
       Else
          Strng="Node "+NodeX+", already active."
       Endif
       Goto ErrorTrap11
    Else
       Strng=Rtrim$(MessWorkRecord1.UserName)
       Call Valid.Name(Strng)
       If TempA Then
          If Rtrim$(NodeX)=Nul Then
             Strng="Node -, active codename."
          Else
             Strng="Node "+NodeX+", active codename."
          Endif
          Goto ErrorTrap11
       Endif
    Endif
 Else
    Strng="Node '"+NodeX+"' is not a valid node number."
    Goto ErrorTrap11
 Endif
ErrorResume11:
 Exit Sub
ErrorTrap11:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3=Strng
 Call Terminate.Program
End Sub

Sub Open.Arrays
 On Local Error Goto Array.Error
 Call Plex.Function(26)
 If (OutregsX.AX And &HFF)=&HFF Then
    Local.ANSI.Color=True
 Else
    Local.ANSI.Color=False
 Endif
 Local.Avatar.Color=False
 Call Plex.Function(27)
 If (OutregsX.AX And &HFF)=&HFF Then
    If (OutregsX.DX And &HFF)=&H16 Then
       Local.Avatar.Color=True
    Endif
 Endif
 Local.Mode=True
 Lost.Carrier=False
 Call Read.Rows(Max.Row)
 Locate Max.Row,1,1
 Call VideoInt(15,0)
 Video.Page=OutregsX.BX
Redim Alignment.Name1(1 To MaxAlignment) As String*7,_
 Alignment.Name2(1 To MaxAlignment) As String*7,_
 Class.Name(1 To MaxClassNames) As String*15,_
 Direction(1 To MaxDirections) As String*9,_
 High.Class.Name(1 To MaxClassNames) As String*15,_
 InventoryNames(1 To MaxItems) As String*8,_
 Numeral(1 To MaxNumerals) As String*5,_
 Race(1 To MaxRaces) As String*8,_
 Room.Array(1 To MaxRoomArrays) As String*40,_
 Stat(1 To MaxStats) As String*12,_
 Training.Stats(1 To MaxClassNames,1 To MaxTrainStats) As Integer,_
 Weapon.Type.Name(1 To MaxWeapons) As String*9
 Exit Sub
Array.Error:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3="Error opening arrays. Free more RAM."
 Call Terminate.Program
End Sub

Sub Get.Config
 On Local Error Goto Config.Error
 DND.Path=Environ$("DNDBBS")
 If DND.Path<>Nul Then
    If Right$(DND.Path,1)<>"\" Then
       DND.Path=DND.Path+"\"
    Endif
 Endif
 FileName=DND.Path+"DND"+NodeX+".CFG"
 Close #TempFile1
 Open FileName For Input Shared As #TempFile1
 Line Input #TempFile1,Var$
 For Temp1=1 To MaxConfigArray1
    Input #TempFile1,Var!
    Select Case Temp1
    Case 10
       InterestRate1=Var!/100
    Case 30
       InterestRate2=Var!/100
    End Select
 Next
 For Temp1=1 To MaxConfigArray2
    Input #TempFile1,Var%
    Select Case Temp1
    Case 48
       Allow.High.Class=Var%
    Case 81
       Allow.Remote.Edit=Var%
    Case 86
       User.Echo=Var%
    Case 87
       User.Linefeeds=Var%
    Case 88
       User.Linelength=Var%
    Case 89
       User.Pagelength=Var%
    Case 90
       User.Wordwrap=Var%
    Case 111
       Disable.DM=Var%
    Case 112
       Disable.Nodes=Var%
    Case 113
       Disable.Sysop=Var%
    End Select
 Next
 For Temp1=1 To MaxConfigArray3
    Line Input #TempFile1,Var$
    Select Case Temp1
    Case 1
       Prelog.FileName=Var$
    Case 3
       Welcome.FileName=Var$
    Case 4
       Notice.FileName=Var$
    Case 11
       Data.Path1=Var$
    Case 12
       MonClass.FileName=Var$
    Case 13
       MonTalk.FileName=Var$
    Case 15
       File.Extension1=Var$
    Case 16
       Room.FileName=Var$
    Case 17
       Object.FileName=Var$
    Case 18
       Monster.FileName=Var$
    Case 19
       Treasure.FileName=Var$
    Case 20
       Spell.FileName=Var$
    Case 21
       User.FileName=Var$
    Case 22
       NonPlayer.FileName=Var$
    Case 28
       Logoff.FileName=Var$
    Case 38
       Logoff.Help.FileName=Var$
    Case 51
       Usage.FileName=Var$
    Case 52
       Data.Path2=Var$
    Case 53
       Data.Path3=Var$
    Case 54
       Data.Path4=Var$
    Case 55
       Help.FileName1=Var$
    Case 56
       Help.Filename2=Var$
    Case 57
       Team.FileName=Var$
    Case 58
       Public.FileName=Var$
    Case 59
       Message.Base.FileName=Var$
    Case 60
       Private.FileName=Var$
    Case 61
       Help.FileName3=Var$
    Case 62
       File.Extension2=Var$
    Case 65
       Catalog.FileName=Var$
    Case 68
       MessWork.FileName=Var$
    Case 71
       Action.FileName=Var$
    Case 72
       Day.File.FileName=Var$
    Case 73
       Log.FileName=Var$
    Case 76
       Help.FileName4=Var$
    Case 80
       Container.FileName=Var$
    Case 85
       ANSIPrefixChar=Var$
    Case 86
       UserInv.FileName=Var$
    Case 87
       CtnInv.FileName=Var$
    Case 88
       TeamInv.FileName=Var$
    Case 89
       RoomInv.FileName=Var$
    Case 90
       MonInv.FileName=Var$
    Case 91
       Inline.FileName2=Var$
    Case 92
       Inline.FileName1=Var$
    Case 93
       Room.Desc.FileName=Var$
    Case 94
       TempA$=Var$
    Case 95
       TempB$=Var$
    Case 96
       Bank.FileName=Var$
    Case 98
       InterestRate3=Csng(Val(Var$))
    Case 99
       Bank.Log.FileName=Var$
    Case 100
       Log.Extension=Var$
    End Select
 Next
 For Temp1=1 To 10
    For Temp2=1 To 4
       Input #TempFile1,Training.Stats(Temp1,Temp2)
    Next
 Next
 For Temp1=1 To 20
    Line Input #TempFile1,Room.Array(Temp1)
 Next
 MessWork.FileName=Data.Path3+MessWork.FileName
 For Temp1=1 To 10
    Line Input #TempFile1,High.Class.Name(Temp1)
 Next
 For Temp1=1 To 8
    Line Input #TempFile1,Race(Temp1)
 Next
 For Temp1=1 To 10
    Line Input #TempFile1,Class.Name(Temp1)
 Next
 For Temp1=1 To 7
    Line Input #TempFile1,Stat(Temp1)
 Next
 For Temp1=1 To 12
    Line Input #TempFile1,Direction(Temp1)
 Next
 For Temp1=1 To 10
    Line Input #TempFile1,Numeral(Temp1)
 Next
 For Temp1=1 To 4
    Line Input #TempFile1,Weapon.Type.Name(Temp1)
 Next
 For Temp1=1 To 3
    Line Input #TempFile1,Alignment.Name1(Temp1)
 Next
 For Temp1=1 To 3
    Line Input #TempFile1,Alignment.Name2(Temp1)
 Next
 For Temp1=1 To MaxUserCommands
    Line Input #TempFile1,Var$
    For Temp2=1 To 3
       Line Input #TempFile1,Var$
    Next
    Input #TempFile1,Var%
    For Temp2=1 To 8
       Input #TempFile1,Var%
    Next
    For Temp2=1 To 4
       Input #TempFile1,Var%
    Next
    Input #TempFile1,Var%
    Input #TempFile1,Var%
 Next
 For Temp1=1 To MaxDMcommands
    Line Input #TempFile1,Var$
    Input #TempFile1,Var%
    For Temp2=1 To 3
       Input #TempFile1,Var%
    Next
 Next
 For Temp1=1 To MaxSysopCommands
    Line Input #TempFile1,Var$
    Input #TempFile1,Var%
 Next
 For Temp1=1 To MaxNodeCommands
    Line Input #TempFile1,Var$
    For Temp2=1 To 8
       Input #TempFile1,Var%
    Next
 Next
 For Temp1=1 To MaxLetters
    Input #TempFile1,Var%
 Next
 For Temp1=1 To MaxStrips
    Line Input #TempFile1,Var$
 Next
 For Temp1=1 To 10
    Line Input #TempFile1,Var$
    Input #TempFile1,Var%
    Input #TempFile1,Var%
 Next
 For Temp1=1 To 10
    Line Input #TempFile1,InventoryNames(Temp1)
 Next
 Exit Sub
Config.Error:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3="Error reading "+Lcase$(FileName)+" (error:"+Str$(Err)+"). Run Dndcnfg."
 Call Terminate.Program
End Sub

Sub Increase.Files
 On Local Error Goto Increase.Error
 Close
 Call StdinInt(62,0)
 PSP.Segment=OutregsX.BX
 Def Seg=PSP.Segment
 Command.Line=&H80
 Command.Tail=Command.Line+60
 For Var=1 To 54
    Poke Command.Tail+Var-1,&HFF
 Next
 For Var=1 To 4
    File.Handle=Peek(&H18+Var-1)
    Poke Command.Tail+Var-1,File.Handle
 Next
 Poke &H32,54
 Poke &H34,Command.Tail
 Def Seg
 Close
 Exit Sub
Increase.Error:
 Color 14,0
 Out2="Error increasing file handles."+Chr$(13)+Chr$(10)
 Out3="Increase files= in config.sys or config.nt, or run Dndcnfg."
 Call Terminate.Program
End Sub

Sub Make.FileNames
 On Local Error Goto Make.Error
 Out2=Environ$("DNDDAT")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path1=Out2
 Endif
 Out2=Environ$("DNDDOC")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path2=Out2
 Endif
 Out2=Environ$("DNDTEMP")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path3=Out2
 Endif
 Out2=Environ$("DNDMESS")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path4=Out2
 Endif
 DOS.Exit="EDTDOS"+Rtrim$(NodeX)+".BAT"
 Day.File.FileName=Data.Path1+Day.File.FileName
 Catalog.FileName=Data.Path2+Catalog.FileName+File.Extension2
 Log.FileName=Data.Path1+Log.FileName+File.Extension1
 Logoff.FileName=Data.Path1+Logoff.FileName+File.Extension1
 Notice.FileName=Data.Path1+Notice.FileName+File.Extension1
 Prelog.FileName=Data.Path1+Prelog.FileName+File.Extension1
 Welcome.FileName=Data.Path1+Welcome.FileName+File.Extension1
 User.FileName=Data.Path1+User.FileName+File.Extension1
 NonPlayer.FileName=Data.Path1+NonPlayer.FileName+File.Extension1
 Room.FileName=Data.Path1+Room.FileName+File.Extension1
 Object.FileName=Data.Path1+Object.FileName+File.Extension1
 Monster.FileName=Data.Path1+Monster.FileName+File.Extension1
 Treasure.FileName=Data.Path1+Treasure.FileName+File.Extension1
 MonTalk.FileName=Data.Path1+MonTalk.FileName+File.Extension1
 MonClass.FileName=Data.Path1+MonClass.FileName+File.Extension1
 Spell.FileName=Data.Path1+Spell.FileName+File.Extension1
 Action.FileName=Data.Path1+Action.FileName+File.Extension1
 Team.FileName=Data.Path1+Team.FileName+File.Extension1
 Container.FileName=Data.Path1+Container.FileName+File.Extension1
 Message.Base.FileName=Data.Path4+Message.Base.FileName+File.Extension1
 Logon.Help.FileName=Data.Path1+Help.FileName3+File.Extension1
 UserInv.FileName=Data.Path1+UserInv.FileName+File.Extension1
 CtnInv.FileName=Data.Path1+CtnInv.FileName+File.Extension1
 TeamInv.FileName=Data.Path1+TeamInv.FileName+File.Extension1
 RoomInv.FileName=Data.Path1+RoomInv.FileName+File.Extension1
 MonInv.FileName=Data.Path1+MonInv.FileName+File.Extension1
 Room.Desc.FileName=Data.Path1+Room.Desc.FileName+File.Extension1
 Usage.FileName=Data.Path1+Usage.FileName+File.Extension1
 Help.FileName1=Data.Path1+Help.FileName1+File.Extension1
 Help.FileName2=Data.Path1+Help.FileName2+File.Extension1
 Logoff.Help.FileName=Data.Path1+Logoff.Help.FileName+File.Extension1
 Exit Sub
Make.Error:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3="Error making "+Lcase$(FileName)+" (error:"+Str$(Err)+"). Increase files= in config.sys or run Dndcnfg."+Chr$(13)+Chr$(10)
 Call Terminate.Program
End Sub

Sub Open.Files
 On Local Error Goto Open.Error
 Close
 ActionRecLen=Len(ActionRecord)
 BankRecLen=Len(BankRecord)
 BufferRecLen=Len(BufferRecord)
 ContainerRecLen=Len(ContainerRecord)
 HelpRecLen1=Len(HelpRecord1)
 HelpRecLen2=Len(HelpRecord2)
 HelpRecLen3=Len(HelpRecord3)
 LogRecLen=Len(LogRecord)
 MessBaseRecLen=Len(MessageBaseRecord)
 MessageRecLen=Len(BufferRecord)
 MonsterRecLen=Len(MonsterRecord)
 NewMessRecLen=Len(NewMessages)
 TableRecLen=Len(TableRecord)
 UserRecLen=Len(UserRecord)
 UserProfileRecLen=Len(UserProfile)
 MonClassRecLen=Len(MonClassRecord)
 MonTalkRecLen=Len(BufferRecord)
 NonPlayerRecLen=Len(MonsterRecord)
 ObjectRecLen=Len(ObjectRecord)
 RoomDescLen=Len(BufferRecord)
 RoomRecLen=Len(RoomRecord)
 SpellRecLen=Len(SpellRecord)
 TeamRecLen=Len(TeamRecord)
 TreasureRecLen=Len(TreasureRecord)
 MessWorkRecLen1=Len(MessWorkRecord1)
 MessWorkRecLen2=Len(MessWorkRecord2)
 MessWorkRecLen3=Len(MessWorkRecord3)
 MessWorkRecLen5=Len(MessWorkRecord5)
 MessWorkRecLen4=Len(MessWorkRecord4)
 MessWorkRecLen6=Len(MessWorkRecord6)
 MessWorkRecLen7=Len(MessWorkRecord7)
 FileName=DND.Path+"ACCOUNTS.SIC"
 Open FileName For Random Shared As #SicFile Len=UserProfileRecLen

 FileName=User.FileName
 Open FileName For Random Shared As #UserFile Len=UserRecLen
 Open FileName For Random Shared As #UserFile2 Len=UserRecLen

 FileName=NonPlayer.FileName
 Open FileName For Random Shared As #NonPlayerFile Len=NonPlayerRecLen
 FileName=Room.FileName
 Open FileName For Random Shared As #RoomFile Len=RoomRecLen
 FileName=Object.FileName
 Open FileName For Random Shared As #ObjectFile Len=ObjectRecLen
 FileName=Monster.FileName
 Open FileName For Random Shared As #MonsterFile Len=MonsterRecLen
 FileName=Treasure.FileName
 Open FileName For Random Shared As #TreasureFile Len=TreasureRecLen
 FileName=MonTalk.FileName
 Open FileName For Random Shared As #MonTalkFile Len=MonTalkRecLen
 FileName=MonClass.FileName
 Open FileName For Random Shared As #MonClassFile Len=MonClassRecLen
 FileName=Spell.FileName
 Open FileName For Random Shared As #SpellFile Len=SpellRecLen
 FileName=Action.FileName
 Open FileName For Random Shared As #ActionFile Len=ActionRecLen
 FileName=Help.FileName1
 Open FileName For Random Shared As #HelpFile1 Len=HelpRecLen1
 FileName=Team.FileName
 Open FileName For Random Shared As #TeamFile Len=TeamRecLen
 FileName=Container.FileName
 Open FileName For Random Shared As #ContainerFile Len=ContainerRecLen
 FileName=Message.Base.FileName
 Open FileName For Random Shared As #MessBaseFile Len=MessBaseRecLen
 FileName=UserInv.FileName
 Open FileName For Random Shared As #UserInvFile Len=MessWorkRecLen6
 FileName=CtnInv.FileName
 Open FileName For Random Shared As #CtnInvFile Len=MessWorkRecLen6
 FileName=TeamInv.FileName
 Open FileName For Random Shared As #TeamInvFile Len=MessWorkRecLen6
 FileName=RoomInv.FileName
 Open FileName For Random Shared As #RoomInvFile Len=MessWorkRecLen6
 FileName=MonInv.FileName
 Open FileName For Random Shared As #MonInvFile Len=MessWorkRecLen6
 FileName=Room.Desc.FileName
 Open FileName For Random Shared As #RoomDescFile Len=RoomDescLen
 FileName=MessWork.FileName+"1"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile1 Len=MessWorkRecLen1
 FileName=MessWork.FileName+"2"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile2 Len=MessWorkRecLen2
 FileName=MessWork.FileName+"6"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile6 Len=MessWorkRecLen6
 FileName=MessWork.FileName+"7"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile7 Len=MessWorkRecLen7
 Exit Sub
Open.Error:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3="Error opening "+Lcase$(FileName)+" (error:"+Str$(Err)+"). Increase files= in config.sys or run Dndcnfg."+Chr$(13)+Chr$(10)
 Call Terminate.Program
End Sub

Sub Read.Options
 On Local Error Goto Error.Trap13
 Redim Options.Array(1 To 165) As String
 Options.Lines=165
 Var=0
 Close #TempFile1
 Filename=DND.Path+"option"+nodex+".cfg"
 If Dir$(Filename)<>Nul Then
    Open Filename For Input As #TempFile1
    Do
       If Eof(TempFile1) Then
          Exit Do
       Endif
       Line Input #TempFile1, Var$
       Var$=Rtrim$(Var$)
       If Left$(Var$,1)=";" Then
          Eat$ = Nul
       Else
          If Len(Var$) Then
             Var=Var+1
             If Var>Options.Lines Then
                Options.Lines=Options.Lines+10
                Redim Preserve Options.Array(1 To Options.Lines) As String
             Endif
             Options.Array(Var)=Var$
          Endif
       Endif
    Loop
 Endif
 Options.Lines=Var
Error.Resume13:
 Exit Sub
Error.Trap13:
 Color 14,0
 Out2="CMD008 Module - Bank"+Chr$(13)+Chr$(10)
 Out3="Error"+Str$(Err)+" reading "+FileName+". Edit file and restart."
 Call Terminate.Program
 Resume Error.Resume13
End Sub

Sub Reset.Cursor
 On Local Error Goto ErrMain13
 Call ScreenANSI(1,37,7)
 Locate Max.Row-1,1,1
 Graphics.Off=False
 Line.Length=False
MainExit13:
 Exit Sub
ErrMain13:
 Resume MainExit13
End Sub

Sub Detect.Share
 On Local Error Goto ErrResume149b
 Call Plex.Function(16)
 If (OutregsX.AX And &HFF)=&HFF Then
    Share.Installed=True
 Else
    Share.Installed=False
 Endif
 Windows.Detected = False
 Call Plex.Function(22)
 If OutregsX.BX>0 Then
    Windows.Detected = True
    ' store windows version
    Win.Minor=OutregsX.BX And &HFF
    Win.Major=(OutregsX.BX And &HFF00)/256
 Endif
ErrExit149b:
 Exit Sub
ErrResume149b:
 Resume ErrExit149b
End Sub

Sub Read.Rows(Var)
 On Local Error Goto Error.Trap62x
 Temp1=50
 Locate 50,1,0
 Var=50
 Exit Sub
Next.Trap1:
 Temp1=43
 Locate 43,1,0
 Var=43
 Exit Sub
Next.Trap2:
 Temp1=25
 Locate 25,1,0
 Var=25
 Exit Sub
Next.Trap3:
 Var=12
Error.Resume62x:
 Exit Sub
Error.Trap62x:
 If Temp1=50 Then
    Resume Next.Trap1
 Endif
 If Temp1=43 Then
    Resume Next.Trap2
 Endif
 If Temp1=25 Then
    Resume Next.Trap3
 Endif
 Resume Error.Resume62x
End Sub

Sub Search.Mess.File(Var1!,Var2)
 On Local Error Goto ErrMain41
 Var2=False
 For TempA=False To MaxNodes
    Call Read.Message.Record(MessWorkFile1,TempA+1)
    Var$=MessWorkRecord1.UserName
    Select Case Rtrim$(Lcase$(Var$))
    Case "login", "logoff", "relogin"
       TempB=False
    Case Deleted$, Offline$
       TempB=False
    Case Else
       TempB=True
    End Select
    If TempB Then
       If MessWorkRecord1.UserIndex=Var1! Then
          Var2=True
          Exit For
       Endif
    Endif
 Next
MainExit41:
 Exit Sub
ErrMain41:
 Resume MainExit41
End Sub

Sub Extend.Amount2(Var#,Var$)
 VarX$=Ltrim$(Str$(Var#)) ' 1.111D308
 V=Instr(VarX$,"D")
 If V Then
    If Mid$(VarX$,2,1)="." Then
       VarX$=Left$(VarX$,1)+Mid$(VarX$,V)
    Endif
    Var$=" "+VarX$
 Else
    Var$=" "+Form$(Var#)
 Endif
End Sub

Sub Save.Screen2(Var)
 On Local Error Goto Error.Trap62
 If Var=False Then
    VarX3=(Max.Row-1)*80+80
    Redim Temp.ArrayY(VarX3) As Long
    Redim Temp.ArrayZ(VarX3) As Double
    For Var1=1 To Max.Row
       For Var2=1 To 80
          TempZ1=Screen(Var1,Var2)
          TempZ2=Screen(Var1,Var2,1)
          VarX2=(Var1-1)*80+Var2
          Temp.ArrayY(VarX2)=TempZ1
          Temp.ArrayZ(VarX2)=TempZ2
       Next
    Next
 Else
    Cls
    For VarX=Max.Row To 1 Step -1
       For VarY=1 To 80
          VarX2=(VarX-1)*80+VarY
          If Temp.ArrayY(VarX2)<>32 Then
             Goto Next.Line
          Endif
       Next
    Next
Next.Line:
    TempX=VarX
    For Var1=1 To VarX ' Max.Row
       For Var2=1 To 80
          VarX2=(Var1-1)*80+Var2
          VarB=Int(Temp.ArrayZ(VarX2)/16)
          VarF=Temp.ArrayZ(VarX2) Mod 16
          TempZ1=Temp.ArrayY(VarX2)
          Locate Var1,Var2,0
          Color VarF,VarB
          Print Chr$(TempZ1);
       Next
    Next
 Endif
Error.Resume62:
 Exit Sub
Error.Trap62:
 Resume Error.Resume62
End Sub
