Rem file: Copyit.bas - Public Domain QB64 Utility v9.0a r9.0a 2025.

Rem v8.0a r1.0a updates:
Rem    Updates Function LastSwitch.
Rem    Removes some unused variables.
Rem
Rem v8.0a r2.0a updates:
Rem    Fixes CreateFile declaration for hfind.
Rem
Rem v9.0a r1.0a updates:
Rem    Adds /zc to not copy compressed files.
Rem    Adds /ze to not copy encrypted files.
Rem    Adds /xc to copy only compressed files.
Rem    Adds /xe to copy only encrypted files.
Rem
Rem v9.0a r2.0a updates:
Rem    Now preserves unicode filenames.
Rem    Now also preserves unicode directories.
Rem    Adds break option to break trap.
Rem
Rem v9.0a r3.0a updates:
Rem    Adds quit option to disk full error.
Rem    Now copies ambiguated unicode filenames.
Rem    Fixes switches in moreprompt.
Rem
Rem v9.0a r4.0a updates:
Rem    Adds skip all to copy prompt.
Rem    Extends moreprompts to be verbose.
Rem    Adds /-5 switch to skip all.
Rem
Rem v9.0a r5.0a updates:
Rem    Repairs call to parameter in CreateDirectory()
Rem    Successful test with large database using /b3 and with
Rem      source/dest both netpath excluding *.* to copy
Rem      directory structure only.
Rem
Rem v9.0a r6.0a updates:
Rem    Fixes memory leak in CreateDirectory()
Rem    Only attempts to createdir if not exist.
Rem
Rem v9.0a r7.0 updates:
Rem    Fixes flags in excluded filelists
Rem    Only copies directories with specified files using /b3
Rem
Rem v9.0a r8.0 updates:
Rem    Added check for error x3E6 during CreateDir
Rem    Adds Startdir$ for default directory
Rem    Edits Curdir$ in Readconfig
Rem
Rem v9.0a r9.0 updates:
Rem    Adds custom command$ function.
Rem    Removes call to SetCurrentDirectory.

' default integer variables
DefInt A-Z

' dimension variables at runtime
Rem $Dynamic

' make windows title
_Title "COPYIT"

' define boolean values
Const True = -1
Const False = 0
Const SFalse = 0!
Const DFalse = 0#
Const Nul = ""

' define color values
Const Black = 0
Const Green = 10
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' define filelist constant
Const RecurseLevel = 8

' define version value
Const Version$ = "v9.0a"
Const Release$ = "r9.0a"

' declare filename buffer
Const buflen = 4096 ' can be changed
Dim Shared fbuffer As String * buflen

' declare filename strings
Dim Shared ASCIIZcopy As String * 260
Dim Shared ASCIIZfile As String * 260

' declare drive variables
Dim Shared Current.Drive As String * 1
Dim Shared Drive.Search As String * 1

' declare default directory variables
Dim Shared StartDir As String

' declare filename variables
Dim Shared Filename.Search As String * 260

' declare exclusion flag variables
Dim Shared Number.Excluded As Integer
Dim Shared Max.Excluded As Integer
Dim Shared Check.Flag As Integer
Dim Shared Pattern.Flag As Integer
Dim Shared Exclude.Flag As Integer
Dim Shared Synched.Flag As Integer
Dim Shared Range.Flag As Integer
Dim Shared Size.Flag As Integer

' declare filename arrays
Dim Shared Excluded.Files(1) As String * 128
Dim Shared Parameters(1) As String * 348
Dim Shared Skip.Filenames(1) As String * 12

' declare ascii arrays
Dim Shared Convert.Ascii(10, 1) As Integer
Dim Shared Strip.Ascii(1) As Integer

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Disk.Full As Integer
Dim Shared Error.Level As Integer
Dim Shared Imbedded As Integer
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer
Dim Shared Quote As String * 1

' declare work variables
Dim Shared Continue.Searching As Integer
Dim Shared Continuous.Display As Integer
Dim Shared Continuous.Display2 As Integer
Dim Shared Continuous.Display3 As Integer
Dim Shared Double.Line As Integer
Dim Shared Dot.Count As Integer
Dim Shared Dot.Total As Integer
Dim Shared Files.Counted As Double
Dim Shared More.Display As Integer
Dim Shared Dirs.Counted As Double
Dim Shared Dirs.Created As Double
Dim Shared Total.Deleted As Double
Dim Shared Quit.Searching As Integer
Dim Shared Skip.All As Integer
Dim Shared Control.Break As Integer

' declare file synchronize work variables
Dim Shared Synch.Files As Integer
Dim Shared Synch.Files1 As Integer, Synch.Files2 As Integer
Dim Shared Synch.Files3 As Integer, Synch.Files4 As Integer
Dim Shared Synch.Files5 As Integer, Synch.Files6 As Integer
Dim Shared Synch.Files7 As Integer, Synch.Files8 As Integer
Dim Shared Synch.Files9 As Integer, Synch.FilesA As Integer
Dim Shared Synch.FilesB As Integer, Synch.FilesC As Integer
Dim Shared Synch.Type1 As Integer, Synch.Type2 As Integer
Dim Shared Synch.Type3 As Integer

' declare search work variables
Dim Shared Search.Date As Integer, Search.Time As Integer
Dim Shared Search.From.Date As Single, Search.To.Date As Single
Dim Shared Search.From.Time As Single, Search.To.Time As Single
Dim Shared File.Size As Double, Recurse.Directories As Integer

' declare pattern search work variables
Dim Shared Pattern.Filename As String
Dim Shared Pattern.Match As Integer
Dim Shared Pattern.Search.Date As Integer
Dim Shared Pattern.Search.From.Date As String
Dim Shared Pattern.Search.To.Date As String
Dim Shared Pattern.Search As Integer

' declare attribute search variables
Dim Shared Display.Attribute As Integer, Display.Hidden As Integer
Dim Shared Display.System As Integer, Display.Readonly As Integer
Dim Shared Display.Archive As Integer, Display.Any As Integer
Dim Shared Display.Compressed As Integer, Display.Encrypted As Integer
Dim Shared No.Display.Archive As Integer, No.Display.Readonly As Integer
Dim Shared No.Display.System As Integer, No.Display.Hidden As Integer
Dim Shared No.Display.Any As Integer, File.Attribute As _Unsigned Long
Dim Shared No.Display.Compressed As Integer, No.Display.Encrypted As Integer

' declare destination attribute work variables
Dim Shared Dir.Attribute As _Unsigned Long, Set.Dest.Archive As Integer
Dim Shared Set.Dest.Readonly As Integer, Set.Dest.System As Integer
Dim Shared Set.Dest.Hidden As Integer, Set.Dest.Any As Integer
Dim Shared Clear.Dest.Archive As Integer, Clear.Dest.Readonly As Integer
Dim Shared Clear.Dest.System As Integer, Clear.Dest.Hidden As Integer
Dim Shared Clear.Dest.Any As Integer

' declare source attribute work variables
Dim Shared Source.Attribute As _Unsigned Long, Set.Source.Archive As Integer
Dim Shared Set.Source.Readonly As Integer, Set.Source.System As Integer
Dim Shared Set.Source.Hidden As Integer, Set.Source.Any As Integer
Dim Shared Clear.Source.Archive As Integer, Clear.Source.Readonly As Integer
Dim Shared Clear.Source.System As Integer, Clear.Source.Hidden As Integer
Dim Shared Clear.Source.Any As Integer, Set.Source.Attribute As Integer

' declare work variables
Dim Shared Overwrite.Prompt As Integer, Debug.ModeX As Integer
Dim Shared Dont.Overwrite As Integer, Debug.Mode As Integer
Dim Shared Dot.Mode As Integer, Rate.Mode As Integer
Dim Shared Start.Time As Single, Stop.Time As Single
Dim Shared Time.Elapsed As Single, Percent.Display As Integer
Dim Shared Percent As Single, Percent.Flag As Integer
Dim Shared Progress.Bar As Integer, Current.Progress As Integer
Dim Shared Display.Errors As Integer, Last.Percent As Single
Dim Shared Display.Header As Integer, Title.Percent As String

' declare copy work variables
Dim Shared Display.Lowercase As Integer, Copy.Ascii As Integer
Dim Shared Ascii.Strips As Integer, Ascii.Filters As Integer
Dim Shared Max.Filters As Integer, Max.Strips As Integer
Dim Shared Directory.Exists As Integer, Filename.Exists As Integer
Dim Shared Dir.Copy.Name As String * 260, Dir.Copy.Target As String * 260
Dim Shared Force.LowerCase As Integer

' declare bytes copied variables
Dim Shared Bytes.Copied As Double
Dim Shared Total.Bytes As Double
Dim Shared Total.Bytes2 As Double

' declare file date/time override work varibles
Dim Shared Override.Create.Date As Integer
Dim Shared Override.Access.Date As Integer
Dim Shared Override.Modify.Date As Integer

Dim Shared Override.Date.Month As Integer
Dim Shared Override.Date.Day As Integer
Dim Shared Override.Date.Year As Integer
Dim Shared Override.Date As Integer

Dim Shared Override.Time.Hour As Integer
Dim Shared Override.Time.Minute As Integer
Dim Shared Override.Time.Second As Integer
Dim Shared Override.Time As Integer

Dim Shared Directory.Path As String

Dim Shared Extended.Time As Integer

' declare copy date/time range work variables
Dim Shared Compare.Create.Date As Integer
Dim Shared Compare.Access.Date As Integer
Dim Shared Compare.Modify.Date As Integer

' declare synchronize date/time work variables
Dim Shared Synch.File.Create.Date As Single
Dim Shared Synch.File.Access.Date As Single
Dim Shared Synch.File.Modify.Date As Single
Dim Shared Synch.File.Create.Time As Single
Dim Shared Synch.File.Access.Time As Single
Dim Shared Synch.File.Modify.Time As Single

' declare synchronize date/time work variables
Dim Shared Synch.Work.Create.Date As Single
Dim Shared Synch.Work.Access.Date As Single
Dim Shared Synch.Work.Modify.Date As Single
Dim Shared Synch.Work.Create.Time As Single
Dim Shared Synch.Work.Access.Time As Single
Dim Shared Synch.Work.Modify.Time As Single

' declare filesize work variables
Dim Shared Copy.Zero As Integer
Dim Shared Dest.File.Size As Double
Dim Shared Search.File.Size As Integer
Dim Shared Search.Size.From As Double
Dim Shared Search.Size.To As Double

' declare destination work variables
Dim Shared Ambiguate.Display As Integer, Append.Handle As Integer
Dim Shared Copy.Directory As Integer, Copy.Target As String
Dim Shared Default.Dest As String, Default.Dir As String
Dim Shared Dest.Dir As String, Dest.File As String
Dim Shared Display.Path As Integer, Display.Wide As Integer
Dim Shared Drive.Letter As Integer, Short.Display As Integer
Dim Shared Short.Display2 As Integer, Short.Display3 As Integer
Dim Shared Short.Display4 As Integer, Start.Dir As String
Dim Shared Wide.List As Integer, Title.Header As String
Dim Shared Skip.Directory As Integer, Current.Directory As String

' declare append variables
Dim Shared Append.Dest As Integer, Append.Files As Integer
Dim Shared Byte.Switch As Integer, Byte.Override As Double
Dim Shared Resume.File As Integer

' declare destination work arrays
Dim Shared Destinate.Directory(1) As String * 260
Dim Shared Destinate.Filename(1) As String * 260
Dim Shared Destinate.Netpaths(1) As String * 260

' declare destination work variables
Dim Shared Max.Dest.Dirs As Integer, Max.Dest.Files As Integer
Dim Shared Max.Dest.Nets As Integer, Number.Dest.Dirs As Integer
Dim Shared Number.Dest.Files As Integer, Number.Dest.Nets As Integer
Dim Shared Default.Net As String * 64, Source.Net As String * 64
Dim Shared Zero.Dirs As Integer, Zero.Nets As Integer

' declare nest recursion variables
Dim Shared Nested.Recurse As Integer, Nested.Levels As Integer
Dim Shared Recursion As Integer, Zero.Nest As Integer
Dim Shared Recurse.Error As Integer, Max.Recurse As Integer

' declare delete copied files variables
Dim Shared Continue.Deleting As Integer, Continue.Subdelete As Integer
Dim Shared Delete.Copied As Integer, Delete.Directory As Integer
Dim Shared Prompt.Delete1 As Integer, Prompt.Delete2 As Integer
Dim Shared Deleted.Dirs As Double, Deleted.Files As Double

' declare DOS command work variables
Dim Shared DOS.Command(1) As String * 128, Disable.Cmd As Integer
Dim Shared Max.Commands As Integer, Number.Commands As Integer

' declare ignore switches
Dim Shared Ignore.Config As Integer, Ignore.Skip As Integer

' declare filelist variables
Dim Shared Enable.Redirect As Integer, Disable.Prompts As Integer

' declare error variables
Dim Shared DataError As Integer, Error.Flag As Integer

' declare floppy copy variables (unused).
Dim Shared Temp.Drive.Dir As String * 260

' declare debug switches
Dim Shared DebugDelay As Single

' declare dos command work variables
ReDim DOS.Command(1 To 10) As String * 128
ReDim Parameters(1 To 12) As String * 348

' declare filename arrays
ReDim Skip.Filenames(1 To 10) As String * 12
ReDim Excluded.Files(1 To 10) As String * 128

' declare work arrays
ReDim Convert.Ascii(1 To 10, 1 To 2) As Integer
ReDim Strip.Ascii(1 To 10) As Integer

' declare destination work arrays
ReDim Destinate.Directory(1 To 10) As String * 260
ReDim Destinate.Filename(1 To 10) As String * 260
ReDim Destinate.Netpaths(1 To 10) As String * 260

' declare library constants.
Const MAX_PATH = 260
Const MAX_PATH2 = 520 ' length of a Unicode ASCIIZ string
Const INVALID_HANDLE_VALUE = -1

' declare unicode variables
Dim Shared FileIsUnicode As Integer
Dim Shared UnicodeShort As String
Dim Shared UnicodeLong As String

Dim Shared DirIsUnicode As Integer
Dim Shared DirUnicodeShort As String
Dim Shared DirUnicodeLong As String

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATAA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

' windows structure for a wide FindFile
Type WIN32_FIND_DATAW
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path2
   cAlternateFileName As String * 28
End Type

' declare external libraries.
Declare Dynamic Library "kernel32"
   Function FindFirstFileA~%& (ByVal lpFileName~%&, ByVal lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindFirstFileW~%& (lpwszFileName$, ByVal lpFindFileData~%&)
   Function FindNextFileW& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)
   Function MoveFileW (f$, g$)

   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, ByVal nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, ByVal nFileSystemNameSize&)
   Function GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
   Function GetDiskFreeSpaceExA& (filename$, free As _Unsigned _Integer64, total As _Unsigned _Integer64, free2 As _Unsigned _Integer64)

   Function DeleteFileA% (F$)
   Function RemoveDirectoryA% (F$)
   Function CreateDirectoryA% (F$, ByVal X%%)
   Function SetCurrentDirectoryA% (f$)

   Function CloseHandle& (ByVal hfile As _Offset)
   Function GetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function SetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function SystemTimeToFileTime& (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME)

   Function GetLastError& ()
End Declare

Declare Library
   Function CreateFile%& (filename$, ByVal access&, ByVal sharing&, ByVal sec_attr%&, ByVal create&, ByVal flags&, ByVal template%&)
   Function GetFileAttributes& (f$)
   Function SetFileAttributes& (f$, ByVal a&)
   Function GetDriveType& (d$)
   Function GetShortPathName& (InP$, OutP$, ByVal length&)
   Function GetModuleFileNameA (ByVal Module As Long, FileName As String, ByVal nSize As Long)
   Function getcwd$ (buffer$, ByVal buflen)
End Declare

' declare library variables.
Dim Shared CreateDate As FILETIME
Dim Shared AccessDate As FILETIME
Dim Shared ModifyDate As FILETIME

Dim Shared SourceCreateDate As FILETIME
Dim Shared SourceAccessDate As FILETIME
Dim Shared SourceModifyDate As FILETIME

Dim Shared SysTime As SYSTEMTIME
Dim Shared DriveType As String
Dim Shared finddatatemp As WIN32_FIND_DATAA

' declare standard error trap
On Error GoTo Error.Routine

' start timer trap.
On Timer(1) Timer.Trap
Timer On
VarQ = _Exit

' force default path
x$ = _StartDir$
StartDir$ = x$
If Right$(StartDir$, 1) <> "\" Then
   StartDir$ = StartDir$ + "\"
End If
f$ = x$ + Chr$(0)
'x = SetCurrentDirectoryA(f$)

' check command line
VarX$ = Read.Command$
VarX$ = LTrim$(RTrim$(VarX$))
If VarX$ = Nul Then
   ' display header
   Color White, Black
   GoSub Header
   Display.Header = True

   ' get command line input
   Print "File list(<enter>=*.*): ";
   Line Input VarX$
   Do
      Color White, Black
      Print "Switches(?=list): ";
      Line Input Var$
      If Var$ = "?" Then
         Call BootUsage
      Else
         VarX$ = VarX$ + Var$
         Exit Do
      End If
   Loop
End If

' read command line switches
Call ReadSwitches(VarX$)
Last.Switch = 0
Switch.Exist = 0

' store skip file list
Skip.Filenames(1) = "WIN386.SWP"
Skip.Filenames(2) = "PAGEFILE.SYS"
Skip.Filenames(3) = "HIBERFIL.SYS"
Skip.Filenames(4) = "SWAPFILE.SYS"

' read current drive
Current.Drive = Left$(_CWD$, 1)
Current.Directory = _CWD$
If Right$(Current.Directory, 1) <> "\" Then
   Current.Directory = Current.Directory + "\"
End If

' store default directory
If Left$(_CWD$, 2) = "\\" Then
   Default.Dir = _CWD$
Else
   Default.Dir = Mid$(_CWD$, 3)
End If

' store default server name
Default.Net = Nul
Var$ = Environ$("COMPUTERNAME")
If Len(Var$) Then
   Default.Net = "\\" + Var$
End If

' reset number of destination filenames
If Number.Dest.Files = False Then
   Number.Dest.Files = 1
   Destinate.Filename(1) = Nul
End If

' reset number of destination directories
If Number.Dest.Dirs = False Or Zero.Dirs Then
   Zero.Dirs = True
   Number.Dest.Dirs = 1
   If Number.Dest.Nets = False Then
      Destinate.Directory(1) = Default.Dir
   Else
      Destinate.Directory(1) = "\"
   End If
End If

' reset and check netpaths
If Zero.Nets Then
   Var2$ = RTrim$(Default.Net)
   If Len(Var2$) Then
      Var2$ = Var2$ + LCase$(Current.Drive) + "\"
      Number.Dest.Nets = 1
      Destinate.Netpaths(1) = Var2$
   End If
End If
If Number.Dest.Nets = False Then
   Number.Dest.Nets = 1
   Destinate.Netpaths(1) = Nul
End If
For Count0 = 1 To Number.Dest.Nets
   Next.Dest.Net$ = Destinate.Netpaths(Count0)
   Next.Dest.Net$ = RTrim$(Next.Dest.Net$)
   If Next.Dest.Net$ <> Nul Then
      ' check netpath
      If Right$(Next.Dest.Net$, 1) = "\" Then
         Next.Dest.Net$ = Left$(Next.Dest.Net$, Len(Next.Dest.Net$) - 1)
      End If
      If Left$(Next.Dest.Net$, 2) <> "\\" Then
         Next.Dest.Net$ = "\" + Next.Dest.Net$
      End If
      If Left$(Next.Dest.Net$, 2) <> "\\" Then
         Next.Dest.Net$ = "\" + Next.Dest.Net$
      End If
      Destinate.Netpaths(Count0) = Next.Dest.Net$
   End If
Next

' check /d omitted or specified w/o parameters
If Zero.Dirs Then
   ' compare /g\\serv\c\ to default.net
   If Number.Dest.Nets = 1 Then
      Var1$ = RTrim$(Destinate.Netpaths(1))
      If Len(Var1$) Then
         Var1$ = UCase$(Var1$) + "\"
         Var2$ = RTrim$(Default.Net)
         If Len(Var2$) Then
            Var2$ = UCase$(Var2$) + Current.Drive + "\"
            If Var1$ = Var2$ Then
               Destinate.Directory(1) = Default.Dir
            End If
         End If
      End If
   End If
End If

' store time copying began
Start.Time = Timer

' search filespecs
Do

   ' store input filename
   Stored.Command.Line$ = Command.Line

   ' create filenames
   Call MakeFilename

   ' locate filelist character
   Command.Out$ = Command.Work

   ' check filelist character
   Flag = FilelistIS(Command.Out$)
   If Flag And Enable.Redirect Then

      ' reset recurse counter
      Max.Recurse = 0

      ' process work filename containing filelist
      Call ProcessFilelist(Command.Out$, -1)

      ' check overwrite flag
      If Quit.Searching Then
         Error.Level = 1
         GoTo End.Copy
      End If
   Else

      ' process filename
      Call ProcessCommand(Quit)

      ' check overwrite flag
      If Quit Or Quit.Searching Then
         Error.Level = 1
         GoTo End.Copy
      End If
   End If

   ' check command line
   If Command.Line = Nul Then
      Exit Do
   End If

   ' check quit searching
   If Quit.Searching Then
      Exit Do
   End If
Loop

' program end label
End.Copy:

' check append files
If Append.Files Then
   Call CloseFile(-1)
End If

' calculate time elapsed during file copying
Stop.Time = Timer
Time.Elapsed = Stop.Time - Start.Time

' check timing past midnight
If Time.Elapsed < SFalse Then
   Time.Elapsed = Time.Elapsed + 86400! ' add one day of seconds
End If

' display end program
If Continuous.Display = False Then
   If Wide.List Then
      Wide.List = False
      Print
   End If
   Color Yellow, Black

   If Continuous.Display2 = False Then
      Print "Directories copied: ";
      Print FormatString$(Dirs.Counted)
      If Dirs.Created > 0 Then
         Print "Directories created: ";
         Print FormatString$(Dirs.Created)
      End If
      If Double.Line >= 4 Then
         Print "Directories deleted: ";
         Print FormatString$(Total.Deleted)
      End If
      Print "Files copied: ";
      Print FormatString$(Files.Counted)
      If Double.Line >= 4 Then
         Print "Bytes counted: ";
         Print FormatString$(Bytes.Copied)
         Print "Bytes copied: ";
         Print FormatString$(Total.Bytes)
         If Deleted.Files > 0# Then
            Print "Files deleted: ";
            Print FormatString$(Deleted.Files)
         End If
      End If
   End If

   ' check to display time/rate
   If Rate.Mode Then
      ' display transfer time
      Call Time.Display1

      ' display transfer rate
      Call Time.Display2
   End If

   ' prompt to exit Copyit
   Prompt$ = "Press <enter> to exit to DOS:"
   Call MorePrompt(Prompt$, Chr$(13), Outpt$, Chr$(13))
End If

' reset color
Color Plain, Black

' exit in debug mode
If Debug.Mode Then
   System
End If

' return error level to DOS
Select Case Error.Level
   Case 1
      End 8
   Case -1
      End 4
   Case 0
      If Files.Counted = DFalse Then
         End 2
      Else
         End 0
      End If
End Select
End 2

' make header
Header:
If Header.Flag Then
   Return
End If
Header.Flag = True
If Continuous.Display = False Then
   Color White, Black
   Print "Copyit " + Version$ + " " + Release$ + ": File copy utility; "
End If
Return

' critical error trap
Error.Routine:
' process error
DataError = Err
If Error.Flag Then
   Resume Next
End If
If Display.Errors Then
   Error.Level = True
   Resume Next
End If
' display error
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$, "c")
Select Case Outpt$
   Case "r"
      Resume
   Case "q"
      Error.Level = True
      Resume End.Copy
   Case "c"
      Resume Next
End Select
Color Plain, Black
End 0

' timer ctrl-break trap.
Sub Timer.Trap
   VarQ = _Exit
   If VarQ Then ' Control-Break
      Prompt$ = "Press B to break, C to continue, Q to quit:"
      Call MorePrompt(Prompt$, "bqc", Outpt$, "c")
      If Outpt$ = "b" Then
         Control.Break = True
      End If
      If Outpt$ = "q" Then
         System
      End If
   End If
End Sub

' clear display progress
Sub ClearDisplay (Var)
   ' break wide list
   If Var = 0 Then
      If Wide.List Then
         Wide.List = False
         Print
      End If
   End If
   ' clear dots
   For Count = 1 To Dot.Count
      Print Chr$(29); " "; Chr$(29);
   Next
   ' clear percent display
   If Percent.Display Then
      If Percent.Flag Then
         For Imbedded = 1 To 4
            Print Chr$(29); " "; Chr$(29);
         Next
      End If
   End If
   ' clear progress bar
   If Progress.Bar Then
      For Imbedded = 1 To Current.Progress
         Print Chr$(29); " "; Chr$(29);
      Next
   End If
   Dot.Count = False
   Dot.Total = False
   Count.Forward = True
   Current.Progress = False
End Sub

' process filelist recursively
Sub ProcessFilelist (Command.Out$, PromptFlag)
   Dim ASCIIZ As String * 260
   Dim hfind As _Offset

   ' check recurse error
   If Max.Recurse >= RecurseLevel Then
      Exit Sub
   End If

   ' process work filename
   Var$ = Nul
   If Command.Out$ <> Nul Then
      If _FileExists(Command.Out$) Then
         Var$ = Command.Out$
      End If
   End If

   ' check filelist exists
   If Var$ <> Nul Then

      ' concatenate work filename
      Var$ = Command.Work ' command line filename
      For Var = Len(Var$) To 1 Step -1
         If Mid$(Var$, Var, 1) = "\" Then
            Var$ = Mid$(Var$, Var + 1)
            Exit For
         End If
      Next
      If Mid$(Var$, 2, 1) = ":" Then
         Var$ = Mid$(Var$, 3)
      End If
      Filename2$ = Var$
      Var$ = Mid$(Var$, 2)
      Var2$ = Command.Out$
      For Var = Len(Var2$) To 1 Step -1
         If Mid$(Var2$, Var, 1) = "\" Then
            Var2$ = Left$(Var2$, Var)
            Var$ = Var2$ + Var$
            Exit For
         End If
      Next

      ' check filename
      Call CheckFile(Filename2$, True)
      If Check.Flag = False Then
         Var$ = Nul
      End If

      ' prompt for filelist
      If Disable.Prompts = False Then
         If Var$ <> Nul Then
            If PromptFlag Then
               ' prompt to use filelist
               Prompt$ = "Use '" + LCase$(Var$) + "' as filelist(y)es,(n)o,(q)uit?"
               Call MorePrompt(Prompt$, "ynq", Outpt$, "y")
               Select Case Outpt$
                  Case "q"
                     Quit.Searching = True
                     Exit Sub
                  Case "n"
                     Var$ = Nul
                     Exit Sub
               End Select
            End If
         End If
      End If
   End If

   ' check filelist exists
   If Var$ = Nul Then

      ' restore original command line
      Command.Line = Stored.Command.Line$

      ' create filenames
      Call MakeFilename

      ' continue processing filename
      Exit Sub
   End If

   ' open filename list
   x = 0
   ASCIIZ = Command.Out$ + Chr$(0)
   hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, 0, 0)
   If hfind <> INVALID_HANDLE_VALUE Then
      x = CloseHandle(hfind)
   End If
   If x = 0 Then
      ' display filename error
      Call DisplayError("Error" + Str$(GetLastError&) + " opening listfile.")
      Exit Sub
   End If

   V = FreeFile
   DataError = False
   Error.Flag = True
   Open Command.Out$ For Input Shared As #V
   Error.Flag = False

   ' check error flag
   If DataError Then
      ' display filename error
      Call DisplayError("Error" + Str$(DataError) + " opening listfile.")
      Exit Sub
   End If

   ' check recursion level
   Max.Recurse = Max.Recurse + 1
   If Max.Recurse >= RecurseLevel Then
      Call DisplayError("Recursive filelist error.")
      Exit Sub
   End If

   ' process input filenames
   Do Until EOF(V)

      ' read next filename from input file
      Line Input #V, Command.Work
      Command.Work = RTrim$(Command.Work)

      ' check input
      If Len(Command.Work) Then

         ' locate filelist character
         Var2$ = Command.Work
         Flag = FilelistIS(Var2$)
         If Flag Then
            ' recursively call filelist
            Call ProcessFilelist(Var2$, 0)
         Else
            ' process filename
            Call ProcessCommand(Quit)
         End If

         ' check overwrite flag
         If Quit Or Quit.Searching Then
            Error.Level = 1
            Exit Do
         End If
      End If
   Loop
   Close #V

   ' check recursion level
   Max.Recurse = Max.Recurse - 1
End Sub

' return -1 for filelist character
Function FilelistIS (Command.Out$)
   Flag = False
   Command.Out2$ = Nul
   If Mid$(Command.Out$, 2, 1) = ":" Then
      Command.Out2$ = Left$(Command.Out$, 2)
      Command.Out$ = Mid$(Command.Out$, 3)
   End If
   If Left$(Command.Out$, 1) = "@" Then
      Flag = True
      Command.Out$ = Mid$(Command.Out$, 2)
   Else
      For Var = Len(Command.Out$) To 1 Step -1
         If Mid$(Command.Out$, Var, 1) = "\" Then
            Char$ = Mid$(Command.Out$, Var + 1)
            If Left$(Char$, 1) = "@" Then
               Flag = True
               Command.Out$ = Left$(Command.Out$, Var) + Mid$(Char$, 2)
            End If
            Exit For
         End If
      Next
   End If
   If Len(Command.Out2$) Then
      Command.Out$ = Command.Out2$ + Command.Out$
   End If
   FilelistIS = Flag
End Function

' routine to copy a filename
Sub CopyFiles (Next.Dest.Net$, Source.Directory$, Source.Filename$)
   ' declare subroutine variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim ASCIIZwrite As String * 260
   Dim Handle As Integer
   Dim Number.Bytes As Integer
   Dim Sum.Bytes As Double
   Dim Sum.Bytes2 As Double

   ' make filename
   Temp.Net$ = RTrim$(Source.Net)
   If Temp.Net$ = Nul Then
      ASCIIZ = Source.Directory$ + Source.Filename$ + Chr$(0)
   Else
      If Left$(Directory.Search$, 1) = "\" Then
         ASCIIZ = Temp.Net$ + Source.Directory$ + Source.Filename$ + Chr$(0)
      Else
         ASCIIZ = Temp.Net$ + "\" + Source.Directory$ + Source.Filename$ + Chr$(0)
      End If
   End If

   ' read file attributes
   Attribute = GetFileAttributes(ASCIIZ)

   ' check directory
   If (Attribute And &H10) = &H10 Then
      Exit Sub
   End If

   ' store file attribute
   Source.Attribute = Attribute

   ' check file attribute
   If Display.Attribute Then

      ' check for readonly file
      If Display.Readonly = True Then
         If (Attribute And 1) <> 1 Then
            Exit Sub
         End If
      End If
      If No.Display.Readonly = True Then
         If (Attribute And 1) = 1 Then
            Exit Sub
         End If
      End If

      ' check for hidden file
      If Display.Hidden = True Then
         If (Attribute And 2) <> 2 Then
            Exit Sub
         End If
      End If
      If No.Display.Hidden = True Then
         If (Attribute And 2) = 2 Then
            Exit Sub
         End If
      End If

      ' check for system file
      If Display.System = True Then
         If (Attribute And 4) <> 4 Then
            Exit Sub
         End If
      End If
      If No.Display.System = True Then
         If (Attribute And 4) = 4 Then
            Exit Sub
         End If
      End If

      ' check for archive file
      If Display.Archive = True Then
         If (Attribute And &H20) <> &H20 Then
            Exit Sub
         End If
      End If
      If No.Display.Archive = True Then
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
      End If

      ' check for compressed file
      If Display.Compressed = True Then
         If (Attribute And &H800) <> &H800 Then
            Exit Sub
         End If
      End If
      If No.Display.Compressed = True Then
         If (Attribute And &H800) = &H800 Then
            Exit Sub
         End If
      End If

      ' check for encrypted file
      If Display.Encrypted = True Then
         If (Attribute And &H4000) <> &H4000 Then
            Exit Sub
         End If
      End If
      If No.Display.Encrypted = True Then
         If (Attribute And &H4000) = &H4000 Then
            Exit Sub
         End If
      End If

      ' check for no attributes
      If Display.Any = True Then
         If (Attribute And 1) = 1 Then
            Exit Sub
         End If
         If (Attribute And 2) = 2 Then
            Exit Sub
         End If
         If (Attribute And 4) = 4 Then
            Exit Sub
         End If
         If (Attribute And &H20) = &H20 Then
            Exit Sub
         End If
      End If
      If No.Display.Any = True Then
         If (Attribute And 1) = False Then
            If (Attribute And 2) = False Then
               If (Attribute And 4) = False Then
                  If (Attribute And &H20) = False Then
                     Exit Sub
                  End If
               End If
            End If
         End If
      End If
   End If

   ' reset destination file attribute
   If Set.Dest.Readonly Then
      Attribute = Attribute Or 1
   End If
   If Set.Dest.Hidden Then
      Attribute = Attribute Or 2
   End If
   If Set.Dest.System Then
      Attribute = Attribute Or 4
   End If
   If Set.Dest.Archive Then
      Attribute = Attribute Or &H20
   End If
   If Set.Dest.Any Then
      Attribute = Attribute Or &H27
   End If
   If Clear.Dest.Readonly Then
      Attribute = Attribute And Not 1
   End If
   If Clear.Dest.Hidden Then
      Attribute = Attribute And Not 2
   End If
   If Clear.Dest.System Then
      Attribute = Attribute And Not 4
   End If
   If Clear.Dest.Archive Then
      Attribute = Attribute And Not &H20
   End If
   If Clear.Dest.Any Then
      Attribute = Attribute And Not &H27
   End If

   ' reset source file attribute
   If Set.Source.Readonly Then
      Source.Attribute = Source.Attribute Or 1
   End If
   If Set.Source.Hidden Then
      Source.Attribute = Source.Attribute Or 2
   End If
   If Set.Source.System Then
      Source.Attribute = Source.Attribute Or 4
   End If
   If Set.Source.Archive Then
      Source.Attribute = Source.Attribute Or &H20
   End If
   If Set.Source.Any Then
      Source.Attribute = Source.Attribute Or &H27
   End If
   If Clear.Source.Readonly Then
      Source.Attribute = Source.Attribute And Not 1
   End If
   If Clear.Source.Hidden Then
      Source.Attribute = Source.Attribute And Not 2
   End If
   If Clear.Source.System Then
      Source.Attribute = Source.Attribute And Not 4
   End If
   If Clear.Source.Archive Then
      Source.Attribute = Source.Attribute And Not &H20
   End If
   If Clear.Source.Any Then
      Source.Attribute = Source.Attribute And Not &H27
   End If

   ' check file size range
   Call CheckSizeRange

   ' check return flag
   If Size.Flag Then
      Exit Sub
   End If

   ' store file date and time
   x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   GoSub Convert.Date
   Synch.Work.Create.Date = Work.Date.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
   GoSub Convert.Date
   Synch.Work.Access.Date = Work.Date.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   GoSub Convert.Date
   Synch.Work.Modify.Date = Work.Date.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
   GoSub Convert.Time
   Synch.Work.Create.Time = Work.Time.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
   GoSub Convert.Time
   Synch.Work.Access.Time = Work.Time.Temp!

   x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   GoSub Convert.Time
   Synch.Work.Modify.Time = Work.Time.Temp!

   ' check date/time range
   Call CheckDateRange

   ' check return flag
   If Range.Flag Then
      Exit Sub
   End If

   ' construct extended date/time string
   FileInfo$ = Nul
   If Double.Line >= 1 Then
      ' make file info
      FileInfo$ = MakeDate(1)
      FileInfo$ = FileInfo$ + "\" + MakeDate(2)
      FileInfo$ = FileInfo$ + "\" + MakeDate(3)
   End If

   ' store filename being copying
   Copy.File$ = Source.Directory$ + Source.Filename$
   If Append.Files Then
      Copy.Dest$ = Dest.Dir
   Else
      If Copy.Directory = False Then
         Copy.Dest$ = Dest.Dir + Source.Filename$
      Else
         Copy.Dest$ = Copy.Target + Source.Filename$
      End If
      If Next.Dest.Net$ = Nul Then
         ASCIIZwrite = Copy.Dest$ + Chr$(0)
      Else
         If Left$(Copy.Dest$, 1) = "\" Then
            ASCIIZwrite = Next.Dest.Net$ + Copy.Dest$ + Chr$(0)
         Else
            ASCIIZwrite = Next.Dest.Net$ + "\" + Copy.Dest$ + Chr$(0)
         End If
      End If
   End If

   ' check filename
   Filename2$ = Source.Filename$
   Call CheckFile(Filename2$, False)
   If Check.Flag = False Then
      Exit Sub
   End If

   ' make target directory only if files exist
   If Skip.Directory Then
      Call CreateDirectory(Next.Dest.Net$)
   End If

   ' check if appending files
   If Append.Files Then
      ' store output file info
      If Next.Dest.Net$ = Nul Then
         ASCIIZfile = Dest.Dir + Chr$(0)
      Else
         If Left$(Dest.Dir, 1) = "\" Then
            ASCIIZfile = Next.Dest.Net$ + Dest.Dir + Chr$(0)
         Else
            ASCIIZfile = Next.Dest.Net$ + "\" + Dest.Dir + Chr$(0)
         End If
      End If

      ' check if files similar
      Call ReadFileSynch

      ' check files
      Call CheckSynched
      If Synched.Flag Then
         Exit Sub
      End If
   Else
      ' store output file info
      ASCIIZfile = ASCIIZwrite

      ' check if files similar
      Call ReadFileSynch

      ' check files
      Call CheckSynched
      If Synched.Flag Then
         Exit Sub
      End If
   End If

   ' verify/display filename
   Call CheckFileExists(Next.Dest.Net$, Copy.Dest$, Response)
   If Response = False And Skip.All Then
      Eat$ = Nul
   Else
      Call FilenameCopying(Next.Dest.Net$, Copy.File$, Copy.Dest$)
   End If

   ' check copying flag
   If Filename.Exists Then
      Exit Sub
   End If

   ' get filename date/time
   ASCIIZcopy = ASCIIZ
   Call ExtendedFile(1)

   ' reset flag error
   Handle = 0

   ' open file for input
   Open.Filename$ = ASCIIZ
   V = InStr(Open.Filename$, Chr$(0))
   If V Then
      Open.Filename$ = Left$(Open.Filename$, V - 1)
   End If
   Handle = FreeFile

   DataError = False
   Error.Flag = True
   Open Open.Filename$ For Binary Shared As #Handle
   Error.Flag = False

   ' check error flag
   If DataError Then
      Handle = 0
   End If

   ' check open file error
   If Handle = 0 Then
      ' display any error
      If Debug.Mode Then
         If DataError <> 70 Then ' ignore share violation
            Call DisplayError("Error" + Str$(DataError) + " opening input filename.")
         End If
      End If
      Exit Sub
   End If

   ' set seek position to start of file
   SeekPosition# = 1#

   ' check byte position override
   If Byte.Switch Then
      ' offset from specified byte position
      SeekPosition# = Byte.Override
   End If

   ' check byte position override
   If Resume.File Then
      ' offset from dest. filesize position
      SeekPosition# = Dest.File.Size
   End If

   ' seek position in input file
   Seek Handle, SeekPosition#

   ' reset delete file flag
   Copy.Error = False

   ' check if appending files
   If Append.Files Then
      ' store output file info
      If Next.Dest.Net$ = Nul Then
         ASCIIZfile = Dest.Dir + Chr$(0)
      Else
         If Left$(Dest.Dir, 1) = "\" Then
            ASCIIZfile = Next.Dest.Net$ + Dest.Dir + Chr$(0)
         Else
            ASCIIZfile = Next.Dest.Net$ + "\" + Dest.Dir + Chr$(0)
         End If
      End If
      File.Attribute = Attribute

      ' check to overwrite
      If Overwrite.Prompt = False Then
         Copy.File$ = Directory.Search$ + RTrim$(Filename.Search)
         Copy.Dest$ = Dest.Dir
         Call PromptOverwrite(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
         If Response = False Then
            GoTo End.Copy.File1
         End If
      End If

      ' open output file
      Call OpenFile(OpenError)

      ' check error opening output file
      If OpenError Then
         Exit Sub
      End If
   Else
      ' store output file info
      ASCIIZfile = ASCIIZwrite
      File.Attribute = Attribute

      ' check to overwrite
      If Overwrite.Prompt = False Then
         Call PromptOverwrite(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
         If Response = False Then
            GoTo End.Copy.File1
         End If
      End If

      ' open output file
      Call OpenFile(OpenError)

      ' check error opening output file
      If OpenError Then
         GoTo End.Copy.File1
      End If
   End If

   ' reset error flag
   Error.Type = False
   Percent.Flag = False
   Current.Progress = False

   ' copy file
   Count.Forward = True
   Dot.Count = False
   Dot.Total = False

   ' file input loop
   Do
      ' reset and store error flag
      DataError = False
      Error.Flag = True

      ' read from file
      Number.Bytes = buflen
      position# = Loc(Handle)
      Get Handle, , fbuffer

      ' restore and check error flag
      Error.Flag = False
      If DataError Then
         Error.Type = DataError
         Exit Do
      End If

      ' store buffer and length of buffer
      buffer$ = Nul
      If position# + buflen > LOF(Handle) Then
         Number.Bytes = LOF(Handle) - position#
      End If
      If Number.Bytes > 0 Then
         buffer$ = Left$(fbuffer, Number.Bytes)
      End If

      ' show disk activity
      If Continuous.Display = False And Dot.Mode = False Then
         Dot.Total = Dot.Total + 1 ' count buflen blocks
         If Dot.Total >= 256 Then ' could be increased
            Dot.Total = 0
            If Count.Forward Then
               Print ".";
               Dot.Count = Dot.Count + 1
               If Dot.Count = 16 Then
                  Count.Forward = False
               End If
            Else
               Print Chr$(29); " "; Chr$(29);
               Dot.Count = Dot.Count - 1
               If Dot.Count = False Then
                  Count.Forward = True
               End If
            End If
         End If
      End If

      ' add total bytes counted
      Sum.Bytes2 = Sum.Bytes2 + Number.Bytes

      ' check total filesize to copy
      If File.Size > 0# Then

         ' check to display percent copied
         P$ = Nul
         Percent = (Sum.Bytes2 / File.Size) * 100!
         Percent = Int(Percent)
         If Percent = 0 Then
            If Percent.Flag = 0 Then
               P$ = "000%"
               If Percent.Display Then
                  Print P$;
                  Percent.Flag = True
               End If
            End If
         Else
            If Percent <> Last.Percent Then
               Last.Percent = Percent
               P$ = Right$(Str$(Percent + 1000%), 3) + "%"
               If Percent.Display Then
                  If Percent.Flag Then
                     For Imbedded = 1 To 4
                        Print Chr$(29); " "; Chr$(29);
                     Next
                  End If
                  Print P$;
                  Percent.Flag = True
               End If
            End If
         End If

         ' display percent copied on title
         If Len(P$) Then
            If P$ <> Title.Percent Then
               Title.Percent = P$
               _Title Title.Header + " " + P$
            End If
         End If

         ' check to display progress bar
         If Progress.Bar Then
            Percent = (Sum.Bytes2 / File.Size) * 100#
            Percent = Int(Percent / 10)
            Do While Percent > Current.Progress
               If Current.Progress >= 10 Then
                  Exit Do
               End If
               Print "#";
               Current.Progress = Current.Progress + 1
            Loop
         End If
      End If

      ' check binary copy
      If Copy.Ascii = False Then
         Ascii.Exit = False
      Else
         If InStr(buffer$, Chr$(26)) Then ' eof char
            buffer$ = Left$(buffer$, InStr(buffer$, Chr$(26)))
            Number.Bytes = Len(buffer$)
            Ascii.Exit = True
         End If
      End If

      ' check number of bytes to copy
      If Number.Bytes > False Then

         ' check ascii filters
         For Count = 1 To Ascii.Filters
            Ascii.From = Convert.Ascii(Count, 1)
            Ascii.To = Convert.Ascii(Count, 2)
            Next.Imbedded = 1
            Do
               Imbedded = InStr(Next.Imbedded, buffer$, Chr$(Ascii.From))
               If Imbedded Then
                  Next.Imbedded = Imbedded + 1
                  Mid$(buffer$, Imbedded, 1) = Chr$(Ascii.To)
               Else
                  Exit Do
               End If
               If Next.Imbedded >= Number.Bytes Then
                  Exit Do
               End If
            Loop
         Next
      End If

      ' check number of bytes to copy
      If Number.Bytes > False Then

         ' check ascii strips
         For Count = 1 To Ascii.Strips
            ' check entire buffer is stripped
            If Left$(buffer$, Number.Bytes) = String$(Number.Bytes, Chr$(Strip.Ascii(Count))) Then
               Number.Bytes = 0
               Exit For
            End If

            ' check strip values
            Do
               Imbedded = InStr(buffer$, Chr$(Strip.Ascii(Count)))
               If Imbedded > False And Imbedded <= Number.Bytes Then
                  buffer$ = Left$(buffer$, Imbedded - 1) + Mid$(buffer$, Imbedded + 1)
                  Number.Bytes = Number.Bytes - 1
               Else
                  Exit Do
               End If
            Loop
         Next
      End If

      ' check number of bytes to copy
      If Number.Bytes > False Then
         ' reset and store error flag
         DataError = False
         Error.Flag = True

         ' append to file
         Put Append.Handle, , buffer$

         ' restore and check error flag
         Error.Flag = False
         If DataError Then
            Error.Type = DataError
            Exit Do
         End If

         ' increment bytes copied
         Sum.Bytes = Sum.Bytes + Number.Bytes

         ' check binary copy
         If Ascii.Exit Then
            Exit Do
         End If
      End If

      ' check for more input
      If EOF(Handle) Then
         Exit Do
      End If
   Loop

   ' clear display progress
   Call ClearDisplay(-1)

   ' update counter
   Files.Counted = Files.Counted + 1#

   ' check copying file error
   If DataError Then
      If Wide.List Then
         Wide.List = False
         Print
      End If
      Copy.Error = True
      If Display.Errors = False Then
         Color Red, Black
         If Error.Type = 61 Then ' disk full
            Disk.Full = True
            Quit.Searching = True
         End If
         Call DisplayCriticalError(Error.Type)
      End If
   End If

   ' close output file
   Call CloseFile(0)

   ' pcocess end of input file parsing
   End.Copy.File1:
   ' close input file
   If Handle Then
      Close #Handle
   End If

   ' display any errors
   If Debug.Mode Then
      If CloseError > False Then
         Call DisplayError("Error closing input filename.")
      End If
   End If

   ' check disk full flag
   If Disk.Full Then
      ' delete destination file
      If Append.Dest = False Then
         Call DeleteDestFile(False, Next.Dest.Net$, Source.Filename$)
      End If
      Exit Sub
   End If

   ' check copy error flag
   If Copy.Error Then
      ' delete destination file
      If Append.Dest = False Then
         Call DeleteDestFile(True, Next.Dest.Net$, Source.Filename$)
      End If
      Exit Sub
   End If

   ' check to change source attribute
   Reset.Source = False
   If RTrim$(Source.Net) <> Nul Then
      Reset.Source = True
   End If
   If Set.Source.Attribute Or Reset.Source Then
      ' reset source attribute
      x = SetFileAttributes&(ASCIIZ, Source.Attribute)
   End If

   ' store total bytes copied
   If OpenError = 0 Then
      Total.Bytes2 = Total.Bytes2 + File.Size
   End If

   ' store actual bytes copied
   If OpenError = 0 Then
      Total.Bytes = Total.Bytes + Sum.Bytes
   End If

   ' store virtual bytes copied
   If Resume.File Then
      Var# = File.Size - Dest.File.Size
   Else
      If Byte.Switch Then
         Var# = File.Size - Byte.Override
      Else
         Var# = File.Size
      End If
   End If
   If Var# < 0# Then
      Var# = 0#
   End If
   If OpenError = 0 Then
      Bytes.Copied = Bytes.Copied + Var#
   End If

   ' check display type
   Var = False
   If Double.Line >= 1 Then
      ' display file date/time
      Color Green, Black
      Print FileInfo$ + " ";
      Var = True
   End If

   ' check display type
   If Double.Line >= 2 Then
      ' display file size
      Color Red, Black
      Print FormatString$(File.Size);
      Var = True
   End If

   ' check display type
   If Double.Line >= 3 Then
      ' check for archive file
      Color White, Black
      If (Attribute And &H20) = &H20 Then
         Print " Archive";
      End If

      ' check for read-only file
      If (Attribute And 1) = 1 Then
         Print " Read-only";
      End If

      ' check for hidden file
      If (Attribute And 2) = 2 Then
         Print " Hidden";
      End If

      ' check for system file
      If (Attribute And 4) = 4 Then
         Print " System";
      End If

      ' check for compressed file
      If (Attribute And &H800) = &H800 Then
         Print " Compressed";
      End If

      ' check for encrypted file
      If (Attribute And &H4000) = &H4000 Then
         Print " Encrypted";
      End If
      Var = True
   End If
   If Var Then
      Wide.List = False
      Print
   End If

   ' check to delete source file
   If Delete.Copied Then
      Call DeleteSourceFile(Source.Directory$, Source.Filename$)
   End If
   Exit Sub

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   Work.Date.Temp! = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   Work.Time.Temp! = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return
End Sub

' display error trap message.
Sub DisplayCriticalError (Var)
   Select Case Var
      Case 6
         Print "Overflow";
      Case 9
         Print "Subscript out of range";
      Case 14
         Print "Out of string space";
      Case 24
         Print "Device timeout";
      Case 25
         Print "Device fault";
      Case 27
         Print "Out of paper";
      Case 52
         Print "Bad file name or number";
      Case 53
         Print "File not found";
      Case 54
         Print "Bad file mode";
      Case 55
         Print "File already open";
      Case 57
         Print "Device I/O error";
      Case 58
         Print "File already exists";
      Case 59
         Print "Bad record length";
      Case 61
         Print "Disk full";
      Case 62
         Print "Input past eof";
      Case 63
         Print "Bad record length";
      Case 64
         Print "Bad file name";
      Case 67
         Print "Not enough file handles";
      Case 68
         Print "Device unavailable";
      Case 70
         Print "Permission denied";
      Case 71
         Print "Disk not ready";
      Case 72
         Print "Disk-media error";
      Case 75
         Print "Path/File access error";
      Case 76
         Print "Pathname not found";
      Case 81
         Print "Invalid name";
      Case 90
         Print "Too many processes";
      Case Else
         Print "Untrapped error" + Str$(Var);
   End Select
   Print " copying files."
End Sub

' routine to access directories
Sub Directories (Next.Dest.Net$, Directory.Search$, Directory.Target$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ.Sub As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' declare wide functions
   Dim finddataw As WIN32_FIND_DATAW ' the windows filename structure
   Dim Wfile.HandleW As _Unsigned _Offset ' windows file handle for FindFile

   ' make directory filename
   Temp.Net$ = RTrim$(Source.Net)
   If Temp.Net$ = Nul Then
      ASCIIZ.Sub = Directory.Search$ + "*.*" + Chr$(0)
      Source.Search$ = Directory.Search$
   Else
      If Left$(Directory.Search$, 1) = "\" Then
         ASCIIZ.Sub = Temp.Net$ + Directory.Search$ + "*.*" + Chr$(0)
         Source.Search$ = Temp.Net$ + Directory.Search$
      Else
         ASCIIZ.Sub = Temp.Net$ + "\" + Directory.Search$ + "*.*" + Chr$(0)
         Source.Search$ = Temp.Net$ + "\" + Directory.Search$
      End If
   End If
   If Right$(Source.Search$, 1) = "\" Then
      Source.Search$ = Left$(Source.Search$, Len(Source.Search$) - 1)
   End If

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ.Sub), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' store source copied directory filename
      Copy.Target = Directory.Target$

      ' check to copy directory structure
      Directory.Exists = False
      If Copy.Directory Then
         Dir.Copy.Name = Directory.Search$
         Dir.Copy.Target = Directory.Target$
         If Skip.Directory = 0 Then
            Call CopyDirectory(Source.Search$, Next.Dest.Net$)
         End If
      End If

      ' check directory exists
      If Directory.Exists = False Then

         ' search directory names
         Call Filenames(Directory.Target$, Next.Dest.Net$, Directory.Search$)

         ' check to recurse directories
         If Recurse.Directories Then

            ' recursive subdirectories
            Do
               ' check to quit
               If Quit.Searching Then
                  Exit Do
               End If

               ' check directory attribute
               Attribute = finddata.dwFileAttributes
               If (Attribute And &H10) = &H10 Then

                  ' store directory name
                  Next.Search$ = finddata.cFileName
                  Imbedded = InStr(Next.Search$, Chr$(0))
                  If Imbedded Then
                     Next.Search$ = Left$(Next.Search$, Imbedded - 1)
                  End If

                  ' check unicode
                  DirIsUnicode = 0
                  If InStr(Next.Search$, "?") Then
                     Next.Search$ = finddata.cAlternateFileName
                     Imbedded = InStr(Next.Search$, Chr$(0))
                     If Imbedded Then
                        Next.Search$ = Left$(Next.Search$, Imbedded - 1)
                     End If
                     Unicode$ = Directory.Search$ + Next.Search$
                     WideZ$ = AsciiToWide$(Unicode$) + Chr$(0)
                     Wfile.HandleW = FindFirstFileW(WideZ$, _Offset(finddataw))
                     If Wfile.HandleW <> INVALID_HANDLE_VALUE Then
                        DirIsUnicode = -1
                        DirUnicodeShort = WideZ$
                        DirUnicodeLong = finddataw.cFileName
                        x = FindClose(Wfile.HandleW)
                     End If
                  End If

                  ' check directory name
                  If Next.Search$ <> "." And Next.Search$ <> ".." Then
                     ' check recursion levels
                     Recursion = True
                     If Nested.Recurse > False Then
                        Nested.Levels = Nested.Levels + 1
                        If Nested.Levels >= Nested.Recurse Then
                           Recursion = False
                        End If
                     End If

                     ' recursively search subdirectories
                     If Recursion Then
                        Temp1$ = Directory.Search$ + Next.Search$ + "\"
                        Temp2$ = Directory.Target$ + Next.Search$ + "\"
                        Call Directories(Next.Dest.Net$, Temp1$, Temp2$)
                     End If
                     If Nested.Recurse > False Then
                        Nested.Levels = Nested.Levels - 1
                     End If
                  End If
               End If
            Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
         End If
      End If
      x = FindClose(Wfile.Handle)
   End If

   ' check to delete subdirectory
   If Recurse.Error = False Then
      If Delete.Directory Then
         Call DeleteSubdirectory(Directory.Search$)
      End If
   End If
End Sub

' routine to access filenames in directory
Sub Filenames (Source.Search$, Next.Dest.Net$, Directory.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim ASCIIZ.File As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' declare wide functions
   Dim finddataw As WIN32_FIND_DATAW ' the windows filename structure
   Dim Wfile.HandleW As _Unsigned _Offset ' windows file handle for FindFile

   ' make filename
   Temp.Net$ = RTrim$(Source.Net)
   Var$ = Filename.Search
   Var$ = RTrim$(Var$)
   If Temp.Net$ = Nul Then
      ASCIIZ.File = Directory.Search$ + Var$ + Chr$(0)
   Else
      If Left$(Directory.Search$, 1) = "\" Then
         ASCIIZ.File = Temp.Net$ + Directory.Search$ + Var$ + Chr$(0)
      Else
         ASCIIZ.File = Temp.Net$ + "\" + Directory.Search$ + Var$ + Chr$(0)
      End If
   End If

   ' find first long filename
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ.File), _Offset(finddata))
 
   ' check findirst error
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      Do
         ' store filename
         Filename$ = finddata.cFileName
         Imbedded = InStr(Filename$, Chr$(0))
         If Imbedded Then
            Filename$ = Left$(Filename$, Imbedded - 1)
         End If

         ' check unicode
         FileIsUnicode = 0
         If InStr(Filename$, "?") Then
            Filename$ = finddata.cAlternateFileName
            Imbedded = InStr(Filename$, Chr$(0))
            If Imbedded Then
               Filename$ = Left$(Filename$, Imbedded - 1)
            End If
            WideZ$ = AsciiToWide$(Filename$) + Chr$(0)
            Wfile.HandleW = FindFirstFileW(WideZ$, _Offset(finddataw))
            If Wfile.HandleW <> INVALID_HANDLE_VALUE Then
               FileIsUnicode = -1
               UnicodeShort = WideZ$
               UnicodeLong = finddataw.cFileName
               x = FindClose(Wfile.HandleW)
            End If
         End If

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then

            ' store file info
            File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

            ' store filename structure buffer
            finddatatemp = finddata

            ' store target directory
            Directory.Path = Source.Search$

            ' call subroutine to copy files
            Call CopyFiles(Next.Dest.Net$, Directory.Search$, Filename$)
         End If

         ' check to quit
         If Quit.Searching Then
            Exit Do
         End If

      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' make a wide ascii filename
Function AsciiToWide$ (Var$)
   Var2$ = Var$
   For X = 1 To Len(Var2$)
      VarX$ = VarX$ + Mid$(Var2$, X, 1) + Chr$(0)
   Next
   AsciiToWide$ = VarX$
End Function

' routine to open output file
Sub OpenFile (OpenError)
   Dim hfind As _Offset

   ' reset file open error flags
   Disk.Full = False
   OpenError = False

   ' declare filename to open
   Open.Filename$ = ASCIIZfile
   V = InStr(Open.Filename$, Chr$(0))
   If V Then
      Open.Filename$ = Left$(Open.Filename$, V - 1)
   End If
   If Len(Open.Filename$) = 0 Then
      If Debug.Mode Then
         Var$ = "Error" + Str$(DataError) + " opening output filename."
         Call DisplayError(Var$)
      End If
      OpenError = -1
      Exit Sub
   End If

   ' change filename attribute
   AttrX& = GetFileAttributes(ASCIIZfile)
   AttrX& = AttrX& And Not &H1 ' reset read-only bit
   x = SetFileAttributes&(ASCIIZfile, AttrX&)

   ' overwrite destination file
   If Append.Dest = 0 Then
      hfind = CreateFile(ASCIIZfile, &H180, &H3, 0, 3, 0, 0)
      If hfind <> INVALID_HANDLE_VALUE Then
         x = CloseHandle(hfind)

         ' delete destination filename
         x = DeleteFileA(ASCIIZfile)

         ' display any errors
         If x = 0 Then
            If Debug.Mode Then
               Var$ = "Error (0x" + Hex$(GetLastError&) + ") deleting output filename."
               Call DisplayError(Var$)
            End If
            OpenError = -1
            Exit Sub
         End If
      End If
   End If

   ' open destination file
   DataError = False
   Error.Flag = True
   Append.Handle = FreeFile
   Open Open.Filename$ For Binary As #Append.Handle
   Error.Flag = False

   ' check error flag
   If DataError Then
      If Debug.Mode Then
         Var$ = "Error" + Str$(DataError) + " opening output filename."
         Call DisplayError(Var$)
      End If
      OpenError = -1
      Exit Sub
   End If

   ' reset and store error flag
   DataError = False
   Error.Flag = True

   ' seek file position to eof
   SeekPosition2# = LOF(Append.Handle) + 1#
   Seek Append.Handle, SeekPosition2#

   ' reset and check error flag
   Error.Flag = False
   If DataError Then
      If Debug.Mode Then
         Var$ = "Error" + Str$(DataError) + " opening output filename."
         Call DisplayError(Var$)
      End If
      OpenError = -1
   End If
End Sub

' routine to close output file
Sub CloseFile (CloseType%)
   ' check file handle
   If Append.Handle = False Then
      Exit Sub
   End If

   ' close file
   Close #Append.Handle

   ' reset file handle
   Append.Handle = False

   ' write dest. filename attributes
   If CloseType% = 0 Then
      x = SetFileAttributes&(ASCIIZfile, File.Attribute)
   End If

   ' set filename date/time
   Call ExtendedFile(2)

   ' restore unicode long filename
   Call RenameUnicode
End Sub

Sub RenameUnicode
   ' check if file is unicode
   If FileIsUnicode Then
      UnicodeShort = AsciiToWide$(ASCIIZfile) + Chr$(0)

      ' parse unicode filename
      Var$ = ASCIIZfile
      If InStr(Var$, Chr$(0)) Then
         Var$ = Left$(Var$, InStr(Var$, Chr$(0)) - 1)
      End If
      Var = 0
      For X = Len(Var$) To 1 Step -1
         If Mid$(Var$, X, 1) = "\" Then
            Var$ = AsciiToWide$(Left$(Var$, X)) + UnicodeLong
            Var = -1
            Exit For
         End If
      Next
      If Var = 0 Then
         Var$ = UnicodeLong
      End If

      ' rename the filename
      r = MoveFileW(UnicodeShort, Var$ + Chr$(0))
      If r = 0 Then
         If Debug.ModeX Then
            Print "Unicode file rename error: "; Hex$(GetLastError)
         End If
      End If
   End If
End Sub

' routine overrides destination file date/time.
'   1 = get filename date/time
'   2 = set filename date/time
Sub ExtendedFile (T)
   Dim hfind As _Offset

   ' get source filename date/time.
   If T = 1 Then
      hfind = CreateFile(ASCIIZcopy, &H180, &H3, 0, 3, 0, 0)
      If hfind <> INVALID_HANDLE_VALUE Then
         x = GetFileTime&(hfind, SourceCreateDate, SourceAccessDate, SourceModifyDate)
         ' display any errors.
         If x = 0 Then
            If Debug.Mode Then
               Var$ = "Error (0x" + Hex$(GetLastError&) + ") reading filename date/time."
               Call DisplayError(Var$)
            End If
         End If
         x = CloseHandle(hfind)
      End If
      Exit Sub
   End If

   ' override filename date/time.
   If Override.Create.Date Or Override.Access.Date Or Override.Modify.Date Then
      ' store default date/time.
      CreateDate = SourceCreateDate
      AccessDate = SourceAccessDate
      ModifyDate = SourceModifyDate

      ' store override date/time.
      If Override.Date And Override.Time Then
         GoSub GetSysDate
         If Override.Create.Date Then
            x = SystemTimeToFileTime&(SysTime, CreateDate)
         End If
         If Override.Access.Date Then
            x = SystemTimeToFileTime&(SysTime, AccessDate)
         End If
         If Override.Modify.Date Then
            x = SystemTimeToFileTime&(SysTime, ModifyDate)
         End If
      End If

      ' set the destination filename date/time.
      hfind = CreateFile(ASCIIZfile, &H180, &H3, 0, 3, 0, 0)
      If hfind <> INVALID_HANDLE_VALUE Then
         x = SetFileTime&(hfind, CreateDate, AccessDate, ModifyDate)
         ' display any errors.
         If x = 0 Then
            If Debug.Mode Then
               Var$ = "Error (0x" + Hex$(GetLastError&) + ") touching filename date/time."
               Call DisplayError(Var$)
            End If
         End If
         x = CloseHandle(hfind)
      End If
   End If
   Exit Sub

   GetSysDate:
   ' store override variables
   SysTime.wMonth = Override.Date.Month
   SysTime.wDay = Override.Date.Day
   SysTime.wYear = Override.Date.Year
   SysTime.wHour = Override.Time.Hour
   SysTime.wMinute = Override.Time.Minute
   SysTime.wSecond = Override.Time.Second
   Return
End Sub

' routine to read file info
Sub ReadFileSynch
   ' declare subroutine variables
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZfile), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' store file size
      Dest.File.Size = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow

      ' store file date and time
      x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      GoSub Convert.Date
      Synch.File.Create.Date = Work.Date.Temp!

      x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
      GoSub Convert.Date
      Synch.File.Access.Date = Work.Date.Temp!

      x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
      GoSub Convert.Date
      Synch.File.Modify.Date = Work.Date.Temp!

      x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      GoSub Convert.Time
      Synch.File.Create.Time = Work.Time.Temp!

      x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
      GoSub Convert.Time
      Synch.File.Access.Time = Work.Time.Temp!

      x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
      GoSub Convert.Time
      Synch.File.Modify.Time = Work.Time.Temp!

      x = FindClose(Wfile.Handle)
   End If
   Exit Sub

   Convert.Date:
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   Work.Date.Temp! = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
   Return

   Convert.Time:
   HourTemp! = SysTime.wHour
   MinuteTemp! = SysTime.wMinute
   SecondsTemp! = SysTime.wSecond
   Work.Time.Temp! = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
   Return
End Sub

' routine to preprocess filenames in command line
Sub ProcessCommand (Quit)
   ' declare work variables
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim ASCIIZ2 As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset
   Dim hfind As _Offset

   ' reset quit flag
   Quit = False

   ' store current drive
   If Mid$(Command.Work, 2, 1) = ":" Then
      Drive.Search = Left$(UCase$(Command.Work), 1)
      Command.Work = Mid$(Command.Work, 3)
   Else
      Drive.Search = UCase$(Current.Drive)
   End If

   ' read current directory
   Temp.Search$ = ""
   Drive.Temp = Asc(Drive.Search) - 64
   If MEDIAEXISTS(Drive.Temp) Then
      If _DirExists(Drive.Search + ":") Then
         x = SetCurrentDirectoryA(Drive.Search + ":" + Chr$(0))
         Temp.Search$ = RTrim$(Mid$(_CWD$, 4)) ' C:\TEMP
      End If
   End If

   ' store source netpath
   Source.Net = Nul
   If Left$(_CWD$, 2) = "\\" Then
      Source.Net = _CWD$
   End If

   ' store current directory
   Directory.Search$ = Nul
   If Len(Command.Work) Then
      Imbedded = InStr(Command.Work, "\")
      Imbedded.Char = Imbedded
      While Imbedded
         Imbedded.Char = Imbedded
         Imbedded = InStr(Imbedded + 1, Command.Work, "\")
      Wend
      If Imbedded.Char Then
         Directory.Search$ = Left$(Command.Work, Imbedded.Char)
         Command.Work = Mid$(Command.Work, Imbedded.Char + 1)
      Else
         If RTrim$(Source.Net) <> Nul Then
            Directory.Search$ = "\"
         End If
      End If
   End If
   If Directory.Search$ = Nul Then
      If Temp.Search$ = "\" Then
         Directory.Search$ = "\"
      Else
         Directory.Search$ = "\" + Temp.Search$
      End If
   End If
   If Right$(Directory.Search$, 1) <> "\" Then
      Directory.Search$ = Directory.Search$ + "\"
   End If
   Directory.Search$ = RTrim$(Directory.Search$)

   ' read filename spec
   Filename.Search = Command.Work
   If RTrim$(Filename.Search) = Nul Then
      Filename.Search = "*.*"
   End If
   Command.Work = Nul
   
   ' check search filename
   Target.Dir$ = Nul
   Imbedded1 = InStr(Filename.Search, "?")
   Imbedded2 = InStr(Filename.Search, "*")
   If Imbedded1 = False And Imbedded2 = False Then
      ' check search directory
      ASCIIZ = Directory.Search$ + RTrim$(Filename.Search) + Chr$(0)

      ' find first directory
      Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
      If Wfile.Handle <> INVALID_HANDLE_VALUE Then

         ' check source is directory or filename
         Attribute = finddata.dwFileAttributes
         If (Attribute And &H10) = &H10 Then
            Directory.Search$ = Directory.Search$ + RTrim$(Filename.Search) + "\"
            Target.Dir$ = RTrim$(Filename.Search)
            Filename.Search = "*.*"
         End If
         x = FindClose(Wfile.Handle)
      End If
   End If

   ' display search filename
   If Continuous.Display = False Then
      Color Yellow, Black
      If RTrim$(Source.Net) = Nul Then
         Print "Searching: " + Drive.Search + ":" + Directory.Search$ + RTrim$(Filename.Search)
      Else
         If Left$(Directory.Search$, 1) = "\" Then
            Print "Searching: " + RTrim$(Source.Net) + Directory.Search$ + RTrim$(Filename.Search)
         Else
            Print "Searching: " + RTrim$(Source.Net) + "\" + Directory.Search$ + RTrim$(Filename.Search)
         End If
      End If
   End If

   ' process destination netpaths
   For Count0 = 1 To Number.Dest.Nets

      ' store netpath
      Next.Dest.Net$ = Destinate.Netpaths(Count0)
      Next.Dest.Net$ = RTrim$(Next.Dest.Net$)

      ' process destination directories
      For Count1 = 1 To Number.Dest.Dirs
         ' store directory
         Next.Dest.Dir$ = Destinate.Directory(Count1)
         Next.Dest.Dir$ = RTrim$(Next.Dest.Dir$)

         ' check destination drive
         If Mid$(Next.Dest.Dir$, 2, 1) = ":" Then
            Drive.Number = Asc(UCase$(Mid$(Next.Dest.Dir$, 1, 1)))
            Next.Dest.Dir$ = Mid$(Next.Dest.Dir$, 3)
         Else
            Drive.Number = Asc(UCase$(Current.Drive))
         End If

         ' store destination directory
         MediaError = 0
         If Next.Dest.Net$ = Nul Then
            GoSub Store.Dest.Dir
         End If

         ' recheck destination directory
         If Left$(Next.Dest.Dir$, 1) <> "\" Then
            Next.Dest.Dir$ = Default.Dest + Next.Dest.Dir$
         End If
         If Right$(Next.Dest.Dir$, 1) <> "\" Then
            Next.Dest.Dir$ = Next.Dest.Dir$ + "\"
         End If

         ' store destination drive/netpath
         If Next.Dest.Net$ = Nul Then
            If Left$(Next.Dest.Dir$, 2) <> "\\" Then
               Next.Dest.Dir$ = Chr$(Drive.Number) + ":" + Next.Dest.Dir$
            End If
         End If

         ' process destination filenames
         For Count2 = 1 To Number.Dest.Files

            ' store filename
            Dest.File = Destinate.Filename(Count2)
            Dest.File = RTrim$(Dest.File)

            ' check filelist filename
            If Left$(Dest.File, 1) = "@" And Enable.Redirect Then
               Dest.Out$ = Mid$(Dest.File$, 2)

               ' open filename list
               x = 0
               ASCIIZ2 = Dest.Out$ + Chr$(0)
               hfind = CreateFile(ASCIIZ2, &H180, &H3, 0, 3, 0, 0)
               If hfind <> INVALID_HANDLE_VALUE Then
                  x = CloseHandle(hfind)
               End If
               If x = 0 Then
                  ' display filename error
                  Call DisplayError("Error" + Str$(GetLastError&) + " opening listfile.")
               Else

                  V = FreeFile
                  DataError = False
                  Error.Flag = True
                  Open Dest.Out$ For Input Shared As #V
                  Error.Flag = False

                  ' check error flag
                  If DataError Then
                     Call DisplayError("Error" + Str$(DataError) + " opening filelist.")
                  Else
                     ' process input filenames
                     Do Until EOF(V)
                        Line Input #V, Next.Filename$
                        Next.Filename$ = RTrim$(Next.Filename$)
                        If Len(Next.Filename$) Then
                           ' process search filename
                           Dest.File$ = Next.Filename$
                           GoSub ProcessDestinate
                        End If
                        ' check to quit
                        If Quit.Searching Then
                           Exit Do
                        End If
                     Loop
                     Close #V
                  End If
               End If
            Else
               GoSub ProcessDestinate
            End If

            ' check quit flag
            If Quit.Searching Then
               Quit = True
               Exit For
            End If
         Next

         ' check quit flag
         If Quit.Searching Then
            Exit For
         End If
      Next

      ' check netpaths
      If Next.Dest.Net$ = Nul Then
         Exit For
      End If
   Next
   Exit Sub

   ProcessDestinate:
   ' check destination drive exists.
   If MediaError Then
      Return
   End If

   ' reset work variable
   Append.Files = False

   ' check destination filename
   Dest.Dir = Next.Dest.Dir$
   If Dest.File <> Nul Then
      Dest.Dir = Dest.Dir + Dest.File
      Append.Files = True
   End If

   ' store target directory for directory structure copy
   Directory.Target$ = Dest.Dir
   If Zero.Nest = False Then
      If Len(Target.Dir$) Then
         Directory.Target$ = Directory.Target$ + Target.Dir$ + "\"
      End If
   End If

   ' construct target directory
   If Copy.Directory Then
      Directory.Path = Directory.Target$
      Call CreateDirectory(Next.Dest.Net$)
   End If

   ' reset recurse flag
   Recurse.Error = False

   ' recursively copy files
   Call Directories(Next.Dest.Net$, Directory.Search$, Directory.Target$)

   ' close output file
   If Append.Files Then
      Call CloseFile(-1)
   End If
   Return

   ' get default directory of target drive
   Store.Dest.Dir:
   Default.Dest = ""
   If Left$(_CWD$, 2) = "\\" Then
      Default.Dest = _CWD$
      If Right$(Default.Dest, 1) <> "\" Then
         Default.Dest = Default.Dest + "\"
      End If
      Return
   End If
   If MEDIAEXISTS(Drive.Number - 64) = 0 Then
      If Debug.Mode Then
         Call DisplayError("Error accessing target drive.")
      End If
      MediaError = -1
      Return
   End If
   If _DirExists(Chr$(Drive.Number) + ":") = 0 Then
      If Debug.Mode Then
         Call DisplayError("Error accessing target directory.")
      End If
      MediaError = -1
      Return
   End If

   ' store directory
   x = SetCurrentDirectoryA(Chr$(Drive.Number) + ":" + Chr$(0))
   Default.Dest = RTrim$(Mid$(_CWD$, 4)) ' C:\TEMP

   ' restore directory
   Drive.Temp = Asc(Drive.Search) - 64
   If MEDIAEXISTS(Drive.Temp) Then
      x = SetCurrentDirectoryA(Drive.Search + ":" + Chr$(0))
   End If

   ' parse directory
   If Default.Dest = Nul Then
      Default.Dest = "\"
   End If
   If Default.Dest <> "\" Then
      Default.Dest = "\" + Default.Dest
   End If
   If Right$(Default.Dest, 1) <> "\" Then
      Default.Dest = Default.Dest + "\"
   End If
   Return
End Sub

' test volume media inserted.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If

   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = Nul
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = False
   Else
      DRIVEEXISTS = True
   End If
End Function

' routine to see if destination file exists
Sub CheckFileExists (Dest.Net$, Destination.File$, Response)
   ' declare subroutine variables
   Dim PromptASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' reset continue searching flag
   Response = True

   ' make filename
   If Dest.Net$ = Nul Then
      PromptASCIIZ = Destination.File$ + Chr$(0)
   Else
      If Left$(Destination.File$, 1) = "\" Then
         PromptASCIIZ = Dest.Net$ + Destination.File$ + Chr$(0)
      Else
         PromptASCIIZ = Dest.Net$ + "\" + Destination.File$ + Chr$(0)
      End If
   End If

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(PromptASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      Response = False
      x = FindClose(Wfile.Handle)
   End If
End Sub

' routine to prompt before overwriting files
Sub PromptOverwrite (Dest.Net$, Source.File$, Destination.File$, Response)
   ' declare subroutine variables
   Dim PromptASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' reset continue searching flag
   Response = True

   ' make filename
   If Dest.Net$ = Nul Then
      PromptASCIIZ = Destination.File$ + Chr$(0)
   Else
      If Left$(Destination.File$, 1) = "\" Then
         PromptASCIIZ = Dest.Net$ + Destination.File$ + Chr$(0)
      Else
         PromptASCIIZ = Dest.Net$ + "\" + Destination.File$ + Chr$(0)
      End If
   End If

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(PromptASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' make drive
      Start.Dir = Dest.Dir
      If Mid$(Start.Dir, 2, 1) = ":" Then
         Drive.Number = Asc(UCase$(Left$(Start.Dir, 1)))
         Start.Dir = Mid$(Start.Dir, 3)
      Else
         Drive.Number = Asc(UCase$(Drive.Search))
      End If

      ' make filename
      To.File$ = Destination.File$
      If Mid$(To.File$, 2, 1) = ":" Then
         To.File$ = Mid$(To.File$, 3)
      End If

      ' make filename
      From.File$ = Source.File$
      If Mid$(From.File$, 2, 1) = ":" Then
         From.File$ = Mid$(From.File$, 3)
      End If

      ' check overwrite flag
      If Dont.Overwrite Then
         ' display file
         Response = False

         ' check display flags
         If Short.Display Or Short.Display4 Then
            Eat$ = Nul
         Else
            ' make filename
            Outpt$ = RTrim$(From.File$)
            Temp.Net$ = RTrim$(Source.Net)
            If Temp.Net$ = Nul Then
               Outpt$ = Chr$(Drive.Number) + ":" + Outpt$
            Else
               If Left$(Outpt$, 1) = "\" Then
                  Outpt$ = Temp.Net$ + Outpt$
               Else
                  Outpt$ = Temp.Net$ + "\" + Outpt$
               End If
            End If

            If Display.Lowercase Then
               Outpt$ = LCase$(Outpt$)
            End If

            ' check continuous display
            If Continuous.Display = False Then
               Outpt$ = "Not copying file " + Outpt$
            End If

            ' display filename
            If Wide.List Then
               Wide.List = False
               Print
            End If
            Color White, Black
            Print Outpt$
         End If
      Else
         ' check continuous copying
         If Continue.Searching = False Then
            ' check to skip all copied files
            If Skip.All Then
               Response = False
            Else

               ' make filename
               Prompt$ = RTrim$(To.File$)
               If Dest.Net$ = Nul Then
                  Prompt$ = Chr$(Drive.Number) + ":" + Prompt$
               Else
                  If Left$(Prompt$, 1) = "\" Then
                     Prompt$ = Dest.Net$ + Prompt$
                  Else
                     Prompt$ = Dest.Net$ + "\" + Prompt$
                  End If
               End If
               If Display.Lowercase Then
                  Prompt$ = LCase$(Prompt$)
               End If

               ' make prompt
               If Short.Display4 Then
                  Response = True
               Else
                  If Continuous.Display3 Then
                     Response = True
                  Else
                     If Short.Display3 Then
                        Prompt$ = "File exists. "
                     Else
                        Prompt$ = "File " + Prompt$ + " exists."
                        Print Prompt$
                        Prompt$ = Nul
                     End If
                     If Append.Dest Then
                        If Resume.File Then
                           Prompt$ = Prompt$ + "Resume"
                        Else
                           Prompt$ = Prompt$ + "Append"
                        End If
                     Else
                        Prompt$ = Prompt$ + "Overwrite"
                     End If
                     Prompt$ = Prompt$ + "(y)es,(n)o,(c)opy all,(s)kip all,(q)uit?"
                     Call MorePrompt(Prompt$, "ynqsc", Outpt$, "y")
                     Select Case Outpt$
                        Case "c"
                           Response = True
                           Continue.Searching = True
                        Case "q"
                           Response = False
                           Quit.Searching = True
                        Case "s"
                           Skip.All = True
                           Response = False
                        Case "y"
                           Response = True
                        Case "n"
                           Response = False
                     End Select
                  End If
               End If
            End If
         End If
      End If
      x = FindClose(Wfile.Handle)
   End If
End Sub

' routine to create directory,
'   and copy directory attributes.
Sub CopyDirectory (Source.Path$, Target.Net$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260

   ' check for copying directory onto itself
   Call DirectoryCopying(Target.Net$)

   ' process directory copying
   If Directory.Exists Then
      Recurse.Error = True
      If Display.Errors = False Then
         If Directory.Exists = -1 Then
            Call DisplayError("Recursive directory error.")
         Else
            If Directory.Exists = -2 Then
               Call DisplayError("Self-Recursive directory error.")
            End If
         End If
      End If
      Exit Sub
   End If

   ' make directory
   Filename$ = RTrim$(Dir.Copy.Target)
   Filename$ = Left$(Filename$, Len(Filename$) - 1)

   ' check directory name
   If Filename$ <> "." And Filename$ <> ".." Then

      ' create directory
      Directory.Path = Filename$
      Call CreateDirectory(Target.Net$)

      ' increment directory counter
      Dirs.Counted = Dirs.Counted + 1!

      ' display directory created
      If Debug.ModeX Then
         Print "Verified: " + Filename$
      End If
      Exit Sub

      ' make directory name
      Directory$ = RTrim$(Dir.Copy.Name)
      Directory$ = Left$(Directory$, Len(Directory$) - 1)

      ' make source directory name
      If Source.Path$ = Nul Then
         ASCIIZ = Directory$ + Chr$(0)
      Else
         ASCIIZ = Source.Path$ + Chr$(0)
      End If

      ' store source directory attribute
      Dir.Attribute = GetFileAttributes(ASCIIZ)

      ' make target directory name
      If Target.Net$ = Nul Then
         ASCIIZ = Filename$ + Chr$(0)
      Else
         If Left$(Filename$, 1) = "\" Then
            If Right$(Target.Net$, 1) = "\" Then
               ASCIIZ = Target.Net$ + Mid$(Filename$, 2) + Chr$(0)
            Else
               ASCIIZ = Target.Net$ + Filename$ + Chr$(0)
            End If
         Else
            If Right$(Target.Net$, 1) = "\" Then
               ASCIIZ = Target.Net$ + Filename$ + Chr$(0)
            Else
               ASCIIZ = Target.Net$ + "\" + Filename$ + Chr$(0)
            End If
         End If
      End If

      ' copy directory attribute
      x = SetFileAttributes&(ASCIIZ, Dir.Attribute)
   End If
End Sub

' routine to create directory structure
Sub CreateDirectory (Next.Dest.Net$)
   ' construct path
   Directory$ = RTrim$(Directory.Path$)
   If Next.Dest.Net$ = Nul Then
      If Mid$(Directory$, 2, 1) = ":" Then
         Drive.Create$ = Left$(Directory$, 1)
         Directory$ = Mid$(Directory$, 3)
      Else
         Drive.Create$ = Current.Drive
      End If
   End If
   If Right$(Directory$, 1) <> "\" Then
      Directory$ = Directory$ + "\"
   End If

   ' create path
   Next.Dir = InStr(Directory$, "\")
   Do
      If Next.Dir = False Then
         Exit Do
      End If

      Filename$ = Left$(Directory$, Next.Dir - 1) ' \temp\t1\t\
      Next.Dir = InStr(Next.Dir + 1, Directory$, "\")

      ' make directory name
      If Len(Filename$) Then
         If Len(Next.Dest.Net$) Then
            Filename$ = Next.Dest.Net$ + "\" + Filename$
         Else
            Filename$ = Drive.Create$ + ":" + Filename$
         End If

         ' check directory
         If _DirExists(Filename$) = 0 Then
            ' create directory
            f$ = Filename$ + Chr$(0)
            x = CreateDirectoryA(f$, 0) ' critical error solved!

            ' increment directory counter
            If x Then
               Dirs.Created = Dirs.Created + 1!
               If Debug.ModeX Then
                  Print "Created: "; Filename$
               End If
            End If

            ' display any error
            If x = 0 Then
               If Debug.ModeX Then
                  If GetLastError& = &HB7 Then ' ignore already exists
                     ' nul
                  Else
                     Var$ = "Error (0x" + Hex$(GetLastError&) + ") creating directory."
                     Call DisplayError(Var$)
                  End If
               End If
            End If
         End If
      End If
   Loop

   ' check if file is unicode
   If DirIsUnicode Then
      If Len(Next.Dest.Net$) Then
         Filename$ = Next.Dest.Net$ + "\" + Directory$
      Else
         Filename$ = Drive.Create$ + ":" + Directory$
      End If
      DirUnicodeShort = AsciiToWide$(Filename$) + Chr$(0)

      ' parse unicode filename
      Var$ = Filename$
      If Right$(Var$, 1) = "\" Then
         Var$ = Left$(Var$, Len(Var$) - 1)
      End If
      Var = 0
      For x = Len(Var$) To 1 Step -1
         If Mid$(Var$, x, 1) = "\" Then
            Var$ = AsciiToWide$(Left$(Var$, x)) + DirUnicodeLong
            Var = -1
            Exit For
         End If
      Next
      If Var = 0 Then
         Var$ = DirUnicodeLong
      End If

      ' rename the filename
      r = MoveFileW(DirUnicodeShort, Var$ + Chr$(0))
      If r = 0 Then
         If Debug.ModeX Then
            Print "Unicode directory rename error: "; Hex$(GetLastError)
         End If
      End If
   End If
End Sub

' subroutine to delete destination filename
Sub DeleteDestFile (Delete.Prompt, Work.Net$, Filename$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260

   ' close output file
   If Append.Files Then
      Call CloseFile(-1)
   End If

   ' make drive
   Start.Dir = Dest.Dir
   If Mid$(Start.Dir, 2, 1) = ":" Then
      Drive.Number = Asc(UCase$(Left$(Start.Dir, 1)))
      Start.Dir = Mid$(Start.Dir, 3)
   Else
      Drive.Number = Asc(UCase$(Drive.Search))
   End If
 
   ' display file being deleted
   If Dest.File = Nul Then
      If Work.Net$ = Nul Then
         Source.File$ = Chr$(Drive.Number) + ":" + Start.Dir + Filename$
      Else
         Source.File$ = Work.Net$ + "\" + Start.Dir + Filename$
      End If
   Else
      If Work.Net$ = Nul Then
         Source.File$ = Chr$(Drive.Number) + ":" + Start.Dir
      Else
         Source.File$ = Work.Net$ + "\" + Start.Dir
      End If
   End If

   ' check prompt to delete
   If Delete.Prompt Then
      Prompt$ = Nul
      If Display.Errors Then
         Prompt$ = "Error copying file. "
      End If
      Prompt$ = Prompt$ + "Delete partially copied destination file: " + Source.File$ + "(y)es,(n)o,(q)uit?"
      Call MorePrompt(Prompt$, "ynq", Respond$, "y")
      Select Case Respond$
         Case "n"
            Exit Sub
         Case "q"
            Quit.Searching = True
            Exit Sub
      End Select
   End If

   ' check to display file
   Deleted.Files = Deleted.Files + 1
   If Continuous.Display = False Then
      If Wide.List Then
         Wide.List = False
         Print
      End If
      Color White, Black
      Print "Deleting file: " + Source.File$
   End If

   ' delete filename
   ASCIIZ = Source.File$ + Chr$(0)

   ' change filename attribute
   AttrX& = GetFileAttributes(ASCIIZ)
   AttrX& = AttrX& And Not &H1 ' remove read-only bit
   x = SetFileAttributes&(ASCIIZ, AttrX&)

   ' delete long filename
   x = DeleteFileA(ASCIIZ)

   ' check delete error
   If x = 0 Then
      If Debug.Mode Then
         Var$ = "Error (0x" + Hex$(GetLastError&) + ") deleting file."
         Call DisplayError(Var$)
      End If
   End If
End Sub

' subroutine to delete source filename
Sub DeleteSourceFile (Directory$, Filename$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260

   ' make filename
   Source.File$ = Directory$ + Filename$

   ' make directory name
   Temp.Dir$ = Directory$
   Call MakeFile(Nul, Source.File$, Temp.Dir$)

   ' reset delete flag
   Response = False

   ' check continue flag
   If Continue.Deleting Then
      Response = True
   End If

   ' check delete prompting
   If Prompt.Delete1 Then
      Response = True
   End If

   ' prompt to delete
   If Response = False Then
      Outpt$ = Source.File$
      If Display.Lowercase Then
         Outpt$ = LCase$(Outpt$)
      End If
      Prompt$ = "Delete copied source file: " + Outpt$ + "(y)es,(n)o,(d)elete all,(q)uit?"
      Call MorePrompt(Prompt$, "ynqd", Respond$, "y")
      Select Case Respond$
         Case "d"
            Response = True
            Continue.Deleting = True
         Case "q"
            Response = False
            Quit.Searching = True
         Case "y"
            Response = True
         Case "n"
            Response = False
      End Select
   End If

   ' check delete flag
   If Response = True Then
      Deleted.Files = Deleted.Files + 1
      ' display file being deleted
      If Continuous.Display = False Then
         If Wide.List Then
            Wide.List = False
            Print
         End If
         Color White, Black
         Prompt$ = "Deleting file: " + Outpt$
         Print Prompt$
      End If

      ' delete filename
      ASCIIZ = Source.File$ + Chr$(0)

      ' change filename attribute
      AttrX& = GetFileAttributes(ASCIIZ)
      AttrX& = AttrX& And Not &H1 ' reset read-only bit
      x = SetFileAttributes&(ASCIIZ, AttrX&)

      ' delete long filename
      x = DeleteFileA(ASCIIZ)

      ' check error and delete 8.3 filename
      If x = 0 Then
         Short.Filename$ = finddatatemp.cAlternateFileName
         V = InStr(Short.Filename$, Chr$(0))
         If V Then Short.Filename$ = Left$(Short.Filename$, V - 1)
         ASCIIZ = Directory$ + Short.Filename$ + Chr$(0)

         ' change filename attribute
         AttrX& = GetFileAttributes(ASCIIZ)
         AttrX& = AttrX& And Not &H1
         x = SetFileAttributes&(ASCIIZ, AttrX&)

         ' delete short filename
         x = DeleteFileA(ASCIIZ)
      End If

      ' check delete error
      If x = 0 Then
         If Debug.Mode Then
            Var$ = "Error (0x" + Hex$(GetLastError&) + ") deleting file."
            Call DisplayError(Var$)
         End If
      End If
   End If
End Sub

' subroutine to delete subdirectory
Sub DeleteSubdirectory (Source.Directory$)
   ' declare work variables
   Dim DeleteASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make directory name
   Directory$ = Source.Directory$
   Temp.Dir$ = Directory$
   Call MakeFile(Nul, Directory$, Temp.Dir$)

   ' find first directory
   If Right$(Source.Directory$, 1) = "\" Then
      DeleteASCIIZ = Left$(Source.Directory$, Len(Source.Directory$) - 1) + Chr$(0)
   Else
      DeleteASCIIZ = Source.Directory$ + Chr$(0)
   End If
   Wfile.Handle = FindFirstFileA(_Offset(DeleteASCIIZ), _Offset(finddata))
   If Wfile.Handle = 0 Then
      Exit Sub
   End If
   x = FindClose(Wfile.Handle)

   ' reset delete flag
   Response = False

   ' check to continue
   If Continue.Subdelete Then
      Response = True
   End If

   ' check for prompting
   If Prompt.Delete2 Then
      Response = True
   End If

   ' make directory name
   Outpt$ = Directory$
   If Display.Lowercase Then
      Outpt$ = LCase$(Outpt$)
   End If

   ' check delete flag
   If Response = False Then
      ' prompt to delete
      Prompt$ = "Delete copied source directory: " + Outpt$ + "(y)es,(n)o,(d)elete all,(q)uit?"
      Call MorePrompt(Prompt$, "ynqd", Respond$, "y")
      Select Case Respond$
         Case "d"
            Response = True
            Continue.Subdelete = True
         Case "q"
            Response = False
            Quit.Searching = True
         Case "y"
            Response = True
         Case "n"
            Response = False
      End Select
   End If

   ' check delete flag
   If Response Then
      Deleted.Dirs = Deleted.Dirs + 1
      If Continuous.Display = False Then
         If Wide.List Then
            Wide.List = False
            Print
         End If
         Color White, Black
         Print "Deleting directory: " + Outpt$
      End If
      Call TreeDirectories(Directory$)
   End If
End Sub

' subroutine to delete subdirectories
Sub TreeDirectories (Directory.Search$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim Attribute As _Unsigned Long
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make directory filename
   ASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' delete filenames
      Call DeleteFiles(Directory.Search$)

      ' recurse subdirectories
      Do
         ' check directory attribute
         Attribute = finddata.dwFileAttributes

         ' check for directory
         If (Attribute And &H10) = &H10 Then

            ' store directory name
            Directory$ = finddata.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

            ' check for unicode
            If InStr(Directory$, "?") Then
               Directory$ = finddata.cAlternateFileName
               V = InStr(Directory$, Chr$(0))
               If V Then Directory$ = Left$(Directory$, V - 1)
            End If

            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then
               ' make next search directory
               Next.Directory$ = Directory.Search$ + Directory$ + "\"

               ' recursively search subdirectories
               Call TreeDirectories(Next.Directory$)
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If

   ' delete directory
   Call DeleteDirectory(Directory.Search$)
End Sub

' subroutine to delete files in a directory
Sub DeleteFiles (Directory$)
   ' declare subroutine variables
   '  local only to this subroutine for recursion.
   Dim ASCIIZ As String * 260
   Dim ASCIIZ2 As String * 260
   Dim finddata As WIN32_FIND_DATAA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make filename
   ASCIIZ = Directory$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then
      ' search filenames
      Do
         ' store filename
         Filename$ = finddata.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then
            ' delete file
            ASCIIZ2 = Directory$ + Filename$ + Chr$(0)

            ' change filename attribute
            AttrX& = GetFileAttributes(ASCIIZ2)
            AttrX& = AttrX& And Not &H1 ' reset read-only bit
            x = SetFileAttributes&(ASCIIZ2, AttrX&)

            ' delete long filename
            x = DeleteFileA(ASCIIZ2)

            ' check error and delete 8.3 filename
            If x = 0 Then
               Short.Filename$ = finddata.cAlternateFileName
               V = InStr(Short.Filename$, Chr$(0))
               If V Then Short.Filename$ = Left$(Short.Filename$, V - 1)
               ASCIIZ2 = Directory$ + Short.Filename$ + Chr$(0)

               ' change filename attribute
               AttrX& = GetFileAttributes(ASCIIZ2)
               AttrX& = AttrX& And Not &H1
               x = SetFileAttributes&(ASCIIZ2, AttrX&)

               ' delete short filename
               x = DeleteFileA(ASCIIZ2)
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata))
      x = FindClose(Wfile.Handle)
   End If
End Sub

' subroutine to delete an empty directory
Sub DeleteDirectory (Directory$)
   ' declare subroutine variables
   Dim ASCIIZ As String * 260

   ' make filename
   Temp.Dir$ = Directory$
   If Right$(Temp.Dir$, 1) = "\" Then
      Temp.Dir$ = Left$(Temp.Dir$, Len(Temp.Dir$) - 1)
   End If
   ASCIIZ = Temp.Dir$ + Chr$(0)

   ' change directory attribute
   AttrX& = GetFileAttributes(ASCIIZ)
   AttrX& = AttrX& And Not &H1 ' remove read-only bit
   x = SetFileAttributes&(ASCIIZ, AttrX&)

   ' remove an empty directory
   x = RemoveDirectoryA(ASCIIZ)

   ' check delete error flag
   If x = 0 Then
      If Debug.Mode Then
         Var$ = "Error (0x" + Hex$(GetLastError&) + ") deleting directory."
         Call DisplayError(Var$)
      End If
   End If

   ' check delete error flag
   If x Then
      Total.Deleted = Total.Deleted + 1
   End If
End Sub

' verifies duplicate filenames,
'   displays filenames being copied.
Sub FilenameCopying (Copy.Net$, From$, To$)
   ' reset flag
   Filename.Exists = False

   ' make filenames
   From.File$ = From$
   To.File$ = To$
   Call MakeFile(Copy.Net$, From.File$, To.File$)

   ' check filename length
   If Len(To.File$) > 259 Then
      Filename.Exists = True
      Exit Sub
   End If

   ' check to run DOS commands
   For Count = 1 To Number.Commands
      Next.Command$ = RTrim$(DOS.Command(Count))
      If Len(Next.Command$) Then
         Call ExecuteCommand(Next.Command$, From.File$)
      End If
   Next

   ' store filenames
   From.Filename$ = From.File$
   To.Filename$ = To.File$

   ' display filename
   GoSub Display.File

   ' make source netpath
   If Copy.Net$ <> Nul Then
      From.Filename$ = From$
      Call MakeFile2(From.Filename$)
   End If

   ' compare filenames
   If LCase$(From.Filename$) = LCase$(To.Filename$) Then
      Filename.Exists = True
      If Continuous.Display = False Then
         If Wide.List Then
            Wide.List = False
            Print
         End If
         Color White, Black
         Print "File in list cannot be copied onto itself."
      End If
   End If
   Exit Sub

   ' display filename being copied
   Display.File:

   ' display file being copied in title
   Var1$ = AmbiguateFile$(From.File$)
   Var2$ = AmbiguateFile$(To.File$)
   Title.Header = "COPYIT - " + Var1$ + " -> " + Var2$
   _Title Title.Header

   ' ambiguate filenames
   If Display.Wide Or Ambiguate.Display Then
      From.File$ = Ambiguate1$(From.File$)
      To.File$ = Ambiguate1$(To.File$)
   End If

   ' convert to lowercase
   If Display.Lowercase Then
      From.File$ = LCase$(From.File$)
      To.File$ = LCase$(To.File$)
   End If

   ' truncate pathname
   If Display.Path Or Display.Wide Then
      For Imbedded = Len(From.File$) To 1 Step -1
         If Mid$(From.File$, Imbedded, 1) = "\" Then
            From.File$ = Left$(From.File$, 2) + Mid$(From.File$, Imbedded + 1)
            Exit For
         End If
      Next
      For Imbedded = Len(To.File$) To 1 Step -1
         If Mid$(To.File$, Imbedded, 1) = "\" Then
            To.File$ = Left$(To.File$, 2) + Mid$(To.File$, Imbedded + 1)
            Exit For
         End If
      Next
   End If

   ' truncate drive letter
   If Drive.Letter Then
      If Mid$(From.File$, 2, 1) = ":" Then
         From.File$ = Mid$(From.File$, 3)
      End If
      If Mid$(To.File$, 2, 1) = ":" Then
         To.File$ = Mid$(To.File$, 3)
      End If
   End If

   ' store filename
   Color Yellow, Black
   Outpt$ = RTrim$(From.File$)

   ' truncate drive letter
   If Copy.Net$ <> Nul Then
      If Mid$(Outpt$, 2, 1) = ":" Then
         Outpt$ = Mid$(Outpt$, 3)
      End If
   End If

   ' display filename in wide list format
   If Display.Wide Then
      If Short.Display4 = 0 Then
         ' check filename
         If Len(Outpt$) > 14 Then
            Outpt$ = Left$(Outpt$, 13) + "~"
         End If

         ' display filename in wide format
         If Left$(Outpt$, 2) = "\\" Then
            Outpt$ = Mid$(Outpt$, 3)
         End If
         Print Outpt$ + Space$(15 - Len(Outpt$));

         ' count wide display filenames
         Wide.List = Wide.List + 1
         If Wide.List = 5 Then
            Wide.List = False
            Print
         End If
      End If
      Return
   End If

   ' prepend copying type
   If Short.Display2 = False Then
      If Append.Dest Then
         If Resume.File Then
            Outpt$ = "Resuming: " + Outpt$
         Else
            Outpt$ = "Appending: " + Outpt$
         End If
      Else
         Outpt$ = "Copying: " + Outpt$
      End If
   End If

   ' display only source filename
   If Short.Display4 = 0 Then
      If Short.Display Then
         Print Outpt$
      Else
         ' display source/destination filenames
         Outpt$ = Outpt$ + " - " + To.File$
         Print Outpt$
      End If
   End If
   Return
End Sub

' ambiguate filename
Function Ambiguate1$ (Var$)
   ' declare subroutine variables
   Dim ASCIIZ1 As String * 260
   Dim ASCIIZ2 As String * 260
   VarX$ = Var$

   ' read 8.3 filename
   ASCIIZ1 = VarX$ + Chr$(0)
   ret = GetShortPathName(ASCIIZ1, ASCIIZ2, MAX_PATH)

   ' check function error
   If ret > 0 Then
      ' store 8.3 filename
      VarX$ = ASCIIZ2
      Imbedded = InStr(VarX$, Chr$(0))
      If Imbedded Then
         VarX$ = Left$(VarX$, Imbedded - 1)
      End If
   End If
   Ambiguate1$ = VarX$
End Function

' ambiguate filename
Function AmbiguateFile$ (Var$)
   ' declare subroutine variables
   Dim ASCIIZ1 As String * 260
   Dim ASCIIZ2 As String * 260
   VarX$ = Var$

   ' read 8.3 filename
   ASCIIZ1 = VarX$ + Chr$(0)
   ret = GetShortPathName(ASCIIZ1, ASCIIZ2, MAX_PATH)

   ' check function error
   If ret > 0 Then
      ' store 8.3 filename
      VarX$ = ASCIIZ2
      Imbedded = InStr(VarX$, Chr$(0))
      If Imbedded Then
         VarX$ = Left$(VarX$, Imbedded - 1)
      End If
   End If

   ' strip path
   For Imbedded = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, Imbedded, 1) = "\" Then
         VarX$ = Mid$(VarX$, Imbedded + 1)
         Exit For
      End If
   Next

   ' strip drive
   If Mid$(VarX$, 2, 1) = ":" Then
      VarX$ = Mid$(VarX$, 3)
   End If
   AmbiguateFile$ = VarX$
End Function

' subroutine to execute DOS command
Sub ExecuteCommand (Next.Command$, DOS.Filename$)
   ' make replacement parameters
   DOS.Pathname$ = DOS.Filename$
   Imbedded1 = InStr(DOS.Pathname$, "\")
   Imbedded2 = False
   While Imbedded1
      Imbedded2 = Imbedded1
      Imbedded1 = InStr(Imbedded1 + 1, DOS.Pathname$, "\")
   Wend
   Filename$ = Mid$(DOS.Pathname$, Imbedded2 + 1)
   If Imbedded2 Then
      DOS.Pathname$ = Left$(DOS.Pathname$, Imbedded2 - 1)
   Else
      DOS.Pathname$ = Nul
   End If
   Extension$ = Nul
   Imbedded = InStr(Filename$, ".")
   If Imbedded Then
      Extension$ = Mid$(Filename$, Imbedded + 1)
      Filename$ = Left$(Filename$, Imbedded - 1)
   End If

   ' store replacement parameters
   If Left$(DOS.Filename$, 2) = "\\" Then
      Parameters(1) = "\\"
      Parameters(2) = "\\"
      Parameters(3) = DOS.Pathname$
      Parameters(4) = DOS.Pathname$ + "\"
      Parameters(5) = DOS.Filename$
   Else
      Parameters(1) = Drive.Search + ":"
      Parameters(2) = Drive.Search + ":\"
      Parameters(3) = Drive.Search + ":" + DOS.Pathname$
      Parameters(4) = Drive.Search + ":" + DOS.Pathname$ + "\"
      Parameters(5) = Drive.Search + ":" + DOS.Filename$
   End If
   Parameters(6) = DOS.Pathname$
   Parameters(7) = DOS.Pathname$ + "\"
   Parameters(8) = DOS.Filename$
   Parameters(9) = Filename$ + "." + Extension$
   Parameters(10) = Filename$
   Parameters(11) = "." + Extension$
   Parameters(12) = Extension$

   ' create DOS command
   Execute.Command$ = Next.Command$

   ' replace parameters
   Count = 1
   Do
      If Count >= Len(Execute.Command$) Then
         Exit Do
      End If
      Imbed$ = Mid$(Execute.Command$, Count, 1)
      If Imbed$ = "%" Then
         Imbed2$ = Mid$(Execute.Command$, Count + 1, 1)
         Select Case UCase$(Imbed2$)
            Case "1" To "9", "A" To "C"
               Count2 = Val("&H" + Imbed2$)
               Execute.Command$ = Left$(Execute.Command$, Count - 1) + RTrim$(Parameters(Count2)) + Mid$(Execute.Command$, Count + 2)
               Count = Count + Len(RTrim$(Parameters(Count2)))
            Case Else
               Count = Count + 1
         End Select
      Else
         Count = Count + 1
      End If
   Loop

   ' start DOS command shell
   If Len(Execute.Command$) Then
      ' check display counter
      If Wide.List Then
         Wide.List = False
         Print
      End If

      ' read command path from environment
      Comspec$ = Environ$("COMSPEC")
      If Len(Comspec$) Then
         ' call shell routine
         If Disable.Cmd Then
            Shell.Command$ = Comspec$ + " /K " + Execute.Command$
         Else
            Shell.Command$ = Comspec$ + " /C " + Execute.Command$
         End If
         Shell Shell.Command$
      End If
   End If
End Sub

' command line switch position function
Function LastSwitch (Var)
   LastSwitch = -1
   If Last.Switch = 0 Then
      Last.Switch = Var - 1
      Switch.Exist = -1
   Else
      If Var < Last.Switch Then
         Last.Switch = Var - 1
         Switch.Exist = -1
      End If
   End If
End Function

' command line switch parser function.
Function ParseLine (X$)
   Imbedded = InStr(Command.Line, LCase$(X$))
   If Imbedded Then
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
      Last.Switch = Imbedded - 1
      Switch.Exist = -1
      ParseLine = True
   Else
      Imbedded = InStr(Command.Line, UCase$(X$))
      If Imbedded Then
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
         Last.Switch = Imbedded - 1
         Switch.Exist = -1
         ParseLine = True
      Else
         ParseLine = False
      End If
   End If
End Function

' formats a double numeric string
Function FormatString$ (s#)
   x$ = ""
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString$ = x$
End Function

' routine parses command line for switches, filenames, and additional info.
Sub ReadSwitches (VarX$)
   ' assign a quote.
   Quote = Chr$(34)

   ' get command line
   Command.Line = VarX$

   ' check command line.
   If Command.Line = "/?" Then
      Call BootUsage
      Color Plain, Black
      Print "Exiting to DOS:"
      End 2
   End If

   ' concatenate environment variable.
   If InStr(Command.Line, "/J") Or InStr(Command.Line, "/j") Then
      Force.LowerCase = True
   End If
   If Force.LowerCase Then
      Command.Line = Command.Line + LCase$(Environ$("COPYIT"))
   Else
      Command.Line = Command.Line + Environ$("COPYIT")
   End If

   ' read config switches.
   Ignore.Config = ParseLine("/.")
   Ignore.Skip = ParseLine("/:")

   ' check config switch.
   If Ignore.Config = False Then

      ' search for config file in dos path.
      Call ReadConfig(StartDir$, File.Found)

      ' search for config file in dosutils path.
      If File.Found = False Then
         Call ReadConfig(Environ$("DOSUTILS"), File.Found)
      End If

      ' search config file in path variable.
      If File.Found = False Then
         Var$ = Environ$("PATH")
         If Var$ <> Nul Then
            Do
               Imbedded = InStr(Var$, ";")
               If Imbedded Then
                  Path$ = Left$(Var$, Imbedded - 1)
                  Var$ = Mid$(Var$, Imbedded + 1)
               Else
                  Path$ = Var$
                  Var$ = Nul
               End If
               If Len(Path$) Then
                  Call ReadConfig(Path$, File.Found)
                  If File.Found Then
                     Exit Do
                  End If
               End If
               If Var$ = Nul Then
                  Exit Do
               End If
            Loop
         End If
      End If
   End If

   ' check command line.
   If Command.Line = "" Then
      Boot.List$ = "Error specifying command line."
      GoTo Boot.Error
   End If

   ' read command line display switch.
   If InStr(Command.Line, "/P") Or InStr(Command.Line, "/p") Then
      Display.CommandLine = True
   End If
   If Display.CommandLine Then
      Print Command.Line
   End If

   ' read startup command line switches.
   Force.LowerCase = ParseLine("/J")
   Display.CommandLine = ParseLine("/P")
   Ignore.Sort = ParseLine("/-1")
   If ParseLine("/-2") Then
      Sort.Method = 1
   End If
   If Sort.Method = 0 Then
      If ParseLine("/-3") Then
         Sort.Method = 2
      End If
   End If

   ' read attribute switches.
   Set.Source.Archive = ParseLine("///XA")
   Set.Source.Hidden = ParseLine("///XH")
   Set.Source.Readonly = ParseLine("///XO")
   Set.Source.System = ParseLine("///XS")
   Set.Source.Any = ParseLine("///XX")

   Clear.Source.Archive = ParseLine("///ZA")
   Clear.Source.Hidden = ParseLine("///ZH")
   Clear.Source.Readonly = ParseLine("///ZO")
   Clear.Source.System = ParseLine("///ZS")
   Clear.Source.Any = ParseLine("///ZX")

   Set.Dest.Archive = ParseLine("//XA")
   Set.Dest.Hidden = ParseLine("//XH")
   Set.Dest.Readonly = ParseLine("//XO")
   Set.Dest.System = ParseLine("//XS")
   Set.Dest.Any = ParseLine("//XX")

   Clear.Dest.Archive = ParseLine("//ZA")
   Clear.Dest.Hidden = ParseLine("//ZH")
   Clear.Dest.Readonly = ParseLine("//ZO")
   Clear.Dest.System = ParseLine("//ZS")
   Clear.Dest.Any = ParseLine("//ZX")

   Display.Archive = ParseLine("/XA")
   Display.Hidden = ParseLine("/XH")
   Display.Readonly = ParseLine("/XO")
   Display.System = ParseLine("/XS")
   Display.Any = ParseLine("/XX")

   Display.Compressed = ParseLine("/XC")
   Display.Encrypted = ParseLine("/XE")

   No.Display.Archive = ParseLine("/ZA")
   No.Display.Hidden = ParseLine("/ZH")
   No.Display.Readonly = ParseLine("/ZO")
   No.Display.System = ParseLine("/ZS")
   No.Display.Any = ParseLine("/ZX")

   No.Display.Compressed = ParseLine("/ZC")
   No.Display.Encrypted = ParseLine("/ZE")

   ' read synchronize switches.
   Synch.Files1 = ParseLine("/A1")
   Synch.Files2 = ParseLine("/A2")
   Synch.Files3 = ParseLine("/A3")
   Synch.Files4 = ParseLine("/A4")
   Synch.Files5 = ParseLine("/A5")
   Synch.Files6 = ParseLine("/A6")
   Synch.Files7 = ParseLine("/A7")
   Synch.Files8 = ParseLine("/A8")
   Synch.Files9 = ParseLine("/A9")
   Synch.FilesA = ParseLine("/AA")
   Synch.FilesB = ParseLine("/AB")
   Synch.FilesC = ParseLine("/AC")

   ' read synchronize override switches.
   Synch.Type1 = ParseLine("/Z1")
   Synch.Type2 = ParseLine("/Z2")
   Synch.Type3 = ParseLine("/Z3")

   ' reset default date/time switch.
   If Synch.Type1 = False Then
      If Synch.Type2 = False Then
         If Synch.Type3 = False Then
            Synch.Type3 = True
         End If
      End If
   End If

   ' read synchronize override switches.
   Compare.Create.Date = ParseLine("/S1")
   Compare.Access.Date = ParseLine("/S2")
   Compare.Modify.Date = ParseLine("/S3")

   ' reset default synchronize override switch.
   If Compare.Create.Date = False Then
      If Compare.Access.Date = False Then
         If Compare.Modify.Date = False Then
            Compare.Modify.Date = True
         End If
      End If
   End If

   ' read remaining alphabetic switches.
   Synch.Files = ParseLine("/A")
   Copy.Directory = ParseLine("/B1")
   Zero.Nest = ParseLine("/B2")
   Skip.Directory = ParseLine("/B3")
   Continuous.Display2 = ParseLine("/C1")
   Continuous.Display3 = ParseLine("/C2")
   Continuous.Display = ParseLine("/C")
   Drive.Letter = ParseLine("/H")
   Delete.Copied = ParseLine("/I")
   Delete.Directory = ParseLine("/K")
   Dont.Overwrite = ParseLine("/M")
   Prompt.Delete1 = ParseLine("/N")
   Display.Wide = ParseLine("/O1")
   Ambiguate.Display = ParseLine("/O2")
   Prompt.Delete2 = ParseLine("/Q")
   Recurse.Directories = ParseLine("/R")
   Display.Path = ParseLine("/S")
   Overwrite.Prompt = ParseLine("/W")
   Short.Display = ParseLine("/X1")
   Short.Display2 = ParseLine("/X2")
   Short.Display3 = ParseLine("/X3")
   Short.Display4 = ParseLine("/X4")
   Display.Lowercase = ParseLine("/Y")
   Display.Errors = ParseLine("/Z")
   Disable.Cmd = ParseLine("/_")
   Extended.Time = ParseLine("/-4")
   Skip.All = ParseLine("/-5")

   ' parse append switches
   Imbedded = InStr(UCase$(Command.Line), "/V2")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 3)
      Call GetNumeric(Var#)
      If Var# > 4294967295# Then
         Boot.List$ = "Error specifying append value."
         GoTo Boot.Error
      End If
      Byte.Switch = True
      Byte.Override = Var#
      Append.Dest = ParseLine("/V")
   Else
      Resume.File = ParseLine("/V1")
      If Resume.File Then
         Append.Dest = True
      Else
         Append.Dest = ParseLine("/V")
      End If
   End If

   ' read more switches
   Pattern.Match = ParseLine("/@2")
   Enable.Redirect = ParseLine("/@")
   Disable.Prompts = ParseLine("/#")

   ' read extended display switches.
   If ParseLine("/L1") Then
      Double.Line = 1
   End If
   If ParseLine("/L2") Then
      Double.Line = 2
   End If
   If ParseLine("/L3") Then
      Double.Line = 3
   End If
   If ParseLine("/L4") Then
      Double.Line = 4
   End If
   If ParseLine("/L") Then
      Double.Line = 4
   End If
 
   ' init first copied directory flag.
   If Zero.Nest Then
      Copy.Directory = True
   End If
   If Skip.Directory Then
      Copy.Directory = True
   End If

   ' parse special debug switch.
   Debug.ModeX = ParseLine("/-=")

   ' parse progress switches.
   Progress.Bar = ParseLine("/*")
   Percent.Display = ParseLine("/!")
   Dot.Mode = ParseLine("/-")

   ' init display switches.
   If Percent.Display Then
      Dot.Mode = True
   End If
   If Progress.Bar Then
      Percent.Display = False
      Dot.Mode = True
   End If

   ' read timing switch.
   Rate.Mode = ParseLine("/+")

   ' read debug mode switches
   DebugDelay! = 3!
   Var2 = 0
   For Var = 0 To 9
      Var2 = ParseLine("/=" + Mid$(Str$(Var), 2))
      If Var2 Then
         DebugDelay! = CSng(Var)
         Debug.Mode = -1
         Exit For
      End If
   Next
   If Var2 = 0 Then
      Debug.Mode = ParseLine("/=")
   End If

   ' set attribute display variable.
   Display.Attribute = False
   If Display.Archive Or No.Display.Archive Then
      Display.Attribute = True
   End If
   If Display.Hidden Or No.Display.Hidden Then
      Display.Attribute = True
   End If
   If Display.Readonly Or No.Display.Readonly Then
      Display.Attribute = True
   End If
   If Display.System Or No.Display.System Then
      Display.Attribute = True
   End If
   If Display.Any Or No.Display.Any Then
      Display.Attribute = True
   End If
   If Display.Compressed Or Display.Encrypted Then
      Display.Attribute = True
   End If
   If No.Display.Compressed Or No.Display.Encrypted Then
      Display.Attribute = True
   End If

   ' set source attribute flag.
   Set.Source.Attribute = False
   If Clear.Source.Archive Or Set.Source.Archive Then
      Set.Source.Attribute = True
   End If
   If Clear.Source.Hidden Or Set.Source.Hidden Then
      Set.Source.Attribute = True
   End If
   If Clear.Source.Readonly Or Set.Source.Readonly Then
      Set.Source.Attribute = True
   End If
   If Clear.Source.System Or Set.Source.System Then
      Set.Source.Attribute = True
   End If
   If Clear.Source.Any Or Set.Source.Any Then
      Set.Source.Attribute = True
   End If

   ' reset file counter variables.
   Error.Level = False
   Dirs.Counted = SFalse
   Dirs.Created = SFalse
   Files.Counted = DFalse
   More.Display = False
   Total.Deleted = False

   ' read excluded filename specs from command line.
   Max.Excluded = 10
   Number.Excluded = False
   Do
      Excluded = InStr(Command.Line, "/(")
      If Excluded = False Then
         Exit Do
      End If
      Var = LastSwitch(Excluded)
      Excluded.Spec$ = Nul
      Next.Bracket = InStr(Excluded + 2, Command.Line, ")")
      If Next.Bracket Then
         Excluded.Spec$ = Mid$(Command.Line, Excluded + 2, Next.Bracket - Excluded - 2)
         Command.Line = Left$(Command.Line, Excluded - 1) + Mid$(Command.Line, Next.Bracket + 1)
      End If
      If Excluded.Spec$ = Nul Then
         Boot.List$ = "Error specifying excluded list."
         GoTo Boot.Error
      End If
      Number.Excluded = Number.Excluded + 1
      If Number.Excluded > Max.Excluded Then
         Max.Excluded = Max.Excluded + 10
         ReDim _Preserve Excluded.Files(1 To Max.Excluded) As String * 128
      End If
      Excluded.Files(Number.Excluded) = UCase$(Excluded.Spec$)
      Command.Line = RTrim$(Command.Line)
   Loop

   ' read DOS commands from command line.
   Max.Commands = 10
   Number.Commands = False
   Do
      DOSswitch = InStr(Command.Line, "/[")
      If DOSswitch = False Then
         Exit Do
      End If
      Var = LastSwitch(DOSswitch)
      DOS.Spec$ = Nul
      Next.Bracket = InStr(DOSswitch + 2, Command.Line, "]")
      If Next.Bracket Then
         DOS.Spec$ = Mid$(Command.Line, DOSswitch + 2, Next.Bracket - DOSswitch - 2)
         Command.Line = Left$(Command.Line, DOSswitch - 1) + Mid$(Command.Line, Next.Bracket + 1)
      End If
      If DOS.Spec$ = Nul Then
         Boot.List$ = "Error specifying DOS command."
         GoTo Boot.Error
      End If
      Number.Commands = Number.Commands + 1
      If Number.Commands > Max.Commands Then
         Max.Commands = Max.Commands + 10
         ReDim _Preserve DOS.Command(1 To Max.Commands) As String * 128
      End If
      DOS.Command(Number.Commands) = DOS.Spec$
      Command.Line = RTrim$(Command.Line)
   Loop

   ' parse dos command parameters.
   For Count = 1 To Number.Commands
      Next.Command$ = DOS.Command(Count)
      Imbedded = InStr(Next.Command$, "//1")
      While Imbedded
         Next.Command$ = Left$(Next.Command$, Imbedded - 1) + ">" + Mid$(Next.Command$, Imbedded + 3)
         Imbedded = InStr(Next.Command$, "//1")
      Wend
      Imbedded = InStr(Next.Command$, "//2")
      While Imbedded
         Next.Command$ = Left$(Next.Command$, Imbedded - 1) + "<" + Mid$(Next.Command$, Imbedded + 3)
         Imbedded = InStr(Next.Command$, "//2")
      Wend
      Imbedded = InStr(Next.Command$, "//3")
      While Imbedded
         Next.Command$ = Left$(Next.Command$, Imbedded - 1) + "|" + Mid$(Next.Command$, Imbedded + 3)
         Imbedded = InStr(Next.Command$, "//3")
      Wend
      Imbedded = InStr(Next.Command$, "//4")
      While Imbedded
         Next.Command$ = Left$(Next.Command$, Imbedded - 1) + "%" + Mid$(Next.Command$, Imbedded + 3)
         Imbedded = InStr(Next.Command$, "//4")
      Wend
      Imbedded = InStr(Next.Command$, "//5")
      While Imbedded
         Next.Command$ = Left$(Next.Command$, Imbedded - 1) + "]" + Mid$(Next.Command$, Imbedded + 3)
         Imbedded = InStr(Next.Command$, "//5")
      Wend
      DOS.Command(Count) = Next.Command$
   Next

   ' read destination file date override.
   Override.Date.Month = False
   Override.Date.Day = False
   Override.Date.Year = False
   Override.Date = False
   Imbedded = InStr(Command.Line, "/5")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Date.Override$ = Mid$(Command.Line, Imbedded + 2, 10)
      If Mid$(Date.Override$, 3, 1) <> "/" Then
         Boot.List$ = "Error specifying override date."
         GoTo Boot.Error
      End If
      If Mid$(Date.Override$, 6, 1) <> "/" Then
         Boot.List$ = "Error specifying override date."
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 12)
      Override.Date.Month = Int(Val(Mid$(Date.Override$, 1, 2)))
      Override.Date.Day = Int(Val(Mid$(Date.Override$, 4, 2)))
      Override.Date.Year = Int(Val(Mid$(Date.Override$, 7, 4)))
      If Override.Date.Month = 99 And Override.Date.Day = 99 And Override.Date.Year = 9999 Then
         Override.Date.Month = Val(Left$(Date$, 2))
         Override.Date.Day = Val(Mid$(Date$, 4, 2))
         Override.Date.Year = Val(Right$(Date$, 4))
      End If
      Override.Date = True
   End If

   ' read destination file time override.
   Override.Time.Hour = False
   Override.Time.Minute = False
   Override.Time.Second = False
   Override.Time = False
   Imbedded = InStr(Command.Line, "/6")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Time.Override$ = Mid$(Command.Line, Imbedded + 2, 8)
      If Mid$(Time.Override$, 3, 1) <> ":" Then
         Boot.List$ = "Error specifying override time."
         GoTo Boot.Error
      End If
      If Mid$(Time.Override$, 6, 1) <> ":" Then
         Boot.List$ = "Error specifying override time."
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 10)
      Override.Time.Hour = Int(Val(Mid$(Time.Override$, 1, 2)))
      Override.Time.Minute = Int(Val(Mid$(Time.Override$, 4, 2)))
      Override.Time.Second = Int(Val(Mid$(Time.Override$, 7, 2)))
      If Override.Time.Hour = 99 And Override.Time.Minute = 99 And Override.Time.Second = 99 Then
         Override.Time.Hour = Int(Val(Left$(Time$, 2)))
         Override.Time.Minute = Int(Val(Mid$(Time$, 4, 2)))
         Override.Time.Second = Int(Val(Right$(Time$, 2)))
      End If
      Override.Time = True
   End If

   ' read date from command line.
   Search.Date = False
   Search.From.Date = False
   Search.To.Date = False
   Imbedded = InStr(UCase$(Command.Line), "/E")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Search.Date = True
      ' /e01/01/1997-01/01/1997
    IF MID$(Command.Line, Imbedded + 4, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 7, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 12, 1) = "-" AND _
    MID$(Command.Line, Imbedded + 15, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 18, 1) = "/" THEN
         D$ = Mid$(Command.Line, Imbedded + 2, 21)
         S$ = Left$(D$, 10)
         D1! = Int(Val(Mid$(S$, 1, 2))) ' month
         D2! = Int(Val(Mid$(S$, 4, 2))) ' day
         D3! = Int(Val(Mid$(S$, 7, 4))) ' year
         If D1! = 99! And D2! = 99! And D3! = 9999! Then ' current date
            D1! = Val(Left$(Date$, 2))
            D2! = Val(Mid$(Date$, 4, 2))
            D3! = Val(Right$(Date$, 4))
         End If
         Search.From.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
         S$ = Right$(D$, 10)
         D1! = Int(Val(Mid$(S$, 1, 2))) ' month
         D2! = Int(Val(Mid$(S$, 4, 2))) ' day
         D3! = Int(Val(Mid$(S$, 7, 4))) ' year
         If D1! = 99! And D2! = 99! And D3! = 9999! Then ' current date
            D1! = Val(Left$(Date$, 2))
            D2! = Val(Mid$(Date$, 4, 2))
            D3! = Val(Right$(Date$, 4))
         End If
         Search.To.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 23)
      Else
         ' /e-01/01/1997
       IF MID$(Command.Line, Imbedded + 2, 1) = "-" AND _
       MID$(Command.Line, Imbedded + 5, 1) = "/" AND _
       MID$(Command.Line, Imbedded + 8, 1) = "/" THEN
            Search.From.Date = False
            S$ = Mid$(Command.Line, Imbedded + 3, 10)
            D1! = Int(Val(Mid$(S$, 1, 2))) ' month
            D2! = Int(Val(Mid$(S$, 4, 2))) ' day
            D3! = Int(Val(Mid$(S$, 7, 4))) ' year
            If D1! = 99! And D2! = 99! And D3! = 9999! Then ' current date
               D1! = Val(Left$(Date$, 2))
               D2! = Val(Mid$(Date$, 4, 2))
               D3! = Val(Right$(Date$, 4))
            End If
            Search.To.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 13)
         Else
            ' /e01/01/1997-
          IF MID$(Command.Line, Imbedded + 4, 1) = "/" AND _
          MID$(Command.Line, Imbedded + 7, 1) = "/" AND _
          MID$(Command.Line, Imbedded + 12, 1) = "-" THEN
               Search.To.Date = False
               S$ = Mid$(Command.Line, Imbedded + 2, 10)
               D1! = Int(Val(Mid$(S$, 1, 2))) ' month
               D2! = Int(Val(Mid$(S$, 4, 2))) ' day
               D3! = Int(Val(Mid$(S$, 7, 4))) ' year
               If D1! = 99! And D2! = 99! And D3! = 9999! Then ' current date
                  D1! = Val(Left$(Date$, 2))
                  D2! = Val(Mid$(Date$, 4, 2))
                  D3! = Val(Right$(Date$, 4))
               End If
               Search.From.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
               Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 13)
            Else
               Boot.List$ = "Error specifying search date."
               GoTo Boot.Error
            End If
         End If
      End If
      If Search.From.Date < False Or Search.To.Date < False Then
         Boot.List$ = "Error specifying search date."
         GoTo Boot.Error
      End If
   End If

   ' read time from command line.
   Search.Time = False
   Search.From.Time = False
   Search.To.Time = False
   Imbedded = InStr(UCase$(Command.Line), "/T")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Search.Time = True
      ' /t12:00:00-12:00:00
    IF MID$(Command.Line, Imbedded + 4, 1) = ":" AND _
    MID$(Command.Line, Imbedded + 7, 1) = ":" AND _
    MID$(Command.Line, Imbedded + 10, 1) = "-" AND _
    MID$(Command.Line, Imbedded + 13, 1) = ":" AND _
    MID$(Command.Line, Imbedded + 16, 1) = ":" THEN
         D$ = Mid$(Command.Line, Imbedded + 2, 17)
         S$ = Left$(D$, 8)
         T1! = Int(Val(Mid$(S$, 1, 2))) ' hours
         T2! = Int(Val(Mid$(S$, 4, 2))) ' minutes
         T3! = Int(Val(Mid$(S$, 7, 2))) ' seconds
         If T1! = 99 And T2! = 99 And T3! = 99 Then
            T1! = Int(Val(Left$(Time$, 2)))
            T2! = Int(Val(Mid$(Time$, 4, 2)))
            T3! = Int(Val(Right$(Time$, 2)))
         End If
         Search.From.Time = T1! * 2048 + T2! * 32 + T3!
         S$ = Right$(D$, 8)
         T1! = Int(Val(Mid$(S$, 1, 2))) ' hours
         T2! = Int(Val(Mid$(S$, 4, 2))) ' minutes
         T3! = Int(Val(Mid$(S$, 7, 2))) ' seconds
         If T1! = 99 And T2! = 99 And T3! = 99 Then
            T1! = Int(Val(Left$(Time$, 2)))
            T2! = Int(Val(Mid$(Time$, 4, 2)))
            T3! = Int(Val(Right$(Time$, 2)))
         End If
         Search.To.Time = T1! * 2048 + T2! * 32 + T3!
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 19)
      Else
         ' /t-12:00:00
       IF MID$(Command.Line, Imbedded + 2, 1) = "-" AND _
       MID$(Command.Line, Imbedded + 5, 1) = ":" AND _
       MID$(Command.Line, Imbedded + 8, 1) = ":" THEN
            Search.From.Time = False
            S$ = Mid$(Command.Line, Imbedded + 3, 8)
            T1! = Int(Val(Mid$(S$, 1, 2))) ' hours
            T2! = Int(Val(Mid$(S$, 4, 2))) ' minutes
            T3! = Int(Val(Mid$(S$, 7, 4))) ' seconds
            If T1! = 99 And T2! = 99 And T3! = 99 Then
               T1! = Int(Val(Left$(Time$, 2)))
               T2! = Int(Val(Mid$(Time$, 4, 2)))
               T3! = Int(Val(Right$(Time$, 2)))
            End If
            Search.To.Time = T1! * 2048 + T2! * 32 + T3!
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 11)
         Else
            ' /t12:00:00-
          IF MID$(Command.Line, Imbedded + 4, 1) = ":" AND _
          MID$(Command.Line, Imbedded + 7, 1) = ":" AND _
          MID$(Command.Line, Imbedded + 10, 1) = "-" THEN
               Search.To.Time = False
               S$ = Mid$(Command.Line, Imbedded + 2, 10)
               T1! = Int(Val(Mid$(S$, 1, 2))) ' hours
               T2! = Int(Val(Mid$(S$, 4, 2))) ' minutes
               T3! = Int(Val(Mid$(S$, 7, 4))) ' seconds
               If T1! = 99 And T2! = 99 And T3! = 99 Then
                  T1! = Int(Val(Left$(Time$, 2)))
                  T2! = Int(Val(Mid$(Time$, 4, 2)))
                  T3! = Int(Val(Right$(Time$, 2)))
               End If
               Search.From.Time = T1! * 2048 + T2! * 32 + T3!
               Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 11)
            Else
               Boot.List$ = "Error specifying search time."
               GoTo Boot.Error
            End If
         End If
      End If
      If Search.From.Time < False Or Search.To.Time < False Then
         Boot.List$ = "Error specifying search time."
         GoTo Boot.Error
      End If
   End If

   ' read file size from command line.
   Search.File.Size = False
   Search.Size.From = DFalse
   Search.Size.To = DFalse
   Imbedded = InStr(UCase$(Command.Line), "/U")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Search.File.Size = True
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
      Call GetNumeric(Var#)
      Search.Size.From = Var#
      If Mid$(Command.Line, Imbedded, 1) <> "-" Then
         Boot.List$ = "Error specifying search size."
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
      Call GetNumeric(Var#)
      Search.Size.To = Var#
      Search.Size.From = Search.Size.From * 1024#
      Search.Size.To = Search.Size.To * 1024#
   End If

   ' read pattern date from command line.
   Pattern.Search.Date = False
   Pattern.Search.From.Date = Nul
   Pattern.Search.To.Date = Nul
   Imbedded = InStr(UCase$(Command.Line), "/E1:")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Pattern.Search.Date = True
      ' /e1:01/01/2000-01/01/2010
    IF MID$(Command.Line, Imbedded + 6, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 9, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 14, 1) = "-" AND _
    MID$(Command.Line, Imbedded + 17, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 20, 1) = "/" THEN
         D$ = Mid$(Command.Line, Imbedded + 4, 21)
         Pattern.Search.From.Date = Left$(D$, 10)
         If Pattern.Search.From.Date = "99/99/9999" Then ' current date
            Pattern.Search.From.Date = Date$
            Mid$(Pattern.Search.From.Date, 3, 1) = "/"
            Mid$(Pattern.Search.From.Date, 6, 1) = "/"
         End If
         Pattern.Search.To.Date = Right$(D$, 10)
         If Pattern.Search.To.Date = "99/99/9999" Then ' current date
            Pattern.Search.To.Date = Date$
            Mid$(Pattern.Search.To.Date, 3, 1) = "/"
            Mid$(Pattern.Search.To.Date, 6, 1) = "/"
         End If
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 25)
      Else
         Boot.List$ = "Error specifying pattern search date."
         GoTo Boot.Error
      End If
   End If

   ' read filename pattern from command line.
   Pattern.Search = False
   Pattern.Filename = Nul
   Imbedded = InStr(UCase$(Command.Line), "/E2:")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      If Mid$(Command.Line, Imbedded + 4, 1) = Quote Then
         For Var = Imbedded + 5 To Len(Command.Line)
            If Mid$(Command.Line, Var, 1) = Quote Then
               Pattern.Search = True
               Pattern.Filename = UCase$(Mid$(Command.Line, Imbedded + 5, Var - Imbedded - 5))
               Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Var + 1)
               Exit For
            End If
         Next
         If Pattern.Search = False Then
            Boot.List$ = "Error specifying filename pattern."
            GoTo Boot.Error
         End If
      End If
   End If

   ' verify both parameters set.
   If Pattern.Search Or Pattern.Search.Date Then
      If Pattern.Search = False Or Pattern.Search.Date = False Then
         Boot.List$ = "Error specifying filename pattern."
         GoTo Boot.Error
      End If
   End If

   ' read remaining numeric switches.
   Copy.Zero = ParseLine("/0")
   Copy.Ascii = ParseLine("/1")

   ' read ascii replacement filters from command line.
   Ascii.Filters = False
   Max.Filters = 10
   Do
      Imbedded = InStr(Command.Line, "/2")
      If Imbedded = False Then
         Exit Do
      End If
      Var = LastSwitch(Imbedded)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
      Call GetNumeric(Var#)
      If Var# > 255# Then
         Boot.List$ = "Error specifying search filter."
         GoTo Boot.Error
      End If
      Ascii.From = CInt(Var#)
      If Mid$(Command.Line, Imbedded, 1) <> "-" Then
         Boot.List$ = "Error specifying search filter."
         GoTo Boot.Error
      End If
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
      Call GetNumeric(Var#)
      If Var# > 255# Then
         Boot.List$ = "Error specifying search filter."
         GoTo Boot.Error
      End If
      Ascii.To = CInt(Var#)
      If Ascii.To <> Ascii.From Then
         Ascii.Filters = Ascii.Filters + 1
         If Ascii.Filters > Max.Filters Then
            Max.Filters = Max.Filters + 10
            ReDim _Preserve Convert.Ascii(1 To Max.Filters, 1 To 2) As Integer
         End If
         Convert.Ascii(Ascii.Filters, 1) = Ascii.From
         Convert.Ascii(Ascii.Filters, 2) = Ascii.To
      End If
   Loop

   ' read ascii strip filters from command line.
   Ascii.Strips = False
   Max.Strips = 10
   Do
      Imbedded = InStr(Command.Line, "/3")
      If Imbedded = False Then
         Exit Do
      End If
      Var = LastSwitch(Imbedded)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
      Call GetNumeric(Var#)
      If Var# > 255# Then
         Boot.List$ = "Error specifying strip filter."
         GoTo Boot.Error
      End If
      Ascii.Strips = Ascii.Strips + 1
      If Ascii.Strips > Max.Strips Then
         Max.Strips = Max.Strips + 10
         ReDim _Preserve Strip.Ascii(1 To Max.Strips) As Integer
      End If
      Strip.Ascii(Ascii.Strips) = CInt(Var#)
   Loop

   ' read nest override switch.
   Imbedded = InStr(Command.Line, "/4")
   If Imbedded Then
      Var = LastSwitch(Imbedded)
      Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 2)
      Call GetNumeric(Var#)
      If Var# > 32767# Then
         Boot.List$ = "Error specifying nest override."
         GoTo Boot.Error
      End If
      Nested.Recurse = CInt(Var#)
   End If

   ' read override switches.
   Override.Create.Date = ParseLine("/7")
   Override.Access.Date = ParseLine("/8")
   Override.Modify.Date = ParseLine("/9")

   ' reset remaining variables.
   Dest.Dir = Nul
   Max.Dest.Dirs = 10
   Number.Dest.Dirs = False

   Dest.File = Nul
   Max.Dest.Files = 10
   Number.Dest.Files = False

   Max.Dest.Nets = 10
   Number.Dest.Nets = False

   Temp.Drive.Dir = Nul

   ' check command line.
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)

   ' read remaining filename switches.
   Do
      If InStr(Command.Line, "/") = False Then
         ' check trailing command line.
         Command.Line = RTrim$(Command.Line)
         If Switch.Exist Then
            If Len(Command.Line) > Last.Switch Then
               Boot.List$ = "Unknown command line characters."
               GoTo Boot.Error
            End If
         End If
         Exit Do
      End If
      For Count = Len(Command.Line) To 1 Step -1
         If Mid$(Command.Line, Count, 1) = "/" Then
            ' store switch letter.
            Switch$ = Mid$(Command.Line, Count + 1, 1)

            ' store switch value.
            Var = LastSwitch(Count)
            Switch.Line$ = Mid$(Command.Line, Count + 2)
            Switch.Line$ = LTrim$(Switch.Line$)
            Switch.Line$ = RTrim$(Switch.Line$)

            ' check quoted string.
            File.Quotes = False
            If Right$(Switch.Line$, 1) = Quote Then
               If Left$(Switch.Line$, 1) = Quote Then
                  Switch.Line$ = Mid$(Switch.Line$, 2)
                  Switch.Line$ = Left$(Switch.Line$, Len(Switch.Line$) - 1)
                  File.Quotes = True
               End If
            End If

            ' process switch.
            Select Case UCase$(Switch$)
               Case "F" ' filename
                  Var = LastSwitch(Count)
                  If Len(Switch.Line$) = False Then
                     Boot.List$ = "Missing command line characters."
                     GoTo Boot.Error
                  End If
                  If InStr(Switch.Line$, " ") Then
                     If File.Quotes = False Then
                        Boot.List$ = "Unknown command line characters."
                        GoTo Boot.Error
                     End If
                  End If
                  Number.Dest.Files = Number.Dest.Files + 1
                  If Number.Dest.Files > Max.Dest.Files Then
                     Max.Dest.Files = Max.Dest.Files + 10
                     ReDim _Preserve Destinate.Filename(1 To Max.Dest.Files) As String * 260
                  End If
                  Destinate.Filename(Number.Dest.Files) = Switch.Line$
                  Dest.File = Switch.Line$
               Case "D" ' directory
                  Var = LastSwitch(Count)
                  If Len(Switch.Line$) = False Then
                     ' check /d w/o parameters specified
                     If Zero.Dirs Then
                        Boot.List$ = "Multiple nul directories not allowed."
                        GoTo Boot.Error
                     End If
                     ' set /d w/o parameters specified
                     Zero.Dirs = True
                  End If
                  If InStr(Switch.Line$, " ") Then
                     If File.Quotes = False Then
                        Boot.List$ = "Unknown command line characters."
                        GoTo Boot.Error
                     End If
                  End If
                  Number.Dest.Dirs = Number.Dest.Dirs + 1
                  If Number.Dest.Dirs > Max.Dest.Dirs Then
                     Max.Dest.Dirs = Max.Dest.Dirs + 10
                     ReDim _Preserve Destinate.Directory(1 To Max.Dest.Dirs) As String * 260
                  End If
                  ' check /d w/o parameters specified
                  If Number.Dest.Dirs > 1 Then
                     If Zero.Dirs Then
                        Boot.List$ = "Combined specified and nul directory not allowed."
                        GoTo Boot.Error
                     End If
                  End If
                  Destinate.Directory(Number.Dest.Dirs) = Switch.Line$
               Case "G" ' netpath
                  Var = LastSwitch(Count)
                  If Len(Switch.Line$) = False Then
                     ' check /g w/o parameters specified
                     If Zero.Nets Then
                        Boot.List$ = "Multiple nul netpaths not allowed."
                        GoTo Boot.Error
                     End If
                     ' set /g w/o parameters specified
                     Zero.Nets = True
                  End If
                  If InStr(Switch.Line$, " ") Then
                     If File.Quotes = False Then
                        Boot.List$ = "Unknown command line characters."
                        GoTo Boot.Error
                     End If
                  End If
                  Number.Dest.Nets = Number.Dest.Nets + 1
                  If Number.Dest.Nets > Max.Dest.Nets Then
                     Max.Dest.Nets = Max.Dest.Nets + 10
                     ReDim _Preserve Destinate.Netpaths(1 To Max.Dest.Nets) As String * 260
                  End If
                  ' check /g w/o parameters specified
                  If Number.Dest.Nets > 1 Then
                     If Zero.Nets Then
                        Boot.List$ = "Combined specified and nul netpaths not allowed."
                        GoTo Boot.Error
                     End If
                  End If
                  If Left$(Switch.Line$, 2) <> "\\" Then
                     If Zero.Nets = False Then
                        Boot.List$ = "Unknown netpath characters."
                        GoTo Boot.Error
                     End If
                  End If
                  Destinate.Netpaths(Number.Dest.Nets) = Switch.Line$
               Case Else ' unknown switch
                  Exit Do
            End Select
            Command.Line = Left$(Command.Line, Count - 1)
            Command.Line = RTrim$(Command.Line)
            Exit For
         End If
      Next
   Loop

   ' check trailing command line.
   Command.Line = RTrim$(Command.Line)
   If Switch.Exist Then
      If Len(Command.Line) > Last.Switch Then
         Boot.List$ = "Unknown command line characters."
         GoTo Boot.Error
      End If
   End If

   ' check zero dirs specified
   If Number.Dest.Nets > 1 Then
      If Zero.Dirs Then
         Boot.List$ = "Nul directory and multiple netpaths not allowed."
         GoTo Boot.Error
      End If
   End If

   ' check zero nets specified
   If Number.Dest.Nets > 1 Then
      If Zero.Nets Then
         Boot.List$ = "Nul netpath and multiple netpaths not allowed."
         GoTo Boot.Error
      End If
   End If

   ' reset temporary drive.
   If Temp.Drive.Dir = Nul Then
      Temp$ = Environ$("TEMP")
      If Len(Temp$) Then
         Temp.Drive.Dir = Temp$
      Else
         Temp$ = Environ$("TMP")
         If Len(Temp$) Then
            Temp.Drive.Dir = Temp$
         End If
      End If
   End If

   ' recheck command line.
   If InStr(Command.Line, "/") Then
      Boot.List$ = "Unknown / switch."
      GoTo Boot.Error
   End If

   ' reset work variables.
   Copy.Target = Nul
   Continue.Searching = False
   Nested.Levels = False
   Quit.Searching = False
   
   ' store remaining command line.
   Command.Line = RTrim$(Command.Line)
   Command.Line = LTrim$(Command.Line)

   ' leave arrays in reverse order.
   If Ignore.Sort Then
      Exit Sub
   End If

   ' sort arrays ascending.
   If Sort.Method = 1 Then
      If Number.Dest.Files > 1 Then
         For Var1 = 1 To Number.Dest.Files
            For Var2 = Var1 + 1 To Number.Dest.Files
               If Destinate.Filename(Var1) > Destinate.Filename(Var2) Then
                  Swap Destinate.Filename(Var1), Destinate.Filename(Var2)
               End If
            Next
         Next
      End If
      If Number.Dest.Dirs > 1 Then
         For Var1 = 1 To Number.Dest.Dirs
            For Var2 = Var1 + 1 To Number.Dest.Dirs
               If Destinate.Directory(Var1) > Destinate.Directory(Var2) Then
                  Swap Destinate.Directory(Var1), Destinate.Directory(Var2)
               End If
            Next
         Next
      End If
      If Number.Dest.Nets > 1 Then
         For Var1 = 1 To Number.Dest.Nets
            For Var2 = Var1 + 1 To Number.Dest.Nets
               If Destinate.Netpaths(Var1) > Destinate.Netpaths(Var2) Then
                  Swap Destinate.Netpaths(Var1), Destinate.Netpaths(Var2)
               End If
            Next
         Next
      End If
      Exit Sub
   End If

   ' sort arrays descending.
   If Sort.Method = 2 Then
      If Number.Dest.Files > 1 Then
         For Var1 = 1 To Number.Dest.Files
            For Var2 = Var1 + 1 To Number.Dest.Files
               If Destinate.Filename(Var1) < Destinate.Filename(Var2) Then
                  Swap Destinate.Filename(Var1), Destinate.Filename(Var2)
               End If
            Next
         Next
      End If
      If Number.Dest.Dirs > 1 Then
         For Var1 = 1 To Number.Dest.Dirs
            For Var2 = Var1 + 1 To Number.Dest.Dirs
               If Destinate.Directory(Var1) < Destinate.Directory(Var2) Then
                  Swap Destinate.Directory(Var1), Destinate.Directory(Var2)
               End If
            Next
         Next
      End If
      If Number.Dest.Nets > 1 Then
         For Var1 = 1 To Number.Dest.Nets
            For Var2 = Var1 + 1 To Number.Dest.Nets
               If Destinate.Netpaths(Var1) < Destinate.Netpaths(Var2) Then
                  Swap Destinate.Netpaths(Var1), Destinate.Netpaths(Var2)
               End If
            Next
         Next
      End If
      Exit Sub
   End If

   ' restore arrays to original order.
   If Number.Dest.Files > 1 Then
      Last.Array = Number.Dest.Files
      Pivot.Array = Int(Last.Array / 2)
      For Var = 1 To Pivot.Array
         Swap Destinate.Filename(Var), Destinate.Filename(Last.Array)
         Last.Array = Last.Array - 1
      Next
   End If
   If Number.Dest.Dirs > 1 Then
      Last.Array = Number.Dest.Dirs
      Pivot.Array = Int(Last.Array / 2)
      For Var = 1 To Pivot.Array
         Swap Destinate.Directory(Var), Destinate.Directory(Last.Array)
         Last.Array = Last.Array - 1
      Next
   End If
   If Number.Dest.Nets > 1 Then
      Last.Array = Number.Dest.Nets
      Pivot.Array = Int(Last.Array / 2)
      For Var = 1 To Pivot.Array
         Swap Destinate.Netpaths(Var), Destinate.Netpaths(Last.Array)
         Last.Array = Last.Array - 1
      Next
   End If
   Exit Sub

   Boot.Error:
   If Display.Header = 0 Then
      Color White, Black
      Print "Copyit " + Version$ + " " + Release$ + ": File copy utility; "
   End If
   Color Yellow, Black
   Print Boot.List$
   Print "Type Copyit /? for help. Or edit Copyit.cfg file."
   Color Plain, Black
   Print "Exiting to DOS:"
   End 2

   ' trap any errors before switch subroutine exits to main copying code.
   Boot.Error2:
   DataError = Err
   Boot.List$ = "Critical error:" + Str$(DataError) + " IDE line:" + Str$(_ErrorLine)
   Resume Boot.Error
End Sub

' subroutines searchs for and parses config file.
Sub ReadConfig (Var$, File.Found)
   VarX$ = Var$
   File.Found = False
   If Left$(VarX$, 1) = Quote Then
      VarX$ = Mid$(VarX$, 2)
   End If
   If Right$(VarX$, 1) = Quote Then
      VarX$ = Left$(VarX$, Len(VarX$) - 1)
   End If
   If Right$(VarX$, 1) <> "\" Then
      VarX$ = VarX$ + "\"
   End If
   VarX$ = VarX$ + "COPYIT.CFG"
   If _FileExists(VarX$) Then
      Close #1
      Open VarX$ For Input As #1
      File.Found = True
      Do Until EOF(1)
         Line Input #1, Param$
         Var2$ = LTrim$(RTrim$(Param$))
         If Var2$ <> Nul Then
            If Left$(Var2$, 1) <> ";" Then
               Command.Line = Command.Line + Param$
            End If
         End If
      Loop
   End If
   Close #1
End Sub

' subroutine converts string to numeric value
Sub GetNumeric (Value#)
   Value# = DFalse
   Do
      Temp$ = Mid$(Command.Line, Imbedded, 1)
      If Temp$ >= "0" And Temp$ <= "9" Then
         Value# = Value# * 10# + Val(Temp$)
         Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + 1)
      Else
         Exit Sub
      End If
   Loop
End Sub

' display program usage
Sub BootUsage
   Display.Page = 1
   Do
      Select Case Display.Page
         Case 1
            GoSub Display.Page.One
         Case 2
            GoSub Display.Page.Two
         Case 3
            GoSub Display.Page.Three
         Case 4
            GoSub Display.Page.Four
         Case 5
            GoSub Display.Page.Five
         Case 6
            GoSub Display.Page.Six
         Case 7
            GoSub Display.Page.Seven
         Case 8
            GoSub Display.Page.Eight
         Case 9
            GoSub Display.Page.Nine
         Case 10
            GoSub Display.Page.Ten
         Case 11
            GoSub Display.Page.Eleven
      End Select
      Prompt$ = "Press 1, 2, 3, 4, 5, a, b, n, s, x, ?, or q to quit:"
      Call MorePrompt(Prompt$, "12345abnsx?q", Outpt$, "q")
      Select Case Outpt$
         Case "1"
            Display.Page = 1
         Case "2"
            Display.Page = 2
         Case "3"
            Display.Page = 3
         Case "4"
            Display.Page = 4
         Case "5"
            Display.Page = 5
         Case "a"
            Display.Page = 6
         Case "b"
            Display.Page = 7
         Case "n"
            Display.Page = 8
         Case "s"
            Display.Page = 9
         Case "x"
            Display.Page = 10
         Case "?"
            Display.Page = 11
         Case "q"
            Exit Sub
      End Select
   Loop
   Color Plain, Black
   Print "Exiting to DOS:"
   End 2

   Display.Page.One:
   GoSub Display.Header
   Print "Where:"
   Print "   <filelist> is source files to copy and are:"
   Print "     multiple files specified:"
   Print "       [@][d:][\path\][filename.ext]"
   Print "     or with netpath specified \\server\share\"
   Print "       @ prefix specifies filename containing filelist to copy"
   Print "   (destination switches):"
   Print "     /d[d:][\pathname\]  is destination directory"
   Print "     /f[filename.ext]    is destination filename"
   Print "     /g[\\server\share\] is destination netpath"
   Print "   (directory/file switches):"
   Print "     /a  synchronize dest. files"
   Print "     /b1 copy directory structure w\o rename"
   Print "     /b2 copy directory structure w\ rename"
   Print "     /b3 only copy directories with files found"
   Print "     /i  delete files after copy"
   Print "     /k  delete directory after copy"
   Print "     /n  don't prompt to delete file after copy"
   Print "     /q  don't prompt to delete directory after copy"
   Print "     /0  don't copy zero-length files"
   Return

   Display.Page.Two:
   GoSub Display.Header
   Print "Where:"
   Print "   (standard copying switches):"
   Print "     /j  force environment variable to lowercase"
   Print "     /m  don't overwrite dest. file"
   Print "     /p  display command line"
   Print "     /r  recurse directories"
   Print "     /v  append to dest. file"
   Print "     /v1 append/resume to dest. file"
   Print "     /v2### copy from byte position"
   Print "     /w  don't prompt before overwrite"
   Print "   (display switches):"
   Print "     /c  continuous display         /x1 don't display dest. filename"
   Print "     /c1  continuous output display /x2 don't prepend display type"
   Print "     /c2  skip file overwrite       /x3 don't display override display"
   Print "     /h  don't display drive letter /x4 don't display any filenames"
   Print "     /o1 display wide list          /y  display files in lowercase"
   Print "     /o2 ambiguate filename         /z  suppress error messages"
   Print "     /s  don't display pathname"
   Print "   (filelist switches):"
   Print "     /@  enable filelists           /#  disable filelist prompts"
   Print "     /@2 ignore pattern matching for filelist filenames"
   Return

   Display.Page.Three:
   GoSub Display.Header
   Print "Where:"
   Print "   (copy filter switches):"
   Print "     /1  copy file to eof"
   Print "     /2xxx-xxx  convert ascii filter (fast)"
   Print "     /3xxx  strip ascii values (slow)"
   Print "     /4xxx nested directories"
   Print "   (file override switches):"
   Print "     /5mm/dd/yyyy  override destination file date"
   Print "     /6hh:mm:ss    override destination file time"
   Print "     /7  creation date/time"
   Print "     /8  last access date/time"
   Print "     /9  last modified (write) date/time"
   Print "   (file override ranges):"
   Print "     /e  search date in form mm/dd/yyyy-mm/dd/yyyy"
   Print "     /t  search time in form hh:mm:ss-hh:mm:ss"
   Print "     /u  search file size in form xxx-xxx in kilobytes"
   Print "   (compare switches used with /e, /t):"
   Print "     /s1  compare source creation date/time"
   Print "     /s2  compare source last access date/time"
   Print "     /s3  compare source last modified date/time"
   Return

   Display.Page.Four:
   GoSub Display.Header
   Print "Where:"
   Print "   (date range switches):"
   Print "     /e1:mm/dd/yyyy-mm/dd/yyyy  pattern match date range"
   Print "     /e2:" + Quote + "filename.ext" + Quote + "  pattern match filename, include:"
   Print "       MM, DD, YY, or YYYY, ?, to match with /e1:"
   Print "   (file attributes switches):"
   Print "     [prefix1][prefix2][ahosx]"
   Print "       prefix1: / copy files, // reset dest. file, /// reset source file;"
   Print "       prefix2: x  with\clear, z  without\set;"
   Print "       attribute: a  archive, h  hidden, o  read-only, s  system, x  none"
   Print "   (additional display switches):"
   Print "     /l1  display file creation\last access\last modified date/time."
   Print "     /l2  display /l1 plus filesize."
   Print "     /l3  display /l2 plus file attributes."
   Print "     /l4  display /l3 plus bytes counted\copied, directories deleted."
   Print "     /l   same as /l4"
   Print "   (extended display switches):"
   Print "     /*  display progress bar  /!  display percent copied"
   Print "     /-  disable copying dots  /+  display transfer rate"
   Return

   Display.Page.Five:
   GoSub Display.Header
   Print "Where:"
   Print "   (debug switches):"
   Print "     /=<x>  set /= and more prompt to <x> seconds"
   Print "     /=  enable extended error messages  /:  ignore skipped files"
   Print "     /.  disable reading configure file"
   Print "   (exclude file list switch):"
   Print "     /(<filename.ext>)"
   Print "       Excludes files containing ? and * characters when"
   Print "       enclosed in parenthesis. Multiple exclusions allowed."
   Print "   (DOS command switch): (use /_ for /K in command call);"
   Print "     /[<command>]  with command replacement parameters:"
   Print "       %1 = d:, %2 = d:\, %3 = d:\pathname, %4 = d:\pathname\"
   Print "       %5 = d:\pathname\filename.ext, %6 = \pathname, %7 = \pathname\"
   Print "       %8 = \pathname\filename.ext, %9 = filename.ext, %a = filename"
   Print "       %b = .ext, %c = ext, //1 = >, //2 = <, //3 = |, //4 = %, //5 = ]"
   Print "   (exit errorlevel codes):"
   Print "     0 = files copied successfully   2 = no files were copied"
   Print "     4 = disk full/disk not ready    8 = copy interrupted by user"
   Return

   Display.Page.Six:
   Cls
   Color White, Black
   Print "Alphabetic list of Copyit command line switches (page 'a'):"
   Color Yellow, Black
   Print "/a - synchronize dest. files           /p - display command line"
   Print "/b - copy directory structure          /q - don't prompt to delete directory"
   Print "/c - continuous list                   /r - recursive directory search"
   Print "/c1 - continuous output display        /s - don't display pathname"
   Print "/c2 - skip file overwrite              /t - time range hh:mm:ss-hh:mm:ss"
   Print "/d - destination directory [d:][\path] /u - file size range in KB"
   Print "/e - date range mm/dd/yyyy-mm/dd/yyyy  /v - append to dest. file"
   Print "/f - destination file [filename.ext]   /v1 - append/resume to dest. file"
   Print "/g - specifies dest. \\server\share\   /v2 - copy from byte position"
   Print "/h - don't display drive letter        /w - don't prompt before overwrite"
   Print "/i - delete files after copy           /x1 - don't display dest. filename"
   Print "/j - force environment to lowercase    /x2 - don't prepend display type"
   Print "/k - delete directory after copy       /x3 - don't display override display"
   Print "/lx - added info switches x=1-4        /x4 - don't display any filenames"
   Print "/m - don't overwrite dest. file        /y - display files in lowercase"
   Print "/n - don't prompt to delete file       /z - don't display errors"
   Print "/o1 - display wide list"
   Print "/o2 - ambiguate filename"
   Return

   Display.Page.Seven:
   Cls
   Color White, Black
   Print "Bit copying list of Copyit command line switches (page 'b'):"
   Color Yellow, Black
   Print "Source copy bits:"
   Print "/xa - with archive bit                  /xh - with hidden bit"
   Print "/xo - with read-only bit                /xs - with system bit"
   Print "/xx - with no bits (without all bits)"
   Print "/za - without archive bit               /zh - without hidden bit"
   Print "/zo - without read-only bit             /zs - without system bit"
   Print "/zx - without no bits (with only all bits)"
   Print "Destination reset bits:"
   Print "//xa - set dest. archive bit            //xh - set dest. hidden bit"
   Print "//xo - set dest. read-only bit          //xs - set dest. system bit"
   Print "//xx - set all dest. bits"
   Print "//za - clear dest. archive bit          //zh - clear dest. hidden bit"
   Print "//zo - clear dest. read-only bit        //zs - clear dest. system bit"
   Print "//zx - clear all dest. bits"
   Print "Source reset bits:"
   Print "///xa - set source archive bit          ///xh - set source hidden bit"
   Print "///xo - set source read-only bit        ///xs - set source system bit"
   Print "///xx - set all source bits"
   Print "///za - clear source archive bit        ///zh - clear source hidden bit"
   Print "///zo - clear source read-only bit      ///zs - clear source system bit"
   Print "///zx - clear all source bits"
   Return

   Display.Page.Eight:
   Cls
   Color White, Black
   Print "Numeric list of Copyit command line switches (page 'n'):"
   Color Yellow, Black
   Print "/0 - don't copy zero-length files"
   Print "/1 - copy ascii file to eof"
   Print "/2 - convert ascii filter xxx-xxx (fast)"
   Print "/3 - strip ascii filter (slow)"
   Print "/4 - override nested directories"
   Print "/5 - specify dest. file date mm/dd/yyyy override"
   Print "/6 - specify dest. file time hh:mm:ss override"
   Print "/7 - file creation date/time override"
   Print "/8 - file last access date/time override"
   Print "/9 - file last modified date/time override"
   Print "/-1 - ignore file sort during command line parsing"
   Print "/-2 - sort command line files ascending"
   Print "/-3 - sort command line files descending"
   Print "/-4 - display extended time for /L"
   Print "/-5 - skips all duplicate files from being copied"
   Return

   Display.Page.Nine:
   Cls
   Color White, Black
   Print "List of extended /a synchronize numeric switches (page 's'):"
   Color Yellow, Black
   Print "/a1  copy source files with sizes less than destination file sizes."
   Print "/a2  copy source files with sizes greater than destination file sizes."
   Print "/a3  copy source files with sizes equal to destination file sizes."
   Print "/a4  copy source files with sizes not equal to destination file sizes."
   Print "/a5  copy source files with dates earlier than destination file dates."
   Print "/a6  copy source files with dates greater than destination file dates."
   Print "/a7  copy source files with dates equal to destination file dates."
   Print "/a8  copy source files with dates not equal to destination file dates."
   Print "/a9  copy source files with times earlier than destination file times."
   Print "/aa  copy source files with times greater than destination file times."
   Print "/ab  copy source files with times equal to destination file times."
   Print "/ac  copy source files with times not equal to destination file times."
   Color White, Black
   Print "Synchronize switches for date/time comparing: (used with /a)"
   Color Yellow, Black
   Print "/z1  compare source creation date/time"
   Print "/z2  compare source last access date/time"
   Print "/z3  compare source last modified date/time"
   Color White, Black
   Print "Special copy switches:"
   Color Yellow, Black
   Print "/xc copy only compressed files, /xe copy only encrypted files."
   Print "/zc don't copy compressed files,  /ze  don't copy encrypted files."
   Return

   Display.Page.Ten:
   Cls
   Color White, Black
   Print "List of Copyit examples (page 'x'):"
   Color Yellow, Black
   Print "Copy all .doc files to the \temp directory:"
   Print "  Copyit *.doc /d\temp"
   Print "Copy all .lst and .txt files to the c: drive \temp directory:"
   Print "  Copyit *.lst *.txt /dc:\temp\"
   Print "Copy the file temp.lst to the file temp2.lst in the temp directory:"
   Print "  Copyit temp.lst /d\temp /ftemp2.lst"
   Print "Copy files with the hidden attribute set:"
   Print "  Copyit *.* /d\temp\ /xh"
   Print "Copy hidden files, and remove the hidden attribute:"
   Print "  Copyit *.* /d\temp\ /xh //xh"
   Print "Copy all .doc files into one file:"
   Print "  Copyit *.doc /ffiles.txt /v"
   Print "Copy all directories and files to another directory:"
   Print "  Copyit \dos /d\temp /r/b2"
   Print "Copy, then delete source files:"
   Print "  Copyit \dos /d\temp /r/b2/i/k"
   Print "Copy a file and take out linefeeds:"
   Print "  Copyit filename.ext /ffile2.txt /310"
   Print "Copy a file and change linefeeds to carriage returns:"
   Print "  Copyit filename.ext /ffile3.txt /210-13"
   Prompt$ = "Press <enter> to continue:"
   Call MorePrompt(Prompt$, Chr$(13), Outpt$, Chr$(13))
   Cls
   Color White, Black
   Print "List of Copyit examples (page 'x'):"
   Color Yellow, Black
   Print "Copy long filenames specified in quotes:"
   Print "  Copyit " + Quote + "c:\program files" + Quote + " /d" + Quote + "d:\program files" + Quote + " /r/b2"
   Print "Copy all files in root to both directories:"
   Print "  Copyit \*.* /dc:\tmp1 /dc:\tmp2"
   Print "Copy all doc and tmp files to both files:"
   Print "  Copyit *.doc *.tmp /ffile1.out /ffile2.out"
   Print "Copy all files to both filenames in the directory:"
   Print "  Copyit *.* /dd:\tmp1 /ffilea.out /ffileb.out"
   Print "Excludes file starting with 'temp' followed by the extension .dat"
   Print "  Copyit *.dat /dd:\work /(temp*.dat)"
   Print "Excludes files starting with 'temp'."
   Print "  Copyit *.* /dd:\work /(temp*.*)"
   Print "Copy files with different file sizes:"
   Print "  Copyit *.* /d\tmp1 /r/b1/a4"
   Print "Copy files and changes its creation time:"
   Print "  Copyit file? /foutput.txt /612:00:00/7"
   Print "Copy files with sizes from 128k to 256k:"
   Print "  Copyit file? /foutput.txt /u128-256"
   Print "Copy files and display transfer rate and percent being copied:"
   Print "  Copyit \*.bak /d\backup.1 /+/!"
   Return

   Display.Page.Eleven:
   GoSub Display.Header
   Print "Where:"
   Color White, Black
   Print "List of reserved characters:"
   Color Yellow, Black
   Print "In DOS the 8.3 filename cannot contain any of the following characters:"
   Color White, Black
   Print "\:/*?" + Quote + ">|<"
   Color Yellow, Black
   Print "In Windows command line the following characters are reserved and should be"
   Print "enclosed in quotes when used in filenames on the command line:"
   Color White, Black
   Print "<space>"
   Print "&()[]{}^=;!'+,`~"
   Color Yellow, Black
   Print "Otherwise, prepend the reserved character with ^ character when"
   Print "being used on the Copyit command line, for example:"
   Print "  Copyit file.dat /ffile.bak /^&"
   Return

   ' make header.
   Display.Header:
   Cls
   Color White, Black
   Print "Copyit " + Version$ + " " + Release$ + ": File copy utility help page";
   If Display.Page = 11 Then
      Print " '?';"
   Else
      Print Str$(Display.Page) + ";"
   End If
   Color Yellow, Black
   Print "Usage: Copyit <filelist>[/dfg][<switches>]"
   Return
End Sub

' routine prompts user for an option
Sub MorePrompt (Input.String$, Input.Mask$, Output.String$, Default$)
   Call ClearDisplay(0)
   Rate.Mode = False
   Start.Timer! = Timer
   Input.Char$ = Nul
   Color White, Black
   Print Input.String$ + " ";
   Do
      Locate , , 1
      Do
         _Limit 50
         Input.Char$ = InKey$
         If Len(Input.Char$) Then
            Exit Do
         End If
         If Control.Break Then
            Control.Break = False
            Input.Char$ = Default$
            Exit Do
         End If

         ' exits with default prompt in debug mode after timer.
         If Debug.Mode Then
            If DebugDelay! = 0! Then
               Input.Char$ = Default$
               Exit Do
            End If
            If DebugDelay! > 0! Then
               Elapsed.Time! = Timer - Start.Timer!
               If Elapsed.Time! < SFalse Then
                  Elapsed.Time! = Elapsed.Time! + 86400!
               End If
               If Elapsed.Time! >= DebugDelay! Then
                  Input.Char$ = Default$
                  Exit Do
               End If
            End If
         End If
      Loop

      ' check keyboard input.
      Input.Char$ = LCase$(Input.Char$)
      If InStr(Input.Mask$, Input.Char$) Then
         If Input.Char$ = Chr$(13) Then
            Print
         Else
            Print Input.Char$
         End If
         Output.String$ = Input.Char$
         Exit Do
      End If
   Loop
End Sub

' displays function error
Sub DisplayError (Temp$)
   ' check display errors flag.
   If Display.Errors = False Then
      ' clear display progress
      Call ClearDisplay(0)
      ' display error.
      Color Red, Black
      Print Temp$
   End If

   ' write error to file
   If Debug.ModeX Then
      V = FreeFile
      Open StartDir$ + "copyerr.log" For Append As #V
      Print #V, Date$ + " " + Time$ + " " + Temp$ ' + " - Line:" + STR$(_ERRORLINE)
      Close #V
   End If
End Sub

' subroutine to check for copying directory structure onto itself
Sub DirectoryCopying (Work.Net$)
   ' reset return flag.
   Directory.Exists = False

   ' read source drive.
   From.Drive = Asc(UCase$(Drive.Search)) - 64

   ' read source directory.
   Copy.From$ = RTrim$(Dir.Copy.Name)
   Copy.From2$ = Copy.From$
   Work.Net3$ = RTrim$(Source.Net)
   Work.Net4$ = RTrim$(Default.Net)
   If Left$(Copy.From$, 1) = "\" Then
      If Work.Net3$ <> Nul Then
         Copy.From$ = RTrim$(Work.Net3$) + Copy.From$
      Else
         If Work.Net4$ <> Nul Then
            Copy.From$ = RTrim$(Work.Net4$) + Drive.Search + Copy.From$
         End If
      End If
   Else
      If Work.Net3$ <> Nul Then
         Copy.From$ = RTrim$(Work.Net3$) + "\" + Copy.From$
      Else
         If Work.Net4$ <> Nul Then
            Copy.From$ = RTrim$(Work.Net4$) + Drive.Search + "\" + Copy.From$
         End If
      End If
   End If

   ' read target drive.
   Copy.To$ = Copy.Target
   If Mid$(Copy.To$, 2, 1) = ":" Then
      Drive.Number = Asc(UCase$(Left$(Copy.To$, 1))) - 64
      Copy.To$ = Mid$(Copy.To$, 3)
   Else
      Drive.Number = Asc(UCase$(Drive.Search)) - 64
   End If

   ' read target directory.
   If Left$(Copy.To$, 1) <> "\" Then
      Copy.To$ = Dest.Dir
      If Mid$(Copy.To$, 2, 1) = ":" Then
         Drive.Number = Asc(UCase$(Left$(Copy.To$, 1))) - 64
         Copy.To$ = Mid$(Copy.To$, 3)
      Else
         Drive.Number = Asc(UCase$(Drive.Search)) - 64
      End If
      If Work.Net$ = Nul Then
         Copy.To$ = Default.Dir + "\" + Copy.To$
      End If
   End If
   If Work.Net$ <> Nul Then
      If Left$(Copy.To$, 1) = "\" Then
         Copy.To$ = Work.Net$ + Copy.To$
      Else
         Copy.To$ = Work.Net$ + "\" + Copy.To$
      End If
   End If
   Copy.From$ = LCase$(Copy.From$)
   Copy.To$ = LCase$(Copy.To$)

   ' compare drives.
   If From.Drive = Drive.Number Then
      ' check directories.
      If Copy.From$ = Copy.To$ Then
         Directory.Exists = -1
      End If

      ' check recursing directories.
      If Recurse.Directories Then
         If Copy.From2$ <> "\" Then
            ' check recursive copying.
            If Copy.From$ = Left$(Copy.To$, Len(Copy.From$)) Then
               Directory.Exists = -2
            End If
         End If
      End If
   End If
End Sub

' subroutine constructs base filenames
Sub MakeFile (Work.Net$, From.File$, To.File$)
   ' make destination filename.
   If Mid$(To.File$, 2, 1) = ":" Then
      To.File$ = Mid$(To.File$, 3)
   End If
   If Left$(To.File$, 1) <> "\" Then
      If Work.Net$ = Nul Then
         If Default.Dir = "\" Then
            To.File$ = Default.Dir + To.File$
         Else
            To.File$ = Default.Dir + "\" + To.File$
         End If
      End If
      If Mid$(To.File$, 2, 1) = ":" Then
         To.File$ = Mid$(To.File$, 3)
      End If
   End If
   If Mid$(Dest.Dir, 2, 1) = ":" Then
      Drive.Number = Asc(UCase$(Left$(Dest.Dir, 1)))
   Else
      Drive.Number = Asc(UCase$(Drive.Search))
   End If
   If Work.Net$ = Nul Then
      If Left$(To.File$, 2) <> "\\" Then
         To.File$ = Chr$(Drive.Number) + ":" + To.File$
      End If
   Else
      If Left$(To.File$, 1) = "\" Then
         To.File$ = Work.Net$ + To.File$
      Else
         To.File$ = Work.Net$ + "\" + To.File$
      End If
   End If

   ' make source filename.
   Work.Net2$ = RTrim$(Source.Net)
   If Mid$(From.File$, 2, 1) = ":" Then
      From.File$ = Mid$(From.File$, 3)
   End If
   If Left$(From.File$, 1) <> "\" Then
      If Work.Net2$ = Nul Then
         If Default.Dir = "\" Then
            From.File$ = Default.Dir + From.File$
         Else
            From.File$ = Default.Dir + "\" + From.File$
         End If
      End If
      If Mid$(From.File$, 2, 1) = ":" Then
         From.File$ = Mid$(From.File$, 3)
      End If
   End If
   If Work.Net2$ = Nul Then
      If Left$(From.File$, 2) <> "\\" Then
         From.File$ = Drive.Search + ":" + From.File$
      End If
   Else
      If Left$(From.File$, 1) = "\" Then
         From.File$ = Work.Net2$ + From.File$
      Else
         From.File$ = Work.Net2$ + "\" + From.File$
      End If
   End If

   ' check filenames.
   If Display.Lowercase Then
      From.File$ = LCase$(From.File$)
      To.File$ = LCase$(To.File$)
   End If
End Sub

' subroutine constructs base netpath
Sub MakeFile2 (From.File$)
   Work.Net$ = RTrim$(Source.Net)
   Work.Net2$ = RTrim$(Default.Net)
   If Mid$(From.File$, 2, 1) = ":" Then
      From.File$ = Mid$(From.File$, 3)
   End If
   If Left$(From.File$, 1) <> "\" Then
      If Work.Net$ = Nul And Work.Net2$ = Nul Then
         If Default.Dir = "\" Then
            From.File$ = Default.Dir + From.File$
         Else
            From.File$ = Default.Dir + "\" + From.File$
         End If
      End If
      If Mid$(From.File$, 2, 1) = ":" Then
         From.File$ = Mid$(From.File$, 3)
      End If
   End If
   If Work.Net$ = Nul And Work.Net2$ = Nul Then
      From.File$ = Drive.Search + ":" + From.File$
   Else
      If Left$(From.File$, 1) = "\" Then
         If Work.Net$ <> Nul Then
            From.File$ = RTrim$(Work.Net$) + From.File$
         Else
            From.File$ = RTrim$(Work.Net2$) + Drive.Search + From.File$
         End If
      Else
         If Work.Net$ <> Nul Then
            From.File$ = RTrim$(Work.Net$) + "\" + From.File$
         Else
            From.File$ = RTrim$(Work.Net2$) + Drive.Search + "\" + From.File$
         End If
      End If
   End If
   From.File$ = LCase$(From.File$)
End Sub

' subroutine to create source filename from command line
Sub MakeFilename
   ' store entire command.
   If Left$(Command.Line, 1) = Quote Then
      Imbedded = InStr(2, Command.Line, Quote)
      If Imbedded Then
         Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = Nul
      End If
   Else
      Imbedded = InStr(Command.Line, " ")
      If Imbedded Then
         Command.Work = Left$(Command.Line, Imbedded - 1)
         Command.Line = Mid$(Command.Line, Imbedded + 1)
      Else
         Command.Work = Command.Line
         Command.Line = Nul
      End If
   End If
   Command.Line = LTrim$(Command.Line)
   Command.Line = RTrim$(Command.Line)
End Sub

' routine constructs file date string
Function MakeDate$ (Var)
   Select Case Var
      Case 1
         x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
      Case 2
         x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
      Case 3
         x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
   End Select
   YearTemp! = SysTime.wYear
   MonthTemp! = SysTime.wMonth
   DayTemp! = SysTime.wDay
   File.Date$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   File.Date$ = File.Date$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   File.Date$ = File.Date$ + LTrim$(Str$(SysTime.wYear))

   If Extended.Time Then
      HourTemp! = SysTime.wHour
      MinuteTemp! = SysTime.wMinute
      SecondsTemp! = SysTime.wSecond
      File.Time$ = Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
      File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
      File.Time$ = File.Time$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
      File.Date$ = File.Date$ + " " + File.Time$
   End If

   MakeDate$ = File.Date$
End Function

' routine checks file size range
Sub CheckSizeRange
   ' reset return flag.
   Size.Flag = False

   ' check for zero-byte files.
   If Copy.Zero Then
      If File.Size = DFalse Then
         Size.Flag = True
         Exit Sub
      End If
   End If

   ' check file size range.
   If Search.File.Size = False Then
      Exit Sub
   End If

   ' files of zero-byte are copied.
   If Search.Size.From = DFalse And Search.Size.To = DFalse Then
      If File.Size <> DFalse Then
         Size.Flag = True
      End If
      Exit Sub
   End If

   ' check /u10-
   If Search.Size.From > DFalse Then
      If Search.Size.To = DFalse Then
         If File.Size < Search.Size.From Then
            Size.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /u-10
   If Search.Size.From = DFalse Then
      If Search.Size.To > DFalse Then
         If File.Size > Search.Size.To Then
            Size.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /u10-20
   If Search.Size.From <= Search.Size.To Then
      If File.Size < Search.Size.From Or File.Size > Search.Size.To Then
         Size.Flag = True
         Exit Sub
      End If
   End If

   ' check /u20-10
   If Search.Size.From > Search.Size.To Then
      If File.Size < Search.Size.From And File.Size > Search.Size.To Then
         Size.Flag = True
         Exit Sub
      End If
   End If
End Sub

' routine checks date/time ranges
'   checks creation, last access, last modified date/time.
Sub CheckDateRange
   ' reset return flag.
   Range.Flag = False

   ' check date range.
   If Search.Date Then
      If Compare.Create.Date Then ' /s1
         If Search.From.Date > False Or Search.To.Date > False Then
            ' /e01/01/1980-
            If Search.From.Date > False Then
               If Search.To.Date = False Then
                  If Synch.Work.Create.Date < Search.From.Date Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /e-12/31/2010
            If Search.From.Date = False Then
               If Search.To.Date > False Then
                  If Synch.Work.Create.Date > Search.To.Date Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /e01/01/1980-12/31/2010
            If Search.From.Date <= Search.To.Date Then
               If Synch.Work.Create.Date < Search.From.Date Or Synch.Work.Create.Date > Search.To.Date Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
            ' /e12/31/2010-01/01/1980
            If Search.From.Date > Search.To.Date Then
               If Synch.Work.Create.Date < Search.From.Date And Synch.Work.Create.Date > Search.To.Date Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
      If Compare.Access.Date Then ' /s2
         If Search.From.Date > False Or Search.To.Date > False Then
            ' /e01/01/1980-
            If Search.From.Date > False Then
               If Search.To.Date = False Then
                  If Synch.Work.Access.Date < Search.From.Date Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /e-12/31/2010
            If Search.From.Date = False Then
               If Search.To.Date > False Then
                  If Synch.Work.Access.Date > Search.To.Date Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /e01/01/1980-12/31/2010
            If Search.From.Date <= Search.To.Date Then
               If Synch.Work.Access.Date < Search.From.Date Or Synch.Work.Access.Date > Search.To.Date Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
            ' /e12/31/2010-01/01/1980
            If Search.From.Date > Search.To.Date Then
               If Synch.Work.Access.Date < Search.From.Date And Synch.Work.Access.Date > Search.To.Date Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
      If Compare.Modify.Date Then ' /s3
         If Search.From.Date > False Or Search.To.Date > False Then
            ' /e01/01/1980-
            If Search.From.Date > False Then
               If Search.To.Date = False Then
                  If Synch.Work.Modify.Date < Search.From.Date Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /e-12/31/2010
            If Search.From.Date = False Then
               If Search.To.Date > False Then
                  If Synch.Work.Modify.Date > Search.To.Date Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /e01/01/1980-12/31/2010
            If Search.From.Date <= Search.To.Date Then
               If Synch.Work.Modify.Date < Search.From.Date Or Synch.Work.Modify.Date > Search.To.Date Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
            ' /e12/31/2010-01/01/1980
            If Search.From.Date > Search.To.Date Then
               If Synch.Work.Modify.Date < Search.From.Date And Synch.Work.Modify.Date > Search.To.Date Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
   End If

   ' check time range.
   If Search.Time Then
      If Compare.Create.Date Then ' /s1
         If Search.From.Time > False Or Search.To.Time > False Then
            ' /t00:00:01-
            If Search.From.Time > False Then
               If Search.To.Time = False Then
                  If Synch.Work.Create.Time < Search.From.Time Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /t-23:59:59
            If Search.From.Time = False Then
               If Search.To.Time > False Then
                  If Synch.Work.Create.Time > Search.To.Time Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /t00:00:01-23:59:59
            If Search.From.Time <= Search.To.Time Then
               If Synch.Work.Create.Time < Search.From.Time Or Synch.Work.Create.Time > Search.To.Time Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
            ' /t23:59:59-00:00:01
            If Search.From.Time > Search.To.Time Then
               If Synch.Work.Create.Time < Search.From.Time And Synch.Work.Create.Time > Search.To.Time Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
      If Compare.Access.Date Then ' /s2
         If Search.From.Time > False Or Search.To.Time > False Then
            ' /t00:00:01-
            If Search.From.Time > False Then
               If Search.To.Time = False Then
                  If Synch.Work.Access.Time < Search.From.Time Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /t-23:59:59
            If Search.From.Time = False Then
               If Search.To.Time > False Then
                  If Synch.Work.Access.Time > Search.To.Time Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /t00:00:01-23:59:59
            If Search.From.Time <= Search.To.Time Then
               If Synch.Work.Access.Time < Search.From.Time Or Synch.Work.Access.Time > Search.To.Time Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
            ' /t23:59:59-00:00:01
            If Search.From.Time > Search.To.Time Then
               If Synch.Work.Access.Time < Search.From.Time And Synch.Work.Access.Time > Search.To.Time Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
      If Compare.Modify.Date Then ' /s3
         If Search.From.Time > SFalse Or Search.To.Time > SFalse Then
            ' /t00:00:01-
            If Search.From.Time > SFalse Then
               If Search.To.Time = SFalse Then
                  If Synch.Work.Modify.Time < Search.From.Time Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /t-23:59:59
            If Search.From.Time = SFalse Then
               If Search.To.Time > SFalse Then
                  If Synch.Work.Modify.Time > Search.To.Time Then
                     Range.Flag = True
                     Exit Sub
                  End If
               End If
            End If
            ' /t00:00:01-23:59:59
            If Search.From.Time <= Search.To.Time Then
               If Synch.Work.Modify.Time < Search.From.Time Or Synch.Work.Modify.Time > Search.To.Time Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
            ' /t23:59:59-00:00:01
            If Search.From.Time > Search.To.Time Then
               If Synch.Work.Modify.Time < Search.From.Time And Synch.Work.Modify.Time > Search.To.Time Then
                  Range.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
   End If
End Sub

' routine verifies source - destination synchronized file size, date/time.
'   checks creation, last access, last modified date/time.
Sub CheckSynched
   ' reset return value.
   Synched.Flag = False

   ' check /a
   If Synch.Files Then
      If Synch.Type1 Then ' creation date/time.
         If File.Size = Dest.File.Size Then
            If Synch.Work.Create.Date = Synch.File.Create.Date Then
               If Synch.Work.Create.Time = Synch.File.Create.Time Then
                  Synched.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If File.Size = Dest.File.Size Then
            If Synch.Work.Access.Date = Synch.File.Access.Date Then
               If Synch.Work.Access.Time = Synch.File.Access.Time Then
                  Synched.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If File.Size = Dest.File.Size Then
            If Synch.Work.Modify.Date = Synch.File.Modify.Date Then
               If Synch.Work.Modify.Time = Synch.File.Modify.Time Then
                  Synched.Flag = True
                  Exit Sub
               End If
            End If
         End If
      End If
   End If

   ' check /a1
   If Synch.Files1 Then
      If File.Size >= Dest.File.Size Then
         Synched.Flag = True
         Exit Sub
      End If
   End If

   ' check /a2
   If Synch.Files2 Then
      If File.Size <= Dest.File.Size Then
         Synched.Flag = True
         Exit Sub
      End If
   End If

   ' check /a3
   If Synch.Files3 Then
      If File.Size <> Dest.File.Size Then
         Synched.Flag = True
         Exit Sub
      End If
   End If

   ' check /a4
   If Synch.Files4 Then
      If File.Size = Dest.File.Size Then
         Synched.Flag = True
         Exit Sub
      End If
   End If

   ' check /a5
   If Synch.Files5 Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Date >= Synch.File.Create.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Date >= Synch.File.Access.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Date >= Synch.File.Modify.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /a6
   If Synch.Files6 Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Date <= Synch.File.Create.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Date <= Synch.File.Access.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Date <= Synch.File.Modify.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /a7
   If Synch.Files7 Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Date <> Synch.File.Create.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Date <> Synch.File.Access.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Date <> Synch.File.Modify.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /a8
   If Synch.Files8 Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Date = Synch.File.Create.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Date = Synch.File.Access.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Date = Synch.File.Modify.Date Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /a9
   If Synch.Files9 Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Time >= Synch.File.Create.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Time >= Synch.File.Access.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Time >= Synch.File.Modify.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /aa
   If Synch.FilesA Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Time <= Synch.File.Create.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Time <= Synch.File.Access.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Time <= Synch.File.Modify.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /ab
   If Synch.FilesB Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Time <> Synch.File.Create.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Time <> Synch.File.Access.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Time <> Synch.File.Modify.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If

   ' check /ac
   If Synch.FilesC Then
      If Synch.Type1 Then ' creation date/time.
         If Synch.Work.Create.Time = Synch.File.Create.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type2 Then ' last access date/time.
         If Synch.Work.Access.Time = Synch.File.Access.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
      If Synch.Type3 Then ' last modified date/time.
         If Synch.Work.Modify.Time = Synch.File.Modify.Time Then
            Synched.Flag = True
            Exit Sub
         End If
      End If
   End If
End Sub

' routine checks filename
Sub CheckFile (Var$, Check)
   ' store test flag
   Check.Flag = True

   ' store input filename
   Var2$ = UCase$(Var$)
   Var2$ = RTrim$(Var2$)

   ' check skip files
   If Ignore.Skip = 0 Then
      For Skip.File = 1 To 10
         Var1$ = Skip.Filenames(Skip.File)
         Var1$ = UCase$(Var1$)
         Var1$ = RTrim$(Var1$)
         If Len(Var1$) Then
            If Var1$ = Var2$ Then
               Check.Flag = False
               Exit Sub
            End If
         End If
      Next
   End If

   ' check excluded files
   For File.Number = 1 To Number.Excluded
      Var1$ = Excluded.Files(File.Number)
      Var1$ = UCase$(Var1$)
      Var1$ = RTrim$(Var1$)
      If Len(Var1$) Then
         Call CheckExcluded(Var1$, Var2$)
         If Exclude.Flag Then
            Check.Flag = False
            Exit Sub
         End If
      End If
   Next

   ' check pattern files
   If Check Then
      If Pattern.Match Then
         Exit Sub
      End If
   End If
   Call CheckPattern(Var2$)
   If Pattern.Flag = False Then
      Check.Flag = False
   End If
End Sub

' routine compares occurrence of filename1$ in filename2$
'  with pattern matching.
Sub CheckExcluded (Filename1$, Filename2$)
   Exclude.Flag = True ' assume mask matches filename2.
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement.
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Exclude.Flag = False
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement.
         ' searches for next matching character.
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement.
         ' matches any next character.
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character.
            ' checks next character unmatched.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Exlcude.Flag = False
                  Exit Do
               End If
            Else
               ' matches next character.
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Exclude.Flag = False
                  Exit Do
               End If
               ' check string lengths.
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Exlcude.Flag = False
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
End Sub

' routine checks filename date pattern
Sub CheckPattern (Filename2$)
   ' reset to match.
   Pattern.Flag = True
   ' exit for no matching.
   If Pattern.Search = False Then
      Exit Sub
   End If
   ' compare exact filename lengths.
   If Len(Filename2$) <> Len(Pattern.Filename) Then
      Pattern.Flag = False
      Exit Sub
   End If
   ' scan pattern.
   For Var = 1 To Len(Pattern.Filename)
      Var$ = Mid$(Pattern.Filename, Var, 1)
      Select Case Var$
         Case "?" ' nul
            Var0$ = Nul
         Case "M", "D", "Y" ' skip
            Var0$ = Nul
         Case Else
            ' match exact filename character.
            If Mid$(Filename2$, Var, 1) <> Var$ Then
               Pattern.Flag = False
               Exit Sub
            End If
      End Select
   Next
   ' scan year pattern type 1.
   Year1 = False
   For Var = 1 To Len(Pattern.Filename)
      If Mid$(Pattern.Filename, Var, 4) = "YYYY" Then
         Year1 = Val(Mid$(Filename2$, Var, 4))
         Exit For
      End If
   Next
   ' scan year pattern type 2.
   If Year1 = False Then
      For Var = 1 To Len(Pattern.Filename)
         If Mid$(Pattern.Filename, Var, 2) = "YY" Then
            Year1 = Val(Mid$(Filename2$, Var, 2))
            Exit For
         End If
      Next
   End If
   ' scan month pattern.
   Month1 = False
   For Var = 1 To Len(Pattern.Filename)
      If Mid$(Pattern.Filename, Var, 2) = "MM" Then
         Month1 = Val(Mid$(Filename2$, Var, 2))
         Exit For
      End If
   Next
   ' scan day pattern.
   Day1 = False
   For Var = 1 To Len(Pattern.Filename)
      If Mid$(Pattern.Filename, Var, 2) = "DD" Then
         Day1 = Val(Mid$(Filename2$, Var, 2))
         Exit For
      End If
   Next

   ' store date patterns.
   Day.From = Val(Mid$(Pattern.Search.From.Date, 4, 2))
   Month.From = Val(Left$(Pattern.Search.From.Date, 2))
   Year.From = Val(Right$(Pattern.Search.From.Date, 4))
   Day.To = Val(Mid$(Pattern.Search.To.Date, 4, 2))
   Month.To = Val(Left$(Pattern.Search.To.Date, 2))
   Year.To = Val(Right$(Pattern.Search.To.Date, 4))

   ' match date patterns. checks all possible patterned combinations.
   If Day1 > False And Month1 > False And Year1 > False Then ' DD-MM-YYYY
      ' for a complete date, serial function can be used.
      From.Serial# = DateSerial(Year.From, Month.From, Day.From)
      To.Serial# = DateSerial(Year.To, Month.To, Day.To)
      Now.Serial# = DateSerial(Year1, Month1, Day1)
      If From.Serial# <= To.Serial# Then
         If Now.Serial# >= From.Serial# And Now.Serial# <= To.Serial# Then
            Pattern.Flag = True
         Else
            Pattern.Flag = False
         End If
      Else
         Pattern.Flag = False
      End If
   Else
      ' for all remaining combinations, specific ranges must be checked.
      If Day1 > False And Month1 > False And Year1 = False Then ' DD-MM
         If Month.From = Month.To Then
            If Month1 = Month.From Then
               If Day.From <= Day.To Then
                  If Day1 >= Day.From And Day1 <= Day.To Then
                     Pattern.Flag = True
                  Else
                     Pattern.Flag = False
                  End If
               Else
                  Pattern.Flag = False
               End If
            Else
               Pattern.Flag = False
            End If
         Else
            If Month.From < Month.To Then
               If Month1 >= Month.From And Month1 <= Month.To Then
                  If Day.From > Day.To Then
                     If Day1 >= Day.From Or Day1 <= Day.To Then
                        Pattern.Flag = True
                     Else
                        Pattern.Flag = False
                     End If
                  Else
                     If Day1 >= Day.From And Day1 <= Day.To Then
                        Pattern.Flag = True
                     Else
                        Pattern.Flag = False
                     End If
                  End If
               Else
                  Pattern.Flag = False
               End If
            Else
               Pattern.Flag = False
            End If
         End If
      Else
         If Day1 > False And Month1 = False And Year1 > False Then ' DD-YYYY
            If Year.From = Year.To Then
               If Year1 = Year.From Then
                  If Day.From <= Day.To Then
                     If Day1 >= Day.From And Day1 <= Day.To Then
                        Pattern.Flag = True
                     Else
                        Pattern.Flag = False
                     End If
                  Else
                     Pattern.Flag = False
                  End If
               Else
                  Pattern.Flag = False
               End If
            Else
               If Year.From < Year.To Then
                  If Year1 >= Year.From And Year1 <= Year.To Then
                     If Day.From > Day.To Then
                        If Day1 >= Day.From Or Day1 <= Day.To Then
                           Pattern.Flag = True
                        Else
                           Pattern.Flag = False
                        End If
                     Else
                        If Day1 >= Day.From And Day1 <= Day.To Then
                           Pattern.Flag = True
                        Else
                           Pattern.Flag = False
                        End If
                     End If
                  Else
                     Pattern.Flag = False
                  End If
               Else
                  Pattern.Flag = False
               End If
            End If
         Else
            If Day1 > False And Month1 = False And Year1 = False Then ' DD
               If Day1 >= Day.From And Day1 <= Day.To Then
                  Pattern.Flag = True
               Else
                  Pattern.Flag = False
               End If
            Else
               If Day1 = False And Month1 > False And Year1 > False Then ' MM-YYYY
                  If Year.From = Year.To Then
                     If Year1 = Year.From Then
                        If Month.From <= Month.To Then
                           If Month1 >= Month.From And Month1 <= Month.To Then
                              Pattern.Flag = True
                           Else
                              Pattern.Flag = False
                           End If
                        Else
                           Pattern.Flag = False
                        End If
                     Else
                        Pattern.Flag = False
                     End If
                  Else
                     If Year.From < Year.To Then
                        If Year1 >= Year.From And Year1 <= Year.To Then
                           If Month.From > Month.To Then
                              If Month1 >= Month.From Or Month1 <= Month.To Then
                                 Pattern.Flag = True
                              Else
                                 Pattern.Flag = False
                              End If
                           Else
                              If Month1 >= Month.From And Month1 <= Month.To Then
                                 Pattern.Flag = True
                              Else
                                 Pattern.Flag = False
                              End If
                           End If
                        Else
                           Pattern.Flag = False
                        End If
                     Else
                        Pattern.Flag = False
                     End If
                  End If
               Else
                  If Day1 = False And Month1 > False And Year1 = False Then ' MM
                     If Month1 >= Month.From And Month1 <= Month.To Then
                        Pattern.Flag = True
                     Else
                        Pattern.Flag = False
                     End If
                  Else
                     If Day1 = False And Month1 = False And Year1 > False Then ' YYYY
                        If Year1 >= Year.From And Year1 <= Year.To Then
                           Pattern.Flag = True
                        Else
                           Pattern.Flag = False
                        End If
                     Else
                        If Day1 = False And Month1 = False And Year1 = False Then ' nul
                           ' no date in pattern, so filename matches.
                           Exit Sub
                        End If
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
End Sub

' format and display time elapsed copying file
Sub Time.Display1
   Var1! = Time.Elapsed
   Hours = Int(Var1! / 3600!)
   Var1! = Var1! - Hours * 3600!
   Minutes = Int(Var1! / 60!)
   Var1! = Var1! - Minutes * 60!
   Seconds = Int(Var1!)
   Print "Transfer time: ";
   If Hours > 23 Then
      Days = Int(Hours / 24)
      Print Right$("00" + Mid$(Str$(Days), 2), 2); ":";
   End If
   Print Right$("00" + Mid$(Str$(Hours), 2), 2); ":";
   Print Right$("00" + Mid$(Str$(Minutes), 2), 2); ":";
   Print Right$("00" + Mid$(Str$(Seconds), 2), 2);
   Var1$ = Str$(Var1!)
   Var = InStr(Var1$, ".")
   If Var Then
      Print Mid$(Var1$, Var, 3)
   Else
      Print ".00"
   End If
End Sub

' format and display time rate copying file
Sub Time.Display2
   Rem 1 B (Byte) = 00x - 0FFx (hexidecimal zero-based)
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB (1 MB B)
   Rem GB (Gigabyte) = 1024 MB
   Rem TB (Terabyte) = 1024 GB (1 MB MB)
   Rem PB (Petabyte) = 1024 TB
   Rem EB (Exabyte) = 1024 PB (1 MB TB)

   ' division by zero
   If Time.Elapsed = 0! Then
      Var# = 0#
      S$ = "B"
      GoTo EndCalc
   End If

   ' rate of bytes copied/sec.
   Total.Bytes2 = Total.Bytes2 / Time.Elapsed

   ' zero bytes copied
   If Total.Bytes2 = 0# Then
      Var# = 0#
      S$ = "B"
      GoTo EndCalc
   End If

   ' calculate suffix
   TempA = False
   Var# = Total.Bytes2
   Do
      If Var# < 1024# Then
         Exit Do
      End If
      Var# = Var# / 1024#
      TempA = TempA + 1
      If TempA = 6 Then
         Exit Do
      End If
   Loop

   ' determine suffix
   S$ = ""
   If TempA > 0 Then
      S$ = Mid$("KMGTPE", TempA, 1)
   End If
   S$ = S$ + "B"
   EndCalc:
   ' display rate
   Print "Transfer rate: " + FormatString$(Var#) + " " + S$ + "/second."
End Sub

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function


